<!DOCTYPE html>
<html lang="en">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" /><!-- /Added by HTTrack -->

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <link rel="shortcut icon" type="image/x-icon" href="hwassets/img/favicon.png">
    <title>HW Add Asset</title>
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/css/bootstrap.min.css">

    <!-- Fontawesome CSS -->
    <link rel="stylesheet" href="hwassets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="hwassets/plugins/fontawesome/css/all.min.css">

    <!-- Feathericon CSS -->
    <link rel="stylesheet" href="hwassets/plugins/feather/feather.css">

    <!-- Select2 CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/css/select2.min.css">

    <!-- Datatables CSS -->
    <link rel="stylesheet" href="hwassets/plugins/datatables/datatables.min.css">

    <!-- Calendar CSS -->
    <link rel="stylesheet" href="hwassets/plugins/simple-calendar/simple-calendar.css">

    <!-- Datepicker CSS -->
    <link rel="stylesheet" href="hwassets/css/bootstrap-datetimepicker.min.css">

    <!-- Slick CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/plugins/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="hwassets/plugins/slick/slick-theme.css">

    <link rel="stylesheet" type="text/css" href="hwassets/plugins/light-gallery/css/lightgallery.min.css">

    <!-- Summernote CSS -->
    <link rel="stylesheet" href="hwassets/plugins/summernote/summernote-bs5.min.css">

    <link rel="stylesheet" type="text/css" href="hwassets/css/fullcalendar.min.css">

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/css/style.css">

</head>


<body>

    <div class="main-wrapper">

        @extends('Hardware_Asset.Navbar.hwnavbar')
        @section('content')
        <div class="page-wrapper">
            <div class="content">
                <!-- Page Header -->
                <!-- Page Header -->
                <div class="page-header">
                    <div class="row">
                        <div class="col-sm-12">
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="javascript:;">Assets </a>
                                </li>
                                <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                                <li class="breadcrumb-item active">Edit Assets</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- /Page Header -->
                <!-- /Page Header -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <form method="post" action="{{ route('Asset_ESave') }}" enctype="multipart/form-data" class="has-validated">
                                    @csrf
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-heading">
                                                <h4>Add Assets</h4>
                                            </div>
                                        </div>
                                        <input type="hidden" name="Rowid" value="{{ $params['id'] ?? '' }}">
                                        <!-- ENO -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>ENO</label>
                                                <input type="text" name="eno" value="{{ $params['eno'] ?? '' }}" class="form-control" readonly>
                                            </div>
                                        </div>
                                        <!-- TYPE -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Asset Type<span class="login-danger">*</span></label>
                                                <input type="text" name="ass_type" value="{{ $params['as_type'] ?? '' }}" class="form-control" readonly>
                                            </div>
                                        </div>
                                        <!-- ID -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Asset ID</label>
                                                <input type="text" name="ass_id" value="{{ $params['Asset_ID'] ?? '' }}" id="ass_id" class="form-control" readonly>
                                            </div>
                                        </div>
                                        <!-- MODE -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <input type="hidden" value="{{ $params['as_mode'] }}">
                                                <label>Mode<span class="login-danger"></span></label>
                                                <select name="ass_mode" class="form-control select">
                                                    <option disabled>Select Type</option>
                                                    <option {{ $params['as_mode'] == 'Project' ? 'selected' : '' }}>Project</option>
                                                    <option {{ $params['as_mode'] == 'Store' ? 'selected' : '' }}>Store</option>
                                                    <option {{ $params['as_mode'] == 'Opening' ? 'selected' : '' }}>Opening</option>
                                                </select>
                                            </div>
                                        </div>
                                        <!-- GRN NO -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>GRN No<span class="login-danger"></span></label>
                                                <select name="grn_no" id="grnno" class="form-control select2" required>
                                                    <option value="" disabled>Select GRN No</option>
                                                    @foreach($Grn_Inv as $Grn)
                                                    <option value="{{ $Grn['GRNNO'] }}" data-grndate="{{ date('Y-m-d', strtotime($Grn['GRNDATE'])) }}" data-invno="{{ $Grn['INVNO'] }}" data-invdate="{{ date('Y-m-d', strtotime($Grn['INVDATE'])) }}" data-supp_name="{{ $Grn['Supplier_Name'] }}" data-item_name="{{ $Grn['ITEMNAME'] }}" {{ $Grn['GRNNO'] == $params['Grn_No'] ? 'selected' : '' }}>
                                                        {{ $Grn['GRNNO'] }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <!-- GRN DATE -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>GRN Date <span class="login-danger"></span></label>
                                                <input type="text" name="grn_date" id="grn_date" class="form-control" readonly value="{{ date('Y-m-d',strtotime($params['Grn_Date'])) }}" placeholder="">
                                            </div>
                                        </div>
                                        <!-- INV NO -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>INV No<span class="login-danger"></span></label>
                                                <input type="text" name="inv_no" id="inv_no" value="{{ $params['Inv_No'] }}" readonly class="form-control">
                                            </div>
                                        </div>
                                        <!-- INV DATE -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>INV Date<span class="login-danger"></span></label>
                                                <input type="text" name="inv_date" id="inv_date" class="form-control" readonly value="{{ date('Y-m-d',strtotime($params['Inv_Date'])) }}" placeholder="">
                                            </div>
                                        </div>
                                        <!-- ITEM NAME -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Item Name<span class="login-danger">*</span></label>
                                                <input type="text" name="item_name" value="{{ $params['item'] }}" class="form-control" oninput="this.value = this.value.toUpperCase()" required>
                                            </div>
                                        </div>
                                        <!-- MODEL -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Model<span class="login-danger"></span></label>
                                                <input type="text" name="model" value="{{ $params['model'] }}" class="form-control">
                                            </div>
                                        </div>
                                        <!-- MANUF -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Manufacturer<span class="login-danger"></span></label>
                                                <input type="text" name="manu" value="{{ $params['manuf'] }}" class="form-control">
                                            </div>
                                        </div>
                                        <!-- PUR DATE -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Purchase Date <span class="login-danger"></span></label>
                                                <input type="text" name="pur_date" class="form-control" id="purDate" value="{{ date('Y-m-d',strtotime($params['Pur_Date'])) }}" required readonly onchange="update()">
                                            </div>
                                        </div>
                                        <!-- HD -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Hard Disk<span class="login-danger"></span></label>
                                                <input type="text" name="hd" value="{{ $params['hd'] }}" class="form-control">
                                            </div>
                                        </div>
                                        <!-- RAM -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>RAM<span class="login-danger"></span></label>
                                                <input type="text" name="ram" value="{{ $params['ram'] }}" class="form-control">
                                            </div>
                                        </div>
                                        <!-- OS -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>OS<span class="login-danger"></span></label>
                                                <input type="text" name="os" value="{{ $params['os'] }}" class="form-control">
                                            </div>
                                        </div>
                                        <!-- PROC -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Processor<span class="login-danger"></span></label>
                                                <input type="text" name="proc" value="{{ $params['proc'] }}" class="form-control">
                                            </div>
                                        </div>
                                        <!-- IP -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>IP Address<span class="login-danger"></span></label>
                                                <input type="text" name="ip" value="{{ $params['ip'] }}" class="form-control">
                                            </div>
                                        </div>
                                        <!-- MAC -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Serial No<span class="login-danger"></span></label>
                                                <input type="text" name="mac" value="{{ $params['mac'] }}" class="form-control">
                                            </div>
                                        </div>
                                        <!-- SYS TYPE -->
                                        <div class="col-12 col-md-6 col-xl-4 d-none ">
                                            <div class="form-group local-forms">
                                                <label>System Type<span class="login-danger"></span></label>
                                                <input type="text" name="sys_type" value="{{ $params['sys_type'] }}" class="form-control">
                                            </div>
                                        </div>
                                        <!-- VALUE -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Value<span class="login-danger"></span></label>
                                                <input type="text" name="value" value="{{ $params['value'] }}" class="form-control">
                                            </div>
                                        </div>

                                        <input value="{{ $params['Warranty'] }}" class="form-control" type="hidden">

                                        <?php
                                        // Assuming $warrantyValue contains the value "1 Year" from request('Warranty')
                                        $warrantyValue = $params['Warranty'];
                                        // Extract the numerical value and unit from the warranty string
                                        $warrantyParts = explode(' ', $warrantyValue);

                                        // Initialize variables to hold the extracted values
                                        $warrantyCount = '';
                                        $warrantyMode = '';

                                        // Check if the array has at least one element
                                        if (isset($warrantyParts[0])) {
                                            $warrantyCount = $warrantyParts[0];
                                        }

                                        // Check if the array has at least two elements
                                        if (isset($warrantyParts[1])) {
                                            $warrantyMode = $warrantyParts[1];
                                        }
                                        ?>

                                        <!-- WARRANTY - COUNT -->
                                        <div class="col-12 col-md-6 col-xl-2">
                                            <div class="form-group local-forms">
                                                <label>Count<span class="login-danger">*</span></label>
                                                <input class="form-control" type="number" id="warrantyCount" min="1" value="<?php echo $warrantyCount ?>" oninput="update()" required>
                                            </div>
                                        </div>

                                        <!-- WARRANTY - M/Y -->
                                        <div class="col-12 col-md-6 col-xl-2">
                                            <div class="form-group local-forms">
                                                <label>M / Y<span class="login-danger">*</span></label>
                                                <select class="form-control select" id="warrantyMode" onchange="update()" required>
                                                    <option value="<?php echo $warrantyMode; ?>" selected disabled><?php echo $warrantyMode; ?></option>
                                                    <option value="Month">Month</option>
                                                    <option value="Year">Year</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-6 col-xl-6 d-none">
                                            <div class="form-group local-forms">
                                                <label>Combined Result<span class="login-danger"></span></label>
                                                <input name="warranty" class="form-control" type="text" id="combinedInput">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6 col-xl-6 d-none">
                                            <div class="form-group local-forms">
                                                <label>End Warranty<span class="login-danger"></span></label>
                                                <input class="form-control" type="text" name="endWarranty" id="endWarranty">
                                            </div>
                                        </div>

                                        <!-- SUPPLIER -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Supplier<span class="login-danger"></span></label>
                                                <input type="text" name="supplier" id="supplier" value="{{ $params['Supplier'] }}" class="form-control">
                                            </div>
                                        </div>
                                        <!-- IMAGE -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-top-form">
                                                <input type="hidden" name="old_Image1" value="{{ $params['Image1'] }}">
                                                <label class="local-top">Image 1<span class="login-danger"></span></label>
                                                <div class="settings-btn upload-files-avator">
                                                    <input type="file" accept="image/*" name="image1" id="prodImgInput1" class="hide-input" onchange="previewImage('1')">
                                                    <label for="prodImgInput1" class="upload">Choose File</label>
                                                </div>
                                                @if($params['Image1'] == 'No Image')
                                                <p>No Image</p>
                                                @else
                                                <div id="existingImage1">
                                                    <img src="{{ asset('hw_add_asset/' . $params['Image1']) }}" style="max-width: 50%; height: 50%;">
                                                </div>
                                                @endif
                                            </div>
                                            <div id="imagePreview1" style="display:none; text-align: center;">
                                                <img id="preview1" alt="Selected Image" style="max-width: 50%; height: 50%;">
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-top-form">
                                                <input type="hidden" name="old_Image2" value="{{ $params['Image2'] }}">
                                                <label class="local-top">Image 2<span class="login-danger"></span></label>
                                                <div class="settings-btn upload-files-avator">
                                                    <input type="file" accept="image/*" name="image2" id="prodImgInput2" class="hide-input" onchange="previewImage('2')">
                                                    <label for="prodImgInput2" class="upload">Choose File</label>
                                                </div>
                                                @if($params['Image2'] == 'No Image')
                                                <p>No Image</p>
                                                @else
                                                <div id="existingImage2">
                                                    <img src="{{ asset('hw_add_asset/' . $params['Image2']) }}" style="max-width: 50%; height: 10%;">
                                                </div>
                                                @endif
                                            </div>
                                            <div id="imagePreview2" style="display:none; text-align: center;">
                                                <img id="preview2" alt="Selected Image" style="max-width: 50%; height: 50%;">
                                            </div>
                                        </div>
                                    </div>


                                    <!-- DESC -->
                                    <div class="col-12 col-sm-12">
                                        <div class="form-group local-forms">
                                            <label>Description <span class="login-danger"></span></label>
                                            <textarea name="desc" value="" class="form-control" rows="3" cols="30">{{ $params['desc'] }}</textarea>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <div class="doctor-submit text-end">
                                            <button type="submit" class="btn btn-primary submit-form me-2">Submit</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ASSIGNING GRN & INV VALUES  -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#grnno').on('change', function() {
                var selectedGrnNo = $(this).val();
                var selectedGrnDate = $(this).find('option:selected').data('grndate');
                var selectedInvNo = $(this).find('option:selected').data('invno');
                var selectedinvdate = $(this).find('option:selected').data('invdate');
                var selectedSupplier = $(this).find('option:selected').data('supp_name');
                var selectedItenName = $(this).find('option:selected').data('item_name');

                console.log("selectedGrnDate", selectedGrnDate);
                console.log("selectedInvNo", selectedInvNo);
                console.log("selectedinvdate", selectedinvdate);
                console.log("selectedSupplier", selectedSupplier);
                console.log("selectedItenName", selectedItenName);

                $('#grn_date').val(selectedGrnDate);
                $('#inv_no').val(selectedInvNo);
                $('#inv_date').val(selectedinvdate);
                $('#itemname').val(selectedItenName);
                $('#purDate').val(selectedGrnDate);

                var Supplier_Name = document.getElementById('supplier');
                if (selectedSupplier != "") {
                    $('#supplier').val(selectedSupplier);
                    Supplier_Name.readOnly = true;
                }

            });
        });
    </script>


    <!-- WARRANTY COUNT AND MODE IN A INPUT -->
    <script>
        // Run the update function when the page loads
        document.addEventListener("DOMContentLoaded", function() {
            update();
        });

        function update() {
            var purDateInput = document.getElementById('purDate');
            var warrantyCountInput = document.getElementById('warrantyCount');
            var warrantyModeSelect = document.getElementById('warrantyMode');
            var combinedInput = document.getElementById('combinedInput');
            var endWarrantyInput = document.getElementById('endWarranty');

            // DONT ALLOW '.' AND LESS THAN '0'
            let value = warrantyCountInput.value;
            value = value.replace(/[^\d]/g, '');
            warrantyCountInput.value = value;

            // Check if all necessary inputs have values
            if (purDateInput.value && warrantyCountInput.value && warrantyModeSelect.value) {
                var countValue = parseInt(warrantyCountInput.value);
                var modeValue = warrantyModeSelect.value;

                // Combine the values
                var combinedValue = countValue + ' ' + modeValue;

                // Set the combined value to the combinedInput field
                combinedInput.value = combinedValue;

                // Calculate end warranty date
                var endWarrantyDate = new Date(purDateInput.value);
                if (modeValue === 'Month') {
                    endWarrantyDate.setMonth(endWarrantyDate.getMonth() + countValue);
                } else if (modeValue === 'Year') {
                    endWarrantyDate.setFullYear(endWarrantyDate.getFullYear() + countValue);
                }

                // Format the end warranty date as dd-mm-yyyy
                // var formattedEndWarranty = endWarrantyDate.getDate() + '-' + (endWarrantyDate.getMonth() + 1) + '-' + endWarrantyDate.getFullYear();
                var formattedEndWarranty = endWarrantyDate.getFullYear() + '-' + (endWarrantyDate.getMonth() + 1) + '-' + endWarrantyDate.getDate();

                endWarrantyInput.value = formattedEndWarranty;
            }
        }
    </script>


    <!-- IMAGE 1-->
    <script>
        function previewImage(imageNumber) {
            var input = document.getElementById('prodImgInput' + imageNumber);
            var preview = document.getElementById('preview' + imageNumber);
            var previewContainer = document.getElementById('imagePreview' + imageNumber);
            var existingImage = document.getElementById('existingImage' + imageNumber);

            var file = input.files[0];

            if (file) {
                if (existingImage) {
                    existingImage.remove();
                }

                var reader = new FileReader();

                reader.onload = function(e) {
                    preview.src = e.target.result;
                    previewContainer.style.display = 'block';
                };

                reader.readAsDataURL(file);
            } else {
                preview.src = '';
                previewContainer.style.display = 'none';
            }
        }
    </script>


    <div class="sidebar-overlay" data-reff=""></div>
    <!-- jQuery -->
    <script src="hwassets/js/jquery-3.7.0.min.js"></script>

    <!-- Bootstrap Core JS -->
    <script src="hwassets/js/bootstrap.bundle.min.js"></script>

    <!-- Feather Js -->
    <script src="hwassets/js/feather.min.js"></script>

    <!-- Slimscroll -->
    <script src="hwassets/js/jquery.slimscroll.js"></script>

    <!-- Select2 Js -->
    <script src="hwassets/js/select2.min.js"></script>

    <!-- Datatables JS -->
    <script src="hwassets/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="hwassets/plugins/datatables/datatables.min.js"></script>

    <!-- counterup JS -->
    <script src="hwassets/js/jquery.waypoints.js"></script>
    <script src="hwassets/js/jquery.counterup.min.js"></script>

    <!-- Apexchart JS -->
    <script src="hwassets/plugins/apexchart/apexcharts.min.js"></script>
    <script src="hwassets/plugins/apexchart/chart-data.js"></script>

    <!-- Calendar Js -->
    <script src="hwassets/plugins/simple-calendar/jquery.simple-calendar.js"></script>
    <script src="hwassets/js/calander.js"></script>

    <!-- Circle Progress JS -->
    <script src="hwassets/js/circle-progress.min.js"></script>

    <!-- Slick JS -->
    <script src="hwassets/plugins/slick/slick.js"></script>

    <!-- Datepicker Core JS -->
    <script src="hwassets/plugins/moment/moment.min.js"></script>
    <script src="hwassets/js/bootstrap-datetimepicker.min.js"></script>

    <script src="hwassets/plugins/light-gallery/js/lightgallery-all.min.js"></script>

    <!-- Summernote JS -->
    <script src="hwassets/plugins/summernote/summernote-bs5.min.js"></script>

    <!-- Ck Editor JS -->
    <script src="hwassets/js/ckeditor.js"></script>

    <!-- Full Calendar -->
    <script src="hwassets/js/jquery-ui.min.js"></script>
    <script src="hwassets/js/fullcalendar.min.js"></script>
    <script src="hwassets/js/jquery.fullcalendar.js"></script>

    <script>
        // Initialize Select2
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <script data-navigate-once="true">
        window.livewireScriptConfig = {
            "csrf": "hU0lkwotxPRtX77i9lZ9z8EOooahpVoehQm3a7EO",
            "uri": "\/livewire\/update",
            "progressBar": ""
        };
    </script>

    <!-- Custom JS -->
    <script src="hwassets/js/app.js"></script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('SuccessMsg'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @if ($message = Session::get('ErrorMsg'))
    <div id="ErrorAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('ErrorAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 10000);
    </script>
    @endif

    <script>
        $(document).ready(function() {
            $('#ass_type').change(function() {
                var selectedPrefix = $(this).val();
                $.ajax({
                    url: '/hw_add_asset2',
                    method: 'get',
                    data: {
                        selectedPrefix: selectedPrefix
                    },
                    success: function(response) {
                        // Handle the response and display the result
                        console.log(response);
                        $("#ass_id").val(response);
                    },
                    error: function(xhr, status, error) {
                        // Handle errors
                        console.error(error);
                    }
                });
            });
        });
    </script>

</body>
@endsection

</html>