<!DOCTYPE html>
<html lang="en">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <link rel="shortcut icon" type="image/x-icon" href="hwassets/img/favicon.png">
    <title>HW Service Entry</title>
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/css/bootstrap.min.css">
    <!-- Fontawesome CSS -->
    <link rel="stylesheet" href="hwassets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="hwassets/plugins/fontawesome/css/all.min.css">
    <!-- Feathericon CSS -->
    <link rel="stylesheet" href="hwassets/plugins/feather/feather.css">
    <!-- Select2 CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/css/select2.min.css">
    <!-- Datatables CSS -->
    <link rel="stylesheet" href="hwassets/plugins/datatables/datatables.min.css">
    <!-- Calendar CSS -->
    <link rel="stylesheet" href="hwassets/plugins/simple-calendar/simple-calendar.css">
    <!-- Datepicker CSS -->
    <link rel="stylesheet" href="hwassets/css/bootstrap-datetimepicker.min.css">
    <!-- Slick CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/plugins/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="hwassets/plugins/slick/slick-theme.css">
    <link rel="stylesheet" type="text/css" href="hwassets/plugins/light-gallery/css/lightgallery.min.css">
    <!-- Summernote CSS -->
    <link rel="stylesheet" href="hwassets/plugins/summernote/summernote-bs5.min.css">
    <link rel="stylesheet" type="text/css" href="hwassets/css/fullcalendar.min.css">
    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/css/style.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

</head>


<body>
    <div class="main-wrapper">

        @extends('Hardware_Asset.Navbar.hwnavbar')
        @section('content')
        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="row">
                        <div class="col-sm-12">
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="javascript:;">Service Entry</a>
                                </li>

                            </ul>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <form method="POST" action="ServiceEntrySave" enctype="multipart/form-data" onsubmit="return validateForm()">
                                    @csrf
                                    <div class="row">
                                        <div class="col-12 col-md-6 col-xl-3">
                                            <div class="form-group local-forms">
                                                <label>ENO</label>
                                                <input type="text" name="eno" value="<?php echo $ENO; ?>" class="form-control" readonly>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6 col-xl-3">
                                            <div class="form-group local-forms">
                                                <label>EDate</label>
                                                <input type="date" name="edate" value="{{now()->format('Y-m-d')}}" class="form-control" readonly>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6 col-xl-3">
                                            <div class="form-group local-forms">
                                                <label>AssetID/Name<span class="login-danger">*</span></label>
                                                <select class="form-control select2" name="Asset_id" onchange="combinefunction(this.value)" required>
                                                    <option disabled selected>Select AssetID</option>
                                                    @foreach($AssetID as $AssetIDs)
                                                    <option value="{{$AssetIDs['Asset_ID']}}/{{$AssetIDs['Rowid']}}/{{$AssetIDs['Bill_Comp_Code']}}">{{$AssetIDs['Asset_ID']}}/{{$AssetIDs['Name']}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6 col-xl-3">
                                            <div class="form-group local-forms">
                                                <label>Ticket No<span class="login-danger">*</span></label>
                                                <select class="form-control select2" name="Ticketno" required>
                                                    <option disabled selected>Select TicketNo</option>
                                                    @foreach($TickNO as $TickNOs)
                                                    <option value="{{$TickNOs['Row_id']}}">{{$TickNOs['Row_id']}}/{{$TickNOs['ReportedBy']}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- <input type="text" id="employeeno">
                                    <input type="text" id="itemname"> -->

                                    <div class="table-responsive">
                                        <table class="table border-0 custom-table comman-table mb-0" id="myTables">
                                            <thead>
                                                <tr>
                                                    <th>SNO</th>
                                                    <th>Name</th>
                                                    <th>Asset ID</th>
                                                    <th>Item</th>
                                                    <th>Supplier</th>
                                                    <th>Warrenty Date</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td id="sno"></td>
                                                    <td id="Name">

                                                    </td>
                                                    <td id="Assetid"></td>
                                                    <td id="Item"></td>
                                                    <td id="supplier"></td>
                                                    <td id="warrentry"></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <input type="hidden" class="form-control" name="Asset_User">
                                    </div>
                                    <br>
                                    <br>
                                    <div class="row">
                                        <div class="col-12 col-md-4 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label> Service Type <span class="login-danger">*</span></label>
                                                <select class="form-control select2" name="Service_typ" required onchange="getType(this.value)">
                                                    <option disabled selected>Select Details</option>
                                                    @foreach($Serv_type as $Serv_types)
                                                    <option value="{{$Serv_types['Rowid']}}">{{$Serv_types['Name']}}</option>
                                                    @endforeach


                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-4 col-xl-4" id="Opti_Type" style="display: block;">
                                            <div class="form-group local-forms">
                                                <label> Type <span class="login-danger">*</span></label>
                                                <select class="form-control select2 Type" name="Type" id="Type">
                                                    <option disabled selected>Select Type</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 col-xl-4" style="display: none;" id="Opt_Suppl">
                                            <div class="form-group local-forms">
                                                <label> Supplier Name <span class="login-danger">*</span></label>
                                                <select class="form-control select2 Supplier_nam" name="Supplier_nam" required>
                                                    <option disabled selected>Select Supplier Name </option>

                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-3 col-xl-4">
                                            <div class="form-group">
                                                <label>Physical Damage by Employee</label>
                                                <div class="row">
                                                    <div class="col-lg-2">
                                                        <label class="radio-inline mt-2">
                                                            <input type="radio" name="Phy_Damge" id="day_type" value="YES">YES
                                                        </label>
                                                    </div>
                                                    <div class="col-lg-2">
                                                        <label class="radio-inline mt-2">
                                                            <input type="radio" name="Phy_Damge" id="day_type" value="NO" checked>NO
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-12 col-sm-12 mt-3">
                                        <div class="form-group local-forms">
                                            <label>Reason <span class="login-danger">*</span></label>
                                            <textarea name="Reason" class="form-control" id="Reason" rows="3" cols="30"></textarea>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12 col-md-4 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label> Status <span class="login-danger">*</span></label>
                                                <select class="form-control select2" name="StatusID" required onchange="changeSts(this.value)">
                                                    <option disabled selected>Select Status</option>
                                                    @foreach($Status as $Statuss)
                                                    <option value="{{$Statuss['Rowid']}}">{{$Statuss['Name']}}</option>
                                                    @endforeach

                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label> Document-1</label>
                                                <input class="form-control" type="file" id="formFile1" name="formFile1" accept="image/*">

                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label> Document-2</label>
                                                <input class="form-control" type="file" id="formFile2" name="formFile2" accept="image/*">

                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12 col-md-4 col-xl-4" id="Cost_option" style="display: none;">
                                            <div class="form-group local-forms">
                                                <label> Cost <span class="login-danger">*</span></label>
                                                <input type="number" name="cost" id="cost" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 col-xl-4" id="Invdate_option" style="display: none;">
                                            <div class="form-group local-forms">
                                                <label> Invoice Date <span class="login-danger">*</span></label>
                                                <input type="date" name="Inv_date" id="Inv_date" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 col-xl-4" id="InvNo_option" style="display: none;">
                                            <div class="form-group local-forms">
                                                <label> Invoice NO <span class="login-danger">*</span></label>
                                                <input type="text" name="Invno" id="Invno" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 col-xl-4" id="Remarks_option" style="display: none;">
                                            <div class="form-group local-forms">
                                                <label> Remarks <span class="login-danger">*</span></label>
                                                <input type="text" name="Remarks" id="Remarks" class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="doctor-submit text-end">
                                            <button type="submit" id="submitButton" class="btn btn-primary submit-form me-2">Submit</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <div id="delete_patient" class="modal fade delete-modal" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <img src="hwassets/img/sent.png" alt="" width="50" height="46">
                    <h3>Are you sure want to delete this ?</h3>
                    <div class="m-t-20"> <a href="javascript:;" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                        <button type="submit" class="btn btn-danger" data-bs-dismiss="modal">Delete</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- <script>
        function CheckSts(){

        }
    </script> -->

    <!-- ---AJAX METHOD FOR SHOWING COST,INV DATE,INVNO INPUT ---- -->
    <script>
        function changeSts(StsID) {

            var Cost_option = document.getElementById('Cost_option');
            var Invdate_option = document.getElementById('Invdate_option');
            var InvNo_option = document.getElementById('InvNo_option');
            var Remarks_option = document.getElementById('Remarks_option');
            // var Type = document.getElementById('Type').value;

            var Type = document.getElementById('Type') ? document.getElementById('Type').value : null;

            var Cost_input = document.getElementById('cost');
            var Invdate_input = document.getElementById('Inv_date');
            var InvNo_input = document.getElementById('Invno');
            var Remarks_input = document.getElementById('Remarks');

            console.log('Selected type', Type);
            console.log('Selected StsID', StsID);


            if (StsID === '3') {
                if (Type != null) {
                    // NO COST || NO PURCHASE
                    if (Type === '2' || Type === '4') {
                        Cost_option.style.display = 'none'; //HIDE
                        Invdate_option.style.display = 'block';
                        InvNo_option.style.display = 'block';
                        Remarks_option.style.display = 'block';

                        Cost_input.removeAttribute('required');
                        Invdate_input.setAttribute('required', 'required');
                        InvNo_input.setAttribute('required', 'required');
                        Remarks_input.setAttribute('required', 'required');

                    } else {

                        Cost_option.style.display = 'block';
                        Invdate_option.style.display = 'block';
                        InvNo_option.style.display = 'block';
                        Remarks_option.style.display = 'block';

                        Cost_input.setAttribute('required', 'required');
                        Invdate_input.setAttribute('required', 'required');
                        InvNo_input.setAttribute('required', 'required');
                        Remarks_input.setAttribute('required', 'required');

                    }
                } else {
                    // Show all options
                    Cost_option.style.display = 'block';
                    Invdate_option.style.display = 'block';
                    InvNo_option.style.display = 'block';
                    Remarks_option.style.display = 'block';

                    Cost_input.setAttribute('required', 'required');
                    Invdate_input.setAttribute('required', 'required');
                    InvNo_input.setAttribute('required', 'required');
                    Remarks_input.setAttribute('required', 'required');
                }
            } else if (StsID != '3') {

                Cost_option.style.display = 'none';
                Invdate_option.style.display = 'none';
                InvNo_option.style.display = 'none';
                Remarks_option.style.display = 'none';

                Cost_input.removeAttribute('required');
                Invdate_input.removeAttribute('required');
                InvNo_input.removeAttribute('required');
                Remarks_input.removeAttribute('required');
            }

        }
    </script>


    <!-- ---AJAX METHOD FOR SHOWING TYPE ---- -->
    <script>
        function getType(Service_Typ) {

            if (Service_Typ === '3' || Service_Typ === '2') {
                var Opt_Typ = document.getElementById('Opti_Type');
                var Opt_Suppl = document.getElementById('Opt_Suppl');
                var Type = document.getElementById('Type');

                Type.value = '';
                Opt_Suppl.style.display = 'block';
                Opt_Typ.style.display = 'none';

            } else {
                $.ajax({
                    url: "{{ route('Ser_ServiceType') }}",
                    type: "GET",
                    data: {
                        Service_Typ: Service_Typ,
                    },
                    dataType: 'json',
                    success: function(Service_Type) {
                        console.log(Service_Type);

                        var Opt_Typ = document.getElementById('Opti_Type');
                        var Opt_Suppl = document.getElementById('Opt_Suppl');

                        Opt_Suppl.style.display = 'none';
                        Opt_Typ.style.display = 'block';

                        // Clear existing options
                        $('.Type').empty();

                        // Append the "--Select Team--" option first
                        $('.Type').append('<option value=""> Select Type </option>');

                        // Populate dropdown with new options
                        $.each(Service_Type, function(index, option) {
                            var Service_TypeOption = $('<option>', {
                                value: option.Rowid,
                                text: option.Name
                            });

                            $('.Type').append(Service_TypeOption);
                        });

                        // Trigger change event to update hidden input
                        $('.Type').trigger('change');

                    },
                    error: function(xhr, status, error) {
                        console.error("Error fetching asset details:", error);
                        alert("An error occurred while fetching asset details.");
                    }
                });
            }

        }
    </script>

    <!-- ---AJAX METHOD FOR SHOWING ASSET DETAILS IN THE TABLE ---- -->
    <script>
        function combinefunction(AssetRowid) {

            getdetails(AssetRowid);
            getSuppliers(AssetRowid);
        }

        function getdetails(AssetRowid) {
            const [AssetID, Rowid] = AssetRowid.split('/');


            $.ajax({
                url: "{{ route('Ser_AssetDetails') }}",
                type: "GET",
                data: {
                    AssetID: AssetID,
                    Rowid: Rowid,
                },
                dataType: 'json',
                success: function(AssetDet) {
                    console.log(AssetDet);
                    if (AssetDet && AssetDet.length > 0) {

                        var table1 = document.getElementById("myTables");
                        for (let i = table1.rows.length - 1; i > 0; i--) {
                            table1.deleteRow(i);
                        }

                        const asset = AssetDet[0];
                        const tableRow = `
                        <tr>
                            <td>1</td>
                            <td>${asset.Asset_User || '-'}</td>
                            <td>${asset.Asset_ID || '-'}</td>
                            <td>${asset.Asset_Type || '-'}
                            <input type="hidden" name="Asset_Type[]" value="${asset.Asset_Type || ''}"></td>
                            <td>${asset.Supplier || '-'}</td>
                            <td>${asset.End_Warranty_Date || '-'}</td>
                        </tr>
                        `;
                        $('#myTables tbody').html(tableRow);

                        // Display the Emplno in the input field
                        if (asset.Emplno) {
                            document.querySelector('input[name="Asset_User"]').value = asset.Emplno;
                        } else {
                            document.querySelector('input[name="Asset_User"]').value = ''; // Clear the input if no Emplno
                        }

                    } else {
                        alert("No data found for the selected Asset.");
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching asset details:", error);
                    alert("An error occurred while fetching asset details.");
                }
            });

        }

        function getSuppliers(AssetRowid) {
            const [AssetID, Rowid, Billcode] = AssetRowid.split('/');


            $.ajax({
                url: "{{ route('Ser_SupplierDetails') }}",
                type: "GET",
                data: {
                    Billcode: Billcode,
                },
                dataType: 'json',
                success: function(Supplier) {
                    console.log('Supplier', Supplier);
                    if (Supplier && Supplier.length > 0) {

                        // Clear existing options
                        $('.Supplier_nam').empty();

                        // Append the "--Select Team--" option first
                        $('.Supplier_nam').append('<option value=""> Select Supplier Name </option>');

                        // Populate dropdown with new options
                        $.each(Supplier, function(index, option) {
                            var SupplierOption = $('<option>', {
                                value: option.Rowid,
                                text: option.Name
                            });

                            $('.Supplier_nam').append(SupplierOption);
                        });

                        // Trigger change event to update hidden input
                        $('.Supplier_nam').trigger('change');


                    } else {
                        alert("No data found for the selected Asset.");
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching asset details:", error);
                    alert("An error occurred while fetching asset details.");
                }
            });

        }
    </script>

    <!-- SEARCH -->
    <script>
        // Initialize Select2
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <!-- ALTER WHEN EMPL NAME AND SYSTEM IF NOT CHOOSEN FOR SUBMIT BUTTON -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>




    <div class="sidebar-overlay" data-reff=""></div>
    <!-- jQuery -->
    <script src="hwassets/js/jquery-3.7.0.min.js"></script>
    <!-- Bootstrap Core JS -->
    <script src="hwassets/js/bootstrap.bundle.min.js"></script>
    <!-- Feather Js -->
    <script src="hwassets/js/feather.min.js"></script>
    <!-- Slimscroll -->
    <script src="hwassets/js/jquery.slimscroll.js"></script>
    <!-- Select2 Js -->
    <script src="hwassets/js/select2.min.js"></script>
    <!-- Datatables JS -->
    <script src="hwassets/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="hwassets/plugins/datatables/datatables.min.js"></script>
    <!-- counterup JS -->
    <script src="hwassets/js/jquery.waypoints.js"></script>
    <script src="hwassets/js/jquery.counterup.min.js"></script>
    <!-- Apexchart JS -->
    <script src="hwassets/plugins/apexchart/apexcharts.min.js"></script>
    <script src="hwassets/plugins/apexchart/chart-data.js"></script>
    <!-- Calendar Js -->
    <script src="hwassets/plugins/simple-calendar/jquery.simple-calendar.js"></script>
    <script src="hwassets/js/calander.js"></script>
    <!-- Circle Progress JS -->
    <script src="hwassets/js/circle-progress.min.js"></script>
    <!-- Slick JS -->
    <script src="hwassets/plugins/slick/slick.js"></script>
    <!-- Datepicker Core JS -->
    <script src="hwassets/plugins/moment/moment.min.js"></script>
    <script src="hwassets/js/bootstrap-datetimepicker.min.js"></script>
    <script src="hwassets/plugins/light-gallery/js/lightgallery-all.min.js"></script>
    <!-- Summernote JS -->
    <script src="hwassets/plugins/summernote/summernote-bs5.min.js"></script>
    <!-- Ck Editor JS -->
    <script src="hwassets/js/ckeditor.js"></script>
    <!-- Full Calendar -->
    <script src="hwassets/js/jquery-ui.min.js"></script>
    <script src="hwassets/js/fullcalendar.min.js"></script>
    <script src="hwassets/js/jquery.fullcalendar.js"></script>



    <script data-navigate-once="true">
        window.livewireScriptConfig = {
            "csrf": "hU0lkwotxPRtX77i9lZ9z8EOooahpVoehQm3a7EO",
            "uri": "\/livewire\/update",
            "progressBar": ""
        };
    </script>

    <!-- Custom JS -->
    <script src="hwassets/js/app.js"></script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('SuccessMsg'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}

    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 15000);
    </script>
    @endif

    @if ($message = Session::get('errorMsg'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}

    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 20000);
    </script>
    @endif
</body>
@endsection

</html>