<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">

    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Dashboard</title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="gplogofinal.png" type="png">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <!-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css"> -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.1.6/dist/sweetalert2.min.css">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- for icon -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css" rel="stylesheet">
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <!-- Buttons CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <!-- Bootstrap popup-->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/css/flatpickr.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/fixedcolumns/3.3.0/css/fixedColumns.dataTables.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/css/bootstrap-datepicker.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css">

    <style type="text/css">
        .navbar {
            background: #13265C;
        }

        .nav-link:hover {
            color: #9ffb00 !important;
        }

        .dropdown-menu.left {
            left: auto;
            right: 0;
        }

        .active {

            border-radius: 10px;
            color: #fff;
            font-weight: 500;
            border: 2px solid white;

        }

        body {
            /* padding-top: 50px;  */
            color: #1a202c;
            text-align: left;
            background-color: #e2e8f0;
        }

        .main-body {
            padding: 15px;
        }

        .card {
            box-shadow: 0 1px 3px 0 rgba(0, 0, 0, .1), 0 1px 2px 0 rgba(0, 0, 0, .06);
        }

        .card {
            position: relative;
            display: flex;
            flex-direction: column;
            min-width: 0;
            word-wrap: break-word;
            background-color: #fff;
            background-clip: border-box;
            border: 0 solid rgba(0, 0, 0, .125);
            border-radius: .25rem;
        }

        .card-body {
            flex: 1 1 auto;
            min-height: 1px;
            padding: 0rem;
        }

        .gutters-sm {
            margin-right: -8px;
            margin-left: -8px;
        }

        .gutters-sm>.col,
        .gutters-sm>[class*=col-] {
            padding-right: 8px;
            padding-left: 8px;
        }

        .mb-3,
        .my-3 {
            margin-bottom: 1rem !important;
        }

        .bg-gray-300 {
            background-color: #e2e8f0;
        }

        .h-100 {
            height: 100% !important;
        }

        .shadow-none {
            box-shadow: none !important;
        }

        .rounded {
            border-radius: 50%;
            border: 2px solid #ccc;
            cursor: pointer;

        }

        .profile-img {
            text-align: center;
        }

        .profile-img .file {
            position: relative;
            overflow: hidden;
            margin-top: -25%;
            width: 51%;
            border: none;
            border-radius: 0;
            font-size: 15px;
            background: #212529b8;
        }

        .profile-img .file input {
            position: absolute;
            opacity: 0;
            right: 0;
            top: 0;
        }

        .preloder {
            display: none;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999999;
            background: #ffffffbd;
            justify-content: center;
            align-items: center;
            display: flex;
        }

        .lds-hourglass,
        .lds-hourglass:after {
            box-sizing: border-box;
        }

        .lds-hourglass {
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: relative;
            width: 80px;
            height: 80px;
        }

        .lds-hourglass:after {
            content: " ";
            display: block;
            border-radius: 50%;
            width: 0;
            height: 0;
            margin: 8px;
            box-sizing: border-box;
            border: 32px solid currentColor;
            border-color: currentColor transparent currentColor transparent;
            animation: lds-hourglass 1.2s infinite;
        }

        @keyframes lds-hourglass {
            0% {
                transform: rotate(0);
                animation-timing-function: cubic-bezier(0.55, 0.055, 0.675, 0.19);
            }

            50% {
                transform: rotate(900deg);
                animation-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
            }

            100% {
                transform: rotate(1800deg);
            }
        }

        .row {
            margin: 0 !important;
        }
    </style>


    <!-- NEWWW.. -->
    <style>
        .header {
            background-color: #72a3e0;
            padding: 0;
            border-radius: 2px;
            text-align: center;
            color: white;
            padding-top: 3px;
            padding-bottom: 3px;
        }

        .title {
            padding: 0px;
            border-radius: 10px;
        }

        .all_backgr {
            background-color: rgb(237, 240, 244);
        }

        .white {
            background-color: white;
        }

        .vl {
            border-left: 10px solid rgb(237, 240, 244);
            height: 500px;
        }

        .chart_title {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #72a3e0;
            padding: 0px;
            border-radius: 10px;
        }

        @media screen and (max-width: 768px) {

            /* Adjust max-width as needed */
            .vl {
                display: none;
            }
        }
    </style>

    <!-- CAP PLAN CARD -->
    <style>
        .capplTable {
            border-collapse: separate;
            border-spacing: 0;
            width: 230px;
            /* margin: 20px auto; */
            text-align: center;
            border: 1px solid #000;
            border-radius: 12px;
            overflow: hidden;
            height: 9px !important;
            background: white !important;
        }

        .capplThead {
            background-color: #f4f4f4;
        }

        .capplth {
            font-weight: bold;
            padding: 1px;
        }

        .cappltd {
            padding: 10px;
            padding-top: 0;
            padding-bottom: 13px;
            position: relative;
        }

        .cappl-row-heading {
            font-weight: bold;
            font-size: 14px;
            padding-top: 0;
            align-items: center;
            text-align: center;
            word-wrap: break-word;
            max-width: 200px;
        }

        .cappl-row-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .cappl-left {
            text-align: left;
        }

        .cappl-right {
            text-align: right;
            font-size: 24px;
            font-weight: bold;
        }

        .cappl-target {
            font-weight: bold;
            font-size: 14px;
            color: gray;
        }

        .cappl-percentage {
            display: flex;
            align-items: center;
            gap: 5px;
            font-size: 14px;
        }

        .cappl-percentage.green {
            color: green;
        }

        .cappl-percentage.red {
            color: red;
        }

        .cappl-arrow {
            font-size: 12px;
        }

        /* Dotted line separator */
        .cappltd:after {
            content: "";
            display: block;
            width: 90%;
            border-bottom: 1px dotted black;
        }

        /* Remove last dotted line */
        tr:last-child td:after {
            content: none;
        }

        /* #yearBtn_DIS, */
        #monthBtn_DIS,
        #weekBtn_DIS {
            background: transparent;
            border: none;
            font-weight: 900;
            font-size: 15px;
        }
       

        .chartfour.active{
            border: none;
            font-size: 15px;
            border-radius: 10px;
            color: #fff;
            background-color: #0d6efd !important;
            font-weight: 900;
            border: 2px solid white;   
        }

        .chartfour.active:hover {
            background-color: #0a58ca;
            border-color: #fff;
        }
    </style>

    <!-- BUYER DROPDOWN -->
    <style>
        .dropdown-menu {
            list-style: none;
            margin: 0;
            padding: 0;
        }

        .dropdown-menu li {
            padding: 0px 1px;
            cursor: pointer;
        }

        .dropdown-menu li a {
            text-decoration: none;
            color: #000;
            display: block;
        }

        .dropdown-menu li:hover {
            background-color: rgb(211, 219, 226);
        }

        .dropdown-submenu {
            position: relative;
        }

        .dropdown-submenu > .dropdown-menu {
            top: 0;
            left: 100%;
            margin-top: -6px;
            margin-left: 0;
            display: none;
        }

        .dropdown-submenu:hover > .dropdown-menu {
            display: block;
        }
    </style>

    <!-- SPINNER -->    
    <style>
        
        #preloder {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999999;
            background: #ffffffbd;
            justify-content: center;
            align-items: center;
            display: flex;
        }

        .lds-hourglass,
        .lds-hourglass:after {
            box-sizing: border-box;
        }

        .lds-hourglass {
            display: inline-block;
            position: relative;
            width: 80px;
            height: 80px;
        }

        .lds-hourglass:after {
            content: " ";
            display: block;
            border-radius: 50%;
            width: 0;
            height: 0;
            margin: 8px;
            box-sizing: border-box;
            border: 32px solid currentColor;
            border-color: currentColor transparent currentColor transparent;
            animation: lds-hourglass 1.2s infinite;
        }

        @keyframes lds-hourglass {
            0% {
                transform: rotate(0);
                animation-timing-function: cubic-bezier(0.55, 0.055, 0.675, 0.19);
            }

            50% {
                transform: rotate(900deg);
                animation-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
            }

            100% {
                transform: rotate(1800deg);
            }
        }
        .preloder {
                display: none;
                display: flex;
                justify-content: space-between;
                align-items: center;
                position: fixed;
                width: 100%;
                height: 100%;
                top: 0;
                left: 0;
                z-index: 999999;
                background: #ffffffbd;
                justify-content: center;
                align-items: center;
                display: flex;
            }

            .lds-hourglass,
            .lds-hourglass:after {
                box-sizing: border-box;
            }

            .lds-hourglass {
                display: flex;
                justify-content: space-between;
                align-items: center;
                position: relative;
                width: 80px;
                height: 80px;
            }

            .lds-hourglass:after {
                content: " ";
                display: block;
                border-radius: 50%;
                width: 0;
                height: 0;
                margin: 8px;
                box-sizing: border-box;
                border: 32px solid currentColor;
                border-color: currentColor transparent currentColor transparent;
                animation: lds-hourglass 1.2s infinite;
            }

            @keyframes lds-hourglass {
                0% {
                    transform: rotate(0);
                    animation-timing-function: cubic-bezier(0.55, 0.055, 0.675, 0.19);
                }

                50% {
                    transform: rotate(900deg);
                    animation-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
                }

                100% {
                    transform: rotate(1800deg);
                }
            }

    </style>

    <!-- OWE CARD -->
    <style>
        .oweTable {
            border-collapse: separate;
            border-spacing: 0;
            width: 100px;
            text-align: center;
            border: 1px solid #000;
            border-radius: 12px;
            overflow: hidden;
            background: white !important;
        }

        .oweThead {
            background-color: #f4f4f4;
        }

        .oweth {
            font-weight: bold;
            padding: 0;
        }

        .owetd {
            padding: 10px;
            padding-top: 0;
            padding-bottom: 0;
            position: relative;
        }

        .owe-row-heading {
            font-weight: bold;
            font-size: 10px;
            padding-top: 0;
            align-items: center;
            text-align: center;
            word-wrap: break-word;
            max-width: 200px;
            /* padding-bottom: 5px;
            padding-top: 3px; */
        }

        .owe-row-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .owe-left {
            text-align: left;
        }

        .owe-right {
            text-align: right;
            font-size: 18px;
            font-weight: bold;
            padding-left: 5px;
        }

        .owe-target {
            font-weight: bold;
            font-size: 14px;
            color: gray;
        }

        .owe-percentage {
            display: flex;
            align-items: center;
            gap: 5px;
            font-size: 14px;
        }

        .owe-percentage.green {
            color: green;
        }

        .owe-percentage.red {
            color: red;
        }

        .owe-arrow {
            font-size: 12px;
        }

        /* Dotted line separator */
        .owetd:after {
            content: "";
            display: block;
            width: 90%;
            border-bottom: 1px dotted black;
        }

        /* Remove last dotted line */
        .owetr:last-child td:after {
            content: none;
        }

        #oweyearBtn,
        #owemonthBtn,
        #oweweekBtn,
        #oweQBtn,
        #oweDBtn {
            background: transparent;
            border: none;
            font-weight: 600;
            font-size: 12px;
            text-align: center;
            font-family: Inter;
        }
    </style>

    <style>

        .click-text{
                
                z-index: 10;
                text-align: center;
                text-decoration: none;
                font-weight: bold;
            }

        /* .apexcharts-text, */
        .hexowe .apexcharts-xaxis-label {
            display: none;
        }

        .hexowe .apexcharts-legend {
            right: 0px !important;
            position: absolute !important;
            /* left: 0px !important; */
            top: 10px !important;
            max-height: 125px !important;
        }
        /* .firstChart .apexcharts-legend {
            display: none !important;
        } */
        .apexcharts-datalabels-group{
            width: 20px;
        }
        .apexcharts-datalabel-label {
            font-size: 12px !important;
            font-weight: bold !important;
            text-wrap:wrap;
        }

        .apexcharts-datalabel-value {
            font-size: 15px !important;
            font-weight: bold !important;
            fill: #ff2089 !important; /* Change color */
        }

        .buttons {
            text-align: center;
            margin-top: 10px;
        }
        .buttons button {
            margin: 5px;
            padding: 10px 15px;
            border: none;
            cursor: pointer;
            background-color: #007bff;
            color: white;
            border-radius: 5px;
        }
        button.active {
            background-color: #0056b3;
        }
    </style>
    <style>
        .ck_actuallist-column-filter,.supplyerpotable-column-filter {
            font-size: 10px;
            padding: 2px 4px;
            height: auto;
        }

        .ck_actuallist-column-filter option,.supplyerpotable-column-filter option {
            font-size: 10px;
        }
    
        #ck_actuallist_filter,#supplyerpotable_filter {
            font-size: 10px;
        }

        #ck_actuallist_filter label ,#supplyerpotable_filter label {
            font-weight: normal;
            margin-bottom: 0;
        }

        #ck_actuallist_filter input[type="search"] ,#supplyerpotable_filter input[type="search"] {
            font-size: 10px;
            padding: 2px 4px;
            height: auto;
            width: 120px; /* Optional: control width */
            margin-left: 4px;
        }
    </style>
    <!-- MODAL -->
    <style>
            /* Modal styles */
            .modal {
                display: none;
                /* Hidden by default */
                position: fixed;
                z-index: 1000;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                overflow: auto;
                background-color: rgba(0, 0, 0, 0.8);
                /* Black background with opacity */
            }

            .modal-content {
                margin: auto;
                padding: 0;
                width: 90%;
                height: 90%;
                display: flex;
                justify-content: center;
                align-items: center;
                background-color: white;
                border-radius: 8px;
                overflow: hidden;
            }

            .close {
                position: absolute;
                right: 20px;
                top: 20px;
                color: #aaa;
                font-size: 28px;
                font-weight: bold;
                cursor: pointer;
            }

            .close:hover,
            .close:focus {
                color: black;
                text-decoration: none;
                cursor: pointer;
            }

            #chartContainer {
                width: 100%;
                height: 100%;
            }
            #finalDetailsContent tr > td,#finalDetailsContent tr > th {
                font-size:10px;
                padding:2px;
                margin:2px;
                border:1px solid;
            }

            .modal {
                z-index: 1050; /* Default Bootstrap z-index */
            }

            #DefectDetailsModal {
                z-index: 1060 !important; /* Set higher z-index for OCN-wise modal */
            }
            
    </style>
    <!-- <style>
        #supplyerpotable {
            font-size: 10px; /* Smaller font */
            margin: 0;
            padding: 0;
            width: 90%;
            border-collapse: collapse;
            table-layout: auto;
        }

        #supplyerpotable th,
        #supplyerpotable td {
            padding: 4px 6px; /* Tighten padding */
            margin: 0;
            white-space: nowrap;
        }

        #supplierpomodel {
            overflow-x: auto;
        }

        .dataTables_wrapper {
            padding: 0;
            margin: 0;
        }

        .modal-content {
            max-height: 90vh;
            overflow: auto;
        }
    </style> -->

    <style>
        #orderDetailsModal .modal-dialog {
            max-width: 90%; /* Adjust as needed */
            width: 90%;
        }
    </style>

    <!-- calendar icon hover -->
    <style>
        .calender_icon:hover i {
            color: black;
        }
        .modal-backdrop {
            display: none !important;
        }
        .full-height {
            min-height: 15vh; /* Full viewport height */
            background-color: white; /* Ensures white background */
        }
        .dataTables_wrapper .dataTables_filter input{
            height: 25px;
        }
    </style>

</head>
<body id="body" class="">
    <!-- spinner -->

    <!-- spinner end -->
    @apexchartsScripts
    @extends('LifeAtGainup.Navbar.Other_Chn')
    @section('content')

    <div id="layout-wrapper">
        <div class="mt-2">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card all_backgr">
                                <div class="card-header header mt-2 h-100">
                                    <div class="row">
                                        <div class="col-md-12" style="border-radius: 10px;">
                                            <h5>
                                                Garments - CXO Dashboard
                                            </h5>
                                        </div>
                                    </div>
                                </div>
                                <br>

                                <div class="row">
                                        <div class="col-md-12 d-flex justify-content-between align-items-center">
                                            <!-- Breadcrumb Section -->
                                            <nav aria-label="breadcrumb" class="d-flex align-items-center">
                                                <ol class="breadcrumb mb-0">
                                                    <li class="breadcrumb-item">
                                                        
                                                            <i class="fas fa-chart-pie me-1"></i>CXO
                                                        
                                                    </li>
                                                    <li class="breadcrumb-item me-1" aria-current="page">
                                                    <a href="/checkingdashboard" class="text-decoration-none text-primary">
                                                            <i class="fas fa-chart-pie me-1"></i>Quality Portal
                                                        </a>
                                                    </li>
                                                </ol>
                                            </nav>
                                            <!-- Right Section -->
                                           
                                        </div>
                                    </div>
                                <div class="card-body">
                                    <div class="row">
                                        <!-- 1st -->
                                        <div class="col-lg-4 title">
                                            <div class="row">
                                                <div class="col-lg-12 title white">
                                                    <div class="chart_title">
                                                        
                                                    <button id="calendarIcon" style="color: #fff;" class="btn btn-outline-light calender_icon">
                                                        <i class="fa-regular fa-calendar-days"></i>
                                                    </button>
                                                    <input type="text" id="ck_fdate" style="display: none;" placeholder="dd-mm-yyyy">
                                                        <h6 style="color: #fff; text-align: center;"> Buyer Revenue Management</h6>
                                                        <button id="optionsButton-user" class="btn optionsButton-user" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fa fa-user" style="color: #fff;"></i>
                                                        </button>
                                                        <ul class="dropdown-menu" id="brmBuyerDropdown" aria-labelledby="optionsButton-user">
                                                            <li><a href="#" data-value="all">ALL</a></li> <!-- Add 'ALL' option -->
                                                            @foreach($resultBRM as $buyer)
                                                            <li>
                                                                <a href="#" data-value="{{ $buyer['Buyer'] }}">{{ $buyer['Buyer'] }}</a>
                                                            </li>
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                    <div id="chart-container" style="display: none;"></div>
                                                    <div id="initialChart">
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="row full-height">
                                                <div class="col-12">
                                                    <div class="card">
                                                        <h5 class="card-title"> Quality Checking - (last 3 Months)</h5>
                                                        <div class="card-body">
                                                            <!-- Content here -->
                                                            <select id="chartTypeSelector" class="form-control">
                                                                <option value="Presentation" selected>Presentation Checking</option>
                                                                <option value="Endline">Endline Checking</option>
                                                            </select>

                                                            <div id="efficiencyChart"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-8">
                                            <div class="row">
                                                <!-- 2nd -->
                                                <div class="col-lg-5 title white">
                                                    <div class="chart_title">
                                                        <button id="optionsButtoncal" style="color: #fff;" class="btn btn-outline-light calender_icon" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fa-regular fa-calendar-days"></i>
                                                        </button>
                                                        <ul class="dropdown-menu" aria-labelledby="optionsButtoncal">
                                                            <!-- Month Submenu -->
                                                            <li class="dropdown-submenu">
                                                                <a class="dropdown-item dropdown-toggle" href="#">Month</a>
                                                                <ul class="dropdown-menu">
                                                                    <li><a class="dropdown-item calender " data-value='month-24' onclick="changechart(this, 'month-24')" href="#">2024</a></li>
                                                                    <li><a class="dropdown-item calender" data-value='month-25' onclick="changechart(this, 'month-25')" href="#">2025</a></li>
                                                                </ul>
                                                            </li>
                                                            <!-- Week Submenu -->
                                                            <li class="dropdown-submenu">
                                                                <a class="dropdown-item dropdown-toggle" href="#">Week</a>
                                                                <ul class="dropdown-menu">
                                                                    <li><a class="dropdown-item calender" data-value='week-24' onclick="changechart(this, 'week-24')" href="#">2024</a></li>
                                                                    <li><a class="dropdown-item calender" data-value='week-25' onclick="changechart(this, 'week-25')" href="#">2025</a></li>
                                                                </ul>
                                                            </li>
                                                            <li><a class="dropdown-item calender active " data-value='overall' onclick="changechart(this, 'overall')" href="#">OverAll</a></li>
                                                        </ul>

                                                        <h6 style="color: #fff; text-align: center;">Capacity Planning </h6>
                                                        <button id="optionsButton" class="btn optionsButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fa fa-industry" style="color: #fff;"></i>
                                                        </button>
                                                        <ul class="dropdown-menu" aria-labelledby="optionsButton">
                                                            <li><a class="dropdown-item method active" data-value='mins' onclick="changechart(this,'mins');" href="#">Minutes</a></li>
                                                            <li><a class="dropdown-item method " data-value='qty' onclick="changechart( this,'qty');" href="#">Quantity</a></li>
                                                            <li><a class="dropdown-item method " data-value='values' onclick="changechart( this,'values');" href="#">Value</a></li>
                                                            <li><a class="dropdown-item method " data-value='tailor' onclick="changechart( this,'tailor');" href="#">tailor</a></li>
                                                            <li><a class="dropdown-item method " data-value='owe' onclick="changechart( this,'owe');" href="#">OWE</a></li>
                                                        </ul>
                                                        <button id='full_screen' class="btn optionsButton-user">
                                                            <i class="fa fa-arrows-alt" style="color: #fff;"></i>
                                                        </button>

                                                        <button id="optionsButton-user" class="btn optionsButton-user" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fa fa-user" style="color: #fff;"></i>
                                                        </button>
                                                        <ul class="dropdown-menu" id="buyerDropdown" aria-labelledby="optionsButton-user">
                                                            <li><a href="#" data-value="all">ALL</a></li> <!-- Add 'ALL' option -->
                                                            <!-- <li><a href="#" data-value="">Select Buyer</a></li> -->
                                                            @foreach($capacityQtyArr as $buyer)
                                                            @if($buyer['Buyer'] !== 'Total')
                                                            <li>
                                                                <a href="#" data-value="{{ $buyer['Buyer'] }}">{{ $buyer['Buyer'] }}</a>
                                                            </li>
                                                            @endif
                                                            @endforeach
                                                        </ul>

                                                    </div>
                                                    <div>
                                                        <div id="preloder">
                                                            <div class="lds-hourglass">
                                                            </div>
                                                        </div>
                                                        {!! $HrbarChart->container() !!}
                                                    </div>
                                                    {!! $HrbarChart->script() !!}
                                                </div>
                                                <!-- 3rd -->
                                                <div class="col-lg-4 title white vl">
                                                    <div>
                                                        <div class="chart_title">
                                                            <button id="calendarIcon2" style="color: #fff;" class="btn btn-outline-light calender_icon">
                                                                <i class="fa-regular fa-calendar-days"></i>
                                                            </button>
                                                            <h6 style="color: #fff; text-align: center;"> Cost Analysis</h6> 
                                                            <button id="optionsButton" class="btn optionsButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                                <i class="fa fa-industry" style="color: #fff;"></i>
                                                            </button>
                                                            <ul class="dropdown-menu" aria-labelledby="optionsButton">
                                                                <li><a class="dropdown-item" href="#">Sales</a></li>
                                                                <li><a class="dropdown-item" href="#">Deposit</a></li>
                                                            </ul>
                                                            <button id="optionsButton-user-cost" class="btn optionsButton-user-cost" data-bs-toggle="dropdown" aria-expanded="false">
                                                                <i class="fa fa-user" style="color: #fff;"></i>
                                                            </button>
                                                        </div>
                                                        <br>
                                                        <div><p class="text-danger d-flex justify-content-center fs-6">(On hold)</p>
                                                            {{-- {!! $HrbarChartStatic->container() !!} --}}
                                                        </div>
                                                        {{-- {!! $HrbarChartStatic->script() !!} --}}
                                                    </div>
                                                </div>
                                                <br>
                                                <!-- 4th -->
                                                <div class="col-lg-3 title vl">
                                                    <input type = 'hidden' class = 'ck_month' value= ''>
                                                    <input type = 'hidden' class = 'ck_year' value= ''>
                                                    <input type = 'hidden' class = 'ck_week' value= ''>
                                                    <input type = 'hidden' class = 'target_ck_month' value= ''>
                                                    <input type = 'hidden' class = 'target_ck_year' value= ''>
                                                    <input type = 'hidden' class = 'target_ck_week' value= ''>
                                                    <input type = 'hidden' class = 'target_prv_ck_month' value= ''>
                                                    <input type = 'hidden' class = 'target_prv_ck_year' value= ''>
                                                    <input type = 'hidden' class = 'target_prv_ck_week' value= ''>

                                                    <input type = 'hidden' class = 'delivery_month' value= ''>
                                                    <input type = 'hidden' class = 'delivery_year' value= ''>
                                                    <input type = 'hidden' class = 'delivery_week' value= ''>
                                                    <input type = 'hidden' class = 'target_delivery_month' value= ''>
                                                    <input type = 'hidden' class = 'target_delivery_year' value= ''>
                                                    <input type = 'hidden' class = 'target_delivery_week' value= ''>
                                                    <input type = 'hidden' class = 'target_pre_delivery_month' value= ''>
                                                    <input type = 'hidden' class = 'target_pre_delivery_year' value= ''>
                                                    <input type = 'hidden' class = 'target_pre_delivery_week' value= ''>

                                                    <table class="capplTable">
                                                        <thead class="capplThead">
                                                            <tr class="cappltr">
                                                                <th class="capplth" title="Year">
                                                                    <button id="yearBtn_DIS" class="btn btn-outline-none chartfour active" data-type = 'Y'>
                                                                        Y
                                                                    </button>
                                                                    <!-- <select id="year" name="year">
                                                                        <option value="">Select Year</option>
                                                                    </select> -->
                                                                </th>
                                                                <th class="capplth" title="Month">
                                                                    <button id="monthBtn_DIS" class="btn btn-outline-none chartfour" data-type = 'M'>
                                                                        M
                                                                    </button>
                                                                    <!-- <input type="month" id="month" name="month" style="display:none;"> -->
                                                                </th>
                                                                <th class="capplth" title="Week">
                                                                    <button id="weekBtn_DIS" class="btn btn-outline-none chartfour" data-type = 'W'>
                                                                        W
                                                                    </button>
                                                                    <!-- <input type="week" id="week" name="week" style="display:none;"> -->
                                                                </th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr class="cappltr">
                                                                <td class="cappltd" colspan="3">
                                                                <div class="cappl-row-heading">Delivery on Time</div>
                                                                    <div class="cappl-row-content">
                                                                        <div class="cappl-left">
                                                                            <div class="cappl-target">Target</div>
                                                                            <div class="cappl-percentage delivery_target percentage-header red" id = 'delivery_time_color'>
                                                                                <span class="cappl-arrow" id = 'target_delivery_on_time_native' style="display: none;">▼</span>
                                                                                <span class="cappl-arrow" id = 'target_delivery_on_time_pluse'>▲</span>
                                                                                <span id = 'delivery_target'>0%</span>
                                                                            </div>
                                                                        </div>
                                                                        <div class="owe-right" id='devlivery_on_time' onclick="showDeliveryChart()" style="cursor: pointer; text-decoration: underline; color:#5927E5; ">
                                                                            0%
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                            <tr class="cappltr">
                                                                <td class="cappltd" colspan="3">
                                                                    <div class="cappl-row-heading">CK on Time</div>
                                                                    <div class="cappl-row-content">
                                                                        <div class="cappl-left">
                                                                            <div class="cappl-target">Target</div>
                                                                            <div class="cappl-percentage ck_target percentage-header red" id = 'ck_time_color'>
                                                                                <span class="cappl-arrow" id = 'target_ck_on_time_native' style="display: none;">▼</span>
                                                                                <span class="cappl-arrow" id = 'target_ck_on_time_pluse'>▲</span>
                                                                                <span id = 'ck_target'>0%</span>
                                                                            </div>
                                                                        </div>
                                                                        <div class="owe-right" id = 'ck_on_time'  onclick="showAccuracyChart()" style="cursor: pointer; text-decoration: underline; color:#5927E5; ">
                                                                            0%
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                            <tr class="cappltr">
                                                                <td class="cappltd" colspan="3">
                                                                    <div class="cappl-row-heading">Utilised Capacity <span class="mark text-danger small">(On hold)</span></div>
                                                                    <div class="cappl-row-content">
                                                                        <div class="cappl-left">
                                                                            <div class="cappl-target">Target</div>
                                                                            <div class="cappl-percentage green">
                                                                                <span class="cappl-arrow">▲</span>
                                                                                <span>0%</span>
                                                                            </div>
                                                                        </div>
                                                                        <div class="owe-right">
                                                                            0%
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                            <tr class="cappltr">
                                                                <td class="cappltd" colspan="3">
                                                                    <div class="cappl-row-heading">Planning Accuracy <span class="mark text-danger small">(On hold)</span></div>
                                                                    <div class="cappl-row-content">
                                                                        <div class="cappl-left">
                                                                            <div class="cappl-target">Target</div>
                                                                            <div class="cappl-percentage green">
                                                                                <span class="cappl-arrow">▲</span>
                                                                                <span>0%</span>
                                                                            </div>
                                                                        </div>
                                                                        <div class="owe-right">
                                                                            0%
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                            <tr class="cappltr">
                                                                <td class="cappltd" colspan="3">
                                                                    <div class="cappl-row-heading">Changeovers <span class="mark text-danger small">(On hold)</span></div>
                                                                    <div class="cappl-row-content">
                                                                        <div class="cappl-left">
                                                                            <div class="cappl-target">Target</div>
                                                                            <div class="cappl-percentage green">
                                                                                <span class="cappl-arrow">▲</span>
                                                                                <span>0%</span>
                                                                            </div>
                                                                        </div>
                                                                        <div class="owe-right">
                                                                            0%
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                            </tr>                                                                                                                    
                                                        </tbody>
                                                    </table>

                                                </div>

                                            </div>
                                            <br>
                                            <div class="row">
                                                <!-- 5th -->
                                                <div class="col-lg-12 white">
                                                        <div class="row">
                                                            <div class="col-lg-2" style="padding: 0px;">
                                                                <div class="card-body">

                                                                    <div id="FGStock"></div>
                                                                    <div class="click-text" data-id="FGStock" style="cursor: pointer; color: #ff2089; ">
                                                                        FG(Qty)
                                                                    </div>
                                                                    

                                                                </div>
                                                            </div>
                                                            <div class="col-lg-2" style="padding: 0px;">
                                                                <div class="card-body">

                                                                    <div id="TrimsStock"></div>
                                                                    <div class="click-text" data-id="TrimsStock" style="cursor: pointer; color: #ff2089; ">
                                                                        Trims(Val)
                                                                    </div>
                                                                    

                                                                </div>
                                                            </div>
                                                            <div class="col-lg-2" style="padding: 0px;">
                                                                <div class="card-body">

                                                                    <div id="WIP"></div>
                                                                    <div class="click-text" data-id="WIP" style="cursor: pointer; color: #ff2089; ">
                                                                        WIP(Qty)
                                                                    </div>
                                                                    

                                                                </div>
                                                            </div>
                                                            <div class="col-lg-2" style="padding: 0px;">
                                                            <button id="backButton" style="display: none; border: none; cursor: pointer; position: absolute; z-index: 1;"><i class="fa fa-arrow-left" aria-hidden="true"></i></button>
                                                                <div class="card-body">

                                                                    <div id="Outstanding"></div>
                                                                    <div class="click-text" data-id="Outstanding" style="cursor: pointer; color: #ff2089; ">
                                                                        O/S(Qty)
                                                                    </div>
                                                                    

                                                                </div>
                                                            </div>
                                                            <div class="col-lg-2" style="padding: 0px;">
                                                                <div class="card-body">

                                                                    <div id="FabricStock" ></div>
                                                                    <div class="click-text" data-id="FabricStock" style="cursor: pointer; color: #ff2089">
                                                                        FS(Qty)
                                                                    </div>
                                                                    

                                                                </div>
                                                            </div>
                                                            <div class="col-lg-2" style="padding: 0px;">
                                                                <div class="card-body" style="display: flex; flex-direction: column; height: 100%;">
                                                                    <!-- Chart or content here -->
                                                                    <!-- <div id="donutchart6"></div> -->

                                                                    <!-- Note at the bottom right in single line 
                                                                    <p style="color: red;background-color: yellow; padding: 3px; font-size: 9px;font-weight:bold; text-align: left; margin-top: auto; text-wrap: wrap;">
                                                                        Note: Trims in value, others in quantities.
                                                                    </p>-->
                                                                </div>
                                                            </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                    <br>
                                    <!-- 6th -->
                                    
                                    <br><br><br><br><br>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <!-- Modal Container -->
    <div id="chartModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <div class="card">
                <div class="card-header">
                    <h3 id ='Chart_title'>Chart Title</h3>
                </div>
                <div class="card-body">
                    <div id="chartContainer"></div>
                </div>
            </div>
        </div>
    </div>

    <div id="deliveryChartModal" class="modal">
        <div style="position: relative; width: 60%; margin: auto; padding: 39px; background: #fff;">
            <span class="close" id="close-delivery-btn" style="position: absolute; top: 10px; right: 10px; cursor: pointer;">&times;</span>
            <div class="card">
                <div class="card-header">
                    <h3 id="Chart_title_delivery">Delivery Status (In %)</h3>
                </div>
                <div class="card-body">
                    <div id="modalDeliveryChartContainer" style="height: 300px;"></div>
                </div>                
            </div>
            <div id="delivery_actualtable"></div>
        </div>
    </div>

    <div id="ckchartModal" class="modal">
        <div style="position: relative; width: 60%; margin: auto; padding: 39px; background: #fff;">
            <span class="close" id="close-btn"  style="position: absolute; top: 10px; right: 10px; cursor: pointer;">&times;</span>
            <div class="card">
                <div class="card-header">
                    <h3 id ='Chart_title12'>CK status(In %)</h3>
                </div>
                <div class="card-body">
                    <div id="modalChartContainer" style="height: 300px;"></div>
                </div>                
            </div>
            <div id="ck_actualtable"></div>
        </div>
    </div>
    <div class="modal fade" id="orderDetailsModal" tabindex="-1">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="orderDetailsModalLabel">Row Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="orderDetailsContent">
                <!-- Row details will be filled here -->
            </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="DefectDetailsModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="DefectDetailsModalLabel">Row Details</h5>
                <button type="button" class="btn-close right" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="DefectDetailsContent">
                <!-- Row details will be filled here -->
            </div>
            <h6 class="modal-title" id="DefectOcnDetailsModalLabel"></h6>
            <div class="modal-body" id="OcnDefectDetailsContent">
                <!-- Row details will be filled here -->
            </div>
            
            </div>
        </div>
    </div>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <!-- DataTables JS -->

    <script src="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <!-- chart plugin  -->

    <!-- CALENDAR -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

    <!-- BRM CHART -->
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function () {

            function getPreviousMonthDates() {
                const today = new Date();
                // Get the first day of the current month
                const firstDayOfCurrentMonth = new Date(today.getFullYear(), today.getMonth(), 1);
                // Get the last day of the previous month (subtract 1 day from the first day of current month)
                const lastDayOfPreviousMonth = new Date(firstDayOfCurrentMonth - 1);
                // Get the first day of the previous month
                const firstDayOfPreviousMonth = new Date(lastDayOfPreviousMonth.getFullYear(), lastDayOfPreviousMonth.getMonth(), 1);
                
                // Format the dates as "d-M-Y" (e.g., "01-Jan-2024")
                const fromDate = firstDayOfPreviousMonth.toLocaleDateString('en-GB').split("/").reverse().join("-");
                const toDate = lastDayOfPreviousMonth.toLocaleDateString('en-GB').split("/").reverse().join("-");
                
                return { fromDate, toDate };
            }

            // Get the previous month's date range
            const { fromDate, toDate } = getPreviousMonthDates();

            // Automatically send the previous month's date range when the page loads
            sendDatesToController(fromDate, toDate);
            $("#preloder").fadeIn();
            
            // Initialize Flatpickr
            const flatpickrInstance = flatpickr("#ck_fdate", {
                dateFormat: "d-M-Y", // Match SQL format: '01-Jan-2024'
                mode: "range",
                allowInput: true,
                onChange: function (selectedDates, dateStr) {
                    // When dates are selected, split the range into From and To dates
                    const dates = dateStr.split(" to ");
                    const fromDate = dates[0] || null;
                    const toDate = dates[1] || null;

                    if (fromDate && toDate) {
                        sendDatesToController(fromDate, toDate);
                        //$("#preloder").fadeIn();
                    } else {
                        console.log("Please select a complete date range.");
                    }
                },
            });

            // Open Flatpickr on button click
            document.getElementById("calendarIcon").addEventListener("click", function () {
                flatpickrInstance.open();
            });

            let chartData = []; // To store the fetched data
            let selectedBuyer = "all";

            // Function to send dates to the controller
            function sendDatesToController(fromDate, toDate) {
                $.ajax({
                    url: "{{ route('brmChartDetailsDate') }}", // Concatenate the API URL
                    method: 'Get',
                    data: { fromDate: fromDate, toDate:toDate}, // Send serialized form data
                    success: function(response) {
                        chartData =response. result.data.brmData;
                        updateFilteredChart();
                        //$("#preloder").fadeOut();
                    },
                    error: function(xhr, status, error) {
                        console.error('Error:', error);
                    }
                });
            }

            let chart = null; // Declare chart instance globally
            function updateFilteredChart() {
                let filteredData = chartData;
                let orderValues = [];
                let invoiceValues = [];
                let receivedValues = [];
                let buyers = [];

                // Filter data based on the selected buyer
                if (selectedBuyer !== "all") {
                    filteredData = chartData.filter(item => item.Buyer === selectedBuyer);
                }

                console.log('Filtered Data:', filteredData);

                // Prepare data for the chart
                filteredData.forEach((item) => {
                    buyers.push(item.Buyer);
                    orderValues.push((item.Order_Value / 1000000).toFixed(2));
                    invoiceValues.push((item.Invoice_Value / 1000000).toFixed(2));
                    receivedValues.push((item.Received / 1000000).toFixed(2));
                });

                // Hide initial chart and show the chart container
                document.getElementById("initialChart").style.display = "none";
                document.getElementById("chart-container").style.display = "block";

                // Update or render the chart
                updateChart(buyers, orderValues, invoiceValues, receivedValues);
            }

            document.getElementById('brmBuyerDropdown').addEventListener('click', function (event) {
                const target = event.target;
                if (target.tagName === 'A') {
                    selectedBuyer = target.getAttribute('data-value');
                    console.log("Selected BRM Buyer:", selectedBuyer);
                    updateFilteredChart();
                }
            }, { passive: true });

            function updateChart(labels, orderValues, invoiceValues, receivedValues) {
                if (chart) {
                    chart.destroy(); // Destroy the existing chart instance
                }

                // Define the colors for each series
                const seriesColors = ['#feb019', '#008ffb', '#00e396']; // Replace with your desired colors
                // Create a new chart instance with the updated data
                chart = new ApexCharts(document.querySelector("#chart-container"), {
                    chart: {
                        type: 'line',
                        height: 450,
                        toolbar: { show: false },
                    },
                    series: [
                        {
                            name: "Order Value",
                            type: "line",
                            data: orderValues,
                        },
                        {
                            name: "Invoice Value",
                            type: "column",
                            data: invoiceValues,
                        },
                        {
                            name: "Received Value",
                            type: "column",
                            data: receivedValues,
                        },
                    ],
                    colors: seriesColors,  // Apply the defined colors to the series
                    dataLabels: { enabled: false },
                    stroke: {
                        curve: 'stepline',
                        width: [3, 1, 4],
                    },
                    xaxis: {
                        categories: labels,
                    },
                    yaxis: {
                        title: { text: "Values (Million)" },
                        labels: {
                            formatter: function (value) {
                                return value + "M"; // Append "M" for million
                            },
                        },
                    },
                    legend: {
                        position: "top",
                    },
                });

                chart.render(); // Render the chart with new data
            }

        });
    </script>

     <!--  brand based donut drill down rendering : START -->

     <script>
        document.addEventListener("DOMContentLoaded", () => {
            document.querySelectorAll(".click-text").forEach(element => {
                element.addEventListener("click", (event) => {
                    event.stopPropagation();
                    const modal = new bootstrap.Modal(document.getElementById("clickMeModal"));
                    modal.show();
    
                    const chartId = event.target.getAttribute("data-chart-id"); 
    
                    let buyers = {};
                    var dataid = element.getAttribute("data-id");
                    // Set the modal title based on the clicked chart
                    if (dataid === "WIP") {
                        document.getElementById("clickMeModalLabel").textContent = "Unit Wise Details";
                    } else {
                        document.getElementById("clickMeModalLabel").textContent = "Buyer Wise Details";
                    }
                
                    document.getElementById("brandChartsContainer").innerHTML = `<p class="text-center text-muted">Loading brand data...</p>`;
                    $.ajax({
                        url: "{{ route('overallproductiondetails') }}", 
                        method: "GET",
                        data: {dataid:dataid, chartId: dataid }, 
                        success: function(response) {
                
                            if (!response.data.preproduction || response.data.preproduction.length === 0) {
                                document.getElementById("brandChartsContainer").innerHTML = `<p class="text-center text-muted">No brand data available.</p>`;
                                return;
                            }
    
                            response.data.preproduction.forEach(item => {
                                let buyerName = item.Buyer.trim();
                                let ageType = item.Age_Type;
                                let value = parseFloat(item.Total_Bal_Qty) || 0;
    
                                if (!buyers[buyerName]) {
                                    buyers[buyerName] = { labels: [], series: [] };
                                }
    
                                
                                buyers[buyerName].labels.push(ageType);
                                buyers[buyerName].series.push(value);
                            });
    
                            
                            document.getElementById("brandChartsContainer").innerHTML = "";
                            Object.keys(buyers).forEach((buyer, index) => {
                               
                                const wrapperDiv = document.createElement("div");
                                wrapperDiv.classList.add("text-center", "mb-4"); 

                               
                                const buyerLabel = document.createElement("p");
                                buyerLabel.textContent = buyer; 
                                buyerLabel.classList.add("fw-bold","text-dark","mx-auto");
                                buyerLabel.style.fontSize = "12px";
                                buyerLabel.style.wordWrap = "break-word"; 
                                buyerLabel.style.overflowWrap = "break-word"; 
                                buyerLabel.style.maxWidth = "150px"; 
                                buyerLabel.style.textAlign = "center";
                                

                                
                                const chartDiv = document.createElement("div");
                                chartDiv.id = `brandDonutChart${index}`;
                                chartDiv.style.width = "180px";
                                chartDiv.style.height = "180px";
                                chartDiv.style.margin = "10px auto";

                              
                                wrapperDiv.appendChild(buyerLabel);
                                wrapperDiv.appendChild(chartDiv);

                               
                                document.getElementById("brandChartsContainer").appendChild(wrapperDiv);

                              
                                renderBrandDonutChart(dataid, buyer, buyers[buyer].labels, buyers[buyer].series, `brandDonutChart${index}`);
                            });

                        },
                        error: function(xhr, status, error) {
                            console.error("Error fetching brand data:", error);
                            document.getElementById("brandChartsContainer").innerHTML = `<p class="text-center text-danger">Error loading data. Please try again.</p>`;
                        }
                    });
                });
            });
        });
    
        
        // Function to render a brand donut chart with drill-down
        function renderBrandDonutChart(chartId,buyerName, labels, values, elementId) {
            if (!document.getElementById(elementId)) {
                console.error("Chart container missing:", elementId);
                return;
            }

            if (window[elementId] && typeof window[elementId].destroy === "function") {
                window[elementId].destroy();
            }

            window[elementId] = new ApexCharts(document.querySelector(`#${elementId}`), {
                chart: { 
                    type: "donut",
                    events: {
                        dataPointSelection: function (event, chartContext, details) {
                            const selectedIndex = details.dataPointIndex;
                            const selectedAgeType = labels[selectedIndex];
                            //var donutid=elementId; 
                            $.ajax({
                                url: "{{ route('preproductionpo') }}",
                                method: "GET",
                                data: { buyer: buyerName, category: selectedAgeType,donutid:chartId },
                                beforeSend: function() {
                                    // Show "Loading data..." message before fetching details
                                    $("#finalDetailsTitle").text(`${buyerName} - Age: ${selectedAgeType}`);
                                    $("#finalDetailsContent").html("<p class='text-center text-muted'>Loading data...</p>");
                                    $("#date_note").hide();
                                    $("#finalDetailsModal").modal("show");
                                },
                                success: function (response) {

                                    $(".modal-backdrop").remove();
                                    $("body").removeClass("modal-open");

                                    $("#finalDetailsTitle").text(`${buyerName} - Age: ${selectedAgeType}`);

                                    if ( !response.data.preproduction || response.data.preproduction.length === 0) {
                                        console.warn("No data returned for", buyerName, selectedAgeType);
                                        $("#finalDetailsContent").html("<p class='text-muted'>No data available.</p>");
                                        $("#date_note").hide();
                                        $("#finalDetailsModal").modal("show");
                                        return;
                                    }

                                    let tableHtml = `<table class='table table-hover table-bordered' id='detailTable'>
                                        <thead><tr>` +
                                        Object.keys(response.data.preproduction[0]).map(key => `<th>${key}</th>`).join('') +
                                        `</tr></thead><tbody>`;

                                    response.data.preproduction.forEach(row => {
                                        tableHtml += "<tr>" + Object.values(row).map(value => `<td>${value}</td>`).join('') + "</tr>";
                                    });

                                    tableHtml += "</tbody></table>";

                                    $("#finalDetailsContent").html(tableHtml);
                                    $("#date_note").hide();
                                    $("#finalDetailsModal").modal("show");
                                },
                                error: function(xhr, status, error) {
                                    console.error("Error fetching details:", error);
                                }
                            });
                        }
                    }
                },
                series: values, 
                labels: labels, 
                colors: ['#5927e5', '#ffbe42', '#ff2089', '#e400b1', '#ffcc33', '#ff5733'],
                plotOptions: {
                    pie: {
                        donut: {
                            size: '75%',
                            labels: {
                                show: true,
                                total: {
                                    show: true,
                                    label: "", // This makes the total label blank
                                    formatter: function (w) {
                                        return values.reduce((sum, val) => sum + val, 0).toLocaleString();
                                    }
                                }
                            }
                        }
                    }
                },

                tooltip: { enabled: true },
                dataLabels: { enabled: false },
                legend: { show: false },
            });

            window[elementId].render();
        }
    </script>
    
    <!-- brand based donut drill down rendering : END -->

    <script> window.brandDataByChart = {}; // global object

        $(document).ready(function () {
            const preproductionData = @json($preproductionArr) || [];
            const wippreproductionData = @json($wiposdetailsArr) || [];
            const trimpreproductionData = @json($trimosdetailsArr) || [];
            const fgspreproductionData = @json($fgsdetailsArr) || [];
            const fabricpreproductionData = @json($FabricdetailsArr) || [];
            
            const Total_Bal_Qty = preproductionData.map(item => Number(item.Total_Bal_Qty) || 0);
            const Age_Type = preproductionData.map(item => item.Age_Type || "N/A");
            const Total_Records = preproductionData.map(item => Number(item.Total_Records) || 0);
            const GrandTotal_Records = Total_Records.reduce((sum, val) => sum + val, 0);
            const GrandTotal_Bal_Qty = Total_Bal_Qty.reduce((sum, val) => sum + val, 0);

             //wip
            const WIPTotal_Bal_Qty = wippreproductionData.map(item => Number(item.Total_Bal_Qty) || 0);
            const WIPAge_Type = wippreproductionData.map(item => item.Age || "N/A");
            const WIPGrandTotal_Bal_Qty = WIPTotal_Bal_Qty.reduce((sum, val) => sum + val, 0);
            //Trims stack
            const TrimTotal_Bal_Qty = trimpreproductionData.map(item => Number(item.Total_Bal_Qty) || 0);
            const TrimAge_Type = trimpreproductionData.map(item => item.Age || "N/A");
            const TrimGrandTotal_Bal_Qty = TrimTotal_Bal_Qty.reduce((sum, val) => sum + val, 0);

            //FGS stack
            const FgsTotal_Bal_Qty = fgspreproductionData.map(item => Number(item.Total_Bal_Qty) || 0);
            const FgsAge_Type = fgspreproductionData.map(item => item.Age || "N/A");
            const FgsGrandTotal_Bal_Qty = FgsTotal_Bal_Qty.reduce((sum, val) => sum + val, 0);

            //Fabric stack
            const FabricTotal_Bal_Qty = fabricpreproductionData.map(item => Number(item.Total_Bal_Qty) || 0);
            const FabricAge_Type = fabricpreproductionData.map(item => item.Age || "N/A");
            const FabricGrandTotal_Bal_Qty = FabricTotal_Bal_Qty.reduce((sum, val) => sum + val, 0);

            let chartInstances = {};
            let isDrilldown = false;
            let originalChartData = null; 


            function renderChart(config, isDrilldown = false) {
                $("#backButton").toggle(isDrilldown);

                const options = {
                    chart: {
                        type: 'donut',
                        events: {
                            dataPointSelection: function (event, chartContext, details) {
                                const chartId = chartContext.el.id;
                                if (config.drilldown && details.dataPointIndex !== undefined && !isDrilldown) {
                                    const selectedIndex = details.dataPointIndex;
                                    const selectedCategory = config.labels[selectedIndex];
                                    
                                    $.ajax({
                                        url: "{{ route('preproductionage') }}",
                                        method: 'GET',
                                        data: {agetype: selectedCategory,donutid: chartId},
                                        success: function(response) {
                                            if (!response.data || response.data.preproduction.length === 0) {
                                                alert("No drilldown data available.");
                                                return;
                                            }
                                            
                                            const buyerageArr = response.data.preproduction;
                                            const BuyerSelArr = buyerageArr.map(item => item.Buyer || "N/A");
                                            const BuyerQty = buyerageArr.map(item => Number(item.Total_Bal_Qty) || 0);
                                            
                                            renderDrilldownChart(BuyerSelArr, BuyerQty, selectedCategory, chartId);

                                            $("#drilldownModal").modal("show");
                                            $(".modal-backdrop").remove();
                                        },
                                        error: function (xhr, status, error) {
                                            console.error('Error:', error);
                                        }
                                    });
                                }
                            },

                        },
                    },
                    series: config.data,
                    labels: config.labels,
                    colors: ['#5927e5', '#ffbe42', '#ff2089', '#e400b1'],
                    plotOptions: {
                        pie: {
                            donut: {
                                size: '75%',
                                labels: {
                                    show: true,
                                    total: {
                                        show: true,
                                        label: config.totalLabel,
                                        formatter: function () {
                                            return config.nextValue;
                                        },
                                    },
                                },
                            },
                        },
                    },
                    tooltip: { enabled: false },
                    dataLabels: { enabled: false },
                    legend: { show: false },
                };

                if (chartInstances[config.element]) {
                    chartInstances[config.element].destroy();
                }
                
                chartInstances[config.element] = new ApexCharts(document.querySelector(config.element), options);
                chartInstances[config.element].render();

            } 

            
            let brandDataByChart = {}; 

            function renderDrilldownChart(labels, data, category, chartId) {
                $('#drilldownTitle').html(chartId + ' Details on Age wise: ' + category);

                if (window.drilldownChart) {
                    window.drilldownChart.destroy();
                }

                const uniqueColors = generateUniqueColors(labels.length);
                window.drilldownChart = new ApexCharts(document.querySelector("#subDonutChart"), {
                    chart: {
                        type: "donut",
                        events: {
                            dataPointSelection: function (event, chartContext, details) {
                                const selectedIndex = details.dataPointIndex;
                                const selectedBuyer = labels[selectedIndex];

                                $.ajax({
                                    url: "{{ route('preproductionpo') }}",
                                    method: 'GET',
                                    data: { buyer: selectedBuyer, category: category, donutid: chartId },  
                                    beforeSend: function() {
                                    // Show "Loading data..." message before fetching details
                                    $("#finalDetailsTitle").text(`${selectedBuyer} - Age: ${category}`);
                                    $("#finalDetailsContent").html("<p class='text-center text-muted'>Loading data...</p>");
                                    $("#date_note").hide();
                                    $("#finalDetailsModal").modal("show");
                                    },                                  
                                    success: function (response) {
                                        $(".modal-backdrop").remove();
                                        $("body").removeClass("modal-open");

                                        $("#finalDetailsTitle").text(chartId + ` Details - Age: ${category} / ${selectedBuyer}`);

                                        if (!response.data.preproduction || response.data.preproduction.length === 0) {
                                            $("#finalDetailsContent").html("<p class='text-muted'>No data available.</p>");
                                            $("#date_note").hide();
                                            return;
                                        }

                                        // Store brand data for later use in the text-click modal
                                   /*     brandDataByChart[chartId] = {};

                                        response.data.preproduction.forEach(item => {
                                            const brand = item.Brand || "Unknown Brand";
                                            const value = parseFloat(item.Value) || 0;

                                            if (!brandDataByChart[chartId][brand]) {
                                                brandDataByChart[chartId][brand] = 0;
                                            }
                                            brandDataByChart[chartId][brand] += value;
                                        });

                                        console.log("Updated brandDataByChart:", brandDataByChart); // Debugging log */

                                        let tableHtml = `<table class='table table-hover table-bordered' id='processpotable2'>
                                            <thead><tr>` +
                                            Object.keys(response.data.preproduction[0]).map(key => `<th>${key}</th>`).join('') +
                                            `</tr></thead><tbody>`;

                                        response.data.preproduction.forEach(row => {
                                            tableHtml += "<tr>" + Object.values(row).map(value => `<td>${value}</td>`).join('') + "</tr>";
                                        });

                                        tableHtml += "</tbody></table>";

                                        $("#finalDetailsContent").html(tableHtml);
                                        $("#date_note").hide();
                                        $("#finalDetailsModal").modal("show");
                                    },
                                    error: function (xhr, status, error) {
                                        console.error('Error:', error);
                                    }
                                });
                            }
                        }
                    },
                    series: data,
                    labels: labels,
                    plotOptions: {
                        pie: {
                            donut: {
                                size: '75%',
                                labels: {
                                    show: true,
                                    total: {
                                        show: true,
                                        label: "",
                                        formatter: function () {
                                            return data.reduce((sum, val) => sum + val, 0);
                                        },
                                    },
                                },
                            },
                        },
                    },
                    legend: { show: false },
                });

                window.drilldownChart.render();
            }


            const chartConfigs = [
                { element: "#FGStock", data: FgsTotal_Bal_Qty, labels: FgsAge_Type, totalLabel: 'FGStock', nextValue: FgsGrandTotal_Bal_Qty, drilldown: true },
                { element: "#TrimsStock", data: TrimTotal_Bal_Qty, labels: TrimAge_Type, totalLabel: 'Trims Stock', nextValue: TrimGrandTotal_Bal_Qty, drilldown: true },
                { element: "#WIP", data: WIPTotal_Bal_Qty, labels: WIPAge_Type, totalLabel: 'WIP', nextValue: WIPGrandTotal_Bal_Qty, drilldown: true },
                { element: "#Outstanding", data: Total_Bal_Qty, labels: Age_Type, totalLabel: 'O/S', nextValue: GrandTotal_Bal_Qty, drilldown: true },
                { element: "#FabricStock", data: FabricTotal_Bal_Qty, labels: FabricAge_Type, totalLabel: 'FabricStock', nextValue: FabricGrandTotal_Bal_Qty, drilldown: true },
                { element: "#donutchart6", data: FabricTotal_Bal_Qty, labels: FabricAge_Type, totalLabel: "#click-text", nextValue: FabricGrandTotal_Bal_Qty, drilldown: true },
            ];


            chartConfigs.forEach(config => renderChart(config));

            $("#backButton").click(function () {
                if (originalChartData) {
                    renderChart(originalChartData, false);
                }
            });
        });
        
        $(document).on("hidden.bs.modal", function () {
            $("body").removeClass("modal-open"); 
            $("body").css("overflow", "auto"); 

            let backdrop = $(".modal-backdrop");
            if (backdrop.length) {
                backdrop.remove(); 
            }
        });

        function generateUniqueColors(count) {
            const colors = [];
            for (let i = 0; i < count; i++) {
                const hue = (i * 137) % 360; 
                colors.push(`hsl(${hue}, 70%, 50%)`);
            }
            return colors;
        }


    </script>

    <!-- Label Modal for Donut Chart -->
    <div class="modal fade" id="clickMeModal" tabindex="-1" aria-labelledby="clickMeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="clickMeModalLabel">Buyer/Unit wise Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="brandChartsContainer" class="d-flex flex-wrap justify-content-center"></div> 
                    <!-- brand charts will be added here -->
                </div>
            </div>
        </div>
    </div>

    
    <!-- Drilldown Modal -->
    <div class="modal fade" id="drilldownModal" tabindex="-1" aria-labelledby="drilldownTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="drilldownTitle">Drilldown Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="subDonutChart" style="height: 350px;"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Final Details Modal -->
    <div class="modal fade" id="finalDetailsModal" tabindex="-1" aria-labelledby="finalDetailsTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="finalDetailsTitle">Buyer Details</h5>                    
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <span style='color:red; font-size:10px; text-align:center;' id='date_note'></span>
                <div class="modal-body" id="finalDetailsContent">
                    <!-- Buyer details will be loaded here -->
                </div>
            </div>
        </div>
    </div>

    <!-- Back Button -->
    <button id="backButton" class="btn btn-secondary" style="display: none;">Back</button>

    
    <script>
        // Initialize Date Range Picker for the first chart
        $('#calendarIcon1').daterangepicker({
            singleDatePicker: true,
            showDropdowns: true,
            locale: {
                format: 'MM/DD/YYYY'
            }
        }, function(start, end, label) {
            console.log('Selected date: ' + start.format('MM/DD/YYYY'));
            // Update the chart based on the selected date
        });

        // Initialize Date Range Picker for the second chart
        $('#calendarIcon2').daterangepicker({
            singleDatePicker: true,
            showDropdowns: true,
            locale: {
                format: 'MM/DD/YYYY'
            }
        }, function(start, end, label) {
            console.log('Selected date: ' + start.format('MM/DD/YYYY'));
            // Update the chart based on the selected date
        });
    </script>

    <script>
        var chartOptions = @json(config('apexcharts.options'));
        var chart = new ApexCharts(document.querySelector("#chart"), chartOptions);
        chart.render();
    </script>


    <script>
        window.onload = function() {
                // Populate Year dropdown
                let yearSelect = document.getElementById('year');
                let currentYear = new Date().getFullYear();
                let startYear = 2023;

                for (let year = startYear; year <= currentYear; year++) {
                    let option = document.createElement('option');
                    option.value = year;
                    option.textContent = year;
                    yearSelect.appendChild(option);
                }

                // Initially hide the year select dropdown
                yearSelect.style.display = 'none';

            
        };
        let filteredQtyDataarr = []; // Default empty array
        let Qtycolumnsarr = []; // Default empty array

        function changechart(element, chartType) {
            var value = chartType;
            var val = chartType;
            $("#preloder").fadeIn();
            if (element.classList.contains('calender')) {
                const dropdownItemsCalender = document.querySelectorAll('.dropdown-item.calender');
                dropdownItemsCalender.forEach(item => item.classList.remove('active'));
            }

            if (element.classList.contains('method')) {
                const dropdownItemsMethod = document.querySelectorAll('.dropdown-item.method');
                dropdownItemsMethod.forEach(item => item.classList.remove('active'));
            }
            element.classList.add('active');
            const activeItems = document.querySelectorAll('.calender.active, .method.active');
            const activeValues = Array.from(activeItems).reduce((result, item) => {
                if (item.classList.contains('calender')) {
                    result.calender = item.getAttribute('data-value');
                } else if (item.classList.contains('method')) {
                    result.method = item.getAttribute('data-value');
                }
                return result;
            }, {});
            const methodValue = activeValues.method;
            const calender = activeValues.calender;
            const parts = calender.split('-');
            const numbercalender = parts[1] ? parts[1] : "OverAll";
            var val = methodValue;           
            $.ajax({
                url: "{{ route('capacitymonthwish') }}",
                method: 'GET',
                data: activeValues,
                success: function(response) {console.log('2');
                    var capacityQtyArr = response.capacitymonth;
                    var deliverytimeArr = response.deliveryontime;
                    var cktimeArr = response.cktime;
                    var cktargetArr = response.cktimetarget;
                    populateontime(deliverytimeArr);
                    populateDeliveryTarget(deliverytimeArr);
                    //populateckontime(cktimeArr);
                    populateckontarget(cktargetArr);
                    if(methodValue == 'tailor' || methodValue == 'owe' ){
                        filteredQtyDataarr = capacityQtyArr
                            .filter(item => item.Unit !== "Over All") ;
                    }else{
                        filteredQtyDataarr = capacityQtyArr.filter((item => item.Buyer !== "Total" && item.Buyer !== "SUB TOT") );
                    }
                
                    populateBuyerDropdown(filteredQtyDataarr);
                    if (value == 'week-24' || value == 'week-25') {
                        Qtycolumnsarr = Object.keys(filteredQtyDataarr[0]);
                    } else {
                        Qtycolumnsarr = Object.keys(filteredQtyDataarr[0]).filter(key => key.match(/^[A-Za-z]{3}_\d{4}$/));
                    }

                    var Qtycategories = Qtycolumnsarr.map(col => col.replace(/_(\d{2})(\d{2})$/, '_$2'));

                    if(methodValue == 'tailor' || methodValue == 'owe' ){
                        var formattedQtyData = filteredQtyDataarr
                            .filter(item => item.Unit !== "Over All") // Remove items with Unit as "Overall"
                            .map(item => ({
                                name: item.Unit,
                                data: Qtycolumnsarr.map(col => parseInt(item[col]) || 0) // Parse and handle null/undefined
                            }));
                    }else{
                        var formattedQtyData = filteredQtyDataarr.map(item => ({
                        name: item.Buyer,
                        data: Qtycolumnsarr.map(col => parseInt(item[col]) || 0)
                        }));
                    }
                    var unitWiseData = {};
                    // Iterate through filteredQtyDataarr
                    filteredQtyDataarr.forEach(item => {
                        var unit = item.Unit; // Extract unit name

                        // Ensure the unit exists in the object, initialize with zeroes
                        if (!unitWiseData[unit]) {
                            unitWiseData[unit] = {
                                name: unit,
                                type: 'line',
                                data: Qtycolumnsarr.map(() => 0) 
                                
                            };
                        }

                        // Sum the values for each month
                        Qtycolumnsarr.forEach((col, index) => {
                            unitWiseData[unit].data[index] += parseInt(item[col]) || 0;
                        });
                    });
                    var unitwishQtyData = Object.values(unitWiseData);
                    chart_{{ $HrbarChart->getId() }}.updateSeries(formattedQtyData);

                    var xAxisLabel = "";
                    var yAxisLabel = "";
                    if (val === 'mins'){
                        xAxisLabel = 'Months';
                        yAxisLabel = 'Booking Mins-('+numbercalender + ')';
                    }else if (val === 'qty') {
                        xAxisLabel = 'Months';
                        yAxisLabel = 'Booking Qty-('+numbercalender + ')';;
                    }else if (val == 'values'){
                        xAxisLabel = 'Months';
                        yAxisLabel = 'Booking Values-('+numbercalender + ')';;
                    } else if (val == 'tailor'){
                        xAxisLabel = 'Months';
                        yAxisLabel = 'Tailor -('+numbercalender + ')';;
                    } else if (val == 'owe'){
                        xAxisLabel = 'Months';
                        yAxisLabel = 'OWE -('+numbercalender + ')';;
                    }
                    let seriesData = (methodValue === 'tailor' || methodValue === 'owe') ? formattedQtyData : formattedQtyData.concat(unitwishQtyData);


                    chart_{{ $HrbarChart->getId() }}.updateOptions({
                    chart: {
                        type: 'bar',
                        zoom: {
                            enabled: true,
                            type: 'xy',
                            autoScaleYaxis: true
                        },
                        toolbar: {
                            show: true,
                            tools: {
                                zoom: true,
                                zoomin: true,
                                zoomout: true,
                                pan: true,
                                reset: true
                            },
                            autoSelected: 'zoom'
                        }
                    },
                    xaxis: {
                        categories: Qtycategories,
                        title: { text: xAxisLabel },
                        labels: {
                            formatter: function (value) {
                                return value;
                            }
                        }
                    },
                    yaxis: {
                        title: { text: yAxisLabel },
                        labels: {
                            formatter: function (value) {
                                if (value >= 1000000) return (value / 1000000).toFixed(1) + 'M';
                                else if (value >= 1000) return (value / 1000).toFixed(1) + 'K';
                                else return value.toLocaleString();
                            }
                        }
                    },
                    series:  seriesData,
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            dataLabels: {
                                enabled: false,
                                formatter: function (value) {
                                    if (value >= 1000000) return (value / 1000000).toFixed(1) + 'M';
                                    else if (value >= 1000) return (value / 1000).toFixed(1) + 'K';
                                    else return value.toLocaleString();
                                }
                            }
                        }
                    },
                    colors: ['#008ffb', '#00e396', '#feb019', '#ff455f', '#775dd0','#80effe','#0077b5','#ff6384','#c9cbcf'],
                    tooltip: {
                        y: {
                            formatter: function (value) {
                                if (value >= 1000000) return (value / 1000000).toFixed(1) + 'M';
                                else if (value >= 1000) return (value / 1000).toFixed(1) + 'K';
                                else return value.toLocaleString();
                            }
                        }
                    },
                    annotations: {
                        points: Qtycategories.map((category, index) => {
                            const total = formattedQtyData.reduce((sum, series) => {
                                return sum + (series.data[index] || 0);
                            }, 0);

                            // Only show label if total is greater than zero
                            if (total > 0) {
                                return {
                                    x: category,
                                    y: total,
                                    marker: {
                                        size: 0
                                    },
                                    label: {
                                        text: total >= 1000000 ? (total / 1000000).toFixed(1) + 'M' :
                                            total >= 1000 ? (total / 1000).toFixed(1) + 'K' : total.toLocaleString(),
                                        style: {
                                            fontSize: '8px',
                                            fontWeight: 'bold',
                                            color: '#000000',
                                        },
                                        offsetY: -10
                                    }
                                };
                            }
                            return null; // Return null for total <= 0 to avoid showing a label
                        }).filter(annotation => annotation !== null) // Filter out null annotations
                    }
                    });
                    $("#preloder").fadeOut();
                },
                error: function() {
                    console.log("Error fetching data.");
                },
                complete: function () {
                   // $("#preloder").fadeOut();
                }
            });
        }

        function updateChartForBuyerNew(selectedBuyer) {
            let activeMethod = document.querySelector('.method.active');
            let methodValue = activeMethod ? activeMethod.getAttribute('data-value') : null;
            var unitWiseData = {};

            if (filteredQtyDataarr.length === 0 || Qtycolumnsarr.length === 0) {
                console.error("Data is not loaded yet. Please wait for the AJAX response.");
                return;
            }

            if(selectedBuyer == 'one' || selectedBuyer == 'all'){
                if(methodValue == 'tailor' || methodValue == 'owe' ){
                    var singleBuyerData = filteredQtyDataarr.filter(item => item.Unit !== "Total" && item.Unit !== "SUB TOT");

                    var formattedQtyData = singleBuyerData.map(item => ({
                        name: item.Unit,
                        data: Qtycolumnsarr.map(col => parseInt(item[col]) || 0)
                    }));
                }else{
                    var singleBuyerData = filteredQtyDataarr.filter(item => item.Buyer !== "Total");
                    var formattedQtyData = singleBuyerData.map(item => ({
                        name: item.Buyer,
                        data: Qtycolumnsarr.map(col => parseInt(item[col]) || 0)
                    }));

                    filteredQtyDataarr.forEach(unititem => {
                        var unit = unititem.Unit; 
                        if (!unitWiseData[unit]) {
                            unitWiseData[unit] = {
                                name: unit,
                                type: 'line',
                                data: Qtycolumnsarr.map(() => 0) 
                            };
                        }
                        Qtycolumnsarr.forEach((col, index) => {
                            unitWiseData[unit].data[index] += parseInt(unititem[col]) || 0;
                        });
                    });
                    var unitwishQtyData = Object.values(unitWiseData);
                }
                
            }else{
                if(methodValue == 'tailor' || methodValue == 'owe' ){
                    var singleBuyerData = filteredQtyDataarr.filter(item => item.Unit === selectedBuyer);
                    var formattedQtyData = singleBuyerData.map(item => ({
                        name: item.Unit,
                        data: Qtycolumnsarr.map(col => parseInt(item[col]) || 0)
                        }));
                }else{
                    var singleBuyerData = filteredQtyDataarr.filter(item => item.Buyer === selectedBuyer);
                    var formattedQtyData = singleBuyerData.map(item => ({
                        name: item.Buyer,
                        data: Qtycolumnsarr.map(col => parseInt(item[col]) || 0)
                    }));
                    var unitwishQtyData = Object.values(unitWiseData);
                }
            }
        
        

            // Modal references
            var modal = document.getElementById('chartModal');
            var closeButton = document.querySelector('.close');

            // Show the modal
            modal.style.display = "block";

            
            const lineChartData = unitwishQtyData;

            const updatedSeriesData = [
                ...formattedQtyData.map(series => ({
                    ...series,
                    type: 'bar',  // Ensure the bar charts are still of 'bar' type
                    yAxisIndex: 0 // Use primary Y-axis for bars
                })),
                ...lineChartData.map(series => ({
                    ...series,
                    type: 'line',
                    yAxisIndex: 1  // Use secondary Y-axis for line charts
                }))
            ];

            //This chart using ZOOM Option
            const chartOptions = {
                chart: {
                    background: '#f4f4f4',
                    width : 1000,
                    height: 500,
                    stacked: true,
                    animations: {
                        enabled: true
                    }
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: '50%',
                        borderRadius: 5
                    }
                },
                colors: ['#008ffb', '#00e396', '#feb019', '#ff455f', '#775dd0','#80effe','#0077b5','#ff6384','#c9cbcf'],
                dataLabels: {
                    enabled: false, // Enable bar labels globally
                    style: {
                        colors: ['#000000'], // Set color for bar labels
                        fontSize: '14px',
                        fontWeight: 'bold',
                        fontFamily: 'Arial, sans-serif',
                    },
                    formatter: function (value) {
                        // Format the value displayed on bars
                        return value >= 1000000 ? (value / 1000000).toFixed(1) + 'M' :
                            value >= 1000 ? (value / 1000).toFixed(1) + 'K' : value;
                    },
                    offsetY: -5, // Adjust label position slightly above bars
                },
                xaxis: {
                    categories: Qtycolumnsarr.map(col => col.replace(/_(\d{2})(\d{2})$/, '_$2')),
                    labels: {
                        show: true,
                        style: {
                            colors: '#333333',
                            fontSize: '14px',
                            fontWeight: 'bold'
                        }
                    },
                    axisBorder: {
                        show: true,
                        color: '#000000',
                        height: 2
                    },
                    axisTicks: {
                        show: true,
                        color: '#000000'
                    }
                },
                yaxis: {
                    labels: {
                        show: true,
                        style: {
                            colors: '#333333',
                            fontSize: '14px',
                            fontWeight: 'bold'
                        },
                        formatter: function (value) {
                            // Format Y-axis labels
                            return value >= 1000000 ? (value / 1000000).toFixed(1) + 'M' :
                                value >= 1000 ? (value / 1000).toFixed(1) + 'K' : value;
                        }
                    },
                    axisBorder: {
                        show: true,
                        color: '#000000',
                    },
                    axisTicks: {
                        show: true,
                        color: '#000000'
                    }
                },
                series: updatedSeriesData,
                annotations: {
                    points: Qtycolumnsarr.map((category, index) => {
                        const total = formattedQtyData.reduce((sum, series) => {
                            return sum + (series.data[index] || 0);
                        }, 0);

                        return {
                            x: category.split('_')[0],
                            y: total,
                            marker: {
                                size: 0
                            },
                            label: {
                                text: total >= 1000000 ? (total / 1000000).toFixed(1) + 'M' :
                                    total >= 1000 ? (total / 1000).toFixed(1) + 'K' : total,
                                style: {
                                    fontSize: '10px',
                                    fontWeight: 'bold',
                                    color: '#000000',
                                
                                },
                                offsetY: -10
                            }
                        };
                    })
                }
            };

            // Render chart
            const chart = new ApexCharts(document.querySelector("#chartContainer"), chartOptions);
            chart.render();

            // Close modal functionality
            closeButton.onclick = function () {
                modal.style.display = "none";
                chart.destroy(); // Destroy the chart when closing the modal
            };

            // Close modal when clicking outside the modal content
            window.onclick = function (event) {
                if (event.target === modal) {
                    modal.style.display = "none";
                    chart.destroy(); // Destroy the chart when closing the modal
                }
            };

            // Optionally add escape key to close modal
            window.onkeydown = function (event) {
                if (event.key === "Escape") {
                    modal.style.display = "none";
                    chart.destroy(); // Destroy the chart when closing the modal
                }
            };
        }

        let selectedBuyer='';
        function updateChartForBuyer(selectedBuyer) {
            let activeMethod = document.querySelector('.method.active');
            let methodValue = activeMethod ? activeMethod.getAttribute('data-value') : null;

            if (filteredQtyDataarr.length === 0 || Qtycolumnsarr.length === 0) {
                console.error("Data is not loaded yet. Please wait for the AJAX response.");
                return;
            }

            
            if(selectedBuyer == 'one' || selectedBuyer == 'all'){
                if(methodValue == 'tailor' || methodValue == 'owe' ){
                    var singleBuyerData = filteredQtyDataarr.filter(item => item.Unit !== "Total" && item.Unit !== "SUB TOT");

                    var formattedQtyData = singleBuyerData.map(item => ({
                name: item.Unit,
                data: Qtycolumnsarr.map(col => parseInt(item[col]) || 0)
            }));
                }else{
                    var singleBuyerData = filteredQtyDataarr.filter(item => item.Buyer !== "Total");
                    var formattedQtyData = singleBuyerData.map(item => ({
                name: item.Buyer,
                data: Qtycolumnsarr.map(col => parseInt(item[col]) || 0)
            }));
                }
                
                
            }else{
                if(methodValue == 'tailor' || methodValue == 'owe' ){
                    var singleBuyerData = filteredQtyDataarr.filter(item => item.Unit === selectedBuyer);
                    var formattedQtyData = singleBuyerData.map(item => ({
                name: item.Unit,
                data: Qtycolumnsarr.map(col => parseInt(item[col]) || 0)
            }));
                }else{
                    var singleBuyerData = filteredQtyDataarr.filter(item => item.Buyer === selectedBuyer);
                    var formattedQtyData = singleBuyerData.map(item => ({
                name: item.Buyer,
                data: Qtycolumnsarr.map(col => parseInt(item[col]) || 0)
            }));
                }
                
            }
        



            // if(selectedBuyer != 'all'){
            //     var singleBuyerData = filteredQtyDataarr.filter(item => item.Buyer === selectedBuyer);
            // }else{
            //     var singleBuyerData = filteredQtyDataarr.filter(item => item.Buyer !== "Total");
            // }
            
            // var formattedQtyData = singleBuyerData.map(item => ({
            //     name: item.Buyer,
            //     data: Qtycolumnsarr.map(col => parseInt(item[col]) || 0)
            // }));


            chart_{{ $HrbarChart->getId() }}.updateSeries(formattedQtyData);
        }

        document.getElementById('buyerDropdown').addEventListener('click', function (event) {
            const target = event.target;

            
            if (target.tagName === 'A') {
                event.preventDefault(); 
                selectedBuyer = target.getAttribute('data-value'); 
                console.log("Selected Buyer:", selectedBuyer); 
                updateChartForBuyer(selectedBuyer); 
            }
        });

        function populateontime(data){
            let monthValue = data[0].Month; 
            let yearValue = data[0].Year;
            let weekValue = data[0].Week; 
            $('#devlivery_on_time').text(yearValue + '%');

            $('.delivery_month').val(monthValue);
            $('.delivery_year').val(yearValue);
            $('.delivery_week').val(weekValue);
            
        }
        
        function populateckontarget(data){
            let monthValue = data[0].Month; 
            let yearValue = data[0].Year;
            let weekValue = data[0].Week; 
            let targetweekValue = data[0].Prv_Week; 
            let targetmonthValue = data[0].Prv_Month; 
            let targetyearValue = data[0].Prv_Year;
            $('#ck_on_time').text(yearValue + '%');
            $('.target_ck_month').val(targetmonthValue);
            $('.target_ck_year').val(targetyearValue);
            $('.target_ck_week').val(targetweekValue);
            $('.ck_month').val(monthValue);
            $('.ck_year').val(yearValue);
            $('.ck_week').val(weekValue);
            $('.target_prv_ck_week').val(targetweekValue);
            $('.target_prv_ck_month').val(targetmonthValue);
            $('.target_prv_ck_year').val(targetyearValue);
            let prvmonthtarget =  $('.target_prv_ck_year').val();
            let currentmonthtarget =  $('.target_ck_year').val();
            if(parseFloat(prvmonthtarget) > 0){
                $('#ck_target').text( currentmonthtarget);
                    $('#target_ck_on_time_native').css('display','block')
                    $('#target_ck_on_time_pluse').css('display','none')
                    $('.ck_target .cappl-percentage').removeClass('red').addClass('green');

            }
            else if(parseFloat(currentmonthtarget) > parseFloat(prvmonthtarget)){
                
                $('#ck_target').text(currentmonthtarget);
                $('#target_ck_on_time_native').css('display','none')
                $('#target_ck_on_time_pluse').css('display','block')
                $('.ck_target .cappl-percentage').removeClass('red').addClass('green');

                
            }else{
                $('#ck_target').text(currentmonthtarget);
                $('#target_ck_on_time_native').css('display','block')
                $('#target_ck_on_time_pluse').css('display','none')
                $('.ck_target .cappl-percentage').removeClass('green').addClass('red');

            }
        }


        function populateBuyerDropdown(filteredQtyData) {
            const buyerDropdown = document.getElementById("buyerDropdown");
            buyerDropdown.innerHTML = ''; 

            const allItem = document.createElement('li');
            allItem.innerHTML = `<a href="#" data-value="all">ALL</a>`;
            buyerDropdown.appendChild(allItem);

            let activeMethod = document.querySelector('.method.active');
            let methodValue = activeMethod ? activeMethod.getAttribute('data-value') : null;
            console.log(methodValue);
            if(methodValue == 'tailor' || methodValue == 'owe' ){
                console.log(filteredQtyData + 'RAJ');
                const buyers = filteredQtyData.map(item => item.Unit);
                const uniqueBuyers = [...new Set(buyers)];
                uniqueBuyers.forEach(buyer => {
                    const listItem = document.createElement('li');
                    listItem.innerHTML = `<a href="#" data-value="${buyer}">${buyer}</a>`;
                    buyerDropdown.appendChild(listItem);
                });
                
            }else{
                const buyers = filteredQtyData.map(item => item.Buyer);
                const uniqueBuyers = [...new Set(buyers)];
                uniqueBuyers.forEach(buyer => {
                    const listItem = document.createElement('li');
                    listItem.innerHTML = `<a href="#" data-value="${buyer}">${buyer}</a>`;
                    buyerDropdown.appendChild(listItem);
                }); 

            }
        }

        function populateDeliveryTarget(data) {
            let currentMonth = data[0].Month; 
            let currentYear = data[0].Year;
            let currentWeek = data[0].Week; 

            let prevMonth = data[0].Prv_Month; 
            let prevYear = data[0].Prv_Year;
            let prevWeek = data[0].Prv_Week; 

            $('.target_pre_delivery_month').val(prevMonth);
            $('.target_pre_delivery_year').val(prevYear);
            $('.target_pre_delivery_week').val(prevWeek);

            $('.target_delivery_month').val(currentMonth);
            $('.target_delivery_year').val(currentYear);
            $('.target_delivery_week').val(currentWeek);

            
            updateDeliveryDisplay(currentYear, prevYear);
        }

        function updateDeliveryDisplay(current, previous) {
            let currentTarget = parseFloat(current);
            let prevTarget = parseFloat(previous);

            if (isNaN(parseFloat(prevTarget)) || parseFloat(prevTarget) == 0) {
                
                $('#delivery_target').text(prevTarget + '%');
                $('#target_delivery_on_time_native').hide();
                $('#target_delivery_on_time_pluse').show();
                $('#delivery_time_color').removeClass('red').addClass('green');
            } 
            else if (currentTarget >= prevTarget) {
                
                $('#delivery_target').text(prevTarget + '%');                  
                $('#target_delivery_on_time_native').hide();
                $('#target_delivery_on_time_pluse').show();
                $('#delivery_time_color').removeClass('red').addClass('green');
            } 
            else {
                
                $('#delivery_target').text(prevTarget + '%');
                $('#target_delivery_on_time_native').show();
                $('#target_delivery_on_time_pluse').hide();
                $('#delivery_time_color').removeClass('green').addClass('red');
            }
        }

        function showDeliveryChart() {  
            var modal = document.getElementById('deliveryChartModal');  
            modal.style.display = "block";
            document.getElementById('Chart_title_delivery').innerText = 'Delivery Status (In %)';

            setTimeout(() => {
                $.ajax({
                    url: "{{ route('dotaccurancytime') }}",
                    method: "GET",
                    success: function (response) {
                        var ck_actual = response.result.data.ck_actual;

                        if (!ck_actual || ck_actual.length === 0) {
                            $("#delivery_actualtable").html("<p>No data available.</p>");
                            return;
                        }

                        let tableHtmlDelivery = `
                            <table class='table table-hover table-bordered' id='delivery_actuallist'>
                                <thead>
                                    <tr>
                                        ${Object.keys(ck_actual[0]).map(key => `<th>${key}</th>`).join('')}
                                    </tr>
                                </thead>
                                <tbody>
                                    ${ck_actual.map(row => `
                                        <tr>
                                            ${Object.entries(row).map(([key, value]) => `
                                                ${key === 'Order_No' 
                                                    ? `<td>${value}</td>` 
                                                    : `<td>${value}</td>`
                                                }
                                            `).join('')}
                                        </tr>
                                    `).join('')}                               
                                </tbody>
                            </table>
                        `;

                        $("#delivery_actualtable").html(tableHtmlDelivery);

                        $('#delivery_actuallist').css('font-size', '10px');
                        $('#delivery_actuallist th, #delivery_actuallist td').css('padding', '4px 6px');

                        $.getScript("https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js", function () {
                            $('#delivery_actuallist').DataTable({
                                paging: false,
                                searching: true,
                                ordering: false
                            });
                        });

                        var accurancyData = response.result.data.accurancytime;

                        var categories = accurancyData
                            .map(item => item.Buyer)
                            .filter(buyer => buyer !== '');

                        var months = Object.keys(accurancyData[0])
                            .filter(key => !['Buyer', 'Total', 'Slno', ''].includes(key));

                        var seriesData = months.map(month => ({
                            name: month,
                            data: accurancyData
                                .filter(item => item.Buyer !== '')
                                .map(item => parseFloat(item[month]) || 0)
                        }));

                        var options = {
                            chart: {
                                type: 'area',
                                height: '100%',
                                toolbar: { show: true },
                                events: {
                                    dataPointSelection: function (event, chartContext, config) {
                                        var seriesName = config.w.config.series[config.seriesIndex].name;
                                        var value = config.w.config.series[config.seriesIndex].data[config.dataPointIndex];
                                    }
                                }
                            },
                            series: seriesData,
                            xaxis: {
                                categories: categories,
                                title: { text: 'Months' }
                            },
                            yaxis: {
                                title: { text: 'Accuracy (%)' }
                            },
                            dataLabels: {
                                enabled: true,
                                style: {
                                    fontSize: '12px',
                                    colors: ['#000']
                                },
                                offsetY: -5,
                                formatter: function (value) {
                                    return value.toFixed(2) + '%';
                                }
                            },
                            tooltip: {
                                y: {
                                    formatter: function (value) {
                                        return value.toFixed(2) + '%';
                                    }
                                }
                            }
                        };

                        if (window.deliveryChart) {
                            window.deliveryChart.destroy();
                        }

                        window.deliveryChart = new ApexCharts(
                            document.querySelector("#modalDeliveryChartContainer"),
                            options
                        );
                        window.deliveryChart.render();
                    },
                    error: function () {
                        alert("Error fetching chart data.");
                    }
                });
            }, 100);
        }

        $('#full_screen').click(function () {
            let activeCalender = document.querySelector('.calender.active');
            let calenderValue = activeCalender ? activeCalender.getAttribute('data-value') : null;

            // Get the active method item
            let activeMethod = document.querySelector('.method.active');
            let methodValue = activeMethod ? activeMethod.getAttribute('data-value') : null;

            // Capitalize the first letter of calenderValue
            if (calenderValue) {
                calenderValue = calenderValue.charAt(0).toUpperCase() + calenderValue.slice(1);
            }

            // Capitalize the first letter of methodValue
            if (methodValue) {
                methodValue = methodValue.charAt(0).toUpperCase() + methodValue.slice(1);
            }

            // Update the chart title
            $('#Chart_title').text('');
            $('#Chart_title').text(calenderValue + ' ' + methodValue);

            //console.log(calenderValue + ' ' + methodValue);


            if(selectedBuyer==''){
                updateChartForBuyerNew('one');
            }else{
                updateChartForBuyerNew(selectedBuyer);
            }
        });
        document.addEventListener("DOMContentLoaded", function () {
            const activeItem = document.querySelector(".dropdown-item.method.active");
            if (activeItem) {
                activeItem.click(); 
            } else {
                console.log("Active item not found!");
            }
        }); 


        $(document).ready(function () {
            $('.chartfour').on('click', function () {

                let dataType = $(this).data('type'); 
                $('.chartfour').removeClass('active');
                $(this).addClass('active');
                if(dataType == 'M'){
                let  monthValue = $('.delivery_month').val();
                let  ckmonthValue = $('.ck_month').val();
                    $('#devlivery_on_time').text(monthValue + '%');
                    $('#ck_on_time').text(ckmonthValue + '%');
                    let prvmonthtarget =  $('.target_prv_ck_month').val();
                    let currentmonthtarget =  $('.target_ck_month').val();
                    if(parseFloat(prvmonthtarget) > 0){
                        $('#ck_target').text( currentmonthtarget);
                        $('#target_ck_on_time_native').css('display','block')
                        $('#target_ck_on_time_pluse').css('display','none')
                        $('#ck_time_color').removeClass('red').addClass('green');

                    }else if(parseFloat(currentmonthtarget) > parseFloat(prvmonthtarget)){
                       
                        $('#ck_target').text(currentmonthtarget);
                        $('#target_ck_on_time_native').css('display','none')
                        $('#target_ck_on_time_pluse').css('display','block')
                        $('#ck_time_color').removeClass('red').addClass('green');

                        
                    }else{
                        
                        $('#ck_target').text(currentmonthtarget);
                        $('#target_ck_on_time_native').css('display','block')
                        $('#target_ck_on_time_pluse').css('display','none')
                        $('#ck_time_color').removeClass('green').addClass('red');

                    }
                }
                if(dataType == 'W'){
                let  monthValue = $('.delivery_week').val();
                let  ckmonthValue = $('.ck_week').val();
                    $('#devlivery_on_time').text(monthValue + '%');
                    $('#ck_on_time').text(ckmonthValue + '%');

                    let prvmonthtarget =  $('.target_prv_ck_week').val();
                    let currentmonthtarget =  $('.target_ck_week').val();
                    //console.log(prvmonthtarget);
                // alert('1235');
                    if (isNaN(parseFloat(prvmonthtarget)) || parseFloat(prvmonthtarget) == 0) {
                        $('#ck_target').text(currentmonthtarget);
                        $('#target_ck_on_time_native').css('display', 'block');
                        $('#target_ck_on_time_pluse').css('display', 'none');
                        $('#ck_time_color').removeClass('red').addClass('green');
                    }
                    else if(parseFloat(currentmonthtarget) > parseFloat(prvmonthtarget)){
                        
                        $('#ck_target').text(currentmonthtarget);
                        $('#target_ck_on_time_native').css('display','none')
                        $('#target_ck_on_time_pluse').css('display','block')
                        $('#ck_time_color').removeClass('red').addClass('green');
                    }
                    else{
                        
                        $('#ck_target').text(currentmonthtarget);
                        $('#target_ck_on_time_native').css('display','none')
                        $('#target_ck_on_time_pluse').css('display','block')
                        $('#ck_time_color').removeClass('red').addClass('green');

                    }
                }
                if(dataType == 'Y'){
                let  monthValue = $('.delivery_year').val();
                let  ckmonthValue = $('.ck_year').val();
                    $('#devlivery_on_time').text(monthValue + '%');
                    $('#ck_on_time').text(ckmonthValue + '%');

                    let prvmonthtarget =  $('.target_prv_ck_year').val();
                    let currentmonthtarget =  $('.target_ck_year').val();
                    if(parseFloat(currentmonthtarget) > parseFloat(prvmonthtarget)){
                        
                        $('#ck_target').text(currentmonthtarget);
                        $('#target_ck_on_time_native').css('display','none')
                        $('#target_ck_on_time_pluse').css('display','block')
                        $('#ck_time_color').removeClass('red').addClass('green');
                    }else{
                        $('#ck_target').text(currentmonthtarget);
                        $('#target_ck_on_time_native').css('display','block')
                        $('#target_ck_on_time_pluse').css('display','none')
                        $('#ck_time_color').removeClass('green').addClass('red');
                    }
                }
                
            });
        });

        document.getElementById('close-btn').addEventListener('click', function () {
            document.getElementById('ckchartModal').style.display = 'none'; // Or use appropriate logic
        });
        document.getElementById('close-delivery-btn').addEventListener('click', function () {
            document.getElementById('deliveryChartModal').style.display = 'none';
        });

        $(document).ready(function () {
            $('.chartfour').on('click', function () {
                let dataType = $(this).data('type'); 
                $('.chartfour').removeClass('active');
                $(this).addClass('active');

                if (dataType == 'M') {
                    let current = $('.target_delivery_month').val();
                    let previous = $('.target_pre_delivery_month').val();
                    updateDeliveryDisplay(current, previous);
                } 
                else if (dataType == 'W') {
                    let current = $('.target_delivery_week').val();
                    let previous = $('.target_pre_delivery_week').val();
                    updateDeliveryDisplay(current, previous);
                } 
                else if (dataType == 'Y') {
                    let current = $('.target_delivery_year').val();
                    let previous = $('.target_pre_delivery_year').val();
                    updateDeliveryDisplay(current, previous);
                }
            });
        });

        function showAccuracyChart() {
            var modal = document.getElementById('ckchartModal');
            modal.style.display = "block";

            setTimeout(() => {
                $.ajax({
                    url: "{{ route('accurancytime') }}",
                    method: "GET",
                    success: function (response) {
                        var ck_actual = response.result.data.ck_actual;
                        let tableHtmlck = `
                            <table class='table table-hover table-bordered' id='ck_actuallist'>
                                <thead>
                                    <tr>
                                        ${Object.keys(ck_actual[0]).map(key => `<th>${key}</th>`).join('')}
                                    </tr>
                                </thead>
                                <tbody>
                                    ${ck_actual.map(row => `
                                        <tr>
                                            ${Object.entries(row).map(([key, value]) => `
                                                ${key === 'Order_No' 
                                                    ? `<td><a href="#" class="order-popup" data-order="${value}">${value}</a></td>` 
                                                    : `<td>${value}</td>`
                                                }
                                            `).join('')}
                                        </tr>
                                    `).join('')}                               
                                </tbody>
                            </table>
                        `;

                        $("#ck_actualtable").html(tableHtmlck);

                        $('#ck_actuallist').css('font-size', '10px');
                        $('#ck_actuallist th, #ck_actuallist td').css('padding', '4px 6px');


                        $.getScript("https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js", function () {
                            const CkactualTable = $('#ck_actuallist').DataTable({
                                paging: false,
                                searching: true,
                                ordering: false,
                                footerCallback: function (row, data, start, end, display) {}
                            });

                            $('#ck_actuallist thead th').each(function () {
                                const title = $(this).text();
                                $(this).append(`
                                    <br>
                                    <select class="ck_actuallist-column-filter column-filter1 form-control form-select-sm">
                                        <option value="">All</option>
                                    </select>
                                `);
                            });

                            CkactualTable.columns().every(function () {
                                var column = this;
                                var select = $(column.header()).find('select');

                                select.empty().append('<option value="">All</option>');

                                column.data().unique().sort().each(function (d) {
                                    if (d !== "") {
                                        select.append(`<option value="${d}">${d}</option>`);
                                    }
                                });

                                select.on('change', function () {
                                    column.search($(this).val()).draw();
                                });
                            });
                        });

                        var accurancyData = response.result.data.accurancytime;

                        var categories = accurancyData
                            .map(item => item.Buyer)
                            .filter(buyer => buyer !== '');

                        var months = Object.keys(accurancyData[0])
                            .filter(key => !['Buyer', 'Total', 'Slno', ''].includes(key));

                        var seriesData = months.map(month => ({
                            name: month,
                            data: accurancyData
                                .filter(item => item.Buyer !== '')
                                .map(item => parseFloat(item[month]) || 0)
                        }));

                        var options = {
                            chart: {
                                type: 'area',
                                height: '100%',
                                toolbar: { show: true },
                                events: {
                                    dataPointSelection: function (event, chartContext, config) {
                                        var seriesName = config.w.config.series[config.seriesIndex].name;
                                        var value = config.w.config.series[config.seriesIndex].data[config.dataPointIndex];
                                    }
                                }
                            },
                            series: seriesData,
                            xaxis: {
                                categories: categories,
                                title: { text: 'Months' }
                            },
                            yaxis: {
                                title: { text: 'Accuracy (%)' }
                            },
                            dataLabels: {
                                enabled: true,
                                style: {
                                    fontSize: '12px',
                                    colors: ['#000']
                                },
                                offsetY: -5,
                                formatter: function (value) {
                                    return value.toFixed(2) + '%';
                                }
                            },
                            tooltip: {
                                y: {
                                    formatter: function (value) {
                                        return value.toFixed(2) + '%';
                                    }
                                }
                            }
                        };

                        window.chart = new ApexCharts(
                            document.querySelector("#modalChartContainer"),
                            options
                        );
                        window.chart.render();
                    },
                    error: function () {
                        alert("Error fetching chart data.");
                    }
                });
            }, 100);
        }
        $(document).on('click', '.order-popup', function(e) {
            e.preventDefault();
            var orderNo = $(this).data('order');
            let totalKeys = ['Req_Qty', 'Recvd_Qty', 'To_be_Ordered', 'To_be_Recvd','Issued', 'Stock', 'Sup_Po_Qty'];
            let keys = [];

            // Set the modal content
            //$('#orderDetailsContent').html('Loading details for Order No: <strong>' + orderNo + '</strong>');
            orderNo = orderNo.replace(/\\/g, '-');
            const apiUrl = `{{ route('rawmaterialstatus') }}`;
            $.ajax({
                url: apiUrl,
                method: 'GET',
                data: { orderNo: orderNo },                                    
                success: function (response) {
                    let tableHtml = `<table class='table table-hover table-bordered' id='supplyerpotable'>`;

                    if (response.data.length > 0) {
                        const excludeKeys = ['Order_no', 'Item_Group', 'Itemid', 'Colorid', 'Sizeid', 'Ord_Qty', 'Grn_Date', 'Ord_Col', 'Rec_Col', 'O_Slno'];
                        keys = Object.keys(response.data[0]).filter(key => !excludeKeys.includes(key));

                        let totals = {};
                        totalKeys.forEach(key => totals[key] = 0);

                        // Header
                        tableHtml += `<thead><tr>` +
                            keys.map(key => `<th>${key}<br><select class="form-control form-select-sm"><option value="">All</option></select></th>`).join('') +
                            `</tr></thead><tbody>`;

                        // Rows
                        response.data.forEach(row => {
                            tableHtml += "<tr>" +
                                keys.map(key => {
                                    let value = row[key];
                                    if ((key === 'Plan_Date' || key === 'Po_Date') && value) {
                                        const date = new Date(value);
                                        value = `${String(date.getDate()).padStart(2, '0')}/${String(date.getMonth() + 1).padStart(2, '0')}/${date.getFullYear()}`;
                                    }
                                    if (totalKeys.includes(key) && !isNaN(value)) {
                                        totals[key] += parseFloat(value);
                                    }
                                    return `<td>${value !== undefined && value !== null ? value : ''}</td>`;
                                }).join('') +
                                "</tr>";
                        });

                        tableHtml += `</tbody>`;

                        // Footer with classes for totals
                        tableHtml += `<tfoot><tr>` +
                            keys.map(key => totalKeys.includes(key) ? `<th class="total-${key}">${totals[key].toFixed(2)}</th>` : `<th></th>`).join('') +
                            `</tr></tfoot>`;

                    } else {
                        tableHtml += `<thead><tr><th>No data available</th></tr></thead><tbody></tbody>`;
                    }

                    tableHtml += "</table>";

                    $("#orderDetailsContent").html(tableHtml);

                    $('#supplyerpotable').css('font-size', '10px');
                    $('#supplyerpotable th, #supplyerpotable td').css('padding', '4px 6px');

                    var table1 = $('#supplyerpotable').DataTable({
                        paging: false,
                        searching: true,
                        ordering: false,
                        initComplete: function () {
                            this.api().columns().every(function () {
                                var column = this;
                                var select = $('select', column.header());

                                var uniqueValues = [];
                                column.data().unique().sort().each(function (d) {
                                    if (d) uniqueValues.push(d.trim());
                                });

                                uniqueValues.forEach(function (d) {
                                    select.append(`<option value="${d}">${d}</option>`);
                                });

                                select.on('change', function () {
                                    var val = $.fn.dataTable.util.escapeRegex($(this).val());
                                    column
                                        .search(val ? '^' + val + '$' : '', true, false)
                                        .draw();
                                });
                            });
                        }
                    });

                    // Recalculate totals on draw (filter/search)
                    table1.on('draw', function () {
                        totalKeys.forEach(function (key) {
                            let colIndex = keys.indexOf(key);
                            let total = table1.column(colIndex, { search: 'applied' }).data().reduce(function (a, b) {
                                let x = parseFloat(a) || 0;
                                let y = parseFloat(b) || 0;
                                return x + y;
                            }, 0);
                            $(`.total-${key}`).html(total.toFixed(2));
                        });
                    });

                    // Trigger the first calculation
                    table1.draw();
                },

                error: function (xhr, status, error) {
                    console.error('Error:', error);
                }
            });

            // Optionally, you can make an AJAX call here to fetch and display more details.

            // Show the modal (Bootstrap 5)
            var orderModal = new bootstrap.Modal(document.getElementById('orderDetailsModal'));
            orderModal.show();
        });

    </script>

    <script>
        $(document).ready(function() {
            loadChartData('Presentation'); // Load default chart

            // Handle dropdown change event
            $('#chartTypeSelector').change(function() {
                var selectedChart = $(this).val();
                loadChartData(selectedChart);
            });
        });

        // Initialize ApexCharts options
        var optionspred = {
            chart: {
                type: 'area',
                height: 420,
                toolbar: { show: true },
                zoom: { enabled: true },
                animations: { enabled: false },
                selection: { enabled: true },
                sparkline: { enabled: false },
                events: {
                    markerClick: function(event, chartContext, { seriesIndex, dataPointIndex }) {
                        var selectedUnit = chartContext.w.globals.categoryLabels[dataPointIndex]; 
                        var selectedMonth = chartContext.w.config.series[seriesIndex].name; 
                        var chartTypeSelector=$('#chartTypeSelector').val();
                        var urldt = $('#chartTypeSelector').val() === "Presentation"
                            ? "{{ route('presentation_checking_date') }}"
                            : "{{ route('endline_checking_date') }}"; 
                        $.ajax({
                            url: urldt,
                            method: 'GET',
                            data: { Unit: selectedUnit, selectedMonth: selectedMonth },
                            success: function(response) {
                                $(".modal-backdrop").remove();
                                $("body").removeClass("modal-open");
                                
                                $("#finalDetailsTitle").text(`${chartTypeSelector} Checking Details -  ${selectedUnit}`);
                                $('#date_note').text('Current month selected by default');

                                let tableHtml = `<table class='table table-hover table-bordered' id='processpotable2'>
                                    <thead><tr>` +
                                    Object.keys(response.data.datewish[0]).map(key => `<th>${key}<br><select style="width: 100%;"><option value="">All</option></select></th>`).join('') +
                                    `</tr></thead><tbody>`;

                                response.data.datewish.forEach(row => {
                                    tableHtml += "<tr>" + Object.entries(row).map(([key, value]) => {
                                        return key === 'Edate' 
                                            ? `<td><a href='' class='defectcheck' data-optdate='${value}' data-unit='${selectedUnit}'>${value}</a></td>` 
                                            : `<td>${value}</td>`;
                                    }).join('') + "</tr>";
                                });
                                                

                                tableHtml += `</tbody><tfoot><tr>` + 
                                    Object.keys(response.data.datewish[0]).map(() => `<th></th>`).join('') + 
                                    `</tr></tfoot></table>`;

                                $("#finalDetailsContent").html(tableHtml);

                                $.getScript("https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js", function() {
                                    var table = $('#processpotable2').DataTable({
                                        paging: false,
                                        searching: true,
                                        ordering: false,
                                        rowCallback: function(row, data) {
                    // Find the column index for "Slno"
                    var slnoColumnIndex = null;
                    $('#processpotable2 thead th').each(function(index) {
                        if ($(this).text().trim().startsWith("Slno")) {
                            slnoColumnIndex = index;
                        }
                    });

                    // Apply bold if "Slno" is 2
                    if (slnoColumnIndex !== null && data[slnoColumnIndex] == "2") {
                        $(row).css({
                            "font-weight": "bold",
                            "background-color": "#f8f9fa" // Optional: Light background for better visibility
                        });
                    }},
                                        initComplete: function () {
                                            var api = this.api();

                                            // Get current month-year in 'MMM-YYYY' format
                                            var currentDate = new Date();
                                            var currentMonthYear = currentDate.toLocaleString('en-us', { month: 'short', year: 'numeric' });

                                            // Apply default filter on "Mon_Name" column dynamically
                                            var monNameColumnIndex = api.column(':contains("Mon_Name")').index(); 
                                            if (monNameColumnIndex !== undefined) {
                                                api.column(monNameColumnIndex).search(currentMonthYear).draw();
                                            }

                                            api.columns().every(function () {
                                                var column = this;
                                                var select = $('select', column.header());
                                                var uniqueValues = [];

                                                column.data().unique().sort().each(function (d) {
                                                    if (d !== null && d !== undefined && d !== '') {
                                                        if (!uniqueValues.includes(d)) {
                                                            uniqueValues.push(d);
                                                        }
                                                    }
                                                });

                                                uniqueValues.forEach(d => {
                                                    select.append(`<option value="${d}">${d}</option>`);
                                                });

                                                select.on('change', function () {
                                                    var val = $.fn.dataTable.util.escapeRegex($(this).val());
                                                    column.search(val ? '^' + val + '$' : '', true, false).draw();
                                                });
                                            });
                                        }
                                    });
                                });


                                $("#finalDetailsModal").modal("show");
                            },
                            error: function(xhr, status, error) {
                                console.error('Error:', error);
                            }
                        });
                    }
                }
            },
            series: [],
            xaxis: {
                categories: [],
                title: { text: "Overall Defect (%)" }
            },
            dataLabels: {
                enabled: true,
                style: { fontSize: '12px', colors: ['#000'] }
            }
        };

        // Render chart
        var chartpred = new ApexCharts(document.querySelector("#efficiencyChart"), optionspred);
        chartpred.render();

        // Function to load chart data dynamically
        function loadChartData(chartType) {
            var url = chartType === "Presentation"
                ? "{{ route('quality.Presentationquality') }}"
                : "{{ route('quality.Endlinequality') }}"; 
            $.ajax({
                url: url,
                method: "GET",
                success: function(response) {
                    console.log("Chart Data:", response.result.data);

                    var categories = response.result.data.presentation
                        .map(item => item.Unit)
                        .filter(unit => unit !== '');

                    var months = Object.keys(response.result.data.presentation[0])
                        .filter(key => key !== 'Unit' && key !== 'Avg' && key !== 'Slno' && key !== '');

                    var seriesData = months.map(month => ({
                        name: month,
                        data: response.result.data.presentation
                            .filter(item => item.Unit !== '')
                            .map(item => parseFloat(item[month]) || 0)
                    }));

                    console.log(categories);
                    console.log(seriesData);

                    chartpred.updateOptions({
                        xaxis: { categories: categories },
                        series: seriesData
                    });
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching Chart Data:", error);
                }
            });
        }

        $(document).on('click', '.defectcheck', function(e) {
            e.preventDefault();
            var optdate = $(this).data('optdate');
            var UnitID = $(this).data('unit'); // Corrected from selectedUnit
            var chartTypeSelector=$('#chartTypeSelector').val();
            const apiUrl = chartTypeSelector === "Presentation"
                ? "{{ route('presentationocnwise') }}"
                : "{{ route('endlinecheckocnwise') }}"; 
            
            $("#DefectDetailsModalLabel").text(`${chartTypeSelector} Checking Details -  ${optdate} and ${UnitID}`);
            $.ajax({
                url: apiUrl,
                method: 'GET',
                data: { optdate: optdate, Unit: UnitID },                                    
                success: function (response) {
                    let tableHtml = `<table class='table table-hover table-bordered' id='presentationchk'>
                        <thead><tr>` +
                        Object.keys(response.data.datewish[0]).map(key => 
                            `<th>${key}<br><select style="width: 100%;"><option value="">All</option></select></th>`
                        ).join('') +
                        `</tr></thead><tbody>`;

                    response.data.datewish.forEach(row => {
                        tableHtml += "<tr>" + Object.entries(row).map(([key, value]) => {
                            return key === 'Order_No' 
                                ? `<td><a href='' class='defectdetailcheck' data-ocn='${value}' data-optdate='${optdate}' data-unit='${UnitID}'>${value}</a></td>` 
                                : `<td>${value}</td>`;
                        }).join('') + "</tr>";
                    });

                    tableHtml += `</tbody><tfoot><tr>` + 
                        Object.keys(response.data.datewish[0]).map(() => `<th></th>`).join('') + 
                        `</tr></tfoot></table>`;

                    $("#DefectDetailsContent").html(tableHtml);
                    $('#presentationchk').css('font-size', '10px');
                    $('#presentationchk th, #supplyerpotable td').css('padding', '4px 6px');

                    //clear 
                    $("#DefectOcnDetailsModalLabel").text('');
                    $('#OcnDefectDetailsContent').text('');

                    // Correct DataTable ID here
                    $.getScript("https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js", function() {
                        $('#presentationchk').DataTable({ // Corrected from #processpotable2
                            paging: false,
                            searching: true,
                            ordering: false,
                            initComplete: function () {
                                this.api().columns().every(function () {
                                    var column = this;
                                    var select = $('select', column.header());
                                    var uniqueValues = [];

                                    column.data().unique().sort().each(function (d) {
                                        if (d !== null && d !== undefined && d !== '') {
                                            if (!uniqueValues.includes(d)) {
                                                uniqueValues.push(d);
                                            }
                                        }
                                    });

                                    uniqueValues.forEach(d => {
                                        select.append(`<option value="${d}">${d}</option>`);
                                    });

                                    select.on('change', function () {
                                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                                    });
                                });
                            }
                        });
                    });

                    // Show the modal (placed inside success function)
                    var orderModal = new bootstrap.Modal(document.getElementById('DefectDetailsModal'));
                    orderModal.show();
                },
                error: function(xhr, status, error) {
                    console.error('Error:', error);
                }
            });
        });

        $(document).on('click', '.defectdetailcheck', function(e) {
            e.preventDefault();
            var ocnno = $(this).data('ocn');
            var optdate = $(this).data('optdate');
            var UnitID = $(this).data('unit'); // Corrected from selectedUnit
            var chartTypeSelector=$('#chartTypeSelector').val();
            const apiUrl = chartTypeSelector === "Presentation"
                ? "{{ route('presentationocnwisedef') }}"
                : "{{ route('endlinecheckocnwisedef') }}"; 
            
            $("#DefectOcnDetailsModalLabel").text(`Defect Details -  ${ocnno}`);
            $.ajax({
                url: apiUrl,
                method: 'GET',
                data: { optdate: optdate, Unit: UnitID, Ocnno:ocnno},                                    
                success: function (response) {
                    let tableHtml = `<table class='table table-hover table-bordered' id='presentationchkdef'>
                        <thead><tr>` +
                        Object.keys(response.data.datewish[0]).map(key => 
                            `<th>${key}<br><select style="width: 100%;"><option value="">All</option></select></th>`
                        ).join('') +
                        `</tr></thead><tbody>`;

                    response.data.datewish.forEach(row => {
                        tableHtml += "<tr>" + Object.entries(row).map(([key, value]) => {
                            return key === 'Order_No' 
                                ? `<td>${value}</td>` 
                                : `<td>${value}</td>`;
                        }).join('') + "</tr>";
                    });

                    tableHtml += `</tbody><tfoot><tr>` + 
                        Object.keys(response.data.datewish[0]).map(() => `<th></th>`).join('') + 
                        `</tr></tfoot></table>`;

                    $("#OcnDefectDetailsContent").html(tableHtml);
                    $('#presentationchkdef').css('font-size', '10px');
                    $('#presentationchkdef th').css('padding', '4px 6px');

                    // Correct DataTable ID here
                    $.getScript("https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js", function() {
                        $('#presentationchkdef').DataTable({ // Corrected from #processpotable2
                            paging: false,
                            searching: true,
                            ordering: false,
                            initComplete: function () {
                                this.api().columns().every(function () {
                                    var column = this;
                                    var select = $('select', column.header());
                                    var uniqueValues = [];

                                    column.data().unique().sort().each(function (d) {
                                        if (d !== null && d !== undefined && d !== '') {
                                            if (!uniqueValues.includes(d)) {
                                                uniqueValues.push(d);
                                            }
                                        }
                                    });

                                    uniqueValues.forEach(d => {
                                        select.append(`<option value="${d}">${d}</option>`);
                                    });

                                    select.on('change', function () {
                                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                                    });
                                });
                            }
                        });
                    });

                    // Show the modal (placed inside success function)
                    //var orderModal = new bootstrap.Modal(document.getElementById('OcnDefectDetailsModal'));
                    //orderModal.show();
                },
                error: function(xhr, status, error) {
                    console.error('Error:', error);
                }
            });
        });

    </script>
    @endsection
</body>
</html>