<!DOCTYPE html>
<html>
<head>
    <title>Speed Test Result</title>
    <!-- Bootstrap CDN (you can use local if needed) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    

</head>
<body class="p-4">

    <h1>Internet Speed Test Result</h1>

    @if(isset($error))
        <p style="color: red;">Error: {{ $error }}</p>
    @else
        <p><strong>Download Speed:</strong> {{ $download_speed }} Mbit/s</p>
        <p><strong>Upload Speed:</strong> {{ $upload_speed }} Mbit/s</p>
    @endif

    <!-- Dropdown speedometer -->
    <div class="dropdown mt-5">
        <a class="nav-link" id="speedometer-btn" data-bs-toggle="dropdown" aria-expanded="false" href="#">
            <i class="bi bi-speedometer2 fs-1 text-primary"></i>
        </a>
        <ul class="dropdown-menu dropdown-menu-center p-3 shadow" style="min-width: 200px;">
            <li><strong>Speed Test</strong></li>
            <li class="text-muted" id="client_download-speed">Download: Testing...</li>
            <li class="text-muted" id="client_upload-speed">Upload: Testing...</li>
        </ul>
    </div>

    <!-- Script Section -->
<script>
    // async function testSpeed() {
    //     const downloadText = document.getElementById("client_download-speed");
    //     const uploadText = document.getElementById("client_upload-speed");

    //     downloadText.innerText = "Download: Testing...";
    //     uploadText.innerText = "Upload: Testing...";
    //     alert('test');
        
    //     const connection = new RTCPeerConnection({ iceServers: [{ urls: "stun:stun.l.google.com:19302" }] });
    //         connection.createDataChannel("dummy");

    //         await connection.setLocalDescription(await connection.createOffer());

    //         const start = performance.now();
    //         await new Promise(res => setTimeout(res, 2000));
    //         const end = performance.now();
    //         connection.close();

    //         const duration = (end - start) / 1000;
    //         const downloadSpeed = (Math.random() * (300 - 100) + 100).toFixed(2);
    //         const uploadSpeed = (downloadSpeed * 0.8).toFixed(2);

    //         downloadText.innerText = `Download: ${downloadSpeed} Mbps`;
    //         uploadText.innerText = `Upload: ${uploadSpeed} Mbps`;

    //         // 🛰️ Send to Laravel route that triggers server speed + stores everything
            


    //         const response = await fetch("/logClientSpeed", {
    //             method: "POST",
    //             headers: {
    //                 "Content-Type": "application/json",
    //                 "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute("content")
    //             },
    //             body: JSON.stringify({
    //                 client_download_speed: parseFloat(downloadSpeed),
    //                 client_upload_speed: parseFloat(uploadSpeed)
    //             })
    //         });

    //         const data = await response.json();
    //         console.log(data.message || data.error);

    //         if (data.server_download_speed && data.server_upload_speed) {
    //             console.log(`Server Download: ${data.server_download_speed} Mbps`);
    //             console.log(`Server Upload: ${data.server_upload_speed} Mbps`);
    //         }
        
    //     try {
    //         // Fake test using WebRTC
            
    //         const connection = new RTCPeerConnection({ iceServers: [{ urls: "stun:stun.l.google.com:19302" }] });
    //         connection.createDataChannel("dummy");

    //         await connection.setLocalDescription(await connection.createOffer());

    //         const start = performance.now();
    //         await new Promise(res => setTimeout(res, 2000));
    //         const end = performance.now();
    //         connection.close();

    //         const duration = (end - start) / 1000;
    //         const downloadSpeed = (Math.random() * (300 - 100) + 100).toFixed(2);
    //         const uploadSpeed = (downloadSpeed * 0.8).toFixed(2);

    //         downloadText.innerText = `Download: ${downloadSpeed} Mbps`;
    //         uploadText.innerText = `Upload: ${uploadSpeed} Mbps`;

    //         // 🛰️ Send to Laravel route that triggers server speed + stores everything
            


    //         const response = await fetch("/logClientSpeed", {
    //             method: "GET",
    //             headers: {
    //                 "Content-Type": "application/json",
    //                 "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute("content")
    //             },
    //             body: JSON.stringify({
    //                 client_download_speed: parseFloat(downloadSpeed),
    //                 client_upload_speed: parseFloat(uploadSpeed)
    //             })
    //         });

    //         const data = await response.json();
    //         console.log(data.message || data.error);

    //         if (data.server_download_speed && data.server_upload_speed) {
    //             console.log(`Server Download: ${data.server_download_speed} Mbps`);
    //             console.log(`Server Upload: ${data.server_upload_speed} Mbps`);
    //         }

           

    //     } catch (error) {
    //         downloadText.innerText = "Download: Error";
    //         uploadText.innerText = "Upload: Error";
    //         console.error("Speed test error:", error);
    //     }
    // }

    async function testSpeed() {
        const downloadText = document.getElementById("client_download-speed");
        const uploadText = document.getElementById("client_upload-speed");

        downloadText.innerText = "Download: Testing...";
        uploadText.innerText = "Upload: Testing...";

        try {
            // WebRTC dummy connection to simulate delay
            const connection = new RTCPeerConnection({ iceServers: [{ urls: "stun:stun.l.google.com:19302" }] });
            connection.createDataChannel("dummy");
            await connection.setLocalDescription(await connection.createOffer());
            const start = performance.now();
            await new Promise(res => setTimeout(res, 2000));
            const end = performance.now();
            connection.close();

            // Simulated speed data
            const downloadSpeed = (Math.random() * (300 - 100) + 100).toFixed(2);
            const uploadSpeed = (downloadSpeed * 0.8).toFixed(2);
            downloadText.innerText = `Download: ${downloadSpeed} Mbps`;
            uploadText.innerText = `Upload: ${uploadSpeed} Mbps`;

            // Get client IP from external API
            const ipRes = await fetch("https://api.ipify.org?format=json");
            const ipData = await ipRes.json();
            const ipAddress = ipData.ip;

            // Send all data to backend
            const response = await fetch("/logClientSpeed", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute("content")
                },
                body: JSON.stringify({
                    client_download_speed: parseFloat(downloadSpeed),
                    client_upload_speed: parseFloat(uploadSpeed),
                    ip_address: ipAddress
                })
                
            });

            console.log("Data sent to backend:", {
                    client_download_speed: downloadSpeed,
                    client_upload_speed: uploadSpeed,
                    ip_address: ipAddress
                });

            const data = await response.json();
            console.log(data.message || data.error);

            if (data.server_download_speed && data.server_upload_speed) {
                console.log(`Server Download: ${data.server_download_speed} Mbps`);
                console.log(`Server Upload: ${data.server_upload_speed} Mbps`);
            }

        } catch (error) {
            downloadText.innerText = "Download: Error";
            uploadText.innerText = "Upload: Error";
            console.error("Speed test error:", error);
        }
    }

    window.onload = function () {
        testSpeed();

        const dropdownMenu = document.querySelector('.dropdown-menu');
        dropdownMenu.classList.add('show');
        document.getElementById('speedometer-btn').setAttribute('aria-expanded', 'true');
    };
</script>



    <!-- Bootstrap Bundle JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
