<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Quality Dashboard</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"/>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/flatpickr@4.6.13/dist/flatpickr.min.js"></script>
  <link href="https://cdn.jsdelivr.net/npm/flatpickr@4.6.13/dist/flatpickr.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
  <!-- Include Bootstrap CSS and JS for dropdown functionality -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <style>
    body {
      background-color: #f0f2f5;
      font-family: "Segoe UI", sans-serif;
    }
    .card {
      border: none;
      border-radius: 12px;
      box-shadow: 0 4px 20px rgba(0, 0, 0, 0.04);
    }
    .table td,
    .table th {
      vertical-align: middle;
    }
    #tabOutput .table th{
      font-weight: normal;
      color: gray;
    }
    
    .icon-btn {
      background: none;
      border: none;
      cursor: pointer;
      padding: 0.25rem 0.5rem;
      font-size: 1rem;
    }
    .icon-btn.active {
      color: #0d6efd;
      font-weight: bold;
    }

    
    .view-table,
    #chart-container {
      display: none;
    }
    .view-table.active,
    #chart-container.active {
      display: block;
    }
    /* Hover effect for table rows in Unit Summary */
    .table tbody tr:hover {
      background-color: #f5f5f5;
      transition: background-color 0.2s ease;
    }
    /* Styles for Defect Analysis tabs */
    .defect-tabs {
      display: inline-flex;
      background-color: #e9ecf2;
      padding: 4px;
      border-radius: 10px;
    }
    .defect-tab {
      display: flex;
      align-items: center;
      gap: 6px;
      padding: 6px 14px;
      border-radius: 8px;
      color: #4b4f56;
      font-weight: 500;
      font-size: 0.95rem;
      text-decoration: none;
      transition: all 0.2s ease-in-out;
    }
    .defect-tab:hover {
      background-color: #d6dbe3;
      text-decoration: none;
    }
    .defect-tab.active {
      background-color: #0d1442;
      color: #fff !important;
    }
    .defect-tab i {
      font-size: 1rem;
    }
    .icon-bar {
      font-size: 1.1rem;
      color: #6c757d;
    }
    .dashboard-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 0.5rem;
    }
    .date-picker-container {
      display: flex;
      align-items: center;
      gap: 0.5rem;
    }
    .date-picker-input {
      border: 1px solid #ced4da;
      border-radius: 4px;
      padding: 0.25rem 0.5rem;
      font-size: 0.9rem;
      width: 220px;
    }
    .calendar-icon {
      font-size: 1.2rem;
      cursor: pointer;
      color: #6c757d;
    }
    .calendar-icon:hover {
      color: #0d6efd;
    }
    /* .table.table-sm.table-bordered tbody tr.highlight {
      border: blue 2px solid !important;
    } */
    .table tbody tr.highlight {
      position: relative;
      background: linear-gradient(90deg, #e6f0ff 0%, #f5faff 100%);
      box-shadow: inset 4px 0 0 #0d6efd;  
      font-weight: 600;
      color: #0a1f44;
      transition: all 0.2s ease-in-out;
      z-index: 1;
    }

    .table tbody tr.highlight td {
      background-color: transparent;  
    }

    
    .table tbody tr:hover {
      background-color: #f0f4ff;
      transition: background-color 0.2s ease-in-out;
      cursor: pointer;
    }

    .table-container {
      height: 280px; /* Fixed height for the table container */
      overflow-y: hidden; /* Hide scrollbar by default */
      position: relative;
    }

    .table-container.expanded {
      overflow-y: auto; /* Enable vertical scrollbar when expanded */
      height: 250px;
    }

    .table-container.expanded table thead {
      position: sticky;
      top: 0;
      background-color: #fff; /* Ensure header background is white */
      z-index: 10; /* Ensure header stays above the table body */
    }

    .view-more-link {
      position: absolute;
      bottom: 20px; /* Position at the bottom of the card */
      margin-top: 10px;
      right: 30px; /* Position at the right of the card */
      font-size: 0.85rem;
      color: #0d6efd; /* Bootstrap primary blue */
      text-decoration: underline;
      cursor: pointer;
      z-index: 20; /* Ensure it stays above the table */
    }

    .view-more-link:hover {
      color: #0056b3; /* Darker blue on hover */
      text-decoration: none;
    }

    .heatmap-container {
        overflow-x: auto;
        margin: 20px 0;
        max-width: 100%;
    }
    .heatmap-scroll-container {
        overflow-x: auto;
        max-width: 100%;
    }
    .heatmap-wrapper {
        min-width: 100%;
    }
    .heatmap-table {
        
        font-size: 14px;
        table-layout: fixed; /* Ensures consistent column widths */
    }
    .heatmap-table th, .heatmap-table td {
        border: 2px solid white;
        padding: 10px;
        text-align: center;
        width: 100px !important;
    }
    .heatmap-table th.sticky-start, .heatmap-table td.sticky-start {
        position: sticky;
        left: 0;
        background: #f8f9fa;
        z-index: 4; /* Highest z-index for Line column */
        width: 100px; /* Fixed width for Line column */
    }
    .heatmap-table th.sticky-second, .heatmap-table td.sticky-second {
        position: sticky;
        left: 50px; /* Offset by Line column width */
        background: #f8f9fa;
        z-index: 3; /* Below Line column but above other cells */
        width: 100px; /* Fixed width for Total/Avg column */
    }
    .heatmap-table th {
        background: #f8f9fa;
        font-weight: bold;
        z-index: 2; /* Above body cells */
    }
    .heatmap-table td > div {
        display: block;
        text-align: center;
    }
    .heatmap-table td .checked-value {
        font-size: 0.85em;
        
    }
    .sticky-start {
        position: sticky;
        left: 0;
        background: #f8f9fa;
        z-index: 2;
    }
  
    .alert {
        padding: 15px;
        margin: 20px 0;
        border-radius: 4px;
    }
    .alert-warning {
        background-color: #fff3cd;
        border: 1px solid #ffeeba;
        color: #856404;
    }
    .heatmap_title {
        font-size: 1.2rem;
        margin-bottom: 10px;
    }
    .heatmap-title-select {
        color: blue;
        cursor: pointer;
    }
    .heatmap-table td.clickable {
        cursor: pointer;
    }
    .heatmap-table td.clickable:hover {
        background-color: rgba(0, 0, 0, 0.1);
    }
    .cell-good { background-color: #bbf3d3 !important; color: green !important }
    .cell-warning { background-color: #fff48c !important; color: brown !important }
    .cell-poor { background-color: #fecaca !important; color: maroon  !important} /* #fedcb9 - peach */
    .cell-empty { background-color: #ffffff !important; color:#000 !important}

    .switch {
      position: relative;
      display: inline-block;
      width: 60px;
      height: 25px;
      font-family: Arial, sans-serif;
      font-size: 12px;
    }

    .switch input {
      opacity: 0;
      width: 0;
      height: 0;
    }

    .slider {
      position: absolute;
      cursor: pointer;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background-color: #ccc;
      transition: .4s;
      border-radius: 25px;
    }

    .slider:before {
      position: absolute;
      content: "End";
      height: 21px;
      width: 34px;
      left: 2px;
      bottom: 2px;
      background-color: white;
      color: #000;
      text-align: center;
      line-height: 21px;
      transition: .4s;
      border-radius: 20px;
      font-weight: bold;
      font-size: 12px;
    }

    input:checked + .slider {
      background-color: #2196F3;
    }

    input:focus + .slider {
      box-shadow: 0 0 1px #2196F3;
    }

    input:checked + .slider:before {
      transform: translateX(22px); /* 60 - knob width (34) - padding (2) = 24px, small fine-tune for better visual */
      content: "Pre";
    }
    
  </style>
  <style>
        
        #preloder {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999999;
            background: #ffffffbd;
            justify-content: center;
            align-items: center;
            display: flex;
        }

        .lds-hourglass,
        .lds-hourglass:after {
            box-sizing: border-box;
        }

        .lds-hourglass {
            display: inline-block;
            position: relative;
            width: 80px;
            height: 80px;
        }

        .lds-hourglass:after {
            content: " ";
            display: block;
            border-radius: 50%;
            width: 0;
            height: 0;
            margin: 8px;
            box-sizing: border-box;
            border: 32px solid currentColor;
            border-color: currentColor transparent currentColor transparent;
            animation: lds-hourglass 1.2s infinite;
        }

        @keyframes lds-hourglass {
            0% {
                transform: rotate(0);
                animation-timing-function: cubic-bezier(0.55, 0.055, 0.675, 0.19);
            }

            50% {
                transform: rotate(900deg);
                animation-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
            }

            100% {
                transform: rotate(1800deg);
            }
        }
        .preloder {
                display: none;
                display: flex;
                justify-content: space-between;
                align-items: center;
                position: fixed;
                width: 100%;
                height: 100%;
                top: 0;
                left: 0;
                z-index: 999999;
                background: #ffffffbd;
                justify-content: center;
                align-items: center;
                display: flex;
            }

            .lds-hourglass,
            .lds-hourglass:after {
                box-sizing: border-box;
            }

            .lds-hourglass {
                display: flex;
                justify-content: space-between;
                align-items: center;
                position: relative;
                width: 80px;
                height: 80px;
            }

            .lds-hourglass:after {
                content: " ";
                display: block;
                border-radius: 50%;
                width: 0;
                height: 0;
                margin: 8px;
                box-sizing: border-box;
                border: 32px solid currentColor;
                border-color: currentColor transparent currentColor transparent;
                animation: lds-hourglass 1.2s infinite;
            }

            @keyframes lds-hourglass {
                0% {
                    transform: rotate(0);
                    animation-timing-function: cubic-bezier(0.55, 0.055, 0.675, 0.19);
                }

                50% {
                    transform: rotate(900deg);
                    animation-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
                }

                100% {
                    transform: rotate(1800deg);
                }
            }

            .sideallign {
                text-align: end !important;
            }
            .view-table {
              display: none;
            }
            .view-table.active {
              display: block;
            }

  </style>
</head>
<body>
  <div class="container-fluid px-4 py-3">
    <div class="dashboard-header d-flex align-items-center justify-content-between px-3 py-2">
      <div class="d-flex align-items-center gap-3">
        <a href="/dashboard" class="btn btn-primary" title="Dashboard">
          <i class="bi bi-house"></i>
        </a>  
        <h3 class="fw-bold fs-5 mb-0">Quality Dashboard - Garments</h3>
      </div>
      <div class="date-picker-container d-flex align-items-center">
        <input type="text" class="date-picker-input form-control me-2" placeholder="Select date range">
        <i class="bi bi-calendar3-range text-dark calendar-icon"></i>
      </div>
    </div>
    <!-- <div id="preloder">
      <div class="lds-hourglass">
      </div>
    </div> -->
    <!-- Unit Summary -->
    <div class="row g-4">
      <div class="col-md-4">
        <div class="card">
          <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0" id="Unit_summary_title">Unit Summary <span class="text-danger fs-6"></span></h5>
            <div>
              <button style="display:none;" class="icon-btn active" data-tab="qty" onclick="switchView('abs')" title="Absolute View">
                Default
              </button>
              <button class="icon-btn d-none" onclick="switchView('delta')" data-tab="delta" title="Delta View (ΔT)">
                △
              </button>
              <button class="icon-btn"  data-tab="unitpercent" title="Percentage View">
                %
              </button>
              <!-- <button class="icon-btn d-none" onclick="switchView('chart')"  title="Chart View">
                📈
              </button> -->
            </div>
          </div>
          <div class="card-body">
            <!-- Absolute View -->
                <div class="table-responsive view-table active">
                  <table id="table-abs" class="table table-sm table-bordered">
                    <thead class="table-light">
                      <tr>
                        <th>Unit</th>
                        <th>FTR</th>
                        <th>Rework</th>
                        <th>Reject</th>
                        <th>Checked</th>
                      </tr>
                    </thead>
                    <tbody>
                      <!-- Populated dynamically via AJAX -->
                    </tbody>
                    
                  </table>
                </div>

                <!-- Delta View -->
                <div class="table-responsive view-table">
                  <table id="table-delta" class="table table-sm table-bordered">
                    <thead class="table-light">
                      <tr>
                        <th>Unit</th>
                        <th>FTR Δ</th>
                        <th>Rework</th>
                        <th>Reject</th>
                        <th>Checked</th>
                      </tr>
                    </thead>
                    <tbody>
                      <!-- Populated dynamically via AJAX -->
                    </tbody>
                    
                  </table>
                </div>

                <!-- Percent View -->
                <div class="table-responsive view-table">
                  <table id="table-percent" class="table table-sm table-bordered">
                    <thead class="table-light">
                      <tr>
                        <th>Unit</th>
                        <th>FTR</th>
                        <th>Rework</th>
                        <th>Reject</th>
                        <th>Checked</th>
                      </tr>
                    </thead>
                    <tbody>
                      <!-- Populated dynamically via AJAX -->
                    </tbody>
                    
                  </table>
                </div>

                <!-- Chart Container -->
                <div id="chart-container" class="mt-4 view-table">
                  <div id="unitChart"></div>
                </div>
              </div>
            </div>
          </div>

          <!-- OCN Summary -->
          <div class="col-md-5">
            <div class="card h-100" id="ocnSummary">
              <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0" id="ocn_summary_title">OCN Summary <span class="text-danger fs-6"> (In Qty)</span></h5>
                <div>
                  <button style="display:none;" id="ocn-abs-btn" class="icon-btn active" data-tab="qty" onclick="switchView('abs')" title="Absolute View">
                    Default
                  </button>
                  <button class="icon-btn d-none" id="ocn-delta-btn" onclick="switchView('delta')" data-tab="delta" title="Delta View (ΔT)">
                    △
                  </button>
                  <button class="icon-btn" id="ocn-percent-btn" data-tab="ocnperc" title="Percentage View">
                    %
                  </button>
                </div>
              </div>
              <div class="card-body" style="max-height: 315px; overflow-y: auto;">
                <div class="table-responsive view-table active">
                  <table class="table table-sm table-bordered" id="ocnTable">
                    <thead style="position: sticky; top: -20px ; z-index: 10" class="table-light">
                      <tr>
                        <th>OCN</th>
                        <th>FTR</th>
                        <th>Rework</th>
                        <th>Reject</th>
                        <th>Checked</th>
                        <th>FI Pass</th>
                      </tr>
                    </thead>
                    <tbody>
                      <td colspan="5" class="text-center">Click on the unit to show details</td>
                    </tbody>
                    <tfoot style="position: sticky; bottom: -20px ; z-index: 10; border-top: 1px solid #dedede;">
                      <tr>
                        <th class="fw-bold">Total</th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                      </tr>
                    </tfoot>
                  </table>
                </div>
                <!-- Percent View -->
                <div class="table-responsive view-table">
                  <table class="table table-sm table-bordered" id="ocnTableperc">
                    <thead style="position: sticky; top: -20px ; z-index: 10" class="table-light">
                      <tr>
                        <th>OCN</th>
                        <th>FTR</th>
                        <th>Rework</th>
                        <th>Reject</th>
                        <th>Checked</th>
                        <th>FI Pass</th>
                      </tr>
                    </thead>
                    <tbody>
                      <td colspan="5" class="text-center">Click on the unit to show details</td>
                    </tbody>
                    <tfoot style="position: sticky; bottom: -20px ; z-index: 10; border-top: 1px solid #dedede;">
                      <tr>
                        <th class="fw-bold">Total</th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                      </tr>
                    </tfoot>
                  </table>
                </div>
              </div>
            </div>
          </div>


          <!-- PO Summary -->
          <div class="col-md-3">
            <div class="card" id="poSummary">
              <div class="card-header">
                <h5>PO Details</h5>
              </div>
              <div class="card-body" style="max-height: 315px; overflow-y: auto; ">
                <table class="table table-sm table-bordered" id="poTable">
                  <thead class="table-light">
                    <tr>
                      <th>PO Number</th>
                      <th>FI Status</th>                
                    </tr>
                  </thead>
                  <tbody>
                    <td colspan="2" class="text-center">Click OCN No for details</td>
                  </tbody>
                </table>
              </div>
            </div>
          </div>


          <!-- Chart & Defect Analysis -->
          <div class="col-md-8">
            <div class="card p-4" id="defectAnalysischart">
              <h5 class="mb-3 fw-semibold">Printing Defect Trend (Unit G1)</h5>
              <p class=" fw-6"> Daily trends (Absolute counts) for printing defects over the last 30 days.</p>
              <div id="trendChart" style="height: 120px;"></div>
                 
            </div>
          </div>
          <div class="col-md-4">
            <div class="card p-4 position-relative h-100" id="defectAnalysis">
              <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0 fw-semibold">Defect Analysis</h5>
                <div class="icon-bar d-flex">
                  <div class="d-flex align-items-center gap-2" id="defect_type_switch">
                    <!-- Rounded switch -->
                    <label class="switch defectswitch me-3">
                      <input type="checkbox" id="defectTypeToggle" >
                      <span class="slider round"></span>
                    </label>
                  </div>

                  <i class="bi bi-percent me-3" id="percentToggle" style="cursor: pointer;"></i>
                  <i class="bi bi-arrow-clockwise" id="reset_defect_table" style="cursor: pointer;"></i>
                </div>
              </div>
              <!-- Defect Tabs -->
              <div class="defect-tabs d-flex justify-content-around align-items-center">
                <a href="#" class="defect-tab active" data-tab="top5">
                  <i class="bi bi-list-check"></i> Top 5
                </a>
                <a href="#" class="defect-tab d-none" data-tab="critical">
                  <i class="bi bi-exclamation-octagon"></i> Critical
                </a>
                <a href="#" class="defect-tab" data-tab="category">
                  <i class="bi bi-record-circle"></i> Category
                </a>
                <a href="#" class="defect-tab d-none" data-tab="all">
                  <i class="bi bi-grid"></i> All
                </a>
              </div>

              <div class="mt-4 position-relative">
                <div id="tabOutput" class="table-container">
                  <!-- Dynamic table will load here -->
                  <div class="spinner-border spinner-border-sm text-primary d-none" role="status" id="defectSpinner">
                    <span class="visually-hidden">Loading...</span>
                  </div>
                </div>
                
              </div>
              <a href="#" id="viewMoreLink" class="view-more-link d-none">View More</a>
            </div>
            
          </div>

          <!-- Heatmap -->

          <div class="container mt-4">
            <div class="card shadow border border-secondary rounded-lg">
              <div class="card-body">
                <div class="d-flex flex-column mb-0">
                  <div class="d-flex justify-content-between align-items-center mb-2">
                    <h6 class="fw-semibold mb-0 heatmap_title">Line wise Heatmap - FTR (Unit G1 - Default)</h6>
                    <div class="d-flex align-items-center gap-2">
                      <div class="spinner-border spinner-border-sm text-primary d-none" role="status" id="heatmapSpinner">
                        <span class="visually-hidden">Loading...</span>
                      </div>
                      <div class="dropdown">
                        <button class="btn btn-sm btn-primary d-flex align-items-center gap-1 px-3" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                          <span class="fw-bold" id="selectedOption">FTR</span>
                          <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path d="M6 9l6 6 6-6" />
                          </svg>
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                          <li><a class="dropdown-item" href="#" data-value="FTR">FTR</a></li>
                          <li><a class="dropdown-item" href="#" data-value="RW">Rework</a></li>
                          <li><a class="dropdown-item" href="#" data-value="RJ">Rejection</a></li>
                        </ul>
                      </div>

                      <div class="d-flex align-items-center gap-2">
                        <button id="heatmap-abs-btn"  style="display:none;" class="heat-icon-btn icon-btn active" onclick="switchHeatmapView('abs')" data-tab="qty" title="Absolute View">
                          Default
                        </button>
                        <button id="heatmap-delta-btn"  class="heat-icon-btn icon-btn d-none" onclick="switchHeatmapView('delta')" data-tab="qty" title="Delta View (ΔT)">
                          △
                        </button>
                        <button id="heatmap-percent-btn"  class="heat-icon-btn icon-btn" onclick="switchHeatmapView('percent')" data-tab="perc" title="Percentage View">
                          %
                        </button>
                      </div>

                      <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" class="text-muted" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path d="M14.106 5.553a2 2 0 0 0 1.788 0l3.659-1.83A1 1 0 0 1 21 4.619v12.764a1 1 0 0 1-.553.894l-4.553 2.277a2 2 0 0 1-1.788 0l-4.212-2.106a2 2 0 0 0-1.788 0l-3.659 1.83A1 1 0 0 1 3 19.381V6.618a1 1 0 0 1 .553-.894l4.553-2.277a2 2 0 0 1 1.788 0z"/>
                        <path d="M15 5.764v15M9 3.236v15"/>
                      </svg>
                    </div>
                  </div>
                </div>

                <!-- Scrollable Heatmap
                <div class="heatmap-scroll-container">
                  <div id="heatmap" class="heatmap-wrapper">
                </div> -->
                <div class="heatmap-scroll-container">
                    <div class="heatmap-wrapper">
                        <div class="heatmap-container">
                            <table class="heatmap-table table-bordered">
                                <thead>
                                    <tr id="heatmapHeader"></tr>
                                </thead>
                                <tbody id="heatmapBody"></tbody>
                            </table>
                        </div>
                        <div id="heatmap"></div>
                    </div>
                    <div class="small text-muted mt-3 d-flex align-items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" class="me-2">
                            <circle cx="12" cy="12" r="10"></circle>
                            <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path>
                            <path d="M12 17h.01"></path>
                        </svg>
                        Cell color indicates daily performance: Green (good), Yellow (warning), Red (poor). Number in ( ) is total checked.
                    </div>
                </div>

              </div>
            </div>
          </div>


  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
<script>
    // Calculate default date range
    let today = new Date();
    let thirtyDaysAgo = new Date();
    thirtyDaysAgo.setDate(today.getDate() - 30);

    // Format dates as DD-MMM-YYYY for API
    let formatDate = (date) => {
        let months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
        return `${String(date.getDate()).padStart(2, '0')}-${months[date.getMonth()]}-${date.getFullYear()}`;
    };
    let defaultStartDate = formatDate(thirtyDaysAgo);
    let defaultEndDate = formatDate(today);

    // Initialize Flatpickr with default date range raj
    flatpickr('.date-picker-input', {
        mode: 'range',
        dateFormat: 'Y-m-d',
        maxDate: 'today',
        defaultDate: [thirtyDaysAgo, today],
        onChange: function(selectedDates, dateStr, instance) {
            if (selectedDates.length === 2) {
                let [fromDate, toDate] = selectedDates;
                let formattedFromDate = instance.formatDate(fromDate, 'd-M-Y');
                let formattedToDate = instance.formatDate(toDate, 'd-M-Y');
                
                fetchUnitSummary(formattedFromDate, formattedToDate, currentType,);
            }
        }
    });

    // Set the input field's value to reflect the default date range
    document.querySelector('.date-picker-input').value = `${defaultStartDate} to ${defaultEndDate}`;

    // Open date picker on calendar icon click
    document.querySelector('.calendar-icon').addEventListener('click', function() {
        document.querySelector('.date-picker-input')._flatpickr.open();
    });

    let currentType = 'qty'; // Default type is 'qty'

    function showLoading(tbody) {
      tbody.innerHTML = `
        <tr>
          <td colspan="5" class="text-center py-3">
            <div class="spinner-border text-primary" role="status">
              <span class="visually-hidden">Loading...</span>
            </div>
          </td>
        </tr>
      `;
    }

    function fetchUnitSummary(fromDate, toDate, type) {
        // let titleElement = document.querySelector('#Unit_summary_title');
        // if (type === 'Perc') {
        //     titleElement.innerHTML = 'Unit Summary <span class="text-danger fs-6"> (In %)</span>';
        // } else if (type === 'delta') {
        //     titleElement.innerHTML = 'Unit Summary <span class="text-danger fs-6"> (In Δ)</span>';
        // } else {
        //     titleElement.innerHTML = 'Unit Summary <span class="text-danger fs-6"> (In Qty)</span>';
        // }

        let absTbody = $('#table-abs tbody');
        let deltaTbody = $('#table-delta tbody');
        let percentTbody = $('#table-percent tbody');

        showLoading(absTbody[0]);
        showLoading(deltaTbody[0]);
        showLoading(percentTbody[0]);

        $.ajax({
            url: `{{ route('unitsummarynew') }}`,
            method: 'GET',
            data: {
                'from_date': fromDate,
                'to_date': toDate,
                'type': type
            },
            success: function(response) {
                let data = response.data.unitqty || [];
                let dataperc = response.data.unitperc || [];

                let absTbody = document.querySelector('#table-abs tbody');
                let percentTbody = document.querySelector('#table-percent tbody');

                absTbody.innerHTML = '';
                percentTbody.innerHTML = '';

                if (!data.length) {
                    absTbody.innerHTML = '<tr><td colspan="5" class="text-center">No data available</td></tr>';
                    percentTbody.innerHTML = '<tr><td colspan="5" class="text-center">No data available</td></tr>';
                    return;
                }

                data.forEach(item => {
                    const isOverAll = item.Unit === 'Over All';
                    const row = document.createElement('tr');
                    if (isOverAll) row.classList.add('fw-bold');
                    else {
                        row.setAttribute('onclick', `handleRowClick('${item.Unit}', '${fromDate}', '${toDate}', '${item.Unit_code}')`);
                        row.style.cursor = 'pointer';
                    }
                    row.innerHTML = `
                        <td class="px-2">${item.Unit}</td>
                        <td>${item.FTR}</td>
                        <td>${item.Rework}</td>
                        <td>${item.Reject}</td>
                        <td>${item.Chk_Pcs}</td>
                    `;
                    absTbody.appendChild(row);
                });

                dataperc.forEach(item => {
                    const isOverAll = item.Unit === 'Over All';
                    const row = document.createElement('tr');
                    if (isOverAll) row.classList.add('fw-bold');
                    else {
                        row.setAttribute('onclick', `handleRowClick('${item.Unit}', '${fromDate}', '${toDate}', '${item.Unit_code}')`);
                        row.style.cursor = 'pointer';
                    }
                    row.innerHTML = `
                        <td class="px-2">${item.Unit}</td>
                        <td>${item.FTR}</td>
                        <td>${item.Rework}</td>
                        <td>${item.Reject}</td>
                        <td>${item.Chk_Pcs}</td>
                    `;
                    percentTbody.appendChild(row);
                });

                // Auto-trigger first row click, but don't pass type to OCN
                const firstRow = absTbody.querySelector('tr:not(.fw-bold)');
                if (firstRow) {
                    const unit = firstRow.querySelector('td')?.textContent;
                    const match = firstRow.getAttribute('onclick')?.match(/'([^']+)'/g);
                    const unitcode = match?.[3]?.replace(/'/g, '');
                    if (unit && unitcode) {
                        handleRowClick(unit, fromDate, toDate, unitcode);
                    }
                }
            },
            error: function(xhr, status, error) {
                console.error('Error fetching unit summary:', error);
                absTbody.empty();
                deltaTbody.empty();
                percentTbody.empty();
                absTbody.append(`
                    <tr>
                        <td colspan="5" class="text-center text-danger">Error loading data</td>
                    </tr>
                `);
                deltaTbody.append(`
                    <tr>
                        <td colspan="5" class="text-center text-danger">Error loading data</td>
                    </tr>
                `);
                percentTbody.append(`
                    <tr>
                        <td colspan="5" class="text-center text-danger">Error loading data</td>
                    </tr>
                `);
            }
        });
    }

    // Initial fetch for default date range
    fetchUnitSummary(defaultStartDate, defaultEndDate, currentType);

    // Switch views in Unit Summary card
    let currentView = 'abs'; // Default view is Absolute

    function switchView(view) {
      let views = ['abs', 'delta', 'percent', 'chart'];

      // Toggle back to 'abs' if clicking the current view (except for chart)
      if (currentView === view && view !== 'chart') {
          view = 'abs';
      }
      currentView = view;

      // Set type for Unit Summary only
      currentType = view === 'percent' ? 'Perc' : view === 'delta' ? 'delta' : 'qty';

      // Update Unit Summary button states
      let buttons = document.querySelectorAll('.card-header .icon-btn'); // Limit to Unit Summary card
      buttons.forEach(btn => btn.classList.remove('active'));
      if (view !== 'abs') {
          let clickedButton = Array.from(buttons).find(btn => btn.dataset.tab === view);
          if (clickedButton) clickedButton.classList.add('active');
      }

      // Update Unit Summary percentage button color
      const unitPercentBtn = document.querySelector('.card-header .icon-btn[data-tab="unitpercent"]');
      if (unitPercentBtn) {
          unitPercentBtn.style.color = view === 'percent' ? 'blue' : '#6c757d';
          unitPercentBtn.classList.toggle('active', view === 'percent');
      }

      // Get current date range
      let selectdate = document.querySelector('.date-picker-input').value;
      let fromDate = selectdate.split(' to ')[0];
      let toDate = selectdate.split(' to ')[1];

      // Update Unit Summary only
      document.querySelectorAll('.view-table').forEach(elem => elem.classList.remove('active'));
      document.getElementById('chart-container').classList.remove('active');
      if (view === 'chart') {
          document.getElementById('chart-container').classList.add('active');
      } else {
          const table = document.getElementById('table-' + (view === 'percent' ? 'percent' : view === 'delta' ? 'delta' : 'abs'));
          if (table) table.closest('.view-table').classList.add('active');
      }
      fetchUnitSummary(fromDate, toDate, currentType);
    }

    // Track the currently highlighted unit
    let currentlyHighlightedUnit = null;

    // Debounce variable to prevent rapid clicks
    let lastClickTime = 0;
    let debounceDelay = 100; // 100ms debounce

    // Handle row click to highlight and toggle
    function handleRowClick(unit, fromDate, toDate, unitcode) {
        let now = Date.now();
        if (now - lastClickTime < debounceDelay) {
            return;
        }
        lastClickTime = now;

        let tableBodies = document.querySelectorAll('#table-abs tbody, #table-delta tbody, #table-percent tbody');
        tableBodies.forEach(tbody => {
            tbody.querySelectorAll('tr').forEach(row => {
                row.classList.remove('highlight');
            });
        });

        tableBodies.forEach(tbody => {
            tbody.querySelectorAll('tr').forEach(row => {
                if (row.querySelector('td')?.textContent === unit) {
                    row.classList.add('highlight');
                }
            });
        });
        currentlyHighlightedUnit = unit;
        currentUnitCode = unitcode;

        // Determine OCN Summary type based on its own button state
        const ocnPercentBtn = document.getElementById('ocn-percent-btn');
        const ocnType = ocnPercentBtn.classList.contains('active') ? 'perc' : 'qty';

        fetchOCNSummary(unit, fromDate, toDate, unitcode, ocnType);
        let activeTab = $('.defect-tab.active').data('tab');
        let defecttype = document.getElementById('defectTypeToggle').checked ? 'pre' : 'end';
        renderDefectTable(activeTab, unit, fromDate, toDate, unitcode, null, null, null, defecttype);
        fetchHeatMapDetails(unit, fromDate, toDate, unitcode, currentOption, null, currentHeatmapType);
    }
    

  // Fetch OCN Summary data via AJAX and render the table
  function fetchOCNSummary(unit,fromDate, toDate, unitcode,type) {
    
    $.ajax({
      url: `{{ route('ocnsummarynew') }}`, // Adjust this URL to your actual API endpoint
      method: 'GET',
      data: {
        'unit': unit,
        'from_date': fromDate,
        'to_date': toDate,
        'type': type,
        'unitcode': unitcode
      },
      success: function(response) {
        let data = response.data.ocnqty || [];
        let dataperc = response.data.ocnperc || [];

        // Card header update
        let ocnCard = document.querySelector('#ocn_summary_title');
        ocnCard.innerHTML = `OCN Summary <span style="color: blue;">(Unit ${unit})</span> <span class="text-danger fs-6"> (${
          type === 'perc' ? 'In %' : type === 'delta' ? 'In Δ' : 'In Qty'
        })</span>`;

        // ====== TABLE 1: Absolute Table (ocnTable) ======
        let ocnTbody = document.querySelector('#ocnTable tbody');
        ocnTbody.innerHTML = '';

        if (data.length === 0) {
          ocnTbody.innerHTML = `<tr><td colspan="6" class="text-center">No data available for Unit ${unit}</td></tr>`;
        } else {
          let otherRows = data.filter(item => !item.Order_No || item.Order_No.toLowerCase() !== 'over all');
          let tbodyRows = '';

          otherRows.forEach(item => {
            let displayOrderNo = item.Order_No ? (item.Order_No.split('OCN')[1] || 'N/A') : 'N/A';
            let displayOCN = item.Order_No ? (item.Order_No.split('OCN0')[1] || 'N/A') : 'N/A';
            tbodyRows += `
              <tr onclick="handleOcnRowClick('${unit}','${item.Unit_code}','${fromDate}','${toDate}','${displayOrderNo}', this)">
                <td class="px-2">${item.Buyer.replace(/[^a-zA-Z0-9]/g, '').substring(0,3)}${displayOCN}</td>
                <td>${item.FTR || 0}</td>
                <td>${item.Rew_Pcs || 0}</td>
                <td>${item.Rej_Pcs || 0}</td>
                <td>${item.Chk_Pcs || 0}</td>
                <td>${item.FI || 0}</td>
              </tr>
            `;
          });

          ocnTbody.innerHTML = tbodyRows;

          let overAllRow = data.find(item => item.Order_No && item.Order_No.toLowerCase() === 'over all');
          let tfoot = document.querySelector('#ocnTable tfoot');
          if (overAllRow && tfoot) {
            tfoot.innerHTML = `
              <tr class="fw-bold">
                <td class="px-2">Over All</td>
                <td>${overAllRow.FTR || 0}</td>
                <td>${overAllRow.Rew_Pcs || 0}</td>
                <td>${overAllRow.Rej_Pcs || 0}</td>
                <td>${overAllRow.Chk_Pcs || 0}</td>
                <td>${overAllRow.FI || 0}</td>
              </tr>
            `;
          } else if (tfoot) {
            tfoot.innerHTML = '';
          }
        }

        // ====== TABLE 2: Percentage Table (ocnTableperc) ======
        let percTbody = document.querySelector('#ocnTableperc tbody');
        percTbody.innerHTML = '';

        if (dataperc.length === 0) {
          percTbody.innerHTML = `<tr><td colspan="6" class="text-center">No data available for Unit ${unit}</td></tr>`;
        } else {
          let otherRows = dataperc.filter(item => !item.Order_No || item.Order_No.toLowerCase() !== 'over all');
          let percRows = '';

          otherRows.forEach(item => {
            let displayOrderNo = item.Order_No ? (item.Order_No.split('OCN')[1] || 'N/A') : 'N/A';
            let displayOCN = item.Order_No ? (item.Order_No.split('OCN0')[1] || 'N/A') : 'N/A';
            percRows += `
              <tr onclick="handleOcnRowClick('${unit}','${item.Unit_code}','${fromDate}','${toDate}','${displayOrderNo}', this)">
                <td class="px-2">${item.Buyer.replace(/[^a-zA-Z0-9]/g, '').substring(0,3)}${displayOCN}</td>
                <td>${item.FTR || 0}</td>
                <td>${item.Rew_Pcs || 0}</td>
                <td>${item.Rej_Pcs || 0}</td>
                <td>${item.Chk_Pcs || 0}</td>
                <td>${item.FI || 0}</td>
              </tr>
            `;
          });

          percTbody.innerHTML = percRows;

          let overAllRow = dataperc.find(item => item.Order_No && item.Order_No.toLowerCase() === 'over all');
          let percTfoot = document.querySelector('#ocnTableperc tfoot');
          if (overAllRow && percTfoot) {
            percTfoot.innerHTML = `
              <tr class="fw-bold">
                <td class="px-2">Over All</td>
                <td>${overAllRow.FTR || 0}</td>
                <td>${overAllRow.Rew_Pcs || 0}</td>
                <td>${overAllRow.Rej_Pcs || 0}</td>
                <td>${overAllRow.Chk_Pcs || 0}</td>
                <td>${overAllRow.FI || 0}</td>
              </tr>
            `;
          } else if (percTfoot) {
            percTfoot.innerHTML = '';
          }
        }
      },
      error: function(xhr, status, error) {
        console.error('Error fetching OCN summary:', error);
        // Update the card title to reflect the selected unit even on error
        let ocnCard = document.querySelector('#ocnSummary h5');
        ocnCard.textContent = `OCN Summary (Unit ${unit})`;
        // Show error message in the table
        let ocnTbody = document.querySelector('#ocnSummary tbody');
        ocnTbody.innerHTML = `
          <tr>
            <td colspan="5" class="text-center text-danger">Error loading data for Unit ${unit}</td>
          </tr>
        `;
      }
    });
  }

  // fetch po no details and render table
  function fetchPOSummary(ocnno) {
    $.ajax({
      url: `{{ route('posummary') }}`, // Adjust this URL to your actual API endpoint
      method: 'GET',
      data: {
        'ocnno': ocnno,
      },
      success: function(response) {
        
        let data = response.data || [];
        
        let poCard = document.querySelector('#poSummary h5');
        poCard.innerHTML = `PO Summary <span style="color: blue;">(${ocnno})</span>`;

        // Populate the OCN Summary table
        let poTbody = document.querySelector('#poSummary tbody');
        poTbody.innerHTML = ''; // Clear existing rows
        
        if (!data || data.length == []||data.length === 0) {
          // Handle empty data case
          poTbody.innerHTML = `
            <tr>
              <td colspan="5" class="text-center">No data available</td>
            </tr>
          `;
        } else {
 
          // Populate tbody (unchanged logic, optimized)
          let tbodyRows = '';
          data.forEach(item => {
              tbodyRows += `
                  <tr>
                      <td>${item.PO_No || ''}</td>
                      <td class="${item.Status == 'PASS' ? 'text-success' : 'text-danger'}">${item.Status || 0}</td>
                  </tr>
              `;
          });
          poTbody.innerHTML = tbodyRows;
        }

      },
      error: function(xhr, status, error) {
        console.error('Error fetching PO summary:', error);
        // Update the card title to reflect the selected unit even on error
        let poCard = document.querySelector('#poSummary h5');
        poCard.textContent = `PO Summary (${ocnno})`;
        // Show error message in the table
        let poTbody = document.querySelector('#poSummary tbody');
        poTbody.innerHTML = `
          <tr>
            <td colspan="5" class="text-center text-danger">Error loading data for ${ocnno}</td>
          </tr>
        `;
      }
    });
  }

    // Single event listener for Unit Summary card
    document.querySelector('.card-body').addEventListener('click', (e) => {
        let row = e.target.closest('tr');
       
        if (row && (row.parentElement.tagName === 'TBODY')) {
            let unit = row.querySelector('td')?.textContent;
            let onclickAttr = row.getAttribute('onclick');
            let unitcode = onclickAttr ? onclickAttr.match(/'([^']*)'/g)[3].replace(/'/g, '') : '';
            if (unit) {
                e.stopPropagation(); // Prevent event bubbling
                handleRowClick(unit, formatDate(thirtyDaysAgo), formatDate(today), unitcode);
            } else {
                console.error('No unit found in clicked row');
            }
        }
    });

    // Printing Defect Trend (ApexCharts line)
    let trendChart = null; // Initialize as null to track chart instance

    function initializeTrendChart() {
        const chartContainer = document.querySelector('#trendChart');
        if (!chartContainer) {
            console.error('Chart container #trendChart not found in the DOM');
            return false;
        }

        // Clear container to ensure clean state
        chartContainer.innerHTML = '';

        const trendOptions = {
            chart: {
                type: 'area',
                height: 300,
                toolbar: { show: false },
                zoom: { enabled: false },
            },
            colors: ['#808080'],
            stroke: {
                curve: 'smooth',
                width: 2,
            },
            markers: {
                size: 3,
            },
            dataLabels: {
                enabled: false,
            },
            series: [
                {
                    name: 'Defects',
                    data: [14, 18, 20, 22, 19, 21, 25],
                },
            ],
            xaxis: {
                categories: [
                    'May 27',
                    'May 28',
                    'May 29',
                    'May 30',
                    'May 31',
                    'Jun 01',
                    'Jun 02',
                ],
                labels: { rotate: -45 },
            },
            tooltip: {
                enabled: true,
                y: { formatter: (val) => val + ' defects' },
            },
        };

        try {
            trendChart = new ApexCharts(chartContainer, trendOptions);
            trendChart.render();
            //console.log('Initial trend chart rendered successfully');
            return true;
        } catch (e) {
            //console.error('Error rendering initial trend chart:', e);
            chartContainer.innerHTML = `
                <div class="text-center text-danger" style="height: 300px; display: flex; align-items: center; justify-content: center;">
                    Error rendering initial chart
                </div>
            `;
            return false;
        }
    }

    // Initialize chart on page load
    document.addEventListener('DOMContentLoaded', initializeTrendChart);

    // Defect Analysis Logic
    const defectData = {
        top5: [
            { description: 'Print bleeding', count: 168 },
            { description: 'Ink smudge', count: 162 },
            { description: 'Fabric tear', count: 157 },
            { description: 'Loose thread', count: 150 },
            { description: 'Alignment error', count: 147 }
        ],
        critical: [
            { description: 'Fabric tear', count: 157 },
            { description: 'Print bleeding', count: 168 },
            { description: 'Ink smudge', count: 162 }
        ],
        category: [
            { description: 'Printing', count: 330 },
            { description: 'Fabric', count: 307 },
            { description: 'Sewing', count: 297 }
        ]
    };

      function handleOcnRowClick(unit,unitcode, fromDate, toDate, ocnno,row){
        // document.querySelectorAll('#ocnSummary .highlight').forEach(r => {
        //     r.classList.remove('highlight');
        // });
        // row.classList.add('highlight');
        selectedOCNNo = ocnno; // store in memory

        // Remove highlight from both tables
        document.querySelectorAll('#ocnTable tr, #ocnTableperc tr').forEach(row => {
          row.classList.remove('highlight');
        });

        // Apply highlight to clicked row
        if (row) {
          row.classList.add('highlight');
        }

        highlightMatchingRowInOtherTable(selectedOCNNo);

        let typeactiveTab = $('.icon-btn.active').data('tab');
        let type = typeactiveTab || 'qty';
        renderDefectTable('top5', unit, fromDate, toDate, unitcode,ocnno,linenumber = null , heatoption = null, defecttype = 'end');
        fetchPOSummary(ocnno);
        fetchHeatMapDetails(unit, fromDate, toDate, unitcode, currentOption, ocnno, currentHeatmapType);
      }


      function highlightMatchingRowInOtherTable(ocnNo) {
        // Find the row in ocnTable
        document.querySelectorAll('#ocnTable tbody tr, #ocnTableperc tbody tr').forEach(row => {
          const cellText = row.cells[0]?.textContent?.trim();
          if (cellText === ocnNo) {
            row.classList.add('highlight');
          }
        });
      }
      
      function handledefRowClick(tab, unit, unitcode, fromDate, toDate, ocnno, defid, defdet, row) {
          document.querySelectorAll('#tabOutput .highlight').forEach(r => {
              r.classList.remove('highlight');
          });

          let selectdate = $('.date-picker-input').val();

          // Corrected variable name here
          let defromdate = (fromDate == 'Invalid-Date') ? selectdate.split(' to ')[0] : fromDate;
          let detodate = (toDate == 'Invalid-Date') ? selectdate.split(' to ')[1] : toDate;

          // Function to calculate the number of days between two dates
          function getDaysBetweenDates(startDate, endDate) {
              let start = new Date(startDate);
              let end = new Date(endDate);
              let diffTime = Math.abs(end - start);
              let diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24)); // Convert ms to days
              return diffDays;
          }

          // Calculate the number of days
          let days = getDaysBetweenDates(defromdate, detodate);

          row.classList.add('highlight');
         
          let lineoption = (currentoption !== '' ? currentoption : null);

          $.ajax({
              url: `defectchartdetails`,
              data: {
                  'tab': tab,
                  'from_date': defromdate,
                  'to_date': detodate,
                  'defid': defid,
                  'unitcode': unitcode,
                  'orderno': ocnno
              },
              method: 'GET',
              success: function(response) {
                  const trendTitle = document.querySelector('#defectAnalysischart h5');
                  if (trendTitle) {
                      trendTitle.innerHTML = `${defdet} Defect Trend <span style="color: blue;">( Unit ${unit} | ${current_line_name || ""} | ${lineoption} )</span>`;
                  }
                  let trend_subTitle = document.querySelector('#defectAnalysischart p');
                  if (trend_subTitle) {
                      if (days === 0) {
                          trend_subTitle.innerHTML = `Daily trends (Absolute counts) for ${defdet} defects on <span style="color: blue;">${defromdate}</span>`;
                      } else {
                          trend_subTitle.innerHTML = `Daily trends (Absolute counts) for ${defdet} defects over the last <span style="color: blue;">${days} day${days !== 1 ? 's' : ''} before ${detodate}</span>`;
                      }
                  }

                  const rawData = response.data || [];

                  // Check if response data is null, empty, or all Def_Cnt are 0
                  const isDataEmpty = !rawData || rawData.length === 0 || rawData.every(item => parseInt(item.Def_Cnt) === 0);

                  // Get the chart container
                  const chartContainer = document.querySelector('#trendChart');
                  if (!chartContainer) {
                      //console.error('Chart container #trendChart not found in the DOM');
                      chartContainer.innerHTML = `
                          <div class="text-center text-danger" style="height: 300px; display: flex; align-items: center; justify-content: center;">
                              Chart container not found
                          </div>
                      `;
                      return;
                  }

                  // Destroy existing chart to prevent memory leaks
                  if (trendChart) {
                      try {
                          trendChart.destroy();
                          //console.log('Existing chart destroyed');
                      } catch (e) {
                          //console.error('Error destroying chart:', e);
                      }
                      trendChart = null; // Reset to null after destruction
                  }

                  if (isDataEmpty) {
                      // Display "No data available" message
                      chartContainer.innerHTML = `
                          <div class="text-center text-muted" style=" display: flex; align-items: center; justify-content: center;">
                              No data available
                          </div>
                      `;
                      //console.log('No data available for chart rendering');
                      return;
                  }

                  let categories = rawData.map(item => {
                      if (!item.Edate) {
                          console.warn('Invalid Edate in data item:', item);
                          return 'Unknown';
                      }
                      const parts = item.Edate.split('-');
                      return parts.length === 3 ? `${parts[2]}/${parts[1]}` : 'Invalid Date';
                  });
                  let defectCounts = rawData.map(item => {
                      const count = parseInt(item.Def_Cnt);
                      return isNaN(count) ? 0 : count;
                  });
                  let totalDefects = rawData.map(item => {
                      const total = parseInt(item.Tot_Def);
                      return isNaN(total) ? 0 : total;
                  });

                  // Calculate percentages for the line chart
                  let percentages = defectCounts.map((defect, index) => {
                      const total = totalDefects[index];
                      return total !== 0 ? ((defect / total) * 100) : 0;
                  });

                  // Ensure chart container is cleared
                  chartContainer.innerHTML = '';

                  // Reinitialize the chart
                  let trendOptions = {
                      chart: {
                          type: 'area',
                          height: 300,
                          toolbar: { show: false },
                          zoom: { enabled: false },
                      },
                      colors: ['#808080'],
                      stroke: {
                          curve: 'smooth',
                          width: 2,
                      },
                      markers: {
                          size: 3,
                      },
                      dataLabels: {
                          enabled: false,
                      },
                      series: [
                          {
                              name: rawData[0]?.Defect || 'Defect Percentage',
                              data: percentages,
                          },
                      ],
                      xaxis: {
                          categories: categories,
                          labels: { rotate: -45 },
                      },
                      yaxis: {
                          labels: {
                              formatter: (val) => `${val.toFixed(2)}%`,
                          },
                          title: {
                              text: 'Percentage',
                          },
                      },
                      tooltip: {
                          enabled: true,
                            custom: function({ series, seriesIndex, dataPointIndex, w }) {
                                let defectCount = defectCounts[dataPointIndex];
                                let totalDefectsVal = totalDefects[dataPointIndex];
                                let percentage = percentages[dataPointIndex].toFixed(2);
                                return `
                                    <div style="background: #ffffff; border: 1px solid #e0e0e0; border-radius: 6px; padding: 12px; font-family: 'Arial', sans-serif; font-size: 14px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                                        <div style="margin-bottom: 6px;"><strong>${w.globals.seriesNames[0]}</strong></div>
                                        <div style="margin-bottom: 4px;">Defect Count: <strong>${defectCount}</strong></div>
                                        <div style="margin-bottom: 4px;">Overall Checked: <strong>${totalDefectsVal}</strong></div>
                                        <div>Percentage: <strong>${percentage}%</strong></div>
                                    </div>
                                `;
                          }
                      }
                      
                  };

                  // Render new chart
                  try {
                      trendChart = new ApexCharts(chartContainer, trendOptions);
                      trendChart.render();
                      //console.log('New chart rendered successfully');
                  } catch (e) {
                      //console.error('Error rendering chart:', e);
                      chartContainer.innerHTML = `
                          <div class="text-center text-danger" style="height: 300px; display: flex; align-items: center; justify-content: center;">
                              Error rendering chart
                          </div>
                      `;
                  }
              },
              error: function(xhr, status, error) {
                  //console.error('Error fetching defect chart details:', error);
                  // Destroy existing chart
                  if (trendChart) {
                      try {
                          trendChart.destroy();
                          //console.log('Existing chart destroyed on error');
                      } catch (e) {
                          //console.error('Error destroying chart on error:', e);
                      }
                      trendChart = null; // Reset to null after destruction
                  }
                  // Display error message
                  const chartContainer = document.querySelector('#trendChart');
                  if (chartContainer) {
                      chartContainer.innerHTML = `
                          <div class="text-center text-danger" style="height: 300px; display: flex; align-items: center; justify-content: center;">
                              Error loading data
                          </div>
                      `;
                  } else {
                      //console.error('Chart container #trendChart not found in the DOM');
                  }
              }
          });
      }

      // Render defect table based on selected tab
      function renderDefectTable(tab, unit, fromDate, toDate, unitcode, ocnno = null, linenumber, heatoption, defecttype){
        // Apply default value logic here
        //console.log('Rendering defect table with parameters:', {tab, unit, fromDate, toDate, unitcode, ocnno, linenumber, heatoption, defecttype});
        let spinner = document.getElementById('defectSpinner');
        if (spinner) {
            spinner.classList.remove('d-none');
        }
        let selectdefect = (typeof defecttype === 'undefined') ? 'end' : defecttype;
        let selectdate = $('.date-picker-input').val();

        // Toggle defect type switch based on selectdefect
        let defectToggle = document.getElementById('defectTypeToggle');
        if (defectToggle) {
            let shouldBeChecked = selectdefect === 'pre';
            if (defectToggle.checked !== shouldBeChecked) {
                defectToggle.checked = shouldBeChecked;
            }
        }

        // Corrected variable name here
        let defromdate = (fromDate == 'Invalid-Date') ? selectdate.split(' to ')[0] : fromDate;
        let detodate = (toDate == 'Invalid-Date') ? selectdate.split(' to ')[1] : toDate;

        let lineNumberParam = (linenumber !== '' ? linenumber : null);
        //let lineoption = (heatoption !== '' ? heatoption : null);
		let lineoption = (currentoption !== '' ? currentoption : null);

		// Update the Defect Analysis card title with the selected unit
        let defectCard = document.querySelector('#defectAnalysis h5');
        if (ocnno && lineoption && current_line_name) {
            defectCard.innerHTML = `Defect Analysis <div style="color: blue; font-size: 14px;">(Unit ${unit} - ${ocnno} - ${current_line_name} - ${lineoption})</div>`;
        }
        else if (ocnno){
            defectCard.innerHTML = `Defect Analysis <span style="color: blue; font-size: 16px;">(Unit ${unit} - ${ocnno})</span>`;
        }
        else if ( lineoption && current_line_name){
            defectCard.innerHTML = `Defect Analysis <div style="color: blue; font-size: 14px;">(Unit ${unit} - ${current_line_name} - ${lineoption})</div>`;
        }
        else {
            defectCard.innerHTML = `Defect Analysis <span style="color: blue;">(Unit ${unit})</span>`;
        }

        // Reset table container state
        let tableContainer = document.querySelector('#tabOutput');
        tableContainer.classList.remove('expanded'); // Disable scrollbar
        tableContainer.scrollTop = 0; // Reset scroll position to top
        let viewMoreLink = document.getElementById('viewMoreLink');
        viewMoreLink.textContent = 'View More'; // Set link text to "View More"

        // if (lineoption == 'FTR') {
        //     toastr.info('This is FTR Line!');
        //     return false;
        // }

        $.ajax({
            url: `defectsummary`,
            data: {
                'type': 'qty',
                'tab': tab,
                'from_date': defromdate,
                'to_date': detodate,
                'isPercentage': isPercentage,
                'unitcode': unitcode,
                'orderno': ocnno,
                'line_no': lineNumberParam,
                'line_option': lineoption,
                'defecttype': selectdefect
            },
            method: 'GET',
            success: function(response) {
                // Hide spinner
                if (spinner) {
                    spinner.classList.add('d-none');
                }
                let data = response.data || [];

                // Aggregate data for 'category' tab
                let processedData = data;
                if (tab === 'category') {
                    // Group by Def_Cat and sum Def_Cnt or calculate percentage
                    const aggregated = data.reduce((acc, item) => {
                        const key = item.Def_Cat;
                        if (!acc[key]) {
                            acc[key] = {
                                Def_Cat: item.Def_Cat,
                                Def_Cnt: 0,
                                Def_Perc: 0,
                                Def_Id: item.Def_Cat // Use Def_Cat as identifier for category tab
                            };
                        }
                        acc[key].Def_Cnt += parseInt(item.Def_Cnt);
                        return acc;
                    }, {});

                    // Convert to array and calculate percentages if needed
                    processedData = Object.values(aggregated).map(item => {
                        if (isPercentage) {
                            const total = data.reduce((sum, item) => sum + parseInt(item.Def_Cnt), 0);
                            item.Def_Perc = ((item.Def_Cnt / total) * 100).toFixed(2);
                        }
                        return item;
                    });
                    // Sort by Def_Cnt descending
                    processedData.sort((a, b) => b.Def_Cnt - a.Def_Cnt);
                }

                // Calculate total count for percentage calculation (for non-category tabs)
                let total = data.reduce((sum, item) => sum + parseInt(item.Def_Cnt), 0);

                // Generate table rows, but only show first 6 rows by default
                let rows = processedData.map((item, index) => {
                    // Determine the description based on the tab value
                    const description = tab === 'top5' ? item.Defect : (tab === 'critical' || tab === 'category' ? item.Def_Cat : item.Defect);
                    const displayValue = isPercentage ? item.Def_Perc : item.Def_Cnt;
                    
                    return `
                        <tr class="defect-row ${index >= 5 ? 'visually-hidden' : ''}" onclick="handledefRowClick('${tab}','${unit}','${unitcode}','${fromDate}','${toDate}','${ocnno}','${item.Def_Id}','${description}',this)">
                            <td>${description}</td>
                            <td class="text-end fw-semibold">${displayValue}</td>
                        </tr>
                    `;
                }).join('');

                // Generate the table HTML
                let html = `
                    <table class="table shadow-sm bg-white">
                        <thead class="fw-normal">
                            <tr>
                                <th>Description</th>
                                <th class="text-end">${isPercentage ? 'Count(%)' : 'Count'}</th>
                            </tr>
                        </thead>
                        <tbody>${rows}</tbody>
                    </table>
                `;
                $('#tabOutput').html(html);

                // Show/hide View More link based on data length
                const viewMoreLink = document.getElementById('viewMoreLink');
                if (processedData.length > 5) {
                    viewMoreLink.classList.remove('d-none');
                } else {
                    viewMoreLink.classList.add('d-none');
                }

                // Trigger handledefRowClick for the first row if data exists
                if (processedData.length > 0) {
                    const firstRow = $('#tabOutput .defect-row')[0];
                    if (firstRow) {
                        const description = tab === 'top5' ? processedData[0].Defect : (tab === 'critical' || tab === 'category' ? processedData[0].Def_Cat : processedData[0].Defect);
                        handledefRowClick(tab, unit, unitcode, fromDate, toDate, ocnno, processedData[0].Def_Id, description, firstRow);
                    }
                }
                
            },
            error: function(xhr, status, error) {
                // Hide spinner
                if (spinner) {
                    spinner.classList.add('d-none');
                }
                //console.error('Error fetching defect summary:', error);
                $('#tabOutput').html(`
                    <div class="alert alert-warning">
                        Failed to load defect data. Please try again later.
                    </div>
                `);
                // Hide View More link on error
                const viewMoreLink = document.getElementById('viewMoreLink');
                viewMoreLink.classList.add('d-none');
            }
        });
      }

      isPercentage = false;
 
      $(function () {
 
          //renderDefectTable('top5');
 
          $('.defect-tab').click(function (e) {
              e.preventDefault();
              $('.defect-tab').removeClass('active');
              $(this).addClass('active');
 
              let tab = $(this).data('tab');
              let selectdate = $('.date-picker-input').val();
              let fromdate = selectdate.split(' to ')[0];
              let todate = selectdate.split(' to ')[1];
              let ocnno = $('.heatmap_title_select').attr('data-order_no') || null;
              let defecttype = document.getElementById('defectTypeToggle').checked ? 'pre' : 'end';
              let unit = currentUnitCode || $('.heatmap_title_select').attr('data-unit');
              
              renderDefectTable(tab, currentlyHighlightedUnit, fromdate, todate, unit, currentOrderNo, null, null, defecttype);
              fetchHeatMapDetails(currentlyHighlightedUnit, fromdate, todate, unit, currentOption, currentOrderNo, currentHeatmapType);
          });
 
          $('#percentToggle').click(function () {
              isPercentage = !isPercentage; // Toggle percentage flag for Defect Analysis
              this.style.color = isPercentage ? 'blue' : '#6c757d';
              this.classList.toggle('active', isPercentage);

              let activeTab = $('.defect-tab.active').data('tab');
              let selectdate = $('.date-picker-input').val();
              let fromdate = selectdate.split(' to ')[0];
              let todate = selectdate.split(' to ')[1];
              let unit = currentlyHighlightedUnit || 'G1';
              let unitcode = currentUnitCode || $('.heatmap_title_select').attr('data-unit') || '';
              let ocnno = $('.heatmap_title_select').attr('data-order_no') || null;
              let defecttype = document.getElementById('defectTypeToggle').checked ? 'pre' : 'end';

              renderDefectTable(activeTab, unit, fromdate, todate, unitcode, currentOrderNo, null, null, defecttype);
              fetchHeatMapDetails(unit, fromdate, todate, unitcode, currentOption, currentOrderNo, currentHeatmapType);
          });

          $('#reset_defect_table').click(function () {
              document.getElementById('percentToggle').style.color = 'black';
              document.getElementById('defectTypeToggle').checked = false;
              isPercentage = false;
              let activeTab = $('.defect-tab.active').data('tab');
              let selectdate = $('.date-picker-input').val();
              let fromdate = selectdate.split(' to ')[0];
              let todate = selectdate.split(' to ')[1];
              let unit = currentUnitCode || $('.heatmap_title_select').attr('data-unit');
              //this.style.color = isPercentage ? 'blue' : 'black';
              document.querySelectorAll('#ocnTable tr, #ocnTableperc tr').forEach(row => {
                row.classList.remove('highlight');
              });
              $('#poSummary tbody td').html('Click OCN for details');
              $('#poSummary .card-header h5 span').html('');
              renderDefectTable(activeTab, currentlyHighlightedUnit, fromdate, todate, unit);
              fetchHeatMapDetails(currentlyHighlightedUnit, fromdate, todate, unit, currentOption, null, currentHeatmapType);
          });

          $('#defectTypeToggle').on('change', function() {
              let defecttype = this.checked ? 'pre' : 'end'; // checked: end, unchecked: pre
              // Get current table parameters
              let activeTab = $('.defect-tab.active').data('tab');
              let selectdate = $('.date-picker-input').val();
              let fromdate = selectdate.split(' to ')[0];
              let todate = selectdate.split(' to ')[1];
              let unit = currentlyHighlightedUnit || 'defaultUnit';
              let unitcode = currentUnitCode || $('.heatmap_title_select').attr('data-unit');
              let ocnno = null;

              // Re-render table with new defectType
              renderDefectTable(activeTab, unit, fromdate, todate, unitcode, currentOrderNo, linenumber = null, heatoption = null, defecttype);
              fetchHeatMapDetails(unit, fromdate, todate, unitcode, currentOption, currentOrderNo, currentHeatmapType);
          });
 
          // Add View More/View Less toggle functionality for the clickable text
          $(document).on('click', '#viewMoreLink', function(e) {
              e.preventDefault(); // Prevent default anchor behavior
              let tableContainer = document.querySelector('#tabOutput');
              let rows = document.querySelectorAll('.defect-row');
              let isExpanded = tableContainer.classList.contains('expanded');
 
              if (isExpanded) {                
                  tableContainer.classList.remove('expanded');
                  rows.forEach((row, index) => {
                      if (index >= 5) {
                          row.classList.add('visually-hidden');
                      }
                  });
                  tableContainer.scrollTop = 0;                
                  this.textContent = 'View More';
              } else {
                  tableContainer.classList.add('expanded');
                  rows.forEach(row => row.classList.remove('visually-hidden'));
                  this.textContent = 'View Less';
              }
          });
      });
 
</script>

<script>
  // Global variables
  let current_line_name = null;
  let currentOption = 'FTR';
  let currentUnitCode = null;
  let heatmapChart = null;
  let currentHeatmapView = 'abs';
  let currentHeatmapType = 'qty';

  // Dropdown Change Handler
  function updateHeatmapOnDropdownChange(unit, fromDate, toDate, unitcode, orderno) {
      // Check the state of the percent toggle button
      let percentToggle = document.querySelector('#heatmap-percent-btn');
      let type = percentToggle.classList.contains('active') ? 'perc' : 'qty';
      
      let defecttype = document.getElementById('defectTypeToggle').checked ? 'pre' : 'end';
      let activeTab = $('.defect-tab.active').data('tab');
      
      if (unit && unitcode) {
          fetchHeatMapDetails(unit, fromDate, toDate, unitcode, currentOption, orderno, type);
          renderDefectTable(activeTab, unit, fromDate, toDate, unitcode, orderno, null, null, defecttype);
      } else {
          console.warn('No unit or unit code selected for heatmap update');
      }
  }

  // Switch view for Heatmap
    function switchHeatmapView(view) {
      if (currentHeatmapView === view) {
        view = 'abs';
      }
      currentHeatmapView = view;
      currentHeatmapType = view === 'percent' ? 'perc' : view === 'delta' ? 'delta' : 'qty';

      // Update Heatmap buttons
      let heatmapButtons = document.querySelectorAll('.heat-icon-btn');
      heatmapButtons.forEach(btn => {
        btn.classList.remove('active');
        btn.style.color = '#6c757d';
        if (btn.dataset.tab === (view === 'percent' ? 'perc' : view === 'delta' ? 'delta' : 'qty')) {
          btn.classList.add('active');
          if (view === 'percent') btn.style.color = 'blue';
        }
      });

      // Get current date range
      let selectdate = document.querySelector('.date-picker-input').value;
      let fromDate = selectdate.split(' to ')[0];
      let toDate = selectdate.split(' to ')[1];

      // Update Heatmap
      let unit = currentlyHighlightedUnit || 'G1';
      let unitcode = currentUnitCode || $('.heatmap_title_select').attr('data-unit') || '';
      let ocnno = $('.heatmap_title_select').attr('data-order_no') || null;
      fetchHeatMapDetails(unit, fromDate, toDate, unitcode, currentOption, currentOrderNo, currentHeatmapType);
    }

  document.addEventListener('DOMContentLoaded', function () {
      let dropdownItems = document.querySelectorAll('.dropdown-item');
      let selectedOption = document.getElementById('selectedOption');
      dropdownItems.forEach(item => {
          item.addEventListener('click', function (e) {
              e.preventDefault();
              let value = this.getAttribute('data-value');
              selectedOption.textContent = value;
              currentOption = value;
              let selectdate = document.querySelector('.date-picker-input').value;
              let fromDate = selectdate.split(' to ')[0];
              let toDate = selectdate.split(' to ')[1];
              let heatorder_no = $('.heatmap_title_select').attr('data-order_no');

              //console.log(heatorder_no);
              //console.log('hjkjnkjbjkb')
              updateHeatmapOnDropdownChange(currentlyHighlightedUnit, fromDate, toDate, currentUnitCode,  currentOrderNo);
          });
      });
  });

  let categories = [];
  let series = [];
  let currentUnit, currentUnitName, currentOrderNo, currentoption;

  // Mapping for option short forms to percentage field names
  const optionMap = {
      'FTR': 'FTR',
      'RW': 'Rework',
      'RJ': 'Reject'
  };

  function fetchHeatMapDetails(unit, fromDate, toDate, unitcode, option, orderno, type) {

      let spinner = document.getElementById('heatmapSpinner');
      if (spinner) {
          spinner.classList.remove('d-none');
      }

      currentUnit = unitcode;
      currentUnitName = unit;
      currentOrderNo = orderno;
      currentoption = option;
      current_line_name = "";

      $.ajax({
          url: `{{ route('heatmapdetails') }}`,
          method: 'GET',
          data: {
              'unit': unit,
              'from_date': fromDate,
              'to_date': toDate,
              'argument2': option,
              'unitcode': unitcode,
              'orderno': orderno,
              'type': type
          },
          success: function (response) {
              if (spinner) {
                  spinner.classList.add('d-none');
              }
              let data = response.data || [];
              let heatmapContainer = document.querySelector('#heatmap');

              if (data.length === 0) {
                  heatmapContainer.innerHTML = `<div class="alert alert-warning text-center">No heatmap data available for Unit ${unit}.</div>`;
                  return;
              }

              // Update title
              let heatmapTitle = document.querySelector('.heatmap_title');
              const displayOption = option === 'FTR' ? 'FTR' : option === 'RW' ? 'Rework' : 'Reject';
              heatmapTitle.innerHTML = orderno
                  ? `Line wise Heat map - ${displayOption} <span class='heatmap-title-select' data-option='${option}' data-unit_name='${unit}' data-unit='${unitcode}' data-order_no='${orderno}'>(Unit ${unit} - GIL\\OCN${orderno})</span>`
                  : `Line wise Heat map - ${displayOption} <span class='heatmap-title-select' data-option='${option}' data-unit_name='${unit}' data-unit='${unitcode}' data-order_no=''>(Unit ${unit})</span>`;

              // Process dates
              const dateMap = {};
              data.forEach(item => {
                  if (item.Slno === '1') {
                      const dateObj = new Date(item.Edate);
                      const formatted = `${String(dateObj.getDate()).padStart(2, '0')}/${String(dateObj.getMonth() + 1).padStart(2, '0')}`;
                      dateMap[formatted] = dateObj;
                  }
              });

              const uniqueDates = Object.keys(dateMap).sort((a, b) => dateMap[a] - dateMap[b]);
              categories = [type === 'qty' ? 'Total' : 'Avg', ...uniqueDates];

              // Initialize series structure
              const lineData = {};
              data.forEach(item => {
                  if (item.Slno === '1' || item.Slno === '2') {
                      const displayName = item.New_Line_No.match(/^[0-9]+$/) ? `L${item.New_Line_No}` : item.New_Line_No;
                      const line = item.Slno === '1' ? `L${item.Line_No}` : `L${item.Line_No}_total`;
                      if (!lineData[line]) lineData[line] = [];
                      lineData[line].displayName = displayName; // Store display name
                      const metric = optionMap[option];
                      const value = parseFloat(item[metric] || 0);
                      const checked = parseInt(item.Chk_Pcs) || 0;
                      const perValue = type === 'perc' ? value : parseFloat(item[`${metric}_Per`] || 0);
                      if (item.Slno === '1') {
                          const dateObj = new Date(item.Edate);
                          const formattedDate = `${String(dateObj.getDate()).padStart(2, '0')}/${String(dateObj.getMonth() + 1).padStart(2, '0')}`;
                          lineData[line].push({
                              date: formattedDate,
                              value: value,
                              checked: checked,
                              perValue: perValue
                          });
                      } else if (item.Slno === '2') {
                          lineData[line].push({
                              date: type === 'qty' ? 'Total' : 'Avg',
                              value: value,
                              checked: checked,
                              perValue: perValue
                          });
                      }
                  }
              });

              // Build series
              series = Object.keys(lineData)
                  .filter(line => !line.includes('_total'))
                  .sort((a, b) => parseInt(a.replace('L', '')) - parseInt(b.replace('L', '')))
                  .map(line => {
                      const dataForLine = uniqueDates.map(date => {
                          const entry = lineData[line].find(item => item.date === date);
                          return entry ? { value: entry.value, checked: entry.checked, perValue: entry.perValue } : { value: 0, checked: '-', perValue: 0 };
                      });

                      const totalEntry = lineData[`${line}_total`]?.[0] || { value: 0, checked: '-', perValue: 0 };
                      const fullData = [{ value: totalEntry.value, checked: totalEntry.checked, perValue: totalEntry.perValue }, ...dataForLine];
                      return {
                          name: lineData[line].displayName, // Use display name for heatmap
                          originalLine: line, // Store original line for AJAX
                          data: fullData
                      };
                  });

              // Add Total/Avg row
              const totalsData = categories.map((category, idx) => {
                  let slnoData = null;
                  if (idx === 0) {
                      slnoData = data.find(item => item.Slno === '4');
                  } else {
                      const [day, month] = category.split('/').map(Number);
                      const dateStr = `2025-${month.toString().padStart(2, '0')}-${day.toString().padStart(2, '0')}`;
                      slnoData = data.find(item => item.Slno === '3' && item.Edate.startsWith(dateStr));
                  }

                  if (slnoData) {
                      const metric = optionMap[option];
                      const value = parseFloat(slnoData[metric] || 0);
                      const checked = parseInt(slnoData.Chk_Pcs) || 0;
                      const perValue = type === 'perc' ? value : parseFloat(slnoData[`${metric}_Per`] || 0);
                      return {
                          value: value,
                          checked: checked,
                          perValue: perValue
                      };
                  }
                  return { value: 0, checked: '-', perValue: 0 };
              });

              series.unshift({
                  name: type === 'qty' ? 'Total' : 'Avg',
				  originalLine: type === 'qty' ? 'Total' : 'Avg',
                  data: totalsData
              });

              buildHeatmap(type);
          },
          error: function () {
              if (spinner) {
                  spinner.classList.add('d-none');
              }
              document.querySelector('#heatmap').innerHTML =
                  `<div class="alert alert-warning text-center">Failed to load heatmap data for Unit ${unit}.</div>`;
          }
      });
  }

  function buildHeatmap(type) {
      $('#heatmapHeader').empty();
      $('#heatmapHeader').append(`<th class="sticky-start">Line</th>`);
      categories.forEach((cat, idx) => {
          const stickyClass = idx === 0 ? 'sticky-second' : '';
          $('#heatmapHeader').append(`<th class="${stickyClass}">${cat}</th>`);
      });

      $('#heatmapBody').empty();
      series.forEach(row => {
          let tr = $('<tr></tr>');
          tr.append(`<td class="sticky-start fw-bold">${row.name}</td>`);
          row.data.forEach((cell, idx) => {
              let bgClass = cell.value == 0 ? 'cell-empty' : getCellColorClass(cell.perValue, currentoption);
              let displayValue = cell.value;
              let checkedText = cell.checked !== '-' ? cell.checked : '';
              let stickyClass = idx === 0 ? 'sticky-second' : '';
              let displayText = type === 'qty' 
                  ? (displayValue == 0 ? '-' : `<div>${Math.floor(displayValue)}</div><div class="checked-value">${checkedText ? `(${checkedText})` : ''}</div>`)
                  : (idx === 0 
                      ? parseFloat(displayValue).toFixed(2) 
                      : (displayValue == 0 ? '-' : `${parseFloat(displayValue).toFixed(2)}%`));
              let td = $(`<td class="${bgClass}${idx >= 0 ? ' clickable' : ''} ${stickyClass}" data-line="${row.originalLine}" data-line-name="${ row.name}" data-date="${categories[idx]}" data-value="${displayValue}" data-checked="${cell.checked}" data-pervalue="${cell.perValue}">${displayText}</td>`);
              tr.append(td);
          });
          $('#heatmapBody').append(tr);
      });

      $('.heatmap-table td.clickable').off('click').on('click', function() {
          const line = $(this).data('line');
          current_line_name  = $(this).data('line-name');
          const xAxisValue = $(this).data('date');
          const selectdate = $('.date-picker-input').val() || '2025-05-01 to 2025-06-15';
          const fromdate = selectdate.split(' to ')[0];
          const fromYear = new Date(fromdate).getFullYear();
          const activeTab = $('.defect-tab.active').data('tab') || 'top5';
          let lineNumber = line.replace('L', '');
          let line_date = xAxisValue + '/' + fromYear;
          let inputDate = line_date.replace(/\s+/g, '').replace(/\//g, '-');
          let parts = inputDate.split('-');
          let formattedDate = `${parts[2]}-${parts[1]}-${parts[0]}`;
          let dateObj = new Date(formattedDate);
          let formattedDate2 = dateObj.toLocaleDateString('en-GB', { day: '2-digit', month: 'short', year: 'numeric' }).replace(/\s/g, '-');
          let from_date = (formattedDate2 == 'Invalid-Date') ? selectdate.split(' to ')[0] : formattedDate2;
          let to_date = (formattedDate2 == 'Invalid-Date') ? selectdate.split(' to ')[1] : formattedDate2;
          let lineoption = (currentoption !== '' ? currentoption : null);

          function getDaysBetweenDates(startDate, endDate) {
              let start = new Date(startDate);
              let end = new Date(endDate);
              let diffTime = Math.abs(end - start);
              let diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
              return diffDays;
          }

          let days = getDaysBetweenDates(from_date, to_date);

          if (lineoption == 'FTR') {
              $.ajax({
                  url: `{{ route('ftr_defect_chart') }}`,
                  method: 'GET',
                  data: {
                      'unitcode': currentUnit,
                      'from_date': from_date,
                      'to_date': to_date,
                      'orderno': currentOrderNo,
                      'lineno': lineNumber
                  },
                  success: function(response) {
                      let trendTitle = document.querySelector('#defectAnalysischart h5');
                      if (trendTitle) {
                          trendTitle.innerHTML = `${currentoption} Defect Trend <span style="color: blue;">( Unit ${currentUnitName} | ${current_line_name} | ${lineoption} )</span>`;
                      }
                      let trend_subTitle = document.querySelector('#defectAnalysischart p');
                      if (trend_subTitle) {
                          if (days === 0) {
                              trend_subTitle.innerHTML = `Daily trends (Absolute counts) for ${currentoption} defects on <span style="color: blue;">${from_date}</span>`;
                          } else {
                              trend_subTitle.innerHTML = `Daily trends (Absolute counts) for ${currentoption} defects over the last <span style="color: blue;">${days} day${days !== 1 ? 's' : ''} before ${to_date}</span>`;
                          }
                      }

                      const rawData = response.data || [];
                      const isDataEmpty = !rawData || rawData.length === 0 || rawData.every(item => parseInt(item.FTR) === 0);
                      const chartContainer = document.querySelector('#trendChart');
                      if (!chartContainer) {
                          chartContainer.innerHTML = `
                              <div class="text-center text-danger" style="height: 300px; display: flex; align-items: center; justify-content: center;">
                                  Chart container not found
                              </div>
                          `;
                          return;
                      }

                      if (trendChart) {
                          try {
                              trendChart.destroy();
                          } catch (e) {}
                          trendChart = null;
                      }

                      if (isDataEmpty) {
                          chartContainer.innerHTML = `
                              <div class="text-center text-muted" style=" display: flex; align-items: center; justify-content: center;">
                                  No data available
                              </div>
                          `;
                          return;
                      }

                      let categories = rawData.map(item => {
                          if (!item.Edate) {
                              return 'Unknown';
                          }
                          const parts = item.Edate.split('-');
                          return parts.length === 3 ? `${parts[2]}/${parts[1]}` : 'Invalid Date';
                      });
                      let defectCounts = rawData.map(item => {
                          const count = parseInt(item.FTR);
                          return isNaN(count) ? 0 : count;
                      });
                      let totalDefects = rawData.map(item => {
                          const total = parseInt(item.Chk_Pcs);
                          return isNaN(total) ? 0 : total;
                      });

                      let percentages = rawData.map(item => {
                          const percent = parseInt(item.FTR_Per);
                          return isNaN(percent) ? 0 : percent;
                      });

                      chartContainer.innerHTML = '';

                      let trendOptions = {
                          chart: {
                              type: 'area',
                              height: 300,
                              toolbar: { show: false },
                              zoom: { enabled: false },
                          },
                          colors: ['#808080'],
                          stroke: {
                              curve: 'smooth',
                              width: 2,
                          },
                          markers: {
                              size: 3,
                          },
                          dataLabels: {
                              enabled: false,
                          },
                          series: [
                              {
                                  name: 'FTR Percentage',
                                  data: percentages,
                              },
                          ],
                          xaxis: {
                              categories: categories,
                              labels: { rotate: -45 },
                          },
                          yaxis: {
                              labels: {
                                  formatter: (val) => `${val.toFixed(2)}%`,
                              },
                              title: {
                                  text: 'Percentage',
                              },
                          },
                          tooltip: {
                              enabled: true,
                              custom: function({ series, seriesIndex, dataPointIndex, w }) {
                                  let defectCount = defectCounts[dataPointIndex];
                                  let totalDefectsVal = totalDefects[dataPointIndex];
                                  let percentage = percentages[dataPointIndex].toFixed(2);
                                  return `
                                      <div style="background: #ffffff; border: 1px solid #e0e0e0; border-radius: 6px; padding: 12px; font-family: 'Arial', sans-serif; font-size: 14px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                                          <div style="margin-bottom: 6px;"><strong>${w.globals.seriesNames[0]}</strong></div>
                                          <div style="margin-bottom: 4px;">FTR: <strong>${defectCount}</strong></div>
                                          <div style="margin-bottom: 4px;">Overall Checked: <strong>${totalDefectsVal}</strong></div>
                                          <div>FTR %: <strong>${percentage}%</strong></div>
                                      </div>
                                  `;
                              }
                          }
                      };

                      try {
                          trendChart = new ApexCharts(chartContainer, trendOptions);
                          trendChart.render();
                      } catch (e) {
                          chartContainer.innerHTML = `
                              <div class="text-center text-danger" style="height: 300px; display: flex; align-items: center; justify-content: center;">
                                  Error rendering chart
                              </div>
                          `;
                      }
                  },
                  error: function(xhr, status, error) {
                      if (trendChart) {
                          try {
                              trendChart.destroy();
                          } catch (e) {}
                          trendChart = null;
                      }
                      const chartContainer = document.querySelector('#trendChart');
                      chartContainer.innerHTML = `
                          <div class="text-center text-danger" style="height: 300px; display: flex; align-items: center; justify-content: center;">
                              Error loading data
                          </div>
                      `;
                  }
              });
          } else {
              renderDefectTable(activeTab, currentUnitName, formattedDate2, formattedDate2, currentUnit, currentOrderNo, lineNumber, currentoption);
          }
      });
  }

  function getCellColorClass(perValue, option) {
      perValue = parseFloat(perValue);
      if (isNaN(perValue)) return 'cell-empty';

      if (option === 'FTR') {
          if (perValue >= 97.5 && perValue <= 100) return 'cell-good';
          if (perValue >= 95 && perValue < 97.5) return 'cell-warning';
          if (perValue >= 0 && perValue < 95) return 'cell-poor';
      } else if (option === 'RW') {
          if (perValue >= 0 && perValue < 1) return 'cell-good';
          if (perValue >= 1 && perValue < 3) return 'cell-warning';
          if (perValue >= 3 && perValue <= 100) return 'cell-poor';
      } else if (option === 'RJ') {
          if (perValue >= 0 && perValue < 0.5) return 'cell-good';
          if (perValue >= 0.5 && perValue < 1) return 'cell-warning';
          if (perValue >= 1 && perValue <= 100) return 'cell-poor';
      }
      return 'cell-empty';
  }

  $(document).ready(function() {
      buildHeatmap();
  });

  // Apply Font Color: Dark Green Always
  function applyCellWiseFontColor(chartContext) {
      const graphics = chartContext?.w?.globals?.graphics?.dataLabels;
      const series = chartContext?.w?.config?.series;
      if (!graphics || !series) return;
      graphics.forEach(row => {
          row.forEach(label => {
              label.setAttribute('fill', '#006400');
          });
      });
  }

  document.addEventListener('click', () => {
    fetch('/check-session')
        .then(response => response.json())
        .then(data => {
            if (!data.active) {
                //alert("⚠️ Your session has timed out.");
                toastr.warning('⚠️ Your session has timed out.');
                setTimeout(() => {
                    window.location.href = "/login";
                }, 3000);
            }
        })
        .catch(err => {
            console.error('Session check failed:', err);
        });
  });

  document.querySelector('[data-tab="unitpercent"]').addEventListener('click', function () {
    const btn = this;
    const viewTables = document.querySelectorAll('.view-table');
    const activeDiv = document.querySelector('.view-table.active');

    // Find the other table (either #table-abs or #table-percent)
    const nextDiv = Array.from(viewTables).find(div => div !== activeDiv && (
      div.querySelector('#table-percent') || div.querySelector('#table-abs')
    ));

    if (nextDiv) {
      activeDiv.classList.remove('active');
      nextDiv.classList.add('active');
    }

    // Toggle the active class on the % button
    btn.classList.toggle('active');
  });
  document.getElementById('ocn-percent-btn').addEventListener('click', function () {
      const btn = this;
      const ocnTableDiv = document.querySelector('#ocnTable').closest('.view-table');
      const ocnPercDiv = document.querySelector('#ocnTableperc').closest('.view-table');
      const isPercActive = ocnPercDiv.classList.contains('active');
      const unit = currentlyHighlightedUnit || 'G1'; // Fallback unit
      const unitcode = currentUnitCode || $('.heatmap_title_select').attr('data-unit') || '';
      const selectdate = document.querySelector('.date-picker-input').value;
      const fromDate = selectdate.split(' to ')[0];
      const toDate = selectdate.split(' to ')[1];

      if (isPercActive) {
          // Switch to Absolute table
          ocnPercDiv.classList.remove('active');
          ocnTableDiv.classList.add('active');
          btn.classList.remove('active');
          btn.style.color = '#6c757d';
          fetchOCNSummary(unit, fromDate, toDate, unitcode, 'qty');
      } else {
          // Switch to Percentage table
          ocnTableDiv.classList.remove('active');
          ocnPercDiv.classList.add('active');
          btn.classList.add('active');
          btn.style.color = 'blue';
          fetchOCNSummary(unit, fromDate, toDate, unitcode, 'perc');
      }
  });

</script>

</body>
</html>