<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Raw Material Management Dashboard</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    

    <style>
        /* Custom Styles */
        body {
            background-color: #f8f9fa;
            font-family: 'Arial', sans-serif;
        }

        /* Header */
        .card-header {
            background-color: #4052B6;
            height: 60px;
            padding: 20px
        }

        .notification-icon {
            position: relative;
        }
        .notification-icon::after {
            content: '5'; /* Display the number of notifications */
            position: absolute;
            top: 0;
            right: 0;
            width: 16px; /* Increased size to accommodate the number */
            height: 16px;
            background-color: #dc3545;
            border-radius: 50%;
            border: 1px solid red;
            transform: translate(50%, -50%);
            color: white;
            font-size: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }

        /* Notification Dropdown */
        .notification-dropdown {
            display: none;
            position: absolute;
            top: 100%;
            right: 0;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            min-width: 250px;
            z-index: 1000;
        }
        .notification-dropdown.show {
            display: block;
        }
        .notification-dropdown::before {
            content: '';
            position: absolute;
            top: -10px;
            right: 15px;
            border-left: 10px solid transparent;
            border-right: 10px solid transparent;
            border-bottom: 10px solid white;
        }
        .notification-item:last-child {
            border-bottom: none;
        }
        .notification-item:first-child{
            border-top:#333
        }
        .notification-item i {
            font-size: 16px;
            margin-right: 10px;
            color: #6c757d;
        }
        .notification-item .message {
            flex-grow: 1;
            font-size: 14px;
            color: #495057;
            font-weight: bold 
        }
        .notification-item .ocn {
            font-size: 12px;
            color: #4052B6;
        }

        /* KPI Dashboard Card */
        .kpi-card, .data-table-card {
            background-color: #FFFFFF;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            padding: 20px;
            margin-bottom: 20px;
        }

        /* KPI Metric Cards */
        .metric-card {
            background-color: white;
            border-radius: 8px;
            padding: 15px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            text-align: left;
            transition: background-color 0.3s;
        }
        .metric-card.active {
            background-color: #4052B6;
            color: white;
        }
        .metric-card.active .card-title,
        .metric-card.active .value,
        .metric-card.active .context,
        .metric-card.active .icon-text {
            color: white;
        }
        .card-title {
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 5px;
            color: black;
        }
        .value {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 5px;
            color: #4052B6;
        }
        .context {
            font-size: 12px;
            color: orangered;
            margin-bottom: 5px;
        }
        .icon-text {
            font-size: 12px;
            color: #6c757d;
            display: flex;
            align-items: center;
        }
        .icon-text i {
            margin-right: 15px;
            color: #6c757d;
        }
        .metric-card.active .icon-text,
        .metric-card.active .icon-text i {
            color: white;
        }

        .icon-text .chart-toggle {
            cursor: pointer;
        }
        .icon-text .chart-toggle.active {
            color: #4052B6;
        }
        .metric-card.active .icon-text .chart-toggle.active {
            color: white;
        }

        /* Line Chart */
        .chart-container {
            height: 350px;
        }

        /* Data Table Tabs */
        .nav-tabs .nav-link {
            color: #333;
            border: none;
            border-bottom: 2px solid transparent;
            transition: all 0.3s;
        }
        .nav-tabs .nav-link:hover {
            border-bottom: 2px solid #4052B6;
        }
        .nav-tabs .nav-link.active {
            color: white;
            border-bottom: 2px solid white;
            background-color: #4052B6;
        }

        /* Data Table */
        .table th {
            background-color: white;
            color: #333;
            font-weight: 600;
        }
        .table tbody tr:nth-child(odd) {
            background-color: #f8f9fa;
        }
        .table tbody tr:hover {
            color: white;
            background-color: #4052B6;
            cursor: pointer;
        }
        
        .btn-group .btn {
            background-color: #e9ecef;
            color: #495057;
            border: none;
            transition: background-color 0.3s, color 0.3s;
        }
        .btn-group .btn.active {
            background-color: #4052B6;
            color: white;
        }

        .status-bar {
            height: 4px;
            border-radius: 2px;
        }
        .status-bar.green {
            background-color: #28a745;
        }
        .status-bar.blue {
            background-color: #007bff;
        }
        .status-dot {
            display: inline-block;
            width: 10px;
            height: 10px;
            border-radius: 50%;
            margin-right: 5px;
        }
        .status-dot.orange {
            background-color: #fd7e14;
        }
        .status-dot.red {
            background-color: #dc3545;
        }
        .status-dot.green {
            background-color: #28a745;
        }

        .modal-content , #commitmentOffcanvas{
            background-color: #F2F8FD;
        }

    </style>
</head>
<body  style="background-color: #F2F8FD">

    <div class="container-fluid my-2">
        
        <div class="card col-12">
            <!-- Header Section -->
            <div class="card-header d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center text-white">
                    <i class="fa-regular fa-newspaper" style="font-size: 24px;"></i>
                    <h4 class=" text-white mt-2" style="margin-left: 15px;">Raw Material View</h4>
                </div>
                <div class="text-white position-relative">
                    <i class="fa-regular fa-bell notification-icon" style="font-size: 24px; cursor: pointer" id="notificationBell"></i>
                    
                    <div class="notification-dropdown" id="notificationDropdown">
                        <div class="card">
                            <h6 class="mt-3 ms-3 text-dark fw-bold bottom-bordered">Focus items (This week)</h6><hr>
                            <div class="card-body ms-3">
                                <div class="notification-item">
                                    <i class="fa-solid fa-triangle-exclamation" style="color:#fd7e14"></i>
                                    <span class="message">Yarn for string</span>
                                    <p class="ocn">OCN: 4233 (Yarn)</p>
                                </div>
                                <div class="notification-item">
                                    <i class="fa-solid fa-triangle-exclamation" style="color: red"></i>
                                    <span class="message">Yarn for canvas</span>
                                    <p class="ocn">OCN: 5890 (Yarn)</p>
                                </div>
                                <div class="notification-item">
                                    <i class="fa-solid fa-triangle-exclamation" style="color:#fd7e14"></i>
                                    <span class="message">String fabric</span>
                                    <p class="ocn">OCN: 4233 (Fabric)</p>
                                </div>
                                <div class="notification-item">
                                    <i class="fa-solid fa-triangle-exclamation" style="color: red"></i>
                                    <span class="message">Canvas fabric</span>
                                    <p class="ocn">OCN: 4334 (Fabric)</p>
                                </div>
                                <div class="notification-item">
                                    <i class="fa-solid fa-triangle-exclamation" style="color:#fd7e14"></i>
                                    <span class="message">Trim for string</span>
                                    <p class="ocn">OCN: 4233 (Sewing trims)</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
            <div class="card-body" style="background-color: #F2F8FD">
                <!-- Main Content -->
                <div class="container-fluid mt-0">
                    <!-- KPI Dashboard Section -->
                    <div class="kpi-card">
                        <div class="row">
                            <!-- KPI Metric Cards (Left Side) -->
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-2 mb-3">
                                        <div class="metric-card active">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div class="col-7">
                                                    <h5 class="card-title fw-bold">PO-delay</h5>
                                                    <div class="context">Since last week</div>
                                                </div>
                                                <div class="value">80 %</div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center icon-text mt-2">   
                                                <i class="fa-solid fa-clock"></i>
                                                <i class="fa-solid fa-chart-line me-4  chart-toggle"></i>
                                                Exceeding Target  
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <div class="metric-card">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div class="col-7">
                                                    <h5 class="card-title fw-bold">RM delay</h5>
                                                    <div class="context">Current Month</div>
                                                </div>
                                                <div class="value">15 %</div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center icon-text mt-2">   
                                                <i class="fa-solid fa-truck me-4"></i>
                                                <i class="fa-solid fa-chart-line me-4 chart-toggle"></i>
                                                Per of Delays  
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <div class="metric-card">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div class="col-7">
                                                    <h5 class="card-title fw-bold">Lead Time Dev</h5>
                                                    <div class="context">Current Avg</div>
                                                </div>
                                                <div class="value">3 days</div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center icon-text mt-2">   
                                                <i class="fa-solid fa-wave-square me-4"></i>
                                                <i class="fa-solid fa-chart-line me-4 chart-toggle"></i>
                                                vs Planned 
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <div class="metric-card">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div class="col-7">
                                                    <h5 class="card-title fw-bold">Commit. Slips</h5>
                                                    <div class="context">Past Quarter</div>
                                                </div>
                                                <div class="value">12 slips</div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center icon-text mt-2">   
                                                <i class="fa-solid fa-file-arrow-up me-4"></i>
                                                <i class="fa-solid fa-chart-line me-4 chart-toggle"></i>
                                                Delivery Impact
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <div class="metric-card">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div class="col-7">
                                                    <h5 class="card-title fw-bold">Inventory Cost</h5>
                                                    <div class="context">YTD Change</div>
                                                </div>
                                                <div class="value">+1.2 M</div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center icon-text mt-2">   
                                                <i class="fa-solid fa-dollar-sign me-4"></i>
                                                <i class="fa-solid fa-chart-line me-4 chart-toggle"></i>
                                                Financial Impact
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <div class="metric-card">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div class="col-7">
                                                    <h5 class="card-title fw-bold">Ret. to Supplier</h5>
                                                    <div class="context">Last 30 Days</div>
                                                </div>
                                                <div class="value">2.5 %</div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center icon-text mt-2">   
                                                <i class="fa-solid fa-reply me-4"></i>
                                                <i class="fa-solid fa-chart-line me-4 chart-toggle"></i>
                                                Quality Issues
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                        <!-- Line Chart (Right Side) -->
                            <div class="col-md-12 d-none kpi-trends-chart">
                                <div class="chart-container">
                                    <canvas id="kpiChart"></canvas>
                                </div>
                            </div>
                    </div>

                    <!-- Data Table Section -->
                    <div class="data-table-card">
                        <!-- Tab Navigation -->
                        <div class="btn-group d-flex" role="group" aria-label="Material Tabs" id="materialTabs">
                            <button type="button" class="btn flex-fill active" id="yarn-tab" data-bs-toggle="tab" data-bs-target="#yarn" role="tab" aria-controls="yarn" aria-selected="true">Yarn</button>
                            <button type="button" class="btn flex-fill" id="fabric-tab" data-bs-toggle="tab" data-bs-target="#fabric" role="tab" aria-controls="fabric" aria-selected="false">Fabric</button>
                            <button type="button" class="btn flex-fill" id="sewing-trims-tab" data-bs-toggle="tab" data-bs-target="#sewing-trims" role="tab" aria-controls="sewing-trims" aria-selected="false">Sewing Trims</button>
                            <button type="button" class="btn flex-fill" id="packing-trims-tab" data-bs-toggle="tab" data-bs-target="#packing-trims" role="tab" aria-controls="packing-trims" aria-selected="false">Packing Trims</button>
                        </div>

                        <!-- Tab Content -->
                        <div class="tab-content" id="materialTabContent">
                            <!-- Yarn Tab -->
                            <div class="tab-pane fade show active" id="yarn" role="tabpanel" aria-labelledby="yarn-tab">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>OCN</th>
                                                <th>Item</th>
                                                <th>PO Issued</th>
                                                <th>Lead Time</th>
                                                <th>Quantity</th>
                                                <th>Est. In-Date</th>
                                                <th>Committed Date</th>
                                                <th>Inspection</th>
                                                <th>Process Owner</th>
                                                <th>Supplier</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>4233</td>
                                                <td>Yarn for String</td>
                                                <td>
                                                    <div class="status-dot green po-trigger"
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#poModal" 
                                                            data-ocn="4233" 
                                                            data-item="Yarn for String"></div>
                                                </td>
                                                <td>34 D</td>
                                                <td>
                                                    <div class="status-bar blue grn-trigger" style="width: 40px;"
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#grnModal" 
                                                            data-ocn="4233" 
                                                            data-item="Yarn for String"></div>
                                                </td>
                                                <td>15/08/24</td>
                                                <td class="text-primary commit-trigger"
                                                        data-bs-toggle="offcanvas" 
                                                        data-bs-target="#commitmentOffcanvas"
                                                        data-ocn="4233" 
                                                        data-item="Yarn for String">10/08/25</td>
                                                <td>Pending</td>
                                                <td>Mr. Smith</td>
                                                <td>SupplyX</td>
                                                <td>
                                                    <span class="status-dot orange" data-bs-toggle="tooltip" data-bs-placement="top" title="Pending"></span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>5890</td>
                                                <td>Yarn for Canvas</td>
                                                <td>
                                                    <div class="status-dot green po-trigger"
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#poModal" 
                                                            data-ocn="5890" 
                                                            data-item="Yarn for Canvas"></div>
                                                </td>
                                                <td>45 D</td>
                                                <td>
                                                    <div class="status-bar blue grn-trigger" style="width: 40px;"
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#grnModal" 
                                                            data-ocn="5890" 
                                                            data-item="Yarn for Canvas"></div>
                                                </td>
                                                <td>20/09/24</td>
                                                <td class="text-primary commit-trigger" 
                                                        data-bs-toggle="offcanvas" 
                                                        data-bs-target="#commitmentOffcanvas"
                                                        data-ocn="5890" 
                                                        data-item="Yarn for Canvas">
                                                        15/09/24
                                                    </td>
                                                <td>Passed</td>
                                                <td>Ms. Jones</td>
                                                <td>Fabrica Ltd.</td>
                                                <td>
                                                    <span class="status-dot red" data-bs-toggle="tooltip" data-bs-placement="top" title="Passed"></span>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <!-- Fabric Tab -->
                            <div class="tab-pane fade" id="fabric" role="tabpanel" aria-labelledby="fabric-tab">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>OCN</th>
                                                <th>Item</th>
                                                <th>Color</th>
                                                <th>Yarn</th>
                                                <th>PO Issued</th>
                                                <th>Lead Time</th>
                                                <th>Quantity</th>
                                                <th>Est. In-Date</th>
                                                <th>Committed Date</th>
                                                <th>Inspection</th>
                                                <th>Process Owner</th>
                                                <th>Supplier</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>4233</td>
                                                <td>String Fabric</td>
                                                <td>Royal Blue</td>
                                                <td>
                                                    <div class="status-dot green fabric-trigger"
                                                        data-bs-toggle="modal" 
                                                        data-bs-target="#fabricModal" 
                                                        data-ocn="4233" 
                                                        data-item="String Fabric"></div>
                                                </td>
                                                <td>
                                                    <div class="status-bar green po-trigger" 
                                                            style="width: 40px;" 
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#poModal" 
                                                            data-ocn="4233" 
                                                            data-item="String Fabric"></div>
                                                </td>
                                                <td>34 D</td>
                                                <td>
                                                    <div class="status-bar blue grn-trigger" 
                                                            style="width: 40px;" 
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#grnModal" 
                                                            data-ocn="4233" 
                                                            data-item="String Fabric"></div>
                                                </td>
                                                <td>15/08/24</td>
                                                <td class="text-primary commit-trigger"
                                                        data-bs-toggle="offcanvas" 
                                                        data-bs-target="#commitmentOffcanvas"
                                                        data-ocn="4233" 
                                                        data-item="String Fabric">10/08/25</td>
                                                <td>Pending</td>
                                                <td>Mr. Smith</td>
                                                <td>SupplyX</td>
                                                <td>
                                                    <span class="status-dot orange" data-bs-toggle="tooltip" data-bs-placement="top" title="Pending"></span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>5890</td>
                                                <td>Canvas Fabric</td>
                                                <td>Natural White</td>
                                                <td>
                                                    <div class="status-dot red fabric-trigger" 
                                                        data-bs-toggle="modal" 
                                                        data-bs-target="#fabricModal" 
                                                        data-ocn="5890" 
                                                        data-item="Canvas Fabric"></div>
                                                </td>
                                                <td>
                                                    <div class="status-bar green po-trigger" 
                                                            style="width: 40px;" 
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#poModal" 
                                                            data-ocn="5890" 
                                                            data-item="Canvas Fabric"></div>
                                                </td>
                                                <td>45 D</td>
                                                <td>
                                                    <div class="status-bar blue grn-trigger" 
                                                            style="width: 40px;" 
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#grnModal" 
                                                            data-ocn="5890" 
                                                            data-item="Canvas Fabric"></div>
                                                </td>
                                                <td>20/09/24</td>
                                                <td class="text-primary commit-trigger"
                                                        data-bs-toggle="offcanvas" 
                                                        data-bs-target="#commitmentOffcanvas"
                                                        data-ocn="5890" 
                                                        data-item="Canvas Fabric">15/09/24</td>
                                                <td>Passed</td>
                                                <td>Ms. Jones</td>
                                                <td>Fabrica Ltd.</td>
                                                <td>
                                                    <span class="status-dot red" data-bs-toggle="tooltip" data-bs-placement="top" title="Passed"></span>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <!-- Sewing Trims Tab -->
                            <div class="tab-pane fade" id="sewing-trims" role="tabpanel" aria-labelledby="sewing-trims-tab">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>OCN</th>
                                                <th>Item</th>
                                                <th>PO Issued</th>
                                                <th>Lead Time</th>
                                                <th>Quantity</th>
                                                <th>Est. In-Date</th>
                                                <th>Committed Date</th>
                                                <th>Inspection</th>
                                                <th>Process Owner</th>
                                                <th>Supplier</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>4233</td>
                                                <td>Trim for String</td>
                                                <td>
                                                    <div class="status-bar green po-trigger" 
                                                            style="width: 40px;" 
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#poModal" 
                                                            data-ocn="4233" 
                                                            data-item="Trim for String"></div>
                                                </td>
                                                <td>34 D</td>
                                                <td>
                                                    <div class="status-bar blue grn-trigger" 
                                                            style="width: 40px;" 
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#grnModal" 
                                                            data-ocn="4233" 
                                                            data-item="Trim for String"></div>
                                                </td>
                                                <td>15/08/24</td>
                                                <td class="text-primary commit-trigger"
                                                            data-bs-toggle="offcanvas" 
                                                            data-bs-target="#commitmentOffcanvas"
                                                            data-ocn="4233" 
                                                            data-item="Trim for String">10/08/25</td>
                                                <td>Pending</td>
                                                <td>Mr. Smith</td>
                                                <td>SupplyX</td>
                                                <td>
                                                    <span class="status-dot orange" data-bs-toggle="tooltip" data-bs-placement="top" title="Pending"></span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>5890</td>
                                                <td>Trim for Canvas</td>
                                                <td>
                                                    <div class="status-bar green po-trigger" 
                                                            style="width: 40px;" 
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#poModal" 
                                                            data-ocn="5890" 
                                                            data-item="Trim for Canvas"></div>
                                                </td>
                                                <td>45 D</td>
                                                <td>
                                                    <div class="status-bar blue grn-trigger" 
                                                            style="width: 40px;" 
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#grnModal" 
                                                            data-ocn="5890" 
                                                            data-item="Trim for Canvas"></div>
                                                </td>
                                                <td>20/09/24</td>
                                                <td class="text-primary commit-trigger" 
                                                    data-bs-toggle="offcanvas" 
                                                    data-bs-target="#commitmentOffcanvas"
                                                    data-ocn="5890" 
                                                    data-item="Trim for Canvas">
                                                    15/09/24
                                                </td>
                                                <td>Passed</td>
                                                <td>Ms. Jones</td>
                                                <td>Fabrica Ltd.</td>
                                                <td>
                                                    <span class="status-dot red" data-bs-toggle="tooltip" data-bs-placement="top" title="Passed"></span>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <!-- Packing trims -->
                            <div class="tab-pane fade" id="packing-trims" role="tabpanel" aria-labelledby="packing-trims-tab">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>OCN</th>
                                                <th>Item</th>
                                                <th>PO Issued</th>
                                                <th>Lead Time</th>
                                                <th>Quantity</th>
                                                <th>Est. In-Date</th>
                                                <th>Committed Date</th>
                                                <th>Inspection</th>
                                                <th>Process Owner</th>
                                                <th>Supplier</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>4233</td>
                                                <td>Packaging for String</td>
                                                <td>
                                                    <div class="status-bar green po-trigger" 
                                                            style="width: 40px;" 
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#poModal" 
                                                            data-ocn="4233" 
                                                            data-item="Packaging for String"></div>
                                                </td>
                                                <td>34 D</td>
                                                <td>
                                                    <div class="status-bar blue grn-trigger" 
                                                            style="width: 40px;" 
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#grnModal" 
                                                            data-ocn="4233" 
                                                            data-item="Packaging for String"></div>
                                                </td>
                                                <td>15/08/24</td>
                                                <td class="text-primary commit-trigger"
                                                            data-bs-toggle="offcanvas" 
                                                            data-bs-target="#commitmentOffcanvas"
                                                            data-ocn="4233" 
                                                            data-item="Packaging for String">10/08/25</td>
                                                <td>Pending</td>
                                                <td>Mr. Smith</td>
                                                <td>SupplyX</td>
                                                <td>
                                                    <span class="status-dot orange" data-bs-toggle="tooltip" data-bs-placement="top" title="Pending"></span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>5890</td>
                                                <td>Packaging for Canvas</td>
                                                <td>
                                                    <div class="status-bar green po-trigger" 
                                                            style="width: 40px;" 
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#poModal" 
                                                            data-ocn="5890" 
                                                            data-item="Packaging for Canvas"></div>
                                                </td>
                                                <td>45 D</td>
                                                <td>
                                                    <div class="status-bar blue grn-trigger" 
                                                            style="width: 40px;" 
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#grnModal" 
                                                            data-ocn="5890" 
                                                            data-item="Packaging for Canvas"></div>
                                                </td>
                                                <td>20/09/24</td>
                                                <td class="text-primary commit-trigger" 
                                                    data-bs-toggle="offcanvas" 
                                                    data-bs-target="#commitmentOffcanvas"
                                                    data-ocn="5890" 
                                                    data-item="Packaging for Canvas">
                                                    15/09/24
                                                </td>
                                                <td>Passed</td>
                                                <td>Ms. Jones</td>
                                                <td>Fabrica Ltd.</td>
                                                <td>
                                                    <span class="status-dot red" data-bs-toggle="tooltip" data-bs-placement="top" title="Passed"></span>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- GRN Modal -->
        <div class="modal fade" id="grnModal" tabindex="-1" aria-labelledby="grnModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content shadow-sm rounded-3">
            <div class="modal-header">
                <div>
                <h5 class="modal-title fw-bold">Goods Received Note (GRN) Details</h5>
                <p class="text-muted mb-0 small">For: Packaging for String (OCN: 4233)</p>
                </div>
                <span class="ms-auto small text-muted">Est. In-Date: <strong>15/08/24</strong></span>
                <button type="button" class="btn-close ms-3" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <div class="modal-body px-3 pt-3 pb-2">
                <div class="table-responsive">
                <table class="table table-sm align-middle table-bordered">
                    <thead class="table-light">
                    <tr>
                        <th>PO #</th>
                        <th>PO Date</th>
                        <th>PO Qty</th>
                        <th>GRN #</th>
                        <th>DC #</th>
                        <th>GRN Date</th>
                        <th>GRN Qty</th>
                        <th>Inspection</th>
                        <th>Supplier</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>PO12345</td>
                        <td>01/07/24</td>
                        <td>50</td>
                        <td>GRN701</td>
                        <td>DC501</td>
                        <td>10/08/24</td>
                        <td>50</td>
                        <td><span class="badge bg-success">Passed</span></td>
                        <td>SupplyX</td>
                    </tr>
                    <tr>
                        <td>PO12346</td>
                        <td>12/07/24</td>
                        <td>50</td>
                        <td>GRN703</td>
                        <td>DC503</td>
                        <td>15/08/24</td>
                        <td>50</td>
                        <td><span class="badge bg-success">Passed</span></td>
                        <td>SupplyX</td>
                    </tr>
                    </tbody>
                </table>
                </div>
            </div>

            <div class="modal-footer d-flex justify-content-between">
                <div class="text-success small">
                <i class="bi bi-check-circle-fill"></i> All items received for associated POs (100)
                </div>
               
            </div>
            </div>
        </div>
        </div>

        <div class="modal fade" id="poModal" tabindex="-1" aria-labelledby="poModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content shadow-lg rounded-3">
            <div class="modal-header ">
                <div>
                <h5 class="modal-title fw-bold">Purchase Order Details</h5>
                <p class="mb-0 text-muted small">For: Yarn for String (OCN: 4233)</p>
                </div>
                <span class="text-muted small ms-auto">Due: <strong>10/07/24</strong></span>
                <button type="button" class="btn-close ms-3" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body px-3 pt-3 pb-2">
                <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-light">
                    <tr>
                        <th>PO Number</th>
                        <th>Placed Date</th>
                        <th>Quantity</th>
                        <th>Supplier</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>PO12345</td>
                        <td>01/07/24</td>
                        <td>50</td>
                        <td>SupplyX</td>
                    </tr>
                    <tr class="table-danger">
                        <td>PO12346</td>
                        <td>
                        12/07/24
                        <span class="text-danger ms-1" title="Delayed">
                            ⚠️
                        </span>
                        </td>
                        <td>50</td>
                        <td>SupplyX</td>
                    </tr>
                    </tbody>
                </table>
                </div>
            </div>
            <div class="modal-footer d-flex ">
                <div class="text-success small">
                <i class="bi bi-check-circle-fill"></i>
                All POs issued for required quantity (100)
                </div>
            </div>
            </div>
        </div>
        </div>

        <div class="modal fade" id="fabricModal" tabindex="-1" aria-labelledby="fabricModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content shadow-sm rounded-3">
                    <div class="modal-header ">
                        <div>
                        <h5 class="modal-title fw-bold">Fabric Process Flow</h5>
                        <p class="text-muted mb-0 small">OCN: 5890 – Item: Canvas Fabric</p>
                        </div>
                        <button type="button" class="btn-close ms-auto" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body px-3 py-2">

                        <div class="accordion" id="fabricProcessAccordion">

                        <!-- Carding -->
                        <div class="accordion-item border-0 mb-2">
                            <h2 class="accordion-header">
                            <button class="accordion-button collapsed bg-white" type="button" data-bs-toggle="collapse" data-bs-target="#cardingCollapse">
                                <div class="d-flex flex-column w-100">
                                <div class="d-flex justify-content-between">
                                    <strong>Carding</strong>
                                    <span class="text-muted small">04/06/24 to 05/06/24</span>
                                </div>
                                <div class="text-success small">Completed 1 day early</div>
                                <div class="progress mt-2" style="height: 6px;">
                                    <div class="progress-bar bg-success" style="width: 100%;"></div>
                                </div>
                                <div class="small text-muted mt-1">GRN: 480 / PO Issued: 490 / Target: 490 kg</div>
                                </div>
                            </button>
                            </h2>
                            <div id="cardingCollapse" class="accordion-collapse collapse" data-bs-parent="#fabricProcessAccordion">
                            <div class="accordion-body">
                                <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <thead class="table-light">
                                    <tr>
                                        <th>PO #</th>
                                        <th>GRN #</th>
                                        <th>PO Date</th>
                                        <th>GRN Date</th>
                                        <th>PO Qty</th>
                                        <th>GRN Qty</th>
                                        <th>Supplier</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>PO-CARD-001</td>
                                        <td>GRN-CARD-001</td>
                                        <td>03/06/24</td>
                                        <td>05/06/24</td>
                                        <td>490</td>
                                        <td>480</td>
                                        <td>Carding Services</td>
                                    </tr>
                                    </tbody>
                                </table>
                                </div>
                                <div class="text-muted small mt-1">PO Qty Left for this Step: 0 kg (Target: 490 kg)</div>
                            </div>
                            </div>
                        </div>

                        <!-- Knitting -->
                        <div class="accordion-item border-0 mb-2">
                            <h2 class="accordion-header">
                            <button class="accordion-button collapsed bg-white" type="button" data-bs-toggle="collapse" data-bs-target="#knittingCollapse">
                                <div class="d-flex flex-column w-100">
                                <div class="d-flex justify-content-between">
                                    <strong>Knitting</strong>
                                    <span class="text-muted small">06/06/24 to Est. Ongoing</span>
                                </div>
                                <div class="text-primary small">Est. to complete on time</div>
                                <div class="progress mt-2" style="height: 6px;">
                                    <div class="progress-bar bg-info" style="width: 10%;"></div>
                                </div>
                                <div class="small text-muted mt-1">GRN: 0 / PO Issued: 480 / Target: 480 kg</div>
                                </div>
                            </button>
                            </h2>
                            <div id="knittingCollapse" class="accordion-collapse collapse" data-bs-parent="#fabricProcessAccordion">
                            <div class="accordion-body">
                                <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <thead class="table-light">
                                    <tr>
                                        <th>PO #</th>
                                        <th>GRN #</th>
                                        <th>PO Date</th>
                                        <th>GRN Date</th>
                                        <th>PO Qty</th>
                                        <th>GRN Qty</th>
                                        <th>Supplier</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>PO-KNIT-001</td>
                                        <td>-</td>
                                        <td>05/06/24</td>
                                        <td>-</td>
                                        <td>480</td>
                                        <td>0</td>
                                        <td>KnitWorld</td>
                                    </tr>
                                    </tbody>
                                </table>
                                </div>
                                <div class="text-muted small mt-1">PO Qty Left for this Step: 480 kg (Target: 480 kg)</div>
                            </div>
                            </div>
                        </div>

                        <!-- Washing -->
                        <div class="accordion-item border-0">
                            <h2 class="accordion-header">
                            <button class="accordion-button collapsed bg-white" type="button" data-bs-toggle="collapse" data-bs-target="#washingCollapse">
                                <div class="d-flex flex-column w-100">
                                <div class="d-flex justify-content-between">
                                    <strong>Washing</strong>
                                </div>
                                <div class="progress mt-2" style="height: 6px;">
                                    <div class="progress-bar bg-secondary" style="width: 0%;"></div>
                                </div>
                                <div class="small text-muted mt-1">GRN: 0 / PO Issued: 0 / Target: 450 kg</div>
                                </div>
                            </button>
                            </h2>
                            <div id="washingCollapse" class="accordion-collapse collapse" data-bs-parent="#fabricProcessAccordion">
                            <div class="accordion-body text-muted small">
                                No PO or GRN issued yet for this step.
                            </div>
                            </div>
                        </div>

                        </div> <!-- end accordion -->
                    </div>
                </div>
            </div>
        </div>

        <div class="offcanvas offcanvas-end" tabindex="-1" id="commitmentOffcanvas" aria-labelledby="commitmentOffcanvasLabel">
        <div class="offcanvas-header border-bottom">
            <div>
            <h5 class="offcanvas-title fw-bold">Update Commitment</h5>
            <p class="text-muted small mb-0">For: Yarn for Canvas (OCN: 5890)</p>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>

        <div class="offcanvas-body">
            <!-- Commitment History -->
            <div class="mb-4">
            <h6 class="text-muted small mb-2">Commitment History</h6>
            <div class="border rounded p-2 bg-light small">
                <strong>Committed Date:</strong> 10 Sep 24<br>
                <strong>Reason:</strong> Original plan.<br>
                <span class="text-muted">Recorded: 16 Jun 2025, 11:26</span>
            </div>
            </div>

            <!-- Update Commitment Date -->
            <div class="mb-3">
            <label for="newCommitDate" class="form-label fw-semibold">New Committed Date</label>
            <input type="text" id="newCommitDate" class="form-control" placeholder="Select date">
            </div>

            <!-- Reason -->
            <div class="mb-4">
            <label for="reasonText" class="form-label fw-semibold">Reason for Change</label>
            <textarea id="reasonText" class="form-control" rows="3" placeholder="E.g., Supplier delay, production rescheduled..."></textarea>
            </div>

            <!-- Save Button -->
            <div class="d-grid">
            <button class="btn btn-primary">💾 Save Commitment</button>
            </div>
        </div>
        </div>
        
    </div>
    

    <!-- Bootstrap 5 JS and Popper.js -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Chart.js for the line chart -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

    <!-- Flatpickr Datepicker Initialization -->
    <script>
    flatpickr("#newCommitDate", {
        dateFormat: "d M y",
        defaultDate: "today"
    });
    </script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            let chartToggles = document.querySelectorAll('.chart-toggle');
            let kpiChartContainer = document.querySelector('.kpi-trends-chart');
            
            chartToggles.forEach(toggle => {
                toggle.addEventListener('click', function () {
                    kpiChartContainer.classList.toggle('d-none');
                    this.classList.toggle('active');
                });
            });
        });

        // Notification Bell Click to Toggle Dropdown
        $(document).ready(function() {
            $('#notificationBell').click(function(e) {
                e.preventDefault();
                $('#notificationDropdown').toggleClass('show');
            });

            // Close dropdown when clicking outside
            $(document).click(function(e) {
                if (!$(e.target).closest('#notificationBell, #notificationDropdown').length) {
                    $('#notificationDropdown').removeClass('show');
                }
            });
        });

        // Initialize Chart.js Line Chart
        const ctx = document.getElementById('kpiChart').getContext('2d');
        const kpiChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
                datasets: [{
                    label: 'Material Usage',
                    data: [120, 150, 100, 170, 130, 180],
                    borderColor: '#4052B6',
                    backgroundColor: 'rgba(64, 82, 182, 0.1)',
                    fill: true,
                    tension: 0.4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        max: 200,
                        title: {
                            display: true,
                            text: 'Values'
                        }
                    },
                    x: {
                        title: {
                            display: true,
                            text: 'Months'
                        }
                    }
                },
                plugins: {
                    tooltip: {
                        enabled: true
                    },
                    legend: {
                        display: false
                    }
                }
            }
        });

    </script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const tabs = document.querySelectorAll('#materialTabs .btn');
        
        tabs.forEach(tab => {
            tab.addEventListener('click', function () {
                // Remove active class from all buttons and panes
                tabs.forEach(t => t.classList.remove('active'));
                document.querySelectorAll('.tab-pane').forEach(pane => {
                    pane.classList.remove('show', 'active');
                });

                // Add active class to the clicked button and corresponding pane
                this.classList.add('active');
                const targetPane = document.querySelector(this.getAttribute('data-bs-target'));
                targetPane.classList.add('show', 'active');
            });
        });
    });

    document.querySelectorAll('.po-trigger').forEach(el => {
        el.addEventListener('click', function () {
            const ocn = this.dataset.ocn;
            const item = this.dataset.item;
            document.querySelector('#poModal .modal-title').innerText = `PO Details for ${item}`;
        });
    });

    document.querySelectorAll('.grn-trigger').forEach(el => {
        el.addEventListener('click', function () {
            const ocn = this.dataset.ocn;
            const item = this.dataset.item;
            document.querySelector('#grnModal .modal-title').innerText = `GRN Details - ${item}`;
        });
    });

    document.querySelectorAll('.fabric-trigger').forEach(el => {
        el.addEventListener('click', function () {
            const ocn = this.dataset.ocn;
            const item = this.dataset.item;
            document.querySelector('#fabricModal .modal-title').innerText = `Fabric Process Flow - ${item}`;
        });
    });

    document.querySelectorAll('.commit-trigger').forEach(el => {
        el.addEventListener('click', function () {
            const ocn = this.dataset.ocn;
            const item = this.dataset.item;
            document.querySelector('#commitmentOffcanvas .offcanvas-title').innerText = `Update Commitment - ${item}`;
        });
    });

</script>
</body>
</html>