<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>DASHBOARD</title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="gplogofinal.png" type="png">


    <!-- alert message for reset password--starts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.4.1/jquery.easing.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">

    <!-- CSS Files -->
    <link rel="stylesheet" href="{{ asset('frontend/css/dashboard.css')}}">
    <link rel="stylesheet" href="{{ asset('frontend/css/bootstrap.min.css')}}">

    <style>
        .modal-confirm {
            color: black;
            width: 450px;
            font-family: 'Varela Round', sans-serif;
        }

        .modal-confirm .modal-content {
            padding: 10px;
            border-radius: 5px;
            border: none;
        }

        .modal-confirm .modal-header {
            border-bottom: none;
            position: relative;
            justify-content: center;
            border-radius: 5px 5px 0 0;
        }

        .modal-confirm h4 {
            color: #545557;
            text-align: center;
            font-size: 25px;
            margin: 5px;

        }

        .modal-confirm .form-control,
        .modal-confirm .btn {
            min-height: 40px;
            border-radius: 3px;
        }

        .modal-confirm .close {
            background: #c0c3c8;
            position: absolute;
            top: 15px;
            right: 15px;
            color: #fff;
            text-shadow: none;
            opacity: 0.5;
            width: 30px;
            height: 30px;
            padding: 0;
            border-radius: 20px;
            font-size: 16px;
        }

        .modal-confirm .close:hover {
            opacity: 0.8;
        }

        .modal-confirm .btn {
            color: #fff;
            border-radius: 4px;
            background: radial-gradient(100% 100% at 100% 0, #5adaff 0, #074d66 100%);
            text-decoration: none;
            transition: all 0.4s;
            line-height: normal;
            border-radius: 3px;
            min-width: 100px;
            border: none;
        }

        .modal-confirm .btn:hover,
        .modal-confirm .btn:focus {
            background: radial-gradient(100% 100% at 100% 0, #074d66 0, #5adaff 100%);
            outline: none;
        }

        .triangle {
            width: 0;
            height: 0;
            border-left: 50px solid transparent;
            border-right: 50px solid transparent;
            border-bottom: 87px solid #f8d7da;
            position: relative;
        }

        .alert-symbol {
            position: absolute;
            top: 28px;
            left: 50%;
            transform: translateX(-50%);
            font-size: 2rem;
            color: #721c24;
        }

        .second {
            max-width: 1200px;
            margin: 10px auto;
            padding: 1px;
            background-image: linear-gradient(rgba(0, 0, 0, 0.3), rgba(0, 0, 0, 0.3)), url('quote_background-2.png');
            background-position: center;
            background-size: cover;
            border: 1px solid #b0d2cb;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
            text-align: center;
            position: relative;
            border-radius: 15px;
        }

        /* Global styles */
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            background-color: #f8fffe;
        }

        /* Quotation marks */
        .quote-container::before,
        .quote-container::after {
            content: '"';
            font-size: 4em;
            color: #ebeff1;
            position: absolute;
            font-family: Georgia, serif;
        }

        .quote-container::before {
            top: -15px;
            left: 4px;
        }

        .quote-container::after {
            bottom: -40px;
            right: 4px;
        }

        /* Typewriter text */
        #quote-text {
            margin-top: 1px;
            margin-bottom: 1px;
            font-size: 1.5em;
            font-family: Copperplate, Papyrus, fantasy;
            font-weight: bold;
        }

        .dropdown-menu {
            max-height: 300px;
            overflow-y: auto;
        }
    </style>

    <style>
        #surya {
            margin-left: 20px !important;
            margin-top: 1px;
            margin-bottom: 1px;
            font-size: 1.5em;
            font-family: Copperplate, Papyrus, fantasy;
            font-weight: bold;
        }
    </style>

    <!-- alert message for reset password--starts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- alert message for reset password--starts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.4.1/jquery.easing.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">


    <!-- CSS Files -->
    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <style>
        .card-animate1 {
            box-shadow: 0 0 15px rgba(0, 114, 255, 0.6);
            transition: box-shadow 0.3s ease;
        }

        .card-animate1:hover {
            box-shadow: 0 0 25px rgba(0, 114, 255, 1);
        }
    </style>


</head>

<body>

    @section('tittle') {{"DASHBOARD"}}@endsection

    @php
    $head_det1 = \App\Models\orgs::where('user_id_number', Session::get('user_data'))->get();
    $head_det= Session::get('user_data');
    $empl_tno= Session::get('user_data');
    $empl_no= Session::get('empl_id');
    $empl_name = Session::get('emp_name');
    $Ctc_right= Session::get('Ctc_rights');
    @endphp

    <div id="layout-wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row dash-nft">
                        <div class="col-xxl-12">

                            @if ($message = Session::get('alert'))
                            <div id="successAlert" class="alert alert-danger alert-dismissible fade show" role="alert">
                                {{$message}}
                            </div>
                            <script>
                                // Automatically close the alert after 3 seconds
                                setTimeout(function() {
                                    var successAlert = document.getElementById('successAlert');
                                    if (successAlert) {
                                        successAlert.remove();
                                    }
                                }, 5000);
                            </script>
                            @endif

                            <!-- ALERT MESSAGE FOR RESET PASSWORD--STARTS -->
                            <?php
                            $due_days = Session('due_day');
                            ?>
                            <div id="myModal" class="modal fade">
                                <div class="modal-dialog modal-confirm">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><span>&times;</span></button>
                                        </div>
                                        <div class="modal-body text-center">
                                            <p style="font-family: 'Varela Round', sans-serif;">
                                                Your Password Need to Change Within
                                                @if ($due_days > 1)
                                                {{ $due_days }} Days
                                                @elseif ($due_days <= 1) {{ "a Day" }} @endif </p>
                                                    <button class="btn" data-dismiss="modal">OK</button>
                                        </div>
                                        <div class="link float-right" style="margin-left:300px;">
                                            <a href="reset">TO CHANGE <i class="fas fa-arrow-right"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            @if ($due_days <= 3) <script>
                                $(document).ready(function(){
                                $(".modal").modal();
                                });
                                </script>
                                @endif

                                <!-- ALERT MESSAGE FOR RESET PASSWORD--ENDS -->
                                <div class="panel-header">
                                    <div class="page-inner py-0">
                                        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                                            <div class="ml-md-auto py-2 py-md-0">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- QUOTES -->
                                <div class="w3-container">
                                    <div class="w3-panel w3-ios-background second">
                                        <div class="d-flex justify-content-around">
                                            <div class="quote-container quote">
                                                <div data-quote="<%= @thought %>">
                                                    <p id="quote-text" class="text-white"></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- EMPLOOYEE AND CTC -->
                                <div class="row">
                                    @php
                                    $admin_det = \App\Models\orgs::where('admin_id_number', Session::get('user_data'))->get();
                                    $empl_tno= Session::get('user_data');
                                    $emp_name = Session::get('emp_name');
                                    // print_r($admin_det);
                                    @endphp

                                    <!-- EMPLOYEE AND MONTH -->
                                    <div class="col-xl-3 col-md-6">
                                        <div class="card card-height-50">
                                            <div class="card-body">
                                                <select name="grid" id="grid" onchange="nowchange(this.value)" class="form-select select2 mb-2" required>
                                                    <option value="" selected disabled>SELECT EMPLOYEE</option>
                                                    <option value="{{ $empl_no }}">{{ $empl_name }}</option>
                                                    @foreach ($admin_det as $key => $adminDtls)
                                                    <option value="{{ $adminDtls['user_emp_id'] }}">{{ $adminDtls['user_name'] }}</option>
                                                    @endforeach
                                                </select>
                                                <div class="mt-2 pt-1">
                                                    <h1 class="h6 mb-0 font-weight-bold mr-1">Month</h1>
                                                    <!-- DATE INPUT FIELD -->
                                                    <input type="date" onchange="changeDate()" name="fdate" id="fdate" value="{{ date('Y-m-d') }}" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- EMP CTC -->
                                    <div class="col-xl-3 col-md-6">
                                        <div class="card card-height-50">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar-sm flex-shrink-0">
                                                        <span class="avatar-title bg-info-subtle rounded fs-3">
                                                            <i class="bx bx-wallet text-info"></i>
                                                        </span>
                                                    </div>
                                                    <div class="flex-grow-1 ps-3">
                                                        <h5 class="text-muted text-uppercase fs-13 mb-0">Employee CTC (Monthly)</h5>
                                                    </div>
                                                </div>
                                                <div class="mt-4 pt-1">
                                                    <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span id="ctc" data-target="ctc">---</span></h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- TEAM CTC -->
                                    <div class="col-xl-3 col-md-6">
                                        <div class="card card-height-50">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar-sm flex-shrink-0">
                                                        <span class="avatar-title bg-info-subtle rounded fs-3">
                                                            <i class="bx bx-wallet text-info"></i>
                                                        </span>
                                                    </div>
                                                    <div class="flex-grow-1 ps-3">
                                                        <h5 class="text-muted text-uppercase fs-13 mb-0">Team CTC (Monthly)</h5>
                                                    </div>
                                                </div>
                                                <div class="mt-4 pt-1">
                                                    <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span id="team_ctc" data-target="team_ctc">---</span></h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- TOTAL CTC -->
                                    <div class="col-xl-3 col-md-6">
                                        <div class="card card-height-50">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar-sm flex-shrink-0">
                                                        <span class="avatar-title bg-info-subtle rounded fs-3">
                                                            <i class="bx bx-wallet text-info"></i>
                                                        </span>
                                                    </div>
                                                    <div class="flex-grow-1 ps-3">
                                                        <h5 class="text-muted text-uppercase fs-13 mb-0">Team Total CTC (monthly)</h5>
                                                    </div>
                                                </div>
                                                <div class="mt-4 pt-1">
                                                    <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span id="total_ctc" data-target="total_ctc">---</span></h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @php
                                    $kpiPer = session('flag', 'N'); // Corrected the session variable name to 'flag'
                                    @endphp
                                    @if($kpiPer === 'Y')
                                    <!-- PAYROLL APPROVAL PENDING -->
                                    <div class="row">
                                        <!-- LEAVE APPROVAL PENDING -->
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate1 overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="leave_approval" class="text-white">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0"> LV-TO APPROVE</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="leave_AppPend"></span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- PERMISSION APPROVAL PENDING -->
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate1 overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="permission_app" class="text-white">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">PER-TO APPROVE</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="Permis_AppPend">0</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- OD APPROVAL PENDING -->
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate1 overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="od_approval" class="text-white">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">OD-TO APPROVE</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="OD_AppPend"></span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- COFF APPROVAL PENDING -->
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate1 overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="coff_app" class="text-white">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">C-OFF-TO APPROVE</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="COFf_AppPend"></span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- MISPUNCH-HOD APPROVAL PENDING -->
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate1 overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="MisPuch_HODAPP" class="text-white">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">MISPUNCH-HOD-TO APPROVE</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="MispunchHOD_AppPend"></span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        @if(session('Mispunch_hr'))
                                        <!-- MISPUNCH-HR APPROVAL PENDING -->
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate1 overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="MisPuch_HRAPP" class="text-white">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">MISPUNCH-HR-TO APPROVE</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="MispunchHR_AppPend"></span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        @endif
                                        @if(session('Mispunch_gmhr'))
                                        <!-- MISPUNCH-GMHR-GUP APPROVAL PENDING -->
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate1 overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="MisPuch_GMHRAPP" class="text-white">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">MISPUNCH-GMHR-TO APPROVE</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="MispunchGMHR_GUP_AppPend"></span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        @endif

                                        @if(session('Mispunch_gmhr_GUT'))
                                        <!-- MISPUNCH-GMHR-GUT APPROVAL PENDING -->
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate1 overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="MisPuch_GMHRAPP" class="text-white">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">MISPUNCH-GMHR-TO APPROVE</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="MispunchGMHR_GUT_AppPend"></span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        @endif

                                        @endif
                                        <!-- </div> -->

                                        <!-- <div class="row"> -->

                                        <!-- MISPUNCH ENTRY PENDING -->
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate1 overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="MisPuch" class="text-white">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0" title="MISPUNCH ENTRY PENDING">MISPUNCH ENTRY PENDING</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0">
                                                                    <span>{{ $Ent_Pend[0]['Mispunch_Pend'] ?? 0 }}</span>
                                                                </h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- MISPUNCH APPROVAL PENDING -->
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate1 overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="MisPuchReport" class="text-white">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0" title="MISPUNCH APPROVAL PENDING">MISPUNCH APPROVAL PENDING</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0">
                                                                    <span>{{ $Ent_App[0]['Mispunch_Pend'] ?? 0 }}</span>
                                                                </h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>

                                        @if($kpiPer === 'Y')
                                        <!-- TRAVEL EXPENSE HOD APPROVAL COUNT -->
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate1 overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="travExp_RepApp1" class="text-white">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">TRAV-ENTRY-HOD TO APPROVE</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"> {{$resTravAppPend1[0]['Pending_Count']}}</h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        @endif

                                        @if($empl_tno=='GLA0001'||$empl_tno=='GKA0559'||$empl_tno=='AMD0000')
                                        <!-- TRAVEL EXPENSE SECOND LEVEL APPROVAL COUNT -->
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate1 overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="travExp_RepApp2" class="text-white">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">TRAV-ENTRY-II LVL TO APPROVE</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"> {{$resTravAppPend2[0]['Pending_Count']}}</h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        @endif

                                        <!-- 5S AUDIT AVERAGE MARK COUNT -->
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate1 overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="{{ url('FiveSAudit_Rep') }}?zone_id={{ $Avgval[0]['Zone_id'] ?? 0}}" class="text-white">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">5S AUDIT AVERAGE MARK</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0">
                                                                    <span style="color: blue;">{{ $Avgval[0]['Average'] ?? 0 }}</span> -
                                                                    <span style="font-size: 16px;">{{ $Zone[0]['Zone'] ?? 'Zone not Mapped' }}</span>
                                                                </h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="d-flex pb-2 mt-0 mb-3">
                                        <div class="col-lg-2">
                                            <button id="loadAttendanceData" class="btn btn-primary">Load Attendance Data</button>
                                        </div>
                                        <!-- Spinner -->
                                        <div id="spinner" style="display: none;">
                                            <div class="spinner-border text-primary" role="status">
                                                <span class="visually-hidden">Loading...</span>
                                            </div>
                                        </div>
                                        @php
                                        $ctc = json_decode(json_encode($Ctc_right), true);
                                        @endphp

                                        @if($ctc === 'Y')
                                        <div class="col-lg-2">
                                            <button id="loadCtcdata" class="btn btn-primary">Load CTC Data</button>
                                        </div>
                                        <!-- Spinner -->
                                        <div id="spinnerctc" style="display: none;">
                                            <div class="spinner-border text-primary" role="status">
                                                <span class="visually-hidden">Loading...</span>
                                            </div>
                                        </div>
                                        @endif
                                    </div>
                                </div>

                                <!-- RATINGS -->
                                <div class="row mt-1">
                                    <!-- STAR RATINGS -->
                                    <div class="col-xl-6 col-md-12 mb-4">
                                        <div class="card shadow mb-4" id="reviewchart">
                                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                                <a href="fullreview">
                                                    <h6 class="m-0 font-weight-bold text-primary">Total Reviews</h6>
                                                </a>
                                                <select class="form-control" name="rev" id="rev" onchange="updateContent(this.value)">
                                                </select>
                                            </div>
                                            <div class="card-body d-flex">
                                                <div class="col-4">
                                                    <div class="rating-box p-4 m-3 text-center">
                                                        <h1>--</h1>
                                                        <p>out of 5</p><br>
                                                        <div class="d-flex justify-content-center">
                                                            <span class="fa fa-star star-active mx-1"></span>
                                                            <span class="fa fa-star star-active mx-1"></span>
                                                            <span class="fa fa-star star-active mx-1"></span>
                                                            <span class="fa fa-star star-active mx-1"></span>
                                                            <span class="fa fa-star star-inactive mx-1"></span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-8">
                                                    <div class="rating-bar0">
                                                        <table class="text-left" id="ratingTable">
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- RECENT REVIEWS -->
                                    <div class="col-xl-6 col-md-12 col-sm-12">
                                        <div class="cards bg-white shadow mx-auto">
                                            <a href="fullreview">
                                                <h6 class="mt-1 pt-1 text-dark text-right">Recent Reviews</h6>
                                            </a>
                                            <div id="carouselTestimonial" class="carousel carousel-testimonial slide" data-ride="carousel">
                                                <div class="carousel-inner" style="z-index:1000;">
                                                    <div class="carousel-item text-center">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>



                                <!-- ATTENDANCE AND TARGET CHARTS -->
                                <div class="row mt-1 ml--3" style="margin-left:-6% !important">
                                    <!-- ATTENDANCE CHART -->
                                    <div class="col-xl-6 col-sm-12 col-md-12" id="adminChart">
                                        <div class="card shadow mb-4 ml-5" id="chartremove">
                                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                                <h6 class="m-0 font-weight-bold text-primary">Attendance({{ now()->year }})</h6>
                                                <select id="myDropdown" class="form-control">
                                                    <option value="present">Present</option>
                                                    <option value="absent">Absent</option>
                                                    <option value="leave">Leave</option>
                                                    <option value="latemins">LateMins</option>
                                                    <option value="dedmins">DedMins</option>
                                                    <option value="latedays">LateDays</option>
                                                    <option value="od">OD</option>
                                                    <option value="cl">CL</option>
                                                    <option value="woff">WOFF</option>
                                                </select>
                                            </div>
                                            <div class="card-body">
                                                <div class="chart-area">
                                                    <canvas id="myChart"></canvas>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- TARGET VS ACTUAL -->
                                    <div class="col-xl-6 col-md-12 col-sm-12">
                                        <div class="card w-100">
                                            <div class="card-body">
                                                <div class="d-sm-flex d-block d-flex  align-items-center justify-content-between mb-9">
                                                    <div class="mb-3 mb-sm-0">
                                                        <h5 class="card-title text-primary" style="font-weight :500;">Target/Actual</h5>
                                                    </div>
                                                    <div>
                                                        <select class="form-select btn " style="text-align:left; margin-left:25%; width:70%;" id="targetSelect">
                                                        </select>
                                                    </div>
                                                </div>
                                                <div id="targetChart"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- ATTENDANCE REPORT-->
                                <div>
                                    <div class="card">
                                        <div class="card-header border-0 pb-0">
                                            <h4 class="card-title fs-22 fw-semibold ff-secondary mb-0">ATTENDANCE (DAYS/MONTH)</h4>
                                        </div>
                                        <div>
                                            <div id="market-overview" data-colors='["--vz-success", "--vz-warning"]' data-colors-minimal='["--vz-gray-200", "--vz-primary"]' data-colors-corporate='["--vz-success", "--vz-secondary"]' data-colors-galaxy='["--vz-primary-rgb, 0.65", "--vz-primary"]' class="apex-charts mt-n4"></div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="#" class="text-white" onclick="redirectToAttendance()">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">PRESENT</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="present">0</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="#" class="text-white" onclick="redirectToAttendance()">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">LEAVE</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="leave">0</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="#" class="text-white" onclick="redirectToAttendance()">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">ABSENT</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="absent">--</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="#" class="text-white" onclick="redirectToAttendance()">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">HALFDAYS</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="half_days">0</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="#" class="text-white" onclick="redirectToAttendance()">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">LATE (MINS)</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="late_mins">0</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="#" class="text-white" onclick="redirectToAttendance()">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">DED (MINS)</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="det_mins">0</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="#" class="text-white" onclick="redirectToAttendance()">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">LATE DAYS(Nos)</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="late_days">0</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="#" class="text-white" onclick="redirectToAttendance()">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">C-OFF</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="cOff">0</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="#" class="text-white" onclick="redirectToAttendance()">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">ON DUTY(OD)</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="od">0</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="#" class="text-white" onclick="redirectToAttendance()">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">CL</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="cl">0</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="#" class="text-white" onclick="redirectToAttendance()">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">WEEK OFF(WO)</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="week_off">0</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="#" class="text-white" onclick="redirectToAttendance()">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">NATIONAL HOLYDAYS</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="n_h">0</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="#" class="text-white" onclick="redirectToLeaveReport()">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">LV APP PEND</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="leavePend">0</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-md-3">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <a href="#" class="text-white" onclick="redirectToPerReport()">
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-grow-1 overflow-hidden">
                                                                <p class="text-uppercase fw-medium text-muted text-truncate mb-0">PER APP PEND</p>
                                                                <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="perPend">0</span></h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- GATE PASS -->
                                <div>
                                    <div class="card">
                                        <div class="card-header border-0 pb-0">
                                            <h6 class="card-title mb-0"></h6>
                                            <h4 class="card-title fs-22 fw-semibold ff-secondary mb-0">GATE PASS (NOS/MONTH)</h4>
                                        </div>
                                        <div>
                                            <div id="market-overview" data-colors='["--vz-success", "--vz-warning"]' data-colors-minimal='["--vz-gray-200", "--vz-primary"]' data-colors-corporate='["--vz-success", "--vz-secondary"]' data-colors-galaxy='["--vz-primary-rgb, 0.65", "--vz-primary"]' class="apex-charts mt-n4"></div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xl-4 col-md-4">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <div class="d-flex align-items-center">
                                                        <div class="flex-grow-1 overflow-hidden">
                                                            <p class="text-uppercase fw-medium text-muted text-truncate mb-0">RGP PENDING</p>
                                                            <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="rgb_bending">0</span></h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-4 col-md-4">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <div class="d-flex align-items-center">
                                                        <div class="flex-grow-1 overflow-hidden">
                                                            <p class="text-uppercase fw-medium text-muted text-truncate mb-0">RGP</p>
                                                            <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="rgb">0</span></h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-4 col-md-4">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <div class="d-flex align-items-center">
                                                        <div class="flex-grow-1 overflow-hidden">
                                                            <p class="text-uppercase fw-medium text-muted text-truncate mb-0">N-RGP</p>
                                                            <h4 class="fs-22 fw-semibold ff-secondary mb-0"><span class="counter-value" id="n_rgb">0</span></h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- ROLES -->
                                <div>
                                    <div class="card">
                                        <div class="card-header border-0 pb-0">
                                            <h4 class="card-title fs-22 fw-semibold ff-secondary mb-0">ROLES (NOS)</h4>
                                        </div>
                                        <div>
                                            <div id="market-overview" data-colors='["--vz-success", "--vz-warning"]' data-colors-minimal='["--vz-gray-200", "--vz-primary"]' data-colors-corporate='["--vz-success", "--vz-secondary"]' data-colors-galaxy='["--vz-primary-rgb, 0.65", "--vz-primary"]' class="apex-charts mt-n4"></div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xl-4 col-md-4">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <div class="d-flex align-items-center">
                                                        <div class="flex-grow-1 overflow-hidden">
                                                            <p class="text-uppercase fw-medium text-muted text-truncate mb-0">PRIMARY</p>
                                                            <h4 class="fs-22 fw-semibold ff-secondary mb-0" id="primaryValue"><span class="counter-value">0</span></h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-4 col-md-4">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <div class="d-flex align-items-center">
                                                        <div class="flex-grow-1 overflow-hidden">
                                                            <p class="text-uppercase fw-medium text-muted text-truncate mb-0">SECONDARY</p>
                                                            <h4 class="fs-22 fw-semibold ff-secondary mb-0" id="secondaryValue"><span class="counter-value">0</span></h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-4 col-md-4">
                                            <div class="card card-animate overflow-hidden">
                                                <div class="position-absolute start-0" style="z-index: 0;">
                                                    <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 120" width="200" height="120">
                                                        <style>
                                                            .s0 {
                                                                opacity: .05;
                                                                fill: var(--vz-success)
                                                            }
                                                        </style>
                                                        <path id="Shape 8" class="s0" d="m189.5-25.8c0 0 20.1 46.2-26.7 71.4 0 0-60 15.4-62.3 65.3-2.2 49.8-50.6 59.3-57.8 61.5-7.2 2.3-60.8 0-60.8 0l-11.9-199.4z" />
                                                    </svg>
                                                </div>
                                                <div class="card-body" style="z-index:1;">
                                                    <div class="d-flex align-items-center">
                                                        <div class="flex-grow-1 overflow-hidden">
                                                            <p class="text-uppercase fw-medium text-muted text-truncate mb-0">TOTAL ROLES</p>
                                                            <h4 class="fs-22 fw-semibold ff-secondary mb-0" id="totalRolesValue"><span class="counter-value">0</span></h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- ASSET -->
                                <div class="row">
                                    <div class="col-xxl-12">
                                        <div class="card">
                                            <div class="card-header align-items-center d-flex">
                                                <h4 class="card-title fs-22 fw-semibold ff-secondary mb-0">ASSETS</h4>
                                            </div>

                                            <div class="card-body">
                                                <!-- Spinner -->
                                                <div id="spinner" style="display: none; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);">
                                                    <div class="spinner-border text-primary" role="status">
                                                        <span class="visually-hidden">Loading...</span>
                                                    </div>
                                                </div>

                                                <div class="table-responsive table-card">
                                                    <table class="table table-borderless table-centered align-middle table-nowrap mb-0" id="dataTable">
                                                        <thead class="text-muted table-light">
                                                            <tr>
                                                                <th scope="col">SNO</th>
                                                                <th scope="col">Asset ID</th>
                                                                <th scope="col">Asset Category</th>
                                                                <th scope="col">Asset Name</th>
                                                                <th scope="col">View</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>

                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

    <!-- == FOR PASSING DATE TO ATTENDANCE REPORT PAGE == -->
    <script>
        function redirectToAttendance() {
            var selectedDate = $('#fdate').val(); // Get the selected date
            if (selectedDate) {
                var fromDate = selectedDate.substring(0, selectedDate.lastIndexOf("-")) + "-01";
                $('#from_date').val(fromDate);
                $('#to_date').val(selectedDate);
                // Submit the form
                $('#attendanceForm').submit();
                window.location.href = "{{ route('Attendane1') }}?fromdate=" + fromDate + "&todate=" + selectedDate;
            }
            event.preventDefault();
        }
    </script>

    <!-- == REDIRECT TO LEAVE REPORT PAGE == -->
    <script>
        function redirectToLeaveReport() {
            window.location.href = "{{route('leave_table')}}";
        }
    </script>

    <!-- == REDIRECT TO PERMISSION REPORT PAGE == -->
    <script>
        function redirectToPerReport() {
            window.location.href = "{{route('permission_table')}}";
        }
    </script>

    <!-- APPROVAL PENDING -->
    <!-- <script>
        $.ajax({
            url: "{{ route('Approval_Pend') }}",
            type: "GET",
            success: function(App_pend) {
                console.log("Approval pending data received:", App_pend);

                if (App_pend.length > 0) {
                    App_pend.forEach(App_pends => {

                        if (App_pends.TYPE === "LEAVE") {
                            var Pend = App_pends.PENDING || 0; // Use 0 if PENDING is undefined

                            document.querySelector('#leave_AppPend').innerText = Pend;
                        } else if (App_pends.TYPE === "PERMISSION") {
                            var Pend = App_pends.PENDING || 0; // Use 0 if PENDING is undefined

                            document.querySelector('#Permis_AppPend').innerText = Pend;

                        } else if (App_pends.TYPE === "OD") {
                            var Pend = App_pends.PENDING || 0; // Use 0 if PENDING is undefined

                            document.querySelector('#OD_AppPend').innerText = Pend;

                        } else if (App_pends.TYPE === "COFF") {
                            var Pend = App_pends.PENDING || 0; // Use 0 if PENDING is undefined

                            document.querySelector('#COFf_AppPend').innerText = Pend;

                        } else if (App_pends.TYPE === "MISPUNCH_HOD") {
                            var Pend = App_pends.PENDING || 0; // Use 0 if PENDING is undefined

                            document.querySelector('#MispunchHOD_AppPend').innerText = Pend;

                        } else if (App_pends.TYPE === "MISPUNCH_HR") {
                            var Pend = App_pends.PENDING || 0; // Use 0 if PENDING is undefined

                            document.querySelector('#MispunchHR_AppPend').innerText = Pend;

                        } else if (App_pends.TYPE === "MISPUNCH_GMHR") {
                            var Pend = App_pends.PENDING || 0; // Use 0 if PENDING is undefined

                            document.querySelector('#MispunchGMHR_AppPend').innerText = Pend;

                        } else {
                            console.warn("Unexpected approval type:", App_pends.TYPE);
                        }


                    });
                }

            },
            error: function(xhr, status, error) {
                console.error("Error fetching approval pending data:", error);
            }
        });
    </script> -->
    <script>
        $(document).ready(function() {
            $.ajax({
                url: "{{ route('Approval_Pend') }}",
                type: "GET",
                success: function(App_pend) {
                    console.log("Approval pending data received:", App_pend);
                    if (App_pend.length > 0) {
                        App_pend.forEach(App_pends => {
                            let idMap = {
                                "LEAVE": "leave_AppPend",
                                "PERMISSION": "Permis_AppPend",
                                "OD": "OD_AppPend",
                                "COFF": "COFf_AppPend",
                                "MISPUNCH_HOD": "MispunchHOD_AppPend",
                                "MISPUNCH_HR": "MispunchHR_AppPend",
                                "MISPUNCH_GMHR_GUP": "MispunchGMHR_GUP_AppPend",
                                "MISPUNCH_GMHR_GUT": "MispunchGMHR_GUT_AppPend"
                            };

                            let elementId = idMap[App_pends.TYPE];
                            if (elementId) {
                                let element = document.querySelector(`#${elementId}`);
                                if (element) {
                                    element.innerText = App_pends.PENDING || 0;
                                } else {
                                    console.warn(`Element with ID ${elementId} not found.`);
                                }
                            } else {
                                console.warn("Unexpected approval type:", App_pends.TYPE);
                            }
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching approval pending data:", error);
                }
            });
        });
    </script>

    <!-- QUOTES -->
    <script>
        $.ajax({
            url: "{{ route('Thoughts') }}",
            type: "GET",
            success: function(Quotes) {
                console.log("Quotes data received:", Quotes);
                document.querySelector('#quote-text').innerText = Quotes;
            },
            error: function(xhr, status, error) {
                console.error("Error fetching Quotes:", error);
            }
        });
    </script>

    <!-- AJAXS -->
    <!-- SHOWING TARGET VS ACTUAL -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="{{ asset('frontend/js/apexcharts.min.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        $(document).ready(function() {
            var defaultEmpId = "{{ $empl_no }}";
            var defaultDate = "{{ date('Y-m-d') }}"; // Set the default date if needed
            nowchange(defaultEmpId, defaultDate); // Call the function with default values

            // Add change event listener to the dropdown
            $('#myDropdown').change(function() {
                var selectedOption = $(this).val(); // Get the selected option value
                var selectedDate = $('#fdate').val(); // Get the selected date
                nowchange($('#grid').val() || defaultEmpId, selectedDate, selectedOption); // Pass the selected employee ID from 'grid'
            });

            // Add change event listener to the targetSelect dropdown
            $('#targetSelect').change(function() {
                var selectedTarget = $(this).val(); // Get the selected target value
                console.log("Selected Target:", selectedTarget); // Add this line to check the selected value
                var selectedDate = $('#fdate').val(); // Get the selected date
                var selectedOption = $('#myDropdown').val(); // Get the selected option value
                var selectedGridOption = $('#grid').val(); // Get the selected option from grid dropdown
                nowchange(selectedGridOption || defaultEmpId, selectedDate, selectedOption, selectedTarget); // Call the function with selected values
            });

            // Load Attendance Data button click event
            $('#loadAttendanceData').click(function() {
                var empId = $('#grid').val() || defaultEmpId;
                var selectedDate = $('#fdate').val();
                loadAttendanceData(empId, selectedDate);
                console.log("Load Button Clicked");
            });

            $('#loadCtcdata').click(function() {
                var empId = $('#grid').val() || defaultEmpId;
                Loadctc(empId);
                console.log("Ctc Load Button Clicked");
            });

        });

        // CTC
        function Loadctc(empId) {
            $('#spinnerctc').show();

            // CTC DASH
            $.ajax({
                url: "{{ route('CTCDash') }}",
                type: "GET",
                data: {
                    empdata: empId,
                },
                dataType: 'json',
                success: function(Ctc_Val) {

                    let rights = @json($Ctc_right);

                    if (rights === 'Y' && Ctc_Val) {
                        function formatCTC(value) {
                            return value !== undefined ? `₹ ${Number(value).toLocaleString('en-IN')}` : "---";
                        }

                        function setCTCValue(elementId, value) {
                            let formattedValue = formatCTC(value);
                            if (value !== undefined) {
                                $(`#${elementId}`).html(`<a href="ctc_report" class="text-decoration-none">${formattedValue}</a>`);
                            } else {
                                $(`#${elementId}`).text("---");
                            }
                        }

                        setCTCValue("ctc", Ctc_Val.Emp_ctc);
                        setCTCValue("team_ctc", Ctc_Val.team_ctc);
                        setCTCValue("total_ctc", Ctc_Val.total_ctc);

                        console.log("CTC DASH data received:", Ctc_Val);
                    } else {
                        $("#ctc, #team_ctc, #total_ctc").text("---");
                    }
                    $('#spinnerctc').hide();

                },
                error: function(xhr, status, error) {
                    console.error("Error fetching Ctc:", error);
                    $('#spinnerctc').hide();
                }
            });
        }

        function loadAttendanceData(empId, selectedDate) {

            $('#spinner').show();
            // ATTENDANCE REPORT
            $.ajax({
                url: "{{ route('Attendance') }}",
                type: "GET",
                data: {
                    fetchDate: selectedDate, // Pass the selected date
                    empdata: empId,
                },
                dataType: 'json',
                success: function(Attend) {
                    console.log("Attendance data received:", Attend);
                    document.querySelector('#present').innerText = Attend.present;
                    document.querySelector('#leave').innerText = Attend.leave;
                    document.querySelector('#absent').innerText = Attend.absent;
                    document.querySelector('#half_days').innerText = Attend.halfDays;
                    document.querySelector('#late_mins').innerText = Attend.lateMin;
                    document.querySelector('#det_mins').innerText = Attend.detMin;
                    document.querySelector('#late_days').innerText = Attend.lateDays;
                    document.querySelector('#cOff').innerText = Attend.coff;
                    document.querySelector('#od').innerText = Attend.od;
                    document.querySelector('#cl').innerText = Attend.cl;
                    document.querySelector('#week_off').innerText = Attend.woff;
                    document.querySelector('#n_h').innerText = Attend.nationalHoliday;
                    document.querySelector('#leavePend').innerText = Attend.LV_APP_PEND;
                    document.querySelector('#perPend').innerText = Attend.PER_APP_PEND;
                    document.querySelector('#rgb_bending').innerText = Attend.rgpBending;
                    document.querySelector('#rgb').innerText = Attend.rgp;
                    document.querySelector('#n_rgb').innerText = Attend.nrgp;
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching Attendance Report:", error);
                }
            });

            // Destroy the existing chart if it exists
            var existingChart = Chart.getChart("myChart");
            if (existingChart) {
                existingChart.destroy();
            }
            // ATTENDANCE CHART
            $.ajax({
                url: "{{ route('Att_Chart') }}",
                type: "GET",
                data: {
                    empdata: empId,
                },
                dataType: 'json',
                success: function(Att_Chart) {
                    console.log("Attendance Chart data received:", Att_Chart);

                    const dropdown = document.getElementById('myDropdown');
                    // Add event listener to detect changes in the dropdown value
                    dropdown.addEventListener('change', updateChart);
                    var presentData = Att_Chart.present
                    var absentData = Att_Chart.absent;
                    var leaveData = Att_Chart.leave;
                    var lateMin = Att_Chart.lateMin;
                    var detmin = Att_Chart.detMin;
                    var latedays = Att_Chart.lateDays;
                    var od = Att_Chart.od;
                    var cl = Att_Chart.cl;
                    var wo = Att_Chart.weekOff;
                    var leavePending = Att_Chart.leavePending;
                    var perPending = Att_Chart.perPending;

                    var chartData = {
                        present: presentData, // Data for Option 1
                        absent: absentData, // Data for Option 2
                        leave: leaveData, // Data for Option 3
                        latemins: lateMin, // Data for Option 3
                        dedmins: detmin, // Data for Option 3
                        latedays: latedays, // Data for Option 3
                        od: od, // Data for Option 3
                        cl: cl, // Data for Option 3
                        woff: wo, // Data for Option 3
                        leavePending: leavePending, // Data for Option 3
                        perPending: perPending, // Data for Option 3
                    };

                    // CREATE THE INITIAL CHART
                    var monthData = Att_Chart.infos;
                    var ctx = document.getElementById('myChart').getContext('2d');
                    var myChart = new Chart(ctx, {
                        type: 'line',
                        data: {
                            labels: monthData,
                            datasets: [{
                                label: 'Data',
                                data: chartData.present, // Initial data based on default selection
                                backgroundColor: 'rgba(0, 123, 255, 0.5)'
                            }],
                        },
                        options: {
                            scales: {
                                y: {
                                    ticks: {
                                        beginAtZero: true,
                                        callback: function(value, index, values) {
                                            return value.toFixed(0); // Round to nearest integer
                                        },
                                    },
                                },
                            },
                        },
                    });
                    // Function to update the chart based on the selected dropdown value
                    function updateChart() {
                        const selectedOption = dropdown.value;
                        // Update the chart's data with the selected option's data
                        myChart.data.datasets[0].data = chartData[selectedOption];
                        // Update the chart
                        myChart.update();
                    }
                    $('#spinner').hide();
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching Attendance Chart:", error);
                }
            });

        }

        function nowchange(empId, selectedDate, selectedOption, selectedTarget) {

            $("#ctc").text('---');
            $("#team_ctc").text('---');
            $("#total_ctc").text('---');


            // CTC
            // $.ajax({
            //     url: "{{ route('CTC') }}",
            //     type: "GET",
            //     data: {
            //         empdata: empId,
            //     },
            //     dataType: 'json',
            //     success: function(ctcData) {
            //         let rights = @json($Ctc_right);

            //         if (rights === 'Y') {
            //             $("#ctc").text(ctcData.Ctc || '---');
            //             $("#team_ctc").text(ctcData.Team_Ctc || '---');
            //             $("#total_ctc").text(ctcData.Tot_Ctc || '---');
            //             console.log("Emp CTC data received:", ctcData);
            //         } else {
            //             $("#ctc").text('---');
            //             $("#team_ctc").text('---');
            //             $("#total_ctc").text('---');
            //             console.log("No CTC data received.");
            //         }

            //     },
            //     error: function(xhr, status, error) {
            //         console.error("Error fetching CTC:", error);
            //     }
            // });

            // CTC DASH
            // $.ajax({
            //     url: "{{ route('CTCDash') }}",
            //     type: "GET",
            //     data: {
            //         empdata: empId,
            //     },
            //     dataType: 'json',
            //     success: function(Ctc_Val) {

            //         let rights = @json($Ctc_right);

            //         if (rights === 'Y' && Ctc_Val) {
            //             $("#ctc").text(Ctc_Val.Emp_ctc !== undefined ? `₹ ${Number(Ctc_Val.Emp_ctc).toLocaleString('en-IN')}` : "---");
            //             $("#team_ctc").text(Ctc_Val.team_ctc !== undefined ? `₹ ${Number(Ctc_Val.team_ctc).toLocaleString('en-IN')}` : "---");
            //             $("#total_ctc").text(Ctc_Val.total_ctc !== undefined ? `₹ ${Number(Ctc_Val.total_ctc).toLocaleString('en-IN')}` : "---");

            //             console.log("CTC DASH data received:", Ctc_Val);
            //         } else {
            //             $("#ctc, #team_ctc, #total_ctc").text("---");
            //         }
            //     },
            //     error: function(xhr, status, error) {
            //         console.error("Error fetching assets:", error);
            //     }
            // });

            // TARGET / ACTUAL
            $.ajax({
                url: "{{ route('targetVsActual') }}",
                type: "GET",
                data: {
                    targetValue: selectedTarget,
                    empdata: empId
                },
                dataType: 'json',
                success: function(Tar_Act) {
                    console.log("Target/Actual data received:", Tar_Act);
                    let target = Tar_Act[0];
                    let actual = Tar_Act[1];
                    let month = Tar_Act[2];
                    console.log("Target : ", actual);
                    var targetChart = {
                        series: [{
                                name: "Target this month:",
                                data: target
                            },
                            {
                                name: "Achieve this month:",
                                data: actual
                            },
                        ],
                        chart: {
                            type: "bar",
                            height: 250,
                            offsetX: -15,
                            toolbar: {
                                show: true
                            },
                            foreColor: "#adb0bb",
                            fontFamily: 'inherit',
                            sparkline: {
                                enabled: false
                            },
                        },
                        colors: ["#5D87FF", "#49BEFF"],
                        plotOptions: {
                            bar: {
                                horizontal: false,
                                columnWidth: "35%",
                                borderRadius: 6,
                            },
                        },
                        markers: {
                            size: 0
                        },
                        dataLabels: {
                            enabled: false,
                        },
                        legend: {
                            show: false,
                        },
                        grid: {
                            borderColor: "rgba(0,0,0,0.1)",
                            strokeDashArray: 3,
                            xaxis: {
                                lines: {
                                    show: false,
                                },
                            },
                        },
                        xaxis: {
                            type: "category",
                            categories: month,
                            labels: {
                                style: {
                                    cssClass: "grey--text lighten-2--text fill-color"
                                },
                            },
                        },
                        yaxis: {
                            show: true,
                            tickAmount: 4,
                            min: 0,
                            labels: {
                                style: {
                                    cssClass: "grey--text lighten-2--text fill-color",
                                },
                            },
                        },
                        stroke: {
                            show: true,
                            width: 3,
                            lineCap: "butt",
                            colors: ["transparent"],
                        },
                        tooltip: {
                            theme: "light"
                        },
                        responsive: [{
                            breakpoint: 600,
                            options: {
                                plotOptions: {
                                    bar: {
                                        borderRadius: 3,
                                    },
                                },
                            },
                        }, ],
                    };
                    // Check if the chart already exists and destroy it
                    if (typeof chartnew !== 'undefined') {
                        chartnew.destroy();
                    }
                    // Create a new chart
                    chartnew = new ApexCharts(document.querySelector("#targetChart"), targetChart);
                    chartnew.render();

                },
                error: function(xhr, status, error) {
                    console.error("Error fetching Target/Actual:", error);
                }
            });

            // SHOWING KPI POINT IN THE TARGET/ACTUAL
            $.ajax({
                url: "{{ route('KPI_Dash') }}",
                type: "GET",
                data: {
                    fetchDate: selectedDate,
                    empdata: empId
                },
                dataType: 'json',
                success: function(kpi) {
                    console.log("KPI options received:", kpi);
                    var select = document.getElementById("targetSelect");

                    // Clear existing options
                    select.innerHTML = "";

                    // Loop through the kpi data and add options to the select dropdown
                    kpi.forEach(function(item) {
                        var option = document.createElement("option");
                        option.value = item.Kpi_point; // Assuming Kpi_point is the value you want to display
                        option.text = item.Kpi_point; // Assuming Kpi_point is the text you want to display
                        select.appendChild(option);
                    });
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching KPI Points:", error);
                }
            });

            // ROLES
            $.ajax({
                url: "{{ route('Roles_emplno') }}",
                type: "GET",
                data: {
                    empdata: empId,
                },
                dataType: 'json',
                success: function(roles) {
                    var pri = roles.primary || 0;
                    var sec = roles.secondary || 0;
                    var totalRole = parseInt(pri) + parseInt(sec);

                    $('#primaryValue').text(pri);
                    $('#secondaryValue').text(sec);
                    $('#totalRolesValue').text(totalRole);

                    console.log("Roles data received:", roles);
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching roles:", error);
                }
            });

            $('#dataTable').hide();
            $('#spinner').show();

            // ASSET
            $.ajax({
                url: "{{ route('AssetDash') }}",
                type: "GET",
                data: {
                    empdata: empId,
                },
                dataType: 'json',
                success: function(assetsData) {
                    var tableBody = $('#dataTable tbody');
                    tableBody.empty(); // Clear existing table data

                    // Loop through $Assets data and populate the table rows
                    for (var i = 0; i < assetsData.length; i++) {
                        var asset = assetsData[i];
                        var row = '<tr>' +
                            '<td>' + (i + 1) + '</td>' + // SNO
                            '<td>' + asset.ENO + '</td>' + // Item ID
                            '<td>' + asset.Asset_Type + '</td>' + // Item Type
                            '<td>' + asset.Item_Name + '</td>' + // Item Name
                            '<td>' +
                            '<a href="asset_detail?mode=view&id=' + asset.Rowid + '&eno=' + asset.ENO + '&as_type=' + asset.Asset_Type + '&as_mode=' + asset.Asset_Mode +
                            '&item=' + asset.Item_Name + '&model=' + asset.Model + '&manuf=' + asset.Manufacture + '&hd=' + asset.HD +
                            '&ram=' + asset.RAM + '&os=' + asset.OS + '&proc=' + asset.Processor + '&ip=' + asset.IP + '&mac=' + asset.MAC +
                            '&sys_type=' + asset.Sys_Type + '&value=' + asset.Value + '&desc=' + asset.Description + '&user=' + asset.Asset_User +
                            '&tno=' + asset.tno + '&depname=' + asset.deptname + '&catname=' + asset.CatName + '&design=' + asset.DesignationName +
                            '&compname=' + asset.CompName + '">' +
                            '<i class="fa fa-eye" style="font-size:20px"></i>' +
                            '</a>' +
                            '</td>' +
                            '</tr>';
                        tableBody.append(row);
                    }
                    // Hide spinner after data is loaded
                    $('#spinner').hide();
                    $('#dataTable').show();
                    console.log("Asset data received:", assetsData);
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching assets:", error);
                }
            });

        }

        function changeDate() {
            var selectedDate = $('#fdate').val(); // Get the selected date from the input field
            var empId = "{{ $empl_no }}"; // Get the default employee ID
            nowchange(empId, selectedDate); // Call the nowchange function with empId and selectedDate
        }
    </script>


    <!-- SHOWING RATING USING AJAX -->
    <script>
        $.ajax({
            url: "{{ route('total_review') }}",
            type: "GET",

            success: function(response) {
                console.log("Total Review data Received : ", response);
                let menu = response[0];
                let tot_percentage = response[1];
                let rev = response[2];

                // Convert the ratings to numbers
                rev = rev.map(Number);

                // Calculate the average
                let totalRating = rev.reduce((acc, rating) => acc + rating, 0);
                let averageRating = totalRating / rev.length;

                // Update the <h1> element with the average rating
                let h1Element = document.querySelector('.rating-box h1');
                h1Element.textContent = averageRating.toFixed(1); // Display with one decimal place

                let average = parseFloat(h1Element.textContent);

                let starsContainer = document.querySelector('.rating-box .d-flex');
                starsContainer.innerHTML = '';

                for (let i = 0; i < 5; i++) {
                    let star = document.createElement('span');
                    if (i < Math.floor(average)) {
                        star.classList.add('fa', 'fa-star', 'star-active', 'mx-1');
                    } else if (i === Math.floor(average)) {
                        let decimalStar = document.createElement('span');
                        decimalStar.classList.add('fa', 'fa-star-half', 'star-active', 'mx-1');
                        starsContainer.appendChild(decimalStar);
                    } else {
                        star.classList.add('fa', 'fa-star', 'star-inactive', 'mx-1');
                    }
                    starsContainer.appendChild(star);
                }

                //CREATE DROPDOWN
                var selectElement = document.getElementById('rev');
                selectElement.innerHTML = '';

                var defaultOption = document.createElement("option");
                defaultOption.value = "";
                defaultOption.textContent = "-- All --";
                selectElement.appendChild(defaultOption);

                menu.forEach(function(name) {
                    var optionElement = document.createElement('option');
                    optionElement.value = name;
                    optionElement.text = name;

                    selectElement.appendChild(optionElement);
                });


                document.getElementById('rev').addEventListener('change', function() {
                    var selectedValue = this.value;
                    if (selectedValue === "") {
                        // IF "ALL" IS SELECTED, RELOAD THE DATA
                        updateContent(selectedValue);
                    }
                });

                var ratings = [];
                var stars = [5, 4, 3, 2, 1];

                for (var i = 0; i < tot_percentage.length; i++) {
                    if (stars[i]) {
                        var rating = {
                            percentage: tot_percentage[i],
                            stars: stars[i]
                        };
                        ratings.push(rating);
                    }
                }

                var table = document.getElementById("ratingTable");
                table.innerHTML = '';

                for (var i = 0; i < ratings.length; i++) {
                    var tr = document.createElement('tr');

                    var tdPercentage = document.createElement('td');
                    tdPercentage.className = 'text-right';
                    tdPercentage.style = 'width:30px;';
                    tdPercentage.textContent = ratings[i].percentage + '%';

                    var tdProgressBar = document.createElement('td');
                    tdProgressBar.className = 'rating-bar';

                    var divProgress = document.createElement('div');
                    divProgress.className = 'progress';

                    var divProgressBar = document.createElement('div');
                    divProgressBar.className = 'progress-bar';
                    divProgressBar.setAttribute('role', 'progressbar');
                    divProgressBar.style.width = ratings[i].percentage + '%';
                    divProgressBar.setAttribute('aria-valuenow', ratings[i].percentage);
                    divProgressBar.setAttribute('aria-valuemin', '0');
                    divProgressBar.setAttribute('aria-valuemax', '100');

                    divProgress.appendChild(divProgressBar);
                    tdProgressBar.appendChild(divProgress);

                    var tdRatingLabel = document.createElement('td');
                    tdRatingLabel.className = 'rating-label';

                    for (var j = 0; j < ratings[i].stars; j++) {
                        var spanStar = document.createElement('span');
                        spanStar.className = 'fa fa-star star-active';
                        tdRatingLabel.appendChild(spanStar);
                    }

                    tr.appendChild(tdPercentage);
                    tr.appendChild(tdProgressBar);
                    tr.appendChild(tdRatingLabel);

                    table.appendChild(tr);
                }
            }
        });
    </script>

    <!-- VIEW RATINGS BY FILTER (DROPDOWN) -->
    <script>
        function updateContent(selectedValue) {
            let selectedValues = selectedValue;
            console.log(selectedValues);

            if (selectedValues === "") {
                $.ajax({
                    url: "{{ route('total_review') }}",
                    type: "GET",

                    success: function(response) {
                        console.log("Rating Dropdown data Received : ", response);
                        let menu = response[0];
                        let tot_percentage = response[1];

                        //CREATE DROPDOWN
                        var selectElement = document.getElementById('rev');
                        selectElement.innerHTML = '';

                        var defaultOption = document.createElement("option");
                        defaultOption.value = "";
                        defaultOption.textContent = "-- All --";
                        selectElement.appendChild(defaultOption);

                        menu.forEach(function(name) {
                            var optionElement = document.createElement('option');
                            optionElement.value = name;
                            optionElement.text = name;

                            selectElement.appendChild(optionElement);
                        });

                        document.getElementById('rev').addEventListener('change', function() {
                            var selectedValue = this.value;
                            if (selectedValue === "") {
                                // IF "ALL" IS SELECTED, RELOAD THE DATA
                                updateContent(selectedValue);
                            }
                        });


                        console.log(response[1]);
                        var ratings = [];
                        var stars = [5, 4, 3, 2, 1];

                        for (var i = 0; i < tot_percentage.length; i++) {
                            if (stars[i]) {
                                var rating = {
                                    percentage: tot_percentage[i],
                                    stars: stars[i]
                                };
                                ratings.push(rating);
                            }
                        }

                        var table = document.getElementById("ratingTable");
                        table.innerHTML = '';

                        for (var i = 0; i < ratings.length; i++) {
                            var tr = document.createElement('tr');

                            var tdPercentage = document.createElement('td');
                            tdPercentage.className = 'text-right';
                            tdPercentage.style = 'width:30px;';
                            tdPercentage.textContent = ratings[i].percentage + '%';

                            var tdProgressBar = document.createElement('td');
                            tdProgressBar.className = 'rating-bar';

                            var divProgress = document.createElement('div');
                            divProgress.className = 'progress';

                            var divProgressBar = document.createElement('div');
                            divProgressBar.className = 'progress-bar';
                            divProgressBar.setAttribute('role', 'progressbar');
                            divProgressBar.style.width = ratings[i].percentage + '%';
                            divProgressBar.setAttribute('aria-valuenow', ratings[i].percentage);
                            divProgressBar.setAttribute('aria-valuemin', '0');
                            divProgressBar.setAttribute('aria-valuemax', '100');

                            divProgress.appendChild(divProgressBar);
                            tdProgressBar.appendChild(divProgress);

                            var tdRatingLabel = document.createElement('td');
                            tdRatingLabel.className = 'rating-label';

                            for (var j = 0; j < ratings[i].stars; j++) {
                                var spanStar = document.createElement('span');
                                spanStar.className = 'fa fa-star star-active';
                                tdRatingLabel.appendChild(spanStar);
                            }

                            tr.appendChild(tdPercentage);
                            tr.appendChild(tdProgressBar);
                            tr.appendChild(tdRatingLabel);

                            table.appendChild(tr);
                        }
                    }
                });


            } else {
                $.ajax({
                    url: "{{ route('review_percent') }}",
                    type: "GET",
                    data: {
                        selectedmenu: selectedValues
                    },
                    success: function(response) {
                        console.log("Rating Dropdown data Received : ", response);
                        let menu_percent = response;
                        var ratings = [];
                        var stars = [5, 4, 3, 2, 1];

                        for (var i = 0; i < menu_percent.length; i++) {
                            if (stars[i]) {
                                var rating = {
                                    percentage: menu_percent[i],
                                    stars: stars[i]
                                };
                                ratings.push(rating);
                            }
                        }

                        var table = document.getElementById("ratingTable");
                        table.innerHTML = '';


                        for (var i = 0; i < ratings.length; i++) {
                            var tr = document.createElement('tr');

                            var tdPercentage = document.createElement('td');
                            tdPercentage.className = 'text-right';
                            tdPercentage.style = 'width:30px;';
                            tdPercentage.textContent = ratings[i].percentage + '%';

                            var tdProgressBar = document.createElement('td');
                            tdProgressBar.className = 'rating-bar';

                            var divProgress = document.createElement('div');
                            divProgress.className = 'progress';

                            var divProgressBar = document.createElement('div');
                            divProgressBar.className = 'progress-bar';
                            divProgressBar.setAttribute('role', 'progressbar');
                            divProgressBar.style.width = ratings[i].percentage + '%';
                            divProgressBar.setAttribute('aria-valuenow', ratings[i].percentage);
                            divProgressBar.setAttribute('aria-valuemin', '0');
                            divProgressBar.setAttribute('aria-valuemax', '100');

                            divProgress.appendChild(divProgressBar);
                            tdProgressBar.appendChild(divProgress);

                            var tdRatingLabel = document.createElement('td');
                            tdRatingLabel.className = 'rating-label';

                            for (var j = 0; j < ratings[i].stars; j++) {
                                var spanStar = document.createElement('span');
                                spanStar.className = 'fa fa-star star-active';
                                tdRatingLabel.appendChild(spanStar);
                            }

                            tr.appendChild(tdPercentage);
                            tr.appendChild(tdProgressBar);
                            tr.appendChild(tdRatingLabel);

                            table.appendChild(tr);
                        }
                    }
                })
            }
        }
    </script>

    <!-- RECENT REVIEWS (SLIDER) -->
    <script>
        $.ajax({
            url: "{{ route('review_slider') }}",
            type: "GET",

            success: function(response) {
                console.log("Recent Review data Received : ", response);
                var carouselInner = $(".carousel-inner"); // Assuming you have a container element for the carousel
                carouselInner.empty(); // Clear existing content

                for (var i = 0; i < response.length; i++) {
                    var testimonial = response[i];
                    var carouselItem = $("<div>").addClass("carousel-item text-center");
                    if (i === 0) {
                        carouselItem.addClass("active");
                    }

                    // Generate the HTML structure for each testimonial
                    var html = `
                        <div class="row">
                        <div class="col-md-2">
                        <div class="carousel-testimonial-img p-1 m-auto">
                            <img class="d-block image rounded-circle" src="{{ asset('frontend/emplphotos/') }}/${testimonial.emplno}.jpeg" alt="..." width="100px" height="100px">
                        </div>
                        </div>
                        <div class="col-md-10">
                        <h5 class="mt-4 mb-0"><strong class="text-primary text-uppercase">${testimonial.name} - ${testimonial.tno}</strong></h5>
                        <div class="small-ratings mb-3">`;
                    for (var j = 1; j <= 5; j++) {
                        if (j <= testimonial.Rating) {
                            html += '<i class="fa fa-star rating-color"></i>';
                        } else {
                            html += '<i class="fa fa-star"></i>';
                        }
                    }

                    html += `</div>
                        <p class="text-dark font-weight-bold ml-5 pt-3">${testimonial.Comments}</p>
                        </div>
                        </div>`;
                    carouselItem.html(html);
                    carouselInner.append(carouselItem);
                }
            }
        });
    </script>


    @endsection
</body>

</html>