<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>VIDEO UPLOAD MASTER</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet" />

    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }
    </style>

</head>

<body>
    @section('tittle') {{"VIDEO UPLOAD MASTER"}}@endsection

    <div id="layout-wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="live-preview">
                                        <form action="{{route ('save_video')}}" class="has-validated" method="post" enctype="multipart/form-data">
                                            @csrf
                                            <div class="card-body">
                                                <div class="row justify-content-center">
                                                    <div class="col-lg-11">
                                                        <div class="mb-4">
                                                            <!-- <label class="form-label">VIDEO UPLOAD MASTER<span class="text-danger">*</span></label> -->
                                                        </div>
                                                        <div class="mb-4">
                                                            <label for="module-select" class="form-label">MODULE<span class="text-danger">*</span></label>
                                                            <select name="moduleID" id="module-select" class="form-select select2" onchange="moduleid(this.value)" required>
                                                                <option value="" disabled selected>Select MODULE</option>
                                                                @foreach($Module_option as $option)
                                                                <option value="{{$option['Rowid']}}">{{$option['Module_name']}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="mb-4">
                                                            <label for="menu-link-select" class="form-label">MENU LINK<span class="text-danger">*</span></label>
                                                            <select name="menu_link" id="menu-link-select" class="form-select select2" required>
                                                                <option value="">Select Menulink</option>
                                                            </select>
                                                        </div>
                                                        <div class="mb-4">
                                                            <label for="video-upload" class="form-label">Upload Video<span class="text-danger">*</span></label>
                                                            <input type="file" name="video" id="video-upload" class="form-control" accept="video/*" required>
                                                        </div>
                                                        <div class="d-flex justify-content-around pb-2 mt-5 mb-3">
                                                            <button type="submit" id="saveButton" class="btn btn-primary" name="submit">SAVE</button>
                                                            <button type="button" id="clearButton" class="btn btn-warning" onclick="window.location.reload()">CLEAR</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>


    <script>
        function moduleid(id) {

            $.ajax({
                url: "{{ route('view_menulink') }}",
                type: "GET",
                data: {
                    id: id,
                },
                dataType: 'json',
                success: function(menulink_option) {
                    console.log(menulink_option);
                    $('#menu-link-select').empty();

                    $('#menu-link-select').append('<option value=""> Select Menulink </option>');

                    // Populate dropdown with new options
                    $.each(menulink_option, function(index, option) {
                        var menuOption = $('<option>', {
                            value: option.MenuLink_name,
                            text: option.MenuLink_name
                        });

                        $('#menu-link-select').append(menuOption);
                    });

                }
            });
        }
    </script>

    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($message = Session::get('alert'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($errors->any())
    <div id="ErrorAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>

    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('ErrorAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 10000);
    </script>
    @endif

    @endsection
</body>

</html>