<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>EXIT INTERVIEW</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>


    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }
    </style>


</head>

<body>
    @section('tittle') {{"EXIT INTERVIEW"}}@endsection

    <div id="layout-wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="live-preview">
                                        <form method="POST" action="{{route('Exit_save')}}" enctype="multipart/form-data" class="has-validated" id="validate">
                                            @csrf
                                            <!-- DETAILS -->
                                            <div class="row">
                                                <!-- TKNO -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">EMP TNo <span class="login-danger">*</span></label>
                                                        <?php $user_tkno = session('user_data') ?>
                                                        <input type="text" name="TNO" value="{{$user_tkno}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- NAME -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">EMP NAME <span class="login-danger">*</span></label>
                                                        <?php $user_name = session('emp_name') ?>
                                                        <input type="text" name="NAME" value="{{$user_name}}" class="form-control dull" readonly>
                                                        <?php $user_id = session('empl_id') ?>
                                                        <input type="hidden" name="Emplno" value="{{$user_id}}" class="form-control" readonly>
                                                    </div>
                                                </div>
                                                <!-- COMPANY NAME -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">COMPANY NAME <span class="login-danger">*</span></label>
                                                        <input type="text" name="comp_NAME" value="" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- DEPARTMENT -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">DEPARTMENT <span class="login-danger">*</span></label>
                                                        <?php $user_dep = session('dep_data') ?>
                                                        <input type="text" name="DEPARTMENT" value="{{$user_dep}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- POSITION -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">POSITION <span class="login-danger">*</span></label>
                                                        <?php $user_posit = session('des_data') ?>
                                                        <input type="text" name="DESIGNAION" value="{{$user_posit}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <br>
                                                <!-- RESIGNATION SUBMISSION DATE -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label class="form-label">RESIGNATION SUBMISSION DATE <span class="login-danger">*</span></label>
                                                        <input type="date" name="reg_date" id="reg_date" value="" class="form-control" required>
                                                    </div>
                                                </div>
                                                <!-- EXIT DATE -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label class="form-label">EXIT DATE<span class="login-danger">*</span></label>
                                                        <input type="date" name="exit_date" id="exit_date" value="" class="form-control" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <!-- REASONS FOR LEAVING -->
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <h5 style="font-weight: bold;">WHAT ARE THE REASONS FOR LEAVING?<span class="login-danger">*</span></h5>
                                                    @foreach ($reason as $index => $res)
                                                    @if ($index < count($reason) / 2) <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" id="formCheck{{$index + 1}}" name="REASONS[]" value="{{$res['Rowid']}}">
                                                        &nbsp;&nbsp;&nbsp;<label class="form-check-label" for="formCheck{{$index + 1}}">{{$res['Name']}}</label>
                                                </div>
                                                <br>
                                                @endif
                                                @endforeach
                                            </div>
                                            <div class="col-md-6">
                                                <h4>&nbsp;</h4> <!-- Placeholder for alignment -->
                                                @foreach ($reason as $index => $res)
                                                @if ($index >= count($reason) / 2)
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="formCheck{{$index + 1}}" name="REASONS[]" value="{{$res['Rowid']}}">
                                                    &nbsp;&nbsp;&nbsp;<label class="form-check-label" for="formCheck{{$index + 1}}">{{$res['Name']}}</label>
                                                </div>
                                                <br>
                                                @endif
                                                @endforeach
                                            </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <!-- COMMENTS -->
                                        <div class="col-md-12">
                                            <div class="mb-12">
                                                <label class="form-label" style="font-weight: bold;">COMMENTS<span class="login-danger">*</span></label>
                                                <textarea class="form-control" rows="4" name="comments" id="comments" required></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <!-- Job -->
                                    <div class="row">
                                        <div class="col-md-12 col-lg-12">
                                            <div class="mb-6">
                                                <h5 style="font-weight: bold;">PLEASE RANK THE FOLLOWING:<span class="login-danger">*</span></h5>
                                                <h6>The Job Itself</h6>
                                                <table class="table table-centered align-middle table-nowrap mb-0">
                                                    <thead class="text-muted table-light">
                                                        <tr>
                                                            <th></th>
                                                            <th></th>
                                                            <th>Strongly Disagree</th>
                                                            <th>Disagree</th>
                                                            <th>Agree</th>
                                                            <th>Strongly Agree</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($job as $job1)
                                                        <tr>
                                                            <td>{{$job1['Name']}}</td>
                                                            <td> <input type="hidden" name="job_id[]" value="{{$job1['Rowid']}}" readonly></td>
                                                            <td><input type="radio" name="job_challenge{{$loop->iteration}}" value="Strongly Disagree"></td>
                                                            <td><input type="radio" name="job_challenge{{$loop->iteration}}" value="Disagree"></td>
                                                            <td><input type="radio" name="job_challenge{{$loop->iteration}}" value="Agree"></td>
                                                            <td><input type="radio" name="job_challenge{{$loop->iteration}}" value="Strongly Agree"></td>
                                                        </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <!-- ABOUT THE JOB -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-12">
                                                <label class="form-label" style="font-weight: bold;">WHAT DO YOU THINK CAN BE IMPROVED ABOUT THE JOB?<span class="login-danger">*</span></label>
                                                <textarea class="form-control" rows="4" name="job_comments" id="job_comments" required></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <!-- REMUNERATION & BENEFITS -->
                                    <div class="row">
                                        <div class="col-md-12 col-lg-12">
                                            <div class="mb-6">
                                                <h5 style="font-weight: bold;">Remuneration & Benefits<span class="login-danger">*</span></h5>
                                                <table class="table">
                                                    <thead class="text-muted table-light">
                                                        <tr>
                                                            <th></th>
                                                            <th></th>
                                                            <th>Strongly Disagree</th>
                                                            <th>Disagree</th>
                                                            <th>Agree</th>
                                                            <th>Strongly Agree</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($benefit as $ben)
                                                        <tr>
                                                            <td>{{$ben['Name']}}</td>
                                                            <td> <input type="hidden" name="ben_id[]" value="{{$ben['Rowid']}}" readonly></td>
                                                            <td><input type="radio" name="ben_challenge{{$loop->iteration}}" value="Strongly Disagree"></td>
                                                            <td><input type="radio" name="ben_challenge{{$loop->iteration}}" value="Disagree"></td>
                                                            <td><input type="radio" name="ben_challenge{{$loop->iteration}}" value="Agree"></td>
                                                            <td><input type="radio" name="ben_challenge{{$loop->iteration}}" value="Strongly Agree"></td>
                                                        </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <!-- OTHER BENEFITS -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-12">
                                                <label class="form-label" style="font-weight: bold;">WHAT IMPROVEMENTS, OTHER BENEFITS COULD THE COMPANY OFFER?<span class="login-danger">*</span></label>
                                                <textarea class="form-control" rows="4" name="ben_comment" id="ben_comment" required></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <!-- COMPANY -->
                                    <div class="row">
                                        <div class="col-md-12 col-lg-12">
                                            <div class="mb-6">
                                                <h5 style="font-weight: bold;">THE COMPANY<span class="login-danger">*</span></h5>
                                                <table class="table">
                                                    <thead class="text-muted table-light">
                                                        <tr>
                                                            <th></th>
                                                            <th></th>
                                                            <th>Strongly Disagree</th>
                                                            <th>Disagree</th>
                                                            <th>Agree</th>
                                                            <th>Strongly Agree</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($company as $com)
                                                        <tr>
                                                            <td>{{$com['Name']}}</td>
                                                            <td> <input type="hidden" name="com_id[]" value="{{$com['Rowid']}}" readonly></td>
                                                            <td><input type="radio" name="com_challenge{{$loop->iteration}}" value="Strongly Disagree"></td>
                                                            <td><input type="radio" name="com_challenge{{$loop->iteration}}" value="Disagree"></td>
                                                            <td><input type="radio" name="com_challenge{{$loop->iteration}}" value="Agree"></td>
                                                            <td><input type="radio" name="com_challenge{{$loop->iteration}}" value="Strongly Agree"></td>
                                                        </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <!-- IMPROVE COMPANY -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-12">
                                                <label class="form-label" style="font-weight: bold;">WHAT DO YOU THINK CAN BE IMPROVED ABOUT THE DEPARTMENT AND COMPANY?<span class="login-danger">*</span></label>
                                                <textarea class="form-control" rows="4" name="comp_comment" id="comp_comment" required></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <!-- SUPERVISOR / LINE MANAGER -->
                                    <div class="row">
                                        <div class="col-md-12 col-lg-12">
                                            <div class="mb-6">
                                                <h5 style="font-weight: bold;">SUPERVISOR / LINE MANAGER<span class="login-danger">*</span></h5>
                                                <table class="table">
                                                    <thead class="text-muted table-light">
                                                        <tr>
                                                            <th></th>
                                                            <th></th>
                                                            <th>Strongly Disagree</th>
                                                            <th>Disagree</th>
                                                            <th>Agree</th>
                                                            <th>Strongly Agree</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($supervisor as $sup)
                                                        <tr>
                                                            <td>{{$sup['Name']}}</td>
                                                            <td> <input type="hidden" name="sup_id[]" value="{{$sup['Rowid']}}" readonly></td>
                                                            <td><input type="radio" name="sup_challenge{{$loop->iteration}}" value="Strongly Disagree"></td>
                                                            <td><input type="radio" name="sup_challenge{{$loop->iteration}}" value="Disagree"></td>
                                                            <td><input type="radio" name="sup_challenge{{$loop->iteration}}" value="Agree"></td>
                                                            <td><input type="radio" name="sup_challenge{{$loop->iteration}}" value="Strongly Agree"></td>
                                                        </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <!-- SUPERVISOR -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-12">
                                                <label class="form-label" style="font-weight: bold;">WHAT ARE YOUR SUGGESTIONS OR IMPROVEMENTS TO YOUR SUPERVISOR?<span class="login-danger">*</span></label>
                                                <textarea class="form-control" rows="4" name="superv_comment" id="superv_comment" required></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <!-- MANAGEMENT -->
                                    <div class="row">
                                        <div class="col-md-12 col-lg-12">
                                            <div class="mb-6">
                                                <h5 style="font-weight: bold;">MANAGEMENT<span class="login-danger">*</span></h5>
                                                <table class="table">
                                                    <thead class="text-muted table-light">
                                                        <tr>
                                                            <th></th>
                                                            <th></th>
                                                            <th>Strongly Disagree</th>
                                                            <th>Disagree</th>
                                                            <th>Agree</th>
                                                            <th>Strongly Agree</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($management as $man)
                                                        <tr>
                                                            <td>{{$man['Name']}}</td>
                                                            <td> <input type="hidden" name="man_id[]" value="{{$man['Rowid']}}" readonly></td>
                                                            <td><input type="radio" name="man_challenge{{$loop->iteration}}" value="Strongly Disagree"></td>
                                                            <td><input type="radio" name="man_challenge{{$loop->iteration}}" value="Disagree"></td>
                                                            <td><input type="radio" name="man_challenge{{$loop->iteration}}" value="Agree"></td>
                                                            <td><input type="radio" name="man_challenge{{$loop->iteration}}" value="Strongly Agree"></td>
                                                        </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <!-- COMMENTS MANAGEMENT -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="mb-12">
                                                <label class="form-label" style="font-weight: bold;">WHAT ARE YOUR SUGGESTIONS OR IMPROVEMENTS TO MANAGEMENT?<span class="login-danger">*</span></label>
                                                <textarea class="form-control" rows="4" name="mang_comment" id="mang_comment" required></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <br>
                                    <!--  SUBMIT BUTTON -->
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-primary" id="saveButton" onclick="return validateForm()">Submit</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

    <script>
        function validateForm() {
            var rows = document.querySelectorAll('tbody tr');
            for (var i = 0; i < rows.length; i++) {
                var radios = rows[i].querySelectorAll('input[type="radio"]');
                var checked = false;
                for (var j = 0; j < radios.length; j++) {
                    if (radios[j].checked) {
                        checked = true;
                        break;
                    }
                }
                if (!checked) {
                    alert("Please fill in all rows.");
                    return false;
                }
            }
            return true;
        }
    </script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($message = Session::get('alert'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>