<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>ADVANCE LICENSE REGISTER</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <!-- EXCEL -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.3/xlsx.full.min.js"></script>

    <!-- STYLE FOR PAGINATION -->
    <style>
        .pagination {
            justify-content: space-between;
            margin-left: 10px;
        }

        #pagination {
            margin-right: 15px;
            display: inline-block;
            vertical-align: middle;
            border-radius: 4px;
            padding: 1px 2px 4px 2px;
            border-top: 1px solid #AEAEAE;
            border-bottom: 1px solid #FFFFFF;
            background-color: #DADADA;
            background-image: -webkit-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -moz-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -ms-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -o-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: linear-gradient(top, #DBDBDB, #E2E2E2);
        }

        #pagination #pag_a,
        #pagination #pag_i {
            display: inline-block;
            vertical-align: middle;
            width: 22px;
            color: #7D7D7D;
            text-align: center;
            font-size: 10px;
            padding: 3px 0 2px 0;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            -o-user-select: none;
            user-select: none;
        }

        #pagination #pag_a {
            margin: 0 2px 0 2px;
            border-radius: 4px;
            border: 1px solid #E3E3E3;
            cursor: pointer;
            box-shadow: inset 0 1px 0 0 #FFF, 0 1px 2px #666;
            text-shadow: 0 1px 1px #FFF;
            background-color: #E6E6E6;
            background-image: -webkit-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -moz-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -ms-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -o-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: linear-gradient(top, #F3F3F3, #D7D7D7);
        }

        #pagination #pag_i {
            margin: 0 3px 0 3px;
        }

        #pagination #pag_a.current {
            border: 1px solid #E9E9E9;
            box-shadow: 0 1px 1px #999;
            background-color: #DFDFDF;
            background-image: -webkit-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -moz-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -ms-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -o-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: linear-gradient(top, #D0D0D0, #EBEBEB);
        }
    </style>

    <!-- FONT -->
    <!-- <style>
        .row label,
        .card-title {
            font-weight: bold;
            font-size: medium;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .form-heading h4 {
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .card-body .table-responsive table thead th {
            color: black;
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .card-body .table-responsive table tbody td {
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }
    </style> -->

    <!-- STATUS -->
    <style>
        .status {
            padding: .1rem 0;
            border-radius: 2rem;
            text-align: center;
            margin-top: 10px;
        }

        .status.Approved {
            /* background-color: #86e49d; */
            /* color: #006b21; */
            color: green;
            font-weight: bold;
            border: 1px solid pink;
            outline: 2px dashed greenyellow;
            /* -webkit-text-stroke: 0.5px black; */

        }

        .status.Reject {
            /* background-color: #d893a3; */
            color: #b30021;
            font-weight: bold;
            border: 2px solid pink;
            outline: 2px dashed #d893a3;

        }

        .status.Request {
            /* background-color: #ebc474; */
            color: #FABA5F;
            font-weight: bold;
            border: 2px solid #FF9F00;
            outline: 2px dashed #FF9944;
            width: 100px;

        }

        .status.shipped {
            background-color: #6fcaea;
        }
    </style>

    <!-- TABLE DESIGN -->
    <style>
        .card-body .table-responsive .table tbody tr td {
            padding: 0 25px !important;
            height: 3px;
            vertical-align: middle !important;
        }

        .card-header {
            height: 60px;
        }

        .card-header .col-md-3 select {
            margin-top: 10px;
        }

        .table-responsive {
            position: relative;
            overflow: auto;
        }

        .table thead th {
            position: sticky;
            top: 0;
            z-index: 1;
        }

        .centerallign {
            text-align: center !important;
        }
    </style>

    <!-- EXAMPLE TABLE -->
    <style>
        .card-body #table-fixed-header .gridjs .gridjs-wrapper .gridjs-table .gridjs-tbody .gridjs-tr .gridjs-td {
            padding: 0 25px !important;
            height: 3px !important;
            vertical-align: middle !important;
        }

        .card-header {
            height: 60px;
        }

        .card-header .col-md-3 select {
            margin-top: 10px;
        }
    </style>

    <style>
        .hidden_data {
            display: none;
        }

        .centered {
            display: flex;
            align-items: center;
            justify-content: center;
        }
    </style>
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->

    <!-- DETAILS MODAL STYLE -->
    <style>
        /* MODAL BACKDROP */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            /* Dark overlay */
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* MODAL CONTENT */
        .modal-content {
            background: #fff;
            padding: 10px;
            width: 100%;
            left: 8%;
            max-width: 1000px;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            animation: fadeIn 0.3s ease-in-out;
            position: relative;
            max-height: 80vh;
            /* Avoid overflow */
            overflow-y: auto;
            /* Scroll if needed */
        }

        /* CLOSE BUTTON */
        .close {
            position: absolute;
            top: 10px;
            right: 15px;
            font-size: 24px;
            cursor: pointer;
            color: #555;
        }

        .close:hover {
            color: #000;
        }

        /* HEADINGS */
        .modal-content h3 {
            margin-top: 0;
            font-size: 22px;
            text-align: center;
            color: #333;
            font-weight: bold;
            font-family: 'Times New Roman', Times, serif;
        }

        /* TABLE STYLING */
        #detailsModel table {
            /* width: 200%; */
            border-collapse: collapse;
            /* margin-top: 10px; */
        }

        #detailsModel th,
        #detailsModel td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        #detailsModel th {
            background-color: #007bff;
            color: white;
        }

        #detailsModel tbody tr:nth-child(even) {
            background-color: #f2f2f2;
        }
    </style>

</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->
    @section('tittle') {{"ADVANCE LICENSE REGISTER"}}@endsection

    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">

                                <!-- ALERT MESSAGE -->
                                @if ($message = Session::get('success'))
                                <div id="successAlert" class="alert alert-success alert-dismissible fade show mt-2 " role="alert">
                                    {{$message}}
                                </div>
                                <script>
                                    // Automatically close the alert after 3 seconds
                                    setTimeout(function() {
                                        var successAlert = document.getElementById('successAlert');
                                        if (successAlert) {
                                            successAlert.remove();
                                        }
                                    }, 15000);
                                </script>
                                @endif

                                @if ($errors->any())
                                <div id="ErrorAlert" class="alert alert-danger alert-dismissible fade show mt-2 " role="alert">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                                @endif

                                <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ SEARCH AND SHOW ENTRIES @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="page-table-header mb-2">
                                            <div class="row align-items-center">
                                                <div class="doctor-table-blk">
                                                    <div class="doctor-search-blk">
                                                        <div class="top-nav-search table-search-blk">
                                                            <form action="javascript:;">
                                                                <div class="d-flex justify-content-between align-items-center">
                                                                    <div class="search-container" style="margin-left: 10px;">
                                                                        <input type="text" id="search-input" class="form-control" placeholder="Search here">
                                                                    </div>

                                                                    <div class="ml-2">
                                                                        <select id="compCodeFilter" class="form-select">
                                                                            <option value="" selected disabled>Choose Company</option>
                                                                            <option value="">All</option>
                                                                            @php
                                                                            $codeNamePairs = collect($result)->unique('CompCode')->mapWithKeys(function ($item) {
                                                                            return [$item['CompCode'] => $item['CompName']];
                                                                            });
                                                                            @endphp

                                                                            @foreach($codeNamePairs as $code => $name)
                                                                            <option value="{{ $code }}">{{ $name }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </div>

                                                                    <div class="ml-2 col-md-1" style="margin-right: 10px;">
                                                                        <select name="state" id="maxRows" class="form-select">
                                                                            <option value="10">10</option>
                                                                            <option value="50">50</option>
                                                                            <option value="70">70</option>
                                                                            <option value="100">100</option>
                                                                            <option value="5000">Show ALL Rows</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ TABLE @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->
                                <div class="card-body">
                                    <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                        <table class="table table-bordered table-centered align-middle table-nowrap mb-0" id="dataTable" style="line-height: 30px !important;">
                                            <thead class="text-muted table-light">
                                                <tr>
                                                    <th rowspan="2" data-sort="sno" class="centerallign">SNO <span class="sort-icon"></span></th>
                                                    <th rowspan="2" data-sort="licno" class="centerallign">License No <span class="sort-icon"></span></th>
                                                    <th rowspan="2" data-sort="licDt" class="centerallign">License DT <span class="sort-icon"></span></th>
                                                    <th rowspan="2" data-sort="imExDt" class="centerallign">Import Exp DT <span class="sort-icon"></span></th>
                                                    <th rowspan="2" data-sort="exExDt" class="centerallign">Export Exp DT <span class="sort-icon"></span></th>
                                                    <th colspan="2" class="centerallign">License Details</th>
                                                    <th colspan="2" class="centerallign">Actual Details</th>
                                                    <th rowspan="2" data-sort="expPending" class="centerallign">Import Pending <span class="sort-icon"></span></th>
                                                    <th rowspan="2" data-sort="bal" class="centerallign">EO Pending <span class="sort-icon"></span></th>
                                                    <th rowspan="2" data-sort="compcode" class="centerallign d-none">Company Code <span class="sort-icon"></span></th>
                                                </tr>
                                                <tr>
                                                    <th class="centerallign">CIF &#8377;</th>
                                                    <th class="centerallign">EO &#8377;</th>
                                                    <th class="centerallign">BOE &#8377;</th>
                                                    <th class="centerallign">Invoices &#8377;</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($result as $res => $row)
                                                <tr data-compcode="{{ $row['CompCode'] }}">
                                                    <td>{{ $res + 1 }}</td>
                                                    <td>
                                                        <a href="javascript:void(0);" class="viewLicDetails" data-rowid="{{ $row['License_ID'] }}" style="color:blue; font-weight: bold;">
                                                            {{$row['LicenseNo']}}
                                                        </a>
                                                    </td>
                                                    <td>{{ date('Y-m-d',strtotime($row['LicenseDate'])) }}</td>
                                                    <td>{{ date('Y-m-d',strtotime($row['Import_Expiry_Dt'])) }}</td>
                                                    <td>{{ date('Y-m-d',strtotime($row['Eo_Expiry_Dt'])) }}</td>
                                                    <td>{{ number_format($row['CIF']) }}</td>
                                                    <td>{{ number_format($row['EO']) }}</td>
                                                    <td>{{ number_format($row['BOE']) }}</td>
                                                    <td>{{ number_format($row['Invoice_Amt']) }}</td>
                                                    <td>{{ number_format($row['Imp_Pending']) }}</td>
                                                    <td>{{ number_format($row['Bal_Amt']) }}</td>
                                                    <td class="d-none">{{ $row['CompCode'] }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <!--############################### PAGINATION ###############################-->
                                <div class="pagination">
                                    <div id="entryCount">Total entries: <span id="rowCount"></span></div>
                                    <div id="searchCount"></div>
                                    <div id="compFilterCount"></div>
                                    <div id="pagination"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- DETAILS MODEL -->
    <div id="detailsModel" class="modal" style="display: none;">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h3>License Details</h3>
            <h5 id="licNo"></h5>
            <!-- LICENSE DETAILS -->
            <table id="licDetails">
                <thead>
                    <tr>
                        <th>SNO</th>
                        <th>Licence Date</th>
                        <th>Imp Exp Dt</th>
                        <th>Eo Exp Dt</th>
                        <th>CIF FC</th>
                        <th>CIF INR</th>
                        <th>FOB FC</th>
                        <th>FOB INR</th>
                        <th>License_Status</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- DATA WILL APPEAR HERE -->
                </tbody>
            </table>
            <!-- BOE DETAILS -->
            <table id="boeDetails">
                <h3>BOE Details</h3>
                <thead>
                    <tr>
                        <th>SNO</th>
                        <th>BOE No</th>
                        <th>Import Item</th>
                        <th>BOE FC</th>
                        <th>BOE INR</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- DATA WILL APPEAR HERE -->
                </tbody>
            </table>
            <!-- INV DETAILS -->
            <table id="invDetails">
                <h3>Invoice Details</h3>
                <thead>
                    <tr>
                        <th>SNO</th>
                        <th>Invoice No</th>
                        <th>EO FC</th>
                        <th>EO Ratio</th>
                        <th>BOE Status</th>
                        <th>Export Description</th>
                        <th>EO Eligible Qty</th>
                        <th>Invoice Qty</th>
                        <th>Invoice Amt</th>
                        <th>Export Bal Qty</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- DATA WILL APPEAR HERE -->
                </tbody>
            </table>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

    <!-- DETAILS MODEL -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $(".viewLicDetails").click(function() {
                var rowid = $(this).data("rowid");
                console.log(rowid);

                $.ajax({
                    url: "{{ route('adv_lic_details') }}",
                    type: "GET",
                    data: {
                        id: rowid
                    },
                    success: function(response) {
                        console.log(response);
                        var resultLicDtl = response.resultLicDtl;
                        var resultBoeDtl = response.resultBoeDtl;
                        var resultInvDtl = response.resultInvDtl;

                        // CLEAR EXISTING TABLE
                        $("#licDetails tbody").empty();
                        $("#boeDetails tbody").empty();
                        $("#invDetails tbody").empty();

                        // SET LICENSE NO IN HEADER
                        if (resultLicDtl.length > 0) {
                            $("#licNo").text("License No: " + resultLicDtl[0].LicenseNo);
                            $.each(resultLicDtl, function(index, item) {
                                $("#licDetails tbody").append(
                                    `<tr>
                                    <td>${index + 1}</td>
                                    <td>${item.License_Date ? item.License_Date.split(' ')[0] : ''}</td>
                                    <td>${item.Import_Expiry_Dt ? item.Import_Expiry_Dt.split(' ')[0] : ''}</td>
                                    <td>${item.Eo_Expiry_Dt ? item.Eo_Expiry_Dt.split(' ')[0] : ''}</td>
                                    <td>${item.CIF_FC}</td>
                                    <td>${item.CIF_INR}</td>
                                    <td>${item.FOB_FC}</td>
                                    <td>${item.FOB_INR}</td>
                                    <td>${item.License_Status}</td>
                                </tr>`
                                );
                            });
                        } else {
                            $("#licNo").text("License No: Not Available");
                        }

                        if (resultBoeDtl.length > 0) {
                            $.each(resultBoeDtl, function(index, item) {
                                $("#boeDetails tbody").append(
                                    `<tr>
                                    <td>${index + 1}</td>
                                    <td>${item.BOE_NO}</td>
                                    <td>${item.ImportItem}</td>
                                    <td>${item.Value_In_FC}</td>
                                    <td>${item.Value_In_INR}</td>
                                </tr>`
                                );
                            });
                        }

                        $.each(resultInvDtl, function(index, item) {
                            $("#invDetails tbody").append(
                                `<tr>
                                    <td>${index + 1}</td>
                                    <td>${item.Invoice_No}</td>
                                    <td>${item.EO_FC}</td>
                                    <td>${item.EO_Ratio}</td>
                                    <td>${item.BOE_Status}</td>
                                    <td>${item.Export_Description}</td>
                                    <td>${item.EO_Eligible_Qty}</td>
                                    <td>${item.Inv_Qty}</td>
                                    <td>${item.Inv_Amt}</td>
                                    <td>${item.Export_Bal_Qty}</td>
                                </tr>`
                            );
                        });

                        $("#detailsModel").show();
                    }
                });
            });
            $(".close").click(function() {
                $("#detailsModel").hide();
            });

            // Close Modal on Clicking Outside the Modal
            $(window).click(function(event) {
                if (event.target.id === "detailsModel") {
                    $("#detailsModel").hide();
                }
            });
        });
    </script>

    <!-- COMPANY FILTER -->
    <script>
        document.getElementById('compCodeFilter').addEventListener('change', function() {
            var selectedCode = this.value.toLowerCase();
            var rows = document.querySelectorAll('#dataTable tbody tr');

            rows.forEach(function(row) {
                var rowCode = row.getAttribute('data-compcode').toLowerCase();
                if (!selectedCode || rowCode === selectedCode) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
            $("#entryCount").hide();
            var rowCount = $("#dataTable tbody tr:visible").length;
            $("#compFilterCount").text(rowCount + " result(s) found");
        });
    </script>

    <!-- SORTING -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#dataTable .sort-icon').html('<i class="fas fa-sort"></i>'); // Display the sort icon by default

            $('#dataTable th[data-sort]').click(function() {
                const column = $(this).data('sort');
                const sortOrder = $(this).hasClass('asc') ? 'desc' : 'asc';

                // Reset sorting indicators
                $('#dataTable th[data-sort]').removeClass('asc desc');
                $('#dataTable .sort-icon').html('<i class="fas fa-sort"></i>');

                // Apply sorting indicator to the clicked column
                $(this).addClass(sortOrder);
                $(this).find('#dataTable .sort-icon i').removeClass().addClass(sortOrder === 'asc' ? 'fas fa-sort-up' : 'fas fa-sort-down');

                // Perform sorting logic based on the column and sortOrder
                sortTable(column, sortOrder);
            });

            function sortTable(column, sortOrder) {
                const rows = $('#dataTable tbody tr').get();

                rows.sort(function(a, b) {
                    let keyA = $(a).find(`td:eq(${getColumnIndex(column)})`).text();
                    let keyB = $(b).find(`td:eq(${getColumnIndex(column)})`).text();

                    if (!isNaN(parseFloat(keyA)) && !isNaN(parseFloat(keyB))) {
                        keyA = parseFloat(keyA);
                        keyB = parseFloat(keyB);
                    }

                    if (sortOrder === 'asc') {
                        if (isNaN(keyA) || isNaN(keyB)) {
                            return keyA.localeCompare(keyB);
                        } else {
                            return keyA - keyB;
                        }
                    } else {
                        if (isNaN(keyA) || isNaN(keyB)) {
                            return keyB.localeCompare(keyA);
                        } else {
                            return keyB - keyA;
                        }
                    }
                });

                $.each(rows, function(index, row) {
                    $('#dataTable tbody').append(row);
                });
            }

            function getColumnIndex(column) {
                return $('#dataTable thead th[data-sort="' + column + '"]').index();
            }
        });
    </script>

    <!-- PRINT -->
    <script>
        let printtable = new function() {
            this.printTable = function() {
                let tab = document.getElementById('dataTable');
                let win = window.open('', '', 'height=700,width=700');
                win.document.write(tab.outerHTML);
                win.document.close();
                win.print();
                win.close(); // Add this line to close the window after printing
            }

        }
    </script>

    <!-- EXPORT AS EXCEL -->
    <script>
        function export_table_to_xlsx(table, filename) {
            var wb = XLSX.utils.table_to_book(table, {
                sheet: "Sheet1"
            });
            var ws = wb.Sheets["Sheet1"];

            // Calculate column widths based on content
            var range = XLSX.utils.decode_range(ws['!ref']);
            for (var C = range.s.c; C <= range.e.c; ++C) {
                var max_len = 0;
                for (var R = range.s.r; R <= range.e.r; ++R) {
                    var cell = ws[XLSX.utils.encode_cell({
                        r: R,
                        c: C
                    })];
                    if (cell && cell.v) {
                        var len = String(cell.v).length;
                        if (len > max_len) {
                            max_len = len;
                        }
                    }
                }
                if (max_len > 0) {
                    ws['!cols'] = ws['!cols'] || [];
                    ws['!cols'][C] = {
                        wch: max_len + 2
                    };
                }
            }

            XLSX.writeFile(wb, filename);
        }

        document.querySelector("#exportExcelBtn").addEventListener("click", function(event) {
            event.preventDefault(); // Prevent default action of anchor tag
            var table = document.querySelector("table");
            if (table) {
                export_table_to_xlsx(table, "ADVANCE_LICENSE_REGISTER.xlsx");
            } else {
                console.error("Table not found!");
            }
        });
    </script>

    <!-- SEARCH -->
    <script>
        $(document).ready(function() {
            // Define a variable to store the search value
            var searchValue = "";

            // Search function
            function performSearch() {
                var matches = $("#dataTable tbody tr").filter(function() {
                    return $(this).text().toLowerCase().indexOf(searchValue) > -1;
                });

                if (searchValue === "") {
                    // If the search bar is empty, clear the search results and count
                    $("#searchCount").text("");
                    $("#entryCount").show(); // Show the entry count
                    $("#dataTable tbody tr").toggle(true);
                    updateRowsPerPage(); // Call the function to reset displayed rows
                } else {
                    $("#entryCount").hide(); // Hide the entry count
                    // Show the search count and hide rows that don't match the search criteria
                    $("#searchCount").text(matches.length + " result(s) found");

                    // Get the selected rows per page value
                    var maxRows = parseInt($("#maxRows").val());

                    // Limit the matches to the selected rows per page
                    matches.slice(maxRows).toggle(false);
                    matches.slice(0, maxRows).toggle(true);
                    $("#dataTable tbody tr").not(matches).toggle(false);
                }
            }

            // Search input keyup event
            $("#search-input").on("keyup", function() {
                searchValue = $(this).val().toLowerCase();
                performSearch();
            });

            // maxRows dropdown change event
            $("#maxRows").on("change", function() {
                // Update rows per page and reapply search
                updateRowsPerPage();
                performSearch();
            });

            // Initialize search and rows per page
            performSearch();
            updateRowsPerPage();
        });
    </script>

    <!-- SHOW ENTRIES TABLE -->
    <script>
        // Function to update the number of displayed rows
        function updateRowsPerPage() {
            var maxRows = parseInt(document.getElementById("maxRows").value);
            var tableBody = document.getElementById("tableBody");
            var dataTable = document.getElementById("dataTable");
            var rows = dataTable.getElementsByTagName("tr");

            for (var i = 1; i < rows.length; i++) {
                if (i <= maxRows) {
                    rows[i].style.display = "";
                } else {
                    rows[i].style.display = "none";
                }
            }
        }

        // Add an event listener to the maxRows dropdown
        document.getElementById("maxRows").addEventListener("change", updateRowsPerPage);

        // Initial call to set the initial number of displayed rows
        updateRowsPerPage();
    </script>

    <!-- PAGINATION -->
    <script>
        var Pagination = {

            code: '',

            // --------------------
            // Utility
            // --------------------

            // converting initialize data
            Extend: function(data) {
                data = data || {};
                Pagination.size = data.size || 3000;
                Pagination.page = data.page || 5;
                Pagination.step = data.step || 5;
            },

            // add pages by number (from [s] to [f])
            Add: function(s, f) {
                for (var i = s; i < f; i++) {
                    Pagination.code += '<a id="pag_a">' + i + '</a>';
                }
            },

            // add last page with separator
            Last: function() {
                Pagination.code += '<i id="pag_i">...</i> <a id="pag_a">' + Pagination.size + '</a>';

            },

            // add first page with separator
            First: function() {
                Pagination.code += '<a id="pag_a">1</a> <i id="pag_i">...</i>';

            },



            // --------------------
            // Handlers
            // --------------------

            // change page
            Click: function() {
                Pagination.page = +this.innerHTML;
                Pagination.Start();
            },

            // previous page
            Prev: function() {
                Pagination.page--;
                if (Pagination.page < 1) {
                    Pagination.page = 1;
                }
                Pagination.Start();
            },

            // next page
            Next: function() {
                Pagination.page++;
                if (Pagination.page > Pagination.size) {
                    Pagination.page = Pagination.size;
                }
                Pagination.Start();
            },



            // --------------------
            // Script
            // --------------------

            // binding pages
            Bind: function() {
                var a = Pagination.e.getElementsByTagName('a');
                for (var i = 0; i < a.length; i++) {
                    if (+a[i].innerHTML === Pagination.page) a[i].className = 'current';
                    a[i].addEventListener('click', Pagination.Click, false);
                }

                // Retrieve the maxRows value
                var maxRows = parseInt(document.getElementById("maxRows").value);

                // Add this block to handle table pagination
                var table = document.getElementById('dataTable');
                var tbody = table.getElementsByTagName('tbody')[0];
                var rows = tbody.getElementsByTagName('tr');
                for (var i = 0; i < rows.length; i++) {
                    rows[i].style.display = 'none';
                }
                var start = (Pagination.page - 1) * maxRows;
                var end = start + maxRows;
                for (var i = start; i < end && i < rows.length; i++) {
                    rows[i].style.display = '';
                }
            },

            // write pagination
            Finish: function() {
                Pagination.e.innerHTML = Pagination.code;
                Pagination.code = '';
                Pagination.Bind();
            },

            // find pagination type
            Start: function() {
                var table = document.getElementById('dataTable');
                var rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

                // Retrieve the maxRows value
                var maxRows = parseInt(document.getElementById("maxRows").value);

                Pagination.size = Math.ceil(rows.length / maxRows);

                // Reset the code
                Pagination.code = '';

                if (Pagination.size < Pagination.step * 2 + 6) {
                    Pagination.Add(1, Pagination.size + 1);
                } else if (Pagination.page < Pagination.step * 2 + 1) {
                    Pagination.Add(1, Pagination.step * 2 + 4);
                    Pagination.Last();
                } else if (Pagination.page > Pagination.size - Pagination.step * 2) {
                    Pagination.First();
                    Pagination.Add(Pagination.size - Pagination.step * 2 - 2, Pagination.size + 1);
                } else {
                    Pagination.First();
                    Pagination.Add(Pagination.page - Pagination.step, Pagination.page + Pagination.step + 1);
                    Pagination.Last();
                }
                Pagination.Finish();
                Pagination.Bind();
            },



            // --------------------
            // Initialization
            // --------------------

            // binding buttons
            Buttons: function(e) {
                var nav = e.getElementsByTagName('a');
                nav[0].addEventListener('click', Pagination.Prev, false);
                nav[1].addEventListener('click', Pagination.Next, false);
            },

            // create skeleton
            Create: function(e) {

                var html = [
                    '<a id="pag_a">◄</a>', // previous button
                    '<span></span>', // pagination container
                    '<a id="pag_a">►</a>' // next button
                ];

                e.innerHTML = html.join('');
                Pagination.e = e.getElementsByTagName('span')[0];
                Pagination.Buttons(e);
            },

            // init
            Init: function(e, data) {
                Pagination.Extend(data);
                Pagination.Create(e);
                Pagination.Start();
            }
        };



        /* * * * * * * * * * * * * * * * *
         * Initialization
         * * * * * * * * * * * * * * * * */

        var init = function() {
            // Initialize with data from the table
            Pagination.Init(document.getElementById('pagination'), {
                page: 1, // selected page
                step: '' // pages before and after current
            });
        };

        document.addEventListener('DOMContentLoaded', init, false);
    </script>

    <!-- SHOWS HOW MANY ENTRIES IN THE TABLE -->
    <script>
        // Add this code to update the entry count:

        function updateEntryCount() {
            var rowCount = $("#dataTable tbody tr").length;
            $("#rowCount").text(rowCount);
        }

        // Call the function to update the entry count after the page loads
        $(document).ready(function() {
            updateEntryCount();
        });
    </script>


</body>
@endsection

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>