<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Reset Password</title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="gplogofinal.png" type="png">

    <!-- Fonts and icons -->
    <script src="{{ asset('frontend/js/plugin/webfont/webfont.min.js')}}"></script>
    <!-- CSS Files -->
    <link rel="stylesheet" href="{{ asset('frontend/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{ asset('frontend/css/atlantis.css')}}">
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->
</head>

<body id="body" class="login">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->
    <div class="wrapper wrapper-login" id="wrapper">
        <div class="container container-login animated fadeIn">
            <div class="text-center">
                <img src="gplogofinal.png" class="center" height="70" width="70">
            </div>
            <br>
            <h3 class="text-center">Life @ GainUp</h3>
            <div class="login-form">
                <form action="/change_pass" method="POST">
                    @csrf
                    @if(\Session::has('message'))
                    <div class="alert alert-info">
                        {{\Session::get('message')}}
                    </div>
                    @endif
                    <div class="form-group form-floating-label">
                        <input id="newpass" name="newpass" type="password" class="form-control input-border-bottom" required>
                        <label for="newpass" class="placeholder">New Password</label>
                        <div class="show-password">
                            <i class="icon-eye"></i>
                        </div>
                        @if ($errors->has('newpass'))
                        <span class="text-danger">{{ $errors->first('newpass') }}</span>
                        @endif
                    </div>
                    <div class="form-group form-floating-label">
                        <input id="conpass" name="conpass" type="password" class="form-control input-border-bottom" required>
                        <label for="conpass" class="placeholder">Confirm Password</label>
                        <div class="show-password">
                            <i class="icon-eye"></i>
                        </div>
                        @if ($errors->has('conpass'))
                        <span class="text-danger">{{ $errors->first('conpass') }}</span>
                        @endif
                    </div>
                    <br>
                    <div class="form-action mb-3">
                        <button type="submit" class="btn btn-primary btn-rounded btn-login">Change Password</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="container container-signup animated fadeIn" style="display:none">
        <h3 class="text-center">Sign Up</h3>
        <div class="login-form">
            <div class="form-group form-floating-label">
                <input id="fullname" name="fullname" type="text" class="form-control input-border-bottom" required>
                <label for="fullname" class="placeholder">Fullname</label>
            </div>
            <div class="form-group form-floating-label">
                <input id="email" name="email" type="email" class="form-control input-border-bottom" required>
                <label for="email" class="placeholder">Email</label>
            </div>
            <div class="form-group form-floating-label">
                <input id="passwordsignin" name="passwordsignin" type="password" class="form-control input-border-bottom" required>
                <label for="passwordsignin" class="placeholder">Password</label>
                <div class="show-password">
                    <i class="icon-eye"></i>
                </div>
            </div>
            <div class="form-group form-floating-label">
                <input id="confirmpassword" name="confirmpassword" type="password" class="form-control input-border-bottom" required>
                <label for="confirmpassword" class="placeholder">Confirm Password</label>
                <div class="show-password">
                    <i class="icon-eye"></i>
                </div>
            </div>
            <div class="row form-sub m-0">
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" class="custom-control-input" name="agree" id="agree">
                    <label class="custom-control-label" for="agree">I Agree the terms and conditions.</label>
                </div>
            </div>
            <div class="form-action">
                <a href="#" id="show-signin" class="btn btn-danger btn-link btn-login mr-3">Cancel</a>
                <a href="#" class="btn btn-primary btn-rounded btn-login">Sign Up</a>
            </div>
        </div>
    </div>

    <script src="{{ asset('frontend/js/core/jquery.3.2.1.min.js')}}"></script>
    <script src="{{ asset('frontend/js/plugin/jquery-ui-1.12.1.custom/jquery-ui.min.js')}}"></script>
    <script src="{{ asset('frontend/js/core/popper.min.js')}}"></script>
    <script src="{{ asset('frontend/js/core/bootstrap.min.js')}}"></script>
    <script src="{{ asset('frontend/js/atlantis.min.js')}}"></script>
</body>

</html>