<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Forgot Password</title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="gplogofinal.png" type="png">

    <!-- Fonts and icons -->
    <script src="{{ asset('frontend/js/plugin/webfont/webfont.min.js')}}"></script>

    <style>
        .sign-in-btn {
            background: radial-gradient(100% 100% at 100% 0, #5adaff 0, #074d66 100%);
            color: #fff;
        }

        /*start page spinner */
        .loader-1 {
            position: absolute;
            z-index: 1000;
            top: 50%;
            left: 40%;
            margin-left: 10%;
            transform: translate3d(-50%, -50%, 0);
        }

        .dot {
            width: 24px;
            height: 24px;
            background: #3ac;
            border-radius: 100%;
            display: inline-block;
            animation: slide 1s infinite;
        }

        .dot:nth-child(1) {
            animation-delay: 0.1s;
            background: #32aacc;
        }

        .dot:nth-child(2) {
            animation-delay: 0.2s;
            background: #64aacc;
        }

        .dot:nth-child(3) {
            animation-delay: 0.3s;
            background: #96aacc;
        }

        .dot:nth-child(4) {
            animation-delay: 0.4s;
            background: #c8aacc;
        }

        .dot:nth-child(5) {
            animation-delay: 0.5s;
            background: #faaacc;
        }

        @-moz-keyframes slide {
            0% {
                transform: scale(1);
            }

            50% {
                opacity: 0.3;
                transform: scale(2);
            }

            100% {
                transform: scale(1);
            }
        }

        @-webkit-keyframes slide {
            0% {
                transform: scale(1);
            }

            50% {
                opacity: 0.3;
                transform: scale(2);
            }

            100% {
                transform: scale(1);
            }
        }

        @-o-keyframes slide {
            0% {
                transform: scale(1);
            }

            50% {
                opacity: 0.3;
                transform: scale(2);
            }

            100% {
                transform: scale(1);
            }
        }

        @keyframes slide {
            0% {
                transform: scale(1);
            }

            50% {
                opacity: 0.3;
                transform: scale(2);
            }

            100% {
                transform: scale(1);
            }
        }

        /* end spinner */

        /* for buttons */

        .verify-btn {
            background: radial-gradient(100% 100% at 100% 0, #5adaff 0, #4a8da7 100%);
            color: #fff;

        }

        .resend-btn {
            background: radial-gradient(100% 100% at 100% 0, #5adaff 0, #4a8da7 100%);
            color: #fff;

        }
    </style>

    <!-- CSS Files -->
    <link rel="stylesheet" href="{{ asset('frontend/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{ asset('frontend/css/atlantis.css')}}">

    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->
</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->
    <div class="login" id="wrapper">
        <div class="wrapper wrapper-login">
            <div class="container container-login animated fadeIn">
                <div class="text-center">
                    <img src="gplogofinal.png" class="center" height="70" width="70">
                </div>
                <br>
                <h3 class="text-center">Life @ GainUp</h3>
                <div class="login-form">
                    <form id="my_form" action="{{ route('verification') }}" method="POST">
                        @csrf
                        @if(\Session::has('message'))
                        <div class="alert alert-info">
                            {{\Session::get('message')}}
                        </div>
                        @endif
                        <div class="form-group form-floating-label">
                            <input id="v_otp" name="v_otp" type="text" class="form-control input-border-bottom" required>
                            <label for="v_otp" class="placeholder">Enter OTP</label>
                            @if ($errors->has('v_otp'))
                            <span class="text-danger">{{ $errors->first('v_otp') }}</span>
                            @endif
                        </div>
                        <div class="row">
                            <div class="form-action mb-4" style="margin-left:40px;">
                                <button type="submit" class="btn verify-btn" name="submit_button" id="verify_button" value="verify">Verify OTP</button>
                            </div>
                            <div class="form-action mb-3">
                                <button type="submit" class="btn resend-btn" name="submit_button" id="resend_button" value="resend">Resend OTP</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <!-- TO GET A VERIFY BUTTON TIME -->
    <script>
        // Get the submit button element
        var verifyButton = document.getElementById('verify_button');

        // Add a click event listener to the button
        verifyButton.addEventListener('click', function(event) {
            const buttonvalue = verifyButton.getAttribute('value');
            console.log(buttonvalue);
            // Prevent the default form submission
            event.preventDefault();
            var currentTime = new Date().toLocaleString();
            console.log(currentTime);

            // Add the timestamp to a hidden input field in the form
            var timestampInput = document.createElement('input');
            timestampInput.type = 'hidden';
            timestampInput.name = 'click_verify';
            timestampInput.value = currentTime;

            var verify_value = document.createElement('input');
            verify_value.type = 'hidden';
            verify_value.name = 'verifyone';
            verify_value.value = buttonvalue;

            // Append the hidden input to the form
            document.getElementById('my_form').appendChild(timestampInput);
            document.getElementById('my_form').appendChild(verify_value);

            // Submit the form
            document.getElementById('my_form').submit();
        });
    </script>

    <!-- TO GET A RESEND BUTTON TIME -->
    <script>
        // Get the submit button element
        var resendButton = document.getElementById('resend_button');

        // Add a click event listener to the button
        resendButton.addEventListener('click', function(event) {

            const buttonvalue = resendButton.getAttribute('value');
            console.log(buttonvalue);

            // Prevent the default form submission
            event.preventDefault();
            var currentTime = new Date().toLocaleString();
            console.log(currentTime);

            // Add the timestamp to a hidden input field in the form
            var timestampInput = document.createElement('input');
            timestampInput.type = 'hidden';
            timestampInput.name = 'click_resend';
            timestampInput.value = currentTime;

            var resend_value = document.createElement('input');
            resend_value.type = 'hidden';
            resend_value.name = 'resendone';
            resend_value.value = buttonvalue;

            // Append the hidden input to the form
            document.getElementById('my_form').appendChild(timestampInput)
            document.getElementById('my_form').appendChild(resend_value)

            // Submit the form
            document.getElementById('my_form').submit();
        });
    </script>


    <script src="{{ asset('frontend/js/core/jquery.3.2.1.min.js')}}"></script>
    <script src="{{ asset('frontend/js/plugin/jquery-ui-1.12.1.custom/jquery-ui.min.js')}}"></script>
    <script src="{{ asset('frontend/js/core/popper.min.js')}}"></script>
    <script src="{{ asset('frontend/js/core/bootstrap.min.js')}}"></script>
    <script src="{{ asset('frontend/js/atlantis.min.js')}}"></script>



</body>

</html>