<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Cutting Output Dashboard</title>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.tailwindcss.com"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
  <!-- Font Awesome CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
<script>
    tailwind.config = {
        theme: {
            extend: {
                colors: {
                    'ui-bg': '#f5f7f9',
                    'ui-primary': '#2563eb',
                    'ui-secondary': '#94a3b8',
                    'kpi-blue': '#1e40af',
                    'kpi-bg': '#f1f5f9',
                    'bar-main': '#2962ff',
                    'bar-sub': '#6495ed',
                    'primary': '#1d4ed8',
                    'primary-foreground': '#ffffff',
                    'card-bg': 'rgba(255, 255, 255, 0.1)',
                },
                fontFamily: {
                    sans: ['Inter', 'sans-serif'],
                },
            }
        }
    }
</script>

    
<style>
    body {
        background-color: #f8fafc;
    }
    html, body {
        overflow-x: hidden;
        width: 100%;
    }
    .table-header-cell {
        padding-left: 8px;
        padding-right: 8px;
        padding-top: 12px;
        padding-bottom: 12px;
        text-align: left;
        font-size: 0.65rem;
        font-weight: 500;
        color: #64748b;
        text-transform: uppercase;
        letter-spacing: 0.05em;
    }
    .table-data-cell {
        padding-left: 8px;
        padding-right: 8px;
        padding-top: 8px;
        padding-bottom: 8px;
        font-size: 0.7rem;
        white-space: nowrap;
    }
    .kpi-card-border-blue { border-top: 4px solid #3b82f6; }
    .kpi-card-border-red { border-top: 4px solid #ef4444; }
    .kpi-card-border-yellow { border-top: 4px solid #f59e0b; }
    .kpi-card-border-teal { border-top: 4px solid #14b8a6; }
    .kpi-card-border-purple { border-top: 4px solid #8b5cf6; }
    .styled-select {
        appearance: none;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' fill='%23ffffff'%3E%3Cpath fill-rule='evenodd' d='M5.23 7.21a.75.75 0 011.06.02L10 10.99l3.71-3.76a.75.75 0 111.08 1.04l-4.25 4.5a.75.75 0 01-1.08 0l-4.25-4.5a.75.75 0 01.02-1.06z' clip-rule='evenodd' /%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-position: right 0.75rem center;
        background-size: 1em;
        padding-right: 2.5rem;
    }
    .date-picker input {
        background: rgba(248, 250, 252, 0.1);
        color: white;
    }
    .date-picker input::placeholder {
        color: rgba(248, 250, 252, 0.7);
    }
    .spinner {
        display: inline-block;
        width: 1.5rem;
        height: 1.5rem;
        border: 3px solid rgba(255, 255, 255, 0.3);
        border-top-color: #fff;
        border-radius: 50%;
        animation: spin 1s ease-in-out infinite;
    }
    @keyframes spin {
        to { transform: rotate(360deg); }
    }
    /* Compact DataTables length control */
    .dataTables_wrapper .dataTables_length label { font-size: 12px; color:#6b7280; }
    .dataTables_wrapper .dataTables_length select { font-size: 12px; padding: 2px 6px; height: 26px; line-height: 22px; border:1px solid #e5e7eb; border-radius:6px; width:auto; min-width:56px; }
    /* Compact DataTables search control */
    .dataTables_wrapper .dataTables_filter input { font-size: 12px; padding: 2px 6px; height: 26px; line-height: 22px; border:1px solid #D3D3D3; border-radius:6px; width:120px; background-color: #ffffff; }
    /* Compact DataTables info and pagination */
    .dataTables_wrapper .dataTables_info { font-size: 12px; color:#6b7280; }
    .dataTables_wrapper .dataTables_paginate { font-size: 12px; }
    .dataTables_wrapper .dataTables_paginate .paginate_button { padding: 2px 6px; margin: 0 1px; font-size: 12px; }
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0.5em 1em;
        margin: 0 2px;
        border: 1px solid #e2e8f0;
        border-radius: 4px;
        color: #64748b;
        background-color: #fff;
    }
    .dataTables_wrapper .dataTables_paginate .paginate_button.current,
    .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
        background-color: #5e5f5fe1;
        color: #fff;
        border-color: #5e5f5fe1;
    }
    .dataTables_wrapper .dataTables_paginate .paginate_button.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
    .dataTables_wrapper .dataTables_filter input {
        border: 1px solid #e2e8f0;
        border-radius: 4px;
        padding: 0.5em;
        margin-left: 0.5em;
    }
    .dataTables_wrapper .dataTables_length select {
        border: 1px solid #e2e8f0;
        border-radius: 4px;
        padding: 0.5em;
    }
    /* Hide scrollbar indicator but allow vertical scrolling */
    .scroll-ghost { scrollbar-width: none; -ms-overflow-style: none; }
    .scroll-ghost::-webkit-scrollbar { width: 0; height: 0; }
    /* Keep header and body columns aligned in scrollable popper tables */
    .popper-table-2 { width: auto; border-collapse: collapse; }
    .popper-table-2 thead, .popper-table-2 tbody { display: block; }
    .popper-table-2 tbody { max-height: 100px; overflow-y: auto; }
    .popper-table-2 th, .popper-table-2 td { width: 100%; box-sizing: border-box; }
    .popper-table-2 th:nth-child(1), .popper-table-2 td:nth-child(1) { padding-right: 12px; }
    .popper-table-2 th:nth-child(2), .popper-table-2 td:nth-child(2) { text-align: right; }
    .fit-popper { width: max-content; max-width: 90vw; }
    .highlight {
        background-color: #48c4f5bb;
        color: #1e3a8a;
        font-weight: bold;
    }
	.tab-option.active { color: #1e40af; font-weight: 600; border-bottom: 2px solid #1e40af; }


</style>
</head>
<body  class="bg-gray-50 text-gray-800">

        @php
        $empl_no= Session::get('empl_id');
        $empl_name = Session::get('emp_name');
        @endphp
   
   
   @include('LifeAtGainup.GUTProduction.header')

    <!-- Breadcrumb -->
    <div class="px-6 py-3 text-sm text-gray-600">
        <a id="gutDashLink" href="/production_gut_dashboard/{{$portal_type}}" class="text-blue-700 hover:underline">GUT Production Dashboard</a> 
        <span> &gt; </span>
        <span class="text-gray-800 font-medium">Cutting Output</span>
    </div>

<div class="px-6 py-2">
    <div class="grid grid-cols-5 gap-4 mb-8">
        <div class="bg-white p-4 rounded-lg shadow-md kpi-card kpi-card-border-blue" data-type="cuttingOutput">
            <div class="flex items-center mb-1 gap-2">
                <div class="text-xs font-medium text-gray-500 mb-1">Cutting Output</div>
                <div class="flex bg-gray-50 rounded-md border border-gray-200 px-2 py-1 gap-3">
                    <span class="tab-option text-[0.8rem] text-gray-500 cursor-pointer hover:text-kpi-blue hover:font-semibold transition active" data-type="pieces">Pieces</span>
                    <span class="tab-option text-[0.8rem] text-gray-500 cursor-pointer hover:text-kpi-blue hover:font-semibold transition" data-type="lay">Lay</span>
                    <span class="tab-option text-[0.8rem] text-gray-500 cursor-pointer hover:text-kpi-blue hover:font-semibold transition" data-type="fabric">Kgs</span>
                </div>
            </div>    
            <div class="flex justify-between items-end">
                <div class="space-y-0.5">
                    <div id="kpi-value" class="text-3xl font-bold text-kpi-blue">0</div>
                    <div id="kpi-change" class="text-[0.6rem] leading-none text-gray-500">
                        <span class="text-red-500 font-semibold">0%</span> 
                        <span class="text-gray-500">vs yesterday</span>
                    </div>
                    <div id="kpi-target" class="text-[0.6rem] text-gray-400">Target: 0</div>
                </div>
                <div class="w-1/3 h-10 bg-kpi-bg rounded-md p-1">
                    <canvas id="kpi-chart-1"></canvas>
                </div>
            </div>
        </div>


        <div class="bg-white p-4 rounded-lg shadow-md  kpi-card cursor-pointer" data-type="fabricUtilization" style="pointer-events: auto; transition: none; box-shadow: none !important; background-color: #ddd8d8ff !important;">
            <div class="text-xs font-medium text-gray-500 mb-1">Fabric Utilization</div>
            <div class="flex justify-between items-end">
                <div class="space-y-0.5">
                    <div class="text-3xl font-bold text-kpi-blue">86%</div>
                    <div class="text-[0.6rem] leading-none text-gray-500">
                        <span class="text-green-500 font-semibold">2%</span> 
                        <span class="text-gray-500">vs last week</span>
                    </div>
                    <div class="text-[0.6rem] text-gray-400">Target: 90%</div>
                </div>
                <div class="w-1/3 h-10 bg-kpi-bg rounded-md p-1">
                    <canvas id="kpi-chart-2"></canvas>
                </div>
            </div>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-md  kpi-card cursor-pointer" data-type="firstTimeRight" style="pointer-events: auto; transition: none; box-shadow: none !important; background-color: #ddd8d8ff !important;">
            <div class="text-xs font-medium text-gray-500 mb-1">First Time Right</div>
            <div class="flex justify-between items-end">
                <div class="space-y-0.5">
                    <div class="text-3xl font-bold text-kpi-blue">97%</div>
                    <div class="text-[0.6rem] leading-none text-gray-500">
                        <span class="text-green-500 font-semibold">0.5%</span> 
                        <span class="text-gray-500">vs last week</span>
                    </div>
                    <div class="text-[0.6rem] text-gray-400">Target: 95%</div>
                </div>
                <div class="w-1/3 h-10 bg-kpi-bg rounded-md p-1">
                    <canvas id="kpi-chart-3"></canvas>
                </div>
            </div>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-md  kpi-card cursor-pointer" data-type="markerEfficiency" style="pointer-events: auto; transition: none; box-shadow: none !important; background-color: #ddd8d8ff !important;">
            <div class="text-xs font-medium text-gray-500 mb-1">Marker Efficiency</div>
            <div class="flex justify-between items-end">
                <div class="space-y-0.5">
                    <div class="text-3xl font-bold text-kpi-blue">88%</div>
                    <div class="text-[0.6rem] leading-none text-gray-500">
                        <span class="text-red-500 font-semibold">3%</span> 
                        <span class="text-gray-500">vs last week</span>
                    </div>
                    <div class="text-[0.6rem] text-gray-400">Target: 90%</div>
                </div>
                <div class="w-1/3 h-10 bg-kpi-bg rounded-md p-1">
                    <canvas id="kpi-chart-4"></canvas>
                </div>
            </div>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-md  kpi-card cursor-pointer" data-type="machineDowntime" style="pointer-events: auto; transition: none; box-shadow: none !important; background-color: #ddd8d8ff !important;">
            <div class="text-xs font-medium text-gray-500 mb-1">Machine Downtime</div>
            <div class="flex justify-between items-end">
                <div class="space-y-0.5">
                    <div class="text-3xl font-bold text-kpi-blue">124 mins</div>
                    <div class="text-[0.6rem] leading-none text-gray-500">
                        <span class="text-red-500 font-semibold">5%</span> 
                        <span class="text-gray-500">vs yesterday</span>
                    </div>
                    <div class="text-[0.6rem] text-gray-400">Target: 90 mins</div>
                </div>
                <div class="w-1/3 h-10 bg-kpi-bg rounded-md p-1">
                    <canvas id="kpi-chart-5"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-3 gap-4 mb-8 h-[25rem]">
        <div class="bg-white p-4 rounded-lg shadow-md flex flex-col">
            <div class="flex flex-row items-center mb-1">
               
                <div class="text-sm font-semibold text-gray-700 mb-3 bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Overall Trend</div>
                 <div class="text-xs text-gray-500 mb-3 ml-2">Time-series trend for the selected KPI</div>
            </div>
           
            <div class="flex-grow">
                <canvas id="overall-trend-chart"></canvas>
            </div>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-md flex flex-col">
            <div class="text-sm font-semibold text-gray-700 mb-3 bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient" id="unitChartTitle">Machine-wise Total Pieces</div>
            <div class=" mb-3">
                <span id="unitBreadcrumbPieces">All Units</span>
            </div>
            <div class="flex justify-end text-xs font-medium mb-4 space-x-2 hidden">
                <button class="text-bar-main border-b-2 border-bar-main pb-0.5">All Units</button>
                <button class="text-gray-500 hover:text-bar-main">Unit 1</button>
                <button class="text-gray-500 hover:text-bar-main">Unit 2</button>
            </div>
            <div class="flex-grow">
                <canvas id="unit-pieces-chart"></canvas>
            </div>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-md">
            <div class=" flex justify-between items-center mb-4">
                <div class="text-sm font-semibold text-gray-700 mb-3 bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Attribute Drilldown</div>
                <select id="attributeModeSelect" class="text-xs border border-gray-300 rounded-md py-1 px-2 focus:ring-ui-primary focus:border-ui-primary">
                <option>Daily KPI</option>
                <option>Cumulative Progress</option>
                </select>
            </div>
            <div class="space-y-4">
                <div class="">
                    <span id="buyerBreadcrumb">ALL CC</span>
                </div>
                <div class="h-80">
                    <canvas id="attribute-drilldown-chart"></canvas>
                </div>
            </div>
        </div>
    </div>
	<div class="py-4">
		<div class="bg-white p-4 rounded-lg shadow-md mt-4">
			<div class="flex justify-between items-center mb-4">
				<div>
					<h2 class="text-sm font-semibold text-gray-700 mb-3 bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Cutting Details</h2>
					<div class="hidden text-xs text-gray-500 mt-1">A detailed log of each cutting lay operation.</div>
				</div>
			</div>
			<div class=" relative" id="cuttingTableContainer">
				<table class="min-w-full divide-y divide-gray-200" id="cuttingTable">
					<thead>
						<tr>
							<th class="table-header-cell min-w-[50px]">Date</th>
							<th class="table-header-cell min-w-[40px]">Lay ID</th>
							<th class="table-header-cell min-w-[90px]">Unit / Shift / Machine</th>
							<th class="table-header-cell min-w-[50px]">CC</th>
							<th class="table-header-cell min-w-[90px]">OCN / Style / Color</th>
							<th class="table-header-cell min-w-[40px]">Rolls Used</th>
							<th class="table-header-cell min-w-[40px]">GSM</th>
							<th class="table-header-cell min-w-[60px]">Fabric Wt. (kg)</th>
							<th class="table-header-cell min-w-[40px]">End Bit</th>
                        
							<th class="table-header-cell min-w-[60px]">Cutting Time (min)</th>
                        
							<th class="table-header-cell min-w-[60px]">Cutting Output</th>
							<th class="table-header-cell min-w-[40px]">Ack. pend</th>
							<th class="table-header-cell min-w-[60px]">SM Received</th>
							<th class="table-header-cell min-w-[40px]">Line Qty</th>
						</tr>
					</thead>
					<tbody class="bg-white divide-y divide-gray-100 text-gray-700 text-xs"></tbody>
				</table>
				</table>
				<!-- Popper for Roll details -->
				<div id="rollPopper" class="hidden absolute z-50 bg-white shadow-xl rounded-lg border border-gray-200  p-4 text-sm fit-popper">
					<div class="font-semibold text-gray-800 mb-2">Roll Details</div>
					<table class="min-w-full ">
						<thead>
						   <tr class="text-gray-500 text-xs">
								<th class="text-left py-1 w-[60px]">Roll No.</th>
								<th class="text-left py-1 w-[60px]">R_Points</th>
								<th class="text-left py-1 w-[60px]">Supplier</th>
								<th class="text-left py-1 w-[60px]">Shade</th>
								<th class="text-left py-1 w-[60px]">Relax (hrs)</th>
							</tr>
						</thead>
						<tbody id="popRollBody"  class="scroll-ghost">
                        
						</tbody>
					</table>
				</div>
				<!-- Popper for Cut Output Breakdown -->
				<div id="cutPopper" class="hidden absolute z-50 bg-white shadow-xl rounded-lg border border-gray-200 p-4 text-sm fit-popper">
					<div class="font-semibold text-gray-800 mb-2">Cut Output Breakdown</div>
					<table class="min-w-full">
						<thead>
							<tr class="text-gray-500 text-xs">
								<th class="text-left py-1">Size</th>
								<th class="text-left py-1">Qty</th>
								<th class="text-left py-1">FPY%</th>
							</tr>
						</thead>
						<tbody id="cutBreakdownBody" class="scroll-ghost">
							<!-- rows injected on click -->
						</tbody>
					</table>
				</div>
				<!-- Popper for Ack Pending Breakdown -->
				<div id="ackPopper" class="hidden absolute z-50 bg-white shadow-xl rounded-lg border border-gray-200 p-4 text-sm fit-popper">
					<div class="font-semibold text-gray-800 mb-2">Ack. Pending Breakdown</div>
					<table class="min-w-full popper-table-2">
						<thead>
							<tr class="text-gray-500 text-xs">
								<th class="text-left py-1">Size</th>
								<th class="text-left py-1">Qty</th>
							</tr>
						</thead>
						<tbody id="ackBreakdownBody" class="scroll-ghost">
							<!-- rows injected on click -->
						</tbody>
					</table>
				</div>
				<!-- Popper for Issued to SM Breakdown -->
				<div id="issdPopper" class="hidden absolute z-50 bg-white shadow-xl rounded-lg border border-gray-200 p-4 text-sm fit-popper">
					<div class="font-semibold text-gray-800 mb-2">Issued to SM Breakdown</div>
					<table class="min-w-full popper-table-2">
						<thead>
							<tr class="text-gray-500 text-xs">
								<th class="text-left py-1">Size</th>
								<th class="text-left py-1">Qty</th>
							</tr>
						</thead>
						<tbody id="issdBreakdownBody" class="scroll-ghost">
							<!-- rows injected on click -->
						</tbody>
					</table>
				</div>
				<!-- Popper for Line Issue Breakdown -->
				<div id="linePopper" class="hidden absolute z-50 bg-white shadow-xl rounded-lg border border-gray-200 p-4 text-sm fit-popper">
					<div class="font-semibold text-gray-800 mb-2">Line Issue Breakdown</div>
					<table class="min-w-full popper-table-2">
						<thead>
							<tr class="text-gray-500 text-xs">
								<th class="text-left py-1">Size</th>
								<th class="text-left py-1">Qty</th>
							</tr>
						</thead>
						<tbody id="lineBreakdownBody" class="scroll-ghost">
							<!-- rows injected on click -->
						</tbody>
					</table>
				</div>
			</div>
			<div class="hidden flex justify-between items-center mt-4 text-xs text-gray-500">
				<div>Showing 1 to 10 of 50 entries</div>
				<div class="flex items-center space-x-2">
					<button class="px-3 py-1 border border-gray-300 rounded-md hover:bg-gray-100 disabled:opacity-50" disabled>Previous</button>
					<span class="font-semibold text-gray-700 px-2">Page 1 of 5</span>
					<button class="px-3 py-1 border border-gray-300 rounded-md hover:bg-gray-100">Next</button>
				</div>
			</div>
		</div>
	</div>
</div>    

<script>

    // Icons now use Font Awesome; no initialization required
    let unitChart, trendChart, attributeChart;
    let unitLevel = "units";
    let unitPath = [];
    let buyerLevel = "buyers";
    let buyerPath = [];
    let selectedRangeLabel = 'Last Week';
    let apiData = {};
    let cuttingOutput = {};
    let globalDates = [];
    let globalBuyerLabels = [];
    let dataTable;
    let activeCell = null; // Track the currently highlighted cell
	let kpiChart;
    let activeTab = 'pieces';
    
    function processApiData() {
        cuttingOutput = {
            units: { labels: [], values: [], machines: {} },
            buyers: { labels: [], values: [], ocns: {} },
            trend: [],
            logs: []
        };
        if (!apiData || typeof apiData !== 'object' || Object.keys(apiData).length === 0) {
            console.warn("Invalid or empty apiData, initializing empty state");
            globalDates = [];
            globalBuyerLabels = [];
            return;
        }
        let allLogs = [];
        Object.values(apiData).forEach(unit => {
            if (unit && unit.machines && typeof unit.machines === 'object') {
                Object.values(unit.machines).forEach(machine => {
                    if (machine && Array.isArray(machine.data)) {
                        allLogs.push(...machine.data);
                    }
                });
            }
        });
        globalDates = [...new Set(allLogs.map(l => l.Edate).filter(Boolean))].sort();
        let buyersMap = allLogs.reduce((acc, log) => {
            if (!log || !log.Buyer) return acc;
            const ocnKey = log.Order_No || log.Order_no || '(No OCN)';
            if (!acc[log.Buyer]) acc[log.Buyer] = { sum: 0, ocns: {}, logs: [] };
            acc[log.Buyer].sum += parseInt(log.Cut_Qty || 0);
            acc[log.Buyer].logs.push(log);
            if (!acc[log.Buyer].ocns[ocnKey]) acc[log.Buyer].ocns[ocnKey] = { sum: 0, logs: [], units: {}, trend: [] };
            acc[log.Buyer].ocns[ocnKey].sum += parseInt(log.Cut_Qty || 0);
            acc[log.Buyer].ocns[ocnKey].logs.push(log);
            return acc;
        }, {});
        globalBuyerLabels = Object.keys(buyersMap).sort();
        cuttingOutput.buyers = {
            labels: globalBuyerLabels,
            values: globalBuyerLabels.map(b => buyersMap[b]?.sum || 0),
            ocns: globalBuyerLabels.reduce((acc, b) => {
                let ocnMap = buyersMap[b]?.ocns || {};
                acc[b] = {
                    labels: Object.keys(ocnMap),
                    values: Object.values(ocnMap).map(o => o.sum || 0),
                    logs: buyersMap[b]?.logs || []
                };
                Object.keys(ocnMap).forEach(ocn => {
                    let ocnLogs = ocnMap[ocn].logs || [];
                    let ocnUnitSums = {};
                    cuttingOutput.units.labels.forEach(u => ocnUnitSums[u] = 0);
                    ocnLogs.forEach(log => {
                        if (log.Unit) ocnUnitSums[log.Unit] += parseInt(log.Cut_Qty || 0);
                    });
                    acc[b][ocn] = {
                        logs: ocnLogs,
                        units: cuttingOutput.units.labels.map(u => ocnUnitSums[u] || 0),
                        trend: globalDates.map(d => ocnLogs.filter(l => l.Edate === d).reduce((s, l) => s + parseInt(l.Cut_Qty || 0), 0))
                    };
                });
                return acc;
            }, {})
        };
        cuttingOutput.trend = globalDates.map(d => allLogs.filter(l => l.Edate === d).reduce((s, l) => s + parseInt(l.Cut_Qty || 0), 0));
        cuttingOutput.logs = allLogs;
        Object.keys(apiData).forEach(unitName => {
            const unit = apiData[unitName];
            if (!unit || !unit.Cut_Qty_Sum || !unit.machines) return;
            cuttingOutput.units.labels.push(unitName);
            cuttingOutput.units.values.push(unit.Cut_Qty_Sum);
            cuttingOutput.units.machines[unitName] = { labels: [], values: [], buyers: [], trend: [], logs: [], machineData: {} };
            let unitLogs = [];
            Object.keys(unit.machines).forEach(machineName => {
                const machine = unit.machines[machineName];
                if (!machine || !machine.data || !Array.isArray(machine.data)) return;
                cuttingOutput.units.machines[unitName].labels.push(machineName);
                cuttingOutput.units.machines[unitName].values.push(machine.Cut_Qty_Sum || 0);
                cuttingOutput.units.machines[unitName].machineData[machineName] = { logs: machine.data };
                unitLogs.push(...machine.data);
            });
            let unitBuyersMap = unitLogs.reduce((acc, log) => {
                if (!log || !log.Buyer) return acc;
                if (!acc[log.Buyer]) acc[log.Buyer] = { sum: 0 };
                acc[log.Buyer].sum += parseInt(log.Cut_Qty || 0);
                return acc;
            }, {});
            cuttingOutput.units.machines[unitName].buyers = globalBuyerLabels.map(b => unitBuyersMap[b]?.sum || 0);
            cuttingOutput.units.machines[unitName].trend = globalDates.map(d => unitLogs.filter(l => l.Edate === d).reduce((s, l) => s + parseInt(l.Cut_Qty || 0), 0));
            cuttingOutput.units.machines[unitName].logs = unitLogs;
            Object.keys(unit.machines).forEach(machineName => {
                let machineLogs = unit.machines[machineName]?.data || [];
                let machineBuyersMap = machineLogs.reduce((acc, log) => {
                    if (!log || !log.Buyer) return acc;
                    if (!acc[log.Buyer]) acc[log.Buyer] = { sum: 0 };
                    acc[log.Buyer].sum += parseInt(log.Cut_Qty || 0);
                    return acc;
                }, {});
                cuttingOutput.units.machines[unitName].machineData[machineName].buyers = globalBuyerLabels.map(b => machineBuyersMap[b]?.sum || 0);
                cuttingOutput.units.machines[unitName].machineData[machineName].trend = globalDates.map(d => machineLogs.filter(l => l.Edate === d).reduce((s, l) => s + parseInt(l.Cut_Qty || 0), 0));
            });
        });
    }
    
    function fetchData(unit_code = null, fromDate = "", toDate = "") {
        $("#loadSpinner").show();
		let portaltype = '{{$portal_type}}';
               $.ajax({
            url: '/gut_cuttingreport',
            method: 'GET',
            data: { unit_code: unit_code, fromdate: fromDate, enddate: toDate,portaltype : portaltype, empid: "{{ Session('empl_id') }}"  },
            success: function(response) {
                $("#loadSpinner").hide();
                if (response && response.success && response.units) {
                    apiData = response.units;
                    processApiData();
                    updateAllCharts();
                    updateTable(cuttingOutput.logs);
                    try { applyDeepLinkFilterIfAny(); } catch (e) { console.warn('Deep link apply failed', e); }
					updateKPI(activeTab);
                    updateUnitBreadcrumb();
                    updateBuyerBreadcrumb();
                } else {
                    console.warn("Invalid API response, resetting data");
                    apiData = {};
                    processApiData();
                    updateAllCharts();
                    updateTable([]);
					updateKPI(activeTab);
                    updateUnitBreadcrumb();
                    updateBuyerBreadcrumb();
                }
            },
            error: function() {
                $("#loadSpinner").hide();
                console.error("Error fetching data");
                apiData = {};
                processApiData();
                updateAllCharts();
                updateTable([]);
				updateKPI(activeTab);
                updateUnitBreadcrumb();
                updateBuyerBreadcrumb();
            }
        });
    }
    function updateAllCharts() {
        trendChart.data.labels = globalDates;
        trendChart.data.datasets[0].data = cuttingOutput.trend;
        trendChart.update();
        unitChart.data.labels = cuttingOutput.units.labels;
        unitChart.data.datasets[0].data = cuttingOutput.units.values;
        unitChart.update();
        attributeChart.data.labels = cuttingOutput.buyers.labels;
        attributeChart.data.datasets[0].data = cuttingOutput.buyers.values;
        attributeChart.update();
    }

    // Deep link: apply buyer/ocn/unit filters from URL to charts and table
    function applyDeepLinkFilterIfAny() {
        const params = new URLSearchParams(window.location.search);
        const buyer = (params.get('buyer') || '').trim();
        const ocn = (params.get('ocn') || '').trim();
        const unit = (params.get('unit') || '').trim();
        if (!buyer && !ocn && !unit) return;

        // Buyer drilldown
        if (buyer && ocn) {
            buyerLevel = 'ocn';
            buyerPath = [buyer, ocn];
            updateBuyerChart('ocn', buyer, ocn);
        } else if (buyer) {
            buyerLevel = 'ocns';
            buyerPath = [buyer];
            updateBuyerChart('ocns', buyer);
        }

        // Unit context
        if (unit) {
            unitLevel = 'machines';
            unitPath = [unit];
            updateUnitChart('machines', unit);
        }

        // If unit specified, recompute per-machine totals filtered by buyer/ocn
        if (unit) {
            const unitData = cuttingOutput.units.machines[unit] || {};
            const labels = (unitData.labels || []).slice();
            const machineData = unitData.machineData || {};
            const sums = labels.reduce((acc, m) => { acc[m] = 0; return acc; }, {});
            labels.forEach(m => {
                const logs = (machineData[m]?.logs || []).filter(l => {
                    if (buyer && String(l.Buyer || '').trim() !== buyer) return false;
                    const lOcn = String(l.Order_No || l.Order_no || l.OCN || '').trim();
                    if (ocn && lOcn !== ocn) return false;
                    return true;
                });
                sums[m] = logs.reduce((s, l) => s + (parseInt(l.Cut_Qty || 0)), 0);
            });
            unitChart.data.labels = labels;
            unitChart.data.datasets[0].data = labels.map(m => sums[m] || 0);
            unitChart.data.datasets[0].backgroundColor = '#000080';
            unitChart.update();
        }

        // Filter Cutting Details table
        const filtered = (cuttingOutput.logs || []).filter(l => {
            if (buyer && String(l.Buyer || '').trim() !== buyer) return false;
            const lOcn = String(l.Order_No || l.Order_no || l.OCN || '').trim();
            if (ocn && lOcn !== ocn) return false;
            if (unit && String(l.Unit || '').trim() !== unit) return false;
            return true;
        });
        if (filtered.length) updateTable(filtered);

        updateUnitBreadcrumb();
        updateBuyerBreadcrumb();
    }

    function updateKPI(type = activeTab) {
        let logs = [];
        if (dataTable) {
            logs = dataTable.rows({ filter: 'applied' }).data().toArray().map(row => ({
                Cut_Qty: row[10].match(/>\s*([\d,]+)\s*</)?.[1].replace(/,/g, '') || '0',
                Lay_ID: row[1],
                Fabric_Wt: row[7].replace(/,/g, '') || '0'
            }));
        }
        let value = 0;
        if (type === 'pieces') {
            value = logs.reduce((sum, row) => sum + parseInt(row.Cut_Qty || 0), 0);
        } else if (type === 'lay') {
            value = new Set(logs.map(row => row.Lay_ID)).size;
        } else if (type === 'fabric') {
            value = logs.reduce((sum, row) => sum + parseFloat(row.Fabric_Wt || 0), 0);
        }
        $('#kpi-value').text(value.toLocaleString());
        $('#kpi-change').html(`<span class="${kpiData[type].change.startsWith('-') ? 'text-red-500' : 'text-green-500'} font-semibold">${kpiData[type].change}</span> <span class="text-gray-500">vs yesterday</span>`);
        $('#kpi-target').text(`Target: ${kpiData[type].target}`);
        kpiChart.data.datasets[0].data = kpiData[type].chart;
        kpiChart.update();
    }
    function updateUnitChart(level, unit, selectedMachine = null) {
        let labels, values;
        if (level === "units") {
            labels = cuttingOutput.units.labels;
            values = cuttingOutput.units.values;
        } else if (level === "machines" || level === "machine") {
            labels = cuttingOutput.units.machines[unit]?.labels || [];
            values = cuttingOutput.units.machines[unit]?.values || [];
        }
        unitChart.data.labels = labels;
        unitChart.data.datasets[0].data = values;
        if (selectedMachine && level === "machine") {
            unitChart.data.datasets[0].backgroundColor = labels.map(l => l === selectedMachine ? '#1e3a8a' : '#d1d5db');
        } else {
            unitChart.data.datasets[0].backgroundColor = '#000080';
        }
        unitChart.update();
    }
    function updateBuyerChart(level, buyer, selectedOCN = null) {
        let labels, values;
        if (level === "buyers") {
            labels = cuttingOutput.buyers.labels;
            values = cuttingOutput.buyers.values;
        } else if (level === "ocns" || level === "ocn") {
            labels = cuttingOutput.buyers.ocns[buyer]?.labels || [];
            values = cuttingOutput.buyers.ocns[buyer]?.values || [];
        }
        attributeChart.data.labels = labels;
        attributeChart.data.datasets[0].data = values;
        // Always use navy blue for all bars at ALL CC stage and when drilling back
        if (level === "buyers" || level === "ocns") {
            attributeChart.data.datasets[0].backgroundColor = '#000080';
        } else if (selectedOCN && level === "ocn") {
            attributeChart.data.datasets[0].backgroundColor = labels.map(l => l === selectedOCN ? '#1e3a8a' : '#000080');
        } else {
            attributeChart.data.datasets[0].backgroundColor = '#000080';
        }
        attributeChart.update();
    }
    function updateUnitBreadcrumb() {
        let breadcrumbHtml = '<span id="allUnits" class="cursor-pointer hover:underline">All Units</span>';
        if (unitLevel === "machines" && unitPath.length > 0) {
            breadcrumbHtml += ` > <span id="unitName" class="cursor-pointer hover:underline " data-unit="${unitPath[0]}">${unitPath[0]}</span>`;
        } else if (unitLevel === "machine" && unitPath.length > 1) {
            breadcrumbHtml += ` > <span id="unitName" class="cursor-pointer hover:underline " data-unit="${unitPath[0]}">${unitPath[0]}</span>`;
            breadcrumbHtml += ` > <span id="machineName" class="cursor-pointer hover:underline " data-unit="${unitPath[0]}" data-machine="${unitPath[1]}">${unitPath[1]}</span>`;
        }
        $("#unitBreadcrumbPieces").html(breadcrumbHtml);
    }
    function updateBuyerBreadcrumb() {
        let breadcrumbHtml = '<span id="allBuyers" class="cursor-pointer hover:underline ">ALL CC</span>';
        if (buyerLevel === "ocns" && buyerPath.length > 0) {
            breadcrumbHtml += ` > <span id="buyerName" class="cursor-pointer hover:underline " data-buyer="${buyerPath[0]}">${buyerPath[0]}</span>`;
        } else if (buyerLevel === "ocn" && buyerPath.length > 1) {
            breadcrumbHtml += ` > <span id="buyerName" class="cursor-pointer hover:underline " data-buyer="${buyerPath[0]}">${buyerPath[0]}</span>`;
            breadcrumbHtml += ` > <span id="ocnName" class="cursor-pointer hover:underline " data-buyer="${buyerPath[0]}" data-ocn="${buyerPath[1]}">${buyerPath[1]}</span>`;
        }
        $("#buyerBreadcrumb").html(breadcrumbHtml);
    }
    function resetBothChartsToTop() {
        unitLevel = "units";
        unitPath = [];
        unitChart.data.labels = cuttingOutput.units.labels;
        unitChart.data.datasets[0].data = cuttingOutput.units.values;
        unitChart.data.datasets[0].backgroundColor = '#000080';
        unitChart.update();
        buyerLevel = "buyers";
        buyerPath = [];
        attributeChart.data.labels = cuttingOutput.buyers.labels;
        attributeChart.data.datasets[0].data = cuttingOutput.buyers.values;
        attributeChart.data.datasets[0].backgroundColor = '#000080';
        attributeChart.update();
        trendChart.data.datasets[0].data = cuttingOutput.trend;
        trendChart.update();
        updateTable(cuttingOutput.logs);
		updateKPI(activeTab);
        updateUnitBreadcrumb();
        updateBuyerBreadcrumb();
    }
    function syncChartsAndUpdateAll() {
        const filterUnit = unitPath[0];
        const filterMachine = unitPath[1];
        const filterBuyer = buyerPath[0];
        const filterOCN = buyerPath[1];
        if (unitLevel === "units") {
            unitChart.data.labels = cuttingOutput.units.labels;
            unitChart.data.datasets[0].data = cuttingOutput.units.values;
            unitChart.data.datasets[0].backgroundColor = '#000080';
        } else if (unitLevel === "machines") {
            const unitData = cuttingOutput.units.machines[filterUnit];
            if (unitData) {
                unitChart.data.labels = unitData.labels;
                unitChart.data.datasets[0].data = unitData.values;
                unitChart.data.datasets[0].backgroundColor = '#000080';
            }
        } else if (unitLevel === "machine") {
            const unitData = cuttingOutput.units.machines[filterUnit];
            if (unitData) {
                unitChart.data.labels = unitData.labels;
                unitChart.data.datasets[0].data = unitData.values;
                unitChart.data.datasets[0].backgroundColor = unitData.labels.map(l => l === filterMachine ? '#1e3a8a' : '#d1d5db');
            }
        }
        unitChart.update();
        if (buyerLevel === "buyers") {
            attributeChart.data.labels = cuttingOutput.buyers.labels;
            attributeChart.data.datasets[0].data = cuttingOutput.buyers.values;
            attributeChart.data.datasets[0].backgroundColor = '#000080';
        } else if (buyerLevel === "ocns") {
            const buyerData = cuttingOutput.buyers.ocns[filterBuyer];
            if (buyerData) {
                attributeChart.data.labels = buyerData.labels;
                attributeChart.data.datasets[0].data = buyerData.values;
                attributeChart.data.datasets[0].backgroundColor = '#000080';
            }
        } else if (buyerLevel === "ocn") {
            const buyerData = cuttingOutput.buyers.ocns[filterBuyer];
            //clickcolorchange
            if (buyerData) {
                attributeChart.data.labels = buyerData.labels;
                attributeChart.data.datasets[0].data = buyerData.values;
                attributeChart.data.datasets[0].backgroundColor = buyerData.labels.map(l => l === filterOCN ? '#1e3a8a' : '#000080');
            }
        }
        attributeChart.update();
        let currentLogs = cuttingOutput.logs;
        let trendData = cuttingOutput.trend;
        if (unitLevel === "machine" && filterUnit && filterMachine) {
            currentLogs = cuttingOutput.units.machines[filterUnit]?.machineData[filterMachine]?.logs || [];
            trendData = cuttingOutput.units.machines[filterUnit]?.machineData[filterMachine]?.trend || [];
        } else if (buyerLevel === "ocn" && filterBuyer && filterOCN) {
            currentLogs = cuttingOutput.buyers.ocns[filterBuyer]?.[filterOCN]?.logs || [];
            trendData = cuttingOutput.buyers.ocns[filterBuyer]?.[filterOCN]?.trend || [];
        }
        trendChart.data.datasets[0].data = trendData;
        trendChart.update();
        updateTable(currentLogs);
		updateKPI(activeTab);
        updateUnitBreadcrumb();
        updateBuyerBreadcrumb();
    }

    function updateTable(logs) {
        if (dataTable) {
            dataTable.clear().destroy();
            $("#cuttingTable tbody").empty();
        }
        const totalCuttingOutput = logs.reduce((sum, row) => sum + parseInt(row.Cut_Qty || 0), 0);
        
        const tableData = logs.map((row, idx) => {
            const formattedDate = row.Edate ? moment(row.Edate).format('DD-MM-YY') : '-';
            return [
                formattedDate,
                row.Lay_ID || '-',
                `${row.Unit || '-'} / ${row.Machine_type || '-'}`,
                row.Buyer || '-',
                `${row.Order_no ? row.Order_no : ' '} `,
                `<span class="rolls-used-cell font-bold text-bar-main cursor-pointer"
                    data-roll-no="${row.Roll_No || ''}"
                    data-rpoints="${row.R_Points || row.Rpoints || ''}"
                    data-supplier="${row.Supplier || ''}"
                    data-shade="${row.Shade || ''}"
                    data-layid="${row.Master_id ?? ''}"
                    data-relax="${row.Relax_hrs || row.Relax || ''}">
                    ${row.Roll_used || '-'}
                </span>`,
                row.gsm || '-',
                row.Fabric_wt || '-',
                row.End_bit || '-',
                row.Cut_time || '-',
                `<span class="cut-qty-cell font-bold text-bar-main cursor-pointer"
                    data-layid="${row.Master_id ?? ''}">
                    ${row.Cut_Qty || '-'}
                </span>`,
                `<span class="ack-pcs-cell font-bold text-bar-main cursor-pointer"
                   data-layid="${row.Master_id ?? ''}">
                    ${row.Ack_Pcs || '-'}
                </span>`,
                `<span class="issd-cell font-bold text-bar-main cursor-pointer"
                    data-layid="${row.Master_id ?? ''}"
                    data-breakdown='${(row.Issd_Breakdown || row.Issued_Breakdown || []).length ? JSON.stringify(row.Issd_Breakdown || row.Issued_Breakdown) : ''}'>
                    ${row.Issd || '-'}
                </span>`,
                `<span class="line-qty-cell font-bold text-bar-main cursor-pointer"
                    data-layid="${row.Master_id ?? ''}"
                    data-breakdown='${(row.Line_Breakdown || row.Line_Size_Breakdown || []).length ? JSON.stringify(row.Line_Breakdown || row.Line_Size_Breakdown) : ''}'>
                    ${row.Line_Qty || '-'}
                </span>`
            ];
        });
        dataTable = $("#cuttingTable").DataTable({
            data: tableData,
            columns: [
                { title: "Date" },
                { title: "Lay ID" },
                { title: "Unit / Shift / Machine" },
                { title: "CC" },
                { title: "OrderNO" },
                { title: "Rolls Used" },
                { title: "GSM" },
                { title: "Fabric Wt. (kg)" },
                { title: "End Bit" },
                { title: "Cutting Time (min)" },
                { title: "Cutting Output" },
                { title: "Ack. pend" },
                { title: "SM Received" },
                { title: "Line Qty" }
            ],
            language: {
                lengthMenu: 'Show _MENU_ rows',
                search: 'search:'
            },
            pageLength: 10,
            lengthMenu: [10, 25, 50, 100],
            searching: true,
            ordering: true,
            destroy: true,
            drawCallback: function() {
                bindPopperEvents();
				updateKPI();
            }
        });
        dataTable.on('length.dt', function(e, settings, len) {
            const container = document.getElementById('cuttingTableContainer');
            const thead = document.querySelector('#cuttingTable thead');
            if (!container || !thead) return;
            if (len > 10) {
                container.style.maxHeight = '520px';
                container.style.overflowY = 'auto';
                thead.style.position = 'sticky';
                thead.style.top = '0';
                thead.style.zIndex = '10';
                thead.style.background = '#ffffff';
            } else {
                container.style.maxHeight = '';
                container.style.overflowY = '';
                thead.style.position = '';
                thead.style.top = '';
                thead.style.zIndex = '';
                thead.style.background = '';
            }
        });
        function hideAllPoppers() {
            $('#rollPopper,#cutPopper,#ackPopper,#issdPopper,#linePopper').addClass('hidden');
            if (activeCell) {
                $(activeCell).removeClass('highlight');
                activeCell = null;
            }
        }
        function bindPopperEvents() {
            $("#cuttingTable tbody .rolls-used-cell").off('click').on('click', function(e) {
                e.stopPropagation();
                const popper = document.getElementById('rollPopper');
                const $cell = $(this);
                const layID = $cell.data('layid');
                let portaltype = '{{$portal_type}}';
                console.log("layid",layID);
                const isHidden = popper.classList.contains('hidden');
                if (isHidden) {
                    hideAllPoppers();
                    activeCell = this;
                    $(this).addClass('highlight');
                    const rect = this.getBoundingClientRect();
                    const containerRect = document.querySelector('#cuttingTableContainer').getBoundingClientRect();
                    popper.style.top = `${rect.top - containerRect.top  }px`;
                    popper.style.left = `${rect.left - containerRect.left + 20}px`;
                    popper.classList.remove('hidden');
                    $('#popRollBody').html('<tr><td colspan="5" class="py-1 text-gray-500">Loading...</td></tr>');
                    $.ajax({
                        url: '/gut-sizerollbreakup',
                        type: 'GET',
                        data: { layid: layID,portaltype:portaltype },
                        success: function(res) {
                            if (res.success && res.data.length) {
                                const rows = res.data.map(item => `
                                    <tr class="text-gray-800">
                                        <td class="py-1 pr-4">${item.RollNo || '-'}</td>
                                        <td class="py-1 pr-4">${item.R_POints || item.R_POints || '-'}</td>
                                        <td class="py-1 pr-4">${item.Supplier || '-'}</td>
                                        <td class="py-1 pr-4">${item.Shade || '-'}</td>
                                        <td class="py-1">${item.Relax_hrs || item.Relax || '-'}</td>
                                    </tr>
                                `).join('');
                                $('#popRollBody').html(rows);
                            } else {
                                $('#popRollBody').html('<tr><td colspan="5" class="py-1 text-gray-500">No roll details available</td></tr>');
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error('Error fetching roll details:', error);
                            $('#popRollBody').html('<tr><td colspan="5" class="py-1 text-red-500">Error loading data</td></tr>');
                        }
                    });
                } else {
                    hideAllPoppers();
                }
            });
            $(document).off('click.rollpop').on('click.rollpop', function() {
                hideAllPoppers();
            });
            $("#cuttingTable tbody .cut-qty-cell").off('click').on('click', function(e) {
                e.stopPropagation();
                const popper = document.getElementById('cutPopper');
                const $cell = $(this);
                const layID = $cell.data('layid');
                const isHidden = popper.classList.contains('hidden');
                let portaltype = '{{$portal_type}}';
                if (isHidden) {
                    hideAllPoppers();
                    activeCell = this;
                    $(this).addClass('highlight');
                    const rect = this.getBoundingClientRect();
                    const containerRect = document.querySelector('#cuttingTableContainer').getBoundingClientRect();
                    popper.style.top = `${rect.top - containerRect.top - 140}px`;
                    popper.style.left = `${rect.left - containerRect.left  + 30}px`;
                    popper.classList.remove('hidden');
                    $('#cutBreakdownBody').html('<tr><td colspan="3" class="py-1 text-gray-500">Loading...</td></tr>');
                    $.ajax({
                        url: '/gut-sizr-breakup-cutting',
                        type: 'GET',
                        data: { layid: layID,portaltype:portaltype },
                        success: function(res) {
                            if (res.success && res.data.length) {
                                const rows = res.data.map(it => `
                                    <tr class="text-gray-800">
                                        <td class="py-1 pr-4">${it.size || '-'}</td>
                                        <td class="py-1 pr-4">${it.Qty ?? '-'}</td>
                                        <td class="py-1">${it.FPY ?? '-'}</td>
                                    </tr>
                                `).join('');
                                $('#cutBreakdownBody').html(rows);
                            } else {
                                $('#cutBreakdownBody').html('<tr><td colspan="3" class="py-1 text-gray-500">No breakdown available</td></tr>');
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error('Error fetching size breakup:', error);
                            $('#cutBreakdownBody').html('<tr><td colspan="3" class="py-1 text-red-500">Error loading data</td></tr>');
                        }
                    });
                } else {
                    hideAllPoppers();
                }
            });
            $(document).off('click.cutpop').on('click.cutpop', function() {
                hideAllPoppers();
            });
            $("#cuttingTable tbody .ack-pcs-cell").off('click').on('click', function(e) {
                e.stopPropagation();
                const popper = document.getElementById('ackPopper');
                const $cell = $(this);
                const layID = $cell.data('layid');
                const isHidden = popper.classList.contains('hidden');
                let portaltype = '{{$portal_type}}';
                if (isHidden) {
                    hideAllPoppers();
                    activeCell = this;
                    $(this).addClass('highlight');
                    const rect = this.getBoundingClientRect();
                    const containerRect = document.querySelector('#cuttingTableContainer').getBoundingClientRect();
                    popper.style.top = `${rect.top - containerRect.top - 140}px`;
                    popper.style.left = `${rect.left - containerRect.left + 40}px`;
                    popper.classList.remove('hidden');
                    $('#ackBreakdownBody').html('<tr><td colspan="2" class="text-gray-500 py-1">Loading...</td></tr>');
                    $.ajax({
                        url: '/gut-get-ack-breakdown',
                        method: 'GET',
                        data: { layid: layID, arg: 1,portaltype : portaltype },
                        success: function(response) {
                            let items = response.data || [];
                            const tbodyHtml = items.length
                                ? items.map(it => `
                                    <tr class="text-gray-800">
                                        <td class="py-1 pr-4">${it.Size || '-'}</td>
                                        <td class="py-1">${it.Qty ?? '-'}</td>
                                    </tr>
                                `).join('')
                                : '<tr><td class="py-1 text-gray-500" colspan="2">No breakdown available</td></tr>';
                            $('#ackBreakdownBody').html(tbodyHtml);
                        },
                        error: function(xhr) {
                            console.error(xhr);
                            $('#ackBreakdownBody').html('<tr><td colspan="2" class="text-red-500 py-1">Error loading data</td></tr>');
                        }
                    });
                } else {
                    hideAllPoppers();
                }
            });
            $(document).off('click.ackpop').on('click.ackpop', function() {
                hideAllPoppers();
            });
            $("#cuttingTable tbody .issd-cell").off('click').on('click', function(e) {
                e.stopPropagation();
                const popper = document.getElementById('issdPopper');
                const $cell = $(this);
                const layID = $cell.data('layid');
                const isHidden = popper.classList.contains('hidden');
                let portaltype = '{{$portal_type}}';
                if (isHidden) {
                    hideAllPoppers();
                    activeCell = this;
                    $(this).addClass('highlight');
                    const rect = this.getBoundingClientRect();
                    const containerRect = document.querySelector('#cuttingTableContainer').getBoundingClientRect();
                    popper.style.top = `${rect.top - containerRect.top - 140}px`;
                    popper.style.left = `${rect.left - containerRect.left - 180}px`;
                    popper.classList.remove('hidden');
                    $('#issdBreakdownBody').html('<tr><td colspan="2" class="text-gray-500 py-1">Loading...</td></tr>');
                    $.ajax({
                        url: '/gut-get-ack-breakdown',
                        method: 'GET',
                        data: { layid: layID, arg: 2 ,portaltype : portaltype},
                        success: function(response) {
                            let items = response.data || [];
                            const tbodyHtml = items.length
                                ? items.map(it => `
                                    <tr class="text-gray-800">
                                        <td class="py-1 pr-4">${it.Size || '-'}</td>
                                        <td class="py-1">${it.Qty ?? '-'}</td>
                                    </tr>
                                `).join('')
                                : '<tr><td class="py-1 text-gray-500" colspan="2">No breakdown available</td></tr>';
                            $('#issdBreakdownBody').html(tbodyHtml);
                        },
                        error: function() {
                            $('#issdBreakdownBody').html('<tr><td colspan="2" class="text-red-500 py-1">Error loading data</td></tr>');
                        }
                    });
                } else {
                    hideAllPoppers();
                }
            });
            $(document).off('click.issdpop').on('click.issdpop', function() {
                hideAllPoppers();
            });
            $("#cuttingTable tbody .line-qty-cell").off('click').on('click', function(e) {
                e.stopPropagation();
                const popper = document.getElementById('linePopper');
                const $cell = $(this);
                const layID = $cell.data('layid');
                const isHidden = popper.classList.contains('hidden');
                 let portaltype = '{{$portal_type}}';
                if (isHidden) {
                    hideAllPoppers();
                    activeCell = this;
                    $(this).addClass('highlight');
                    const rect = this.getBoundingClientRect();
                    const containerRect = document.querySelector('#cuttingTableContainer').getBoundingClientRect();
                    popper.style.top = `${rect.top - containerRect.top - 140}px`;
                    popper.style.left = `${rect.left - containerRect.left - 180}px`;
                    popper.classList.remove('hidden');
                    $('#lineBreakdownBody').html('<tr><td colspan="2" class="text-gray-500 py-1">Loading...</td></tr>');
                    $.ajax({
                        url: '/gut-get-ack-breakdown',
                        method: 'GET',
                        data: { layid: layID, arg: 3 ,portaltype : portaltype},
                        success: function(response) {
                            let items = response.data || [];
                            const tbodyHtml = items.length
                                ? items.map(it => `
                                    <tr class="text-gray-800">
                                        <td class="py-1 pr-4">${it.Size || '-'}</td>
                                        <td class="py-1">${it.Qty ?? '-'}</td>
                                    </tr>
                                `).join('')
                                : '<tr><td class="py-1 text-gray-500" colspan="2">No breakdown available</td></tr>';
                            $('#lineBreakdownBody').html(tbodyHtml);
                        },
                        error: function() {
                            $('#lineBreakdownBody').html('<tr><td colspan="2" class="text-red-500 py-1">Error loading data</td></tr>');
                        }
                    });
                } else {
                    hideAllPoppers();
                }
            });
            $(document).off('click.linepop').on('click.linepop', function() {
                hideAllPoppers();
            });
        }
    }

    function drillOutUnits() {
        unitLevel = "units";
        unitPath = [];
        updateUnitChart("units");
        // Reset attribute chart to show ALL CC
        buyerLevel = "buyers";
        buyerPath = [];
        updateBuyerChart("buyers");
        attributeChart.data.labels = cuttingOutput.buyers.labels;
        attributeChart.data.datasets[0].data = cuttingOutput.buyers.values;
        attributeChart.data.datasets[0].backgroundColor = '#000080';
        attributeChart.update();
        trendChart.data.datasets[0].data = cuttingOutput.trend;
        trendChart.update();
        updateTable(cuttingOutput.logs);
		updateKPI(activeTab);
        updateUnitBreadcrumb();
        updateBuyerBreadcrumb();
    }
    function drillBackUnits(unit) {
        unitLevel = "machines";
        unitPath = [unit];
        updateUnitChart("machines", unit);
        // Update attribute chart to show buyers for this unit
        buyerLevel = "buyers";
        buyerPath = [];
        updateBuyerChart("buyers");
        attributeChart.data.labels = cuttingOutput.buyers.labels;
        attributeChart.data.datasets[0].data = cuttingOutput.units.machines[unit]?.buyers || [];
        attributeChart.data.datasets[0].backgroundColor = '#000080';
        attributeChart.update();
        // Update trend chart with unit-specific trend data
        const unitTrend = cuttingOutput.units.machines[unit]?.trend || cuttingOutput.trend;
        trendChart.data.datasets[0].data = unitTrend;
        trendChart.update();
        // Update table with unit-specific logs
        const unitLogs = cuttingOutput.units.machines[unit]?.logs || cuttingOutput.logs;
        updateTable(unitLogs);
		updateKPI(activeTab);
        updateUnitBreadcrumb();
        updateBuyerBreadcrumb();
    }
    function drillBackMachine(unit, machine) {
        unitLevel = "machine";
        unitPath = [unit, machine];
        updateUnitChart("machine", unit, machine);
        // Update attribute chart to show buyers for this machine
        buyerLevel = "buyers";
        buyerPath = [];
        updateBuyerChart("buyers");
        attributeChart.data.labels = cuttingOutput.buyers.labels;
        attributeChart.data.datasets[0].data = cuttingOutput.units.machines[unit]?.machineData[machine]?.buyers || [];
        attributeChart.data.datasets[0].backgroundColor = '#000080';
        attributeChart.update();
        // Update trend chart with machine-specific trend data
        const machineTrend = cuttingOutput.units.machines[unit]?.machineData[machine]?.trend || cuttingOutput.trend;
        trendChart.data.datasets[0].data = machineTrend;
        trendChart.update();
        // Update table with machine-specific logs
        const machineLogs = cuttingOutput.units.machines[unit]?.machineData[machine]?.logs || cuttingOutput.logs;
        updateTable(machineLogs);
		updateKPI(activeTab);
        updateUnitBreadcrumb();
        updateBuyerBreadcrumb();
    }
    function drillOutBuyers() {
        buyerLevel = "buyers";
        buyerPath = [];
        updateBuyerChart("buyers");
        // Reset unit chart to show all units
        unitLevel = "units";
        unitPath = [];
        updateUnitChart("units");
        unitChart.data.labels = cuttingOutput.units.labels;
        unitChart.data.datasets[0].data = cuttingOutput.units.values;
        unitChart.data.datasets[0].backgroundColor = '#000080';
        unitChart.update();
        trendChart.data.datasets[0].data = cuttingOutput.trend;
        trendChart.update();
        updateTable(cuttingOutput.logs);
		updateKPI(activeTab);
        updateBuyerBreadcrumb();
        updateUnitBreadcrumb();
    }
    function drillBackBuyers(buyer) {
        buyerLevel = "ocns";
        buyerPath = [buyer];
        updateBuyerChart("ocns", buyer);
        // Update unit chart to show units for this buyer
        unitLevel = "units";
        unitPath = [];
        updateUnitChart("units");
        let buyerLogs = cuttingOutput.buyers.ocns[buyer]?.logs || [];
        let unitSums = cuttingOutput.units.labels.reduce((acc, u) => { acc[u] = 0; return acc; }, {});
        buyerLogs.forEach(log => unitSums[log.Unit] += parseInt(log.Cut_Qty || 0));
        unitChart.data.labels = cuttingOutput.units.labels;
        unitChart.data.datasets[0].data = cuttingOutput.units.labels.map(u => unitSums[u] || 0);
        unitChart.data.datasets[0].backgroundColor = '#000080';
        unitChart.update();
        // Update trend chart with buyer-specific trend data
        const buyerTrend = globalDates.map(d => buyerLogs.filter(l => l.Edate === d).reduce((s, l) => s + parseInt(l.Cut_Qty || 0), 0));
        trendChart.data.datasets[0].data = buyerTrend;
        trendChart.update();
        updateTable(buyerLogs);
		updateKPI(activeTab);
        updateBuyerBreadcrumb();
        updateUnitBreadcrumb();
    }
    function drillBackOCN(buyer, ocn) {
        buyerLevel = "ocn";
        buyerPath = [buyer, ocn];
        updateBuyerChart("ocn", buyer, ocn);
        // Update unit chart to show units for this OCN
        unitLevel = "units";
        unitPath = [];
        updateUnitChart("units");
        let ocnLogs = cuttingOutput.buyers.ocns[buyer]?.[ocn]?.logs || [];
        let unitSums = cuttingOutput.units.labels.reduce((acc, u) => { acc[u] = 0; return acc; }, {});
        ocnLogs.forEach(log => {
            if (log.Unit) unitSums[log.Unit] += parseInt(log.Cut_Qty || 0);
        });
        unitChart.data.labels = cuttingOutput.units.labels;
        unitChart.data.datasets[0].data = cuttingOutput.units.labels.map(u => unitSums[u] || 0);
        unitChart.data.datasets[0].backgroundColor = '#000080';
        unitChart.update();
        // Update trend chart with OCN-specific trend data
        const ocnTrend = cuttingOutput.buyers.ocns[buyer]?.[ocn]?.trend || globalDates.map(d => ocnLogs.filter(l => l.Edate === d).reduce((s, l) => s + parseInt(l.Cut_Qty || 0), 0));
        trendChart.data.datasets[0].data = ocnTrend;
        trendChart.update();
        updateTable(ocnLogs);
		updateKPI(activeTab);
        updateBuyerBreadcrumb();
        updateUnitBreadcrumb();
    }
    const smallChartOptions = {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: { display: false },
            tooltip: { enabled: false }
        },
        layout: { padding: 0 },
        scales: {
            x: { display: false },
            y: { display: false }
        }
    };
    var kpiData = {
        pieces: { change: "-5%", target: "8,000", chart: [5, 6, 7, 8, 6, 7, 8] },
        lay: { change: "+2%", target: "500", chart: [3, 4, 4, 5, 4, 5, 6] },
        fabric: { change: "-1%", target: "70", chart: [2, 2, 3, 3, 2, 3, 2] }
    };
    var ctx = document.getElementById('kpi-chart-1').getContext('2d');
    kpiChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: ["Mon","Tue","Wed","Thu","Fri","Sat","Sun"],
            datasets: [{
                data: kpiData.pieces.chart,
                borderColor: "#3b82f6",
                backgroundColor: "rgba(59,130,246,0.2)",
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            plugins: { legend: { display: false } },
            scales: { x: { display: false }, y: { display: false } }
        }
    });
    new Chart(document.getElementById('kpi-chart-2'), {
        type: 'line',
        data: {
            labels: ['A', 'B', 'C', 'D', 'E'],
            datasets: [{ data: [90, 85, 88, 86, 86], borderColor: '#ef4444', tension: 0.4, borderWidth: 2, pointRadius: 0, fill: false }]
        },
        options: smallChartOptions
    });
    new Chart(document.getElementById('kpi-chart-3'), {
        type: 'line',
        data: {
            labels: ['A', 'B', 'C', 'D', 'E'],
            datasets: [{ data: [95, 96, 98, 97.5, 97], borderColor: '#f59e0b', tension: 0.4, borderWidth: 2, pointRadius: 0, fill: false }]
        },
        options: smallChartOptions
    });
    new Chart(document.getElementById('kpi-chart-4'), {
        type: 'line',
        data: {
            labels: ['A', 'B', 'C', 'D', 'E'],
            datasets: [{ data: [80, 85, 90, 89, 88], borderColor: '#14b8a6', tension: 0.4, borderWidth: 2, pointRadius: 0, fill: false }]
        },
        options: smallChartOptions
    });
    new Chart(document.getElementById('kpi-chart-5'), {
        type: 'line',
        data: {
            labels: ['A', 'B', 'C', 'D', 'E'],
            datasets: [{ data: [130, 110, 100, 120, 124], borderColor: '#8b5cf6', tension: 0.4, borderWidth: 2, pointRadius: 0, fill: false }]
        },
        options: smallChartOptions
    });
    $(document).ready(function() {
		
		$('.tab-option').on('click', function() {
            $('.tab-option').removeClass('active');
            $(this).addClass('active');
            activeTab = $(this).data('type');
            updateKPI();
        });
		 
        $(`#HistoricalButton`).on('click', function () {
		const drp = $('#dateRangePicker').data('daterangepicker');
                const from = drp && drp.startDate ? drp.startDate.format('YYYY-MM-DD') : moment().format('YYYY-MM-DD');
                const to = drp && drp.endDate ? drp.endDate.format('YYYY-MM-DD') : moment().format('YYYY-MM-DD');
                window.location.href = `/gut_history_dashboard/{{$portal_type}}?fromdate=${from}&enddate=${to}&type=Cutting`;
            
        });

        trendChart = new Chart(document.getElementById('overall-trend-chart'), {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'Trend',
                    data: [],
                    borderColor: '#000080',
                    backgroundColor: 'rgba(0, 0, 128, 0.1)',
                    tension: 0.3,
                    borderWidth: 2,
                    pointRadius: 4,
                    pointBackgroundColor: '#000080',
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { legend: { display: false }, tooltip: { mode: 'index', intersect: false } },
                scales: {
                    x: {
                        grid: { display: false },
                        ticks: {
                            callback: function(value, index, values) {
                                return moment(this.getLabelForValue(value)).format('DD-MM-YY');
                            }
                        }
                    },
                    y: { beginAtZero: true, grid: { color: '#e5e7eb' } }
                }
            }
        });
        unitChart = new Chart(document.getElementById('unit-pieces-chart'), {
            type: 'bar',
            data: {
                labels: [],
                datasets: [{
                    label: 'Units',
                    data: [],
                    backgroundColor: '#000080',
                    borderRadius: 4,
                    minBarLength: 10
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                elements: { bar: { minBarLength: 10 } },
                plugins: { legend: { display: false } },
                scales: { x: { grid: { display: false } }, y: { beginAtZero: true, grid: { color: '#e5e7eb' } } },
                onClick: (e, elements) => {
                    if (!elements.length) return;
                    const index = elements[0].index;
                    const label = unitChart.data.labels[index];
                    if (unitLevel === "units") {
                        drillBackUnits(label);
                    } else if (unitLevel === "machines") {
                        drillBackMachine(unitPath[0], label);
                    } else if (unitLevel === "machine") {
                        drillBackMachine(unitPath[0], label);
                    }
                }
            }
        });
        attributeChart = new Chart(document.getElementById('attribute-drilldown-chart'), {
            type: 'bar',
            data: {
                labels: [],
                datasets: [{
                    label: 'Breakdown by Buyer',
                    data: [],
                    backgroundColor: '#000080',
                    borderRadius: 4,
                    barThickness: 30,
                    borderSkipped: false,
                    borderWidth: 1,
                    borderColor: '#000080'
                }]
            },
            options: {
                indexAxis: 'y',
                responsive: true,
                maintainAspectRatio: false,
                plugins: { legend: { display: false }, tooltip: { enabled: true } },
                scales: {
                    x: { beginAtZero: true, max: undefined, ticks: { callback: value => value.toLocaleString() }, grid: { color: '#e5e7eb' } },
                    y: { grid: { display: false } }
                },
                onClick: (e, elements) => {
                    if (!elements.length) return;
                    const index = elements[0].index;
                    const label = attributeChart.data.labels[index];
                    if (buyerLevel === "buyers") {
                        drillBackBuyers(label);
                    } else if (buyerLevel === "ocns") {
                        drillBackOCN(buyerPath[0], label);
                    } else if (buyerLevel === "ocn") {
                        drillBackOCN(buyerPath[0], label);
                    }
                }
            }
        });
        $("#unitBreadcrumbPieces").on("click", "#allUnits", () => {
            resetBothChartsToTop();
        });
        $("#unitBreadcrumbPieces").on("click", "#unitName", function() { drillBackUnits($(this).data("unit")); });
        $("#unitBreadcrumbPieces").on("click", "#machineName", function() { drillBackMachine($(this).data("unit"), $(this).data("machine")); });
        $("#buyerBreadcrumb").on("click", "#allBuyers", () => {
            resetBothChartsToTop();
        });
        $("#buyerBreadcrumb").on("click", "#buyerName", function() { drillBackBuyers($(this).data("buyer")); });
        $("#buyerBreadcrumb").on("click", "#ocnName", function() { drillBackOCN($(this).data("buyer"), $(this).data("ocn")); });

        // Read initial range from URL if present
        const urlParams = new URLSearchParams(window.location.search);
        const fromParam = urlParams.get('fromdate');
        const endParam = urlParams.get('enddate');
        let initialStart = (fromParam && moment(fromParam, 'YYYY-MM-DD', true).isValid()) ? moment(fromParam, 'YYYY-MM-DD') : moment().subtract(6, 'days');
        let initialEnd = (endParam && moment(endParam, 'YYYY-MM-DD', true).isValid()) ? moment(endParam, 'YYYY-MM-DD') : moment();

        $('#dateRangePicker').daterangepicker({
            opens: 'left',
            startDate: initialStart,
            endDate: initialEnd,
            maxDate: moment(), // Restrict dates beyond today
            ranges: {
                'Today': [moment(), moment()],
                'Last Week': [moment().subtract(6, 'days'), moment()], // Changed from This Week
                'This Month': [moment().startOf('month'), moment().endOf('month')]
            },
            locale: {
                format: 'DD-MM-YY'
            }
        }, function(start, end, label) {
            const startFormatted = start.format('YYYY-MM-DD');
            const endFormatted = end.format('YYYY-MM-DD');
            const displayStartFormatted = start.format('DD-MM-YY');
            const displayEndFormatted = end.format('DD-MM-YY');
            selectedRangeLabel = label;
            const isSameDay = start.isSame(end, 'day');
            const titleText = `
            Cutting Output for - 
            <span style="color: #000; font-weight: bold; background-color: #FFFF00; padding: 2px 6px; border-radius: 10px;">
                {{$portal_type}}
            </span>
            <span class="ml-4" style="color: #fff; font-weight: 500;">
                ${startFormatted} - ${endFormatted}
            </span>
            `;

            $('.dashboard_title').html(titleText); // ✅ Use .html() instead of .text()
            $('#dateRangePicker').val(`${displayStartFormatted} - ${displayEndFormatted}`);
            // Sync breadcrumb link with selected dates
            const gutLink = document.getElementById('gutDashLink');
            if (gutLink) gutLink.href = `/production_gut_dashboard/{{$portal_type}}?fromdate=${startFormatted}&enddate=${endFormatted}`;
            unitLevel = "units";
            unitPath = [];
            buyerLevel = "buyers";
            buyerPath = [];
            fetchData(null, startFormatted, endFormatted);
        });
        const initialStartFormatted = initialStart.format('YYYY-MM-DD');
        const initialEndFormatted = initialEnd.format('YYYY-MM-DD');
        const initialDisplayStartFormatted = initialStart.format('DD-MM-YY');
        const initialDisplayEndFormatted = initialEnd.format('DD-MM-YY');
        const isSameDay = initialStart.isSame(initialEnd, 'day');
                $('.dashboard_title').html(`
                Cutting Output for - 
                <span style="color: #000; font-weight: bold; background-color: #FFFF00; padding: 2px 6px; border-radius: 10px;">
                {{$portal_type}}
                </span>
                <span class="ml-4" style="color: #fff; font-weight: 500;">
                ${initialDisplayStartFormatted} - ${initialDisplayEndFormatted}
                </span>
        `);
        $('#dateRangePicker').val(`${initialDisplayStartFormatted} - ${initialDisplayEndFormatted}`);
        // Initialize breadcrumb link with initial dates
        const gutLink = document.getElementById('gutDashLink');
        if (gutLink) gutLink.href = `/production_gut_dashboard/{{$portal_type}}?fromdate=${initialStartFormatted}&enddate=${initialEndFormatted}`;
        fetchData(null, initialStartFormatted, initialEndFormatted);
    });
</script>
</body>
</html>