<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Issued Quantity Details</title>
  <!-- Tailwind CDN -->
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- Font -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap" rel="stylesheet">
  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
  <!-- Chart.js -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <!-- DataTables (for table pagination/search) -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" />
  <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
  <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
  <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            'background': 'rgb(245, 246, 247)',
            'foreground': 'rgb(31, 41, 55)',
            'card': 'rgb(255, 255, 255)',
            'card-foreground': 'rgb(31, 41, 55)',
            'primary': 'rgb(15, 61, 126)',
            'primary-foreground': 'rgb(248, 250, 252)',
            'primary-100': 'rgb(219, 234, 254)',
            'primary-50': 'rgb(239, 246, 255)',
            'primary-25': 'rgb(248, 250, 252)',
            'secondary': 'rgb(241, 245, 249)',
            'muted': 'rgb(241, 245, 249)',
            'muted-foreground': 'rgb(100, 116, 139)',
            'border': 'rgb(226, 232, 240)',
            'input': 'rgb(226, 232, 240)',
            'ring': 'rgb(15, 61, 126)',
          },
          fontFamily: {
            'body': ['Inter', 'system-ui', 'sans-serif'],
          }
        }
      }
    }
  </script>
  <style>
    body { font-family: 'Inter', system-ui, -apple-system, 'Segoe UI', Roboto, 'Helvetica Neue', Arial; }
    .app-width { max-width: 100%; }
    /* subtle card border like the screenshot */
    .card-border { border: 1px solid rgba(226,232,240,1); }
    .kpi-title { font-weight: 600; color: #0f172a; }
    .muted { color: #64748b; }
    /* table row subtle divider */
    .tbl-row { border-bottom: 1px solid rgba(226,232,240,1); }
    /* small circle avatar */
    .avatar { width:36px; height:36px; border-radius:9999px; background:#0f172a; color:#fff; display:flex; align-items:center; justify-content:center; font-weight:600; }
    .chart-area { background: #f1f5f9; border-radius:8px; height:300px; }
    /* pagination */
    .pagination .page { border:1px solid rgba(226,232,240,1); padding:.35rem .6rem; border-radius:.375rem; }
    .btn-download { width:40px; height:40px; border-radius:8px; border:1px solid rgba(226,232,240,1); display:flex; align-items:center; justify-content:center; }
    .date-picker input {
      background: rgba(248, 250, 252, 0.1);
      color: white;
    }
    .date-picker input::placeholder {
      color: rgba(248, 250, 252, 0.7);
    }
    .spinner {
      display: inline-block;
      width: 1.5rem;
      height: 1.5rem;
      border: 3px solid rgba(255, 255, 255, 0.3);
      border-top-color: #fff;
      border-radius: 50%;
      animation: spin 1s ease-in-out infinite;
    }
    @keyframes spin {
      to { transform: rotate(360deg); }
    }
    /* Compact DataTables controls to match other pages */
    .dataTables_wrapper .dataTables_length label { font-size: 12px; color:#6b7280; }
    .dataTables_wrapper .dataTables_length select { font-size: 12px; padding: 2px 6px; height: 26px; line-height: 22px; border:1px solid #e5e7eb; border-radius:6px; width:auto; min-width:56px; }
    .dataTables_wrapper .dataTables_filter input { font-size: 12px; padding: 2px 6px; height: 26px; line-height: 22px; border:1px solid #e5e7eb; border-radius:6px; width:120px; background-color: #D3D3D3; }
    .dataTables_wrapper .dataTables_info { font-size: 12px; color:#6b7280; }
    .dataTables_wrapper .dataTables_paginate { font-size: 12px; }
    .dataTables_wrapper .dataTables_paginate .paginate_button { padding: 2px 6px; margin: 0 1px; font-size: 12px; }
  </style>
</head>
<body class="bg-slate-50 pb-2">

        @php
        $empl_no= Session::get('empl_id');
        $empl_name = Session::get('emp_name');
        @endphp
  
    <header class="bg-blue-900 text-white  px-4 py-2">
      <div class="flex items-center justify-between">
        <div class="flex items-center space-x-2">
            <a href="/dashboard" class="inline-flex items-center justify-center rounded-lg border border-white/30 p-2 hover:bg-blue-800 transition">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 text-white">
                <path d="M15 21v-8a1 1 0 0 0-1-1h-4a1 1 0 0 0-1 1v8"></path>
                <path d="M3 10a2 2 0 0 1 .709-1.528l7-6a2 2 0 0 1 2.582 0l7 6A2 2 0 0 1 21 10v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                </svg>
            </a>
           <h1 class="text-2xl font-semibold">Issued Quantity Details for {{$portal_type}} -  </h1>
           <h6 class="text-sm " id="item-info"></h6>
        </div>
        <div class="flex items-center gap-3">
          <div id="loadSpinner" class="spinner hidden"></div>
          <input type="text" placeholder="Select date range" id="dateRangePicker" class="hidden h-8 px-2 rounded-md bg-white/10 text-white border border-white/30 text-sm cursor-pointer hover:bg-white/20 transition-colors">
        </div>
      </div>
    </header>

  <div class=" app-width px-2">
    <!-- breadcrumb  -->
    <div class="px-6 py-3 text-sm text-gray-600">
        <a href="/production_gut_dashboard/{{$portal_type}}" class="text-blue-700 hover:underline">GUT Production Dashboard</a> 
        <span> &gt; </span>
        <a href="/gut_smstock/{{$portal_type}}" class="text-blue-700 hover:underline">Supermarket Stock Analysis</a>
        <span> &gt; </span>
        <span class="text-gray-800 font-medium">Issued Quantity Details</span>
    </div>
    
    <!-- Top cards -->
    <div class="grid grid-cols-12 gap-6 mb-6">
      <div class="col-span-7 bg-white rounded-md p-5 card-border shadow-sm" style="min-height:380px;">
        <div class="flex items-start justify-between mb-3">
          <div class="flex items-center gap-3">
            
            <div class="flex flex-row items-center gap-2">
              <div class="kpi-title font-bold bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Issued Quantity by Line</div>
              <div class="text-xs muted">Total quantity issued to each production line. Click a bar to filter.</div>
            </div>
          </div>
          <div class="text-sm muted">&nbsp;</div>
        </div>
        <div class="mt-3">
          <canvas id="barChart" height="280"></canvas>
        </div>
      </div>

      <div class="col-span-5 bg-white rounded-md p-5 card-border shadow-sm" style="min-height:380px;">
        <div class="flex items-start justify-between mb-3">
          <div class="flex flex-row items-center gap-2">
            <div class="kpi-title font-bold bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Trend for All Lines</div>
            <div class="text-xs muted">Daily quantity issued to the selected line(s).</div>
          </div>
          <div class="text-sm muted">&nbsp;</div>
        </div>
        <div class="chart-area mt-2 p-3"><canvas id="trendChart" height="280"></canvas></div>
      </div>
    </div>

    <!-- Table card -->
    <div class="bg-white rounded-md p-5 card-border shadow-sm">
      <div class="flex items-center justify-between mb-4">
        <div class="flex flex-row gap-2">
          <h2 class="text-lg font-semibold bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Issue Events</h2>
          <div class="text-xs muted mt-2">Detailed log of stock issue events for this item.</div>
        </div>
        <div class="flex items-center gap-3">
          <div class="btn-download" title="Export">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 muted" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a2 2 0 002 2h12a2 2 0 002-2v-1M12 12v8m0-8l-3 3m3-3l3 3M12 4v8"/></svg>
          </div>
        </div>
      </div>

      <div id="eventsTableContainer">
        <table class="w-full text-sm" id="eventsTable">
          <thead class="text-left text-xs text-slate-500 border-b border-slate-200">
            <tr>
              <th class="py-3">Entry No.</th>
              <th class="py-3">Line</th>
              <th class="py-3">Quantity Issued</th>
              <th class="py-3">Issued To</th>
              <th class="py-3">Date</th>
            </tr>
          </thead>
          <tbody id="eventsTbody" class="text-sm">
            <!-- rows injected by script -->
          </tbody>
          <tfoot>
            <tr>
              <th>Total: </th>
              <th></th>
              <th></th>
              <th></th>
              <th></th>
            </tr>
          </tfoot>
        </table>
      </div>

      <!-- DataTables will render pagination, ordering, and info -->
    </div>

  </div>

<script>
    // Read query params and set the dynamic header info
function getParam(name) {
  const u = new URL(window.location.href);
  return u.searchParams.get(name) || '';
}
const qOrder = getParam('order_no');
const qItemId = getParam('itemid');
const qColorId = getParam('colorid');
const qSizeId = getParam('sizeid');
const qBuyer = getParam('buyer');
const qItemName = getParam('item');
const qColorName = getParam('color');
const pretty = [qBuyer, qOrder ? qOrder.slice(-4) : null, qItemName || qItemId, qColorName || qColorId]
  .filter(Boolean)
  .join(' - ');
if (pretty) {
  document.getElementById('item-info').textContent = pretty;
}

// Global API data
let apiData = [];

// Fetch data from API
function fetchData(ocnno = qOrder, itemid = qItemId, colorid = qColorId, sizeid = qSizeId, portaltype = '{{$portal_type}}') {
  $("#loadSpinner").show();
  $.ajax({
    url: '/gutsmstockissued',
    method: 'GET',
    data: { ocnno, itemid, colorid, sizeid, portaltype, empid: "{{ Session('empl_id') }}"  },
    success: function (response) {
      $("#loadSpinner").hide();
      if (response && response.success && response.data && Array.isArray(response.data)) {
  apiData = response.data;
  renderTable();
  updateBarChart();
  updateTrendChart();
  } else {
  apiData = [];
  renderTable();
  updateBarChart();
  updateTrendChart();
  }
  },
  error: function () {
  $("#loadSpinner").hide();
  apiData = [];
  renderTable();
  updateBarChart();
  updateTrendChart();
  }
  });
  }

  // Table/filters
  let selectedLine = null; // Track selected line for filtering trend chart
  let eventsDT = null;     // DataTables instance

  function renderTable() {
  // Build normalized rows for DataTables with robust fallbacks
  let rows = apiData.flatMap(d => (d.Entries || []).map(e => {
    const entry = (e && (e.Entry_No ?? e.EntryNo ?? e.Entry_no ?? e.entry ?? e['Entry No'] ?? e.Entry)) ?? '';
    const line = String((e && (e.Line ?? e.line)) ?? (d && (d.Line ?? d.line)) ?? '');
    const qtyRaw = (e && (e.Iss_Qty ?? e.iss_qty ?? e.IssQty ?? e.qty ?? e.Qty ?? e.Quantity)) ?? 0;
    const qty = Number.isFinite(parseInt(qtyRaw)) ? parseInt(qtyRaw) : 0;
    const issuedTo = (e && (e.Unit ?? e.unit ?? e.To ?? e.to)) ?? '';
    const dateRaw = (e && (e.Edate ?? e.Edate ?? e.Date ?? e.date)) ?? null;
    const date = dateRaw ? moment(dateRaw).format('MMM D, YYYY') : '';
    return { entry, line, qty, to: issuedTo, date };
  }));
  if (selectedLine) rows = rows.filter(r => r.line === String(selectedLine));

  if (eventsDT) {
  eventsDT.clear();
  eventsDT.rows.add(rows);
  eventsDT.draw();
  return;
  }

  $.fn.dataTable.ext.errMode = 'console';
  eventsDT = $('#eventsTable').DataTable({
  data: rows,
  columns: [
  { data: 'entry', title: 'Entry No.', defaultContent: '' },
  { data: 'line', title: 'Line', defaultContent: '' },
  { data: 'qty', title: 'Quantity Issued', defaultContent: 0 },
  { data: 'to', title: 'Issued To', defaultContent: '' },
  { data: 'date', title: 'Date', defaultContent: '' }
  ],
  language: { lengthMenu: 'Show _MENU_ rows', search: '' },
  pageLength: 10,
  lengthMenu: [10, 25, 50, 100],
  searching: true,
  ordering: true,
  info: true,
  paging: true,
  footerCallback: function (row, data, start, end, display) {
  let api = this.api();
  // Calculate total for the 'qty' column (index 2)
  let total = api
  .column(2, { page: 'current' })
  .data()
  .reduce((sum, val) => sum + (parseInt(val) || 0), 0);
  // Update footer
  $(api.column(2).footer()).html(`${total}`);
  }
  });
  }

  // Bar chart
  const ctx = document.getElementById('barChart').getContext('2d');
  const barChart = new Chart(ctx, {
  type: 'bar',
  data: { labels: [], datasets: [{ data: [], backgroundColor: 'rgba(15, 46, 91, 0.15)', borderRadius: 8, barThickness: 34 }] },
  options: {
  indexAxis: 'x',
  plugins: { legend: { display: false } },
  scales: { y: { beginAtZero: true, grid: { color: 'rgba(226,232,240,1)' }, ticks: { color: '#94a3b8' } }, x: { grid: { display: false }, ticks: { color: '#94a3b8' } } },
  responsive: true,
  maintainAspectRatio: false,
  onClick: (e, elements) => {
  if (elements.length > 0) {
  const index = elements[0].index;
  const label = String(barChart.data.labels[index]);
  selectedLine = (String(selectedLine) === label) ? null : label;
  } else {
  selectedLine = null;
  }
  updateBarChart();
  updateTrendChart();
  renderTable();
  }
  }
  });

  function updateBarChart() {
  // Populate by Line from API: use provided Total_Iss_Qty, fallback to sum of Entries if needed
  const labels = (apiData || []).map(d => String(d.Line || 'Unknown'));
  const dataVals = (apiData || []).map(d => {
  const declared = parseInt(d.Total_Iss_Qty);
  if (!isNaN(declared) && declared > 0) return declared;
  const entries = Array.isArray(d.Entries) ? d.Entries : [];
  return entries.reduce((s, e) => s + (parseInt(e.Iss_Qty ?? e.iss_qty) || 0), 0);
  });
  barChart.data.labels = labels;
  barChart.data.datasets[0].data = dataVals;
  const pale = 'rgba(36, 134, 180, 0.81)';
  const navy =  '#08325b';
  barChart.data.datasets[0].backgroundColor = labels.map(l => {
  if (!selectedLine) return pale;
  return String(l) === String(selectedLine) ? navy : pale;
  });
  barChart.update();
  }

  // Trend chart
  const tctx = document.getElementById('trendChart').getContext('2d');
  const grad = tctx.createLinearGradient(0, 0, 0, 160);
  grad.addColorStop(0, 'rgba(14,78,162,0.16)');
  grad.addColorStop(1, 'rgba(14,78,162,0.02)');
  const trendChart = new Chart(tctx, {
  type: 'line',
  data: { labels: [], datasets: [{ data: [], borderColor: '#0e4ea2', backgroundColor: grad, fill: true, tension: 0.35, borderWidth: 2, pointRadius: 0 }] },
  options: {
  plugins: { legend: { display: false } },
  scales: { x: { grid: { display: false }, ticks: { color: '#94a3b8' } }, y: { grid: { color: 'rgba(226,232,240,1)' }, ticks: { color: '#94a3b8' } } },
  responsive: true,
  maintainAspectRatio: false
  }
  });

  function updateTrendChart() {
  let entries = (apiData || []).flatMap(d => Array.isArray(d.Entries) ? d.Entries : []);
  if (selectedLine) {
  entries = entries.filter(e => String(e.Line) === String(selectedLine));
  }
  const dateMap = entries.reduce((acc, e) => {
  const date = moment(e.Edate).format('MMM D');
  const qty = parseInt(e.Iss_Qty ?? e.iss_qty) || 0;
  acc[date] = (acc[date] || 0) + qty;
  return acc;
  }, {});
  const sortedDates = Object.keys(dateMap).sort((a, b) => moment(a, 'MMM D').toDate() - moment(b, 'MMM D').toDate());
  const dataVals = sortedDates.map(date => dateMap[date]);
  trendChart.data.labels = sortedDates;
  trendChart.data.datasets[0].data = dataVals;
  trendChart.update();
  }

  $(document).ready(function () {
  // Initialize date range picker
  $('#dateRangePicker').daterangepicker({
  opens: 'left',
  startDate: moment().subtract(6, 'days'),
  endDate: moment(),
  maxDate: moment(), // Restrict dates beyond today
  ranges: {
  'Today': [moment(), moment()],
  'Last Week': [moment().subtract(6, 'days'), moment()], // Changed from This Week
  'This Month': [moment().startOf('month'), moment().endOf('month')]
  }
  }, function (start, end) {
  const startFormatted = start.format('DD-MM-YY');
  const endFormatted = end.format('DD-MM-YY');
  const isSameDay = start.isSame(end, 'day');
  const titleText = `
  Production overview for -
  <span style="color: #000; font-weight: bold; background-color: #FFFF00; padding: 2px 6px; border-radius: 10px;">
    {{$portal_type}}
  </span>
  <span class="ml-4" style="color: #fff; font-weight: 500;">
    ${startFormatted} - ${endFormatted}
  </span>
  `;
  $('.dashboard_title').html(titleText);
  $('#dateRangePicker').val(isSameDay ? startFormatted : `${startFormatted} - ${endFormatted}`);
  fetchData();
  // Diagnostics: log a quick glimpse at mapped rows and per-line totals
  setTimeout(() => {
    try {
      const rowsDiag = (apiData || []).flatMap(d => (d.Entries || []).map(e => ({
        entry: e.Entry_No ?? e.Entry_no ?? e.entry,
        line: e.Line,
        qty: parseInt(e.Iss_Qty ?? e.iss_qty) || 0
      })));
      const totalsDiag = (apiData || []).map(d => ({
        line: d.Line,
        total: (Array.isArray(d.Entries) ? d.Entries : []).reduce((s, e) => s + (parseInt(e.Iss_Qty ?? e.iss_qty) || 0), 0)
      }));
      console.debug('issued diagnostics sample rows:', rowsDiag.slice(0, 5));
      console.debug('issued totals by line (computed):', totalsDiag);
    } catch (err) { /* no-op */ }
  }, 0);
  });

  // Initial title setup
  const initialStart = moment().subtract(6, 'days');
  const initialEnd = moment();
  const initialStartFormatted = initialStart.format('DD-MM-YY');
  const initialEndFormatted = initialEnd.format('DD-MM-YY');
  const isSameDay = initialStart.isSame(initialEnd, 'day');
  $('.dashboard_title').html(`
  Production overview for -
  <span style="color: #000; font-weight: bold; background-color: #FFFF00; padding: 2px 6px; border-radius: 10px;">
    {{$portal_type}}
  </span>
  <span class="ml-4" style="color: #fff; font-weight: 500;">
    ${initialStartFormatted} - ${initialEndFormatted}
  </span>
  `);
  $('#dateRangePicker').val(`${initialStartFormatted} - ${initialEndFormatted}`);
  fetchData();
  });
</script>
</body>
</html>
