<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Grievance Entry</title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="gplogofinal.png" type="png">

    <!--vendor css ================================================== -->
    <link rel="stylesheet" type="text/css" href="css/vendor.css">

    <!-- Link Swiper's CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css" />

    <!--Bootstrap ================================================== -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">

    <!-- Style Sheet ================================================== -->
    <link rel="stylesheet" type="text/css" href="styles.css">


    <!-- start spinner script -->
    <script>
        window.addEventListener("beforeunload", function(e) {
            document.getElementById('dot-1').className = "dot";
            document.getElementById('dot-2').className = "dot";
            document.getElementById('dot-3').className = "dot";
            document.getElementById('dot-4').className = "dot";
            document.getElementById('dot-5').className = "dot";
        }, false);
    </script>
    <!-- end spinner script -->
    <style>
        /* .save-btn{
            background: radial-gradient(100% 100% at 100% 0, #5adaff 0, #4a8da7 100%);
            color: #fff;
        } */

        /*start page spinner */
        .loader-1 {
            position: absolute;
            z-index: 1000;
            top: 50%;
            left: 40%;
            margin-left: 10%;
            transform: translate3d(-50%, -50%, 0);
        }

        .dot {
            width: 24px;
            height: 24px;
            background: #3ac;
            border-radius: 100%;
            display: inline-block;
            animation: slide 1s infinite;
        }

        .dot:nth-child(1) {
            animation-delay: 0.1s;
            background: #32aacc;
        }

        .dot:nth-child(2) {
            animation-delay: 0.2s;
            background: #64aacc;
        }

        .dot:nth-child(3) {
            animation-delay: 0.3s;
            background: #96aacc;
        }

        .dot:nth-child(4) {
            animation-delay: 0.4s;
            background: #c8aacc;
        }

        .dot:nth-child(5) {
            animation-delay: 0.5s;
            background: #faaacc;
        }

        @-moz-keyframes slide {
            0% {
                transform: scale(1);
            }

            50% {
                opacity: 0.3;
                transform: scale(2);
            }

            100% {
                transform: scale(1);
            }
        }

        @-webkit-keyframes slide {
            0% {
                transform: scale(1);
            }

            50% {
                opacity: 0.3;
                transform: scale(2);
            }

            100% {
                transform: scale(1);
            }
        }

        @-o-keyframes slide {
            0% {
                transform: scale(1);
            }

            50% {
                opacity: 0.3;
                transform: scale(2);
            }

            100% {
                transform: scale(1);
            }
        }

        @keyframes slide {
            0% {
                transform: scale(1);
            }

            50% {
                opacity: 0.3;
                transform: scale(2);
            }

            100% {
                transform: scale(1);
            }
        }

        /* end spinner */

        form.hero-form {
            background: rgba(255, 255, 255, 0.90);
        }

        .image {
            background-image: linear-gradient(rgba(0, 0, 0, 0.3), rgba(0, 0, 0, 0.3)), url('background-render-image.jpg');
            background-position: center;
            background-size: cover;
        }

        .home {
            margin-bottom: 10px;
        }

        .icon {
            margin-left: 50px;
        }
    </style>
</head>


<body>

    <!-- spinner start -->
    <div class="loader-1">
        <div class="" id="dot"></div>
        <div class="" id="dot-1"></div>
        <div class="" id="dot-2"></div>
        <div class="" id="dot-3"></div>
        <div class="" id="dot-4"></div>
        <div class="" id="dot-5"></div>

    </div>

    <!-- spinner end -->

    <section id="hero" class="position-relative overflow-hidden image">
        <!-- <div class="pattern-overlay pattern-right position-absolute">
            <img src="images/pattern-hero.png" alt="pattern">
        </div> -->
        <div class="mt-3 mt-2 icon">

            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-arrow-left-circle-fill text-white" viewBox="0 0 16 16">
                <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0zm3.5 7.5a.5.5 0 0 1 0 1H5.707l2.147 2.146a.5.5 0 0 1-.708.708l-3-3a.5.5 0 0 1 0-.708l3-3a.5.5 0 1 1 .708.708L5.707 7.5H11.5z" />
            </svg>
            <a href="login" class="text-white btn btn-outline-secondary btn-lg"> BACK<!-- Add the URL of your home page in the href attribute -->

            </a>
        </div>
        <div class="container py-3">
            <div class="row align-items-center">
                <div class="col-md-6 mb-5 mb-md-0">
                    <h2 class="text-white fw-bold display-2">GRIEVANCE SYSTEM</h2>
                    <p class="text-white ">Employee Grievance is a formal complaint raised by an employee against a fellow
                        employee or manager, or even against the employer. Employees usually file grievances
                        for workplace harassment, discrimination, nepotism, concerns regarding team management or regarding terms of the employment.</p>
                    <ul class="list-unstyled">
                        <li class="text-white fw-bold">
                            <svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 23 23" fill="none">
                                <g clip-path="url(#clip0_1_359)">
                                    <path d="M11.5 0.359375C5.34719 0.359375 0.359375 5.34719 0.359375 11.5C0.359375 17.6528 5.34719 22.6406 11.5 22.6406C17.6528 22.6406 22.6406 17.6528 22.6406 11.5C22.6406 5.34719 17.6528 0.359375 11.5 0.359375ZM11.5 2.51562C16.4653 2.51562 20.4844 6.53393 20.4844 11.5C20.4844 16.4653 16.4661 20.4844 11.5 20.4844C6.5347 20.4844 2.51562 16.4661 2.51562 11.5C2.51562 6.5347 6.53393 2.51562 11.5 2.51562ZM17.7982 8.36746L16.7859 7.34693C16.5762 7.13557 16.2349 7.13418 16.0235 7.34387L9.67375 13.6426L6.98778 10.9349C6.77813 10.7235 6.43681 10.7221 6.22545 10.9318L5.20487 11.9441C4.99352 12.1538 4.99212 12.4951 5.20182 12.7065L9.27987 16.8176C9.48952 17.0289 9.83084 17.0303 10.0422 16.8206L17.7952 9.12983C18.0065 8.92014 18.0079 8.57882 17.7982 8.36746Z" fill="white" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_1_359">
                                        <rect width="23" height="23" fill="white" />
                                    </clipPath>
                                </defs>
                            </svg>
                            Workplace Harassment
                        </li>
                        <li class="text-white fw-bold">
                            <svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 23 23" fill="none">
                                <g clip-path="url(#clip0_1_359)">
                                    <path d="M11.5 0.359375C5.34719 0.359375 0.359375 5.34719 0.359375 11.5C0.359375 17.6528 5.34719 22.6406 11.5 22.6406C17.6528 22.6406 22.6406 17.6528 22.6406 11.5C22.6406 5.34719 17.6528 0.359375 11.5 0.359375ZM11.5 2.51562C16.4653 2.51562 20.4844 6.53393 20.4844 11.5C20.4844 16.4653 16.4661 20.4844 11.5 20.4844C6.5347 20.4844 2.51562 16.4661 2.51562 11.5C2.51562 6.5347 6.53393 2.51562 11.5 2.51562ZM17.7982 8.36746L16.7859 7.34693C16.5762 7.13557 16.2349 7.13418 16.0235 7.34387L9.67375 13.6426L6.98778 10.9349C6.77813 10.7235 6.43681 10.7221 6.22545 10.9318L5.20487 11.9441C4.99352 12.1538 4.99212 12.4951 5.20182 12.7065L9.27987 16.8176C9.48952 17.0289 9.83084 17.0303 10.0422 16.8206L17.7952 9.12983C18.0065 8.92014 18.0079 8.57882 17.7982 8.36746Z" fill="white" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_1_359">
                                        <rect width="23" height="23" fill="white" />
                                    </clipPath>
                                </defs>
                            </svg>
                            Compensation
                        </li>
                        <li class="text-white fw-bold">
                            <svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 23 23" fill="none">
                                <g clip-path="url(#clip0_1_359)">
                                    <path d="M11.5 0.359375C5.34719 0.359375 0.359375 5.34719 0.359375 11.5C0.359375 17.6528 5.34719 22.6406 11.5 22.6406C17.6528 22.6406 22.6406 17.6528 22.6406 11.5C22.6406 5.34719 17.6528 0.359375 11.5 0.359375ZM11.5 2.51562C16.4653 2.51562 20.4844 6.53393 20.4844 11.5C20.4844 16.4653 16.4661 20.4844 11.5 20.4844C6.5347 20.4844 2.51562 16.4661 2.51562 11.5C2.51562 6.5347 6.53393 2.51562 11.5 2.51562ZM17.7982 8.36746L16.7859 7.34693C16.5762 7.13557 16.2349 7.13418 16.0235 7.34387L9.67375 13.6426L6.98778 10.9349C6.77813 10.7235 6.43681 10.7221 6.22545 10.9318L5.20487 11.9441C4.99352 12.1538 4.99212 12.4951 5.20182 12.7065L9.27987 16.8176C9.48952 17.0289 9.83084 17.0303 10.0422 16.8206L17.7952 9.12983C18.0065 8.92014 18.0079 8.57882 17.7982 8.36746Z" fill="white" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_1_359">
                                        <rect width="23" height="23" fill="white" />
                                    </clipPath>
                                </defs>
                            </svg>
                            Workload and employee burnout
                        </li>
                    </ul>
                </div>
                <div class=" col-md-5 offset-md-1">
                    <form class="hero-form p-5" id="validate" method="POST" action="{{ route('griev_save') }}">
                        @csrf
                        <div class="col-md-12">
                            @if ($message = Session::get('success'))
                            <div class="alert alert-success">
                                <p>{{ $message }}</p>
                            </div>
                            @endif
                            @if(session('alert'))
                            <style>
                                .custom-light-red-alert {
                                    background-color: #ffcccc;
                                    /* Light Red Color */
                                    border-color: #ff9999;
                                    /* Border Color */
                                    color: #0b0b10;
                                    /* Text Color */
                                }
                            </style>

                            <svg xmlns="http://www.w3.org/2000/svg" class="d-none">
                                <symbol id="exclamation-triangle-fill" viewBox="0 0 16 16">
                                    <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                </symbol>
                            </svg>

                            <div class="alert custom-light-red-alert d-flex align-items-center" role="alert">
                                <svg class="bi flex-shrink-0 me-2" role="img" aria-label="Danger:" style="width: 40px; height: 40px;">
                                    <use xlink:href="#exclamation-triangle-fill" />
                                </svg>
                                <div class="mr-3"></div>
                                {{ session('alert') }}
                            </div>
                            @endif

                        </div>

                        <h3>Grievance Entry </h3>

                        <div class="mb-4">
                            <label for="exampleInputEmail1" class="form-label mb-0"> Name (Optional)</label>
                            <input type="text" class="form-control border-0" name="NAME" value="" id="NAME">
                            <input type="hidden" class="form-control border-0 empno" name="empno" value="" id="empno">
                        </div>
                        <div class="mb-3">
                            <label for="exampleInputEmail2" class="form-label mb-0">Phone No (Optional)</label>
                            <input type="text" class="form-control border-0" name="PhNo" id="PhNo">
                        </div>
                        <div class="mb-3">
                            <label for="exampleInputEmail3" class="form-label mb-0">Grievance</label>
                            <select class="form-control" name="Grievance" id="Grievance" required>
                                <option value="">--Select Detail--</option>
                                @foreach($Name as $name)
                                <option value="{{ $name }}">{{ $name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="exampleInputEmail4" class="form-label mb-0 ">Grievance Type</label>
                            <select class="form-control details1" name="ch" id="GrievanceType" value="id" required>
                                <option value="">--Select Detail--</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="exampleInputEmail5" class="form-label mb-0">Comment</label>
                            <textarea class="form-control" rows="4" name="comment" id="comment" style="resize: vertical;" required></textarea>
                        </div>

                        <div class=" d-flex justify-content-around pb-2">
                            <input type="submit" name="submit" value="SAVE" id="saveButton" class="btn btn-primary">
                            <button type="button" id="clearButton" class="btn btn-success" onclick="clearPage()">CLEAR</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </section>


    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        function clearPage() {
            // Reload the current page
            window.location.reload();
        }
    </script>



    <script>
        var selectButtons = document.querySelectorAll('#Grievance');

        selectButtons.forEach(function(button) {
            button.addEventListener('click', function(e) {
                e.preventDefault();

                var selectedRowId = button.value;

                // Send the selected data to the controller via AJAX
                $.ajax({
                    url: "{{ route('griev_det2') }}",
                    type: 'get',
                    dataType: 'json',
                    data: {
                        'row_id': selectedRowId
                    },
                    success: function(data) {
                        console.log(data); // Access result from the second request

                        console.log(data.result1); // Access result from the first request
                        console.log(data.result2); // Access result from the second request



                        var select = $('#GrievanceType'); // Get the select element
                        select.empty(); // Clear existing options

                        // Add an initial option
                        select.append($('<option>', {
                            value: '',
                            text: '--Select Detail--'
                        }));

                        for (var i = 0; i < data.result1.length; i++) {
                            var id = data.result1[i].id; // Assuming 'id' is the name of the property in your data
                            var name = data.result1[i].Name;

                            // Create and append an option element
                            var option = $('<option>', {
                                value: id, // Set the 'id' as the value
                                text: name
                            });
                            select.append(option);
                        }

                        var sample = data.result2;
                        console.log(sample); // Access result from the second request

                        var option_id = sample[0].id;
                        $('.empno').val(option_id);


                    }
                });
            });
        });
    </script>


</body>

</html>