<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>KPI MASTER ENTRY</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <!-- TABLE DESIGN -->
    <style>
        .card-body .table-responsive .table tbody tr td {
            padding: 0 25px !important;
            height: 3px;
            vertical-align: middle !important;
        }

        .card-header {
            height: 60px;
        }

        .card-header .col-md-3 select {
            margin-top: 10px;
        }

        .table-responsive {
            position: relative;
            overflow: auto;
        }

        .table thead th {
            position: sticky;
            top: 0;
            z-index: 1;
        }
    </style>
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->


</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->

    @section('tittle') {{"KPI MASTER ENTRY"}}@endsection

    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="card">
                                <form action="{{ route('kpimaster') }}" class="has-validated" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="card-body">
                                        <div class="row justify-content-center">
                                            <div class="col-lg-11">
                                                <!-- KPI NAME -->
                                                <div class="mb-4">
                                                    <label class="form-label">KPI NAME<span class="text-danger">*</span></label>
                                                    <input type="text" name="KPI_Point_Name" class="form-control" required />
                                                </div>
                                                <!-- DIVISION -->
                                                <div class="mb-4">
                                                    <label class="form-label">DIVISION<span class="text-danger">*</span></label>
                                                    <select class="form-control select2" data-choices name="Actual_Division_Code" required>
                                                        <option value="">--Select Division--</option>
                                                        @foreach ($division as $div)
                                                        <option value="{{$div['Actual_Division_Code']}}">{{$div['Actual_Division_Name']}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <!-- DEPARTMENT -->
                                                <div class="mb-4">
                                                    <label class="form-label">DEPARTMENT<span class="text-danger">*</span></label>
                                                    <select class="form-control select2" data-choices name="Dep_Code" required>
                                                        <option value="">--Select Department--</option>
                                                        @foreach ($Department as $Dep)
                                                        <option value="{{$Dep['code']}}">{{$Dep['name']}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <!-- UOM -->
                                                <div class="mb-4">
                                                    <label class="form-label">UOM<span class="text-danger">*</span></label>
                                                    <select class="form-control select2" data-choices name="uom" required>
                                                        <option value="">--Select UOM--</option>
                                                        @foreach ($UOM as $u)
                                                        <option value="{{$u['RowID']}}">{{$u['KPI_Point_Name']}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="d-flex justify-content-around">
                                                <button type="submit" id="saveButton" class="btn btn-primary" name="submit">SAVE</button>
                                                <button type="button" id="clearButton" class="btn btn-warning" onclick="window.location.reload()">CLEAR</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

    <!-- SEARCH -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($message = Session::get('alert'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>