<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>SELF APPRAISAL ENTRY</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/2.11.6/umd/popper.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.6.0/js/bootstrap.min.js"></script>

    <!-- TABLE DESIGN -->
    <style>
        .card-body .table-responsive .table tbody tr td {
            padding: 0 25px !important;
            height: 3px;
            vertical-align: middle !important;
        }

        .card-header {
            height: 60px;
        }

        .card-header .col-md-3 select {
            margin-top: 10px;
        }

        .table-responsive {
            position: relative;
            overflow: auto;
        }

        .table thead th {
            position: sticky;
            top: 0;
            z-index: 1;
        }
    </style>

    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }
    </style>
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->

</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->
    @section('tittle') {{"SELF APPRAISAL ENTRY"}}@endsection

    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="live-preview">
                                        <form method="POST" action="{{ route('form/save') }}" enctype="multipart/form-data" class="has-validated" id="validate">
                                            @csrf
                                            <div class="row">
                                                <!-- TKNO -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">TNo</label>
                                                        <?php $user_tkno = session('user_data') ?>
                                                        <input type="text" name="TNO" value="{{$user_tkno}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- NAME -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">NAME</label>
                                                        <?php $user_name = session('emp_name') ?>
                                                        <input type="text" name="NAME" value="{{$user_name}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- DEPARTMENT -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">DEPARTMENT</label>
                                                        <?php $user_dep = session('dep_data') ?>
                                                        <input type="text" name="DEPARTMENT" value="{{$user_dep}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- POSITION -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">POSITION</label>
                                                        <?php $user_posit = session('des_data') ?>
                                                        <input type="text" name="DESIGNAION" value="{{$user_posit}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- EMPLNO NUMBER FOR MAIL -->
                                            <?php $user_emplo = session('empl_id') ?>
                                            <input type="hidden" name="Emplid1" value="{{$user_emplo}}" class="form-control dull" readonly>

                                            <div class="row align-items-end">
                                                <div class="col-md-3 mb-4">
                                                    <label for="job-category-Input" class="form-label">MONTH<span class="text-danger">*</span></label>
                                                    <select class="form-control select2" name="options123" id="newkpi" onchange="newchange(this.value)" required>
                                                        <option value="">--Select month--</option>
                                                        @foreach ($newdate as $newone)
                                                        <option value="{{$newone['Month_Year']}}">{{$newone['Month_Year']}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <!-- Spinner -->
                                                <div id="spinner" class="col-md-1 mb-4" style="display: none;">
                                                    <div class="spinner-border text-primary" role="status">
                                                        <span class="visually-hidden">Loading...</span>
                                                    </div>
                                                </div>

                                                <!-- Information Text -->
                                                <div class="col-md-3 mb-4 d-flex justify-content-end">
                                                    <h6 class="me-5" style="color: grey; background-color: #eded5c; /* Light yellow-green background */
                                                        padding: 8px 12px; 
                                                        border: 2px solid yellow;
                                                        border-radius: 5px;
                                                        font-weight: bold;
                                                        /*display: none;*/
                                                    ">
                                                        Yellow - Not Editable
                                                    </h6>
                                                </div>

                                            </div>



                                            <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ TABLE @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->
                                            <div class="row">
                                                <div class="card-body">
                                                    <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                                        <table class="table table-centered align-middle table-nowrap mb-0" id="Newtable" style="line-height: 30px !important;">
                                                            <thead class="text-muted table-light">
                                                                <tr>
                                                                    <th data-sort="sno"> SNO <span class="sort-icon"></th>
                                                                    <th data-sort="kpi"> KPI(Key Performance Indicator) <span class="sort-icon"></th>
                                                                    <th data-sort="UOM"> UOM <span class="sort-icon"></th>
                                                                    <th data-sort="Target"> Target <span class="sort-icon"></th>
                                                                    <th data-sort="Self Appraisal Rating"> Self Appraisal Rating <span class="sort-icon"></th>
                                                                    <th data-sort="Remarks"> Remarks <span class="sort-icon"></th>
                                                                </tr>
                                                            </thead>
                                                            <tbody></tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>

                                            <br>
                                            <br>

                                            <!--  SUBMIT BUTTON -->
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        @php
                                                        $approval = Session::get("approval");
                                                        $effect_from = Session::get("effect_from");
                                                        @endphp
                                                        <?php
                                                        $appr = ($approval == "T") ? "APPROVED" : "NOT APPROVED";
                                                        // $formatted_date = date('F Y', strtotime($effect_from));
                                                        $formatted_date = \Carbon\Carbon::parse($effect_from)->format('F Y');
                                                        ?>
                                                        <div class="mb-3">
                                                            <label for="firstNameinput" class="form-label">Previous KPI Status</label>
                                                            <?php $user_dep = session('dep_data') ?>
                                                            <input type="text" id="pre" class="form-control dull" name="pre" value="" autofocus readonly>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-3 d-flex justify-content-center align-items-center">
                                                    <button type="submit" value="SAVE" name="submit" id="saved" class="btn btn-primary" style="display: none;">SAVE</button>
                                                </div>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>


    <!-- SAVE BUTTON SHOW AND HIDE -->
    <script>
        const table = document.getElementById('Newtable');
        const saveButton = document.getElementById('saved');

        table.addEventListener('input', function(event) {
            saveButton.style.display = 'block';
        });

        saveButton.addEventListener('click', function() {
            saveButton.style.display = 'none';
        });
    </script>

    <!-- SHOWING DETAISLS IN TABLE USING AJAX -->
    <!-- <script>
        function newchange(getemplname) {

            $('#spinner').show();

            var emplno_select_User212 = $("#newkpi option:selected").val();

            // Step 1: Create a new Date object using the original date string
            const originalDate = new Date(emplno_select_User212);

            // Step 2: Use the Date methods to extract the year, month, and day
            const year = originalDate.getFullYear();
            const month = originalDate.getMonth() + 1; // add 1 because months are zero-indexed
            const day = originalDate.getDate();

            // Step 3: Create a new date string in the desired format
            const newDatenew = `${year}-${month.toString().padStart(2, '0')}-${day.toString().padStart(2, '0')}`;

            document.getElementById("Newtable").disabled = false;
            var table1 = document.getElementById("Newtable");
            var rowCount1 = table1.rows.length - 1;

            for (var i = 0; i < rowCount1; i++) {
                table1.deleteRow(1);
            }

            $.ajax({
                url: "{{ route('selecttonewgrid') }}",
                type: "GET",

                data: {
                    kpientrydata: emplno_select_User212,
                },
                dataType: 'json',
                success: function(data2) {
                    console.log(data2);
                    var count = data2.length;
                    var items = 0;
                    for ($i = 0; $i < count; $i++) {
                        items++;
                        var html = "<tr>";
                        html += "<td>" + items + "</td>";
                        html += "<td><input name='userdesnew[]' value='" + data2[$i]['Kpi_point'] + "' style= width:350px readonly></td>";
                        html += "<td><input value='" + data2[$i]['UOM'] + "' style= width:100px readonly></td>";
                        html += "<td><input name='usertargetnew[]' value='" + data2[$i]['Target'] + "' style= width:100px readonly></td>";
                        html += "<td><input name='uservalnew[]' value='" + data2[$i]['Actual'] + "' style= width:190px required><input type='hidden' name='userRowidnew[]' value='" + data2[$i]['Rowid'] + "' required></td>";
                        html += "<td><input name='uservalnewremarks[]' value='" + data2[$i]['Kpi_Remarks'] + "' style= width:190px></td>";
                        html += "<tr>";
                        document.getElementById("Newtable").insertRow().innerHTML = html;
                    }
                    $('#spinner').hide();
                }

            });
        }
    </script> -->

    <script>
        function newchange(getemplname) {
            $('#spinner').show();

            var emplno_select_User212 = $("#newkpi").val(); // Simplified selector


            let previousApproval = @json($appr);
            let formattedDate = @json($formatted_date);

            $('#pre').val(previousApproval + ' - ' + formattedDate); // Reset value


            // Formatting the selected date
            const originalDate = new Date(emplno_select_User212);
            const year = originalDate.getFullYear();
            const month = (originalDate.getMonth() + 1).toString().padStart(2, '0');
            const day = originalDate.getDate().toString().padStart(2, '0');
            const newDatenew = `${year}-${month}-${day}`;

            // Enable the table
            document.getElementById("Newtable").disabled = false;

            // Clear previous table rows except the header
            var table1 = document.getElementById("Newtable");
            for (let i = table1.rows.length - 1; i > 0; i--) {
                table1.deleteRow(i);
            }

            // Variable to store details data
            let detailsData = [];

            // First AJAX request to get data2
            $.ajax({
                url: "{{ route('selecttonewgrid') }}",
                type: "GET", // Ensure this matches your route method
                data: {
                    kpientrydata: emplno_select_User212
                },
                dataType: 'json',
                success: function(data2) {
                    console.log("data2:", data2);
                    // Extract KPI_IDs into an array
                    const array_KPIid = data2.map(item => item.KPI_ID);
                    console.log(array_KPIid);

                    $.ajax({
                        url: "{{ route('DefaultActval') }}",
                        type: "GET",
                        data: {
                            Month: emplno_select_User212,
                            array_KPIid: array_KPIid,
                        },
                        dataType: 'json',
                        success: function(cmb_Data) {
                            console.log("details:", cmb_Data);

                            const detailsData = cmb_Data.details.flat(); // Flatten nested details array
                            const avgValData = cmb_Data.Avgval ?? []; // Default to empty array if Avgval is null

                            if (Array.isArray(avgValData) && avgValData.length === 0) {
                                avgValData.push({
                                    KPI_ID: "6497",
                                    Average: 0
                                });
                            }

                            console.log("Flattened detailsData:", detailsData);
                            console.log("Avgval data:", avgValData);

                            let items = 0;
                            data2.forEach((item) => {
                                items++;

                                // Check in details data
                                let matchingDetail = detailsData.find(detail => detail.Kpi_ID === item.KPI_ID || detail.Kpi_ID === item.KPI_ID?.toString());

                                // Check in Avgval data
                                let matchingAvgval = avgValData.find(avg => avg.KPI_ID === item.KPI_ID || avg.Kpi_ID === item.KPI_ID?.toString());

                                // Default to item actual value
                                let actualValue = item.Actual;

                                let readonlyAttribute = "";
                                let backgroundColor = "";

                                const detailVal = matchingDetail?.Actual;
                                const avgVal = matchingAvgval?.Average;

                                if (detailVal !== undefined && detailVal !== null && detailVal !== '') {
                                    actualValue = detailVal;
                                    readonlyAttribute = "readonly";
                                    backgroundColor = "background-color:#eded5c;";
                                }

                                if ((avgVal !== undefined && avgVal !== null && avgVal !== '') &&
                                    !(detailVal !== undefined && detailVal !== null && detailVal !== '')) {
                                    // Only apply avgVal if detailVal wasn't applied
                                    actualValue = avgVal;
                                    readonlyAttribute = "readonly";
                                    backgroundColor = "background-color:#eded5c;";
                                }

                                // Optional: Log both values for debug
                                console.log(`KPI ${item.KPI_ID}: Detail=${detailVal}, Avg=${avgVal}, Final=${actualValue}`);

                                const rowHtml = `
                                    <tr style="${backgroundColor}">
                                        <td>${items}</td>
                                        <td><input name='userdesnew[]' value='${item.Kpi_point}' style='width:350px;' readonly></td>
                                        <td><input value='${item.UOM}' style='width:100px;' readonly></td>
                                        <td><input name='usertargetnew[]' value='${item.Target}' style='width:100px;' readonly></td>
                                        <td>
                                            <input name='uservalnew[]' value='${actualValue}' style='width:190px; ${backgroundColor}' ${readonlyAttribute} required>
                                            <input type='hidden' name='userRowidnew[]' value='${item.Rowid}' required>
                                        </td>
                                        <td><input name='uservalnewremarks[]' value='${item.Kpi_Remarks}' style='width:190px;'></td>
                                    </tr>`;
                                table1.insertRow().innerHTML = rowHtml;
                            });

                            $('#spinner').hide();
                        },
                        error: function(xhr, status, error) {
                            console.error("Error in DefaultActval request:", error);
                            $('#spinner').hide();
                        }
                    });

                    ////------------ OLD QUERY BEFORE ADDING 5S KPI POINTS --------------- ///
                    // // Second AJAX request to get details
                    // $.ajax({
                    //     url: "{{ route('DefaultActval') }}",
                    //     type: "GET", // Ensure this matches your route method
                    //     data: {
                    //         Month: emplno_select_User212,
                    //         array_KPIid: array_KPIid,
                    //     },
                    //     dataType: 'json',
                    //     success: function(details) {
                    //         console.log("details:", details);

                    //         // Flatten the details array to make it easier to search
                    //         detailsData = details.flat(); // Flattens nested arrays into a single array
                    //         console.log("Flattened detailsData:", detailsData);

                    //         let items = 0;
                    //         data2.forEach((item) => {
                    //             items++;

                    //             // Find the matching detail for the current KPI_ID
                    //             let matchingDetail = detailsData.find(detail => detail.Kpi_ID === item.KPI_ID || detail.Kpi_ID === item.KPI_ID?.toString());
                    //             console.log(`Matching Detail for KPI_ID ${item.KPI_ID}:`, matchingDetail);

                    //             // Extract the actual value, either from matchingDetail or the item
                    //             let actualValue = matchingDetail ? matchingDetail.Actual : item.Actual;

                    //             // Determine the readonly attribute based on whether actualValue is defined and not empty
                    //             const readonlyAttribute = (matchingDetail && actualValue !== null && actualValue !== '') ? "readonly" : "";

                    //             // Set the background color to yellow for matched rows
                    //             const backgroundColor = matchingDetail ? "background-color:#eded5c;" : "";

                    //             // Construct the row with the matched or default Actual value
                    //             const rowHtml = `
                    //                 <tr style="${backgroundColor}">
                    //                     <td>${items}</td>
                    //                     <td><input name='userdesnew[]' value='${item.Kpi_point}' style='width:350px;' readonly></td>
                    //                     <td><input value='${item.UOM}' style='width:100px;' readonly></td>
                    //                     <td><input name='usertargetnew[]' value='${item.Target}' style='width:100px;' readonly></td>
                    //                     <td>
                    //                         <input name='uservalnew[]' value='${actualValue}' style='width:190px; ${backgroundColor}' ${readonlyAttribute} required>
                    //                         <input type='hidden' name='userRowidnew[]' value='${item.Rowid}' required>
                    //                     </td>
                    //                     <td><input name='uservalnewremarks[]' value='${item.Kpi_Remarks}' style='width:190px;'></td>
                    //                 </tr>`;
                    //             table1.insertRow().innerHTML = rowHtml;
                    //         });
                    //         $('#spinner').hide();
                    //     },



                    //     error: function(xhr, status, error) {
                    //         console.error("Error in DefaultActval request:", error);
                    //         $('#spinner').hide();
                    //     }
                    // });
                },
                error: function(xhr, status, error) {
                    console.error("Error in selectgetdatetonewgrid request:", error);
                    $('#spinner').hide();
                }
            });

        }
    </script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($message = Session::get('alert'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>