<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>KPI Portal self_app</title>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <!-- App favicon -->
  <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
  <!-- gridjs css -->
  <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
  <!-- Layout config Js -->
  <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
  <!-- Bootstrap Css -->
  <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
  <!-- Icons Css -->
  <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
  <!-- App Css-->
  <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
  <!-- custom Css-->
  <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />


  <style>
    /* tiny extras to match screenshot */
    .sidebar-item {
      height: 40px
    }

    .pill {
      padding: 6px 10px;
      border-radius: 9999px
    }

    .score-pill {
      background: #0b67ff;
      color: #fff;
      padding: 8px 12px;
      border-radius: 12px;
      font-weight: 600
    }

    .small-pill {
      background: #eef2ff;
      color: #3b3b3b;
      padding: 6px 8px;
      border-radius: 8px
    }

    .input-box {
      border: 1px solid #e6e9ef;
      padding: 8px;
      border-radius: 8px
    }

    .info-dot {
      width: 10px;
      height: 10px;
      border-radius: 50%;
      background: #ff4d4f;
      display: inline-block;
      margin-left: 6px
    }

    /* table stripe subtle */
    tbody tr {
      background: #fff
    }

    thead th {
      background: #223046
    }
  </style>
  <style>
    /* KPI popover styling */
    .popover.kpi-popover {
      max-width: 280px;
    }

    .kpi-scale .list-group-item {
      display: flex;
      align-items: center;
      gap: .5rem;
      padding: .5rem .75rem;
    }

    .kpi-scale .dot {
      width: 10px;
      height: 10px;
      border-radius: 50%;
      display: inline-block;
    }

    .kpi-scale .meta {
      font-size: 11px;
      color: #6c757d;
      display: block;
    }

    /* Actual formula popover styling */
    .popover.actual-popover .popover-body {
      background: #fdecea;
      color: #842029;
    }

    /* Fix chart canvas heights */
    #overallChart,
    #kpiChart {
      height: 220px !important;
    }

    /* Pointers for interactive icons */
    .kpi-info,
    .actual-info,
    .score-info,
    .exclaim-circle {
      cursor: pointer;
    }

    /* Lightweight tooltip (CSS-only) for older versions */
    .has-tooltip {
      position: relative;
    }

    .has-tooltip::after {
      content: attr(data-tooltip);
      position: absolute;
      z-index: 10;
      left: 50%;
      top: -32px;
      transform: translateX(-50%);
      background: #fdecea;
      color: #842029;
      border: 1px solid #f5c2c7;
      padding: 4px 8px;
      border-radius: 6px;
      font-size: 12px;
      white-space: nowrap;
      box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);
      opacity: 0;
      pointer-events: none;
      transition: opacity .15s ease;
    }

    .has-tooltip::before {
      content: "";
      position: absolute;
      left: 50%;
      top: -8px;
      transform: translateX(-50%);
      width: 8px;
      height: 8px;
      background: #fdecea;
      border-left: 1px solid #f5c2c7;
      border-top: 1px solid #f5c2c7;
      transform: translateX(-50%) rotate(45deg);
      opacity: 0;
      transition: opacity .15s ease;
    }

    .has-tooltip:hover::after,
    .has-tooltip:hover::before {
      opacity: 1;
    }

    /* Error tooltip variant and force-show support */
    .has-tooltip.error-tip::after {
      background: #fee2e2;
      color: #b91c1c;
      border-color: #fecaca;
    }

    .has-tooltip.error-tip::before {
      background: #fee2e2;
      border-left-color: #fecaca;
      border-top-color: #fecaca;
    }

    .has-tooltip.show-tip::after,
    .has-tooltip.show-tip::before {
      opacity: 1;
    }

    /* KPI floating panel (replaces Bootstrap popover) */
    .kpi-float {
      position: absolute;
      z-index: 1060;
      background: #fff;
      border: 1px solid #e6e9ef;
      border-radius: 10px;
      padding: 10px;
      box-shadow: 0 8px 24px rgba(0, 0, 0, 0.12);
      width: 280px;
      display: none;
    }

    .kpi-float .title {
      font-weight: 600;
      margin-bottom: 6px;
    }
  </style>
  <style>
    .ps-card {
      border-radius: 12px;
      overflow: hidden;
      background: #fff;
      border: 1px solid #e9edf3
    }

    .ps-header {
      background: #223046;
      color: #fff;
      padding: 10px 14px;
      font-weight: 600;
      display: flex;
      align-items: center;
      gap: 8px
    }

    .ps-body {
      padding: 8px
    }

    .ps-panel {
      background: #eef3ff;
      border: 1px solid #e6e9ef;
      border-radius: 10px;
      padding: 2px
    }

    .ps-progress {
      height: 8px;
      background: #e9eff6;
      border-radius: 999px;
      overflow: hidden
    }

    .ps-progress>span {
      display: block;
      height: 100%;
      background: linear-gradient(90deg, #ffb36b, #ff8a00)
    }

    .ps-badge {
      background: #ff8a00;
      color: #fff;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 8px;
      font-size: 12px
    }

    .ps-scale {
      display: flex;
      gap: 12px;
      flex-wrap: wrap
    }

    .ps-pill {
      padding: 10px 12px;
      border-radius: 8px;
      font-size: 12px;
      font-weight: 600;
      display: flex;
      align-items: center;
      gap: 8px;
      border: 1px solid transparent
    }

    .ps-pill .dot {
      width: 10px;
      height: 10px;
      border-radius: 50%
    }

    /* Legend cards aligned with ring band colors */
    .ps-pill.green {
      background: rgba(34, 197, 94, 0.10);
      border-color: #22c55e;
      color: #22c55e
    }

    .ps-pill.green .dot {
      background: #22c55e
    }

    .ps-pill.yellow {
      background: rgba(173, 248, 2, 0.12);
      border-color: #b36ba4;
      color: #b36ba4
    }

    .ps-pill.yellow .dot {
      background: #b36ba4
    }

    .ps-pill.purple {
      background: rgba(179, 107, 164, 0.10);
      border-color: #b36ba4;
      color: #b36ba4
    }

    .ps-pill.purple .dot {
      background: #b36ba4
    }

    .ps-pill.orange {
      background: rgba(251, 146, 60, 0.10);
      border-color: #fb923c;
      color: #fb923c
    }

    .ps-pill.orange .dot {
      background: #fb923c
    }

    .ps-pill.red {
      background: rgba(239, 68, 68, 0.10);
      border-color: #ef4444;
      color: #ef4444
    }

    .ps-pill.red .dot {
      background: #ef4444
    }

    .ps-pill.gray {
      background: rgba(148, 163, 184, 0.12);
      border-color: #94a3b8;
      color: #475569
    }

    .ps-pill.gray .dot {
      background: #94a3b8
    }

    /* Highlight for active rating band in KPI Summary */
    .ps-pill.active-band {
      transform: scale(1.12);
      box-shadow: 0 6px 14px rgba(15, 23, 42, 0.18);
      border-width: 2px;
    }

    /* Overall rating summary card (square) */
    .overall-card {
      border-radius: 12px;
      border: 1.5px solid #e5e7eb;
      background: #ffffff;
      padding: 6px 8px;
      font-size: 12px;
      min-width: 270px;
      min-height: 10px;
      display: flex;
      flex-direction: column;
      align-items: flex-start;
      justify-content: center;
      gap: 3px;
      box-shadow: 0 8px 20px rgba(15, 23, 42, 0.10);
    }

    .overall-card-label {
      color: #111827;
      font-weight: 700;
      font-size: 11px
    }

    .overall-pill {
      padding: 4px 10px;
      border-radius: 999px;
      font-weight: 700;
      font-size: 11px;
      border: 1px solid transparent;
    }

    .overall-card.excellent {
      background: rgba(34, 197, 94, 0.10);
      border-color: #22c55e
    }

    .overall-card.excellent .overall-pill {
      background: #22c55e;
      border-color: #15803d;
      color: #ffffff
    }

    .overall-card.good {
      background: rgba(179, 107, 164, 0.10);
      border-color: #b36ba4
    }

    .overall-card.good .overall-pill {
      background: #b36ba4;
      border-color: #7e255f;
      color: #ffffff
    }

    .overall-card.average {
      background: rgba(251, 146, 60, 0.10);
      border-color: #fb923c
    }

    .overall-card.average .overall-pill {
      background: #fb923c;
      border-color: #c05621;
      color: #ffffff
    }

    /* Below Average -> gray */
    .overall-card.below {
      background: rgba(148, 163, 184, 0.10);
      border-color: #94a3b8
    }

    .overall-card.below .overall-pill {
      background: #94a3b8;
      border-color: #475569;
      color: #ffffff
    }

    /* Poor -> red */
    .overall-card.poor {
      background: rgba(239, 68, 68, 0.08);
      border-color: #ef4444
    }

    .overall-card.poor .overall-pill {
      background: #ef4444;
      border-color: #b91c1c;
      color: #ffffff
    }

    .kpi-table {
      border-collapse: separate;
      border-spacing: 0 2px;
      width: 100%;
      font-size: 12px !important
    }

    .kpi-table thead th {
      background: #223046;
      color: #fff;
      border: none;
      padding: 12px 16px
    }

    .kpi-table thead th:first-child {
      border-top-left-radius: 8px
    }

    .kpi-table thead th:last-child {
      border-top-right-radius: 8px
    }

    .kpi-table tbody tr {
      background: #fff
    }

    .kpi-table tbody td {
      padding: 14px 16px;
      vertical-align: middle;
      border-top: 1px solid #eef1f5;
      border-bottom: 1px solid #eef1f5
    }

    .kpi-table tbody td:first-child {
      border-left: 1px solid #eef1f5;
      border-top-left-radius: 8px;
      border-bottom-left-radius: 8px
    }

    .kpi-table tbody td:last-child {
      border-right: 1px solid #eef1f5;
      border-top-right-radius: 8px;
      border-bottom-right-radius: 8px
    }

    .pill-badge {
      background: #eef2ff;
      color: #3b5bdb;
      border: 1px solid #dfe6ff;
      padding: 4px 8px;
      border-radius: 8px;
      font-weight: 600;
      font-size: 12px;
      display: inline-block;
      min-width: 36px;
      text-align: center
    }

    .pill-light {
      background: #f7f8fb;
      color: #64748b;
      border: 1px solid #e6e9ef;
      padding: 4px 8px;
      border-radius: 8px;
      font-weight: 600;
      font-size: 12px;
      display: inline-block;
      min-width: 36px;
      text-align: center
    }

    .score-badge {
      background: #0b67ff;
      color: #fff;
      padding: 6px 10px;
      border-radius: 12px;
      font-weight: 700;
      font-size: 12px;
      display: inline-block;
      min-width: 54px;
      text-align: center
    }

    .input-actual {
      background: #f7f8fb;
      border: 1px solid #e6e9ef;
      border-radius: 8px;
      padding: 6px 10px;
      width: 80px
    }

    .warn {
      color: #ef4444;
      font-size: 14px;
      margin-left: 6px
    }

    .remarks-input {
      background: #f7f8fb;
      border: 1px solid #e6e9ef;
      border-radius: 8px;
      padding: 6px 10px;
      width: 100%
    }

    /* Invalid field highlighting */
    .input-actual.is-invalid,
    .remarks-input.is-invalid {
      border-color: #ef4444 !important;
      box-shadow: 0 0 0 1px rgba(239, 68, 68, 0.4);
      background: #fef2f2;
    }

    .exclaim-circle {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      width: 18px;
      height: 18px;
      border-radius: 50%;
      border: 1px solid #94a3b8;
      color: #64748b;
      font-size: 12px;
      margin-left: 6px;
      background: #fff
    }
  </style>
  <style>
    /* Reduce overall table row height */
    .kpi-table tbody td,
    .kpi-table thead th {
      padding: 4px 5px !important;
      /* reduced from px-4 py-5 */
    }

    /* Reduce pill sizes */
    .pill-badge,
    .pill-light {
      padding: 2px 6px !important;
      font-size: 11px !important;
      border-radius: 6px !important;
    }

    /* Reduce input box size */
    .input-actual {
      padding: 4px 6px !important;
      width: 60px !important;
      font-size: 12px !important;
    }

    /* Reduce remarks box height */
    .remarks-input {
      padding: 4px 6px !important;
      font-size: 12px !important;
    }

    /* Score badge smaller */
    .score-badge {
      padding: 4px 8px !important;
      font-size: 11px !important;
      min-width: 50px !important;
    }

    /* Reduce warning icon spacing */
    .warn {
      font-size: 12px !important;
      margin-left: 4px !important;
    }

    /* Reduce exclaim icon */
    .exclaim-circle {
      width: 14px !important;
      height: 14px !important;
      font-size: 10px !important;
      margin-left: 4px !important;
    }

    /* Reduce row gap */
    .kpi-table tbody tr {
      margin-bottom: 0 !important;
    }

    /* chart section */

    /* Reduce top whitespace before first container-fluid */
    .main-content {
      padding-top: 0 !important;
      margin-top: 0 !important;
    }

    .page-content {
      padding-top: 0 !important;
      margin-top: 0 !important;
    }

    /* Pull local container-fluid up on this page but keep slight padding for top row */
    .main-content .page-content>.container-fluid {
      padding-top: 0.5rem !important;
      margin-top: 0 !important;
    }

    #clear-cache-btn {
      display: none;
    }

    #reviewDiv {
      display: none;
    }

    #search-options {
      display: none;
    }

    .search-widget-icon {
      display: none;
    }

    /* AUTO vs MANUAL actual styling */
    .input-actual-auto {
      background-color: #a9fca9 !important;
      /* light green */
    }

    .input-actual-manual {
      background-color: #fcee6d !important;
      /* light yellow */
    }

    .navbar-header {
      height: 45px !important
    }

    .kpi-table tbody td,
    .kpi-table thead th {
      padding: 2px 3px !important;
    }

    .page-content {
      padding: 0;
    }

    #body {
      top: 22px !important;
    }

    .topbar-user {
      height: 45px !important;

    }
  </style>
</head>

<body id="body">
  @php
  $approval = isset($approval) ? $approval : Session::get('approval');
  $effect_from = isset($effect_from) ? $effect_from : Session::get('effect_from');
  $appr = ($approval === 'T') ? 'Approved' : 'Not Approved';
  $badgeClass = ($approval === 'T') ? 'bg-success' : 'bg-danger';
  $formatted_date = '';
  if (!empty($effect_from) && $effect_from !== '0000-00-00') {
  try { $formatted_date = \Carbon\Carbon::parse($effect_from)->format('F Y'); } catch (\Exception $e) { $formatted_date = ''; }
  }
  // fallback if available in session (e.g., "Month_Year")
  if (empty($formatted_date)) {
  $monthYear = Session::get('Month_Year');
  if (!empty($monthYear)) { $formatted_date = $monthYear; }
  }
  // final fallback: show month before previous (two months ago)
  if (empty($formatted_date)) {
  $formatted_date = \Carbon\Carbon::now()->subMonths(2)->format('F Y');
  }
  @endphp
  @section('tittle') Hi '{{ Session('emp_name') }}- {{"SELF APPRAISAL APPROVAL "}} @endsection
  <!-- <span class="badge ms-2 {{ $badgeClass }}">{{ $appr }}</span> -->

  <div id="wrapper">
    @extends('LifeAtGainup.Navbar.nav')
    @section('content')
    <div class="main-content">
      <div class="page-content">
        <div class="container-fluid">
          <!-- Top row -->
          <div class="row align-items-start pt-5">
            <div class="col-md-8">



              <!-- Hidden form for Self Appraisal Save -->
              <form id="selfAppSaveForm" method="POST" action="{{ route('selfApprai_AppSave') }}" class="d-none">
                @csrf
              </form>
            </div>


          </div>

          <!-- Performance Summary card -->
          <section class="ps-card mb-1">

            <div class="ps-body">
              <div class="row g-3">
                <div class="col-md-12">
                  <div class="card-header bg-primary">
                    <h5 class="mb-0 text-white">KPI Summary</h5>
                  </div>
                  <div class="ps-panel d-flex align-items-center justify-content-between">
                    <div class="mt-1 position-relative" style="max-width: 150px;">
                      <canvas id="totalScoreRing"></canvas>
                      <div id="totalScoreCenter" class="position-absolute top-50 start-50 translate-middle text-center" style="color: #111827;">
                        <div id="totalScorePercent" class="fw-semibold" style="font-size:18px;">0%</div>
                        <div id="totalScoreStatus" style="font-size:12px; color:#6b7280;">Poor</div>
                      </div>
                    </div>
                    <div class="flex-grow-1 ms-4">
                      <div class="ms-0 d-flex align-items-start justify-content-start">
                        <div id="overallStatusWrapper" class="overall-card poor">
                          <span class="overall-card-label" style="font-size:18px" id="overallrate">Overall Rating</span>
                          <span id="overallStatusCard" class="overall-pill" style="font-size:16px">Poor</span>
                        </div>
                      </div>
                      <div class="ps-scale flex-wrap align-items-center mt-2">
                        <div class="ps-pill green d-block"><span class="dot"></span> 80-100: Excellent
                          <div> Eligible for Monthly Incentive</div>

                        </div>
                        <div class="ps-pill purple d-block"><span class="dot"></span> 61-79: Good
                          <div> Eligible for quarterly incentive</div>
                        </div>
                        <div class="ps-pill orange d-block"><span class="dot"></span> 41-60: Average
                          <div> Eligible for Annual Incentive</div>
                        </div>
                        <div class="ps-pill gray " style="padding:18px;"><span class="dot d-none"></span> 21-40: Below Average
                          <!-- <div>  Not eligible for any Incentive</div> -->
                        </div>
                        <div class="ps-pill red " style="padding:18px;"><span class="dot d-none"></span> 0-20: Poor
                        </div>

                      </div>

                    </div>
                  </div>
                </div>
                <div class="col-md-4 d-none">
                  <div class="ps-panel d-flex align-items-start justify-content-between">
                    <div>
                      <div class="text-muted small mb-1">Overall Rating</div>
                      <span id="overallRatingBadge" class="ps-badge">Average</span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </section>

          @php
          // Build a simple month list for dropdown: previous month as default candidate
          $prevMonthCarbon = \Carbon\Carbon::now()->subMonth();
          $prevMonthKey = strtolower($prevMonthCarbon->format('M')) . '-' . $prevMonthCarbon->format('Y'); // e.g., oct-2025
          $prevMonthLabel = $prevMonthCarbon->format('M- Y');
          @endphp

          <!-- Tabs -->

          @csrf
          <div class="d-flex gap-2 align-items-center mb-1">
            <button id="tabTable" class="btn btn-primary text-white shadow-sm d-inline-flex align-items-center gap-1">
              <i class="ri-table-2"></i>
              Table View
            </button>

            <button id="tabCharts" class="btn btn-light shadow-sm d-inline-flex align-items-center gap-1">
              <i class="ri-bar-chart-2-line"></i>
              Performance Charts
            </button>

            <div class="ms-auto d-flex align-items-center gap-3">
              <!-- Person selection (employee list) -->
              <div class="d-flex align-items-center gap-2">
                <div id="personLoading" class="spinner-border spinner-border-sm text-primary d-none" role="status" aria-hidden="true"></div>
                <label for="vehno" class="form-label mb-0 fw-semibold">Person</label>
                <select id="vehno" name="options123" class="form-select form-select-sm" style="max-width: 200px;" onchange="changename(this.value)">
                  <option value="">Select Person</option>
                  @if(!empty($options) && is_array($options))
                  @foreach($options as $option)
                  @php
                  $val = $option['Emplno'] ?? $option['Tno'] ?? $option['EmpNo'] ?? null;
                  $name = $option['Name'] ?? $option['EmpName'] ?? $option['Employee'] ?? null;
                  @endphp
                  @if($val && $name)
                  <option value="{{ $val }}">{{ $name }}</option>
                  @endif
                  @endforeach
                  @endif
                </select>
              </div>

              <!-- Month selection -->
              <div class="d-flex align-items-center gap-2">
                <div id="monthLoading" class="spinner-border spinner-border-sm text-primary d-none" role="status" aria-hidden="true"></div>
                <label for="monthSelect" class="form-label mb-0 fw-semibold">MONTH </label>
                <select id="monthSelect" name="options1345" class="form-select form-select-sm" style="max-width: 200px;">
                  <option value="">--Select month--</option>
                  <option value="{{ $prevMonthKey }}">{{ $prevMonthLabel }}</option>
                </select>
              </div>
            </div>
          </div>

          <!-- TABLE VIEW WRAPPER -->
          <div id="tableSection">

            <section class="bg-white rounded shadow-sm border py-1 px-2">
              <div class="table-responsive">
                <table class="kpi-table table align-middle mb-2">
                  <thead>
                    <tr>
                      <th class="px-4 py-3">SNO</th>
                      <th class="px-4 py-3">KPI (Key Performance Indicator)</th>
                      <th class="px-4 py-3">Weightage</th>
                      <th class="px-4 py-3">Target</th>
                      <th class="px-4 py-3">Self Appraisal Rating</th>
                      <th class="px-4 py-3">User Remark</th>
                      <th class="px-4 py-3">Supervisor Rating</th>
                      <th class="px-4 py-3">Score</th>
                      <th class="px-4 py-3">HOD Remarks</th>
                      <th class="px-4 py-3">UOM</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      <td colspan="10" class="text-center text-muted py-4">Select month to view KPI data.</td>
                    </tr>
                  </tbody>
                </table>
              </div>

              <div class="d-flex justify-content-end align-items-center gap-2 mt-0 w-100">
                <button id="selfAppSaveBtn" type="button" class="btn btn-primary d-inline-flex align-items-center gap-1 p-2">
                  <i class="ri-check-line"></i> Approve
                </button>
              </div>
            </section>
          </div>

          <!-- CHART VIEW WRAPPER (HIDDEN INITIALLY) -->
          <div id="chartSection" class="d-none">

            <!-- Performance Charts Section -->
            <section class="bg-white rounded shadow border mt-4 mb-4">
              <div class="px-4 py-3 border-bottom d-flex align-items-center justify-content-between bg-dark text-white rounded-top">
                <h3 class="h6 fw-semibold mb-0 text-white">Performance Charts</h3>
                <select id="overallRange" class="form-select form-select-sm bg-white text-dark" style="max-width:240px;">
                  <option value="month_to_date">Monthly</option>
                  <option value="month_to_quarter" selected>Quarterly</option>
                  <option value="month_to_half_yearly">Half Yearly</option>
                  <option value="month_to_annual">Annual</option>
                </select>
              </div>

              <!-- Chart Container -->
              <div class="p-4">
                <div class="bg-white border rounded p-3">
                  <h4 id="overallRangeTitle" class="small text-muted mb-2">Month to Quarter</h4>
                  <canvas id="overallChart" class="w-100" style="height: 160px;"></canvas>
                  <div class="small text-primary text-end mt-2">Performance Score</div>
                </div>
              </div>
            </section>

            <!-- KPI-wise Trend Analysis -->
            <section class="bg-white rounded shadow border mb-4">
              <div class="px-4 py-3 border-bottom d-flex align-items-center justify-content-between bg-dark text-white rounded-top">
                <h3 class="h6 fw-semibold mb-0 text-white">KPI-wise Trend Analysis</h3>
                <div class="d-flex gap-2">
                  <select id="kpiSelect" class="form-select form-select-sm bg-white text-dark" style="max-width:200px;">
                    <option value="Attrition" selected>Attrition</option>
                    <option value="Absenteeism">Absenteeism</option>
                    <option value="Recruitment Strength">Recruitment Strength</option>
                    <option value="Audit Score">Audit Score</option>
                    <option value="5S Audit Mark">5S Audit Mark</option>
                  </select>
                  <select id="kpiRange" class="form-select form-select-sm bg-white text-dark" style="max-width:160px;">
                    <option value="monthly">Monthly</option>
                    <option value="quarterly" selected>Quarterly</option>
                    <option value="half_yearly">Half Yearly</option>
                    <option value="annum">Annum</option>
                  </select>
                </div>
              </div>

              <div class="p-4">
                <div class="bg-white border rounded p-3">
                  <h4 id="kpiRangeTitle" class="small text-muted mb-2">Attrition - Quarterly</h4>
                  <canvas id="kpiChart" class="w-100" style="height: 160px;"></canvas>
                </div>
              </div>
            </section>

            <!-- KPI API Summary Section (populated from kpiinfokeyperformace in JS) -->
            <div id="kpiSummaryCard" class="card shadow-sm border-0 mb-4"></div>

          </div>

          <!-- Hidden template for KPI rating popover -->
          <div id="kpi-scale-template" class="d-none">
            <div class="kpi-scale">
              <div class="fw-semibold mb-2"><span class="kpi-title">KPI</span> - Rating Scale:</div>
              <div class="list-group">
                <div class="list-group-item d-flex justify-content-between">
                  <div><span class="dot bg-success"></span> <span class="ms-2 range">0-5</span></div>
                  <div class="text-success">Excellent</div>
                </div>
                <div class="list-group-item d-flex justify-content-between">
                  <div><span class="dot bg-warning"></span> <span class="ms-2 range">6-7</span></div>
                  <div class="text-warning">Good</div>
                </div>
                <div class="list-group-item d-flex justify-content-between">
                  <div><span class="dot" style="background:#fb923c"></span> <span class="ms-2 range">7-9</span></div>
                  <div style="color:#fb923c">Average</div>
                </div>
                <div class="list-group-item d-flex justify-content-between">
                  <div><span class="dot bg-danger"></span> <span class="ms-2 range">>10</span></div>
                  <div class="text-danger">Poor</div>
                </div>
              </div>
            </div>
            <div class="text-center mt-1" style="font-size:11px">Ratings: <span class="ratings-count">—</span></div>
            <div class="text-center mt-1">&#9670;</div>
            <!-- small diamond pointer mimic under popover -->
          </div>

          <!-- JAVASCRIPT -->
          <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
          <script>
            $(function() {
              function updateOverallRate() {
                var val = $('#vehno').val();
                var txt = $('#vehno option:selected').text().trim();
                if (val) {
                  $('#overallrate').text(txt + "'s Overall rating");
                } else {
                  $('#overallrate').text('Overall Rating');
                }
              }

              updateOverallRate();
              $('#vehno').on('change', updateOverallRate);
            });


            // Load month list and basic employee details when a person is selected
            function changename(getemplname) {
              // hide month dropdown, show spinner
              $('#monthSelect').hide();
              $('#monthLoading').removeClass('d-none');

              var emplno_select_User = $('#vehno option:selected').val();

              // clear existing month options except first
              $('#monthSelect').val('');
              $('#monthSelect option:not(:first)').remove();

              $.ajax({
                // Use the route to get selected employee's available months
                url: "{{ route('selfAppraiApp_MonthDate') }}",
                type: "GET",
                data: {
                  emplno_select_User1: emplno_select_User,
                },
                dataType: 'json',
                success: function(data) {
                  console.table('Month Data: ', data);

                  if (data && data.length > 0) {
                    var tno = data[0].Tno;
                    var name = data[0].Name;
                    var depname = data[0].DeptName;
                    var desname = data[0].DesignationName;

                    // These fields may or may not exist on this page; jQuery will safely no-op if they don't
                    $('#TNO').val(tno);
                    $('#NAME').val(name);
                    $('#DEPARTMENT').val(depname);
                    $('#DESIGNAION').val(desname);

                    var count = data.length;
                    for (var i = 0; i < count; i++) {
                      var row = data[i] || {};
                      var eff = row.EFFECTFROM || row.Effectfrom || row.Effect_From || row.EffectFrom || '';
                      if (!eff) continue;
                      $('#monthSelect').append('<option value="' + eff + '">' + eff + '</option>');
                    }
                  }

                  $('#monthSelect').show();
                  $('#monthLoading').addClass('d-none');
                },
                error: function(xhr) {
                  console.error('Error:', xhr.responseText);
                  $('#monthSelect').show();
                  $('#monthLoading').addClass('d-none');
                }
              });
            }
          </script>
          <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
          <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
          <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
          <!-- prismjs plugin -->
          <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
          <!-- gridjs js -->
          <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
          <!-- gridjs init -->
          <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
          <!-- Toastr notifications -->
          <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
          <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
          <!-- App js -->
          <script src="LifeAtGainup_Assets/assets/js/app.js"></script>
          <!-- Chart.js for KPI charts -->
          <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

          <script>
            // Canvas contexts for charts
            const ctxRing = document.getElementById('totalScoreRing');
            const ctx1 = document.getElementById('overallChart');
            const ctx2 = document.getElementById('kpiChart');

            // Map an Actual value to a rating (0-100) using the same scale as the KPI popup
            function getRatingFromScale(kpi, actualVal) {
              var name = (kpi || 'KPI').toLowerCase();

              // AUDIT SCORE (grade-based A–E)
              if (name === 'audit score') {
                var grade = (actualVal || '').toString().trim().toUpperCase();
                if (grade === 'A') return 100;
                if (grade === 'B') return 90;
                if (grade === 'C') return 80;
                if (grade === 'D') return 70;
                if (grade === 'E') return 0;
                return '';
              }

              var v = parseFloat(actualVal);
              if (isNaN(v)) return '';

              // Absenteeism: 0-10, 11-12, 13-14, 15-16, 17-50
              if (name === 'absenteeism') {
                if (v >= 0 && v <= 10) return 100;
                if (v > 10 && v <= 12) return 90;
                if (v >= 13 && v <= 14) return 80;
                if (v >= 15 && v <= 16) return 70;
                if (v >= 17 && v <= 50) return 0;
                return '';
              }

              // Recruitment Strength: 95-100, 80-94, 75-79, 70-74, 0-69
              if (name === 'recruitment strength' || name === 'recruitment_strength') {
                if (v >= 95 && v <= 100) return 100;
                if (v >= 80 && v <= 94) return 90;
                if (v >= 75 && v <= 79) return 80;
                if (v >= 70 && v <= 74) return 70;
                if (v >= 0 && v < 70) return 0;
                return '';
              }

              // 5S Audit Mark: 95-100, 80-94, 75-79, 70-74, <70
              if (name === '5s audit mark' || name === '5s' || name === '5s audit') {
                if (v >= 95 && v <= 100) return 100;
                if (v >= 80 && v <= 94) return 90;
                if (v >= 75 && v <= 79) return 80;
                if (v >= 70 && v <= 74) return 70;
                if (v >= 0 && v < 70) return 0;
                return '';
              }

              // Default numeric scale aligned with KPI info popup (e.g., Attrition):
              // 0-5  -> 100
              // 6-7  -> 90
              // 8-9  -> 80
              // 10-20 -> 0
              if (v >= 0 && v <= 5) return 100;
              if (v > 5 && v <= 7) return 90;
              if (v > 7 && v <= 9) return 80;
              if (v > 9 && v <= 20) return 0;
              return '';
            }

            // tiny jQuery to update score-pill when actual changes (example logic: weightage * actual/target)
            function calcScore(row) {
              const actual = parseFloat($('#actual-' + row).val()) || 0;
              const target = {
                1: 5,
                2: 10,
                3: 90,
                4: 0,
                5: 100
              } [row];
              const weight = {
                1: 40,
                2: 35,
                3: 10,
                4: 10,
                5: 5
              } [row];
              let score = 0;
              if (row === 4) { // grade-based simple mapping
                score = (actual === 'A') ? weight : (actual === 'B') ? weight * 0.5 : 0;
              } else {
                if (target > 0) score = (actual / target) * weight;
              }
              if (score > weight) score = weight; // cap
              $('#score-' + row).text(score.toFixed(2));
            }

            $(document).ready(function() {
              // Populate table from Self Appraisal Grid Data for selected month
              function monthKey(ym) {
                // ym: YYYY-MM -> 'mon-YYYY' (e.g., 'sep-2025')
                if (!ym) return '';
                var parts = ym.split('-');
                if (parts.length < 2) return '';
                var y = parts[0],
                  m = parseInt(parts[1], 10);
                var names = ['jan', 'feb', 'mar', 'apr', 'may', 'jun', 'jul', 'aug', 'sep', 'oct', 'nov', 'dec'];
                return names[m - 1] + '-' + y;
              }

              function buildRow(i, r) {

                var kpi = r.KPI_POINT || '';
                var uom = r.Uom || r.UOM || '';
                var target = r.Target != null ? r.Target : '';
                // Self appraisal rating (user actual)
                var selfRating = (r.ACTUAL != null ? r.ACTUAL : (r.Actual != null ? r.Actual : (r.Actual_Value != null ? r.Actual_Value : '')));
                // User remark from employee
                var userRemark = r.Kpi_Remarks || '';
                // Supervisor rating should mirror Self Appraisal Rating
                var supRating = selfRating;
                // HOD remarks
                var hodRemark = r.Remarks || '';
                var weight = r.Weightage != null ? r.Weightage : '';
                var kpiId = r.Kpi_Id || r.KPI_ID || r.Id || '';
                var rowId = r.Rowid || r.ROWID || r.RowID || '';
                var kpiremarks = userRemark;
                var scoreVal = (r.Score != null && r.Score !== '') ? parseFloat(r.Score) : 0;
                var type = (r.Type || '').toString().toUpperCase();
                var isAuto = (type === 'AUTO');
                var actualClass = 'input-actual ' + (isAuto ? 'input-actual-auto' : 'input-actual-manual');
                var placeholderAttr = isAuto ? '' : ' placeholder="Enter"';
                var formulaWarnClass = (kpi.toLowerCase().includes('5s')) ? ' d-none' : '';
                return (
                  '<tr data-rowid="' + rowId + '">' +
                  '<td class="px-2 py-3">' + (i + 1) + '</td>' +
                  '<td class="px-2 py-3  align-items-center gap-1">' +
                  kpi + ' <span class="text-primary small kpi-info" data-kpi="' + kpi + '" data-kpiid="' + kpiId + '">ⓘ</span>' +
                  '<input type="hidden" name="userdes1[]" value="' + kpi + '">' +
                  '<input type="hidden" name="userRowid1[]" value="' + rowId + '">' +
                  '</td>' +
                  // Weightage
                  '<td class="px-2 py-3 text-center">' +
                  '<span class="pill-badge">' + weight + '</span>' +
                  '<input type="hidden" name="userweight1[]" value="' + weight + '">' +
                  '</td>' +
                  // Target
                  '<td class="px-2 py-3"><span class="pill-light">' + target + '</span><input type="hidden" name="usertarget1[]" value="' + target + '"></td>' +
                  // Self Appraisal Rating (readonly)
                  '<td class="px-2 py-3">' +
                  '<input value="' + selfRating + '" class="input-actual input-actual-auto" data-kpiid="' + kpiId + '" data-weight="' + weight + '" data-type="AUTO" readonly/>' +
                  ' <span class="exclaim-circle actual-info' + formulaWarnClass + '" data-formula="Formula: ">!</span>' +
                  '</td>' +
                  // User Remark
                  '<td class="px-2 py-3"><input placeholder="Add remarks..." class="remarks-input" value="' + (userRemark || '') + '" readonly></td>' +
                  // Supervisor Rating (editable actual) - no duplicate exclaim icon or visible score badge
                  '<td class="px-2 py-3">' +
                  '<input name="useract1[]" value="' + supRating + '" class="' + actualClass + '" data-kpiid="' + kpiId + '" data-weight="' + weight + '" data-type="' + (isAuto ? 'AUTO' : 'MANUAL') + '"' + placeholderAttr + (isAuto ? ' readonly' : '') + '/>' +
                  // keep score-badge hidden for calculations used elsewhere
                  ' <span class="score-badge d-none">' + (scoreVal ? scoreVal.toFixed(2) : (supRating !== '' ? supRating : '0')) + '</span> <span class="text-primary small score-info">ⓘ</span>' +
                  '<input type="hidden" name="userincpoint1[]" value="' + (scoreVal ? scoreVal.toFixed(2) : (supRating !== '' ? supRating : '0')) + '">' +
                  '</td>' +
                  // Score (visible column, uses API "Score" value) with blue pill design
                  '<td class="px-2 py-3 text-center">' +
                  '<span class="score-badge">' + (scoreVal ? scoreVal.toFixed(2) : '0.00') + '</span> ' +
                  '<span class="text-primary small score-info">ⓘ</span>' +
                  '</td>' +
                  // HOD Remarks (editable, posted as userremark1[])
                  '<td class="px-2 py-3"><input name="userremark1[]" placeholder="HOD remarks" class="remarks-input" value="' + (hodRemark || '') + '"></td>' +
                  // UOM
                  '<td class="px-2 py-3">' + uom + '</td>' +
                  '</tr>'
                );
              }

              function wireScoreHandlers() {
                $('table.kpi-table tbody input.input-actual').off('input change focus blur').on('input change', function() {
                  var $inp = $(this);
                  var val = ($inp.val() || '').toString();
                  var weight = parseFloat($inp.data('weight')) || 0;
                  var $row = $inp.closest('tr');
                  var kpiTitle = $.trim($row.find('.kpi-info').first().data('kpi') || $row.find('td').eq(1).text());
                  var targetText = $.trim($row.find('.pill-light').first().text());
                  var targetVal = parseFloat(targetText);
                  var actualNum = parseFloat(val);

                  // Inline validation with tooltip: Supervisor Rating cannot be greater than Target
                  // Skip this check for COST PER MIN and OCR CLOSING KPIs
                  var kpiLower = (kpiTitle || '').toString().toLowerCase();
                  var skipGreaterCheck = (kpiLower === 'cost per min' || kpiLower === 'ocr closing');
                  // Use the icon located in the same cell as the editable input
                  var $errorIcon = $inp.closest('td').find('.actual-info').first();
                  if (!skipGreaterCheck && !isNaN(actualNum) && !isNaN(targetVal) && actualNum > targetVal) {
                    if ($errorIcon.length) {
                      $errorIcon.addClass('has-tooltip error-tip show-tip').attr('data-tooltip', 'Supervisor Rating cannot be greater than Target');
                    }
                    $inp.addClass('has-tooltip error-tip is-invalid show-tip').attr('data-tooltip', 'Supervisor Rating cannot be greater than Target');
                    $row.find('.score-badge').text('0.00');
                    updatePerformanceSummary();
                    refreshOverallChartFromTable();
                    refreshKpiTrendChart();
                    return;
                  } else {
                    if ($errorIcon.length) {
                      $errorIcon.attr('data-tooltip', '').removeClass('error-tip show-tip');
                    }
                    $inp.removeClass('error-tip is-invalid show-tip').attr('data-tooltip', '');
                  }

                  var ratingVal = getRatingFromScale(kpiTitle, val);
                  var score = 0;
                  if (ratingVal !== '' && ratingVal != null && !isNaN(parseFloat(ratingVal))) {
                    score = (parseFloat(ratingVal) * weight) / 100;
                  }

                  $row.find('.score-badge').text(score.toFixed(2));
                  updatePerformanceSummary();
                  refreshOverallChartFromTable();
                  refreshKpiTrendChart();
                }).on('focus', function() {
                  var $inp = $(this);
                  if ($inp.hasClass('error-tip')) {
                    $inp.addClass('show-tip');
                  }
                }).on('blur', function() {
                  var $inp = $(this);
                  if (!$inp.hasClass('error-tip')) {
                    $inp.removeClass('show-tip').attr('data-tooltip', '');
                  }
                });
              }

              // Prevent Approve if any invalid self appraisal inputs exist
              $(document).on('click', '#selfAppSaveBtn', function(e) {
                var $invalid = $('table.kpi-table tbody input.input-actual.error-tip, table.kpi-table tbody input.input-actual.is-invalid');
                if ($invalid.length) {
                  e.preventDefault();
                  if (window.toastr) {
                    toastr.error('Please correct highlighted values. Self Appraisal Rating cannot be greater than Target.');
                  }
                  $invalid.first().focus();
                  return false;
                }
              });

              function getOverallRating(total) {
                var t = parseFloat(total) || 0;
                if (t >= 80) return 'Excellent'; // 80-100
                if (t >= 61) return 'Good'; // 61-79
                if (t >= 41) return 'Average'; // 41-60
                if (t >= 21) return 'Below Average'; // 21-40
                return 'Poor'; // 0-20
              }

              function updatePerformanceSummary() {
                var sum = 0;
                // Use only the visible Score column badges (blue pill),
                // ignore hidden score-badge elements used for internal calculations.
                var $scores = $('table.kpi-table tbody .score-badge:not(.d-none)');
                var selMonth = ($('#monthSelect').val() || '').toString().trim();

                // If no month is selected or there are no score badges yet (placeholder row),
                // show a neutral "Select month" state instead of 0% Poor.
                if (!selMonth || !$scores.length) {
                  window.totalScoreValue = 0;
                  $('#totalScorePercent').text('--');
                  $('#totalScoreStatus').text('Select month');
                  $('#overallStatusCard').text('Select month');
                  $('#overallRatingBadge').text('Select month');
                  $('#totalScoreStatus').css('color', '#6b7280');
                  var $wrap = $('#overallStatusWrapper');
                  $wrap.removeClass('poor below average good excellent');
                  return;
                }

                $scores.each(function() {
                  var v = parseFloat($(this).text());
                  if (!isNaN(v)) sum += v;
                });
                // Cap between 0 and 100 for display
                var display = Math.max(0, Math.min(100, sum));
                // Persist the latest total for tooltip usage
                window.totalScoreValue = display;
                // Compute status label
                var status = getOverallRating(display);
                // Show rounded percentage and status inside the ring center and summary card
                $('#totalScorePercent').text(Math.round(display) + '%');
                $('#totalScoreStatus').text(status);
                $('#overallStatusCard').text(status);
                $('#overallRatingBadge').text(status);
                // Set status color and DO NOT pop any pill (no active-band effect)
                (function() {
                  function bandIndexForValue(v) {
                    if (v <= 20) return 0; // 0-20 Poor
                    if (v <= 40) return 1; // 21-40 Below Avg
                    if (v <= 60) return 2; // 41-60 Avg
                    if (v <= 79) return 3; // 61-79 Good
                    return 4; // 80-100 Excellent
                  }
                  var activeBand = bandIndexForValue(display);
                  // Poor -> red, Below Avg -> gray, others unchanged
                  var statusColors = ['#ef4444', '#94a3b8', '#fb923c', '#b36ba4', '#22c55e'];
                  $('#totalScoreStatus').css('color', statusColors[activeBand] || '#6b7280');
                  // Update overall card band class
                  var bandClasses = ['poor', 'below', 'average', 'good', 'excellent'];
                  var $wrap = $('#overallStatusWrapper');
                  $wrap.removeClass('poor below average good excellent');
                  $wrap.addClass(bandClasses[activeBand] || 'poor');
                })();

                // Update donut ring: only one colored slice (the total %) and the rest as a light gray ring
                if (window.totalScoreRingInstance) {
                  var percent = Math.round(display); // 0-100
                  if (percent < 0) percent = 0;
                  if (percent > 100) percent = 100;

                  // Band colors aligned with legend cards (Poor red, Below gray, Average orange, Good, Excellent)
                  var baseBandColors = ['#ef4444', '#94a3b8', '#fb923c', '#b36ba4', '#22c55e']; // Poor, Below, Avg, Good, Excellent

                  function bandIndexForValue(v) {
                    if (v <= 20) return 0; // 0-20 Poor
                    if (v <= 40) return 1; // 21-40 Below Avg
                    if (v <= 60) return 2; // 41-60 Avg
                    if (v <= 79) return 3; // 61-79 Good
                    return 4; // 80-100 Excellent
                  }

                  var activeBand = bandIndexForValue(display);

                  // Two slices: [score, remaining]
                  window.totalScoreRingInstance.data.datasets[0].data = [percent, 100 - percent];
                  window.totalScoreRingInstance.data.datasets[0].backgroundColor = [
                    baseBandColors[activeBand], // actual score slice
                    'rgba(148,163,184,0.20)' // remaining, light gray
                  ];
                  window.totalScoreRingInstance.update();
                }
              }

              // Build a simple series from current table scores (one point per KPI row)
              function buildScoreSeriesFromTable() {
                var labels = [],
                  data = [];
                $('table.kpi-table tbody tr').each(function() {
                  var $row = $(this);
                  var kpiTitle = $.trim($row.find('.kpi-info').first().data('kpi') || $row.find('td').eq(1).text());
                  // Same as summary: use only the visible Score column badge, not hidden ones
                  var score = parseFloat($row.find('.score-badge:not(.d-none)').text());
                  if (!isNaN(score)) {
                    labels.push(kpiTitle || ('KPI ' + (labels.length + 1)));
                    data.push(score);
                  }
                });
                return {
                  labels: labels,
                  data: data
                };
              }

              // Overall performance chart: multi-KPI area chart driven by same API as KPI-wise trend
              function refreshOverallChartFromTable() {
                if (!window.overallChartInstance) return;

                // Map overallRange values to internal range used by KPI-wise chart
                var overallRange = $('#overallRange').val() || 'month_to_quarter';
                var range;
                if (overallRange === 'month_to_date') range = 'monthly';
                else if (overallRange === 'month_to_quarter') range = 'quarterly';
                else if (overallRange === 'month_to_half_yearly') range = 'half_yearly';
                else if (overallRange === 'month_to_annual') range = 'annum';
                else range = 'quarterly';

                // Determine fiscal year (April to March)
                var today = new Date();
                var currentMonth = today.getMonth() + 1; // 1-12
                var currentYear = today.getFullYear();
                var fiscalStartYear = currentMonth >= 4 ? currentYear : currentYear - 1; // April-based FY

                var fromdate = fiscalStartYear + '-04-01';
                var enddate;
                if (range === 'monthly') {
                  var endYear = currentYear;
                  var endMonth = currentMonth;
                  var endMonthStr = (endMonth < 10 ? '0' : '') + endMonth;
                  enddate = endYear + '-' + endMonthStr + '-01';
                } else if (range === 'quarterly') {
                  enddate = fiscalStartYear + '-06-30';
                } else if (range === 'half_yearly' || range === 'annum') {
                  enddate = (fiscalStartYear + 1) + '-04-01';
                } else {
                  enddate = today.toISOString().slice(0, 10);
                }

                var params = {
                  // Use selected person for charts; fallback to logged-in employee if none selected
                  empid: ($('#vehno').val() || @json(Session::get('empl_id'))),
                  fromdate: fromdate,
                  enddate: enddate
                };

                $.getJSON("{{ route('kpiinfokeyperformace') }}", params)
                  .done(function(res) {
                    try {
                      var allRows = [];
                      if (Array.isArray(res)) allRows = res;
                      else if (res && Array.isArray(res.data)) allRows = res.data;
                      else if (res && Array.isArray(res.results)) allRows = res.results;

                      if (!allRows.length) return;

                      var monthNames = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
                      var monthShort = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

                      // Build KPI order dynamically from API rows and align to existing datasets by index
                      var datasets = (window.overallChartInstance.data && window.overallChartInstance.data.datasets) || [];
                      var kpiOrder = [];
                      var kpiMonths = {};

                      for (var di = 0; di < datasets.length; di++) {
                        var row = allRows[di];
                        if (!row) continue;
                        var rawName = (row.KPI_Point || row.KPI_POINT || '').toString();
                        if (!rawName) continue;
                        // update dataset label so legend text matches API
                        datasets[di].label = rawName;
                        kpiOrder.push(rawName);
                        kpiMonths[rawName] = [];

                        // build month items for this KPI
                        for (var m = 1; m <= 12; m++) {
                          var calYear = (m >= 4) ? fiscalStartYear : (fiscalStartYear + 1);
                          var key = monthShort[m - 1] + '_' + calYear;
                          if (row.hasOwnProperty(key)) {
                            var v = parseFloat(row[key]);
                            if (isNaN(v)) v = 0;
                            kpiMonths[rawName].push({
                              year: calYear,
                              month: m,
                              fyYear: fiscalStartYear,
                              value: v
                            });
                          }
                        }
                      }

                      // Build labels + series according to range
                      var labels = [];
                      var seriesData = {};
                      kpiOrder.forEach(function(n) {
                        seriesData[n] = [];
                      });

                      if (range === 'annum') {
                        // One point per KPI, average over FY, label uses latest month across all KPIs
                        var lastMonth = null;
                        kpiOrder.forEach(function(kn) {
                          kpiMonths[kn].forEach(function(it) {
                            if (lastMonth === null || it.month > lastMonth.month ||
                              (it.month === lastMonth.month && it.year > lastMonth.year)) {
                              lastMonth = {
                                year: it.year,
                                month: it.month
                              };
                            }
                          });
                        });
                        var endLabel = lastMonth ? monthNames[lastMonth.month - 1] : 'Mar';
                        labels.push('Annual (Apr-' + endLabel + ')');

                        kpiOrder.forEach(function(kn) {
                          var sum = 0,
                            cnt = 0;
                          kpiMonths[kn].forEach(function(it) {
                            sum += it.value;
                            cnt++;
                          });
                          seriesData[kn].push(cnt > 0 ? (sum / cnt) : 0);
                        });

                      } else if (range === 'quarterly') {
                        var qLabels = ['Q1 (Apr-Jun)', 'Q2 (Jul-Sep)', 'Q3 (Oct-Dec)', 'Q4 (Jan-Mar)'];
                        var curQ;
                        if (currentMonth >= 4 && currentMonth <= 6) curQ = 1;
                        else if (currentMonth >= 7 && currentMonth <= 9) curQ = 2;
                        else if (currentMonth >= 10 && currentMonth <= 12) curQ = 3;
                        else curQ = 4;

                        kpiOrder.forEach(function(kn) {
                          var qAgg = {
                            1: {
                              sum: 0,
                              cnt: 0
                            },
                            2: {
                              sum: 0,
                              cnt: 0
                            },
                            3: {
                              sum: 0,
                              cnt: 0
                            },
                            4: {
                              sum: 0,
                              cnt: 0
                            }
                          };
                          kpiMonths[kn].forEach(function(it) {
                            var m = it.month,
                              q;
                            if (m >= 4 && m <= 6) q = 1;
                            else if (m >= 7 && m <= 9) q = 2;
                            else if (m >= 10 && m <= 12) q = 3;
                            else q = 4;
                            qAgg[q].sum += it.value;
                            qAgg[q].cnt += 1;
                          });
                          seriesData[kn] = [];
                          for (var qi = 1; qi <= curQ; qi++) {
                            if (kn === kpiOrder[0]) labels.push(qLabels[qi - 1]);
                            seriesData[kn].push(qAgg[qi].cnt > 0 ? (qAgg[qi].sum / qAgg[qi].cnt) : 0);
                          }
                        });

                      } else if (range === 'half_yearly') {
                        labels = ['H1 (Apr-Sep)', 'H2 (Oct-Mar)'];
                        kpiOrder.forEach(function(kn) {
                          var hAgg = {
                            1: {
                              sum: 0,
                              cnt: 0
                            },
                            2: {
                              sum: 0,
                              cnt: 0
                            }
                          };
                          kpiMonths[kn].forEach(function(it) {
                            var m = it.month;
                            var h = (m >= 4 && m <= 9) ? 1 : 2;
                            hAgg[h].sum += it.value;
                            hAgg[h].cnt += 1;
                          });
                          seriesData[kn] = [
                            hAgg[1].cnt > 0 ? (hAgg[1].sum / hAgg[1].cnt) : 0,
                            hAgg[2].cnt > 0 ? (hAgg[2].sum / hAgg[2].cnt) : 0
                          ];
                        });

                      } else { // monthly
                        var endM = currentMonth;
                        var sequence = [];
                        if (endM >= 4) {
                          for (var m = 4; m <= endM; m++) sequence.push(m);
                        } else {
                          for (var m = 4; m <= 12; m++) sequence.push(m);
                          for (var m2 = 1; m2 <= endM; m2++) sequence.push(m2);
                        }

                        sequence.forEach(function(m) {
                          labels.push(monthNames[m - 1]);
                        });

                        kpiOrder.forEach(function(kn) {
                          var monthMap = {};
                          kpiMonths[kn].forEach(function(it) {
                            monthMap[it.month] = it.value;
                          });
                          seriesData[kn] = [];
                          sequence.forEach(function(m) {
                            var v = monthMap[m];
                            seriesData[kn].push(typeof v === 'number' ? v : 0);
                          });
                        });
                      }

                      // Apply to chart (datasets assumed in same order as kpiOrder)
                      window.overallChartInstance.data.labels = labels;
                      window.overallChartInstance.data.datasets.forEach(function(ds) {
                        var name = ds.label || '';
                        var key = null;
                        kpiOrder.forEach(function(kn) {
                          if (kn.toUpperCase() === name.toUpperCase()) key = kn;
                        });
                        if (key && seriesData[key]) {
                          ds.data = seriesData[key];
                        }
                      });
                      // Enable legend only after API-driven data is in place
                      if (window.overallChartInstance.options && window.overallChartInstance.options.plugins && window.overallChartInstance.options.plugins.legend) {
                        window.overallChartInstance.options.plugins.legend.display = true;
                      }
                      window.overallChartInstance.update();
                    } catch (e) {
                      console.error('overallChart aggregation error', e);
                    }
                  })
                  .fail(function(xhr) {
                    console.error('overallChart API error', xhr.status, xhr.responseText);
                  });
              }

              function refreshKpiTrendChart() {
                if (!window.kpiChartInstance) return;

                var selectedKpi = $('#kpiSelect').val();
                var range = $('#kpiRange').val();

                // Determine fiscal year (April to March)
                var today = new Date();
                var currentMonth = today.getMonth() + 1; // 1-12
                var currentYear = today.getFullYear();
                var fiscalStartYear = currentMonth >= 4 ? currentYear : currentYear - 1; // April-based FY

                var fromdate = fiscalStartYear + '-04-01'; // Always start from April 1st of fiscal year
                var enddate;

                if (range === 'monthly') {
                  // April 1st of FY to the first day of this month
                  var endYear = currentYear;
                  var endMonth = currentMonth; // this month
                  var endMonthStr = (endMonth < 10 ? '0' : '') + endMonth;
                  enddate = endYear + '-' + endMonthStr + '-01';
                } else if (range === 'quarterly') {
                  // Apr - Jun (we only need up to Q1; higher quarters are derived from monthly data)
                  enddate = fiscalStartYear + '-06-30';
                } else if (range === 'half_yearly' || range === 'annum') {
                  // For half-yearly and annual we need the full fiscal year Apr 1 - next Apr 1
                  enddate = (fiscalStartYear + 1) + '-04-01';
                } else {
                  // Fallback: today
                  enddate = today.toISOString().slice(0, 10);
                }

                // Build params for API (backend returns all KPIs; we filter on frontend)
                var params = {
                  empid: ($('#vehno').val() || @json(Session::get('empl_id'))),
                  fromdate: fromdate,
                  enddate: enddate
                };

                $.getJSON("{{ route('kpiinfokeyperformace') }}", params)
                  .done(function(res) {
                    try {
                      // Normalize response to a flat array
                      var allPoints = [];
                      if (Array.isArray(res)) {
                        allPoints = res;
                      } else if (res && Array.isArray(res.data)) {
                        allPoints = res.data;
                      } else if (res && Array.isArray(res.results)) {
                        allPoints = res.results;
                      }

                      // Filter by selected KPI (match against KPI_Point)
                      var selectedName = (selectedKpi || '').toLowerCase();
                      var points = allPoints.filter(function(p) {
                        return (p && (p.KPI_Point || '').toLowerCase() === selectedName);
                      });

                      if (!points.length) throw new Error('No points for KPI');

                      // Sort by KPI_Month date ascending
                      points.sort(function(a, b) {
                        var da = (a.KPI_Month || '').toString();
                        var db = (b.KPI_Month || '').toString();
                        return da.localeCompare(db);
                      });

                      var monthNames = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

                      // Normalize to month-level items with fiscal year mapping
                      var monthItems = [];

                      if (points.length && (points[0].KPI_Month || points[0].KPI_Month === '0')) {
                        // Legacy shape: one record per month with KPI_Month like '2025-04'
                        monthItems = points.map(function(p) {
                          var dstr = (p.KPI_Month || '').toString();
                          var parts = dstr.split('-');
                          var y = parts.length >= 1 ? parseInt(parts[0], 10) || 0 : 0;
                          var m = parts.length >= 2 ? parseInt(parts[1], 10) || 1 : 1;
                          var v = parseFloat(p.Score || p.Value || p.Total || p.Y || 0);
                          if (isNaN(v)) v = 0;
                          var fyYear = (m >= 4) ? y : (y - 1); // FY starts in April
                          return {
                            year: y,
                            month: m,
                            fyYear: fyYear,
                            value: v,
                            raw: p
                          };
                        }).filter(function(it) {
                          return it.fyYear === fiscalStartYear;
                        });
                      } else if (points.length) {
                        // New shape: a single row per KPI with columns like 'Apr_2025','May_2025', ...
                        var row = points[0];
                        var monthShort = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
                        for (var m = 1; m <= 12; m++) {
                          // For FY N: Apr–Dec are year N, Jan–Mar are year N+1
                          var calYear = (m >= 4) ? fiscalStartYear : (fiscalStartYear + 1);
                          var key = monthShort[m - 1] + '_' + calYear;
                          if (row.hasOwnProperty(key)) {
                            var v2 = parseFloat(row[key]);
                            if (isNaN(v2)) v2 = 0;
                            monthItems.push({
                              year: calYear,
                              month: m,
                              fyYear: fiscalStartYear,
                              value: v2,
                              raw: row
                            });
                          }
                        }
                      }

                      var labels = [];
                      var data = [];

                      if (range === 'annum') {
                        // Annual view: single point for fiscal year Apr-<last data month>
                        var sumAll = 0,
                          cntAll = 0;
                        var lastMonth = null;
                        monthItems.forEach(function(it) {
                          sumAll += it.value;
                          cntAll += 1;
                          if (lastMonth === null || it.year > lastMonth.year || (it.year === lastMonth.year && it.month > lastMonth.month)) {
                            lastMonth = {
                              year: it.year,
                              month: it.month
                            };
                          }
                        });

                        var endLabel = lastMonth ? monthNames[lastMonth.month - 1] : 'Mar';
                        labels.push('Annual (Apr-' + endLabel + ')');
                        data.push(cntAll > 0 ? (sumAll / cntAll) : 0);
                      } else if (range === 'quarterly') {
                        // Q1: Apr-Jun, Q2: Jul-Sep, Q3: Oct-Dec, Q4: Jan-Mar
                        var qAgg = {
                          1: {
                            sum: 0,
                            cnt: 0
                          },
                          2: {
                            sum: 0,
                            cnt: 0
                          },
                          3: {
                            sum: 0,
                            cnt: 0
                          },
                          4: {
                            sum: 0,
                            cnt: 0
                          }
                        };
                        monthItems.forEach(function(it) {
                          var m = it.month;
                          var q;
                          if (m >= 4 && m <= 6) q = 1;
                          else if (m >= 7 && m <= 9) q = 2;
                          else if (m >= 10 && m <= 12) q = 3;
                          else q = 4; // Jan-Mar
                          qAgg[q].sum += it.value;
                          qAgg[q].cnt += 1;
                        });
                        var qLabels = ['Q1 (Apr-Jun)', 'Q2 (Jul-Sep)', 'Q3 (Oct-Dec)', 'Q4 (Jan-Mar)'];

                        // Determine current fiscal quarter (1-4) based on today's month
                        var curQ;
                        if (currentMonth >= 4 && currentMonth <= 6) curQ = 1;
                        else if (currentMonth >= 7 && currentMonth <= 9) curQ = 2;
                        else if (currentMonth >= 10 && currentMonth <= 12) curQ = 3;
                        else curQ = 4; // Jan-Mar

                        for (var qi = 1; qi <= curQ; qi++) {
                          labels.push(qLabels[qi - 1]);
                          if (qAgg[qi].cnt > 0) {
                            data.push(qAgg[qi].sum / qAgg[qi].cnt);
                          } else {
                            data.push(0);
                          }
                        }
                      } else if (range === 'half_yearly') {
                        // H1: Apr-Sep, H2: Oct-Mar (always show both halves)
                        var hAgg = {
                          1: {
                            sum: 0,
                            cnt: 0
                          },
                          2: {
                            sum: 0,
                            cnt: 0
                          }
                        };
                        monthItems.forEach(function(it) {
                          var m = it.month;
                          var h = (m >= 4 && m <= 9) ? 1 : 2; // Apr-Sep vs Oct-Mar
                          hAgg[h].sum += it.value;
                          hAgg[h].cnt += 1;
                        });

                        labels.push('H1 (Apr-Sep)');
                        data.push(hAgg[1].cnt > 0 ? (hAgg[1].sum / hAgg[1].cnt) : 0);

                        labels.push('H2 (Oct-Mar)');
                        data.push(hAgg[2].cnt > 0 ? (hAgg[2].sum / hAgg[2].cnt) : 0);
                      } else if (range === 'monthly') {
                        // Monthly view: continuous Apr -> current month for this fiscal year
                        var monthMap = {};
                        monthItems.forEach(function(it) {
                          if (!monthMap[it.month]) monthMap[it.month] = {
                            sum: 0,
                            cnt: 0
                          };
                          monthMap[it.month].sum += it.value;
                          monthMap[it.month].cnt += 1;
                        });

                        // Build from April (4) up to current month (within this FY)
                        var endM = currentMonth;
                        // If we are in Jan/Feb/Mar, still show full Apr-Dec of previous FY then Jan..current
                        var sequence = [];
                        if (endM >= 4) {
                          for (var m = 4; m <= endM; m++) sequence.push(m);
                        } else {
                          for (var m = 4; m <= 12; m++) sequence.push(m);
                          for (var m2 = 1; m2 <= endM; m2++) sequence.push(m2);
                        }

                        sequence.forEach(function(m) {
                          labels.push(monthNames[m - 1]);
                          if (monthMap[m] && monthMap[m].cnt > 0) {
                            data.push(monthMap[m].sum / monthMap[m].cnt);
                          } else {
                            data.push(0);
                          }
                        });
                      } else {
                        // Fallback: month-wise labels directly from data
                        labels = monthItems.map(function(it) {
                          return monthNames[it.month - 1] + ' ' + it.year.toString().slice(-2);
                        });
                        data = monthItems.map(function(it) {
                          return it.value;
                        });
                      }

                      window.kpiChartInstance.data.labels = labels;
                      window.kpiChartInstance.data.datasets[0].label = selectedKpi || 'KPI';
                      window.kpiChartInstance.data.datasets[0].data = data;
                      window.kpiChartInstance.update();
                    } catch (e) {
                      // Fallback to simple pseudo-trend based on current table scores
                      var series = buildScoreSeriesFromTable();
                      var idx = -1;
                      for (var i = 0; i < series.labels.length; i++) {
                        if (series.labels[i].toLowerCase() === (selectedKpi || '').toLowerCase()) {
                          idx = i;
                          break;
                        }
                      }
                      var val = (idx >= 0) ? series.data[idx] : 0;
                      var labels = ['P1', 'P2', 'P3', 'P4'];
                      var data = labels.map(function() {
                        return val;
                      });
                      window.kpiChartInstance.data.labels = labels;
                      window.kpiChartInstance.data.datasets[0].label = selectedKpi || 'KPI';
                      window.kpiChartInstance.data.datasets[0].data = data;
                      window.kpiChartInstance.update();
                    }
                  })
                  .fail(function() {
                    // On error, also fall back to pseudo-trend
                    var series = buildScoreSeriesFromTable();
                    var idx = -1;
                    for (var i = 0; i < series.labels.length; i++) {
                      if (series.labels[i].toLowerCase() === (selectedKpi || '').toLowerCase()) {
                        idx = i;
                        break;
                      }
                    }
                    var val = (idx >= 0) ? series.data[idx] : 0;
                    var labels = ['P1', 'P2', 'P3', 'P4'];
                    var data = labels.map(function() {
                      return val;
                    });
                    window.kpiChartInstance.data.labels = labels;
                    window.kpiChartInstance.data.datasets[0].label = selectedKpi || 'KPI';
                    window.kpiChartInstance.data.datasets[0].data = data;
                    window.kpiChartInstance.update();
                  });
              }

              function initActualInfoTooltips() {
                $('table.kpi-table tbody .actual-info').each(function() {
                  var text = $(this).attr('data-formula') || 'Formula';
                  $(this).addClass('has-tooltip').attr('data-tooltip', text);
                });
              }

              // Ensure 'Your Score' tooltip content is applied for dynamically inserted rows
              function initScoreInfoTooltipsLegacy() {
                $('table.kpi-table tbody .score-info').each(function() {
                  var el = this;
                  var $el = $(el);
                  $el.addClass('has-tooltip');

                  function computeContent() {
                    var $row = $el.closest('tr');
                    // Prefer weight from visible badge; fallback to input data-weight
                    var weight = $.trim($row.find('.pill-badge').first().text());
                    if (!weight) {
                      var wAttr = $row.find('.input-actual').data('weight');
                      weight = (wAttr != null && wAttr !== '') ? wAttr.toString() : '';
                    }
                    var actualRaw = $.trim($row.find('.input-actual').val());
                    var actual = actualRaw != null ? actualRaw.toString().replace(/,/g, '') : '';
                    var kpiTitle = $.trim($row.find('.kpi-info').first().data('kpi') || $row.find('td').eq(1).text());
                    var ratingVal = getRatingFromScale(kpiTitle, actual);
                    // Fallback: derive rating as a percentage of Target when scale returns blank
                    if (ratingVal === '' || ratingVal == null) {
                      var targetText = $.trim($row.find('.pill-light').first().text());
                      var t = parseFloat((targetText || '').toString().replace(/,/g, ''));
                      var a = parseFloat(actual);
                      if (!isNaN(a) && !isNaN(t) && t > 0) {
                        ratingVal = Math.max(0, Math.min(100, Math.round((a / t) * 100)));
                      }
                    }
                    var displayRating = (ratingVal === '' || ratingVal == null) ? '-' : ratingVal;
                    return 'Ratings: ' + displayRating + ' * Weightage ' + (weight || '-') + '%';
                  }
                  // set initial tooltip text
                  $el.attr('data-tooltip', computeContent());
                  // avoid duplicate bindings
                  $el.off('mouseenter.scoretip').on('mouseenter.scoretip', function() {
                    $el.attr('data-tooltip', computeContent());
                  });
                  var $inp = $el.closest('tr').find('.input-actual');
                  $inp.off('input.scoretip change.scoretip').on('input.scoretip change.scoretip', function() {
                    $el.attr('data-tooltip', computeContent());
                  });
                });
              }

              // Load table data for selected person & month (approval view)
              function populateTableFromSelfApp(monthKeyVal) {
                if (!monthKeyVal) {
                  // if no month selected, just reset table to placeholder row
                  var $tbody = $('table.kpi-table tbody');
                  $tbody.html('<tr><td colspan="8" class="text-center text-muted py-4">Select month to view KPI data.</td></tr>');
                  updatePerformanceSummary();
                  refreshOverallChartFromTable();
                  refreshKpiTrendChart();
                  return;
                }

                // show loading spinner near MONTH label
                $('#monthLoading').removeClass('d-none');

                var emplno_select_User2 = $('#vehno option:selected').val();
                var datetime1 = monthKeyVal; // EFFECTFROM value from monthSelect

                $.ajax({
                  url: "{{ route('selfAppraiApp_TableDate') }}",
                  type: "GET",
                  data: {
                    emplno_select_User1: emplno_select_User2,
                    datetime: datetime1,
                  },
                  dataType: 'json',
                  success: function(cmb_Data) {
                    console.log('Approval grid data:', cmb_Data);

                    var data1 = cmb_Data.data ?? [];

                    // Map raw data into the shape expected by buildRow()
                    var rows = data1.map(function(d) {
                      return {
                        KPI_POINT: d.Kpi_point,
                        UOM: d.UOM,
                        Uom: d.UOM,
                        Target: d.Target,
                        ACTUAL: d.Actual,
                        Actual: d.Actual,
                        Actual_Value: d.Actual,
                        Weightage: d.Weightage,
                        Kpi_Id: d.KPI_POINT_ID,
                        Rowid: d.Rowid,
                        Kpi_Remarks: d.Kpi_Remarks,
                        Score: d.Score,
                        // Prefer Kpi_Type from API; fallback to Type
                        Type: (d.Kpi_Type || d.Type)
                      };
                    });

                    var html = '';
                    rows.forEach(function(r, idx) {
                      html += buildRow(idx, r);
                    });
                    var $tbody = $('table.kpi-table tbody');
                    $tbody.html(html);
                    initActualInfoTooltips();
                    if (typeof bindKpiInfoFloat === 'function') {
                      bindKpiInfoFloat();
                    }
                    wireScoreHandlers();
                    // initial summary after rows are rendered
                    updatePerformanceSummary();
                    // initialize custom tooltips for score column after rows are inserted
                    initScoreInfoTooltipsLegacy();
                    // sync charts with freshly loaded scores
                    refreshOverallChartFromTable();
                    refreshKpiTrendChart();
                  },
                  error: function(xhr) {
                    console.error('getdatatopassgrid fetch failed', xhr.status, xhr.responseText);
                  },
                  complete: function() {
                    // hide loading spinner when request completes
                    $('#monthLoading').addClass('d-none');
                  }
                });
              }

              // Month dropdown change -> load data for that month
              $('#monthSelect').on('change', function() {
                var val = $(this).val(); // already in format like "oct-2025"
                populateTableFromSelfApp(val);
              });

              // On initial load, force neutral state: no month selected, placeholder row, and 'Select month' summary
              $('#monthSelect').val('');
              populateTableFromSelfApp('');

              // KPI-wise Trend Analysis dropdowns -> update kpiChart
              function getKpiConfig(kpi, range) {
                // labels by range
                var labels = range === 'annual' ? ['2023', '2024', '2025'] : (range === 'half_yearly' ? ['H1 2025', 'H2 2025'] : ['Q1 2025', 'Q2 2025', 'Q3 2025', 'Q4 2025']);
                // sample data per KPI (0-10 range)
                var seriesMap = {
                  'Attrition': [8, 7, 6, 6],
                  'Absenteeism': [4, 5, 5, 4],
                  'Recruitment Strength': [9, 8, 8, 9],
                  'Audit Score': [9, 9, 8, 9],
                  '5S Audit Mark': [8, 8, 9, 9]
                };
                var data = seriesMap[kpi] || [6, 6, 6, 6];
                if (range === 'half_yearly') data = [data[0], data[3]];
                if (range === 'annual') data = [data[0], data[2] || data[1], data[3] || data[2]];
                return {
                  labels,
                  data,
                  title: kpi + ' - ' + (range === 'annual' ? 'Annual' : (range === 'half_yearly' ? 'Half Yearly' : 'Quarterly'))
                };
              }

              function updateKpiChart() {
                refreshKpiTrendChart();
                // update title to reflect current KPI and range
                var kpi = $('#kpiSelect').val();
                var range = $('#kpiRange').val();
                var rangeLabel = (range === 'annual' ? 'Annual' : (range === 'half_yearly' ? 'Half Yearly' : (range === 'quarterly' ? 'Quarterly' : 'Monthly')));
                $('#kpiRangeTitle').text((kpi || 'KPI') + ' - ' + rangeLabel);
              }

              $('#kpiSelect, #kpiRange').on('change', updateKpiChart);

              // Populate KPI dropdown dynamically from KPI trend API
              function populateKpiDropdownFromApi() {
                var $ddl = $('#kpiSelect');
                if (!$ddl.length) return;

                // Use same fiscal window as charts
                var today = new Date();
                var currentMonth = today.getMonth() + 1;
                var currentYear = today.getFullYear();
                var fiscalStartYear = currentMonth >= 4 ? currentYear : currentYear - 1;
                var fromdate = fiscalStartYear + '-04-01';
                var enddate = (fiscalStartYear + 1) + '-04-01';

                var params = {
                  empid: ($('#vehno').val() || @json(Session::get('empl_id'))),
                  fromdate: fromdate,
                  enddate: enddate
                };

                $.getJSON("{{ route('kpiinfokeyperformace') }}", params)
                  .done(function(res) {
                    var rows = [];
                    if (Array.isArray(res)) rows = res;
                    else if (res && Array.isArray(res.data)) rows = res.data;
                    else if (res && Array.isArray(res.results)) rows = res.results;

                    if (!rows.length) return;

                    var seen = {};
                    var options = [];
                    rows.forEach(function(r) {
                      var name = (r.KPI_Point || r.KPI_POINT || '').toString();
                      if (!name) return;
                      var key = name.toLowerCase();
                      if (seen[key]) return;
                      seen[key] = true;
                      options.push(name);
                    });

                    if (!options.length) return;

                    var current = $ddl.val();
                    var html = '';
                    options.forEach(function(name, idx) {
                      var sel = (current && current.toLowerCase() === name.toLowerCase()) || (!current && idx === 0) ? ' selected' : '';
                      html += '<option value="' + name + '"' + sel + '>' + name + '</option>';
                    });
                    $ddl.html(html);

                    // After populating, sync chart/title to current selection
                    updateKpiChart();
                  });
              }

              // initialize title, data, and dropdown from API
              populateKpiDropdownFromApi();

              function refreshChartsForCurrentPerson() {
                populateKpiDropdownFromApi();
                refreshOverallChartFromTable();
                renderKpiSummaryTable();
              }

              // Performance Charts dropdown -> update Overall chart
              function getOverallConfig(range) {
                switch (range) {
                  case 'month_to_date':
                    return {
                      title: 'Month to Date', labels: ['W1', 'W2', 'W3', 'W4'], data: [62, 64, 65, 66]
                    };
                  case 'month_to_quarter':
                    return {
                      title: 'Month to Quarter', labels: ['Q1 2025', 'Q2 2025', 'Q3 2025', 'Q4 2025'], data: [70, 68, 66, 64]
                    };
                  case 'month_to_half_yearly':
                    return {
                      title: 'Month to Half Yearly', labels: ['H1 2025', 'H2 2025'], data: [69, 67]
                    };
                  case 'month_to_annual':
                    return {
                      title: 'Month to Annual', labels: ['2023', '2024', '2025'], data: [72, 70, 68]
                    };
                  default:
                    return {
                      title: 'Month to Quarter', labels: ['Q1 2025', 'Q2 2025', 'Q3 2025', 'Q4 2025'], data: [70, 68, 66, 64]
                    };
                }
              }

              $('#overallRange').on('change', function() {
                var cfg = getOverallConfig(this.value);
                $('#overallRangeTitle').text(cfg.title);
                // data points come from table scores; just refresh series
                refreshOverallChartFromTable();
              });

              // KPI API Summary table (same API used for charts)
              function renderKpiSummaryTable() {
                var $card = $('#kpiSummaryCard');
                if (!$card.length) return;

                // Use same fiscal year window as charts: Apr (FY start) to next Apr
                var today = new Date();
                var currentMonth = today.getMonth() + 1;
                var currentYear = today.getFullYear();
                var fiscalStartYear = currentMonth >= 4 ? currentYear : currentYear - 1;
                var fromdate = fiscalStartYear + '-04-01';
                var enddate = (fiscalStartYear + 1) + '-04-01';

                var params = {
                  empid: ($('#vehno').val() || @json(Session::get('empl_id'))),
                  fromdate: fromdate,
                  enddate: enddate
                };

                $.getJSON("{{ route('kpiinfokeyperformace') }}", params)
                  .done(function(res) {
                    var rows = [];
                    if (Array.isArray(res)) rows = res;
                    else if (res && Array.isArray(res.data)) rows = res.data;
                    else if (res && Array.isArray(res.results)) rows = res.results;

                    if (!rows.length) {
                      $card.html('<div class="card-body py-3 text-muted small">No KPI summary data available.</div>');
                      return;
                    }

                    var monthShort = ['Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec', 'Jan', 'Feb', 'Mar'];
                    var headerMonths = [];
                    for (var i = 0; i < monthShort.length; i++) {
                      headerMonths.push(monthShort[i]);
                    }

                    var html = '';
                    // Header bar to match other chart sections
                    html += '<div class="px-4 py-3 border-bottom d-flex align-items-center justify-content-between bg-dark text-white rounded-top">';
                    html += '<h3 class="h6 fw-semibold mb-0 text-white">KPI Summary</h3>';
                    html += '</div>';

                    html += '<div class="card-body">';
                    html += '<div class="d-flex justify-content-between align-items-center mb-2">';
                    html += '<div class="small text-muted">Fiscal Year ' + fiscalStartYear + '-' + (fiscalStartYear + 1).toString().slice(-2) + '</div>';
                    html += '</div>';
                    html += '<div class="table-responsive">';
                    html += '<table class="table table-sm table-bordered align-middle mb-0">';
                    html += '<thead class="table-light">';
                    html += '<tr>';
                    html += '<th style="min-width:220px;">KPI</th>';
                    headerMonths.forEach(function(m) {
                      html += '<th class="text-center">' + m + '</th>';
                    });
                    html += '</tr>';
                    html += '</thead>';
                    html += '<tbody>';

                    rows.forEach(function(r) {
                      var name = (r.KPI_Point || r.KPI_POINT || '').toString();
                      if (!name) return;

                      html += '<tr>';
                      html += '<td class="fw-semibold">' + name + '</td>';

                      // Map Apr-Sep/Oct-Nov etc using same key pattern as charts
                      var keyOrder = ['Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec', 'Jan', 'Feb', 'Mar'];
                      keyOrder.forEach(function(mon) {
                        var year = (['Jan', 'Feb', 'Mar'].indexOf(mon) >= 0) ? (fiscalStartYear + 1) : fiscalStartYear;
                        var key = mon + '_' + year;
                        var val = r.hasOwnProperty(key) ? r[key] : '';
                        html += '<td class="text-center small">' + (val === null || typeof val === 'undefined' ? '' : val) + '</td>';
                      });

                      html += '</tr>';
                    });

                    html += '</tbody>';
                    html += '</table>';
                    html += '</div>';
                    html += '</div>';

                    $card.html(html);
                  })
                  .fail(function() {
                    $card.html('<div class="card-body py-3 text-muted small">Unable to load KPI summary data.</div>');
                  });
              }


              // Normalize overall rating card on initial load (e.g., when no month is selected)
              if (typeof updatePerformanceSummary === 'function') {
                updatePerformanceSummary();
              }

              // Handle CDC Self Appraisal Approve button click (form post to cdc_KpiApproval_new)
              $('#selfAppSaveBtn').on('click', function() {
                var hasError = false;

                // clear previous validation styles
                $('table.kpi-table tbody .input-actual, table.kpi-table tbody .remarks-input').removeClass('is-invalid');

                $('table.kpi-table tbody tr').each(function() {
                  var $row = $(this);
                  var $inp = $row.find('.input-actual').first();
                  var actualV = $.trim($inp.val());
                  var remark = $.trim($row.find('input[name="userremark1[]"]').val() || '');
                  var isReadOnly = $inp.prop('readonly') || $inp.hasClass('input-actual-auto');

                  // Actual required only for editable fields
                  if (!isReadOnly && actualV === '') {
                    hasError = true;
                    $inp.addClass('is-invalid');
                  }

                  // HOD remark required
                  if (remark === '') {
                    hasError = true;
                    $row.find('input[name="userremark1[]"]').addClass('is-invalid');
                  }
                });

                if (hasError) {
                  if (window.toastr) {
                    toastr.error('Please fill all required fields (Actual and HOD Remarks) before approving.', 'Required');
                  } else {
                    alert('Please fill all required fields (Actual and HOD Remarks) before approving.');
                  }
                  return;
                }

                if ($('table.kpi-table tbody tr').length === 0) {
                  alert('No KPI rows to save.');
                  return;
                }

                // Build payload from current table rows
                var payload = {
                  options123: ($('#vehno').val() || ''), // person
                  options1345: ($('#monthSelect').val() || ''), // month
                  userdes1: [],
                  userRowid1: [],
                  usertarget1: [],
                  useract1: [],
                  userincpoint1: [],
                  userremark1: []
                };

                $('table.kpi-table tbody tr').each(function() {
                  var $row = $(this);
                  var kpi = $.trim($row.find('input[name="userdes1[]"]').val() || $row.find('td').eq(1).text());
                  var rowId = $.trim($row.find('input[name="userRowid1[]"]').val() || $row.data('rowid') || '');
                  var target = $.trim($row.find('input[name="usertarget1[]"]').val() || $row.find('.pill-light').first().text());
                  var act = $.trim($row.find('input[name="useract1[]"]').val() || $row.find('.input-actual').first().val());
                  var score = $.trim($row.find('input[name="userincpoint1[]"]').val() || $row.find('.score-badge').first().text());
                  var hodRm = $.trim($row.find('input[name="userremark1[]"]').val() || '');

                  if (rowId) {
                    payload.userdes1.push(kpi);
                    payload.userRowid1.push(rowId);
                    payload.usertarget1.push(target);
                    payload.useract1.push(act);
                    payload.userincpoint1.push(score);
                    payload.userremark1.push(hodRm);
                  }
                });

                // Require person and month
                if (!payload.options123 || !payload.options1345) {
                  if (window.toastr) {
                    toastr.error('Please select Person and Month before approving.', 'Required');
                  } else {
                    alert('Please select Person and Month before approving.');
                  }
                  return;
                }

                // Post to approval endpoint and show toaster
                $.ajax({
                  url: "{{ url('SelF_Apprai_App_Save') }}",
                  type: 'GET',
                  data: $.extend({
                    _token: '{{ csrf_token() }}'
                  }, payload),
                  success: function(res) {
                    if (window.toastr) {
                      var msg = (res && (res.message || res.status)) ? (res.message || 'Approved') : 'Approved successfully';
                      toastr.success(msg, 'Success');
                    } else {
                      alert('Approved successfully');
                    }
                    // Reload after a short delay so user can see the toast
                    setTimeout(function() {
                      window.location.reload();
                    }, 1000);
                  },
                  error: function(xhr) {
                    if (window.toastr) {
                      toastr.error('Approval failed. Please try again.', 'Error');
                    } else {
                      alert('Approval failed. Please try again.');
                    }
                    try {
                      console.error('Approval error', xhr.status, xhr.responseText);
                    } catch (e) {}
                  }
                });
              });

              function chartOptions(color, label, fillGradient) {
                return {
                  maintainAspectRatio: false,
                  responsive: true,
                  layout: {
                    padding: {
                      left: 8,
                      right: 8,
                      top: 8,
                      bottom: 8
                    }
                  },
                  plugins: {
                    legend: {
                      display: true,
                      position: 'bottom',
                      align: 'center',
                      labels: {
                        usePointStyle: true,
                        pointStyle: 'circle',
                        padding: 16
                      }
                    },
                    tooltip: {
                      mode: 'index',
                      intersect: false
                    },
                    title: {
                      display: false
                    }
                  },
                  scales: {
                    x: {
                      grid: {
                        color: 'rgba(0,0,0,0.08)'
                      },
                      ticks: {
                        color: '#6b7280'
                      }
                    },
                    y: {
                      beginAtZero: true,
                      grid: {
                        color: 'rgba(0,0,0,0.08)'
                      },
                      ticks: {
                        color: '#6b7280'
                      }
                    }
                  },
                  elements: {
                    line: {
                      tension: 0.35,
                      borderWidth: 2,
                      borderColor: color
                    },
                    point: {
                      radius: 0,
                      hoverRadius: 5,
                      backgroundColor: color,
                      borderColor: color
                    }
                  },
                  datasets: {
                    line: {
                      fill: true,
                      backgroundColor: fillGradient || color
                    }
                  }
                };
              }

              // Destroy any previous instances to avoid height growth on re-inits
              // Total Score donut ring chart: one colored slice (score) and one gray slice (remaining)
              if (window.totalScoreRingInstance) {
                try {
                  window.totalScoreRingInstance.destroy();
                } catch (e) {}
              }
              window.totalScoreRingInstance = new Chart(ctxRing, {
                type: 'doughnut',
                data: {
                  labels: ['Score', 'Remaining'],
                  datasets: [{
                    data: [0, 100],
                    backgroundColor: ['#22c55e', 'rgba(148,163,184,0.20)'],
                    borderWidth: 0,
                    // Pop the score slice out slightly
                    offset: function(ctx) {
                      return ctx.dataIndex === 0 ? 6 : 0;
                    }
                  }]
                },
                options: {
                  cutout: '65%',
                  plugins: {
                    legend: {
                      display: false
                    },
                    tooltip: {
                      enabled: true,
                      callbacks: {
                        label: function(ctx) {
                          var v = window.totalScoreValue || 0;

                          // Slice 0: actual score band
                          if (ctx.dataIndex === 0) {
                            var bandText;
                            if (v <= 20) bandText = '0-20: Poor';
                            else if (v <= 40) bandText = '21-40: Below Average';
                            else if (v <= 60) bandText = '41-60: Average';
                            else if (v <= 79) bandText = '61-79: Good';
                            else bandText = '80-100: Excellent';
                            return Math.round(v) + '% - ' + bandText;
                          }

                          // Slice 1: remaining
                          var rem = 100 - v;
                          return Math.round(rem) + '% Remaining';
                        }
                      }
                    }
                  }
                }
              });

              // Build gradients for stacked multi-KPI overall chart (Apr–Oct)
              var ctx1g = ctx1.getContext('2d');
              var grad5s = ctx1g.createLinearGradient(0, 0, 0, ctx1.height || 200); // bottom green band
              grad5s.addColorStop(0, 'rgba(16,185,129,0.25)');
              grad5s.addColorStop(1, 'rgba(16,185,129,0.65)');

              var gradAbs = ctx1g.createLinearGradient(0, 0, 0, ctx1.height || 200); // soft purple line near x-axis
              gradAbs.addColorStop(0, 'rgba(129,140,248,0.15)');
              gradAbs.addColorStop(1, 'rgba(129,140,248,0.35)');

              var gradAttr = ctx1g.createLinearGradient(0, 0, 0, ctx1.height || 200); // orange hump
              gradAttr.addColorStop(0, 'rgba(249,115,22,0.75)');
              gradAttr.addColorStop(1, 'rgba(249,115,22,0.05)');

              var gradAudit = ctx1g.createLinearGradient(0, 0, 0, ctx1.height || 200); // light lime
              gradAudit.addColorStop(0, 'rgba(190,242,100,0.6)');
              gradAudit.addColorStop(1, 'rgba(190,242,100,0.1)');

              var gradRecruit = ctx1g.createLinearGradient(0, 0, 0, ctx1.height || 200); // blue line at top
              gradRecruit.addColorStop(0, 'rgba(59,130,246,0.35)');
              gradRecruit.addColorStop(1, 'rgba(59,130,246,0.05)');

              if (window.overallChartInstance) {
                try {
                  window.overallChartInstance.destroy();
                } catch (e) {}
              }
              window.overallChartInstance = new Chart(ctx1, {
                type: 'line',
                data: {
                  labels: ['Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct'],
                  datasets: [{
                      label: '5S Audit Mark',
                      data: [8, 8, 8, 8, 8, 8, 8],
                      borderColor: 'rgba(16,185,129,1)',
                      backgroundColor: grad5s,
                      fill: true,
                      order: 1
                    },
                    {
                      label: 'Absenteeism',
                      data: [1, 2, 3, 3, 1, 2, 1],
                      borderColor: 'rgba(129,140,248,1)',
                      backgroundColor: gradAbs,
                      fill: true,
                      order: 2
                    },
                    {
                      label: 'Attrition',
                      data: [0, 10, 25, 25, 0, 28, 0],
                      borderColor: 'rgba(239,68,68,1)',
                      backgroundColor: gradAttr,
                      fill: true,
                      order: 3
                    },
                    {
                      label: 'Audit Score',
                      data: [30, 32, 35, 33, 36, 37, 40],
                      borderColor: 'rgba(234,179,8,1)',
                      backgroundColor: gradAudit,
                      fill: true,
                      order: 4
                    },
                    {
                      label: 'Recruitment Strength',
                      data: [34, 34, 36, 35, 37, 38, 40],
                      borderColor: 'rgba(59,130,246,1)',
                      backgroundColor: gradRecruit,
                      fill: true,
                      order: 5
                    }
                  ]
                },
                options: Object.assign({}, chartOptions('#f97316', 'KPI Trend', null), {
                  scales: {
                    x: {
                      grid: {
                        color: 'rgba(148,163,184,0.2)'
                      },
                      ticks: {
                        color: '#6b7280'
                      }
                    },
                    y: {
                      beginAtZero: true,
                      min: 0,
                      max: 40,
                      ticks: {
                        stepSize: 10,
                        color: '#9ca3af'
                      },
                      grid: {
                        color: 'rgba(148,163,184,0.2)'
                      }
                    }
                  },
                  plugins: {
                    legend: {
                      display: false,
                      position: 'bottom'
                    }
                  }
                })
              });

              // Gradient for KPI-wise Trend area (orange band on top of soft green base)
              var kpiGrad = ctx2.getContext('2d').createLinearGradient(0, 0, 0, ctx2.height || 200);
              kpiGrad.addColorStop(0, 'rgba(249,115,22,0.65)'); // bright orange top
              kpiGrad.addColorStop(0.5, 'rgba(249,186,90,0.45)'); // warm middle
              kpiGrad.addColorStop(1, 'rgba(16,185,129,0.35)'); // soft green bottom

              if (window.kpiChartInstance) {
                try {
                  window.kpiChartInstance.destroy();
                } catch (e) {}
              }
              window.kpiChartInstance = new Chart(ctx2, {
                type: 'line',
                data: {
                  labels: ['Q1 2025', 'Q2 2025', 'Q3 2025', 'Q4 2025'],
                  datasets: [{
                    label: 'Attrition',
                    data: [80, 75, 70, 65],
                    borderColor: '#f97316',
                    backgroundColor: kpiGrad,
                    fill: true
                  }]
                },
                options: Object.assign({}, chartOptions('#f97316', 'Attrition', kpiGrad), {
                  scales: {
                    x: {
                      grid: {
                        color: 'rgba(0,0,0,0.08)'
                      },
                      ticks: {
                        color: '#6b7280'
                      }
                    },
                    y: {
                      beginAtZero: true,
                      min: 0,
                      max: 100,
                      ticks: {
                        stepSize: 20,
                        color: '#6b7280'
                      },
                      grid: {
                        color: 'rgba(0,0,0,0.08)'
                      }
                    }
                  }
                })
              });

              // Initial render of KPI summary table once charts and handlers are set up
              renderKpiSummaryTable();

            });

            $(document).ready(function() {
              $('#tabCharts').on('click', function() {
                $('#tableSection').addClass('d-none');
                $('#chartSection').removeClass('d-none');

                $('#tabCharts').removeClass('btn-light shadow-sm').addClass('btn-primary text-white shadow-sm');
                $('#tabTable').removeClass('btn-primary text-white shadow-sm').addClass('btn-light shadow-sm');
              });

              $('#tabTable').on('click', function() {
                $('#chartSection').addClass('d-none');
                $('#tableSection').removeClass('d-none');

                $('#tabTable').removeClass('btn-light shadow-sm').addClass('btn-primary text-white shadow-sm');
                $('#tabCharts').removeClass('btn-primary text-white shadow-sm').addClass('btn-light shadow-sm');
              });

              // Helper: map an Actual value to a rating (0-100) using the same scale as the KPI popup
              function getRatingFromScale(kpi, actualVal) {
                var name = (kpi || 'KPI').toLowerCase();
                var v = parseFloat(actualVal);
                if (isNaN(v)) return '';

                // Absenteeism
                if (name === 'absenteeism') {
                  if (v >= 0 && v <= 10) return 100;
                  if (v > 10 && v <= 12) return 90;
                  if (v >= 13 && v <= 14) return 80;
                  if (v >= 15 && v <= 16) return 70;
                  if (v > 17) return 0;
                  return '';
                }

                // Recruitment Strength
                if (name === 'recruitment strength' || name === 'recruitment_strength') {
                  if (v >= 95 && v <= 100) return 100;
                  if (v >= 80 && v <= 94) return 90;
                  if (v >= 75 && v <= 79) return 80;
                  if (v >= 70 && v <= 74) return 70;
                  if (v >= 0 && v < 70) return 0;
                  return '';
                }

                // 5S Audit Mark
                if (name === '5s audit mark' || name === '5s' || name === '5s audit') {
                  if (v >= 95 && v <= 100) return 100;
                  if (v >= 80 && v <= 94) return 90;
                  if (v >= 75 && v <= 79) return 80;
                  if (v >= 70 && v <= 74) return 70;
                  if (v >= 0 && v < 70) return 0;
                  return '';
                }

                // Default numeric scale (e.g., Attrition screenshot):
                // 0-5 -> 100, 6-7 -> 90, 7-9 -> 80, >10 -> 70
                if (v >= 0 && v <= 5) return 100;
                if (v > 5 && v <= 7) return 90;
                if (v > 7 && v <= 9) return 80;
                if (v > 10) return 70;
                return '';
              }

              // Initialize Bootstrap 5 popovers on exclaim icons
              function buildPopoverContent(kpi) {
                var name = (kpi || 'KPI').toLowerCase();
                // Define per-KPI scales
                var items;
                if (name === 'absenteeism') {
                  items = [{
                      dot: 'bg-success',
                      range: '0-10',
                      label: 'Excellent',
                      count: 100,
                      colorClass: 'text-success'
                    },
                    {
                      dot: '',
                      range: '10-12',
                      label: 'Good',
                      count: 90,
                      colorStyle: 'color:#b36ba4',
                      dotStyle: 'background:#b36ba4'
                    },
                    {
                      dot: '',
                      range: '13-14',
                      label: 'Average',
                      count: 80,
                      colorStyle: 'color:#fb923c',
                      dotStyle: 'background:#fb923c'
                    },
                    {
                      dot: '',
                      range: '15-16',
                      label: 'Poor',
                      count: 70,
                      colorStyle: 'color:#ef4444',
                      dotStyle: 'background:#ef4444'
                    },
                    {
                      dot: '',
                      range: '>17',
                      label: 'Very Poor',
                      count: 0,
                      colorClass: 'text-muted',
                      dotStyle: 'background:#94a3b8'
                    }
                  ];
                } else if (name === 'recruitment strength' || name === 'recruitment_strength') {
                  items = [{
                      dot: 'bg-success',
                      range: '95-100',
                      label: 'Excellent',
                      count: 100,
                      colorClass: 'text-success'
                    },
                    {
                      dot: '',
                      range: '80-94',
                      label: 'Good',
                      count: 90,
                      colorStyle: 'color:#b36ba4',
                      dotStyle: 'background:#b36ba4'
                    },
                    {
                      dot: '',
                      range: '75-79',
                      label: 'Average',
                      count: 80,
                      colorStyle: 'color:#fb923c',
                      dotStyle: 'background:#fb923c'
                    },
                    {
                      dot: '',
                      range: '70-74',
                      label: 'Poor',
                      count: 70,
                      colorStyle: 'color:#ef4444',
                      dotStyle: 'background:#ef4444'
                    },
                    {
                      dot: '',
                      range: '0-69',
                      label: 'Very Poor',
                      count: 0,
                      colorClass: 'text-muted',
                      dotStyle: 'background:#94a3b8'
                    }
                  ];
                } else if (name === 'audit score' || name === 'audit_score') {
                  items = [{
                      dot: 'bg-success',
                      range: 'A',
                      label: 'Excellent',
                      count: 100,
                      colorClass: 'text-success'
                    },
                    {
                      dot: '',
                      range: 'B',
                      label: 'Very good',
                      count: 100,
                      colorStyle: 'color:#0d6efd',
                      dotStyle: 'background:#0d6efd'
                    },
                    {
                      dot: '',
                      range: 'C and above',
                      label: 'Very Poor',
                      count: 0,
                      colorClass: 'text-muted',
                      dotStyle: 'background:#6c757d'
                    }
                  ];
                } else if (name === '5s audit mark' || name === '5s' || name === '5s audit') {
                  items = [{
                      dot: 'bg-success',
                      range: '95-100',
                      label: 'Excellent',
                      count: 100,
                      colorClass: 'text-success'
                    },
                    {
                      dot: '',
                      range: '80-94',
                      label: 'Good',
                      count: 90,
                      colorStyle: 'color:#b36ba4',
                      dotStyle: 'background:#b36ba4'
                    },
                    {
                      dot: '',
                      range: '75-79',
                      label: 'Average',
                      count: 80,
                      colorStyle: 'color:#fb923c',
                      dotStyle: 'background:#fb923c'
                    },
                    {
                      dot: '',
                      range: '70-74',
                      label: 'Poor',
                      count: 70,
                      colorStyle: 'color:#94a3b8',
                      dotStyle: 'background:#94a3b8'
                    },
                    {
                      dot: '',
                      range: '0-69',
                      label: 'Very Poor',
                      count: 0,
                      colorClass: 'text-muted',
                      dotStyle: 'background:#94a3b8'
                    }
                  ];
                } else {
                  // Default scale
                  items = [{
                      dot: 'bg-success',
                      range: '0-5',
                      label: 'Excellent',
                      count: 100,
                      colorClass: 'text-success'
                    },
                    {
                      dot: '',
                      range: '6-7',
                      label: 'Good',
                      count: 90,
                      colorStyle: 'color:#b36ba4',
                      dotStyle: 'background:#b36ba4'
                    },
                    {
                      dot: '',
                      range: '7-9',
                      label: 'Average',
                      count: 80,
                      colorStyle: 'color:#fb923c',
                      dotStyle: 'background:#fb923c'
                    },
                    {
                      dot: '',
                      range: '>10',
                      label: 'Poor',
                      count: 70,
                      colorStyle: 'color:#ef4444',
                      dotStyle: 'background:#ef4444'
                    }
                  ];
                }

                var html = '<div class="kpi-scale">' +
                  '<div class="fw-semibold mb-2">' + (kpi || 'KPI') + ' - Rating Scale:</div>' +
                  '<div class="list-group">';
                items.forEach(function(it) {
                  var dotClass = 'dot ' + (it.dot || '');
                  var dotStyle = it.dotStyle ? (' style="' + it.dotStyle + '"') : '';
                  var rightClass = it.colorClass || '';
                  var rightStyle = it.colorStyle ? (' style="' + it.colorStyle + '"') : '';
                  html += '<div class="list-group-item">' +
                    '<div class="flex-grow-1">' +
                    '<span class="' + dotClass + '"' + dotStyle + '></span>' +
                    '<span class="ms-2 range">' + it.range + '</span>' +
                    '<div class="meta">Ratings: ' + (it.count != null ? it.count : '—') + '</div>' +
                    '</div>' +
                    '<div class="' + rightClass + '"' + rightStyle + '>' + it.label + '</div>' +
                    '</div>';
                });
                html += '</div></div><div class="text-center mt-1" style="font-size:11px">&#9670;</div>';
                return html;
              }

              // KPI info icon: custom floating panel (no Bootstrap)
              var $kpiPanel = window.$kpiPanel || $('<div id="kpi-float-panel" class="kpi-float"></div>').appendTo('body');
              window.$kpiPanel = $kpiPanel;

              function positionKpiPanel($target) {
                var off = $target.offset();
                var tw = $target.outerWidth();
                var th = $target.outerHeight();
                var pw = $kpiPanel.outerWidth();
                var ph = $kpiPanel.outerHeight();
                var top = off.top - ph - 12; // above with small gap
                var left = off.left + (tw / 2) - (pw / 2);
                // clamp within viewport
                var vw = $(window).width();
                if (left < 8) left = 8;
                if (left + pw > vw - 8) left = vw - pw - 8;
                if (top < 8) top = off.top + th + 12; // if not enough space above, show below
                $kpiPanel.css({
                  top: top,
                  left: left
                });
              }
              var hideTimer;

              function setupDelegatedKpiInfo() {
                $(document)
                  .off('mouseenter.kpifocus', '.kpi-info')
                  .off('focus.kpifocus', '.kpi-info')
                  .off('mouseleave.kpifocus', '.kpi-info')
                  .off('blur.kpifocus', '.kpi-info')
                  .on('mouseenter.kpifocus focus.kpifocus', '.kpi-info', function() {
                    clearTimeout(hideTimer);
                    var $icon = $(this);
                    var kpi = $icon.attr('data-kpi') || 'KPI';
                    var $row = $icon.closest('tr');
                    var kpiId = $icon.data('kpiid') || $row.data('kpiid') || '';

                    // show loading state first
                    $kpiPanel.html('<div class="kpi-scale"><div class="fw-semibold mb-2">' + kpi + ' - Rating Scale:</div><div class="text-muted small">Loading...</div></div>').show();
                    positionKpiPanel($icon);

                    if (!kpiId) {
                      // fallback to static content if KPI_ID missing
                      var fallback = buildPopoverContent(kpi);
                      $kpiPanel.html(fallback);
                      positionKpiPanel($icon);
                      return;
                    }

                    // Fetch KPI range/score info for this KPI_ID via AJAX
                    $.get("{{ route('KPI_MasterReportNewDtl') }}", {
                        id: kpiId
                      })
                      .done(function(res) {
                        try {
                          var ranges = (res && res.RangeScore) ? res.RangeScore : [];
                          if (!Array.isArray(ranges) || !ranges.length) {
                            $kpiPanel.html(buildPopoverContent(kpi));
                            positionKpiPanel($icon);
                            return;
                          }

                          var html = '<div class="kpi-scale">';
                          html += '<div class="fw-semibold mb-2">' + kpi + ' - Rating Scale:</div>';
                          html += '<div class="list-group">';
                          var rangeRow = null,
                            scoreRow = null;
                          var isAttrition = (kpi || '').toString().toLowerCase() === 'attrition';

                          ranges.forEach(function(r) {
                            var t = (r.Type || '').toString().toLowerCase();
                            if (t === 'range') rangeRow = r;
                            else if (t === 'score') scoreRow = r;
                          });
                          for (var i = 1; i <= 6; i++) {
                            var colKey = 'Col' + i;
                            var rangeText = rangeRow && rangeRow[colKey] ? rangeRow[colKey].toString() : '';
                            var scoreText = scoreRow && scoreRow[colKey] ? scoreRow[colKey].toString() : '';
                            if (!rangeText && !scoreText) continue;
                            var scoreNum = parseFloat(scoreText);
                            var dotColor = '#22c55e';
                            var label = 'Excellent';
                            var labelColor = '#16a34a';
                            if (!isNaN(scoreNum)) {
                              if (scoreNum >= 100) { // 100
                                dotColor = '#22c55e';
                                label = 'Excellent';
                                labelColor = '#16a34a';
                              } else if (scoreNum >= 90) { // 90
                                dotColor = '#b36ba4';
                                label = 'Good';
                                labelColor = '#b36ba4';
                              } else if (scoreNum >= 80) { // 80
                                dotColor = '#fb923c';
                                label = 'Average';
                                labelColor = '#fb923c';
                              } else if (!isAttrition && scoreNum >= 70) { // 70-range -> Below Average (gray)
                                dotColor = '#94a3b8';
                                label = 'Below Avg';
                                labelColor = '#94a3b8';
                              } else { // remaining -> Poor (red)
                                dotColor = '#ef4444';
                                label = 'Poor';
                                labelColor = '#ef4444';
                              }
                            }
                            html += '<div class="list-group-item">';
                            html += '<div class="d-flex align-items-center">';
                            html += '<div class="d-flex align-items-center flex-grow-1">';
                            html += '<span class="dot" style="background:' + dotColor + '"></span>';
                            html += '<span class="ms-2 range">' + rangeText + '</span>';
                            html += '</div>';
                            html += '<div class="text-center" style="min-width:90px;color:' + labelColor + ';font-weight:600;">' + label + '</div>';
                            html += '<div class="ms-auto text-muted" style="font-size:12px;">Ratings: ' + (scoreText || '-') + '</div>';
                            html += '</div>';
                            html += '</div>';
                          }
                          html += '</div></div><div class="text-center mt-1" style="font-size:11px">&#9670;</div>';
                          $kpiPanel.html(html);
                          positionKpiPanel($icon);
                        } catch (e) {
                          $kpiPanel.html(buildPopoverContent(kpi));
                          positionKpiPanel($icon);
                        }
                      })
                      .fail(function() {
                        $kpiPanel.html(buildPopoverContent(kpi));
                        positionKpiPanel($icon);
                      });
                  })
                  .on('mouseleave.kpifocus blur.kpifocus', '.kpi-info', function() {
                    hideTimer = setTimeout(function() {
                      $kpiPanel.hide();
                    }, 150);
                  });
              }
              // Keep panel open when hovering the panel itself; hide when leaving
              $kpiPanel.on('mouseenter', function() {
                clearTimeout(hideTimer);
              }).on('mouseleave', function() {
                $kpiPanel.hide();
              });
              setupDelegatedKpiInfo();
              // Actual info: delegated tooltip setup for dynamic rows + per-KPI formula from KPI_MasterReportNewDtl
              var kpiFormulaCache = {};

              function setupDelegatedActualInfo() {
                $(document)
                  .off('mouseenter.actinfo', '.actual-info')
                  .on('mouseenter.actinfo', '.actual-info', function() {
                    var $icon = $(this);
                    var $row = $icon.closest('tr');
                    var kpiId = $.trim($row.find('.input-actual').first().data('kpiid') || '');
                    if (!kpiId) {
                      // No KPI id -> nothing to fetch, clear tooltip
                      $icon.addClass('has-tooltip').attr('data-tooltip', '').removeAttr('title');
                      return;
                    }

                    // If formula already cached, use it immediately
                    if (kpiFormulaCache[kpiId] && kpiFormulaCache[kpiId] !== 'loading') {
                      var formula = kpiFormulaCache[kpiId];
                      var fullText = formula || '';
                      $icon.addClass('has-tooltip').attr('data-tooltip', fullText).removeAttr('title');
                      return;
                    }

                    // Otherwise, mark as loading and fetch from API
                    kpiFormulaCache[kpiId] = 'loading';
                    $icon.addClass('has-tooltip').attr('data-tooltip', 'Loading formula...').removeAttr('title');

                    $.get("{{ route('KPI_MasterReportNewDtl') }}", {
                        id: kpiId
                      })
                      .done(function(res) {
                        try {
                          var ranges = (res && res.RangeScore) ? res.RangeScore : [];
                          var formulaText = '';
                          if (Array.isArray(ranges) && ranges.length) {
                            ranges.forEach(function(r) {
                              var t = (r.Type || '').toString().toLowerCase();
                              if (t === 'formula') {
                                if (r.Col1) formulaText = r.Col1.toString();
                                else if (r.Col2) formulaText = r.Col2.toString();
                                else if (r.Col3) formulaText = r.Col3.toString();
                                else if (r.Col4) formulaText = r.Col4.toString();
                                else if (r.Col5) formulaText = r.Col5.toString();
                                else if (r.Col6) formulaText = r.Col6.toString();
                              }
                            });
                          }
                          // If no formula returned, show 'No data'
                          var finalText = formulaText && formulaText.trim().length ? formulaText : 'No data';
                          kpiFormulaCache[kpiId] = finalText;
                          var fullText = finalText;
                          $icon.attr('data-tooltip', fullText);
                        } catch (e) {
                          kpiFormulaCache[kpiId] = 'No data';
                          $icon.attr('data-tooltip', 'No data');
                        }
                      })
                      .fail(function() {
                        kpiFormulaCache[kpiId] = 'No data';
                        $icon.attr('data-tooltip', 'No data');
                      });
                  });
              }
              setupDelegatedActualInfo();
              // Your Score column: lightweight tooltip (legacy-friendly)
              $('.score-info').each(function() {
                var el = this;
                $(el).addClass('has-tooltip');

                function computeContent() {
                  var $row = $(el).closest('tr');
                  var weight = $.trim($row.find('.pill-badge').first().text());
                  var actual = $.trim($row.find('.input-actual').val());
                  var kpiTitle = $.trim($row.find('.kpi-info').first().data('kpi') || $row.find('td').eq(1).text());
                  var ratingVal = getRatingFromScale(kpiTitle, actual);
                  var displayRating = (ratingVal === '' || ratingVal == null) ? '-' : ratingVal;
                  return 'Ratings: ' + displayRating + ' * Weightage ' + (weight || '-') + '%';
                }
                // initial text
                $(el).attr('data-tooltip', computeContent());
                // update on hover and when the row's actual changes
                $(el).on('mouseenter', function() {
                  $(el).attr('data-tooltip', computeContent());
                });
                $(el).closest('tr').find('.input-actual').on('input change', function() {
                  $(el).attr('data-tooltip', computeContent());
                });
              });
            });
          </script>
          <script>
            const approvalFacade = @json(Session::get('approval'));
            const approvalHelper = @json(session('approval'));
            const approvalDerived = @json(isset($appr) ? $appr : null);
            console.log("Approval (Session facade):", approvalFacade);
            console.log("Approval (session helper):", approvalHelper);
            console.log("Approval (derived $appr):", approvalDerived);
            console.log('kpiResults count:', {
              {
                isset($kpiResults) && is_array($kpiResults) ? count($kpiResults) : 0
              }
            });
            console.log('server kpiMap keys:', @json(isset($kpiMap) ? array_keys($kpiMap) : []));

            console.log("populated in target actual");
          </script>
          @endsection
</body>

</html>