<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Login</title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="L@g_logo.png" type="png">

    <!-- Fonts and icons -->
    <script src="{{ asset('frontend/js/plugin/webfont/webfont.min.js')}}"></script>
    <!-- CSS Files -->
    <link rel="stylesheet" href="{{ asset('frontend/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{ asset('frontend/css/atlantis.css')}}">
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->

    <style>
        .sign-in-btn {
            background: radial-gradient(100% 100% at 100% 0, #5adaff 0, #074d66 100%);
            color: #fff;
        }


        .wrapper-login {
            animation: bouncetop 2s ease 0s 1 normal forwards;
        }

        @keyframes bouncetop {
            0% {
                animation-timing-function: ease-in;
                opacity: 1;
                transform: translateY(-45px);
            }

            24% {
                opacity: 1;
            }

            40% {
                animation-timing-function: ease-in;
                transform: translateY(-24px);
            }

            65% {
                animation-timing-function: ease-in;
                transform: translateY(-12px);
            }

            82% {
                animation-timing-function: ease-in;
                transform: translateY(-6px);
            }

            93% {
                animation-timing-function: ease-in;
                transform: translateY(-4px);
            }

            25%,
            55%,
            75%,
            87% {
                animation-timing-function: ease-out;
                transform: translateY(0px);
            }

            100% {
                animation-timing-function: ease-out;
                opacity: 1;
                transform: translateY(0px);
            }
        }
    </style>

    <style>
        .wrapper .container .login-form .form-group .form-control {
            background-color: #e8f0fe !important;
        }
    </style>

    <style>
        .group {
            position: relative;
            width: 100%;
            height: 40px;
            overflow: hidden;
            color: #fff;
            background-color: #0000008e;
            border-bottom: 2px solid #009cff;
            border-top: 2px solid #009cff;
        }

        .group .text {
            white-space: nowrap;
            /* Ensure text stays in a single line */
            position: absolute;
            margin: 5px 0;
            color: #fff;
            font-size: 20px;
        }
    </style>

    <!-- NEW YEAR COUNTDOWN -->
    <!-- <style>
        .countdown-container {
            font-size: 16px;
            font-weight: bold;
            color: #e74c3c;
            margin: 10px;
            padding: 5px 10px;
            background: #fef4e6;
            border: 1px solid #e67e22;
            border-radius: 15px;
            display: inline-block;
            animation: fadeIn 1s ease-in-out;

            /* Positioning styles */
            position: absolute;
            top: 10px;
            right: 10px;
            z-index: 1000;
        }

        .countdown-container h6 {
            font-weight: bold;
        }

        .countdown-number {
            color: #e67e22;
            font-size: 18px;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }
    </style> -->

    <style>
        .login .wrapper.wrapper-login .container-login,
        .login .wrapper.wrapper-login .container-signup {
            padding: 15px 25px !important;
        }
    </style>

</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->

    <div id="wrapper">
        <div class="d-none">
            <div class="group">
                <p class="text">
                    KAIZEN MELA -2024 IS GOING LIVE - '<img src="{{ asset('k2.png')}}" class="pb-1 pl-2 pr-2" alt="" width="40" height="30">Small Steps Lead to Big Changes.<img src="{{ asset('k1.png')}}" class="pb-1 pl-2" alt="" width="40" height="30"> '
                </p>
            </div>
        </div>
        <div class="login">

            <!-- NEW YEAR 2024 -->
            <!-- <div id="newYearCountdown" class="countdown-container text-center d-none">
                <h6>New Year Countdown :</h6>
                <span id="days" class="countdown-number">0</span>D :
                <span id="hours" class="countdown-number">0</span>H :
                <span id="minutes" class="countdown-number">0</span>M :
                <span id="seconds" class="countdown-number">0</span>S
            </div> -->

            <div class="wrapper wrapper-login">
                <div class="container container-login animated fadeIn">
                    <div class="text-center">
                        <img src="L@g_logo.png" class="center" height="70" width="70">
                    </div>
                    <br>
                    <h3 class="text-center">Life @ GainUp</h3>
                    <div class="login-form">
                        <form action="/dashboard" method="POST">
                            @csrf
                            @if(\Session::has('message'))
                            <div id="message" class="alert alert-info">
                                {{\Session::get('message')}}
                            </div>
                            <script>
                                setTimeout(function() {
                                    var successAlert = document.getElementById('message');
                                    if (successAlert) {
                                        successAlert.remove();
                                    }
                                }, 15000);
                            </script>
                            @endif
                            @if(session('alert'))
                            <style>
                                .custom-light-red-alert {
                                    background-color: #ffcccc;
                                    border-color: #ff9999;
                                    color: #0b0b10;
                                }
                            </style>
                            <svg xmlns="http://www.w3.org/2000/svg" class="d-none">
                                <symbol id="exclamation-triangle-fill" viewBox="0 0 16 16">
                                    <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                </symbol>
                            </svg>

                            <div id="alert" class="alert custom-light-red-alert d-flex align-items-center" role="alert">
                                <svg class="bi flex-shrink-0 me-2" role="img" aria-label="Danger:" style="width: 40px; height: 40px;">
                                    <use xlink:href="#exclamation-triangle-fill" />
                                </svg>
                                <div class="mr-3"></div>
                                {{ session('alert') }}
                            </div>
                            <script>
                                setTimeout(function() {
                                    var successAlert = document.getElementById('alert');
                                    if (successAlert) {
                                        successAlert.remove();
                                    }
                                }, 15000);
                            </script>
                            @endif
                            <div class="form-group form-floating-label">
                                <input id="UserName" name="UserName" type="text" class="form-control input-border-bottom" maxlength="10" required>
                                <label for="UserName" class="placeholder">Username</label>
                                @if ($errors->has('UserName'))
                                <span class="text-danger">{{ $errors->first('UserName') }}</span>
                                @endif
                            </div>
                            <div class="form-group form-floating-label">
                                <input id="PassWord" name="PassWord" type="password" class="form-control input-border-bottom" required>
                                <label for="PassWord" class="placeholder">Password</label>
                                <div class="show-password">
                                    <i class="icon-eye"></i>
                                </div>
                                @if ($errors->has('PassWord'))
                                <span class="text-danger">{{ $errors->first('PassWord') }}</span>
                                @endif
                            </div>
                            <div class="link float-right">
                                <a href="forgot">Forgot Password ?</a>
                            </div>
                            <div class="form-action mt-3 mb-3">
                                <button type="submit" class="btn sign-in-btn btn-rounded btn-login">Sign In</button>
                            </div>
                            <div class="link mt-5 d-flex justify-content-between">
                                <a href="https://www.gainup.in/" class="mb-5" title="Visit Gainup Website">
                                    <img src="L@g_logo.png" alt="" srcset="" width="40">
                                </a>
                                <br>


                                <a href="http://supplier.gainup.in:8084/login" target="_blank" class="mb-5 highlight-link" title="Supplier Portal">
                                    <img src="SUPPLIER.png" alt="Life@Gainup App" width="40">
                                </a>

                                <br>
                                <a href="griev_entry">
                                    <img src="Grievence_img.jfif" alt="" srcset="" width="60" title="Grievance Entry">
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="container container-signup animated fadeIn" style="display:none">
                    <h3 class="text-center">Sign Up</h3>
                    <div class="login-form">
                        <div class="form-group form-floating-label">
                            <input id="fullname" name="fullname" type="text" class="form-control input-border-bottom" required>
                            <label for="fullname" class="placeholder">Fullname</label>
                        </div>
                        <div class="form-group form-floating-label">
                            <input id="email" name="email" type="email" class="form-control input-border-bottom" required>
                            <label for="email" class="placeholder">Email</label>
                        </div>
                        <div class="form-group form-floating-label">
                            <input id="passwordsignin" name="passwordsignin" type="password" class="form-control input-border-bottom" required>
                            <label for="passwordsignin" class="placeholder">Password</label>
                            <div class="show-password">
                                <i class="icon-eye"></i>
                            </div>
                        </div>
                        <div class="form-group form-floating-label">
                            <input id="confirmpassword" name="confirmpassword" type="password" class="form-control input-border-bottom" required>
                            <label for="confirmpassword" class="placeholder">Confirm Password</label>
                            <div class="show-password">
                                <i class="icon-eye"></i>
                            </div>
                        </div>
                        <div class="row form-sub m-0">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" name="agree" id="agree">
                                <label class="custom-control-label" for="agree">I Agree the terms and conditions.</label>
                            </div>
                        </div>
                        <div class="form-action">
                            <a href="#" id="show-signin" class="btn btn-danger btn-link btn-login mr-3">Cancel</a>
                            <a href="#" class="btn btn-primary btn-rounded btn-login">Sign Up</a>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <script src="{{ asset('frontend/js/core/jquery.3.2.1.min.js')}}"></script>
    <script src="{{ asset('frontend/js/plugin/jquery-ui-1.12.1.custom/jquery-ui.min.js')}}"></script>
    <script src="{{ asset('frontend/js/core/popper.min.js')}}"></script>
    <script src="{{ asset('frontend/js/core/bootstrap.min.js')}}"></script>
    <script src="{{ asset('frontend/js/atlantis.min.js')}}"></script>

    <!-- NEW YEAR COUNTDOWN -->
    <!-- <script>
        function startCountdown() {
            const newYearDate = new Date(new Date().getFullYear() + 1, 0, 1, 0, 0, 0); // Next Jan 1

            function updateCountdown() {
                const now = new Date();
                const timeDiff = newYearDate - now;

                if (timeDiff <= 0) {
                    document.getElementById("newYearCountdown").innerHTML = "🎉 Happy New Year!";
                    clearInterval(timer);
                    return;
                }

                const days = Math.floor(timeDiff / (1000 * 60 * 60 * 24));
                const hours = Math.floor((timeDiff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                const minutes = Math.floor((timeDiff % (1000 * 60 * 60)) / (1000 * 60));
                const seconds = Math.floor((timeDiff % (1000 * 60)) / 1000);

                document.getElementById("days").textContent = days;
                document.getElementById("hours").textContent = hours;
                document.getElementById("minutes").textContent = minutes;
                document.getElementById("seconds").textContent = seconds;
            }

            const timer = setInterval(updateCountdown, 1000);
            updateCountdown();
        }

        document.addEventListener("DOMContentLoaded", startCountdown);
    </script> -->

    <script>
        window.onload = function() {
            var inputElement = document.getElementById('UserName');
            inputElement.focus();
        };
    </script>

    <script>
        function setAnimation() {
            const textElement = document.querySelector(".text");
            const textWidth = textElement.offsetWidth;
            const parentWidth = textElement.parentElement.offsetWidth;
            const animationDuration = Math.max((textWidth / 100) * 1.5, 40);

            // Create or update animation
            var style =
                document.getElementById("marqueeStyle") ||
                document.createElement("style");
            style.id = "marqueeStyle";
            style.innerHTML = `
                @keyframes marqueeAnimation {
                    from { transform: translateX(${parentWidth}px); }
                    to { transform: translateX(-${textWidth}px); }
                }
                .text {
                    animation: marqueeAnimation ${animationDuration}s linear infinite;
                }
            `;
            document.head.appendChild(style);
        }

        window.onload = setAnimation;
        window.onresize = setAnimation;
    </script>
</body>

</html>