<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link rel="icon" href="L@g_logo.png" type="png">


    <!-- CSS Files -->
    <link rel="stylesheet" href="{{ asset('frontend/css/bootstrap.min.css')}}">
    <script src="{{ asset('frontend/Christmas2024/spinner_Chris.js')}}"></script>
    <link rel="stylesheet" href="{{ asset('frontend/Christmas2024/loginChris.css')}}">

    <style type="text/css">
        .no-cursor {
            filter: blur(5px);
            cursor: none;
        }

        * {
            /* cursor: url(https://cur.cursors-4u.net/holidays/hol-5/hol442.ani), url(https://cur.cursors-4u.net/holidays/hol-5/hol442.gif), auto !important; */
            /* cursor: url(http://cur.cursors-4u.net/holidays/hol-4/hol356.cur), progress !important; */
            cursor: url(http://cur.cursors-4u.net/holidays/hol-4/hol392.cur), progress !important
            /* cursor: url(http://cur.cursors-4u.net/holidays/hol-4/hol397.cur), progress !important; */
        }
    </style>

    <style>
        .login-card {
            position: relative;
            padding: 20px;
            background: #fff;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
        }

        .audio-controls {
            position: absolute;
            top: 10px;
            right: 10px;
            text-align: center;
        }

        /* Toggle Button Styling */
        .toggle {
            position: relative;
            display: inline-block;
            width: 40px;
            height: 20px;
        }

        .toggle input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: 0.4s;
            border-radius: 25px;
        }

        .slider:before {
            position: absolute;
            content: '';
            height: 14px;
            width: 14px;
            left: 2px;
            bottom: 3px;
            background-color: white;
            transition: 0.4s;
            border-radius: 50%;
        }

        input:checked+.slider {
            background-color: #4caf50;
        }

        input:checked+.slider:before {
            transform: translateX(24px);
        }

        #toggleLabel {
            margin-top: 5px;
            font-size: 14px;
            color: #333;
        }
    </style>

</head>

<body id="body">
    <div id="container" class="spin_container" style="display: none;">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
        <section>
            <svg id="Layer_1" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                x="0px" y="0px" viewbox="0 0 64 64">
                <g>
                    <path class="st0"
                        d="M40.5,40c6.9,0,7.5,0.9,4.6,6.4c-0.5,0.9-1,1.8-1.6,2.5c-1.9,2.1-4.2,4.8-7,4c-2.7-0.9-0.9-4.3-1.3-6.6														C34.5,41.4,35.9,38.7,40.5,40z">
                    </path>
                    <path class="st1"
                        d="M30.9,46.6c-0.6,2.3,1,5.3-1.1,6.2c-2.4,1-4.5-1.4-6.4-3c-0.6-0.5-1.2-1.2-1.6-1.9c-1.5-2.2-2.6-4.6-2.2-7.4														c0.1-0.5,9.7-0.8,10.3-0.2C31.7,42.2,30,44.7,30.9,46.6z">
                    </path>
                    <path class="st2"
                        d="M30.5,32.2c-0.8,1,2.1,4.2-1.6,4.6c-2.7,0.3-7.7-5.6-7.8-8.9c-0.1-3.9,3-1.9,4.7-2.2														C31.1,24.6,31.1,28,30.5,32.2z">
                    </path>
                    <path class="st3"
                        d="M35.2,31.5c0.9-2-1.8-5.9,3-5.8c2.2,0,5.4-1.3,6.4,0.9c1.2,2.5-0.9,5.1-2.7,7c-1.5,1.7-3.4,3.9-5.8,3														C34.3,35.9,35.7,33.3,35.2,31.5z">
                    </path>
                    <path class="st4"
                        d="M30.7,18.1c-0.4,1,1.2,3.2-1.3,3.7c-1.9,0.4-6.1-4.6-6.1-7.1c0-2.9,2.3-1.5,3.6-1.8C31.1,12.2,31,15,30.7,18.1														z">
                    </path>
                    <path class="st4"
                        d="M35.5,18.1c-0.9-4.2,0.4-5.8,4-5.2c1.2,0.2,3.2-0.9,3.3,1.7c0.1,2.4-4.1,7.6-6,7.2														C34,21.3,35.9,18.9,35.5,18.1z">
                    </path>
                    <path class="st5" d="M32.9,103.1"></path>
                    <path class="st6"
                        d="M35.2,60.3c-0.1,1.8,0.6,4.2-2.5,3.8c-3.3-0.4-1.5-3.1-1.8-4.7c-0.2-1.4-0.6-3.5,2.1-3.4														C36.5,56.2,34.5,59,35.2,60.3z">
                    </path>
                    <path class="st7"
                        d="M36,7.1c-0.3,1.9-1.4,3-3.4,2.8c-1.7-0.2-2.7-1.4-2.6-3.1c0.1-2,1.4-3,3.3-2.8C35.1,4.1,36,5.3,36,7.1z">
                    </path>
                </g>
            </svg>
            <svg id="Layer_1" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                x="0px" y="0px" viewbox="0 0 64 64">
                <g>
                    <path class="st0"
                        d="M40.5,40c6.9,0,7.5,0.9,4.6,6.4c-0.5,0.9-1,1.8-1.6,2.5c-1.9,2.1-4.2,4.8-7,4c-2.7-0.9-0.9-4.3-1.3-6.6														C34.5,41.4,35.9,38.7,40.5,40z">
                    </path>
                    <path class="st1"
                        d="M30.9,46.6c-0.6,2.3,1,5.3-1.1,6.2c-2.4,1-4.5-1.4-6.4-3c-0.6-0.5-1.2-1.2-1.6-1.9c-1.5-2.2-2.6-4.6-2.2-7.4														c0.1-0.5,9.7-0.8,10.3-0.2C31.7,42.2,30,44.7,30.9,46.6z">
                    </path>
                    <path class="st2"
                        d="M30.5,32.2c-0.8,1,2.1,4.2-1.6,4.6c-2.7,0.3-7.7-5.6-7.8-8.9c-0.1-3.9,3-1.9,4.7-2.2														C31.1,24.6,31.1,28,30.5,32.2z">
                    </path>
                    <path class="st3"
                        d="M35.2,31.5c0.9-2-1.8-5.9,3-5.8c2.2,0,5.4-1.3,6.4,0.9c1.2,2.5-0.9,5.1-2.7,7c-1.5,1.7-3.4,3.9-5.8,3														C34.3,35.9,35.7,33.3,35.2,31.5z">
                    </path>
                    <path class="st4"
                        d="M30.7,18.1c-0.4,1,1.2,3.2-1.3,3.7c-1.9,0.4-6.1-4.6-6.1-7.1c0-2.9,2.3-1.5,3.6-1.8C31.1,12.2,31,15,30.7,18.1														z">
                    </path>
                    <path class="st4"
                        d="M35.5,18.1c-0.9-4.2,0.4-5.8,4-5.2c1.2,0.2,3.2-0.9,3.3,1.7c0.1,2.4-4.1,7.6-6,7.2														C34,21.3,35.9,18.9,35.5,18.1z">
                    </path>
                    <path class="st5" d="M32.9,103.1"></path>
                    <path class="st6"
                        d="M35.2,60.3c-0.1,1.8,0.6,4.2-2.5,3.8c-3.3-0.4-1.5-3.1-1.8-4.7c-0.2-1.4-0.6-3.5,2.1-3.4														C36.5,56.2,34.5,59,35.2,60.3z">
                    </path>
                    <path class="st7"
                        d="M36,7.1c-0.3,1.9-1.4,3-3.4,2.8c-1.7-0.2-2.7-1.4-2.6-3.1c0.1-2,1.4-3,3.3-2.8C35.1,4.1,36,5.3,36,7.1z">
                    </path>
                </g>
            </svg>
            <svg id="Layer_1" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                x="0px" y="0px" viewbox="0 0 64 64">
                <g>
                    <path class="st0"
                        d="M40.5,40c6.9,0,7.5,0.9,4.6,6.4c-0.5,0.9-1,1.8-1.6,2.5c-1.9,2.1-4.2,4.8-7,4c-2.7-0.9-0.9-4.3-1.3-6.6														C34.5,41.4,35.9,38.7,40.5,40z">
                    </path>
                    <path class="st1"
                        d="M30.9,46.6c-0.6,2.3,1,5.3-1.1,6.2c-2.4,1-4.5-1.4-6.4-3c-0.6-0.5-1.2-1.2-1.6-1.9c-1.5-2.2-2.6-4.6-2.2-7.4														c0.1-0.5,9.7-0.8,10.3-0.2C31.7,42.2,30,44.7,30.9,46.6z">
                    </path>
                    <path class="st2"
                        d="M30.5,32.2c-0.8,1,2.1,4.2-1.6,4.6c-2.7,0.3-7.7-5.6-7.8-8.9c-0.1-3.9,3-1.9,4.7-2.2														C31.1,24.6,31.1,28,30.5,32.2z">
                    </path>
                    <path class="st3"
                        d="M35.2,31.5c0.9-2-1.8-5.9,3-5.8c2.2,0,5.4-1.3,6.4,0.9c1.2,2.5-0.9,5.1-2.7,7c-1.5,1.7-3.4,3.9-5.8,3														C34.3,35.9,35.7,33.3,35.2,31.5z">
                    </path>
                    <path class="st4"
                        d="M30.7,18.1c-0.4,1,1.2,3.2-1.3,3.7c-1.9,0.4-6.1-4.6-6.1-7.1c0-2.9,2.3-1.5,3.6-1.8C31.1,12.2,31,15,30.7,18.1														z">
                    </path>
                    <path class="st4"
                        d="M35.5,18.1c-0.9-4.2,0.4-5.8,4-5.2c1.2,0.2,3.2-0.9,3.3,1.7c0.1,2.4-4.1,7.6-6,7.2														C34,21.3,35.9,18.9,35.5,18.1z">
                    </path>
                    <path class="st5" d="M32.9,103.1"></path>
                    <path class="st6"
                        d="M35.2,60.3c-0.1,1.8,0.6,4.2-2.5,3.8c-3.3-0.4-1.5-3.1-1.8-4.7c-0.2-1.4-0.6-3.5,2.1-3.4														C36.5,56.2,34.5,59,35.2,60.3z">
                    </path>
                    <path class="st7"
                        d="M36,7.1c-0.3,1.9-1.4,3-3.4,2.8c-1.7-0.2-2.7-1.4-2.6-3.1c0.1-2,1.4-3,3.3-2.8C35.1,4.1,36,5.3,36,7.1z">
                    </path>
                </g>
            </svg>
            <svg id="Layer_1" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                x="0px" y="0px" viewbox="0 0 64 64">
                <g>
                    <path class="st0"
                        d="M40.5,40c6.9,0,7.5,0.9,4.6,6.4c-0.5,0.9-1,1.8-1.6,2.5c-1.9,2.1-4.2,4.8-7,4c-2.7-0.9-0.9-4.3-1.3-6.6														C34.5,41.4,35.9,38.7,40.5,40z">
                    </path>
                    <path class="st1"
                        d="M30.9,46.6c-0.6,2.3,1,5.3-1.1,6.2c-2.4,1-4.5-1.4-6.4-3c-0.6-0.5-1.2-1.2-1.6-1.9c-1.5-2.2-2.6-4.6-2.2-7.4														c0.1-0.5,9.7-0.8,10.3-0.2C31.7,42.2,30,44.7,30.9,46.6z">
                    </path>
                    <path class="st2"
                        d="M30.5,32.2c-0.8,1,2.1,4.2-1.6,4.6c-2.7,0.3-7.7-5.6-7.8-8.9c-0.1-3.9,3-1.9,4.7-2.2														C31.1,24.6,31.1,28,30.5,32.2z">
                    </path>
                    <path class="st3"
                        d="M35.2,31.5c0.9-2-1.8-5.9,3-5.8c2.2,0,5.4-1.3,6.4,0.9c1.2,2.5-0.9,5.1-2.7,7c-1.5,1.7-3.4,3.9-5.8,3														C34.3,35.9,35.7,33.3,35.2,31.5z">
                    </path>
                    <path class="st4"
                        d="M30.7,18.1c-0.4,1,1.2,3.2-1.3,3.7c-1.9,0.4-6.1-4.6-6.1-7.1c0-2.9,2.3-1.5,3.6-1.8C31.1,12.2,31,15,30.7,18.1														z">
                    </path>
                    <path class="st4"
                        d="M35.5,18.1c-0.9-4.2,0.4-5.8,4-5.2c1.2,0.2,3.2-0.9,3.3,1.7c0.1,2.4-4.1,7.6-6,7.2														C34,21.3,35.9,18.9,35.5,18.1z">
                    </path>
                    <path class="st5" d="M32.9,103.1"></path>
                    <path class="st6"
                        d="M35.2,60.3c-0.1,1.8,0.6,4.2-2.5,3.8c-3.3-0.4-1.5-3.1-1.8-4.7c-0.2-1.4-0.6-3.5,2.1-3.4														C36.5,56.2,34.5,59,35.2,60.3z">
                    </path>
                    <path class="st7"
                        d="M36,7.1c-0.3,1.9-1.4,3-3.4,2.8c-1.7-0.2-2.7-1.4-2.6-3.1c0.1-2,1.4-3,3.3-2.8C35.1,4.1,36,5.3,36,7.1z">
                    </path>
                </g>
            </svg>
            <svg id="Layer_1" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                x="0px" y="0px" viewbox="0 0 64 64">
                <g>
                    <path class="st0"
                        d="M40.5,40c6.9,0,7.5,0.9,4.6,6.4c-0.5,0.9-1,1.8-1.6,2.5c-1.9,2.1-4.2,4.8-7,4c-2.7-0.9-0.9-4.3-1.3-6.6														C34.5,41.4,35.9,38.7,40.5,40z">
                    </path>
                    <path class="st1"
                        d="M30.9,46.6c-0.6,2.3,1,5.3-1.1,6.2c-2.4,1-4.5-1.4-6.4-3c-0.6-0.5-1.2-1.2-1.6-1.9c-1.5-2.2-2.6-4.6-2.2-7.4														c0.1-0.5,9.7-0.8,10.3-0.2C31.7,42.2,30,44.7,30.9,46.6z">
                    </path>
                    <path class="st2"
                        d="M30.5,32.2c-0.8,1,2.1,4.2-1.6,4.6c-2.7,0.3-7.7-5.6-7.8-8.9c-0.1-3.9,3-1.9,4.7-2.2														C31.1,24.6,31.1,28,30.5,32.2z">
                    </path>
                    <path class="st3"
                        d="M35.2,31.5c0.9-2-1.8-5.9,3-5.8c2.2,0,5.4-1.3,6.4,0.9c1.2,2.5-0.9,5.1-2.7,7c-1.5,1.7-3.4,3.9-5.8,3														C34.3,35.9,35.7,33.3,35.2,31.5z">
                    </path>
                    <path class="st4"
                        d="M30.7,18.1c-0.4,1,1.2,3.2-1.3,3.7c-1.9,0.4-6.1-4.6-6.1-7.1c0-2.9,2.3-1.5,3.6-1.8C31.1,12.2,31,15,30.7,18.1														z">
                    </path>
                    <path class="st4"
                        d="M35.5,18.1c-0.9-4.2,0.4-5.8,4-5.2c1.2,0.2,3.2-0.9,3.3,1.7c0.1,2.4-4.1,7.6-6,7.2														C34,21.3,35.9,18.9,35.5,18.1z">
                    </path>
                    <path class="st5" d="M32.9,103.1"></path>
                    <path class="st6"
                        d="M35.2,60.3c-0.1,1.8,0.6,4.2-2.5,3.8c-3.3-0.4-1.5-3.1-1.8-4.7c-0.2-1.4-0.6-3.5,2.1-3.4														C36.5,56.2,34.5,59,35.2,60.3z">
                    </path>
                    <path class="st7"
                        d="M36,7.1c-0.3,1.9-1.4,3-3.4,2.8c-1.7-0.2-2.7-1.4-2.6-3.1c0.1-2,1.4-3,3.3-2.8C35.1,4.1,36,5.3,36,7.1z">
                    </path>
                </g>
            </svg>
            <svg id="Layer_1" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                x="0px" y="0px" viewbox="0 0 64 64">
                <g>
                    <path class="st0"
                        d="M40.5,40c6.9,0,7.5,0.9,4.6,6.4c-0.5,0.9-1,1.8-1.6,2.5c-1.9,2.1-4.2,4.8-7,4c-2.7-0.9-0.9-4.3-1.3-6.6														C34.5,41.4,35.9,38.7,40.5,40z">
                    </path>
                    <path class="st1"
                        d="M30.9,46.6c-0.6,2.3,1,5.3-1.1,6.2c-2.4,1-4.5-1.4-6.4-3c-0.6-0.5-1.2-1.2-1.6-1.9c-1.5-2.2-2.6-4.6-2.2-7.4														c0.1-0.5,9.7-0.8,10.3-0.2C31.7,42.2,30,44.7,30.9,46.6z">
                    </path>
                    <path class="st2"
                        d="M30.5,32.2c-0.8,1,2.1,4.2-1.6,4.6c-2.7,0.3-7.7-5.6-7.8-8.9c-0.1-3.9,3-1.9,4.7-2.2														C31.1,24.6,31.1,28,30.5,32.2z">
                    </path>
                    <path class="st3"
                        d="M35.2,31.5c0.9-2-1.8-5.9,3-5.8c2.2,0,5.4-1.3,6.4,0.9c1.2,2.5-0.9,5.1-2.7,7c-1.5,1.7-3.4,3.9-5.8,3														C34.3,35.9,35.7,33.3,35.2,31.5z">
                    </path>
                    <path class="st4"
                        d="M30.7,18.1c-0.4,1,1.2,3.2-1.3,3.7c-1.9,0.4-6.1-4.6-6.1-7.1c0-2.9,2.3-1.5,3.6-1.8C31.1,12.2,31,15,30.7,18.1														z">
                    </path>
                    <path class="st4"
                        d="M35.5,18.1c-0.9-4.2,0.4-5.8,4-5.2c1.2,0.2,3.2-0.9,3.3,1.7c0.1,2.4-4.1,7.6-6,7.2														C34,21.3,35.9,18.9,35.5,18.1z">
                    </path>
                    <path class="st5" d="M32.9,103.1"></path>
                    <path class="st6"
                        d="M35.2,60.3c-0.1,1.8,0.6,4.2-2.5,3.8c-3.3-0.4-1.5-3.1-1.8-4.7c-0.2-1.4-0.6-3.5,2.1-3.4														C36.5,56.2,34.5,59,35.2,60.3z">
                    </path>
                    <path class="st7"
                        d="M36,7.1c-0.3,1.9-1.4,3-3.4,2.8c-1.7-0.2-2.7-1.4-2.6-3.1c0.1-2,1.4-3,3.3-2.8C35.1,4.1,36,5.3,36,7.1z">
                    </path>
                </g>
            </svg>
            <svg id="Layer_1" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                x="0px" y="0px" viewbox="0 0 64 64">
                <g>
                    <path class="st0"
                        d="M40.5,40c6.9,0,7.5,0.9,4.6,6.4c-0.5,0.9-1,1.8-1.6,2.5c-1.9,2.1-4.2,4.8-7,4c-2.7-0.9-0.9-4.3-1.3-6.6														C34.5,41.4,35.9,38.7,40.5,40z">
                    </path>
                    <path class="st1"
                        d="M30.9,46.6c-0.6,2.3,1,5.3-1.1,6.2c-2.4,1-4.5-1.4-6.4-3c-0.6-0.5-1.2-1.2-1.6-1.9c-1.5-2.2-2.6-4.6-2.2-7.4														c0.1-0.5,9.7-0.8,10.3-0.2C31.7,42.2,30,44.7,30.9,46.6z">
                    </path>
                    <path class="st2"
                        d="M30.5,32.2c-0.8,1,2.1,4.2-1.6,4.6c-2.7,0.3-7.7-5.6-7.8-8.9c-0.1-3.9,3-1.9,4.7-2.2														C31.1,24.6,31.1,28,30.5,32.2z">
                    </path>
                    <path class="st3"
                        d="M35.2,31.5c0.9-2-1.8-5.9,3-5.8c2.2,0,5.4-1.3,6.4,0.9c1.2,2.5-0.9,5.1-2.7,7c-1.5,1.7-3.4,3.9-5.8,3														C34.3,35.9,35.7,33.3,35.2,31.5z">
                    </path>
                    <path class="st4"
                        d="M30.7,18.1c-0.4,1,1.2,3.2-1.3,3.7c-1.9,0.4-6.1-4.6-6.1-7.1c0-2.9,2.3-1.5,3.6-1.8C31.1,12.2,31,15,30.7,18.1														z">
                    </path>
                    <path class="st4"
                        d="M35.5,18.1c-0.9-4.2,0.4-5.8,4-5.2c1.2,0.2,3.2-0.9,3.3,1.7c0.1,2.4-4.1,7.6-6,7.2														C34,21.3,35.9,18.9,35.5,18.1z">
                    </path>
                    <path class="st5" d="M32.9,103.1"></path>
                    <path class="st6"
                        d="M35.2,60.3c-0.1,1.8,0.6,4.2-2.5,3.8c-3.3-0.4-1.5-3.1-1.8-4.7c-0.2-1.4-0.6-3.5,2.1-3.4														C36.5,56.2,34.5,59,35.2,60.3z">
                    </path>
                    <path class="st7"
                        d="M36,7.1c-0.3,1.9-1.4,3-3.4,2.8c-1.7-0.2-2.7-1.4-2.6-3.1c0.1-2,1.4-3,3.3-2.8C35.1,4.1,36,5.3,36,7.1z">
                    </path>
                </g>
            </svg>
            <svg id="Layer_1" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                x="0px" y="0px" viewbox="0 0 64 64">
                <g>
                    <path class="st0"
                        d="M40.5,40c6.9,0,7.5,0.9,4.6,6.4c-0.5,0.9-1,1.8-1.6,2.5c-1.9,2.1-4.2,4.8-7,4c-2.7-0.9-0.9-4.3-1.3-6.6														C34.5,41.4,35.9,38.7,40.5,40z">
                    </path>
                    <path class="st1"
                        d="M30.9,46.6c-0.6,2.3,1,5.3-1.1,6.2c-2.4,1-4.5-1.4-6.4-3c-0.6-0.5-1.2-1.2-1.6-1.9c-1.5-2.2-2.6-4.6-2.2-7.4														c0.1-0.5,9.7-0.8,10.3-0.2C31.7,42.2,30,44.7,30.9,46.6z">
                    </path>
                    <path class="st2"
                        d="M30.5,32.2c-0.8,1,2.1,4.2-1.6,4.6c-2.7,0.3-7.7-5.6-7.8-8.9c-0.1-3.9,3-1.9,4.7-2.2														C31.1,24.6,31.1,28,30.5,32.2z">
                    </path>
                    <path class="st3"
                        d="M35.2,31.5c0.9-2-1.8-5.9,3-5.8c2.2,0,5.4-1.3,6.4,0.9c1.2,2.5-0.9,5.1-2.7,7c-1.5,1.7-3.4,3.9-5.8,3														C34.3,35.9,35.7,33.3,35.2,31.5z">
                    </path>
                    <path class="st4"
                        d="M30.7,18.1c-0.4,1,1.2,3.2-1.3,3.7c-1.9,0.4-6.1-4.6-6.1-7.1c0-2.9,2.3-1.5,3.6-1.8C31.1,12.2,31,15,30.7,18.1														z">
                    </path>
                    <path class="st4"
                        d="M35.5,18.1c-0.9-4.2,0.4-5.8,4-5.2c1.2,0.2,3.2-0.9,3.3,1.7c0.1,2.4-4.1,7.6-6,7.2														C34,21.3,35.9,18.9,35.5,18.1z">
                    </path>
                    <path class="st5" d="M32.9,103.1"></path>
                    <path class="st6"
                        d="M35.2,60.3c-0.1,1.8,0.6,4.2-2.5,3.8c-3.3-0.4-1.5-3.1-1.8-4.7c-0.2-1.4-0.6-3.5,2.1-3.4														C36.5,56.2,34.5,59,35.2,60.3z">
                    </path>
                    <path class="st7"
                        d="M36,7.1c-0.3,1.9-1.4,3-3.4,2.8c-1.7-0.2-2.7-1.4-2.6-3.1c0.1-2,1.4-3,3.3-2.8C35.1,4.1,36,5.3,36,7.1z">
                    </path>
                </g>
            </svg>
        </section>
        </p>
    </div>
    <div id="wrapper">
        <div class="snowflakes">
            <div class="snowflake">❅</div>
            <div class="snowflake">❆</div>
            <div class="snowflake">❅</div>
            <div class="snowflake">❆</div>
            <div class="snowflake">❅</div>
        </div>

        <div class="login-container">
            <div class="login-card">
                <!-- Toggle Button -->
                <div class="audio-controls">
                    <label class="toggle">
                        <input type="checkbox" id="audioToggle">
                        <span class="slider"></span>
                    </label>
                    <p id="toggleLabel"></p>
                    <!-- <p id="toggleLabel">🔇 Audio Off</p> -->
                    <!-- <p id="toggleLabel">🔇 Audio Off</p> -->
                </div>

                <h1 class="title">🎄 LIFE@GAINUP! 🎄</h1>
                <p class="subtitle">Wishing you a Merry Christmas! 🎅</p>
                <form action="/dashboard" method="POST">
                    @csrf
                    @if(\Session::has('message'))
                    <div id="message" class="alert alert-info">
                        {{\Session::get('message')}}
                    </div>
                    <script>
                        setTimeout(function() {
                            var successAlert = document.getElementById('message');
                            if (successAlert) {
                                successAlert.remove();
                            }
                        }, 15000);
                    </script>
                    @endif
                    @if(session('alert'))
                    <style>
                        .custom-light-red-alert {
                            background-color: #ffcccc;
                            border-color: #ff9999;
                            color: #0b0b10;
                        }
                    </style>
                    <div id="alert" class="alert custom-light-red-alert d-flex align-items-center" role="alert">
                        <svg class="bi flex-shrink-0 me-2" role="img" aria-label="Danger:" style="width: 40px; height: 40px;">
                            <use xlink:href="#exclamation-triangle-fill" />
                        </svg>
                        <div class="mr-3"></div>
                        {{ session('alert') }}
                    </div>
                    <script>
                        setTimeout(function() {
                            var successAlert = document.getElementById('alert');
                            if (successAlert) {
                                successAlert.remove();
                            }
                        }, 15000);
                    </script>
                    @endif
                    <div class="form-group">
                        <input type="text" id="UserName" name="UserName" placeholder="Username" maxlength="10" required>
                        @if ($errors->has('UserName'))
                        <span class="text-danger">{{ $errors->first('UserName') }}</span>
                        @endif
                    </div>
                    <div class="form-group">
                        <input type="password" id="PassWord" name="PassWord" placeholder="Password" required>
                        <div class="show-password">
                            <i class="icon-eye"></i>
                        </div>
                        @if ($errors->has('PassWord'))
                        <span class="text-danger">{{ $errors->first('PassWord') }}</span>
                        @endif
                    </div>
                    <div class="forgot-password">
                        <a href="forgot" class="forgot-password-link">Forgot Password?</a>
                    </div>
                    <!-- <button type="submit" class="login-button">Login</button> -->
                    <!-- <a href="#" type="submit" class="button">LOGIN</a> -->
                    <button type="submit" class="btn sign-in-btn btn-rounded btn-login button">Sign In</button>

                    <div class="link mt-5 d-flex justify-content-between">
                        <a href="https://www.gainup.in/" class="mb-5" title="Visit Gainup Website">
                            <img src="L@g_logo.png" alt="" srcset="" width="40">
                        </a>
                        <br>
                        <a href="http://supplier.gainup.in:8084/login" target="_blank" class="mb-5 highlight-link" title="Supplier Portal" download="LatG_App.apk">
                            <img src="SUPPLIER.png" alt="Life@Gainup App" width="40">
                        </a>
                        <br>
                        <a href="griev_entry">
                            <img src="Grievence_img.jfif" alt="" srcset="" class="mb-5 highlight-link" width="60" title="Grievance Entry">
                        </a>
                    </div>
                </form>
            </div>
        </div>

    </div>

    <audio id="jingleBellsAudio" src="{{ asset('frontend/Christmas2024/jingle_bells.mp3')}}"></audio>
    <!-- <script>
        // Trigger audio playback after any interaction (e.g., mouse click or key press)
        window.addEventListener('click', function() {
            var audio = document.getElementById('jingleBellsAudio');
            audio.play().catch(function(error) {
                console.log("Audio play failed: " + error);
            });
        });
    </script> -->


    <script>
        // Variables for audio and toggle
        const audio = document.getElementById('jingleBellsAudio');
        const audioToggle = document.getElementById('audioToggle');
        const toggleLabel = document.getElementById('toggleLabel');

        // Play audio on first click anywhere on the page
        let audioStarted = false; // Tracks if audio has started
        window.addEventListener('click', function() {
            if (!audioStarted) {
                audio.muted = false; // Unmute the audio
                audio.play().catch(function(error) {
                    console.log("Audio play failed: " + error);
                });
                audioStarted = true; // Mark audio as started
                audioToggle.checked = true; // Toggle button ON
                // toggleLabel.textContent = '🔊 Audio On'; // Update label
            }
        });

        // Toggle button to mute/unmute the audio
        audioToggle.addEventListener('change', function() {
            if (this.checked) {
                audio.muted = false; // Unmute
                // toggleLabel.textContent = '🔊 Audio On'; // Update label
            } else {
                audio.muted = true; // Mute
                // toggleLabel.textContent = '🔇 Audio Off'; // Update label
            }
        });

        // Set initial state on page load
        window.addEventListener('DOMContentLoaded', function() {
            audio.muted = true; // Ensure audio is muted initially
            audioToggle.checked = false; // Ensure toggle button is off initially
            // toggleLabel.textContent = '🔇 Audio Off'; // Display initial label
        });
    </script>

</body>

</html>