<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <meta content="text/html; charset=UTF-8" http-equiv="Content-Type">
    <meta content="width=device-width,height=device-height,inital-scale=1.0,maximum-scale=1.0,user-scalable=no" name="viewport">

    <!-- Primary Meta Tags -->
    <title>Happy Diwali</title>
    <audio type="audio/mpeg" controls="none" autoplay id="audio1" src="{{ asset('frontend/fireworks1.mp3')}}"></audio>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-compat/3.0.0-alpha1/jquery.min.js"></script>
    <style>
        .red-text {
            font-family: Pacifico;
            color: red;
            font-size: 46px;
        }

        html,
        body {
            height: 100%;
            margin: 0;
            padding: 0;
            background-image: url("https://img1.wallspic.com/previews/2/8/5/9/4/149582/149582-bokeh_photography_of_city_lights_during_night_time-x750.jpg");
            background-color: black;
        }

        ul,
        li {
            text-indent: 0;
            text-decoration: none;
            margin: 0;
            padding: 0;
        }

        img {
            border: 0;
        }

        body {
            background-color: #000;
            color: #999;
            font: 100%/18px helvetica, arial, sans-serif;
        }

        canvas {
            cursor: crosshair;
            display: block;
            left: 0;
            position: absolute;
            top: 0;
            z-index: 20;
        }

        #header img {
            width: 100%;
            height: 20%;
        }

        #bg img {
            width: 100%;
            height: 80%;
        }

        #header,
        #bg {
            position: fixed;
            left: 0;
            right: 0;
            z-index: 10;
        }

        #header {
            top: 0;
        }

        #bg {
            position: fixed;
            z-index: 1;
            bottom: 0;
        }

        audio {
            position: fixed;
            display: none;
            bottom: 0;
            left: 0;
            right: 0;
            width: 100%;
            z-index: 5;
        }

        .ak {
            position: absolute;
            left: 0;
            right: 0;
            top: 0%;
            color: #FFE45E;
            text-align: center;
            font-size: 7rem;
            font-style: italic;
            text-shadow: #FFE45E 0 0 30px, #E5C654 1px 0 3px;
        }
    </style>

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            position: relative;
            overflow: hidden;
            /* Prevent overflow if the animation is full screen */
        }

        .login-container {
            background-color: #fff;
            padding: 40px;
            border-radius: 5px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            width: 350px;
            z-index: 2;
            /* Ensure form is above other content */
            position: relative;
            /* Ensure it layers correctly */
        }

        .login-container h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        .login-container input[type="text"],
        .login-container input[type="password"] {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        .login-container button {
            width: 100%;
            padding: 10px;
            background-color: #28a745;
            border: none;
            color: white;
            border-radius: 5px;
            cursor: pointer;
        }

        .login-container button:hover {
            background-color: #218838;
        }
    </style>

</head>

<body>
    <div class="login-container">
        <h2>Life@Gainup</h2>
        <form action="/dashboard" method="POST" id="login-form">
            @csrf

            @if(\Session::has('message'))
            <div id="message" class="alert alert-info custom-alert" role="alert">
                {{\Session::get('message')}}
            </div>
            <script>
                setTimeout(function() {
                    var successAlert = document.getElementById('message');
                    if (successAlert) {
                        successAlert.remove();
                    }
                }, 6000);
            </script>
            @endif

            @if(session('alert'))
            <div id="alert" class="alert custom-light-red-alert custom-alert" role="alert">
                {{ session('alert') }}
            </div>
            <script>
                setTimeout(function() {
                    var successAlert = document.getElementById('alert');
                    if (successAlert) {
                        successAlert.remove();
                    }
                }, 15000);
            </script>
            @endif
            <div class="mb-3 col-xl-3">

                <div class="form-group">
                    <label for="UserName">Username</label>
                    <input id="UserName" name="UserName" type="text" class="form-control" maxlength="10" required>
                    @if ($errors->has('UserName'))
                    <span class="text-danger">{{ $errors->first('UserName') }}</span>
                    @endif
                </div>

                <div class="form-group">
                    <label for="PassWord">Password</label>
                    <input id="PassWord" name="PassWord" type="password" class="form-control" required>
                    <div class="show-password" onclick="togglePasswordVisibility()">
                        <!-- <i class="icon-eye" style="cursor: pointer;">👁️</i> Simple eye icon -->
                    </div>
                    @if ($errors->has('PassWord'))
                    <span class="text-danger">{{ $errors->first('PassWord') }}</span>
                    @endif
                </div>
            </div>

            <div class="link">
                <a href="forgot">Forgot Password?</a>
            </div>
            <br>
            <button type="submit" class="btn btn-primary btn-login mt-3">Sign In</button>
            <br>
            <br>

            <div class="footer-icons mt-5 d-flex justify-content-between">
                <a href="https://www.gainup.in/" title="Visit Gainup Website">
                    <img src="L@g_logo.png" alt="Gainup Logo" width="40">
                </a>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <a href="http://supplier.gainup.in:8084/login" target="_blank" title="Supplier Portal">
                    <img src="SUPPLIER.png" alt="Supplier Portal" width="40">
                </a>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <a href="griev_entry" title="Grievance Entry">
                    <img src="Grievence_img.jfif" alt="Grievance Entry" width="60">
                </a>
            </div>
        </form>
        <!-- <form id="login-form" action="#" method="POST">
            <input type="text" name="username" placeholder="Username" required>
            <input type="password" name="password" placeholder="Password" required>
            <button type="submit">Login</button>
        </form> -->
    </div>

    <div>
    <center> <span style="color:whitesmoke;position:fixed;top:0px;margin:auto;left:0;right:0;font-size: 25px;font-weight: 800;color: red ;">click on screen</span></center>
    <h1 class="red-text ak" style="text-align:center;font-weight:normal;font-size:50px;">Happy Diwali</h1>
        <!-- <h3 class="" style="position:fixed;bottom:20px;margin:auto;right:30px;text-align:center;color:#FEFCD7;font-size:18px; text-shadow:#FEFCD7 0 0 30px, #FEFCD7 1px 0 1px;">@pallaviwebmaster</h3> -->
        <br /><br />
    </div>

    <script>
        // Assuming your firework function is named startFireworkAnimation
        function startFireworkAnimation() {
            // Your firework animation logic goes here
            $(function() {
                var Fireworks = function() {
                    var styles = [
                        'background: linear-gradient(#D33106, #571402)', 'border: 1px solid #3E0E02', 'color: white', 'display: block', 'text-shadow: 0 1px 0 rgba(0, 0, 0, 0.3)', 'box-shadow: 0 1px 0 rgba(255, 255, 255, 0.4) inset, 0 5px 3px -5px rgba(0, 0, 0, 0.5), 0 -13px 5px -10px rgba(255, 255, 255, 0.4) inset', 'line-height: 40px', 'text-align: center', 'font-weight: bold'
                    ].join(';');
                    var self = this;
                    var rand = function(rMi, rMa) {
                        return ~~((Math.random() * (rMa - rMi + 1)) + rMi);
                    }
                    var hitTest = function(x1, y1, w1, h1, x2, y2, w2, h2) {
                        return !(x1 + w1 < x2 || x2 + w2 < x1 || y1 + h1 < y2 || y2 + h2 < y1);
                    };
                    window.requestAnimFrame = function() {
                        return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function(a) {
                            window.setTimeout(a, 1E3 / 60)
                        }
                    }();
                    self.init = function() {
                        let dt = 'This Page is Designed By virtualgadgets.in';
                        self.canvas = document.createElement('canvas');
                        self.canvas.style.zIndex = 1;

                        self.canvas.width = self.cw = $(window).innerWidth();
                        self.canvas.height = self.ch = $(window).innerHeight();
                        self.particles = [];
                        self.partCount = 150;
                        self.fireworks = [];
                        self.mx = self.cw / 2;
                        self.my = self.ch / 2;
                        self.currentHue = 30;
                        self.partSpeed = 5;
                        self.partSpeedVariance = 10;
                        self.partWind = 50;
                        self.partFriction = 5;
                        self.partGravity = 1;
                        self.hueMin = 0;
                        self.hueMax = 360;
                        self.fworkSpeed = 4;
                        self.fworkAccel = 10;
                        self.hueVariance = 30;
                        self.flickerDensity = 25;
                        self.showShockwave = true;
                        self.showTarget = false;
                        self.clearAlpha = 25;
                        console.log(`%c ${dt}`, styles);
                        $(document.body).append(self.canvas);
                        self.ctx = self.canvas.getContext('2d');
                        self.ctx.lineCap = 'round';
                        self.ctx.lineJoin = 'round';
                        self.lineWidth = 1;
                        self.bindEvents();
                        self.canvasLoop();
                        self.canvas.onselectstart = function() {
                            return false;
                        };
                    };
                    self.createParticles = function(x, y, hue) {
                        var audio = document.getElementById('audio1');
                        if (audio.paused) {
                            audio.play();
                        } else {
                            audio.currentTime = 0
                        }
                        var countdown = self.partCount;
                        while (countdown--) {
                            var newParticle = {
                                x: x,
                                y: y,
                                coordLast: [{
                                        x: x,
                                        y: y
                                    },
                                    {
                                        x: x,
                                        y: y
                                    },
                                    {
                                        x: x,
                                        y: y
                                    }
                                ],
                                angle: rand(0, 360),
                                speed: rand(((self.partSpeed - self.partSpeedVariance) <= 0) ? 1 : self.partSpeed - self.partSpeedVariance, (self.partSpeed + self.partSpeedVariance)),
                                friction: 1 - self.partFriction / 100,
                                gravity: self.partGravity / 2,
                                hue: rand(hue - self.hueVariance, hue + self.hueVariance),
                                brightness: rand(50, 80),
                                alpha: rand(40, 100) / 100,
                                decay: rand(10, 50) / 1000,
                                wind: (rand(0, self.partWind) - (self.partWind / 2)) / 25,
                                lineWidth: self.lineWidth
                            };
                            self.particles.push(newParticle);
                        }
                    };
                    self.updateParticles = function() {
                        var i = self.particles.length;
                        while (i--) {
                            var p = self.particles[i];
                            var radians = p.angle * Math.PI / 180;
                            var vx = Math.cos(radians) * p.speed;
                            var vy = Math.sin(radians) * p.speed;
                            p.speed *= p.friction;
                            p.coordLast[2].x = p.coordLast[1].x;
                            p.coordLast[2].y = p.coordLast[1].y;
                            p.coordLast[1].x = p.coordLast[0].x;
                            p.coordLast[1].y = p.coordLast[0].y;
                            p.coordLast[0].x = p.x;
                            p.coordLast[0].y = p.y;
                            p.x += vx;
                            p.y += vy;
                            p.y += p.gravity;
                            p.angle += p.wind;
                            p.alpha -= p.decay;
                            if (!hitTest(0, 0, self.cw, self.ch, p.x - p.radius, p.y - p.radius, p.radius * 2, p.radius * 2) || p.alpha < .05) {
                                self.particles.splice(i, 1);
                            }
                        };
                    };
                    self.drawParticles = function() {
                        var i = self.particles.length;
                        while (i--) {
                            var p = self.particles[i];
                            var coordRand = (rand(1, 3) - 1);
                            self.ctx.beginPath();
                            self.ctx.moveTo(Math.round(p.coordLast[coordRand].x), Math.round(p.coordLast[coordRand].y));
                            self.ctx.lineTo(Math.round(p.x), Math.round(p.y));
                            self.ctx.closePath();
                            self.ctx.strokeStyle = 'hsla(' + p.hue + ', 100%, ' + p.brightness + '%, ' + p.alpha + ')';
                            self.ctx.stroke();
                            if (self.flickerDensity > 0) {
                                var inverseDensity = 50 - self.flickerDensity;
                                if (rand(0, inverseDensity) === inverseDensity) {
                                    self.ctx.beginPath();
                                    self.ctx.arc(Math.round(p.x), Math.round(p.y), rand(p.lineWidth, p.lineWidth + 3) / 2, 0, Math.PI * 2, false)
                                    self.ctx.closePath();
                                    var randAlpha = rand(50, 100) / 100;
                                    self.ctx.fillStyle = 'hsla(' + p.hue + ', 100%, ' + p.brightness + '%, ' + randAlpha + ')';
                                    self.ctx.fill();
                                }
                            }
                        };
                    };
                    self.createFireworks = function(startX, startY, targetX, targetY) {
                        var newFirework = {
                            x: startX,
                            y: startY,
                            startX: startX,
                            startY: startY,
                            hitX: false,
                            hitY: false,
                            coordLast: [{
                                    x: startX,
                                    y: startY
                                },
                                {
                                    x: startX,
                                    y: startY
                                },
                                {
                                    x: startX,
                                    y: startY
                                }
                            ],
                            targetX: targetX,
                            targetY: targetY,
                            speed: self.fworkSpeed,
                            angle: Math.atan2(targetY - startY, targetX - startX),
                            shockwaveAngle: Math.atan2(targetY - startY, targetX - startX) + (90 * (Math.PI / 180)),
                            acceleration: self.fworkAccel / 100,
                            hue: self.currentHue,
                            brightness: rand(50, 80),
                            alpha: rand(50, 100) / 100,
                            lineWidth: self.lineWidth
                        };
                        self.fireworks.push(newFirework);
                    };
                    self.updateFireworks = function() {
                        var i = self.fireworks.length;
                        while (i--) {
                            var f = self.fireworks[i];
                            self.ctx.lineWidth = f.lineWidth;
                            vx = Math.cos(f.angle) * f.speed,
                                vy = Math.sin(f.angle) * f.speed;
                            f.speed *= 1 + f.acceleration;
                            f.coordLast[2].x = f.coordLast[1].x;
                            f.coordLast[2].y = f.coordLast[1].y;
                            f.coordLast[1].x = f.coordLast[0].x;
                            f.coordLast[1].y = f.coordLast[0].y;
                            f.coordLast[0].x = f.x;
                            f.coordLast[0].y = f.y;
                            if (f.startX >= f.targetX) {
                                if (f.x + vx <= f.targetX) {
                                    f.x = f.targetX;
                                    f.hitX = true;
                                } else {
                                    f.x += vx;
                                }
                            } else {
                                if (f.x + vx >= f.targetX) {
                                    f.x = f.targetX;
                                    f.hitX = true;
                                } else {
                                    f.x += vx;
                                }
                            }
                            if (f.startY >= f.targetY) {
                                if (f.y + vy <= f.targetY) {
                                    f.y = f.targetY;
                                    f.hitY = true;
                                } else {
                                    f.y += vy;
                                }
                            } else {
                                if (f.y + vy >= f.targetY) {
                                    f.y = f.targetY;
                                    f.hitY = true;
                                } else {
                                    f.y += vy;
                                }
                            }
                            if (f.hitX && f.hitY) {
                                self.createParticles(f.targetX, f.targetY, f.hue);
                                self.fireworks.splice(i, 1);
                            }
                        };
                    };
                    self.drawFireworks = function() {
                        var i = self.fireworks.length;
                        self.ctx.globalCompositeOperation = 'lighter';
                        while (i--) {
                            var f = self.fireworks[i];
                            self.ctx.lineWidth = f.lineWidth;
                            var coordRand = (rand(1, 3) - 1);
                            self.ctx.beginPath();
                            self.ctx.moveTo(Math.round(f.coordLast[coordRand].x), Math.round(f.coordLast[coordRand].y));
                            self.ctx.lineTo(Math.round(f.x), Math.round(f.y));
                            self.ctx.closePath();
                            self.ctx.strokeStyle = 'hsla(' + f.hue + ', 100%, ' + f.brightness + '%, ' + f.alpha + ')';
                            self.ctx.stroke();
                            if (self.showTarget) {
                                self.ctx.save();
                                self.ctx.beginPath();
                                self.ctx.arc(Math.round(f.targetX), Math.round(f.targetY), rand(1, 8), 0, Math.PI * 2, false)
                                self.ctx.closePath();
                                self.ctx.lineWidth = 1;
                                self.ctx.stroke();
                                self.ctx.restore();
                            }
                            if (self.showShockwave) {
                                self.ctx.save();
                                self.ctx.translate(Math.round(f.x), Math.round(f.y));
                                self.ctx.rotate(f.shockwaveAngle);
                                self.ctx.beginPath();
                                self.ctx.arc(0, 0, 1 * (f.speed / 5), 0, Math.PI, true);
                                self.ctx.strokeStyle = 'hsla(' + f.hue + ', 100%, ' + f.brightness + '%, ' + rand(25, 60) / 100 + ')';
                                self.ctx.lineWidth = f.lineWidth;
                                self.ctx.stroke();
                                self.ctx.restore();
                            }
                        };
                    };
                    self.bindEvents = function() {
                        $(window).on('resize', function() {
                            clearTimeout(self.timeout);
                            self.timeout = setTimeout(function() {
                                self.canvas.width = self.cw = $(window).innerWidth();
                                self.canvas.height = self.ch = $(window).innerHeight();
                                self.ctx.lineCap = 'round';
                                self.ctx.lineJoin = 'round';
                            }, 100);
                        });
                        $(self.canvas).on('mousedown', function(e) {
                            self.mx = e.pageX - self.canvas.offsetLeft;
                            self.my = e.pageY - self.canvas.offsetTop;
                            self.currentHue = rand(self.hueMin, self.hueMax);
                            self.createFireworks(self.cw / 2, self.ch, self.mx, self.my);
                            $(self.canvas).on('mousemove.fireworks', function(e) {
                                self.mx = e.pageX - self.canvas.offsetLeft;
                                self.my = e.pageY - self.canvas.offsetTop;
                                self.currentHue = rand(self.hueMin, self.hueMax);
                                self.createFireworks(self.cw / 2, self.ch, self.mx, self.my);
                            });
                        });
                        $(self.canvas).on('mouseup', function(e) {
                            $(self.canvas).off('mousemove.fireworks');
                        });
                    }
                    self.clear = function() {
                        self.particles = [];
                        self.fireworks = [];
                        self.ctx.clearRect(0, 0, self.cw, self.ch);
                    };
                    self.canvasLoop = function() {
                        requestAnimFrame(self.canvasLoop, self.canvas);
                        self.ctx.globalCompositeOperation = 'destination-out';
                        self.ctx.fillStyle = 'rgba(0,0,0,' + self.clearAlpha / 100 + ')';
                        self.ctx.fillRect(0, 0, self.cw, self.ch);
                        self.updateFireworks();
                        self.updateParticles();
                        self.drawFireworks();
                        self.drawParticles();
                    };
                    self.init();
                }
                var fworks = new Fireworks();
                $('#info-toggle').on('click', function(e) {
                    $('#info-inner').stop(false, true).slideToggle(100);
                    e.preventDefault();
                });
            });
            console.log("Firework animation started");
            // Add your animation code here
        }
        // let reloadTimeout = setTimeout(function() {
        //     location.reload();
        // }, 5000);

        // Disable the timeout on form submission
        // document.getElementById('login-form').onsubmit = function() {
        //     clearTimeout(reloadTimeout);
        // };
        // Prevent firework animation from triggering on login form clicks
        document.addEventListener('click', function(event) {
            if (!document.querySelector('.login-container').contains(event.target)) {
                startFireworkAnimation(); // Call the firework animation function
            }
        });
    </script>


</body>

</html>

<!-- <script>
        $(function() {
            var Fireworks = function() {
                var styles = [
                    'background: linear-gradient(#D33106, #571402)', 'border: 1px solid #3E0E02', 'color: white', 'display: block', 'text-shadow: 0 1px 0 rgba(0, 0, 0, 0.3)', 'box-shadow: 0 1px 0 rgba(255, 255, 255, 0.4) inset, 0 5px 3px -5px rgba(0, 0, 0, 0.5), 0 -13px 5px -10px rgba(255, 255, 255, 0.4) inset', 'line-height: 40px', 'text-align: center', 'font-weight: bold'
                ].join(';');
                var self = this;
                var rand = function(rMi, rMa) {
                    return ~~((Math.random() * (rMa - rMi + 1)) + rMi);
                }
                var hitTest = function(x1, y1, w1, h1, x2, y2, w2, h2) {
                    return !(x1 + w1 < x2 || x2 + w2 < x1 || y1 + h1 < y2 || y2 + h2 < y1);
                };
                window.requestAnimFrame = function() {
                    return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function(a) {
                        window.setTimeout(a, 1E3 / 60)
                    }
                }();
                self.init = function() {
                    let dt = 'This Page is Designed By virtualgadgets.in';
                    self.canvas = document.createElement('canvas');
                    self.canvas.width = self.cw = $(window).innerWidth();
                    self.canvas.height = self.ch = $(window).innerHeight();
                    self.particles = [];
                    self.partCount = 150;
                    self.fireworks = [];
                    self.mx = self.cw / 2;
                    self.my = self.ch / 2;
                    self.currentHue = 30;
                    self.partSpeed = 5;
                    self.partSpeedVariance = 10;
                    self.partWind = 50;
                    self.partFriction = 5;
                    self.partGravity = 1;
                    self.hueMin = 0;
                    self.hueMax = 360;
                    self.fworkSpeed = 4;
                    self.fworkAccel = 10;
                    self.hueVariance = 30;
                    self.flickerDensity = 25;
                    self.showShockwave = true;
                    self.showTarget = false;
                    self.clearAlpha = 25;
                    console.log(`%c ${dt}`, styles);
                    $(document.body).append(self.canvas);
                    self.ctx = self.canvas.getContext('2d');
                    self.ctx.lineCap = 'round';
                    self.ctx.lineJoin = 'round';
                    self.lineWidth = 1;
                    self.bindEvents();
                    self.canvasLoop();
                    self.canvas.onselectstart = function() {
                        return false;
                    };
                };
                self.createParticles = function(x, y, hue) {
                    var audio = document.getElementById('audio1');
                    if (audio.paused) {
                        audio.play();
                    } else {
                        audio.currentTime = 0
                    }
                    var countdown = self.partCount;
                    while (countdown--) {
                        var newParticle = {
                            x: x,
                            y: y,
                            coordLast: [{
                                    x: x,
                                    y: y
                                },
                                {
                                    x: x,
                                    y: y
                                },
                                {
                                    x: x,
                                    y: y
                                }
                            ],
                            angle: rand(0, 360),
                            speed: rand(((self.partSpeed - self.partSpeedVariance) <= 0) ? 1 : self.partSpeed - self.partSpeedVariance, (self.partSpeed + self.partSpeedVariance)),
                            friction: 1 - self.partFriction / 100,
                            gravity: self.partGravity / 2,
                            hue: rand(hue - self.hueVariance, hue + self.hueVariance),
                            brightness: rand(50, 80),
                            alpha: rand(40, 100) / 100,
                            decay: rand(10, 50) / 1000,
                            wind: (rand(0, self.partWind) - (self.partWind / 2)) / 25,
                            lineWidth: self.lineWidth
                        };
                        self.particles.push(newParticle);
                    }
                };
                self.updateParticles = function() {
                    var i = self.particles.length;
                    while (i--) {
                        var p = self.particles[i];
                        var radians = p.angle * Math.PI / 180;
                        var vx = Math.cos(radians) * p.speed;
                        var vy = Math.sin(radians) * p.speed;
                        p.speed *= p.friction;
                        p.coordLast[2].x = p.coordLast[1].x;
                        p.coordLast[2].y = p.coordLast[1].y;
                        p.coordLast[1].x = p.coordLast[0].x;
                        p.coordLast[1].y = p.coordLast[0].y;
                        p.coordLast[0].x = p.x;
                        p.coordLast[0].y = p.y;
                        p.x += vx;
                        p.y += vy;
                        p.y += p.gravity;
                        p.angle += p.wind;
                        p.alpha -= p.decay;
                        if (!hitTest(0, 0, self.cw, self.ch, p.x - p.radius, p.y - p.radius, p.radius * 2, p.radius * 2) || p.alpha < .05) {
                            self.particles.splice(i, 1);
                        }
                    };
                };
                self.drawParticles = function() {
                    var i = self.particles.length;
                    while (i--) {
                        var p = self.particles[i];
                        var coordRand = (rand(1, 3) - 1);
                        self.ctx.beginPath();
                        self.ctx.moveTo(Math.round(p.coordLast[coordRand].x), Math.round(p.coordLast[coordRand].y));
                        self.ctx.lineTo(Math.round(p.x), Math.round(p.y));
                        self.ctx.closePath();
                        self.ctx.strokeStyle = 'hsla(' + p.hue + ', 100%, ' + p.brightness + '%, ' + p.alpha + ')';
                        self.ctx.stroke();
                        if (self.flickerDensity > 0) {
                            var inverseDensity = 50 - self.flickerDensity;
                            if (rand(0, inverseDensity) === inverseDensity) {
                                self.ctx.beginPath();
                                self.ctx.arc(Math.round(p.x), Math.round(p.y), rand(p.lineWidth, p.lineWidth + 3) / 2, 0, Math.PI * 2, false)
                                self.ctx.closePath();
                                var randAlpha = rand(50, 100) / 100;
                                self.ctx.fillStyle = 'hsla(' + p.hue + ', 100%, ' + p.brightness + '%, ' + randAlpha + ')';
                                self.ctx.fill();
                            }
                        }
                    };
                };
                self.createFireworks = function(startX, startY, targetX, targetY) {
                    var newFirework = {
                        x: startX,
                        y: startY,
                        startX: startX,
                        startY: startY,
                        hitX: false,
                        hitY: false,
                        coordLast: [{
                                x: startX,
                                y: startY
                            },
                            {
                                x: startX,
                                y: startY
                            },
                            {
                                x: startX,
                                y: startY
                            }
                        ],
                        targetX: targetX,
                        targetY: targetY,
                        speed: self.fworkSpeed,
                        angle: Math.atan2(targetY - startY, targetX - startX),
                        shockwaveAngle: Math.atan2(targetY - startY, targetX - startX) + (90 * (Math.PI / 180)),
                        acceleration: self.fworkAccel / 100,
                        hue: self.currentHue,
                        brightness: rand(50, 80),
                        alpha: rand(50, 100) / 100,
                        lineWidth: self.lineWidth
                    };
                    self.fireworks.push(newFirework);
                };
                self.updateFireworks = function() {
                    var i = self.fireworks.length;
                    while (i--) {
                        var f = self.fireworks[i];
                        self.ctx.lineWidth = f.lineWidth;
                        vx = Math.cos(f.angle) * f.speed,
                            vy = Math.sin(f.angle) * f.speed;
                        f.speed *= 1 + f.acceleration;
                        f.coordLast[2].x = f.coordLast[1].x;
                        f.coordLast[2].y = f.coordLast[1].y;
                        f.coordLast[1].x = f.coordLast[0].x;
                        f.coordLast[1].y = f.coordLast[0].y;
                        f.coordLast[0].x = f.x;
                        f.coordLast[0].y = f.y;
                        if (f.startX >= f.targetX) {
                            if (f.x + vx <= f.targetX) {
                                f.x = f.targetX;
                                f.hitX = true;
                            } else {
                                f.x += vx;
                            }
                        } else {
                            if (f.x + vx >= f.targetX) {
                                f.x = f.targetX;
                                f.hitX = true;
                            } else {
                                f.x += vx;
                            }
                        }
                        if (f.startY >= f.targetY) {
                            if (f.y + vy <= f.targetY) {
                                f.y = f.targetY;
                                f.hitY = true;
                            } else {
                                f.y += vy;
                            }
                        } else {
                            if (f.y + vy >= f.targetY) {
                                f.y = f.targetY;
                                f.hitY = true;
                            } else {
                                f.y += vy;
                            }
                        }
                        if (f.hitX && f.hitY) {
                            self.createParticles(f.targetX, f.targetY, f.hue);
                            self.fireworks.splice(i, 1);
                        }
                    };
                };
                self.drawFireworks = function() {
                    var i = self.fireworks.length;
                    self.ctx.globalCompositeOperation = 'lighter';
                    while (i--) {
                        var f = self.fireworks[i];
                        self.ctx.lineWidth = f.lineWidth;
                        var coordRand = (rand(1, 3) - 1);
                        self.ctx.beginPath();
                        self.ctx.moveTo(Math.round(f.coordLast[coordRand].x), Math.round(f.coordLast[coordRand].y));
                        self.ctx.lineTo(Math.round(f.x), Math.round(f.y));
                        self.ctx.closePath();
                        self.ctx.strokeStyle = 'hsla(' + f.hue + ', 100%, ' + f.brightness + '%, ' + f.alpha + ')';
                        self.ctx.stroke();
                        if (self.showTarget) {
                            self.ctx.save();
                            self.ctx.beginPath();
                            self.ctx.arc(Math.round(f.targetX), Math.round(f.targetY), rand(1, 8), 0, Math.PI * 2, false)
                            self.ctx.closePath();
                            self.ctx.lineWidth = 1;
                            self.ctx.stroke();
                            self.ctx.restore();
                        }
                        if (self.showShockwave) {
                            self.ctx.save();
                            self.ctx.translate(Math.round(f.x), Math.round(f.y));
                            self.ctx.rotate(f.shockwaveAngle);
                            self.ctx.beginPath();
                            self.ctx.arc(0, 0, 1 * (f.speed / 5), 0, Math.PI, true);
                            self.ctx.strokeStyle = 'hsla(' + f.hue + ', 100%, ' + f.brightness + '%, ' + rand(25, 60) / 100 + ')';
                            self.ctx.lineWidth = f.lineWidth;
                            self.ctx.stroke();
                            self.ctx.restore();
                        }
                    };
                };
                self.bindEvents = function() {
                    $(window).on('resize', function() {
                        clearTimeout(self.timeout);
                        self.timeout = setTimeout(function() {
                            self.canvas.width = self.cw = $(window).innerWidth();
                            self.canvas.height = self.ch = $(window).innerHeight();
                            self.ctx.lineCap = 'round';
                            self.ctx.lineJoin = 'round';
                        }, 100);
                    });
                    $(self.canvas).on('mousedown', function(e) {
                        self.mx = e.pageX - self.canvas.offsetLeft;
                        self.my = e.pageY - self.canvas.offsetTop;
                        self.currentHue = rand(self.hueMin, self.hueMax);
                        self.createFireworks(self.cw / 2, self.ch, self.mx, self.my);
                        $(self.canvas).on('mousemove.fireworks', function(e) {
                            self.mx = e.pageX - self.canvas.offsetLeft;
                            self.my = e.pageY - self.canvas.offsetTop;
                            self.currentHue = rand(self.hueMin, self.hueMax);
                            self.createFireworks(self.cw / 2, self.ch, self.mx, self.my);
                        });
                    });
                    $(self.canvas).on('mouseup', function(e) {
                        $(self.canvas).off('mousemove.fireworks');
                    });
                }
                self.clear = function() {
                    self.particles = [];
                    self.fireworks = [];
                    self.ctx.clearRect(0, 0, self.cw, self.ch);
                };
                self.canvasLoop = function() {
                    requestAnimFrame(self.canvasLoop, self.canvas);
                    self.ctx.globalCompositeOperation = 'destination-out';
                    self.ctx.fillStyle = 'rgba(0,0,0,' + self.clearAlpha / 100 + ')';
                    self.ctx.fillRect(0, 0, self.cw, self.ch);
                    self.updateFireworks();
                    self.updateParticles();
                    self.drawFireworks();
                    self.drawParticles();
                };
                self.init();
            }
            var fworks = new Fireworks();
            $('#info-toggle').on('click', function(e) {
                $('#info-inner').stop(false, true).slideToggle(100);
                e.preventDefault();
            });
        });
    </script> -->