<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">


    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Dashboard</title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="gplogofinal.png" type="png">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <!-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css"> -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.1.6/dist/sweetalert2.min.css">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- for icon -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css" rel="stylesheet">
    <!-- DataTables CSS 
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css"> -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <!-- Buttons CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <!-- Bootstrap popup-->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/css/flatpickr.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/fixedcolumns/3.3.0/css/fixedColumns.dataTables.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/css/bootstrap-datepicker.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css">

    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">

    <style type="text/css">
        .navbar {
            background: #13265C;
        }

        .nav-link:hover {
            color: #9ffb00 !important;
        }

        .dropdown-menu.left {
            left: auto;
            right: 0;
        }

        .active {

            border-radius: 10px;
            color: #fff;
            font-weight: 500;
            border: 2px solid white;

        }

        body {
            /* padding-top: 50px;  */
            color: #1a202c;
            text-align: left;
            background-color: #e2e8f0;
        }

        .main-body {
            padding: 15px;
        }

        .card {
            box-shadow: 0 1px 3px 0 rgba(0, 0, 0, .1), 0 1px 2px 0 rgba(0, 0, 0, .06);
        }

        .card {
            position: relative;
            display: flex;
            flex-direction: column;
            min-width: 0;
            word-wrap: break-word;
            background-color: #fff;
            background-clip: border-box;
            border: 0 solid rgba(0, 0, 0, .125);
            border-radius: .25rem;
        }

        .card-body {
            flex: 1 1 auto;
            min-height: 1px;
            padding: 0rem;
        }

        .gutters-sm {
            margin-right: -8px;
            margin-left: -8px;
        }

        .gutters-sm>.col,
        .gutters-sm>[class*=col-] {
            padding-right: 8px;
            padding-left: 8px;
        }

        .mb-3,
        .my-3 {
            margin-bottom: 1rem !important;
        }

        .bg-gray-300 {
            background-color: #e2e8f0;
        }

        .h-100 {
            height: 100% !important;
        }

        .shadow-none {
            box-shadow: none !important;
        }

        .rounded {
            border-radius: 50%;
            border: 2px solid #ccc;
            cursor: pointer;

        }

        .profile-img {
            text-align: center;
        }

        .profile-img .file {
            position: relative;
            overflow: hidden;
            margin-top: -25%;
            width: 51%;
            border: none;
            border-radius: 0;
            font-size: 15px;
            background: #212529b8;
        }

        .profile-img .file input {
            position: absolute;
            opacity: 0;
            right: 0;
            top: 0;
        }

        .preloder {
            display: none;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999999;
            background: #ffffffbd;
            justify-content: center;
            align-items: center;
            display: flex;
        }

        .lds-hourglass,
        .lds-hourglass:after {
            box-sizing: border-box;
        }

        .lds-hourglass {
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: relative;
            width: 80px;
            height: 80px;
        }

        .lds-hourglass:after {
            content: " ";
            display: block;
            border-radius: 50%;
            width: 0;
            height: 0;
            margin: 8px;
            box-sizing: border-box;
            border: 32px solid currentColor;
            border-color: currentColor transparent currentColor transparent;
            animation: lds-hourglass 1.2s infinite;
        }

        @keyframes lds-hourglass {
            0% {
                transform: rotate(0);
                animation-timing-function: cubic-bezier(0.55, 0.055, 0.675, 0.19);
            }

            50% {
                transform: rotate(900deg);
                animation-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
            }

            100% {
                transform: rotate(1800deg);
            }
        }

        .row {
            margin: 0 !important;
        }


        #trimsStatusModaltable th:nth-child(2),
        #trimsStatusModaltable td:nth-child(2) {
            width: 100px; /* adjust as you like */
            min-width: 100px;
            max-width: 300px; /* optional */
        }
 
        #trimsStatusModaltable th:nth-child(3),
        #trimsStatusModaltable td:nth-child(3) {
            width: 50px; /* adjust as you like */
           
         
        }
 
        #trimsStatusModaltable tbody th, table.dataTable tbody td {
            padding: 6px 8px;
        }
    </style>


    <!-- NEWWW.. -->
    <style>
        .header {
            background-color: #72a3e0;
            padding: 0;
            border-radius: 2px;
            text-align: center;
            color: white;
            padding-top: 3px;
            padding-bottom: 3px;
        }

        .title {
            padding: 0px;
            border-radius: 10px;
        }

        .all_backgr {
            background-color: rgb(237, 240, 244);
        }

        .white {
            background-color: white;
        }

        .vl {
            border-left: 10px solid rgb(237, 240, 244);
            height: 500px;
        }

        .chart_title {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #72a3e0;
            padding: 0px;
            border-radius: 10px;
        }

        @media screen and (max-width: 768px) {

            /* Adjust max-width as needed */
            .vl {
                display: none;
            }
        }
    </style>

    <!-- CAP PLAN CARD -->
    <style>
        .sideallign {
            text-align: end !important;
        }

        .leftallign {
            text-align: start !important;
        } 
        .capplTable {
            border-collapse: separate;
            border-spacing: 0;
            width: 230px;
            /* margin: 20px auto; */
            text-align: center;
            border: 1px solid #000;
            border-radius: 12px;
            overflow: hidden;
            height: 9px !important;
            background: white !important;
        }

        .capplThead {
            background-color: #f4f4f4;
        }

        .capplth {
            font-weight: bold;
            padding: 1px;
        }

        .cappltd {
            padding: 10px;
            padding-top: 0;
            padding-bottom: 28px;
            position: relative;
        }

        .cappl-row-heading {
            font-weight: bold;
            font-size: 14px;
            padding-top: 0;
            align-items: center;
            text-align: center;
            word-wrap: break-word;
            max-width: 200px;
        }

        .cappl-row-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .cappl-left {
            text-align: left;
        }

        .cappl-right {
            text-align: right;
            font-size: 24px;
            font-weight: bold;
        }

        .cappl-target {
            font-weight: bold;
            font-size: 14px;
            color: gray;
        }

        .cappl-percentage {
            display: flex;
            align-items: center;
            gap: 5px;
            font-size: 14px;
        }

        .cappl-percentage.green {
            color: green;
        }

        .cappl-percentage.red {
            color: red;
        }

        .cappl-arrow {
            font-size: 12px;
        }

        /* Dotted line separator */
        .cappltd:after {
            content: "";
            display: block;
            width: 90%;
            border-bottom: 1px dotted black;
        }

        /* Remove last dotted line */
        tr:last-child td:after {
            content: none;
        }

        /* #yearBtn_DIS, */
        #monthBtn_DIS,
        #weekBtn_DIS {
            background: transparent;
            border: none;
            font-weight: 900;
            font-size: 15px;
        }
       

        .chartfour.active{
            border: none;
            font-size: 15px;
            border-radius: 10px;
            color: #fff;
            background-color: #0d6efd !important;
            font-weight: 900;
            border: 2px solid white;   
        }

        .chartfour.active:hover {
            background-color: #0a58ca;
            border-color: #fff;
        }
    </style>

    <!-- BUYER DROPDOWN -->
    <style>
        .dropdown-menu {
            list-style: none;
            margin: 0;
            padding: 0;
        }

        .dropdown-menu li {
            padding: 0px 1px;
            cursor: pointer;
        }

        .dropdown-menu li a {
            text-decoration: none;
            color: #000;
            display: block;
        }

        .dropdown-menu li:hover {
            background-color: rgb(211, 219, 226);
        }

        .dropdown-submenu {
            position: relative;
        }

        .dropdown-submenu > .dropdown-menu {
            top: 0;
            left: 100%;
            margin-top: -6px;
            margin-left: 0;
            display: none;
        }

        .dropdown-submenu:hover > .dropdown-menu {
            display: block;
        }
    </style>

    <!-- SPINNER -->    
    <style>
        
        #preloder {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999999;
            background: #ffffffbd;
            justify-content: center;
            align-items: center;
            display: flex;
        }

        .lds-hourglass,
        .lds-hourglass:after {
            box-sizing: border-box;
        }

        .lds-hourglass {
            display: inline-block;
            position: relative;
            width: 80px;
            height: 80px;
        }

        .lds-hourglass:after {
            content: " ";
            display: block;
            border-radius: 50%;
            width: 0;
            height: 0;
            margin: 8px;
            box-sizing: border-box;
            border: 32px solid currentColor;
            border-color: currentColor transparent currentColor transparent;
            animation: lds-hourglass 1.2s infinite;
        }

        @keyframes lds-hourglass {
            0% {
                transform: rotate(0);
                animation-timing-function: cubic-bezier(0.55, 0.055, 0.675, 0.19);
            }

            50% {
                transform: rotate(900deg);
                animation-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
            }

            100% {
                transform: rotate(1800deg);
            }
        }
        .preloder {
                display: none;
                display: flex;
                justify-content: space-between;
                align-items: center;
                position: fixed;
                width: 100%;
                height: 100%;
                top: 0;
                left: 0;
                z-index: 999999;
                background: #ffffffbd;
                justify-content: center;
                align-items: center;
                display: flex;
            }

            .lds-hourglass,
            .lds-hourglass:after {
                box-sizing: border-box;
            }

            .lds-hourglass {
                display: flex;
                justify-content: space-between;
                align-items: center;
                position: relative;
                width: 80px;
                height: 80px;
            }

            .lds-hourglass:after {
                content: " ";
                display: block;
                border-radius: 50%;
                width: 0;
                height: 0;
                margin: 8px;
                box-sizing: border-box;
                border: 32px solid currentColor;
                border-color: currentColor transparent currentColor transparent;
                animation: lds-hourglass 1.2s infinite;
            }

            @keyframes lds-hourglass {
                0% {
                    transform: rotate(0);
                    animation-timing-function: cubic-bezier(0.55, 0.055, 0.675, 0.19);
                }

                50% {
                    transform: rotate(900deg);
                    animation-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
                }

                100% {
                    transform: rotate(1800deg);
                }
            }

            .sideallign {
            text-align: end !important;
        }

    </style>

    <!-- OWE CARD -->
    <style>
        .oweTable {
            border-collapse: separate;
            border-spacing: 0;
            width: 100px;
            text-align: center;
            border: 1px solid #000;
            border-radius: 12px;
            overflow: hidden;
            background: white !important;
        }

        .oweThead {
            background-color: #f4f4f4;
        }

        .oweth {
            font-weight: bold;
            padding: 0;
        }

        .owetd {
            padding: 10px;
            padding-top: 0;
            padding-bottom: 0;
            position: relative;
        }

        .owe-row-heading {
            font-weight: bold;
            font-size: 10px;
            padding-top: 0;
            align-items: center;
            text-align: center;
            word-wrap: break-word;
            max-width: 200px;
            /* padding-bottom: 5px;
            padding-top: 3px; */
        }

        .owe-row-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .owe-left {
            text-align: left;
        }

        .owe-right {
            text-align: right;
            font-size: 18px;
            font-weight: bold;
            padding-left: 5px;
        }

        .owe-target {
            font-weight: bold;
            font-size: 14px;
            color: gray;
        }

        .owe-percentage {
            display: flex;
            align-items: center;
            gap: 5px;
            font-size: 14px;
        }

        .owe-percentage.green {
            color: green;
        }

        .owe-percentage.red {
            color: red;
        }

        .owe-arrow {
            font-size: 12px;
        }

        /* Dotted line separator */
        .owetd:after {
            content: "";
            display: block;
            width: 90%;
            border-bottom: 1px dotted black;
        }

        /* Remove last dotted line */
        .owetr:last-child td:after {
            content: none;
        }

        #oweyearBtn,
        #owemonthBtn,
        #oweweekBtn,
        #oweQBtn,
        #oweDBtn {
            background: transparent;
            border: none;
            font-weight: 600;
            font-size: 12px;
            text-align: center;
            font-family: Inter;
        }
    </style>

    <style>

        .click-text{
                
                z-index: 10;
                text-align: center;
                text-decoration: none;
                font-weight: bold;
            }

        /* .apexcharts-text, */
        .hexowe .apexcharts-xaxis-label {
            display: none;
        }

        .hexowe .apexcharts-legend {
            right: 0px !important;
            position: absolute !important;
            /* left: 0px !important; */
            top: 10px !important;
            max-height: 125px !important;
        }
        /* .firstChart .apexcharts-legend {
            display: none !important;
        } */
        .apexcharts-datalabels-group{
            width: 20px;
        }
        .apexcharts-datalabel-label {
            font-size: 12px !important;
            font-weight: bold !important;
            text-wrap:wrap;
        }

        .apexcharts-datalabel-value {
            font-size: 15px !important;
            font-weight: bold !important;
            fill: #ff2089 !important; /* Change color */
        }

        .buttons {
            text-align: center;
            margin-top: 10px;
        }
        .buttons button {
            margin: 5px;
            padding: 10px 15px;
            border: none;
            cursor: pointer;
            background-color: #007bff;
            color: white;
            border-radius: 5px;
        }
        button.active {
            background-color: #0056b3;
        }
    </style>
    <style>
        .ck_actuallist-column-filter,.supplyerpotable-column-filter {
            font-size: 10px;
            padding: 2px 4px;
            height: auto;
        }

        .ck_actuallist-column-filter option,.supplyerpotable-column-filter option {
            font-size: 10px;
        }
    
        #ck_actuallist_filter,#supplyerpotable_filter {
            font-size: 10px;
        }

        #ck_actuallist_filter label ,#supplyerpotable_filter label {
            font-weight: normal;
            margin-bottom: 0;
        }

        #ck_actuallist_filter input[type="search"] ,#supplyerpotable_filter input[type="search"] {
            font-size: 10px;
            padding: 2px 4px;
            height: auto;
            width: 120px; /* Optional: control width */
            margin-left: 4px;
        }
    </style>
    <!-- MODAL -->
    <style>
            /* Modal styles */
            .modal {
                display: none;
                /* Hidden by default */
                position: fixed;
                z-index: 1000;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                overflow: auto;
                background-color: rgba(0, 0, 0, 0.8);
                /* Black background with opacity */
            }

            .modal-content {
                margin: auto;
                padding: 0;
                width: 90%;
                height: 90%;
                display: flex;
                /* justify-content: center;
                align-items: center; */
                background-color: white;
                border-radius: 8px;
                overflow: hidden;
            }

            .close {
                position: absolute;
                right: 20px;
                top: 20px;
                color: #aaa;
                font-size: 28px;
                font-weight: bold;
                cursor: pointer;
            }

            .close:hover,
            .close:focus {
                color: black;
                text-decoration: none;
                cursor: pointer;
            }

            #chartContainer {
                width: 100%;
                height: 100%;
            }
            #finalDetailsContent tr > td,#finalDetailsContent tr > th {
                font-size:10px;
                padding:2px;
                margin:2px;
                border:1px solid;
            }

            .modal {
                z-index: 1050; /* Default Bootstrap z-index */
            }

            #DefectDetailsModal {
                z-index: 1060 !important; /* Set higher z-index for OCN-wise modal */
            }

            .modal-body{
                overflow-x: auto;
            }

                    /* trims_ck */
        .custom-modal-xxl {
            width: 100vw;
            max-width: 100% !important;
            margin: 1rem auto;
        }
            
    </style>
    <!-- <style>
        #supplyerpotable {
            font-size: 10px; /* Smaller font */
            margin: 0;
            padding: 0;
            width: 90%;
            border-collapse: collapse;
            table-layout: auto;
        }

        #supplyerpotable th,
        #supplyerpotable td {
            padding: 4px 6px; /* Tighten padding */
            margin: 0;
            white-space: nowrap;
        }

        #supplierpomodel {
            overflow-x: auto;
        }

        .dataTables_wrapper {
            padding: 0;
            margin: 0;
        }

        .modal-content {
            max-height: 90vh;
            overflow: auto;
        }
    </style> -->

    <style>
        #orderDetailsModal .modal-dialog {
            max-width: 90%; /* Adjust as needed */
            width: 90%;
        }
        .modal-dialog.modal-sm {
            max-width: 400px !important;
            /* Adjust the width of the small modal */
        }

        .modal-body {
            padding: 10px;
            /* Adjust the padding inside the modal */
        }
        .table_popup {
            font-size: 11px !important;
        }

        .modal_popup {
            max-width: 1375px !important;
        }
        .modal_popup1 {
            max-width: 1550px !important;
        }
    </style>

    <!-- calendar icon hover -->
    <style>
        .calender_icon:hover i {
            color: black;
        }
        .modal-backdrop {
            display: none !important;
        }
        .full-height {
            min-height: 15vh; /* Full viewport height */
            background-color: white; /* Ensures white background */
        }
        .dataTables_wrapper .dataTables_filter input{
            height: 25px;
        }

        #chartWrapper:fullscreen {
        background-color: #fff;
        padding: 10px;
        }

        #chartScrollWrapper {
            overflow-x: auto;
        }
        #FileStatusFabricabstractTable{
            width: 100% !important;
        }
        
        div.dataTables_filter {
            margin-bottom: 15px; 
        }

        #FileStatusFabricabstractTable td:nth-child(1){
            width:200px;
        }

        #FileStatusFabricabstractTable td:nth-child(2){
            width:100px;
        }

        .table>:not(:last-child)>:last-child>* {
            border-bottom-color: #dedede !important;
        }

        table.dataTable {
            border-color: #dedede !important;
            border-collapse: collapse !important;
            border-spacing: 0 !important;
        }
        
    </style>

</head>
<body id="body" class="">
    <!-- spinner -->

    <!-- spinner end -->
    @apexchartsScripts
    @extends('LifeAtGainup.Navbar.Other_Chn')
    @section('content')

    @php
    $empl_no= Session::get('empl_id');
    $empl_name = Session::get('emp_name');
    @endphp

    <div id="layout-wrapper">
        <div class="mt-2">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card all_backgr">
                                <div class="card-header header mt-2 h-100">
                                    <div class="row">
                                        <div class="col-md-12" style="border-radius: 10px;">
                                            <h5>
                                              GUT Dashboard
                                            </h5>
                                        </div>
                                    </div>
                                </div>
                                <br>

                                <!-- <div class="row">
                                    <div class="col-md-12 d-flex justify-content-between align-items-center">
                                        <nav aria-label="breadcrumb" class="d-flex align-items-center">
                                            <ol class="breadcrumb mb-0">
                                                <li class="breadcrumb-item">
                                                    
                                                        <i class="fas fa-chart-pie me-1"></i>CXO
                                                    
                                                </li>
                                                <li class="breadcrumb-item me-1" aria-current="page">
                                                <a href="/checkingdashboard" class="text-decoration-none text-primary">
                                                        <i class="fas fa-chart-pie me-1"></i>Quality Portal
                                                    </a>
                                                </li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div> -->
                                <div class="card-body">
                                    <div class="row">
                                        <!-- 1st -->
                                        <div class="col-lg-4 title">
                                            <div class="row">
                                            <div class="title white">
                                                    <div class="chart_title">
                                                        <input type="text" id="qlty_fdate" style="display: none;" placeholder="dd-mm-yyyy">
                                                        <button id="QltycalendarIcon" style="color: #fff;" class="btn btn-outline-light calender_icon">
                                                            <i class="fa-regular fa-calendar-days"></i>
                                                        </button>
                                                        <h6 style="color: #fff; text-align: center;">Quality Checking</h6>
                                                        <button id='full_screendefect' class="btn">
                                                            <i class="fa fa-arrows-alt" style="color: #fff;"></i>
                                                        </button>
                                                        <!-- Quality Type Selection -->
                                                        <button id="QltyoptionsButton" class="btn QltyoptionsButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fa fa-clipboard-check" style="color: #fff;"></i>
                                                        </button>
                                                        <ul class="dropdown-menu" aria-labelledby="QltyoptionsButton">
                                                            <li><a class="dropdown-item method opt" data-check="opt" data-value="Presentation" href="javascript:void(0);">Presentation</a></li>
                                                            <!-- <li><a class="dropdown-item method opt"  data-check="opt"  data-value="Endline" href="javascript:void(0);">Endline</a></li> -->
                                                        </ul>
                                                        <button id='ocnno_filter' class="btn ocnno_filter" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fa fa-search-plus" style="color: #fff;"></i>
                                                        </button>
                                                        <ul class="dropdown-menu" aria-labelledby="ocnno_filter">
                                                            <input type="text" class="form-control ocnnotext" id="ocntxt" placeholder="CC No" /> 
                                                        </ul>
                                                        <!-- Unit Selection -->
                                                        <button id="unitoptionsButton" class="btn unitoptionsButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fa fa-industry" style="color: #fff;"></i>
                                                        </button>
                                                        <ul class="dropdown-menu" aria-labelledby="unitoptionsButton">
                                                            <li><a class="dropdown-item method unit"  data-check="unit"  data-value="" href="javascript:void(0);">ALL</a></li>
                                                            <li><a class="dropdown-item method unit" data-check="unit" data-value="T-W-I" href="javascript:void(0);">T-W-I</a></li>
                                                           
                                                        </ul>

                                                        <!-- Buyer Selection -->
                                                        <button id="QltyoptionsButton-user" class="btn QltyoptionsButton-user" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fa fa-user" style="color: #fff;"></i>
                                                        </button>
                                                        <ul class="dropdown-menu" id="buyerdefDropdown" aria-labelledby="QltyoptionsButton-user">
                                                            <li><a class="dropdown-item method buyer" data-check="buyer" data-value="" href="javascript:void(0);">ALL</a></li>
                                                          

                                                        </ul>
                                                    </div>
                                                    <div id="chartWrapper" style="overflow-x: auto; overflow-y: hidden; height: 465px;">
                                                        <div id="efficiencyChart" style="min-width: 1500px;"></div>
                                                    </div>
                                                </div> 
                                            </div>
                                            <br>
                                          ]
                                        </div>

                                      
                                    </div>
                                    <br>
                                    <!-- 6th -->
                                    
                                    <br><br><br><br><br>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <!-- Modal Container -->
    <div id="chartModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <div class="card">
                <div class="card-header">
                    <h3 id ='Chart_title'>Chart Title</h3>
                </div>
                <div class="card-body">
                    <div id="chartContainer"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Final Details Modal -->
    <div class="modal fade" id="finalDetailsModal" tabindex="-1" aria-labelledby="finalDetailsTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="finalDetailsTitle">Buyer Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="finalDetailsContent">
                    <!-- Buyer details will be loaded here -->
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <!-- DataTables JS -->

    <script src="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <!-- chart plugin  -->

    <!-- CALENDAR -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

    <!-- BRM CHART -->
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>


    <script src="{{ asset('custom\seeting.js') }}"></script>


    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>

   
    <script>
    // Initialize Flatpickr for date selection
    const flatpickrInstanceQlty = flatpickr("#qlty_fdate", {
        dateFormat: "d-M-Y", // Format to match SQL requirement
        mode: "range",
        allowInput: true,
        defaultDate: getCurrentMonthDates(),
        appendTo: document.querySelector(".title.white"),
        onChange: function (selectedDates, dateStr) {
            if (selectedDates.length === 2) {
                updateQltyChart();
            }
        }
    });
    

    // Open Date Picker when clicking the calendar icon
    document.getElementById("QltycalendarIcon").addEventListener("click", function () {
        flatpickrInstanceQlty.open();
    });

    // Function to collect selected filters and update the chart
    function updateQltyChart() {
        let dateRange = document.getElementById("qlty_fdate").value;
        let dates = dateRange ? dateRange.split(" to ") : [];
        let fdate = dates[0] || "";
        let tdate = dates[1] || "";

        let qltyType = $(".dropdown-item.method.opt.active").data("value") || "Presentation";
        let unit = $(".dropdown-item.method.unit.active").data("value") || "";
        let buyer = $(".dropdown-item.method.buyer.active").data("value") || "";
        let ocntxt = $("#ocntxt").val() || "";

        console.log("Selected Filters:", { fdate, tdate, qltyType, unit, buyer,ocntxt });

        $.ajax({
            url: qltyType === "Presentation" ? "{{ route('wovenquality.Presentationquality') }}" : "{{ route('quality.Endlinequality') }}",
            method: "GET",
            data: { fdate, tdate, buyer, unit ,ocntxt},
            success: function (response) {
                let data = response.result.data.presentation;
                // Extract unique dates and units
                let months = [...new Set(data.map(item => item.Edate))];
                let units = [...new Set(data.map(item => item.Unit))];
                // Format data for ApexCharts
                let seriesData = units.map(unit => ({
                    name: unit,
                    data: months.map(date => {
                        let unitData = data.filter(item => item.Unit === unit && item.Edate === date);
                        return unitData.length > 0 ? parseFloat(unitData[0].Def_Perc) || 0 : 0;
                    })
                }));

                const chartScrollWrapper = document.getElementById("chartWrapper");
                const chartEl = document.getElementById("efficiencyChart");

                if (months.length > 30) {
                    chartEl.style.minWidth = (months.length * 30) + "px"; // Adjust width
                    chartScrollWrapper.style.overflowX = "auto";
                } else {
                    chartEl.style.minWidth = "95%";
                    chartScrollWrapper.style.overflowX = "hidden";
                }

                // Update the chart
                chartpred.updateOptions({
                    title: {
                        text: `${qltyType} Defect % (${dateRange}) - ${unit || 'All Units'} - ${buyer || 'All Buyers'}`,
                        align: 'center',
                        style: {
                            fontSize: '9px',
                            fontWeight: 'bold'
                        }
                    },
                    xaxis: { categories: months },
                    series: seriesData
                });
            },
            error: function (xhr, status, error) {
                console.error("Error fetching data:", error);
            }
        });
    }

    // Event Listeners for dropdowns
    $(document).ready(function () {
        $(".dropdown-item.method.opt, .dropdown-item.method.unit, .dropdown-item.method.buyer").on("click", function () {
            $(".dropdown-item.method." + $(this).attr("data-check")).removeClass("active");
            $(this).addClass("active");
            updateQltyChart();
        });
    });

    
    $(".ocnnotext").keypress(function(){
        //if($(this).val()>1000){     
            updateQltyChart();           
        //}
    });

    // Function to get the first and last date of the current month in "dd-MMM-yyyy" format
    function getCurrentMonthDates() {
        let now = new Date();
        let firstDay = new Date(now.getFullYear(), now.getMonth(), 1);
        let lastDay = new Date(now.getFullYear(), now.getMonth() + 1, 0);

        // Format the dates as "dd-MMM-yyyy"
        let formatDate = (date) => date.toLocaleDateString('en-GB', {
            day: '2-digit', month: 'short', year: 'numeric'
        }).replace(',', '');

        return `${formatDate(firstDay)} to ${formatDate(lastDay)}`;
    }

    // Set the default date value
    document.getElementById("qlty_fdate").value = getCurrentMonthDates();
    //document.getElementById("qlty_dateLabel").textContent = $('#qlty_fdate').val();

    // Initialize ApexCharts
    var optionspred = {
        chart: {
            type: 'area',
            height: 420,
            toolbar: { show: false },
            zoom: { enabled: true },
            animations: { enabled: true },
            selection: { enabled: true },
            sparkline: { enabled: false },
            events: {
                markerClick: function(event, chartContext, { seriesIndex, dataPointIndex }) {
                    var selectedUnit = chartContext.w.config.series[seriesIndex].name;
                    var selectedMonth = chartContext.w.globals.categoryLabels[dataPointIndex]; 

                    var chartTypeSelector = $(".dropdown-item.method.opt.active").data("value") || "Presentation";
                    let unit = $(".dropdown-item.method.unit.active").data("value") || "";

                    //var chartTypeSelector=$(".chartTypeSelector.active").data("value");
                    var urldt = chartTypeSelector === "Presentation"
                        ? "{{ route('woven_presentation_checking_date') }}"
                        : "{{ route('endline_checking_date') }}"; 

                    

                    $.ajax({
                        url: urldt,
                        method: 'GET',
                        data: { Unit: unit, seldate: selectedMonth },
                        success: function(response) {
                            
                            $(".modal-backdrop").remove();
                            $("body").removeClass("modal-open");
                            
                            $("#finalDetailsModal").modal("show");
                            
                            $("#finalDetailsTitle").text(`${chartTypeSelector} Checking Details -  ${selectedMonth}`);
                            //$('#date_note').text('Current month selected by default');

                            // Filter out the Slno column from the headers
                            let filteredKeys = Object.keys(response.data.datewish[0]).filter(key => key !== 'Slno');

                            let tableHtml = `<table class='table table-hover table-bordered' style='font-size: 12px' id='processpotable2'>
                                <thead><tr>` +
                                filteredKeys.map(key => `<th>${key}<br><select style="width: 100%;"><option value="">All</option></select></th>`).join('') +
                                `</tr></thead><tbody>`;

                            response.data.datewish.forEach(row => {
                                let unitval = row['Unit'];
                                tableHtml += "<tr>" + filteredKeys.map(key => {
                                    return key === 'Edate' 
                                        ? `<td><a href='' class='defectcheck' data-optdate='${row[key]}' data-unit='${unitval}'>${row[key]}</a></td>` 
                                        : `<td>${row[key]}</td>`;
                                }).join('') + "</tr>";
                            });

                            // tableHtml += `</tbody><tfoot><tr>` + 
                            //     Object.keys(response.data.datewish[0]).map(() => `<th></th>`).join('') + 
                            //     `</tr></tfoot></table>`;

                            $("#finalDetailsContent").html(tableHtml);

                            $.getScript("https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js", function() {
                                var table = $('#processpotable2').DataTable({
                                    paging: false,
                                    searching: true,
                                    ordering: false,
                                    rowCallback: function(row, data) {
                                        var edateColumnIndex = null;
                                        $('#processpotable2 thead th').each(function(index) {
                                            if ($(this).text().trim().startsWith("Edate")) {
                                                edateColumnIndex = index;
                                            }
                                        });

                                        if (edateColumnIndex !== null) {
                                            const edateCell = $('td', row).eq(edateColumnIndex);
                                            const edateText = edateCell.find('a').text().trim();

                                            if (edateText === "1900-01-01") {
                                                $(row).css({
                                                    "font-weight": "bold",
                                                    "background-color": "#f8f9fa"
                                                });

                                                edateCell.html('Total'); // replace <a> entirely with plain text
                                            }
                                        }
                                    },
                                    initComplete: function () {
                                        var api = this.api();

                                        // Get current month-year in 'MMM-YYYY' format
                                        var currentDate = new Date();
                                        var currentMonthYear = currentDate.toLocaleString('en-us', { month: 'short', year: 'numeric' });

                                        // Apply default filter on "Mon_Name" column dynamically
                                        var monNameColumnIndex = api.column(':contains("Mon_Name")').index(); 
                                        if (monNameColumnIndex !== undefined) {
                                            api.column(monNameColumnIndex).search(currentMonthYear).draw();
                                        }

                                        api.columns().every(function () {
                                            var column = this;
                                            var select = $('select', column.header());
                                            var uniqueValues = [];

                                            column.data().unique().sort().each(function (d) {
                                                if (d !== null && d !== undefined && d !== '') {
                                                    if (!uniqueValues.includes(d)) {
                                                        uniqueValues.push(d);
                                                    }
                                                }
                                            });

                                            uniqueValues.forEach(d => {
                                                select.append(`<option value="${d}">${d}</option>`);
                                            });

                                            select.on('change', function () {
                                                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                                                column.search(val ? '^' + val + '$' : '', true, false).draw();
                                            });
                                        });
                                    }
                                });
                            });


                            
                        },
                        error: function(xhr, status, error) {
                            console.error('Error:', error);
                        }
                    });
                }
            }
        },
        series: [],
        xaxis: { categories: [], title: { text: "Overall Defect (%)" } },
        dataLabels: { enabled: false, style: { fontSize: '12px', colors: ['#000'] } }
    };

    var chartpred = new ApexCharts(document.querySelector("#efficiencyChart"), optionspred);
    chartpred.render();


    $(document).on('click', '.defectcheck', function(e) {
        e.preventDefault();
        var optdate = $(this).data('optdate');
        var UnitID = $(this).data('unit'); // Corrected from selectedUnit
        var chartTypeSelector = $(".dropdown-item.method.opt.active").data("value") || "Presentation";
        const apiUrl = chartTypeSelector === "Presentation"
            ? "{{ route('presentationocnwise') }}"
            : "{{ route('endlinecheckocnwise') }}"; 
        
        $("#DefectDetailsModalLabel").text(`${chartTypeSelector} Checking Details -  ${optdate} and ${UnitID}`);
        $.ajax({
            url: apiUrl,
            method: 'GET',
            data: { optdate: optdate, Unit: UnitID },                                    
            success: function (response) {
                let tableHtml = `<table class='table table-hover table-bordered' id='presentationchk'>
                    <thead><tr>` +
                    Object.keys(response.data.datewish[0]).map(key => 
                        `<th>${key}<br><select style="width: 100%;"><option value="">All</option></select></th>`
                    ).join('') +
                    `</tr></thead><tbody>`;

                // response.data.datewish.forEach(row => {
                //     tableHtml += "<tr>" + Object.entries(row).map(([key, value]) => {
                //         return key === 'Edate' 
                //             ? `<td><a href='' class='defectcheck' data-optdate='${value}' data-unit='${UnitID}'>${value}</a></td>` 
                //             : `<td>${value}</td>`;
                //     }).join('') + "</tr>";
                // });

                response.data.datewish.forEach(row => {
                    tableHtml += "<tr>" + Object.entries(row).map(([key, value]) => {
                        return key === 'Order_No' 
                            ? `<td><a href='' class='defectdetailcheck' data-ocn='${value}' data-optdate='${optdate}' data-unit='${UnitID}'>${value}</a></td>` 
                            : `<td>${value}</td>`;
                    }).join('') + "</tr>";
                });

                tableHtml += `</tbody><tfoot><tr>` + 
                    Object.keys(response.data.datewish[0]).map(() => `<th></th>`).join('') + 
                    `</tr></tfoot></table>`;

                $("#DefectDetailsContent").html(tableHtml);
                $('#presentationchk').css('font-size', '10px');
                $('#presentationchk th, #supplyerpotable td').css('padding', '4px 6px');
                
                $("#DefectOcnDetailsModalLabel").html('');
                $("#OcnDefectDetailsContent").html('');
                // Correct DataTable ID here
                $.getScript("https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js", function() {
                    $('#presentationchk').DataTable({ // Corrected from #processpotable2
                        paging: false,
                        searching: true,
                        ordering: false,
                        initComplete: function () {
                            this.api().columns().every(function () {
                                var column = this;
                                var select = $('select', column.header());
                                var uniqueValues = [];

                                column.data().unique().sort().each(function (d) {
                                    if (d !== null && d !== undefined && d !== '') {
                                        if (!uniqueValues.includes(d)) {
                                            uniqueValues.push(d);
                                        }
                                    }
                                });

                                uniqueValues.forEach(d => {
                                    select.append(`<option value="${d}">${d}</option>`);
                                });

                                select.on('change', function () {
                                    var val = $.fn.dataTable.util.escapeRegex($(this).val());
                                    column.search(val ? '^' + val + '$' : '', true, false).draw();
                                });
                            });
                        }
                    });
                });

                // Show the modal (placed inside success function)
                var orderModal = new bootstrap.Modal(document.getElementById('DefectDetailsModal'));
                orderModal.show();
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
            }
        });
    });

    $(document).on('click', '.defectdetailcheck', function(e) {
        e.preventDefault();
        var ocnno = $(this).data('ocn');
        var optdate = $(this).data('optdate');
        var UnitID = $(this).data('unit'); // Corrected from selectedUnit
        //var chartTypeSelector=$('#chartTypeSelector').val();
        var chartTypeSelector=$(".dropdown-item.method.opt.active").data("value") || "Presentation";

        const apiUrl = chartTypeSelector === "Presentation"
            ? "{{ route('presentationocnwisedef') }}"
            : "{{ route('endlinecheckocnwisedef') }}"; 
        
        $("#DefectOcnDetailsModalLabel").text(`Defect Details -  ${ocnno}`);
        $.ajax({
            url: apiUrl,
            method: 'GET',
            data: { optdate: optdate, Unit: UnitID, Ocnno:ocnno},                                    
            success: function (response) {
                let tableHtml = `<table class='table table-hover table-bordered' id='presentationchkdef'>
                    <thead><tr>` +
                    Object.keys(response.data.datewish[0]).map(key => 
                        `<th>${key}<br><select style="width: 100%;"><option value="">All</option></select></th>`
                    ).join('') +
                    `</tr></thead><tbody>`;

                response.data.datewish.forEach(row => {
                    tableHtml += "<tr>" + Object.entries(row).map(([key, value]) => {
                        return key === 'Order_No' 
                            ? `<td>${value}</td>` 
                            : `<td>${value}</td>`;
                    }).join('') + "</tr>";
                });

                tableHtml += `</tbody><tfoot><tr>` + 
                    Object.keys(response.data.datewish[0]).map(() => `<th></th>`).join('') + 
                    `</tr></tfoot></table>`;

                $("#OcnDefectDetailsContent").html(tableHtml);
                $('#presentationchkdef').css('font-size', '10px');
                $('#presentationchkdef th').css('padding', '4px 6px');

                // Correct DataTable ID here
                $.getScript("https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js", function() {
                    $('#presentationchkdef').DataTable({ // Corrected from #processpotable2
                        paging: false,
                        searching: true,
                        ordering: false,
                        initComplete: function () {
                            this.api().columns().every(function () {
                                var column = this;
                                var select = $('select', column.header());
                                var uniqueValues = [];

                                column.data().unique().sort().each(function (d) {
                                    if (d !== null && d !== undefined && d !== '') {
                                        if (!uniqueValues.includes(d)) {
                                            uniqueValues.push(d);
                                        }
                                    }
                                });

                                uniqueValues.forEach(d => {
                                    select.append(`<option value="${d}">${d}</option>`);
                                });

                                select.on('change', function () {
                                    var val = $.fn.dataTable.util.escapeRegex($(this).val());
                                    column.search(val ? '^' + val + '$' : '', true, false).draw();
                                });
                            });
                        }
                    });
                });

                // Show the modal (placed inside success function)
                //var orderModal = new bootstrap.Modal(document.getElementById('OcnDefectDetailsModal'));
                //orderModal.show();
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
            }
        });
    });

    $(document).ready(function() {
        updateQltyChart(); // Load default chart
        $(".dropdown-item.method.opt[data-value='Presentation']").addClass("active");             
        $(".dropdown-item.method.unit[data-value='']").addClass("active"); 
        $(".dropdown-item.method.buyer[data-value='']").addClass("active"); 
    });
    
    document.getElementById("full_screendefect").addEventListener("click", function () {
        let chartContainer = document.getElementById("chartWrapper");

        if (!document.fullscreenElement) {
            if (chartContainer.requestFullscreen) {
                chartContainer.requestFullscreen();
                chartContainer.style.backgroundColor = "white";
            } else if (chartContainer.webkitRequestFullscreen) {
                chartContainer.webkitRequestFullscreen();
                chartContainer.style.backgroundColor = "white";
            } else if (chartContainer.msRequestFullscreen) {
                chartContainer.msRequestFullscreen();
                chartContainer.style.backgroundColor = "white";
            }
        } else {
            if (document.exitFullscreen) {
                document.exitFullscreen();
            } else if (document.webkitExitFullscreen) {
                document.webkitExitFullscreen();
            } else if (document.msExitFullscreen) {
                document.msExitFullscreen();
            }
        }
    });

    document.addEventListener("fullscreenchange", () => {
        const isFullscreen = !!document.fullscreenElement;

        chartpred.updateOptions({
            chart: {
                height: isFullscreen ? 600 : 400
            }
        });
    });

    // let chartWidth = Math.max(1200, months.length * 120); // 120px per label
    // document.getElementById('efficiencyChart').style.minWidth = chartWidth + 'px';
</script>
    




    @endsection
</body>
</html>