<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>MIS PUNCH ENTRY</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>


    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tempusdominus-bootstrap-4/build/css/tempusdominus-bootstrap-4.min.css" />


    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }
    </style>

    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->

</head>

<body id="body" class="">

    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->

    @section('tittle') {{"MIS PUNCH ENTRY"}}@endsection

    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <br>

                                <!-- ALERT MESSAGE -->
                                @if ($message = Session::get('success'))
                                <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert">
                                    {{$message}}
                                </div>
                                <script>
                                    // Automatically close the alert after 3 seconds
                                    setTimeout(function() {
                                        var successAlert = document.getElementById('successAlert');
                                        if (successAlert) {
                                            successAlert.remove();
                                        }
                                    }, 15000);
                                </script>
                                @endif
                                @if ($message = Session::get('alert'))
                                <div id="successAlert" class="alert alert-danger alert-dismissible fade show" role="alert">
                                    {{$message}}
                                </div>
                                <script>
                                    // Automatically close the alert after 3 seconds
                                    setTimeout(function() {
                                        var successAlert = document.getElementById('successAlert');
                                        if (successAlert) {
                                            successAlert.remove();
                                        }
                                    }, 15000);
                                </script>
                                @endif
                                @if ($errors->any())
                                <div id="ErrorAlert" class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                                @endif

                                <div class="card-body">
                                    <div class="live-preview">
                                        <form method="POST" action="{{ route('MisPunch_save') }}" enctype="multipart/form-data" class="has-validated" id="validate">
                                            @csrf
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <!-- <label class="form-label">DATE<span class="login-danger">*</span></label>
                                                        <input type="date" class="form-control" id="Edate" onchange="datechange(this.value)" name="Edate"
                                                            value="{{ now()->format('Y-m-d') }}"
                                                            min="{{ now()->startOfMonth()->format('Y-m-d') }}"
                                                            max="{{ now()->endOfMonth()->addDay()->format('Y-m-d') }}"
                                                            required> -->
                                                        <button type="button" class="btn btn-warning Mispunch_viewButton">
                                                            Click Here For Selecting the EDate
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <!-- TKNO -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">TNo</label>
                                                        <?php $user_tkno = session('user_data') ?>
                                                        <input type="text" name="TNO" value="{{$user_tkno}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- NAME -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">NAME</label>
                                                        <?php $user_name = session('emp_name') ?>
                                                        <input type="text" name="NAME" value="{{$user_name}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- DEPARTMENT -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">DEPARTMENT</label>
                                                        <?php $user_dep = session('dep_data') ?>
                                                        <input type="text" name="DEPARTMENT" value="{{$user_dep}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- POSITION -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">POSITION</label>
                                                        <?php $user_posit = session('des_data') ?>
                                                        <input type="text" name="DESIGNAION" value="{{$user_posit}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="row">
                                                <!-- DATE -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label class="form-label">EDATE</label>
                                                        <input type="text" class="form-control dull" id="Edate" name="Edate" readonly>
                                                    </div>
                                                </div>


                                                <!-- IN TIME -->
                                                <!-- <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">IN TIME</label>
                                                        <input type="text" name="intime" value="{{old('intime')}}" id="intime" class="form-control intime dull" readonly>
                                                    </div>
                                                </div> -->
                                                <!-- OUT TIME -->
                                                <!-- <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">OUT TIME<span class="login-danger">*</span></label>
                                                        <input type="text" name="outtime" value="{{old('outtime')}}" id="outtime" class="form-control outtime">
                                                    </div>
                                                </div> -->

                                                <!-- IN TIME -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="intime" class="form-label">IN TIME</label>
                                                        <div class="input-group date" id="intime" data-target-input="nearest">
                                                            <input type="text" class="form-control datetimepicker-input intime" data-target="#intime" name="intime" />
                                                            <div class="input-group-append" id="datetimepicker_in" data-target="#intime" data-toggle="datetimepicker" style="display: block;">
                                                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- OUT TIME -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="outtime" class="form-label">OUT TIME</label>
                                                        <div class="input-group date" id="outtime" data-target-input="nearest">
                                                            <input type="text" class="form-control datetimepicker-input outtime" data-target="#outtime" name="outtime" />
                                                            <div class="input-group-append" id="datetimepicker_out" data-target="#outtime" data-toggle="datetimepicker" style="display: block;">
                                                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>



                                                <!-- STATUS -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">STATUS</label>
                                                        <input type="text" name="Status" value="{{old('Status')}}" id="Status" class="form-control sts dull" readonly>
                                                    </div>
                                                </div>



                                            </div>

                                            <br>
                                            <div class="row">
                                                <!-- HOURS -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">HOURS</label>
                                                        <input type="text" placeholder="" id="hour" class="form-control dull hour" name="hour" value="{{old ('hour')}}" readonly>
                                                    </div>
                                                </div>


                                                <!--YOUR SHIFT IN TIME -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">YOUR SHIFT IN TIME</label>
                                                        <input type="text" name="shiftin" value="{{old('intime')}}" id="shiftin" class="form-control shit_in dull" readonly>
                                                    </div>
                                                </div>
                                                <!--YOUR SHIFT OUT TIME -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">YOUR SHIFT OUT TIME</label>
                                                        <input type="text" name="shiftout" value="{{old('outtime')}}" id="shiftout" class="form-control shit_out dull" readonly>
                                                    </div>
                                                </div>
                                                <input type="hidden" value="{{$E_Count}}" name="Entry_count">


                                            </div>
                                            <br>

                                            <div class="row">
                                                <!-- REMARKS -->
                                                <div class="col-md-6">
                                                    <div class="mb-6">
                                                        <label for="firstNameinput" class="form-label">REASON<span class="login-danger">*</span></label>
                                                        <textarea name="Remarks" id="Remarks" class="form-control" required></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>

                                            <!--  SUBMIT BUTTON -->
                                            <div class="d-flex justify-content-around mt-3">
                                                <button type="submit" class="btn btn-primary" name="submit" id="saveButton" style="display: block;" disabled>Submit</button>
                                                <!-- Spinner -->
                                                <!-- <div id="spinner" class="col-md-1 mb-4" style="display: none;">
                                                    <div class="spinner-border text-primary" role="status">
                                                        <span class="visually-hidden">Loading...</span>
                                                    </div>
                                                </div> -->

                                                <button type="button" id="clearButton" class="btn btn-info" onclick="window.location.reload()">CLEAR</button>
                                                <!-- <button type="button" id="reportButton" class="btn btn-info" onclick="window.location.href = '/MisPuchReport'">Report</button> -->
                                            </div>


                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal for Mispunch Details -->
    <div id="MispunchModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="MispunchModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="MispunchModalLabel">Mispunch Details</h5>
                    <button type="button" class="close btnok bg-light btn" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table" id="table_det">
                        <thead class="text-muted table-light">
                            <tr>
                                <th>SNO</th>
                                <th>Edate</th>
                                <th>In-time</th>
                                <th>Out-Time</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($user_data as $index => $user_datas)
                            <tr>
                                <td>
                                    {{ $index + 1 }}
                                    <input type="radio" name="Mispunch_radio"
                                        data-edate="{{ date('Y-m-d', strtotime($user_datas['EDate'])) }}"
                                        data-intime="{{ $user_datas['InTime'] }}"
                                        data-outtime="{{ $user_datas['OutTime'] }}"
                                        data-status="{{ $user_datas['Status'] }}"
                                        data-hours="{{ $user_datas['Hrs'] }}"
                                        data-shintime="{{ $user_datas['Sh_InTime'] }}"
                                        data-shouttime="{{ $user_datas['Sh_OutTime'] }}"
                                        data-e_count="{{ $E_Count }}">
                                </td>
                                <td>{{ date('Y-m-d', strtotime($user_datas['EDate'])) }}</td>
                                <td>{{ $user_datas['InTime'] }}</td>
                                <td>{{ $user_datas['OutTime'] }}</td>
                                <td>{{ $user_datas['Status'] }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-success btnok" data-dismiss="modal">OK</button>
                    <button type="button" class="btn btn-secondary btncancel" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Confirmation Modal -->
    <div id="modalConfirm" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalConfirmLabel" aria-hidden="true">
        <div class="modal-dialog modal-notify modal-info" role="document">
            <div class="modal-content text-center">
                <div class="modal-header d-flex justify-content-center">
                    <h5 class="modal-title">Confirmation</h5>
                </div>
                <div class="modal-body">
                    <i class="fas fa-bell fa-4x animated rotateIn mb-4" style="color:#48ABF7"></i>
                    <h4>Already you have made 2 entries for this month<br>
                        This entry need to appove by GM-HR.<br>
                        Are your sure to proceed?
                    </h4>
                </div>
                <div class="modal-footer flex-center">
                    <button type="button" class="btn btn-info YES">YES</button>
                    <button type="button" class="btn btn-outline-info NO" data-dismiss="modal">NO</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Alert Modal -->
    <div id="modalAlert" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalAlertLabel" aria-hidden="true">
        <div class="modal-dialog modal-notify modal-warning" role="document">
            <div class="modal-content text-center">
                <div class="modal-header d-flex justify-content-center">
                    <h5 class="modal-title">Alert</h5>
                </div>
                <div class="modal-body">
                    <i class="fas fa-exclamation-triangle fa-4x animated rotateIn mb-4" style="color:#FFA726"></i>
                    <h4 id="alertMessage">This Month Your MisPunch Entry is Over.</h4>
                </div>
                <div class="modal-footer flex-center">
                    <button type="button" class="btn btn-warning OK" data-dismiss="modal">OK</button>
                </div>
            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/min/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/tempusdominus-bootstrap-4/build/js/tempusdominus-bootstrap-4.min.js"></script>

    <script type="text/javascript">
        $(function() {
            $('#datetimepicker_in').hide();
            $('#datetimepicker_out').hide();

            var startOfMonth = moment().startOf('month').add(-1, 'days');
            var endOfMonth = moment().endOf('month');

            $('#intime, #outtime').datetimepicker({
                format: 'YYYY-MM-DD hh:mm:ss A', // 12-hour format with AM/PM
                icons: {
                    time: 'fa fa-clock',
                    date: 'fa fa-calendar',
                    up: 'fa fa-arrow-up',
                    down: 'fa fa-arrow-down',
                },
                viewMode: 'times',
                useCurrent: true,
                minDate: startOfMonth, // Set minimum date to start of current month
                maxDate: endOfMonth // Set maximum date to end of current month
            });
            // Prevent typing in the input field
            $('.datetimepicker-input').on('keypress', function(e) {
                e.preventDefault();
            });
        });
    </script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <script>
        // Define calculateHours in the global scope
        function calculateHours() {
            let intime = $('.intime').val();
            let outtime = $('.outtime').val();

            if (intime && outtime) {
                let start = moment(intime, "YYYY-MM-DD hh:mm:ss A");
                let end = moment(outtime, "YYYY-MM-DD hh:mm:ss A");

                let duration = moment.duration(end.diff(start));
                let hours = duration.asHours();

                if (hours < 0) {
                    alert('Out Time must be later than In Time');
                    $('#hour').val('');
                    return;
                }

                $('#hour').val(hours.toFixed(2));
            }
        }

        $(function() {
            $('#intime, #outtime').on("change.datetimepicker", function() {
                calculateHours();
            });

            // Other initialization code for datetimepicker if needed
        });
    </script>

    <!--  MISPUNCH DETAILS  -->
    <script>
        $(document).ready(function() {
            function resetFields() {
                $('#Edate, #Status, #hour, #shiftin, #shiftout').val('');
                $('.intime, .outtime').val('');
            }

            function enableSaveButton() {
                $('#saveButton').prop('disabled', false);
            }

            function disableSaveButton() {
                $('#saveButton').prop('disabled', true);
            }

            $(document).on('click', '.Mispunch_viewButton', function() {
                $('#MispunchModal').modal('show');

                // Attach click event to table rows
                $('#table_det tbody tr').off('click').on('click', function(event) {
                    // Prevent event propagation if the radio button itself is clicked
                    if (event.target.type === 'radio') return;

                    // Find and check the radio button in the clicked row
                    const $radioButton = $(this).find('input[type=radio]');
                    $radioButton.prop('checked', true).trigger('click');
                });

                // Event for radio buttons when clicked
                $('input[type=radio][name=Mispunch_radio]').off('click').on('click', function() {
                    const selectedEdate = $(this).data('edate');
                    const selectedIntime = $(this).data('intime');
                    const selectedOuttime = $(this).data('outtime');
                    const selectedStatus = $(this).data('status');
                    const selectedHours = $(this).data('hours');
                    const selectedshintime = $(this).data('shintime');
                    const selectedshouttime = $(this).data('shouttime');
                    const E_count = $(this).data('e_count');

                    // Populate the input fields
                    $('#Edate').val(selectedEdate);
                    $('.intime').val(selectedIntime);
                    $('.outtime').val(selectedOuttime);
                    $('#Status').val(selectedStatus);
                    $('#hour').val(selectedHours);
                    $('#shiftin').val(selectedshintime);
                    $('#shiftout').val(selectedshouttime);

                    // Toggle date pickers based on status
                    if (selectedStatus === "Outpunch Missing") {
                        $('#datetimepicker_in').hide();
                        $('#datetimepicker_out').show();
                    } else if (selectedStatus === "InPunch Missing") {
                        $('#datetimepicker_out').hide();
                        $('#datetimepicker_in').show();
                    }

                    // Confirmation modal logic
                    // if (E_count > 1) {
                    //     $('#MispunchModal').modal('hide');
                    //     $('#modalConfirm').modal('show');

                    //     $('.YES').off('click').on('click', function() {
                    //         enableSaveButton();
                    //         calculateHours();
                    //         $('#modalConfirm').modal('hide');
                    //         $('#MispunchModal').modal('hide');
                    //     });

                    //     $('.NO').off('click').on('click', function() {
                    //         disableSaveButton();
                    //         resetFields();
                    //         $('input[type=radio][name=Mispunch_radio]').prop('checked', false);
                    //         $('#modalConfirm').modal('hide');
                    //         $('#MispunchModal').modal('show');
                    //     });
                    // } else {
                    //     calculateHours();
                    //     enableSaveButton();
                    // }

                    if (E_count >= 3) {
                        $('#modalConfirm').modal('hide');
                        $('#modalAlert').modal('show');

                        $('.OK').off('click').on('click', function() {
                            $('#modalConfirm').modal('hide');
                            $('#modalAlert').modal('hide');
                            disableSaveButton();
                            resetFields();
                            $('input[type=radio][name=Mispunch_radio]').prop('checked', false);
                            $('#MispunchModal').modal('hide');
                        });

                    } else if (E_count == 2) {
                        $('#MispunchModal').modal('hide');
                        $('#modalConfirm').modal('show');

                        $('.YES').off('click').on('click', function() {
                            enableSaveButton();
                            calculateHours();
                            $('#modalConfirm').modal('hide');
                            $('#MispunchModal').modal('hide');
                        });

                        $('.NO').off('click').on('click', function() {
                            disableSaveButton();
                            resetFields();
                            $('input[type=radio][name=Mispunch_radio]').prop('checked', false);
                            $('#modalConfirm').modal('hide');
                            $('#MispunchModal').modal('show');
                        });
                    } else {
                        calculateHours();
                        enableSaveButton();
                    }

                });


                $('.btncancel').off('click').on('click', function() {
                    resetFields();
                    $('#MispunchModal').modal('hide');
                });

                $('.btnok').off('click').on('click', function() {
                    $('#MispunchModal').modal('hide');
                });
            });
        });
    </script>

    <!-- OLD MISPUNCH DETAILS  -->
    <!-- <script>
        $(document).ready(function() {
            function resetFields() {
                $('#Edate, #Status, #hour, #shiftin, #shiftout').val('');
                $('.intime, .outtime').val('');
            }

            function enableSaveButton() {
                $('#saveButton').prop('disabled', false);
            }

            function disableSaveButton() {
                $('#saveButton').prop('disabled', true);
            }

            $(document).on('click', '.Mispunch_viewButton', function() {
                $('#MispunchModal').modal('show');

                // Attach click event to table rows
                $('#table_det tbody tr').off('click').on('click', function(event) {
                    // Prevent event propagation if the radio button itself is clicked
                    if (event.target.type === 'radio') return;

                    // Find and check the radio button in the clicked row
                    const $radioButton = $(this).find('input[type=radio]');
                    $radioButton.prop('checked', true).trigger('click');
                });

                $('input[type=radio][name=Mispunch_radio]').off('click').on('click', function() {
                    const selectedEdate = $(this).data('edate');
                    const selectedIntime = $(this).data('intime');
                    const selectedOuttime = $(this).data('outtime');
                    const selectedStatus = $(this).data('status');
                    const selectedHours = $(this).data('hours');
                    const selectedshintime = $(this).data('shintime');
                    const selectedshouttime = $(this).data('shouttime');
                    const E_count = $(this).data('e_count');
                    console.log(E_count);

                    // Populate the input fields
                    $('#Edate').val(selectedEdate);
                    $('.intime').val(selectedIntime);
                    $('.outtime').val(selectedOuttime);
                    $('#Status').val(selectedStatus);
                    $('#hour').val(selectedHours);
                    $('#shiftin').val(selectedshintime);
                    $('#shiftout').val(selectedshouttime);

                    // Toggle date pickers based on status
                    if (selectedStatus === "Outpunch Missing") {
                        $('#datetimepicker_in').hide();
                        $('#datetimepicker_out').show();


                    } else if (selectedStatus === "InPunch Missing") {
                        $('#datetimepicker_out').hide();
                        $('#datetimepicker_in').show();
                    }


                    // Confirmation modal logic
                    if (E_count > 1) {
                        $('#MispunchModal').modal('hide');

                        $('#modalConfirm').modal('show');

                        $('.YES').off('click').on('click', function() {
                            console.log('Proceed with saving the data');
                            $('#modalConfirm').modal('hide');
                            $('#MispunchModal').modal('hide');

                        });

                        $('.NO').off('click').on('click', function() {
                            disableSaveButton();
                            resetFields();
                            $('input[type=radio][name=Mispunch_radio]').prop('checked', false);


                            $('#modalConfirm').modal('hide');
                            $('#MispunchModal').modal('hide');
                        });

                    } else {
                        calculateHours();
                        enableSaveButton();
                    }
                });

                $('.btncancel').off('click').on('click', function() {
                    resetFields();
                    $('#MispunchModal').modal('hide');
                });

                $('.btnok').off('click').on('click', function() {
                    $('#MispunchModal').modal('hide');
                });
            });
        });
    </script> -->


    <!-- <script>
        function datechange(date) {
            $('#spinner').show();
            $('#saveButton').hide();

            $('#MispunchModal').show();
            console.log('dateee', date);

            $.ajax({
                url: "{{ route('Mispunch_det') }}",
                type: "GET",
                data: {
                    date: date,
                },
                dataType: 'json',
                success: function(details) {
                    console.log(details);

                    if (details.length > 0) {
                        var Status = details[0].Status;
                        var InTime = details[0].InTime;
                        var OutTime = details[0].OutTime;
                        var Sh_InTime = details[0].Sh_InTime;
                        var Sh_OutTime = details[0].Sh_OutTime;

                        // var Sh_InTime = formatDateTime(details[0].Sh_InTime);
                        // var Sh_OutTime = formatDateTime(details[0].Sh_OutTime);
                        // var InTime = formatDateTime(details[0].InTime);
                        // var OutTime = formatDateTime(details[0].OutTime);

                        $('.intime').val(InTime);
                        $('.outtime').val(OutTime);
                        $('.sts').val(Status);
                        $('.shit_in').val(Sh_InTime);
                        $('.shit_out').val(Sh_OutTime);

                        if (details[0].Status === "Outpunch Missing") {
                            $('#datetimepicker_in').hide();
                            $('#datetimepicker_out').show();

                        }

                        if (details[0].Status === "InPunch Missing") {
                            $('#datetimepicker_out').hide();
                            $('#datetimepicker_in').show();

                        }

                        calculateHours();
                        // Enable the Save button if all details are filled
                        enableSaveButton();
                    } else {
                        $('.intime').val('');
                        $('.outtime').val('');
                        $('.sts').val('');
                        $('.shit_in').val('');
                        $('.shit_out').val('');
                        $('.hour').val('');

                        $('#datetimepicker_in').hide();
                        $('#datetimepicker_out').hide();

                        // Disable the Save button if details are not filled
                        disableSaveButton();
                        alert("There is No MisPunch For this Date ...!");
                    }
                    $('#spinner').hide();
                    $('#saveButton').show();

                }
            });
        }

        function enableSaveButton() {
            $('#saveButton').prop('disabled', false);
        }

        function disableSaveButton() {
            $('#saveButton').prop('disabled', true);
        }

        // Event listener to prevent Enter key from submitting the form
        document.addEventListener("keydown", function(event) {
            if (event.key === "Enter") { // Enter key
                if (!areDetailsFilled()) {
                    event.preventDefault();
                    return false;
                }
            }
        });

        // function areDetailsFilled() {
        //     var intime = $('.details1').val();
        //     var outtime = $('.details2').val();
        //     var bal_Hrs = $('.details3').val();
        //     var lastStatus = $('.details4').val();

        //     return intime && outtime && bal_Hrs && lastStatus;
        // }
    </script> -->


    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>