<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Joiners</title>
    <link rel="icon" href="gplogofinal.png" type="png">

    <link href="https://fonts.googleapis.com/css2?family=Ceviche+One&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Abril+Fatface" rel="stylesheet" type="text/css">


    <style>
        body {
            margin: 0;
            padding: 0;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: consolas;
            /* background-image: linear-gradient(315deg, #63a4ff 0%, #83eaf1 74%); */

            background-image: url('https://media.istockphoto.com/id/1395321519/photo/digital-background-with-movement-of-glowing-particles-complex-technologies-of-big-data-3d.webp?b=1&s=170667a&w=0&k=20&c=0SWIokXTPzOv6WfRPmyBIV9-6Twxs7SfMAMZCJ6Pw-A=');
            background-size: cover;
            background-repeat: no-repeat;
            background-attachment: fixed;

        }

        .container {
            width: 1000px;
            position: relative;
            display: flex;
            justify-content: space-between;

            /* GPT */
            flex-wrap: wrap;
            margin-bottom: 20px;
        }

        .container .card {
            position: relative;
            cursor: pointer;

            /* GPT */
            width: calc(20% - 20px);
            /* margin: 0 4px 20px; */
            /* margin-top: 10px; */
            height: 300px;
        }


        .container .card .face {
            width: 200px;
            height: 200px;
            transition: 0.5s;
            border-radius: 10px;
            border: 0.1px solid white;

        }

        .container .card .face.face1 {
            position: relative;
            background: #082530;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1;
            transform: translateY(100px);
            border-radius: 10px;
        }

        .container .card:hover .face.face1 {
            background: #002244;
            transform: translateY(0);
        }


        .container .card .face.face1 .Name img {
            align-items: center;
            width: 150px;
            height: 120px;
            display: block;
            margin: auto;
            border-radius: 10px;
        }

        .container .card .face.face1 .Name h3 {

            margin-top: 10px;
            color: #99FFFF;
            text-align: center;
            font-size: 1em;

            /* font-weight: bold !important; */
            /* -webkit-text-stroke: 0.3px black; */
        }

        .container .card .face.face2 {

            height: 160px;
            position: relative;
            background: #fff;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            box-sizing: border-box;
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.8);
            transform: translateY(-100px);
            ;

        }

        .container .card:hover .face.face2 {
            transform: translateY(0);
        }

        .details {
            color: #28650e;
            font-family: Perpetua, Baskerville, Big Caslon, Palatino Linotype, Palatino, URW Palladio L, Nimbus Roman No9 L, serif;
            font-weight: bold;

            /* margin-top: -30px; */
            /* display: flex;
            flex-wrap: wrap; */
        }

        .role {
            color: black;
            font-family: Didot, Didot LT STD, Hoefler Text, Garamond, Times New Roman, serif;

        }

        .desig {
            margin-top: 10px;
            color: white;
            text-align: center;
            font-size: 12px;
            font-weight: bolder;
        }

        .home-link {
            position: absolute;
            top: 20px;
            right: 20px;
            height: 25px;
            width: 60px;
        }

        .home-link a {
            text-decoration: none;
            align-items: center;
            font-weight: bolder;
        }
		
        .ref-link {
            position: absolute;
            top: 20px;
            right: 100px;
            height: 25px;
            width: 80px;
        }

        .ref-link a {
            text-decoration: none;
            align-items: center;
            font-weight: bolder;
        }
    </style>




</head>

<body>
    <button class="home-link">
        <a href="dashboard">HOME</a>
    </button>
	<button class="ref-link">
		<a href="{{ url('/refresh_onboard') }}">REFRESH</a>
	</button>


    <div class="container">

	    <!-- ALERT MESSAGE -->
        @if ($message = Session::get('success'))
        <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
            {{$message}}
        </div>
        <script>
            // Automatically close the alert after 3 seconds
            setTimeout(function() {
                var successAlert = document.getElementById('successAlert');
                if (successAlert) {
                    successAlert.remove();
                }
            }, 1000);
        </script>
        @endif


        @foreach($results as $index => $employee)
        <div class="card">
            <div class="face face1">
                <div class="Name">
                    <!-- <img src="data:image/jpeg;base64,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"> -->
                    <!-- <img src="{{ asset('frontend/emplphotos/46973.jpeg')}}" alt="..." class="rounded-circle shadow-1-strong me-3" alt="avatar" width="60" height="60"> -->
                    <!-- <img src="{{ asset('frontend/emplphotos/' .$employee['Emplno']) }}" alt="..." class="rounded-circle shadow-1-strong me-3" alt="avatar" width="60" height="60"> -->

                    <img src="{{ asset('frontend/emplphotos/' . $employee['Emplno'] . '.jpeg') }}" alt="..." class="rounded-circle shadow-1-strong me-3" alt="avatar" width="60" height="60">

                    <h3><span>{{ $employee['Name'] }}</span></h3>
                    <p class="desig"><span>{{ $employee['DesignationName'] }}</span></p>
                </div>
            </div>
            <div class="face face2">
                <div class="details">

                    <!-- <span> <strong class="role">Designation:</strong> {{ $employee['DesignationName'] }}</span> <br> -->

                    <span> <strong class="role">DEP:</strong> {{ $employee['Deptname'] }}</span> <br>

                    <span> <strong class="role">TNO:</strong> {{ $employee['Tno'] }}</span> <br>

                    <!-- <span> <strong class="role">EmplNo:</strong> {{ $employee['Emplno'] }}</span> <br> -->

                    <span> <strong class="role">DOJ:</strong> {{ date('d-m-Y', strtotime ($employee['Dateofjoin'])) }}</span> <br>

                    <span> <strong class="role">INCHARGE:</strong> {{ $employee['Inch_Name'] }}</span> <br>

                    <span> <strong class="role">DIVISION:</strong> {{ $employee['compname'] }}</span>

                </div>
            </div>
        </div>
        @endforeach
    </div>

</body>

</html>