<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>ADMIN ORGANOGRAM</title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="gplogofinal.png" type="png">


    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>


    <link rel="stylesheet" href="{{ asset('frontend/css/fonts.min.css')}}">
    <link rel="stylesheet" href="{{ asset('frontend/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{ asset('frontend/css/atlantis.css')}}">
    <style>
        .caret-down::before {
            -ms-transform: rotate(90deg);
            -webkit-transform: rotate(90deg);
            transform: rotate(90deg);
        }

        .nested {
            display: none;
            padding: 0;

        }

        .org {
            /* position:inherit; */
            align-items: center;
            /* appearance: none; */
            background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #4a8da7 100%);
            border: 0;
            border-radius: 6px;
            box-shadow: rgba(45, 35, 66, .4) 0 2px 4px, rgba(45, 35, 66, .3) 0 7px 13px -3px, rgba(58, 65, 111, .5) 0 -3px 0 inset;
            box-sizing: border-box;
            color: #fff;
            cursor: pointer;
            /* display: inline-flex;  */
            font-family: "JetBrains Mono", monospace;
            /* height: 30px; */
            justify-content: center;
            /* line-height: 1;
            /* list-style: none; */
            /* overflow: hidden;  */
            padding-left: 16px;
            padding-right: 16px;
            /* position: relative; */
            text-align: left;
            text-decoration: none;
            transition: box-shadow .15s, transform .15s;
            user-select: none;
            -webkit-user-select: none;
            touch-action: manipulation;
            white-space: nowrap;
            will-change: box-shadow, transform;
            font-size: 0.7rem;
        }


        #main-content {
            overflow: scroll;
        }

        .org1 {
            align-items: center;
            appearance: none;
            background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #074d66 100%);
            border: 0;
            border-radius: 6px;
            box-shadow: rgba(45, 35, 66, .4) 0 2px 4px, rgba(45, 35, 66, .3) 0 7px 13px -3px, rgba(58, 65, 111, .5) 0 -3px 0 inset;
            box-sizing: border-box;
            color: #fff;
            cursor: pointer;
            /* display: inline-flex; */
            font-family: "JetBrains Mono", monospace;
            height: 45px;
            justify-content: center;
            /* line-height: 1;
            /* list-style: none; */
            /* overflow: hidden; */
            padding-left: 16px;
            padding-right: 16px;
            /* position: relative; */
            text-align: left;
            text-decoration: none;
            transition: box-shadow .15s, transform .15s;
            user-select: none;
            -webkit-user-select: none;
            touch-action: manipulation;
            white-space: nowrap;
            will-change: box-shadow, transform;
            font-size: 15px;
        }

        .org3 {
            /* position:inherit; */
            align-items: center;
            /* appearance: none; */
            background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #4a8da7 100%);
            border: 0;
            border-radius: 6px;
            box-shadow: rgba(45, 35, 66, .4) 0 2px 4px, rgba(45, 35, 66, .3) 0 7px 13px -3px, rgba(58, 65, 111, .5) 0 -3px 0 inset;
            box-sizing: border-box;
            color: #fff;
            cursor: pointer;
            /* display: inline-flex;  */
            font-family: "JetBrains Mono", monospace;
            /* height: 40px; */
            justify-content: center;
            /* line-height: 1;
            /* list-style: none; */
            /* overflow: hidden;  */
            padding-left: 16px;
            padding-right: 16px;
            /* position: relative; */
            text-align: left;
            text-decoration: none;
            transition: box-shadow .15s, transform .15s;
            user-select: none;
            -webkit-user-select: none;
            touch-action: manipulation;
            white-space: nowrap;
            will-change: box-shadow, transform;
            font-size: 0.7rem;
        }

        .active {
            display: block;
        }

        h3 {
            text-align: center;
            padding-top: 20px;
        }

        td {
            padding: 10px;
        }

        label,
        input,
        button {
            display: block;
            border: none;
            outline: none;
            box-sizing: border-box;
            font-family: "Times New Roman", Times, serif;
            font-size: 0.8rem;
        }

        label {
            margin-bottom: 4px;
        }

        label:nth-of-type(2) {
            margin-top: 12px;
        }

        input::placeholder {
            color: gray;
        }

        input {
            background: #ecf0f3;
            padding: 15px;
            padding-left: 20px;
            height: 40px;
            font-size: 14px;
            border-color: black;

        }

        .table td,
        .table th {
            font-size: 12px;
            border-top-width: 0px;
            border-bottom: 1px solid;
            border-color: #ebedf2 !important;
            padding: 0 10px !important;
            height: 53px;
            vertical-align: middle !important;
        }
    </style>
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->

</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->
    @section('tittle') {{"ORGANOGRAM"}}@endsection
    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-panel">
            <div class="container">
                <div class="page-inner">

                    <!-- CTC -->
                    <div class="page-header">
                        <div class="row">
                            <!-- EMP CTC -->
                            <div class="col-sm-4">
                                <div class="form-group row" style="padding: 1px;">
                                    <label for="ctc" class="col-sm-4 col-form-label">EMP - CTC
                                        <i class="flaticon-right-arrow"></i>
                                    </label>
                                    <div class="col-sm-6">
                                        <input type="text" placeholder="" id="ctc" value="" class="form-control bold-input" name="ctc" readonly>
                                    </div>
                                </div>
                            </div>
                            <!-- TEAM CTC -->
                            <div class="col-sm-4">
                                <div class="form-group row" style="padding: 1px;">
                                    <label for="team_ctc" class="col-sm-4 col-form-label">TEAM - CTC
                                        <i class="flaticon-right-arrow"></i>
                                    </label>
                                    <div class="col-sm-6">
                                        <input type="text" placeholder="" id="team_ctc" value="" class="form-control bold-input" name="team_ctc" readonly>
                                    </div>
                                </div>
                            </div>
                            <!-- TOTAL -->
                            <div class="col-sm-4">
                                <div class="form-group row" style="padding: 1px;">
                                    <label for="total_ctc" class="col-sm-4 col-form-label">TOTAL / Month
                                        <i class="flaticon-right-arrow"></i>
                                    </label>
                                    <div class="col-sm-6 ml-4">
                                        <input type="text" placeholder="" id="total_ctc" value="" class="form-control bold-input" name="total_ctc" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <!-- ORGANOGRAM LIST -->
                        <div class="col-sm-4 text-wrap " id="main-content">
                            <div class="card ">
                                <div class="card-header">
                                    <h4 class="card-title">ORGANOGRAM</h4>
                                </div>

                                <div class="card-body text-wrap" style="padding: 0px;">
                                    <ul id="myUL" style="margin: 0px;padding: 0px;">
                                        @php
                                        $head_det = \App\Models\orgs::where('admin_id_number', 'AMD0000')->get();
                                        $empl_tno= 'AMD0000';
                                        $empl_name = 'DWARAKANATHAN S';
                                        $notice = Session::get('notice');

                                        $tno= 'AMD0000';
                                        $emp_no = DB::table('orgs')
                                        ->select('NO_Of_Reporting')
                                        ->distinct()
                                        ->where('admin_id_number', '=', $tno)
                                        ->get();
                                        @endphp

                                        <?php
                                        $hiddenValue = ' ' . '  ' . ' ';
                                        ?>
                                        <li class="org1">
                                            @if( $notice == 'Y')
                                            <span class="caret" style="color:yellow;font-weight: 800;">
                                                @foreach ($emp_no as $empno)
                                                <a onclick="myFunction1('{{$empl_tno}}')">{{$empl_name}} - ({{ $empno->NO_Of_Reporting }})
                                                    @endforeach
                                                    <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                    </span>
                                                </a>
                                            </span>

                                            @else
                                            <span class="caret" style="font-weight: 800;">
                                                @foreach ($emp_no as $empno)
                                                <a onclick="myFunction1('{{$empl_tno}}')">{{$empl_name}} - ({{ $empno->NO_Of_Reporting }})
                                                    @endforeach
                                                    <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                    </span>
                                                </a>
                                            </span>
                                            @endif
                                            <br><br>

                                            <ul class="nested v2" style="margin-top: 25px;word-break: break-all;">
                                                @foreach ($head_det as $key => $head_det_val)
                                                @if($head_det_val['NO_Of_Reporting_Can'] >0)
                                                <li class="org" style="margin-top: 25px;word-break: break-all;background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #4a8da7 100%)">
                                                    @if($head_det_val['Notice'] == 'Y')
                                                    <span class="caret" style="color:yellow;font-weight: 800;">
                                                        <a onclick="myFunction1('{{$head_det_val['user_id_number']}}')" class="one">{{$head_det_val['user_name']}} - ({{$head_det_val['NO_Of_Reporting_Can']}})
                                                            <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                            </span>
                                                        </a>
                                                    </span>
                                                    @else
                                                    <span class="caret" style="font-weight: 800;">
                                                        <a onclick="myFunction1('{{$head_det_val['user_id_number']}}')" class="one">{{$head_det_val['user_name']}} - ({{$head_det_val['NO_Of_Reporting_Can']}})
                                                            <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                            </span>
                                                        </a>
                                                    </span>
                                                    @endif
                                                    @else
                                                </li>
                                                <li style="margin-top: 25px;word-break: break-all;height:25px;background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #4a8da7 100%)" class="org">
                                                    @if($head_det_val['Notice'] == 'Y')
                                                    <span style="color:yellow;font-weight: 800;">
                                                        <a style="height:25px;" onclick="myFunction1('{{$head_det_val['user_id_number']}}')" class="one">{{$head_det_val['user_name']}}
                                                            <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                            </span>
                                                        </a>
                                                    </span>
                                                    @else
                                                    <span style="font-weight: 800;">
                                                        <a style="height:25px;" onclick="myFunction1('{{$head_det_val['user_id_number']}}')" class="one">{{$head_det_val['user_name']}}
                                                            <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                            </span>
                                                        </a>
                                                    </span>
                                                    @endif
                                                </li>
                                                @endif
                                                <ul class="nested v1">
                                                    @php
                                                    $head_det_1 = \App\Models\orgs::where('admin_id_number', $head_det_val['user_id_number'])->get();
                                                    @endphp

                                                    @foreach ($head_det_1 as $key => $head_det_val_1)
                                                    @php
                                                    $head_det_2 = \App\Models\orgs::where('admin_id_number', $head_det_val_1['user_id_number'])->get();
                                                    $count_head_det_2 = count($head_det_2);
                                                    @endphp

                                                    @if(count($head_det_2) > 0)
                                                    <li class="org3" style="margin-top: 25px;word-break: break-all;background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #074d66 100%)">
                                                        @if($head_det_val_1['Notice'] == 'Y')
                                                        <span class="caret" style="color:yellow;font-weight: 800;">
                                                            <a onclick="myFunction1('{{$head_det_val_1['user_id_number']}}')" style="height:25px;" class="one">{{$head_det_val_1['user_name']}} - ({{count($head_det_2)}})
                                                                <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                </span>
                                                            </a>
                                                        </span>
                                                        @else
                                                        <span class="caret" style="font-weight: 800;">
                                                            <a onclick="myFunction1('{{$head_det_val_1['user_id_number']}}')" style="height:25px;" class="one">{{$head_det_val_1['user_name']}} - ({{count($head_det_2)}})
                                                                <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                </span>
                                                            </a>
                                                        </span>
                                                        @endif
                                                        <ul class="nested v2">
                                                            @foreach ($head_det_2 as $key => $head_det_val_2)
                                                            @php
                                                            $head_det_3 = \App\Models\orgs::where('admin_id_number', $head_det_val_2['user_id_number'])->get();
                                                            @endphp
                                                            @if(count($head_det_3) > 0)
                                                            <li style="margin-top: 25px;word-break: break-all;background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #4a8da7 100%);" class="org">
                                                                @if($head_det_val_2['Notice'] == 'Y')
                                                                <span class="caret" style="color:yellow;font-weight: 800;">
                                                                    <a onclick="myFunction1('{{$head_det_val_2['user_id_number']}}')">{{$head_det_val_2['user_name']}} - ({{count($head_det_3)}})
                                                                        <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                        </span>
                                                                    </a>
                                                                </span>
                                                                @else
                                                                <span class="caret" style="font-weight: 800;">
                                                                    <a onclick="myFunction1('{{$head_det_val_2['user_id_number']}}')">{{$head_det_val_2['user_name']}} - ({{count($head_det_3)}})
                                                                        <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                        </span>
                                                                    </a>
                                                                </span>
                                                                @endif
                                                                <ul class="nested v3">
                                                                    @foreach ($head_det_3 as $key => $head_det_val_3)
                                                                    @php
                                                                    $head_det_4 = \App\Models\orgs::where('admin_id_number', $head_det_val_3['user_id_number'])->get();
                                                                    @endphp
                                                                    @if(count($head_det_4) > 0)
                                                                    <li style="margin-top: 25px;word-break: break-all;height:25px;background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #4a8da7 100%);" class="org">
                                                                        @if($head_det_val_3['Notice'] == 'Y')
                                                                        <span class="caret" style="color:yellow;font-weight: 800;">
                                                                            <a onclick="myFunction1('{{$head_det_val_3['user_id_number']}}')">{{$head_det_val_3['user_name']}} - ({{count($head_det_4)}})
                                                                            </a>
                                                                        </span>
                                                                        @else
                                                                        <span class="caret" style="font-weight: 800;">
                                                                            <a onclick="myFunction1('{{$head_det_val_3['user_id_number']}}')">{{$head_det_val_3['user_name']}} - ({{count($head_det_4)}})
                                                                            </a>
                                                                        </span>
                                                                        @endif
                                                                        <ul class="nested v4">
                                                                            @foreach ($head_det_4 as $key => $head_det_val_4)
                                                                            <li style="margin-top: 10px;" class="org">
                                                                                @if($head_det_val_4['Notice'] == 'Y')
                                                                                <span class="caret" style="color:yellow;font-weight: 800;">{{$head_det_val_4['user_name']}}
                                                                                    <span> {{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                    </span>
                                                                                </span>
                                                                                @else
                                                                                <span class="caret" style="font-weight: 800;">{{$head_det_val_4['user_name']}}
                                                                                    <span> {{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                    </span>
                                                                                </span>
                                                                                @endif
                                                                            </li>
                                                                            @endforeach
                                                                        </ul>
                                                                    </li>
                                                                    @else
                                                                    <li style="margin-top: 25px;word-break: break-all;height:25px;background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #074d66 100%)" class="org">
                                                                        @if($head_det_val_3['Notice'] == 'Y')
                                                                        <span style="color:yellow;font-weight: 800;">
                                                                            <a style="height:25px;" onclick="myFunction1('{{$head_det_val_3['user_id_number']}}')" class="one">{{$head_det_val_3['user_name']}}
                                                                                <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                </span>
                                                                            </a>
                                                                        </span>
                                                                        @else
                                                                        <span style="font-weight: 800;">
                                                                            <a style="height:25px;" onclick="myFunction1('{{$head_det_val_3['user_id_number']}}')" class="one">{{$head_det_val_3['user_name']}}
                                                                                <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                </span>
                                                                            </a>
                                                                        </span>
                                                                        @endif
                                                                    </li>
                                                                    @endif
                                                                    @endforeach
                                                                </ul>
                                                            </li>
                                                            @else
                                                            <li style="margin-top: 25px;word-break: break-all;height:25px;background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #4a8da7 100%);" class="org">
                                                                @if($head_det_val_2['Notice'] == 'Y')
                                                                <span style="color:yellow;font-weight: 800;">
                                                                    <a style="height:25px;" onclick="myFunction1('{{$head_det_val_2['user_id_number']}}')" class="one">{{$head_det_val_2['user_name']}}
                                                                        <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                                                                    </a>
                                                                </span>
                                                                @else
                                                                <span style="font-weight: 800;">
                                                                    <a style="height:25px;" onclick="myFunction1('{{$head_det_val_2['user_id_number']}}')" class="one">{{$head_det_val_2['user_name']}}
                                                                        <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                                                                    </a>
                                                                </span>
                                                                @endif
                                                            </li>
                                                            @endif
                                                            @endforeach
                                                        </ul>
                                                    </li>
                                                    @else
                                                    <li style="margin-top: 25px;word-break: break-all;height:25px;background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #074d66 100%);" class="org">
                                                        @if($head_det_val_1['Notice'] == 'Y')
                                                        <span style="color:yellow;font-weight: 800;">
                                                            <a style="height:25px;" onclick="myFunction1('{{$head_det_val_1['user_id_number']}}')" class="one">{{$head_det_val_1['user_name']}}
                                                                <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                </span>
                                                            </a>
                                                        </span>
                                                        @else
                                                        <span style="font-weight: 800;">
                                                            <a style="height:25px;" onclick="myFunction1('{{$head_det_val_1['user_id_number']}}')" class="one">{{$head_det_val_1['user_name']}}
                                                                <span>{{$hiddenValue}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                </span>
                                                            </a>
                                                        </span>
                                                        @endif
                                                    </li>
                                                    @endif
                                                    @endforeach
                                                </ul>
                                                @endforeach
                                            </ul>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-8">
                            <div class="card ">

                                <!-- USER PROFILE -->
                                <div class="card-header ">
                                    {{-- <h4 class="card-title">KPI REPORT</h4> --}}
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div>
                                                <label for="email2">ID</label>
                                                <?php $user_dataa = Session('user_data'); ?>
                                                <input type="text" class="form-control" name="tno" style="width:150px" id="tno" disabled value="{{$user_dataa}}">
                                                <?php $emp_idd = Session('empl_id'); ?>
                                                <input type="hidden" class="form-control" name="emp_no_d" id="emp_no_d" value="{{$emp_idd}}">
                                            </div>
                                        </div>
                                        <div class=" col-md-4">
                                            <label for="country">NAME</label>
                                            <?php $emp_idd = Session('emp_name'); ?>
                                            <input type="text" class="form-control" name="name" style="width:180px;" id="name" disabled value="{{$empl_name}}">
                                        </div>
                                        <div class="col-md-4">
                                            <button class="form-control" style="width:120px;margin-top:23px; color: white;cursor:pointer;height:40px;background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #074d66 100%)" class="btn btn-info btn-block" onclick="location.href='{{ url('OrganogramDB') }}'">
                                                REFRESH
                                                <i class="icon-refresh"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4 pt-3">
                                            <div>
                                                <label for="email2">DEPARTMENT</label>
                                                <?php $dep_dataa = Session('dep_data'); ?>
                                                <input type="text" class="form-control" name="dpt" style="width:200px" id="dpt" disabled value="{{$dep_dataa}}">
                                            </div>
                                        </div>
                                        <div class=" col-md-4 pt-3">
                                            <label for="country">DESIGNATION</label>
                                            <?php $des_dataa = Session('des_data'); ?>
                                            <input type="text" class="form-control" name="designation" style="width:200px" id="designation" disabled value="{{$des_dataa}}">
                                        </div>
                                    </div>
                                </div>

                                <!-- BUTTONS -->
                                <div class="card-body ">
                                    <form name="kpi" class="registartion-form">
                                        <div class="row">
                                            <div class="col-md-4 col-lg-4">
                                                <div class="">
                                                    <input class="btn" type="Button" style="width:200px;cursor:pointer;padding:10px;color: white;background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #074d66 100%)" class="btn btn-info btn-block" id="btn" onclick="myFunction12(this.value)" value="KPI ">
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-lg-4">
                                                <input class="btn" type="Button" style="width:200px;cursor:pointer;padding:10px;color: white;background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #074d66 100%)" class="btn btn-info btn-block" id="btn" onclick="myFunctionJ(this.value)" value="ROLES">
                                            </div>
                                            <div class="col-md-3 col-lg-3 float-left" style="margin-top: -80px;">
                                                <?php $emp_idd = '5545'  ?>
                                                <img id="empImg" src="{{ asset('frontend/emplphotos/'.$emp_idd.'.jpeg')}}" class="img-responsive" alt="..." width="150px" height="130px" style="float: right;">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4 col-lg-4">
                                                <input class="btn" type="Button" style="width:200px;cursor:pointer;padding:10px;color: white;background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #074d66 100%)" class="btn btn-info btn-block" id="btn" onclick="myFunction(this.value)" value="SKILL">
                                            </div>
                                            <div class="col-md-4 col-lg-4">
                                                <input class="btn" type="Button" style="width:200px;cursor:pointer;padding:10px;color: white;background-image: radial-gradient(100% 100% at 100% 0, #5adaff 0, #074d66 100%)" class="btn btn-info btn-block" id="btn" value="PROFILE" onclick="redirectToProfile()">
                                            </div>
                                        </div>
                                    </form>
                                </div>

                                <!-- KPI & SKILL -->
                                <div class="inputs">
                                    <span id="message_error"></span>

                                    <!-- KPI DATE -->
                                    <div class="row">
                                        <div class="col-md-5 col-lg-5">
                                            <div class="form-group">
                                                <label for="country">KPI DATE</label>
                                                <?php $user_dataa = Session('effect_from1'); ?>
                                                <input type="text" class="form-control" name="effect_from1" style="width:200px" id="effect_from1" disabled value="{{$user_dataa}}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-12 col-md-12 col-lg-12">
                                        <!-- KPI TABLE -->
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="table-responsive">
                                                    <div class="myTable1">
                                                        <table id="myTable1" class="table table-bordered">
                                                            <thead>
                                                                <tr>
                                                                    <th>SNO</th>
                                                                    <th>KPI POINT</th>
                                                                    <th>TARGET</th>
                                                                    <th>SELF APPRAISAL RATING</th>
                                                                    <th>SUPERVISOR RATING</th>
                                                                    <th>REMARKS</th>
                                                                    <th>APPROVAL</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- SKILL TABLE -->
                                        <div class="row">
                                            <div class="col-md-5 col-lg-3">
                                                <div class="form-group">
                                                    <label for="skill_date">SKILL DATE</label>
                                                    <input type="text" class="form-control" name="skill_date" style="width:150px" id="skill_date" disabled value="">
                                                </div>
                                            </div>

                                            <div class="col-md-5 col-lg-3">
                                                <div class="form-group">
                                                    <label for="division">DIVISION</label>
                                                    <input type="text" class="form-control" name="division" style="width:150px" id="division" disabled value="">
                                                </div>
                                            </div>

                                            <div class="col-md-5 col-lg-3">
                                                <div class="form-group">
                                                    <label for="department">DEPARTMENT</label>
                                                    <input type="text" class="form-control" name="department" style="width:150px" id="department" disabled value="">
                                                </div>
                                            </div>

                                            <div class="col-md-5 col-lg-3">
                                                <div class="form-group">
                                                    <label for="desination">DESGINATION</label>
                                                    <input type="text" class="form-control" name="desination" style="width:150px" id="desination" disabled value="">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <!-- ROLES -->
                                <div class="col-sm-12 col-md-12 col-lg-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="table-responsive">
                                                <div class="myTable">
                                                    <table id="myTable" class="table table-bordered">
                                                        <thead>
                                                            <tr>
                                                                <th>SNO</th>
                                                                <th>SKILL DESCRIPTION </th>
                                                                <th>DRIVE LINK </th>
                                                                <th>ATTACHEMENT-1</th>
                                                                <th>ATTACHEMENT-2</th>
                                                                <th>ATTACHEMENT-3</th>
                                                                <th>ATTACHEMENT-4</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- ROLES DATE -->
                                    <div class="row">
                                        <div class="col-md-5 col-lg-5">
                                            <div class="form-group">
                                                <label for="country">ROLES DATE</label>
                                                <?php $user_dataa = Session('effect_from2'); ?>
                                                <input type="text" class="form-control" name="effect_from2" style="width:200px" id="effect_from2" disabled value="{{$user_dataa}}">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- ROLES TABLE -->
                                    <div class="col-sm-12 col-md-12 col-lg-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="table-responsive">
                                                    <div class="myTableJ">
                                                        <table id="myTableJ" class="table table-bordered">
                                                            <thead>
                                                                <tr>
                                                                    <th>SNO</th>
                                                                    <th>ROLES</th>
                                                                    <th>TYPE</th>
                                                                    <th>REMARKS</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>



    <!-- LIST ACTIVE -->
    <script>
        var toggler = document.getElementsByClassName("caret");
        var i;
        for (i = 0; i < toggler.length; i++) {
            toggler[i].addEventListener("click", function() {
                this.parentElement.querySelector(".nested").classList.toggle("active");
                this.classList.toggle("caret-down");
            });
        }
    </script>

    <!-- SHOWING CLICKED PERSON KPI DETAILS -->
    @php
    $Ctc_right= Session::get('Ctc_rights');
    @endphp
    <script>
        function myFunction1(user_id) {
            console.log(user_id);
            var selectedId = user_id;
            $.ajax({
                url: "{{ route('getData1', ':id')}}".replace(':id', selectedId),
                type: "GET",
                dataType: 'json',
                success: function(data) {
                    $("#name").val(data.user_name);
                    $("#tno").val(data.user_id_number);
                    $("#dpt").val(data.user_department);
                    $("#designation").val(data.user_destination);
                    $("#division").val(data.Division);
                    $("#doj").val(data.DateofJoin);
                    $("#aps").val(data.Approval_Status);
                    $("#apat").val(data.Approval_At);
                    $("#noreport").val(data.NO_Of_Reporting);
                    $("#emp_no_d").val(data.user_emp_id);

                    let rights = @json($Ctc_right);

                    if (rights === 'Y') {
                        $("#ctc").val(data.Ctc);
                        $("#team_ctc").val(data.Team_Ctc);
                        $("#total_ctc").val(data.Tot_Ctc);
                    } else {
                        $("#ctc").val("---");
                        $("#team_ctc").val("---");
                        $("#total_ctc").val("---");
                    }

                    console.log(data.user_emp_id);
                    $("#empImg").attr("src", '/frontend/emplphotos/' + data.user_emp_id + '.jpeg');
                    document.getElementById('effect_from1').value = '';
                    document.getElementById('effect_from2').value = '';
                    document.getElementById('skill_date').value = '';
                    document.getElementById('division').value = '';
                    document.getElementById('department').value = '';
                    document.getElementById('desination').value = '';

                    var table1 = document.getElementById("myTable1");
                    var rowCount1 = table1.rows.length - 1;

                    for (var i = 0; i < rowCount1; i++) {
                        table1.deleteRow(1);
                    }

                    var table1 = document.getElementById("myTableJ");
                    var rowCount1 = table1.rows.length - 1;

                    for (var i = 0; i < rowCount1; i++) {
                        table1.deleteRow(1);
                    }

                    var table1 = document.getElementById("myTable");
                    var rowCount1 = table1.rows.length - 1;

                    for (var i = 0; i < rowCount1; i++) {
                        table1.deleteRow(1);
                    }
                }
            });
        }
    </script>

    <!-- LOADING KPI TABLE -->
    <script>
        function myFunction12(user_id) {
            var user_id = $('input[name="emp_no_d"]').val();
            console.log(user_id);
            const date = new Date(user_id);
            const month = date.toLocaleString('default', {
                month: 'short'
            });
            const year = date.getFullYear();
            const hello = month + - +year;
            $.ajax({
                url: "{{ route('KPI_Table') }}",
                type: "GET",

                data: {
                    hello_date: user_id,

                },
                dataType: 'json',
                success: function(single1672) {
                    console.log(single1672);
                    var count = single1672.length;
                    var items = 0;

                    var tableHeaderRowCount = 1;
                    var table = document.getElementById('myTable1');
                    var rowCount = table.rows.length;
                    for (var i = tableHeaderRowCount; i < rowCount; i++) {
                        table.deleteRow(tableHeaderRowCount);
                    }

                    for ($i = 0; $i < count; $i++) {
                        items++;
                        var html = "<tr>";
                        html += "<td>" + items + " </td>";
                        html += "<td><input name='usertarget[]' value='" + single1672[$i]['kpi_point'] + "' title='" + single1672[$i]['kpi_point'] + "' style= width:170px readonly></td>";
                        html += "<td><input name='usertarget[]' value='" + single1672[$i]['target'] + "' title='" + single1672[$i]['target'] + "' style= width:70px readonly></td>";
                        html += "<td><input name='usertarget[]' value='" + single1672[$i]['actual'] + "' style= width:70px title='" + single1672[$i]['actual'] + "' readonly></td>";
                        html += "<td><input name='usertarget[]' value='" + single1672[$i]['incharge_point'] + "' title='" + single1672[$i]['incharge_point'] + "' style= width:70px readonly></td>";
                        html += "<td><input name='usertarget[]' value='" + single1672[$i]['remarks'] + "' title='" + single1672[$i]['remarks'] + "' style= width:100px readonly></td>";
                        html += "<td><input name='usertarget[]' value='" + single1672[$i]['approval'] + "' title='" + single1672[$i]['approval'] + "' style= width:70px readonly></td>";

                        var kpi_date = single1672[0].effect_from;
                        var part1_kpi_date = kpi_date.substring(0, 10);
                        var part2_kpi_date = kpi_date.substring(10);
                        $("#effect_from1").val(part1_kpi_date);
                        $eff = (single1672[$i]['effect_from']);
                        html += "<tr>";
                        document.getElementById("myTable1").insertRow().innerHTML = html;
                    }
                }
            });
        }
    </script>

    <!-- SHOWING ROLES  -->
    <script>
        function myFunctionJ(user_id) {
            var user_id = $('input[name="emp_no_d"]').val();
            console.log(user_id);
            const date = new Date(user_id);
            const month = date.toLocaleString('default', {
                month: 'short'
            });
            const year = date.getFullYear();
            const hello = month + - +year;
            $.ajax({
                url: "{{ route('Roles') }}",
                type: "GET",

                data: {
                    hello_date: user_id,
                },
                dataType: 'json',
                success: function(single1672) {
                    console.log(single1672);
                    var count = single1672.length;
                    var items = 0;

                    //ROLES DETAILS ORG
                    var tableHeaderRowCount = 1;
                    var table = document.getElementById('myTableJ');
                    var rowCount = table.rows.length;
                    for (var i = tableHeaderRowCount; i < rowCount; i++) {
                        table.deleteRow(tableHeaderRowCount);
                    }

                    for ($i = 0; $i < count; $i++) {
                        items++;
                        var html = "<tr>";
                        html += "<td>" + items + "</td>";
                        html += "<td><input name='usertarget[]' value='" + single1672[$i]['roles'] + "' title='" + single1672[$i]['roles'] + "' style= width:200px readonly></td>";
                        html += "<td><input name='usertarget[]' value='" + single1672[$i]['type'] + "' title='" + single1672[$i]['type'] + "' style= width:140px readonly></td>";
                        html += "<td><input name='usertarget[]' value='" + single1672[$i]['remarks'] + "' title='" + single1672[$i]['remarks'] + "' style= width:140px readonly></td>";

                        var roles_date = single1672[0].effect_from;
                        var part1_roles_date = roles_date.substring(0, 10);
                        var part2_roles_date = roles_date.substring(10);

                        $("#effect_from2").val(part1_roles_date);
                        html += "<tr>";
                        document.getElementById("myTableJ").insertRow().innerHTML = html;
                    }
                }
            });
        }
    </script>

    <!-- FOR SKILL  -->
    <script>
        function myFunction(user_id) {
            var user_id = $('input[name="emp_no_d"]').val();
            const date = new Date(user_id);
            const month = date.toLocaleString('default', {
                month: 'short'
            });
            const year = date.getFullYear();
            const hello = month + - +year;
            $.ajax({
                url: "{{ route('skill') }}",
                type: "GET",

                data: {
                    hello_date: user_id,
                },
                dataType: 'json',
                success: function(sk_details) {
                    console.log(sk_details);
                    var count = sk_details.length;
                    console.log(count);
                    var items = 0;

                    //ROLES DETAILS ORG
                    var tableHeaderRowCount = 1;
                    var table = document.getElementById('myTable');
                    var rowCount = table.rows.length;
                    for (var i = tableHeaderRowCount; i < rowCount; i++) {
                        table.deleteRow(tableHeaderRowCount);
                    }


                    for ($i = 0; $i < count; $i++) {
                        items++;
                        var html = "<tr>";
                        html += "<td>" + items + "</td>";
                        html += "<td><input name='usertarget[]' value='" + sk_details[$i]['skill'] + "' title='" + sk_details[$i]['skill'] + "' style= width:200px readonly></td>";

                        if (sk_details[$i]['drive_link'] !== "NO Link") {
                            html += "<td><a href='" + sk_details[$i]['drive_link'] + "' class='mr-5 file-link' id='link5' title='" + sk_details[$i]['drive_link'] + "'>Drivelink</a></td>";
                        } else {
                            html += "<td>---</td>";
                        }

                        if (sk_details[$i]['Attachment_1'] !== "null") {
                            html += "<td><a href='" + sk_details[$i]['Attachment_1'] + "' class='mr-5 file-link' id='link1' name='filepath' target='_blank' title='" + sk_details[$i]['Attachment_1'] + "'>Doc-1</a></td>";
                        } else {
                            html += "<td>---</td>";
                        }

                        if (sk_details[$i]['Attachment_2'] !== "null") {
                            html += "<td><a href='" + sk_details[$i]['Attachment_2'] + "' class='mr-5 file-link' id='link2' name='filepath' target='_blank' title='" + sk_details[$i]['Attachment_2'] + "'>Doc-2</a></td>";
                        } else {
                            html += "<td>---</td>";
                        }

                        if (sk_details[$i]['Attachment_3'] !== "null") {
                            html += "<td><a href='" + sk_details[$i]['Attachment_3'] + "' class='mr-5 file-link' id='link3' name='filepath' target='_blank' title='" + sk_details[$i]['Attachment_3'] + "'>Doc-3</a></td>";
                        } else {
                            html += "<td>---</td>";
                        }

                        if (sk_details[$i]['Attachment_4'] !== "null") {
                            html += "<td><a href='" + sk_details[$i]['Attachment_4'] + "' class='mr-5 file-link' id='link4' name='filepath' target='_blank' title='" + sk_details[$i]['Attachment_4'] + "'>Doc-4</a></td>";
                        } else {
                            html += "<td>---</td>";
                        }

                        var roles_date = sk_details[0].Eff_from;
                        var div_name = sk_details[0].Actual_Division_Name;
                        var dept = sk_details[0].DeptName;
                        var desig = sk_details[0].Designation;
                        console.log(roles_date);

                        var part1_roles_date = roles_date.substring(0, 10);
                        var part2_roles_date = roles_date.substring(10);
                        console.log(div_name);

                        $("#skill_date").val(part1_roles_date);
                        $("#division").val(div_name);
                        $("#department").val(dept);
                        $("#desination").val(desig);
                        html += "<tr>";
                        document.getElementById("myTable").insertRow().innerHTML = html;
                    }
                }
            });
        }
    </script>

    @endsection

</body>

</html>