<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>ORGANOGRAM</title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="gplogofinal.png" type="png">

    <!-- CSS Files -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <link rel="stylesheet" href="{{ asset('frontend/css/fonts.min.css')}}">
    <link rel="stylesheet" href="{{ asset('frontend/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{ asset('frontend/css/atlantis.css')}}">
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">

    <style>
        /* ---- Summernote fallback ---- */
        @font-face {font-family:'Summernote';src:local('Arial'),local('Helvetica'),local('sans-serif');}

        /* ---- Caret ---- */
        .caret {cursor:pointer;font-weight:800;}
        .caret::before {content:'▶';display:inline-block;margin-right:6px;transition:transform .2s;}
        .caret-down::before {transform:rotate(90deg);}

        .nested {display:none;padding-left:30px;}
        .active {display:block;}

        .org, .org1, .org3 {
            display:flex;align-items:center;gap:5px;
            padding:8px 16px;margin:8px 0;
            border-radius:6px;color:#fff;
            font-family:"JetBrains Mono",monospace;
            box-shadow:0 2px 4px rgba(45,35,66,.4),0 7px 13px -3px rgba(45,35,66,.3),inset 0 -3px 0 rgba(58,65,111,.5);
            transition:all .15s;
        }
        .org:hover,.org1:hover,.org3:hover {transform:translateY(-1px);box-shadow:0 4px 8px rgba(45,35,66,.4);}
        .org1 {background:radial-gradient(100% 100% at 100% 0,#5adaff 0,#074d66 100%);font-size:15px;height:45px;}
        .org  {background:radial-gradient(100% 100% at 100% 0,#5adaff 0,#4a8da7 100%);font-size:.8rem;}
        .org3 {background:radial-gradient(100% 100% at 100% 0,#5adaff 0,#074d66 100%);font-size:.8rem;}

        .org a, .org1 a, .org3 a {flex:1;color:inherit;text-decoration:none;display:block;}

        #main-content {max-height:80vh;overflow-y:auto;padding-right:10px;}
        .table input[readonly]{background:#f8f9fa;border:none;font-size:12px;}
        .btn-custom{width:200px;padding:10px;color:#fff;background:radial-gradient(100% 100% at 100% 0,#5adaff 0,#074d66 100%);border:none;border-radius:6px;cursor:pointer;font-weight:bold;}
        .btn-custom:hover{transform:translateY(-1px);box-shadow:0 4px 8px rgba(0,0,0,.2);}

         .caret {
        display: contents !important;
    }
    </style>
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
</head>

<body id="body">
    <div id="container" class="spin_container">
        <div id="spinner_divider"></div>
        <p id="load_text"><span id="l_1">G</span><span id="l_2">a</span><span id="l_3">i</span><span id="l_4">n</span><span id="l_5">u</span><span id="l_6">p</span></p>
    </div>

    @section('tittle') {{"ORGANOGRAM"}}@endsection
    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        @php
            ini_set('memory_limit','2048M');
            $orgdata = Session::get('ornogramdata');
            $employees = $orgdata['data'] ?? [];

            // ---- Build lookup map (Emplno → employee) ----
            $empMap = [];
            foreach ($employees as $e) $empMap[$e['Emplno']] = $e;

            // ---- Top-level (reporting_to missing or not in map) ----
            $topLevel = collect($employees)->filter(fn($e) => empty($e['reporting_to']) || !isset($empMap[$e['reporting_to']]))->values();

            // ---- Helper to render a node (uses NO_Of_Reporting_Can for caret) ----
            function renderNode($emp, $map, $lvl = 1) {
                $subCnt   = (int)($emp['NO_Of_Reporting_Can'] ?? 0);
                $hasSubs  = $subCnt > 0;
                $cls      = $lvl == 1 ? 'org1' : ($lvl == 2 ? 'org' : 'org3');
                $notice   = ($emp['Notice'] ?? 'N') === 'Y' ? 'color:yellow;' : '';
                $caretCls = $hasSubs ? 'caret' : '';
                $disp     = $hasSubs ? $emp['C_Name'].' - ('.$subCnt.')' : $emp['C_Name'];

                $html = "<li class=\"{$cls}\">";
                $html .= "<span class=\"{$caretCls}\" style=\"font-weight:800;{$notice}\">";
                $html .= "<a href=\"javascript:void(0)\" class=\"emp-link\" data-id=\"{$emp['Emplno']}\">{$disp}</a>";
                $html .= "</span>";

                if ($hasSubs) {
                    $html .= "<ul class=\"nested\">";
                    foreach ($map as $c) {
                        if (($c['reporting_to'] ?? null) === $emp['Emplno']) {
                            $html .= renderNode($c, $map, $lvl + 1);
                        }
                    }
                    $html .= "</ul>";
                }
                $html .= "</li>";
                return $html;
            }
        @endphp

        <div class="main-panel">
            <div class="container">
                <div class="page-inner">

                    <!-- CTC Header (unchanged) -->
                    <div class="page-header">
                        <div class="row">
                            <div class="col-sm-4"><label>EMP - CTC</label><input type="text" id="ctc" class="form-control bold-input" readonly></div>
                            <div class="col-sm-4"><label>TEAM - CTC</label><input type="text" id="team_ctc" class="form-control bold-input" readonly></div>
                            <div class="col-sm-4"><label>TOTAL / Month</label><input type="text" id="total_ctc" class="form-control bold-input" readonly></div>
                        </div>
                    </div>

                    <div class="row">
                        <!-- ORGANOGRAM TREE -->
                        <div class="col-sm-4" id="main-content">
                            <div class="card">
                                <div class="card-header"><h4>ORGANOGRAM</h4></div>
                                <div class="card-body" style="padding:0;">
                                    <ul id="myUL" style="margin:0;padding:0;">
                                        @foreach($topLevel as $root)
                                            {!! renderNode($root, $empMap) !!}
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- RIGHT PANEL (unchanged except button onclicks) -->
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-md-4"><label>ID</label><input type="text" id="tno" class="form-control" style="width:150px" disabled value="{{ Session::get('user_data') }}"><input type="hidden" id="emp_no_d" value="{{ Session::get('empl_id') }}"></div>
                                        <div class="col-md-4"><label>NAME</label><input type="text" id="name" class="form-control" style="width:180px" disabled value="{{ Session::get('emp_name') }}"></div>
                                        <div class="col-md-4"><button class="btn btn-info" style="margin-top:23px;height:40px;" onclick="location.href='{{ url('OrganogramDB') }}'">REFRESH <i class="icon-refresh"></i></button></div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4 pt-3"><label>DEPARTMENT</label><input type="text" id="dpt" class="form-control" style="width:200px" disabled value="{{ Session::get('dep_data') }}"></div>
                                        <div class="col-md-4 pt-3"><label>DESIGNATION</label><input type="text" id="designation" class="form-control" style="width:200px" disabled value="{{ Session::get('des_data') }}"></div>
                                    </div>
                                </div>

                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4"><button class="btn-custom" onclick="loadKPI()">KPI</button></div>
                                        <div class="col-md-4"><button class="btn-custom" onclick="loadRoles()">ROLES</button></div>
                                        <div class="col-md-4 text-right"><img id="empImg" src="{{ asset('frontend/emplphotos/'.Session::get('empl_id').'.jpeg') }}" width="150" height="130" style="border-radius:8px;"></div>
                                    </div>
                                    <div class="row mt-3">
                                        <div class="col-md-4"><button class="btn-custom" onclick="loadSkills()">SKILL</button></div>
                                        <div class="col-md-4"><button class="btn-custom" onclick="redirectToProfile()">PROFILE</button></div>
                                    </div>
                                </div>

                                <!-- KPI / SKILL / ROLES tables (unchanged) -->
                                <!-- … (your existing table markup) … -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endsection
    </div>

    <!-- All your existing scripts (CTC, KPI, Roles, Skill) stay exactly the same – only the tree JS is new -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

    <!-- NEW TREE JS (replace the old caret + myFunction1 scripts) -->
    <script>
        const CTC_RIGHTS = @json(Session::get('Ctc_rights'));

        $(function () {
            // 1. Caret toggle (only caret, never the link)
            $(document).on('click', '.caret', function (e) {
                if (e.target.tagName === 'A') return;
                $(this).toggleClass('caret-down')
                       .parent().children('.nested').toggleClass('active');
            });

            // 2. Employee click
            $(document).on('click', '.emp-link', function (e) {
                e.stopPropagation();
                const empId = $(this).data('id');
                loadEmployee(empId);
            });

            // 3. Load logged-in user on start
            loadEmployee($('#emp_no_d').val());
        });

        function loadEmployee(empId) {
            $.get("{{ route('getData1', ':id') }}".replace(':id', empId), function (d) {
                $('#name').val(d.user_name);
                $('#tno').val(d.user_id_number);
                $('#dpt').val(d.user_department);
                $('#designation').val(d.user_destination);
                $('#emp_no_d').val(d.user_emp_id);
                $('#empImg').attr('src', '/frontend/emplphotos/' + d.user_emp_id + '.jpeg?' + Date.now());

                loadCTC(d.user_emp_id);
                clearTables();
            }).fail(() => alert('Failed to load employee'));
        }

        function loadCTC(empId) {
            $.get("{{ route('CTCDash') }}", {empdata: empId}, function (d) {
                if (CTC_RIGHTS === 'Y' && d) {
                    $('#ctc').val(d.Emp_ctc ? `₹ ${Number(d.Emp_ctc).toLocaleString('en-IN')}` : '---');
                    $('#team_ctc').val(d.team_ctc ? `₹ ${Number(d.team_ctc).toLocaleString('en-IN')}` : '---');
                    $('#total_ctc').val(d.total_ctc ? `₹ ${Number(d.total_ctc).toLocaleString('en-IN')}` : '---');
                } else {
                    $('#ctc,#team_ctc,#total_ctc').val('---');
                }
            });
        }

        function clearTables() {
            ['myTable1','myTableJ','myTable'].forEach(id => {
                const t = document.getElementById(id);
                while (t.rows.length > 1) t.deleteRow(1);
            });
            $('#effect_from1,#effect_from2,#skill_date,#division,#department,#desination').val('');
        }

        /* ----- KPI / ROLES / SKILL functions (unchanged) ----- */
        function loadKPI() { /* your existing myFunction12 code */ }
        function loadRoles() { /* your existing myFunctionJ code */ }
        function loadSkills() { /* your existing myFunction code */ }
        function redirectToProfile() { location.href = '/profile?emplno=' + $('#emp_no_d').val(); }
    </script>

    <!-- Keep your KPI / Roles / Skill AJAX functions exactly as you already have them -->
    <!-- (just rename the calls to loadKPI(), loadRoles(), loadSkills() in the buttons above) -->
</body>
</html>