@extends('LifeAtGainup.Navbar.header')
@section('tittle')
{{"Operations Dashboard"}}
@endsection
<head>
    <title>Operation Dashboard</title>
<link rel="icon" href="gplogofinal.png" type="png">
<link href="LifeAtGainup_Assets/assets/css/operationsDashboard.css" rel="stylesheet" type="text/css" />
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<style> 
    .sideallign {
            text-align: end !important;
        }

        #tableAppstrike tbody td:nth-child(3),
        #tableAppstrike tbody td:nth-child(4),
        #tableAppstrike tbody td:nth-child(5),
        #tableAppstrike tbody td:nth-child(6),
        #tableAppstrike tbody td:nth-child(7),
        #tableAppstrike tbody td:nth-child(8) {
            text-align: right;
        }

        
        #tableAppstrike tfoot th{
            text-align: right;
        }
</style>
<div id="layout-wrapper">
    @section('content')

    <div class="main-content">
        <div class="page-content">

            <div class="container-fluid">
                <!-- <h1 style="text-align:center; margin-bottom:40px">Gainup Garments - Operations Dashboard </h1> -->

                <div class="card-header">
                    <div class="row">
                        <div class="col-md-12 d-flex justify-content-between align-items-center">
                            <!-- Breadcrumb Section -->
                            <nav aria-label="breadcrumb" class="d-flex align-items-center">
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item me-1" aria-current="page">
                                        Dashboard
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="/operationlist" class="text-decoration-none text-primary">
                                            Gainup Garments - Operations Details
                                        </a>
                                    </li>
                                </ol>
                            </nav>
                        </div>
                        <hr>
                    </div>
                </div>

                <div id="preloder">
                    <div class="lds-hourglass">

                    </div>
                </div>
                <div class="row ">


                    <div class="col-md-6">
                        <h6>Today's Production details:</h6>
                        <table id="tableAppstrike" class="table  table_popup mt-3 mb-3">
                            <thead class="header-fixed">
                                <tr>
                                    <th>S.No</th>
                                    <th>Unit</th>
                                    <th>Input Qty</th>
                                    <th>Output Qty</th>
                                    <th>Earned Mins</th>
                                    <th>Ack Ped</th>
                                    <th>SM Stock</th>
                                    <th>WIP Qty</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="2" class="sideallign">Total:</th>
                                    <th id="inputqty" data-opt="Input" class="tdayFooterTotal sideallign">0</th>
                                    <th id="outputqty" data-opt="Output" class="tdayFooterTotal sideallign">0</th>
                                    <th id="earnminis" class="sideallign">0</th>
                                    <th id="ack_ped" data-opt="ACK" class="tdayFooterTotal sideallign">0</th>
                                    <th id="sm_stock" data-opt="SMStock" class="tdayFooterTotal sideallign">0</th>
                                    <th id="wip" data-opt="WIP" class="tdayFooterTotal sideallign">0</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <input type="hidden" name="emp_id" id="emp_id" value="{{$user = Session('empl_id')}}">



                    <div class="col-md-6 ">
                        <canvas id="barChart"></canvas>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xxl-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col-md-6">
                                        SELECT FILTER
                                    </div>

                                </div>
                            </div>

                            <div class="card-body">
                                <div class="row">
                                    <!-- Select Option Dropdown -->
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label for="select_option" class="form-label">Select Option</label>
                                            <select class="form-control" name="select_option" id="select_option">
                                                <option value="" selected>Select Report</option>
                                                <option value="Tvl">Turn Over</option>
                                                <option value="Tminis">Earned Mins</option>
                                                <option value="Tqty">Production Qty</option>
                                                <option value="Total_OWE">OWE</option>
                                                <option value="Tailor">Tailor</option>
                                                <option value="cutting_status">Cutting Status</option>
                                                <option value="packing">Packing</option>
                                            </select>
                                        </div>
                                        <span class="filter_row filterheading" s style="color:red;display: none;  font-size: 11px;">Note : This implies that all the values mentioned are in the unit of lakhs.</span>
                                    </div>

                                    <!-- Month and Year Picker -->
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label for="monthYearPicker" class="form-label">Select Month</label>
                                            <input type="text" id="monthYearPicker" class="form-control" placeholder="Select Month and Year">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>


                <div class="row production_6 Tminis" style="display: none;">
                    <div class="col-md-6">
                        <h6>Last 6 Months (Sewing) Earned Mins Details:</h6>
                        <table id="tableAppMonth" class="table table-bordered table_popup mt-3 mb-3" style="font-size:10px">

                            <tbody></tbody>

                        </table>
                    </div>
                    <input type="hidden" name="emp_id" id="emp_id" value="{{$user = Session('empl_id')}}">



                    <div class="col-md-6 " style="font-size:10px">
                        <canvas id="barChartMOnth"></canvas>
                    </div>
                </div>


                <div class="row production_6 Tvl" style="display: none;">
                    <div class="col-md-6">
                        <h6>Last 6 Months (Sewing) Turnover Value Details:</h6>
                        <table id="tableportaltvl" class="table table-bordered table_popup mt-3 mb-3" style="font-size:10px">

                            <tbody></tbody>

                        </table>
                    </div>
                    <input type="hidden" name="emp_id" id="emp_id" value="{{$user = Session('empl_id')}}">



                    <div class="col-md-6 " style="font-size:10px">
                        <canvas id="barChartMOnth_portaltvl"></canvas>
                    </div>
                </div>

                <div class="row production_6 Tqty" style="display: none;">
                    <div class="col-md-6">
                        <h6>Last 6 Months (Sewing) Production Qty Details:</h6>
                        <table id="tableportalqty" class="table table-bordered table_popup mt-3 mb-3" style="font-size:10px">

                            <tbody></tbody>

                        </table>
                    </div>
                    <input type="hidden" name="emp_id" id="emp_id" value="{{$user = Session('empl_id')}}">



                    <div class="col-md-6 " style="font-size:10px">
                        <canvas id="barChartMOnth_portalqty"></canvas>
                    </div>
                </div>


                <div class="row production_6 Total_OWE" style="display: none;">
                    <div class="col-md-6">
                        <h6>Last 6 Months (Sewing) Total OWE</h6>

                        <table id="tableportalowe" class="table table-bordered table_popup mt-3 mb-3" style="font-size:10px">

                            <tbody></tbody>

                        </table>

                    </div>
                    <input type="hidden" name="emp_id" id="emp_id" value="{{$user = Session('empl_id')}}">



                    <div class="col-md-6 " style="font-size:10px">
                        <canvas id="barChartMOnth_portalowe"></canvas>
                    </div>
                </div>

                <div class="row production_6 Tailor" style="display: none;">
                    <div class="col-md-6">
                        <h6>Last 6 Months Tailor</h6>
                        <table id="tableportaltailor" class="table table-bordered table_popup mt-3 mb-3" style="font-size:10px">

                            <tbody></tbody>

                        </table>
                    </div>
                    <input type="hidden" name="emp_id" id="emp_id" value="{{$user = Session('empl_id')}}">



                    <div class="col-md-6 " style="font-size:10px">
                        <canvas id="barChartMOnth_portaltailor"></canvas>
                    </div>
                </div>
                <div class="row production_6 cutting_status" style="display: none;">
                    <div class="col-md-6">
                        <h6>Last 6 Month Cutting</h6>
                        <table id="tableportalcutting" class="table table-bordered table_popup mt-3 mb-3" style="font-size:10px">

                            <tbody></tbody>

                        </table>
                    </div>
                    <input type="hidden" name="emp_id" id="emp_id" value="{{$user = Session('empl_id')}}">



                    <div class="col-md-6 " style="font-size:10px">
                        <canvas id="barChartMOnth_portalcutting"></canvas>
                    </div>
                </div>
                <div class="row production_6 packing" style="display: none;">
                    <div class="col-md-6">
                        <h6>Last 6 Month Packing</h6>
                        <table id="tableportalpacking" class="table table-bordered table_popup mt-3 mb-3" style="font-size:10px">

                            <tbody></tbody>

                        </table>
                    </div>
                    <input type="hidden" name="emp_id" id="emp_id" value="{{$user = Session('empl_id')}}">



                    <div class="col-md-6 " style="font-size:10px">
                        <canvas id="barChartMOnth_portalpacking"></canvas>
                    </div>
                </div>

                <div class="row filter_row" style="display: none;">

                    <div class="col-md-12 load_turnover">
                        <h6><span class='month_heder'></span></h6>

                        <table class="table table-bordered table_popup table_production" id="dynamicTable">
                            <thead>
                                <!-- Table headers will be inserted here dynamically -->
                            </thead>
                            <tbody>
                                <!-- Table rows will be inserted here dynamically -->
                            </tbody>
                        </table>
                        <table class="table table-bordered table_popup table_production" id="abstractTable">
                            <thead>
                                <!-- Table headers will be inserted here dynamically -->
                            </thead>
                            <tbody>
                                <!-- Table rows will be inserted here dynamically -->
                            </tbody>
                        </table>
                    </div>


                    <div class="col-md-12 ">
                        <canvas id="multipleLineChart" width="800" height="280"></canvas>
                    </div>
                </div>
                <div class="row">

                    <div class="col-6">
                        <div class="card">
                            <div class="card-header">
                                <h1 class="card-title">Usage Analysis</h1>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive  table-card">
                                    <table class="table table-hover table-centered align-middle" id="userlogaudit">
                                        <thead class="text-muted table-light" style="font-size: 11px;">
                                            <tr>
                                                <th style="width: 50px;">SNO</th>
                                                <th>Name</th>
                                                {{-- <th>IP address</th> --}}
                                                <th>Last Login</th>
                                            </tr>
                                        </thead>
                                        <tbody style="font-size: 11px">
                                            <!-- Data will be loaded here via AJAX -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="emp_id" id="emp_id" value="{{$user = Session('empl_id')}}">
            </div>
        </div>
        
        <div class="modal fade" id="DefectDetailsModal" tabindex="-1">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="DefectOcnDetailsModalLabel">Row Details</h5>
                        <button type="button" class="btn-close right" data-bs-dismiss="modal"></button>
                    </div>            
                    <div class="modal-body" id="OcnDefectDetailsContent">
                        <!-- Row details will be filled here -->
                    </div>
                </div>
            </div>
        </div>
        @endsection

        @section('script')

        <!-- <script src="LifeAtGainup_Assets/assets/js/operationsDashboard.js"></script> -->


        <script>
            window.LaravelRoutes = {
                operationDashboard: "{{ route('operationdashboard') }}",
                operationReport: "{{ route('operationreport') }}",
                operationReportTmins: "{{ route('operationreporttmins') }}",
                operationReportQty: "{{ route('operationreportqty') }}",
                operationReportOwe: "{{ route('operationreportowe') }}",
                operationCutting: "{{ route('operationcutting') }}",
                operationPacking: "{{ route('operationpacking') }}",
                dashboardAnaly: "{{ route('dashboardanaly') }}",
                userLogMerch_opt: "{{ route('userlogmerch_opt') }}",
            };
        </script>

        <script>
            $(document).ready(function () {
                $.ajax({
                    url: "{{ route('operationdashboard') }}", // route should point to this controller
                    method: "GET",
                    dataType: "json",
                    success: function (data) {
                        $('#loader').hide();
                        $('#dataContainer').show();

                        // Simple example to print JSON
                        $('#dataContainer').html('<pre>' + JSON.stringify(data, null, 2) + '</pre>');

                        // You can loop through data and render it better
                    },
                    error: function () {
                        $('#loader').text('Failed to load data.');
                    }
                });
            });
            //Today production drilldown popup
            $(document).on('click', '.tdayFooterTotal', function (e) {
            e.preventDefault();

                const optdate = $(this).data('opt');
                $("#DefectOcnDetailsModalLabel").text(`Today's Production Details - ${optdate}`);

                $.ajax({
                    url: "{{ route('TodayOperationDash') }}",
                    method: 'GET',
                    data: { optdate },
                    success: function (response) {
                        $("#DefectDetailsModal").modal("show");

                        let data = response.data || [];
                        if (data.length === 0) {
                            $("#OcnDefectDetailsContent").html("<p>No data available.</p>");
                            return;
                        }

                        // Build table headers and body
                        let tableHtml = `<table class='table table-hover table-bordered' id='presentationchkdef'>
                            <thead><tr>` +
                            Object.keys(response.data[0]).map((key, index) =>
                                `<th id="header-${key}">${key}<br><select style="width: 100%;" id="filter-${index}"><option value="">All</option></select></th>`
                            ).join('') +
                            `</tr></thead><tbody>`;

                        response.data.forEach((row, rowIndex) => {
                            tableHtml += `<tr>` +
                                Object.entries(row).map(([key, value]) => {
                                    let cellId = `cell-${key}-${rowIndex + 1}`;
                                    return `<td id="${cellId}">${value}</td>`;
                                }).join('') +
                                `</tr>`;
                        });

                        tableHtml += `</tbody><tfoot><tr>` +
                            Object.keys(response.data[0]).map((key) => `<th id="footer-${key}"></th>`).join('') +
                            `</tr></tfoot></table>`;


                        $("#OcnDefectDetailsContent").html(tableHtml);
                        $('#presentationchkdef').css({ 'font-size': '10px' });
                        $('#presentationchkdef th').css({ 'padding': '4px 6px' });

                        // Initialize DataTable
                        const table = $('#presentationchkdef').DataTable({
                            paging: false,
                            searching: true,
                            ordering: false,
                            initComplete: function () {
                                const inputFieldMap = {
                                    'Unit': '#unitInput',
                                    'Buyer': '#buyerInput',
                                    'Order_No': '#orderNoInput',
                                    'Item': '#itemInput',
                                    'Color': '#colorInput',
                                    'Input': '#inputQty'
                                };

                                this.api().columns().every(function () {
                                    const column = this;
                                    const index = column.index();
                                    const select = $(`#filter-${index}`);

                                    const uniqueSet = new Set();
                                    column.data().each(function (d) {
                                        if (d) uniqueSet.add(d);
                                    });

                                    Array.from(uniqueSet).sort().forEach(val => {
                                        select.append(`<option value="${val}">${val}</option>`);
                                    });

                                    select.on('change', function () {
                                        const val = $.fn.dataTable.util.escapeRegex($(this).val());
                                        column.search(val ? `^${val}$` : '', true, false).draw();

                                        // Sync to inputs if mapped
                                        const headerText = $(column.header()).clone().children('select').remove().end().text().trim();
                                        const inputSelector = inputFieldMap[headerText];
                                        if (inputSelector) $(inputSelector).val(val);

                                        // Update all dropdowns based on visible column cells only
                                        table.columns().every(function () {
                                            const col = this;
                                            const colIndex = col.index();
                                            const selectElem = $(`#filter-${colIndex}`);
                                            const currentValue = selectElem.val(); // store current selected value

                                            const visibleVals = new Set();

                                            // Loop through visible rows only
                                            col.nodes().to$().each(function () {
                                                const cell = $(this);
                                                if (cell.closest('tr').is(':visible')) {
                                                    const cellText = cell.text().trim();
                                                    if (cellText !== '') visibleVals.add(cellText);
                                                }
                                            });

                                            // Clear and repopulate dropdown
                                            selectElem.empty().append(`<option value="">All</option>`);
                                            Array.from(visibleVals).sort().forEach(v => {
                                                const selected = (v === currentValue) ? 'selected' : '';
                                                selectElem.append(`<option value="${v}" ${selected}>${v}</option>`);
                                            });
                                        });
                                    });

                                });
                            },

                            footerCallback: function (row, data, start, end, display) {
                                const api = this.api();
                                const totalColumns = ['Input', 'Sew_Qty', 'Rej_Qty', 'Ern_Mins', 'Ack_Pend', 'Stock', 'Wip'];

                                const columnIndicesToTotal = [];
                                
                                // Find indices based on header names
                                api.columns().every(function (index) {
                                    const colTitle = $(this.header()).clone().children('select').remove().end().text().trim();
                                    if (totalColumns.includes(colTitle)) {
                                        columnIndicesToTotal.push(index);
                                    }
                                });

                                // Recalculate totals for visible (filtered) data only
                                columnIndicesToTotal.forEach(function (colIdx) {
                                    const total = api.column(colIdx, { search: 'applied' }).data().reduce((a, b) => {
                                        const x = parseFloat(String(a).replace(/,/g, '')) || 0;
                                        const y = parseFloat(String(b).replace(/,/g, '')) || 0;
                                        return x + y;
                                    }, 0);

                                    $(api.column(colIdx).footer()).html(
                                        total.toLocaleString(undefined, { maximumFractionDigits: 2 })
                                    );
                                });
                            }

                        });
                    },
                    error: function (xhr, status, error) {
                        console.error("Drilldown Fetch Error:", error);
                        $("#OcnDefectDetailsContent").html("<p class='text-danger'>Error loading data. Try again.</p>");
                    }
                });
            });
            // $(document).on('click', '.tdayFooterTotal', function(e) {
            //     e.preventDefault();
            //     var optdate = $(this).data('opt');
            //     $("#DefectOcnDetailsModalLabel").text(`Today's Production details -  ${optdate}`);
            //     $.ajax({
            //         url: "{{ route('TodayOperationDash') }}",
            //         method: 'GET',
            //         data: { optdate: optdate},                                    
            //         success: function (response) {
            //             $("#DefectDetailsModal").modal("show");
            //             let tableHtml = `<table class='table table-hover table-bordered' id='presentationchkdef'>
            //                 <thead><tr>` +
            //                 Object.keys(response.data[0]).map(key => 
            //                     `<th>${key}<br><select style="width: 100%;"><option value="">All</option></select></th>`
            //                 ).join('') +
            //                 `</tr></thead><tbody>`;

            //             response.data.forEach(row => {
            //                 tableHtml += "<tr>" + Object.entries(row).map(([key, value]) => {
            //                     return key === 'Order_No' 
            //                         ? `<td>${value}</td>` 
            //                         : `<td>${value}</td>`;
            //                 }).join('') + "</tr>";
            //             });

            //             tableHtml += `</tbody><tfoot><tr>` + 
            //                 Object.keys(response.data[0]).map(() => `<th></th>`).join('') + 
            //                 `</tr></tfoot></table>`;

            //             $("#OcnDefectDetailsContent").html(tableHtml);
            //             $('#presentationchkdef').css('font-size', '10px');
            //             $('#presentationchkdef th').css('padding', '4px 6px');

            //             // Correct DataTable ID here
            //             //$.getScript("https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js", function() {
            //                 $('#presentationchkdef').DataTable({ // Corrected from #processpotable2
            //                     paging: false,
            //                     searching: true,
            //                     ordering: false,
            //                     initComplete: function () {
            //                         this.api().columns().every(function () {
            //                             var column = this;
            //                             var select = $('select', column.header());
            //                             var uniqueValues = [];

            //                             column.data().unique().sort().each(function (d) {
            //                                 if (d !== null && d !== undefined && d !== '') {
            //                                     if (!uniqueValues.includes(d)) {
            //                                         uniqueValues.push(d);
            //                                     }
            //                                 }
            //                             });

            //                             uniqueValues.forEach(d => {
            //                                 select.append(`<option value="${d}">${d}</option>`);
            //                             });

            //                             select.on('change', function () {
            //                                 var val = $.fn.dataTable.util.escapeRegex($(this).val());
            //                                 column.search(val ? '^' + val + '$' : '', true, false).draw();
            //                             });
            //                         });
            //                     },
            //                     footerCallback: function (row, data, start, end, display) {
            //                         let api = this.api();

            //                         // Columns to total (original column names)
            //                         const totalColumns = ['Input', 'Sew_Qty', 'Rej_Qty', 'Ern_Mins', 'Ack_Pend', 'Stock', 'Wip'];

            //                         // Reverse map to get sanitized column index
            //                         const columnIndicesToTotal = [];

            //                         api.columns().every(function (index) {
            //                             const colTitle = $(this.header()).clone().children('select').remove().end().text().trim();
            //                             if (totalColumns.includes(colTitle)) {
            //                                 columnIndicesToTotal.push(index);
            //                             }
            //                         });

            //                         // Loop through the target columns
            //                         columnIndicesToTotal.forEach(function (colIdx) {
            //                             let total = api.column(colIdx, { filter: 'applied' }).data()
            //                                 .reduce(function (a, b) {
            //                                     const x = parseFloat(String(a).replace(/,/g, '')) || 0;
            //                                     const y = parseFloat(String(b).replace(/,/g, '')) || 0;
            //                                     return x + y;
            //                                 }, 0);

            //                             // Write to footer
            //                             $(api.column(colIdx).footer()).html(total.toLocaleString(undefined, { maximumFractionDigits: 2 }));
            //                         });
            //                     }
            //                 });
            //             //});

            //             // Show the modal (placed inside success function)
            //             //var orderModal = new bootstrap.Modal(document.getElementById('OcnDefectDetailsModal'));
            //             //orderModal.show();
            //         },
            //         error: function(xhr, status, error) {
            //             console.error('Error:', error);
            //         }
            //     });
            // });
        </script>











































        <script>
            $(document).ready(function() {


                function fadeOutLoader() {
                    return new Promise((resolve) => {
                        $("#preloder").fadeOut(300, resolve);
                    });
                }

                $.ajax({
                    url: "{{ route('operationdashboard') }}",
                    method: 'GET',
                    success: function(response) {
                        fadeOutLoader().then(() => {
                            if (response.success) {
                                // Execute the functions after the fadeOut is complete
                                populateAppstrikeTable(response.data.listdata);
                                generateBarChart(response.data.listdata);
                                populateMonthData(response.data.monthdata, response.data.monthkey);
                                populatePortalTVL(response.data.portaltval, response.data.portalkey);
                                populatePortalQTY(response.data.portaltqty, response.data.portqtykey);
                            } else {
                                console.error("API returned success false.");
                            }
                        });
                    },
                    error: function() {
                        console.log("Error fetching data.");
                        // Fade out the loader even in case of error
                        fadeOutLoader();
                    }
                });

            });

            function getTableData1() {
                var labels = [];
                var inputData = [];
                var outputData = [];
                var earnMinisData = [];
                var wipData = [];
                var TotalQty = [];
                var month4 = [];
                var month5 = [];
                var month6 = [];

                // Get table rows and extract data from each row
                $('#tableAppMonth tbody tr').each(function(index, row) {
                    if ($(row).is(':last-child')) {
                        //$(row).remove();  // Remove the last row
                    } else {
                        var unit = $(this).find('td').eq(0).text();
                        var input = $(this).find('td').eq(1).text();
                        var output = $(this).find('td').eq(2).text();
                        var earnMinis = $(this).find('td').eq(3).text();
                        var wip = $(this).find('td').eq(4).text();
                        var m4 = $(this).find('td').eq(5).text();
                        var m5 = $(this).find('td').eq(6).text();

                        var total = $(this).find('td').eq(7).text();
                        console.log(total);

                        labels.push(unit);
                        inputData.push(parseInt(input.replace(/,/g, ''), 10));
                        outputData.push(parseInt(output.replace(/,/g, ''), 10));
                        earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
                        wipData.push(parseInt(wip.replace(/,/g, ''), 10));
                        month4.push(parseInt(m4.replace(/,/g, ''), 10));
                        month5.push(parseInt(m5.replace(/,/g, ''), 10));


                        TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
                    }
                });

                return {
                    labels: labels,
                    inputData: inputData,
                    outputData: outputData,
                    earnMinisData: earnMinisData,
                    wipData: wipData,
                    month4: month4,
                    month5: month5,

                    TotalQty: TotalQty,
                };
            }


            function populateAppstrikeTable(data) {
                const $tableBody = $('#tableAppstrike tbody');
                const $accessTypeDropdown = $('#accessTypeDropdown');
                const accessTypes = new Set();

                $tableBody.empty();
                let totalAppAmount = 0;
                let totalUnAppAmount = 0;
                let earnminis = 0;
                let wip = 0;
                let ack_ped = 0;
                let sm_stock = 0;

                $.each(data, function(index, item) {
                    let appAmount = item.Input;
                    let unappAmount = item.Output;
                    let totalearn = item.Ern_Mins;
                    let totalackped = item.Ack_Pend;
                    let totalsmstock = item.SM_Stock;
                    let totalwip = item.Wip;
                    const row = `
                    <tr>
                        <td>${index + 1}</td>
                        <td>${item.Unit}</td>
                        <td >${formatIndianNumber12(item.Input)}</td>
                        <td >${formatIndianNumber12(item.Output)}</td>
                        <td >${formatIndianNumber12(item.Ern_Mins)}</td>
                        <td >${formatIndianNumber12(item.Ack_Pend)}</td>
                        <td >${formatIndianNumber12(item.SM_Stock)}</td>
                        <td >${formatIndianNumber12(item.Wip)}</td>
                     
                    </tr>
                `;
                    $tableBody.append(row);

                    totalAppAmount += parseFloat(appAmount) || 0;
                    totalUnAppAmount += parseFloat(unappAmount) || 0;
                    earnminis += parseFloat(totalearn) || 0;
                    wip += parseFloat(totalwip) || 0;
                    ack_ped += parseFloat(totalackped) || 0;
                    sm_stock += parseFloat(totalsmstock) || 0;

                    accessTypes.add(item.Access_Type);
                });

                $('#totalAppQtyStrike').text(parseInt(totalAppAmount));
                $('#totalAppAmountStrike').text(totalUnAppAmount);
                $('#earnminis').text(earnminis);
                $('#wip').text(wip);
                $('#ack_ped').text(ack_ped);
                $('#sm_stock').text(sm_stock);

                $accessTypeDropdown.empty();
                $accessTypeDropdown.append('<option value="">All Access Types</option>');
                accessTypes.forEach(function(accessType) {
                    $accessTypeDropdown.append(`<option value="${accessType}">${accessType}</option>`);
                });

                if (!$.fn.DataTable.isDataTable('#tableAppstrike')) {
                    appstrikeTable = $('#tableAppstrike').DataTable({
                        paging: false,
                        searching: false,
                        ordering: false,
                        info: false,
                        drawCallback: function() {
                            let totalFilteredAppQty = 0;
                            let totalFilteredAppAmount = 0;

                            $('#tableAppstrike tbody tr:visible').each(function() {
                                const appQty = parseFloat($(this).find('td:nth-child(3)').text()) || 0;
                                const appAmount = parseFloat($(this).find('td:nth-child(4)').text()) || 0;

                                totalFilteredAppQty += appQty;
                                totalFilteredAppAmount += appAmount;
                            });

                            $('#totalAppQtyStrike').text(parseInt(totalFilteredAppQty));
                            $('#totalAppAmountStrike').text(parseInt(totalFilteredAppAmount));
                        }
                    });
                }
            }


            function populateMonthData(data, Key) {
                const $tableBody = $('#tableAppMonth tbody');
                const $accessTypeDropdown = $('#accessTypeDropdown');
                const accessTypes = new Set();

                const monthsDataKey = Key;

                $tableBody.empty();
                let totalAppAmount = 0;
                let totalUnAppAmount = 0;
                let earnminis = 0;
                let wip = 0;

                let headerRow = '<thead><tr>';

                // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
                $.each(monthsDataKey, function(index, key) {
                    headerRow += `<th>${key}</th>`;
                });
                headerRow += '</tr></thead>';

                // Append the header row to the table
                $('#tableAppMonth').append(headerRow);


                $.each(data, function(index, item) {
                    var unit = monthsDataKey[0];
                    var M1 = monthsDataKey[1];
                    var M2 = monthsDataKey[2];
                    var M3 = monthsDataKey[3];
                    var M4 = monthsDataKey[4];
                    var M5 = monthsDataKey[5];
                    var M6 = monthsDataKey[6];
                    var M7 = monthsDataKey[7];


                    let appAmount = item[unit];
                    let unappAmount = item[M1];
                    let totalearn = item[M2];
                    let totalwip = item[M3];
                    const row = `
                    <tr>
                        
                        <td>${item[unit]}</td>
                        <td >${formatIndianNumber1(item[M1])}</td>
                        <td >${formatIndianNumber1(item[M2])}</td>
                        <td >${formatIndianNumber1(item[M3])}</td>
                        <td >${formatIndianNumber1(item[M4])}</td>
                        <td >${formatIndianNumber1(item[M5])}</td>
                        <td >${formatIndianNumber1(item[M6])}</td>
                       
                        <td style="text-align:right;font-weight:bold">${formatIndianNumber1(item[M7])}</td>
                     
                    </tr>`;
                    $tableBody.append(row);

                    totalAppAmount += parseFloat(appAmount) || 0;
                    totalUnAppAmount += parseFloat(unappAmount) || 0;
                    earnminis += parseFloat(totalearn) || 0;
                    wip += parseFloat(totalwip) || 0;

                    accessTypes.add(item.Access_Type);
                });


                var data = getTableData1(); // Get the extracted table data
                var ctx = document.getElementById('barChartMOnth').getContext('2d');

                // Destroy the previous chart if it exists

                // Create a new bar chart
                window.barChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: data.labels, // Using labels from the extracted data
                        datasets: [{
                                label: 'Month-I',
                                data: data.inputData, // Using dynamic data
                                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                                borderColor: 'rgba(75, 192, 192, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-II',
                                data: data.outputData, // Using dynamic data
                                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                                borderColor: 'rgba(54, 162, 235, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-III',
                                data: data.earnMinisData, // Using dynamic data
                                backgroundColor: 'rgba(255, 206, 86, 0.6)',
                                borderColor: 'rgba(255, 206, 86, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-IV',
                                data: data.wipData, // Using dynamic data
                                backgroundColor: 'rgba(153, 102, 255, 0.6)',
                                borderColor: 'rgba(153, 102, 255, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-V',
                                data: data.month4, // Using dynamic data
                                backgroundColor: 'rgba(255, 159, 64, 0.6)',
                                borderColor: 'rgba(255, 159, 64, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-VI',
                                data: data.month5, // Using dynamic data
                                backgroundColor: 'rgba(75, 163, 59, 0.6)',
                                borderColor: 'rgba(75, 163, 59, 1)',
                                borderWidth: 1
                            },


                        ]

                    },
                    options: {
                        responsive: true,
                        title: {
                            display: true,
                            text: 'Last 6 Month Data'
                        },
                        scales: {
                            x: {
                                stacked: false // Bars will be side by side
                            },
                            y: {
                                beginAtZero: true // Start Y-axis at 0
                            }
                        }
                    }
                });





            }










            function populateAppstrikeTable(data) {
                const $tableBody = $('#tableAppstrike tbody');
                const $accessTypeDropdown = $('#accessTypeDropdown');
                const accessTypes = new Set();

                $tableBody.empty();
                let totalAppAmount = 0;
                let totalUnAppAmount = 0;
                let earnminis = 0;
                let wip = 0;
                let ackped = 0;
                let smstock = 0;

                $.each(data, function(index, item) {
                    let appAmount = item.Input;
                    let unappAmount = item.Output;
                    let totalearn = item.Ern_Mins;
                    let totalackped = item.Ack_Pend;
                    let totalsmstock = item.SM_Stock;
                    let totalwip = item.Wip;

                    const row = `
                    <tr>
                        <td>${index + 1}</td>
                        <td>${item.Unit}</td>
                        <td >${formatIndianNumber12(item.Input)}</td>
                        <td >${formatIndianNumber12(item.Output)}</td>
                        <td >${formatIndianNumber12(item.Ern_Mins)}</td>
                        <td >${formatIndianNumber12(item.Ack_Pend)}</td>
                        <td >${formatIndianNumber12(item.SM_Stock)}</td>
                        <td >${formatIndianNumber12(item.Wip)}</td>
                     
                    </tr>
                `;
                    $tableBody.append(row);

                    totalAppAmount += parseFloat(appAmount) || 0;
                    totalUnAppAmount += parseFloat(unappAmount) || 0;
                    earnminis += parseFloat(totalearn) || 0;
                    wip += parseFloat(totalwip) || 0;
                    ackped += parseFloat(totalackped) || 0;
                    smstock += parseFloat(totalsmstock) || 0;

                    accessTypes.add(item.Access_Type);
                });

                $('#inputqty').text(formatIndianNumber12(totalAppAmount));
                $('#outputqty').text(formatIndianNumber12(totalUnAppAmount));
                $('#earnminis').text(formatIndianNumber12(earnminis));
                $('#wip').text(formatIndianNumber12(wip));
                $('#ack_ped').text(formatIndianNumber12(ackped));
                $('#sm_stock').text(formatIndianNumber12(smstock));

                $accessTypeDropdown.empty();
                $accessTypeDropdown.append('<option value="">All Access Types</option>');
                accessTypes.forEach(function(accessType) {
                    $accessTypeDropdown.append(`<option value="${accessType}">${accessType}</option>`);
                });

                if (!$.fn.DataTable.isDataTable('#tableAppstrike')) {
                    appstrikeTable = $('#tableAppstrike').DataTable({
                        paging: false,
                        searching: false,
                        ordering: false,
                        info: false,
                        drawCallback: function() {
                            let totalFilteredAppQty = 0;
                            let totalFilteredAppAmount = 0;

                            $('#tableAppstrike tbody tr:visible').each(function() {
                                const appQty = parseFloat($(this).find('td:nth-child(3)').text()) || 0;
                                const appAmount = parseFloat($(this).find('td:nth-child(4)').text()) || 0;

                                totalFilteredAppQty += appQty;
                                totalFilteredAppAmount += appAmount;
                            });

                            $('#totalAppQtyStrike').text(parseInt(totalFilteredAppQty));
                            $('#totalAppAmountStrike').text(parseInt(totalFilteredAppAmount));
                        }
                    });
                }
            }

            // Function to extract data from the table
            function getTableData() {
                var labels = [];
                var inputData = [];
                var outputData = [];
                var earnMinisData = [];
                var wipData = [];
                var ackped = [];
                var smstock = [];

                // Get table rows and extract data from each row
                $('#tableAppstrike tbody tr').each(function() {
                    var machineName = $(this).find('td').eq(1).text();
                    var input = $(this).find('td').eq(2).text();
                    var output = $(this).find('td').eq(3).text();
                    var earnMinis = $(this).find('td').eq(4).text();
                    var ackped = $(this).find('td').eq(5).text();
                    var smstock = $(this).find('td').eq(6).text();
                    var wip = $(this).find('td').eq(7).text();

                    labels.push(parseInt(machineName.replace(/,/g, ''), 10));
                    inputData.push(parseInt(input.replace(/,/g, ''), 10));
                    outputData.push(outparseInt(output.replace(/,/g, ''), 10));
                    earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
                    wipData.push(parseInt(wip.replace(/,/g, ''), 10));
                    ackpeddata.push(parseInt(ackped.replace(/,/g, ''), 10));
                    smstockdata.push(parseInt(smstock.replace(/,/g, ''), 10));
                });

                return {
                    labels: labels,
                    inputData: inputData,
                    outputData: outputData,
                    earnMinisData: earnMinisData,
                    ackpeddata: ackpeddata,
                    smstockdata: smstockdata,

                    wipData: wipData
                };
            }

            // Function to generate the bar chart
            function generateBarChart() {

                var data = getTableData();
                console.log(data); // Get the extracted table data
                var ctx = document.getElementById('barChart').getContext('2d');

                // Destroy the previous chart if it exists

                // Create a new bar chart
                window.barChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: data.labels, // Using labels from the extracted data
                        datasets: [{
                                label: 'Input Qty',
                                data: data.inputData, // Using dynamic data
                                backgroundColor: 'rgba(75, 192, 192, 0.6)', // Teal
                                borderColor: 'rgba(75, 192, 192, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Output Qty',
                                data: data.outputData, // Using dynamic data
                                backgroundColor: 'rgba(54, 162, 235, 0.6)', // Blue
                                borderColor: 'rgba(54, 162, 235, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Earned Mins',
                                data: data.earnMinisData, // Using dynamic data
                                backgroundColor: 'rgba(255, 206, 86, 0.6)', // Yellow
                                borderColor: 'rgba(255, 206, 86, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Ack Ped',
                                data: data.ackpedData, // Using dynamic data
                                backgroundColor: 'rgba(255, 99, 132, 0.6)', // Red
                                borderColor: 'rgba(255, 99, 132, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Sm Stock',
                                data: data.smstockData, // Using dynamic data
                                backgroundColor: 'rgba(101, 203, 90, 0.6)', // Light Green
                                borderColor: 'rgba(101, 203, 90, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'WIP Qty',
                                data: data.wipData, // Using dynamic data
                                backgroundColor: 'rgba(153, 102, 255, 0.6)', // Purple
                                borderColor: 'rgba(153, 102, 255, 1)',
                                borderWidth: 1
                            }
                        ]

                    },
                    options: {
                        responsive: true,
                        title: {
                            display: true,
                            text: 'Unit - Input Qty, Output Qty, Earned Mins, Ack Ped,Sm Stock,WIP Qty'
                        },
                        scales: {
                            x: {
                                stacked: false // Bars will be side by side
                            },
                            y: {
                                beginAtZero: true // Start Y-axis at 0
                            }
                        }
                    }
                });
            }
        </script>


        <script>
            //TVL Start

            function getTableDataTVL() {
                var labels = [];
                var inputData = [];
                var outputData = [];
                var earnMinisData = [];
                var wipData = [];
                var TotalQty = [];
                var month4 = [];
                var month5 = [];
                var month6 = [];

                // Get table rows and extract data from each row
                $('#tableportaltvl tbody tr').each(function(index, row) {
                    if ($(row).is(':last-child')) {
                        //$(row).remove();  // Remove the last row
                    } else {
                        var unit = $(this).find('td').eq(0).text();
                        var input = $(this).find('td').eq(1).text();
                        var output = $(this).find('td').eq(2).text();
                        var earnMinis = $(this).find('td').eq(3).text();
                        var wip = $(this).find('td').eq(4).text();
                        var m4 = $(this).find('td').eq(5).text();
                        var m5 = $(this).find('td').eq(6).text();

                        var total = $(this).find('td').eq(7).text();
                        console.log(total);

                        labels.push(unit);
                        inputData.push(parseInt(input.replace(/,/g, ''), 10));
                        outputData.push(parseInt(output.replace(/,/g, ''), 10));
                        earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
                        wipData.push(parseInt(wip.replace(/,/g, ''), 10));
                        month4.push(parseInt(m4.replace(/,/g, ''), 10));
                        month5.push(parseInt(m5.replace(/,/g, ''), 10));


                        TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
                    }
                });

                return {
                    labels: labels,
                    inputData: inputData,
                    outputData: outputData,
                    earnMinisData: earnMinisData,
                    wipData: wipData,
                    month4: month4,
                    month5: month5,

                    TotalQty: TotalQty,
                };
            }

            function populatePortalTVL(data, Key) {
                const $tableBody = $('#tableportaltvl tbody');

                const accessTypes = new Set();

                const monthsDataKey = Key;

                $tableBody.empty();
                let totalAppAmount = 0;
                let totalUnAppAmount = 0;
                let earnminis = 0;
                let wip = 0;

                let headerRow = '<thead><tr>';

                // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
                $.each(monthsDataKey, function(index, key) {
                    headerRow += `<th>${key}</th>`;
                });
                headerRow += '</tr></thead>';

                // Append the header row to the table
                $('#tableportaltvl').append(headerRow);


                $.each(data, function(index, item) {
                    var unit = monthsDataKey[0];
                    var M1 = monthsDataKey[1];
                    var M2 = monthsDataKey[2];
                    var M3 = monthsDataKey[3];
                    var M4 = monthsDataKey[4];
                    var M5 = monthsDataKey[5];
                    var M6 = monthsDataKey[6];
                    var M7 = monthsDataKey[7];


                    let appAmount = item[unit];
                    let unappAmount = item[M1];
                    let totalearn = item[M2];
                    let totalwip = item[M3];
                    const row = `
                <tr>
                    
                    <td>${item[unit]}</td>
                    <td >${formatIndianNumber1(item[M1])}</td>
                    <td >${formatIndianNumber1(item[M2])}</td>
                    <td >${formatIndianNumber1(item[M3])}</td>
                    <td >${formatIndianNumber1(item[M4])}</td>
                    <td >${formatIndianNumber1(item[M5])}</td>
                    <td >${formatIndianNumber1(item[M6])}</td>
                   
                    <td style="text-align:right;font-weight:bold">${formatIndianNumber1(item[M7])}</td>
                 
                </tr>`;
                    $tableBody.append(row);

                    totalAppAmount += parseFloat(appAmount) || 0;
                    totalUnAppAmount += parseFloat(unappAmount) || 0;
                    earnminis += parseFloat(totalearn) || 0;
                    wip += parseFloat(totalwip) || 0;

                    accessTypes.add(item.Access_Type);
                });


                var data = getTableDataTVL(); // Get the extracted table data
                var ctx = document.getElementById('barChartMOnth_portaltvl').getContext('2d');

                // Destroy the previous chart if it exists

                // Create a new bar chart
                window.barChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: data.labels, // Using labels from the extracted data
                        datasets: [{
                                label: 'Month-I',
                                data: data.inputData, // Using dynamic data
                                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                                borderColor: 'rgba(75, 192, 192, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-II',
                                data: data.outputData, // Using dynamic data
                                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                                borderColor: 'rgba(54, 162, 235, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-III',
                                data: data.earnMinisData, // Using dynamic data
                                backgroundColor: 'rgba(255, 206, 86, 0.6)',
                                borderColor: 'rgba(255, 206, 86, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-IV',
                                data: data.wipData, // Using dynamic data
                                backgroundColor: 'rgba(153, 102, 255, 0.6)',
                                borderColor: 'rgba(153, 102, 255, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-V',
                                data: data.month4, // Using dynamic data
                                backgroundColor: 'rgba(255, 159, 64, 0.6)',
                                borderColor: 'rgba(255, 159, 64, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-VI',
                                data: data.month5, // Using dynamic data
                                backgroundColor: 'rgba(75, 163, 59, 0.6)',
                                borderColor: 'rgba(75, 163, 59, 1)',
                                borderWidth: 1
                            },


                        ]

                    },
                    options: {
                        responsive: true,
                        title: {
                            display: true,
                            text: 'Last 6 Month Data'
                        },
                        scales: {
                            x: {
                                stacked: false // Bars will be side by side
                            },
                            y: {
                                beginAtZero: true // Start Y-axis at 0
                            }
                        }
                    }
                });





            }



            //TVL END

            //OWE start

            function getTableDataowe() {
                var labels = [];
                var inputData = [];
                var outputData = [];
                var earnMinisData = [];
                var wipData = [];
                var TotalQty = [];
                var month4 = [];
                var month5 = [];
                var month6 = [];

                // Get table rows and extract data from each row
                $('#tableportalowe tbody tr').each(function(index, row) {
                    if ($(row).is(':last-child')) {
                        //$(row).remove();  // Remove the last row
                    } else {
                        var unit = $(this).find('td').eq(0).text();
                        var input = $(this).find('td').eq(1).text();
                        var output = $(this).find('td').eq(2).text();
                        var earnMinis = $(this).find('td').eq(3).text();
                        var wip = $(this).find('td').eq(4).text();
                        var m4 = $(this).find('td').eq(5).text();
                        var m5 = $(this).find('td').eq(6).text();

                        var total = $(this).find('td').eq(7).text();


                        labels.push(unit);
                        inputData.push(parseInt(input.replace(/,/g, ''), 10));
                        outputData.push(parseInt(output.replace(/,/g, ''), 10));
                        earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
                        wipData.push(parseInt(wip.replace(/,/g, ''), 10));
                        month4.push(parseInt(m4.replace(/,/g, ''), 10));
                        month5.push(parseInt(m5.replace(/,/g, ''), 10));


                        TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
                    }
                });

                return {
                    labels: labels,
                    inputData: inputData,
                    outputData: outputData,
                    earnMinisData: earnMinisData,
                    wipData: wipData,
                    month4: month4,
                    month5: month5,

                    TotalQty: TotalQty,
                };
            }

            function populatePortalOWE(data, Key) {
                const $tableBody = $('#tableportalowe tbody');

                const accessTypes = new Set();

                const monthsDataKey = Key;

                $tableBody.empty();
                let totalAppAmount = 0;
                let totalUnAppAmount = 0;
                let earnminis = 0;
                let wip = 0;

                let headerRow = '<thead><tr>';

                // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
                $.each(monthsDataKey, function(index, key) {
                    headerRow += `<th>${key}</th>`;
                });
                headerRow += '</tr></thead>';

                // Append the header row to the table
                $('#tableportalowe').append(headerRow);


                $.each(data, function(index, item) {
                    var unit = monthsDataKey[0];
                    var M1 = monthsDataKey[1];
                    var M2 = monthsDataKey[2];
                    var M3 = monthsDataKey[3];
                    var M4 = monthsDataKey[4];
                    var M5 = monthsDataKey[5];
                    var M6 = monthsDataKey[6];
                    var M7 = monthsDataKey[7];


                    let appAmount = item[unit];
                    let unappAmount = item[M1];
                    let totalearn = item[M2];
                    let totalwip = item[M3];
                    const row = `
                <tr>
                    
                   <td>${item[unit]}</td>
                    <td>${parseFloat(item[M1]).toFixed(2)}</td>
                    <td>${parseFloat(item[M2]).toFixed(2)}</td>
                    <td>${parseFloat(item[M3]).toFixed(2)}</td>
                    <td>${parseFloat(item[M4]).toFixed(2)}</td>
                    <td>${parseFloat(item[M5]).toFixed(2)}</td>
                    <td>${parseFloat(item[M6]).toFixed(2)}</td>
                    <td style="text-align:right;font-weight:bold">${parseFloat(item[M7]).toFixed(2)}</td>
                 
                </tr>`;
                    $tableBody.append(row);

                    totalAppAmount += parseFloat(appAmount) || 0;
                    totalUnAppAmount += parseFloat(unappAmount) || 0;
                    earnminis += parseFloat(totalearn) || 0;
                    wip += parseFloat(totalwip) || 0;

                    accessTypes.add(item.Access_Type);
                });


                var data = getTableDataowe(); // Get the extracted table data
                var ctx = document.getElementById('barChartMOnth_portalowe').getContext('2d');

                // Destroy the previous chart if it exists

                // Create a new bar chart
                window.barChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: data.labels, // Using labels from the extracted data
                        datasets: [{
                                label: 'Month-I',
                                data: data.inputData, // Using dynamic data
                                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                                borderColor: 'rgba(75, 192, 192, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-II',
                                data: data.outputData, // Using dynamic data
                                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                                borderColor: 'rgba(54, 162, 235, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-III',
                                data: data.earnMinisData, // Using dynamic data
                                backgroundColor: 'rgba(255, 206, 86, 0.6)',
                                borderColor: 'rgba(255, 206, 86, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-IV',
                                data: data.wipData, // Using dynamic data
                                backgroundColor: 'rgba(153, 102, 255, 0.6)',
                                borderColor: 'rgba(153, 102, 255, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-V',
                                data: data.month4, // Using dynamic data
                                backgroundColor: 'rgba(255, 159, 64, 0.6)',
                                borderColor: 'rgba(255, 159, 64, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-VI',
                                data: data.month5, // Using dynamic data
                                backgroundColor: 'rgba(75, 163, 59, 0.6)',
                                borderColor: 'rgba(75, 163, 59, 1)',
                                borderWidth: 1
                            },


                        ]

                    },
                    options: {
                        responsive: true,
                        title: {
                            display: true,
                            text: 'Last 6 Month Data'
                        },
                        scales: {
                            x: {
                                stacked: false // Bars will be side by side
                            },
                            y: {
                                beginAtZero: true // Start Y-axis at 0
                            }
                        }
                    }
                });





            }
            //OWE End


            //tailor start

            function getTableDatatailor() {
                var labels = [];
                var inputData = [];
                var outputData = [];
                var earnMinisData = [];
                var wipData = [];
                var TotalQty = [];
                var month4 = [];
                var month5 = [];
                var month6 = [];

                // Get table rows and extract data from each row
                $('#tableportaltailor tbody tr').each(function(index, row) {
                    if ($(row).is(':last-child')) {
                        //$(row).remove();  // Remove the last row
                    } else {
                        var unit = $(this).find('td').eq(0).text();
                        var input = $(this).find('td').eq(1).text();
                        var output = $(this).find('td').eq(2).text();
                        var earnMinis = $(this).find('td').eq(3).text();
                        var wip = $(this).find('td').eq(4).text();
                        var m4 = $(this).find('td').eq(5).text();
                        var m5 = $(this).find('td').eq(6).text();

                        var total = $(this).find('td').eq(7).text();


                        labels.push(unit);
                        inputData.push(parseInt(input.replace(/,/g, ''), 10));
                        outputData.push(parseInt(output.replace(/,/g, ''), 10));
                        earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
                        wipData.push(parseInt(wip.replace(/,/g, ''), 10));
                        month4.push(parseInt(m4.replace(/,/g, ''), 10));
                        month5.push(parseInt(m5.replace(/,/g, ''), 10));


                        TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
                    }
                });

                return {
                    labels: labels,
                    inputData: inputData,
                    outputData: outputData,
                    earnMinisData: earnMinisData,
                    wipData: wipData,
                    month4: month4,
                    month5: month5,

                    TotalQty: TotalQty,
                };
            }

            function populatePortaltailor(data, Key) {
                const $tableBody = $('#tableportaltailor tbody');

                const accessTypes = new Set();

                const monthsDataKey = Key;

                $tableBody.empty();
                let totalAppAmount = 0;
                let totalUnAppAmount = 0;
                let earnminis = 0;
                let wip = 0;

                let headerRow = '<thead><tr>';

                // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
                $.each(monthsDataKey, function(index, key) {
                    headerRow += `<th>${key}</th>`;
                });
                headerRow += '</tr></thead>';

                // Append the header row to the table
                $('#tableportaltailor').append(headerRow);


                $.each(data, function(index, item) {
                    var unit = monthsDataKey[0];
                    var M1 = monthsDataKey[1];
                    var M2 = monthsDataKey[2];
                    var M3 = monthsDataKey[3];
                    var M4 = monthsDataKey[4];
                    var M5 = monthsDataKey[5];
                    var M6 = monthsDataKey[6];
                    var M7 = monthsDataKey[7];


                    let appAmount = item[unit];
                    let unappAmount = item[M1];
                    let totalearn = item[M2];
                    let totalwip = item[M3];
                    const row = `
                <tr>
                    
                     <td>${item[unit]}</td>
                    <td>${parseInt(item[M1])}</td>
                    <td>${parseInt(item[M2])}</td>
                    <td>${parseInt(item[M3])}</td>
                    <td>${parseInt(item[M4])}</td>
                    <td>${parseInt(item[M5])}</td>
                    <td>${parseInt(item[M6])}</td>
                    <td style="text-align:right;font-weight:bold">${parseInt(item[M7])}</td>
                 
                </tr>`;
                    $tableBody.append(row);

                    totalAppAmount += parseFloat(appAmount) || 0;
                    totalUnAppAmount += parseFloat(unappAmount) || 0;
                    earnminis += parseFloat(totalearn) || 0;
                    wip += parseFloat(totalwip) || 0;

                    accessTypes.add(item.Access_Type);
                });


                var data = getTableDatatailor(); // Get the extracted table data
                var ctx = document.getElementById('barChartMOnth_portaltailor').getContext('2d');

                // Destroy the previous chart if it exists

                // Create a new bar chart
                window.barChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: data.labels, // Using labels from the extracted data
                        datasets: [{
                                label: 'Month-I',
                                data: data.inputData, // Using dynamic data
                                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                                borderColor: 'rgba(75, 192, 192, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-II',
                                data: data.outputData, // Using dynamic data
                                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                                borderColor: 'rgba(54, 162, 235, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-III',
                                data: data.earnMinisData, // Using dynamic data
                                backgroundColor: 'rgba(255, 206, 86, 0.6)',
                                borderColor: 'rgba(255, 206, 86, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-IV',
                                data: data.wipData, // Using dynamic data
                                backgroundColor: 'rgba(153, 102, 255, 0.6)',
                                borderColor: 'rgba(153, 102, 255, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-V',
                                data: data.month4, // Using dynamic data
                                backgroundColor: 'rgba(255, 159, 64, 0.6)',
                                borderColor: 'rgba(255, 159, 64, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-VI',
                                data: data.month5, // Using dynamic data
                                backgroundColor: 'rgba(75, 163, 59, 0.6)',
                                borderColor: 'rgba(75, 163, 59, 1)',
                                borderWidth: 1
                            },


                        ]

                    },
                    options: {
                        responsive: true,
                        title: {
                            display: true,
                            text: 'Last 6 Month Data'
                        },
                        scales: {
                            x: {
                                stacked: false // Bars will be side by side
                            },
                            y: {
                                beginAtZero: true // Start Y-axis at 0
                            }
                        }
                    }
                });





            }
            //tailor End



            //cutting start

            function getTableDatacutting() {
                var labels = [];
                var inputData = [];
                var outputData = [];
                var earnMinisData = [];
                var wipData = [];
                var TotalQty = [];
                var month4 = [];
                var month5 = [];
                var month6 = [];

                // Get table rows and extract data from each row
                $('#tableportalcutting tbody tr').each(function(index, row) {
                    if ($(row).is(':last-child')) {
                        //$(row).remove();  // Remove the last row
                    } else {
                        var unit = $(this).find('td').eq(0).text();
                        var input = $(this).find('td').eq(1).text();
                        var output = $(this).find('td').eq(2).text();
                        var earnMinis = $(this).find('td').eq(3).text();
                        var wip = $(this).find('td').eq(4).text();
                        var m4 = $(this).find('td').eq(5).text();
                        var m5 = $(this).find('td').eq(6).text();

                        var total = $(this).find('td').eq(7).text();


                        labels.push(unit);
                        inputData.push(parseInt(input.replace(/,/g, ''), 10));
                        outputData.push(parseInt(output.replace(/,/g, ''), 10));
                        earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
                        wipData.push(parseInt(wip.replace(/,/g, ''), 10));
                        month4.push(parseInt(m4.replace(/,/g, ''), 10));
                        month5.push(parseInt(m5.replace(/,/g, ''), 10));


                        TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
                    }
                });

                return {
                    labels: labels,
                    inputData: inputData,
                    outputData: outputData,
                    earnMinisData: earnMinisData,
                    wipData: wipData,
                    month4: month4,
                    month5: month5,

                    TotalQty: TotalQty,
                };
            }

            function populatePortalcutting(data, Key) {
                const $tableBody = $('#tableportalcutting tbody');

                const accessTypes = new Set();

                const monthsDataKey = Key;

                $tableBody.empty();
                let totalAppAmount = 0;
                let totalUnAppAmount = 0;
                let earnminis = 0;
                let wip = 0;
                let counter = 0;

                let headerRow = '<thead><tr>';

                // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
                $.each(monthsDataKey, function(index, key) {
                    if (counter <= 7) {
                        headerRow += `<th>${key}</th>`;
                        counter++;
                    }
                });
                headerRow += '</tr></thead>';

                // Append the header row to the table
                $('#tableportalcutting').append(headerRow);


                $.each(data, function(index, item) {
                    var unit = monthsDataKey[0];
                    var M1 = monthsDataKey[1];
                    var M2 = monthsDataKey[2];
                    var M3 = monthsDataKey[3];
                    var M4 = monthsDataKey[4];
                    var M5 = monthsDataKey[5];
                    var M6 = monthsDataKey[6];
                    var M7 = monthsDataKey[7];


                    let appAmount = item[unit];
                    let unappAmount = item[M1];
                    let totalearn = item[M2];
                    let totalwip = item[M3];
                    const row = `
                <tr>
                    
                     <td>${item[unit]}</td>
                    <td>${parseInt(item[M1])}</td>
                    <td>${parseInt(item[M2])}</td>
                    <td>${parseInt(item[M3])}</td>
                    <td>${parseInt(item[M4])}</td>
                    <td>${parseInt(item[M5])}</td>
                    <td>${parseInt(item[M6])}</td>
                    <td style="text-align:right;font-weight:bold">${parseInt(item[M7])}</td>
                 
                </tr>`;
                    $tableBody.append(row);

                    totalAppAmount += parseFloat(appAmount) || 0;
                    totalUnAppAmount += parseFloat(unappAmount) || 0;
                    earnminis += parseFloat(totalearn) || 0;
                    wip += parseFloat(totalwip) || 0;

                    accessTypes.add(item.Access_Type);
                });


                var data = getTableDatacutting(); // Get the extracted table data
                var ctx = document.getElementById('barChartMOnth_portalcutting').getContext('2d');

                // Destroy the previous chart if it exists

                // Create a new bar chart
                window.barChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: data.labels, // Using labels from the extracted data
                        datasets: [{
                                label: 'Month-I',
                                data: data.inputData, // Using dynamic data
                                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                                borderColor: 'rgba(75, 192, 192, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-II',
                                data: data.outputData, // Using dynamic data
                                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                                borderColor: 'rgba(54, 162, 235, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-III',
                                data: data.earnMinisData, // Using dynamic data
                                backgroundColor: 'rgba(255, 206, 86, 0.6)',
                                borderColor: 'rgba(255, 206, 86, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-IV',
                                data: data.wipData, // Using dynamic data
                                backgroundColor: 'rgba(153, 102, 255, 0.6)',
                                borderColor: 'rgba(153, 102, 255, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-V',
                                data: data.month4, // Using dynamic data
                                backgroundColor: 'rgba(255, 159, 64, 0.6)',
                                borderColor: 'rgba(255, 159, 64, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-VI',
                                data: data.month5, // Using dynamic data
                                backgroundColor: 'rgba(75, 163, 59, 0.6)',
                                borderColor: 'rgba(75, 163, 59, 1)',
                                borderWidth: 1
                            },


                        ]

                    },
                    options: {
                        responsive: true,
                        title: {
                            display: true,
                            text: 'Last 6 Month Data'
                        },
                        scales: {
                            x: {
                                stacked: false // Bars will be side by side
                            },
                            y: {
                                beginAtZero: true // Start Y-axis at 0
                            }
                        }
                    }
                });





            }
            //OWE Cutting


            //Packing start

            function getTableDatapacking() {
                var labels = [];
                var inputData = [];
                var outputData = [];
                var earnMinisData = [];
                var wipData = [];
                var TotalQty = [];
                var month4 = [];
                var month5 = [];
                var month6 = [];

                // Get table rows and extract data from each row
                $('#tableportalpacking tbody tr').each(function(index, row) {
                    if ($(row).is(':last-child')) {
                        //$(row).remove();  // Remove the last row
                    } else {
                        var unit = $(this).find('td').eq(0).text();
                        var input = $(this).find('td').eq(1).text();
                        var output = $(this).find('td').eq(2).text();
                        var earnMinis = $(this).find('td').eq(3).text();
                        var wip = $(this).find('td').eq(4).text();
                        var m4 = $(this).find('td').eq(5).text();
                        var m5 = $(this).find('td').eq(6).text();

                        var total = $(this).find('td').eq(7).text();


                        labels.push(unit);
                        inputData.push(parseInt(input.replace(/,/g, ''), 10));
                        outputData.push(parseInt(output.replace(/,/g, ''), 10));
                        earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
                        wipData.push(parseInt(wip.replace(/,/g, ''), 10));
                        month4.push(parseInt(m4.replace(/,/g, ''), 10));
                        month5.push(parseInt(m5.replace(/,/g, ''), 10));


                        TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
                    }
                });

                return {
                    labels: labels,
                    inputData: inputData,
                    outputData: outputData,
                    earnMinisData: earnMinisData,
                    wipData: wipData,
                    month4: month4,
                    month5: month5,

                    TotalQty: TotalQty,
                };
            }

            function populatePortalpacking(data, Key) {
                const $tableBody = $('#tableportalpacking tbody');

                const accessTypes = new Set();

                const monthsDataKey = Key;

                $tableBody.empty();
                let totalAppAmount = 0;
                let totalUnAppAmount = 0;
                let earnminis = 0;
                let wip = 0;
                let counter = 0;

                let headerRow = '<thead><tr>';

                // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
                $.each(monthsDataKey, function(index, key) {
                    if (counter <= 7) {
                        headerRow += `<th>${key}</th>`;
                        counter++;
                    }
                });
                headerRow += '</tr></thead>';

                // Append the header row to the table
                $('#tableportalpacking').append(headerRow);


                $.each(data, function(index, item) {
                    var unit = monthsDataKey[0];
                    var M1 = monthsDataKey[1];
                    var M2 = monthsDataKey[2];
                    var M3 = monthsDataKey[3];
                    var M4 = monthsDataKey[4];
                    var M5 = monthsDataKey[5];
                    var M6 = monthsDataKey[6];
                    var M7 = monthsDataKey[7];


                    let appAmount = item[unit];
                    let unappAmount = item[M1];
                    let totalearn = item[M2];
                    let totalwip = item[M3];
                    const row = `
                <tr>
                    
                     <td>${item[unit]}</td>
                    <td>${parseInt(item[M1])}</td>
                    <td>${parseInt(item[M2])}</td>
                    <td>${parseInt(item[M3])}</td>
                    <td>${parseInt(item[M4])}</td>
                    <td>${parseInt(item[M5])}</td>
                    <td>${parseInt(item[M6])}</td>
                    <td style="text-align:right;font-weight:bold">${parseInt(item[M7])}</td>
                 
                </tr>`;
                    $tableBody.append(row);

                    totalAppAmount += parseFloat(appAmount) || 0;
                    totalUnAppAmount += parseFloat(unappAmount) || 0;
                    earnminis += parseFloat(totalearn) || 0;
                    wip += parseFloat(totalwip) || 0;

                    accessTypes.add(item.Access_Type);
                });


                var data = getTableDatapacking(); // Get the extracted table data
                var ctx = document.getElementById('barChartMOnth_portalpacking').getContext('2d');

                // Destroy the previous chart if it exists

                // Create a new bar chart
                window.barChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: data.labels, // Using labels from the extracted data
                        datasets: [{
                                label: 'Month-I',
                                data: data.inputData, // Using dynamic data
                                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                                borderColor: 'rgba(75, 192, 192, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-II',
                                data: data.outputData, // Using dynamic data
                                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                                borderColor: 'rgba(54, 162, 235, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-III',
                                data: data.earnMinisData, // Using dynamic data
                                backgroundColor: 'rgba(255, 206, 86, 0.6)',
                                borderColor: 'rgba(255, 206, 86, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-IV',
                                data: data.wipData, // Using dynamic data
                                backgroundColor: 'rgba(153, 102, 255, 0.6)',
                                borderColor: 'rgba(153, 102, 255, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-V',
                                data: data.month4, // Using dynamic data
                                backgroundColor: 'rgba(255, 159, 64, 0.6)',
                                borderColor: 'rgba(255, 159, 64, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-VI',
                                data: data.month5, // Using dynamic data
                                backgroundColor: 'rgba(75, 163, 59, 0.6)',
                                borderColor: 'rgba(75, 163, 59, 1)',
                                borderWidth: 1
                            },


                        ]

                    },
                    options: {
                        responsive: true,
                        title: {
                            display: true,
                            text: 'Last 6 Month Data'
                        },
                        scales: {
                            x: {
                                stacked: false // Bars will be side by side
                            },
                            y: {
                                beginAtZero: true // Start Y-axis at 0
                            }
                        }
                    }
                });





            }
            //Packing End


            //QTY Start

            function getTableDataQTY() {
                var labels = [];
                var inputData = [];
                var outputData = [];
                var earnMinisData = [];
                var wipData = [];
                var TotalQty = [];
                var month4 = [];
                var month5 = [];
                var month6 = [];

                // Get table rows and extract data from each row
                $('#tableportalqty tbody tr').each(function(index, row) {
                    if ($(row).is(':last-child')) {
                        //$(row).remove();  // Remove the last row
                    } else {
                        var unit = $(this).find('td').eq(0).text();
                        var input = $(this).find('td').eq(1).text();
                        var output = $(this).find('td').eq(2).text();
                        var earnMinis = $(this).find('td').eq(3).text();
                        var wip = $(this).find('td').eq(4).text();
                        var m4 = $(this).find('td').eq(5).text();
                        var m5 = $(this).find('td').eq(6).text();

                        var total = $(this).find('td').eq(7).text();
                        console.log(total);

                        labels.push(unit);
                        inputData.push(parseInt(input.replace(/,/g, ''), 10));
                        outputData.push(parseInt(output.replace(/,/g, ''), 10));
                        earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
                        wipData.push(parseInt(wip.replace(/,/g, ''), 10));
                        month4.push(parseInt(m4.replace(/,/g, ''), 10));
                        month5.push(parseInt(m5.replace(/,/g, ''), 10));


                        TotalQty.push(parseInt(total.replace(/,/g, ''), 10));
                    }
                });

                return {
                    labels: labels,
                    inputData: inputData,
                    outputData: outputData,
                    earnMinisData: earnMinisData,
                    wipData: wipData,
                    month4: month4,
                    month5: month5,

                    TotalQty: TotalQty,
                };
            }

            function populatePortalQTY(data, Key) {
                const $tableBody = $('#tableportalqty tbody');

                const accessTypes = new Set();

                const monthsDataKey = Key;

                $tableBody.empty();
                let totalAppAmount = 0;
                let totalUnAppAmount = 0;
                let earnminis = 0;
                let wip = 0;

                let headerRow = '<thead><tr>';

                // Loop through monthsDataKey to create headers (Unit, Month Names, etc.)
                $.each(monthsDataKey, function(index, key) {
                    headerRow += `<th>${key}</th>`;
                });
                headerRow += '</tr></thead>';

                // Append the header row to the table
                $('#tableportalqty').append(headerRow);


                $.each(data, function(index, item) {
                    var unit = monthsDataKey[0];
                    var M1 = monthsDataKey[1];
                    var M2 = monthsDataKey[2];
                    var M3 = monthsDataKey[3];
                    var M4 = monthsDataKey[4];
                    var M5 = monthsDataKey[5];
                    var M6 = monthsDataKey[6];
                    var M7 = monthsDataKey[7];


                    let appAmount = item[unit];
                    let unappAmount = item[M1];
                    let totalearn = item[M2];
                    let totalwip = item[M3];
                    const row = `
                <tr>
                    
                    <td>${item[unit]}</td>
                   <td>${parseInt(item[M1]) || 0}</td>
                    <td>${parseInt(item[M2]) || 0}</td>
                    <td>${parseInt(item[M3]) || 0}</td>
                    <td>${parseInt(item[M4]) || 0}</td>
                    <td>${parseInt(item[M5]) || 0}</td>
                    <td>${parseInt(item[M6]) || 0}</td>

                   
                    <td style="text-align:right;font-weight:bold">${parseInt(item[M7])}</td>
                 
                </tr>`;
                    $tableBody.append(row);

                    totalAppAmount += parseFloat(appAmount) || 0;
                    totalUnAppAmount += parseFloat(unappAmount) || 0;
                    earnminis += parseFloat(totalearn) || 0;
                    wip += parseFloat(totalwip) || 0;

                    accessTypes.add(item.Access_Type);
                });


                var data = getTableDataQTY(); // Get the extracted table data
                var ctx = document.getElementById('barChartMOnth_portalqty').getContext('2d');

                // Destroy the previous chart if it exists

                // Create a new bar chart
                window.barChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: data.labels, // Using labels from the extracted data
                        datasets: [{
                                label: 'Month-I',
                                data: data.inputData, // Using dynamic data
                                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                                borderColor: 'rgba(75, 192, 192, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-II',
                                data: data.outputData, // Using dynamic data
                                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                                borderColor: 'rgba(54, 162, 235, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-III',
                                data: data.earnMinisData, // Using dynamic data
                                backgroundColor: 'rgba(255, 206, 86, 0.6)',
                                borderColor: 'rgba(255, 206, 86, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-IV',
                                data: data.wipData, // Using dynamic data
                                backgroundColor: 'rgba(153, 102, 255, 0.6)',
                                borderColor: 'rgba(153, 102, 255, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-V',
                                data: data.month4, // Using dynamic data
                                backgroundColor: 'rgba(255, 159, 64, 0.6)',
                                borderColor: 'rgba(255, 159, 64, 1)',
                                borderWidth: 1
                            },
                            {
                                label: 'Month-VI',
                                data: data.month5, // Using dynamic data
                                backgroundColor: 'rgba(75, 163, 59, 0.6)',
                                borderColor: 'rgba(75, 163, 59, 1)',
                                borderWidth: 1
                            },


                        ]

                    },
                    options: {
                        responsive: true,
                        title: {
                            display: true,
                            text: 'Last 6 Month Data'
                        },
                        scales: {
                            x: {
                                stacked: false // Bars will be side by side
                            },
                            y: {
                                beginAtZero: true // Start Y-axis at 0
                            }
                        }
                    }
                });





            }



            //TVL QTY
            // Function to extract data from the table
            function getTableData() {
                var labels = [];
                var inputData = [];
                var outputData = [];
                var earnMinisData = [];
                var wipData = [];
                var ackpedData = [];
                var smstockData = [];

                // Get table rows and extract data from each row
                $('#tableAppstrike tbody tr').each(function() {
                    var machineName = $(this).find('td').eq(1).text();
                    var input = $(this).find('td').eq(2).text();
                    var output = $(this).find('td').eq(3).text();
                    var earnMinis = $(this).find('td').eq(4).text();
                    var ackped = $(this).find('td').eq(5).text();
                    var smstock = $(this).find('td').eq(6).text();
                    var wip = $(this).find('td').eq(7).text();

                    labels.push(machineName);
                    inputData.push(parseInt(input.replace(/,/g, ''), 10));
                    outputData.push(parseInt(output.replace(/,/g, ''), 10));
                    earnMinisData.push(parseInt(earnMinis.replace(/,/g, ''), 10));
                    wipData.push(parseInt(wip.replace(/,/g, ''), 10));
                    ackpedData.push(parseInt(ackped.replace(/,/g, ''), 10));
                    smstockData.push(parseInt(smstock.replace(/,/g, ''), 10));
                });

                return {
                    labels: labels,
                    inputData: inputData,
                    outputData: outputData,
                    earnMinisData: earnMinisData,
                    ackpedData: ackpedData,
                    smstockData: smstockData,
                    wipData: wipData
                };
            }

            // Prepare the chart data
            var data = getTableData();

            // Create the bar chart
            var ctx = document.getElementById('barchart').getContext('2d');
            var chart = new Chart(ctx, {
                type: 'bar', // Bar chart type
                data: {
                    labels: data.labels, // X-axis labels (machine names)
                    datasets: [{
                            label: 'Input Qty',
                            data: data.inputData,
                            backgroundColor: 'rgba(75, 192, 192, 0.6)', // Teal
                            borderColor: 'rgba(75, 192, 192, 1)',
                            borderWidth: 1
                        },
                        {
                            label: 'Output Qty',
                            data: data.outputData,
                            backgroundColor: 'rgba(54, 162, 235, 0.6)', // Blue
                            borderColor: 'rgba(54, 162, 235, 1)',
                            borderWidth: 1
                        },
                        {
                            label: 'Earned Mins',
                            data: data.earnMinisData,
                            backgroundColor: 'rgba(255, 206, 86, 0.6)', // Yellow
                            borderColor: 'rgba(255, 206, 86, 1)',
                            borderWidth: 1
                        },
                        {
                            label: 'Ack Ped',
                            data: data.ackpedData,
                            backgroundColor: 'rgba(255, 99, 132, 0.6)', // Red
                            borderColor: 'rgba(255, 99, 132, 1)',
                            borderWidth: 1
                        },
                        {
                            label: 'Sm Stock',
                            data: data.smstockData,
                            backgroundColor: 'rgba(75, 192, 75, 0.6)', // Green
                            borderColor: 'rgba(75, 192, 75, 1)',
                            borderWidth: 1
                        },
                        {
                            label: 'WIP Qty',
                            data: data.wipData,
                            backgroundColor: 'rgba(153, 102, 255, 0.6)', // Purple
                            borderColor: 'rgba(153, 102, 255, 1)',
                            borderWidth: 1
                        }
                    ]

                },
                options: {
                    responsive: true,
                    title: {
                        display: true,
                        text: 'Unit - Input Qty, Output Qty, Earned Mins,Ack Ped,Sm Stock,WIP Qty'
                    },
                    scales: {
                        x: {
                            stacked: false // Bars will be side by side
                        },
                        y: {
                            beginAtZero: true // Start Y-axis at 0
                        }
                    }
                }
            });
        </script>




        <script>
            $(function() {
                var start = moment().subtract(29, 'days');
                var end = moment();

                function cb(start, end) {
                    $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                }

                $('#reportrange').daterangepicker({
                    startDate: start,
                    endDate: end,
                    ranges: {
                        'Today': [moment(), moment()],
                        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                        'This Month': [moment().startOf('month'), moment().endOf('month')],
                        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                    }
                }, cb);

                cb(start, end);
                fetchDashboardData(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));

                $('#reportrange').on('apply.daterangepicker', function(ev, picker) {
                    var startDate = picker.startDate.format('YYYY-MM-DD');
                    var endDate = picker.endDate.format('YYYY-MM-DD');
                    console.log("Selected date range: " + startDate + " - " + endDate);

                    fetchDashboardData(startDate, endDate);
                });

                var myChart;

                function fetchDashboardData(startDate, endDate) {
                    $('.loader').show();
                    $.ajax({
                        url: "{{ route('dashboardanaly') }}",
                        method: 'GET',
                        data: {
                            start_date: startDate,
                            end_date: endDate
                        },
                        success: function(mddata) {
                            // console.log(mddata);

                            // Check if data is valid and extract merch_buyers
                            var merchBuyers = mddata.success && mddata.data ? mddata.data.merch_buyers : [];

                            if (merchBuyers.length === 0) {
                                console.log("No data found, showing default empty chart.");

                                merchBuyers = [{
                                    merch: "No Data",
                                    order_qty: 0,
                                    shipped_qty: 0

                                }];
                            }

                            var labels = [];
                            // var totalBuyers = [];
                            var totalorder_qty = [];
                            var totalshipped_qty = [];
                            // var pendingOrders = [];

                            // Use the correct merchBuyers variable
                            merchBuyers.forEach(function(item) {
                                // console.log(item); // Optional: for debugging purposes
                                labels.push(item.merch);
                                // totalBuyers.push(item.buyers);
                                totalorder_qty.push(item.order_qty);
                                totalshipped_qty.push(item.shipped_qty);
                                // pendingOrders.push(item.pending);
                            });

                            if (myChart) {
                                myChart.destroy();
                            }

                            updateChart(labels, totalorder_qty, totalshipped_qty);
                            $('.loader').hide();
                        },
                        error: function() {
                            console.log("Error fetching data.");
                        }
                    });
                }

                function updateChart(labels, totalorder_qty, totalshipped_qty) {
                    const ctx = document.getElementById('myChart').getContext('2d');
                    myChart = new Chart(ctx, {
                        type: 'bar',
                        data: {
                            labels: labels,
                            datasets: [{
                                    label: 'Shipped Qty',
                                    data: totalshipped_qty,
                                    backgroundColor: 'rgba(153, 102, 255, 0.6)', // Customize the color as needed
                                    borderColor: 'rgba(153, 102, 255, 1)',
                                    borderWidth: 1
                                },
                                {
                                    label: 'Orders Qty',
                                    data: totalorder_qty,
                                    backgroundColor: 'rgba(75, 192, 192, 0.6)', // Customize the color as needed
                                    borderColor: 'rgba(75, 192, 192, 1)',
                                    borderWidth: 1
                                }

                            ]
                        },
                        options: {
                            responsive: true,
                            scales: {
                                x: {
                                    stacked: true // Enable stacking on X-axis
                                },
                                y: {
                                    stacked: true, // Enable stacking on Y-axis
                                    beginAtZero: true,
                                    ticks: {
                                        stepSize: 5000 // Adjust this according to your data range
                                    }
                                }
                            },
                            plugins: {
                                legend: {
                                    position: 'top'
                                }
                            }
                        }
                    });
                }

            });

            function formatIndianNumber1(x) {
                return (x / 100000).toFixed(2)
                //return parts.length > 1 ? formattedNumber + '.' + parts[1] : formattedNumber;
            }

            function formatIndianNumber12(x) {
                var parts = x.toString().split(".");
                var lastThree = parts[0].slice(-3);
                var otherNumbers = parts[0].slice(0, -3);
                if (otherNumbers !== '') {
                    lastThree = ',' + lastThree;
                }
                return formattedNumber = otherNumbers.replace(/\B(?=(\d{2})+(?!\d))/g, ",") + lastThree;
                //return parts.length > 1 ? formattedNumber + '.' + parts[1] : formattedNumber;
            }
        </script>
        <script>
            $(document).ready(function() {
                var table = $('#userlogaudit').DataTable({
                    paging: false,
                    searching: false,
                    ordering: true,
                    order: [
                        [0, 'asc']
                    ],
                    // dom: 'Bfrtip',

                });

                var emp_id = $('#emp_id').val();
                //console.log(emp_id);
                // var emp_id = '5545';
                const apiUrl = `{{ route('userlogmerch_opt') }}`;

                $.ajax({
                    url: apiUrl,
                    method: 'GET',
                    data: {
                        emp_id: emp_id
                    },
                    success: function(response) {
                        console.log(response);

                        if (response.success && response.data) {
                            // Clear any existing rows in the DataTable
                            table.clear();

                            response.data.forEach(function(item, index) {
                                table.row.add([
                                    index + 1, // SNO
                                    item.employee || '-', // Name
                                    // item.EmpCode || '-',        // Emp Code (mapped as IP Address)
                                    item.LastLoginDateTime || '-', // Date
                                ]);
                            });

                            // Redraw the table with the new data
                            table.draw();
                        } else {
                            // If no data found
                            $('#userlogaudit tbody').append('<tr><td colspan="5">No data found</td></tr>');
                        }
                    },
                    error: function() {
                        console.log("Error fetching data.");
                        $('#userlogaudit tbody').append('<tr><td colspan="5">Error fetching data</td></tr>');
                    }
                });
            });
        </script>





        <script>
            $(document).ready(function() {

                $('#select_option').change(function() {
                    // Get the selected value
                    $('.production').css('display', 'none');
                    $('.production_6').css('display', 'none');
                    $('.filter_row').css('display', 'block');

                    var selectedoption = $(this).val();
                    $('.' + selectedoption).show();
                    $('html, body').animate({
                        scrollTop: $("div." + selectedoption).offset().top
                    }, 1000)


                    var selectedValue = $('#monthYearPicker').val();
                    var parts = selectedValue.split('/');
                    var month = parts[0];
                    var year = parts[1];

                    if (selectedoption == 'Tvl') {
                        $('.month_heder').text(month + ' Month (Sewing) Turnover Value Details');
                        updateChart(month, year);

                    } else if (selectedoption == 'Tminis') {
                        $('.month_heder').text(month + ' Month (Sewing) Earned Mins Details');
                        updateChartTminis(month, year);

                    } else if (selectedoption == 'Tqty') {
                        $('.month_heder').text(month + ' Months(Sewing) Production Qty Details');
                        updateChartTqty(month, year);
                    } else if (selectedoption == 'Total_OWE') {
                        $('.month_heder').text(month + ' Month OWE Details');
                        $('.filterheading').css('display', 'none');
                        updateChartowe(month, year);
                    } else if (selectedoption == 'Tailor') {
                        $('.month_heder').text(month + ' Month  Tailors Details');
                        $('.filterheading').css('display', 'none');
                        updateChartTailor(month, year);
                    } else if (selectedoption == 'cutting_status') {
                        $('.month_heder').text(month + ' Month  Cutting Details');
                        $('.filterheading').css('display', 'none');
                        updateChartCutting(month, year);
                    } else if (selectedoption == 'packing') {
                        $('.month_heder').text(month + ' Month  Packing Details');
                        $('.filterheading').css('display', 'none');
                        updateChartPacking(month, year);
                    }

                    // Display the selected value in the result div
                    $('#result').text("Selected Value: " + selectedoption);
                });
                var chartInstance = null;
                let abstractTable = null;

                function formatCompactNumber(value) {
                    var selectedoption = $('#select_option').val();
                    console.log(selectedoption);
                    if (selectedoption == 'Tqty') {
                        return (value);
                    } else {
                        return (value / 100000).toFixed(2);
                    }

                }

                // Store the chart instance

                // Function to fetch data and update the chart
                function updateChart(monthName, year) {
                    // Convert month name (e.g., 'Jan') into month number (1-12)
                    var monthNumber = getMonthNumber(monthName);
                    $("#preloder").fadeIn();


                    $.ajax({
                        url: "{{ route('operationreport') }}",
                        data: {
                            'year': year,
                            'month': monthName
                        },
                        method: 'GET',
                        success: function(response) {
                            $("#preloder").fadeOut();
                            if (response.success) {

                                var tableData = response.data;
                                populateAbstractTable(tableData, monthNumber);



                                // Filter data for chart (excluding 'Total' units)
                                const filteredData = tableData.filter(unitData => unitData.Unit !== "Total");

                                // Prepare the chart data dynamically
                                const labels = Object.keys(filteredData[0]).filter(key => key !== "Unit" && key !== "Total"); // Extract dates from the first unit's keys

                                const datasets = filteredData.map(unitData => ({
                                    label: unitData.Unit,
                                    data: labels.map(date => parseInt(unitData[date], 10)),
                                    borderColor: getRandomColor(), // You can customize the color for each line
                                    backgroundColor: 'rgba(0, 0, 0, 0)', // Transparent background
                                    fill: false,
                                    lineTension: 0.1
                                }));

                                // Destroy the existing chart instance if it exists
                                if (chartInstance) {
                                    chartInstance.destroy(); // Destroy the previous chart instance
                                }

                                // Create a new chart
                                const ctx = document.getElementById('multipleLineChart').getContext('2d');
                                chartInstance = new Chart(ctx, {
                                    type: 'line',
                                    data: {
                                        labels: labels,
                                        datasets: datasets
                                    },
                                    options: {
                                        responsive: true,
                                        plugins: {
                                            legend: {
                                                position: 'top',
                                            },
                                            tooltip: {
                                                callbacks: {
                                                    label: function(tooltipItem) {
                                                        return 'Turn Over: ' + tooltipItem.raw.toLocaleString();
                                                    }
                                                }
                                            }
                                        },
                                        scales: {
                                            x: {
                                                title: {
                                                    display: true,
                                                    text: 'Date'
                                                }
                                            },
                                            y: {
                                                title: {
                                                    display: true,
                                                    text: 'Turn Over'
                                                },
                                                ticks: {
                                                    callback: function(value) {
                                                        return value.toLocaleString();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                });

                            } else {
                                console.error("API returned success false.");
                            }
                        },
                        error: function() {
                            console.log("Error fetching data.");
                        }
                    });
                }

                function updateChartTminis(monthName, year) {
                    // Convert month name (e.g., 'Jan') into month number (1-12)
                    var monthNumber = getMonthNumber(monthName);
                    $("#preloder").fadeIn();

                    $.ajax({
                        url: "{{ route('operationreporttmins') }}",
                        data: {
                            'year': year,
                            'month': monthName
                        },
                        method: 'GET',
                        success: function(response) {
                            $("#preloder").fadeOut();
                            if (response.success) {

                                var tableData = response.data;
                                populateAbstractTable(tableData, monthNumber);



                                // Filter data for chart (excluding 'Total' units)
                                const filteredData = tableData.filter(unitData => unitData.Unit !== "Total");

                                // Prepare the chart data dynamically
                                const labels = Object.keys(filteredData[0]).filter(key => key !== "Unit" && key !== "Total"); // Extract dates from the first unit's keys

                                const datasets = filteredData.map(unitData => ({
                                    label: unitData.Unit,
                                    data: labels.map(date => parseInt(unitData[date], 10)),
                                    borderColor: getRandomColor(), // You can customize the color for each line
                                    backgroundColor: 'rgba(0, 0, 0, 0)', // Transparent background
                                    fill: false,
                                    lineTension: 0.1
                                }));

                                // Destroy the existing chart instance if it exists
                                if (chartInstance) {
                                    chartInstance.destroy(); // Destroy the previous chart instance
                                }

                                // Create a new chart
                                const ctx = document.getElementById('multipleLineChart').getContext('2d');
                                chartInstance = new Chart(ctx, {
                                    type: 'line',
                                    data: {
                                        labels: labels,
                                        datasets: datasets
                                    },
                                    options: {
                                        responsive: true,
                                        plugins: {
                                            legend: {
                                                position: 'top',
                                            },
                                            tooltip: {
                                                callbacks: {
                                                    label: function(tooltipItem) {
                                                        return 'Earned Mins: ' + tooltipItem.raw.toLocaleString();
                                                    }
                                                }
                                            }
                                        },
                                        scales: {
                                            x: {
                                                title: {
                                                    display: true,
                                                    text: 'Date'
                                                }
                                            },
                                            y: {
                                                title: {
                                                    display: true,
                                                    text: 'Earned Mins'
                                                },
                                                ticks: {
                                                    callback: function(value) {
                                                        return value.toLocaleString();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                });

                            } else {
                                console.error("API returned success false.");
                            }
                        },
                        error: function() {
                            console.log("Error fetching data.");
                        }
                    });
                }

                function updateChartTqty(monthName, year) {
                    // Convert month name (e.g., 'Jan') into month number (1-12)
                    var monthNumber = getMonthNumber(monthName);
                    $("#preloder").fadeIn();

                    $.ajax({
                        url: "{{ route('operationreportqty') }}",
                        data: {
                            'year': year,
                            'month': monthName
                        },
                        method: 'GET',
                        success: function(response) {
                            $("#preloder").fadeOut();
                            if (response.success) {

                                var tableData = response.data;
                                populateAbstractTable(tableData, monthNumber);



                                // Filter data for chart (excluding 'Total' units)
                                const filteredData = tableData.filter(unitData => unitData.Unit !== "Total");

                                // Prepare the chart data dynamically
                                const labels = Object.keys(filteredData[0]).filter(key => key !== "Unit" && key !== "Total"); // Extract dates from the first unit's keys

                                const datasets = filteredData.map(unitData => ({
                                    label: unitData.Unit,
                                    data: labels.map(date => parseInt(unitData[date], 10)),
                                    borderColor: getRandomColor(), // You can customize the color for each line
                                    backgroundColor: 'rgba(0, 0, 0, 0)', // Transparent background
                                    fill: false,
                                    lineTension: 0.1
                                }));

                                // Destroy the existing chart instance if it exists
                                if (chartInstance) {
                                    chartInstance.destroy(); // Destroy the previous chart instance
                                }

                                // Create a new chart
                                const ctx = document.getElementById('multipleLineChart').getContext('2d');
                                chartInstance = new Chart(ctx, {
                                    type: 'line',
                                    data: {
                                        labels: labels,
                                        datasets: datasets
                                    },
                                    options: {
                                        responsive: true,
                                        plugins: {
                                            legend: {
                                                position: 'top',
                                            },
                                            tooltip: {
                                                callbacks: {
                                                    label: function(tooltipItem) {
                                                        return 'Production Qty: ' + tooltipItem.raw.toLocaleString();
                                                    }
                                                }
                                            }
                                        },
                                        scales: {
                                            x: {
                                                title: {
                                                    display: true,
                                                    text: 'Date'
                                                }
                                            },
                                            y: {
                                                title: {
                                                    display: true,
                                                    text: 'Production Qty'
                                                },
                                                ticks: {
                                                    callback: function(value) {
                                                        return value.toLocaleString();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                });

                            } else {
                                console.error("API returned success false.");
                            }
                        },
                        error: function() {
                            console.log("Error fetching data.");
                        }
                    });
                }

                function updateChartowe(monthName, year) {
                    // Convert month name (e.g., 'Jan') into month number (1-12)
                    var monthNumber = getMonthNumber(monthName);
                    var status = $('#tableportalowe').find('td').text().trim();
                    $("#preloder").fadeIn();
                    console.log(status);

                    $.ajax({
                        url: "{{ route('operationreportowe') }}",
                        data: {
                            'year': year,
                            'month': monthName,
                            'type': 'Total_OWE'
                        },
                        method: 'GET',
                        success: function(response) {
                            $("#preloder").fadeOut();
                            if (response.success) {

                                var tableData = response.data.monthdata;

                                var tablesixData = response.data.sixdata;
                                var keydata = response.data.sixkey;
                                populateWorksTable(tableData, monthNumber);
                                if (status == '') {
                                    populatePortalOWE(tablesixData, keydata);
                                } else {
                                    // $('.Total_OWE').css('display', 'block');

                                    // console.log('ALL ready load function');
                                }




                                // Filter data for chart (excluding 'Total' units)
                                const filteredData = tableData.filter(unitData => unitData.Unit !== "Total");

                                // Prepare the chart data dynamically
                                const labels = Object.keys(filteredData[0]).filter(key => key !== "Unit" && key !== "Total"); // Extract dates from the first unit's keys

                                const datasets = filteredData.map(unitData => ({
                                    label: unitData.Unit,
                                    data: labels.map(date => parseInt(unitData[date], 10)),
                                    borderColor: getRandomColor(), // You can customize the color for each line
                                    backgroundColor: 'rgba(0, 0, 0, 0)', // Transparent background
                                    fill: false,
                                    lineTension: 0.1
                                }));

                                // Destroy the existing chart instance if it exists
                                if (chartInstance) {
                                    chartInstance.destroy(); // Destroy the previous chart instance
                                }



                                // Create a new chart
                                const ctx = document.getElementById('multipleLineChart').getContext('2d');
                                chartInstance = new Chart(ctx, {
                                    type: 'line',
                                    data: {
                                        labels: labels,
                                        datasets: datasets
                                    },
                                    options: {
                                        responsive: true,
                                        plugins: {
                                            legend: {
                                                position: 'top',
                                            },
                                            tooltip: {
                                                callbacks: {
                                                    label: function(tooltipItem) {
                                                        return 'Total_OWE: ' + tooltipItem.raw.toLocaleString();
                                                    }
                                                }
                                            }
                                        },
                                        scales: {
                                            x: {
                                                title: {
                                                    display: true,
                                                    text: 'Date'
                                                }
                                            },
                                            y: {
                                                title: {
                                                    display: true,
                                                    text: 'Total_OWE'
                                                },
                                                ticks: {
                                                    callback: function(value) {
                                                        return value.toLocaleString();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                });

                            } else {
                                console.error("API returned success false.");
                            }
                        },
                        error: function() {
                            console.log("Error fetching data.");
                        }
                    });
                }

                function updateChartTailor(monthName, year) {
                    // Convert month name (e.g., 'Jan') into month number (1-12)
                    var monthNumber = getMonthNumber(monthName);
                    $("#preloder").fadeIn();
                    var status = $('#tableportaltailor').find('td').text().trim();

                    $.ajax({
                        url: "{{ route('operationreportowe') }}",
                        data: {
                            'year': year,
                            'month': monthName,
                            'type': 'Tailor'
                        },
                        method: 'GET',
                        success: function(response) {
                            $("#preloder").fadeOut();
                            if (response.success) {

                                var tableData = response.data.monthdata;
                                var tablesixData = response.data.sixdata;
                                var keydata = response.data.sixkey;
                                populateWorksTable(tableData, monthNumber);
                                if (status == '') {
                                    populatePortaltailor(tablesixData, keydata);
                                } else {
                                    //$('.Tailore').css('display', 'block');
                                    // console.log('ALL ready load function');
                                }





                                // Filter data for chart (excluding 'Total' units)
                                const filteredData = tableData.filter(unitData => unitData.Unit !== "Total");

                                // Prepare the chart data dynamically
                                const labels = Object.keys(filteredData[0]).filter(key => key !== "Unit" && key !== "Total"); // Extract dates from the first unit's keys

                                const datasets = filteredData.map(unitData => ({
                                    label: unitData.Unit,
                                    data: labels.map(date => parseInt(unitData[date], 10)),
                                    borderColor: getRandomColor(), // You can customize the color for each line
                                    backgroundColor: 'rgba(0, 0, 0, 0)', // Transparent background
                                    fill: false,
                                    lineTension: 0.1
                                }));

                                // Destroy the existing chart instance if it exists
                                if (chartInstance) {
                                    chartInstance.destroy(); // Destroy the previous chart instance
                                }

                                // Create a new chart
                                const ctx = document.getElementById('multipleLineChart').getContext('2d');
                                chartInstance = new Chart(ctx, {
                                    type: 'line',
                                    data: {
                                        labels: labels,
                                        datasets: datasets
                                    },
                                    options: {
                                        responsive: true,
                                        plugins: {
                                            legend: {
                                                position: 'top',
                                            },
                                            tooltip: {
                                                callbacks: {
                                                    label: function(tooltipItem) {
                                                        return 'Tailor: ' + tooltipItem.raw.toLocaleString();
                                                    }
                                                }
                                            }
                                        },
                                        scales: {
                                            x: {
                                                title: {
                                                    display: true,
                                                    text: 'Date'
                                                }
                                            },
                                            y: {
                                                title: {
                                                    display: true,
                                                    text: 'Tailor'
                                                },
                                                ticks: {
                                                    callback: function(value) {
                                                        return value.toLocaleString();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                });

                            } else {
                                console.error("API returned success false.");
                            }
                        },
                        error: function() {
                            console.log("Error fetching data.");
                        }
                    });
                }


                function updateChartCutting(monthName, year) {
                    // Convert month name (e.g., 'Jan') into month number (1-12)
                    var monthNumber = getMonthNumber(monthName);
                    $("#preloder").fadeIn();
                    var status = $('#tableportalcutting').find('td').text().trim();
                    //Cutting RAJ

                    $.ajax({
                        url: "{{ route('operationcutting') }}",
                        data: {
                            'year': year,
                            'month': monthName
                        },
                        method: 'GET',
                        success: function(response) {
                            $("#preloder").fadeOut();
                            if (response.success) {

                                var tableData = response.data.monthdata;
                                var tablesixData = response.data.sixdata;
                                var keydata = response.data.sixkey;
                                populateWorksTable(tableData, monthNumber);
                                if (status == '') {
                                    populatePortalcutting(tablesixData, keydata);
                                } else {
                                    //$('.Tailore').css('display', 'block');
                                    // console.log('ALL ready load function');
                                }





                                // Filter data for chart (excluding 'Total' units)
                                const filteredData = tableData.filter(unitData => unitData.Buyer !== "Total");



                                // Prepare the chart data dynamically RAJ
                                const labels = Object.keys(filteredData[0]).filter(key => key !== "Buyer" && key !== "Total" && key !== 'Slno'); // Extract dates from the first unit's keys

                                const datasets = filteredData.map(unitData => ({
                                    label: unitData.Buyer,
                                    data: labels.map(date => parseInt(unitData[date], 10)),
                                    borderColor: getRandomColor(), // You can customize the color for each line
                                    backgroundColor: 'rgba(0, 0, 0, 0)', // Transparent background
                                    fill: false,
                                    lineTension: 0.1
                                }));

                                // Destroy the existing chart instance if it exists
                                if (chartInstance) {
                                    chartInstance.destroy(); // Destroy the previous chart instance
                                }

                                // Create a new chart
                                const ctx = document.getElementById('multipleLineChart').getContext('2d');
                                chartInstance = new Chart(ctx, {
                                    type: 'line',
                                    data: {
                                        labels: labels,
                                        datasets: datasets
                                    },
                                    options: {
                                        responsive: true,
                                        plugins: {
                                            legend: {
                                                position: 'top',
                                            },
                                            tooltip: {
                                                callbacks: {
                                                    label: function(tooltipItem) {
                                                        return 'Cutting: ' + tooltipItem.raw.toLocaleString();
                                                    }
                                                }
                                            }
                                        },
                                        scales: {
                                            x: {
                                                title: {
                                                    display: true,
                                                    text: 'Date'
                                                }
                                            },
                                            y: {
                                                title: {
                                                    display: true,
                                                    text: 'Cutting'
                                                },
                                                ticks: {
                                                    callback: function(value) {
                                                        return value.toLocaleString();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                });

                            } else {
                                console.error("API returned success false.");
                            }
                        },
                        error: function() {
                            console.log("Error fetching data.");
                        }
                    });
                }

                function updateChartPacking(monthName, year) {
                    // Convert month name (e.g., 'Jan') into month number (1-12)
                    var monthNumber = getMonthNumber(monthName);
                    $("#preloder").fadeIn();
                    var status = $('#tableportalpacking').find('td').text().trim();
                    //Cutting RAJ

                    $.ajax({
                        url: "{{ route('operationpacking') }}",
                        data: {
                            'year': year,
                            'month': monthName
                        },
                        method: 'GET',
                        success: function(response) {
                            $("#preloder").fadeOut();
                            if (response.success) {

                                var tableData = response.data.monthdata;
                                var tablesixData = response.data.sixdata;
                                var keydata = response.data.sixkey;
                                populateWorksTable(tableData, monthNumber);
                                if (status == '') {
                                    populatePortalpacking(tablesixData, keydata);
                                } else {
                                    //$('.Tailore').css('display', 'block');
                                    // console.log('ALL ready load function');
                                }





                                // Filter data for chart (excluding 'Total' units)
                                const filteredData = tableData.filter(unitData => unitData.Buyer !== "Total");

                                // Prepare the chart data dynamically RAJ
                                const labels = Object.keys(filteredData[0]).filter(key => key !== "Buyer" && key !== "Total" && key !== 'Slno'); // Extract dates from the first unit's keys

                                const datasets = filteredData.map(unitData => ({
                                    label: unitData.Buyer,
                                    data: labels.map(date => parseInt(unitData[date], 10)),
                                    borderColor: getRandomColor(), // You can customize the color for each line
                                    backgroundColor: 'rgba(0, 0, 0, 0)', // Transparent background
                                    fill: false,
                                    lineTension: 0.1
                                }));

                                // Destroy the existing chart instance if it exists
                                if (chartInstance) {
                                    chartInstance.destroy(); // Destroy the previous chart instance
                                }

                                // Create a new chart
                                const ctx = document.getElementById('multipleLineChart').getContext('2d');
                                chartInstance = new Chart(ctx, {
                                    type: 'line',
                                    data: {
                                        labels: labels,
                                        datasets: datasets
                                    },
                                    options: {
                                        responsive: true,
                                        plugins: {
                                            legend: {
                                                position: 'top',
                                            },
                                            tooltip: {
                                                callbacks: {
                                                    label: function(tooltipItem) {
                                                        return 'Packing: ' + tooltipItem.raw.toLocaleString();
                                                    }
                                                }
                                            }
                                        },
                                        scales: {
                                            x: {
                                                title: {
                                                    display: true,
                                                    text: 'Date'
                                                }
                                            },
                                            y: {
                                                title: {
                                                    display: true,
                                                    text: 'Packing'
                                                },
                                                ticks: {
                                                    callback: function(value) {
                                                        return value.toLocaleString();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                });

                            } else {
                                console.error("API returned success false.");
                            }
                        },
                        error: function() {
                            console.log("Error fetching data.");
                        }
                    });
                }



                var selectedValue = $('#monthYearPicker').val();
                var parts = selectedValue.split('/');
                var month = parts[0];
                var year = parts[1];
                //updateChart(month, year); 


                $('#monthYearPicker').on('change', function() {
                    var selectedValue = $(this).val();
                    var parts = selectedValue.split('/');
                    var month = parts[0];
                    var year = parts[1];
                    console.log(selectedValue);
                    var selectedoption = $('#select_option').val();
                    if (selectedoption == 'Tvl') {
                        updateChart(month, year);
                        $('.month_heder').text(month + ' Month (Sewing) Turnover Value Details');

                    } else if (selectedoption == 'Tminis') {
                        $('.month_heder').text(month + ' Month (Sewing) Earned Mins Details');
                        updateChartTminis(month, year);

                    } else if (selectedoption == 'Tqty') {
                        $('.month_heder').text(month + ' Month (Sewing) Production Qty Details');
                        updateChartTqty(month, year);
                    } else if (selectedoption == 'Total_OWE') {
                        $('.month_heder').text(month + ' Month OWE Details');
                        $('.filterheading').css('display', 'none');
                        updateChartowe(month, year);
                    } else if (selectedoption == 'Tailor') {
                        $('.month_heder').text(month + ' Month  Tailors Details');
                        $('.filterheading').css('display', 'none');
                        updateChartTailor(month, year);
                    } else if (selectedoption == 'cutting_status') {
                        $('.month_heder').text(month + ' Month  Cutting Details');
                        $('.filterheading').css('display', 'none');
                        updateChartCutting(month, year);
                    } else if (selectedoption == 'packing') {
                        $('.month_heder').text(month + ' Month  Packing Details');
                        $('.filterheading').css('display', 'none');
                        updateChartPacking(month, year);
                    }


                    //updateChart(monthName, year);
                });


                function getMonthNumber(monthName) {
                    var monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                    return monthNames.indexOf(monthName) + 1;
                }


                function getRandomColor() {
                    const colors = ['#FF5733', '#33FF57', '#3357FF', '#F9A825', '#FF33A1', '#8E24AA'];


                    return colors;
                }

                // Function to populate Abstract Table
                function populateAbstractTable(data, orderNo) {
                    const $tableBody = $('#abstractTable tbody');
                    $tableBody.empty();

                    if (!data || data.length === 0) {
                        console.log("No data available to populate.");
                        return;
                    }

                    var headers = Object.keys(data[0]);

                    // Dynamically create table headers
                    var thead = '<tr>';
                    headers.forEach(function(header) {
                        var dateFormatRegex = /^\d{4}_(0[1-9]|1[0-2])_(0[1-9]|[12][0-9]|3[01])$/;
                        if (dateFormatRegex.test(header)) {
                            var parts = header.split('_');
                            var month = parts[0];
                            var year = parts[1];
                            var day = parts[2];
                            var headercol = day;

                        } else {
                            var headercol = header;
                        }

                        thead += '<th>' + headercol + '</th>';
                    });
                    thead += '</tr>';
                    $('#abstractTable thead').html(thead); // Insert headers into table

                    // Dynamically create table rows
                    var tbody = '';
                    data.forEach(function(row) {
                        tbody += '<tr>';
                        headers.forEach(function(header) {
                            if ($.isNumeric(row[header])) {

                                var tdata = formatCompactNumber(row[header]);
                            } else {
                                var tdata = row[header];
                            }
                            if(header=='Unit' || row['Unit']=='Total'){
                                tbody += '<td data-unit="'+row['Unit']+'" data-dateno="'+header+'">' + tdata + '</td>';
                            }else{
                                tbody += '<td class="prodlink" onclick="datewiseproduction(this);" data-unit="'+row['Unit']+'" data-dateno="'+header+'">' + tdata + '</td>';
                            }
                        });
                        tbody += '</tr>';
                    });
                    $('#abstractTable tbody').html(tbody); // Insert rows into abstract table


                }

                function populateWorksTable(data, orderNo) {
                    const $tableBody = $('#abstractTable tbody');
                    $tableBody.empty();

                    if (!data || data.length === 0) {
                        console.log("No data available to populate.");
                        return;
                    }

                    var headers = Object.keys(data[0]);

                    // Dynamically create table headers
                    var thead = '<tr>';
                    headers.forEach(function(header, index) {
                        var dateFormatRegex = /^\d{4}_(0[1-9]|1[0-2])_(0[1-9]|[12][0-9]|3[01])$/;
                        if (index !== headers.length - 1) {
                            if (dateFormatRegex.test(header)) {
                                var parts = header.split('_');
                                var month = parts[0];
                                var year = parts[1];
                                var day = parts[2];
                                var headercol = day;

                            } else {
                                var headercol = header;
                            }

                            thead += '<th>' + headercol + '</th>';
                        }
                    });
                    thead += '</tr>';
                    $('#abstractTable thead').html(thead); // Insert headers into table

                    // Dynamically create table rows
                    var tbody = '';
                    data.forEach(function(row) {
                        tbody += '<tr>';
                        headers.forEach(function(header, index) {
                            // Check if it's the last column and skip adding it
                            if (index !== headers.length - 1) {
                                tbody += '<td class="prodlink" onclick="datewiseproduction(this);" data-unit="'+row['Unit']+'" data-dateno="'+header+'">' + row[header] + '</td>';

                            }
                        });
                        tbody += '</tr>';
                    });
                    $('#abstractTable tbody').html(tbody); // Insert rows into abstract table


                }
            });




            $(document).ready(function() {



                // Export chart as PNG
                $('#load-data').click(function() {
                    $('.load_turnover').css('display', 'block');
                });


            });

            function datewiseproduction(val) {
    let Unit = $(val).data("unit");
    let optdate = $(val).data("dateno");
    let optname = $('#select_option').val();
    let selectedText = $('#select_option option:selected').text();

    $.ajax({
        url: "{{ route('datewiseproduction') }}",
        method: 'GET',
        data: { optdate: optdate, Unit: Unit, optname: optname },
        success: function (response) {
            //console.log(response);
            // Destroy old DataTable if it exists
            if ($.fn.DataTable.isDataTable('#productionTable')) {
                $('#productionTable').DataTable().clear().destroy();
            }

            if ((!response.data) || (response.data.length === 0)) {
                alert("No data found");
                return;
            }

            // If modal doesn't exist, append it
            if ($('#productionModal').length === 0) {
                $('body').append(`
                    <div class="modal fade" id="productionModal" tabindex="-1">
                        <div class="modal-dialog modal-xl">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="productionModalLabel"></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    <table id="productionTable" class="table table-bordered table-striped" style="width:100%">
                                        <thead></thead>
                                        <tbody></tbody>
                                        <tfoot></tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                `);
            }
            if (optdate) {
                let parts = optdate.split('_');
                formatdate = `${parts[2]}-${parts[1]}-${parts[0]}`; // dd/mm/yyyy
            }
            
            $('#productionModalLabel').text(`${selectedText} Datewise Production : ${formatdate}`+' | '+response.data[0].Unit);

            // Extract columns
            const columns = Object.keys(response.data[0]).filter(col => col !== 'Unit');

            // Build table header
            let theadHtml = '<tr>';
            columns.forEach(col => {
                theadHtml += `<th>${col}</th>`;
            });
            theadHtml += '</tr>';
            $('#productionTable thead').html(theadHtml);

            // Build table body
            let tbodyHtml = '';
            response.data.forEach(row => {
                tbodyHtml += '<tr>';
                columns.forEach((col, index) => {
                    // Apply 'sideallign' class to columns 4, 5, 6, 7 (index 3, 4, 5, 6)
                    let className = (index > 3) ? 'sideallign' : ''; 
                    tbodyHtml += `<td class="${className}">${row[col]}</td>`;
                });
                tbodyHtml += '</tr>';
            });
            $('#productionTable tbody').html(tbodyHtml);

            // Build table footer
            let tfootHtml = '<tr>';
            columns.forEach((col, index) => {
                if (index === 0) {
                    tfootHtml += `<td class="sideallign fw-bold">Total:</td>`;  
                } else {
                    tfootHtml += `<td class="sideallign fw-bold"></td>`; 
                }
            });
            tfootHtml += '</tr>';
            $('#productionTable tfoot').html(tfootHtml);

            // Initialize DataTable
            const dt = $('#productionTable').DataTable({
                responsive: true,
                autoWidth: false,
                paging: false,
                footerCallback: function (row, data, start, end, display) {
                    let api = this.api();
                    let floatVal = (i) => {
                        if (typeof i === 'string') {
                            const text = $('<div>').html(i).text(); // safely strip out tags like <span>
                            return parseFloat(text.replace(/,/g, '')) || 0;
                        }
                        return typeof i === 'number' ? i : 0;
                    };

                    var columnsToSum = [4, 5, 6, 7]; 

                    columnsToSum.forEach(function (colIndex) {
                        var total = api
                            .column(colIndex, { page: 'current' }) // Sum only visible data
                            .data()
                            .reduce((a, b) => floatVal(a) + floatVal(b), 0);

                        // Update footer with total
                        $(api.column(colIndex).footer()).html(total);
                        // var totalInLakhs = (total / 100000).toFixed(2);
                        // $(api.column(colIndex).footer()).html(totalInLakhs);
                    });
                
                }
            });

            // Show the modal
            const modalEl = document.getElementById('productionModal');
            const modal = new bootstrap.Modal(modalEl);
            modal.show();

            // Redraw table after modal shown
            $(modalEl).off('shown.bs.modal').on('shown.bs.modal', function () {
                dt.columns.adjust().draw();
            });
        },
        error: function (xhr, status, error) {
            console.error("AJAX Error:", error);
            alert("Error loading data.");
        }
    });
}


        </script>






        @endsection





       