<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>PAYSLIP</title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="gplogofinal.png" type="png">


    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>


    <!-- Fonts and icons -->
    <script src="{{ asset('frontend/js/plugin/webfont/webfont.min.js')}}"></script>
    <script>
        WebFont.load({
            google: {
                "families": ["Lato:300,400,700,900"]
            },
            //custom: {"families":["Flaticon", "Font Awesome 5 Solid", "Font Awesome 5 Regular", "Font Awesome 5 Brands", "simple-line-icons"], urls: ['assets/css/fonts.min.css']},
            active: function() {
                sessionStorage.fonts = true;
            }
        });
    </script>
    <!-- CSS Files -->
    <link rel="stylesheet" href="{{ asset('frontend/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{ asset('frontend/css/atlantis.css')}}">
    <style>
        .vl {
            border-left: 6px solid green;
            height: 500px;
        }

        .containers:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            background-image: url(gain1.png);
            background-size: 500px;
            background-position: center;
            background-repeat: no-repeat;
            width: 100%;
            height: 100%;
            opacity: .2;
            z-index: 2;
        }

        .label-right {
            text-align: right;
            float: right;
        }

        /* for box */

        .box-model {
            background-color: white;
            width: 90%;
            border: 1px solid black;
            padding: 10px;
            margin: 10px;
        }

        .dotted-table {
            border: 2px dotted;
        }
    </style>

    <style>
        .highlight-button {
            display: inline-block;
            padding: 5px 20px 9px;
            font-size: 15px;
            color: black;
            border: 1px solid black;
        }

        .highlight-button:hover {
            background-color: #405189;
            color: white;
        }

        @media (max-width: 600px) {
            .btn-large i {
                font-size: 20px;
            }

            .btn-large {
                font-size: 14px;
                margin-left: 5px !important;

            }

            .highlight-button {
                padding: 3px 12px 7px;
                font-size: 12px;
            }
        }

        @media (max-width: 576px) {
            .page-title h4 {
                font-size: 14px;
                align-items: center;
                justify-content: space-between;
                margin-top: 10px;
            }
        }
    </style>

    <style>
        :root,
        [data-bs-theme=light] {
            --vz-blue: #3577f1;
            --vz-indigo: #405189;
            --vz-purple: #6559cc;
            --vz-pink: #f672a7;
            --vz-red: #f06548;
            --vz-orange: #f1963b;
            --vz-yellow: #f7b84b;
            --vz-green: #0ab39c;
            --vz-teal: #02a8b5;
            --vz-cyan: #299cdb;
            --vz-white: #fff;
            --vz-gray: #878a99;
            --vz-gray-dark: #343a40;
            --vz-gray-100: #f3f6f9;
            --vz-gray-200: #eff2f7;
            --vz-gray-300: #e9ebec;
            --vz-gray-400: #ced4da;
            --vz-gray-500: #adb5bd;
            --vz-gray-600: #878a99;
            --vz-gray-700: #495057;
            --vz-gray-800: #343a40;
            --vz-gray-900: #212529;
            --vz-primary: #405189;
            --vz-secondary: #3577f1;
            --vz-success: #0ab39c;
            --vz-info: #299cdb;
            --vz-warning: #f7b84b;
            --vz-danger: #f06548;
            --vz-light: #f3f6f9;
            --vz-dark: #212529;
            --vz-primary-rgb: 64, 81, 137;
            --vz-secondary-rgb: 53, 119, 241;
            --vz-success-rgb: 10, 179, 156;
            --vz-info-rgb: 41, 156, 219;
            --vz-warning-rgb: 247, 184, 75;
            --vz-danger-rgb: 240, 101, 72;
            --vz-light-rgb: 243, 246, 249;
            --vz-dark-rgb: 33, 37, 41;
            --vz-primary-text-emphasis: #364574;
            --vz-secondary-text-emphasis: #2d65cd;
            --vz-success-text-emphasis: #099885;
            --vz-info-text-emphasis: #2385ba;
            --vz-warning-text-emphasis: #d29c40;
            --vz-danger-text-emphasis: #cc563d;
            --vz-light-text-emphasis: #ced4da;
            --vz-dark-text-emphasis: #343a40;
            --vz-primary-bg-subtle: #e2e5ed;
            --vz-secondary-bg-subtle: #e1ebfd;
            --vz-success-bg-subtle: #daf4f0;
            --vz-info-bg-subtle: #dff0fa;
            --vz-warning-bg-subtle: #fef4e4;
            --vz-danger-bg-subtle: #fde8e4;
            --vz-light-bg-subtle: #f9fbfc;
            --vz-dark-bg-subtle: #e9ebec;
            --vz-primary-border-subtle: #b3b9d0;
            --vz-secondary-border-subtle: #aec9f9;
            --vz-success-border-subtle: #9de1d7;
            --vz-info-border-subtle: #a9d7f1;
            --vz-warning-border-subtle: #fce3b7;
            --vz-danger-border-subtle: #f9c1b6;
            --vz-light-border-subtle: #eff2f7;
            --vz-dark-border-subtle: #adb5bd;
            --vz-white-rgb: 255, 255, 255;
            --vz-black-rgb: 0, 0, 0;
            --vz-font-sans-serif: var(--vz-font-family-secondary);
            --vz-font-monospace: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
            --vz-gradient: linear-gradient(180deg, rgba(255, 255, 255, 0.15), rgba(255, 255, 255, 0));
            --vz-body-font-family: var(--vz-font-sans-serif);
            --vz-body-font-size: var(--vz-font-base);
            --vz-body-font-weight: var(--vz-font-weight-normal);
            --vz-body-line-height: 1.5;
            --vz-body-color: #212529;
            --vz-body-color-rgb: 33, 37, 41;
            --vz-body-bg: #f3f3f9;
            --vz-body-bg-rgb: 243, 243, 249;
            --vz-emphasis-color: #212529;
            --vz-emphasis-color-rgb: 33, 37, 41;
            --vz-secondary-color: #878a99;
            --vz-secondary-color-rgb: 135, 138, 153;
            --vz-secondary-bg: #fff;
            --vz-secondary-bg-rgb: 255, 255, 255;
            --vz-tertiary-color: rgba(33, 37, 41, 0.5);
            --vz-tertiary-color-rgb: 33, 37, 41;
            --vz-tertiary-bg: #eff2f7;
            --vz-tertiary-bg-rgb: 239, 242, 247;
            --vz-heading-color: #495057;
            --vz-link-color: #405189;
            --vz-link-color-rgb: 64, 81, 137;
            --vz-link-decoration: none;
            --vz-link-hover-color: #405189;
            --vz-link-hover-color-rgb: 64, 81, 137;
            --vz-code-color: #f672a7;
            --vz-highlight-color: #212529;
            --vz-highlight-bg: #fcf8e3;
            --vz-border-width: 1px;
            --vz-border-style: solid;
            --vz-border-color: #e9ebec;
            --vz-border-color-translucent: #ced4da;
            --vz-border-radius: 0.25rem;
            --vz-border-radius-sm: 0.2rem;
            --vz-border-radius-lg: 0.3rem;
            --vz-border-radius-xl: 1rem;
            --vz-border-radius-xxl: 2rem;
            --vz-border-radius-2xl: var(--vz-border-radius-xxl);
            --vz-border-radius-pill: 50rem;
            --vz-box-shadow: 0 1px 2px rgba(56, 65, 74, 0.15);
            --vz-box-shadow-sm: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            --vz-box-shadow-lg: 0 5px 10px rgba(30, 32, 37, 0.12);
            --vz-box-shadow-inset: inset 0 1px 2px rgba(0, 0, 0, 0.075);
            --vz-focus-ring-width: 0.25rem;
            --vz-focus-ring-opacity: 0.25;
            --vz-focus-ring-color: rgba(var(--vz-primary-rgb), 0.25);
            --vz-form-valid-color: #0ab39c;
            --vz-form-valid-border-color: #0ab39c;
            --vz-form-invalid-color: #f06548;
            --vz-form-invalid-border-color: #f06548
        }

        [data-bs-theme=dark] {
            color-scheme: dark;
            --vz-body-color: #ced4da;
            --vz-body-color-rgb: 206, 212, 218;
            --vz-body-bg: #1a1d21;
            --vz-body-bg-rgb: 26, 29, 33;
            --vz-emphasis-color: #fff;
            --vz-emphasis-color-rgb: 255, 255, 255;
            --vz-secondary-color: #878a99;
            --vz-secondary-color-rgb: 135, 138, 153;
            --vz-secondary-bg: #212529;
            --vz-secondary-bg-rgb: 33, 37, 41;
            --vz-tertiary-color: rgba(206, 212, 218, 0.75);
            --vz-tertiary-color-rgb: 206, 212, 218;
            --vz-tertiary-bg: #2a2d31;
            --vz-tertiary-bg-rgb: 42, 45, 49;
            --vz-primary-text-emphasis: #6674a1;
            --vz-secondary-text-emphasis: #5d92f4;
            --vz-success-text-emphasis: #3bc2b0;
            --vz-info-text-emphasis: #54b0e2;
            --vz-warning-text-emphasis: #f9c66f;
            --vz-danger-text-emphasis: #f3846d;
            --vz-light-text-emphasis: #535659;
            --vz-dark-text-emphasis: #5f6164;
            --vz-primary-bg-subtle: rgba(64, 81, 137, 0.15);
            --vz-secondary-bg-subtle: rgba(53, 119, 241, 0.15);
            --vz-success-bg-subtle: rgba(10, 179, 156, 0.15);
            --vz-info-bg-subtle: rgba(41, 156, 219, 0.15);
            --vz-warning-bg-subtle: rgba(247, 184, 75, 0.15);
            --vz-danger-bg-subtle: rgba(240, 101, 72, 0.15);
            --vz-light-bg-subtle: #25282c;
            --vz-dark-bg-subtle: #313437;
            --vz-primary-border-subtle: #2a3559;
            --vz-secondary-border-subtle: #1b3c79;
            --vz-success-border-subtle: #055a4e;
            --vz-info-border-subtle: #154e6e;
            --vz-warning-border-subtle: #7c5c26;
            --vz-danger-border-subtle: #783324;
            --vz-light-border-subtle: #35383c;
            --vz-dark-border-subtle: #3c3f42;
            --vz-heading-color: #ced4da;
            --vz-link-color: #d9dce7;
            --vz-link-hover-color: #e1e3ec;
            --vz-link-color-rgb: 217, 220, 231;
            --vz-link-hover-color-rgb: 225, 227, 236;
            --vz-code-color: #f672a7;
            --vz-highlight-color: #ced4da;
            --vz-highlight-bg: #634a1e;
            --vz-border-color: #32383e;
            --vz-border-color-translucent: #32383e;
            --vz-form-valid-color: #3bc2b0;
            --vz-form-valid-border-color: #3bc2b0;
            --vz-form-invalid-color: #f3846d;
            --vz-form-invalid-border-color: #f3846d
        }
    </style>
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->

</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->

    <div id="wrapper">
        <header id="page-topbar" style="background-color: #E0E0E0 !important;">
            <div class="layout-width">
                <div class="navbar-header">
                    <div class="d-flex">

                        <!-- HAMBURGER MENU -->
                        <button type="button" class="btn btn-sm px-3 fs-16 header-item vertical-menu-btn topnav-hamburger material-shadow-none" id="topnav-hamburger-icon" style="background-color: #E0E0E0 !important;">
                            <span class="hamburger-icon">
                                <span></span>
                                <span></span>
                                <span></span>
                            </span>
                        </button>

                        <!-- ============================================================APP SEARCH============================================================ -->
                        <form class="app-search d-none d-md-block">
                            <div class="position-relative">
                                <input type="text" class="form-control" placeholder="Search Nav..." autocomplete="off" id="search-options" value="">
                                <span class="mdi mdi-magnify search-widget-icon"></span>
                                <span class="mdi mdi-close-circle search-widget-icon search-widget-icon-close d-none" id="search-close-options"></span>
                            </div>
                            <div class="dropdown-menu dropdown-menu-lg" id="search-dropdown">
                                <div data-simplebar style="max-height: 320px;">

                                    <div class="dropdown-header mt-2">
                                        <h6 class="text-overflow text-muted mb-1 text-uppercase">Pages</h6>
                                    </div>

                                    <a href="task_allocate" class="dropdown-item notify-item">
                                        <i class="ri-dashboard-2-line align-middle fs-18 text-muted me-2"></i>
                                        <span>Task Entry</span>
                                    </a>

                                    <a href="task_action" class="dropdown-item notify-item">
                                        <i class="ri-dashboard-2-line align-middle fs-18 text-muted me-2"></i>
                                        <span>Task Allocated and Action</span>
                                    </a>

                                    <a href="task_main_report" class="dropdown-item notify-item">
                                        <i class="ri-dashboard-2-line align-middle fs-18 text-muted me-2"></i>
                                        <span>Task Report</span>
                                    </a>

                                    <a href="task_comp_report" class="dropdown-item notify-item">
                                        <i class="ri-dashboard-2-line align-middle fs-18 text-muted me-2"></i>
                                        <span>Task Completion Report</span>
                                    </a>

                                    <a href="calendar" class="dropdown-item notify-item">
                                        <i class="ri-calendar-2-fill align-middle fs-18 text-muted me-2"></i>
                                        <span>Calendar</span>
                                    </a>

                                    <a href="tms_dashboard" class="dropdown-item notify-item">
                                        <i class="ri-honour-line  align-middle fs-18 text-muted me-2"></i>
                                        <span>Dashboard</span>
                                    </a>

                                    <a href="dashboard" class="dropdown-item notify-item">
                                        <i class="ri-home-3-fill  align-middle fs-18 text-muted me-2"></i>
                                        <span>Life at Gainup</span>
                                    </a>

                                </div>

                            </div>
                        </form>

                        <!-- TITLE -->
                        <div class="page-title d-sm-flex align-items-center justify-content-between bg-galaxy-transparent" style="margin-left: 10px;">
                            <h4 class="mb-sm-0" style="font-weight: bold;">PAYSLIP</h4>
                        </div>

                    </div>

                    <!-- ============================================================PROFILE AND LOGOUT============================================================ -->
                    <div class="d-flex align-items-center">
                        <div id="reviewDiv"></div>


                        <!-- REVIEW -->
                        <div class="collapse" id="search-nav">
                            <h3 class="text-white pt-2 t-text" style="float: left; display: none;">PAYSLIP</h3>
                            <input type="hidden" name="title" id="title_input">
                            <form class="navbar-left navbar-form nav-search mr-md-3"></form>
                        </div>
                        <div class="d-flex align-items-center" style="display: none;">
                            <div class="ms-1 header-item d-none d-sm-flex">
                                <button type="button" class="btn btn-icon btn-topbar material-shadow-none btn-ghost-secondary rounded-circle light-dark-mode" style="display: none;">
                                    <i class='bx bx-moon fs-22'></i>
                                </button>
                            </div>
                        </div>
                        <script>
                            // for review
                            var title_Element = document.querySelector('h3.t-text');
                            var title_Value = title_Element.innerText;
                            var titleValue = title_Value.replace(/\s/g, '');
                            document.getElementById('title_input').value = titleValue;
                            // alert(titleValue);

                            // const dynamicValue = "kpimaster_entry";
                            const link = document.createElement('a');
                            link.href = `Post_Cmt?value=${titleValue}`;
                            link.innerHTML = '<i class="fa fa-comment"></i> Review Here!';
                            link.classList.add('highlight-button');

                            const targetDiv = document.getElementById('reviewDiv'); // Assuming you have a div element with id 'myDiv'
                            targetDiv.appendChild(link);

                            // document.body.appendChild(link);
                            // alert(link);           
                        </script>



                        <div class="dropdown ms-sm-3 header-item topbar-user">
                            <button type="button" class="btn material-shadow-none" id="page-header-user-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <span class="d-flex align-items-center">
                                    <?php
                                    $emp_idd = Session('empl_id');
                                    ?>
                                    <img class="rounded-circle header-profile-user" src="{{ asset('frontend/emplphotos/'.$emp_idd.'.jpeg')}}" alt="Header Avatar">
                                    <span class="text-start ms-xl-2">
                                        <span class="d-none d-xl-inline-block ms-1 fw-medium user-name-text">
                                            <?php $empl_name = Session('emp_name');
                                            echo $empl_name; ?>
                                        </span>
                                        <span class="d-none d-xl-block ms-1 fs-12 user-name-sub-text">
                                            <?php $emp_desg = Session('des_data');
                                            echo $emp_desg; ?>
                                        </span>
                                    </span>
                                </span>
                            </button>
                            <div class="dropdown-menu dropdown-menu-end">
                                <a class="dropdown-item" href="profile"><i class="mdi mdi-account-circle text-muted fs-16 align-middle me-1"></i> <span class="align-middle">Profile</span></a>
                                <a class="dropdown-item" href="reset"><i class="ri-lock-password-line text-muted fs-16 align-middle me-1"></i> <span class="align-middle" data-key="t-logout">Change Password</span></a>
                                <a class="dropdown-item" href="login"><i class="mdi mdi-logout text-muted fs-16 align-middle me-1"></i> <span class="align-middle" data-key="t-logout">Logout</span></a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </header>

        <!-- ============================================================SIDEBAR============================================================ -->
        <div class="app-menu navbar-menu">
            <!-- ============================================================LOGO============================================================ -->
            <div class="navbar-brand-box">
                <!-- Dark Logo-->
                <a href="javascript:;" class="logo logo-dark">
                    <span class="logo-sm">
                        <img src="Life-logo/logo.png" alt="" height="50">
                    </span>
                    <span class="logo-lg">
                        <img src="Life-logo/LIFE-DARK.png" alt="" height="25">
                    </span>
                </a>
                <!-- Light Logo-->
                <a href="javascript:;" class="logo logo-light">
                    <span class="logo-sm">
                        <img src="Life-logo/logo.png" alt="" height="50">
                    </span>
                    <span class="logo-lg">
                        <img src="Life-logo/LIFE-LIGHT.png" alt="" height="25">
                    </span>
                </a>
                <button type="button" class="btn btn-sm p-0 fs-20 header-item float-end btn-vertical-sm-hover" id="vertical-hover">
                    <i class="ri-record-circle-line"></i>
                </button>
            </div>

            <!-- ============================================================MENU============================================================ -->

            <div id="scrollbar">
                <div class="container-fluid">
                    <div id="two-column-menu"></div>
                    <ul class="navbar-nav" id="navbar-nav">
                        <li class="menu-title"><span data-key="t-menu">Menu</span></li>

                        <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ DASHBOARD @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="dashboard">
                                <i class="fas fa-home"></i> <span data-key="t-widgets">DASHBOARD</span>
                            </a>
                        </li>

                        <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ TICKET @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->
                        @php
                        $developerScreen_Rights=Session::get ('developerScreen');
                        @endphp
                        @if ($developerScreen_Rights ==='Y')
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#deventry" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="deventry">
                                <i class="fas fa-ticket-alt"></i> <span data-key="t-dev">TICKETS</span>
                            </a>
                            <div class="collapse menu-dropdown" id="deventry">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="IT_Ticket" class="nav-link" data-key="t-analytics"> TICKET ENTRY </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="{{ route('it-developer-screen') }}" class="nav-link" data-key="t-analytics"> DEVELOPER SCREEN </a>
                                    </li>
                                    @php
                                    $Ticket_Allocation_Rights=Session::get ('Ticket_Allow_rights');
                                    @endphp
                                    @if ($Ticket_Allocation_Rights ==='Y')
                                    <li class="nav-item">
                                        <a href="{{ route('Ticket_FC_Allocation') }}" class="nav-link" data-key="t-crm"> TICKET ALLOCATION </a>
                                    </li>
                                    @endif
                                </ul>
                            </div>
                        </li>
                        @endif

                        <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ KPI @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#kpi" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="kpi">
                                <i class="fas fa-layer-group"></i> <span data-key="t-kpi">KPI</span>
                            </a>
                            <div class="collapse menu-dropdown" id="kpi">
                                <ul class="nav nav-sm flex-column">
                                    @php
                                    $user_data=Session::get('user_data');
                                    @endphp
                                    @if($user_data == "GGA0741" || $user_data == "GKA0506" || $user_data == "GKA0100" || $user_data == "GKA0094" || $user_data == "GKA0419" || $user_data == "GRA0019" || $user_data == "GKA0516" || $user_data == "GGA0824")
                                    <li class="nav-item">
                                        <a href="KPI_Master" class="nav-link" data-key="t-analytics"> KPI MASTER ENTRY </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="KPI_MasterReport" class="nav-link" data-key="t-crm"> KPI MASTER REPORT </a>
                                    </li>
                                    @endif
                                    <li class="nav-item">
                                        <a href="target_entry" class="nav-link" data-key="t-ecommerce"> TARGET ENTRY </a>
                                    </li>
                                    @php
                                    $kpiPer = session('kpi_per', 'N');
                                    @endphp
                                    @if($kpiPer === 'Y')
                                    <li class="nav-item">
                                        <a href="target_app" class="nav-link" data-key="t-ecommerce"> TARGET APPROVAL </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="target_unapp" class="nav-link" data-key="t-ecommerce"> TARGET UNAPPROVAL </a>
                                    </li>
                                    @endif
                                    <li class="nav-item">
                                        <a href="SelF_Apprai_Entry" class="nav-link" data-key="t-ecommerce"> SELF APPRAISAL ENTRY </a>
                                    </li>
                                    @if($kpiPer === 'Y')
                                    <li class="nav-item">
                                        <a href="Self_Apapprove" class="nav-link" data-key="t-ecommerce"> SELF APPRAISAL APPROVAL </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="Self_UnApapprove" class="nav-link" data-key="t-ecommerce"> SELF APPRAISAL UNAPPROVAL </a>
                                    </li>
                                    @endif
                                </ul>
                            </div>
                        </li>

                        <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ KPI REPORTS @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#kpireport" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="kpireport">
                                <i class="fas fa-address-card"></i> <span data-key="t-dashboards">KPI REPORT</span>
                            </a>
                            <div class="collapse menu-dropdown" id="kpireport">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="Target_Master_Report" class="nav-link" data-key="t-analytics"> TARGET MASTER REPORT </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="KPI_Targer_Report" class="nav-link" data-key="t-crm"> TARGET REPORT </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="KPI_Apprai_Report" class="nav-link" data-key="t-crm"> SELF APPRAISAL REPORT </a>
                                    </li>
                                    @php
                                    $user_data=Session::get('user_data');
                                    @endphp
                                    @if($user_data == "GGA0824")
                                    <li class="nav-item">
                                        <a href="KPI_all_Apprai_Report" class="nav-link" data-key="t-crm"> ALL SELF APPRAISAL REPORT </a>
                                    </li>
                                    @endif
                                    <li class="nav-item">
                                        <a href="roles_report" class="nav-link" data-key="t-crm"> ROLES REPORT </a>
                                    </li>
                                    @php
                                    $Ctc_right=Session::get ('Ctc_rights');
                                    @endphp
                                    @if ($Ctc_right==='Y')
                                    <li class="nav-item">
                                        <a href="ctc_report" class="nav-link" data-key="t-crm"> CTC REPORT </a>
                                    </li>
                                    @endif
                                </ul>
                            </div>
                        </li>

                        <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ ORGANOGRAM @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#org" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="org">
                                <i class="fas fa-th-list"></i> <span data-key="t-dashboards">ORGANOGRAM</span>
                            </a>
                            <div class="collapse menu-dropdown" id="org">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="Organogram" class="nav-link" data-key="t-analytics"> ORGANOGRAM DETAILS </a>
                                    </li>
                                    <?php $user = Session('empl_id'); ?>
                                    @if($user=='406'|| $user=='50668'|| $user=='22140'|| $user=='44319')
                                    <!--NAGARAJAN || USHA.SIVAN || GANGATHARAN C || SRISANDOSH KARTHIKA N -->
                                    <li class="nav-item">
                                        <a href="Admin_org" class="nav-link" data-key="t-crm"> ADMIN ORGANOGRAM </a>
                                    </li>
                                    @endif
                                </ul>
                            </div>
                        </li>

                        <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ PAYROLL @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#payroll" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="payroll">
                                <i class="fab fa-paypal"></i> <span data-key="t-dashboards">PAYROLL</span>
                            </a>
                            <div class="collapse menu-dropdown" id="payroll">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="leave_entry" class="nav-link" data-key="t-analytics"> LEAVE ENTRY </a>
                                    </li>
                                    @php
                                    $kpiPer = session('kpi_per', 'N');
                                    @endphp
                                    @if($kpiPer === 'Y')
                                    <li class="nav-item">
                                        <a href="leave_approval" class="nav-link" data-key="t-crm"> LEAVE APPROVAL </a>
                                    </li>
                                    @endif
                                    <li class="nav-item">
                                        <a href="permission_entry" class="nav-link" data-key="t-ecommerce"> PERMISSION ENTRY </a>
                                    </li>
                                    @if($kpiPer === 'Y')
                                    <li class="nav-item">
                                        <a href="permission_app" class="nav-link" data-key="t-ecommerce"> PERMISSION APPROVAL </a>
                                    </li>
                                    @endif
                                    <li class="nav-item">
                                        <a href="odentry" class="nav-link" data-key="t-ecommerce"> OD ENTRY </a>
                                    </li>
                                    @if($kpiPer === 'Y')
                                    <li class="nav-item">
                                        <a href="od_approval" class="nav-link" data-key="t-ecommerce"> OD APPROVAL </a>
                                    </li>
                                    @endif
                                    <li class="nav-item">
                                        <a href="coffentry" class="nav-link" data-key="t-ecommerce"> C-OFF ENTRY </a>
                                    </li>
                                    @if($kpiPer === 'Y')
                                    <li class="nav-item">
                                        <a href="coff_app" class="nav-link" data-key="t-ecommerce"> C-OFF APPROVAL </a>
                                    </li>
                                    @endif

                                    @php
                                    $payslip1=Session::get('payslip');
                                    @endphp
                                    @if ($payslip1==='Y')
                                    <li class="nav-item">
                                        <a href="payslip" class="nav-link" data-key="t-ecommerce"> PAY SLIP </a>
                                    </li>
                                    @endif
                                    <li class="nav-item">
                                        <a href="New_Joiners" class="nav-link" data-key="t-ecommerce"> ON BOARDING </a>
                                    </li>
                                </ul>
                            </div>
                        </li>

                        <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ PAYROLL REPORTS @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#payrollreport" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="payrollreport">
                                <i class="fas fa-address-card"></i> <span data-key="payrollreport">PAYROLL REPORTS</span>
                            </a>
                            <div class="collapse menu-dropdown" id="payrollreport">
                                <ul class="nav nav-sm flex-column">

                                    <li class="nav-item">
                                        <a href="AttendanceDate" class="nav-link">
                                            <span data-key="payrollreport"> ATTENDANCE REPORT </span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="leave_entry_report" class="nav-link">
                                            <span data-key="payrollreport"> LEAVE ENTRY REPORT </span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="Permission_entry_report" class="nav-link">
                                            <span data-key="payrollreport"> PERMISSION ENTRY REPORT </span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="Od_Entry_Report" class="nav-link">
                                            <span data-key="payrollreport"> OD ENTRY REPORT </span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="C-OFF_Entry_Report" class="nav-link">
                                            <span data-key="payrollreport"> C-OFF ENTRY REPORT </span>
                                        </a>
                                    </li>

                                </ul>
                            </div>
                        </li>

                        <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ POLICY @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#policy" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="policy">
                                <i class="mdi mdi-shield-check"></i> <span data-key="t-dashboards">POLICY</span>
                            </a>
                            <div class="collapse menu-dropdown" id="policy">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="policy_mas" class="nav-link" data-key="t-analytics"> POLICY MASTER </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="policy_entry" class="nav-link" data-key="t-crm"> POLICY ENTRY </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="policy_app_1" class="nav-link" data-key="t-ecommerce"> POLICY 1ST LEVEL APPROVAL </a>
                                    </li>
                                    @if($user_data == "AMD0000" || $user_data == "GKA0100" )
                                    <li class="nav-item">
                                        <a href="policy_app_2" class="nav-link" data-key="t-ecommerce"> POLICY 2ND LEVEL APPROVAL </a>
                                    </li>
                                    @endif
                                </ul>
                            </div>
                        </li>

                        <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ POWER BI @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="powerBireport">
                                <i class="fas fa-file-powerpoint"></i> <span data-key="t-widgets"> POWERBI REPORT </span>
                            </a>
                        </li>

                        <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ ROLES @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#roles" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="roles">
                                <i class="fas fa-user"></i> <span data-key="t-dashboards">ROLES</span>
                            </a>
                            <div class="collapse menu-dropdown" id="roles">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="Roles_Entry" class="nav-link" data-key="t-analytics"> ROLES ENTRY </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="Roles_Allocate" class="nav-link" data-key="t-crm"> ROLES ALLOCATION </a>
                                    </li>
                                </ul>
                            </div>
                        </li>

                        <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ TMS @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="tms_dashboard">
                                <i class="fas fa-list"></i> <span data-key="t-widgets"> TASK MANAGEMENT </span>
                            </a>
                        </li>

                        <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ PROJECT @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#ticket" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="ticket">
                                <i class="las la-hard-hat"></i> <span data-key="t-dashboards">PROJECT</span>
                            </a>
                            <div class="collapse menu-dropdown" id="ticket">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="project" class="nav-link" data-key="t-crm"> PROJECT APPROVAL </a>
                                    </li>
                                    <?php $user_data = Session('empl_id'); ?>
                                    @if($user_data == '9549' || $user_data == '33058'|| $user_data == '48143' ||
                                    $user_data == '5108' || $user_data == '5461' || $user_data == '48640' )
                                    <li class="nav-item">
                                        <a href="project_report" class="nav-link" data-key="t-crm"> PROJECT REPORT </a>
                                    </li>
                                    @endif
                                </ul>
                            </div>
                        </li>

                        <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ SKILL @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#skill" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="skill">
                                <i class="ri-rocket-line"></i> <span data-key="t-dashboards">SKILL MANAGEMENT</span>
                            </a>
                            <div class="collapse menu-dropdown" id="skill">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="skill_team" class="nav-link" data-key="t-analytics"> SKILL MASTER </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="skill_entry" class="nav-link" data-key="t-crm"> SKILL MANAGEMENT ENTRY </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="skill_allocation" class="nav-link" data-key="t-crm"> SKILL ALLOCATION </a>
                                    </li>
                                </ul>
                            </div>
                        </li>

                        <!-- @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ VEHICLE BOOKING @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ -->
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#vehbook" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="vehbook">
                                <i class="fa-solid fa-car"></i> <span data-key="t-dashboards">VEHICLE BOOKING</span>
                            </a>
                            <div class="collapse menu-dropdown" id="vehbook">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="car_booking" class="nav-link" data-key="t-analytics"> CAR BOOKING </a>
                                    </li>
                                </ul>
                            </div>
                        </li>

                        <br><br>
                        <li class="menu-title d-none"><i class="ri-more-fill"></i> <span data-key="t-components">Components</span></li>


                    </ul>
                </div>
                <!-- Sidebar -->
            </div>

            <!-- Include Bootstrap and jQuery libraries -->
            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
            <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
            <script>
                $(document).ready(function() {
                    // Handle click event on menu links
                    $('.menu-link').on('click', function() {
                        var target = $(this).data('bs-target');
                        var $targetCollapse = $(target);

                        if ($targetCollapse.hasClass('show')) {
                            // Collapse the target menu if it is already open
                            $targetCollapse.collapse('hide');
                        } else {
                            // Close other open collapsible menus
                            $('.collapse.show').collapse('hide');

                            // Open the target menu
                            $targetCollapse.collapse('show');
                        }
                    });
                });
            </script>
            <div class="sidebar-background"></div>
        </div>
        <div class="vertical-overlay"></div>


        <div class="main-panel">
            <div class="container">

                <div class="row">
                    <div class="col-sm-12 col-md-12 col-lg-12">
                        <div class="card">
                            <div class="card-title"></div>
                            <div class="row">
                                <div class="col text-right">
                                </div>
                            </div>

                            <form id="validate" method="GET" action="{{ route('get_payslip_data') }}">
                                @csrf
                                <div class="row">
                                    <div class="col-md-1 col-lg-1 mt-3">
                                        <div class="form-group">
                                            <label>Date</label>
                                        </div>
                                    </div>
                                    <div Class="col-md-4 col-lg-4 mt-2">
                                        <div class="form-group">
                                            <select class="form-control" name="from_date" id="from_date" onchange="datechange(this.value)">
                                                <option value="">--Select--</option>
                                                @foreach ($get_months as $row)
                                                <option value="{{$row}}">{{$row}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <!-- Spinner -->
                                        <div id="spinner" style="display: none; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);">
                                            <div class="spinner-border text-primary" role="status">
                                                <span class="visually-hidden">Loading...</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>

                            <div class="card-body">
                                <div class="col text-right">
                                    <input type="button" onclick="printDiv('printableArea')" value="PRINT" />
                                </div>
                                <div class="table-responsive" id="printableArea">
                                    <div class="box-model" style=width:1250px;>

                                        <div class="row">
                                            <div style="font-weight:bold">
                                                <h4 style="text-align:left;font-weight:bold;" class="comp_name col-8"></h4>
                                                <h5 style="text-align:left;font-weight:bold;" class="comp_add col-7"></h5>
                                            </div>
                                            <div style="font-weight:bold">
                                                <h4 style="text-align:center;font-weight:bold;">PAY SLIP</h4>
                                                <h5 style="text-align:center;font-weight:bold;">Form No - 25 (Under Rule 103-B)</h5>
                                                <lable>Salary Month:</lable>
                                                <lable style=text-align:center; class="sal_mon">---</lable>
                                                <lable class="ml-3">Payment Date:</lable>
                                                <lable style=text-align:center; class="pay_date">---</lable>
                                            </div>
                                        </div>

                                        <hr style="width:1250px;margin-left:-10px;color:1px solid black;border: 1px solid black;background-color:black;">
                                        <div class="row row-cols-lg-auto g-3">
                                            <div class="col" style="font-weight:bold">
                                                <lable class="col-md-3">Employee No</lable>
                                                <lable style="margin-left:87px;">:</lable>
                                                <lable class="emp_no"></lable>
                                            </div>
                                            <div class="col" style="font-weight:bold">
                                                <lable class="col-md-3">Factory Reg.No</lable>
                                                <lable style="margin-left:0px;">:</lable>
                                                <lable class="fac_no"></lable>
                                            </div>
                                            <div class="col" style="font-weight:bold">
                                                <lable class="col-md-3">Mode of Payment</lable>
                                                <lable style="margin-left:4px;">:</lable>
                                                <lable class="pay_mode"></lable>
                                            </div>
                                        </div>
                                        <div class="row row-cols-lg-auto g-3">
                                            <div class="col" style="font-weight:bold">
                                                <lable class="col-md-3">Employee Name</lable>
                                                <lable style="margin-left:67px;">:</lable>
                                                <lable class="emp_name"></lable>
                                            </div>
                                            <div class="col" style="font-weight:bold">
                                                <lable class="col-md-3">PF UAN No</lable>
                                                <lable style="margin-left:30px;">:</lable>
                                                <lable class="pf_no"></lable>
                                            </div>
                                            <div class="col" style="font-weight:bold">
                                                <lable class="col-md-3">Name of The Bank</lable>
                                                <lable style="margin-left:0px;">:</lable>
                                                <lable class="bank"></lable>
                                            </div>
                                        </div>
                                        <div class="row row-cols-lg-auto g-3">
                                            <div class="col" style="font-weight:bold">
                                                <lable class="col-md-3">Father's/Husband's Name</lable>
                                                <lable style="margin-left:0px;">:</lable>
                                                <lable class="fa_name"></lable>
                                            </div>
                                            <div class="col" style="font-weight:bold">
                                                <lable class="col-md-3">ESI No</lable>
                                                <lable style="margin-left:62px;">:</lable>
                                                <lable class="esi_no"></lable>
                                            </div>
                                            <div class="col" style="font-weight:bold">
                                                <lable class="col-md-3">Bank A/C No</lable>
                                                <lable style="margin-left:37px;">:</lable>
                                                <lable class="ac_no"></lable>
                                            </div>
                                        </div>
                                        <div class="row row-cols-lg-auto g-3">
                                            <div class="col" style="font-weight:bold">
                                                <lable class="col-md-3">Department</lable>
                                                <lable style="margin-left:94px;">:</lable>
                                                <lable class="dep"></lable>
                                            </div>
                                            <div class="col" style="font-weight:bold">
                                                <lable class="col-md-3">Date of Join</lable>
                                                <lable style="margin-left:24px;">:</lable>
                                                <lable class="doj"></lable>
                                            </div>
                                            <div class="col" style="font-weight:bold">
                                                <lable class="col-md-3">Week-Off</lable>
                                                <lable style="margin-left:57px;">:</lable>
                                                <lable class="WkOffDay"></lable>
                                            </div>
                                        </div>
                                        <div class="row row-cols-lg-auto g-3">
                                            <div class="col-5" style="font-weight:bold">
                                                <lable class="col-md-3">Designation</lable>
                                                <lable style="margin-left:95px;">: </lable><label style="font-weight:bold" class="desig"></label>
                                            </div>
                                            <div class="col" style="font-weight:bold">
                                                <lable style="margin-left:-105px;" class="col-md-3">Date of Birth</lable>
                                                <lable style="margin-left:17px;">: </lable><label style="font-weight:bold" class="dob"></label>
                                            </div>
                                        </div>

                                        <hr style="width:1250px;margin-left:-10px;color:1px solid black; border: 1px solid black;background-color:black;">
                                        <div class="col-sm-12 col-md-12 col-lg-12">
                                            <div class="table-responsive">
                                                <table class="table10" style="border:dotted 2px #000000;width:100%;">
                                                    <thead class="text-center">
                                                        <tr>
                                                            <th style="border-bottom:dotted 2px #000000;border-right:dotted 2px #000000;height:50px;width:416px;">Salary(&#8377;)</th>
                                                            <th style="border-bottom:dotted 2px #000000;border-right:dotted 2px #000000;height:50px;width:416px;">Deductions(&#8377;)</th>
                                                            <th style="border-bottom:dotted 2px #000000;border-right:dotted 2px #000000;height:50px;width:416px;">Attendance(days)</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>Basic + DA</lable>
                                                                <lable class="control-label27 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>Advance</lable>
                                                                <lable class="control-label11 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>No Of Days Worked</lable>
                                                                <lable class="control-label21 label-right">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>HRA</lable>
                                                                <lable class="control-label5 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>PF</lable>
                                                                <lable class="control-label12 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>CL Usage/CL Available</lable>
                                                                <lable class="control-label222 label-right"></lable>
                                                                <lable class="label-right">/</lable>
                                                                <lable class="control-label22 label-right"></lable>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>Special Allowance</lable>
                                                                <lable class="control-label28 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>ESI</lable>
                                                                <lable class="control-label13 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>EL Usage/EL Available</lable>
                                                                <lable class="control-label233 label-right"> </lable>
                                                                <lable class="label-right">/</lable>
                                                                <lable class="control-label23 label-right"></lable>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>Total Salary</lable>
                                                                <lable class="control-label1 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>Token</lable>
                                                                <lable class="control-label14 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>NFH Days</lable>
                                                                <lable class="control-label24 label-right">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>Earned Salary</lable>
                                                                <lable class="control-label3 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>Purchase</lable>
                                                                <lable class="control-label15 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>OT Hrs</lable>
                                                                <lable class="control-label25 label-right">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>OT Salary</lable>
                                                                <lable class="control-label4 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>TDS / Insurance</lable>
                                                                <lable class="control-label16 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>Total Leave Days</lable>
                                                                <lable class="control-label26 label-right">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>Prv.CF Amount</lable>
                                                                <lable class="control-label6 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>Others</lable>
                                                                <lable class="control-label18 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;"></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <hr class="label-right" style="width:20%; height:-10px;color:black;background-color:black;">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>C.CF Amount</lable>
                                                                <lable class="control-label19 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;"></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable><b style="font-size:1rem;">Gross Salary</b></lable>
                                                                <lable class="control-label7 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;"></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>Incentive Amount(+)</lable>
                                                                <lable class="control-label8 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;"></td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;"></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable>Deductions(-)</lable>
                                                                <lable class="control-label9 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;"></td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;"></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;"> </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;"></td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;"></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <hr class="label-right" style="width:20%; height:-10px;color:black;background-color:black;">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <hr class="label-right" style="width:27%; height:-10px;color:black;background-color:black;">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;"></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable><b style="font-size:1rem;">Net Salary</b></lable>
                                                                <lable class="control-label10 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;">
                                                                <lable style="font-size:1rem;">Total</lable>
                                                                <lable class="control-label20 label-right">
                                                            </td>
                                                            <td style="border-bottom:none;border-right:dotted 2px #000000;height:20px;padding-left: 20px;padding-right: 20px;"></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="height:20px;border-right:dotted 2px #000000;padding-left: 20px;padding-right: 20px;">
                                                                <hr class="label-right" style="width:20%; height:-10px;color:black;background-color:black;">
                                                            </td>
                                                            <td style="height:20px;border-right:dotted 2px #000000;padding-left: 20px;padding-right: 20px;">
                                                                <hr class="label-right" style="width:27%; height:-10px;color:black;background-color:black;">
                                                            </td>
                                                            <td style="height:20px;border-right:dotted 2px #000000;padding-left: 20px;padding-right: 20px;"></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="text-center">
                                                <lable><b style="font-size:1rem;font-weight:bold">Rupees</b></lable>
                                                <lable style="margin-left:30px;font-weight:bold" class="control-label100"></lable>
                                                <lable><b style="font-size:1rem;margin-left:30px;">Only</b></lable>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- <footer class="footer"> -->
                                    <div class="text-center">
                                        <p>"This is an electronically generated report, hence does not require a signature"</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>


    <!-- PRINT -->
    <script>
        function printDiv(divName) {
            var printContents = document.getElementById(divName).innerHTML;
            var originalContents = document.body.innerHTML;
            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;
        }
    </script>

    <!-- SHOWING DATA USING AJAX -->
    <script>
        function datechange(t_date) {

            $('#spinner').show();

            var selected_date = t_date;

            $.ajax({
                url: "{{ route('get_payslip_data') }}",
                type: "GET",

                data: {
                    insert_date: selected_date,
                },

                dataType: 'json',
                success: function(data1) {
                    console.log(data1);
                    var t_sal = data1[0].Total_Salary;
                    t_sal = t_sal.toString().split('.')[0];
                    var basic = data1[0].Basic_Da;
                    basic = basic.toString().split('.')[0];
                    var hra = data1[0].Hra;
                    hra = hra.toString().split('.')[0];
                    var spl = data1[0].Spec_Allow;
                    spl = spl.toString().split('.')[0];
                    var incen = data1[0].Incent_Amount;
                    incen = incen.toString().split('.')[0];
                    var adv = data1[0].Advance;
                    adv = adv.toString().split('.')[0];
                    var pf = data1[0].Pf;
                    pf = pf.toString().split('.')[0];
                    var esi = data1[0].Esi;
                    esi = esi.toString().split('.')[0];
                    var purch = data1[0].Purchase;
                    purch = purch.toString().split('.')[0];
                    var tds = data1[0].Tds;
                    tds = tds.toString().split('.')[0];
                    var others = data1[0].Others;
                    others = others.toString().split('.')[0];
                    var el_u = data1[0].El;
                    el_u = el_u.slice(0, -1);

                    var net = data1[0].Net_Salary;
                    var nfh = data1[0].Nh_Days_Salary;
                    var earn = data1[0].Earn_Salary;
                    var ot = data1[0].Ot_Salary;
                    var prv_cf = data1[0].Prv_Cf_Amount;
                    var gross = data1[0].Gross_Salary;
                    var deduc = data1[0].Deduction;
                    var token = data1[0].Token;
                    var insur = data1[0].Insurance;
                    var c_cf = data1[0].C_Cf_Amount;
                    var total = data1[0].Total_Deduction;
                    var d_wrk = data1[0].Tot_Work_Days;
                    var cl_u = data1[0].Cl;
                    var cl_a = data1[0].Cl_Avail;
                    var el_a = data1[0].El_Avail;
                    var nfh_d = data1[0].NH_Days;
                    var ot_hrs = data1[0].Ot_Hrs;
                    var t_lea_d = data1[0].Total_Leave;
                    var tic_no = data1[0].TNo;
                    var name = data1[0].Name;
                    var desig = data1[0].DesigName;
                    var comp = data1[0].CompName;
                    var add = data1[0].Compaddress;
                    var mon = data1[0].Sal_Month;
                    var fact_no = data1[0].Factreg_No;
                    var fname = data1[0].Fname;
                    var pf_uan = data1[0].PfNo;
                    var no_esi = data1[0].EsiNo;
                    var mode_pay = data1[0].PayMode;
                    var bank_name = data1[0].Bankname;
                    var acc_no = data1[0].AcNo;
                    var WkOffDay = data1[0].WkOffDay;
                    var mon_sal = data1[0].Sal_Month;
                    var dept = data1[0].DEPTNAME;
                    var Sal_Words = data1[0].Sal_Words;

                    var pay_date = data1[0].PayDate;
                    var part1_pay_date = pay_date.substring(0, 10);
                    var part2_pay_date = pay_date.substring(10);
                    part1_pay_date = part1_pay_date.split('-').reverse().join('-');

                    var do_j = data1[0].dateofjoin;
                    var part1_do_j = do_j.substring(0, 10);
                    var part2_do_j = do_j.substring(10);
                    part1_do_j = part1_do_j.split('-').reverse().join('-');


                    var do_b = data1[0].dateofbirth;
                    var part1_do_b = do_b.substring(0, 10);
                    var part2_do_b = do_b.substring(10);
                    part1_do_b = part1_do_b.split('-').reverse().join('-');

                    $('.control-label100').text(Sal_Words);
                    $('.control-label1').text(t_sal);
                    $('.control-label2').text(nfh);
                    $('.control-label3').text(earn);
                    $('.control-label4').text(ot);
                    $('.control-label5').text(hra);
                    $('.control-label6').text(prv_cf);
                    $('.control-label7').text(gross);
                    $('.control-label8').text(incen);
                    $('.control-label9').text(deduc);
                    $('.control-label10').text(net);

                    $('.control-label11').text(adv);
                    $('.control-label12').text(pf);
                    $('.control-label13').text(esi);
                    $('.control-label14').text(token);
                    $('.control-label15').text(purch);
                    $('.control-label16').text(tds);
                    $('.control-label17').text(insur);
                    $('.control-label18').text(others);
                    $('.control-label19').text(c_cf);
                    $('.control-label20').text(total);

                    $('.control-label21').text(d_wrk);
                    $('.control-label22').text(cl_u);
                    $('.control-label222').text(cl_a);
                    $('.control-label23').text(el_u);
                    $('.control-label233').text(el_a);
                    $('.control-label24').text(nfh_d);
                    $('.control-label25').text(ot_hrs);
                    $('.control-label26').text(t_lea_d);

                    $('.control-label27').text(basic);
                    $('.control-label28').text(spl);

                    $('.emp_no').text(tic_no);
                    $('.fac_no').text(fact_no);
                    $('.pay_mode').text(mode_pay);

                    $('.emp_name').text(name);
                    $('.pf_no').text(pf_uan);
                    $('.bank').text(bank_name);

                    $('.fa_name').text(fname);
                    $('.esi_no').text(no_esi);
                    $('.ac_no').text(acc_no);

                    $('.dep').text(dept);
                    $('.doj').text(part1_do_j);
                    $('.WkOffDay').text(WkOffDay);

                    $('.desig').text(desig);
                    $('.dob').text(part1_do_b);

                    $('.comp_name').text(comp);
                    $('.comp_add').text(add);

                    $('.sal_mon').text(mon_sal);
                    $('.pay_date').text(part1_pay_date);

                    $('#spinner').hide();

                }
            });
        }
    </script>

</body>

<!-- Mirrored from demo.themekita.com/atlantis/livepreview/examples/demo1/index.html by HTTrack Website Copier/3.x [XR&CO'2014], Sat, 26 Feb 2022 04:59:08 GMT -->

</html>