<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>LEAVE ENTRY</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <script type="text/javascript">
        document.addEventListener('contextmenu', function(e) {
            e.preventDefault();
        });

        document.addEventListener('keydown', function(e) {
            // Disable F12 key
            if (e.keyCode === 123) {
                e.preventDefault();
            }
            // Disable Ctrl+Shift+I
            if (e.ctrlKey && e.shiftKey && e.keyCode === 73) {
                e.preventDefault();
            }
            // Disable Ctrl+Shift+J (Console)
            if (e.ctrlKey && e.shiftKey && e.keyCode === 74) {
                e.preventDefault();
            }
            // Disable Ctrl+U (View Source)
            if (e.ctrlKey && e.keyCode === 85) {
                e.preventDefault();
            }
        });
    </script>


    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }
    </style>

    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->


</head>

<body id="body" class="">

    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->

    @section('tittle') {{"LEAVE ENTRY"}}@endsection

    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                      <br>
                                <!-- ALERT MESSAGE -->
                                @if ($message = Session::get('success'))
                                <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert">
                                    {{$message}}
                                </div>
                                <script>
                                    // Automatically close the alert after 3 seconds
                                    setTimeout(function() {
                                        var successAlert = document.getElementById('successAlert');
                                        if (successAlert) {
                                            successAlert.remove();
                                        }
                                    }, 15000);
                                </script>
                                @endif

                                @if ($errors->any())
                                <div id="ErrorAlert" class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>

                                <script>
                                    // Automatically close the alert after 3 seconds
                                    setTimeout(function() {
                                        var successAlert = document.getElementById('ErrorAlert');
                                        if (successAlert) {
                                            successAlert.remove();
                                        }
                                    }, 15000);
                                </script>
                                @endif

                                @if ($message = Session::get('alert'))
                                <div id="successAlert" class="alert alert-danger alert-dismissible fade show" role="alert">
                                    {{$message}}
                                </div>
                                <script>
                                    // Automatically close the alert after 3 seconds
                                    setTimeout(function() {
                                        var successAlert = document.getElementById('successAlert');
                                        if (successAlert) {
                                            successAlert.remove();
                                        }
                                    }, 5000);
                                </script>
                                @endif

                                <div class="card-body">
                                    <div class="live-preview">
                                        <form method="POST" action="{{ route('leave_request') }}" enctype="multipart/form-data" class="has-validated" id="validate">
                                            @csrf
                                            <div class="row">
                                                <!-- TKNO -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">TNo</label>
                                                        <?php $user_tkno = session('user_data') ?>
                                                        <input type="text" name="TNO" value="{{$user_tkno}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- NAME -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">NAME</label>
                                                        <?php $user_name = session('emp_name') ?>
                                                        <input type="text" name="NAME" value="{{$user_name}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- DEPARTMENT -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">DEPARTMENT</label>
                                                        <?php $user_dep = session('dep_data') ?>
                                                        <input type="text" name="DEPARTMENT" value="{{$user_dep}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- POSITION -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">POSITION</label>
                                                        <?php $user_posit = session('des_data') ?>
                                                        <input type="text" name="DESIGNAION" value="{{$user_posit}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="row">
                                                <!-- FROM -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label class="form-label">FROM<span class="login-danger">*</span></label>
                                                        <input type="date" name="from_date" id="from_date" onkeydown="return false;" min="{{ date('Y-m-d') }}" value="{{ old('from_date', now()->format('Y-m-d')) }}" class="form-control">
                                                    </div>
                                                </div>
                                                <!-- TO -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label class="form-label">TO<span class="login-danger">*</span></label>
                                                        <input type="date" name="to_date" id="to_date" onkeydown="return false;" min="{{ date('Y-m-d') }}" value="{{ old('to_date', now()->format('Y-m-d')) }}" class="form-control">
                                                    </div>
                                                </div>
                                                <!-- DAY -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">DAYS</label>
                                                        <input type="radio" name="daytype" checked id="day_type" value="1" {{ old('daytype', '1') == '1' ? 'checked' : '' }}>
                                                        <input type="text" name="days_count" id="days_count" value="{{ old('days_count', '1') }}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- HALF DAY -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">HALF DAY</label>
                                                        <input type="radio" name="daytype" id="half_type" value="0.5" {{ old('daytype') == '0.5' ? 'checked' : '' }}>
                                                        <input type="text" name="halfday_count" id="halfday_count" value="{{ old('halfday_count', '0.5') }}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="row">
                                                <!-- PREVIOUS STATUS -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">PREVIOUS STATUS</label>
                                                        <input type="text" name="prev" value="{{$status}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- REASON -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label>REASON<span class="login-danger">*</span></label>
                                                        <select name="reas" class="form-select select2" required>
                                                            <option value="" disabled {{ old('reas') ? '' : 'selected' }}>Select Reason</option>
                                                            <option value="Bank Work" {{ old('reas') == 'Bank Work' ? 'selected' : '' }}>Bank Work</option>
                                                            <option value="Festival" {{ old('reas') == 'Festival' ? 'selected' : '' }}>Festival</option>
                                                            <option value="Floor Leave" {{ old('reas') == 'Floor Leave' ? 'selected' : '' }}>Floor Leave</option>
                                                            <option value="Health Problem" {{ old('reas') == 'Health Problem' ? 'selected' : '' }}>Health Problem</option>
                                                            <option value="Marriage" {{ old('reas') == 'Marriage' ? 'selected' : '' }}>Marriage</option>
                                                            <option value="Official Work" {{ old('reas') == 'Official Work' ? 'selected' : '' }}>Official Work</option>
                                                            <option value="Personal" {{ old('reas') == 'Personal' ? 'selected' : '' }}>Personal</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <!-- REMARK -->
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label for="validationTextarea" class="form-label">REMARK<span class="login-danger">*</span></label>
                                                        <textarea class="form-control" name="remarks" rows="1" required>{{ old('remarks') }}</textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <!--  SUBMIT BUTTON -->
                                            <div class="text-center">
                                                <button type="submit" class="btn btn-primary" id="saveButton">Submit</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>



    <!-- DAYS COUNT -->
    <script>
        $(document).ready(function() {
            $('#from_date, #to_date').change(function() {
                var fromDate = $('#from_date').val();
                var toDate = $('#to_date').val();

                if (fromDate && toDate) {
                    var daysCount = getDaysCount(fromDate, toDate);
                    $('#days_count').val(daysCount + 1);

                    // Update the value of the radio button
                    $('#day_type').val(daysCount + 1);

                    // Check if days count is more than one, then hide halfday_count
                    if (daysCount > 0) {
                        $('#halfday_count').closest('.mb-3').hide();
                        $('#day_type').prop('checked', true); // Check the radio button for days
                    } else {
                        $('#halfday_count').closest('.mb-3').show();
                    }
                }
            });

            function getDaysCount(fromDate, toDate) {
                var from = new Date(fromDate);
                var to = new Date(toDate);
                var timeDiff = to.getTime() - from.getTime();
                var dayCount = Math.ceil(timeDiff / (1000 * 3600 * 24));
                return dayCount;
            }
        });
    </script>

    <!-- CHECKING THE TO DATE -->
    <script>
        // Function to handle saving the details
        function saveDetails(dayCount) {
            // You can replace this alert with your code for saving the details
            // document.getElementById("validate").submit();
        }

        // Add an event listener to the "saveButton" element
        document.getElementById("saveButton").addEventListener("click", function(event) {

            var dayCount = document.getElementById("days_count").value;
            var dayCountValue = parseInt(dayCount);

            // Check if the value is less than 0
            if (dayCountValue < 0) {
                event.preventDefault();
                // Display an error message for a negative value
                alert("Please Check the TO Date.");
            } else if (dayCountValue === 0) {
                event.preventDefault();
                // Display an error message for a value equal to 0
                alert("Please Check the TO Date.");
            } else {
                saveDetails(dayCount); // Call the function to handle saving the details
            }
        });
        // Add an event listener for the "Enter" key press
        document.addEventListener("keydown", function(event) {
            if (event.key === "Enter") {
                var dayCount = document.getElementById("days_count").value;
                var dayCountValue = parseInt(dayCount);

                // Check if the value is less than 0
                if (dayCountValue < 0) {
                    event.preventDefault();
                    // Display an error message for a negative value
                    alert("Please Check the TO Date.");
                } else if (dayCountValue === 0) {
                    event.preventDefault();
                    // Display an error message for a value equal to 0
                    alert("Please Check the TO Date.");
                } else {
                    saveDetails(dayCount); // Call the function to handle saving the details
                }
            }
        });
    </script>


    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>