<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>PERMISSION ENTRY</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <!-- Link to Flatpickr CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <!-- Link to Flatpickr JS -->
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>

    <script type="text/javascript">
        document.addEventListener('contextmenu', function(e) {
            e.preventDefault();
        });

        document.addEventListener('keydown', function(e) {
            // Disable F12 key
            if (e.keyCode === 123) {
                e.preventDefault();
            }
            // Disable Ctrl+Shift+I
            if (e.ctrlKey && e.shiftKey && e.keyCode === 73) {
                e.preventDefault();
            }
            // Disable Ctrl+Shift+J (Console)
            if (e.ctrlKey && e.shiftKey && e.keyCode === 74) {
                e.preventDefault();
            }
            // Disable Ctrl+U (View Source)
            if (e.ctrlKey && e.keyCode === 85) {
                e.preventDefault();
            }
        });
    </script>


    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }
    </style>

    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->

</head>

<body id="body" class="">

    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->

    @section('tittle') {{"PERMISSION ENTRY"}}@endsection

    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <br>


    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 15000);
    </script>
    @endif
    @if ($message = Session::get('alert'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show" role="alert">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 15000);
    </script>
    @endif
    @if ($errors->any())
    <div id="ErrorAlert" class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>

    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('ErrorAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 15000);
    </script>
    @endif

                                <div class="card-body">
                                    <div class="live-preview">
                                        <form method="POST" action="{{ route('perentry') }}" enctype="multipart/form-data" class="has-validated" id="validate">
                                            @csrf
                                            <div class="row">
                                                <!-- TKNO -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">TNo</label>
                                                        <?php $user_tkno = session('user_data') ?>
                                                        <input type="text" name="TNO" value="{{$user_tkno}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- NAME -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">NAME</label>
                                                        <?php $user_name = session('emp_name') ?>
                                                        <input type="text" name="NAME" value="{{$user_name}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- DEPARTMENT -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">DEPARTMENT</label>
                                                        <?php $user_dep = session('dep_data') ?>
                                                        <input type="text" name="DEPARTMENT" value="{{$user_dep}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- POSITION -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">POSITION</label>
                                                        <?php $user_posit = session('des_data') ?>
                                                        <input type="text" name="DESIGNAION" value="{{$user_posit}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="row">
                                                <!-- DATE -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label class="form-label">DATE<span class="login-danger">*</span></label>
                                                        <input type='date' class="form-control" id="from_date" name="from_date" min="{{ date('Y-m-d') }}" value="{{ old('from_date', now()->format('Y-m-d')) }}">
                                                    </div>
                                                </div>
                                                <!-- FROM -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">FROM</label>
                                                        <input class="form-control timepicker" type="text" name="start_time" required>
                                                    </div>
                                                </div>
                                                <!-- TO -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">TO</label>
                                                        <input class="form-control timepicker" type="text" name="end_time" required>
                                                    </div>
                                                </div>
                                                <!-- HOURS -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">HOURS</label>
                                                        <input type="text" placeholder="" id="hour" class="form-control dull" name="hour" value="{{old ('hour')}}" readonly>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="row">
                                                <!-- TYPE -->
                                                <div class="col-md-4 col-lg-3">
                                                    <div class="form-group">
                                                        <label>Type</label>
                                                        <div class="row">
                                                            <div class="col">
                                                                <label class="radio-inline mt-3">
                                                                    <input type="radio" name="type" id="type" value="1" {{ old('type', '1') == '1' ? 'checked' : '' }}>Official
                                                                </label>
                                                            </div>
                                                            <div class="col">
                                                                <label class="radio-inline mt-3">
                                                                    <input type="radio" name="type" id="type" value="0" {{ old('type', '0') == '0' ? 'checked' : '' }}>Personal
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- REMARK -->
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label for="validationTextarea" class="form-label">REMARK<span class="login-danger">*</span></label>
                                                        <textarea class="form-control" name="remarks" rows="1" required>{{ old('remarks') }}</textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <!--  SUBMIT BUTTON -->
                                            <div class="text-center">
                                                <button type="submit" name="submit" class="btn btn-primary" value="SAVE" id="saveButton">Submit</button>
                                            </div>

                                            <!--Modal: modalPush-->
                                            <div class="modal fade" id="modalPush" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-notify modal-info" role="document">
                                                    <!--Content-->
                                                    <div class="modal-content text-center">
                                                        <!--Header-->
                                                        <div class="modal-header d-flex justify-content-center">
                                                            <h1 class="heading">Confirmation</h1>
                                                        </div>
                                                        <!--Body-->
                                                        <div class="modal-body">
                                                            <i class="fas fa-bell fa-4x animated rotateIn mb-4" style="color:#48ABF7"></i>
                                                            <h4>Permission Hours exceed 2 hours. It is considered as a Half-Day Leave.</h4>
                                                        </div>
                                                        <!--Footer-->
                                                        <div class="modal-footer flex-center">
                                                            <input type="submit" name="submit" value="YES" class="btn btn-info">
                                                            <input type="submit" name="submit" value="NO" class="btn btn-outline-info waves-effect" data-dismiss="modal" onclick="closePopup()">
                                                        </div>
                                                    </div>
                                                    <!--/.Content-->
                                                </div>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- CALCULATE THE BOTH TIME  -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Get current date
            const currentDate = new Date();
            const currentDateString = currentDate.toISOString().split('T')[0]; // Get current date in 'YYYY-MM-DD' format

            // Initialize Flatpickr for time input
            const timepickerOptions = {
                enableTime: true,
                noCalendar: true,
                dateFormat: 'h:i K', // Updated format for 12-hour time
                time_24hr: false, // Set to false for 12-hour time
                onClose: function(selectedDates, dateStr, instance) {
                    updateHourDifference();
                },
                onChange: function(selectedDates, dateStr, instance) {
                    updateHourDifference();
                },
                defaultDate: currentDate, // Set defaultDate to current time
                disableMobile: true,

            };

            // Check if the selected date is the current date
            const fromDateInput = document.getElementById('from_date');
            if (fromDateInput.value === currentDateString) {
                timepickerOptions.minTime = currentDate.getHours() + ':' + currentDate.getMinutes(); // Set minTime to current time
            }

            const timepickers = flatpickr('.timepicker', timepickerOptions);

            // Event listener for date input change
            fromDateInput.addEventListener('change', function() {
                const selectedDate = this.value;
                if (selectedDate !== currentDateString) {
                    // If the selected date is not the current date, remove the minTime option and update hours to "00:00"
                    timepickers.forEach(function(instance) {
                        instance.set('minTime', null);
                        instance.setDate(selectedDate + ' 09:00 AM', false); // Set timepicker to selected date
                    });
                    document.getElementsByName('hour')[0].value = '00:00'; // Update hours value
                } else {
                    // If the selected date is the current date, set the minTime option to the current time
                    timepickers.forEach(function(instance) {
                        instance.set('minTime', currentDate.getHours() + ':' + currentDate.getMinutes());
                        instance.setDate(currentDate, false); // Set timepicker to current date
                    });
                    document.getElementsByName('hour')[0].value = '00:00'; // Update hours value
                }
            });

            // Function to calculate time difference
            function updateHourDifference() {
                const start_time = document.getElementsByName('start_time')[0].value;
                const end_time = document.getElementsByName('end_time')[0].value;

                if (start_time && end_time) {
                    const startTime = moment(start_time, 'h:mm A');
                    const endTime = moment(end_time, 'h:mm A');

                    if (endTime.isBefore(startTime)) {
                        endTime.add(1, 'day'); // If end time is before start time, add a day to end time
                    }

                    const duration = moment.duration(endTime.diff(startTime));
                    const hours = Math.floor(duration.asHours());
                    const minutes = duration.minutes();

                    // Format the result to HH:mm
                    const formattedHours = (hours < 10 ? '0' : '') + hours + ':' + (minutes < 10 ? '0' : '') + minutes;

                    document.getElementsByName('hour')[0].value = formattedHours;
                } else {
                    // If start time and end time are the same or one of them is empty, display '00:00'
                    document.getElementsByName('hour')[0].value = start_time === end_time ? '00:00' : '';
                }
            }

            // Calculate hour difference initially
            updateHourDifference();
        });
    </script>

    <!-- FROM AND TO TIME MUST NOT SAME -->
    <script>
        function saveDetails(hourValue) {
            // You can replace this alert with your code for saving the details
            document.getElementById("validate").submit();
        }

        // Add an event listener to the "saveButton" element
        document.getElementById("saveButton").addEventListener("click", function(event) {
            var hourValue = document.getElementById("hour").value;
            var hourParts = hourValue.split(":"); // Split the input value into hours and minutes
            var hours = parseInt(hourParts[0]);
            var minutes = parseInt(hourParts[1]);

            // Check if the value is equal to "00:00"
            if (hours === 0 && minutes === 0) {
                event.preventDefault();
                // Display an error message for "00:00" value
                alert("Please enter a valid time.");
            }
            // Check if the value is greater than 2 hours
            else if (hours > 2 || (hours === 2 && minutes > 0)) {
                event.preventDefault();
                // Display a Bootstrap modal alert with "Yes" and "No" buttons
                $('#modalPush').modal('show');
            } else {
                // Call the function to handle saving the details
                // event.preventDefault();

                saveDetails(hourValue);
            }
        });
    </script>

    <!-- CLOSE POPUP MODAL -->
    <script>
        function closePopup() {
            $('#modalPush').modal('hide'); // Hide the modal
        }
    </script>

    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>



    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>