<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Sewing Line Allocation</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.5.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.css">
<style>
    /* Loading and Blur Effects */
    .content-blur {
        filter: blur(4px);
        opacity: 0.6;
        pointer-events: none;
        transition: filter 0.3s ease, opacity 0.3s ease;
    }
    .loading-overlay {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(255, 255, 255, 0.8);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 1000;
    }
    .spinner {
        border: 4px solid rgba(0, 0, 0, 0.1);
        width: 36px;
        height: 36px;
        border-radius: 50%;
        border-left-color: #3b82f6;
        animation: spin 1s linear infinite;
    }
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
      .machine-allocation-row {
        animation: fadeIn 0.3s ease-in-out;
        position: relative;
    }
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .remove-machine-btn {
        transition: color 0.2s;
        background: none;
        border: none;
        cursor: pointer;
    }
    .remove-machine-btn:hover {
        color: #dc2626 !important;
    }
    
    /* Calendar highlighting styles */
    .current-date {
        background-color: #3b82f6 !important;
        color: white !important;
        border-radius: 4px;
    }
    .holiday-date {
        background-color: #EF4444 !important;
        color: white !important;
        border-radius: 4px;
    }
    .overtime-date {
        background-color: #a855f7 !important;
        color: white !important;
        border-radius: 4px;
    }
    .local-holiday-date {
        background-color: #f97316 !important;
        color: white !important;
        border-radius: 4px;
    }
    .local-overtime-date {
        background-color: #ec4899 !important;
        color: white !important;
        border-radius: 4px;
    }
    .calendar-day {
        cursor: pointer;
        transition: background-color 0.2s;
    }
    .calendar-day:hover {
        background-color: #e5e7eb;
    }
    .calendar-day.current-date:hover {
        background-color: #2563eb !important;
    }
    .calendar-day.holiday-date:hover {
        background-color: #db2777 !important;
    }
    .calendar-day.overtime-date:hover {
        background-color: #9333ea !important;
    }
    .calendar-day.local-holiday-date:hover {
        background-color: #ea580c !important;
    }
    .calendar-day.local-overtime-date:hover {
        background-color: #db2777 !important;
    }
    
    /* Dynamic sizing for allocated lines container */
    #allocatedlinescontainer {
        min-height: 13rem; /* 52px = 13rem */
        max-height: 30rem;
        transition: height 0.3s ease;
        overflow-y: auto;
    }
    
    /* Dynamic sizing for group edit modal */
	#groupedit {
		transition: height 0.35s ease;
		height: auto;                /* Allow natural height */
		min-height: 90vh;            /* Never exceed 90% of viewport */
		overflow-y: auto;            /* Scroll if it would exceed max-height */
		
	}

	/* Ensure the allocated lines container also grows/shrinks properly */
	#allocatedlinescontainer {
		min-height: 13rem;
		max-height: 30rem;
		transition: all 0.3s ease;
		overflow-y: auto;
		flex-shrink: 0; /* prevents it from shrinking too much */
	}

    #machineAllocations {
        max-height: 260px;      /* controls visible height inside popup */
        overflow-y: auto;       /* scroll when there are many rows */
        padding-right: 4px;     /* prevent scrollbar from overlapping content */
    }
</style>

</head>

<body class="bg-gray-100">

@include('LifeAtGainup.Planning.GUTplanning.Gutplan_nav')

<div class=" ms-4 px-4 py-2">
    <nav class="text-sm font-medium text-gray-500" aria-label="Breadcrumb">
        <ol class="list-none p-0 inline-flex">
            <li class="flex items-center">
                <a href="/gutplan" class="text-blue-600 hover:text-blue-800">Order Management</a>
                <svg class="fill-current w-3 h-3 mx-3" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M285.476 272.971L91.132 467.314c-9.373 9.373-24.569 9.373-33.941 0l-22.667-22.667c-9.357-9.357-9.375-24.522-.04-33.901L188.505 256 34.484 101.255c-9.335-9.379-9.317-24.544.04-33.901l22.667-22.667c9.373-9.373 24.569-9.373 33.941 0L285.475 239.03c9.373 9.372 9.373 24.568.001 33.941z"/></svg>
            </li>
            <li>
                <span class="text-gray-700">Capacity Allocation</span>
            </li>
        </ol>
    </nav>
</div>

<div class="p-6">

    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-3xl font-bold text-gray-800">Sewing Line Capacity Allocation</h1>
            <p class="text-gray-600">Create line groups, assign CCs, and allocate sewing lines</p>
        </div>
        <button class="hidden bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded">
            Factory Calendar
        </button>
    </div>

    <!-- Two Columns -->
    <div class="grid grid-cols-12 gap-6">

        <!-- LEFT SECTION - Unallocated Lines -->
        <div class="col-span-4">

            <!-- Modal Container -->
            <div class="bg-white rounded-lg border shadow-md p-6  mb-4 hidden" id="creategroup">

                <!-- Title -->
                <h2 class="text-2xl font-semibold mb-6">Create New Line Group</h2>

                <!-- Assign CC + Output side by side -->
                <div class="grid grid-cols-2 gap-6 mb-6">

                    <!-- Assign CC -->
                    <div>
                        <label class="block text-sm text-gray-700 mb-1">Assign CC No.</label>
                        <select
                            id="createGroupCCSelect"
                            class="w-full border border-gray-300 rounded-md px-3 py-2 text-gray-700
                                focus:ring-1 focus:ring-blue-400 focus:border-blue-400 outline-none"
                        >
                            <option value="">Select a CC</option>
                            <option value="114227">114227</option>
                            <option value="-">-</option>
                        </select>
                    </div>

                    <!-- Output / Layout (populated from layout_plan_details based on CC) -->
                    <div>
                        <label class="block text-sm text-gray-700 mb-1">Layout</label>
                        <select
                            id="createGroupLayoutSelect"
                            class="w-full border border-gray-300 rounded-md px-3 py-2 text-gray-700
                                focus:ring-1 focus:ring-blue-400 focus:border-blue-400 outline-none"
                        >
                            <option value="">Select Layout</option>
                        </select>
                    </div>

                </div>

                <!-- Group Name + Date Range -->
                <div class="grid grid-cols-2 gap-6 mb-10">

                    <!-- Group Name (auto-generated, read-only) -->
                    <div>
                        <label class="block text-sm text-gray-700 mb-1">Group Name</label>
                        <input
                            type="text"
                            id="createGroupNameInput"
                            readonly
                            placeholder="Group name"
                            class="w-full border border-gray-300 rounded-md px-3 py-2 text-gray-700 bg-gray-100
                                focus:ring-1 focus:ring-blue-400 focus:border-blue-400 outline-none"
                        />
                    </div>

                    <!-- Date Range -->
                    <div>
                        <label class="block text-sm text-gray-700 mb-1">Date Range</label>
                        <input
                            type="text"
                            id="groupDateRange"
                            placeholder="Select date range"
                            class="w-full border border-gray-300 rounded-md px-3 py-2 text-gray-700
                                focus:ring-1 focus:ring-blue-400 focus:border-blue-400 outline-none"
                        />
                    </div>

                </div>

                <!-- Footer Buttons -->
                <div class="flex justify-end items-center gap-6">

                    <!-- Cancel -->
                    <button class="text-gray-600 text-sm hover:text-gray-800" id="closeCreateGroupModal">
                        Cancel
                    </button>

                    <!-- Create Group -->
                    <button
                        id="createGroupSubmitButton"
                        class="px-5 py-2 rounded-md text-white text-sm 
                            bg-blue-500 hover:bg-blue-600 shadow-sm">
                        Create Group
                    </button>

                </div>

            </div>

            <!-- BIG CARD WRAPPER -->
            <div class="bg-white shadow-md rounded-lg p-5 max-h-[160vh] overflow-y-auto">

                <div class="flex justify-around mb-4">
                    
                    <h2 class="font-medium text-gray-700 text-lg">Unallocated Lines</h2>
                    <div class="flex justify-around gap-3">
                        <div class="relative">
                            <select id="unit_dropdown" class="px-3 py-1 bg-gray-200 rounded appearance-none pr-8">
                                <option value="">Select Unit</option>
                                <!-- Units will be populated by JavaScript -->
                            </select>
                            <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-700">
                                <i class="fa-solid fa-chevron-down"></i>
                            </div>
                        </div>
                        <button class="px-3 py-1 bg-gray-200 rounded-md text-sm hidden">+ Sewing Line</button>
                    </div>
                </div>

                <!-- LINE CARD LIST -->
                <div class="space-y-4">

                    <!-- Example: Buffer -->
                    <div class="bg-gray-50 p-4 rounded-lg shadow-sm border border-gray-200">
                        <div class="flex justify-between items-center">
                            <h3 class="font-medium">Buffer</h3>
                            <span class="text-sm text-gray-500">8 Machines</span>
                        </div>
                        <div class="flex items-center justify-end gap-3">
                            <i class="fa-solid fa-pen-to-square text-gray-600 text-lg cursor-pointer open-reallocate-pop open-reallocate-pop-buffer" data-target-line="Buffer" data-rowid="0"></i>


                        </div>


                        <div class="flex flex-wrap gap-2 mt-3">
                            <span class="px-2 py-1 bg-white border rounded text-xs">Single Needle Lock Stitch: 2</span>
                            <span class="px-2 py-1 bg-white border rounded text-xs">Over Lock Machine: 2</span>
                            <span class="px-2 py-1 bg-white border rounded text-xs">Flat Lock Machine: 2</span>
                            <span class="px-2 py-1 bg-white border rounded text-xs">Bar Tack Machine: 1</span>
                            <span class="px-2 py-1 bg-white border rounded text-xs">Chain Stitch Machine: 1</span>
                        </div>
                    </div>

                    

                </div>
            </div>
        </div>


        <!-- RIGHT SECTION - Sewing Line Groups -->
        <div class="col-span-8">

            <!-- BIG CARD WRAPPER -->
            <div class="bg-white shadow-md rounded-lg p-5">

                <div class="flex justify-between items-center mb-4">
                    <h2 class="font-medium text-gray-700 text-lg">Sewing Line Groups</h2>
                    <button class="px-3 py-1 bg-gray-200 rounded-md text-sm" id="creategroup-button">+ Line Group</button>
                </div>

                <div class="space-y-4" id="sewingLineGroupsContainer">

                    <!-- Group Card 1 -->
                    <div class="bg-gray-50 border border-gray-200 rounded-md p-4 flex justify-between items-center shadow-sm" data-group-name="SLG-1">
                        <div>
                            <h3 class="font-medium">SLG-1</h3>
                            <p class="text-gray-500 text-sm">CC: 114227</p>
                            <p class="text-gray-500 text-xs mt-1 group-output-label">1x Layout</p>
                        </div>

                        <div class="flex items-center gap-3">
                            <button class="text-blue-500 hover:text-blue-700">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </button>
                            <button class="text-gray-500 hover:text-gray-700">
                                <i class="fa-solid fa-arrow-right open-groupedit-pop" data-group-name="SLG-1" data-group-cc="114227"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Group Card 2 -->
                    <div class="bg-gray-50 border border-gray-200 rounded-md p-4 flex justify-between items-center shadow-sm" data-group-name="SLG-2">
                        <div>
                            <h3 class="font-medium">SLG-2</h3>
                            <p class="text-gray-500 text-sm">CC: -</p>
                            <p class="text-gray-500 text-xs mt-1 group-output-label">1x Layout</p>
                        </div>

                        <div class="flex items-center gap-3">
                            <button class="text-blue-500 hover:text-blue-700">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </button>
                            <button class="text-gray-500 hover:text-gray-700">
                                <i class="fa-solid fa-arrow-right open-groupedit-pop" data-group-name="SLG-2" data-group-cc="-"></i>
                            </button>
                        </div>
                    </div>

                </div>

            </div>

            <div class="bg-white border rounded-lg p-6 shadow-md mt-4 hidden" id="groupedit">  <!-- ADDED shadow -->

                <!-- Header + Buttons -->
                <div class="flex justify-between items-start mb-4">

                    <div>
                        <h2 class="text-2xl font-semibold">Details for <span id="groupEditName">SLG-1</span></h2>
                        <p class="text-gray-500 text-sm">CC No: <span id="groupEditCC">114227</span></p>
                    </div>

                    <div class="flex items-center gap-3">

                        <button class="flex items-center gap-2 px-4 py-2 border rounded-md text-sm hover:bg-gray-50 shadow-sm">
                            <i class="fa-regular fa-calendar"></i>
                            SLG Calendar
                        </button>

                        <select id="groupEditOutputSelect" class="px-3 py-2 border rounded-md text-sm focus:ring-1 focus:ring-blue-400 shadow-sm cursor-not-allowed" disabled>
                            <option value="1">1X Layout</option>
                            <option value="2">2X Layout</option>
                            <option value="3">3X Layout</option>
                            <option value="4">4X Layout</option>
                            <option value="5">5X Layout</option>
                        </select>

                        <button class="px-4 py-2 border rounded-md text-sm hover:bg-gray-50 flex items-center gap-2 shadow-sm" id="closeGroupEditModal">
                            <i class="fa-solid fa-xmark"></i>
                            Cancel
                        </button>

                        <button id="saveallocationbutton" class="px-5 py-2 bg-blue-500 text-white rounded-md text-sm hover:bg-blue-600 flex items-center gap-2 shadow-sm">
                            <i class="fa-regular fa-floppy-disk"></i>
                            Save
                        </button>
                    </div>
                </div>

                <!-- Machine Requirements vs Allocated -->
                <h3 class="text-gray-800 font-medium mb-3">Machine Requirements vs. Allocated</h3>

                <div class="grid grid-cols-4 gap-4">

                    <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4 shadow-sm">
                        <p class="text-gray-600 text-sm mb-1">Chain Stitch Machine</p>
                        <p class="text-xl font-semibold">0 <span class="text-gray-500 text-base font-normal">/ 4</span></p>
                    </div>

                    <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4 shadow-sm">
                        <p class="text-gray-600 text-sm mb-1">Flat Lock Machine</p>
                        <p class="text-xl font-semibold">0 <span class="text-gray-500 text-base font-normal">/ 2</span></p>
                    </div>

                    <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4 shadow-sm">
                        <p class="text-gray-600 text-sm mb-1">Over Lock Machine</p>
                        <p class="text-xl font-semibold">0 <span class="text-gray-500 text-base font-normal">/ 8</span></p>
                    </div>

                    <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4 shadow-sm">
                        <p class="text-gray-600 text-sm mb-1">Single Needle Lock Stitch</p>
                        <p class="text-xl font-semibold">0 <span class="text-gray-500 text-base font-normal">/ 9</span></p>
                    </div>

                </div>

                <!-- Allocated Lines -->
                <h3 class="text-gray-800 font-medium mt-6 mb-2">Allocated Lines</h3>

                <div class="border rounded-lg h-52 bg-gray-50 shadow-inner" id="allocatedlinescontainer"></div>  <!-- Soft inner shadow -->

            </div>

        </div>


    </div>

</div>

    <!-- Modal Background -->
    <div class="fixed inset-0 bg-black bg-opacity-40 flex items-center justify-center z-50 hidden" id="createline">

        <!-- Modal Card -->
        <div class="bg-white rounded-lg shadow-xl w-[700px] p-6">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-xl font-semibold">Create New Sewing Line</h2>
                <button class="text-gray-500 hover:text-gray-700" id="closeCreateLineModal">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>


            <!-- Subtext -->
            <p class="text-gray-500 text-sm mb-6">
                Combine machines from existing lines to form a new, dedicated sewing line.
            </p>

            <!-- New Line Name -->
            <label class="block text-gray-700 text-sm font-medium mb-1">New Line Name</label>
            <input
                type="text"
                id="createLineNameInput"
                placeholder="Line 7"
                class="w-full border border-gray-300 rounded-md px-3 py-2 focus:ring-1 focus:ring-blue-400 focus:border-blue-400 outline-none mb-6"
            />

            <!-- Machine Transfers Title -->
            <h3 class="text-gray-700 font-medium mb-2">Machine Transfers</h3>

            <!-- Machine Transfer Box -->
            <div class="border border-gray-200 rounded-md p-4 mb-3">

                <!-- Row -->
                <div class="grid grid-cols-12 gap-3 items-center">

                    <!-- Source Line -->
                    <div class="col-span-4">
                        <label class="text-sm text-gray-500">Source Line</label>
                        <select class="w-full border-gray-300 rounded-md px-3 py-2 mt-1 focus:ring-1 focus:ring-blue-400">
                            <option value="">Select Source</option>
                            <option value="Line 1">Line 1</option>
                            <option value="Line 2">Line 2</option>
                            <option value="Line 3">Line 3</option>
                            <option value="Line 4">Line 4</option>
                            <option value="Line 5">Line 5</option>
                            <option value="Line 6">Line 6</option>
                        </select>
                    </div>

                    <!-- Machine Type -->
                    <div class="col-span-4">
                        <label class="text-sm text-gray-500">Machine Type</label>
                        <select class="w-full border-gray-300 rounded-md px-3 py-2 mt-1 focus:ring-1 focus:ring-blue-400">
                            <option value="">Select Type</option>
                            <option value="Single Needle Lock Stitch">Single Needle Lock Stitch</option>
                            <option value="Over Lock Machine">Over Lock Machine</option>
                            <option value="Flat Lock Machine">Flat Lock Machine</option>
                            <option value="Bar Tack Machine">Bar Tack Machine</option>
                            <option value="Chain Stitch Machine">Chain Stitch Machine</option>
                        </select>
                    </div>

                    <!-- Quantity -->
                    <div class="col-span-3">
                        <label class="text-sm text-gray-500">Quantity</label>
                        <input
                            type="number"
                            value="1"
                            class="w-full border border-gray-300 rounded-md px-3 py-2 mt-1 focus:ring-1 focus:ring-blue-400"
                        />
                    </div>

                    <!-- Delete Icon -->
                    <div class="col-span-1 flex justify-center mt-6">
                        <button class="text-red-500 hover:text-red-700">
                            <i class="fa-solid fa-xmark text-lg"></i>
                        </button>
                    </div>

                </div>
            </div>

            <!-- Add Source -->
            <button class="text-blue-600 text-sm flex items-center gap-1 mb-6">
                <i class="fa-solid fa-plus"></i> Add Source
            </button>

            <!-- Footer Buttons -->
            <div class="flex justify-end gap-3">
                <button class="px-4 py-2 border border-gray-300 rounded-md hover:bg-gray-100">
                    Cancel
                </button>
                <button id="createLineSubmitButton" class="px-5 py-2 bg-blue-500 text-white rounded-md hover:bg-blue-600">
                    Create Line
                </button>
            </div>

        </div>
    </div>

    <!-- Modal Background -->
    <div class="fixed inset-0 bg-black bg-opacity-40 flex items-center justify-center z-50 hidden" id="reallocatepop">

        <!-- Modal Box -->
        <div class="bg-white rounded-lg shadow-lg w-[700px] p-6">

            <!-- Header -->
            <div class="flex justify-between items-start mb-2">
                <div>
                    <h2 class="text-xl font-semibold">Re-allocate Machines to <span id="targetLineTitle">Buffer</span></h2>
                    <p class="text-gray-500 text-sm">Move machines from a source line to this target line.</p>
                </div>

                <button class="text-gray-500 hover:text-gray-700" id="closeReallocatePopModal">
                    <i class="fa-solid fa-xmark text-xl"></i>
                </button>
            </div>

            <!-- Form Section -->
            <div class="grid grid-cols-2 gap-6 mt-6">

                <!-- Source Line -->
                <div>
                    <label class="block text-sm text-gray-700 mb-1">Source Line</label>
                    <select id="sourceLineSelect" 
                        class="w-full border border-gray-300 rounded-md px-3 py-2 text-gray-700 
                            focus:ring-1 focus:ring-blue-400 focus:border-blue-400 outline-none"
                    >
                        <option>Select Source</option>
                    </select>
                </div>

                <!-- Target Line -->
                <div>
                    <label class="block text-sm text-gray-700 mb-1">Target Line</label>

                    <div class="flex items-center gap-3">

                        <!-- Arrow -->
                        <div class="text-gray-400 text-xl">
                            <i class="fa-solid fa-arrow-right"></i>
                        </div>

                        <!-- Target disabled input -->
                        <input
                            type="text"
                            id="targetLineInput"
                            value="Buffer"
                            disabled
                            class="w-full border border-gray-300 rounded-md px-3 py-2 bg-gray-100 text-gray-600"
                        />
                    </div>
                </div>

            </div>

            <!-- Machine Type + Quantity -->
            <div class=" mt-6">

                <h3 class="font-medium text-gray-700 mb-3">Machine Allocations</h3>
    
                <!-- Machine allocations container -->
                <div id="machineAllocations">
                    <!-- Machine allocation rows will be added here -->
                </div>

                <!-- Add Machine button -->
                <button type="button" id="addMachineBtn" class="mt-3 flex items-center text-blue-500 hover:text-blue-700 text-sm">
                    <i class="fa-solid fa-plus-circle mr-1"></i> Add Machine
                </button>

                <!-- Template for new machine allocation row (hidden by default) -->
                <template id="machineAllocationTemplate">
                    <div class="machine-allocation-row grid grid-cols-2 gap-6 mt-4">
                        <div>
                            <label class="block text-sm text-gray-700 mb-1">Machine Type</label>
                            <select class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm text-gray-700 focus:ring-1 focus:ring-blue-400 focus:border-blue-400 outline-none machine-type-select">
                                <option value="">Select Machine Type</option>
                                <!-- Options will be populated by JavaScript -->
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm text-gray-700 mb-1">Quantity</label>
                            <div class="flex items-center gap-2">
                                <input type="number" min="1" value="1" class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm text-gray-700 focus:ring-1 focus:ring-blue-400 focus:border-blue-400 outline-none quantity-input">
                                <button type="button" class="remove-machine-btn text-red-500 hover:text-red-700 p-1">
                                    <i class="fa-solid fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </template>

            </div>

            <!-- Buttons -->
            <div class="flex justify-end mt-10 gap-4">

                <!-- Cancel -->
                <button id="cancelReallocateBtn" class="px-4 py-2 rounded-md border border-gray-300 text-gray-700 hover:bg-gray-100">
                    Cancel
                </button>

                <!-- Confirm & Move -->
                <button id="confirmMoveBtn" 
                    class="px-5 py-2 rounded-md bg-blue-500 text-white hover:bg-blue-600 shadow-sm"
                >
                    Confirm & Move
                </button>

            </div>

        </div>

    </div>

    <!-- Modal Background -->
    <div class="fixed inset-0 bg-black bg-opacity-40 flex items-center justify-center z-50 hidden" id="calenderpop">

        <!-- Modal Box -->
        <div class="bg-white rounded-lg shadow-xl w-[900px] p-6">

            <!-- Header -->
            <div class="flex justify-between items-start">
                <div>
                    <h2 class="text-xl font-semibold">Manage Factory Calendar</h2>
                    <p class="text-gray-500 text-sm">
                        Select dates for factory-wide holidays and overtime.
                    </p>
                </div>

                <!-- Dropdown -->
                <div class="relative">
                    <select id="factorySettingDropdown"
                        class="border border-gray-300 rounded-md px-3 py-2 text-sm shadow-sm 
                            focus:ring-1 focus:ring-blue-400 focus:border-blue-400"
                    >
                        <option value="">Select Setting</option>
                        <option value="holiday">Setting Holidays</option>
                        <option value="overtime">Setting Overtime</option>
                    </select>
                </div>
            </div>

            <!-- Calendar Section -->
            <div class="mt-6 grid grid-cols-2 gap-6">

                <!-- Left Calendar -->
                <div>

                    <!-- Calendar Header -->
                    <div class="flex items-center gap-3 mb-4">
                        <button class="border px-2 py-1 rounded-md" id="factoryCalPrev">
                            <i class="fa-solid fa-chevron-left text-gray-600"></i>
                        </button>
                        <h3 class="text-gray-700 font-medium" id="factoryCalLeftMonth">November 2025</h3>
                        <button class="border px-2 py-1 rounded-md" id="factoryCalNext">
                            <i class="fa-solid fa-chevron-right text-gray-600"></i>
                        </button>
                    </div>

                    <!-- Weekdays -->
                    <div class="grid grid-cols-7 text-center text-gray-500 text-sm mb-2">
                        <div>Su</div><div>Mo</div><div>Tu</div><div>We</div><div>Th</div><div>Fr</div><div>Sa</div>
                    </div>

                    <!-- Days Grid -->
                    <div class="grid grid-cols-7 text-center text-gray-700 gap-y-2" id="factoryCalLeftDays">
                    </div>
                </div>

                <!-- Right Calendar -->
                <div>

                    <!-- Calendar Header -->
                    <div class="flex items-center gap-3 mb-4 justify-end">
                        <h3 class="text-gray-700 font-medium" id="factoryCalRightMonth">December 2025</h3>
                    </div>

                    <!-- Weekdays -->
                    <div class="grid grid-cols-7 text-center text-gray-500 text-sm mb-2">
                        <div>Su</div><div>Mo</div><div>Tu</div><div>We</div><div>Th</div><div>Fr</div><div>Sa</div>
                    </div>

                    <!-- Days Grid -->
                    <div class="grid grid-cols-7 text-center text-gray-700 gap-y-2" id="factoryCalRightDays">
                    </div>
                </div>

            </div>

            <!-- Legend -->
            <div class="flex items-center gap-6 mt-6 px-2">
                <div class="flex items-center gap-2">
                    <span class="w-3 h-3 bg-red-500 rounded-full"></span>
                    <span class="text-gray-700 text-sm">Holiday</span>
                </div>

                <div class="flex items-center gap-2">
                    <span class="w-3 h-3 bg-purple-500 rounded-full"></span>
                    <span class="text-gray-700 text-sm">Overtime</span>
                </div>
            </div>

            <!-- Buttons -->
            <div class="flex justify-end mt-10 gap-4">
                <button class="px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-100">
                    Cancel
                </button>
                <button id="factoryCalendarConfirmBtn" class="px-5 py-2 bg-blue-500 text-white rounded-md hover:bg-blue-600 shadow-sm">
                    Confirm
                </button>
            </div>

        </div>

    </div>

    <!-- SLG Modal Background -->
    <div class="fixed inset-0 bg-black bg-opacity-40 flex items-center justify-center z-50 hidden" id="slgcalenderpop">

        <!-- Modal Box -->
        <div class="bg-white rounded-lg shadow-xl w-[900px] p-6">

            <!-- Header -->
            <div class="flex justify-between items-start">
                <div>
                    <div class="flex items-baseline gap-2">
                        <h2 id="slgCalendarTitle" class="text-xl font-semibold">Manage SLG Calendar for SLG-1</h2>
                        <span id="slgCalendarRangeLabel" class="text-sm text-gray-500"></span>
                    </div>
                    <p class="text-gray-500 text-sm">
                        Set group-specific holidays or overtime. Global dates are shown for context.
                    </p>
                </div>

                <!-- Dropdown -->
                <select id="slgSettingDropdown"
                    class="border border-gray-300 rounded-md px-3 py-2 text-sm shadow-sm
                        focus:ring-1 focus:ring-blue-400 focus:border-blue-400"
                >
                    <option value="">Select Setting</option>
                    <option value="holiday">Setting Holidays</option>
                    <option value="overtime">Setting Overtime</option>
                </select>
            </div>

            <!-- Calendar Section -->
            <div class="mt-6 grid grid-cols-2 gap-6">

                <!-- Left Calendar -->
                <div>

                    <!-- Header -->
                    <div class="flex items-center gap-3 mb-4">
                        <button class="border px-2 py-1 rounded-md" id="slgCalPrev">
                            <i class="fa-solid fa-chevron-left text-gray-600"></i>
                        </button>
                        <h3 class="text-gray-700 font-medium" id="slgCalLeftMonth">November 2025</h3>
                        <button class="border px-2 py-1 rounded-md" id="slgCalNext">
                            <i class="fa-solid fa-chevron-right text-gray-600"></i>
                        </button>
                    </div>

                    <!-- Weekdays -->
                    <div class="grid grid-cols-7 text-center text-gray-500 text-sm mb-2">
                        <div>Su</div><div>Mo</div><div>Tu</div><div>We</div>
                        <div>Th</div><div>Fr</div><div>Sa</div>
                    </div>

                    <!-- Days -->
                    <div class="grid grid-cols-7 text-center text-gray-700 gap-y-2" id="slgCalLeftDays">
                    </div>
                </div>

                <!-- Right Calendar -->
                <div>

                    <!-- Header -->
                    <h3 class="text-gray-700 font-medium mb-4" id="slgCalRightMonth">December 2025</h3>

                    <!-- Weekdays -->
                    <div class="grid grid-cols-7 text-center text-gray-500 text-sm mb-2">
                        <div>Su</div><div>Mo</div><div>Tu</div><div>We</div>
                        <div>Th</div><div>Fr</div><div>Sa</div>
                    </div>

                    <!-- Days -->
                    <div class="grid grid-cols-7 text-center text-gray-700 gap-y-2" id="slgCalRightDays">
                    </div>

                </div>

            </div>

            <!-- Legend -->
            <div class="flex items-center gap-8 mt-6">
                <div class="flex items-center gap-2">
                    <span class="w-3 h-3 bg-red-500 rounded-full"></span>
                    <span class="text-sm text-gray-700">Global Holiday</span>
                </div>

                <div class="flex items-center gap-2">
                    <span class="w-3 h-3 bg-purple-500 rounded-full"></span>
                    <span class="text-sm text-gray-700">Global Overtime</span>
                </div>

                <div class="flex items-center gap-2">
                    <span class="w-3 h-3 bg-orange-500 rounded-full"></span>
                    <span class="text-sm text-gray-700">Local Holiday</span>
                </div>

                <div class="flex items-center gap-2">
                    <span class="w-3 h-3 bg-pink-500 rounded-full"></span>
                    <span class="text-sm text-gray-700">Local Overtime</span>
                </div>
            </div>

            <!-- Footer -->
            <div class="flex justify-end mt-10 gap-4">
                <button class="px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-100">
                    Cancel
                </button>
                <button id="slgCalendarConfirmBtn" class="px-5 py-2 rounded-md bg-blue-500 text-white hover:bg-blue-600 shadow-sm">
                    Confirm
                </button>
            </div>

        </div>

    </div>

    <!-- Line Group Delete Confirmation Modal -->
    <div id="lineGroupDeleteModal" class="fixed inset-0 bg-black bg-opacity-40 flex items-center justify-center z-50 hidden">
        <div class="bg-white rounded-lg shadow-xl w-full max-w-md p-6">
            <h2 class="text-lg font-semibold text-gray-800 mb-4">Delete Line Group</h2>
            <p id="lineGroupDeleteMessage" class="text-sm text-gray-700 mb-6">
                Are you sure you want to delete this line group?
            </p>
            <div class="flex justify-end gap-3">
                <button id="lineGroupDeleteCancelBtn" class="px-4 py-2 rounded-md border border-gray-300 text-gray-700 hover:bg-gray-100">
                    No
                </button>
                <button id="lineGroupDeleteConfirmBtn" class="px-4 py-2 rounded-md bg-red-500 text-white hover:bg-red-600">
                    Yes, Delete
                </button>
            </div>
        </div>
    </div>





 </body>
<script src="https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<script>
    //Global variables
    let currentSelectedUnit = '';
    let activeGroupName = '';
    let activeGroupId = '';
    let groupEditModal = null;
    let groupEditCC = null;
    let groupEditOutputSelect = null;
    let reallocatePopModal = null;
    let targetLineTitle = null;
    let targetLineInput = null;

    // Pending delete state for line group delete confirmation modal
    let pendingDeleteCard = null;
    let pendingDeleteGroupId = '';
    let pendingDeleteGroupName = '';

    function formatToDDMMYY(dateStr) {
        if (!dateStr) return '';
        const [y, m, d] = dateStr.split('-');
        return `${d}-${m}-${y.slice(2)}`;
    }

    // Check if groupedit modal is visible and control allocate buttons accordingly
    function updateAllocateButtonsBasedOnGroupEditVisibility() {
        const groupEditModal = document.getElementById('groupedit');
        const allocateButtons = document.querySelectorAll('.allocate-button');
        
        if (!groupEditModal) return;
        
        const isModalVisible = !groupEditModal.classList.contains('hidden');
        
        allocateButtons.forEach(btn => {
            const lineName = btn.getAttribute('data-line-name') || '';
            
            if (isModalVisible) {
                // Modal is visible - enable buttons (except already allocated lines)
                let isAlreadyAllocated = false;
                const allocatedBox = groupEditModal.querySelector('h3.text-gray-800.font-medium.mt-6.mb-2 + div.border');
                if (allocatedBox && lineName) {
                    const allocatedHeaders = allocatedBox.querySelectorAll('div.flex.justify-between.items-center h3.font-medium');
                    allocatedHeaders.forEach(h3 => {
                        if (h3.textContent.trim() === lineName) {
                            isAlreadyAllocated = true;
                        }
                    });
                }
                
                if (isAlreadyAllocated) {
                    btn.disabled = true;
                    btn.classList.remove('bg-blue-500','text-white','hover:bg-blue-600','cursor-pointer');
                    btn.classList.add('bg-gray-300','text-gray-500','cursor-not-allowed');
                } else {
                    btn.disabled = false;
                    btn.classList.remove('bg-gray-300','text-gray-500','cursor-not-allowed');
                    btn.classList.add('bg-blue-500','text-white','hover:bg-blue-600','cursor-pointer');
                }
            } else {
                // Modal is hidden - disable all buttons
                btn.disabled = true;
                btn.classList.remove('bg-blue-500','text-white','hover:bg-blue-600','cursor-pointer');
                btn.classList.add('bg-gray-300','text-gray-500','cursor-not-allowed');
            }
        });
    }

    document.addEventListener('DOMContentLoaded', function() {
        // Factory Calendar popup (select first blue button with bold text as Factory Calendar)
        const factoryCalendarButton = document.querySelector('button.bg-blue-500.text-white.font-bold.py-2.px-4.rounded');
        const calendarPopModal = document.getElementById('calenderpop');
        const calendarCancelButton = calendarPopModal ? calendarPopModal.querySelector('button.px-4.py-2.border.border-gray-300.rounded-md.text-gray-700') : null;

        // SLG Calendar popup (button inside #groupedit header)
        const slgCalendarButton = document.querySelector('#groupedit button.flex.items-center.gap-2.px-4.py-2.border.rounded-md.text-sm');
        const slgCalendarPopModal = document.getElementById('slgcalenderpop');
        const slgCalendarCancelButton = slgCalendarPopModal ? slgCalendarPopModal.querySelector('button.px-4.py-2.border.border-gray-300.rounded-md.text-gray-700') : null;
        const slgCalendarTitle = document.getElementById('slgCalendarTitle');
        const slgCalendarRangeLabel = document.getElementById('slgCalendarRangeLabel');

        // createline popup
        const createLineButton = document.querySelector('button.px-3.py-1.bg-gray-200.rounded-md.text-sm');
        const createLineModal = document.getElementById('createline');
        const closeCreateLineModalButton = document.getElementById('closeCreateLineModal');
        const createLineNameInput = document.getElementById('createLineNameInput');
        const createLineSubmitButton = document.getElementById('createLineSubmitButton');
        const unallocatedLinesContainer = document.querySelector('#createline')

        if (createLineButton && createLineModal) {
            createLineButton.addEventListener('click', function() {
                createLineModal.classList.remove('hidden');
            });
        }

        if (factoryCalendarButton && calendarPopModal) {
            factoryCalendarButton.addEventListener('click', function() {
                calendarPopModal.classList.remove('hidden');
            });
        }

        if (closeCreateLineModalButton && createLineModal) {
            closeCreateLineModalButton.addEventListener('click', function() {
                createLineModal.classList.add('hidden');
            });
        }

        if (calendarCancelButton && calendarPopModal) {
            calendarCancelButton.addEventListener('click', function() {
                calendarPopModal.classList.add('hidden');
            });
        }

        if (slgCalendarButton && slgCalendarPopModal) {
            slgCalendarButton.addEventListener('click', function() {
                slgCalendarPopModal.classList.remove('hidden');

                // Update SLG calendar title with active group name
                if (slgCalendarTitle && window.activeGroupName) {
                    slgCalendarTitle.textContent = `Manage SLG Calendar for ${window.activeGroupName}`;
                }

                // Show active group date range in grey text, if available
                if (slgCalendarRangeLabel) {
                    if (window.activeGroupFromDate && window.activeGroupToDate) {

                        const from = formatToDDMMYY(window.activeGroupFromDate);
                        const to   = formatToDDMMYY(window.activeGroupToDate);

                        slgCalendarRangeLabel.textContent = `(${from} to ${to})`;

                    } else {
                        slgCalendarRangeLabel.textContent = '';
                    }
                }

                // All calendar rendering & wiring is handled in the dedicated
                // SLG calendar initialization block further below.
            });
        }

        if (slgCalendarCancelButton && slgCalendarPopModal) {
            slgCalendarCancelButton.addEventListener('click', function() {
                slgCalendarPopModal.classList.add('hidden');

                // When SLG modal is closed, clear current selections/highlights
                if (typeof resetSlgSelections === 'function') {
                    resetSlgSelections();
                }
            });
        }

        // Create Line: add new unallocated line card + increment line name
        if (createLineSubmitButton && createLineNameInput) {
            createLineSubmitButton.addEventListener('click', function() {
                const lineName = createLineNameInput.value.trim();
                if (!lineName) {
                    return;
                }

                // Find the Unallocated Lines card list container (the first space-y-4 under Unallocated Lines)
                const unallocatedWrapper = document.querySelector('h2.font-medium.text-gray-700.text-lg:nth-of-type(1)');
                let listContainer = null;
                if (unallocatedWrapper) {
                    const parent = unallocatedWrapper.closest('div.bg-white.shadow-md.rounded-lg.p-5');
                    if (parent) {
                        listContainer = parent.querySelector('div.space-y-4');
                    }
                }

                if (!listContainer) {
                    return;
                }

                const wrapper = document.createElement('div');
                wrapper.className = 'bg-gray-50 p-4 rounded-lg shadow-sm border border-gray-200';
                wrapper.innerHTML = `
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium">${lineName}</h3>
                        <span class="text-sm text-gray-500">8 Machines</span>
                    </div>
                    <div class="flex items-center justify-end gap-3">
                        <i class="fa-solid fa-pen-to-square text-gray-600 text-lg cursor-pointer open-reallocate-pop" data-target-line="${lineName}"></i>

                        <button
                            class="allocate-button bg-gray-300 text-gray-500 px-3 py-2 rounded-md text-sm cursor-not-allowed"
                            data-line-name="${lineName}"
                            disabled
                        >
                            Allocate
                        </button>
                    </div>
                `;

                listContainer.appendChild(wrapper);

                // Wire reallocate popup for the new line icon
                const newPen = wrapper.querySelector('.open-reallocate-pop');
                if (newPen && reallocatePopModal) {
                    newPen.addEventListener('click', function() {
                        const targetLine = this.getAttribute('data-target-line') || '';

                        if (targetLineTitle) {
                            targetLineTitle.textContent = targetLine;
                        }

                        if (targetLineInput) {
                            targetLineInput.value = targetLine;
                        }

                        reallocatePopModal.classList.remove('hidden');
                    });
                }

                // Wire Allocate button for this new line
                const newAllocateBtn = wrapper.querySelector('.allocate-button');
                if (newAllocateBtn) {
                    attachAllocateHandler(newAllocateBtn);
                }

                // Auto-increment line name (e.g., Line 7 -> Line 8)
                const matchLine = lineName.match(/^(.*?)(\d+)$/);
                if (matchLine) {
                    const prefix = matchLine[1];
                    const num = parseInt(matchLine[2], 10) + 1;
                    createLineNameInput.value = `${prefix}${num}`;
                }

                // Optionally keep modal open as in the design; comment next line if you want it to stay open
                // createLineModal.classList.add('hidden');
            });
        }

        // groupedit popup (dynamic group info)
        const groupEditButtons = document.querySelectorAll('.open-groupedit-pop');
        groupEditModal = document.getElementById('groupedit');
        const closeGroupEditModalButton = document.getElementById('closeGroupEditModal');
        const groupEditName = document.getElementById('groupEditName');
        groupEditCC = document.getElementById('groupEditCC');
        groupEditOutputSelect = document.getElementById('groupEditOutputSelect');

        // Store base machine requirements for scaling (1x values)
        const machineRequirementCards = groupEditModal ? groupEditModal.querySelectorAll('.grid.grid-cols-4.gap-4 .bg-yellow-50') : [];
        const baseRequirements = [];
        if (machineRequirementCards && machineRequirementCards.length === 4) {
            machineRequirementCards.forEach(card => {
                const span = card.querySelector('p.text-xl span.text-gray-500');
                if (!span) return;
                const text = span.textContent || '';
                const parts = text.split('/');
                const val = parts.length === 2 ? parseInt(parts[1], 10) : NaN;
                baseRequirements.push(isNaN(val) ? 0 : val);
            });
        }

        // Helper: apply an output multiplier (1�5) to the 4 cards
        function applyOutputMultiplier(multiplier) {
            if (!machineRequirementCards || baseRequirements.length !== machineRequirementCards.length) return;
            machineRequirementCards.forEach((card, index) => {
                const base = baseRequirements[index];
                const span = card.querySelector('p.text-xl span.text-gray-500');
                if (!span) return;
                const scaled = base * multiplier;
                span.textContent = ` / ${scaled}`;
            });
        }

        // Track which group card is currently being edited
        let activeGroupCard = null;

        if (groupEditButtons && groupEditModal) {
            groupEditButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const groupName = this.getAttribute('data-group-name') || '';
                    const groupCC = this.getAttribute('data-group-cc') || '';
                    const groupId = this.getAttribute('data-group-id') || '';

                    activeGroupName = groupName;
                    activeGroupId = groupId;

                    if (groupEditName) {
                        groupEditName.textContent = groupName;
                    }

                    if (groupEditCC) {
                        groupEditCC.textContent = groupCC;
                    }

                    // Remember which card this group belongs to (for updating its output label)
                    activeGroupCard = null;
                    const allGroupCards = document.querySelectorAll('#sewingLineGroupsContainer > div.bg-gray-50');
                    allGroupCards.forEach(card => {
                        const title = card.querySelector('h3.font-medium');
                        if (title && title.textContent.trim() === groupName) {
                            activeGroupCard = card;
                        }
                    });

                    // Sync dropdown with that card's current label (default 1x if missing)
                    if (groupEditOutputSelect) {
                        let currentMultiplier = 1;
                        if (activeGroupCard) {
                            const label = activeGroupCard.querySelector('.group-output-label');
                            if (label) {
                                const txt = label.textContent.trim();
                                const m = txt.match(/(\d+)x/);
                                if (m) {
                                    currentMultiplier = parseInt(m[1], 10) || 1;
                                }
                            }
                        }
                    }
                })
            });
        }

        if (closeGroupEditModalButton && groupEditModal) {
            closeGroupEditModalButton.addEventListener('click', function() {
                groupEditModal.classList.add('hidden');
				// Clear allocated box contents when closing the modal
             
                let allocatedContainer = document.getElementById('allocatedlinescontainer');
                if (allocatedContainer) {
                    allocatedContainer.innerHTML = '';
                }
                // Update allocate buttons based on modal visibility
                updateAllocateButtonsBasedOnGroupEditVisibility();

                activeGroupCard = null;
                activeGroupName = '';
                activeGroupId = '';
            });
        }

        // Attach allocate handler to initial and future allocate buttons
        const allocateButtons = document.querySelectorAll('.allocate-button');
        
        allocateButtons.forEach(btn => attachAllocateHandler(btn));

        // Initialize allocate buttons based on groupedit modal visibility on page load
        updateAllocateButtonsBasedOnGroupEditVisibility();

        // When output dropdown changes, rescale the 4 cards and update the active group card label
        if (groupEditOutputSelect) {
            groupEditOutputSelect.addEventListener('change', function() {
                const multiplier = parseInt(this.value, 10) || 1;
                applyOutputMultiplier(multiplier);

                if (activeGroupCard) {
                    const label = activeGroupCard.querySelector('.group-output-label');
                    if (label) {
                        label.textContent = `${multiplier}x Layout`;
                    }
                }
            });
        }

        // creategroup popup
        const createGroupButton = document.getElementById('creategroup-button');
        const createGroupModal = document.getElementById('creategroup');
        const closeCreateGroupModalButton = document.getElementById('closeCreateGroupModal');
        const createGroupNameInput = document.getElementById('createGroupNameInput');
        const createGroupCCSelect = document.getElementById('createGroupCCSelect');
        const createGroupLayoutSelect = document.getElementById('createGroupLayoutSelect');
        const createGroupSubmitButton = document.getElementById('createGroupSubmitButton');
        const sewingLineGroupsContainer = document.getElementById('sewingLineGroupsContainer');
        const groupDateRange = document.getElementById('groupDateRange');

        if (groupDateRange && window.flatpickr) {
            window.flatpickr(groupDateRange, {
                mode: 'range',
                dateFormat: 'd-m-y',  // Capital Y for 4-digit year (recommended)
                minDate: "today",         // This is the key: disables all past dates
                
            });
        }
        let selectedUnitCode = '';

        // Load layout/output options for a given CC into the Layout dropdown
        async function loadLayoutsForCC(ccNo) {
            if (!createGroupLayoutSelect) return;

            // Reset dropdown
            createGroupLayoutSelect.innerHTML = '';

            const placeholder = document.createElement('option');
            placeholder.value = '';
            placeholder.textContent = ccNo ? 'Select Layout' : 'Select CC first';
            placeholder.disabled = !ccNo;
            placeholder.selected = true;
            createGroupLayoutSelect.appendChild(placeholder);

            if (!ccNo) {
                return;
            }

            try {
                const response = await fetch(`/layout_plan_details?ccno=${encodeURIComponent(ccNo)}`);
                const result = await response.json();

                if (!result || !result.success || !Array.isArray(result.data) || !result.data.length) {
                    return;
                }

                // Build unique layout options from the returned data: { Layout: 'L1' }
                const layouts = [];
                result.data.forEach(row => {
                    if (!row || !row.Layout) return;
                    const value = String(row.Layout).trim();
                    if (!value) return;

                    if (!layouts.includes(value)) {
                        layouts.push(value);
                    }
                });

                layouts.forEach(val => {
                    const opt = document.createElement('option');
                    opt.value = val;
                    opt.textContent = val; // e.g. L1
                    createGroupLayoutSelect.appendChild(opt);
                });

            } catch (err) {
                console.error('Error loading layouts:', err);
            }
        }

        async function updateCreateGroupName() {
            const createGroupNameInput = document.getElementById('createGroupNameInput');
            const createGroupCCSelect = document.getElementById('createGroupCCSelect');
            const unitDropdown = document.getElementById('unit_dropdown');

            if (!createGroupNameInput || !createGroupCCSelect || !unitDropdown) return;

            const ccNo = createGroupCCSelect.value.trim();
            const selectedOption = unitDropdown.options[unitDropdown.selectedIndex];

            if (!selectedOption || unitDropdown.value === '' || !ccNo) {
                createGroupNameInput.value = '';
                return;
            }

            // Clean unit code: "T-W-I" → "TWI"
            const displayText = selectedOption.textContent.trim();
            const shortCode = displayText
                .replace(/-/g, '')
                .replace(/I+$/g, match => match.length > 1 ? match : 'I')
                .toUpperCase();

            // Find highest existing number from actual group cards
            const groupCards = document.querySelectorAll('#sewingLineGroupsContainer [data-group-name]');
            let highestNumber = 0;
            const prefix = `${shortCode}-SLG-`;

            groupCards.forEach(card => {
                const name = card.getAttribute('data-group-name') || '';
                if (name.startsWith(prefix)) {
                    const numStr = name.split('-').pop();
                    if (/^\d+$/.test(numStr)) {
                        const num = parseInt(numStr, 10);
                        if (num > highestNumber) highestNumber = num;
                    }
                }
            });

            createGroupNameInput.value = `${shortCode}-SLG-${highestNumber + 1}`;
        }

        if (createGroupButton && createGroupModal) {
            createGroupButton.addEventListener('click', function() {
                if (groupDateRange) {
                    groupDateRange.value = '';
                }

                const groupcc = document.getElementById('createGroupCCSelect');

                // Fetch units from the server
                fetch(`/gut_ccnodetails`)
                    .then(response => response.json())
                    .then(data => {
                        // Clear existing options
                        groupcc.innerHTML = '';

                        // Add placeholder
                        const placeholder = document.createElement('option');
                        placeholder.value = "";
                        placeholder.textContent = "-- Select CC No --";
                        placeholder.disabled = true;
                        placeholder.selected = true;
                        groupcc.appendChild(placeholder);

                        if (data.success && Array.isArray(data.data) && data.data.length) {

                            // Extract and clean CCNo values, then sort them
                            let ccNumbers = data.data
                                .map(grup => grup.CCNo)
                                .filter(cc => cc !== null && cc !== undefined && cc !== '')  // remove invalid ones
                                .sort((a, b) => {
                                    // Try to sort numerically first (handles pure numbers properly)
                                    const numA = parseInt(a, 10);
                                    const numB = parseInt(b, 10);

                                    if (!isNaN(numA) && !isNaN(numB)) {
                                        return numA - numB;  // numeric sort
                                    } else {
                                        return a.localeCompare(b);  // fallback to string sort
                                    }
                                });

                            // Remove duplicates (optional but recommended)
                            ccNumbers = [...new Set(ccNumbers)];

                            // Add sorted options
                            ccNumbers.forEach(cc => {
                                const option = document.createElement('option');
                                option.value = cc;
                                option.textContent = cc;
                                groupcc.appendChild(option);
                            });
                        } else {
                            // If no data
                            const noOption = document.createElement('option');
                            noOption.value = "";
                            noOption.textContent = "No CC No found";
                            noOption.disabled = true;
                            groupcc.appendChild(noOption);
                        }
                    })
                    .catch(error => {
                        console.error('Error fetching group:', error);
                    });

                updateCreateGroupName();
                loadLayoutsForCC(createGroupCCSelect ? createGroupCCSelect.value : '');
                createGroupModal.classList.remove('hidden');
            });
        }

        if (closeCreateGroupModalButton && createGroupModal) {
            closeCreateGroupModalButton.addEventListener('click', function() {
                createGroupModal.classList.add('hidden');
                // Reset sewing line groups filter to show all cards
                resetSewingLineGroupsFilter();
            });
        }

        // Create Group: add new card
        if (createGroupSubmitButton && createGroupNameInput && sewingLineGroupsContainer) {
            createGroupSubmitButton.addEventListener('click', async function() {
                updateCreateGroupName();

                //const groupName = createGroupNameInput.value.trim();
                //const groupCC = createGroupCCSelect ? (createGroupCCSelect.value || '-') : '-';


				const createGroupCCSelect = document.getElementById('createGroupCCSelect');
				const createGroupNameInput = document.getElementById('createGroupNameInput');
				const groupDateRangeInput = document.getElementById('groupDateRange');
				const outputSelect = document.querySelector('#createGroupCCSelect')
					.closest('.grid')
					.querySelectorAll('select')[1]; // 2nd select is Output
                
                const unitDropdown = document.getElementById('unit_dropdown');
                const unitId = unitDropdown ? unitDropdown.value : '';

				// Validation: Check if CC is selected
				if (!createGroupCCSelect.value || createGroupCCSelect.value === '') {
					toastr.error('Please select a CC number.');
					return;
				}

				// Validation: Check if date range is not empty
				if (!groupDateRangeInput.value || groupDateRangeInput.value.trim() === '') {
					toastr.error('Please select a date range.');
					return;
				}

					const payload1 = {
						group_name: createGroupNameInput.value.trim(),
						cc_no: createGroupCCSelect?.value || "-",        // assign CC
						output_type: outputSelect?.value || "",         // 1x, 2x, ...
						date_range: groupDateRangeInput.value.trim(),   // from UI
                        unitId: unitId
					};
					//console.log(payload1);
					//alert('t');
				try {
					const response = await fetch('/createlinegroup', {
						method: 'POST',
						headers: {
							'Content-Type': 'application/json',
							'X-CSRF-TOKEN': document
								.querySelector('meta[name="csrf-token"]')
								?.getAttribute('content') || ''
						},
						body: JSON.stringify(payload1)
					});

					const result = await response.json();

					if (result.success) {
						toastr.success('Line Group created successfully!');
						location.reload(); // or update UI without reload
					} else {
						toastr.error(result.message || 'Failed to create group');
					}

				} catch (error) {
					console.error(error);
					toastr.error('Network error. Please try again.');
				}

                if (!groupName) {
                    return; // simple guard; no alert to keep UI clean
                }

                // Build new group card HTML
                const wrapper = document.createElement('div');
                wrapper.className = 'bg-gray-50 border border-gray-200 rounded-md p-4 flex justify-between items-center shadow-sm';
                wrapper.innerHTML = `
                    <div>
                        <h3 class="font-medium">${groupName}</h3>
                        <p class="text-gray-500 text-sm">CC: ${groupCC}</p>
                    </div>

                    <div class="flex items-center gap-3">
                        <button class="text-blue-500 hover:text-blue-700">
                            <i class="fa-solid fa-pen-to-square"></i>
                        </button>
                        <button class="text-gray-500 hover:text-gray-700">
                            <i class="fa-solid fa-arrow-right open-groupedit-pop" data-group-name="${groupName}" data-group-cc="${groupCC}"></i>
                        </button>
                        
                    </div>
                `;

                sewingLineGroupsContainer.appendChild(wrapper);

                // Attach groupedit behavior for the new arrow icon
                const newArrow = wrapper.querySelector('.open-groupedit-pop');
                if (newArrow && groupEditModal) {
                    newArrow.addEventListener('click', function() {
                        const gName = this.getAttribute('data-group-name') || '';
                        const gCC = this.getAttribute('data-group-cc') || '';

                        if (groupEditName) {
                            groupEditName.textContent = gName;
                        }

                        if (groupEditCC) {
                            groupEditCC.textContent = gCC;
                        }

                        groupEditModal.classList.remove('hidden');
                        
                        // Adjust modal height after showing
                        setTimeout(() => {
                            adjustAllocatedLinesContainerHeight();
                            adjustGroupEditHeight();
                        }, 100);
                    });
                }

                // Keep modal open as in the screenshot; remove next line if you want it to close
                // createGroupModal.classList.add('hidden');
            });
        }

        const unitDropdownForGroup = document.getElementById('unit_dropdown');
        if (unitDropdownForGroup) {
            unitDropdownForGroup.addEventListener('change', updateCreateGroupName);
        }

        if (createGroupCCSelect) {
            createGroupCCSelect.addEventListener('change', function() {
                // Update the group name (existing functionality)
                updateCreateGroupName();
                // Refresh layouts based on newly selected CC
                loadLayoutsForCC(this.value || '');
                
                // Get the selected CC value
                const selectedCC = this.value || '';
                
                // If "Select a CC" (empty value) is chosen, reset filter to show all
                if (selectedCC === '') {
                    resetSewingLineGroupsFilter();
                } else {
                    // Filter sewing line groups based on selected CC
                    filterSewingLineGroups(selectedCC);
                }
            });
        }

        // reallocatepop popup (dynamic target line + dynamic source list)
        const openReallocatePopButtons = document.querySelectorAll('.open-reallocate-pop');
        reallocatePopModal = document.getElementById('reallocatepop');
        const closeReallocatePopModalButton = document.getElementById('closeReallocatePopModal');
        targetLineTitle = document.getElementById('targetLineTitle');
        targetLineInput = document.getElementById('targetLineInput');
        // In reallocate modal: first select = Source Line, second = Machine Type
        const reallocateSourceSelect = reallocatePopModal ? reallocatePopModal.querySelector('select.w-full.border.border-gray-300.rounded-md.px-3.py-2.text-gray-700') : null;
        const reallocateMachineTypeSelect = reallocatePopModal ? reallocatePopModal.querySelectorAll('select.w-full.border.border-gray-300.rounded-md.px-3.py-2.text-gray-700')[1] : null;
        const reallocateQuantityInput = reallocatePopModal ? reallocatePopModal.querySelector('input[type="number"]') : null;
        const reallocateConfirmButton = reallocatePopModal ? reallocatePopModal.querySelector('button.bg-blue-500') : null;

        // --------- Simple Calendar Engine (Factory + SLG) ---------
        const monthNames = ['January','February','March','April','May','June','July','August','September','October','November','December'];

        function daysInMonth(year, monthIndex) {
            return new Date(year, monthIndex + 1, 0).getDate();
        }

        function renderCalendarPair(leftMonthEl, rightMonthEl, leftDaysEl, rightDaysEl, baseYear, baseMonthIndex) {
            if (!leftMonthEl || !rightMonthEl || !leftDaysEl || !rightDaysEl) return;

            const leftYear = baseYear;
            const leftMonth = baseMonthIndex;
            const rightDate = new Date(leftYear, leftMonth + 1, 1);
            const rightYear = rightDate.getFullYear();
            const rightMonth = rightDate.getMonth();

            leftMonthEl.textContent = monthNames[leftMonth] + ' ' + leftYear;
            rightMonthEl.textContent = monthNames[rightMonth] + ' ' + rightYear;

            buildMonthGrid(leftDaysEl, leftYear, leftMonth);
            buildMonthGrid(rightDaysEl, rightYear, rightMonth);
        }

        function buildMonthGrid(container, year, monthIndex) {
            if (!container) return;
            container.innerHTML = '';

            const firstDay = new Date(year, monthIndex, 1).getDay(); // 0=Sun
            const totalDays = daysInMonth(year, monthIndex);
            const today = new Date();
            const isCurrentMonth = today.getFullYear() === year && today.getMonth() === monthIndex;
            const currentDate = today.getDate();

            // Previous month trailing days
            const prevDate = new Date(year, monthIndex, 0);
            const prevMonthDays = prevDate.getDate();
            for (let i = 0; i < firstDay; i++) {
                const d = prevMonthDays - firstDay + 1 + i;
                const cell = document.createElement('div');
                cell.textContent = d;
                cell.className = 'text-gray-300';
                container.appendChild(cell);
            }

            // Current month days
            for (let d = 1; d <= totalDays; d++) {
                const cell = document.createElement('div');
                cell.textContent = d;
                cell.className = 'calendar-day cursor-pointer';
                cell.dataset.date = `${year}-${String(monthIndex + 1).padStart(2, '0')}-${String(d).padStart(2, '0')}`;
                
                // Highlight current date
                if (isCurrentMonth && d === currentDate) {
                    cell.classList.add('current-date');
                }
                
                container.appendChild(cell);
            }

            // Next month leading days to fill grid rows (~6 weeks max = 42 cells)
            const cellsNow = container.children.length;
            const totalCells = Math.ceil(cellsNow / 7) * 7;
            for (let i = 1; i <= totalCells - cellsNow; i++) {
                const cell = document.createElement('div');
                cell.textContent = i;
                cell.className = 'text-gray-300';
                container.appendChild(cell);
            }
        }

        // Initialize Factory calendar (global)
        const factoryLeftMonthEl = document.getElementById('factoryCalLeftMonth');
        const factoryRightMonthEl = document.getElementById('factoryCalRightMonth');
        const factoryLeftDaysEl = document.getElementById('factoryCalLeftDays');
        const factoryRightDaysEl = document.getElementById('factoryCalRightDays');
        const factoryPrevBtn = document.getElementById('factoryCalPrev');
        const factoryNextBtn = document.getElementById('factoryCalNext');

        let factoryBaseYear = new Date().getFullYear();
        let factoryBaseMonth = new Date().getMonth();

        function refreshFactoryCalendar() {
            renderCalendarPair(factoryLeftMonthEl, factoryRightMonthEl, factoryLeftDaysEl, factoryRightDaysEl, factoryBaseYear, factoryBaseMonth);
        }
        
        // Initialize the calendar on page load
        refreshFactoryCalendar();

        if (factoryPrevBtn) {
            factoryPrevBtn.addEventListener('click', function() {
                const prev = new Date(factoryBaseYear, factoryBaseMonth - 1, 1);
                factoryBaseYear = prev.getFullYear();
                factoryBaseMonth = prev.getMonth();
                refreshFactoryCalendar();
            });
        }

        if (factoryNextBtn) {
            factoryNextBtn.addEventListener('click', function() {
                const next = new Date(factoryBaseYear, factoryBaseMonth + 1, 1);
                factoryBaseYear = next.getFullYear();
                factoryBaseMonth = next.getMonth();
                refreshFactoryCalendar();
            });
        }

        // Initialize SLG calendar (group specific)
        const slgLeftMonthEl = document.getElementById('slgCalLeftMonth');
        const slgRightMonthEl = document.getElementById('slgCalRightMonth');
        const slgLeftDaysEl = document.getElementById('slgCalLeftDays');
        const slgRightDaysEl = document.getElementById('slgCalRightDays');
        const slgPrevBtn = document.getElementById('slgCalPrev');
        const slgNextBtn = document.getElementById('slgCalNext');

        let slgBaseYear = new Date().getFullYear();
        let slgBaseMonth = new Date().getMonth();

        function refreshSlgCalendar() {
            renderCalendarPair(slgLeftMonthEl, slgRightMonthEl, slgLeftDaysEl, slgRightDaysEl, slgBaseYear, slgBaseMonth);
            // After (re)rendering the grid, re-apply range + stored highlights
            if (typeof applySlgRangeHighlight === 'function') {
                applySlgRangeHighlight();
            }
            if (typeof applySlgStoredHighlights === 'function') {
                applySlgStoredHighlights();
            }
            if (typeof addSlgCalendarClickHandlers === 'function') {
                addSlgCalendarClickHandlers();
            }
        }

        if (slgPrevBtn) {
            slgPrevBtn.addEventListener('click', function() {
                const prev = new Date(slgBaseYear, slgBaseMonth - 1, 1);
                slgBaseYear = prev.getFullYear();
                slgBaseMonth = prev.getMonth();
                refreshSlgCalendar();
            });
        }

        if (slgNextBtn) {
            slgNextBtn.addEventListener('click', function() {
                const next = new Date(slgBaseYear, slgBaseMonth + 1, 1);
                slgBaseYear = next.getFullYear();
                slgBaseMonth = next.getMonth();
                refreshSlgCalendar();
            });
        }

        // Initial render of SLG calendar grid so days exist for highlighting
        refreshSlgCalendar();

        if (openReallocatePopButtons && reallocatePopModal) {
            openReallocatePopButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const targetLine = this.getAttribute('data-target-line') || 'Buffer';

                    // Update target line text
                    if (targetLineTitle) {
                        targetLineTitle.textContent = targetLine;
                    }

                    if (targetLineInput) {
                        targetLineInput.value = targetLine;
                    }

                    // Populate Source Line dropdown dynamically with all current line names
                    if (reallocateSourceSelect) {
                        // Clear existing options
                        reallocateSourceSelect.innerHTML = '';

                        const defaultOpt = document.createElement('option');
                        defaultOpt.value = '';
                        defaultOpt.textContent = 'Select Source';
                        defaultOpt.disabled = true;
                        defaultOpt.selected = true;
                        reallocateSourceSelect.appendChild(defaultOpt);

                        // Always add "Buffer" as a source option
                        const bufferOption = document.createElement('option');
                        bufferOption.value = 'Buffer';
                        bufferOption.textContent = 'Buffer';
                        reallocateSourceSelect.appendChild(bufferOption);

                        // Add all regular lines (excluding the current target line)
                        const lineCards = document.querySelectorAll('div.bg-gray-50.p-4.rounded-lg.shadow-sm.border.border-gray-200');
                        lineCards.forEach(card => {
                            const header = card.querySelector('h3.font-medium');
                            if (!header) return;
                            const lineName = header.textContent.trim();

                            // Skip if it's the target line OR already added (Buffer)
                            if (lineName === targetLine || lineName === 'Buffer') return;

                            const opt = document.createElement('option');
                            opt.value = lineName;
                            opt.textContent = lineName;
                            reallocateSourceSelect.appendChild(opt);
                        });
                    }

                    // Populate Machine Type dropdown dynamically based on chips in target + all lines
                    if (reallocateMachineTypeSelect) {
                        while (reallocateMachineTypeSelect.firstChild) {
                            reallocateMachineTypeSelect.removeChild(reallocateMachineTypeSelect.firstChild);
                        }

                        const defaultType = document.createElement('option');
                        defaultType.value = '';
                        defaultType.textContent = 'Select Type';
                        reallocateMachineTypeSelect.appendChild(defaultType);

                        const typeSet = new Set();

                        // Helper to collect machine types from a given card
                        const collectTypesFromCard = (card) => {
                            if (!card) return;
                            const chips = card.querySelectorAll('span.px-2.py-1.bg-white.border.rounded.text-xs');
                            chips.forEach(chip => {
                                const text = chip.textContent.trim();
                                const parts = text.split(':');
                                const typeName = parts[0] ? parts[0].trim() : '';
                                if (typeName) {
                                    typeSet.add(typeName);
                                }
                            });
                        };

                        // Collect from all unallocated line cards
                        const allCards = document.querySelectorAll('div.bg-gray-50.p-4.rounded-lg.shadow-sm.border.border-gray-200');
                        allCards.forEach(card => collectTypesFromCard(card));

                        // Add options
                        typeSet.forEach(typeName => {
                            const opt = document.createElement('option');
                            opt.value = typeName;
                            opt.textContent = typeName;
                            reallocateMachineTypeSelect.appendChild(opt);
                        });
                    }

                    reallocatePopModal.classList.remove('hidden');
                });
            });
        }

        // Helper: find line card by its title text
        function findLineCardByName(name) {
            const headers = document.querySelectorAll('div.bg-gray-50.p-4.rounded-lg.shadow-sm.border.border-gray-200 h3.font-medium');
            for (const h3 of headers) {
                if (h3.textContent.trim() === name) {
                    return h3.closest('div.bg-gray-50.p-4.rounded-lg.shadow-sm.border.border-gray-200');
                }
            }
            return null;
        }

        // Helper: adjust chip value for a given machine type on a card
        function adjustMachineCount(card, machineType, delta) {
            if (!card || !machineType || !delta) return;
            const chips = card.querySelectorAll('span.px-2.py-1.bg-white.border.rounded.text-xs');
            for (const chip of chips) {
                const text = chip.textContent.trim();
                const parts = text.split(':');
                if (parts.length !== 2) continue;
                const typeName = parts[0].trim();
                const currentVal = parseInt(parts[1], 10);
                if (typeName === machineType && !isNaN(currentVal)) {
                    const nextVal = currentVal + delta;
                    if (nextVal < 0) return; // don't allow negative; abort
                    chip.textContent = `${typeName}: ${nextVal}`;
                    return;
                }
            }
        }

        // Confirm & Move: visually reallocate machines between lines (static demo)
        if (reallocateConfirmButton && reallocateSourceSelect && reallocateMachineTypeSelect && reallocateQuantityInput) {
            reallocateConfirmButton.addEventListener('click', function() {
                const sourceName = reallocateSourceSelect.value;
                const targetName = targetLineInput ? targetLineInput.value.trim() : '';
                const machineType = reallocateMachineTypeSelect.value;
                const qty = parseInt(reallocateQuantityInput.value, 10);

                if (!sourceName || !targetName || !machineType || !qty || qty <= 0) {
                    return;
                }

                const sourceCard = findLineCardByName(sourceName);
                const targetCard = findLineCardByName(targetName);
                if (!sourceCard || !targetCard) {
                    return;
                }

                // Decrease from source; if this would go negative, do nothing
                const chips = sourceCard.querySelectorAll('span.px-2.py-1.bg-white.border.rounded.text-xs');
                let canApply = false;
                for (const chip of chips) {
                    const text = chip.textContent.trim();
                    const parts = text.split(':');
                    if (parts.length !== 2) continue;
                    const typeName = parts[0].trim();
                    const currentVal = parseInt(parts[1], 10);
                    if (typeName === machineType && !isNaN(currentVal) && currentVal - qty >= 0) {
                        canApply = true;
                        break;
                    }
                }

                if (!canApply) {
                    return;
                }

                adjustMachineCount(sourceCard, machineType, -qty);
                adjustMachineCount(targetCard, machineType, qty);

                // Close modal after applying
                reallocatePopModal.classList.add('hidden');
            });
        }

        if (closeReallocatePopModalButton && reallocatePopModal) {
            closeReallocatePopModalButton.addEventListener('click', function() {
                reallocatePopModal.classList.add('hidden');
            });
        }
    });

    // Add blur effect to content areas
    function addBlurEffect() {
        const containers = [
            document.querySelector('.col-span-4 > .bg-white'), // Unallocated lines
            document.querySelector('.col-span-8 > .bg-white'), // Sewing line groups
            document.querySelector('.bg-gray-50.p-4.rounded-lg.shadow-sm.border.border-gray-200') // Buffer card
        ];
        containers.forEach(container => {
            if (container) container.classList.add('content-blur');
        });
    }

    // Remove blur effect from content areas
    function removeBlurEffect() {
        const containers = [
            document.querySelector('.col-span-4 > .bg-white'),
            document.querySelector('.col-span-8 > .bg-white'),
            document.querySelector('.bg-gray-50.p-4.rounded-lg.shadow-sm.border.border-gray-200') // Buffer card
        ];
        containers.forEach(container => {
            if (container) container.classList.remove('content-blur');
        });
    }

    // Show loading state
    function showLoading() {
        const overlay = document.createElement('div');
        overlay.className = 'loading-overlay';
        overlay.id = 'loadingOverlay';
        overlay.innerHTML = '<div class="spinner"></div>';
        document.body.appendChild(overlay);
    }

    // Hide loading state
    function hideLoading() {
        const overlay = document.getElementById('loadingOverlay');
        if (overlay) {
            overlay.remove();
        }
    }
    
    // Fetch units and populate dropdown
    document.addEventListener('DOMContentLoaded', function() {
        // Add blur effect initially
        addBlurEffect();
    
        const unitDropdown = document.getElementById('unit_dropdown');
        
        // Fetch units and populate dropdown
        fetch(`/gut_unitdetails?portaltype=${window.portalType || 'gut_new'}`)
            .then(response => response.json())
            .then(data => {
                if (data.success && data.data) {
                    // Clear existing options except the first one
                    while (unitDropdown.options.length > 1) {
                        unitDropdown.remove(1);
                    }
                    
                    // Add new options
                    data.data.forEach(unit => {
                        const option = document.createElement('option');
                        option.value = unit.Unitcode;
                        option.textContent = unit.Unit_Lookup; // Only showing Unit_Lookup
                        unitDropdown.appendChild(option);
                    });
                    
                    // Populate sewing line groups if available
                    if (data.line_groups && Array.isArray(data.line_groups)) {
                       
                        populateSewingLineGroups(data.line_groups);
                    } else {
                        console.log('No line_groups data found in response');
                       
                    }
                    
                    // Enable the dropdown
                    unitDropdown.disabled = false;
                    
                    // Auto-select the first unit if available
                    if (unitDropdown.options.length > 1) {
                        unitDropdown.selectedIndex = 1; // Select first real unit (index 0 is "Select Unit")
                        // Trigger the change event to load the unit details
                        unitDropdown.dispatchEvent(new Event('change'));
                    }
                }
            })
            .catch(error => {
                console.error('Error fetching units:', error);
                // You might want to show an error message to the user here
            });

            // Update the unit change event handler
            unitDropdown.addEventListener('change', async function() {
                const selectedUnit = this.value;
                currentSelectedUnit = this.value;

                if (!selectedUnit) return;

                try {
                    // Show loading state
                    showLoading();
                    unitDropdown.disabled = true;
                    
                    // Fetch buffer and line details
                    const response = await fetch(`/buffer_machine_details?unit=${selectedUnit}`);
                    const data = await response.json();

                    if (data.success) {
                        // Update buffer and line details
                        if (data.data) updateBufferDetails(data.data);
                        if (data.linedata) updateLineDetails(data.linedata);
                        
                        // Remove blur effect after content is populated
                        removeBlurEffect();
                    }
                } catch (error) {
                    console.error('Error fetching unit details:', error);
                } finally {
                    hideLoading();
                    unitDropdown.disabled = false;
                }
            });
            
        
    });

    // Add the buffer and line details handling functions
    function updateBufferDetails(bufferData) {
        const bufferCard = document.querySelector('.bg-gray-50.p-4.rounded-lg.shadow-sm.border.border-gray-200');
        if (!bufferCard) return;

        const machineContainer = bufferCard.querySelector('.flex.flex-wrap.gap-2');
        if (!machineContainer) return;

        // Clear existing machine types
        machineContainer.innerHTML = '';

        // Filter out machines with 0 pending and add them to the buffer card
        const activeMachines = bufferData.filter(machine => parseInt(machine.Pending) > 0);
        
        activeMachines.forEach(machine => {
            const machineBadge = document.createElement('span');
            machineBadge.className = 'px-2 py-1 bg-white border rounded text-xs';
            machineBadge.textContent = `${machine.MAchine_Type}: ${machine.Pending}`;
            machineContainer.appendChild(machineBadge);
        });

        // Update the machine count in the buffer card header
        const machineCount = bufferCard.querySelector('.text-sm.text-gray-500');
        if (machineCount) {
            const totalMachines = activeMachines.reduce((sum, machine) => sum + parseInt(machine.Pending), 0);
            machineCount.textContent = `${totalMachines} Machines`;
        }
    }

    // Standalone helper: attach delete click handler to all visible line-group delete buttons
    function attachLineGroupDeleteHandlers() {
        const deleteButtons = document.querySelectorAll('#sewingLineGroupsContainer #linegroup_delete');
        deleteButtons.forEach(btn => {
            // Avoid attaching multiple listeners to the same button
            if (btn.dataset.bound === '1') return;
            btn.dataset.bound = '1';

            btn.addEventListener('click', function() {
                const card = this.closest('[data-group-name]');
                if (!card) return;

                const arrow = card.querySelector('.open-groupedit-pop');
                const groupId = arrow ? (arrow.getAttribute('data-group-id') || '').trim() : '';
                const groupName = card.getAttribute('data-group-name') || groupId;

                if (!groupId) {
                    toastr.error('Group id not found for deletion.');
                    return;
                }

                // Store pending delete state for modal
                pendingDeleteCard = card;
                pendingDeleteGroupId = groupId;
                pendingDeleteGroupName = groupName;

                const modal = document.getElementById('lineGroupDeleteModal');
                const messageEl = document.getElementById('lineGroupDeleteMessage');
                if (messageEl && pendingDeleteGroupName) {
                    messageEl.textContent = `Are you sure you want to delete line group "${pendingDeleteGroupName}"?`;
                }
                if (modal) {
                    modal.classList.remove('hidden');
                }
            });
        });
    }

    function populateSewingLineGroups(lineGroups) {
		const sewingLineGroupsContainer = document.getElementById('sewingLineGroupsContainer');
		if (!sewingLineGroupsContainer) {
			console.error('sewingLineGroupsContainer not found');
			return;
		}

		// Clear existing group cards
		sewingLineGroupsContainer.innerHTML = '';

		// REMOVED SORTING - Use the original order from the server
		// const sortedGroups = [...lineGroups].sort((a, b) => {
		//     return (a.group_name || '').localeCompare(b.group_name || '');
		// });

		// Now just use lineGroups directly (preserves server order)
		const groupsToDisplay = lineGroups;  // This keeps the exact received order

		// Create group cards for each line group in original order
		groupsToDisplay.forEach((group, index) => {
			const groupName = group.group_name || '';
			const ccNo = group.cc_no || '-';
			const outputType = group.output_type || '1';
			const groupId = group.id || '';
            let groupfromdate = group.date_from || '';
            let grouptodate = group.date_to || '';
			const groupCard = document.createElement('div');
			groupCard.className = 'bg-gray-50 border border-gray-200 rounded-md p-4 flex justify-between items-center shadow-sm';
			groupCard.setAttribute('data-group-name', groupName);
			groupCard.setAttribute('data-group-cc', ccNo);
			groupCard.setAttribute('data-group-id', groupId);

			groupCard.classList.add("relative");

            groupCard.innerHTML = `
                <!-- Delete cross -->
                <button class="absolute top-3 right-4 text-red-500 hover:text-red-700" id="linegroup_delete">
                    <i class="fa-solid fa-xmark"></i>
                </button>

                <!-- Main content -->
                <div class="flex justify-between items-center w-full">
                    <div>
                        <h3 class="font-medium">${groupName}</h3>
                        <p class="text-gray-500 text-sm">CC: ${ccNo}</p>
                        <p class="text-gray-500 text-xs mt-1 group-output-label">${outputType}X Layout</p>
                    </div>

                    <div class="flex items-center gap-3">
                        <button class="hidden text-blue-500 hover:text-blue-700">
                            <i class="fa-solid fa-pen-to-square"></i>
                        </button>

                        <button class="text-gray-500 hover:text-gray-700">
                            <i class="fa-solid fa-arrow-right open-groupedit-pop"
                            data-from-date="${groupfromdate}"
                            data-to-date="${grouptodate}"
                            data-group-name="${groupName}"
                            data-group-cc="${ccNo}"
                            data-group-id="${groupId}">
                            </i>
                        </button>
                    </div>
                </div>
            `;

			sewingLineGroupsContainer.appendChild(groupCard);
		});

		// Re-attach event listeners
			attachGroupEditListeners();

			// Attach delete handlers for line groups (trash icon)
			attachLineGroupDeleteHandlers();

		// Apply current filter if a CC is selected
		const createGroupCCSelect = document.getElementById('createGroupCCSelect');
		if (createGroupCCSelect) {
			const currentCC = createGroupCCSelect.value || '';
			filterSewingLineGroups(currentCC);
		}

		// Handle empty state
		if (groupsToDisplay.length === 0) {
			const groupEditModal = document.getElementById('groupedit');
			if (groupEditModal) {
				groupEditModal.classList.add('hidden');
				updateAllocateButtonsBasedOnGroupEditVisibility();
			}
			console.log('No sewing line groups available, groupedit modal closed');
		}
		// Note: You already have the auto-open-first-group logic commented out, so leaving it as-is
	}

    // Function to attach event listeners to group edit buttons
    function attachGroupEditListeners() {
        const groupEditButtons = document.querySelectorAll('.open-groupedit-pop');
        const groupEditModal = document.getElementById('groupedit');
        const closeGroupEditModalButton = document.getElementById('closeGroupEditModal');
        const groupEditName = document.getElementById('groupEditName');
        const groupEditCC = document.getElementById('groupEditCC');
        const groupEditOutputSelect = document.getElementById('groupEditOutputSelect');

        if (groupEditButtons && groupEditModal) {
            groupEditButtons.forEach(button => {
                // Remove existing listener to avoid duplicates
                button.replaceWith(button.cloneNode(true));
            });

            // Re-select the buttons after cloning
            const freshButtons = document.querySelectorAll('.open-groupedit-pop');
            
            freshButtons.forEach(button => {
                button.addEventListener('click', async function() {
                    const groupName = this.getAttribute('data-group-name') || '';
                    const groupCC = this.getAttribute('data-group-cc') || '';
                    const groupId = this.getAttribute('data-group-id') || '';
                    const groupFromDate = this.getAttribute('data-from-date') || '';
                    const groupToDate   = this.getAttribute('data-to-date') || '';

                    // Set active group variables
                    activeGroupName = groupName;
                    activeGroupId = groupId;

                    // Also expose them globally for SLG calendar title & range
                    window.activeGroupName     = groupName;
                    window.activeGroupFromDate = groupFromDate;
                    window.activeGroupToDate   = groupToDate;

                    if (groupEditName) {
                        groupEditName.textContent = groupName;
                    }

                    if (groupEditCC) {
                        groupEditCC.textContent = groupCC;
                    }

                    // Find the corresponding group card to get current output
                    const activeGroupCard = document.querySelector(`[data-group-name="${groupName}"]`);
                    if (activeGroupCard && groupEditOutputSelect) {
                        const outputLabel = activeGroupCard.querySelector('.group-output-label');
                        if (outputLabel) {
                            const outputText = outputLabel.textContent.trim();
                            const match = outputText.match(/(\d+)x/);
                            const currentMultiplier = match ? parseInt(match[1]) : 1;
                            groupEditOutputSelect.value = currentMultiplier;
                        }
                    }

                    // Show the modal
                    groupEditModal.classList.remove('hidden');
                    
                    // Set global variables for allocate button functionality
                    activeGroupName = groupName;
                    activeGroupId = activeGroupCard ? activeGroupCard.getAttribute('data-group-id') || '' : '';

                    // Update allocate buttons based on modal visibility
                    updateAllocateButtonsBasedOnGroupEditVisibility();

                    // Fetch group details and populate machine requirements
                    if (groupCC && groupCC !== '-') {
                        // Get the current unit ID from the unit dropdown
                        const unitDropdown = document.getElementById('unit_dropdown');
                        const unitId = unitDropdown ? unitDropdown.value : '';
                        
                        if (unitId) {
                            // Clear SLG selections BEFORE loading new group calendar data
                            if (typeof resetSlgSelections === 'function') {
                                resetSlgSelections();
                            }

                            // Get group-id from the clicked button's data attribute
                            const groupId = this.getAttribute('data-group-id') || '';
                            await fetchGroupDetails(groupCC, unitId, groupId);
                        } else {
                            console.warn('No unit selected, cannot fetch group details');
                        }
                    }
                });
            });
        }
    }

    // Function to filter sewing line groups based on selected CC
    function filterSewingLineGroups(selectedCC) {
        const sewingLineGroupsContainer = document.getElementById('sewingLineGroupsContainer');
        if (!sewingLineGroupsContainer) return;

        const groupCards = sewingLineGroupsContainer.querySelectorAll('[data-group-name]');
        
        groupCards.forEach(card => {
            const groupCC = card.getAttribute('data-group-cc') || '';
            
            // Show all groups if no CC is selected or if "Select a CC" is chosen
            if (!selectedCC || selectedCC === '') {
                card.style.display = 'flex';
                return;
            }
            
            // Show/hide based on CC match
            if (groupCC === selectedCC) {
                card.style.display = 'flex';
            } else {
                card.style.display = 'none';
            }
        });

        // Show a message if no groups are visible
        const visibleGroups = Array.from(groupCards).filter(card => card.style.display !== 'none');
        
        // Remove existing "no results" message if any
        const existingMessage = sewingLineGroupsContainer.querySelector('.no-groups-message');
        if (existingMessage) {
            existingMessage.remove();
        }

        // Add "no results" message if no groups are visible and a CC is selected
        if (visibleGroups.length === 0 && selectedCC !== '') {
            const noGroupsMessage = document.createElement('div');
            noGroupsMessage.className = 'no-groups-message text-center py-8 text-gray-500';
            noGroupsMessage.innerHTML = `
                <i class="fa-solid fa-search text-2xl mb-2 text-gray-400"></i>
                <p>No sewing line groups found for CC: ${selectedCC}</p>
            `;
            sewingLineGroupsContainer.appendChild(noGroupsMessage);
        }

        // Handle groupedit modal based on filtered results
        if (visibleGroups.length === 0) {
            // No visible groups after filtering - close the groupedit modal
            const groupEditModal = document.getElementById('groupedit');
            if (groupEditModal) {
                groupEditModal.classList.add('hidden');
                
                // Update allocate buttons based on modal visibility
                updateAllocateButtonsBasedOnGroupEditVisibility();
            }
            console.log('No visible groups after filtering, groupedit modal closed');
        } else {
            // Groups are visible - open groupedit for the first visible group
            const firstVisibleGroup = visibleGroups[0];
            const firstGroupName = firstVisibleGroup.getAttribute('data-group-name') || '';
            const firstGroupCC = firstVisibleGroup.getAttribute('data-group-cc') || '';
            
            // Find the groupedit modal and populate it with first visible group data - DISABLED for page load
            // setTimeout(() => {
            //     const groupEditModal = document.getElementById('groupedit');
            //     const groupEditName = document.getElementById('groupEditName');
            //     const groupEditCC = document.getElementById('groupEditCC');
            //     const groupEditOutputSelect = document.getElementById('groupEditOutputSelect');
            //     
            //     if (groupEditModal) {
                    //     // Populate the modal with first visible group data
    //                 if (groupEditName) {
    //                     groupEditName.textContent = firstGroupName;
    //                 }
    //                 
    //                 if (groupEditCC) {
    //                     groupEditCC.textContent = firstGroupCC;
    //                 }
    //                 
    //                 // Find the corresponding group card to get current output
    //                 const activeGroupCard = document.querySelector(`[data-group-name="${firstGroupName}"]`);
    //                 if (activeGroupCard && groupEditOutputSelect) {
    //                     const outputLabel = activeGroupCard.querySelector('.group-output-label');
    //                     if (outputLabel) {
    //                         const outputText = outputLabel.textContent.trim();
    //                         const match = outputText.match(/(\d+)x/);
    //                         const currentMultiplier = match ? parseInt(match[1]) : 1;
    //                         groupEditOutputSelect.value = currentMultiplier;
    //                     }
    //                 }
    //                 
    //                 // Show the modal
    //                 groupEditModal.classList.remove('hidden');
    //                 
    //                 // Set global variables for allocate button functionality
    //                 activeGroupName = firstGroupName;
    //                 activeGroupId = firstVisibleGroup.getAttribute('data-group-id') || '';
    //                 
    //                 // Fetch group details and populate machine requirements - removed for page load
    //                 // if (firstGroupCC && firstGroupCC !== '-') {
    //                 //     const unitDropdown = document.getElementById('unit_dropdown');
    //                 //     const unitId = unitDropdown ? unitDropdown.value : '';
    //                 //     
    //                 //     if (unitId) {
    //                 //         // Get group-id from the visible group element
    //                 //         const groupId = firstVisibleGroup.getAttribute('data-group-id') || '';
    //                 //         fetchGroupDetails(firstGroupCC, unitId, groupId);
    //                 //     } else {
    //                 //         console.warn('No unit selected, cannot fetch group details');
    //                 //     }
    //                 // }
    //                 
    //                 console.log('Auto-opened groupedit modal for first visible group:', firstGroupName);
    //                 
    //                 // Update allocate buttons based on modal visibility
    //                 updateAllocateButtonsBasedOnGroupEditVisibility();
    //             } else {
    //                 console.error('groupedit modal not found');
    //             }
    //         }, 500); // Shorter delay for filtering
        }
    }

    // Function to reset sewing line groups filter to show all cards
    function resetSewingLineGroupsFilter() {
        // Reset the CC dropdown to show "Select a CC"
        const createGroupCCSelect = document.getElementById('createGroupCCSelect');
        if (createGroupCCSelect) {
            createGroupCCSelect.value = '';
        }
        
        // Apply filter with empty string to show all cards
        filterSewingLineGroups('');
    }

    // Function to dynamically adjust allocated lines container height
    function adjustAllocatedLinesContainerHeight() {
        const allocatedContainer = document.getElementById('allocatedlinescontainer');
        if (!allocatedContainer) return;

        const allocatedCards = allocatedContainer.querySelectorAll('.bg-white.border.border-gray-200.rounded-md.p-3.mb-2');
        const cardCount = allocatedCards.length;
        
        // Calculate height based on card count
        // Each card is approximately 60px tall + margins
        const minCardHeight = 60;
        const cardMargin = 8; // mb-2 = 0.5rem = 8px
        const totalCardHeight = cardCount * (minCardHeight + cardMargin);
        
        // Set minimum height and allow growth up to max-height
        const calculatedHeight = Math.max(208, totalCardHeight + 16); // 208px = 13rem, +16px padding
        
        // Update CSS height if needed
        if (calculatedHeight > 208) {
            allocatedContainer.style.height = Math.min(calculatedHeight, 480) + 'px'; // 480px = 30rem max
        }
    }

    // Function to dynamically adjust group edit modal height
    function adjustGroupEditHeight() {
		const modal = document.getElementById('groupedit');
		const allocatedContainer = document.getElementById('allocatedlinescontainer');
		if (!modal || modal.classList.contains('hidden')) return;

		// First, let the allocated container take its natural height
		if (allocatedContainer) {
			allocatedContainer.style.height = 'auto'; // remove any fixed height
			const allocatedHeight = allocatedContainer.scrollHeight + 16; // + padding/margin
			allocatedContainer.style.height = Math.min(allocatedHeight, 480) + 'px'; // 30rem max
		}

		// Then let the modal take its natural height (auto + max-height in CSS does this)
		modal.style.height = 'auto';

		// Optional: If you want to force a minimum height
		const minModalHeight = 500; // adjust as needed
		const naturalHeight = modal.scrollHeight;
		if (naturalHeight < minModalHeight) {
			modal.style.height = minModalHeight + 'px';
		}
	}

    // Function to populate machine requirements from API response
    function populateMachineRequirements(mchSummary) {
        const machineRequirementsContainer = document.querySelector('.grid.grid-cols-4.gap-4');
        
        if (!machineRequirementsContainer) {
            console.error('Machine requirements container not found');
            return;
        }

        // Clear existing machine requirement cards
        machineRequirementsContainer.innerHTML = '';

        // Create dynamic machine requirement cards from mch_summary array
        mchSummary.forEach(machine => {
            const machineType = machine.mach_type || '';
            const totalMach = parseInt(machine.total_mach) || 0;
            const allocatedMach = parseInt(machine.allocated_mach) || 0;
            
            const machineCard = document.createElement('div');
            machineCard.className = 'bg-yellow-50 border border-yellow-200 rounded-lg p-4 shadow-sm';
            
            machineCard.innerHTML = `
                <p class="text-gray-600 text-sm mb-1">${machineType}</p>
                <p class="text-xl font-semibold">${allocatedMach} <span class="text-gray-500 text-base font-normal">/ ${totalMach}</span></p>
            `;

            machineRequirementsContainer.appendChild(machineCard);
        });
    }

    // Function to populate allocated lines container from API response
    function populateAllocatedLines(allocatedLinewise) {
        const allocatedContainer = document.getElementById('allocatedlinescontainer');
        if (!allocatedContainer) {
            console.error('Allocated lines container not found');
            return;
        }

        // Clear existing allocated line cards
        allocatedContainer.innerHTML = '';

        // if (!allocatedLinewise || allocatedLinewise.length === 0) {
        //     // Show empty state message
        //     allocatedContainer.innerHTML = `
        //         <div class="text-center py-8 text-gray-500">
        //             <i class="fa-solid fa-inbox text-2xl mb-2 text-gray-400"></i>
        //             <p>No lines allocated yet</p>
        //         </div>
        //     `;
        //     return;
        // }

        // Sort allocated lines by line_id
        allocatedLinewise.sort((a, b) => parseInt(a.line_id) - parseInt(b.line_id));

        // Create allocated line cards
        allocatedLinewise.forEach(lineData => {
            const lineId = lineData.line_id;
            const machines = lineData.machines || [];

            // Calculate total machines
            const totalMachines = machines.reduce((sum, machine) => sum + parseInt(machine.allocated_mach || 0), 0);

            // Create line card
            const lineCard = document.createElement('div');
            lineCard.className = 'bg-white border border-gray-200 rounded-md p-3 mb-2 flex flex-col shadow-sm';

            // Header (Line name + machines count)
            const header = document.createElement('div');
            header.className = 'flex justify-between items-center';
            header.innerHTML = `
                <h3 class="font-medium">Line ${lineId}</h3>
                <span class="text-sm text-gray-500">${totalMachines} Machines</span>
            `;
            lineCard.appendChild(header);

            // Machine chips
            if (machines.length > 0) {
                const chipsRow = document.createElement('div');
                chipsRow.className = 'flex flex-wrap gap-2 mt-3';
                
                machines.forEach(machine => {
                    const allocatedQty = parseInt(machine.allocated_mach || 0);
                    if (allocatedQty > 0) {
                        const chip = document.createElement('span');
                        chip.className = 'px-2 py-1 bg-white border rounded text-xs';
                        chip.textContent = `${machine.mach_type}: ${allocatedQty}`;
                        chipsRow.appendChild(chip);
                    }
                });
                
                lineCard.appendChild(chipsRow);
            }

            // Deallocate button row
            const actionsRow = document.createElement('div');
            actionsRow.className = 'flex justify-end mt-2';
            const deallocateBtn = document.createElement('button');
            deallocateBtn.className = 'deallocate-button px-3 py-1 rounded-md text-xs bg-red-500 text-white hover:bg-red-600';
            deallocateBtn.textContent = 'Deallocate';
            deallocateBtn.setAttribute('data-line-id', lineId);
            actionsRow.appendChild(deallocateBtn);
            lineCard.appendChild(actionsRow);

            allocatedContainer.appendChild(lineCard);

            // Wire deallocate behavior
            deallocateBtn.addEventListener('click', function() {
                // Get required parameters for AJAX call
                const unitId = currentSelectedUnit || document.getElementById('unit_dropdown')?.value || '';
                const portalType = window.portalType || 'gut_new';
                const groupId = activeGroupId || '';
                const lineId = this.getAttribute('data-line-id') || '';
                
                // Make AJAX call for deallocation
                fetch('/allocatedline_delete', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    },
                    body: JSON.stringify({
                        unitid: unitId,
                        portaltype: portalType,
                        groupid: groupId,
                        lineid: lineId
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Proceed with UI updates after successful deallocation
                        // Find the corresponding line in unallocated lines
                        const unallocatedHeader = Array.from(document.querySelectorAll('h2.font-medium.text-gray-700.text-lg'))
                            .find(h2 => h2.textContent.trim() === 'Unallocated Lines');
                        if (!unallocatedHeader) return;
                        
                        const wrapper = unallocatedHeader.closest('div.bg-white.shadow-md.rounded-lg.p-5');
                        if (!wrapper) return;
                        
                        const listContainer = wrapper.querySelector('div.space-y-4');
                        if (!listContainer) return;

                        // Create a new unallocated line card
                        const newCard = document.createElement('div');
                        newCard.className = 'bg-gray-50 p-4 rounded-lg shadow-sm border border-gray-200';
                        newCard.setAttribute('data-rowid', lineId);

                        // Reuse header from allocated card
                        const clonedHeader = header.cloneNode(true);
                        newCard.appendChild(clonedHeader);

                        // Reuse machines from allocated card
                        const clonedChips = lineCard.querySelector('.flex.flex-wrap.gap-2.mt-3');
                        if (clonedChips) {
                            newCard.appendChild(clonedChips.cloneNode(true));
                        }

                        // Add tools row (reallocate icon + Allocate button)
                        const toolsRow = document.createElement('div');
                        toolsRow.className = 'flex items-center justify-end gap-3 mt-2';

                        const icon = document.createElement('i');
                        icon.className = 'fa-solid fa-pen-to-square text-gray-600 text-lg cursor-pointer open-reallocate-pop';
                        icon.setAttribute('data-target-line', `Line ${lineId}`);
                        icon.setAttribute('data-rowid', lineId);

                        const allocBtn = document.createElement('button');
                        allocBtn.className = 'allocate-button bg-blue-500 text-white px-3 py-1 rounded-md text-sm';
                        allocBtn.setAttribute('data-line-name', `Line ${lineId}`);
                        allocBtn.disabled = false;
                        allocBtn.textContent = 'Allocate';

                        toolsRow.appendChild(icon);
                        toolsRow.appendChild(allocBtn);
                        newCard.appendChild(toolsRow);

                        // Insert in sorted position
                        insertCardInSortedPosition(listContainer, newCard, `Line ${lineId}`);

                        // Wire behaviors for the recreated card
                        attachAllocateHandler(allocBtn);

                        // Remove allocated card from group
                        lineCard.parentNode.removeChild(lineCard);

                        // Update machine requirements after deallocation
                        if (activeGroupName && groupEditCC) {
                            fetchGroupDetails(groupEditCC.textContent, currentSelectedUnit, activeGroupId);
                        }
                    } else {
                        toastr.error(data.message || 'Deallocation failed');
                    }
                })
                .catch(error => {
                    console.error('Error deallocating line:', error);
                    toastr.error('Error deallocating line');
                });
            });
        });
    }

    // Save allocation button event listener
    document.addEventListener('DOMContentLoaded', function() {
        const saveAllocationButton = document.getElementById('saveallocationbutton');
        
        if (saveAllocationButton) {
            saveAllocationButton.addEventListener('click', async function() {
                try {
                    // Get current values from the group edit modal
                    const unitId = currentSelectedUnit || document.getElementById('unit_dropdown')?.value || '';
                    const groupId = activeGroupId || '';
                    const output = document.getElementById('groupEditOutputSelect')?.value || '1';
                    const portalType = window.portalType || 'gut_new';
                    
                    if (!unitId || !groupId) {
                        toastr.error('Unit ID and Group ID are required');
                        return;
                    }
                    
                    // Collect machine summary data from the machine requirements cards
                    const machineSummary = [];
                    const machineCards = document.querySelectorAll('.grid.grid-cols-4.gap-4 .bg-yellow-50');
                    
                    machineCards.forEach(card => {
                        const machineType = card.querySelector('p.text-gray-600.text-sm')?.textContent?.trim() || '';
                        const requirementText = card.querySelector('p.text-xl span.text-gray-500')?.textContent || '';
                        const match = requirementText.match(/\/\s*(\d+)/);
                        const totalMach = match ? parseInt(match[1]) : 0;
                        
                        // Get allocated count from the first part of the text
                        const allocatedText = card.querySelector('p.text-xl')?.textContent?.trim() || '';
                        const allocatedMatch = allocatedText.match(/^(\d+)/);
                        const allocatedMach = allocatedMatch ? parseInt(allocatedMatch[1]) : 0;
                        
                        if (machineType) {
                            machineSummary.push({
                                mach_type: machineType,
                                total_mach: totalMach.toString(),
                                allocated_mach: allocatedMach.toString(),
                                output: output
                            });
                        }
                    });
                    
                    // Collect allocated lines data from the allocated lines container
                    const allocatedLinewise = [];
                    const allocatedLineCards = document.querySelectorAll('#allocatedlinescontainer .bg-white.border.border-gray-200');
                    
                    allocatedLineCards.forEach(card => {
                        const lineIdText = card.querySelector('h3.font-medium')?.textContent?.trim() || '';
                        const lineIdMatch = lineIdText.match(/Line\s+(\d+)/);
                        const lineId = lineIdMatch ? parseInt(lineIdMatch[1]) : 0;
                        
                        const machines = [];
                        const machineChips = card.querySelectorAll('.flex.flex-wrap.gap-2.mt-3 span');
                        
                        machineChips.forEach(chip => {
                            const chipText = chip.textContent?.trim() || '';
                            const chipMatch = chipText.match(/(.+):\s*(\d+)/);
                            
                            if (chipMatch) {
                                const machType = chipMatch[1].trim();
                                const allocatedMach = chipMatch[2].trim();
                                
                                machines.push({
                                    mach_type: machType,
                                    allocated_mach: allocatedMach,
                                    pending_qty: 0 // Default to 0, can be updated if needed
                                });
                            }
                        });
                        
                        if (lineId > 0 && machines.length > 0) {
                            allocatedLinewise.push({
                                line_id: lineId,
                                machines: machines
                            });
                        }
                    });
                    
                    // Prepare the payload
                    const payload = {
                        portaltype: portalType,
                        unitid: unitId,
                        groupid: groupId,
                        output: output,
                        mch_summary: machineSummary,
                        allocated_linewise: allocatedLinewise
                    };
                    
                    console.log('Saving allocation data:', payload);
                    
                    // Make the AJAX call
                    const response = await fetch('/saveallocationgroup', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                        },
                        body: JSON.stringify(payload)
                    });
                    
                    const result = await response.json();
                    
                    if (result.success) {
                        toastr.success('Allocation saved successfully!');
                        // Optionally close the modal or refresh data
                        // document.getElementById('groupedit').classList.add('hidden');
                    } else {
                        toastr.error('Error: ' + (result.message || 'Failed to save allocation'));
                    }
                    
                } catch (error) {
                    console.error('Error saving allocation:', error);
                    toastr.error('Network error. Please try again.');
                }
            });
        }
    });

    // Function to fetch group details from API
    async function fetchGroupDetails(groupCC, unitId, groupId = null) {
        try {
            const portalType = window.portalType || 'gut_new';
            let url = `/gut_sewinglinegroup?portaltype=${portalType}&ccno=${groupCC}&unitid=${unitId}&linegroupid=${groupId}`;
            
            // Clear allocated lines container before populating fresh data
            const allocatedContainer = document.getElementById('allocatedlinescontainer');
            if (allocatedContainer) {
                allocatedContainer.innerHTML = '';
            }
            
            const response = await fetch(url);
            const data = await response.json();

            if (data.success) {
                // Store calendar data (if present) for SLG highlighting
                if (data.calendar) {
                    window.slgCalendarData = data.calendar;
                }

                if (data.data) updateBufferDetails(data.data);

                // Populate machine requirements from mch_summary
                if (data.mch_summary) {
                    populateMachineRequirements(data.mch_summary);
                }
                
                // Populate line cards from linedata
                if (data.linedata && data.linedata.length > 0) {
                    updateLineDetails(data.linedata);
                }
                
                // Populate allocated lines container from allocated_linewise
                if (data.allocated_linewise) {
                    populateAllocatedLines(data.allocated_linewise);
                }

                // Re-apply SLG highlights now that we have fresh calendar data
                if (typeof applySlgStoredHighlights === 'function') {
                    setTimeout(() => applySlgStoredHighlights(), 100);
                }
            } else {
                console.error('No data found in response');
            }
        } catch (error) {
            console.error('Error fetching group details:', error);
        }
    }

    // Helper: insert card in correct sorted position by line number
    function insertCardInSortedPosition(container, newCard, lineName) {
        // Extract line number from line name (e.g., "Line 1" -> 1, "Buffer" -> 0)
        const getLineNumber = (name) => {
            if (name === 'Buffer') return 0;
            const match = name.match(/Line\s+(\d+)/);
            return match ? parseInt(match[1]) : 999;
        };

        const newCardNumber = getLineNumber(lineName);
        
        // Get all existing line cards (excluding buffer)
        const existingCards = Array.from(container.children).filter(card => {
            const header = card.querySelector('h3.font-medium');
            if (!header) return false;
            const cardName = header.textContent.trim();
            return cardName !== 'Buffer';
        });

        // Find the correct position to insert
        let insertBefore = null;
        for (const card of existingCards) {
            const header = card.querySelector('h3.font-medium');
            const cardName = header.textContent.trim();
            const cardNumber = getLineNumber(cardName);
            
            if (newCardNumber < cardNumber) {
                insertBefore = card;
                break;
            }
        }

        // Insert at the correct position
        if (insertBefore) {
            container.insertBefore(newCard, insertBefore);
        } else {
            // If no position found, append at the end (after buffer)
            const bufferCard = container.querySelector('.bg-gray-50.p-4.rounded-lg.shadow-sm.border.border-gray-200');
            if (bufferCard && bufferCard !== newCard) {
                container.insertBefore(newCard, bufferCard.nextSibling);
            } else {
                container.appendChild(newCard);
            }
        }
    }

    // Helper: wire Allocate behavior for a given button
    function attachAllocateHandler(button) {
        if (this.disabled || !activeGroupName || !groupEditModal) {
            return;
        }

		button.addEventListener('click', function() {

			const lineName = this.getAttribute('data-line-name') || '';
			if (!lineName) return;

			// Find the unallocated line card
			const lineCard = this.closest('div.bg-gray-50.p-4.rounded-lg.shadow-sm.border.border-gray-200');
			if (!lineCard) return;

			// Find Allocated Lines container
			const allocatedBox = groupEditModal.querySelector('h3.text-gray-800.font-medium.mt-6.mb-2 + div.border');
			if (!allocatedBox) return;

			// Temporarily disable the button to prevent double-clicks
			this.disabled = true;

			// Optimistically build the allocated card (we'll only append it on success)
			const allocatedCard = document.createElement('div');
			allocatedCard.className = 'bg-white border border-gray-200 rounded-md p-3 mb-2 flex flex-col shadow-sm';

			const header = lineCard.querySelector('div.flex.justify-between.items-center');
			let clonedHeader = null;
			if (header) {
				clonedHeader = header.cloneNode(true);
				allocatedCard.appendChild(clonedHeader);
			}

			const chipsRow = lineCard.querySelector('div.flex.flex-wrap.gap-2.mt-3');
			if (chipsRow) {
				allocatedCard.appendChild(chipsRow.cloneNode(true));
			}

			const actionsRow = document.createElement('div');
			actionsRow.className = 'flex justify-end mt-2';
			const deallocateBtn = document.createElement('button');
			deallocateBtn.className = 'deallocate-button px-3 py-1 rounded-md text-xs bg-red-500 text-white hover:bg-red-600';
			deallocateBtn.textContent = 'Deallocate';
			actionsRow.appendChild(deallocateBtn);
			allocatedCard.appendChild(actionsRow);

			// ----- API CALL -----
			(async () => {
				try {
					const portalType = window.portalType || 'gut_new';
					const unitId = currentSelectedUnit || document.getElementById('unit_dropdown')?.value || '';
					const ccNo = groupEditCC ? groupEditCC.textContent : '';
					const lineId = lineCard.getAttribute('data-rowid') || '';
					const output = groupEditOutputSelect ? groupEditOutputSelect.value : '1';

					if (!unitId || !ccNo || !lineId) {
						toastr.error('Missing required data for allocation.');
						this.disabled = false;
						return;
					}

					const url = `/gut_sewingline_allocated?portaltype=${portalType}&unitid=${unitId}&ccno=${ccNo}&linegroupid=${activeGroupId}&lineid=${lineId}&output=${output}`;

					const response = await fetch(url);
					const data = await response.json();

					// ----- HANDLE FAILURE -----
					if (!data.success) {
						toastr.error(data.message || 'Allocation failed.');
						// Do NOT move the card — just re-enable the button
						this.disabled = false;
						return;
					}

					// ----- SUCCESS PATH -----
					// Now it's safe to move the card
					allocatedBox.appendChild(allocatedCard);

					// Remove from unallocated lines
					lineCard.parentNode.removeChild(lineCard);

					// Update machine requirements & allocated lines list (if provided)
					if (data.mch_summary) {
						populateMachineRequirements(data.mch_summary);
					}
					if (data.allocated_linewise) {
						populateAllocatedLines(data.allocated_linewise);
					}

					// Adjust heights
					setTimeout(() => {
						adjustAllocatedLinesContainerHeight();
						adjustGroupEditHeight();
					}, 100);

				} catch (error) {
					console.error('Error calling allocation API:', error);
					toastr.error('An unexpected error occurred.');
					this.disabled = false;
					return;
				}
			})();

				// Wire deallocate behavior: move card back to Unallocated Lines
				deallocateBtn.addEventListener('click', function() {
					// Locate Unallocated Lines list container
					const unallocatedHeader = Array.from(document.querySelectorAll('h2.font-medium.text-gray-700.text-lg'))
						.find(h2 => h2.textContent.trim() === 'Unallocated Lines');
					if (!unallocatedHeader) return;
					const wrapper = unallocatedHeader.closest('div.bg-white.shadow-md.rounded-lg.p-5');
					if (!wrapper) return;
					const listContainer = wrapper.querySelector('div.space-y-4');
					if (!listContainer) return;

					// Create a new unallocated line card from the allocatedCard content
					const newCard = document.createElement('div');
					newCard.className = 'bg-gray-50 p-4 rounded-lg shadow-sm border border-gray-200';

					// Reuse header and chips from allocated card
					const allocHeader = clonedHeader || allocatedCard.querySelector('div.flex.justify-between.items-center');
					const allocChips = allocatedCard.querySelector('div.flex.flex-wrap.gap-2.mt-3');

					if (allocHeader) {
						newCard.appendChild(allocHeader.cloneNode(true));
					}

					if (allocChips) {
						newCard.appendChild(allocChips.cloneNode(true));
					}

					// Add tools row (reallocate icon + disabled Allocate button)
					const toolsRow = document.createElement('div');
					toolsRow.className = 'flex items-center justify-end gap-3 mt-2';

					const icon = document.createElement('i');
					icon.className = 'fa-solid fa-pen-to-square text-gray-600 text-lg cursor-pointer open-reallocate-pop';
					icon.setAttribute('data-target-line', lineName);

					const allocBtn = document.createElement('button');
					allocBtn.className = 'allocate-button bg-blue-500 text-white px-3 py-2 rounded-md text-sm hover:bg-blue-600 cursor-pointer';
					allocBtn.setAttribute('data-line-name', lineName);
					allocBtn.disabled = false; // immediately active after deallocate
					allocBtn.textContent = 'Allocate';

					toolsRow.appendChild(icon);
					toolsRow.appendChild(allocBtn);
					newCard.appendChild(toolsRow);

					// Insert the card in the correct sorted position by line number
					insertCardInSortedPosition(listContainer, newCard, lineName);

					// Wire behaviors for the recreated card
					if (reallocatePopModal) {
						icon.addEventListener('click', function() {
							const targetLine = this.getAttribute('data-target-line') || '';

							if (targetLineTitle) {
								targetLineTitle.textContent = targetLine;
							}

							if (targetLineInput) {
								targetLineInput.value = targetLine;
							}

							reallocatePopModal.classList.remove('hidden');
						});
					}

					// Allow this button to allocate again when a group is active
					attachAllocateHandler(allocBtn);

					// Remove allocated card from group
					allocatedCard.parentNode.removeChild(allocatedCard);
                
					// Adjust container heights after deallocation
					setTimeout(() => {
						adjustAllocatedLinesContainerHeight();
						adjustGroupEditHeight();
					}, 100);
				});
        });
    }

    function updateLineDetails(lineData) {
        const linesContainer = document.querySelector('.space-y-4');
        if (!linesContainer) return;

        // Find the buffer card (we'll insert lines after it)
        const bufferCard = document.querySelector('.bg-gray-50.p-4.rounded-lg.shadow-sm.border.border-gray-200');
        if (!bufferCard) return;

        // Remove existing line cards except the buffer
        const allLineCards = Array.from(document.querySelectorAll('.bg-gray-50.p-4.rounded-lg.shadow-sm.border.border-gray-200'));
        allLineCards.forEach(card => {
            if (card !== bufferCard) {
                card.remove();
            }
        });

        // Sort line data by line number in ascending order
        
        lineData.sort((a, b) => {
            const lineA = parseInt(a.Line_No) || 0;
            const lineB = parseInt(b.Line_No) || 0;
            
            return lineA - lineB; // Ascending: 1, 2, 3, 4...
        });
       
        // Add new line cards
        lineData.forEach(line => {
            // Calculate total machines from line's machines array
            const totalMachines = line.machines ? line.machines.reduce((sum, machine) => sum + parseInt(machine.quantity || 0), 0) : 0;
            
            const lineCard = document.createElement('div');
            lineCard.className = 'bg-gray-50 p-4 rounded-lg shadow-sm border border-gray-200';
            lineCard.setAttribute('data-rowid', line.Rowid);
            lineCard.innerHTML = `
                <div class="flex justify-between items-center">
                    <h3 class="font-medium">Line ${line.Line_No}</h3>
                    <span class="text-sm text-gray-500">${totalMachines} Machines</span>
                </div>
                <div class="flex items-center justify-end gap-3">
                    <i class="fa-solid fa-pen-to-square text-gray-600 text-lg cursor-pointer open-reallocate-pop" 
                    data-target-line="Line ${line.Line_No}" data-unit="${line.Unit_Code}" data-rowid="${line.Rowid}"></i>
                    <button class="allocate-button bg-blue-500 text-white px-3 py-1 rounded-md text-sm" data-line-name="Line ${line.Line_No}">
                        Allocate
                    </button>
                </div>
                <div class="flex flex-wrap gap-2 mt-3">
                    ${line.machines && line.machines.length > 0 ? 
                        line.machines.filter(machine => parseInt(machine.quantity || 0) > 0)
                            .map(machine => `<span class="px-2 py-1 bg-white border rounded text-xs">${machine.machine}: ${machine.quantity}</span>`)
                            .join('') : 
                        '<!-- No machines with pending quantity -->'}
                </div>
            `;
            
            // Append to container to maintain sorted order
            bufferCard.parentNode.appendChild(lineCard);
            
            // Attach allocate handler to the new button
            const newAllocateBtn = lineCard.querySelector('.allocate-button');
            if (newAllocateBtn) {
                attachAllocateHandler(newAllocateBtn);
            }
        });
        
        // Update allocate buttons based on modal visibility for newly created lines
        updateAllocateButtonsBasedOnGroupEditVisibility();
    }

    // Machine Allocations Management

    document.addEventListener('DOMContentLoaded', function () {
        const reallocatePopModal = document.getElementById('reallocatepop');
        const targetLineTitle = document.getElementById('targetLineTitle');
        const targetLineInput = document.getElementById('targetLineInput');
        const machineAllocations = document.getElementById('machineAllocations');
        const addMachineBtn = document.getElementById('addMachineBtn');
        const machineTemplate = document.getElementById('machineAllocationTemplate');

        let availableMachineData = [];  // Full objects with Pending
        let currentTargetLine = '';
        let currentTargetRowId = '';
        let currentUnitCode = '';

        // Add one allocation row with validation + max display
        function addMachineAllocationRow() {
            const clone = machineTemplate.content.cloneNode(true);
            const row = clone.querySelector('.machine-allocation-row');
            const select = row.querySelector('.machine-type-select');
            const quantityInput = row.querySelector('.quantity-input');
            const removeBtn = row.querySelector('.remove-machine-btn');

            // Helper text below quantity
            const helperText = document.createElement('p');
            helperText.className = 'text-xs text-gray-500 mt-1 ml-1';
            helperText.textContent = 'Max available: 0';
            quantityInput.parentNode.appendChild(helperText);

            // When machine type is selected → set max
            select.addEventListener('change', function () {
                const selectedType = this.value.trim();
                const machine = availableMachineData.find(m => m.MAchine_Type.trim() === selectedType);
                const max = machine ? parseInt(machine.Pending || machine.Pending_qty || 0) : 0;

                helperText.textContent = `Max available: ${max}`;
                quantityInput.max = max;
                quantityInput.disabled = max === 0;
                // Only set default if field is empty or zero
                if (!quantityInput.value || parseInt(quantityInput.value) === 0) {
                    quantityInput.value = max > 0 ? 1 : '';
                }
            });

            // Real-time input validation
            quantityInput.addEventListener('input', function () {
                let val = this.value.trim();

                // Allow empty input while typing
                if (val === '') {
                    return;
                }

                let num = parseInt(val, 10);

                // If not a number, clear it
                if (isNaN(num)) {
                    this.value = '';
                    return;
                }

                const max = parseInt(this.max) || 0;

                // Only clamp if user typed something invalid
                if (num > max && max > 0) {
                    this.value = max;
                } else if (num < 1 && max > 0) {
                    this.value = 1;
                } else if (max === 0) {
                    this.value = '';
                }
            });

            removeBtn.addEventListener('click', () => {
                row.remove();
                updateMachineTypeDropdowns();
            });

            select.addEventListener('change', updateMachineTypeDropdowns);
            machineAllocations.appendChild(row);
            updateMachineTypeDropdowns();
            setTimeout(() => select.focus(), 10);
        }

        // Refresh dropdowns and show available count
        function updateMachineTypeDropdowns() {
            const selects = document.querySelectorAll('.machine-type-select');
            const used = new Set(Array.from(selects).map(s => s.value).filter(Boolean));

            selects.forEach(select => {
                const current = select.value;
                select.innerHTML = '<option value="">Select Machine Type</option>';

                availableMachineData.forEach(item => {
                    const type = item.MAchine_Type.trim();
                    const pending = parseInt(item.Pending || item.Pending_qty || 0);
                    if (pending <= 0) return;

                    const opt = document.createElement('option');
                    opt.value = type;
                    opt.textContent = `${type} `;
                    if (used.has(type) && type !== current) opt.disabled = true;
                    select.appendChild(opt);
                });

                select.value = current;
            });
        }

        // Open modal: set target line + populate source dropdown
        document.addEventListener('click', function (e) {
            const icon = e.target.closest('.open-reallocate-pop, .open-reallocate-pop-buffer');
            if (!icon) return;

            currentTargetLine = icon.getAttribute('data-target-line') || 'Buffer';
            currentTargetRowId = icon.getAttribute('data-rowid') || '0';
            currentUnitCode = document.getElementById('unit_dropdown')?.value || currentSelectedUnit;

            if (!currentUnitCode) {
                toastr.error('Please select a Unit first.');
                return;
            }

            targetLineTitle.textContent = currentTargetLine;
            targetLineInput.value = currentTargetLine;

            machineAllocations.innerHTML = `
                <div class="text-center py-8 text-gray-500">
                    <p>Please select a <strong>Source Line</strong> to see available machines.</p>
                </div>
            `;

            // Populate Source Line dropdown
            const sourceSelect = document.getElementById('sourceLineSelect');
            if (sourceSelect) {
                sourceSelect.innerHTML = '<option value="">Select Source Line</option>';
                
                // Add Buffer only if target is not Buffer
                if (currentTargetLine !== 'Buffer') {
                    const bufferOpt = document.createElement('option');
                    bufferOpt.value = '0';
                    bufferOpt.textContent = 'Buffer';
                    bufferOpt.setAttribute('data-line-number', '0');
                    bufferOpt.setAttribute('data-row-id', '0');
                    sourceSelect.appendChild(bufferOpt);
                }

                // Collect all real lines and sort by line number
                const linesArray = [];
                document.querySelectorAll('.open-reallocate-pop[data-rowid]:not(.open-reallocate-pop-buffer)').forEach(ic => {
                    const name = ic.getAttribute('data-target-line');
                    const id = ic.getAttribute('data-rowid');
                    if (name && id && name !== currentTargetLine) {
                        const lineNumber = name.includes('Line') ? parseInt(name.replace('Line ', '').trim()) : 0;
                        linesArray.push({
                            name: name,
                            id: id,
                            lineNumber: lineNumber,
                            element: ic
                        });
                    }
                });

                // Sort by line number ascending
                linesArray.sort((a, b) => a.lineNumber - b.lineNumber);

                // Add sorted options to dropdown
                linesArray.forEach(line => {
                    const opt = document.createElement('option');
                    // Extract line number from name (e.g., "Line 56" -> 56) but store rowid for API calls
                    const lineNumber = line.name.includes('Line') ? line.name.replace('Line ', '').trim() : line.id;
                    opt.value = line.id; // Keep rowid for API calls
                    opt.setAttribute('data-line-number', lineNumber); // Store line number separately
                    opt.setAttribute('data-row-id', line.id); // Store rowid for payload
                
                    opt.textContent = line.name;
                    sourceSelect.appendChild(opt);
                });
            }

            reallocatePopModal.classList.remove('hidden');
        });

        // MAIN: Source Line changed → Load machines from API
        document.getElementById('sourceLineSelect')?.addEventListener('change', async function () {
            const sourceId = this.value; // This is still the rowid, but we need line number for API
            if (!sourceId || !currentUnitCode) return;

            // Get line number from selected option for API call
            const selectedOption = this.options[this.selectedIndex];
            const lineNumber = selectedOption?.getAttribute('data-line-number') || sourceId;

            machineAllocations.innerHTML = '<p class="text-center py-6 text-gray-600">Loading...</p>';

            try {
                const res = await fetch(`/line_buffer_machine_details?unittype=${currentUnitCode}&portaltype=${window.portalType || 'gut_new'}&source=${lineNumber}`);
                const json = await res.json();

                if (json.success && Array.isArray(json.data)) {
                    availableMachineData = json.data.filter(m => {
                        const p = parseInt(m.Pending || m.Pending_qty || 0);
                        return p > 0;
                    });

                    machineAllocations.innerHTML = '';
                    if (availableMachineData.length > 0) {
                        addMachineAllocationRow();
                    } else {
                        machineAllocations.innerHTML = '<p class="text-center py-6 text-orange-600">No machines available.</p>';
                    }
                } else {
                    machineAllocations.innerHTML = '<p class="text-center py-6 text-red-600">No data received.</p>';
                    availableMachineData = [];
                }
            } catch (err) {
                console.error(err);
                machineAllocations.innerHTML = '<p class="text-center py-6 text-red-600">Failed to load.</p>';
                availableMachineData = [];
            }
        });

        // Add more rows
        addMachineBtn?.addEventListener('click', addMachineAllocationRow);

        // Close modal
        document.getElementById('closeReallocatePopModal')?.addEventListener('click', () => {
            resetReallocateModal();
        });

        // Cancel button with reset functionality
        document.getElementById('cancelReallocateBtn')?.addEventListener('click', () => {
            resetReallocateModal();
        });

        // Function to reset reallocate modal fields
        function resetReallocateModal() {
            // Reset all fields before closing
            const sourceSelect = document.getElementById('sourceLineSelect');
            const machineAllocations = document.getElementById('machineAllocations');
            
            // Reset source line dropdown
            if (sourceSelect) {
                sourceSelect.selectedIndex = 0;
            }
            
            // Clear machine allocations
            if (machineAllocations) {
                machineAllocations.innerHTML = `
                    <div class="text-center py-8 text-gray-500">
                        <p>Please select a <strong>Source Line</strong> to see available machines.</p>
                    </div>
                `;
            }
            
            // Reset global variables
            availableMachineData = [];
            currentTargetLine = '';
            currentTargetRowId = '';
            currentUnitCode = '';
            
            reallocatePopModal.classList.add('hidden');
        }

        // Confirm & Move — Collect all data and send to backend
        document.getElementById('confirmMoveBtn')?.addEventListener('click', async function () {
            const sourceSelect = document.getElementById('sourceLineSelect');
            const targetLine = currentTargetLine; // already stored when opening modal
            
            // Get source line number from selected option (for payload)
            const selectedOption = sourceSelect.options[sourceSelect.selectedIndex];
            const sourceLineNumber = selectedOption?.getAttribute('data-line-number') || sourceSelect?.value || '0';
            const sourcerowid = selectedOption?.getAttribute('data-row-id') || '0';
            // Extract line number for target (e.g., "Line 56" -> 56, Buffer -> "0")
            const targetLineNumber = targetLine === 'Buffer' ? '0' : 
                (targetLine.includes('Line') ? targetLine.replace('Line ', '').trim() : '0');

            const sourceId = sourceSelect?.value || ''; // This is still the rowid for API calls
            if (!sourceId) {
                toastr.error('Please select a source line.');
                return;
            }

            // Collect all allocation rows
            const rows = document.querySelectorAll('.machine-allocation-row');
            const machines = [];

            let hasError = false;

            rows.forEach(row => {
                const select = row.querySelector('.machine-type-select');
                const qtyInput = row.querySelector('.quantity-input');

                const machineType = select?.value.trim();
                const selectedQty = parseInt(qtyInput?.value) || 0;

                if (!machineType || selectedQty <= 0) {
                    hasError = true;
                    qtyInput?.classList.add('border-red-500');
                    return;
                } else {
                    qtyInput?.classList.remove('border-red-500');
                }

                // Find original pending from availableMachineData
                const machineInfo = availableMachineData.find(m => m.MAchine_Type.trim() === machineType);
                const pendingQty = machineInfo ? parseInt(machineInfo.Pending || machineInfo.Pending_qty || 0) : 0;

                machines.push({
                    machine_type: machineType,
                    pending_qty: pendingQty,
                    selected_qty: selectedQty
                });
            });

            if (hasError || machines.length === 0) {
                toastr.error('Please select machine type and valid quantity for all rows.');
                return;
            }

            const payload = {
                portaltype: window.portalType || 'gut_new',
                unitcode: currentUnitCode,
                source: sourceLineNumber,   // Line number (e.g., "56") or "0" for Buffer
                target: targetLineNumber,   // Line number (e.g., "56") or "0" for Buffer
                sourcerowid: sourcerowid,
                targetrowid: currentTargetRowId,
                machines: machines
            };

            console.log('Sending:', payload); // Remove in production

            try {
                const response = await fetch('/allocatemachined', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    },
                    body: JSON.stringify(payload)
                });

                const result = await response.json();

                if (result.success) {
                    toastr.success('Machines moved successfully!');
                    reallocatePopModal.classList.add('hidden');

                    // Optional: Refresh page or update UI
                    location.reload(); // or smarter UI update
                } else {
                    toastr.error('Error: ' + (result.message || 'Failed to move machines'));
                }
            } catch (err) {
                console.error(err);
                toastr.error('Network error. Please try again.');
            }
        });

    });

    // Factory Calendar Functionality
    document.addEventListener('DOMContentLoaded', function() {
        const factorySettingDropdown = document.getElementById('factorySettingDropdown');
        const factoryCalendarConfirmBtn = document.getElementById('factoryCalendarConfirmBtn');
        const calendarPopModal = document.getElementById('calenderpop');
        
        // Store selected dates
        let selectedDates = {
            holiday: new Set(),
            overtime: new Set()
        };
        
        // Load existing dates from storage (if any)
        loadStoredDates();
        
        // Add click handlers to calendar days
        function addCalendarClickHandlers() {
            const calendarDays = document.querySelectorAll('#factoryCalLeftDays .calendar-day, #factoryCalRightDays .calendar-day');
            
            calendarDays.forEach(day => {
                day.addEventListener('click', function() {
                    const setting = factorySettingDropdown.value;
                    if (!setting) {
                        toastr.warning('Please select a setting (Holiday or Overtime) first.');
                        return;
                    }
                    
                    const date = this.dataset.date;
                    if (!date) return;
                    
                    toggleDateSelection(this, date, setting);
                });
            });
        }
        
        // Toggle date selection
        function toggleDateSelection(element, date, setting) {
            const isSelected = selectedDates[setting].has(date);
            
            if (isSelected) {
                // Remove selection
                selectedDates[setting].delete(date);
                element.classList.remove(`${setting}-date`);
            } else {
                // Add selection
                selectedDates[setting].add(date);
                element.classList.add(`${setting}-date`);
                
                // Remove from other setting if exists
                const otherSetting = setting === 'holiday' ? 'overtime' : 'holiday';
                if (selectedDates[otherSetting].has(date)) {
                    selectedDates[otherSetting].delete(date);
                    element.classList.remove(`${otherSetting}-date`);
                }
            }
        }
        
        // Load stored dates
        function loadStoredDates() {
            // In a real application, you would load this from the server
            // For now, we'll use localStorage as an example
            const stored = localStorage.getItem('factoryCalendarDates');
            if (stored) {
                const data = JSON.parse(stored);
                selectedDates.holiday = new Set(data.holiday || []);
                selectedDates.overtime = new Set(data.overtime || []);
            }
        }
        
        // Save dates to storage
        function saveDates() {
            const data = {
                holiday: Array.from(selectedDates.holiday),
                overtime: Array.from(selectedDates.overtime)
            };
            localStorage.setItem('factoryCalendarDates', JSON.stringify(data));
        }
        
        // Apply stored highlights to FACTORY calendar only
        function applyStoredHighlights() {
            selectedDates.holiday.forEach(date => {
                const elements = document.querySelectorAll(
                    `#factoryCalLeftDays [data-date="${date}"], #factoryCalRightDays [data-date="${date}"]`
                );
                elements.forEach(el => el.classList.add('holiday-date'));
            });
            
            selectedDates.overtime.forEach(date => {
                const elements = document.querySelectorAll(
                    `#factoryCalLeftDays [data-date="${date}"], #factoryCalRightDays [data-date="${date}"]`
                );
                elements.forEach(el => el.classList.add('overtime-date'));
            });
        }
        
        // Update calendar when month changes
        function updateCalendarHighlights() {
            setTimeout(() => {
                applyStoredHighlights();
                addCalendarClickHandlers();
            }, 100);
        }
        
        // Factory calendar navigation
        const factoryPrevBtn = document.getElementById('factoryCalPrev');
        const factoryNextBtn = document.getElementById('factoryCalNext');
        
        if (factoryPrevBtn) {
            factoryPrevBtn.addEventListener('click', updateCalendarHighlights);
        }
        
        if (factoryNextBtn) {
            factoryNextBtn.addEventListener('click', updateCalendarHighlights);
        }
        
        // Confirm button handler
        if (factoryCalendarConfirmBtn) {
            factoryCalendarConfirmBtn.addEventListener('click', function() {
                // Save the dates
                saveDates();
                
                // Here you would also send the data to the server
                const data = {
                    holiday: Array.from(selectedDates.holiday),
                    overtime: Array.from(selectedDates.overtime)
                };
                
                console.log('Saving calendar data:', data);
                
                // In a real application, you would send this to your backend
                // fetch('/save-factory-calendar', {
                //     method: 'POST',
                //     headers: {
                //         'Content-Type': 'application/json',
                //         'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                //     },
                //     body: JSON.stringify(data)
                // });
                
                toastr.success('Calendar settings saved successfully!');
                calendarPopModal.classList.add('hidden');
            });
        }
        
        // Initialize calendar highlights after the calendar is rendered
        setTimeout(() => {
            applyStoredHighlights();
            addCalendarClickHandlers();
        }, 500);
        
        // SLG Calendar Functionality
        const slgSettingDropdown = document.getElementById('slgSettingDropdown');
        const slgCalendarConfirmBtn = document.getElementById('slgCalendarConfirmBtn');
        const slgCalendarPopModal = document.getElementById('slgcalenderpop');
        
        // Store selected dates for SLG
        let slgSelectedDates = {
            holiday: new Set(),
            overtime: new Set()
        };

        // Active group's date range (from/to) for SLG view
        window.activeGroupFromDate = window.activeGroupFromDate || null;
        window.activeGroupToDate   = window.activeGroupToDate   || null;

        // Reset SLG selections and visual highlights (used when switching groups)
        function resetSlgSelections() {
            // Clear in-memory sets
            slgSelectedDates.holiday.clear();
            slgSelectedDates.overtime.clear();

            // Clear persisted local storage for SLG
            try {
                localStorage.removeItem('slgCalendarDates');
            } catch (e) {
                console.warn('Unable to clear slgCalendarDates from localStorage', e);
            }

            // Remove highlight classes from SLG calendar cells
            const allDays = document.querySelectorAll('#slgCalLeftDays .calendar-day, #slgCalRightDays .calendar-day');
            allDays.forEach(day => {
                day.classList.remove('local-holiday-date', 'local-overtime-date', 'slg-range-date');
            });
        }

        // Highlight the group's date range on the SLG calendar
        function applySlgRangeHighlight() {
            if (!window.activeGroupFromDate || !window.activeGroupToDate) return;

            const from = new Date(window.activeGroupFromDate);
            const to   = new Date(window.activeGroupToDate);

            if (isNaN(from.getTime()) || isNaN(to.getTime())) return;

            from.setHours(0, 0, 0, 0);
            to.setHours(0, 0, 0, 0);

            const allDays = document.querySelectorAll('#slgCalLeftDays .calendar-day, #slgCalRightDays .calendar-day');

            allDays.forEach(day => {
                const dateStr = day.dataset.date;
                if (!dateStr) return;

                const d = new Date(dateStr);
                if (isNaN(d.getTime())) return;
                d.setHours(0, 0, 0, 0);

                // Inside group's date range -> normal text
                if (d >= from && d <= to) {
                    day.classList.add('slg-range-date');
                    day.classList.remove('text-gray-400');
                    // Reset inline color so the normal color applies
                    day.style.color = '';
                } else {
                    // Outside range -> grey text to indicate restricted
                    day.classList.remove('slg-range-date');
                    day.classList.add('text-gray-400');
                    // Force grey text so parent classes don't override
                    day.style.color = '#9CA3AF'; // Tailwind gray-400
                }
            });
        }
        
        // Helper: merge backend calendar data into local SLG sets
        function mergeBackendSlgCalendar() {
            if (!window.slgCalendarData) return;

            const src = window.slgCalendarData;

            // IMPORTANT: always start from a clean slate so old dates
            // from a previous group/response do not linger
            slgSelectedDates.holiday.clear();
            slgSelectedDates.overtime.clear();

            const handleEntry = (entry, forcedType = null) => {
                if (!entry || !entry.value) return;
                const dateStr = entry.value; // e.g. "2025-12-13"
                const rawType = forcedType || entry.type || '';
                const type    = rawType.toLowerCase();

                if (type === 'holiday') {
                    slgSelectedDates.holiday.add(dateStr);
                    slgSelectedDates.overtime.delete(dateStr);
                } else if (type === 'overtime') {
                    slgSelectedDates.overtime.add(dateStr);
                    slgSelectedDates.holiday.delete(dateStr);
                }
            };

            // Case 1: API returns { holiday: [...], overtime: [...] }
            if (Array.isArray(src.holiday) || Array.isArray(src.overtime)) {
                (src.holiday || []).forEach(e => handleEntry(e, 'holiday'));
                (src.overtime || []).forEach(e => handleEntry(e, 'overtime'));
                return;
            }

            // Case 2: API returns a flat array of entries
            if (Array.isArray(src)) {
                src.forEach(e => handleEntry(e, null));
            }
        }

        // Load existing SLG dates from storage (if any) and then merge backend data
        function loadSlgStoredDates() {
            const stored = localStorage.getItem('slgCalendarDates');
            if (stored) {
                const data = JSON.parse(stored);
                slgSelectedDates.holiday = new Set(data.holiday || []);
                slgSelectedDates.overtime = new Set(data.overtime || []);
            }

            // Merge backend calendar (from gut_sewinglinegroup) on top
            mergeBackendSlgCalendar();
        }
        
        // Add click handlers to SLG calendar days
        function addSlgCalendarClickHandlers() {
            const calendarDays = document.querySelectorAll('#slgCalLeftDays .calendar-day, #slgCalRightDays .calendar-day');
            console.log('Adding click handlers to', calendarDays.length, 'SLG calendar days');
            
            calendarDays.forEach(day => {
                // Remove existing listener to avoid duplicates
                day.replaceWith(day.cloneNode(true));
            });
            
            // Re-select after cloning
            const freshDays = document.querySelectorAll('#slgCalLeftDays .calendar-day, #slgCalRightDays .calendar-day');
            
            freshDays.forEach(day => {
                day.addEventListener('click', function(e) {
                    console.log('SLG calendar day clicked:', this.dataset.date);
                    console.log('Current dropdown value:', slgSettingDropdown.value);
                    
                    const setting = slgSettingDropdown.value;
                    if (!setting) {
                        toastr.warning('Please select a setting (Holiday or Overtime) first.');
                        return;
                    }

                    const date = this.dataset.date;
                    if (!date) {
                        console.log('No date attribute found');
                        return;
                    }

                    // Restrict selection to current and future dates only
                    try {
                        const today = new Date();
                        today.setHours(0, 0, 0, 0);

                        const clickedDate = new Date(date);
                        clickedDate.setHours(0, 0, 0, 0);

                        if (clickedDate < today) {
                            toastr.error('You can select only current and future dates.');
                            return;
                        }

                        // Additionally restrict to the active group's date range, if defined
                        if (window.activeGroupFromDate && window.activeGroupToDate) {
                            const from = new Date(window.activeGroupFromDate);
                            const to   = new Date(window.activeGroupToDate);

                            if (!isNaN(from.getTime()) && !isNaN(to.getTime())) {
                                from.setHours(0, 0, 0, 0);
                                to.setHours(0, 0, 0, 0);

                                if (clickedDate < from || clickedDate > to) {
                                    toastr.error('You can select dates only within the group date range.');
                                    return;
                                }
                            }
                        }
                    } catch (err) {
                        console.error('Error parsing SLG calendar date', err);
                    }

                    console.log('Toggling date selection:', date, setting);
                    toggleSlgDateSelection(this, date, setting);
                });
            });
        }
        
        // Toggle SLG date selection
        function toggleSlgDateSelection(element, date, setting) {
            const isSelected = slgSelectedDates[setting].has(date);
            console.log('Toggling date:', date, 'Setting:', setting, 'Is selected:', isSelected);
            
            if (isSelected) {
                // Remove selection
                slgSelectedDates[setting].delete(date);
                element.classList.remove(`local-${setting}-date`);
                console.log('Removed selection:', `local-${setting}-date`);
            } else {
                // Add selection
                slgSelectedDates[setting].add(date);
                element.classList.add(`local-${setting}-date`);
                console.log('Added selection:', `local-${setting}-date`);
                
                // Remove from other setting if exists
                const otherSetting = setting === 'holiday' ? 'overtime' : 'holiday';
                if (slgSelectedDates[otherSetting].has(date)) {
                    slgSelectedDates[otherSetting].delete(date);
                    element.classList.remove(`local-${otherSetting}-date`);
                    console.log('Removed other setting:', `local-${otherSetting}-date`);
                }
            }
            
            console.log('Current selections:', {
                holiday: Array.from(slgSelectedDates.holiday),
                overtime: Array.from(slgSelectedDates.overtime)
            });
        }
        
        // Save SLG dates to storage
        function saveSlgDates() {
            const data = {
                holiday: Array.from(slgSelectedDates.holiday),
                overtime: Array.from(slgSelectedDates.overtime)
            };
            localStorage.setItem('slgCalendarDates', JSON.stringify(data));
        }
        
        // Apply stored highlights to SLG calendar only
        function applySlgStoredHighlights() {
            // Always merge latest backend data (if any) before painting
            mergeBackendSlgCalendar();

            // First clear any existing SLG highlight classes so we don't
            // keep stale dates when data for a new group is loaded.
            const allDays = document.querySelectorAll(
                '#slgCalLeftDays .calendar-day, #slgCalRightDays .calendar-day'
            );
            allDays.forEach(day => {
                day.classList.remove('local-holiday-date', 'local-overtime-date');
            });

            // Apply fresh highlights from the current in-memory sets
            slgSelectedDates.holiday.forEach(date => {
                const elements = document.querySelectorAll(
                    `#slgCalLeftDays [data-date="${date}"], #slgCalRightDays [data-date="${date}"]`
                );
                elements.forEach(el => el.classList.add('local-holiday-date'));
            });
            
            slgSelectedDates.overtime.forEach(date => {
                const elements = document.querySelectorAll(
                    `#slgCalLeftDays [data-date="${date}"], #slgCalRightDays [data-date="${date}"]`
                );
                elements.forEach(el => el.classList.add('local-overtime-date'));
            });
        }
        
        // Update SLG calendar when month changes
        function updateSlgCalendarHighlights() {
            setTimeout(() => {
                applySlgStoredHighlights();
                addSlgCalendarClickHandlers();
            }, 100);
        }
        
        // Initialize SLG calendar functionality
        loadSlgStoredDates();
        
        // SLG calendar navigation
        const slgPrevBtn = document.getElementById('slgCalPrev');
        const slgNextBtn = document.getElementById('slgCalNext');
        
        if (slgPrevBtn) {
            slgPrevBtn.addEventListener('click', updateSlgCalendarHighlights);
        }
        
        if (slgNextBtn) {
            slgNextBtn.addEventListener('click', updateSlgCalendarHighlights);
        }
        
        // Confirm button handler for SLG
        if (slgCalendarConfirmBtn) {
            slgCalendarConfirmBtn.addEventListener('click', async function() {
                // Save in local storage (existing behaviour)
                saveSlgDates();
                
                // Prepare payload for backend
                const payload = {
                    holiday: Array.from(slgSelectedDates.holiday),
                    overtime: Array.from(slgSelectedDates.overtime),
                    dropdown_value: slgSettingDropdown ? slgSettingDropdown.value : '',
                    portaltype: window.portalType || 'gut_new',
                    groupid: activeGroupId || '', 
                    unitid: (document.getElementById('unit_dropdown') && document.getElementById('unit_dropdown').value)
                        || (typeof window.currentSelectedUnit !== 'undefined' ? window.currentSelectedUnit : null)
                };

                console.log('Saving SLG calendar data (POST):', payload);

                try {
                    const response = await fetch('/savegroupcalender', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        },
                        body: JSON.stringify(payload)
                    });

                    const result = await response.json();

                    if (result.success) {
                        toastr.success(result.message || 'SLG Calendar settings saved successfully!');
                        slgCalendarPopModal.classList.add('hidden');
                    } else {
                        toastr.error(result.message || 'Failed to save SLG Calendar settings.');
                    }
                } catch (err) {
                    console.error('Error saving SLG calendar data', err);
                    toastr.error('Network error while saving SLG Calendar settings.');
                }
            });
        }
        
        // Initialize SLG calendar highlights after the calendar is rendered
        setTimeout(() => {
            console.log('Initializing SLG calendar...');
            if (typeof applySlgRangeHighlight === 'function') {
                applySlgRangeHighlight();
            }
            if (typeof applySlgStoredHighlights === 'function') {
                applySlgStoredHighlights();
            }
            if (typeof addSlgCalendarClickHandlers === 'function') {
                addSlgCalendarClickHandlers();
            }
            
            // Debug: Check if elements exist
            const slgDays = document.querySelectorAll('#slgCalLeftDays .calendar-day, #slgCalRightDays .calendar-day');
            console.log('Found SLG calendar days:', slgDays.length);
            console.log('SLG dropdown value:', slgSettingDropdown?.value);
        }, 500);
        
        // Also re-initialize when SLG modal is opened
        if (slgCalendarPopModal) {
            const observer = new MutationObserver((mutations) => {
                mutations.forEach((mutation) => {
                    if (mutation.type === 'attributes' && mutation.attributeName === 'class') {
                        if (!slgCalendarPopModal.classList.contains('hidden')) {
                            console.log('SLG modal opened, re-initializing calendar...');
                            setTimeout(() => {
                                if (typeof applySlgRangeHighlight === 'function') {
                                    applySlgRangeHighlight();
                                }
                                if (typeof applySlgStoredHighlights === 'function') {
                                    applySlgStoredHighlights();
                                }
                                if (typeof addSlgCalendarClickHandlers === 'function') {
                                    addSlgCalendarClickHandlers();
                                }
                            }, 100);
                        }
                    }
                });
            });
            observer.observe(slgCalendarPopModal, { attributes: true });
        }

        // Line group delete confirmation modal wiring
        const deleteModal = document.getElementById('lineGroupDeleteModal');
        const deleteCancelBtn = document.getElementById('lineGroupDeleteCancelBtn');
        const deleteConfirmBtn = document.getElementById('lineGroupDeleteConfirmBtn');

        function resetPendingDeleteState() {
            pendingDeleteCard = null;
            pendingDeleteGroupId = '';
            pendingDeleteGroupName = '';
        }

        if (deleteCancelBtn && deleteModal) {
            deleteCancelBtn.addEventListener('click', function() {
                deleteModal.classList.add('hidden');
                resetPendingDeleteState();
            });
        }

        if (deleteConfirmBtn && deleteModal) {
            deleteConfirmBtn.addEventListener('click', async function() {
                if (!pendingDeleteGroupId || !pendingDeleteCard) {
                    toastr.error('Nothing to delete. Please try again.');
                    deleteModal.classList.add('hidden');
                    resetPendingDeleteState();
                    return;
                }

                try {
                    const response = await fetch('/deletegroup', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                        },
                        body: JSON.stringify({ group_id: pendingDeleteGroupId })
                    });

                    const result = await response.json();

                    if (result.success) {
                        toastr.success(result.message || 'Line group deleted successfully.');
                        if (pendingDeleteCard && pendingDeleteCard.parentNode) {
                            pendingDeleteCard.remove();
                        }
						location.reload(); // or update UI without reload
                    } else {
                        toastr.error(result.message || 'Failed to delete line group.');
                    }
                } catch (err) {
                    console.error('Error deleting line group:', err);
                    toastr.error('Network error while deleting line group.');
                } finally {
                    deleteModal.classList.add('hidden');
                    resetPendingDeleteState();
                }
            });
        }
    });

    

</script>
</html>
