<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PO Status</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://kit.fontawesome.com/a2e0e6ad65.js" crossorigin="anonymous"></script>
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
  
    <style>
        .sticky-header {
            position: sticky;
            top: 0;
            z-index: 10;
            background-color: #EAF1FF;
        }
        .sticky-footer {
            position: sticky;
            bottom: 0;
            z-index: 10;
            background-color: #F3F4F6;
        }
        .table-container {
            max-height: 550px;
            overflow-y: auto;
        }

        .table-xs, .table-xs th, .table-xs td {
            font-size: 12px !important;
        }

        .po-hover {
            cursor: pointer;
            padding: 8px;
            transition: color 0.2s;
            border-radius: 4px;
            color: #1515e8 !important;
        }

        .sideallign {
            text-align: end !important;
        }

        .leftallign {
            text-align: start !important;
        }
    </style>
</head>

<body class="bg-[#F9FAFB]">
    @include('LifeAtGainup.Planning.GUTplanning.Gutplan_nav')

    <div class="p-6 relative">

    <div class="text-gray-500 text-sm mb-6 flex items-center gap-2">
        <a href="/gutplan" class="text-gray-500 hover:text-gray-700">
            Order Management
        </a>
        &gt;
        <span class="text-gray-700 font-medium">PO Status</span>
        <div class="h-4 w-px bg-gray-300"></div>
        <p class="text-gray-500 font-bold text-base"> For <span class="ccno-display font-bold text-base"></span></p>
        <div class="h-4 w-px bg-gray-300"></div>
        <p class="text-gray-500 ">View released purchase orders for forecasted styles.</p>
    </div>

        <!-- Table Section -->
        <div class="table-container rounded-xl border bg-white mt-5">
            <table class="w-full border-collapse text-xs" style="font-size: 12px !important;">
                <thead class="sticky-header" id="poTableHead">
                    <tr class="text-gray-700 ">
                        <th class="px-4 py-3">Order #</th>
                        <th class="px-4 py-3">PO #</th>
                        <th class="px-4 py-3">Destination</th>
                        <th class="px-4 py-3">Po date</th>
                        <th class="px-4 py-3">PO Wk</th>
                        <th class="px-4 py-3">EHD Date</th>
                        <th class="px-4 py-3">EHD Wk</th>
                        <th class="px-4 py-3">CHD Date</th>
                        <th class="px-4 py-3">CHD Wk</th>
                        <!-- Size columns will be dynamically added here -->
                        <th class="px-4 py-3 cursor-pointer text-blue-600" id="togglePoQty">>> CFM Qty</th>
                        <th class="px-4 py-3">CO #</th>
                        <th class="px-4 py-3">Production</th>
                        <th class="px-4 py-3">DFQC</th>
                        <th class="px-4 py-3">Shipped</th>
                    </tr>
                </thead>

                <!-- Dynamic Table Body -->
                <tbody class=" " id="poTableBody">
                    <!-- Data will be populated here -->
                    <tr>
                        <td colspan="15" class="text-center py-8 text-gray-500">
                            <i class="fas fa-spinner fa-spin text-2xl mb-2"></i>
                            <p>Loading PO data...</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

    </div>
    <!-- Confirm Order modal start - Pooja (Tailwind) -->
    <div id="confirmOrdQtyModal" aria-labelledby="confirmOrdQtyLabel" aria-hidden="true"
         class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-50">
        <div class="bg-white rounded-xl shadow-2xl w-full max-w-6xl max-h-[85vh] flex flex-col border text-xs">
            <!-- Header -->
            <div class="flex items-center justify-between px-5 py-3 border-b bg-gray-50">
                <h5 class="text-sm font-semibold" id="confirmOrdQtyLabel">Confirm Order Qty</h5>
                <button type="button" id="confirmOrdQtyModal_close"
                        class="inline-flex items-center justify-center w-8 h-8 rounded-full hover:bg-gray-100 text-gray-500">
                    <span class="sr-only">Close</span>
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <!-- Body -->
            <div class="px-5 py-4 overflow-y-auto">
                <div class="space-y-4">
                    <!-- Filters row -->
                    <div id="confirm_ord_filters" class="grid grid-cols-3 gap-3 mb-2">
                        <div>
                            <select id="filter_cfmNo"
                                    class="w-full border border-gray-300 rounded-md px-2 py-1.5 bg-white focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select CFM No</option>
                            </select>
                        </div>
                        <div>
                            <select id="filter_PoNo"
                                    class="w-full border border-gray-300 rounded-md px-2 py-1.5 bg-white focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Po No</option>
                            </select>
                        </div>
                        <div>
                            <select id="filter_DOTsts"
                                    class="w-full border border-gray-300 rounded-md px-2 py-1.5 bg-white focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select DOT Status</option>
                            </select>
                        </div>
                    </div>

                    <!-- Table -->
                    <div class="border rounded-lg overflow-hidden">
                        <div class="overflow-auto max-h-[60vh]">
                            <table id="confirmOrdQtyTable" class="min-w-full border-collapse table-xs">
                                <thead class="bg-gray-100 sticky top-0 z-10">
                                    <tr>
                                        <th class="px-2 py-2 border text-left">CFM No</th>
                                        <th class="px-2 py-2 border text-left">Po No</th>
                                        <th class="px-2 py-2 border text-left">Po Date</th>
                                        <th class="px-2 py-2 border text-left">Del Date</th>
                                        <th class="px-2 py-2 border text-right">PO Qty</th>
                                        <th class="px-2 py-2 border text-right">Shpd Qty</th>
                                        <th class="px-2 py-2 border text-left">Shpd Date</th>
                                        <th class="px-2 py-2 border text-right">Pend Qty</th>
                                        <th class="px-2 py-2 border text-left">DOT Sts</th>
                                        <th class="px-2 py-2 border text-left">Ship Mode</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data will be injected here dynamically -->
                                </tbody>
                                <tfoot class="bg-gray-50 sticky bottom-0 z-10">
                                    <tr>
                                        <th colspan="3" class="px-2 py-2 border text-right font-semibold">Total :</th>
                                        <th class="px-2 py-2 border"></th>
                                        <th class="px-2 py-2 border text-right"></th>
                                        <th class="px-2 py-2 border text-right"></th>
                                        <th class="px-2 py-2 border"></th>
                                        <th class="px-2 py-2 border text-right"></th>
                                        <th class="px-2 py-2 border"></th>
                                        <th class="px-2 py-2 border"></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Confirm Order modal end - Pooja -->
    <!-- COnfirm order size Wish breakup Raj start-->
    <div id="Confirm_POQtyModal" aria-labelledby="Confirm_POQtyModalLabel" aria-hidden="true"
         class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-50">
        <div class="bg-white rounded-md shadow-md w-full max-w-md max-h-[80vh] flex flex-col border text-xs">
            <!-- Header -->
            <div class="flex items-center justify-between px-4 py-2 border-b bg-gray-50">
                <span class="text-sm font-semibold" id="Confirm_POQtyModalLabel">Confirm POQty Details</span>
                <button type="button" id="Confirm_POQtyModal_close"
                        class="inline-flex items-center justify-center w-8 h-8 rounded-full hover:bg-gray-100 text-gray-500">
                    <span class="sr-only">Close</span>
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <!-- Body -->
            <div class="px-4 py-3 overflow-y-auto">
                <div class="border rounded-lg overflow-hidden">
                    <div class="overflow-auto max-h-[60vh]" style="font-size: 12px;">
                        <table id="Confirm_POQtyTable" class="min-w-full border-collapse table-xs">
                            <thead class="bg-gray-100 sticky top-0 z-10">
                                <!-- Filled dynamically -->
                            </thead>
                            <tbody>
                                <!-- Data rows injected dynamically -->
                            </tbody>
                            <tfoot class="bg-gray-50 sticky bottom-0 z-10">
                                <!-- Footer totals injected dynamically -->
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- COnfirm order size Wish breakup Raj end -->

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script>
        // Load PO data when page loads
        $(document).ready(function() {
            // Display CC No and Color in the header
            const ccno = localStorage.getItem('selectedCcNo');
            const color = localStorage.getItem('selectedColor');
            const modal = localStorage.getItem('selectedmodal');
            const season = localStorage.getItem('selectedseason');

            if (ccno && color && modal && season) {
                $('.ccno-display').text(color +' | '+ modal +' | ' + season);
            } else if (ccno) {
                $('.ccno-display').text(ccno);
            }
            
            loadPoData();
        });

        // Function to load PO data via AJAX
        function loadPoData() {
            const costno = localStorage.getItem('selectedCostNo');
            const portalType = localStorage.getItem('portalType') || 'gut_new';
            
            if (!costno) {
                $('#poTableBody').html(`
                    <tr>
                        <td colspan="15" class="text-center py-20 text-gray-500">
                            No cost number selected. Please go back and select an order.
                        </td>
                    </tr>
                `);
                return;
            }

            $.ajax({
                url: '/cfm_details',
                method: 'GET',
                data: {
                    costno: costno,
                    portaltype: portalType
                },
                success: function(response) {
                    if (response.success && response.data && response.data.length > 0) {
                        populatePoTable(response.data);
                    } else {
                        $('#poTableBody').html(`
                            <tr>
                                <td colspan="15" class="text-center py-20 text-gray-500">
                                    No PO data available for the selected cost.
                                </td>
                            </tr>
                        `);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error loading PO data:', error);
                    $('#poTableBody').html(`
                        <tr>
                            <td colspan="15" class="text-center py-20 text-red-500">
                                Error loading PO data. Please try again.
                            </td>
                        </tr>
                    `);
                }
            });
        }

        // Function to populate PO table with data
        function populatePoTable(data) {
            // Extract all unique sizes from the data
            const allSizes = new Set();
            data.forEach(function(row) {
                Object.keys(row).forEach(function(key) {
                    // Skip standard fields that are not sizes
                    const standardFields = ['Order_NO', 'PO_No', 'Destination', 'Cfm_Qty', 'PO_DAte', 'Delivery_Date', 'Ship_Date', 'Po_Week', 'Del_Week', 'Ship_Week', 'Approval', 'Approval1', 'Cut_No', 'Produced', 'DFQC', 'Shipped', 'Cost_ID', 'PO_Qty'];
                    
                    if (!standardFields.includes(key) && row[key] !== null && row[key] !== '') {
                        allSizes.add(key);
                    }
                });
            });
            
            // Convert to array and sort sizes
            const sizeArray = Array.from(allSizes).sort(function(a, b) {
                // Extract size part (before the slash) for comparison
                const aSize = a.split('/')[0];
                const bSize = b.split('/')[0];
                
                const sizeOrder = ['2XS', 'XS', 'S', 'M', 'L', 'XL', '2XL', '3XL', '4XL', '5XL'];
                const aIndex = sizeOrder.indexOf(aSize);
                const bIndex = sizeOrder.indexOf(bSize);
                
                if (aIndex !== -1 && bIndex !== -1) {
                    return aIndex - bIndex;
                } else if (aIndex !== -1) {
                    return -1;
                } else if (bIndex !== -1) {
                    return 1;
                } else {
                    return a.localeCompare(b);
                }
            });
            
            // Update table header with dynamic size columns
            updateTableHeader(sizeArray);
            
            // Generate table body
            let tableHtml = '';
            let totalCfmQty = 0;
            
            data.forEach(function(row) {
                // Determine production status
                let productionStatus = 'Not Started';
                let productionClass = 'bg-gray-100 text-gray-600';
                
                if (row.Produced && row.Produced.trim() !== '') {
                    productionStatus = row.Produced;
                    productionClass = 'bg-green-100 text-green-700';
                }
                
                // Determine DFQC status
                let dfqcStatus = 'Pending';
                let dfqcClass = 'bg-yellow-100 text-yellow-700';
                
                if (row.DFQC && row.DFQC.trim() !== '') {
                    dfqcStatus = row.DFQC;
                    if (row.DFQC.toLowerCase().includes('passed') || row.DFQC.toLowerCase().includes('completed')) {
                        dfqcClass = 'bg-green-100 text-green-700';
                    } else if (row.DFQC.toLowerCase().includes('failed')) {
                        dfqcClass = 'bg-red-100 text-red-700';
                    }
                }
                
                // Determine Ship status
                let shipStatus = 'Not Shipped';
                let shipClass = 'bg-gray-100 text-gray-600';
                
                if (row.Shipped && row.Shipped.trim() !== '') {
                    shipStatus = row.Shipped;
                    if (row.Shipped.toLowerCase().includes('shipped') || row.Shipped.toLowerCase().includes('completed')) {
                        shipClass = 'bg-green-100 text-green-700';
                    } else if (row.Shipped.toLowerCase().includes('delayed')) {
                        shipClass = 'bg-orange-100 text-orange-700';
                    } else if (row.Shipped.toLowerCase().includes('pending')) {
                        shipClass = 'bg-yellow-100 text-yellow-700';
                    }
                }

                totalCfmQty += Number(row.Cfm_Qty || 0);
                
                // Generate size column HTML dynamically
                let sizeColumnsHtml = '';
                sizeArray.forEach(function(size) {
                    const quantity = row[size] || 0;
                    sizeColumnsHtml += `<td class="po-size-extra px-4 py-3 hidden">${quantity && quantity > 0 ? quantity : '-'}</td>`;
                });
                
                tableHtml += `
                    <tr class="border-b hover:bg-gray-50">
                        <td class="px-4 py-3 Confirm_clickable"  data-cost-id="${row.Cost_ID}" data-order-id="${row.Order_NO}" style=" color: blue; cursor: pointer;">${row.Order_NO || '-'}</td>
                        <td class="px-4 py-3 text-black-700 font-bold  ">
                            ${row.PO_No || '-'}
                        </td>
                        <td class="px-4 py-3 whitespace-nowrap">${row.Destination || '-'}</td>
                        <td class="px-1 py-3 text-xs">${formatDate(row.PO_DAte) || '-'}</td>
                        <td class="px-4 py-3">${row.Po_Week || '-'}</td>
                        <td class="px-4 py-3 text-xs">${formatDate(row.Delivery_Date) || '-'}</td>
                        <td class="px-4 py-3">${row.Del_Week || '-'}</td>
                        <td class="px-1 py-3 text-xs">${formatDate(row.Ship_Date) || '-'}</td>
                        <td class="px-4 py-3">${row.Ship_Week || '-'}</td>
                        ${sizeColumnsHtml}
                        <td class="px-4 py-3 text-center font-semibold">${row.Cfm_Qty || '0'}</td>
                        <td class="px-4 py-3">${row.Cut_No || '-'}</td>
                        <td class="px-4 py-3 whitespace-nowrap">
                            <span class="${productionClass} px-3 py-1 rounded-full text-xs font-medium">
                                ${productionStatus}
                            </span>
                        </td>
                        <td class="px-4 py-3 whitespace-nowrap">
                            <span class="${dfqcClass} px-3 py-1 rounded-full text-xs font-medium">
                                ${dfqcStatus}
                            </span>
                        </td>
                        <td class="px-4 py-3 whitespace-nowrap">
                            <span class="${shipClass} px-3 py-1 rounded-full text-xs font-medium">
                                ${shipStatus}
                            </span>
                        </td>
                    </tr>
                `;
            });

            // Footer total row
            tableHtml += `
                <tr class="sticky-footer bg-gray-100 font-semibold">
                    <td class="px-4 py-3 text-right" colspan="9">Total</td>
                    <td class="px-4 py-3 po-size-extra hidden" colspan="${sizeArray.length}"></td>
                    <td class="px-4 py-3 font-semibold">${totalCfmQty}</td>
                    <td class="px-4 py-3" colspan="4"></td>
                </tr>
            `;
            
            $('#poTableBody').html(tableHtml);
        }

        // Function to update table header with dynamic size columns
        function updateTableHeader(sizes) {
            let headerHtml = `
                <th class="px-4 py-3">Order #</th>
                <th class="px-4 py-3">PO #</th>
                <th class="px-4 py-3 whitespace-nowrap">Destination</th>
                <th class="px-4 py-3 whitespace-nowrap">Po date</th>
                <th class="px-4 py-3">PO Wk</th>
                <th class="px-4 py-3 whitespace-nowrap">EHD Date</th>
                <th class="px-4 py-3">EHD Wk</th>
                <th class="px-4 py-3 whitespace-nowrap">CHD Date</th>
                <th class="px-4 py-3">CHD Wk</th>
                
            `;
            
            // Add dynamic size columns
            sizes.forEach(function(size) {
                headerHtml += `<th class="po-size-extra px-4 py-3 hidden">${size}</th>`;
            });
            
            headerHtml += `
                <th class="px-4 py-3 cursor-pointer text-blue-600" id="togglePoQty">>> CFM Qty</th>
                <th class="px-4 py-3">CO #</th>
                <th class="px-4 py-3 whitespace-nowrap">Production</th>
                <th class="px-4 py-3 whitespace-nowrap">DFQC</th>
                <th class="px-4 py-3 whitespace-nowrap">Shipped</th>
            `;
            
            $('#poTableHead tr').html(headerHtml);
        }

        // Function to format date to dd-mm-yy
        function formatDate(dateString) {
            if (!dateString) return '';
            
            const date = new Date(dateString);
            if (isNaN(date.getTime())) return dateString; // Return original if invalid
            
            const day = String(date.getDate()).padStart(2, '0');
            const month = String(date.getMonth() + 1).padStart(2, '0');
            const year = String(date.getFullYear()).slice(-2);
            
            return `${day}-${month}-${year}`;
        }

        // PO Qty toggle functionality
        $(document).off("click", "#togglePoQty").on("click", "#togglePoQty", function(){
            $(".po-size-extra").toggleClass("hidden");
            $(this).text($(this).text().includes(">>") ? "<< CFM Qty" : ">> CFM Qty");
        });

        // Confirm Order Quantity start - Pooja

        // Tailwind helpers for Confirm Order Qty modal
        function openConfirmModal() {
            const modal = document.getElementById('confirmOrdQtyModal');
            if (!modal) return;
            modal.classList.remove('hidden');
            modal.classList.add('flex');
            document.body.classList.add('overflow-hidden');
        }

        function closeConfirmModal() {
            const modal = document.getElementById('confirmOrdQtyModal');
            if (!modal) return;
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.classList.remove('overflow-hidden');

            // Reset filters
            $('#filter_cfmNo, #filter_PoNo, #filter_DOTsts').val('');

            // Clear DataTable filters if initialized
            if ($.fn.DataTable && $.fn.DataTable.isDataTable('#confirmOrdQtyTable')) {
                let table = $('#confirmOrdQtyTable').DataTable();
                table.columns().search('').draw();
            }
        }

        // Close on X or backdrop click
        document.addEventListener('click', function (e) {
            const modal = document.getElementById('confirmOrdQtyModal');
            if (!modal) return;

            const isCloseBtn = e.target.id === 'confirmOrdQtyModal_close' || e.target.closest('#confirmOrdQtyModal_close');
            const clickedOutside = e.target === modal;

            if (isCloseBtn || clickedOutside) {
                closeConfirmModal();
            }
        });

        $(document).on('click', '.Confirm_clickable', function () {

            let buyerQty = parseFloat($(this).text()) || 0;
            if (buyerQty <= 0) return; //ignore the click
            

            const costId = $(this).data('cost-id');
            const orderId = $(this).data('order-id');

            $('#confirmOrdQtyTable tbody').html('<tr><td colspan="10" class="text-center">⏳ Fetching data...</td></tr>');

            // Show Tailwind modal
            openConfirmModal();

            $.ajax({
                url: "{{ route('gut_confirm_ord_details') }}", 
                method: 'GET',
                data: { cost_id: costId },
                success: function(response) {
                    $('#confirmOrdQtyLabel').text('Confirm Ord Qty Details - ' + orderId);
                    if (!response || !response.data || response.data.length === 0) {
                        $('#confirmOrdQtyTable tbody').html('<tr><td colspan="10" class="text-danger text-center"> No records found!</td></tr>');
                        return;
                    }
                    else{
                        // Destroy if already initialized
                    if ($.fn.DataTable.isDataTable('#confirmOrdQtyTable')) {
                        $('#confirmOrdQtyTable').DataTable().destroy();
                    }
                    const rows = response.data.map(row => `
                        <tr>
                            <td class="leftallign">${row.CFM_No || ''}</td>
                            <td class="leftallign">${row.PO_No || ''}</td>
                            <td class="leftallign">${formatDateTime(row.Po_Dt) || ''}</td>
                            <td class="leftallign">${formatDateTime(row.Del_Dt) || ''}</td>
                        <td class="sideallign po-hover po_modal_trigger" 
                                data-bs-toggle="tooltip" 
                                data-order-id="${row.Order_Id}"
                                data-bs-placement="top" 
                                data-title="${row.PO_Qty || 'No value'}"
                                data-poqty="${row.PO_Qty || 'No value'}">
                            ${row.PO_Qty || ''}
                            </td>
                            <td class="sideallign">${row.Shpd_Qty || ''}</td>                  
                            <td class="leftallign">${formatDateTime(row.Shpd_Dt) || ''}</td>                  
                            <td class="sideallign">${row.Pend_Qty || ''}</td>
                            <td class="leftallign">${row.DOT_Sts || ''}</td>                   
                            <td class="leftallign">${row.Ship_Mode || ''}</td>                   
                        </tr>
                    `).join('');

                    $('#confirmOrdQtyTable tbody').html(rows);

                    // Init DataTable
                    let table = $('#confirmOrdQtyTable').DataTable({
                        ordering: true,
                        paging: false,
                        pageLength: 100,
                        searching: true,
                        dom: 'Bfrtip',
                        columnDefs: [
                            { type: 'dd-mm-yy', targets: [2,3,6] } // Ensuring sorting works for date columns
                        ],
                        buttons: [
                                {
                                    extend: 'excelHtml5',
                                    title: 'Confirm Order Quantity',
                                    exportOptions: {
                                        columns: ':visible',
                                        format: {
                                            body: function (data, row, column) {
                                                return [2,3,6].includes(column) && /\d{2}-\d{2}-\d{2}/.test(data)
                                                    ? moment(data, 'DD-MM-YY').format('YYYY-MM-DD') // Convert date format
                                                    : data.replace(/<[^>]+>/g, ''); // Remove HTML tags if any
                                            }
                                        }
                                    },
                                    footer: true
                                },
                                {
                                    extend: 'pdfHtml5',
                                    text: 'PDF',
                                    title: 'Confirm Order Quantity',
                                    orientation: 'landscape',
                                    pageSize: 'A3',
                                    exportOptions: {
                                        columns: ':visible'
                                    },
                                    customize: function(doc) {
                                        doc.defaultStyle.fontSize = 7;
                                        doc.content[1].table.widths = 'auto';  
                                        doc.content[1].table.dontBreakRows = true;  
                                    }
                                }
                            ],
                            footerCallback: function (row, data, start, end, display) {
                                const api = this.api();
                                const floatVal = (i) => typeof i === 'string' ? parseFloat(i.replace(/,/g, '')) || 0 : (typeof i === 'number' ? i : 0);

                                var columnsToSum = [4, 5, 7]; 

                                columnsToSum.forEach(function (colIndex) {
                                    var total = api
                                        .column(colIndex, { page: 'current' }) // Sum only visible data
                                        .data()
                                        .reduce((a, b) => floatVal(a) + floatVal(b), 0);

                                    // Update footer with total
                                    $(api.column(colIndex).footer()).html(total);
                                    // var totalInLakhs = (total / 100000) .toFixed(2);
                                    // $(api.column(colIndex).footer()).html(totalInLakhs);
                                });
                            
                            }
                    });
                            populate_Conf_Ord_Filter(0, 'filter_cfmNo');       // CFM No
                            populate_Conf_Ord_Filter(1, 'filter_PoNo');       // PO No
                            populate_Conf_Ord_Filter(8, 'filter_DOTsts');  // DOT Status

                            function populate_Conf_Ord_Filter(columnIndex, selectCfmId) {
                                let column = table.column(columnIndex);
                                let uniqueCfmData = column
                                    .data()
                                    .toArray()
                                    .filter((value, index, self) => value && self.indexOf(value) === index)
                                    .sort();

                                let $select = $(`#${selectCfmId}`);
                                let defaultOption = $select.data('default') || $select.find('option:first').text();
                                $select.empty().append(`<option value="">${defaultOption}</option>`);
                                uniqueCfmData.forEach(item => {
                                    $select.append(`<option value="${item}">${item}</option>`);
                                });
                            }

                            $('#filter_cfmNo').on('change', function () {
                                table.column(0).search(this.value).draw();
                            });
                            $('#filter_PoNo').on('change', function () {
                                table.column(1).search(this.value).draw();
                            });
                            $('#filter_DOTsts').on('change', function () {
                                table.column(8).search(this.value).draw();
                            });
                }
                },
                error: function (xhr) {
                    console.error(xhr);
                    $('#confirmOrdQtyTable tbody').html('<tr><td colspan="24" class="text-danger text-center">🔥 Error fetching data!</td></tr>');
                }
            });
        });
        // Confirm Order Quantity end - Pooja

        // Confirm order size wish break up Raj start
        function openConfirmPoModal() {
            const modal = document.getElementById('Confirm_POQtyModal');
            if (!modal) return;
            modal.classList.remove('hidden');
            modal.classList.add('flex');
            document.body.classList.add('overflow-hidden');
        }

        function closeConfirmPoModal() {
            const modal = document.getElementById('Confirm_POQtyModal');
            if (!modal) return;
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.classList.remove('overflow-hidden');

            // Destroy DataTable if exists (optional cleanup)
            if ($.fn.DataTable && $.fn.DataTable.isDataTable('#Confirm_POQtyTable')) {
                $('#Confirm_POQtyTable').DataTable().destroy();
            }
        }

        // Close size-wise modal via X button or backdrop
        document.addEventListener('click', function (e) {
            const modal = document.getElementById('Confirm_POQtyModal');
            if (!modal) return;

            const isCloseBtn = e.target.id === 'Confirm_POQtyModal_close' || e.target.closest('#Confirm_POQtyModal_close');
            const clickedOutside = e.target === modal;

            if (isCloseBtn || clickedOutside) {
                closeConfirmPoModal();
            }
        });

        $(document).on('click', '.po_modal_trigger', function () {

            let order_id = $(this).data('order-id');
            let title = $(this).data('title');
            let po_qty = $(this).data('poqty');
            if (po_qty <= 0) return; //ignore the click

            // Show Tailwind size-wise modal
            openConfirmPoModal();

            let $tbody = $('#Confirm_POQtyTable tbody');
            const tableId = `#Confirm_POQtyTable`;
            $tbody.empty();

            $tbody.append('<tr><td class="text-center">Loading...</td></tr>');

            $.ajax({
                url: '/gut_conf_poDetails',
                method: 'GET',
                data: {
                    orderId: order_id,
                },
                success: function (response) {
                    if ($.fn.DataTable.isDataTable('#Confirm_POQtyTable')) {
                            $('#Confirm_POQtyTable').DataTable().destroy();
                        }
                        
                    $('#Confirm_POQtyModalLabel').text("Size wise Details for the Order no : "+response.data[0].Order_No+" | PO No : "+response.data[0].PO_No+" | PO Qty : "+title);

                    $tbody.empty();

                    let headers = Object.keys(response.data[0]).filter(h => h !== 'Order_No' && h !== 'PO_No');
                    let headerHtml = `<tr>${headers.map(h => `<th class="text-center">${h}</th>`).join('')}</tr>`;
                    let rowsHtml = response.data.map(row => `
                        <tr>
                            ${headers.map(h => {
                                const cellClass = (h === 'Order_Qty' || h === 'Bom_Qty') ? 'sideallign' : '';
                                return `<td class="${cellClass}">${row[h] ?? 0}</td>`;
                            }).join('')}
                        </tr>
                    `).join('');
                    let footerHtml = `
                            <tr>
                                ${headers.map(h => {
                                    const cellClass = (h === 'Order_Qty' || h === 'Bom_Qty') ? 'sideallign' : '';
                                    return `<th class="${cellClass}"></th>`;
                                }).join('')}
                            </tr>
                        `;
                

                $(`${tableId} thead`).html(headerHtml);
                            $(`${tableId} tbody`).html(rowsHtml);
                            $(`${tableId} tfoot`).html(footerHtml);


                            $(tableId).DataTable({
                        ordering: false,
                        paging: false,
                        searching: false,
                        columnDefs: [
                                
                                { type: 'dd-mm-yy', targets: [0] } // Ensuring sorting works for date columns
                            ],
                                    
                        footerCallback: function (row, data, start, end, display) {
                            let api = this.api();

                                let floatVal = i => {
                                    if (typeof i === 'string') {
                                        const text = $('<div>').html(i).text();
                                        return parseFloat(text.replace(/,/g, '')) || 0;
                                    }
                                    return typeof i === 'number' ? i : 0;
                                };

                                api.columns().every(function () {
                                    let colIdx = this.index();
                                    let header = $(api.column(colIdx).header()).text().trim();

                                    if (header === 'Order_Qty' || header === 'Bom_Qty') {
                                        let total = this.data()
                                            .reduce((a, b) => floatVal(a) + floatVal(b), 0);
                                        $(api.column(colIdx).footer()).html(Math.round(total));
                                    } else if (header === 'Size') {
                                        $(api.column(colIdx).footer()).html('Total :');
                                    } else {
                                        $(api.column(colIdx).footer()).html('');
                                    }
                                });

                        }

                    });
                    $(tableId).show();
            

                },
                error: function (xhr, status, error) {
                    $tbody.empty().append(`<tr><td class="text-danger text-center">Error loading data.</td></tr>`);
                    console.error("Data fetch failed:", error);
                }
            });
        });
        // Remove blur effect when the modal is hidden
        // $('#Confirm_POQtyModal').on('hidden.bs.modal', function () {
        //     // Remove the blur effect on all modals
        //     $('.modal').css('background', 'none');
        // });
        // Confirm order size wish break up Raj end

        function formatDateTime(dateString) {
            if (!dateString) return '';

            // Try parsing datetime with time (e.g. 2023-11-08 00:00:00.000)
            if (moment(dateString, 'YYYY-MM-DD HH:mm:ss.SSS', true).isValid()) {
                return moment(dateString, 'YYYY-MM-DD HH:mm:ss.SSS').format('DD-MM-YY');
            }

            // Try parsing date only (e.g. 2023-11-08)
            if (moment(dateString, 'YYYY-MM-DD', true).isValid()) {
                return moment(dateString, 'YYYY-MM-DD').format('DD-MM-YY');
            }

            // Try parsing existing DD-MM-YY
            if (moment(dateString, 'DD-MM-YY', true).isValid()) {
                return moment(dateString, 'DD-MM-YY').format('DD-MM-YY');
            }

            return ''; // Invalid or unrecognized format
        }

    </script>

</body>
</html>