<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Demand Trend Analysis</title>
</head>
<body class="bg-slate-50">
    @include('LifeAtGainup.Planning.GUTplanning.Gutplan_nav')

    <div class=" mx-3 px-6 py-6">
        <div class="flex items-center gap-4 mb-1">
            <div class="text-gray-500 text-m">
                <a href="/gutplan" class="text-gray-500 hover:text-gray-700">
                    Order Management
                </a>
                >
                <span class="text-black-700 font-medium">Demand Trend Analysis</span>
            </div>
            <div class="h-4 w-px bg-gray-300"></div>
            <p class="text-gray-500 font-bold text-base">for <span class="ccno-display font-bold text-base"></span></p>
            <div class="h-4 w-px bg-gray-300"></div>
            <p class="text-gray-500 text-xs">View and analyze your demand trends.</p>
            
        </div>

        <div class="mb-4 flex flex-wrap items-end gap-4 text-[13px]">
            <div class="hidden">
                <label class="block text-gray-500 mb-1">Order ID</label>
                <div class="inline-flex items-center px-3 py-1.5 border border-gray-300 rounded-md bg-white min-w-[190px]">
                    <span id="orderCcColorDisplay" class="text-gray-800 text-[13px] truncate">-</span>
                </div>
            </div>

            <div>
                <label class="block text-gray-500 mb-1">Type</label>
                <div class="inline-flex items-center px-3 py-1.5 border border-gray-300 rounded-md bg-white min-w-[120px]">
                    <select id="typeFilter" class="w-full bg-transparent outline-none text-gray-800 text-[13px]">
                        <option value="All">ALL</option>
                        <option value="po">PO</option>
                        <option value="PERC">PERC</option>
                        <option value="FC">FC</option>
                    </select>
                </div>
            </div>

            <div>
                <label class="block text-gray-500 mb-1">Destination</label>
                <div class="inline-flex items-center px-3 py-1.5 border border-gray-300 rounded-md bg-white min-w-[120px]">
                    <select id="destinationFilter" class="w-full bg-transparent outline-none text-gray-800 text-[13px]">
                        <option value="ALL">ALL</option>
                    </select>
                </div>
            </div>

            <div>
                <label class="block text-gray-500 mb-1">Size</label>
                <div class="inline-flex items-center px-3 py-1.5 border border-gray-300 rounded-md bg-white min-w-[120px]">
                    <select id="sizeFilter" class="w-full bg-transparent outline-none text-gray-800 text-[13px]">
                        <option value="ALL">ALL</option>
                    </select>
                </div>
            </div>

            

            <div>
                <button type="button" id="overalldetailButton" class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-white border border-gray-300 text-gray-800 text-[13px] shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-400">
                    Overall
                </button>
            </div>

            <div class="ml-auto">
                <label class="block text-gray-500 mb-1">&nbsp;</label>
                <button type="button" class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-gray-100 border border-gray-300 text-gray-800 text-[13px] shadow-sm ">
                    <span class="text-gray-500">Current Week:</span>
                    <span id="currentWeekLabel" class="font-medium text-gray-900">-</span>
                </button>
            </div>
        </div>

        <div class="mt-2 border border-slate-200 rounded-lg overflow-hidden bg-white shadow-sm relative">
            <div id="demandTrendLoading" class="absolute inset-0 flex items-center justify-center bg-white bg-opacity-70 z-20">
                <div class="flex items-center gap-2 text-sm text-gray-600">
                    <svg class="animate-spin h-5 w-5 text-blue-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
                    </svg>
                    <span>Loading demand trend...</span>
                </div>
            </div>

            <div class="overflow-x-auto">
                <table class="bg-gray-100 min-w-full text-[11px] text-right text-slate-700" id="demandTrendTable">
                    <thead class="bg-blue-50 border-b border-blue-200">
                        <tr id="demandTrendHeaderRow">
                            <th class="sticky left-0 z-10 bg-blue-50 text-left px-3 py-2 font-semibold text-[11px] text-blue-700 border-r border-blue-200">Snapshot Week</th>
                        </tr>
                    </thead>
                    <tbody id="demandTrendBody">
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var headerRow = document.getElementById('demandTrendHeaderRow');
            var body = document.getElementById('demandTrendBody');
            var loadingOverlay = document.getElementById('demandTrendLoading');
            var destinationFilter = document.getElementById('destinationFilter');
            var sizeFilter = document.getElementById('sizeFilter');
            var overallButton = document.getElementById('overalldetailButton');
            var percentageButton = document.getElementById('percentageButton');
            var typeFilter = document.getElementById('typeFilter');

            var defaultData = [];
            var defaultWeekKeys = [];
            var overallData = [];
            var percentageData = [];
            var isOverallMode = false;
            var isPercentageMode = false;
            var overallInitialized = false;
            var percentageInitialized = false;

            if (!headerRow || !body) {
                return;
            }

            function formatNumber(value) {
                if (value === null || value === undefined || value === '') {
                    return '-';
                }
                var num = Number(value);
                if (isNaN(num)) {
                    return value;
                }
                return num.toLocaleString('en-IN');
            }

            function formatWeekKeyLabel(key) {
                if (!key) {
                    return '';
                }
                // Example API key: "09#2026" -> take the numeric part before '#'
                var parts = String(key).split('#');
                var weekPart = parts[0];
                var weekNum = parseInt(weekPart, 10);
                if (isNaN(weekNum)) {
                    return key;
                }
                return 'W' + weekNum;
            }

            function formatSnapshotWeekLabel(snapWeek) {
                if (!snapWeek) {
                    return '';
                }
                // Example Snap_Week: "35.2025" -> take the part before '.'
                var parts = String(snapWeek).split('.');
                var weekPart = parts[0];
                var weekNum = parseInt(weekPart, 10);
                if (isNaN(weekNum)) {
                    return snapWeek;
                }
                return 'W' + weekNum;
            }

            function getCurrentIsoWeekLabel() {
                var now = new Date();
                // Copy date and set to nearest Thursday: current date + 4 - current day number (Sunday=0)
                var target = new Date(Date.UTC(now.getFullYear(), now.getMonth(), now.getDate()));
                var dayNr = target.getUTCDay();
                if (dayNr === 0) {
                    dayNr = 7;
                }
                target.setUTCDate(target.getUTCDate() + 4 - dayNr);
                var yearStart = new Date(Date.UTC(target.getUTCFullYear(), 0, 1));
                var weekNo = Math.ceil((((target - yearStart) / 86400000) + 1) / 7);
                return 'W' + weekNo;
            }

            var portalType = localStorage.getItem('portalType') || 'gut_new';
            var costNo = localStorage.getItem('selectedCostNo');
            var selectedCcNo = localStorage.getItem('selectedCcNo');
            var selectedColor = localStorage.getItem('selectedColor');
            var selectedmodel = localStorage.getItem('selectedmodel');
            var selectedseason = localStorage.getItem('selectedseason');

            var currentWeekLabelEl = document.getElementById('currentWeekLabel');
            if (currentWeekLabelEl) {
                currentWeekLabelEl.textContent = getCurrentIsoWeekLabel();
            }

            if (selectedCcNo || selectedColor) {
                let displayValue = `${selectedColor} | ${selectedmodel} | ${selectedseason} `;
                $('#orderCcColorDisplay').text(displayValue);
                $('.ccno-display').text(displayValue);
            } 

            if (!costNo) {
                console.warn('Demand Trend: selectedCostNo not found in localStorage');
                return;
            }

            function loadDemandTrendData() {
                if (loadingOverlay) {
                    loadingOverlay.style.display = 'flex';
                }

                // Reset Overall mode and filters on every load
                if (overallButton) {
                    isOverallMode = false;
                    overallButton.classList.remove('bg-gray-200', 'text-black');
                    overallButton.classList.add('bg-white', 'text-gray-800');
                    overallButton.disabled = true;
                }

                if (destinationFilter && sizeFilter) {
                    resetOverallFilterOptions();
                }

                var typeVal = typeFilter ? typeFilter.value : 'All';
                var url = '/pofrcdetails?portaltype=' + encodeURIComponent(portalType) +
                          '&costno=' + encodeURIComponent(costNo);
                if (typeVal) {
                    url += '&type=' + encodeURIComponent(typeVal);
                }

                $.ajax({
                    url: url,
                    method: 'GET',
                    dataType: 'json',

                    success: function (result) {
                        if (loadingOverlay) {
                            loadingOverlay.style.display = 'none';
                        }

                        if (!result || !result.success || !Array.isArray(result.data) || result.data.length === 0) {
                            headerRow.innerHTML = '';
                            body.innerHTML = '';
                            return;
                        }

                        var data = result.data;
                        var firstRow = data[0];

                        defaultData = data;
                        overallData = Array.isArray(result.overalldata) ? result.overalldata : [];
                        percentageData = Array.isArray(result.percentage) ? result.percentage : [];

                        // Build list of keys for weekly columns, keeping Total as a separate last column.
                        var allKeys = Object.keys(firstRow || {});
                        var weekKeys = allKeys.filter(function (k) { return k !== 'Snap_Week' && k !== 'Total'; });
                        defaultWeekKeys = weekKeys;

                        // Render the default snapshot view initially
                        renderDefaultTable();

                        // If we have overall data, prepare filters and button behavior (only wire once)
                        if (overallData.length > 0 && destinationFilter && sizeFilter && overallButton) {
                            overallButton.disabled = false;
                            initializeOverallMode();
                        }

                        // Initialize percentage button (only wire once)
                        if (percentageButton && percentageData.length > 0) {
                            initializePercentageMode();
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error('Error loading demand trend data:', status, error);
                        if (loadingOverlay) {
                            loadingOverlay.style.display = 'none';
                        }
                    }
                });
            }

            // Initial load
            loadDemandTrendData();

            // Reload whenever type filter changes
            if (typeFilter) {
                typeFilter.addEventListener('change', function () {
                    loadDemandTrendData();
                });
            }

            function initializeOverallMode() {
                if (!overallButton || !destinationFilter || !sizeFilter) {
                    return;
                }
                if (overallInitialized) {
                    return;
                }
                overallInitialized = true;

                // Overall button click -> toggle between default and overall view
                overallButton.addEventListener('click', function () {
                    if (!isOverallMode) {
                        isOverallMode = true;
                        overallButton.classList.add('bg-gray-200', 'text-black');
                        overallButton.classList.remove('bg-white', 'text-gray-800');
                        populateOverallFilters();
                        renderOverallWithCurrentFilters();
                    } else {
                        isOverallMode = false;
                        overallButton.classList.remove('bg-gray-200', 'text-black');
                        overallButton.classList.add('bg-white', 'text-gray-800');
                        // reset filters and options when leaving overall view
                        resetOverallFilterOptions();
                        renderDefaultTable();
                    }
                });

                // Change events on dropdowns -> re-filter overall view (only when in overall mode)
                destinationFilter.addEventListener('change', function () {
                    if (isOverallMode) {
                        renderOverallWithCurrentFilters();
                    }
                });

                sizeFilter.addEventListener('change', function () {
                    if (isOverallMode) {
                        renderOverallWithCurrentFilters();
                    }
                });
            }

            function populateOverallFilters() {

                if (!destinationFilter || !sizeFilter || !overallData || overallData.length === 0) {
                    return;
                }

                var destSet = new Set();
                var sizeSet = new Set();

                overallData.forEach(function (row) {
                    if (row.Destination) {
                        destSet.add(String(row.Destination));
                    }
                    if (row.Size) {
                        sizeSet.add(String(row.Size));
                    }
                });

                // Reset options
                destinationFilter.innerHTML = '';
                sizeFilter.innerHTML = '';

                var allDestOpt = document.createElement('option');
                allDestOpt.value = 'ALL';
                allDestOpt.textContent = 'ALL';
                destinationFilter.appendChild(allDestOpt);

                destSet.forEach(function (val) {
                    var opt = document.createElement('option');
                    opt.value = val;
                    opt.textContent = val;
                    destinationFilter.appendChild(opt);
                });

                var allSizeOpt = document.createElement('option');
                allSizeOpt.value = 'ALL';
                allSizeOpt.textContent = 'ALL';
                sizeFilter.appendChild(allSizeOpt);

                sizeSet.forEach(function (val) {
                    var opt = document.createElement('option');
                    opt.value = val;
                    opt.textContent = val;
                    sizeFilter.appendChild(opt);
                });
            }

            function resetOverallFilterOptions() {
                if (!destinationFilter || !sizeFilter) {
                    return;
                }

                destinationFilter.innerHTML = '';
                sizeFilter.innerHTML = '';

                var allDestOpt = document.createElement('option');
                allDestOpt.value = 'ALL';
                allDestOpt.textContent = 'ALL';
                destinationFilter.appendChild(allDestOpt);

                var allSizeOpt = document.createElement('option');
                allSizeOpt.value = 'ALL';
                allSizeOpt.textContent = 'ALL';
                sizeFilter.appendChild(allSizeOpt);
            }

            function renderOverallWithCurrentFilters() {
                if (!overallData || overallData.length === 0) {
                    return;
                }

                var selectedDest = destinationFilter ? destinationFilter.value : 'ALL';
                var selectedSize = sizeFilter ? sizeFilter.value : 'ALL';

                var filtered = overallData.filter(function (row) {
                    var destOk = (selectedDest === 'ALL') || (String(row.Destination) === selectedDest);
                    var sizeOk = (selectedSize === 'ALL') || (String(row.Size) === selectedSize);
                    return destOk && sizeOk;
                });

                renderOverallTable(filtered);
            }

            function initializePercentageMode() {
                if (!percentageButton) {
                    return;
                }
                if (percentageInitialized) {
                    return;
                }
                percentageInitialized = true;

                // Percentage button click -> toggle between default and percentage view
                percentageButton.addEventListener('click', function () {
                    if (!isPercentageMode) {
                        isPercentageMode = true;
                        percentageButton.classList.add('bg-gray-200', 'text-black');
                        percentageButton.classList.remove('bg-white', 'text-gray-800');
                        renderPercentageTable();
                    } else {
                        isPercentageMode = false;
                        percentageButton.classList.remove('bg-gray-200', 'text-black');
                        percentageButton.classList.add('bg-white', 'text-gray-800');
                        renderDefaultTable();
                    }
                });
            }

            function formatPercentage(value) {
                if (value === null || value === undefined || value === '') {
                    return '0.0';
                }
                var num = Number(value);
                if (isNaN(num)) {
                    return '0.0';
                }
                return num.toFixed(1);
            }

            function renderPercentageTable() {
                if (!percentageData || percentageData.length === 0) {
                    headerRow.innerHTML = '';
                    body.innerHTML = '';
                    return;
                }

                var firstRow = percentageData[0];
                var allKeys = Object.keys(firstRow || {});
                var weekKeys = allKeys.filter(function (k) { return k !== 'Snap_Week' && k !== 'Total'; });

                headerRow.innerHTML = '';
                body.innerHTML = '';

                // Snapshot week header (sticky first column)
                var thSnap = document.createElement('th');
                thSnap.className = 'sticky left-0 z-10 bg-blue-50 text-left px-3 py-2 font-semibold text-[11px] text-blue-700 border-r border-blue-200';
                thSnap.textContent = 'Snapshot Week';
                headerRow.appendChild(thSnap);

                // Week columns (displayed as W{week number})
                weekKeys.forEach(function (key) {
                    var th = document.createElement('th');
                    th.className = 'px-3 py-2 font-semibold text-[11px] text-blue-700';
                    th.textContent = formatWeekKeyLabel(key);
                    headerRow.appendChild(th);
                });

                // Total header
                var thTotal = document.createElement('th');
                thTotal.className = 'px-3 py-2 font-semibold text-[11px] text-blue-700 text-right';
                thTotal.textContent = 'Total';
                headerRow.appendChild(thTotal);

                // Build body rows
                percentageData.forEach(function (row) {
                    var tr = document.createElement('tr');
                    tr.className = 'border-b border-slate-100';

                    var tdSnap = document.createElement('td');
                    tdSnap.className = 'sticky left-0 z-10 bg-blue-50 text-left px-3 py-2 text-slate-700 border-r border-slate-100';
                    tdSnap.textContent = formatSnapshotWeekLabel(row.Snap_Week || '');
                    tr.appendChild(tdSnap);

                    weekKeys.forEach(function (key) {
                        var td = document.createElement('td');
                        td.className = 'px-3 py-2';

                        var percentage = Number(row[key]) || 0;
                        td.textContent = formatPercentage(percentage);

                        // Apply conditional background colors based on percentage values
                        if (percentage >= -5 && percentage <= 5) {
                            td.style.backgroundColor = 'white';
                        } else if (percentage === 6) {
                            td.style.backgroundColor = 'yellow';
                        } else if (percentage > 6 && percentage <= 20) {
                            td.style.backgroundColor = 'red';
                        } else {
                            td.style.backgroundColor = 'lightgrey';
                        }

                        tr.appendChild(td);
                    });

                    var tdTotal = document.createElement('td');
                    tdTotal.className = 'px-3 py-2 font-semibold text-slate-900 bg-orange-50 text-right';
                    tdTotal.textContent = formatPercentage(row.Total);
                    tr.appendChild(tdTotal);

                    body.appendChild(tr);
                });
            }

            function renderDefaultTable() {
                var currentType = typeFilter ? typeFilter.value : 'All';
                var rowsSource = (currentType === 'All') ? defaultData : percentageData;

                if (!rowsSource || rowsSource.length === 0) {
                    headerRow.innerHTML = '';
                    body.innerHTML = '';
                    return;
                }

                var firstRow = rowsSource[0];
                var allKeys = Object.keys(firstRow || {});
                var weekKeys = allKeys.filter(function (k) { return k !== 'Snap_Week' && k !== 'Total'; });

                headerRow.innerHTML = '';
                body.innerHTML = '';

                // Snapshot week header (sticky first column)
                var thSnap = document.createElement('th');
                thSnap.className = 'sticky left-0 z-10 bg-blue-50 text-left px-1 py-2 font-semibold text-[11px] text-blue-700 border-r border-blue-200';
                thSnap.textContent = 'Snapshot Week';
                headerRow.appendChild(thSnap);

                // Week columns (displayed as W{week number})
                weekKeys.forEach(function (key) {
                    var th = document.createElement('th');
                    th.className = 'px-3 py-2 font-semibold text-[11px] text-blue-700';
                    th.textContent = formatWeekKeyLabel(key);
                    headerRow.appendChild(th);
                });

                // Total header
                var thTotal = document.createElement('th');
                thTotal.className = 'px-3 py-2 font-semibold text-[11px] text-blue-700 text-right';
                thTotal.textContent = 'Total';
                headerRow.appendChild(thTotal);

                // Build body rows and prepare totals
                var columnTotals = {};

                rowsSource.forEach(function (row) {
                    var tr = document.createElement('tr');
                    tr.className = 'border-b border-slate-100';

                    var tdSnap = document.createElement('td');
                    tdSnap.className = 'sticky left-0 z-10 bg-blue-50 text-left px-3 py-2 text-slate-700 border-r border-slate-100';
                    tdSnap.textContent = formatSnapshotWeekLabel(row.Snap_Week || '');
                    tr.appendChild(tdSnap);

                    weekKeys.forEach(function (key) {
                        var raw = row[key];
                        var num = Number(raw || 0);
                        if (!isNaN(num)) {
                            columnTotals[key] = (columnTotals[key] || 0) + num;
                        }

                        var td = document.createElement('td');
                        td.className = 'px-3 py-2';
                        td.textContent = formatNumber(raw);
                        tr.appendChild(td);
                    });

                    var rowTotalRaw = row.Total;
                    var rowTotalNum = Number(rowTotalRaw || 0);
                    if (!isNaN(rowTotalNum)) {
                        columnTotals['Total'] = (columnTotals['Total'] || 0) + rowTotalNum;
                    }

                    var tdTotal = document.createElement('td');
                    tdTotal.className = 'px-3 py-2 font-semibold text-slate-900 bg-orange-50 text-right';
                    tdTotal.textContent = formatNumber(rowTotalRaw);
                    tr.appendChild(tdTotal);

                    body.appendChild(tr);
                });

                if (rowsSource.length > 0) {
                    var totalRow = document.createElement('tr');
                    totalRow.className = 'border-t border-slate-200 bg-slate-50';

                    var totalLabelCell = document.createElement('td');
                    totalLabelCell.className = 'sticky left-0 z-10 bg-blue-50 text-left px-3 py-2 text-slate-700 border-r border-slate-100';
                    totalLabelCell.textContent = 'Total';
                    totalRow.appendChild(totalLabelCell);

                    weekKeys.forEach(function (key) {
                        var td = document.createElement('td');
                        td.className = 'px-3 py-2 font-semibold text-slate-900';
                        td.textContent = formatNumber(columnTotals[key] || 0);
                        totalRow.appendChild(td);
                    });

                    var grandTotalCell = document.createElement('td');
                    grandTotalCell.className = 'px-3 py-2 font-bold text-slate-900 bg-orange-100 text-right';
                    grandTotalCell.textContent = formatNumber(columnTotals['Total'] || 0);
                    totalRow.appendChild(grandTotalCell);

                    body.appendChild(totalRow);
                }
            }

            function renderOverallTable(rows) {
                // If no rows, just clear table
                headerRow.innerHTML = '';
                body.innerHTML = '';

                if (!rows || rows.length === 0) {
                    return;
                }

                var firstRow = rows[0];
                var allKeys = Object.keys(firstRow || {});
                var staticKeys = ['Snap_Week', 'Destination', 'Item_Code', 'Size', 'Total'];
                var weekKeys = allKeys.filter(function (k) {
                    return staticKeys.indexOf(k) === -1;
                });

                // Header: Snapshot Week, Destination, Size, weeks, Total
                var thSnap = document.createElement('th');
                thSnap.className = 'sticky left-0 z-10 bg-blue-50 text-left px-3 py-2 font-semibold text-[11px] text-blue-700 border-r border-blue-200';
                thSnap.textContent = 'Snapshot Week';
                headerRow.appendChild(thSnap);

                var thDest = document.createElement('th');
                thDest.className = 'px-3 py-2 font-semibold text-[11px] text-blue-700 text-left';
                thDest.textContent = 'Destination';
                headerRow.appendChild(thDest);

                var thSize = document.createElement('th');
                thSize.className = 'px-3 py-2 font-semibold text-[11px] text-blue-700 text-left';
                thSize.textContent = 'Size';
                headerRow.appendChild(thSize);

                weekKeys.forEach(function (key) {
                    var th = document.createElement('th');
                    th.className = 'px-3 py-2 font-semibold text-[11px] text-blue-700';
                    th.textContent = formatWeekKeyLabel(key);
                    headerRow.appendChild(th);
                });

                var thTotal = document.createElement('th');
                thTotal.className = 'px-3 py-2 font-semibold text-[11px] text-blue-700 text-right';
                thTotal.textContent = 'Total';
                headerRow.appendChild(thTotal);

                var columnTotals = {};

                rows.forEach(function (row) {
                    var tr = document.createElement('tr');
                    tr.className = 'border-b border-slate-100';

                    var tdSnap = document.createElement('td');
                    tdSnap.className = 'sticky left-0 z-10 bg-blue-50 text-left px-3 py-2 text-slate-700 border-r border-slate-100';
                    tdSnap.textContent = formatSnapshotWeekLabel(row.Snap_Week || '');
                    tr.appendChild(tdSnap);

                    var tdDest = document.createElement('td');
                    tdDest.className = 'px-3 py-2 text-left';
                    tdDest.textContent = row.Destination || '';
                    tr.appendChild(tdDest);

                    var tdSize = document.createElement('td');
                    tdSize.className = 'px-3 py-2 text-left';
                    tdSize.textContent = row.Size || '';
                    tr.appendChild(tdSize);

                    weekKeys.forEach(function (key) {
                        var raw = row[key];
                        var num = Number(raw || 0);
                        if (!isNaN(num)) {
                            columnTotals[key] = (columnTotals[key] || 0) + num;
                        }

                        var td = document.createElement('td');
                        td.className = 'px-3 py-2';
                        td.textContent = formatNumber(raw);
                        tr.appendChild(td);
                    });

                    var rowTotalRaw = row.Total;
                    var rowTotalNum = Number(rowTotalRaw || 0);
                    if (!isNaN(rowTotalNum)) {
                        columnTotals['Total'] = (columnTotals['Total'] || 0) + rowTotalNum;
                    }

                    var tdTotal = document.createElement('td');
                    tdTotal.className = 'px-3 py-2 font-semibold text-slate-900 bg-orange-50 text-right';
                    tdTotal.textContent = formatNumber(rowTotalRaw);
                    tr.appendChild(tdTotal);

                    body.appendChild(tr);
                });

                // Totals row
                if (rows.length > 0) {
                    var totalRow = document.createElement('tr');
                    totalRow.className = 'border-t border-slate-200 bg-slate-50';

                    var totalLabelCell = document.createElement('td');
                    totalLabelCell.className = 'sticky left-0 z-10 bg-white text-left px-3 py-2 text-slate-700 border-r border-slate-100';
                    totalLabelCell.textContent = 'Total';
                    totalRow.appendChild(totalLabelCell);

                    var emptyDest = document.createElement('td');
                    emptyDest.className = 'px-3 py-2';
                    totalRow.appendChild(emptyDest);

                    var emptySize = document.createElement('td');
                    emptySize.className = 'px-3 py-2';
                    totalRow.appendChild(emptySize);

                    weekKeys.forEach(function (key) {
                        var td = document.createElement('td');
                        td.className = 'px-3 py-2 font-semibold text-slate-900';
                        td.textContent = formatNumber(columnTotals[key] || 0);
                        totalRow.appendChild(td);
                    });

                    var grandTotalCell = document.createElement('td');
                    grandTotalCell.className = 'px-3 py-2 font-bold text-slate-900 bg-orange-100 text-right';
                    grandTotalCell.textContent = formatNumber(columnTotals['Total'] || 0);
                    totalRow.appendChild(grandTotalCell);

                    body.appendChild(totalRow);
                }
            }

        });
    </script>
</body>
</html>