
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Management</title>

    <!-- Tailwind CDN -->
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" />
	<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
</head>
<style>
	.season-one-line {
		white-space: nowrap;      /* Prevent wrapping */
		overflow: hidden;         /* Hide any overflow */
		text-overflow: ellipsis;  /* Show ... if it overflows */
		max-width: 100%;          /* Respect column width */
	}

	.cc-color-tight {
		white-space: nowrap;      /* Keep CC-Color on one line (e.g., 114227-Purple) */
		overflow: hidden;
		text-overflow: ellipsis;  /* Show ... if it’s too long */
		padding-left: 8px !important;   /* Reduce from px-4 (16px) */
		padding-right: 8px !important;  /* Reduce from px-4 (16px) */
		max-width: 160px;         /* Optional: limit max width so very long values don’t push the table */
	}

    /* OrderPopup styles removed – using full /orderdetails page instead */

    /* For Chrome, Safari, Edge */
    ::-webkit-scrollbar {
    display: none;
    }

    /* For Firefox */
    * {
    scrollbar-width: none;
    }

    /* Stack sort arrows vertically (▲ above ▼) and make them very compact */
    .sort-indicator {
        display: inline-block;
      
        line-height: 1;           /* tighter vertical spacing */
        font-size: 6px;             /* smaller icon size */
        vertical-align: middle;
    }

</style>
<body class="bg-gray-100">
    @include('LifeAtGainup.Planning.GUTplanning.Gutplan_nav')
     

<div class="px-8 py-4">


    <!-- Page Title -->
    <h1 class="text-2xl font-semibold text-gray-800 mb-1">Order Management</h1>
    <p class="text-gray-500 mb-2">
        View all your GUT orders. Click on an Order ID to see details.
    </p>

    <div class=" flex justify-end items-center px-4 pt-3 pb-1 gap-2">
        <button
            type="button"
            id="resetColumnFiltersBtn"
            class="px-3 py-1 text-xs border border-gray-300 rounded-md bg-gray-50 hover:bg-gray-100 text-gray-700">
            Reset Filters
        </button>
        <input
            type="text"
            id="orderTableSearch"
            class="border border-gray-300 rounded-md px-3 py-1 text-sm w-64 focus:outline-none focus:ring-1 focus:ring-blue-400"
            placeholder="Search"
        />
    </div>

    <!-- Table Container -->
    <div class="bg-white shadow-sm rounded-lg overflow-hidden border border-gray-200" style="max-height: 80vh; overflow-y: auto;">

    <table class="w-full text-sm text-left" style="font-size: 11.5px;">
        <thead class="bg-blue-100 text-gray-700 sticky top-0 z-10" style="position: sticky;">
            <tr class="text-[11px] font-medium">
                <th class="pl-2 py-2 whitespace-nowrap w-40 cursor-pointer hover:bg-blue-200 relative" onclick="sortTable(0)">
                    <div class="flex items-center gap-1">
                        <span>CC-Color</span>
                        <span class="sort-indicator text-gray-500 ml-1">▲
                        ▼</span>
                        <button type="button"
                                class="ml-1 text-gray-500 hover:text-blue-600 text-[10px] column-filter-trigger"
                                data-filter-key="cccolor"
                                onclick="event.stopPropagation(); openColumnFilter('cccolor', this);">
                            <i class="fas fa-filter"></i>
                        </button>
                    </div>
                </th>
                <th class="pr-2 py-2 whitespace-nowrap w-40 cursor-pointer hover:bg-blue-200 relative" onclick="sortTable(1)">
                    <div class="flex items-center gap-1">
                        <span>Season</span>
                        <span class="sort-indicator text-gray-500 ml-1">▲
                        ▼</span>
                        <button type="button"
                                class="ml-1 text-gray-500 hover:text-blue-600 text-[10px] column-filter-trigger"
                                data-filter-key="season"
                                onclick="event.stopPropagation(); openColumnFilter('season', this);">
                            <i class="fas fa-filter"></i>
                        </button>
                    </div>
                </th>
                <th class="px-2 py-2 whitespace-nowrap cursor-pointer hover:bg-blue-200" onclick="sortTable(2)">Buyer <span class="sort-indicator text-gray-500  ml-1">▲
                ▼</span></th>
                <th class="px-2 py-2 whitespace-nowrap cursor-pointer hover:bg-blue-200 relative" onclick="sortTable(3)">
                    <div class="flex items-center gap-1">
                        <span>Model no.</span>
                        <span class="sort-indicator text-gray-500 ml-1">▲
                        ▼</span>
                        <button type="button"
                                class="ml-1 text-gray-500 hover:text-blue-600 text-[10px] column-filter-trigger"
                                data-filter-key="model"
                                onclick="event.stopPropagation(); openColumnFilter('model', this);">
                            <i class="fas fa-filter"></i>
                        </button>
                    </div>
                </th>
                <th class="px-2 py-2 whitespace-nowrap cursor-pointer hover:bg-blue-200" onclick="sortTable(4)">Sel Quantity <span class="sort-indicator text-gray-500  ml-1">▲
                ▼</span></th>
                <th class="px-2 py-2 whitespace-nowrap cursor-pointer hover:bg-blue-200" onclick="sortTable(5)">PO + FC <span class="sort-indicator text-gray-500  ml-1">▲
                ▼</span></th>
                <th class="px-2 py-2 whitespace-nowrap cursor-pointer hover:bg-blue-200" onclick="sortTable(6)">PRJ Qty <span class="sort-indicator text-gray-500  ml-1">▲
                ▼</span></th>
                <th class="px-2 py-2 whitespace-nowrap cursor-pointer hover:bg-blue-200" onclick="sortTable(7)">FRC Qty <span class="sort-indicator text-gray-500  ml-1">▲
                ▼</span></th>
                <th class="px-2 py-2 whitespace-nowrap cursor-pointer hover:bg-blue-200" onclick="sortTable(8)">Cfm PO <span class="sort-indicator text-gray-500 ml-1">▲
                ▼</span></th>
                <th class="px-2 py-2 whitespace-nowrap cursor-pointer hover:bg-blue-200" onclick="sortTable(9)">Cut Order <span class="sort-indicator text-gray-500 ml-1">▲
                ▼</span></th>
                <th class="px-2 py-2 whitespace-nowrap cursor-pointer hover:bg-blue-200" onclick="sortTable(10)">Prod <span class="sort-indicator text-gray-500 ml-1">▲
                ▼</span></th>
                <th class="px-2 py-2 whitespace-nowrap cursor-pointer hover:bg-blue-200" onclick="sortTable(11)">Shipped <span class="sort-indicator text-gray-500 ml-1">▲
                ▼</span></th>
                <th class="px-2 py-2 whitespace-nowrap cursor-pointer hover:bg-blue-200" onclick="sortTable(12)">Target Eff. <span class="sort-indicator text-gray-500 ml-1">▲
                ▼</span></th>

                <!-- Eff Group -->
                <th class="px-2 py-2 whitespace-nowrap cursor-pointer text-blue-600" id="toggleEff">» YTD Eff%</th>
                <th class="px-2 py-2 whitespace-nowrap eff-extra hidden">W-Eff%</th>
                <th class="px-2 py-2 whitespace-nowrap eff-extra hidden">4W-Eff%</th>

                <!-- HOT Group -->
                <th class="px-2 py-2 whitespace-nowrap cursor-pointer text-blue-600" id="toggleHot">» YTD HOT%</th>
                <th class="px-2 py-2 whitespace-nowrap hot-extra hidden">W-HOT%</th>
                <th class="px-2 py-2 whitespace-nowrap hot-extra hidden">4W-HOT%</th>

                <!-- BR Group -->
                <th class="px-2 py-2 whitespace-nowrap cursor-pointer text-blue-600" id="toggleBR">» YTD-BR%</th>
                <th class="px-2 py-2 whitespace-nowrap br-extra hidden">W-BR%</th>
                <th class="px-2 py-2 whitespace-nowrap br-extra hidden">4W-BR%</th>

                <th class="px-2 py-2 whitespace-nowrap cursor-pointer hover:bg-blue-200" onclick="sortTable(20)">Alerts <span class="sort-indicator text-gray-500 ml-1">▲
                ▼</span></th>
            </tr>
        </thead>
		

        <tbody id="ordersTableBody">
        @foreach($result as $row)

            <tr class="border-b hover:bg-gray-50 transition data-row">

            <td>
                <a href="/orderdetails"
                class="cc-color-tight text-blue-600 font-medium cursor-pointer underline orderdetails-link"
                data-ccno="{{ $row->CcNo ?? '' }}"
                data-model="{{ $row->Model ?? '' }}"
                data-costno="{{ $row->Cost_ID ?? '' }}"
                data-season="{{ $row->Season ?? '-' }}"
                data-selectionqty="{{ $row->Selection_Qty ?? 0 }}"
                data-prjqty="{{ $row->PRJ_Qty ?? 0 }}"
                data-color="{{ $row->CC_Color ?? '-' }}">
                    {{ $row->CC_Color ?? '-' }}
                </a>
            </td>

                <td class="pr-2 py-3 season-one-line">{{ $row->Season ?? '-' }}</td>

                <td class="px-2 py-3">{{ $row->{'DMI/DSI'} ?? '-' }}</td>

                <td class="px-2 py-3">{{ $row->Model ?? '-' }}</td>

                <td class="px-2 py-3 text-blue-600 font-semibold cursor-pointer open-demand">
                    {{ number_format($row->Selection_Qty ?? 0) }}
                </td>

                <td class="px-2 py-3">
                    <!-- <a href="{{ url('demandtrend/'.$row->CcNo) }}"  -->
                    <a href="/demandtrend" 
                    class="text-blue-600 cursor-pointer hover:underline demandtrend-link" data-ccno="{{ $row->CcNo ?? '' }}" data-costno="{{ $row->Cost_ID ?? '' }}" data-color="{{ $row->CC_Color ?? '' }}" data-season="{{ $row->Season ?? '-' }}" data-model="{{ $row->Model ?? '-' }}">
                        {{ number_format($row->PO_Frc_Qty ?? 0) }}
                    </a>
                </td>


                <td>
                    <!-- <a href="{{ url('projectionplanning/'.$row->CcNo) }}"  -->
                    <a href="/projectionplanning" 
                        class="text-blue-600 font-medium hover:underline projection-link" 
                        data-ccno="{{ $row->CcNo ?? '' }}" 
                        data-costno="{{ $row->Cost_ID ?? '' }}" 
                        data-color="{{ $row->CC_Color ?? '' }}" 
                        data-modal="{{ $row->Model ?? '-' }}"
                        data-season="{{ $row->Season ?? '-' }}">
                        {{ $row->PRJ_Qty ?? 0 }}
                    </a>
                </td>

                <td > <a href="/frcplanning"  class="px-2 py-3 text-blue-600 font-medium hover:underline frc-link" data-ccno="{{ $row->CcNo ?? '' }}" data-costno="{{ $row->Cost_ID ?? '' }}" data-color="{{ $row->CC_Color ?? '' }}" data-modal="{{ $row->Model ?? '-' }}" data-season="{{ $row->Season ?? '-' }}">{{ $row->FRC_Qty ?? 0 }}</a></td>

                <td> <a href="/demandpostatus"  class="px-2 py-3 text-blue-600 font-semibold hover:underline demand-link" data-ccno="{{ $row->CcNo ?? '' }}" data-costno="{{ $row->Cost_ID ?? '' }}" data-color="{{ $row->CC_Color ?? '' }}" data-modal="{{ $row->Model ?? '-' }}" data-season="{{ $row->Season ?? '-' }}">
                    {{ number_format($row->CFM_Qty ?? 0) }}</a>
                </td>

                <td> <a href="/cutorderissue" class="px-2 py-3 text-blue-600 font-medium hover:underline cut-link" data-ccno="{{ $row->CcNo ?? '' }}" data-costno="{{ $row->Cost_ID ?? '' }}" data-color="{{ $row->CC_Color ?? '' }}" data-modal="{{ $row->Model ?? '-' }}" data-season="{{ $row->Season ?? '-' }}">
                    {{ number_format($row->CutOrd_Qty ?? 0) }} </a>
                </td>

                <td  class="px-2 py-3 font-semibold text-blue-600 production" style="cursor: pointer;" 
                data-bs-toggle="modal" 
                data-bs-target="#tableModalproduction"
                data-cost-id="{{ $row->Cost_ID ?? '' }}" 
                title="Production Status"
                data-production-title="CC No : {{ $row->CC_Color ?? '' }} | Season: {{ $row->Season ?? '-' }} | Model : {{ $row->Model ?? '' }} ">
                    {{ number_format($row->Prod_Qty ?? 0) }}
                </td>

                <td class="px-2 py-3 font-semibold text-blue-600 shipqty" style="cursor: pointer;" 
                data-bs-toggle="modal" 
                data-bs-target="#shipQtyModal"
                data-cost-id="{{ $row->Cost_ID ?? '' }}" 
                title="shipment details"
                data-ship-title="CC No : {{ $row->CC_Color ?? '' }} | Season: {{ $row->Season ?? '-' }} | Model : {{ $row->Model ?? '' }} ">
                    {{ number_format($row->Ship_Qty ?? 0) }}
                </td>

                <td class="px-2 py-3">{{ $row->Tar_Eff ?? '0%' }}</td>

                <td class="px-2 py-3 text-blue-600 font-medium ytd-eff cursor-pointer open-hot-modal">
                    {{ $row->YTD_Eff ?? '0%' }}
                </td>

                <td class="px-2 py-3 eff-extra hidden text-blue-600">{{ $row->W_Eff ?? '0%' }}</td>
                <td class="px-2 py-3 eff-extra hidden text-blue-600">{{ $row->W4_Eff ?? '0%' }}</td>

                <td class="px-2 py-3 text-blue-600 font-medium ytd-hot">{{ $row->YTD_Hot ?? '0%' }}</td>
                <td class="px-2 py-3 hot-extra hidden text-blue-600">0%</td>
                <td class="px-2 py-3 hot-extra hidden text-blue-600">0%</td>

                <td class="px-2 py-3 text-red-500 font-medium ytd-br">{{ $row->YTD_BR ?? '0%' }}</td>
                <td class="px-2 py-3 br-extra hidden text-red-500">0%</td>
                <td class="px-2 py-3 br-extra hidden text-blue-600"></td>

                <td class="px-2 py-3 flex gap-2">
                    <span class="bg-red-500 text-white text-xs font-bold w-6 h-6 flex items-center justify-center rounded-full cursor-pointer open-alerts-sidebar">0</span>
                    <span class="bg-yellow-400 text-white text-xs font-bold w-6 h-6 flex items-center justify-center rounded-full cursor-pointer open-alerts-sidebar">0</span>
                </td>

            </tr>
        @endforeach
        <tr id="noMatchesRow" class="hidden">
            <td colspan="23" class="px-4 py-6 text-center text-gray-500 text-sm">
                No matches available
            </td>
        </tr>
        </tbody>

        <tfoot class="bg-gray-100 font-semibold text-gray-700 border-t-2 border-gray-300 sticky bottom-0 z-10" style="position: sticky;">
            <tr>
                <td class="px-3 py-2 text-center" colspan="4">TOTAL:</td>
                <td class="px-3 py-2 text-left" id="total-sel-qty">0</td>
                <td class="px-3 py-2 text-left" id="total-po-fc">0</td>
                <td class="px-3 py-2 text-left" id="total-prj-qty">0</td>
                <td class="px-3 py-2 text-left" id="total-frc-qty">0</td>
                <td class="px-3 py-2 text-left" id="total-cfm-po">0</td>
                <td class="px-3 py-2 text-left" id="total-cut-order">0</td>
                <td class="px-3 py-2 text-left" id="total-prod">0</td>
                <td class="px-3 py-2 text-left" id="total-shipped">0</td>
                <td class="px-3 py-2 text-left" id="total-target-eff">-</td>
                <td class="px-3 py-2 text-left" id="total-ytd-eff">-</td>
                <td class="px-3 py-2 text-left eff-extra hidden" id="total-w-eff">-</td>
                <td class="px-3 py-2 text-left eff-extra hidden" id="total-4w-eff">-</td>
                <td class="px-3 py-2 text-left" id="total-ytd-hot">-</td>
                <td class="px-3 py-2 text-left hot-extra hidden" id="total-w-hot">-</td>
                <td class="px-3 py-2 text-left hot-extra hidden" id="total-4w-hot">-</td>
                <td class="px-3 py-2 text-left" id="total-ytd-br">-</td>
                <td class="px-3 py-2 text-left br-extra hidden" id="total-w-br">-</td>
                <td class="px-3 py-2 text-left br-extra hidden" id="total-4w-br">-</td>
                <td class="px-3 py-2 text-left" id="total-alerts">0</td>
            </tr>
        </tfoot>

    </table>

    <!-- Column Filter Dropdown (reused for CC-Color / Season / Model) -->
    <div id="columnFilterPanel"
         class="absolute bg-white border border-gray-200 rounded-md shadow-lg z-30 text-xs w-56 hidden">
        <div class="flex items-center justify-between px-3 py-2 border-b bg-gray-50">
            <span id="columnFilterTitle" class="font-semibold text-gray-700">Filter</span>
            <button type="button"
                    class="text-gray-400 hover:text-gray-700 text-sm"
                    onclick="hideColumnFilter()">
                ✕
            </button>
        </div>

        <!-- Search within filter values -->
        <div class="px-3 py-2 border-b">
            <input
                type="text"
                id="columnFilterSearch"
                class="w-full border border-gray-300 rounded px-2 py-1 text-[11px] focus:outline-none focus:ring-1 focus:ring-blue-400"
                placeholder="Search values..."
            />
        </div>

        <div class="flex items-center justify-between px-3 py-2 border-b">
            <button type="button"
                    class="px-2 py-1 bg-blue-500 text-white rounded text-[11px]"
                    id="filterSelectAllBtn">
                Select All
            </button>
            <button type="button"
                    class="px-2 py-1 bg-gray-200 text-gray-700 rounded text-[11px]"
                    id="filterClearAllBtn">
                Clear All
            </button>
        </div>

        <div id="columnFilterOptions"
             class="max-h-56 overflow-y-auto px-3 py-2 space-y-1">
            <!-- Checkboxes injected by JS -->
        </div>
    </div>

</div>

    <!-- DEMAND POPUP -->
    <div id="demandModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
        
        <div class="bg-gray-300 rounded-lg shadow-xl w-[950px] pb-4 overflow-hidden relative">

            <!-- HEADER -->
            <div class="flex justify-between items-start p-5 pb-2">
                <div>
                    <h2 class="text-lg font-semibold text-gray-800">
                        Demand Details for 114227-Purple
                    </h2>
                    <p class="text-gray-500 text-sm">
                        Comparison of Selection Quantity vs. PO+FC.
                    </p>
                </div>

                <button id="closeDemand" class="border rounded-full w-7 h-7 flex items-center justify-center text-gray-500 hover:bg-gray-100">
                    ✕
                </button>
            </div>

            <!-- TABLE -->
            <div class="px-5 pb-4">
                <table class="w-full text-sm border border-gray-200 rounded-lg overflow-hidden">
                    <thead class="bg-blue-100 text-gray-700">
                        <tr>
                            <th class="px-4 py-3 text-left">Destination</th>
                            <th class="px-4 py-3 text-center">Selection Qty</th>
                            <th class="px-4 py-3 text-center">PO</th>
                            <th class="px-4 py-3 text-center">FC</th>
                            <th class="px-4 py-3 text-center">PO+FC</th>
                            <th class="px-4 py-3 text-center">Réalisation</th>
                        </tr>
                    </thead>

                    <tbody>
                        <tr class="border-t">
                            <td class="px-4 py-3">New York, USA</td>
                            <td class="px-4 py-3 text-center">28,333</td>
                            <td class="px-4 py-3 text-center">23,333</td>
                            <td class="px-4 py-3 text-center">1,867</td>
                            <td class="px-4 py-3 text-center font-semibold">25,200</td>
                            <td class="px-4 py-3 text-center">88.94%</td>
                        </tr>

                        <tr class="border-t">
                            <td class="px-4 py-3">London, UK</td>
                            <td class="px-4 py-3 text-center">28,333</td>
                            <td class="px-4 py-3 text-center">18,667</td>
                            <td class="px-4 py-3 text-center">7,467</td>
                            <td class="px-4 py-3 text-center font-semibold">26,134</td>
                            <td class="px-4 py-3 text-center">92.24%</td>
                        </tr>

                        <tr class="border-t">
                            <td class="px-4 py-3">Tokyo, Japan</td>
                            <td class="px-4 py-3 text-center">28,334</td>
                            <td class="px-4 py-3 text-center">4,667</td>
                            <td class="px-4 py-3 text-center">18,666</td>
                            <td class="px-4 py-3 text-center font-semibold">23,333</td>
                            <td class="px-4 py-3 text-center">82.35%</td>
                        </tr>

                        <tr class="border-t bg-gray-50 font-semibold">
                            <td class="px-4 py-3">Total</td>
                            <td class="px-4 py-3 text-center">85,000</td>
                            <td class="px-4 py-3 text-center">46,667</td>
                            <td class="px-4 py-3 text-center">28,000</td>
                            <td class="px-4 py-3 text-center">74,667</td>
                            <td class="px-4 py-3 text-center">87.84%</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

    </div>


    <!-- WEEKLY HOT POPUP -->
    <div id="hotModal" class="fixed inset-0 bg-black bg-opacity-50 hidden flex items-center justify-center z-50">

        <div class="bg-white rounded-xl shadow-xl w-[580px] overflow-hidden relative">

            <!-- HEADER -->
            <div class="flex justify-between items-center p-4 border-b">
                <h2 class="text-lg font-semibold text-gray-800">
                    Weekly HOT% for 114227-Purple
                </h2>

                <button id="closeHot" class="text-gray-500 hover:bg-gray-200 w-7 h-7 flex items-center justify-center rounded-full">
                    ✕
                </button>
            </div>

            <!-- TABLE -->
            <table class="w-full text-sm">
                <thead class="bg-blue-100 text-gray-700">
                    <tr>
                        <th class="px-4 py-3 text-left">Week</th>
                        <th class="px-4 py-3 text-right">HOT %</th>
                    </tr>
                </thead>

                <tbody class="text-gray-700">

                    <tr class="border-b">
                        <td class="px-4 py-3">Week 40</td>
                        <td class="px-4 py-3 text-right">92.5%</td>
                    </tr>

                    <tr class="border-b">
                        <td class="px-4 py-3">Week 41</td>
                        <td class="px-4 py-3 text-right">95.1%</td>
                    </tr>

                    <tr class="border-b">
                        <td class="px-4 py-3">Week 42</td>
                        <td class="px-4 py-3 text-right">98.3%</td>
                    </tr>

                    <tr>
                        <td class="px-4 py-3">Week 43</td>
                        <td class="px-4 py-3 text-right">97.2%</td>
                    </tr>

                </tbody>
            </table>

        </div>

    </div>





	
	<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>
    // Global page switcher used by navbar
    window.showPage = function(type){
        document.querySelectorAll('#gut-pages .gut-page').forEach(function(el){ 
            el.classList.add('hidden'); 
        });
        var id = 'page-' + (type || 'GUTNEW');
        var el = document.getElementById(id);
        if (el) { 
            el.classList.remove('hidden'); 
        }

        // reattach accordion listeners when page changes
        attachAccordionHandlers();
    };

    function attachAccordionHandlers(){
        // Efficiency group
        $(document).off("click", "#toggleEff").on("click", "#toggleEff", function(){
            $(".eff-extra").toggleClass("hidden");
            $(this).text($(this).text().includes("»") ? "« YTD Eff%" : "» YTD Eff%");
        });

        // HOT group
        $(document).off("click", "#toggleHot").on("click", "#toggleHot", function(){
            $(".hot-extra").toggleClass("hidden");
            $(this).text($(this).text().includes("»") ? "« YTD HOT%" : "» YTD HOT%");
        });

        // BR group
        $(document).off("click", "#toggleBR").on("click", "#toggleBR", function(){
            $(".br-extra").toggleClass("hidden");
            $(this).text($(this).text().includes("»") ? "« YTD-BR%" : "» YTD-BR%");
        });
    }

    // Initial selection based on dropdown
    (function(){
        var ddl = document.getElementById('plantSelect');
        var initial = ddl && ddl.value ? ddl.value : 'GUTNEW';
        window.showPage(initial);

        // VERY IMPORTANT
        attachAccordionHandlers();
    })();


	
    function closePopup(){
        $('#orderPopup').addClass('hidden');
    }

    $(document).on('click', '#popupTabs .tab-btn', function(){
        var tab = $(this).data('tab');
        $('#popupTabs .tab-btn').removeClass('bg-blue-600 text-white').addClass('text-gray-600');
        $(this).removeClass('text-gray-600').addClass('bg-blue-600 text-white');
        $('#tabContent .tab-pane').addClass('hidden').removeClass('active');
        $('#' + tab + 'Content').removeClass('hidden').addClass('active');
    });

    $(document).on('click', '.dropdown-toggle', function(e){
        e.stopPropagation();
        var btn = $(this);
        var type = btn.data('type');
        var rect = this.getBoundingClientRect();
        var menu = $('#popupDropdownMenu');
        if(menu.length === 0){
        $('body').append('<div id="popupDropdownMenu" class="fixed bg-white border rounded-lg shadow-xl z-50 hidden"></div>');
        menu = $('#popupDropdownMenu');
        }
        var options = type === 'yesno' ? ['Yes','No'] : ['Projection','FRC'];
        var html = '<div class="py-1">' + options.map(function(opt){
        return '<button data-opt="'+opt+'" class="w-full text-left px-4 py-2 hover:bg-gray-100">'+opt+'</button>';
        }).join('') + '</div>';
        menu.html(html);
        menu.css({left: rect.left + 'px', top: (rect.bottom + 4) + 'px'}).removeClass('hidden');
        menu.data('targetBtn', btn);
    });

    $(document).on('click', '#popupDropdownMenu button', function(e){
        var val = $(this).data('opt');
        var menu = $('#popupDropdownMenu');
        var btn = menu.data('targetBtn');
        if(btn && btn.length){
        btn.attr('data-value', val);
        btn.contents().filter(function(){ return this.nodeType === 3; }).first()[0].nodeValue = ' ' + val + ' ';
        }
        menu.addClass('hidden');
    });

    $(document).on('click', function(){
        $('#popupDropdownMenu').addClass('hidden');
    });

    document.addEventListener("click", function(e){

        if(e.target.closest(".add-day-btn")){
            let container = document.getElementById("dayContainer");
            let rows = container.querySelectorAll(".day-row").length;
            let newDay = rows + 1;

            let row = document.createElement("div");
            row.className = "grid grid-cols-2 gap-4 day-row";

            row.innerHTML = `
                <input
                    type="number"
                    value="${newDay}"
                    class="border rounded-lg px-3 py-2 w-full focus:ring focus:ring-blue-200 day-input"
                />

                <input
                    type="number"
                    value="75"
                    class="border rounded-lg px-3 py-2 w-full focus:ring focus:ring-blue-200"
                />
            `;

            container.appendChild(row);
        }

    });

    document.addEventListener("click", function(e){

        if(e.target.closest('.open-demand')){
            document.getElementById("demandModal").classList.remove("hidden");
            document.getElementById("demandModal").classList.add("flex");
        }

        if(e.target.id === "closeDemand" || e.target.id === "demandModal"){
            document.getElementById("demandModal").classList.add("hidden");
            document.getElementById("demandModal").classList.remove("flex");
        }

        // Hot Modal
        $(document).on('click', '.open-hot-modal', function() {
            $('#hotModal').removeClass('hidden');
        });

        $(document).on('click', '#closeHot', function() {
            $('#hotModal').addClass('hidden');
        });

        // Add Day functionality
        $(document).on('click', '.add-day-btn', function() {
            const $dayContainer = $('#dayContainer');
            const $lastDayRow = $dayContainer.find('.day-row').last();
            const lastDayValue = parseInt($lastDayRow.find('.day-input').val());
            const newDayValue = lastDayValue + 1;

            const $newDayRow = $lastDayRow.clone();
            $newDayRow.find('.day-input').val(newDayValue);
            $dayContainer.append($newDayRow);
        });

        // Alerts Sidebar functionality
        $(document).on('click', '.open-alerts-sidebar', function() {
            $('#alertsSidebar').removeClass('translate-x-full');
        });

        $(document).on('click', '#closeAlertsSidebar', function() {
            $('#alertsSidebar').addClass('translate-x-full');
        });
    });
</script>

<script>
    $(document).ready(function () {
        const $search = $('#orderTableSearch');
        const $rows = $('#ordersTableBody').find('tr.data-row');
        const $noMatches = $('#noMatchesRow');

        $search.on('keyup', function () {
            const term = $(this).val().toLowerCase().trim();

            if (!term) {
                $rows.show();
                $noMatches.addClass('hidden');
                return;
            }

            let visibleCount = 0;

            $rows.each(function () {
                const text = $(this).text().toLowerCase();
                const match = text.indexOf(term) !== -1;
                $(this).toggle(match);
                if (match) visibleCount++;
            });

            if (visibleCount === 0) {
                $noMatches.removeClass('hidden');
            } else {
                $noMatches.addClass('hidden');
            }
        });

        // DETAILS LINK: before going to /orderdetails, ensure we persist current order context
        $(document).on('click', 'a[href="/orderdetails"]', function(e) {
            // Get the row that opened the popup
            const $rowTrigger = $('.orderpopupnew.clicked').first();
            if ($rowTrigger.length) {
                const ccNo = $rowTrigger.data('ccno');
                const costNo = $rowTrigger.data('costno');
                const model = $rowTrigger.data('model');
                const color = $rowTrigger.text().trim();
                const selectionQty = $rowTrigger.data('selectionqty');
                const prjQty = $rowTrigger.data('prjqty');
                const portalType = localStorage.getItem('portalType') || window.portalType || 'gut_new';
                const season = $rowTrigger.data('season');
                
                try {
                    if (ccNo != null) localStorage.setItem('selectedCcNo', ccNo);
                    if (costNo != null) localStorage.setItem('selectedCostNo', costNo);
                    if (color) localStorage.setItem('selectedColor', color);
                    if (model) localStorage.setItem('selectedmodel', model);
                    localStorage.setItem('selectedseason', season);
                    localStorage.setItem('selectedportalType', portalType);
                    localStorage.setItem('selectedSelectionQty', selectionQty != null ? selectionQty : '0');
                    localStorage.setItem('selectedPrjQty', prjQty != null ? prjQty : '0');
                } catch (err) {
                    console.warn('Unable to persist order context for /orderdetails:', err);
                }
            }
            // allow normal navigation to continue
        });
    });
</script>





<script>
        // FIXED: populate OB correctly into #obContent
        function populateOrderPopup(data, ccNo, ccColor) {
            const ops = data || [];
            const totalSAM = ops.reduce((a, op) => a + parseFloat(op.Minutes || 0), 0).toFixed(2);
            const totalOps = ops.reduce((a, op) => a + parseFloat(op.Allot_Oper || 0), 0);

            const grades = {}; 
            const machines = {};
            ops.forEach(op => {
                grades[op.Grade] = (grades[op.Grade] || 0) + parseFloat(op.Allot_Oper || 0);
                machines[op.Mch_Type] = (machines[op.Mch_Type] || 0) + parseFloat(op.Allot_Oper || 0);
            });

            let rows = '';
            if (ops.length === 0) {
                rows = `<tr><td colspan="5" class="text-center py-12 text-gray-500 text-sm">No OB data found for this style</td></tr>`;
            } else {
                rows = ops.map(op => {
                    const isCritical = op.OP_TYPE === 'CRITICAL';
                    const gradeColor = 
                        op.Grade === 'A' ? 'bg-green-100 text-green-800' :
                        op.Grade === 'B' ? 'bg-blue-100 text-blue-800' :
                        op.Grade === 'C' ? 'bg-yellow-100 text-yellow-800' :
                        op.Grade === 'D' ? 'bg-orange-100 text-orange-800' :
                        'bg-gray-100 text-gray-700';

                    return `
                    <tr class="border-t hover:bg-gray-50">
                        <td class="px-4 py-1">
                            <div class="flex items-center gap-2">
                                <span class="text-sm text-gray-600">${op.SNo || ''}.</span>
                                <span class="text-sm font-medium">${op.Operation || 'N/A'}</span>
                            </div>
                        </td>
                        <td class="px-4 py-1 text-sm text-gray-700">${op.Mch_Type || '-'}</td>
                        <td class="px-4 py-1 text-center">
                            <span class="inline-flex items-center justify-center w-5 h-5 rounded-full text-sm font-semibold ${gradeColor}">
                                ${op.Grade || 'H'}
                            </span>
                        </td>
                        <td class="px-4 py-1 text-center text-sm font-semibold text-gray-800">${op.Allot_Oper || 0}</td>
                        <td class="px-4 py-1 text-center text-sm font-mono text-gray-700">${parseFloat(op.Minutes || 0).toFixed(2)}</td>
                    </tr>`;
                }).join('');
            }

            const html = `
            <div class="bg-gray-50 border border-gray-200 rounded-lg p-2 mx-2 mt-2 mb-1 sticky top-0 z-10">
                <div class="flex items-start gap-10">
                    <!-- Left: SAM + Tailors -->
                    <div class="flex items-start gap-10">
                        <!-- Total SAM -->
                        <div class="text-center">
                            <p class="text-gray-600 text-sm">Total SAM</p>
                            <p class="text-3xl font-semibold">${totalSAM}</p>
                        </div>
                        <!-- Vertical Line -->
                        <div class="h-24 w-px bg-gray-300"></div>
                        <!-- Total Tailors -->
                        <div class="text-center">
                            <p class="text-gray-600 text-sm">Tailors</p>
                            <p class="text-3xl font-semibold">${totalOps}</p>
                        </div>
                    </div>
                          <!-- Vertical Line -->
                    <div class="h-24 w-px bg-gray-300 mx-2"></div>
                    <!-- Right: Tailor Grades + Machine Types -->
                    <div class="flex ">
                        <!-- Tailor Grades -->
                        <div>
                            <p class="text-gray-700 font-medium mb-1 text-sm">Tailor Grades</p>
                            <div class="flex flex-wrap gap-2">
                                ${Object.entries(grades).map(([g, c]) => 
                                    `<span class="px-3 py-1 bg-gray-100 rounded-full text-sm">${g}: ${c}</span>`
                                ).join('')}
                            </div>
                        </div>
                        <!-- Vertical Line -->
                        <div class="h-24 w-px bg-gray-300 mr-4"></div>
                        <!-- Machine Types -->
                        <div>
                            <p class="text-gray-700 font-medium mb-1 text-sm">Machine Types</p>
                            <div class="flex flex-wrap gap-2">
                                ${Object.entries(machines).map(([m, c]) => 
                                    `<span class="px-3 py-1 bg-gray-100 rounded-full text-sm">${m}: ${c}</span>`
                                ).join('')}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Operations Table -->
            <div class="mt-2 p-3">
                <h3 class="text-base font-semibold text-gray-800 mb-2 hidden">Operation Breakdown (OB)</h3>
                <div class="overflow-x-auto">
                    <table class="w-full">
                            <thead class="bg-gray-50 border-b">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-700">Operation</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-700">Machine</th>
                                    <th class="px-4 py-3 text-center text-xs font-medium text-gray-700">Grade</th>
                                    <th class="px-4 py-3 text-center text-xs font-medium text-gray-700">Operators</th>
                                    <th class="px-4 py-3 text-center text-xs font-medium text-gray-700">SAM</th>
                                </tr>
                            </thead>
                        <tbody class="divide-y divide-gray-200">
                            ${rows}
                        </tbody>
                    </table>
                </div>
            </div>`;

            $('#obContent').html(html);
        }


        function populateBOMContent(bomData, ccNo, ccColor) {
            if (!bomData || bomData.length === 0) {
                $('#bomTableContainer').html(`
                    <div class="text-center py-20 text-red-600 text-xl">
                        No BOM data found for this style
                    </div>
                `).removeClass('hidden');
                $('#bomLoading').addClass('hidden');
                return;
            }

            let rows = bomData.map(item => {
                const sizeDep = item.Size_Avail === '1' || item.Size_Avail?.toLowerCase() === 'yes' ? 'Yes' : 'No';
                const source = item.Currency === 'Import' ? 'Import' : 'Local';
                const projFrc = item.Ocn_Type === 'Proj' ? 'Projection' : 'FRC';

                return `
                <tr class="border-t hover:bg-gray-50">
                    <td class="px-2 py-2 font-medium">${item.Item || 'N/A'}</td>
                    <td class="px-2 py-2 text-center">
                        <span class="px-2 py-1 rounded-full text-xs font-medium ${sizeDep === 'Yes' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-700'}">
                            ${sizeDep}
                        </span>
                    </td>
                    <td class="px-2 py-2 text-center">
                        <span class="px-2 py-1 rounded-full text-xs font-medium ${source === 'Import' ? 'bg-red-100 text-red-700' : 'bg-green-100 text-green-700'}">
                            ${source}
                        </span>
                    </td>
                    <td class="px-2 py-2 text-center font-medium">${item.Dom_LDay || '-'} days</td>
                    <td class="px-2 py-2 text-center font-medium">${item.Imp_LDays || '-'} days</td>
                    <td class="px-2 py-2">${item.Supplier || '-'}</td>
                    <td class="px-2 py-2 text-center">
                        <span class="px-3 py-1 rounded-full text-xs font-semibold ${projFrc === 'Projection' ? 'bg-purple-100 text-purple-800' : 'bg-orange-100 text-orange-800'}">
                            ${projFrc}
                        </span>
                    </td>
                </tr>`;
            }).join('');

            const tableHTML = `
            <div class="border rounded-xl overflow-hidden bg-white shadow-sm">
                <div class="max-h-96 overflow-y-auto">
                    <table class="w-full " style="font-size:12px;">
                        <thead class="bg-blue-50 text-gray-700 sticky top-0 z-20">
                            <tr>
                                <th class="px-2 py-2 text-left text-xs font-medium">Cmpt Name</th>
                                <th class="px-2 py-2 text-center text-xs font-medium">Size Dep</th>
                                <th class="px-2 py-2 text-center text-xs font-medium">Impt / Local</th>
                                <th class="px-2 py-2 text-center text-xs font-medium">D Time</th>
                                <th class="px-2 py-2 text-center text-xs font-medium">L Time</th>
                                <th class="px-2 py-2 text-left text-xs font-medium">Supplier</th>
                                <th class="px-2 py-2 text-left text-xs font-medium">Ocn_Type</th>
                            </tr>
                        </thead>
                        <tbody>
                            ${rows}
                        </tbody>
                    </table>
                </div>
            </div>`;

            $('#bomTableContainer').html(tableHTML).removeClass('hidden');
            $('#bomLoading').addClass('hidden');
        }




        // MAIN CLICK → OPEN POPUP (FIXED)
        $(document).on('click', '.orderpopupnew', function(e) {
            e.preventDefault();
            const ccNo = $(this).data('ccno');
            const costNo = $(this).data('costno');
            const model = $(this).data('model');
            const ccColor = $(this).text().trim();
            const selectionQty = $(this).data('selectionqty');
            const prjQty = $(this).data('prjqty');

            if (!ccNo) return alert('CC No missing!');

            // Track clicked element
            $('.orderpopupnew').removeClass('clicked');
            $(this).addClass('clicked');

            // Store selection/prj qty in case other pages (like Order Details) need them
            try {
                localStorage.setItem('selectedSelectionQty', selectionQty != null ? selectionQty : '0');
                localStorage.setItem('selectedPrjQty', prjQty != null ? prjQty : '0');
            } catch (err) {
                console.warn('Unable to store selection/prj qty in localStorage:', err);
            }

            $('#orderPopup').removeClass('hidden');
            
            // Update popup header dynamically
            const $header = $('#popupHeaderContent');
            $header.html(`
                <div class="flex items-center gap-4" id="popupHeaderContent">
                    <div>
                        <div class="flex">
                            <h2 class="text-xl font-semibold text-gray-900">${ccNo} - ${ccColor}</h2>
                            <h3 class="text-lg font-semibold text-gray-800">(OB)</h3>
                        </div> 
                        <p class="text-sm text-gray-500">Forecasted Order ID: ${ccNo}-${ccColor} • Buyer: DMI</p>  
                    </div>
                </div>    
            `);
            
            // Show loading in OB tab
            $('#obContent').html('<div class="p-20 text-center"><i class="fas fa-spinner fa-spin text-5xl text-blue-600"></i><p class="mt-4 text-xl text-gray-600">Loading OB...</p></div>');
            
            // Activate OB tab
            $('.tab-btn').removeClass('bg-blue-600 text-white').addClass('text-gray-600');
            $('[data-tab="ob"]').addClass('bg-blue-600 text-white').removeClass('text-gray-600');
            $('.tab-pane').addClass('hidden');
            $('#obContent').removeClass('hidden');
            
            // Set popup to OB dimensions
            $('#orderPopup').addClass('ob-tab-active');

            $.ajax({
                url: '/gut_plan_obchartdetails',
                method: 'GET',
                data: { ccno: ccNo,costno : costNo },
                success: function(res) {
                    if (res.success && res.data && res.data.length > 0) {
                        populateOrderPopup(res.data, ccNo, ccColor);
                        populateBOMContent(res.bomdetails || [], ccNo, ccColor);
                    } else {
                        $('#obContent').html('<div class="p-20 text-center text-red-600 text-xl">No OB data found</div>');
                    }
                },
                error: function() {
                    $('#obContent').html('<div class="p-20 text-center text-red-600 text-xl">Server error</div>');
                }
            });
        });

        // Close production modal via close button or background click
        $(document).on('click', '#closeProductionModal', function () {
            closeOverlayModal($('#tableModalproduction'));
        });

        $(document).on('click', '#tableModalproduction', function (e) {
            if (e.target.id === 'tableModalproduction') {
                closeOverlayModal($('#tableModalproduction'));
            }
        });

        // TAB SWITCHING
        $(document).on('click', '.tab-btn', function() {
            const tab = $(this).data('tab');
            $('.tab-btn').removeClass('bg-blue-600 text-white').addClass('text-gray-600');
            $(this).addClass('bg-blue-600 text-white').removeClass('text-gray-600');
            $('.tab-pane').addClass('hidden');
            $('#' + tab + 'Content').removeClass('hidden');
            
            // Update popup dimensions based on active tab
            $('#orderPopup').removeClass('ob-tab-active bom-tab-active');
            if (tab === 'ob') {
                $('#orderPopup').addClass('ob-tab-active');
                // Update header for OB tab
                const $header = $('#popupHeaderContent');
                const ccNo = $('.orderpopupnew.clicked').data('ccno');
                const ccColor = $('.orderpopupnew.clicked').text().trim();
                $header.html(`
                <div class="flex items-center gap-4" id="popupHeaderContent">
                    <div>
                        <div class="flex">
                            <h2 class="text-xl font-semibold text-gray-900">${ccNo} - ${ccColor}</h2>
                            <h3 class="text-lg font-semibold text-gray-800">(OB)</h3>
                        </div> 
                        <p class="text-sm text-gray-500">Forecasted Order ID: ${ccNo}-${ccColor} • Buyer: DMI</p>  
                    </div>
                </div>  
                `);
            } else if (tab === 'bom') {
                $('#orderPopup').addClass('bom-tab-active');
                // Update header for BOM tab
                const $header = $('#popupHeaderContent');
                const ccNo = $('.orderpopupnew.clicked').data('ccno');
                const ccColor = $('.orderpopupnew.clicked').text().trim();
                $header.html(`
                <div class="flex items-center gap-4" id="popupHeaderContent">
                    <div>
                        <div class="flex">
                            <h2 class="text-xl font-semibold text-gray-900">${ccNo} - ${ccColor}</h2>
                            <h3 class="text-lg font-semibold text-gray-800">(BOM)</h3>
                        </div> 
                        <p class="text-sm text-gray-500">Forecasted Order ID: ${ccNo}-${ccColor} • Buyer: DMI</p>  
                    </div>
                </div>  
                `);
            }
        });
    </script>




    <!-- Alerts Sidebar -->
    <div id="alertsSidebar" class="fixed right-0 top-0 h-full w-96 bg-white shadow-lg z-50 transform translate-x-full transition-transform duration-300 ease-in-out">
        <div class="flex justify-between items-center p-4 border-b">
            <h2 class="text-lg font-semibold text-gray-800">Alerts for 114227 - Purple</h2>
            <button id="closeAlertsSidebar" class="text-gray-500 hover:bg-gray-200 w-7 h-7 flex items-center justify-center rounded-full">
                ✕
            </button>
        </div>
        <div class="p-4">
            <p class="text-sm text-gray-600 mb-4">Review critical and non-critical issues for this order.</p>

            <h3 class="text-red-600 font-semibold mb-2">Critical Alerts</h3>
            <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-3 mb-4 rounded-md">
                <p class="text-sm">Critical alert for 114227 #1</p>
            </div>

            <h3 class="text-yellow-600 font-semibold mb-2">Not Critical Alerts</h3>
            <div class="space-y-2">
                <div class="bg-gray-100 p-3 rounded-md">
                    <p class="text-sm text-gray-800">Non-critical issue for 114227 #1</p>
                </div>
                <div class="bg-gray-100 p-3 rounded-md">
                    <p class="text-sm text-gray-800">Non-critical issue for 114227 #2</p>
                </div>
                <div class="bg-gray-100 p-3 rounded-md">
                    <p class="text-sm text-gray-800">Non-critical issue for 114227 #3</p>
                </div>
            </div>
        </div>
    </div>
    <!--Production popup RAj-->
    <div id="tableModalproduction" class="fixed inset-0 bg-black bg-opacity-60 z-50 hidden items-center justify-center">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-6xl max-h-[80vh] overflow-y-auto">
            <div class="flex items-center justify-between px-4 py-3 border-b">
                <div class="flex items-center gap-2">
                    <h5 class="text-lg font-semibold text-gray-800" id="tableModalLabelproduction"></h5>
                    <span id="noteText" class="text-sm text-gray-500"></span>
                </div>
                <button type="button" id="closeProductionModal" class="text-gray-500 hover:text-gray-800 text-xl font-bold">
                    ✕
                </button>
            </div>

            <div class="p-4">
                <table class="w-full text-xs border table_gut_production" id="abstractTable">
                    <thead class="bg-gray-100">
                        <tr>
                            <th rowspan="2">S.No</th> 
                            <th rowspan="2">Size</th>
                            <th rowspan="2">BOM Qty</th>
                            <th colspan="2">Cut Order</th>
                            <th colspan="3" class="centerallign">Cutting</th>
                            <th colspan="4" class="centerallign">Production</th>
                            <th colspan="5" class="centerallign">Finishing</th>

                        </tr>
                        <tr>
                            <!--  Cut Order -->
                            <th>CO Qty</th>
                            <th>CO Pending</th>
                            <!-- Cutting -->
                            <th>Cut Qty</th>
                            <th>Cut Pending</th>
                            <th>Cut Stock</th>
                            <!-- Production -->
                            <th>Inp Qty</th>
                            <th>Opt Qty</th>
                            <th>Rej Qty</th>
                            <th>Wip</th> 
                            <!-- FINISHING -->
                            <th>Pck Rcvd</th>
                            <th>Packed</th>
                            <th>Shipped</th>
                            <th>Un Packed</th>
                            <th>FG Stock</th>
                        
                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="2" class="sideallign">Total :</th>
                            <th id="totalBomQty" class="sideallign">0</th>
                            <th id="totalCutOrderQty" class="sideallign operation_clickable" data-type="CUT ORD" 
                                data-cost-id="" 
                                data-title="COQty" style="cursor: pointer; color:#007bff">0</th>
                            <th id="totalCutOrderPending" class="sideallign">0</th>
                            <th id="totalCutQty" class="sideallign operation_clickable" data-type="CUTTING" 
                                data-cost-id="" 
                                data-title="CutQty" style="cursor: pointer; color:#007bff">0</th>
                            <th id="totalCutPending" class="sideallign">0</th>
                            <th id="totalCutStock" class="sideallign">0</th>
                            <th id="totalprodInpQty" class="sideallign operation_clickable" data-type="LINE" 
                                data-cost-id="" 
                                data-title="IntQty" style="cursor: pointer; color:#007bff">0</th>
                            <th id="totalprodOptQty" class="sideallign operation_clickable" data-type="PROD OK" 
                                data-cost-id="" 
                                data-title="OptQty" style="cursor: pointer; color:#007bff">0</th>
                            <th id="totalprodRejQty" class="sideallign operation_clickable" data-type="PROD REJ"   data-cost-id="" 
                                data-title="RejQty" style="cursor: pointer; color:#007bff" >0</th>
                            <th id="totalprodWip" class="sideallign">0</th>
                            <th id="totalPckRcvd" class="sideallign operation_clickable" data-type="PACK ACK" 
                                data-cost-id="" 
                                data-title="PckRcvd" style="cursor: pointer; color:#007bff">0</th>
                            <th id="totalPacked" class="sideallign operation_clickable" data-type="PACKING" 
                                data-cost-id="" 
                                data-title="Packed" style="cursor: pointer; color:#007bff">0</th>
                            <th id="totalShpd" class="sideallign operation_clickable" data-type="SHIP" 
                                data-cost-id="" 
                                data-title="Shipped" style="cursor: pointer; color:#007bff">0</th>
                            <th id="totalUnPacked" class="sideallign">0</th>
                            <th id="totalFgStock" class="sideallign">0</th>
                        </tr>
                    </tfoot>
                </table>


                <h6 class='prod_summary_datails text-center' style="display: none"></h6>
                <table class="table-responsive table-bordered" id ="prod_summaryTable" style="max-width: 1300px; max-height: 200px;font-size: 12px; display: none">
                    <thead style="position: sticky; top: 0; z-index: 10; background-color: white">
                        
                    </thead>
                    
                    <tbody>
                        <!-- Your table data rows go here -->
                    </tbody>
                    <tfoot></tfoot>

                
                </table>
            </div>
        </div>
    </div>
    <!--Production popup End RAj-->


    <!-- SHippment Popup Start Raj-->
    <div id="shipQtyModal" class="fixed inset-0 bg-black bg-opacity-60 z-50 hidden items-center justify-center">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-5xl max-h-[80vh] overflow-y-auto">
            <div class="flex items-center justify-between px-4 py-3 border-b">
                <h5 class="text-lg font-semibold text-gray-800" id="shipQtyModalLabel">Shipment Details</h5>
                <button type="button" id="closeShipQtyModal" class="text-gray-500 hover:text-gray-800 text-xl font-bold">
                    ✕
                </button>
            </div>
            <div class="p-4">
                <div class="table-responsive" style="font-size: 12px; max-height: 400px; overflow-y:auto">
                    <table id ="shipmentTable" class="w-full text-xs">
                        <thead style="position: sticky; top: 0; z-index: 10; background-color: white">
                            <tr>
                                <th>Invoice_No</th>
                                <th>Invoice_Date</th>
                                <th>Ocn_No</th>
                                <th>Po_No</th>
                                <th>Inv_Qty</th>
                                <th>Rate</th>
                                <th>Value</th>
                                <th>Mode</th>
                            </tr>
                        </thead>
                        
                        <tbody>
                            <!-- Your table data rows go here -->
                        </tbody>

                        <tfoot style="position: sticky; bottom: 0; z-index: 10; background-color: white">
                            <tr>
                                <th class="sideallign">Total :</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th class="sideallign"></th>
                                <th></th>
                                <th class="sideallign"></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- SHippment Popup End Raj-->

    <script>
        // Global sort direction for header arrows (used by inline onclick)
        let sortDirection = {};
        
        // Global sorting function (used by header onclick)
        function sortTable(columnIndex) {
            const table = document.querySelector('table');
            const tbody = table.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr'));

            // Toggle sort direction
            sortDirection[columnIndex] = sortDirection[columnIndex] === 'asc' ? 'desc' : 'asc';

            // Update sort indicators
            document.querySelectorAll('.sort-indicator').forEach((indicator, index) => {
                if (index === columnIndex) {
                    indicator.textContent = sortDirection[columnIndex] === 'asc' ? '▲' : '▼';
                    indicator.classList.remove('text-gray-500');
                    indicator.classList.add('text-blue-600', 'font-bold');
                } else {
                    // Show stacked arrows by using a newline between ▲ and ▼
                    indicator.textContent = '▲\n▼';
                    indicator.classList.remove('text-blue-600', 'font-bold');
                    indicator.classList.add('text-gray-500');
                }
            });

            // Sort rows (safely handle rows without that column)
            rows.sort((a, b) => {
                const aCell = a.cells[columnIndex];
                const bCell = b.cells[columnIndex];

                const aValue = aCell ? aCell.textContent.trim() : '';
                const bValue = bCell ? bCell.textContent.trim() : '';

                // Check if values are numeric
                const aNum = parseFloat(aValue.replace(/,/g, ''));
                const bNum = parseFloat(bValue.replace(/,/g, ''));

                if (!isNaN(aNum) && !isNaN(bNum)) {
                    return sortDirection[columnIndex] === 'asc' ? aNum - bNum : bNum - aNum;
                } else {
                    // String comparison
                    return sortDirection[columnIndex] === 'asc'
                        ? aValue.localeCompare(bValue)
                        : bValue.localeCompare(aValue);
                }
            });

            // Reorder rows in DOM
            rows.forEach(row => tbody.appendChild(row));
        }
        
        // Access and display the active portal type
        $(document).ready(function() {
            // --- Portal type ---
            // Get portal type from localStorage or window variable
            const portalType = localStorage.getItem('portalType') || window.portalType || 'gut_new';
            console.log('Current active portal type:', portalType);
            
            // --- Column filter configuration and caching ---
            const filterConfig = {
                cccolor: { colIndex: 0, title: 'CC-Color' },
                season:  { colIndex: 1, title: 'Season' },
                model:   { colIndex: 3, title: 'Model no.' }
            };

            const allFilterValues = {
                cccolor: [],
                season:  [],
                model:   []
            };

            const activeFilters = {
                cccolor: new Set(),
                season:  new Set(),
                model:   new Set()
            };

            // Cache initial values from all data rows
            $('#ordersTableBody tr.data-row').each(function () {
                const $cells = $(this).find('td');

                allFilterValues.cccolor.push($cells.eq(filterConfig.cccolor.colIndex).text().trim());
                allFilterValues.season.push($cells.eq(filterConfig.season.colIndex).text().trim());
                allFilterValues.model.push($cells.eq(filterConfig.model.colIndex).text().trim());
            });

            // Deduplicate and sort, then snapshot initial full lists
            Object.keys(allFilterValues).forEach(key => {
                const uniqueSorted = Array.from(new Set(allFilterValues[key])).sort((a, b) => a.localeCompare(b));
                allFilterValues[key] = uniqueSorted;
            });

            const initialFilterValues = {
                cccolor: [...allFilterValues.cccolor],
                season:  [...allFilterValues.season],
                model:   [...allFilterValues.model]
            };

            let currentFilterValues = {
                cccolor: [...initialFilterValues.cccolor],
                season:  [...initialFilterValues.season],
                model:   [...initialFilterValues.model]
            };
            
            // Handle CC-Color → Order Details link clicks
            $('.orderdetails-link').on('click', function(e) {
                e.preventDefault();

                const costno        = $(this).data('costno');
                const ccno          = $(this).data('ccno');
                const color         = $(this).data('color');
                const model         = $(this).data('model');
                const season        = $(this).data('season');
                const selectionQty  = $(this).data('selectionqty');
                const prjQty        = $(this).data('prjqty');
                const portalType    = localStorage.getItem('portalType') || window.portalType || 'gut_new';

                localStorage.setItem('selectedseason', season ?? '-');
                if (model) localStorage.setItem('selectedmodel', model);
                localStorage.setItem('selectedCostNo', costno ?? '');
                localStorage.setItem('selectedCcNo', ccno ?? '');
                localStorage.setItem('selectedColor', color ?? '-');
                localStorage.setItem('selectedSelectionQty', selectionQty != null ? selectionQty : '0');
                localStorage.setItem('selectedPrjQty', prjQty != null ? prjQty : '0');
                localStorage.setItem('selectedportalType', portalType);

                window.open('/orderdetails', '_self');
            });

            // Handle Demand Trend link clicks (PO + FC column)
            $('.demandtrend-link').on('click', function(e) {
                e.preventDefault();

                const costno = $(this).data('costno');
                const ccno = $(this).data('ccno');
                const color = $(this).data('color');
                const portalType = localStorage.getItem('portalType') || window.portalType || 'gut_new';
                const season = $(this).data('season');
                const model = $(this).data('model');
                localStorage.setItem('selectedseason', season);
				localStorage.setItem('selectedmodel', model);
                localStorage.setItem('selectedCostNo', costno);
                localStorage.setItem('selectedCcNo', ccno);
                localStorage.setItem('selectedColor', color);
                localStorage.setItem('portalType', portalType);

                window.open('/demandtrend', '_self');
            });

                      // Handle projection link clicks
               $('.cut-link').on('click', function(e) {
                e.preventDefault();

                const costno = $(this).data('costno');
                const ccno = $(this).data('ccno');
                const color = $(this).data('color');
                const modal = $(this).data('modal'); // <-- get modal value
                const portalType = localStorage.getItem('portalType') || window.portalType || 'gut_new';
                const season = $(this).data('season');
                
                localStorage.setItem('selectedseason', season);
                localStorage.setItem('selectedCostNo', costno);
                localStorage.setItem('selectedCcNo', ccno);
                localStorage.setItem('selectedColor', color);
                if (modal) localStorage.setItem('selectedmodal', modal); // <-- set modal if present
                localStorage.setItem('portalType', portalType);

                window.open('/cutorderissue', '_self');
            });         $('.projection-link').on('click', function(e) {
                e.preventDefault();
                
                const costno = $(this).data('costno');
                const ccno = $(this).data('ccno');
                const color = $(this).data('color');
                const modal = $(this).data('modal'); // <-- this should not be null!
                console.log('Modal value from data-modal:', modal);
                const portalType = localStorage.getItem('portalType') || window.portalType || 'gut_new';
                const season = $(this).data('season');
                
                localStorage.setItem('selectedseason', season);
                // Store data in localStorage for the projection page to retrieve
                localStorage.setItem('selectedCostNo', costno);
                localStorage.setItem('selectedCcNo', ccno);
                localStorage.setItem('selectedColor', color);
                if (modal) localStorage.setItem('selectedmodal', modal); // <-- only sets if modal is truthy
                localStorage.setItem('portalType', portalType);
                
                window.open('/projectionplanning', '_self');
            });

            // Handle FRC link clicks
            $('.frc-link').on('click', function(e) {
                e.preventDefault();
                
                const costno = $(this).data('costno');
                const ccno = $(this).data('ccno');
                const color = $(this).data('color');
                const modal = $(this).data('modal'); // <-- add this line
                const portalType = localStorage.getItem('portalType') || window.portalType || 'gut_new';
                const season = $(this).data('season');
                
                localStorage.setItem('selectedseason', season);
                // Store data in localStorage for the FRC page to retrieve
                localStorage.setItem('selectedCostNo', costno);
                localStorage.setItem('selectedCcNo', ccno);
                localStorage.setItem('selectedColor', color);
                if (modal) localStorage.setItem('selectedmodal', modal); // <-- set modal if present
                localStorage.setItem('portalType', portalType);
                
                // Open FRC planning page
                window.open('/frcplanning', '_self');
            });

            // Handle Demand link clicks
            $('.demand-link').on('click', function(e) {
                e.preventDefault();
                
                const costno = $(this).data('costno');
                const ccno = $(this).data('ccno');
                const color = $(this).data('color');
                const modal = $(this).data('modal'); // <-- get modal value
                const portalType = localStorage.getItem('portalType') || window.portalType || 'gut_new';
                const season = $(this).data('season');
                
                localStorage.setItem('selectedseason', season);
                localStorage.setItem('selectedCostNo', costno);
                localStorage.setItem('selectedCcNo', ccno);
                localStorage.setItem('selectedColor', color);
                if (modal) localStorage.setItem('selectedmodal', modal); // <-- set modal if present
                localStorage.setItem('portalType', portalType);
                
                window.open('/demandpostatus', '_self');
            });
            
            // Handle Cut Order link clicks
            $('.cut-link').on('click', function(e) {
                e.preventDefault();

                const costno = $(this).data('costno');
                const ccno = $(this).data('ccno');
                const color = $(this).data('color');
                const modal = $(this).data('modal'); // <-- get modal value
                const portalType = localStorage.getItem('portalType') || window.portalType || 'gut_new';
                const season = $(this).data('season');
                
                localStorage.setItem('selectedseason', season);
                localStorage.setItem('selectedCostNo', costno);
                localStorage.setItem('selectedCcNo', ccno);
                localStorage.setItem('selectedColor', color);
                if (modal) localStorage.setItem('selectedmodal', modal); // <-- set modal if present
                localStorage.setItem('portalType', portalType);

                window.open('/cutorderissue', '_self');
            });
            
            // Build checkbox list for a given key into the shared panel
            function renderFilterOptions(key) {
                const $options = $('#columnFilterOptions');
                $options.empty();

                const values = currentFilterValues[key] || [];

                values.forEach((val, idx) => {
                    const $label = $('<label/>', {
                        class: 'flex items-center gap-2 text-[11px] py-0.5 cursor-pointer'
                    });

                    const $checkbox = $('<input/>', {
                        type: 'checkbox',
                        class: 'filter-checkbox',
                        'data-filter-key': key
                    }).val(val);

                    // If this value is currently selected, keep it checked; if no filter yet, default all to checked
                    if (activeFilters[key].size === 0 || activeFilters[key].has(val)) {
                        $checkbox.prop('checked', true);
                    }

                    const displayText = val === '' ? '(Blank)' : val;

                    const $span = $('<span/>', {
                        class: 'truncate',
                        text: displayText,
                        title: displayText
                    });

                    $label.append($checkbox).append($span);
                    $options.append($label);
                });

                // Reset search box whenever we render options for a key
                const $search = $('#columnFilterSearch');
                if ($search.length) {
                    $search.val('');
                }
            }

            // Apply all active column filters to table rows
            function applyColumnFilters() {
                $('#ordersTableBody tr.data-row').each(function () {
                    const $row = $(this);
                    let visible = true;

                    for (const [key, cfg] of Object.entries(filterConfig)) {
                        const selected = activeFilters[key];
                        if (selected.size > 0) {
                            const cellText = $row.find('td').eq(cfg.colIndex).text().trim();
                            if (!selected.has(cellText)) {
                                visible = false;
                                break;
                            }
                        }
                    }

                    $row.toggle(visible);
                });

                // After filtering rows, recompute which values are currently available in visible rows
                const visibleValues = {
                    cccolor: new Set(),
                    season:  new Set(),
                    model:   new Set()
                };

                $('#ordersTableBody tr.data-row:visible').each(function () {
                    const $row = $(this);
                    visibleValues.cccolor.add($row.find('td').eq(filterConfig.cccolor.colIndex).text().trim());
                    visibleValues.season.add($row.find('td').eq(filterConfig.season.colIndex).text().trim());
                    visibleValues.model.add($row.find('td').eq(filterConfig.model.colIndex).text().trim());
                });

                // Update currentFilterValues to only values that exist in visible rows
                Object.keys(currentFilterValues).forEach(key => {
                    if (visibleValues[key].size > 0) {
                        currentFilterValues[key] = Array.from(visibleValues[key]).sort((a, b) => a.localeCompare(b));
                    } else {
                        // If nothing is visible (e.g. filters exclude all rows), keep list as-is so user can recover
                        currentFilterValues[key] = [...initialFilterValues[key]];
                    }
                });

                // Show / hide 'No matches' row
                const anyVisible = $('#ordersTableBody tr.data-row:visible').length > 0;
                $('#noMatchesRow').toggle(!anyVisible);

                // Recompute totals only on visible rows
                calculateTotals();
            }

            // --- Filter panel open/close ---
            let currentFilterKey = null;

            window.openColumnFilter = function (key, buttonEl) {
                currentFilterKey = key;

                const cfg = filterConfig[key];
                if (!cfg) return;

                const panel = document.getElementById('columnFilterPanel');
                const titleEl = document.getElementById('columnFilterTitle');

                titleEl.textContent = `Filter: ${cfg.title}`;

                // Position panel under the header cell / button relative to table container
                const rect = buttonEl.getBoundingClientRect();
                const container = document.querySelector('.bg-white.shadow-sm.rounded-lg.overflow-hidden.border');
                const containerRect = container ? container.getBoundingClientRect() : { top: 0, left: 0 };

                panel.style.top = (rect.bottom - containerRect.top + 4) + 'px';
                panel.style.left = (rect.left - containerRect.left) + 'px';

                renderFilterOptions(key);

                panel.classList.remove('hidden');
            };

            window.hideColumnFilter = function () {
                document.getElementById('columnFilterPanel').classList.add('hidden');
                currentFilterKey = null;
            };

            // Close when clicking outside
            document.addEventListener('click', function (e) {
                const panel = document.getElementById('columnFilterPanel');
                if (!panel || panel.classList.contains('hidden')) return;

                if (!panel.contains(e.target) && !e.target.closest('.column-filter-trigger')) {
                    hideColumnFilter();
                }
            });

            // Select All
            $('#filterSelectAllBtn').on('click', function () {
                if (!currentFilterKey) return;

                activeFilters[currentFilterKey] = new Set(allFilterValues[currentFilterKey]);
                $('#columnFilterOptions input.filter-checkbox').prop('checked', true);

                applyColumnFilters();
            });

            // Live search inside the column filter panel – filters visible options only
            $('#columnFilterSearch').on('input', function () {
                const term = $(this).val().toLowerCase();
                const $labels = $('#columnFilterOptions label');

                if (!term) {
                    // If search cleared, show all options
                    $labels.show();
                    return;
                }

                $labels.each(function () {
                    const text = $(this).find('span').text().toLowerCase();
                    $(this).toggle(text.includes(term));
                });
            });

            // Clear All
            $('#filterClearAllBtn').on('click', function () {
                if (!currentFilterKey) return;

                activeFilters[currentFilterKey].clear();
                $('#columnFilterOptions input.filter-checkbox').prop('checked', false);

                // No selection => treat as no filter for this column
                applyColumnFilters();
            });

            // Individual checkbox change
            $(document).on('change', '#columnFilterOptions input.filter-checkbox', function () {
                const key = $(this).data('filter-key');
                if (!key) return;

                const selected = new Set();
                $('#columnFilterOptions input.filter-checkbox:checked').each(function () {
                    selected.add($(this).val());
                });

                activeFilters[key] = selected;

                applyColumnFilters();
            });

            // Reset all three filters to initial full lists and show all rows
            $('#resetColumnFiltersBtn').on('click', function () {
                // Clear active selections
                Object.keys(activeFilters).forEach(key => {
                    activeFilters[key].clear();
                });

                // Restore full value arrays
                currentFilterValues = {
                    cccolor: [...initialFilterValues.cccolor],
                    season:  [...initialFilterValues.season],
                    model:   [...initialFilterValues.model]
                };

                // Show all rows
                $('#ordersTableBody tr.data-row').show();
                $('#noMatchesRow').addClass('hidden');

                // If a panel is open, rerender it from restored lists
                if (currentFilterKey) {
                    renderFilterOptions(currentFilterKey);
                }

                // Recompute totals
                calculateTotals();
            });

            // Calculate table totals (only visible rows)
            function calculateTotals() {
                let totals = {
                    selQty: 0,
                    poFc: 0,
                    prjQty: 0,
                    frcQty: 0,
                    cfmPo: 0,
                    cutOrder: 0,
                    prod: 0,
                    shipped: 0,
                    alerts: 0
                };
                
                $('#ordersTableBody tr.data-row:visible').each(function() {
                    const row = $(this);
                    totals.selQty += parseFloat(row.find('td').eq(4).text().replace(/,/g, '')) || 0;
                    totals.poFc += parseFloat(row.find('td').eq(5).text().replace(/,/g, '')) || 0;
                    totals.prjQty += parseFloat(row.find('td').eq(6).text().replace(/,/g, '')) || 0;
                    totals.frcQty += parseFloat(row.find('td').eq(7).text().replace(/,/g, '')) || 0;
                    totals.cfmPo += parseFloat(row.find('td').eq(8).text().replace(/,/g, '')) || 0;
                    totals.cutOrder += parseFloat(row.find('td').eq(9).text().replace(/,/g, '')) || 0;
                    totals.prod += parseFloat(row.find('td').eq(10).text().replace(/,/g, '')) || 0;
                    totals.shipped += parseFloat(row.find('td').eq(11).text().replace(/,/g, '')) || 0;
                    
                    // Count alerts
                    const alertCell = row.find('td').eq(20);
                    const alertCount = alertCell.find('.bg-red-500, .bg-yellow-500').length;
                    totals.alerts += alertCount;
                });
                
                // Update footer
                $('#total-sel-qty').text(totals.selQty.toLocaleString());
                $('#total-po-fc').text(totals.poFc.toLocaleString());
                $('#total-prj-qty').text(totals.prjQty.toLocaleString());
                $('#total-frc-qty').text(totals.frcQty.toLocaleString());
                $('#total-cfm-po').text(totals.cfmPo.toLocaleString());
                $('#total-cut-order').text(totals.cutOrder.toLocaleString());
                $('#total-prod').text(totals.prod.toLocaleString());
                $('#total-shipped').text(totals.shipped.toLocaleString());
                $('#total-alerts').text(totals.alerts);
            }
            
            // Calculate totals on page load
            calculateTotals();
            
            // Recalculate when search/filter changes
            $('#orderTableSearch').on('input', function() {
                setTimeout(calculateTotals, 100);
            });

			document.addEventListener('click', () => {
				fetch('/check-session')
					.then(response => response.json())
					.then(data => {
						if (!data.active) {
							//alert("⚠️ Your session has timed out.");
							toastr.warning('⚠️ Your session has timed out.');
							setTimeout(() => {
								window.location.href = "/login";
							}, 3000);
						}
					})
					.catch(err => {
						console.error('Session check failed:', err);
					});
			});
        });

        // Helper: open/close Tailwind-style overlay modals
        function openOverlayModal($el) {
            $el.removeClass('hidden').addClass('flex');
        }

        function closeOverlayModal($el) {
            $el.addClass('hidden').removeClass('flex');
        }

        // Shipment  Quantity start - Raj
        $(document).on('click', '.shipqty', function () {
            let buyerQty = parseFloat($(this).text()) || 0;
            if (buyerQty <= 0) return; //ignore the click
            let title = $(this).data('ship-title');

            const costId = $(this).data('cost-id');

            $('#shipmentTable tbody').html('<tr><td colspan="10" class="text-center">⏳ Fetching data...</td></tr>');

            const $shipModal = $('#shipQtyModal');
            openOverlayModal($shipModal);

            $.ajax({
                url: "{{ route('gut_shippment_details') }}", 
                method: 'GET',
                data: { cost_id: costId },
                success: function (response) {
                    $('#shipQtyModalLabel').text('Shipment Details - ' + title);
                    if (!response || !response.data || response.data.length === 0) {
                        $('#shipmentTable tbody').html('<tr><td colspan="11" class="text-center text-danger"> No records found!</td></tr>');
                        return;
                    }
                    else{
                        // Destroy if already initialized
                    if ($.fn.DataTable.isDataTable('#shipmentTable')) {
                        $('#shipmentTable').DataTable().destroy();
                    }
                    let formatNum = val => { const num = parseFloat(val);
                        return (!isNaN(num)) ? num.toFixed(2) : '0.00';
                    };

                    let rows = response.data.map(row => `
                        <tr>
                            <td class="leftallign">${row.Invoice_No || ''}</td>
                            <td class="leftallign">${formatDateTime(row.Invoice_Date) || ''}</td>
                            <td class="leftallign">${row.Ocn_No || ''}</td>
                            <td class="leftallign">${row.Po_No || ''}</td>
                            <td class="sideallign">${formatNum(row.Inv_Qty) || 0}</td>
                            <td class="sideallign">${formatNum(row.Rate) || 0}</td>
                            <td class="sideallign">${formatNum(row.Value) || 0}</td>    
                            <td class="leftallign">${row.Ship_Mode || ''}</td>               
                        </tr>
                    `).join('');

                    $('#shipmentTable tbody').html(rows);

                    // Init DataTable
                    $('#shipmentTable').DataTable({
                        ordering: true,
                        paging: false,
                        pageLength: 50,
                        searching: true,
                        columnDefs: [
                
                            { type: 'dd-mm-yy', targets: [1] } // Ensuring sorting works for date columns
                        ],
                        dom: 'Bfrtip',
                        buttons: [
                                {
                                    extend: 'excelHtml5',
                                    title: 'Shipment Quantity Details',
                                    exportOptions: {
                                        columns: ':visible',
                                        format: {
                                            body: function (data, row, column) {
                                                return [1].includes(column) && /\d{2}-\d{2}-\d{2}/.test(data)
                                                    ? moment(data, 'DD-MM-YY').format('YYYY-MM-DD') // Convert date format
                                                    : data.replace(/<[^>]+>/g, ''); // Remove HTML tags if any
                                            }
                                        }
                                    },
                                    footer: true
                                },
                                {
                                    extend: 'pdfHtml5',
                                    text: 'PDF',
                                    title: 'Shipment Quantity Details',
                                    orientation: 'landscape',
                                    pageSize: 'A3',
                                    exportOptions: {
                                        columns: ':visible'
                                    },
                                    customize: function(doc) {
                                        doc.defaultStyle.fontSize = 7;
                                        doc.content[1].table.widths = 'auto';  
                                        doc.content[1].table.dontBreakRows = true;  
                                    }
                                }
                            ],
                            footerCallback: function (row, data, start, end, display) {
                                let api = this.api();
                                let floatVal = (i) => {
                                    if (typeof i === 'string') {
                                        const text = $('<div>').html(i).text(); // safely strip out tags like <span>
                                        return parseFloat(text.replace(/,/g, '')) || 0;
                                    }
                                    return typeof i === 'number' ? i : 0;
                                };

                                var columnsToSum = [4, 6]; 

                                columnsToSum.forEach(function (colIndex) {
                                    var total = api
                                        .column(colIndex, { page: 'current' }) // Sum only visible data
                                        .data()
                                        .reduce((a, b) => floatVal(a) + floatVal(b), 0);

                                    // Update footer with total
                                    $(api.column(colIndex).footer()).html(Math.round(total));
                                    // var totalInLakhs = (total / 100000).toFixed(2);
                                    // $(api.column(colIndex).footer()).html(totalInLakhs);
                                });
                            
                            }
                    });
                }
                },
                error: function (xhr) {
                    console.error(xhr);
                    $('#shipmentTable tbody').html('<tr><td colspan="11" class="text-danger text-center">🔥 Error fetching data!</td></tr>');
                }
            });
        });
        // Close shipment modal via close button or background click
        $(document).on('click', '#closeShipQtyModal', function () {
            closeOverlayModal($('#shipQtyModal'));
        });

        $(document).on('click', '#shipQtyModal', function (e) {
            if (e.target.id === 'shipQtyModal') {
                closeOverlayModal($('#shipQtyModal'));
            }
        });
        // Shipment Quantity end - Raj

        //  production Popup  ajax  Raj
        let abstractTable;

        $(document).on('click', '.production', function () {
            let costid = $(this).data('cost-id');
            let title = $(this).data('production-title');
            $("#preloder").fadeIn();

            // Open production overlay modal
            const $prodModal = $('#tableModalproduction');
            openOverlayModal($prodModal);

            if ($.fn.DataTable.isDataTable('#prod_summaryTable')) {
                $('#prod_summaryTable').DataTable().clear().destroy();
                $('#prod_summaryTable').hide(); // Hide the whole table
            }

            const productionurl = `{{ route('gut-productstatus') }}`; // Laravel route

            $('#tableModalLabelproduction').text('Production Order Details - ' + title);

            $.ajax({
                url: productionurl,
                method: 'GET',
                data: { costid },
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                },
                success: function (response) {
                    $("#preloder").fadeOut();

                    if (response.success) {
                        const data = response.data;

                        // Destroy old table instance if exists
                        if ($.fn.DataTable.isDataTable('#abstractTable')) {
                            $('#abstractTable').DataTable().clear().destroy();
                        }

                        $('#abstractTable tbody').empty();
                        

                        data.forEach((item, index) => {
                            const row = `
                                <tr>
                                    <td class="sideallign">${index + 1}</td>
                                    <td class="leftallign">${item.Size || '-'}</td>
                                    <td class="sideallign">${item.Bom_Qty || 0}</td>
                                    <td class="sideallign">${item.CO_Qty || 0}</td>
                                    <td class="sideallign">${(item.CO_Pend || 0) - (item.Line_Issued || 0)}</td>
                                    <td class="sideallign">${item.Cut_Qty || 0}</td>
                                    <td class="sideallign">${item.Cut_Pend || 0}</td>
                                    <td class="sideallign">${item.Cut_Stock || 0}</td>
                                    <td class="sideallign">${item.Inp_Qty || 0}</td>
                                    <td class="sideallign">${item.Opt_Qty || 0}</td>
                                    <td class="sideallign">${item.Rej_Qty || 0}</td>
                                    <td class="sideallign">${item.WIP || 0}</td>
                                    <td class="sideallign">${item.Pck_Rcvd || 0}</td>
                                    <td class="sideallign">${item.Packed || 0}</td>
                                    <td class="sideallign">${item.Shipped || 0}</td>
                                    <td class="sideallign">${item.Un_Packed || 0}</td>
                                    <td class="sideallign">${item.FG_Stock || 0}</td>
                                </tr>
                            `;
                            $('#abstractTable tbody').append(row);
                        });

                        $('#totalCutOrderQty').data('cost-id', costid); 
                        $('#totalCutQty').data('cost-id', costid);
                        $('#totalprodInpQty').data('cost-id', costid);
                        $('#totalprodOptQty').data('cost-id', costid);
                        $('#totalPckRcvd').data('cost-id', costid);
                        $('#totalprodRejQty').data('cost-id', costid);
                        $('#totalPacked').data('cost-id', costid);
                        $('#totalShpd').data('cost-id', costid);

                        // Reinitialize DataTable
                        abstractTable = $('#abstractTable').DataTable({
                            dom: 'Bfrtip',
                            buttons: [
                                {
                                    extend: 'excelHtml5',
                                    title: 'Production Details',
                                    exportOptions: {
                                        columns: ':visible'
                                    },
                                    footer: true
                                },
                                {
                                    extend: 'pdfHtml5',
                                    text: 'PDF',
                                    title: 'Production Details',
                                    orientation: 'landscape',
                                    pageSize: 'A3',
                                    exportOptions: {
                                        columns: ':visible'
                                    },
                                    customize: function(doc) {
                                        doc.defaultStyle.fontSize = 7;
                                        doc.content[1].table.widths = 'auto';  
                                        doc.content[1].table.dontBreakRows = true;  
                                    }
                                }
                            ],
                            ordering: true,
                            paging: false,
                            searching: true,
                            pageLength: 50,
                            destroy: true,
                            footerCallback: function (row, data, start, end, display) {
                                const api = this.api();
                                const floatVal = (i) => typeof i === 'string' ? parseFloat(i.replace(/,/g, '')) || 0 : (typeof i === 'number' ? i : 0);

                                var columnsToSum = [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]; 

                                columnsToSum.forEach(function (colIndex) {
                                    var total = api
                                        .column(colIndex, { page: 'current' }) // Sum only visible data
                                        .data()
                                        .reduce((a, b) => floatVal(a) + floatVal(b), 0);

                                    // Update footer with total
                                    $(api.column(colIndex).footer()).html(total);
                                    // var totalInLakhs = (total / 100000).toFixed(2);
                                    // $(api.column(colIndex).footer()).html(totalInLakhs);
                                });
                            
                            }
                        });
                    } else {
                        alert("No data found.");
                    }
                },
                error: function (xhr, status, error) {
                    $("#preloder").fadeOut();
                    console.error("AJAX error:", error);
                }
            });
        });

        // production summary start - Pooja

        $(document).on('click', '.operation_clickable', function () {
            let totalQty = parseFloat($(this).text()) || 0;
            if (totalQty <= 0) return;

            const type = $(this).data('type'); // COQty, CutQty, etc.
            const costId = $(this).data('cost-id');
            const title = $(this).data('title') || `${type} Details`;
            $('.prod_summary_datails').css('display','block');
            $('.prod_summary_datails').text('Date wise Breakup in '+ title);

            
            const tableId = `#prod_summaryTable`;

            $(`${tableId} tbody`).html('<tr><td colspan="10" class="text-center">⏳ Fetching data...</td></tr>');

            $.ajax({
                url: `{{ route('gut_production_summarydetails') }}`,
                method: 'GET',
                data: { cost_id: costId, 
                        type: type 
                },
                success: function (response) {

                    if (!response || !response.data || response.data.length === 0) {
                        $(`${tableId} tbody`).html('<tr><td  class="text-center text-danger"> No records found!</td></tr>');
                        return;
                    }

                    if ($.fn.DataTable.isDataTable(tableId)) {
                        $(tableId).DataTable().destroy();
                    }
                    const headers = Object.keys(response.data[0]);

                            // Build header HTML
                            const headerHtml = `
                                <tr>
                                    ${headers.map(key => `<th class="${key === 'Edate' ? 'leftallign' : 'sideallign'}">${key}</th>`).join('')}
                                </tr>
                            `;

                            const footerHtml = `
                                <tr>
                                    ${headers.map(key => `<th class="${key === 'Edate' ? 'leftallign' : 'sideallign'}"></th>`).join('')}
                                </tr>
                            `;

                            // Build rows HTML
                            const rowsHtml = response.data.map(row => `
                                <tr>
                                    ${headers.map(key => `
                                        <td class="${key === 'Edate' ? 'leftallign' : 'sideallign'}">
                                            ${key === 'Edate' ? formatDateTime(row[key]) : (row[key] || 0)}
                                        </td>
                                    `).join('')}
                                </tr>
                            `).join('');

                            // Inject into table
                            $(`${tableId} thead`).html(headerHtml);
                            $(`${tableId} tbody`).html(rowsHtml);
                            $(`${tableId} tfoot`).html(footerHtml);


                    

                // $(`${tableId} tbody`).html(rows);

                    $(tableId).DataTable({
                        ordering: true,
                        paging: false,
                        searching: false,
                        columnDefs: [
                                
                                { type: 'dd-mm-yy', targets: [0] } // Ensuring sorting works for date columns
                            ],
                                    
                        footerCallback: function (row, data, start, end, display) {
                            let api = this.api();

                            let floatVal = i => {
                                if (typeof i === 'string') {
                                    const text = $('<div>').html(i).text();
                                    return parseFloat(text.replace(/,/g, '')) || 0;
                                }
                                return typeof i === 'number' ? i : 0;
                            };

                            api.columns().every(function () {
                                let colIdx = this.index();
                                let header = $(api.column(colIdx).header()).text().trim();

                                if (header.toLowerCase() === 'edate') return; // skip date

                                // check if column is numeric by checking a few cells
                                let isNumeric = api.column(colIdx).data().toArray().some(val => !isNaN(parseFloat(val)));

                                if (isNumeric) {
                                    let total = this.data()
                                        .reduce((a, b) => floatVal(a) + floatVal(b), 0);
                                        $(api.column(colIdx).footer()).html(Math.round(total));
                                }
                            });
                        }

                    });
                    $(tableId).show();
                },
                error: function (xhr) {
                    console.error(xhr);
                    $(`${tableId} tbody`).html('<tr><td colspan="11" class="text-danger text-center">🔥 Error fetching data!</td></tr>');
                }
            });
        });

        // production summary end - pooja

        function formatDateTime(dateString) {
            if (!dateString) return '';

            // Try parsing datetime with time (e.g. 2023-11-08 00:00:00.000)
            if (moment(dateString, 'YYYY-MM-DD HH:mm:ss.SSS', true).isValid()) {
                return moment(dateString, 'YYYY-MM-DD HH:mm:ss.SSS').format('DD-MM-YY');
            }

            // Try parsing date only (e.g. 2023-11-08)
            if (moment(dateString, 'YYYY-MM-DD', true).isValid()) {
                return moment(dateString, 'YYYY-MM-DD').format('DD-MM-YY');
            }

            // Try parsing existing DD-MM-YY
            if (moment(dateString, 'DD-MM-YY', true).isValid()) {
                return moment(dateString, 'DD-MM-YY').format('DD-MM-YY');
            }

            return ''; // Invalid or unrecognized format
        }
    </script>

</body>
</html>
