<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>FRC Planning</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <script src="https://kit.fontawesome.com/a2e0e6ad65.js" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
   
</head>

<body class="bg-[#F9FAFB]">
    @include('LifeAtGainup.Planning.GUTplanning.Gutplan_nav')

    <div class="p-6 relative">

    <div class="text-gray-500 text-sm mb-6 flex items-center gap-2">
        <a href="/gutplan" class="text-gray-500 hover:text-gray-700">
            Order Management
        </a>
        &gt;
        <span class="text-gray-700 font-medium">FRC Planning</span>
        <div class="h-4 w-px bg-gray-300"></div>
        <p class="text-gray-500 font-bold text-base"> For <span class="ccno-display font-bold text-base"></span></p>
        <div class="h-4 w-px bg-gray-300"></div>
        <p class="text-gray-500 ">View and manage your material FRCs.</p>
    </div>


        <!-- Title -->
        <!-- <h1 class="text-2xl font-semibold">FRC Planning</h1> -->
        

        <!-- Active Filters -->
        <!-- <div class="flex items-center gap-3 mb-4">
            <span class="text-gray-600 font-medium">Active Filters:</span>

            <div class="flex items-center bg-gray-200 text-gray-700 px-3 py-1 rounded-full text-sm gap-2">
                114227
                <i class="fa-solid fa-xmark text-gray-500"></i>
            </div>

            <div class="flex items-center bg-gray-200 text-gray-700 px-3 py-1 rounded-full text-sm gap-2">
                Padded Jacket / Purple
                <i class="fa-solid fa-xmark text-gray-500"></i>
            </div>
        </div> -->

        <!-- Filter Button -->
        <div class="flex justify-end mb-3">
            <button class="px-4 py-2 border rounded-md flex items-center gap-2 hover:bg-gray-50" onclick="toggleFilter()">
                <i class="fa-solid fa-filter"></i>
                Filter
                <span class="bg-gray-200 px-2 py-0.5 rounded text-xs">2</span>
            </button>
        </div>

        <!-- Table Section -->
        <div class="overflow-x-auto rounded-xl border bg-white mt-5">
            <table class="w-full border-collapse">
                <thead class="bg-[#EAF1FF]" id="frcTableHead">
                    <tr class="text-gray-700 text-sm">
                        <!-- <th class="px-4 py-3">CC no.</th>
                        <th class="px-4 py-3">Model / Color</th> -->
                        <th class="px-4 py-3">PRJ #</th>
                        <th class="px-4 py-3">FRC #</th>
                        <th class="px-4 py-3">FRC date</th>
                        <th class="px-4 py-3">FRC Week</th>
                        <th class="px-4 py-3">CK date</th>
                        <th class="px-4 py-3">CK Week</th>
                        
                        <!-- Size columns will be dynamically added here -->
                        <th class="px-4 py-3">FRC Qty</th>
                        <!-- <th class="px-4 py-3">Status</th> -->
                        <!-- <th class="px-4 py-3">Approve</th> -->
                    </tr>
                </thead>

                <!-- Dynamic Table Body -->
                <tbody class="text-sm" id="frcTableBody">
                    <!-- Data will be populated here -->
                    <tr>
                        <td colspan="22" class="text-center py-8 text-gray-500">
                            <i class="fas fa-spinner fa-spin text-2xl mb-2"></i>
                            <p>Loading FRC data...</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Filter Panel (RIGHT SIDE) -->
        <div id="filterPanel" class="hidden absolute right-0 top-28 w-80 bg-white rounded-lg shadow-xl border p-5 z-50">

            <h3 class="text-lg font-semibold">Filters</h3>
            <p class="text-gray-500 text-sm mb-4">Filter the FRC data.</p>

            <!-- CC No -->
            <div class="mb-4">
                <label class="text-sm text-gray-700 mb-1 block">CC No.</label>
                <select class="w-full border-gray-300 rounded-md px-3 py-2 bg-gray-50">
                    <option>1 selected</option>
                </select>
            </div>

            <!-- Model / Color -->
            <div class="mb-4">
                <label class="text-sm text-gray-700 mb-1 block">Model / Color</label>
                <select class="w-full border-gray-300 rounded-md px-3 py-2 bg-gray-50">
                    <option>1 selected</option>
                </select>
            </div>

            <!-- FRC Week -->
            <div class="mb-4">
                <label class="text-sm text-gray-700 mb-1 block">FRC Week</label>
                <div class="grid grid-cols-2 gap-3">
                    <select class="border-gray-300 rounded-md px-3 py-2 bg-gray-50">
                        <option>Start</option>
                    </select>
                    <select class="border-gray-300 rounded-md px-3 py-2 bg-gray-50">
                        <option>End</option>
                    </select>
                </div>
            </div>

            <!-- CK Week -->
            <div class="mb-5">
                <label class="text-sm text-gray-700 mb-1 block">CK Week</label>
                <div class="grid grid-cols-2 gap-3">
                    <select class="border-gray-300 rounded-md px-3 py-2 bg-gray-50">
                        <option>Start</option>
                    </select>
                    <select class="border-gray-300 rounded-md px-3 py-2 bg-gray-50">
                        <option>End</option>
                    </select>
                </div>
            </div>

            <!-- Clear filters -->
            <button class="flex items-center gap-2 text-red-500 text-sm hover:text-red-600">
                <i class="fa-solid fa-xmark text-red-500"></i>
                Clear all filters
            </button>

        </div>

    </div>

<!-- FRC status modal - Tailwind version -->
<div id="tableModalfcrstatus" aria-labelledby="tableModalLabelFRC" aria-hidden="true"
     class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-50">
    <div class="bg-white rounded-xl shadow-2xl w-full max-w-6xl max-h-[85vh] flex flex-col border">
        <!-- Header -->
        <div class="flex items-center justify-between px-5 py-3 border-b bg-gray-50">
            <h5 class="text-base font-semibold" id="tableModalLabelFRC">FRC Status</h5>
            <button type="button" id="tableModalfcrstatus_close"
                    class="inline-flex items-center justify-center w-8 h-8 rounded-full hover:bg-gray-100 text-gray-500">
                <span class="sr-only">Close</span>
                <i class="fa-solid fa-xmark"></i>
            </button>
        </div>

        <!-- Body -->
        <div class="px-5 py-4 overflow-y-auto">
            <div class="space-y-4">
                <!-- Filters row -->
                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-5 gap-3">
                    <div>
                        <select id="frcmodelDropdown"
                                class="w-full border border-gray-300 rounded-md px-2.5 py-1.5 text-sm bg-white focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Model code</option>
                        </select>
                    </div>

                    <div>
                        <select id="frcitemDropdown"
                                class="w-full border border-gray-300 rounded-md px-2.5 py-1.5 text-sm bg-white focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Item code</option>
                        </select>
                    </div>

                    <div>
                        <select id="frctrimsDropdown"
                                class="w-full border border-gray-300 rounded-md px-2.5 py-1.5 text-sm bg-white focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Trims</option>
                        </select>
                    </div>
                    
                    <div>
                        <select id="frcsizeDropdown"
                                class="w-full border border-gray-300 rounded-md px-2.5 py-1.5 text-sm bg-white focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Color &amp; Size</option>
                        </select>
                    </div>

                    <div>
                        <select id="frcstatusDropdown"
                                class="w-full border border-gray-300 rounded-md px-2.5 py-1.5 text-sm bg-white focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Status</option>
                        </select>
                    </div>
                </div>

                <!-- Table -->
                <div class="border rounded-lg overflow-hidden ocrstatuscon">
                    <div class="overflow-auto max-h-[60vh]">
                        <table id="frc_based_ocn_modal" class="min-w-full text-xs border-collapse table_fabric">
                            <thead class="bg-gray-100 sticky top-0 z-10">
                                <tr class="text-gray-700 text-[11px] uppercase tracking-wide">
                                    <th class="px-2 py-2 border text-left">Sl No</th>
                                    <th class="px-2 py-2 border text-left">MODEL Code</th>
                                    <th class="px-2 py-2 border text-left">Item Code</th>
                                    <th class="px-2 py-2 border text-left">Trims</th>
                                    <th class="px-2 py-2 border text-left">Color And Size</th>
                                    <th class="px-2 py-2 border text-right">Req Qty</th>
                                    <th class="px-2 py-2 border text-right">PO Qty</th>
                                    <th class="px-2 py-2 border text-right">PO Pend</th>
                                    <th class="px-2 py-2 border text-right">Grn Qty</th>
                                    <th class="px-2 py-2 border text-right">Rej Qty</th>
                                    <th class="px-2 py-2 border text-right">Grn Pend</th>
                                    <th class="px-2 py-2 border text-left">GrnDt</th>
                                    <th class="px-2 py-2 border text-left">Lead Days</th>
                                    <th class="px-2 py-2 border text-left">Item Closure</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Data will be injected here dynamically -->
                            </tbody>
                            <tfoot class="bg-gray-50 sticky bottom-0 z-10 text-xs">
                                <tr>
                                    <th colspan="5" class="px-2 py-2 border text-right font-semibold">Total :</th>
                                    <th id="totalReqQty" class="px-2 py-2 border text-right font-semibold"></th>
                                    <th id="totalPOQty" class="px-2 py-2 border text-right font-semibold"></th>
                                    <th id="totalPOpend" class="px-2 py-2 border text-right font-semibold"></th>
                                    <th id="totalGRNQty" class="px-2 py-2 border text-right font-semibold"></th>
                                    <th id="totalRejQty" class="px-2 py-2 border text-right font-semibold"></th> 
                                    <th id="totalGRNpend" class="px-2 py-2 border text-right font-semibold"></th>
                                    <th class="px-2 py-2 border"></th>
                                    <th class="px-2 py-2 border"></th>
                                    <th class="px-2 py-2 border"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<!-- venkatesh__FRC_po_ -->
<div id="FRC_po_details" aria-labelledby="FRC_po_detailsLabel" aria-hidden="true"
     class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-50">
    <div class="bg-white rounded-xl shadow-2xl w-full max-w-3xl max-h-[80vh] flex flex-col border text-xs">
        <!-- Header -->
        <div class="flex items-center justify-between px-4 py-2 border-b bg-gray-50">
            <h5 class="text-sm font-semibold w-full" id="FRC_po_detailsLabel">Po_details</h5>
            <button type="button" id="FRC_po_details_close"
                    class="inline-flex items-center justify-center w-8 h-8 rounded-full hover:bg-gray-100 text-gray-500">
                <span class="sr-only">Close</span>
                <i class="fa-solid fa-xmark"></i>
            </button>
        </div>

        <!-- Body -->
        <div class="px-4 py-3 overflow-y-auto">
            <div class="border rounded-lg overflow-hidden">
                <div class="table-responsive max-h-[60vh]" style="font-size: 12px;">
                    <table class="table table-bordered table-sm text-nowrap" id="po_frc_DetailsTable">
                        <thead class="table-light tab" style="position: sticky; top: 0;">
                            <tr>
                                <th>PONo</th>
                                <th>PoDate</th>
                                <th>Supplier</th>
                                <th>UOM</th>
                                <th>PO Qty</th>
                                <th>GRN Qty</th>
                                <th>Rej Qty</th>
                                <th>GRN Pend Qty</th>
                                <th>Approval</th>
                            </tr>
                        </thead>
                        <tbody id="po_frc_DetailsBody">
                            <!-- Dynamic content goes here -->
                            <tr>
                                <td colspan="9" class="text-center">🚧 Data Coming Soon... Stay Tuned!</td>
                            </tr>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="4" class="sideallign">Total :</th>
                                <th id="totalPOQty3" class="sideallign"></th>
                                <th id="totalGRNQty3" class="sideallign"></th>
                                <th id="totalRejQty3" class="sideallign"></th>
                                <th id="totalGRNPendingQty3" class="sideallign"></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- FRC GRN_QTY modal  start - Pooja -->
<div id="frc_grnDetailsModal" aria-labelledby="frc_grnDetailsModalLabel" aria-hidden="true"
     class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-50">
    <div class="bg-white rounded-xl shadow-2xl w-full max-w-5xl max-h-[80vh] flex flex-col border text-xs">
        <!-- Header -->
        <div class="flex items-center justify-between px-4 py-2 border-b bg-gray-50">
            <h5 class="text-sm font-semibold" id="frc_grnDetailsModalLabel">FRC - GRN Details</h5>
            <button type="button" id="frc_grnDetailsModal_close"
                    class="inline-flex items-center justify-center w-8 h-8 rounded-full hover:bg-gray-100 text-gray-500">
                <span class="sr-only">Close</span>
                <i class="fa-solid fa-xmark"></i>
            </button>
        </div>

        <!-- Body -->
        <div class="px-4 py-3 overflow-y-auto">
            <div class="border rounded-lg overflow-hidden">
                <div class="table-responsive max-h-[60vh]" style="font-size: 12px;">
                    <table class="table table-bordered" id="frc_grnDetailsTable">
                        <thead style="position: sticky; top: 0; z-index: 10;">
                            <tr>
                                <th>GRN No</th>
                                <th>GRN_Date</th>
                                <th>Supplier Name</th>
                                <th>Invoice No</th>
                                <th>Invoice_Date</th>
                                <th>GP No</th>
                                <th>GP_Date</th>
                                <th>GRN Qty</th>
                                <th>Rej Qty</th>
                                <th>UOM</th>
                                <th>Sec Qty</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Data will be injected here dynamically -->
                        </tbody>
                        <tfoot style="position: sticky; bottom: 0; z-index: 10;">
                            <tr>
                                <th colspan="3" class="sideallign">Total:</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th id="total_frc_grn_GRNQty" class="sideallign"></th>
                                <th id="total_frc_grn_RejQty" class="sideallign"></th> 
                                <th></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- FRC GRN_QTY modal  end - Pooja -->

<!-- FRC Follow popup modal - start -->
<div id="frcfollow" aria-labelledby="frcModalLabel" aria-hidden="true"
     class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-50">
    <div class="bg-white rounded-md shadow-lg w-full max-w-sm flex flex-col border text-xs">
        <div class="flex items-center justify-between px-4 py-2 border-b bg-gray-50">
            <h6 class="text-sm font-semibold" id="frcModalLabel"><span id='frcfollow-up-title'></span></h6>
            <button type="button" id="frcfollow_close"
                    class="inline-flex items-center justify-center w-8 h-8 rounded-full hover:bg-gray-100 text-gray-500">
                <span class="sr-only">Close</span>
                <i class="fa-solid fa-xmark"></i>
            </button>
        </div>
        <div class="px-4 py-3 overflow-y-auto">
            <div class="table-container">


                <!-- Form inside modal -->
                <form id=frcfollowup>
                    @csrf
                    <!-- Description Textarea -->
                    <div class="mb-3">
                        <!-- <label for="description" class="form-label" id="frc_note_title" ></label> -->
                        <input type="hidden" name="emp_id" id="frcemp_id" value="{{$user = Session('empl_id')}}">
                        <input type="hidden" name="portal_id" id="frcportal_id" value="2">
                        <input type="hidden" name="follow_ocn" id="frcfollow_ocn" value="">
                        <input type="hidden" name="portal_id" id="frcitem_id" value="">
                        <textarea class="form-control w-full border rounded px-2 py-1 text-xs" id="frcdescription" name='description' rows="4" placeholder="Enter your remarks here"></textarea>
                        <div class="table-responsive mt-2">
                            <table class="min-w-full border border-gray-300 text-xs">
                                    <thead class="bg-gray-100">
                                        <tr>
                                            <th class="w-2/5 px-2 py-1 border-b border-gray-300 text-left font-semibold">Employee</th>
                                            <th class="px-2 py-1 border-b border-gray-300 text-left font-semibold">Comment</th>
                                        </tr>
                                    </thead>
                                <tbody id="frc_comments_table">
                                    <!-- Rows will be added dynamically -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <button type="button" id="frcsubmitBtn" class="mt-1 inline-flex items-center px-3 py-1.5 bg-blue-600 text-white text-xs font-medium rounded shadow-sm hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-1">Submit</button>
                </form>


            </div>
        </div>
    </div>
</div>
<!-- FRC Follow popup modal - end -->

    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.js"></script>
    <script>
        function toggleFilter() {
            const panel = document.getElementById('filterPanel');
            panel.classList.toggle('hidden');
        }

        // Close filter panel when clicking outside
        document.addEventListener('click', function(event) {
            const filterButton = event.target.closest('button[onclick="toggleFilter()"]');
            const filterPanel = document.getElementById('filterPanel');
            
            if (!filterButton && !filterPanel.contains(event.target)) {
                filterPanel.classList.add('hidden');
            }
        });

        // Load FRC data when page loads
        $(document).ready(function() {
            // Display CC No and Color in the header
            const ccno = localStorage.getItem('selectedCcNo');
            const color = localStorage.getItem('selectedColor');
            const modal = localStorage.getItem('selectedmodal');
            const season = localStorage.getItem('selectedseason');

            if (ccno && color && modal && season) {
                $('.ccno-display').text(color +' | '+ modal +' | ' + season);
            } else if (ccno) {
                $('.ccno-display').text(ccno);
            }
            
            loadFrcData(); // Call the function to load FRC data();
        });

        // Function to load FRC data via AJAX
        function loadFrcData() {
            const costno = localStorage.getItem('selectedCostNo');
            const portalType = localStorage.getItem('portalType') || 'gut_new';
            
            if (!costno) {
                $('#frcTableBody').html(`
                    <tr>
                        <td colspan="22" class="text-center py-20 text-gray-500">
                            No cost number selected. Please go back and select an order.
                        </td>
                    </tr>
                `);
                return;
            }

            $.ajax({
                url: '/frc_details',
                method: 'GET',
                data: {
                    costno: costno,
                    portaltype: portalType
                },
                success: function(response) {
                    if (response.success && response.data && response.data.length > 0) {
                        populateFrcTable(response.data);
                    } else {
                        $('#frcTableBody').html(`
                            <tr>
                                <td colspan="22" class="text-center py-20 text-gray-500">
                                    No FRC data available for the selected cost.
                                </td>
                            </tr>
                        `);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error loading FRC data:', error);
                    $('#frcTableBody').html(`
                        <tr>
                            <td colspan="22" class="text-center py-20 text-red-500">
                                Error loading FRC data. Please try again.
                            </td>
                        </tr>
                    `);
                }
            });
        }

        // Function to populate FRC table with data
        function populateFrcTable(data) {
            // Extract all unique sizes from the data
            const allSizes = new Set();
            data.forEach(function(row) {
                Object.keys(row).forEach(function(key) {
                    // Skip standard fields that are not sizes
                    const standardFields = ['Frc_No', 'Total_Buyer_Qty', 'PO_Date', 'Ck_Date', 'Po_Week', 'Ck_Week', 'Prj_No', 'Frc_Cov_Week', 'Approval', 'Approval1', 'Cost_ID'];
                    
                    if (!standardFields.includes(key) && row[key] !== null && row[key] !== '') {
                        allSizes.add(key);
                    }
                });
            });
            
            // Convert to array and sort sizes
            const sizeArray = Array.from(allSizes).sort(function(a, b) {
                const aIsNumeric = /^\d/.test(a);
                const bIsNumeric = /^\d/.test(b);
                
                if (aIsNumeric && bIsNumeric) {
                    return parseInt(a) - parseInt(b);
                } else if (aIsNumeric) {
                    return -1;
                } else if (bIsNumeric) {
                    return 1;
                } else {
                    return a.localeCompare(b);
                }
            });
            
            // Update table header with dynamic size columns
            updateTableHeader(sizeArray);
            
            // Generate table body
            let tableHtml = '';
            let totalFrcQty = 0;
            
            data.forEach(function(row) {
                // Calculate coverage weeks (if needed later)
                const poDate = new Date(row.PO_Date);
                const ckDate = new Date(row.Ck_Date);
                const coverageWeeks = Math.ceil((ckDate - poDate) / (7 * 24 * 60 * 60 * 1000));
                
                // Determine status based on Approval fields
                let status = 'Pending';
                let statusClass = 'text-yellow-600';
                if (row.Approval === 'T' && row.Approval1 === 'T') {
                    status = 'Approved';
                    statusClass = 'text-green-600';
                } else if (row.Approval === 'F' || row.Approval1 === 'F') {
                    status = 'Unapproved';
                    statusClass = 'text-red-600';
                }
                
                // Generate size column HTML dynamically
                let sizeColumnsHtml = '';
                sizeArray.forEach(function(size) {
                    const quantity = row[size] || 0;
                    sizeColumnsHtml += `<td class="px-4 py-3 text-center">${quantity && quantity > 0 ? quantity : '-'}</td>`;
                });

                totalFrcQty += Number(row.Total_Buyer_Qty || 0);
                
                tableHtml += `
                    <tr class="border-b hover:bg-gray-50">
                        <td class="px-4 py-3 text-center">${row.Prj_No || '-'}</td>
                        <td class="px-4 py-3 text-center  frc_tadetails" data-order-id = ${row.Order_Id} data-cost-id="${row.Cost_ID}" style="cursor: pointer; color: blue;" data-bs-toggle="modal" data-bs-target="#tableModalfcrstatus">${row.Frc_No || '-'}</td>
                        <td class="px-4 py-3 text-center">${formatDate(row.PO_Date) || '-'}</td>
                        <td class="px-4 py-3 text-center">${row.Po_Week || '-'}</td>
                        <td class="px-4 py-3 text-center">${formatDate(row.Ck_Date) || '-'}</td>
                        <td class="px-4 py-3 text-center">${row.Ck_Week || '-'}</td>
                        ${sizeColumnsHtml}
                        <td class="px-4 py-3 font-semibold text-center">${row.Total_Buyer_Qty || '0'}</td>
                        
                    </tr>
                `;
            });

            // Footer total row
            tableHtml += `
                <tr class="bg-gray-100 font-semibold">
                    <td class="px-4 py-3 text-right" colspan="${6 + sizeArray.length}">Total</td>
                    <td class="px-4 py-3 text-center">${totalFrcQty}</td>
                    
                </tr>
            `;

            $('#frcTableBody').html(tableHtml);
        }

        // Function to update table header with dynamic size columns
        function updateTableHeader(sizes) {
            let headerHtml = `
                <th class="px-4 py-3">PRJ #</th>
                <th class="px-4 py-3">FRC #</th>
                <th class="px-4 py-3">FRC date</th>
                <th class="px-4 py-3">FRC Week</th>
                <th class="px-4 py-3">CK date</th>
                <th class="px-4 py-3">CK Week</th>
                
            `;
            
            // Add dynamic size columns
            sizes.forEach(function(size) {
                headerHtml += `<th class="px-4 py-3">${size}</th>`;
            });
            
            headerHtml += `
                <th class="px-4 py-3">FRC Qty</th>
               
            `;
            
            $('#frcTableHead tr').html(headerHtml);
        }

        // Function to format date to dd-mm-yy
        function formatDate(dateString) {
            if (!dateString) return '';
            
            const date = new Date(dateString);
            if (isNaN(date.getTime())) return dateString; // Return original if invalid
            
            const day = String(date.getDate()).padStart(2, '0');
            const month = String(date.getMonth() + 1).padStart(2, '0');
            const year = String(date.getFullYear()).slice(-2);
            
            return `${day}-${month}-${year}`;
        }

        let frctable;
        function populateTableFRCOCN(data) {
            const $table = $('#frc_based_ocn_modal');
            const $tbody = $table.find('tbody');

            // Destroy if already initialized
            if ($.fn.DataTable.isDataTable($table)) {
                $table.DataTable().clear().destroy();
            }

            // Clear old rows
            $tbody.empty();

            // Show Tailwind modal
            openFrcModal();

            if (!Array.isArray(data) || data.length === 0) {
                $tbody.html('<tr><td colspan="13" class="text-danger text-center">No data found!</td></tr>');
                return;
            }else{
                $('#tableModalLabelFRC').text(
                    'Trims Req Status For the Proj No :' + data[0].Order_No + 
                    ' CKDT :' + formatDate(data[0].Ck_Date)
                );

            // Build table rows
            let rows = data.map((row, index) => {
            const rowClass = row.CK_COlor === 'Red' ? 'table-danger' : '';
            let poQty = parseInt(row.PO_Qty) || 0;
            let poQtyElement = '';
            if (poQty > 0) {
                        poQtyElement = `
                            <span 
                                class=" frc-po-click" 
                                style="cursor: pointer; color: blue; font-weight: bold;" 
                                data-bs-toggle="modal" 
                                data-bs-target="#FRC_po_details"
                                data-itemcode="${row.Item_Code}" 
                                data-orderid="${row.Order_ID}" 
                                data-modelcode="${row.Model_Code}">
                                ${poQty}
                            </span>`;
                    } else {
                        poQtyElement = `
                            <span 
                                class="text-muted" 
                                style="cursor: not-allowed;" 
                                title="No data">
                                0
                            </span>`;
                    }
            return `
                <tr class="${rowClass}">
                    <td class="leftallign">${index + 1}</td>
                    <td class="leftallign">${row.Model_Code || ''}</td>
                    <td class="leftallign">${row.Item_Code || ''}</td>
                    <td class="leftallign">${row.Trims || ''}</td>
                    <td class="leftallign">${row.Color && row.Size ? `${row.Color}&${row.Size}` : (row.Color || row.Size || '')}</td>
                    <td class="sideallign">${row.Req_Qty || 0}</td>
                    <td class="sideallign">${poQtyElement || 0}</td>
                    <td class="sideallign">${row.PO_Pending || 0}</td>
                    <td class="sideallign"><span class=" frc-grn-clickable" data-order-id="${row.Order_ID}" data-model_code="${row.Model_Code}" data-item_code="${row.Item_Code}" style="color: ${row.CK_COlor || 'black'}; font-weight: bold; cursor: pointer;" title="${parseFloat(row.GRN_Qty) > 0 ? `PO Date: ${formatDate(row.PODate)}` : 'No data'}">${parseFloat(row.GRN_Qty) || 0}</span></td>
                    <td class="sideallign">${row.Rej_Qty || 0}</td>
                    <td class="sideallign">${row.GRN_Pending || 0}</td>
                    <td class="leftallign">${formatDateTime(row.GrnDate) || ''}</td>
                    <td class="leftallign">${row.Lead_Days || ''}</td>
                    <td class="leftallign">${row.Item_Closure || ''} <span class="frc-follow-popup" style="cursor: pointer; color: blue; margin-left:5px"
                        data-bs-toggle="modal" data-model-code="${row.Model_Code}" data-item-code="${row.Item_Code}" data-fabric="${row.Trims}"  data-order-no="${row.Order_No}" data-bs-target="#frcfollow" >
                        <i class="fa-regular fa-comment"></i></span>
                    </td>
                </tr>
            `;
            }).join('');


            $tbody.html(rows);

            // Initialize DataTable
            frctable = $table.DataTable({
                ordering: true,
                paging: false,
                pageLength: 25,
                searching: true,
                dom: 'Bfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: 'Trims Req status Details',
                        exportOptions: { 
                            columns: ':visible',
                            format: {
                                body: function (data, row, column) {
                                    return [11].includes(column) && /\d{2}-\d{2}-\d{2}/.test(data)
                                        ? moment(data, 'DD-MM-YY').format('YYYY-MM-DD') // Convert date format
                                        : data.replace(/<[^>]+>/g, ''); // Remove HTML tags if any
                                }
                            }
                            },
                        footer: true
                    },
                    {
                        extend: 'pdfHtml5',
                        title: 'Trims Req status Details',
                        orientation: 'landscape',
                        pageSize: 'A3',
                        exportOptions: { columns: ':visible' },
                        customize: function (doc) {
                            doc.defaultStyle.fontSize = 6;
                            doc.content[1].table.widths = Array(doc.content[1].table.body[0].length + 1).join('*').split('');
                        }
                    }
                ],
                footerCallback: function (row, data, start, end, display) {
                    let api = this.api();
                    let floatVal = (html) => {
                        let tempDiv = document.createElement('div');
                        tempDiv.innerHTML = html;
                        let span = tempDiv.querySelector('span');
                        let text = span ? span.textContent.trim() : tempDiv.textContent.trim(); // Fallback if span is missing
                        return parseFloat(text.replace(/,/g, '')) || 0;
                    };
                    let columnsToSum = [5, 6, 7, 8, 9, 10];

                    columnsToSum.forEach(function (colIndex) {
                        var total = api
                            .column(colIndex, { page: 'current' }) // Sum only visible data
                            .data()
                            .reduce((a, b) => floatVal(a) + floatVal(b), 0);

                        // Update footer with total
                        $(api.column(colIndex).footer()).html(total.toFixed(2));
                        // var totalInLakhs = (total) .toFixed(2);
                        // $(api.column(colIndex).footer()).html(totalInLakhs);
                    });
                }
            });

            populatefrcDropdown(1, 'frcmodelDropdown');      
            populatefrcDropdown(2, 'frcitemDropdown');
            populatefrcDropdown(3, 'frctrimsDropdown');     
            populatefrcDropdown(4, 'frcsizeDropdown');
            populatefrcDropdown(13, 'frcstatusDropdown');
        

            $('#frcmodelDropdown').on('change', function () {
                frctable.column(1).search(this.value).draw();
            });
            $('#frcitemDropdown').on('change', function () {
                frctable.column(2).search(this.value).draw();
            });
            $('#frctrimsDropdown').on('change', function () {
                frctable.column(3).search(this.value).draw();
            });
            $('#frcsizeDropdown').on('change', function () {
                frctable.column(4).search(this.value).draw();
            });
            $('#frcstatusDropdown').on('change', function () {
                frctable.column(13).search(this.value).draw();
            });
            // Remove blur effect when the modal is hidden
            // $('#tableModalfcrstatus').on('hidden.bs.modal', function () {
            //     // Remove the blur effect on all modals
            //     $('.modal').css('filter', 'none');
            // });
            }
            
        }
        // Populate FRC dropdowns
        function populatefrcDropdown(columnIndex, dropdownId) {
            let column = frctable.column(columnIndex);
            let uniqueVals = column.data().toArray().filter((v, i, a) => v && a.indexOf(v) === i).sort();
            let $dropdown = $(`#${dropdownId}`);
            let defaultOption = $dropdown.data('default') || $dropdown.find('option:first').text();
            $dropdown.empty().append(`<option value="">${defaultOption}</option>`);
            uniqueVals.forEach(v => $dropdown.append(`<option value="${v}">${v}</option>`));
        }
        // Reset filters is handled inside closeFrcModal (Tailwind modal)

        // Helper functions to control FRC Tailwind modal
        function openFrcModal() {
            const modal = document.getElementById('tableModalfcrstatus');
            if (!modal) return;
            modal.classList.remove('hidden');
            modal.classList.add('flex');
            document.body.classList.add('overflow-hidden');
        }

        function closeFrcModal() {
            const modal = document.getElementById('tableModalfcrstatus');
            if (!modal) return;
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.classList.remove('overflow-hidden');

            // Reset dropdowns
            $('#frcmodelDropdown, #frcitemDropdown, #frctrimsDropdown, #frcsizeDropdown, #frcstatusDropdown').val('');

            // Clear all filters on the DataTable if initialized
            if ($.fn.DataTable && $.fn.DataTable.isDataTable('#frc_based_ocn_modal')) {
                let table = $('#frc_based_ocn_modal').DataTable();
                table.columns().search('').draw();
            }
        }

        // Close when clicking X button or backdrop
        document.addEventListener('click', function (e) {
            const modal = document.getElementById('tableModalfcrstatus');
            if (!modal) return;

            const isCloseBtn = e.target.id === 'tableModalfcrstatus_close' || e.target.closest('#tableModalfcrstatus_close');
            const clickedOutside = e.target === modal;

            if (isCloseBtn || clickedOutside) {
                closeFrcModal();
            }
        });

        $(document).on('click', '.frc_tadetails', function () {
            // Derive an order identifier for the details API
            const clickedCell = $(this);
            const orderId = clickedCell.data('order-id') || (clickedCell.text() || '').trim();

            if (!orderId) {
                console.warn('No order ID found for FRC details');
                return;
            }

            // Optionally, show the modal immediately with a loading row
            openFrcModal();
            const $tbody = $('#frc_based_ocn_modal tbody');
            $tbody.html('<tr><td colspan="14" class="text-center">⏳ Loading FRC details...</td></tr>');

            const data = {
                orderID: orderId
            };

            $.ajax({
                url: "{{ route('frc_order_details_ocn') }}",
                type: "GET",
                data,
                success: res => populateTableFRCOCN(res.data || []),
                error: function (xhr) {
                    console.error(xhr);
                    $tbody.html('<tr><td colspan="14" class="text-danger text-center">Error fetching data!</td></tr>');
                }
            });
        });

        function formatDateTime(dateString) {
            if (!dateString) return '';

            // Try parsing datetime with time (e.g. 2023-11-08 00:00:00.000)
            if (moment(dateString, 'YYYY-MM-DD HH:mm:ss.SSS', true).isValid()) {
                return moment(dateString, 'YYYY-MM-DD HH:mm:ss.SSS').format('DD-MM-YY');
            }

            // Try parsing date only (e.g. 2023-11-08)
            if (moment(dateString, 'YYYY-MM-DD', true).isValid()) {
                return moment(dateString, 'YYYY-MM-DD').format('DD-MM-YY');
            }

            // Try parsing existing DD-MM-YY
            if (moment(dateString, 'DD-MM-YY', true).isValid()) {
                return moment(dateString, 'DD-MM-YY').format('DD-MM-YY');
            }

            return ''; // Invalid or unrecognized format
        }

        $('#frcsubmitBtn').click(function() {
            
            let orderno = $('#frcfollow_ocn').val();
            let formattedOrderNo = orderno.match(/\d+$/)[0];
            let itemid = $('#frcitem_id').val();
            let type = $('#frcportal_id').val();
            let emp_id = $('#frcemp_id').val();
            let description = $('#frcdescription').val();
            let today = new Date();
            let formattedDate = today.getFullYear() + '-' +
            String(today.getMonth() + 1).padStart(2, '0') + '-' +
            String(today.getDate()).padStart(2, '0');
            if (description == '') {
                $('#frcdescription').focus(); 
                toastr.error('Remark is empty', 'Error'); 
                return false; 
            }

            $.ajax({
                url: '{{ route("metrial_commands") }}', 
                method: 'POST',
                data: {
                    orderno: formattedOrderNo,
                    itemid: itemid,
                    type: type,
                    command: description,
                    created_by: emp_id,
                    command_date: formattedDate
                },
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
                },
                dataType: 'json',
                success: function(response) {
                    toastr.success('Your Feedback was successful!', response);

                    closeFrcFollowModal();
                    $('#frcfollowup')[0].reset();
                },
                error: function(xhr, status, error) {
                    alert('Error: ' + error);
                }
            });
        });

        $(document).on('click', '.frc-follow-popup', function() {

            let ocn = $(this).data('order-no');
            let formattedOrderNo = ocn.match(/\d+$/)[0];
            let fabric = $(this).data('fabric');
            let model_code = $(this).data('model-code');
            let item_code = $(this).data('item-code');

            $('#frcfollow_ocn').val(ocn);
            $('#frcitem_id').val(item_code);
            $('#frcfollow').data('order-no', ocn)
            $('#frcfollow-up-title').text(ocn+' | '+fabric);
            $('#frcfollowup')[0].reset();

            $.ajax({
                url: "{{ route('metrialfollowdetails') }}",
                method: 'GET',
                data: {
                    orderno: formattedOrderNo,
                    type: $('#frcportal_id').val() || 2,
                    emp_id: $('#frcemp_id').val(),
                    itemid: item_code

                },
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
                },
                dataType: 'json',
                beforeSend: function() {
                    $("#preloder").fadeIn();
                },
                success: function(response) {
                    let tableBody = $('#frc_comments_table');
                    tableBody.empty(); // Clear previous rows

                    if (Array.isArray(response.data) && response.data.length > 0) {

                        // Build table rows
                        response.data.forEach(comment => {
                            let row = `
                                <tr>
                                    <td>${comment.emp_name}</td>
                                    <td>${comment.comments}</td>
                                </tr>
                            `;
                            tableBody.append(row);
                        });

                        $('#frcdescription').val(response.data[0].comments || '');

                    } else {
                        tableBody.append(`<tr><td colspan="2" class="text-center">No comments found</td></tr>`);
                        $('#frcdescription').val('');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching data:', error);
                },
                complete: function() {
                    $("#preloder").fadeOut();
                    isAjaxFRCInProgress = false;
                }
            });

            openFrcFollowModal();
        });

        // FRC PO Modal start - Venkatesh
        $(document).on('click', '.frc-po-click', function () {
            let itemCode = $(this).data('itemcode');
            let orderId = $(this).data('orderid');
            let modelCode = $(this).data('modelcode');

            // Show loading in modal body and open Tailwind PO modal
            $('#po_frc_DetailsBody').html('<tr><td colspan="17" class="text-center">⏳ Loading...</td></tr>');
            openFrcPoModal();
            
            $.ajax({
                url: 'gut-frc-po-details',
                method: 'GET',
                data: {
                    itemcode: itemCode,
                    orderId: orderId,
                    modcode: modelCode
                },

                    // $oderid = $request->input('orderId');
                    // $modelcode = $request->input('modcode');
                    // $itemcode = $request->input('itemcode');



                success: function(response) {
                    if ($.fn.DataTable.isDataTable('#po_frc_DetailsTable')) {
                        $('#po_frc_DetailsTable').DataTable().destroy();
                    }
                    
                    if (!response || !response.data || response.data.length === 0) {
                        $('#po_frc_DetailsBody').html('<tr><td colspan="17" class="text-center"> No PO records found!</td></tr>');
                        return;
                    }

                $('#FRC_po_detailsLabel').text('Po_FRC_details - '+ response.data[0].Item + ' | ' + response.data[0].Color + ' | ' + response.data[0].Size + ' | ' + response.data[0].CCNo + ' | ' + response.data[0].Season);

                    let rows = '';
                    response.data.forEach(item => {
                        
                        rows += `
                            <tr>
                                <td class="leftallign">${item.PONo || ''}</td>
                                <td class="leftallign">${formatDateTime(item.PoDate) || ''}</td>
                                <td class="leftallign">${item.Supplier || ''}</td>
                                <td class="leftallign">${item.UOM || ''}</td>
                                <td class="sideallign">${item.Po_Qty || ''}</td>
                                <td class="sideallign">${item.Grn_Qty || ''}</td>
                                <td class="sideallign">${item.Rej_Qty || ''}</td>
                                <td class="sideallign">${item.Grn_Pend_Qty || ''}</td>
                                <td class="leftallign">${item.Approval_Flag_PO || ''}</td>
                            </tr>`;
                    });

                    $('#po_frc_DetailsBody').html(rows);

                    $('#po_frc_DetailsTable').DataTable({
                        paging: false,
                        searching: true,
                        ordering: true,
                        columnDefs: [
                                { type: 'dd-mm-yy', targets: [1] } // Ensuring sorting works for date columns
                        ],
                        dom: 'Bfrtip',  
                        buttons: [
                            {
                                extend: 'excelHtml5',
                                title: 'FRC PO DETAILS',
                                exportOptions: {
                                    columns: ':visible',
                                    format: {
                                            body: function (data, row, column) {
                                                return [1].includes(column) && /\d{2}-\d{2}-\d{2}/.test(data)
                                                    ? moment(data, 'DD-MM-YY').format('YYYY-MM-DD') // Convert date format
                                                    : data.replace(/<[^>]+>/g, ''); // Remove HTML tags if any
                                            }
                                        }
                                },
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                text: 'PDF',
                                title: 'FRC PO DETAILS',
                                orientation: 'landscape',
                                pageSize: 'A3',
                                exportOptions: {
                                    columns: ':visible'
                                },
                                customize: function(doc) {
                                    doc.defaultStyle.fontSize = 7;
                                    doc.content[1].table.widths = 'auto';  
                                    doc.content[1].table.dontBreakRows = true;  
                                }
                            }
                        ],
                        footerCallback: function (row, data, start, end, display) {
                            let api = this.api();
                            let floatVal = (i) => typeof i === 'string' ? parseFloat(i.replace(/,/g, '')) || 0 : (typeof i === 'number' ? i : 0);
                            var columnsToSum = [4, 5, 6, 7]; 

                            columnsToSum.forEach(function (colIndex) {
                                var total = api
                                    .column(colIndex, { page: 'current' }) // Sum only visible data
                                    .data()
                                    .reduce((a, b) => floatVal(a) + floatVal(b), 0);

                                // Update footer with total
                                $(api.column(colIndex).footer()).html(total);
                                // var totalInLakhs = (total / 100000) .toFixed(2);
                                // $(api.column(colIndex).footer()).html(totalInLakhs);
                            });
                        }
                        
                    });

                },
                error: function(xhr) {
                    console.error(xhr);
                    $('#po_frc_DetailsBody').html('<tr><td colspan="17" class="text-danger text-center">🔥 Error loading data!</td></tr>');
                }
            });
        });
        
        // FRC GRN_QTY  start - Pooja
        $(document).on('click', '.frc-grn-clickable', function () {
            let grnQty = parseFloat($(this).text()) || 0;
            if (grnQty <= 0) return; //ignore the click

            const orderId = $(this).data('order-id');
            const modelCode = $(this).data('model_code');
            const itemCode = $(this).data('item_code');

            $.ajax({
                url: '/gut_frc_grn_details', 
                method: 'GET',
                data: {
                    order_id: orderId,
                    model_code: modelCode,
                    item_code: itemCode
                },
                beforeSend: function () {
                    $('#frc_grnDetailsTable tbody').html('<tr><td colspan="24">Loading...</td></tr>');
                },
                success: function (response) {
                    // Destroy existing DataTable instance if exists
                    if ($.fn.DataTable.isDataTable('#frc_grnDetailsTable')) {
                            $('#frc_grnDetailsTable').DataTable().destroy();
                        }

                    const tbody = $('#frc_grnDetailsTable tbody');
                    tbody.empty();

                    if (response.data && response.data.length > 0) {
                        let titleParts = [`FRC GRN Details - ${response.data[0].ORder_ID}`];
                        if (response.data[0].ITem) titleParts.push(response.data[0].ITem);
                        if (response.data[0].Color) titleParts.push(response.data[0].Color);
                        if (response.data[0].Size) titleParts.push(response.data[0].Size);

                        $('#frc_grnDetailsModalLabel').text(titleParts.join(' | '));
                        
                        response.data.forEach(row => {
                            const htmlRow = `
                                <tr>
                                    <td class="leftallign">${row.GRnNo}</td>
                                    <td class="leftallign">${formatDateTime(row.GrnDate)}</td>
                                    <td class="leftallign">${row.Supplier_Name}</td>
                                    <td class="leftallign">${row.Invoice_NO}</td>
                                    <td class="leftallign">${formatDateTime(row.Invoice_Date)}</td>
                                    <td class="leftallign">${row.Gp_No}</td>
                                    <td class="leftallign">${formatDateTime(row.Gp_Date)}</td>
                                    <td class="sideallign">${row.Grn_Qty}</td>
                                    <td class="sideallign">${row.Rej_Qty}</td>
                                    <td class="leftallign">${row.Uom}</td>
                                    <td class="leftallign">${row.Bag_NO}</td>
                                </tr>
                            `;
                            tbody.append(htmlRow);
                        });
                        
                        // Reinit DataTable with footerCallback
                        $('#frc_grnDetailsTable').DataTable({
                            //destroy: true,
                            ordering: true,
                            paging: false,
                            searching: true,
                            dom: 'Bfrtip',  
                            buttons: [
                                {
                                    extend: 'excelHtml5',
                                    title: 'FRC GRN DETAILS',
                                    exportOptions: {
                                        columns: ':visible',
                                        format: {
                                            body: function (data, row, column) {
                                                return [1, 4, 6].includes(column) && /\d{2}-\d{2}-\d{2}/.test(data)
                                                    ? moment(data, 'DD-MM-YY').format('YYYY-MM-DD') // Convert date format
                                                    : data.replace(/<[^>]+>/g, ''); // Remove HTML tags if any
                                            }
                                        }
                                    },
                                    footer: true
                                },
                                {
                                    extend: 'pdfHtml5',
                                    text: 'PDF',
                                    title: 'FRC GRN DETAILS',
                                    orientation: 'landscape',
                                    pageSize: 'A3',
                                    exportOptions: {
                                        columns: ':visible'
                                    },
                                    customize: function(doc) {
                                        doc.defaultStyle.fontSize = 7;
                                        doc.content[1].table.widths = 'auto';  
                                        doc.content[1].table.dontBreakRows = true;  
                                    }
                                }
                            ],
                            footerCallback: function (row, data, start, end, display) {
                                let api = this.api();
                                let floatVal = (i) => typeof i === 'string' ? parseFloat(i.replace(/,/g, '')) || 0 : (typeof i === 'number' ? i : 0);
                                var columnsToSum = [7, 8]; 

                                columnsToSum.forEach(function (colIndex) {
                                    var total = api
                                        .column(colIndex, { page: 'current' }) // Sum only visible data
                                        .data()
                                        .reduce((a, b) => floatVal(a) + floatVal(b), 0);

                                    // Update footer with total
                                    $(api.column(colIndex).footer()).html(total);
                                    // var totalInLakhs = (total / 100000) .toFixed(2);
                                    // $(api.column(colIndex).footer()).html(totalInLakhs);
                                });
                            }
                        });
                    
                    } else {
                        tbody.html('<tr><td colspan="24" class="text-center text-muted">No GRN data found.</td></tr>');
                    }

                    openFrcGrnModal();
                },
                error: function () {
                    $('#frc_grnDetailsTable tbody').html('<tr><td colspan="24" class="text-danger text-center">Failed to load data.</td></tr>');
                }
            });
        });
        
        // Tailwind helpers for FRC PO details modal
        function openFrcPoModal() {
            const modal = document.getElementById('FRC_po_details');
            if (!modal) return;
            modal.classList.remove('hidden');
            modal.classList.add('flex');
            document.body.classList.add('overflow-hidden');
        }

        function closeFrcPoModal() {
            const modal = document.getElementById('FRC_po_details');
            if (!modal) return;
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.classList.remove('overflow-hidden');

            // Destroy DataTable instance when closing
            if ($.fn.DataTable && $.fn.DataTable.isDataTable('#po_frc_DetailsTable')) {
                $('#po_frc_DetailsTable').DataTable().destroy();
            }
        }

        // Tailwind helpers for FRC GRN details modal
        function openFrcGrnModal() {
            const modal = document.getElementById('frc_grnDetailsModal');
            if (!modal) return;
            modal.classList.remove('hidden');
            modal.classList.add('flex');
            document.body.classList.add('overflow-hidden');
        }

        function closeFrcGrnModal() {
            const modal = document.getElementById('frc_grnDetailsModal');
            if (!modal) return;
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.classList.remove('overflow-hidden');

            // Destroy DataTable instance when closing
            if ($.fn.DataTable && $.fn.DataTable.isDataTable('#frc_grnDetailsTable')) {
                $('#frc_grnDetailsTable').DataTable().destroy();
            }
        }

        // Tailwind helpers for FRC follow-up modal
        function openFrcFollowModal() {
            const modal = document.getElementById('frcfollow');
            if (!modal) return;
            modal.classList.remove('hidden');
            modal.classList.add('flex');
            document.body.classList.add('overflow-hidden');
        }

        function closeFrcFollowModal() {
            const modal = document.getElementById('frcfollow');
            if (!modal) return;
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.classList.remove('overflow-hidden');
        }

        // Global click handler to close Tailwind modals on X or backdrop
        document.addEventListener('click', function (e) {
            const poModal = document.getElementById('FRC_po_details');
            if (poModal) {
                const isCloseBtnPo = e.target.id === 'FRC_po_details_close' || e.target.closest('#FRC_po_details_close');
                const clickedOutsidePo = e.target === poModal;
                if (isCloseBtnPo || clickedOutsidePo) {
                    closeFrcPoModal();
                }
            }

            const grnModal = document.getElementById('frc_grnDetailsModal');
            if (grnModal) {
                const isCloseBtnGrn = e.target.id === 'frc_grnDetailsModal_close' || e.target.closest('#frc_grnDetailsModal_close');
                const clickedOutsideGrn = e.target === grnModal;
                if (isCloseBtnGrn || clickedOutsideGrn) {
                    closeFrcGrnModal();
                }
            }

            const followModal = document.getElementById('frcfollow');
            if (followModal) {
                const isCloseBtnFollow = e.target.id === 'frcfollow_close' || e.target.closest('#frcfollow_close');
                const clickedOutsideFollow = e.target === followModal;
                if (isCloseBtnFollow || clickedOutsideFollow) {
                    closeFrcFollowModal();
                }
            }
        });

    </script>

</body>
</html>