<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Projection Planning</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    
</head>
<body class="bg-gray-50">
    @include('LifeAtGainup.Planning.GUTplanning.Gutplan_nav')

    <div class="p-6">

    <div class="flex items-center gap-4 mb-3">
        <div class="text-gray-500 text-m">
            <a href="/gutplan" class="text-gray-500 hover:text-gray-700">
                Order Management
            </a>
            &gt;
            <span class="text-black-700 font-medium">Projection Planning</span>
        </div>
        <div class="h-4 w-px bg-gray-300"></div>
        <p class="text-gray-500 font-bold text-base">for <span class="ccno-display font-bold text-base"></span></p>
        <div class="h-4 w-px bg-gray-300"></div>
        <p class="text-gray-500 text-xs">View and manage your material projections.</p>
    </div>


        <!-- Title Section -->
        
        

        <!-- Filter Button with Dropdown -->
        <div class="flex justify-end mb-3 relative">
            <button class="px-4 py-2 border rounded-md flex items-center gap-2 hover:bg-gray-50" onclick="toggleFilter()">
                <i class="fa-solid fa-filter"></i> Filter
            </button>
            
            <!-- Filter Panel -->
            <div id="filterPanel" class="hidden absolute right-0 mt-2 w-72 bg-white rounded-lg shadow-xl border p-5 z-50">
                <!-- Title -->
                <h3 class="text-lg font-semibold">Filters</h3>
                <p class="text-gray-500 text-sm mb-4">Filter the Projection data.</p>

                <!-- CC No -->
                <div class="mb-4">
                    <label class="text-sm text-gray-700 mb-1 block">CC No.</label>
                    <select class="w-full border border-gray-300 rounded-md px-3 py-2 text-gray-700 bg-gray-50 focus:ring-1 focus:ring-blue-400 focus:border-blue-400">
                        <option>1 selected</option>
                    </select>
                </div>

                <!-- Model / Color -->
                <div class="mb-5">
                    <label class="text-sm text-gray-700 mb-1 block">Model / Color</label>
                    <select class="w-full border border-gray-300 rounded-md px-3 py-2 text-gray-700 bg-gray-50 focus:ring-1 focus:ring-blue-400 focus:border-blue-400">
                        <option>1 selected</option>
                    </select>
                </div>

                <!-- Clear Filters -->
                <button class="flex items-center gap-2 text-red-500 text-sm hover:text-red-600">
                    <i class="fa-solid fa-xmark text-red-500"></i>
                    Clear all filters
                </button>
            </div>
        </div>

        <!-- Table -->
        <div class="overflow-x-auto rounded-xl border">

            <table class="w-full text-left border-collapse">

                <!-- Table Header -->
                <thead class="bg-[#EAF1FF]">
                    <tr class="text-gray-700 text-sm">
                        <!-- <th class="px-4 py-3 font-medium">CC no.</th>
                        <th class="px-4 py-3 font-medium">Model / Color</th> -->
                        <th class="px-4 py-3 font-medium">PRJ #</th>
                        <th class="px-4 py-3 font-medium">PRJ Date</th>
                        <th class="px-4 py-3 font-medium">PRJ Week</th>
                        <th class="px-4 py-3 font-medium">CK Date</th>
                        <th class="px-4 py-3 font-medium">CK week</th>
                        <th class="px-4 py-3 font-medium">PRJ Coverage weeks</th>
                        <th class="px-4 py-3 font-medium">PRJ Qty</th>
                     
                       
                        <th class="px-4 py-3 font-medium">Kit-Receipt Week</th>
                       
                    </tr>
                </thead>

                <!-- Table Body -->
                <tbody class="text-sm" id="projectionTableBody">
                    <!-- Data will be populated here -->
                    <tr>
                        <td colspan="13" class="text-center py-8 text-gray-500">
                            <i class="fas fa-spinner fa-spin text-2xl mb-2"></i>
                            <p>Loading projection data...</p>
                        </td>
                    </tr>
                </tbody>

            </table>
        </div>

    </div>

    <!-- prj_based_ocn_modal start - Pooja (Tailwind modal) -->
    <div id="prj_based_ocn_modal" aria-labelledby="prj_based_ocn_modal_Label" aria-hidden="true"
         class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-50">
        <div class="bg-white rounded-xl shadow-2xl w-full max-w-6xl max-h-[85vh] flex flex-col border">
            <!-- Header -->
            <div class="flex items-center justify-between px-5 py-3 border-b bg-gray-50">
                <h5 class="text-base font-semibold prj_ocn_based" id="prj_based_ocn_modal_Label">Projection Status</h5>
                <button type="button" id="prj_based_ocn_modal_close"
                        class="inline-flex items-center justify-center w-8 h-8 rounded-full hover:bg-gray-100 text-gray-500">
                    <span class="sr-only">Close</span>
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <!-- Body -->
            <div class="px-5 py-4 overflow-y-auto">
                <div class="space-y-4">
                    <!-- Filters row -->
                    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-5 gap-3">
                        <div>
                            <select id="modelDropdown"
                                    class="w-full border border-gray-300 rounded-md px-2.5 py-1.5 text-sm bg-white focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Model code</option>
                            </select>
                        </div>

                        <div>
                            <select id="itemDropdown"
                                    class="w-full border border-gray-300 rounded-md px-2.5 py-1.5 text-sm bg-white focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Item code</option>
                            </select>
                        </div>

                        <div>
                            <select id="fabricDropdown"
                                    class="w-full border border-gray-300 rounded-md px-2.5 py-1.5 text-sm bg-white focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Fabric</option>
                            </select>
                        </div>

                        <div>
                            <select id="color_sizeDropdown"
                                    class="w-full border border-gray-300 rounded-md px-2.5 py-1.5 text-sm bg-white focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Color &amp; Size</option>
                            </select>
                        </div>

                        <div>
                            <select id="statusDropdown"
                                    class="w-full border border-gray-300 rounded-md px-2.5 py-1.5 text-sm bg-white focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Closure</option>
                            </select>
                        </div>
                    </div>

                    <!-- Table -->
                    <div class="border rounded-lg overflow-hidden">
                        <div class="overflow-auto max-h-[60vh]">
                            <table id="prj_based_ocn_modal_detailsTable"
                                   class="min-w-full text-xs border-collapse">
                                <thead class="bg-gray-100 sticky top-0 z-10">
                                    <tr class="text-gray-700 text-[11px] uppercase tracking-wide">
                                        <th class="px-2 py-2 border text-left">Sl No</th>
                                        <th class="px-2 py-2 border text-left">MODEL Code</th>
                                        <th class="px-2 py-2 border text-left">Item Code</th>
                                        <th class="px-2 py-2 border text-left">FABRIC</th>
                                        <th class="px-2 py-2 border text-left">Color And Size</th>
                                        <th class="px-2 py-2 border text-right">Req Qty</th>
                                        <th class="px-2 py-2 border text-right">PO Qty</th>
                                        <th class="px-2 py-2 border text-right">PO Pend</th>
                                        <th class="px-2 py-2 border text-right">Grn Qty</th>
                                        <th class="px-2 py-2 border text-right">Rej Qty</th>
                                        <th class="px-2 py-2 border text-right">Grn Pend</th>
                                        <th class="px-2 py-2 border text-left">GRN Dt</th>
                                        <th class="px-2 py-2 border text-left">Lead Days</th>
                                        <th class="px-2 py-2 border text-left">Item Closure</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data will be injected here dynamically -->
                                </tbody>
                                <tfoot class="bg-gray-50 sticky bottom-0 z-10 text-xs">
                                    <tr>
                                        <th colspan="5" class="px-2 py-2 border text-right font-semibold">Total :</th>
                                        <th id="totalReqQty" class="px-2 py-2 border text-right font-semibold"></th>
                                        <th id="totalPOQty" class="px-2 py-2 border text-right font-semibold"></th>
                                        <th id="totalPOpend" class="px-2 py-2 border text-right font-semibold"></th>
                                        <th id="totalGRNQty" class="px-2 py-2 border text-right font-semibold"></th>
                                        <th id="totalRejQty" class="px-2 py-2 border text-right font-semibold"></th>
                                        <th id="totalGRNpend" class="px-2 py-2 border text-right font-semibold"></th>
                                        <th class="px-2 py-2 border"></th>
                                        <th class="px-2 py-2 border"></th>
                                        <th class="px-2 py-2 border"></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- prj_based_ocn_modal end - Pooja -->

    <!-- PRJ Follow popup modal - start (Tailwind) -->
    <div id="prjfollow" aria-labelledby="prjModalLabel" aria-hidden="true"
         class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-50">
        <div class="bg-white rounded-md shadow-lg w-full max-w-sm flex flex-col border text-xs">
            <div class="flex items-center justify-between px-4 py-2 border-b bg-gray-50">
                <h6 class="text-sm font-semibold" id="prjModalLabel"><span id='prjfollow-up-title'></span></h6>
                <button type="button" id="prjfollow_close"
                        class="inline-flex items-center justify-center w-8 h-8 rounded-full hover:bg-gray-100 text-gray-500">
                    <span class="sr-only">Close</span>
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
            <div class="px-4 py-3 overflow-y-auto">
                <div class="table-container">
                    <!-- Form inside modal -->
                    <form id=prjfollowup>
                        @csrf
                        <!-- Description Textarea -->
                        <div class="mb-3">
                            <!-- <label for="description" class="form-label" id="prj_note_title"></label> -->
                            <input type="hidden" name="emp_id" id="prjemp_id" value="{{$user = Session('empl_id')}}">
                            <input type="hidden" name="portal_id" id="prjportal_id" value="1">
                            <input type="hidden" name="follow_ocn" id="prjfollow_ocn" value="">
                            <input type="hidden" name="portal_id" id="prjitem_id" value="">
                            <textarea class="form-control w-full border rounded px-2 py-1 text-xs" id="prjdescription" name='description' rows="4" placeholder="Enter your remarks here"></textarea>
                            <div class="mt-2 overflow-x-auto">
                                <table class="min-w-full border border-gray-300 text-xs">
                                    <thead class="bg-gray-100">
                                        <tr>
                                            <th class="w-2/5 px-2 py-1 border-b border-gray-300 text-left font-semibold">Employee</th>
                                            <th class="px-2 py-1 border-b border-gray-300 text-left font-semibold">Comment</th>
                                        </tr>
                                    </thead>
                                    <tbody id="prj_comments_table">
                                        <!-- Rows will be added dynamically -->
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <button type="button" id="prjsubmitBtn" class="mt-1 inline-flex items-center px-3 py-1.5 bg-blue-600 text-white text-xs font-medium rounded shadow-sm hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-1">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- PRJ Follow popup modal - end -->

    <!-- venkatesh_po_projection (Tailwind) -->
    <div id="PO_qt_prj" aria-labelledby="PO_qtLabel" aria-hidden="true"
         class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-50">
        <div class="bg-white rounded-xl shadow-2xl w-full max-w-3xl max-h-[80vh] flex flex-col border text-xs">
            <!-- Header -->
            <div class="flex items-center justify-between px-4 py-2 border-b bg-gray-50">
                <h5 class="text-sm font-semibold w-full" id="PO_qtLabel">PO Details</h5>
                <button type="button" id="PO_qt_prj_close"
                        class="inline-flex items-center justify-center w-8 h-8 rounded-full hover:bg-gray-100 text-gray-500">
                    <span class="sr-only">Close</span>
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <!-- Body -->
            <div class="px-4 py-3 overflow-y-auto">
                <div class="border rounded-lg overflow-hidden">
                    <div class="table-responsive max-h-[60vh]" style="font-size: 12px;">
                        <table class="table table-bordered table-sm text-nowrap" id="poDetailsTable">
                            <thead class="table-light" style="position: sticky; top: 0; z-index: 2; background-color: #f8f9fa;">
                                <tr>
                                    <th>PONo</th>
                                    <th>PoDate</th>
                                    <th>Supplier</th>
                                    <th>UOM</th>
                                    <th>PO Qty</th>
                                    <th>GRN Qty</th>
                                    <th>Rej Qty</th>
                                    <th>GRN Pending Qty</th>
                                    <th>Approval</th>
                                </tr>
                            </thead>

                            <tbody id="poDetailsBody">
                                <!-- Dynamic rows go here -->
                            </tbody>

                            <tfoot class="table-light">
                                <tr>
                                    <th colspan="4" style="text-align:right">Total:</th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Prj GRN Qty Detail Modal start - Pooja (Tailwind) -->
    <div id="grnDetailsModal" aria-labelledby="grnDetailsModalLabel" aria-hidden="true"
         class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-50">
        <div class="bg-white rounded-xl shadow-2xl w-full max-w-5xl max-h-[80vh] flex flex-col border text-xs">
            <!-- Header -->
            <div class="flex items-center justify-between px-4 py-2 border-b bg-gray-50">
                <h5 class="text-sm font-semibold" id="grnDetailsModalLabel">GRN Details</h5>
                <button type="button" id="grnDetailsModal_close"
                        class="inline-flex items-center justify-center w-8 h-8 rounded-full hover:bg-gray-100 text-gray-500">
                    <span class="sr-only">Close</span>
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
            <div class="px-4 py-3 overflow-y-auto">
                <div class="border rounded-lg overflow-hidden">
                    <div class="table-responsive max-h-[60vh]" style="font-size: 12px;">
                        <table class="table table-bordered" id="grnDetailsTable">
                            <thead style="position: sticky; top: 0; z-index: 10;">
                                <tr>
                                    <th>GRN No</th>
                                    <th>GRN_Date</th>
                                    <th>Supplier Name</th>
                                    <th>Invoice No</th>
                                    <th>Invoice_Date</th>
                                    <th>GP No</th>
                                    <th>GP_Date</th>
                                    <th>GRN Qty</th>
                                    <th>Rej Qty</th>
                                    <th>UOM</th>
                                    <th>Sec Qty</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Data will be injected here dynamically -->
                            </tbody>
                            <tfoot style="position: sticky; bottom: 0; z-index: 10;">
                                <tr>
                                    <th colspan="3" class="sideallign">Total:</th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th id="total_grn_GRNQty" class="sideallign"></th>
                                    <th id="total_grn_RejQty" class="sideallign"></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Prj GRN Qty Detail Modal end - Pooja -->


    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.js"></script>
    <script>
        function toggleFilter() {
            const panel = document.getElementById('filterPanel');
            panel.classList.toggle('hidden');
        }

        // Close filter panel when clicking outside
        document.addEventListener('click', function(event) {
            const filterButton = event.target.closest('button[onclick="toggleFilter()"]');
            const filterPanel = document.getElementById('filterPanel');
            
            if (!filterButton && !filterPanel.contains(event.target)) {
                filterPanel.classList.add('hidden');
            }
        });

        // Load projection data when page loads
        $(document).ready(function() {
            // Display CC No and Color in the header
            const ccno = localStorage.getItem('selectedCcNo');
            const color = localStorage.getItem('selectedColor');
            const modal = localStorage.getItem('selectedmodal');
            const season = localStorage.getItem('selectedseason');
            
            if (ccno && color && modal && season) {
                $('.ccno-display').text(color +' | '+ modal +' | ' + season);
            } else if (ccno) {
                $('.ccno-display').text(ccno);
            }
            
            loadProjectionData();
        });

        function loadProjectionData() {
            const costno = localStorage.getItem('selectedCostNo');
            const portalType = localStorage.getItem('portalType') || 'gut_new';

            console.log('Loading projection data for costno:', costno, 'portal type:', portalType);

            if (!costno) {
                $('#projectionTableBody').html(`
                    <tr>
                        <td colspan="13" class="text-center py-8 text-red-500">
                            <i class="fas fa-exclamation-triangle text-2xl mb-2"></i>
                            <p>No cost number selected. Please go back and select a PRJ Qty from Order Management.</p>
                        </td>
                    </tr>
                `);
                return;
            }

            $.ajax({
                url: '/proj_details',
                method: 'GET',
                data: {
                    costno: costno,
                    portaltype: portalType
                },
                success: function(response) {
                    console.log('Projection data response:', response);
                    
                    if (response.success && response.data && response.data.length > 0) {
                        populateProjectionTable(response.data);
                    } else {
                        $('#projectionTableBody').html(`
                            <tr>
                                <td colspan="13" class="text-center py-8 text-gray-500">
                                    <i class="fas fa-inbox text-2xl mb-2"></i>
                                    <p>No projection data found for Cost ID: ${costno}</p>
                                </td>
                            </tr>
                        `);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error loading projection data:', error);
                    $('#projectionTableBody').html(`
                        <tr>
                            <td colspan="13" class="text-center py-8 text-red-500">
                                <i class="fas fa-exclamation-circle text-2xl mb-2"></i>
                                <p>Error loading projection data. Please try again.</p>
                                <p class="text-sm text-gray-500 mt-1">${error}</p>
                            </td>
                        </tr>
                    `);
                }
            });
        }

        function populateProjectionTable(data) {
            let tableHtml = '';
            let totalProjQty = 0; 
            
            data.forEach(function(row) {
                const approvalStatus = row.Approval === 'T' ? 
                    '<i class="fa-solid fa-check text-green-600"></i>' : 
                    '<i class="fa-solid fa-xmark text-red-600"></i>';
                
                const statusClass = row.Approval === 'T' ? 'text-green-600' : 'text-red-600';
                const statusText = row.Approval === 'T' ? 'Approved' : 'Pending';
                
                // Format dates
                const poDate = formatDate(row.PO_DAte) || '-';
                const ckDate = formatDate(row.Ck_Date) || '-';

                totalProjQty += Number(row.Proj_Qty || 0);
                
                tableHtml += `
                    <tr class="border-b hover:bg-gray-50">
                        <td class="px-4 py-3 prj_based_ocn_clickable" style="cursor: pointer; color: blue;" data-order-id="${row.Order_ID}">${row.Order_NO || '-'}</td>
                        <td class="px-4 py-3">${poDate}</td>
                        <td class="px-4 py-3">${row.Po_Week || '-'}</td>
                        <td class="px-4 py-3">${ckDate}</td>
                        <td class="px-4 py-3">${row.Ck_Week || '-'}</td>
                        <td class="px-4 py-3 bg-gray-100">${row.Prj_Cov_Week || '-'}</td>
                        <td class="px-4 py-3 font-medium">${number_format(row.Proj_Qty || 0)}</td>
                        <td class="px-4 py-3">
                            <span>--</span>
                        </td>
                    </tr>
                `;
            });

            tableHtml += `
                <tr class="bg-gray-100 font-semibold">
                    <td class="px-4 py-3 text-right" colspan="6">Total</td>
                    <td class="px-4 py-3">${number_format(totalProjQty)}</td>
                    <td class="px-4 py-3" colspan="2"></td>
                </tr>
            `;
            
            $('#projectionTableBody').html(tableHtml);
        }

        function number_format(num) {
            return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }

        // Function to format date to dd-mm-yy
        function formatDate(dateString) {
            if (!dateString) return '';
            
            const date = new Date(dateString);
            if (isNaN(date.getTime())) return dateString; // Return original if invalid
            
            const day = String(date.getDate()).padStart(2, '0');
            const month = String(date.getMonth() + 1).padStart(2, '0');
            const year = String(date.getFullYear()).slice(-2);
            
            return `${day}-${month}-${year}`;
        }

        // Helper functions to control PRJ based OCN Tailwind modal
        function openPrjOcnModal() {
            var modal = document.getElementById('prj_based_ocn_modal');
            if (!modal) return;
            modal.classList.remove('hidden');
            modal.classList.add('flex');
            document.body.classList.add('overflow-hidden');
        }

        function closePrjOcnModal() {
            var modal = document.getElementById('prj_based_ocn_modal');
            if (!modal) return;
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.classList.remove('overflow-hidden');

            // Reset filters and DataTable state when modal closes
            $('#modelDropdown, #itemDropdown, #sizeDropdown, #statusDropdown, #color_sizeDropdown').val('');
            if ($.fn.DataTable && $.fn.DataTable.isDataTable('#prj_based_ocn_modal_detailsTable')) {
                var table = $('#prj_based_ocn_modal_detailsTable').DataTable();
                table.columns([1, 2, 3, 4, 13]).search('').draw();
            }
        }

        // Close when clicking X button or backdrop
        document.addEventListener('click', function (e) {
            var modal = document.getElementById('prj_based_ocn_modal');
            if (!modal) return;

            var isCloseBtn = e.target.id === 'prj_based_ocn_modal_close' || e.target.closest('#prj_based_ocn_modal_close');
            var clickedOutside = e.target === modal;

            if (isCloseBtn || clickedOutside) {
                closePrjOcnModal();
            }
        });

        // prj based ocn details start - Pooja
        $(document).on('click', '.prj_based_ocn_clickable', function () {
            const orderId = $(this).data('order-id');
            let prjocntitle = $(this).data('title');
            const $tbody = $('#prj_based_ocn_modal_detailsTable tbody');
            $tbody.empty();

            $('#prj_based_ocn_modal_detailsTable tbody').html('<tr><td colspan="14" class="text-center">⏳ Loading projection details...</td></tr>');
            openPrjOcnModal();

            $.ajax({
                url: '{{ route("gut_proj_based_ocn_details") }}',
                method: 'GET',
                data: { orderId },
                success: function (response) {
                    const $tbody = $('#prj_based_ocn_modal_detailsTable tbody');

                    if (!response || !response.data || response.data.length === 0) {
                        $tbody.html('<tr><td colspan="14" class="text-danger text-center">No data found!</td></tr>');
                        return;
                    }

                    $('#prj_based_ocn_modal_Label').text(
                        'Fabric Req Status For the Proj No :' + response.data[0].Order_No + 
                        ' CKDT :' + formatDate(response.data[0].Ck_Date)
                    );

                    if ($.fn.DataTable.isDataTable('#prj_based_ocn_modal_detailsTable')) {
                        $('#prj_based_ocn_modal_detailsTable').DataTable().clear().destroy();
                    }

                    // Build rows in a string
                    let rows = response.data.map((row, index) => {
                        const rowClass = row.CK_COlor === 'Red' ? 'table-danger' : '';
                        let poQty = parseInt(row.PO_Qty) || 0;
                        let grnQty = parseFloat(row.GRN_Qty) || 0;
                        let grnColor = row.CK_COlor || 'black';
                        let po_date = formatDate(row.PODate) || "-";
                        let poQtyPrjElement = '';
                        if (poQty > 0) {
                            poQtyPrjElement = `
                                <span class="PO_qt_prj-click" 
                                    style="color: blue; cursor: pointer;" 
                                    data-bs-toggle="modal" data-bs-target="#PO_qt_prj"
                                    data-itemcode="${row.Item_Code}" 
                                    data-orderid="${row.Order_ID}" 
                                    data-modelcode="${row.Model_Code}">
                                    ${poQty}
                                </span>`;
                        } else {
                            poQtyPrjElement = `
                                <span 
                                    class="text-muted" 
                                    style="cursor: not-allowed;" 
                                    title="No data">
                                    0
                                </span>`;
                        }
                        return `
                            <tr class="${rowClass}">
                                <td class="leftallign">${index + 1}</td>
                                <td class="leftallign">${row.Model_Code || ''}</td>
                                <td class="leftallign">${row.Item_Code || ''}</td>
                                <td class="leftallign">${row.Fabric || ''}</td>
                                <td class="leftallign">${row.Color && row.Size ? `${row.Color}&${row.Size}` : (row.Color || row.Size || '')}</td>
                                <td class="sideallign">${row.Req_Qty || 0}</td>
                                <td class="sideallign">${poQtyPrjElement || 0}</td>
                                <td class="sideallign">${row.PO_Pending || 0}</td>
                                <td class="sideallign"> <span class=" grn-clickable" data-order-id="${row.Order_ID}" data-model_code="${row.Model_Code}" data-item_code="${row.Item_Code}" style="color: ${grnColor}; font-weight: bold; cursor: pointer;" title="${parseFloat(grnQty) > 0 ? `` : 'No data'}">${grnQty}</span></td>
                                <td class="sideallign">${row.Rej_Qty || 0}</td>
                                <td class="sideallign">${row.GRN_Pending || 0}</td>
                                <td class="leftallign">${formatDateTime(row.GrnDate) || ''}</td>
                                <td class="leftallign">${row.Lead_Days || ''}</td>
                                <td class="leftallign">${row.Item_Closure || ''} <span class="prj-follow-popup" style="cursor: pointer; color: blue; margin-left:5px"
                                    data-bs-toggle="modal" data-model-code="${row.Model_Code}" data-item-code="${row.Item_Code}" data-fabric="${row.Fabric}"  data-order-no="${row.Order_No}" data-bs-target="#prjfollow" >
                                    <i class="fa-regular fa-comment"></i></span>
                                </td>
                            </tr>
                        `;
                    }).join('');

                    $tbody.html(rows);

                    // Initialize DataTable
                    let table = $('#prj_based_ocn_modal_detailsTable').DataTable({
                        ordering: true,
                        paging: false,
                        pageLength: 25,
                        searching: true,
                        dom: 'Bfrtip',
                        buttons: [
                            {
                                extend: 'excelHtml5',
                                title: 'Fabric Req status Details',
                                exportOptions: {
                                    columns: ':visible',
                                    format: {
                                        body: function (data, row, column) {
                                            return [5,6].includes(column) && /\d{2}-\d{2}-\d{2}/.test(data)
                                                ? moment(data, 'DD-MM-YY').format('YYYY-MM-DD') // Convert date format
                                                : data.replace(/<[^>]+>/g, ''); // Remove HTML tags if any
                                        }
                                    }
                                },
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                text: 'PDF',
                                title: 'Fabric Req status Details',
                                orientation: 'landscape',
                                pageSize: 'A3',
                                exportOptions: {
                                    columns: ':visible',
                                    stripHtml: true 
                                }
                            }
                        ],
                        footerCallback: function (row, data, start, end, display) {
                            let api = this.api();
                            //const floatVal = i => typeof i === 'string' ? parseFloat(i.replace(/,/g, '')) || 0 : (typeof i === 'number' ? i : 0);
                            let floatVal = (html) => {
                            let tempDiv = document.createElement('div');
                            tempDiv.innerHTML = html;
                            let span = tempDiv.querySelector('span');
                            let text = span ? span.textContent.trim() : tempDiv.textContent.trim(); // Fallback if span is missing
                            return parseFloat(text.replace(/,/g, '')) || 0;
                        };
                            let columnsToSum = [5, 6, 7, 8, 9, 10];

                            columnsToSum.forEach(function (colIndex) {
                                let total = api.column(colIndex, { page: 'current' }).data()
                                    .reduce((a, b) => floatVal(a) + floatVal(b), 0);

                                $(api.column(colIndex).footer()).html(Math.round(total));
                            });
                        }
                    });

                    // Populate dropdowns
                    function populateDropdown(columnIndex, dropdownId) {
                        let column = table.column(columnIndex);
                        let uniqueVals = column.data().toArray().filter((v, i, a) => v && a.indexOf(v) === i).sort();
                        let $dropdown = $(`#${dropdownId}`);
                        let defaultOption = $dropdown.data('default') || $dropdown.find('option:first').text();
                        $dropdown.empty().append(`<option value="">${defaultOption}</option>`);
                        uniqueVals.forEach(v => $dropdown.append(`<option value="${v}">${v}</option>`));
                    }

                    populateDropdown(1, 'modelDropdown');
                    populateDropdown(2, 'itemDropdown');
                    populateDropdown(3, 'fabricDropdown');
                    populateDropdown(4, 'color_sizeDropdown');
                    populateDropdown(13, 'statusDropdown');

                    $('#modelDropdown').on('change', function () {
                        table.column(1).search(this.value).draw();
                    });
                    $('#itemDropdown').on('change', function () {
                        table.column(2).search(this.value).draw();
                    });
                    $('#fabricDropdown').on('change', function () {
                        table.column(3).search(this.value).draw();
                    });
                    $('#color_sizeDropdown').on('change', function () {
                        table.column(4).search(this.value).draw();
                    });
                    $('#statusDropdown').on('change', function () {
                        table.column(13).search(this.value).draw();
                    });
                },
                error: function (xhr) {
                    console.error(xhr);
                    $('#prj_based_ocn_modal_detailsTable tbody').html('<tr><td colspan="14" class="text-danger text-center">🔥 Error fetching data!</td></tr>');
                }
            });

        });

        // prj based ocn details end - Pooja

        function formatDateTime(dateString) {
            if (!dateString) return '';

            // Try parsing datetime with time (e.g. 2023-11-08 00:00:00.000)
            if (moment(dateString, 'YYYY-MM-DD HH:mm:ss.SSS', true).isValid()) {
                return moment(dateString, 'YYYY-MM-DD HH:mm:ss.SSS').format('DD-MM-YY');
            }

            // Try parsing date only (e.g. 2023-11-08)
            if (moment(dateString, 'YYYY-MM-DD', true).isValid()) {
                return moment(dateString, 'YYYY-MM-DD').format('DD-MM-YY');
            }

            // Try parsing existing DD-MM-YY
            if (moment(dateString, 'DD-MM-YY', true).isValid()) {
                return moment(dateString, 'DD-MM-YY').format('DD-MM-YY');
            }

            return ''; // Invalid or unrecognized format
        }

        //  venkatesh_Prjocn - start
        $(document).on('click', '.PO_qt_prj-click', function () {
            const itemCode = $(this).data('itemcode');
            const orderId = $(this).data('orderid');
            const modelCode = $(this).data('modelcode');

            // Show loading in modal body and open Tailwind PO modal
            $('#poDetailsBody').html('<tr><td colspan="1" class="text-center">⏳ Loading...</td></tr>');
            openPrjPoModal();

            $.ajax({
                url: 'gut-prj-po-details',
                method: 'GET',
                data: {
                    itemcode: itemCode,
                    orderId: orderId,
                    modcode: modelCode
                },
                success: function(response) {
                    if ($.fn.DataTable.isDataTable('#poDetailsTable')) {
                        $('#poDetailsTable').DataTable().destroy();
                    }
                    if (!response || !response.data || response.data.length === 0) {
                        $('#poDetailsBody').html('<tr><td colspan="17" class="text-center">🚫 No PO records found!</td></tr>');
                        $('#PO_qtLabel').text('Po_details - No records');
                        return;
                    }

                    console.log('PO Details:', response.data);
                    
                    // ✅ Safe access to response.data[0]
                    const firstItem = response.data[0];
                    $('#PO_qtLabel').text(`Po_details - ${firstItem.Item || ''} | ${firstItem.Color || ''} | ${firstItem.Size || ''} | ${firstItem.CCNo || ''} | ${firstItem.Season || ''}`);

                    let rows = '';

                    response.data.forEach(item => {
                        rows += `
                            <tr>
                                <td>${item.PONo || ''}</td>
                                <td>${formatDateTime(item.PoDate) || ''}</td>
                                <td>${item.Supplier || ''}</td>
                                <td>${item.UOM || ''}</td>
                                <td>${item.Po_Qty || ''}</td>
                                <td>${item.Grn_Qty || ''}</td>
                                <td>${item.Rej_Qty || ''}</td>
                                <td>${item.Grn_Pend_Qty || ''}</td>
                                <td>${item.Approval_Flag_PO || ''}</td>
                            </tr>`;
                    });

                    $('#poDetailsBody').html(rows);

                    $('#poDetailsTable').DataTable({
                        paging: false,
                        searching: true,
                        ordering: true,
                        columnDefs: [
                                        { type: 'dd-mm-yy', targets: [1] } // Ensuring sorting works for date columns
                        ],
                        dom: 'Bfrtip',
                        buttons: [
                            {
                                extend: 'excelHtml5',
                                title: 'Prj PO DETAILS',
                                exportOptions: {
                                    columns: ':visible',
                                    format: {
                                        body: function (data, row, column) {
                                            return [1].includes(column) && /\d{2}-\d{2}-\d{2}/.test(data)
                                                ? moment(data, 'DD-MM-YY').format('YYYY-MM-DD') // Convert date format
                                                : data.replace(/<[^>]+>/g, ''); // Remove HTML tags if any
                                        }
                                    }
                                },
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                text: 'PDF',
                                title: 'Prj PO DETAILS',
                                orientation: 'landscape',
                                pageSize: 'A3',
                                exportOptions: {
                                    columns: ':visible'
                                },
                                customize: function(doc) {
                                    doc.defaultStyle.fontSize = 7;
                                    doc.content[1].table.widths = 'auto';  
                                    doc.content[1].table.dontBreakRows = true;  
                                }
                            }
                        ],
                        footerCallback: function (row, data, start, end, display) {
                            let api = this.api();
                            let floatVal = (i) => typeof i === 'string' ? parseFloat(i.replace(/,/g, '')) || 0 : (typeof i === 'number' ? i : 0);
                            let columnsToSum = [4, 5, 6, 7]; 

                            columnsToSum.forEach(function (colIndex) {
                                var total = api
                                    .column(colIndex, { page: 'current' }) // Sum only visible data
                                    .data()
                                    .reduce((a, b) => floatVal(a) + floatVal(b), 0);

                                // Update footer with total
                                $(api.column(colIndex).footer()).html(total);
                                // var totalInLakhs = (total / 100000).toFixed(2);
                                // $(api.column(colIndex).footer()).html(totalInLakhs);
                            });
                        }
                    });

                }

                
            });
        });
        //  venkatesh_Prjocn - end

        //    pooja_PRJ_GRN_details - start
        $(document).on('click', '.grn-clickable', function () {
            let grnQty = parseFloat($(this).text()) || 0;
            if (grnQty <= 0) return; //ignore the click

            let order_id = $(this).data('order-id');
            let model_code = $(this).data('model_code');
            let item_code = $(this).data('item_code');

            // Open Tailwind GRN modal
            openPrjGrnModal();

            // Clear old data
            const $tbody = $('#grnDetailsTable tbody');
            $tbody.empty();

            // Optional: Show a loading row while fetching
            $tbody.append('<tr><td colspan="24" class="text-center">Loading...</td></tr>');

            $.ajax({
                url: '/gutprjGrnDetails', // ⬅️ Replace this once you get it
                method: 'GET',
                data: {
                    orderId: order_id,
                    modcode: model_code,
                    itemcode: item_code
                },
                success: function (response) {
                    if ($.fn.DataTable.isDataTable('#grnDetailsTable')) {
                            $('#grnDetailsTable').DataTable().destroy();
                        }
                        
                    $tbody.empty();

                    if (response && response.data.length > 0) {
                        let titleParts = [`PRJ GRN Details - ${response.data[0].ORder_ID}`];
                        if (response.data[0].ITem) titleParts.push(response.data[0].ITem);
                        if (response.data[0].Color) titleParts.push(response.data[0].Color);
                        if (response.data[0].Size) titleParts.push(response.data[0].Size);

                        $('#grnDetailsModalLabel').text(titleParts.join(' | '));
                        response.data.forEach(row => {
                            $tbody.append(`
                                <tr>
                                    <td class="leftallign">${row.GRnNo}</td>
                                    <td class="leftallign">${formatDateTime(row.GrnDate)}</td>
                                    <td class="leftallign">${row.Supplier_Name}</td>
                                    <td class="leftallign">${row.Invoice_NO}</td>
                                    <td class="leftallign">${formatDateTime(row.Invoice_Date)}</td>
                                    <td class="leftallign">${row.Gp_No}</td>
                                    <td class="leftallign">${formatDateTime(row.Gp_Date)}</td>
                                    <td class="sideallign">${row.Grn_Qty}</td>
                                    <td class="sideallign">${row.Rej_Qty}</td>
                                    <td class="leftallign">${row.Uom}</td>
                                    <td class="leftallign">${row.Bag_NO}</td>           
                                </tr>
                            `);
                            
                        });
                        
                        // Reinit DataTable with footerCallback
                        $('#grnDetailsTable').DataTable({
                            //destroy: true,
                            ordering: true,
                            paging: false,
                            searching: true,
                            dom: 'Bfrtip',  
                            buttons: [
                                {
                                    extend: 'excelHtml5',
                                    title: 'PROJECTION GRN DETAILS',
                                    exportOptions: {
                                        columns: ':visible'
                                    },
                                    footer: true
                                },
                                {
                                    extend: 'pdfHtml5',
                                    text: 'PDF',
                                    title: 'PROJ GRN DETAILS',
                                    orientation: 'landscape',
                                    pageSize: 'A3',
                                    exportOptions: {
                                        columns: ':visible'
                                    },
                                    customize: function(doc) {
                                        doc.defaultStyle.fontSize = 7;
                                        doc.content[1].table.widths = 'auto';  
                                        doc.content[1].table.dontBreakRows = true;  
                                    }
                                }
                            ],
                            footerCallback: function (row, data, start, end, display) {
                                const api = this.api();
                                const floatVal = (i) => typeof i === 'string' ? parseFloat(i.replace(/,/g, '')) || 0 : (typeof i === 'number' ? i : 0);
                                const colTotal = (index) => api.column(index, { filter: 'applied' }).data().reduce((a, b) => floatVal(a) + floatVal(b), 0);

                                $(api.column(7).footer()).html(colTotal(7));   // GRN Qty
                                $(api.column(8).footer()).html(colTotal(8));   // Rej Qty
                            }
                        });

                    } else {
                        $tbody.append('<tr><td colspan="24" class="text-center text-muted">No GRN records found.</td></tr>');
                    }
                },
                error: function (xhr, status, error) {
                    $tbody.empty().append(`<tr><td colspan="24" class="text-danger text-center">Error loading GRN data.</td></tr>`);
                    console.error("GRN fetch failed:", error);
                }
            });
        });
        //    pooja_PRJ_GRN_details - end

        $('#prjsubmitBtn').click(function() {
            
            let orderno = $('#prjfollow_ocn').val();
            let formattedOrderNo = orderno.match(/\d+$/)[0];
            let itemid = $('#prjitem_id').val();
            let type = $('#prjportal_id').val();
            let emp_id = $('#prjemp_id').val();
            let description = $('#prjdescription').val();
            let today = new Date();
            let formattedDate = today.getFullYear() + '-' +
            String(today.getMonth() + 1).padStart(2, '0') + '-' +
            String(today.getDate()).padStart(2, '0');

            if (description == '') {
                $('#prjdescription').focus(); 
                toastr.error('Remark is empty', 'Error'); 
                return false; 
            }

            $.ajax({
                url: '{{ route("metrial_commands") }}', 
                method: 'POST',
                data: {
                    orderno: formattedOrderNo,
                    itemid: itemid,
                    type: type,
                    command: description,
                    created_by: emp_id,
                    command_date: formattedDate
                },
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
                },
                dataType: 'json',
                success: function(response) {
                    toastr.success('Your Feedback was successful!', response);
                    closePrjFollowModal();
                    $('#prjfollowup')[0].reset();
                },
                error: function(xhr, status, error) {
                    alert('Error: ' + error);
                }
            });
        });

        $(document).on('click', '.prj-follow-popup', function() {

            let ocn = $(this).data('order-no');
            let formattedOrderNo = ocn.match(/\d+$/)[0];
            let fabric = $(this).data('fabric');
            let model_code = $(this).data('model-code');
            let item_code = $(this).data('item-code');
        

            $('#prjfollow_ocn').val(ocn);
            $('#prjitem_id').val(item_code);
            $('#prjfollow').data('order-no', ocn)
            $('#prjfollow-up-title').text(ocn+' | '+fabric);
            $('#prjfollowup')[0].reset();

            $.ajax({
                url: "{{ route('metrialfollowdetails') }}",
                method: 'GET',
                data: {
                    orderno: formattedOrderNo,
                    type:  $('#prjportal_id').val() || 1,
                    emp_id: $('#prjemp_id').val(),
                    itemid: item_code

                },
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
                },
                dataType: 'json',
                beforeSend: function() {
                    $("#preloder").fadeIn();
                },
                success: function(response) {
                    let tableBody = $('#prj_comments_table');
                    tableBody.empty(); // Clear previous rows

                    if (Array.isArray(response.data) && response.data.length > 0) {

                        // Build table rows
                        response.data.forEach(comment => {
                            let row = `
                                <tr>
                                    <td>${comment.emp_name}</td>
                                    <td>${comment.comments}</td>
                                </tr>
                            `;
                            tableBody.append(row);
                        });

                        // Optionally, set the first comment in the textarea for editing
                        $('#prjdescription').val(response.data[0].comments || '');

                    } else {
                        tableBody.append(`<tr><td colspan="2" class="text-center">No comments found</td></tr>`);
                        $('#prjdescription').val('');

                    }
                },

                error: function(xhr, status, error) {
                    console.error('Error fetching data:', error);
                },
                complete: function() {
                    $("#preloder").fadeOut();
                    isAjaxFRCInProgress = false;
                }
            });

            openPrjFollowModal();
        });

        // Tailwind helpers for PRJ Follow modal
        function openPrjFollowModal() {
            const modal = document.getElementById('prjfollow');
            if (!modal) return;
            modal.classList.remove('hidden');
            modal.classList.add('flex');
            document.body.classList.add('overflow-hidden');
        }

        function closePrjFollowModal() {
            const modal = document.getElementById('prjfollow');
            if (!modal) return;
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.classList.remove('overflow-hidden');
        }

        // Tailwind helpers for PRJ PO details modal
        function openPrjPoModal() {
            const modal = document.getElementById('PO_qt_prj');
            if (!modal) return;
            modal.classList.remove('hidden');
            modal.classList.add('flex');
            document.body.classList.add('overflow-hidden');
        }

        function closePrjPoModal() {
            const modal = document.getElementById('PO_qt_prj');
            if (!modal) return;
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.classList.remove('overflow-hidden');

            if ($.fn.DataTable && $.fn.DataTable.isDataTable('#poDetailsTable')) {
                $('#poDetailsTable').DataTable().destroy();
            }
        }

        // Tailwind helpers for PRJ GRN details modal
        function openPrjGrnModal() {
            const modal = document.getElementById('grnDetailsModal');
            if (!modal) return;
            modal.classList.remove('hidden');
            modal.classList.add('flex');
            document.body.classList.add('overflow-hidden');
        }

        function closePrjGrnModal() {
            const modal = document.getElementById('grnDetailsModal');
            if (!modal) return;
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.classList.remove('overflow-hidden');

            if ($.fn.DataTable && $.fn.DataTable.isDataTable('#grnDetailsTable')) {
                $('#grnDetailsTable').DataTable().destroy();
            }
        }

        // Global click handler to close Tailwind PRJ modals on X or backdrop
        document.addEventListener('click', function (e) {
            const prjFollowModal = document.getElementById('prjfollow');
            if (prjFollowModal) {
                const isCloseBtnFollow = e.target.id === 'prjfollow_close' || e.target.closest('#prjfollow_close');
                const clickedOutsideFollow = e.target === prjFollowModal;
                if (isCloseBtnFollow || clickedOutsideFollow) {
                    closePrjFollowModal();
                }
            }

            const poModal = document.getElementById('PO_qt_prj');
            if (poModal) {
                const isCloseBtnPo = e.target.id === 'PO_qt_prj_close' || e.target.closest('#PO_qt_prj_close');
                const clickedOutsidePo = e.target === poModal;
                if (isCloseBtnPo || clickedOutsidePo) {
                    closePrjPoModal();
                }
            }

            const grnModal = document.getElementById('grnDetailsModal');
            if (grnModal) {
                const isCloseBtnGrn = e.target.id === 'grnDetailsModal_close' || e.target.closest('#grnDetailsModal_close');
                const clickedOutsideGrn = e.target === grnModal;
                if (isCloseBtnGrn || clickedOutsideGrn) {
                    closePrjGrnModal();
                }
            }
        });


    </script>
</body>
</html>