<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cut Order Issued</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://kit.fontawesome.com/a2e0e6ad65.js" crossorigin="anonymous"></script>
    <style>
        .cut-table-wrapper {
            max-height: 500px;
            overflow-y: auto;
        }
        .cut-table thead th {
            position: sticky;
            top: 0;
            z-index: 10;
            background-color: #eff6ff; /* blue-50 */
        }
        .cut-table tfoot td {
            position: sticky;
            bottom: 0;
            z-index: 10;
            background-color: #f9fafb; /* gray-50 */
        }
        .cut-table .po-tooltip {
            z-index: 50;
        }
    </style>
</head>

<body class="bg-gray-50">

    @include('LifeAtGainup.Planning.GUTplanning.Gutplan_nav')

<div class="p-4">

    <div class="flex items-center gap-4 mb-3">
        <div class="text-gray-500 text-sm">
            <a href="/gutplan" class="text-gray-500 hover:text-gray-700">
                Order Management
            </a>
            &gt;
            <span class="text-gray-700 font-medium">Cut Order Issued</span>
        </div>
        <div class="h-4 w-px bg-gray-300"></div>
        <p class="text-gray-500 font-bold text-base">for <span class="ccno-display font-bold text-base"></span></p>
        <div class="h-4 w-px bg-gray-300"></div>
        <p class="text-gray-500 text-xs">View and track your cut orders.</p>
    </div>

    <!-- Title + Back Button -->
    <div class="flex justify-between items-center mb-4 hidden">
        <div>
            <h1 class="text-2xl font-semibold">Cut Order Issued</h1>
            <p class="text-gray-500 text-sm mt-1"><span id="orderIdLabel">Order ID:</span> <span id="orderIdValue">114227-Purple</span></p>
        </div>

        <a href="/gutplan"
            class="inline-flex items-center px-3 py-1.5 rounded-md border border-gray-300 bg-white 
                   text-xs font-medium text-gray-700 hover:bg-gray-50 shadow-sm">
            <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                      d="M10 19l-7-7m0 0l7-7m7 7H3">
                </path>
            </svg>
            Back to Orders
        </a>
    </div>

    <!-- Search Bar -->
    <div class="mb-3 flex justify-end">
        <input
            type="text"
            id="cutTableSearch"
            class="w-64 px-3 py-2 text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
            placeholder="Search">
    </div>

    <!-- Table -->
    <div class="bg-white rounded-lg border border-gray-200 overflow-hidden">
        
        <table id="cutOrderTable" class="w-full border-collapse cut-table">

            <!-- HEADER -->
            <thead class="bg-blue-50 border-b border-gray-200">
            <tr id="cutTableHeaderRow">
            </tr>
            </thead>

            <!-- BODY -->
            <tbody class="text-sm" id="cutTableBody">
            </tbody>

            <!-- FOOTER TOTALS -->
            <tfoot class="bg-gray-50 font-semibold text-sm" id="cutTableFooterRow">
            </tfoot>
        </table>
        
    </div>

</div>
<script>
    $(document).ready(function () {
        const costno = localStorage.getItem('selectedCostNo');
        const ccno = localStorage.getItem('selectedCcNo');
        const color = localStorage.getItem('selectedColor');
        const portalType = localStorage.getItem('portalType') || 'gut_new';
        const modal = localStorage.getItem('selectedmodal');
		const season = localStorage.getItem('selectedseason');

        if ((color || ccno) && modal && season) {
            const displayValue = `${color} | ${modal} | ${season} `;
            $('#orderIdValue').text(displayValue);
            $('.ccno-display').text(displayValue);
        } else if (color) {
            $('#orderIdValue').text(color);
            $('.ccno-display').text(color);
        } else if (ccno) {
            $('#orderIdValue').text(ccno);
            $('.ccno-display').text(ccno);
        }

        $('#cutTableHeaderRow').html('');
        $('#cutTableBody').html('<tr><td colspan="6" class="px-3 py-6 text-center text-gray-500">Loading cut order details...</td></tr>');

        // Simple client-side search filter across all columns
        $('#cutTableSearch').on('keyup', function () {
            const query = $(this).val().toLowerCase();
            let anyVisible = false;

            // Hide/show data rows based on query
            $('#cutTableBody tr').each(function () {
                const $row = $(this);

                // Skip the special no-match row if it exists
                if ($row.hasClass('no-match-row')) {
                    return;
                }

                const rowText = $row.text().toLowerCase();
                const isMatch = query === '' || rowText.indexOf(query) !== -1;
                $row.toggle(isMatch);
                if (isMatch) {
                    anyVisible = true;
                }
            });

            // Manage the "No matches" row
            let $noMatchRow = $('#cutTableBody tr.no-match-row');
            const colCount = $('#cutTableHeaderRow th').length || 1;

            if (!$noMatchRow.length) {
                $('#cutTableBody').append(
                    `<tr class="no-match-row" style="display:none;"><td colspan="${colCount}" class="px-3 py-3 text-center text-sm text-gray-500">No matches found</td></tr>`
                );
                $noMatchRow = $('#cutTableBody tr.no-match-row');
            }

            // Show "No matches" only when there are no visible rows and query is not empty
            if (!anyVisible && query !== '') {
                $noMatchRow.show();
            } else {
                $noMatchRow.hide();
            }
        });

        function formatDate(dateString) {
            const d = new Date(dateString);
            const day = String(d.getDate()).padStart(2, '0');
            const month = String(d.getMonth() + 1).padStart(2, '0');
            const year = String(d.getFullYear()).slice(2); // last 2 digits
            return `${day}-${month}-${year}`;
        }




        $.ajax({
            url: '/cut_details',
            method: 'GET',
            data: {
                costno: costno,
                portaltype: portalType
            },
            success: function (response) {
                if (!response || !response.success || !response.data || !response.data.length) {
                    $('#cutTableHeaderRow').html('');
                    $('#cutTableBody').html('<tr><td colspan="6" class="px-3 py-6 text-center text-gray-500">No cut order data available for the selected cost.</td></tr>');
                    return;
                }

                const firstItem = response.data[0];

                const staticFields = [
                    'Cut_No','CO_No','Co_No','CutOrd_No',
                    'Total_Cut_Qty','Total_Qty','Total',
                    'Cut_Week','Week','Cut_Date',
                    'Po','POs','Po_Nos',
                    'Approval','Approval1','Status','Cost_ID'
                ];

                const allKeys = Object.keys(firstItem);
                const sizeKeys = allKeys.filter(function (key) {
                    return staticFields.indexOf(key) === -1;
                });

                // Build header row: CO#, CO Week, dynamic sizes, Total, POs, Approval, Status
                let headerHtml = '';
                headerHtml += '<th class="px-3 py-3 text-left text-xs font-medium text-blue-600">CO #</th>';
                headerHtml += '<th class="px-3 py-3 text-left text-xs font-medium text-blue-600">CO Date</th>';
                headerHtml += '<th class="px-3 py-3 text-left text-xs font-medium text-blue-600">CO Week Coverage</th>';
                sizeKeys.forEach(function (key) {
                    headerHtml += `<th class="px-3 py-3 text-center text-xs font-medium text-blue-600">${key}</th>`;
                });
                headerHtml += '<th class="px-3 py-3 text-center text-xs font-medium text-blue-600">Total</th>';
                headerHtml += '<th class="px-3 py-3 text-center text-xs font-medium text-blue-600">POs</th>';
              

                $('#cutTableHeaderRow').html(headerHtml);

                let rows = '';

                // Initialize totals for size columns and overall total
                const sizeTotals = {};
                sizeKeys.forEach(function (key) { sizeTotals[key] = 0; });
                let grandTotal = 0;

                

                response.data.forEach(function (item) {
                    const coNo = item.Cut_No || item.CO_No || item.Co_No || item.CutOrd_No || '-';
                    const weekCoverage = item.Cut_Week || item.Week || '-';
                    const total = item.Total_Cut_Qty || item.Total_Qty || item.Total || '';
                    const cutdate = item.Cut_Date ? formatDate(item.Cut_Date) : '--';

                    const poRaw = item.Po || item.POs || item.Po_Nos || '';
                    const approvalRaw = item.Approval1 || '';
                    const appstatus = item.Approval || '';
                    const statusRaw = item.Status || '';

                    let approvalText = approvalRaw;
                    if (approvalRaw === 'T') {
                        approvalText = 'Approved';
                    } else if (approvalRaw === 'F') {
                        approvalText = 'Pending';
                    }

                    const statusText = statusRaw || 'Pending';
                    let statusClass = 'bg-gray-100 text-gray-700';
                    if (statusRaw && statusRaw.toLowerCase() === 'completed') {
                        statusClass = 'bg-green-100 text-green-700';
                    } else if (!statusRaw) {
                        statusClass = 'bg-yellow-100 text-yellow-700';
                    }

                    rows += '<tr class="border-b border-gray-200">';
                    rows += `<td class="px-3 py-3 text-sm">${coNo}</td>`;
                    rows += `<td class="px-3 py-3 text-sm">${cutdate}</td>`;
                    rows += `<td class="px-3 py-3 text-sm">${weekCoverage}</td>`;

                    sizeKeys.forEach(function (key) {
                        const rawVal = item[key] !== null && item[key] !== undefined ? item[key] : '';
                        const numVal = parseFloat(String(rawVal).replace(/,/g, '')) || 0;
                        sizeTotals[key] += numVal;
                        rows += `<td class="px-3 py-3 text-sm text-center">${rawVal || '-'}</td>`;
                    });

                    const totalNum = parseFloat(String(total).replace(/,/g, '')) || 0;
                    grandTotal += totalNum;
                    rows += `<td class="px-3 py-3 text-sm text-center font-semibold">${total}</td>`;

                    const poDisplay = poRaw || '';
                    rows += `
                        <td class="px-3 py-3 text-sm text-center">
                            <div class="relative group inline-block">
                                <div class="h-5 w-5 border border-gray-300 rounded-full flex items-center justify-center text-gray-500 text-xs cursor-pointer hover:bg-gray-100">i</div>
                                <div class="absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2 px-3 py-2 bg-gray-800 text-white text-xs rounded-lg opacity-0 group-hover:opacity-100 transition-opacity duration-200 whitespace-nowrap po-tooltip">
                                    ${poDisplay ? poDisplay : 'No POs'}
                                    <div class="absolute top-full left-1/2 transform -translate-x-1/2 -mt-1">
                                        <div class="w-0 h-0 border-l-4 border-r-4 border-t-4 border-transparent border-t-gray-800"></div>
                                    </div>
                                </div>
                            </div>
                        </td>`;

                    rows += '</tr>';
                });

                // Build footer totals row
                let footerHtml = '';
                footerHtml += '<tr>';
                footerHtml += '<td class="px-3 py-3 text-sm font-semibold text-right" colspan="3">Total</td>';

                sizeKeys.forEach(function (key) {
                    const sum = sizeTotals[key];
                    footerHtml += `<td class="px-3 py-3 text-sm text-center">${sum ? Math.round(sum) : '-'}</td>`;
                });

                footerHtml += `<td class="px-3 py-3 text-sm text-center font-bold">${grandTotal ? Math.round(grandTotal) : ''}</td>`;
                footerHtml += '<td class="px-3 py-3 text-sm"></td>'; // POs footer empty
               
                footerHtml += '</tr>';

                $('#cutTableBody').html(rows);
                $('#cutTableFooterRow').html(footerHtml);

                
            },
            error: function () {
                $('#cutTableHeaderRow').html('');
                $('#cutTableBody').html('<tr><td colspan="6" class="px-3 py-6 text-center text-red-500">Error loading cut order data. Please try again.</td></tr>');
                $('#cutTableFooterRow').html('');
            }
        });
    });
</script>

</body>
</html>
