<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Details</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<style>
    #orderPopup .popup-header {
        padding: 8px 16px; /* Reduced header height */
    }
    #orderPopup h2 {
        margin-bottom: 1px;
        font-size: 18px;
    }
    #orderPopup #tabContent {
        margin-top: 8px; /* reduce gap */
        height: calc(100% - 90px); /* auto fit */
        overflow-y: auto;
    }
    
    /* Special dimensions for OB tab - wider and shorter */
    #orderPopup.ob-tab-active .popup-container {
        width: 68%;
        max-width: 95vw;
        height: 80vh;
    }
    
    /* Special dimensions for BOM tab - shorter height */
    #orderPopup.bom-tab-active .popup-container {
        width: 68%;
        max-width: 95vw;
        height: 70vh;
    }
    
    /* Default popup dimensions */
    #orderPopup .popup-container {
        width: 68%;
        max-width: 1800px;
        height: 106vh;
    }
    
    /* Compact OB content styling */
    #orderPopup.ob-tab-active .bg-gradient-to-r {
        padding: 12px !important;
    }
    
    #orderPopup.ob-tab-active .text-5xl {
        font-size: 2.5rem !important;
    }
    
    #orderPopup.ob-tab-active .px-6 {
        padding-left: 12px !important;
        padding-right: 12px !important;
    }
    
    #orderPopup.ob-tab-active .py-4 {
        padding-top: 8px !important;
        padding-bottom: 8px !important;
    }
    
    #orderPopup.ob-tab-active .px-5 {
        padding-left: 8px !important;
        padding-right: 8px !important;
    }
    
    #orderPopup.ob-tab-active .py-3 {
        padding-top: 6px !important;
        padding-bottom: 6px !important;
    }
    
    #orderPopup.ob-tab-active .px-4 {
        padding-left: 8px !important;
        padding-right: 8px !important;
    }
    
    #orderPopup.ob-tab-active .p-6 {
        padding: 12px !important;
    }
    
    #orderPopup.ob-tab-active .p-20 {
        padding: 40px !important;
    }
    
    #orderPopup.ob-tab-active .gap-8 {
        gap: 16px !important;
    }
    
    #orderPopup.ob-tab-active .gap-6 {
        gap: 12px !important;
    }
    
    #orderPopup.ob-tab-active .gap-3 {
        gap: 8px !important;
    }
    
    #orderPopup.ob-tab-active .mb-6 {
        margin-bottom: 12px !important;
    }
    
    #orderPopup.ob-tab-active .mt-6 {
        margin-top: 12px !important;
    }
    
    #orderPopup.ob-tab-active .mt-2 {
        margin-top: 4px !important;
    }
    
    #orderPopup.ob-tab-active .text-lg {
        font-size: 14px !important;
    }
    
    #orderPopup.ob-tab-active .text-sm {
        font-size: 12px !important;
    }
    
    #orderPopup.ob-tab-active .text-xl {
        font-size: 16px !important;
    }
    
    #orderPopup.ob-tab-active td, #orderPopup.ob-tab-active th {
        font-size: 12px !important;
    }
    
    #orderPopup.ob-tab-active .w-10 {
        width: 32px !important;
        height: 32px !important;
    }
    
    #orderPopup.ob-tab-active .rounded-full {
        font-size: 10px !important;
    }

    /* For Chrome, Safari, Edge */
    ::-webkit-scrollbar {
    display: none;
    }

    /* For Firefox */
    * {
    scrollbar-width: none;
    }
</style>
<body class="bg-gray-100">

    @include('LifeAtGainup.Planning.GUTplanning.Gutplan_nav')

    <div class="px-8 py-4">

        <!-- Breadcrumb + Order popup link -->
        <div class="flex items-center justify-between mb-2">
            <div class="flex items-center gap-4">
                <div class="text-gray-500 text-m">
                    <a href="/gutplan" class="text-gray-500 hover:text-gray-700">
                        Order Management
                    </a>
                    &gt;
                    <span class="text-black-700 font-medium">Order Details</span>
                </div>
                <div class="h-4 w-px bg-gray-300"></div>
                <p class="text-gray-500 text-xs">View and manage your material order details.</p>
            </div>

            <button
                id="openOrderPopupLink"
                type="button"
                class="flex items-center py-2 px-3 gap-1 rounded text-sm bg-blue-800 text-white hover:bg-blue-500">
                <span>OB Details</span>
                <i class="fas fa-external-link"></i>
            </button>
        </div>

        

      <div class="bg-white rounded-lg shadow-md p-6">
        <!-- Selected filters / CC display (can wrap on multiple lines) -->
        <div class="mb-3 text-sm font-bold text-gray-700">
            <span class="font-semibold">Search Result: </span>
            <span class="font-semibold break-words" id="colordisplay"></span>
        </div>
        <!-- Main Card -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 px-6 py-5 mb-6">

            <!-- Top row: Selection / PMU / CC & Color -->
            <div class="flex items-start justify-between mb-2">

                <div class="flex items-center gap-4">
                    <!-- Selection Qty -->
                    <div class="bg-blue-50 border border-blue-100 rounded-lg px-6 py-3 min-w-[130px] text-center">
                        <p class="text-[11px] tracking-wide text-gray-500 font-medium mb-1">Selection Qty</p>
                        <p id="selectionQtyValue" class="text-2xl font-bold text-gray-800">0</p>
                    </div>

                    <!-- PRJ Qty -->
                    <div class="bg-blue-50 border border-blue-100 rounded-lg px-6 py-3 min-w-[130px] text-center">
                        <p class="text-[11px] tracking-wide text-gray-500 font-medium mb-1">PRJ Qty</p>
                        <p id="prjQtyValue" class="text-2xl font-bold text-gray-800">0</p>
                    </div>

                    <!-- PRJ PO Qty -->
                    <div class="bg-blue-50 border border-blue-100 rounded-lg px-6 py-3 min-w-[130px] text-center">
                        <p class="text-[11px] tracking-wide text-gray-500 font-medium mb-1">Conf. PO Qty</p>
                        <p id="confpoValue" class="text-2xl font-bold text-gray-800">0</p>
                    </div>

                    <!-- PRJ GRN Qty -->
                    <div class="bg-blue-50 border border-blue-100 rounded-lg px-6 py-3 min-w-[130px] text-center">
                        <p class="text-[11px] tracking-wide text-gray-500 font-medium mb-1">Prod Qty</p>
                        <p id="prodQtyValue" class="text-2xl font-bold text-gray-800">0</p>
                    </div>
                </div>

                <!-- CC & Color selectors as dropdown filter panels + Submit -->
                <div class="flex items-end gap-2">

                    <!-- CC: single-select custom dropdown panel -->
                    <div class="relative">

                        <p class="text-[11px] text-gray-500 mb-1">CC No.</p>
                        <button type="button" id="ccFilterToggle"
                                class="min-w-[140px] border border-gray-300 rounded-md px-3 py-2 text-sm flex items-center justify-between bg-white focus:ring-1 focus:ring-blue-400 focus:border-blue-400">
                            <span id="ccFilterLabel" class="truncate">All CC</span>
                            <span class="text-gray-500 text-xs">▾</span>
                        </button>

                        <div id="ccFilterPanel"
                             class="absolute left-0 mt-1 w-56 bg-white border border-gray-200 rounded-md shadow-lg z-30 hidden">
                            <div class="px-3 pt-2 pb-1 border-b border-gray-200">
                                <input id="ccFilterSearch" type="text" placeholder="Search CC..."
                                       class="w-full border border-gray-200 rounded-md px-2 py-1 text-xs focus:outline-none focus:ring-1 focus:ring-blue-400 focus:border-blue-400" />
                            </div>
                            <div id="ccFilterOptions" class="max-h-56 overflow-y-auto px-3 py-2 space-y-1">
                                <!-- CC options injected by JS -->
                            </div>
                        </div>
                    </div>

                    <!-- Model / Color: multi-checkbox dropdown filter -->
                    <div class="relative">

                        <p class="text-[11px] text-gray-500 mb-1">Model / Color</p>
                        <button type="button" id="modelFilterToggle"
                                class="min-w-[180px] border border-gray-300 rounded-md px-3 py-2 text-sm flex items-center justify-between bg-white focus:ring-1 focus:ring-blue-400 focus:border-blue-400">
                            <span id="modelFilterLabel" class="truncate">All Models</span>
                            <span class="text-gray-500 text-xs">▾</span>
                        </button>

                        <div id="modelFilterPanel"
                             class="absolute left-0 mt-1 w-64 bg-white border border-gray-200 rounded-md shadow-lg z-30 hidden">
                            <div class="px-3 pt-2 pb-1 border-b border-gray-200">
                                <input id="modelFilterSearch" type="text" placeholder="Search models..."
                                       class="w-full border border-gray-200 rounded-md px-2 py-1 text-xs focus:outline-none focus:ring-1 focus:ring-blue-400 focus:border-blue-400" />
                            </div>
                            <div id="modelFilterOptions" class="max-h-56 overflow-y-auto px-3 py-2 space-y-1">
                                <!-- Model/Color checkboxes injected by JS -->
                            </div>
                        </div>
                    </div>

                    <!-- Buyer: multi-checkbox dropdown filter (data to be wired later) -->
                    <div class="relative">

                        <p class="text-[11px] text-gray-500 mb-1">Buyer</p>
                        <button type="button" id="buyerFilterToggle"
                                class="min-w-[140px] border border-gray-300 rounded-md px-3 py-2 text-sm flex items-center justify-between bg-white focus:ring-1 focus:ring-blue-400 focus:border-blue-400">
                            <span id="buyerFilterLabel" class="truncate">All Buyers</span>
                            <span class="text-gray-500 text-xs">▾</span>
                        </button>

                        <div id="buyerFilterPanel"
                             class="absolute left-0 mt-1 w-56 bg-white border border-gray-200 rounded-md shadow-lg z-30 hidden">
                            <div class="px-3 pt-2 pb-1 border-b border-gray-200">
                                <input id="buyerFilterSearch" type="text" placeholder="Search buyers..."
                                       class="w-full border border-gray-200 rounded-md px-2 py-1 text-xs focus:outline-none focus:ring-1 focus:ring-blue-400 focus:border-blue-400" />
                            </div>
                            <div id="buyerFilterOptions" class="max-h-56 overflow-y-auto px-3 py-2 space-y-1">
                                <!-- Buyer checkboxes injected by JS -->
                            </div>
                        </div>
                    </div>

                    <!-- Season: multi-checkbox dropdown filter -->
                    <div class="relative">

                        <p class="text-[11px] text-gray-500 mb-1">Season</p>
                        <button type="button" id="seasonFilterToggle"
                                class="min-w-[140px] border border-gray-300 rounded-md px-3 py-2 text-sm flex items-center justify-between bg-white focus:ring-1 focus:ring-blue-400 focus:border-blue-400">
                            <span id="seasonFilterLabel" class="truncate">All Seasons</span>
                            <span class="text-gray-500 text-xs">▾</span>
                        </button>

                        <div id="seasonFilterPanel"
                             class="absolute left-0 mt-1 w-56 bg-white border border-gray-200 rounded-md shadow-lg z-30 hidden">
                            <div class="px-3 pt-2 pb-1 border-b border-gray-200">
                                <input id="seasonFilterSearch" type="text" placeholder="Search seasons..."
                                       class="w-full border border-gray-200 rounded-md px-2 py-1 text-xs focus:outline-none focus:ring-1 focus:ring-blue-400 focus:border-blue-400" />
                            </div>
                            <div id="seasonFilterOptions" class="max-h-56 overflow-y-auto px-3 py-2 space-y-1">
                                <!-- Season checkboxes injected by JS -->
                            </div>
                        </div>
                    </div>

                    <!-- Reset / Submit Filters beside filters -->
                    <div class="flex items-center gap-2 ml-4">
                        <button id="resetFiltersBtn" class="hidden px-3 py-1.5 text-xs border border-gray-300 rounded-md text-gray-700 hover:bg-gray-100">
                            Reset Filters
                        </button>
                        <button id="applyFiltersBtn" class="px-3 py-2 text-sm border border-blue-600 rounded-md text-white bg-blue-600 hover:bg-blue-500">
                            Submit
                        </button>
                    </div>

                </div>


            </div>

            

            <!-- Main Size Table -->
            <div class="overflow-x-auto relative min-h-[200px]">
                <!-- Dedicated loader for main table -->
                <div id="mainLoader" class="absolute inset-0 bg-white bg-opacity-80 flex items-center justify-center z-20 hidden">
                    <div class="flex items-center gap-3">
                        <svg class="animate-spin h-6 w-6 text-blue-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
                        </svg>
                        <span class="text-gray-700 font-medium">Loading...</span>
                    </div>
                </div>
                
                <table id="mainSizeTable" class="w-full text-xs border-collapse">
                    <thead id="tableHeader">
                        <!-- Headers will be populated dynamically -->
                    </thead>
                    <tbody id="tableBody" class="text-gray-700">
                        <!-- Table rows will be populated dynamically -->
                    </tbody>
                </table>
            </div>

        </div>

        <!-- Time-based Material alerts -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 px-6 py-5 mb-6">
            <div class="flex justify-between items-center mb-3">
                <h2 class="text-sm font-semibold text-gray-800">Time-based Material alerts</h2>
                <div class="flex items-center gap-3 text-xs" id="materialdatepicker">
                    <span class="text-gray-500">Select Date</span>
                    <input type="date" id="material_date" 
                        class="border border-gray-300 rounded-md px-3 py-1.5 text-xs focus:ring-1 focus:ring-blue-400 focus:border-blue-400" />
                </div>
            </div>

            <div class="overflow-x-auto relative min-h-[150px]">
                <!-- Dedicated loader -->
                <div id="materialLoader" class="absolute inset-0 bg-white bg-opacity-80 flex items-center justify-center z-20 hidden">
                    <div class="flex items-center gap-3">
                        <svg class="animate-spin h-6 w-6 text-blue-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
                        </svg>
                        <span class="text-gray-700 font-medium">Loading material data...</span>
                    </div>
                </div>

                <table class="w-full text-xs border-collapse" id="materialtable">
                    <thead>
                        
                    </thead>

                    <tbody class="text-gray-700">
                        <!-- Dynamic content will be populated here -->
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Time-based Production alerts -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 px-6 py-5 mb-10">
            <div class="flex justify-between items-center mb-3">
                <h2 class="text-sm font-semibold text-gray-800">Time-based Production alerts</h2>
                <div class="flex items-center gap-3 text-xs" id="productiondatepicker">
                    <span class="text-gray-500">Select Date</span>
                    <input type="date" id="production_date" 
                        class="border border-gray-300 rounded-md px-3 py-1.5 text-xs focus:ring-1 focus:ring-blue-400 focus:border-blue-400" />
                </div>
            </div>

            <div class="overflow-x-auto relative min-h-[150px]">
                <!-- Dedicated loader -->
                <div id="productionLoader" class="absolute inset-0 bg-white bg-opacity-80 flex items-center justify-center z-20 hidden">
                    <div class="flex items-center gap-3">
                        <svg class="animate-spin h-6 w-6 text-blue-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
                        </svg>
                        <span class="text-gray-700 font-medium">Loading production data...</span>
                    </div>
                </div>

                <table class="w-full text-xs border-collapse" id="productiontable">
                    <thead>
                        
                    </thead>

                    <tbody class="text-gray-700">
                        <!-- Dynamic content will be populated here -->
                    </tbody>
                </table>
            </div>
        </div>

    </div>

    <!-- Popup Overlay -->
    <div id="orderPopup" class="fixed inset-0 bg-black bg-opacity-60 flex items-center justify-center z-50 hidden">
        <div class="popup-container bg-white rounded-2xl shadow-2xl flex flex-col overflow-hidden animate-[fadeIn_0.2s_ease-out]">


            <!-- HEADER -->
            <div class="popup-header flex justify-between items-start">
                <div class="flex items-center gap-4" id="popupHeaderContent">
                    <div>
                        <div class="flex">
                            <h2 class="text-xl font-semibold text-gray-900">Loading...</h2>
                            <h3 class="text-lg font-semibold text-gray-800">(Loading...)</h3>
                        </div> 
                        <p class="text-sm text-gray-500">Loading...</p>   
                    </div>
                </div>
                <div class="flex items-center gap-3">
                    <div id="popupTabs" class="flex bg-gray-100 rounded-lg text-sm font-medium overflow-hidden">
                        <button data-tab="ta" class="tab-btn px-4 py-1 text-gray-600 hidden">T&A Plan</button>
                        <button data-tab="ob" class="tab-btn px-4 py-1 bg-blue-600 text-white">OB</button>
                        <button data-tab="bom" class="tab-btn px-4 py-1 text-gray-600">BOM</button>
                        <button data-tab="ram" class="tab-btn px-4 py-1 text-gray-600 hidden">Ramp-up</button>
                    </div>

                    <button onclick="closePopup()" class="text-gray-500 text-xl font-bold hover:text-black">
                        ✕
                    </button>
                </div>

            </div>

            <div id="tabContent" class="mt-2">
                <div id="taContent" class="tab-pane hidden">
                    <!-- INFO CARDS -->
                    <div class="grid grid-cols-5 gap-3 mt-6">
                        <div class="bg-gray-100 p-4 rounded-lg">
                            <p class="text-xs text-gray-500">Season</p>
                            <p class="text-lg font-semibold text-gray-800">AW-25</p>
                        </div>

                        <div class="bg-gray-100 p-4 rounded-lg">
                            <p class="text-xs text-gray-500">Style</p>
                            <p class="text-lg font-semibold text-gray-800">Padded Jacket</p>
                        </div>

                        <div class="bg-gray-100 p-4 rounded-lg">
                            <p class="text-xs text-gray-500">Selection Qty</p>
                            <p class="text-lg font-semibold text-gray-800">85,000</p>
                        </div>

                        <div class="bg-gray-100 p-4 rounded-lg">
                            <p class="text-xs text-gray-500">Budgeted Efficiency</p>
                            <p class="text-lg font-semibold text-gray-800">75%</p>
                        </div>

                        <div class="border border-yellow-300 bg-yellow-50 p-4 rounded-lg text-center">
                            <p class="text-xs text-gray-700 flex justify-center items-center gap-1">
                                Process Batch Size
                                <span class="text-yellow-600">ⓘ</span>
                            </p>
                            <p class="text-2xl font-semibold text-gray-800">17,000</p>
                        </div>
                    </div>

                    <!-- TABLE -->
                    <div class="mt-6 border rounded-lg overflow-hidden">
                        <table class="w-full text-sm">
                            <thead class="bg-gray-100 text-gray-700">
                                <tr>
                                    <th class="px-4 py-2 text-left">Process</th>
                                    <th class="px-4 py-2">SAM</th>
                                    <th class="px-4 py-2">Min Run Days</th>
                                    <th class="px-4 py-2">Calculated MOQ</th>
                                    <th class="px-4 py-2">Duration</th>
                                    <th class="px-4 py-2">Earliest Start</th>
                                    <th class="px-4 py-2">Latest Start</th>
                                    <th class="px-4 py-2">Scheduled Start</th>
                                    <th class="px-4 py-2">Scheduled End</th>
                                </tr>
                            </thead>

                            <tbody>
                                <tr class="border-t">
                                    <td class="px-4 py-3">Cutting</td>
                                    <td class="text-center">5</td>
                                    <td class="text-center"><input class="w-16 border rounded-md px-2 py-1 text-sm"></td>
                                    <td class="text-center">0</td>
                                    <td class="text-center">-</td>
                                    <td class="text-center">-</td>
                                    <td class="text-center">-</td>
                                    <td class="text-center text-gray-400">Not set</td>
                                    <td class="text-center text-gray-400">Not set</td>
                                </tr>

                                <tr class="border-t">
                                    <td class="px-4 py-3">Sewing</td>
                                    <td class="text-center">15</td>
                                    <td class="text-center"><input class="w-16 border rounded-md px-2 py-1 text-sm"></td>
                                    <td class="text-center">0</td>
                                    <td class="text-center">-</td>
                                    <td class="text-center">-</td>
                                    <td class="text-center">-</td>
                                    <td class="text-center text-gray-400">Not set</td>
                                    <td class="text-center text-gray-400">Not set</td>
                                </tr>

                                <tr class="border-t">
                                    <td class="px-4 py-3">Packing</td>
                                    <td class="text-center">2</td>
                                    <td class="text-center"><input class="w-16 border rounded-md px-2 py-1 text-sm"></td>
                                    <td class="text-center">0</td>
                                    <td class="text-center">-</td>
                                    <td class="text-center">-</td>
                                    <td class="text-center">-</td>
                                    <td class="text-center text-gray-400">Not set</td>
                                    <td class="text-center text-gray-400">Not set</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div id="obContent" class="tab-pane active">
                    <div class="p-4">

                        <!-- TOP SUMMARY -->
                        <div class="bg-gray-50 rounded-xl border p-6 mb-6 w-full">

                            <div class="grid grid-cols-12 gap-6 items-start">

                                <!-- Total SAM -->
                                <div class="col-span-4">
                                    <div class="flex items-start">
                                        <div class="pr-8 border-r">
                                            <p class="text-sm text-gray-500">Total SAM</p>
                                            <p class="text-4xl font-bold text-gray-800">45.00</p>
                                        </div>
                                        <div class="pl-8">
                                            <p class="text-sm text-gray-500">Total Tailors</p>
                                            <p class="text-4xl font-bold text-gray-800">25</p>
                                        </div>
                                    </div>
                                </div>

                                <!-- Total Tailors -->
                                <!-- Tailor Grades -->
                                <div class="col-span-8">
                                    <p class="text-sm text-gray-500 mb-2">Tailor Grades</p>
                                    <div class="flex flex-wrap gap-2">
                                        <span class="px-3 py-1 rounded-full text-sm font-semibold bg-gray-200 text-gray-900">A: 3</span>
                                        <span class="px-3 py-1 rounded-full text-sm font-semibold bg-gray-200 text-gray-900">B: 3</span>
                                        <span class="px-3 py-1 rounded-full text-sm font-semibold bg-gray-200 text-gray-900">C: 2</span>
                                        <span class="px-3 py-1 rounded-full text-sm font-semibold bg-gray-200 text-gray-900">D: 0</span>
                                    </div>
                                    <hr class="border-gray-200 my-4">
                                    <p class="text-sm text-gray-500 mb-2">Machine Types</p>
                                    <div class="flex flex-wrap gap-2">
                                        <span class="px-3 py-1 rounded-full text-sm font-semibold bg-gray-200 text-gray-900">Cutting Machine Alpha: 1</span>
                                        <span class="px-3 py-1 rounded-full text-sm font-semibold bg-gray-200 text-gray-900">CSM: 1</span>
                                        <span class="px-3 py-1 rounded-full text-sm font-semibold bg-gray-200 text-gray-900">SNLS: 3</span>
                                        <span class="px-3 py-1 rounded-full text-sm font-semibold bg-gray-200 text-gray-900">OLM: 2</span>
                                        <span class="px-3 py-1 rounded-full text-sm font-semibold bg-gray-200 text-gray-900">FLM: 1</span>
                                    </div>
                                </div>
                            </div>

                        </div>


                        <!-- TABLE -->
                        <div class="border rounded-xl overflow-hidden bg-white w-full shadow-sm">
                            <table class="w-full text-sm">
                                <thead class="bg-blue-50 text-gray-700">
                                    <tr>
                                        <th class="px-4 py-3 text-left">Operation</th>
                                        <th class="px-4 py-3 text-left">Machine</th>
                                        <th class="px-4 py-3 text-center">Grade</th>
                                        <th class="px-4 py-3 text-center">Operators</th>
                                        <th class="px-4 py-3 text-center">Time (SAM)</th>
                                    </tr>
                                </thead>

                                <tbody>

                                    <tr class="border-t hover:bg-blue-50">
                                        <td class="px-4 py-3">Shell & Lining Cutting</td>
                                        <td class="px-4 py-3">Cutting Machine Alpha</td>
                                        <td class="text-center"><span class="inline-flex items-center justify-center w-6 h-6 rounded-full bg-gray-100 border border-gray-300 text-xs font-semibold text-gray-700">B</span></td>
                                        <td class="text-center">2</td>
                                        <td class="text-center">5.00</td>
                                    </tr>

                                    <tr class="border-t hover:bg-blue-50">
                                        <td class="px-4 py-3">Padding Cutting & Quilting</td>
                                        <td class="px-4 py-3">Chain Stitch Machine</td>
                                        <td class="text-center"><span class="inline-flex items-center justify-center w-6 h-6 rounded-full bg-gray-100 border border-gray-300 text-xs font-semibold text-gray-700">A</span></td>
                                        <td class="text-center">4</td>
                                        <td class="text-center">8.00</td>
                                    </tr>

                                    <tr class="border-t hover:bg-blue-50">
                                        <td class="px-4 py-3">Front Pocket Setting</td>
                                        <td class="px-4 py-3">Single Needle Lock Stitch</td>
                                        <td class="text-center"><span class="inline-flex items-center justify-center w-6 h-6 rounded-full bg-gray-100 border border-gray-300 text-xs font-semibold text-gray-700">B</span></td>
                                        <td class="text-center">3</td>
                                        <td class="text-center">4.50</td>
                                    </tr>

                                    <tr class="border-t hover:bg-blue-50">
                                        <td class="px-4 py-3">Front Zipper Attachment</td>
                                        <td class="px-4 py-3">Single Needle Lock Stitch</td>
                                        <td class="text-center"><span class="inline-flex items-center justify-center w-6 h-6 rounded-full bg-gray-100 border border-gray-300 text-xs font-semibold text-gray-700">A</span></td>
                                        <td class="text-center">3</td>
                                        <td class="text-center">5.00</td>
                                    </tr>

                                    <tr class="border-t hover:bg-blue-50">
                                        <td class="px-4 py-3">Sleeve Assembly</td>
                                        <td class="px-4 py-3">Over Lock Machine</td>
                                        <td class="text-center"><span class="inline-flex items-center justify-center w-6 h-6 rounded-full bg-gray-100 border border-gray-300 text-xs font-semibold text-gray-700">C</span></td>
                                        <td class="text-center">4</td>
                                        <td class="text-center">6.00</td>
                                    </tr>

                                    <tr class="border-t hover:bg-blue-50">
                                        <td class="px-4 py-3">Sleeve Attachment to Body</td>
                                        <td class="px-4 py-3">Over Lock Machine</td>
                                        <td class="text-center"><span class="inline-flex items-center justify-center w-6 h-6 rounded-full bg-gray-100 border border-gray-300 text-xs font-semibold text-gray-700">B</span></td>
                                        <td class="text-center">4</td>
                                        <td class="text-center">5.50</td>
                                    </tr>

                                    <tr class="border-t hover:bg-blue-50">
                                        <td class="px-4 py-3">Joining Shell and Lining</td>
                                        <td class="px-4 py-3">Single Needle Lock Stitch</td>
                                        <td class="text-center"><span class="inline-flex items-center justify-center w-6 h-6 rounded-full bg-gray-100 border border-gray-300 text-xs font-semibold text-gray-700">A</span></td>
                                        <td class="text-center">3</td>
                                        <td class="text-center">7.00</td>
                                    </tr>

                                    <tr class="border-t hover:bg-blue-50">
                                        <td class="px-4 py-3">Cuff & Hem Finishing</td>
                                        <td class="px-4 py-3">Flat Lock Machine</td>
                                        <td class="text-center"><span class="inline-flex items-center justify-center w-6 h-6 rounded-full bg-gray-100 border border-gray-300 text-xs font-semibold text-gray-700">C</span></td>
                                        <td class="text-center">2</td>
                                        <td class="text-center">4.00</td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>

                    </div>
                </div> 

                <div id="bomContent" class="tab-pane hidden">
                    <div class="p-4">
                        <div id="bomLoading" class="text-center py-20">
                            <i class="fas fa-spinner fa-spin text-5xl text-blue-600"></i>
                            <p class="mt-4 text-xl text-gray-600">Loading BOM...</p>
                        </div>

                        <div class="border rounded-xl overflow-hidden bg-white" id="bomTableContainer">
                            <table class="w-full text-sm">

                                <thead class="bg-blue-50 text-gray-700 sticky top-0 z-10">
                                    <tr>
                                        <th class="px-4 py-3 text-left">Cmpt Name</th>
                                        <th class="px-4 py-3 text-center">Size Dep</th>
                                        <th class="px-4 py-3 text-center">Impt / Local</th>
                                        <th class="px-4 py-3 text-center">L Time</th>
                                        <th class="px-4 py-3 text-left">Supplier</th>
                                        <th class="px-4 py-3 text-center">PRJ / FRC</th>
                                    </tr>
                                </thead>

                                <tbody>

                                    <!-- ROW TEMPLATE -->
                                    <tr class="border-t">
                                        <td class="px-4 py-3">Insulation Padding (Down)</td>
                                        <td class="text-left">
                                            <div class="relative inline-block">
                                                <button class="dropdown-toggle px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2" data-type="yesno" data-value="Yes">
                                                    Yes
                                                    <span class="text-gray-500">▾</span>
                                                </button>
                                            </div>
                                        </td>
                                        <td class="text-center">Import</td>
                                        <td class="text-center">100 days</td>
                                        <td class="px-4 py-3">Feather Inc.</td>
                                        <td class="text-center">
                                            <button class="dropdown-toggle px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2" data-type="projfrc" data-value="Projection">
                                                Projection
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                    </tr>

                                    <tr class="border-t">
                                        <td class="px-4 py-3">Shell Fabric (Nylon)</td>
                                        <td class="text-center">
                                            <button class="dropdown-toggle px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2" data-type="yesno" data-value="Yes">
                                                Yes
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                        <td class="text-center">Import</td>
                                        <td class="text-center">90 days</td>
                                        <td class="px-4 py-3">Global Textiles</td>
                                        <td class="text-center">
                                            <button class="dropdown-toggle px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2" data-type="projfrc" data-value="Projection">
                                                Projection
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                    </tr>

                                    <tr class="border-t">
                                        <td class="px-4 py-3">Main Zipper</td>
                                        <td class="text-center">
                                            <button class="dropdown-toggle px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2" data-type="yesno" data-value="No">
                                                No
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                        <td class="text-center">Import</td>
                                        <td class="text-center">60 days</td>
                                        <td class="px-4 py-3">YKK</td>
                                        <td class="text-center">
                                            <button class="dropdown-toggle px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2" data-type="projfrc" data-value="Projection">
                                                Projection
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                    </tr>

                                    <tr class="border-t">
                                        <td class="px-4 py-3">Pocket Zippers</td>
                                        <td class="text-center">
                                            <button class="dropdown-toggle px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2" data-type="yesno" data-value="No">
                                                No
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                        <td class="text-center">Import</td>
                                        <td class="text-center">60 days</td>
                                        <td class="px-4 py-3">YKK</td>
                                        <td class="text-center">
                                            <button class="dropdown-toggle px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2" data-type="projfrc" data-value="FRC">
                                                FRC
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                    </tr>

                                    <tr class="border-t">
                                        <td class="px-4 py-3">Brand Label</td>
                                        <td class="text-center">
                                            <button class="dropdown-toggle px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2" data-type="yesno" data-value="No">
                                                No
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                        <td class="text-center">Import</td>
                                        <td class="text-center">45 days</td>
                                        <td class="px-4 py-3">LabelMakers Inc.</td>
                                        <td class="text-center">
                                            <button class="dropdown-toggle px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2" data-type="projfrc" data-value="Projection">
                                                Projection
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                    </tr>

                                    <tr class="border-t">
                                        <td class="px-4 py-3">Care Label</td>
                                        <td class="text-center">
                                            <button class="px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2">
                                                No
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                        <td class="text-center">Import</td>
                                        <td class="text-center">45 days</td>
                                        <td class="px-4 py-3">LabelMakers Inc.</td>
                                        <td class="text-center">
                                            <button class="px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2">
                                                Projection
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                    </tr>

                                    <tr class="border-t">
                                        <td class="px-4 py-3">Lining Fabric (Polyester)</td>
                                        <td class="text-center">
                                            <button class="dropdown-toggle px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2" data-type="yesno" data-value="Yes">
                                                Yes
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                        <td class="text-center">Local</td>
                                        <td class="text-center">30 days</td>
                                        <td class="px-4 py-3">Local Weavers</td>
                                        <td class="text-center">
                                            <button class="dropdown-toggle px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2" data-type="projfrc" data-value="FRC">
                                                FRC
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                    </tr>

                                    <tr class="border-t">
                                        <td class="px-4 py-3">Cuff Elastic</td>
                                        <td class="text-center">
                                            <button class="px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2">
                                                No
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                        <td class="text-center">Local</td>
                                        <td class="text-center">20 days</td>
                                        <td class="px-4 py-3">Elasticorp</td>
                                        <td class="text-center">
                                            <button class="px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2">
                                                FRC
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                    </tr>

                                    <tr class="border-t">
                                        <td class="px-4 py-3">Sewing Thread</td>
                                        <td class="text-center">
                                            <button class="px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2">
                                                No
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                        <td class="text-center">Local</td>
                                        <td class="text-center">7 days</td>
                                        <td class="px-4 py-3">Stitch Co.</td>
                                        <td class="text-center">
                                            <button class="px-4 py-1 border rounded-lg bg-gray-50 flex items-center gap-2">
                                                FRC
                                                <span class="text-gray-500">▾</span>
                                            </button>
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>

                    </div>
                </div> 

                <div id="ramContent" class="tab-pane hidden">

                    <div class="p-6 space-y-6">

                        <!-- TOP CARDS -->
                        <div class="grid grid-cols-4 gap-4">
                            <div class="bg-gray-100 p-4 rounded-lg border text-sm">
                                <div class="text-gray-500">Budgeted Efficiency</div>
                                <div class="text-xl font-semibold mt-1">75%</div>
                            </div>

                            <div class="bg-gray-100 p-4 rounded-lg border text-sm">
                                <div class="text-gray-500">Total Production Days</div>
                                <div class="text-xl font-semibold mt-1">3541.67</div>
                            </div>

                            <div class="bg-gray-100 p-4 rounded-lg border text-sm">
                                <div class="text-gray-500">Weighted Avg. Efficiency</div>
                                <div class="text-xl font-semibold text-blue-600 mt-1">75.00%</div>
                            </div>

                            <div class="bg-gray-100 p-4 rounded-lg border text-sm">
                                <div class="text-gray-500">Number of Lines</div>
                                <div class="text-xl font-semibold mt-1">1</div>
                            </div>
                        </div>

                        <!-- LABELS -->
                        <div class="grid grid-cols-2 text-gray-600 text-sm font-medium mt-4">
                            <div>Day</div>
                            <div>Target Efficiency (%)</div>
                        </div>

                        <!-- DAY INPUT ROWS CONTAINER -->
                        <div id="dayContainer" class="space-y-4">

                            <div class="grid grid-cols-2 gap-4 day-row">
                                <input
                                    type="number"
                                    value="1"
                                    class="border rounded-lg px-3 py-2 w-full focus:ring focus:ring-blue-200 day-input"
                                />

                                <input
                                    type="number"
                                    value="75"
                                    class="border rounded-lg px-3 py-2 w-full focus:ring focus:ring-blue-200"
                                />
                            </div>

                        </div>


                        <!-- ADD DAY -->
                        <button class="text-blue-600 flex items-center gap-2 text-sm font-medium mt-2 add-day-btn">
                            <span class="text-lg">+</span> Add Day
                        </button>

                        <hr class="border-gray-200 mt-4">

                        <!-- SAVE BUTTON -->
                        <div class="flex justify-end">
                            <button class="bg-blue-600 text-white px-6 py-2 rounded-lg shadow hover:bg-blue-700">
                                Save Scheme
                            </button>
                        </div>

                    </div>

                </div>
                
            </div>    

        </div>
    </div>

    <script>
        function closePopup(){
            $('#orderPopup').addClass('hidden');
        }
       
        $(document).ready(function() {
            const today = new Date().toISOString().split('T')[0];
            $('#material_date').val(today);
            $('#production_date').val(today);

            const costno     = localStorage.getItem('selectedCostNo');
            const portaltype = localStorage.getItem('selectedportalType');

            if (!costno) {
                alert('No Cost No. selected. Please go back.');
                return;
            }

            // Load Selection & PRJ Qty
            $('#selectionQtyValue').text(formatIndian(localStorage.getItem('selectedSelectionQty') || 0));
            $('#prjQtyValue').text(formatIndian(localStorage.getItem('selectedPrjQty') || 0));
            $('#confpoValue').text(formatIndian(localStorage.getItem('selectedConfPo') || 0));
            $('#prodQtyValue').text(formatIndian(localStorage.getItem('selectedProdQty') || 0));
            $('#colordisplay').text(localStorage.getItem('selectedColor') +' | '+ localStorage.getItem('selectedmodel') +' | '+ localStorage.getItem('selectedseason'));

            // Active filter state for dropdown panels
            const activeFilters = {
                cc: new Set(),       // single-select semantics
                model: new Set(),
                buyer: new Set(),
                season: new Set()
            };

            let isFirstLoad = true;
            const storedCcFromLocal = localStorage.getItem('selectedCcNo') || '';

            function updateCcFilterLabel() {
                const labelEl = document.getElementById('ccFilterLabel');
                if (!labelEl) return;
                if (activeFilters.cc.size === 0) {
                    labelEl.textContent = 'All CC';
                } else {
                    labelEl.textContent = Array.from(activeFilters.cc)[0];
                }
            }

            function updateModelFilterLabel() {
                const labelEl = document.getElementById('modelFilterLabel');
                if (!labelEl) return;
                const count = activeFilters.model.size;
                if (count === 0) {
                    labelEl.textContent = 'All Models';
                } else if (count === 1) {
                    labelEl.textContent = Array.from(activeFilters.model)[0];
                } else {
                    labelEl.textContent = `${count} selected`;
                }
            }

            function updateSeasonFilterLabel() {
                const labelEl = document.getElementById('seasonFilterLabel');
                if (!labelEl) return;
                const count = activeFilters.season.size;
                if (count === 0) {
                    labelEl.textContent = 'All Seasons';
                } else if (count === 1) {
                    labelEl.textContent = Array.from(activeFilters.season)[0];
                } else {
                    labelEl.textContent = `${count} selected`;
                }
            }

            function updateBuyerFilterLabel() {
                const labelEl = document.getElementById('buyerFilterLabel');
                if (!labelEl) return;
                const count = activeFilters.buyer.size;
                if (count === 0) {
                    labelEl.textContent = 'All Buyers';
                } else if (count === 1) {
                    labelEl.textContent = Array.from(activeFilters.buyer)[0];
                } else {
                    labelEl.textContent = `${count} selected`;
                }
            }

            // Enable/disable Model/Buyer/Season filters based on CC selection
            function updateFilterEnabledState() {
                const hasCc = activeFilters.cc.size > 0;

                const toggleSelectors = ['#modelFilterToggle', '#buyerFilterToggle', '#seasonFilterToggle'];
                toggleSelectors.forEach(sel => {
                    const $btn = $(sel);
                    if (!$btn.length) return;
                    if (hasCc) {
                        $btn.prop('disabled', false)
                            .removeClass('opacity-50 cursor-not-allowed');
                    } else {
                        $btn.prop('disabled', true)
                            .addClass('opacity-50 cursor-not-allowed');
                    }
                });

                // When disabling, also make sure panels are closed
                if (!hasCc) {
                    $('#modelFilterPanel').addClass('hidden');
                    $('#buyerFilterPanel').addClass('hidden');
                    $('#seasonFilterPanel').addClass('hidden');
                }
            }

            // Main function to populate all dropdowns
            function applyOrderDropdownData(res, options = {}) {
                if (!res || !res.success) return;

                const clearSelection = options.clearSelection === true;
                const preserveLocalCc = options.preserveLocalCc !== false;

                // CC FILTER
                const $ccOptions = $('#ccFilterOptions');
                if ($ccOptions.length && Array.isArray(res.ccNo)) {
                    const uniqueCc = Array.from(new Set(res.ccNo)).filter(v => v);

                    let selectedCc = '';
                    if (isFirstLoad && preserveLocalCc && storedCcFromLocal && uniqueCc.includes(storedCcFromLocal)) {
                        selectedCc = storedCcFromLocal;
                    } else if (uniqueCc.length === 1) {
                        selectedCc = uniqueCc[0];
                    }

                    if (uniqueCc.length > 1) {
                        $ccOptions.empty();
                        uniqueCc.sort((a, b) => a.localeCompare(b, undefined, {numeric: true}));
                        uniqueCc.forEach(val => {
                            const $row = $('<div/>', {
                                class: 'flex items-center gap-2 text-[11px] py-0.5 cursor-pointer hover:bg-blue-50 px-1 rounded',
                                'data-cc-value': val,
                                text: val
                            });
                            if (val === selectedCc) $row.addClass('bg-blue-50 font-semibold');
                            $ccOptions.append($row);
                        });
                    } 

                    if (clearSelection) {
                        activeFilters.cc.clear();
                    } else if (selectedCc) {
                        activeFilters.cc.clear();
                        activeFilters.cc.add(selectedCc);
                    }
                    updateCcFilterLabel();
                }

                // MODEL / SEASON / BUYER
                const filters = [
                    { type: 'model',  data: res.model,   container: '#modelFilterOptions' },
                    { type: 'season', data: res.season,  container: '#seasonFilterOptions' },
                    { type: 'buyer',  data: res.dmiDsi,  container: '#buyerFilterOptions' }
                ];

                filters.forEach(item => {
                    const $cont = $(item.container);
                    if (!$cont.length || !Array.isArray(item.data) || item.data.length === 0) return;

                    $cont.empty();
                    const values = Array.from(new Set(item.data.filter(v => v)));

                    values.forEach(val => {
                        const $label = $('<label/>', { class: 'flex items-center gap-2 text-[11px] py-0.5 cursor-pointer' });
                        const $cb = $('<input/>', {
                            type: 'checkbox',
                            class: 'filter-checkbox',
                            'data-filter-key': item.type
                        }).val(val);

                        if (activeFilters[item.type].has(val)) {
                            $cb.prop('checked', true);
                        }

                        $label.append($cb)
                            .append(`<span class="truncate" title="${val}">${val}</span>`);
                        $cont.append($label);
                    });

                    if (clearSelection) activeFilters[item.type].clear();

                    if (item.type === 'model')  updateModelFilterLabel();
                    if (item.type === 'season') updateSeasonFilterLabel();
                    if (item.type === 'buyer')  updateBuyerFilterLabel();
                });

                updateFilterEnabledState();
           
            }

            // On-load: fetch order dropdown details (CC/model/buyer/season) for filters
            function loadOrderDropdownDetails(isUserAction = false) {
                const payload = {
                    cc: activeFilters.cc.size > 0 ? Array.from(activeFilters.cc)[0] : '',
                    model_color: Array.from(activeFilters.model),
                    buyer_name: Array.from(activeFilters.buyer),
                    season: Array.from(activeFilters.season)
                };

                $.ajax({
                    url: '/gut_order_dropdowndetails',
                    method: 'GET',
                    data: { cc: payload.cc },
                    success: function(res) {
                        // Only preserve localStorage CC on the very first load (not when auto-applying)
                        const preserveLocalCc = isFirstLoad && !isUserAction;
                        applyOrderDropdownData(res, { preserveLocalCc });

                        // AUTO-APPLY CC FROM LOCALSTORAGE (only once, on first load)
                        if (isFirstLoad && storedCcFromLocal) {
                            setTimeout(() => {
                                // 1. Select the CC in UI + state
                                activeFilters.cc.clear();
                                activeFilters.cc.add(storedCcFromLocal);
                                updateCcFilterLabel();
                                updateFilterEnabledState();

                                // 3. Trigger second API call with the selected CC
                                loadOrderDropdownDetails(true); // true = user-like action
                            }, 150); // slightly longer delay to ensure DOM is ready
                        }

                        // Turn off first-load mode ONLY after everything is done
                        if (isFirstLoad) {
                            isFirstLoad = false;
                        }
                    },
                    error: function() {
                        console.error('Failed to load dropdown data');
                        isFirstLoad = false; // prevent stuck state
                    }
                });
            }

            // After loadOrderDropdownDetails();
            loadOrderDropdownDetails();

            // Reset Filters button: send empty values and clear selections
            const resetBtn = document.getElementById('resetFiltersBtn');
            if (resetBtn) {
                resetBtn.addEventListener('click', function() {
                    // Clear all filters
                    activeFilters.cc.clear();
                    activeFilters.model.clear();
                    activeFilters.buyer.clear();
                    activeFilters.season.clear();

                    const cd = document.getElementById('colordisplay');
                    if (cd) cd.textContent = '';

                    // Update UI immediately
                    updateCcFilterLabel();
                    updateModelFilterLabel();
                    updateBuyerFilterLabel();
                    updateSeasonFilterLabel();
                    updateFilterEnabledState();

                    // Fetch fresh data with empty filters
                    $.ajax({
                        url: '/gut_order_dropdowndetails',
                        method: 'GET',
                        data: { cc: '', model_color: [], buyer_name: [], season: [] },
                        success: function(res) {
                            // Force clear + do NOT preserve old CC
                            applyOrderDropdownData(res, { clearSelection: true, preserveLocalCc: false });
                        }
                    });
                });
            }

            // Toggle handlers for filter panels
            $('#ccFilterToggle').on('click', function() {
                $('#ccFilterPanel').toggleClass('hidden');
            });

            $('#modelFilterToggle').on('click', function() {
                $('#modelFilterPanel').toggleClass('hidden');
            });

            $('#buyerFilterToggle').on('click', function() {
                $('#buyerFilterPanel').toggleClass('hidden');
            });

            $('#seasonFilterToggle').on('click', function() {
                $('#seasonFilterPanel').toggleClass('hidden');
            });

            // CC selection handler (same as before)
            $('#ccFilterOptions').on('click', '[data-cc-value]', function() {
                const value = $(this).data('cc-value');

                // UI highlight
                $('#ccFilterOptions [data-cc-value]').removeClass('bg-blue-50 font-semibold');
                $(this).addClass('bg-blue-50 font-semibold');

                // Update state
                activeFilters.cc.clear();
                activeFilters.cc.add(value);

                updateCcFilterLabel();
                updateFilterEnabledState();
                $('#ccFilterPanel').addClass('hidden');

                // Trigger refresh (treated as user action → localStorage ignored forever after)
                loadOrderDropdownDetails(true);
            });

            // Model / Season / Buyer change handlers (unchanged)
            $('#modelFilterOptions, #seasonFilterOptions, #buyerFilterOptions').on('change', '.filter-checkbox', function() {
                const key = $(this).data('filter-key');
                const val = $(this).val();
                if (this.checked) {
                    activeFilters[key].add(val);
                } else {
                    activeFilters[key].delete(val);
                }
                if (key === 'model') updateModelFilterLabel();
                if (key === 'season') updateSeasonFilterLabel();
                if (key === 'buyer') updateBuyerFilterLabel();
            });

            // Panel search: filter option rows by typed text
            function attachPanelSearch(inputSelector, optionsContainerSelector, rowSelector) {
                const rowSel = rowSelector || 'label';
                $(inputSelector).on('input', function() {
                    const term = $(this).val().toLowerCase();
                    const $options = $(optionsContainerSelector).children(rowSel);

                    if (!term) {
                        $options.removeClass('hidden');
                        return;
                    }

                    $options.each(function() {
                        const text = $(this).text().toLowerCase();
                        if (text.indexOf(term) !== -1) {
                            $(this).removeClass('hidden');
                        } else {
                            $(this).addClass('hidden');
                        }
                    });
                });
            }

            attachPanelSearch('#modelFilterSearch', '#modelFilterOptions');           // labels
            attachPanelSearch('#buyerFilterSearch', '#buyerFilterOptions');           // labels
            attachPanelSearch('#seasonFilterSearch', '#seasonFilterOptions');         // labels
            attachPanelSearch('#ccFilterSearch', '#ccFilterOptions', '[data-cc-value]'); // CC rows are <div data-cc-value>

            function formatIndian(num) {
                if (!num || isNaN(num)) return '0';
                return Number(num).toLocaleString('en-IN');
            }

            function isAlertMetric(rawName) {
                if (!rawName) return false;

                var name = String(rawName)
                    .replace(/\s+/g, ' ')
                    .trim()
                    .toLowerCase();

                const alerts = [
                    'fc qty',
                    'po upto',
                    'fc upto',
                    'frc pending',
                    'co tobe issued',
                    'tobe issued',
                    'tobe produced',
                    'material grn',
                    'material tobe inhoused',
                    'tobe scanned',
                    'tobe mapped',
                    'po + fc qty upto'
                ];

                return alerts.some(label => name.startsWith(label));
            }

            // Clear any table
            function clearTable(tableId) {
                if (tableId === 'mainSizeTable') {
                    $('#tableHeader').empty();
                    $('#tableBody').empty();
                } else {
                    $(`#${tableId} thead`).empty();
                    $(`#${tableId} tbody`).empty();
                }
            }

            function showLoader(tableId) {
                if (tableId === 'mainSizeTable') {
                    $('#mainLoader').removeClass('hidden').addClass('flex');
                } else if (tableId === 'materialtable') {
                    $('#materialLoader').removeClass('hidden').addClass('flex');
                } else if (tableId === 'productiontable') {
                    $('#productionLoader').removeClass('hidden').addClass('flex');
                }
            }

            function hideLoader(tableId) {
                if (tableId === 'mainSizeTable') {
                    $('#mainLoader').addClass('hidden').removeClass('flex');
                } else if (tableId === 'materialtable') {
                    $('#materialLoader').addClass('hidden').removeClass('flex');
                } else if (tableId === 'productiontable') {
                    $('#productionLoader').addClass('hidden').removeClass('flex');
                }
            }

            // Build filter payload from current selections
            function getCurrentFilterPayload() {
                return {
                    cc: activeFilters.cc.size > 0 ? Array.from(activeFilters.cc)[0] : '',
                    model_color: Array.from(activeFilters.model),
                    buyer_name: Array.from(activeFilters.buyer),
                    season: Array.from(activeFilters.season)
                };
            }

			// Initial load
            loadMainTable();
            loadMaterialTable();
            loadProductionTable();

            function loadMainTable(filters) {
                clearTable('mainSizeTable');
                showLoader('mainSizeTable');

                const params = {
                    portaltype: portaltype,
                    costno: costno
                };

                if (filters) {
                    params.cc = filters.cc || '';
                    params.model_color = filters.model_color || [];
                    params.buyer_name = filters.buyer_name || [];
                    params.season = filters.season || [];
                }

                $.get('/cccolordetails', params)
                .done(function(res) {
                    if (res.success && res.data && res.data.length > 0) {
                        buildDynamicTable(res.data);
                    } else {
                        $('#tableHeader').html('<tr><th class="py-3 px-3 text-left text-red-600">No Data</th></tr>');
                        $('#tableBody').html('<tr><td class="py-8 text-center text-gray-500">No records found</td></tr>');
                    }
                })
                .fail(function() {
                    $('#tableBody').html('<tr><td class="py-8 text-center text-red-600">Failed to load</td></tr>');
                })
                .always(() => hideLoader('mainSizeTable'));
            }

            function loadMaterialTable(filters) {
                clearTable('materialtable');
                showLoader('materialtable');

                const materialDate = $('#material_date').val() || today;

                const params = {
                    portaltype: portaltype,
                    costno: costno,
                    material_fromdate: materialDate,
                    material_todate: materialDate
                };

                if (filters) {
                    params.cc = filters.cc || '';
                    params.model_color = filters.model_color || [];
                    params.buyer_name = filters.buyer_name || [];
                    params.season = filters.season || [];
                }

                $.get('/cccolordetailstimematerial', params)
                .done(function(res) {
                    if (res.success && res.material && res.material.length > 0) {
                        buildMaterialTable(res.material);
                    } else {
                        $('#materialtable tbody').html('<tr><td colspan="15" class="py-8 text-center text-gray-500">No material alerts for selected date</td></tr>');
                    }
                })
                .fail(function() {
                    $('#materialtable tbody').html('<tr><td class="py-8 text-center text-red-600">Failed to load material data</td></tr>');
                })
                .always(() => hideLoader('materialtable'));
            }

            function loadProductionTable(filters) {
                clearTable('productiontable');
                showLoader('productiontable');

                const productionDate = $('#production_date').val() || today;

                const params = {
                    portaltype: portaltype,
                    costno: costno,
                    production_fromdate: productionDate,
                    production_todate: productionDate
                };

                if (filters) {
                    params.cc = filters.cc || '';
                    params.model_color = filters.model_color || [];
                    params.buyer_name = filters.buyer_name || [];
                    params.season = filters.season || [];
                }

                $.get('/cccolordetailstimeprod', params)
                .done(function(res) {
                    if (res.success && res.production && res.production.length > 0) {
                        buildProductionTable(res.production);
                    } else {
                        $('#productiontable tbody').html('<tr><td colspan="15" class="py-8 text-center text-gray-500">No production alerts for selected date</td></tr>');
                    }
                })
                .fail(function() {
                    $('#productiontable tbody').html('<tr><td class="py-8 text-center text-red-600">Failed to load production data</td></tr>');
                })
                .always(() => hideLoader('productiontable'));
            }

            function updateColorDisplay(filters) {
                const el = document.getElementById('colordisplay');
                if (!el) return;

                const cc      = filters.cc || '';
                const models  = filters.model_color || [];
                const buyers  = filters.buyer_name || [];
                const seasons = filters.season || [];

                const parts = [
                    `CC : ${cc}`,
                    `Model : [${models.length ? models.join(', ') : 'All'}]`,
                    `Buyer : [${buyers.length ? buyers.join(', ') : 'All'}]`,
                    `Season : [${seasons.length ? seasons.join(', ') : 'All'}]`
                ];

                el.textContent = parts.join(' | ');
            }

            function buildDynamicTable(data) {
                if (!data || data.length === 0) {
                    $('#tableHeader').html('<tr><th class="py-3 px-3 text-left font-semibold">No data available</th></tr>');
                    $('#tableBody').html('<tr><td class="py-2.5 px-3 text-center">No data available</td></tr>');
                    return;
                }

                // Get all column keys from the first row, excluding unwanted columns
                var firstRow = data[0];
                var columns = Object.keys(firstRow).filter(key => 
                    key !== 'SNo' && 
                    key !== 'SlNo' && 
                    key !== 'TypeName' && 
                    key !== 'Formula'
                );

                // Build header
                var headerHtml = '<tr class="bg-blue-50 text-gray-700">';
                headerHtml += '<th class="py-3 px-3 text-left font-semibold">Metric</th>';
                
                // Add size columns (all columns except Type and other metadata)
                var sizeColumns = columns.filter(key => 
                    key !== 'Type' && 
                    key !== 'Mode'
                );
                sizeColumns.forEach(function(column) {
                    headerHtml += '<th class="py-3 px-3 text-center font-semibold">' + column + '</th>';
                });
                
                headerHtml += '<th class="py-3 px-3 text-center font-semibold">Total</th>';
                headerHtml += '</tr>';
                
                $('#tableHeader').html(headerHtml);

                // Build body rows
                var bodyHtml = '';
                data.forEach(function(row, index) {
                    var metricName = row.TypeName || '';
                    var highlight = isAlertMetric(metricName) ? ' bg-yellow-50' : '';
                    var rowClass = index < data.length - 1 ? 'border-b border-gray-100' : '';
                    bodyHtml += '<tr class="' + rowClass + highlight + '">';
                    
                    // Add Type as the first column (Metric) with info icon if Mode is 'C'
                    var metricCell = '<td class="py-2.5 px-3 font-medium">';
                    metricCell += metricName;
                    
                    // Add info icon with formula tooltip if Mode is 'C' and Formula exists
                    if (row.Mode === 'C' && row.Formula && row.Formula.trim() !== '') {
                        metricCell += ' <i class="fas fa-info-circle text-blue-500 cursor-pointer ml-2" title="' + 
                                    row.Formula.replace(/"/g, '&quot;') + '" data-toggle="tooltip"></i>';
                    }
                    
                    metricCell += '</td>';
                    bodyHtml += metricCell;
                    
                    // Add size columns
                    var rowTotal = 0;
                    sizeColumns.forEach(function(column) {
                        var value = row[column] || 0;
                        var numValue = null;
                        if (value !== null && value !== undefined && value !== '') {
                            numValue = parseFloat(value);
                            if (!isNaN(numValue)) {
                                rowTotal += numValue;
                            }
                        }
                        var cellClass = 'text-center';
                        if (numValue !== null && !isNaN(numValue) && numValue < 0) {
                            cellClass += ' text-red-500';
                        }
                        bodyHtml += '<td class="' + cellClass + '">' + formatIndian(value) + '</td>';
                    });
                    
                    // Add total column (red if negative)
                    var totalClass = 'text-center font-semibold';
                    if (!isNaN(rowTotal) && rowTotal < 0) {
                        totalClass += ' text-red-500';
                    }
                    bodyHtml += '<td class="' + totalClass + '">' + formatIndian(rowTotal) + '</td>';
                    bodyHtml += '</tr>';
                });
                
                $('#tableBody').html(bodyHtml);
            }

            // Function to build material alerts table
            function buildMaterialTable(data) {
                if (!data || data.length === 0) {
                    // Keep existing static content if no data
                    return;
                }

                // Get all column keys from the first row, excluding unwanted columns
                var firstRow = data[0];
                var columns = Object.keys(firstRow).filter(key => 
                    key !== 'SNo' && 
                    key !== 'SlNo' && 
                    key !== 'TypeName' && 
                    key !== 'Formula'
                );

                // Build header for material table
                var headerHtml = '<tr class="bg-blue-50 text-gray-700">';
                headerHtml += '<th class="py-3 px-3 text-left font-semibold">Metric</th>';
                
                // Add size columns (all columns except Type and other metadata)
                var sizeColumns = columns.filter(key => 
                    key !== 'Type' && 
                    key !== 'Mode'
                );
                sizeColumns.forEach(function(column) {
                    headerHtml += '<th class="py-3 px-3 text-center font-semibold">' + column + '</th>';
                });
                
                headerHtml += '<th class="py-3 px-3 text-center font-semibold">Total</th>';
                headerHtml += '</tr>';
                
                $('#materialtable thead').html(headerHtml);

                // Build body rows for material table
                var bodyHtml = '';
                data.forEach(function(row, index) {
                    var metricName = row.TypeName || '';
                    var highlight = isAlertMetric(metricName) ? ' bg-yellow-50' : '';
                    var rowClass = index < data.length - 1 ? 'border-b border-gray-100' : '';
                    bodyHtml += '<tr class="' + rowClass + highlight + '">';
                    
                    // Add Type as the first column (Metric) with info icon if Mode is 'C'
                    var metricCell = '<td class="py-2.5 px-3 font-medium">';
                    metricCell += metricName;
                    
                    // Add info icon with formula tooltip if Mode is 'C' and Formula exists
                    if (row.Mode === 'C' && row.Formula && row.Formula.trim() !== '') {
                        metricCell += ' <i class="fas fa-info-circle text-blue-500 cursor-pointer ml-2" title="' + 
                                    row.Formula.replace(/"/g, '&quot;') + '" data-toggle="tooltip"></i>';
                    }
                    
                    metricCell += '</td>';
                    bodyHtml += metricCell;
                    
                    // Add size columns (all columns except Type and other metadata)
                    var sizeColumns = columns.filter(key => 
                        key !== 'Type' && 
                        key !== 'Mode'
                    );
                    
                    var rowTotal = 0;
                    sizeColumns.forEach(function(column) {
                        var value = row[column] || 0;
                        var numValue = null;
                        if (value !== null && value !== undefined && value !== '') {
                            numValue = parseFloat(value);
                            if (!isNaN(numValue)) {
                                rowTotal += numValue;
                            }
                        }
                        var cellClass = 'text-center';
                        if (numValue !== null && !isNaN(numValue) && numValue < 0) {
                            cellClass += ' text-red-500';
                        }
                        bodyHtml += '<td class="' + cellClass + '">' + formatIndian(value) + '</td>';
                    });
                    
                    // Add total column (red if negative)
                    var totalClass = 'text-center font-semibold';
                    if (!isNaN(rowTotal) && rowTotal < 0) {
                        totalClass += ' text-red-500';
                    }
                    bodyHtml += '<td class="' + totalClass + '">' + formatIndian(rowTotal) + '</td>';
                    bodyHtml += '</tr>';
                });
                
                // Find the material table tbody and update it using ID
                var materialTableBody = $('#materialtable tbody');
                if (materialTableBody.length > 0) {
                    materialTableBody.html(bodyHtml);
                    console.log('Material table updated successfully');
                } else {
                    console.log('Material table body not found');
                }
            }

            // Function to build production alerts table
            function buildProductionTable(data) {
                if (!data || data.length === 0) {
                    // Keep existing static content if no data
                    return;
                }

                // Get all column keys from the first row, excluding unwanted columns
                var firstRow = data[0];
                var columns = Object.keys(firstRow).filter(key => 
                    key !== 'SNo' && 
                    key !== 'SlNo' && 
                    key !== 'TypeName' && 
                    key !== 'Formula'
                );

                // Build header for production table
                var headerHtml = '<tr class="bg-blue-50 text-gray-700">';
                headerHtml += '<th class="py-3 px-3 text-left font-semibold">Metric</th>';
                
                // Add size columns (all columns except Type and other metadata)
                var sizeColumns = columns.filter(key => 
                    key !== 'Type' && 
                    key !== 'Mode'
                );
                sizeColumns.forEach(function(column) {
                    headerHtml += '<th class="py-3 px-3 text-center font-semibold">' + column + '</th>';
                });
                
                headerHtml += '<th class="py-3 px-3 text-center font-semibold">Total</th>';
                headerHtml += '</tr>';
                
                $('#productiontable thead').html(headerHtml);

                // Build body rows for production table
                var bodyHtml = '';
                data.forEach(function(row, index) {
                    var metricName = row.TypeName || '';
                    var highlight = isAlertMetric(metricName) ? ' bg-yellow-50' : '';
                    var rowClass = index < data.length - 1 ? 'border-b border-gray-100' : '';
                    bodyHtml += '<tr class="' + rowClass + highlight + '">';
                    
                    // Add Type as the first column (Metric) with info icon if Mode is 'C'
                    var metricCell = '<td class="py-2.5 px-3 font-medium">';
                    metricCell += metricName;
                    
                    // Add info icon with formula tooltip if Mode is 'C' and Formula exists
                    if (row.Mode === 'C' && row.Formula && row.Formula.trim() !== '') {
                        metricCell += ' <i class="fas fa-info-circle text-blue-500 cursor-pointer ml-2" title="' + 
                                    row.Formula.replace(/"/g, '&quot;') + '" data-toggle="tooltip"></i>';
                    }
                    
                    metricCell += '</td>';
                    bodyHtml += metricCell;
                    
                    // Add size columns (all columns except Type and other metadata)
                    var sizeColumns = columns.filter(key => 
                        key !== 'Type' && 
                        key !== 'Mode'
                    );
                    
                    var rowTotal = 0;
                    sizeColumns.forEach(function(column) {
                        var value = row[column] || 0;
                        var numValue = null;
                        if (value !== null && value !== undefined && value !== '') {
                            numValue = parseFloat(value);
                            if (!isNaN(numValue)) {
                                rowTotal += numValue;
                            }
                        }
                        var cellClass = 'text-center';
                        if (numValue !== null && !isNaN(numValue) && numValue < 0) {
                            cellClass += ' text-red-500';
                        }
                        bodyHtml += '<td class="' + cellClass + '">' + formatIndian(value) + '</td>';
                    });

                    // Add total column (red if negative)
                    var totalClass = 'text-center font-semibold';
                    if (!isNaN(rowTotal) && rowTotal < 0) {
                        totalClass += ' text-red-500';
                    }
                    bodyHtml += '<td class="' + totalClass + '">' + formatIndian(rowTotal) + '</td>';
                    bodyHtml += '</tr>';
                });
                
                // Find the production table tbody and update it using ID
                var productionTableBody = $('#productiontable tbody');
                if (productionTableBody.length > 0) {
                    productionTableBody.html(bodyHtml);
                    console.log('Production table updated successfully');
                } else {
                    console.log('Production table body not found');
                }
            }

            // Date change → reload only relevant table with current filters
            $('#material_date').on('change', function() {
                const filters = getCurrentFilterPayload();
                loadMaterialTable(filters);
            });

            $('#production_date').on('change', function() {
                const filters = getCurrentFilterPayload();
                loadProductionTable(filters);
            });

            // Submit / Apply filters button → load all three tables with current filters
            const applyFiltersBtn = document.getElementById('applyFiltersBtn');
            if (applyFiltersBtn) {
                applyFiltersBtn.addEventListener('click', function() {
                    const filters = getCurrentFilterPayload();
                    updateColorDisplay(filters);
                    loadMainTable(filters);
                    loadMaterialTable(filters);
                    loadProductionTable(filters);
                });
            }

            // Unified helper: open order popup in OB mode and load OB/BOM data
            function openOrderPopupOB(ccNoRaw, costNoRaw, ccColorRaw) {
                var ccNo    = ccNoRaw    || localStorage.getItem('selectedCcNo')   || '';
                var costNo  = costNoRaw  || localStorage.getItem('selectedCostNo') || '';
                var ccColor = ccColorRaw || localStorage.getItem('selectedColor') || '';

                if (!ccNo || !costNo) {
                    alert('No order selected. Please open from Order Management first.');
                    return;
                }

                var safeCcNo    = ccNo || '-';
                var safeCcColor = ccColor || '-';

                $('#orderPopup').removeClass('hidden');

                const $header = $('#popupHeaderContent');
                $header.html(`
                    <div class="flex items-center gap-4" id="popupHeaderContent">
                        <div>
                            <div class="flex">
                                <h2 class="text-xl font-semibold text-gray-900">${safeCcNo} - ${safeCcColor}</h2>
                                <h3 class="text-lg font-semibold text-gray-800">(OB)</h3>
                            </div> 
                            <p class="text-sm text-gray-500">Forecasted Order ID: ${safeCcNo}-${safeCcColor} • Buyer: DMI</p>  
                        </div>
                    </div>    
                `);

                // OB tab as default
                $('#obContent').html('<div class="p-20 text-center"><i class="fas fa-spinner fa-spin text-5xl text-blue-600"></i><p class="mt-4 text-xl text-gray-600">Loading OB...</p></div>');
                $('.tab-btn').removeClass('bg-blue-600 text-white').addClass('text-gray-600');
                $('[data-tab="ob"]').addClass('bg-blue-600 text-white').removeClass('text-gray-600');
                $('.tab-pane').addClass('hidden');
                $('#obContent').removeClass('hidden');
                $('#orderPopup').addClass('ob-tab-active').removeClass('bom-tab-active');

                $.ajax({
                    url: '/gut_plan_obchartdetails',
                    method: 'GET',
                    data: { ccno: ccNo, costno: costNo },
                    success: function(res) {
                        if (res.success && res.data && res.data.length > 0) {
                            populateOrderPopup(res.data, safeCcNo, safeCcColor);
                            populateBOMContent(res.bomdetails || [], safeCcNo, safeCcColor);
                        } else {
                            $('#obContent').html('<div class="p-20 text-center text-red-600 text-xl">No OB data found</div>');
                        }
                    },
                    error: function() {
                        $('#obContent').html('<div class="p-20 text-center text-red-600 text-xl">Server error</div>');
                    }
                });
            }

            // Header link: open OB/BOM popup using current order from localStorage
            $('#openOrderPopupLink').on('click', function () {
                openOrderPopupOB(null, null, null);
            });

            

            // Order popup click trigger from main list (Gut_new_main rows)
            $(document).on('click', '.orderpopupnew', function(e) {
                e.preventDefault();
                const ccNo = $(this).data('ccno');
                const costNo = $(this).data('costno');
                const model = $(this).data('model');

                const ccColor = $(this).text().trim();
                const selectionQty = $(this).data('selectionqty');
                const prjQty = $(this).data('prjqty');

                if (!ccNo) return alert('CC No missing!');

                // Track clicked element
                $('.orderpopupnew').removeClass('clicked');
                $(this).addClass('clicked');

                // Store selection/prj qty in case other pages (like Order Details) need them
                try {
                    localStorage.setItem('selectedSelectionQty', selectionQty != null ? selectionQty : '0');
                    localStorage.setItem('selectedPrjQty', prjQty != null ? prjQty : '0');
                } catch (err) {
                    console.warn('Unable to store selection/prj qty in localStorage:', err);
                }

                // Use unified helper
                openOrderPopupOB(ccNo, costNo, ccColor);
            });

            // TAB SWITCHING
            $(document).on('click', '.tab-btn', function() {
                const tab = $(this).data('tab');
                $('.tab-btn').removeClass('bg-blue-600 text-white').addClass('text-gray-600');
                $(this).addClass('bg-blue-600 text-white').removeClass('text-gray-600');
                $('.tab-pane').addClass('hidden');
                $('#' + tab + 'Content').removeClass('hidden');
                
                // Update popup dimensions based on active tab
                $('#orderPopup').removeClass('ob-tab-active bom-tab-active');
                if (tab === 'ob') {
                    $('#orderPopup').addClass('ob-tab-active');
                    // Update header for OB tab (fallback to localStorage if no clicked row)
                    const $header = $('#popupHeaderContent');
                    let ccNo = $('.orderpopupnew.clicked').data('ccno') || localStorage.getItem('selectedCcNo') || '-';
                    let ccColor = ($('.orderpopupnew.clicked').text() || '').trim() || localStorage.getItem('selectedColor') || '-';
                    $header.html(`
                    <div class="flex items-center gap-4" id="popupHeaderContent">
                        <div>
                            <div class="flex">
                                <h2 class="text-xl font-semibold text-gray-900">${ccNo} - ${ccColor}</h2>
                                <h3 class="text-lg font-semibold text-gray-800">(OB)</h3>
                            </div> 
                            <p class="text-sm text-gray-500">Forecasted Order ID: ${ccNo}-${ccColor} • Buyer: DMI</p>  
                        </div>
                    </div>  
                    `);
                } else if (tab === 'bom') {
                    $('#orderPopup').addClass('bom-tab-active');
                    // Update header for BOM tab (fallback to localStorage if no clicked row)
                    const $header = $('#popupHeaderContent');
                    let ccNo = $('.orderpopupnew.clicked').data('ccno') || localStorage.getItem('selectedCcNo') || '-';
                    let ccColor = ($('.orderpopupnew.clicked').text() || '').trim() || localStorage.getItem('selectedColor') || '-';
                    $header.html(`
                    <div class="flex items-center gap-4" id="popupHeaderContent">
                        <div>
                            <div class="flex">
                                <h2 class="text-xl font-semibold text-gray-900">${ccNo} - ${ccColor}</h2>
                                <h3 class="text-lg font-semibold text-gray-800">(BOM)</h3>
                            </div> 
                            <p class="text-sm text-gray-500">Forecasted Order ID: ${ccNo}-${ccColor} • Buyer: DMI</p>  
                        </div>
                    </div>  
                    `);
                }
            });

            function populateOrderPopup(data, ccNo, ccColor) {
                const ops = data || [];
                const totalSAM = ops.reduce((a, op) => a + parseFloat(op.Minutes || 0), 0).toFixed(2);
                const totalOps = ops.reduce((a, op) => a + parseFloat(op.Allot_Oper || 0), 0);

                const grades = {}; 
                const machines = {};
                ops.forEach(op => {
                    grades[op.Grade] = (grades[op.Grade] || 0) + parseFloat(op.Allot_Oper || 0);
                    machines[op.Mch_Type] = (machines[op.Mch_Type] || 0) + parseFloat(op.Allot_Oper || 0);
                });

                let rows = '';
                if (ops.length === 0) {
                    rows = `<tr><td colspan="5" class="text-center py-12 text-gray-500 text-sm">No OB data found for this style</td></tr>`;
                } else {
                    rows = ops.map(op => {
                        const isCritical = op.OP_TYPE === 'CRITICAL';
                        const gradeColor = 
                            op.Grade === 'A' ? 'bg-green-100 text-green-800' :
                            op.Grade === 'B' ? 'bg-blue-100 text-blue-800' :
                            op.Grade === 'C' ? 'bg-yellow-100 text-yellow-800' :
                            op.Grade === 'D' ? 'bg-orange-100 text-orange-800' :
                            'bg-gray-100 text-gray-700';

                        return `
                        <tr class="border-t hover:bg-gray-50">
                            <td class="px-4 py-1">
                                <div class="flex items-center gap-2">
                                    <span class="text-sm text-gray-600">${op.SNo || ''}.</span>
                                    <span class="text-sm font-medium">${op.Operation || 'N/A'}</span>
                                </div>
                            </td>
                            <td class="px-4 py-1 text-sm text-gray-700">${op.Mch_Type || '-'}</td>
                            <td class="px-4 py-1 text-center">
                                <span class="inline-flex items-center justify-center w-5 h-5 rounded-full text-sm font-semibold ${gradeColor}">
                                    ${op.Grade || 'H'}
                                </span>
                            </td>
                            <td class="px-4 py-1 text-center text-sm font-semibold text-gray-800">${op.Allot_Oper || 0}</td>
                            <td class="px-4 py-1 text-center text-sm font-mono text-gray-700">${parseFloat(op.Minutes || 0).toFixed(2)}</td>
                        </tr>`;
                    }).join('');
                }

                const html = `
                <div class="bg-gray-50 border border-gray-200 rounded-lg p-2 mx-2 mt-2 mb-1 sticky top-0 z-10">
                    <div class="flex items-start gap-10">
                        <!-- Left: SAM + Tailors -->
                        <div class="flex items-start gap-10">
                            <!-- Total SAM -->
                            <div class="text-center">
                                <p class="text-gray-600 text-sm">Total SAM</p>
                                <p class="text-3xl font-semibold">${totalSAM}</p>
                            </div>
                            <!-- Vertical Line -->
                            <div class="h-24 w-px bg-gray-300"></div>
                            <!-- Total Tailors -->
                            <div class="text-center">
                                <p class="text-gray-600 text-sm">Tailors</p>
                                <p class="text-3xl font-semibold">${totalOps}</p>
                            </div>
                        </div>
                            <!-- Vertical Line -->
                        <div class="h-24 w-px bg-gray-300 mx-2"></div>
                        <!-- Right: Tailor Grades + Machine Types -->
                        <div class="flex ">
                            <!-- Tailor Grades -->
                            <div>
                                <p class="text-gray-700 font-medium mb-1 text-sm">Tailor Grades</p>
                                <div class="flex flex-wrap gap-2">
                                    ${Object.entries(grades).map(([g, c]) => 
                                        `<span class="px-3 py-1 bg-gray-100 rounded-full text-sm">${g}: ${c}</span>`
                                    ).join('')}
                                </div>
                            </div>
                            <!-- Vertical Line -->
                            <div class="h-24 w-px bg-gray-300 mr-4"></div>
                            <!-- Machine Types -->
                            <div>
                                <p class="text-gray-700 font-medium mb-1 text-sm">Machine Types</p>
                                <div class="flex flex-wrap gap-2">
                                    ${Object.entries(machines).map(([m, c]) => 
                                        `<span class="px-3 py-1 bg-gray-100 rounded-full text-sm">${m}: ${c}</span>`
                                    ).join('')}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Operations Table -->
                <div class="mt-2 p-3">
                    <h3 class="text-base font-semibold text-gray-800 mb-2 hidden">Operation Breakdown (OB)</h3>
                    <div class="overflow-x-auto">
                        <table class="w-full">
                                <thead class="bg-gray-50 border-b">
                                    <tr>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-700">Operation</th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-700">Machine</th>
                                        <th class="px-4 py-3 text-center text-xs font-medium text-gray-700">Grade</th>
                                        <th class="px-4 py-3 text-center text-xs font-medium text-gray-700">Operators</th>
                                        <th class="px-4 py-3 text-center text-xs font-medium text-gray-700">SAM</th>
                                    </tr>
                                </thead>
                            <tbody class="divide-y divide-gray-200">
                                ${rows}
                            </tbody>
                        </table>
                    </div>
                </div>`;

                $('#obContent').html(html);
            }

            function populateBOMContent(bomData, ccNo, ccColor) {
                if (!bomData || bomData.length === 0) {
                    $('#bomTableContainer').html(`
                        <div class="text-center py-20 text-red-600 text-xl">
                            No BOM data found for this style
                        </div>
                    `).removeClass('hidden');
                    $('#bomLoading').addClass('hidden');
                    return;
                }

                let rows = bomData.map(item => {
                    const sizeDep = item.Size_Avail === '1' || item.Size_Avail?.toLowerCase() === 'yes' ? 'Yes' : 'No';
                    const source = item.Currency === 'Import' ? 'Import' : 'Local';
                    const projFrc = item.Ocn_Type === 'Proj' ? 'Projection' : 'FRC';

                    return `
                    <tr class="border-t hover:bg-gray-50">
                        <td class="px-2 py-2 font-medium">${item.Item || 'N/A'}</td>
                        <td class="px-2 py-2 text-center">
                            <span class="px-2 py-1 rounded-full text-xs font-medium ${sizeDep === 'Yes' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-700'}">
                                ${sizeDep}
                            </span>
                        </td>
                        <td class="px-2 py-2 text-center">
                            <span class="px-2 py-1 rounded-full text-xs font-medium ${source === 'Import' ? 'bg-red-100 text-red-700' : 'bg-green-100 text-green-700'}">
                                ${source}
                            </span>
                        </td>
                        <td class="px-2 py-2 text-center font-medium">${item.Dom_LDay || '-'} days</td>
                        <td class="px-2 py-2 text-center font-medium">${item.Imp_LDays || '-'} days</td>
                        <td class="px-2 py-2">${item.Supplier || '-'}</td>
                        <td class="px-2 py-2 text-center">
                            <span class="px-3 py-1 rounded-full text-xs font-semibold ${projFrc === 'Projection' ? 'bg-purple-100 text-purple-800' : 'bg-orange-100 text-orange-800'}">
                                ${projFrc}
                            </span>
                        </td>
                    </tr>`;
                }).join('');

                const tableHTML = `
                <div class="border rounded-xl overflow-hidden bg-white shadow-sm">
                    <div class="max-h-96 overflow-y-auto">
                        <table class="w-full " style="font-size:12px;">
                            <thead class="bg-blue-50 text-gray-700 sticky top-0 z-20">
                                <tr>
                                    <th class="px-2 py-2 text-left text-xs font-medium">Cmpt Name</th>
                                    <th class="px-2 py-2 text-center text-xs font-medium">Size Dep</th>
                                    <th class="px-2 py-2 text-center text-xs font-medium">Impt / Local</th>
                                    <th class="px-2 py-2 text-center text-xs font-medium">D Time</th>
                                    <th class="px-2 py-2 text-center text-xs font-medium">L Time</th>
                                    <th class="px-2 py-2 text-left text-xs font-medium">Supplier</th>
                                    <th class="px-2 py-2 text-left text-xs font-medium">Ocn_Type</th>
                                </tr>
                            </thead>
                            <tbody>
                                ${rows}
                            </tbody>
                        </table>
                    </div>
                </div>`;

                $('#bomTableContainer').html(tableHTML).removeClass('hidden');
                $('#bomLoading').addClass('hidden');
            }
        });
    </script>

</body>
</html>