<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Sewing Gantt Chart - Exact Match</title>
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">

  <style>
    /* Width of day cells will be fully controlled by JS (dayWidth) */
    .day-cell { min-width: 0; }
    #week-headers {
      position: relative;
    }

    .week-resize-handle {
      position: absolute;
      top: 0;
      bottom: 0;
      width: 10px;
      margin-left: -5px;
      cursor: col-resize;
      z-index: 40;
    }

    .resizing-week,
    .resizing-week * {
      cursor: col-resize !important;
      user-select: none !important;
    }

    /* Make unplanned small cards slimmer with smaller text */
    .small-card {
      width: 85%;              /* narrower than the left panel */
      margin-left: auto;
      margin-right: auto;
      font-size: 0.70rem;      /* smaller base font */
      padding-top: 0.4rem;
      padding-bottom: 0.4rem;
      padding-left: 0.5rem;
      padding-right: 0.5rem;
    }

    .small-card .text-xs {
      font-size: 0.65rem;      /* tighten inner label text */
    }

    .task-bar {
      /* Tailwind @apply does not run in-browser via CDN, so set explicit styles */
      position: absolute;
      height: 40px;
      background-color: #f97316; /* orange-500 */
      color: #ffffff;
      font-size: 0.75rem;
      font-weight: 500;
      border-radius: 0.5rem;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
      cursor: move;
      display: flex;
      align-items: center;
      justify-content: center;
      border: 2px solid #ffffff;
      top: 50%;
      transform: translateY(-50%);
      padding: 0 12px;
      white-space: nowrap;
      z-index: 10;
    }

    .task-bar:hover { 
      box-shadow: 0 0 0 4px #feb2c6; /* ring-4 ring-orange-300 */
    }
    .task-layer {
        min-width: fit-content;
        width: max-content;
    }
    .task-layer {
    height: 40px !important;        /* reduced row height */
    }
    /* Grey overlay for task-layer cells */
    .task-layer .grid-cell {
        background-color: rgba(156, 163, 175, 0.3); /* gray-400 with 30% opacity */
    }
    .task-layer .grid-cell.no-overlay {
        background-color: transparent;
    }
    .task-bar {
    height: 30px !important;        /* reduced bar height */
    line-height: 40px;
    top: 50% !important;
    transform: translateY(-50%);
    }

    /* Gantt task hover info panel */
    #gantt-task-tooltip {
      position: absolute;
      top: 8px;
      right: 16px;
      background: #fff9c4; /* light yellow similar to sample */
      border-radius: 6px;
      padding: 6px 10px;
      font-size: 11px;
      color: #111827;
      box-shadow: 0 2px 6px rgba(0,0,0,0.15);
      border: 1px solid #facc15;
      display: none;
      z-index: 40;
      white-space: nowrap;
    }
    #gantt-task-tooltip span {
      margin-right: 10px;
    }
    #gantt-task-tooltip .label {
      font-weight: 600;
    }

    /* Unplanned small-card hover info panel (same position as task tooltip) */
    #unplanned-card-tooltip {
      position: absolute;
      top: 8px;
      right: 16px;
      background: #bbf7d0; /* light green default, overridden per card on hover */
      border-radius: 6px;
      padding: 6px 10px;
      font-size: 11px;
      color: #111827;
      box-shadow: 0 2px 6px rgba(0,0,0,0.15);
      border: 1px solid #16a34a;
      display: none;
      z-index: 45;
      white-space: nowrap;
    }
    #unplanned-card-tooltip span {
      margin-right: 10px;
    }
    #unplanned-card-tooltip .label {
      font-weight: 600;
    }

    /* Lightweight tooltip styles for validation (reused from KPI pages) */
    .has-tooltip{ position: relative; }
    .has-tooltip::after{
      content: attr(data-tooltip);
      position: absolute; z-index: 50;
      left: 50%; top: -32px; transform: translateX(-50%);
      background: #fdecea; color: #842029; border: 1px solid #f5c2c7;
      padding: 4px 8px; border-radius: 6px; font-size: 12px; white-space: nowrap;
      box-shadow: 0 2px 6px rgba(0,0,0,0.08);
      opacity: 0; pointer-events: none; transition: opacity .15s ease;
    }
    .has-tooltip::before{
      content: ""; position: absolute; left: 50%; top: -8px;
      width: 8px; height: 8px; background: #fdecea;
      border-left:1px solid #f5c2c7; border-top:1px solid #f5c2c7;
      transform: translateX(-50%) rotate(45deg);
      opacity: 0; transition: opacity .15s ease;
    }
    .has-tooltip.error-tip::after{ background:#fee2e2; color:#b91c1c; border-color:#fecaca; }
    .has-tooltip.error-tip::before{ background:#fee2e2; border-left-color:#fecaca; border-top-color:#fecaca; }
    .has-tooltip.show-tip::after,
    .has-tooltip.show-tip::before{ opacity:1; }
    @keyframes spin {
      from { transform: rotate(0deg); }
      to   { transform: rotate(360deg); }
    }
  </style>
</head>
<body class="bg-gray-100">

    @include('LifeAtGainup.Planning.GUTplanning.Gutplan_nav')

<div class="h-screen flex flex-col ">

  <!-- Top Nav -->
  <div class="flex items-center justify-between px-6 py-3 border-b bg-white">
    <div class="flex gap-1 text-sm">
      <button class="process-btn px-4 py-1.5 text-gray-600 hidden" data-process="cutting">Cutting</button>
      <button class="process-btn px-4 py-1.5 text-gray-600 hidden" data-process="printing">Printing</button>
      <button class="process-btn px-4 py-1.5 text-gray-600 hidden" data-process="embroidery">Embroidery</button>
      <button class="process-btn px-4 py-1.5 ml-5 bg-gray-200 text-gray-800 rounded" data-process="sewing">Sewing</button>
      <button class="process-btn px-4 py-1.5 text-gray-600 hidden" data-process="packing">Packing</button>
      <button class="process-btn px-4 py-1.5 text-gray-600 hidden" data-process="pab-mode">PAB Mode</button>
    </div>
    <div class="flex items-center gap-4">
      <!-- Year Navigation -->
      <div class="flex items-center gap-2 hidden">
        <button id="prev-year" class="px-3 py-1 bg-gray-100 hover:bg-gray-200 rounded text-sm font-medium">←</button>
        <span id="current-year" class="px-4 py-1 bg-blue-100 text-blue-700 rounded text-sm font-bold">2026</span>
        <button id="next-year" class="px-3 py-1 bg-gray-100 hover:bg-gray-200 rounded text-sm font-medium">→</button>
      </div>
      <div class="flex items-center gap-2">
        <span class="text-xs text-gray-500">Zoom</span>
        <button id="zoom-out" class="px-2 py-1 border border-gray-300 rounded text-xs text-gray-600 hover:bg-gray-100">-</button>
        <button id="zoom-in" class="px-2 py-1 border border-gray-300 rounded text-xs text-gray-600 hover:bg-gray-100">+</button>
      </div>
    </div>
  </div>

  <!-- Main Grid -->
  <div class="flex flex-1 overflow-hidden">

    <!-- Left: Unplanned -->
    <div class="w-80  border-r p-4">
      <div class="bg-white rounded-lg shadow-sm border h-full py-6 px-2 relative">
        <div class="flex items-center justify-between mb-2">
          <h3 class="font-semibold text-lg text-gray-900">Unplanned</h3>
          <button id="unplanned-filter-btn" type="button" class="flex items-center justify-center w-8 h-8 rounded-md bg-blue-500 text-white hover:bg-blue-600 shadow-sm" aria-label="Filter unplanned items">
            <i class="fa-solid fa-filter text-sm"></i>
          </button>
        </div>
        <p id="unplanned-text" class="text-xs text-gray-500 mb-5">All Sewing (qty) processes are scheduled.</p>
        <div id="small-cards-container">
          
          <!-- Small cards will be generated dynamically based on process -->
        </div>

        <!-- Unplanned Filters Dropdown -->
        <div id="unplanned-filter-panel" class="hidden absolute left-20 top-10 w-72 bg-white rounded-2xl shadow-xl border border-gray-200 z-40">
          <div class="p-4">
            <div class="flex items-start justify-between mb-1">
              <div>
                <h4 class="text-sm font-semibold text-gray-900">Filters &amp; Sort</h4>
                <p class="text-xs text-gray-500">Filter and sort the unplanned orders.</p>
              </div>
            </div>

            <!-- OCN -->
            <div class="mt-4">
              <label class="block text-xs font-medium text-gray-700 mb-1">OCN</label>
              <div class="relative">
                <input id="filter-ocn" type="text" class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm placeholder-gray-400 focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500" placeholder="300000">
              </div>
            </div>

            <!-- Unit -->
            <div class="mt-4">
              <label class="block text-xs font-medium text-gray-700 mb-1">Unit</label>
              <select id="filter-unit" class="w-full rounded-lg border border-gray-300 bg-white px-3 py-2 text-sm text-gray-700 focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                <option value="">All Units</option>
              </select>
            </div>

            <!-- Due Date Range -->
            <div class="mt-4 mb-1">
              <label class="block text-xs font-medium text-gray-700 mb-1">Due Date</label>
              <div class="flex items-center gap-2">
                <input id="filter-date-from" type="date" class="flex-1 rounded-lg border border-gray-300 bg-white px-3 py-2 text-sm text-gray-700 focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500" />
                <span class="text-xs text-gray-400">to</span>
                <input id="filter-date-to" type="date" class="flex-1 rounded-lg border border-gray-300 bg-white px-3 py-2 text-sm text-gray-700 focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

        <!-- Right: Gantt Chart -->
        <div class="flex-1 flex flex-col bg-white shadow-md rounded-lg p-6 mt-4 relative" style="max-width: 84%;">
            <!-- Hover info panel for task bars -->
            <div id="gantt-task-tooltip">
                <span><span class="label">CC:</span> <span id="gt-tip-ocn"></span></span>
                <span><span class="label">Model:</span> <span id="gt-tip-item"></span></span>
                <span><span class="label">Start:</span> <span id="gt-tip-start"></span></span>
                <span><span class="label">Group:</span> <span id="gt-tip-buyer"></span></span>
                <span><span class="label">Duration:</span> <span id="gt-tip-duration"></span></span>
                <br>
                <span><span class="label">Line Name:</span> <span id="gt-tip-line"></span></span>
                <span><span class="label">Color:</span> <span id="gt-tip-color"></span></span>
                <span><span class="label">End:</span> <span id="gt-tip-end"></span></span>
                <span><span class="label">Planned Qty:</span> <span id="gt-tip-qty"></span></span>
            </div>

            <!-- Hover info panel for unplanned small cards -->
            <div id="unplanned-card-tooltip">
                <span><span class="label">CC:</span> <span id="uc-tip-ccno"></span></span>
                <span><span class="label">Color:</span> <span id="uc-tip-color"></span></span>
                <span><span class="label">Model:</span> <span id="uc-tip-model"></span></span>
                <span><span class="label">Total Qty:</span> <span id="uc-tip-qty"></span></span>
            </div>

            <div class="overflow-x-auto">
                <!-- Fixed Header -->
                <div id="header-scroll" class="bg-white border-b z-20">
                    <div class="min-w-max">

                        <!-- Month Row -->
                        <div class="grid grid-cols-[150px_1fr] border-b">
                            <div class="border-r bg-gray-50 font-medium py-2 pl-4 sticky left-0 z-30" style="position: sticky; "> year</div>
                            <div class="flex" id="month-headers">
                            </div>
                        </div>

                        <!-- Week Row -->
                        <div class="grid grid-cols-[150px_1fr] text-xs text-gray-600 border-b">
                            <div class="py-2 pl-4 border-r bg-gray-50 font-medium sticky left-0 z-30" style="position: sticky;">Week</div>
                            <div class="flex" id="week-headers">
                            </div>
                        </div>

                        <!-- Day Row -->
                        <div class="grid grid-cols-[150px_1fr] text-xs text-gray-700 border-b bg-gray-50">
                            <div class="py-2 pl-4 border-r font-medium sticky left-0 z-30 bg-gray-50" style="position: sticky;">Day</div>
                            <div class="flex" id="day-headers"></div>
                        </div>
                    </div>
                </div>

                <!-- Scrollable Body -->
                <div id="gantt-body" class="flex-1 bg-white">
                        <div class="min-w-max" id="gantt-rows">
                        <!-- Gantt rows will be generated dynamically -->
                        </div>
                </div>
            </div>
        </div>

        <!-- Modal Background -->
        <div class="fixed inset-0 bg-black bg-opacity-40 flex items-center justify-center z-50" id="split-modal" style="display: none;">

            <!-- Popup Card -->
            <div class="bg-white w-[480px] rounded-lg shadow-xl p-6 border border-gray-200">

                <!-- Title -->
                <h2 class="text-xl font-semibold mb-1">Split Process: Cutting</h2>

                <!-- Subtitle -->
                <p class="text-gray-500 text-sm leading-5 mb-6">
                    For Order 114227-Green. Adjust the values for the total of 729.17 Days.
                    The sum must equal the total.
                </p>

                <!-- Batch Table Header -->
                <div class="grid grid-cols-2 mb-2 px-1 batch-table-header">
                    <span class="text-gray-700 font-medium text-sm">Batch</span>
                    <span class="text-gray-700 font-medium text-sm">Days</span>
                </div>

                <!-- Existing Batches -->
                <div class="existing-batches-info mt-1 mb-1 px-1 text-xs text-gray-500 font-medium">
                </div>

                <!-- Batch 1 Row -->
                <div class="grid grid-cols-2 items-center mb-3 px-1 batch-row" data-batch="1">
                    <span class="text-gray-700 text-sm">Batch 1</span>

                    <input
                        type="number"
                        value="0"
                        class="border rounded-md px-3 py-2 text-sm focus:ring-1 focus:ring-blue-400 focus:border-blue-400 batch-input"
                    />
                </div>

                <!-- Remainder Row -->
                <div class="grid grid-cols-2 items-center mb-4 px-1">
                    <span class="text-gray-700 text-sm">Remainder</span>

                    <input
                        id="split-remainder"
                        type="text"
                        value="0"
                        disabled
                        class="border rounded-md px-3 py-2 text-sm bg-gray-100 text-gray-600"
                    />
                </div>

                <!-- Add Batch -->
                <button class="flex items-center gap-2 text-blue-600 text-sm mb-4 px-1" id="add-batch-btn">
                    <i class="fa-solid fa-plus text-blue-600"></i>
                    Add Batch
                </button>

                <!-- Divider -->
                <div class="border-t border-gray-300 my-4"></div>

                <!-- Totals -->
                <div class="flex justify-between text-sm mb-1 px-1">
                    <span class="text-gray-700 font-medium">Total Split Duration:</span>
                    <span id="split-total-entered" class="text-blue-600 font-semibold">0.00</span>
                </div>

                <div class="flex justify-between text-sm mb-6 px-1">
                    <span class="text-gray-700">Original Total:</span>
                    <span id="split-original-total" class="text-gray-700">0.00</span>
                </div>

                <!-- Footer Buttons -->
                <div class="flex justify-end gap-3">

                    <!-- Cancel -->
                    <button class="px-4 py-2 border border-gray-300 rounded-md text-sm hover:bg-gray-100" id="cancel-split">
                        Cancel
                    </button>

                    <!-- Confirm Split -->
                    <button id="confirm-split" class="px-5 py-2 bg-blue-500 text-white rounded-md text-sm hover:bg-blue-600 shadow-sm">
                        Confirm Split
                    </button>

                </div>

            </div>

        </div>



    
</div>


<div id="cardContextMenu" 
     class="bg-white shadow-lg border rounded p-2 text-sm hidden absolute z-50">
    <button id="btnSplit" class="block px-3 py-1 hover:bg-gray-200 w-full text-left">
        Split
    </button>
</div>
<div id="splitPopup" class="fixed inset-0 bg-black bg-opacity-40 hidden flex items-center justify-center z-50">
    <div class="bg-white p-4 rounded-lg w-80 shadow-xl">

        <h2 class="text-lg font-semibold mb-3">
            Split Value: <span id="splitTitle"></span>
        </h2>

        <label class="text-xs">Split 1</label>
        <input id="splitVal1" type="number" class="border p-2 w-full mb-3 rounded">

        <label class="text-xs">Split 2 (Auto)</label>
        <input id="splitVal2" type="number" class="border p-2 w-full mb-3 rounded bg-gray-100" readonly>

        <div class="flex justify-end">
            <button id="closeSplit" class="px-3 py-1 bg-gray-300 rounded mr-2">Cancel</button>
            <button id="submitSplit" class="px-3 py-1 bg-blue-600 text-white rounded">OK</button>
        </div>
    </div>
</div>




<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<script>
/* Full Gantt + metrics script (drop into your page) */
// Calendar configuration
// Date range now comes dynamically from controller (fromDate/toDate)
let currentYear = {{ \Carbon\Carbon::parse($fromDate)->year }};
let startDate = new Date('{{ $fromDate }}');
let endDate   = new Date('{{ $toDate }}');

// Horizontal scale (px per day) – will be controlled by zoom
let dayWidth = 42;
const zoomLevels = [12, 20, 32]; // compressed → expanded
let currentZoomIndex = 2;        // start at 32px per day
const MIN_DAY_WIDTH = 12;
const MAX_DAY_WIDTH = 64;
const DRAG_SENSITIVITY = 0.5; // smaller value slows resizing
const LEFT_COLUMN_WIDTH = 150;

// Working days coming from NH_Days_Woven_Plan_Proc
const planDays = @json($planDays ?? []);
// Fast lookup: date (YYYY-MM-DD) -> index in planDays
const dateIndexMap = {};
planDays.forEach((d, idx) => {
  if (d.date) {
    dateIndexMap[d.date] = idx;
  }
});

// Ensure the visible timeline always starts from today: drop any days before today
(function alignPlanDaysToToday() {
  if (!Array.isArray(planDays) || !planDays.length) return;

  const today = new Date();
  const todayISO = today.toISOString().split('T')[0];

  const firstIdx = planDays.findIndex(d => d.date && d.date >= todayISO);

  if (firstIdx > 0) {
    planDays.splice(0, firstIdx);
  }

  if (planDays.length && planDays[0].date) {
    startDate = new Date(planDays[0].date);
  }

  // Rebuild dateIndexMap based on the trimmed planDays
  Object.keys(dateIndexMap).forEach(k => delete dateIndexMap[k]);
  planDays.forEach((d, idx) => {
    if (d.date) {
      dateIndexMap[d.date] = idx;
    }
  });
})();

let isWeekResizing = false;
let resizeStartX = 0;
let resizeStartDayWidth = dayWidth;

// Filter state
const filterState = {
  ocn: '',
  unit: '',
  dateFrom: '',
  dateTo: ''
};

// Total working days in the configured range (from planDays)
function getTotalDaysInRange() {
  return planDays.length;
}

// Build headers for the configured range; keep year label in the UI
function updateYear() {
  $('#current-year').text(startDate.getFullYear());
  generateMonthHeaders();
  generateWeekHeaders();
  generateDayHeaders();
}

// Get ISO week number of a date (weeks start on Monday)
function getWeekNumber(date) {
  // Use UTC to avoid timezone issues and ensure Monday-based weeks
  const tmp = new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate()));

  // ISO week date weeks start on Monday (1) and end on Sunday (7)
  const dayNum = tmp.getUTCDay() || 7; // Sunday (0) becomes 7

  // Set the date to the Thursday in the current week to determine the ISO year
  tmp.setUTCDate(tmp.getUTCDate() + 4 - dayNum);

  const yearStart = new Date(Date.UTC(tmp.getUTCFullYear(), 0, 1));
  const weekNo = Math.ceil((((tmp - yearStart) / 86400000) + 1) / 7);

  return weekNo;
}

function generateMonthHeaders() {
  const $headers = $('#month-headers').empty();
  if (!planDays.length) return;

  let currentMonth = '';
  let monthDays = 0;

  planDays.forEach((d, idx) => {
    const date = new Date(d.date);
    const monthName = date.toLocaleDateString('en-US', { month: 'short', year: '2-digit' });

    if (monthName !== currentMonth) {
      if (currentMonth) {
        const width = monthDays * dayWidth;
        $headers.append(`<div class="text-center py-1 font-semibold border-r bg-gray-50" style="width:${width}px">${currentMonth}</div>`);
      }
      currentMonth = monthName;
      monthDays = 1;
    } else {
      monthDays++;
    }
  });

  if (currentMonth) {
    const width = monthDays * dayWidth;
    $headers.append(`<div class="text-center py-1 font-semibold bg-gray-50" style="width:${width}px">${currentMonth}</div>`);
  }
}

function generateWeekHeaders() {
  const $headers = $('#week-headers').empty();
  if (!planDays.length) return;

  let currentWeek = null;
  let weekDays = 0;

  planDays.forEach((d, idx) => {
    const date = new Date(d.date);
    const weekNum = getWeekNumber(date);

    if (weekNum !== currentWeek) {
      if (currentWeek !== null) {
        const width = weekDays * dayWidth;
        $headers.append(`<div class="text-center border-r py-2" style="width:${width}px">W${currentWeek}</div>`);
      }
      currentWeek = weekNum;
      weekDays = 1;
    } else {
      weekDays++;
    }
  });

  if (currentWeek !== null) {
    const width = weekDays * dayWidth;
    $headers.append(`<div class="text-center py-2" style="width:${width}px">W${currentWeek}</div>`);
  }

  createWeekResizeHandles();
}

function generateDayHeaders() {
  const $headers = $('#day-headers').empty();
  planDays.forEach(d => {
    const date = new Date(d.date);
    const day = date.getDate();
    // No weekend grey highlighting
    $headers.append(`<div class="day-cell text-center border-r py-1 text-xs" style="width:${dayWidth}px">${day}</div>`);
  });
}

function createWeekResizeHandles() {
  const $container = $('#week-headers');
  if ($container.length === 0) return;

  $container.find('.week-resize-handle').remove();
  const $weeks = $container.children('div');
  let cumulativeLeft = 0;

  $weeks.each(function(index) {
    const width = $(this).outerWidth();
    cumulativeLeft += width;
    if (index === $weeks.length - 1) return; // no handle after last week

    $('<div class="week-resize-handle"></div>')
      .css('left', `${cumulativeLeft}px`)
      .appendTo($container);
  });
}

function updateDayWidth(newWidth, source = 'manual') {
  const oldWidth = dayWidth;
  const clamped = Math.max(MIN_DAY_WIDTH, Math.min(MAX_DAY_WIDTH, newWidth));
  dayWidth = clamped;

  if (source === 'zoom') {
    currentZoomIndex = zoomLevels.findIndex(z => Math.abs(z - clamped) < 0.5);
  } else if (source === 'drag') {
    const idx = zoomLevels.findIndex(z => Math.abs(z - clamped) < 0.5);
    currentZoomIndex = idx;
  }

  generateMonthHeaders();
  generateWeekHeaders();
  generateDayHeaders();
  rebuildBackgroundGrid(oldWidth);
  refreshGanttBodyLayout();
}

function bindWeekResizeHandles() {
  $('#week-headers').on('mousedown', '.week-resize-handle', function(e) {
    e.preventDefault();
    isWeekResizing = true;
    resizeStartX = e.clientX;
    resizeStartDayWidth = dayWidth;
    $('body').addClass('resizing-week');
    $(document).on('mousemove.weekResize', onWeekResizeMove);
    $(document).on('mouseup.weekResize', stopWeekResize);
  });
}

function onWeekResizeMove(e) {
  if (!isWeekResizing) return;
  const delta = e.clientX - resizeStartX;
  const proposed = resizeStartDayWidth + (delta * DRAG_SENSITIVITY);
  updateDayWidth(proposed, 'drag');
  $('.metrics-row, .metrics-week').hide();
}

function stopWeekResize() {
  if (!isWeekResizing) return;
  isWeekResizing = false;
  $('body').removeClass('resizing-week');
  $(document).off('mousemove.weekResize', onWeekResizeMove);
  $(document).off('mouseup.weekResize', stopWeekResize);
}

function refreshGanttBodyLayout() {
  const totalDays = getTotalDaysInRange();
  const fullWidth = totalDays * dayWidth;
  const rowTotalWidth = fullWidth + LEFT_COLUMN_WIDTH;

  $('#gantt-rows .grid').each(function() {
    $(this).css({
      width: rowTotalWidth + 'px',
      gridTemplateColumns: `${LEFT_COLUMN_WIDTH}px 1fr`
    });
  });

  $('.task-layer').each(function() {
    $(this).css('width', fullWidth + 'px');
  });

  $('.metrics-row').each(function() {
    $(this).css({
      width: rowTotalWidth + 'px',
      gridTemplateColumns: `${LEFT_COLUMN_WIDTH}px 1fr`
    });
    $(this).find('.flex').css('width', fullWidth + 'px');
    $(this).find('.flex .border-r').css('width', dayWidth + 'px');
  });

  $('.task-layer .task-bar').each(function() {
    const $task = $(this);
    if (!$task.attr('data-start-day')) {
      storeTaskTemporalData($task);
    }
    positionTaskFromData($task);
  });
  
  // Apply grey overlay after all tasks are positioned
  applyGreyOverlay();
}

function calculateTaskData($task, referenceDayWidth) {
  const leftPx = parseFloat($task.css('left')) || 0;
  const widthPx = parseFloat($task.css('width')) || referenceDayWidth || dayWidth;
  const baseWidth = referenceDayWidth || dayWidth;

  return {
    startDay: Math.max(0, Math.round(leftPx / baseWidth)),
    spanDays: Math.max(1, Math.round(widthPx / baseWidth))
  };
}

function storeTaskTemporalData($task, referenceDayWidth) {
  const { startDay, spanDays } = calculateTaskData($task, referenceDayWidth);
  $task.attr('data-start-day', startDay);
  $task.attr('data-span-days', spanDays);
}

function positionTaskFromData($task) {
  const startDay = parseInt($task.attr('data-start-day'), 10);
  const spanDays = parseInt($task.attr('data-span-days'), 10);

  if (!Number.isNaN(startDay)) {
    $task.css('left', (startDay * dayWidth) + 'px');
  }
  if (!Number.isNaN(spanDays)) {
    $task.css('width', (spanDays * dayWidth) + 'px');
  }
}

// Rebuild only the background day grid for all task layers, preserving any tasks.
// If oldDayWidth is provided, also rescale existing task bars from old → new dayWidth.
function rebuildBackgroundGrid(oldDayWidth) {
  const totalDays = getTotalDaysInRange();
  const fullWidth = totalDays * dayWidth;

  const rowTotalWidth = fullWidth + LEFT_COLUMN_WIDTH;

  $('.task-layer').each(function() {
    const $layer = $(this);
    const $row = $layer.closest('.grid');
    $row.css({
      width: rowTotalWidth + 'px',
      gridTemplateColumns: `${LEFT_COLUMN_WIDTH}px 1fr`
    });

    // Detach existing task bars so we can rebuild grid underneath
    const $tasks = $layer.find('.task-bar').detach();

    // Clear and rebuild background grid using planDays (no weekend shading)
    $layer.empty();
    planDays.forEach((d, idx) => {
      $layer.append(`
        <div class="absolute top-0 border-r grid-cell" 
             style="left:${idx * dayWidth}px; width:${dayWidth}px; height:100%; pointer-events:none;"></div>
      `);
    });

    const referenceWidth = oldDayWidth || dayWidth;
    $tasks.each(function() {
      const $t = $(this);
      storeTaskTemporalData($t, referenceWidth);
      positionTaskFromData($t);
    });

    // Ensure layer width matches new zoom and reattach tasks on top of grid
    $layer.css('width', fullWidth + 'px');
    $layer.append($tasks);
    
    // Apply grey overlay after grid is rebuilt and tasks are reattached
    applyGreyOverlay();
  });
}

// Apply grey overlay to all task-layer cells except where group date ranges are active
function applyGreyOverlay() {
  $('.task-layer').each(function() {
    const $layer = $(this);
    const stationId = $layer.closest('[data-line]').data('line');
    
    // First, add grey overlay to all cells
    $layer.find('.grid-cell').addClass('grid-cell').removeClass('no-overlay');
    
    // Find the group details for this station using group_name
    const $stationRow = $layer.closest('.grid');
    const stationName = $stationRow.find('.font-bold').text().trim();
    
    const group = Array.isArray(groupdetails) ? groupdetails.find(g => String(g.group_name) === String(stationName)) : null;
    
    if (group && group.date_from && group.date_to) {
      // Convert date strings to indices in planDays
      let fromIndex = dateIndexMap[group.date_from];
      let toIndex = dateIndexMap[group.date_to];
      
      // Fallback: if from date not found, use the first available date
      if (fromIndex == null) {
        fromIndex = 0; // First available date in planDays
        console.log(`Using fallback: from date ${group.date_from} not found, using index 0`);
      }
      
      // Fallback: if to date not found, use the last available date
      if (toIndex == null) {
        toIndex = planDays.length - 1; // Last available date in planDays
        console.log(`Using fallback: to date ${group.date_to} not found, using index ${toIndex}`);
      }
      
      console.log(`Group: ${group.group_name}, From: ${group.date_from} -> index ${fromIndex}, To: ${group.date_to} -> index ${toIndex}`);
      
      if (fromIndex != null && toIndex != null && fromIndex <= toIndex) {
        // Remove overlay from cells within the group's date range
        for (let i = fromIndex; i <= toIndex; i++) {
          const $cell = $layer.find('.grid-cell').eq(i);
          if ($cell.length) {
            $cell.addClass('no-overlay');
          }
        }
        console.log(`Applied no-overlay to ${toIndex - fromIndex + 1} cells for ${group.group_name}`);
      } else {
        console.log(`Invalid date range for ${group.group_name}: fromIndex=${fromIndex}, toIndex=${toIndex}`);
      }
    } else {
      console.log(`No group found or missing dates for station: ${stationName}`);
    }
  });
}

// Actual implementation of updateRemainder
function updateRemainder() {
  const originalTotal = parseInt($('#split-original-total').text(), 10) || 0;
  let batchTotal = 0;
  
  // Sum all batch inputs
  $('.batch-input').each(function() {
    const value = parseInt($(this).val(), 10) || 0;
    batchTotal += value;
  });
  
  // Calculate remainder
  const remainder = Math.max(0, originalTotal - batchTotal);
  
  // Update UI
  $('#split-remainder').val(remainder);
  $('#split-total-entered').text(batchTotal.toFixed(2));
}

$(document).ready(function() {
  let selectedTask = null;
  let splitTotalDays = 0;
  let currentProcess = 'sewing';

  // Track batch numbering context for the current split
  let currentClickedBatchNo = 1;   // existing batch no of the bar we right-clicked
  let currentMaxBatchNo = 1;       // max existing batch no for this cc+color+station

  // Store converted tasks globally
  let convertedTasks = [];

  // Map to remember batch_id per logical task
  // Uniqueness is enforced by (ccno, color, group_name)
  const batchIdMap = {};

  function buildBatchKey(task) {
    const ccno = String(task.ccno || '');
    const color = String(task.Color || task.color || '');
    const group = String(task.group_name || task.station_id || '');
    return `${ccno}__${color}__${group}`;
  }

  // Helper: collect day-wise metrics (PO+FC, Efficiency, Plan Qty, FG OI) for an order
  function getMetricsForOrder(order) {
    if (!order) return null;

    const stationId = order.station_id;
    const ccno = order.ccno;
    const from = order.date_from;
    const to = order.date_to;

    if (!stationId || !ccno || !from || !to) return null;

    // Prefer explicit day indices stored on the task, fall back to dateIndexMap
    let startIdx = (order.start_day_index != null)
      ? parseInt(order.start_day_index, 10)
      : dateIndexMap[from];
    let endIdx = null;
    if (order.span_days != null) {
      const span = parseInt(order.span_days, 10) || 0;
      endIdx = startIdx != null && span > 0 ? (startIdx + span - 1) : null;
    } else {
      endIdx = dateIndexMap[to];
    }

    if (startIdx == null || endIdx == null) return null;

    // Metrics rows are keyed by title/ccno (e.g. '305836-(BLUE)').
    // Station IDs can differ between task data and metrics rows, so match by ccno only.
    const ccStr = ccno.toString();

    function findMetricsRows() {
      return $('.metrics-row').filter(function() {
        const titleAttr = ($(this).data('title') || '').toString();
        const stationAttr = ($(this).data('station') || '').toString();
        return (titleAttr === ccStr || titleAttr.startsWith(ccStr + '-')) && stationAttr === stationId.toString();
      });
    }

    let $rows = findMetricsRows();
    console.log('getMetricsForOrder: initial metrics-row count', $rows.length, 'for', { stationId, ccno, from, to });

    // If no metrics rows yet, try to auto-create them from the corresponding task bar
    if (!$rows.length) {
      console.log('getMetricsForOrder: no existing metrics rows found, searching for task bar...');
      const $taskBar = $(`.task-bar[data-title="${ccStr}"][data-station="${stationId}"]`).first();
      console.log('getMetricsForOrder: found task bar:', $taskBar.length, 'for selector', `.task-bar[data-title="${ccStr}"][data-station="${stationId}"]`);
      if ($taskBar.length) {
        const domStationId = $taskBar.data('station');
        const taskValue = $taskBar.data('value');
        console.log('getMetricsForOrder: creating metrics rows via createMetricsRows for', { domStationId, ccStr, taskValue });
        if (typeof createMetricsRows === 'function') {
          createMetricsRows(domStationId, ccStr, taskValue, $taskBar);
          $rows = findMetricsRows();
          console.log('getMetricsForOrder: after creation, metrics-row count:', $rows.length);
        }
      } else {
        console.log('getMetricsForOrder: no task bar found for metrics creation');
      }
    }

    console.log('getMetricsForOrder: final metrics-row count', $rows.length, 'for', { stationId, ccno, from, to });

    // Try to get model from the task bar for this ccno/station
    let model = '';
    const $taskBar = $(`.task-bar[data-title="${ccStr}"][data-station="${stationId}"]`).first();
    if ($taskBar.length) {
      model = $taskBar.data('model') || '';
    }

    $.ajax({
      url: "/getpofcdata",
      type: "GET",
      dataType: "json",
      data: { ccno: ccno, modelid: model },
      success: function(response) {
        const pofcdata = response && Array.isArray(response.data) ? response.data : [];
        console.log('getMetricsForOrder: fetched PO/FC data', pofcdata);

        // Locate PO + FC, PO and FC metrics rows for this station/order
        const $rowPOFC = $rows.filter(function() {
          const label = $(this).find('.font-medium').first().text().trim();
          return label.indexOf('PO + FC') === 0;
        }).first();

        const $rowPO = $rows.filter(function() {
          const label = $(this).find('.font-medium').first().text().trim();
          return label.indexOf('PO') === 0 && label.indexOf('PO + FC') !== 0;
        }).first();

        const $rowFC = $rows.filter(function() {
          const label = $(this).find('.font-medium').first().text().trim();
          return label.indexOf('FC') === 0;
        }).first();

        if (!$rowPOFC.length && !$rowPO.length && !$rowFC.length) {
          console.log('getMetricsForOrder: no PO/FC rows to populate for', { stationId, ccno });
          return;
        }

        // Map Qty / PO_Qty / Fc_Qty by WDate using dateIndexMap
        const poFcByDayIndex = {};
        const poByDayIndex = {};
        const fcByDayIndex = {};
        const ccStrLocal = String(ccno);

        pofcdata.forEach(function(row) {
          if (!row) return;

          const ccField = row.CC || row.cc || row.ccno || null;
          if (String(ccField || '') !== ccStrLocal) return;

          const rawDate = row.WDate || row.Wdate || row.wdate || row.Delivery_Date || row.delivery_date || null;
          if (!rawDate) return;

          let dateOnly = null;
          if (typeof rawDate === 'string') {
            dateOnly = rawDate.split(' ')[0];
          } else {
            try {
              const d = new Date(rawDate);
              if (!isNaN(d)) {
                dateOnly = d.toISOString().split('T')[0];
              }
            } catch (e) {
              dateOnly = null;
            }
          }

          if (!dateOnly) return;
          const idx = dateIndexMap[dateOnly];
          if (idx == null) return; // date not in visible planDays

          // Only populate if within the task bar's span
          if (idx < startIdx || idx > endIdx) return;

          const qtyVal = row.Qty ?? row.qty ?? null;
          const poQtyVal = row.PO_Qty ?? row.po_qty ?? row.POQty ?? null;
          const fcQtyVal = row.Fc_Qty ?? row.FC_Qty ?? row.fc_qty ?? null;

          function accumulate(map, value) {
            if (value == null || value === '' || isNaN(value)) return;
            const num = Number(value);
            if (map[idx] == null) {
              map[idx] = num;
            } else {
              map[idx] += num;
            }
          }

          accumulate(poFcByDayIndex, qtyVal);
          accumulate(poByDayIndex, fcQtyVal);
          accumulate(fcByDayIndex, poQtyVal);
        });

        function fillRow($row, map) {
          if (!$row || !$row.length) return;
          Object.keys(map).forEach(function(dStr) {
            const dayIndex = parseInt(dStr, 10);
            const val = map[dayIndex];
            const display = val != null ? val : '';
            const $cellSpan = $row
              .find(`.metrics-cell[data-day-index="${dayIndex}"] span`)
              .first();
            if ($cellSpan.length) {
              $cellSpan.text(display);
            }
          });
        }

        fillRow($rowPOFC, poFcByDayIndex);
        fillRow($rowPO, poByDayIndex);
        fillRow($rowFC, fcByDayIndex);
      }
    });

    if (!$rows.length) {
      console.log('getMetricsForOrder: no metrics rows found for', { stationId, ccno, from, to });
      return null;
    }

    function pickRow(matchFn) {
      return $rows.filter(function() {
        const label = $(this).find('.font-medium').first().text().trim();
        return matchFn(label);
      }).first();
    }

    const $rowPOFC = pickRow(label => label.indexOf('PO + FC') === 0);
    const $rowEff  = pickRow(label => label.indexOf('Efficiency') === 0);
    const $rowPlan = pickRow(label => label.indexOf('Plan Qty') === 0);
    const $rowFgOi = pickRow(label => label.indexOf('FG OI') === 0);
    const $rowPO   = pickRow(label => label === 'PO');
    const $rowFC   = pickRow(label => label === 'FC');

    // Build metrics keyed by date: { 'YYYY-MM-DD': { po_fc, efficiency, plan_qty, fg_oi, po, fc }, ... }
    const metricsByDate = {};
    for (let d = startIdx; d <= endIdx; d++) {
      const dayInfo = planDays[d];
      if (!dayInfo || !dayInfo.date) continue;
      const dateKey = dayInfo.date; // already in YYYY-MM-DD

      function getCellText($row) {
        if (!$row || !$row.length) return '';
        const $cellSpan = $row
          .find(`.metrics-cell[data-day-index="${d}"] span`)
          .first();
        return ($cellSpan.text() || '').toString().trim();
      }

      metricsByDate[dateKey] = {
        po_fc: getCellText($rowPOFC),
        efficiency: getCellText($rowEff),
        plan_qty: getCellText($rowPlan),
        fg_oi: getCellText($rowFgOi),
        po: getCellText($rowPO),
        fc: getCellText($rowFC)
      };
    }

    console.log('getMetricsForOrder: built metrics', { order, startIdx, endIdx, metricsByDate });
    return metricsByDate;
  }

  // Function to log all task data with context
  function logAllTaskData(action, specificTask = null) {
    console.log(`=== ${action.toUpperCase()} TASK DATA ===`);
    
    let ordersToSend = [];
    
    // For split tasks
    if (action === 'split') {
        const splitTasks = convertedTasks.filter(task => task.batch_number);
        ordersToSend = splitTasks.map(task => ({
            ...task,
            date_from: task.date_from,
            date_to: task.date_to
        }));
    }
    // For a single specific task
    else if (specificTask) {
        // Wrap single object in an array
        ordersToSend = [{
            ...specificTask,
            date_from: specificTask.date_from,
            date_to: specificTask.date_to
        }];
    }

    // Attach any known batch_id from previous saves
    if (ordersToSend.length > 0) {
      ordersToSend = ordersToSend.map(order => {
        const key = buildBatchKey(order);
        const existingBatchId = batchIdMap[key];
        const withBatch = existingBatchId
          ? { ...order, batch_id: existingBatchId }
          : { ...order };

        // Attach day-wise metrics from the current metrics rows snapshot
        console.log('logAllTaskData: getting metrics for order', withBatch);
        const metrics = getMetricsForOrder(withBatch) || {};
        console.log('logAllTaskData: metrics returned', metrics);
        withBatch.metrics = metrics;

        return withBatch;
      });
    }

    // Send AJAX request
    if (ordersToSend.length > 0) {
      $.ajax({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          url: "/saveunplannedorders",
          type: "POST",
          data: JSON.stringify({ orders: ordersToSend }),
          contentType: "application/json",
          success: function(res) {

              // Backend returns ids_against_batch keyed by (ccno__color__group_name)
              const idsMap = res.ids_against_batch || {};
              console.log("ids_against_batch from server:", idsMap);

              // If only one logical task was sent, also read the convenience batch_id
              if (ordersToSend.length === 1 && res.batch_id) {
                const singleKey = buildBatchKey(ordersToSend[0]);
                batchIdMap[singleKey] = res.batch_id;
              }

              // For robustness, also merge any explicit ids_against_batch entries
              Object.keys(idsMap).forEach(function(k) {
                const v = idsMap[k];
                if (v) {
                  batchIdMap[k] = v;
                }
              });

              console.log("Updated batchIdMap:", batchIdMap);

          },
          error: function(err) {
              console.error("Error saving:", err);
          }
      });


        console.log(ordersToSend);
    }
    
    console.log('========================');
  }

  // Actual implementation of openSplitModal (single clicked bar only, but global numbering)
  function openSplitModal($task) {

    selectedTask = $task;

    const taskTitle = $task.data('title') || '';
    const stationId = $task.data('station') || '';
    const taskTitleColor = $task.data('titlecolor') || '';

    // Existing batch number of the clicked bar (default 1 if none)
    const clickedBatchNo = parseInt($task.data('batch'), 10) || 1;

    // Find all existing batch bars for this cc+color+station
    const $allBatches = $(`.task-bar[data-title="${taskTitle}"][data-station="${stationId}"][data-titlecolor="${taskTitleColor}"]`);

    let maxBatchNo = clickedBatchNo;
    const otherBatches = [];

    $allBatches.each(function() {
      const $b = $(this);
      const bNo = parseInt($b.data('batch'), 10) || 1;
      const span = parseInt($b.attr('data-span-days'), 10)
                   || Math.round((parseInt($b.css('width')) || dayWidth) / dayWidth)
                   || 1;

      // Do not add the currently clicked bar itself to the info list
      if ($b.is($task)) {
        // Special rule: when splitting Batch 1, we never show Batch 1 in the info list
        // (even if there are multiple Batch 1 bars)
      } else if (clickedBatchNo === 1 && bNo === 1) {
        // Skip all Batch 1 entries when the popup is for Batch 1
      } else {
        otherBatches.push({ batchNo: bNo, span });
      }

      if (!isNaN(bNo) && bNo > maxBatchNo) {
        maxBatchNo = bNo;
      }
    });

    // Compute spans for clicked bar and all existing batches so the total
    // reflects the sum of ALL batch days for this cc+color+station
    let batches = [];
    let totalSpanDays = 0;

    const spanDays = parseInt($task.attr('data-span-days'), 10)
                     || Math.round((parseInt($task.css('width')) || dayWidth) / dayWidth)
                     || 1;

    // The clicked bar keeps its current batch number in the popup (e.g. Batch 2)
    batches.push({ batchNo: clickedBatchNo, span: spanDays });

    // Start total from the clicked span and add all other batch spans
    totalSpanDays = spanDays;
    otherBatches.forEach(ob => {
      totalSpanDays += ob.span;
    });

    // Remember numbering context for confirm-split
    currentClickedBatchNo = clickedBatchNo;
    currentMaxBatchNo = maxBatchNo;

    console.log('Open split modal (single bar):', { taskTitle, stationId, taskTitleColor, batches, maxBatchNo });

    // Build display title with color, e.g. 305836-(PURPLE)
    const displayTitle = taskTitleColor
      ? `${taskTitle}-(${taskTitleColor})`
      : `${taskTitle}`;

    // Update modal title/subtitle with color-aware title
    $('#split-modal h2').text(`Split Process: ${displayTitle}`);
    $('#split-modal p').html(
      `For Order ${displayTitle}. Adjust the values for the total of <strong>${totalSpanDays}</strong> Days.<br>
      The sum must equal the total.`
    );

    // Reset modal totals
    $('#split-original-total').text(totalSpanDays);
    $('#split-remainder').val(0);
    $('#split-total-entered').text('0.00');

    // Remove all existing batch rows and info blocks
    $('.batch-row').remove();
    $('.existing-batches-info').remove();

    // Build a combined list of batches (existing + clicked) that will all be editable
    let allBatches = [];

    // Add existing batches (excluding the clicked bar itself)
    otherBatches.forEach(ob => {
      allBatches.push({ batchNo: ob.batchNo, span: ob.span, isExisting: true });
    });

    // Add the clicked batch
    allBatches.push({ batchNo: clickedBatchNo, span: spanDays, isExisting: false });

    // Sort by batch number so rows appear in order
    allBatches.sort((a, b) => a.batchNo - b.batchNo);

    // Insert editable rows for all batches before the remainder row
    const $remainderRow = $('#split-remainder').closest('.grid');
    allBatches.forEach(b => {
      const $row = $(`
        <div class="grid grid-cols-2 items-center mb-3 px-1 batch-row" data-batch="${b.batchNo}" data-existing="${b.isExisting}">
          <span class="text-gray-700 text-sm">Batch ${b.batchNo}</span>
          <div class="relative w-full">
            <input type="number" value="${b.span}" class="border rounded-md px-3 pr-8 py-2 text-sm w-full focus:ring-1 focus:ring-blue-400 focus:border-blue-400 batch-input" />
            <button class="absolute bg-red-100 rounded right-2 top-1/2 -translate-y-1/2 text-red-500 hover:text-red-700 text-sm remove-batch-btn">
              <i class="fa-solid fa-minus"></i>
            </button>
          </div>
        </div>
      `);
      $remainderRow.before($row);
    });

    // Ensure newly added rows get NEW batch numbers after the current global max
    // (batchCount is incremented before use in the Add Batch handler)
    batchCount = Math.max(1, maxBatchNo);

    // Re-bind input handlers
    $('.batch-input').off('input').on('input', updateRemainder);
    updateRemainder();

    // Show the modal
    $('#split-modal').show();
   
  }

  // Simple incremental generator for client‑side unique task IDs
  let nextTaskId = 1002;

  // Convert a dropped small card into a task data object and store it
  // rowIndex (from resultData) makes each card/task uniquely tied to its backend row
  function convertToTask(title, titleColor, value, stationId, left, width, taskId, rowIndex) {
    // Calculate day indices from position
    const startDay = Math.round(left / dayWidth);
    const spanDays = Math.round(width / dayWidth);
    const endDay = startDay + spanDays - 1;

    // Convert indices to actual dates using planDays so that task bars
    // follow the same working-day sequence as the header (NH_Days_Woven_Plan_Proc)
    let taskDateFromStr = null;
    let taskDateToStr = null;
    if (Array.isArray(planDays) && planDays.length) {
      const fromInfo = planDays[startDay];
      const toInfo   = planDays[endDay];
      if (fromInfo && fromInfo.date) {
        taskDateFromStr = fromInfo.date;
      }
      if (toInfo && toInfo.date) {
        taskDateToStr = toInfo.date;
      }
    }
    // Fallback to calendar-based dates only if planDays mapping is missing
    if (!taskDateFromStr || !taskDateToStr) {
      const taskDateFrom = new Date(startDate);
      taskDateFrom.setDate(taskDateFrom.getDate() + startDay);
      const taskDateTo = new Date(startDate);
      taskDateTo.setDate(taskDateTo.getDate() + endDay);
      taskDateFromStr = taskDateFrom.toISOString().split('T')[0];
      taskDateToStr = taskDateTo.toISOString().split('T')[0];
    }

    // Find the matching resultData row to pull other fields
    // Prefer an explicit rowIndex (unique per row), fallback to ccno+Color match
    let sourceRow = {};
    if (Array.isArray(resultData)) {
      if (Number.isInteger(rowIndex) && resultData[rowIndex]) {
        sourceRow = resultData[rowIndex];
      } else {
        sourceRow = resultData.find(r => {
          const ccMatch = String(r.ccno) === String(title);
          const colorMatch = String((r.Color || '')).trim().toLowerCase() === String(titleColor || '').trim().toLowerCase();
          return ccMatch && colorMatch;
        }) || {};
      }
    }

    // Map stationId (typically cc_no for sewing) to actual group/station name from groupdetails
    let groupName = stationId;
    if (Array.isArray(groupdetails) && groupdetails.length) {
      const g = groupdetails.find(gd => String(gd.cc_no || '') === String(stationId || ''));
      if (g && g.group_name) {
        groupName = g.group_name;
      }
    }

    const effectiveTaskId = taskId || `task_${nextTaskId++}`;

    const taskData = {
      task_id: effectiveTaskId,
      station_id: stationId,
      start_day_index: startDay,
      span_days: spanDays,
      Color: titleColor || (sourceRow.Color || ''),
      Pend_Qty: sourceRow.Pend_Qty || '',
      Sel_Qty: value,
      Tot_days: String(spanDays),
      ccno: title,
      date_from: taskDateFromStr,
      date_to: taskDateToStr,
      group_name: groupName,
      id: sourceRow.id || '',
      unit_id: sourceRow.unit_id || '',
      // Include model so it can be saved by /saveunplannedorders
      model: sourceRow.Model || sourceRow.Item || ''
    };

    // Store the task
    convertedTasks.push(taskData);
    logAllTaskData('converted', taskData);
    return taskData;
  }

  const processData = {
    cutting: { unplannedText: 'All Cutting processes are scheduled.', smallCards: [{ title: '114227', value: '12491', color: 'bg-blue-100 text-blue-800' },{ title: '114228', value: '12491', color: 'bg-green-100 text-green-800' }], stations: [{ name: 'Cutting Station 1', id: 'CT-1' }] },
    printing: { unplannedText: 'All Printing processes are scheduled.', smallCards: [{ title: '114229', value: '12491', color: 'bg-blue-100 text-blue-800' }], stations: [{ name: 'Printing Station 1', id: 'PR-1' }] },
    embroidery: { unplannedText: 'All Embroidery processes are scheduled.', smallCards: [{ title: '114230', value: '12491', color: 'bg-blue-100 text-blue-800' }], stations: [{ name: 'Embroidery Station 1', id: 'EM-1' }] },
    sewing: {
      unplannedText: 'All Sewing (QTY) processes are scheduled.',
      smallCards: [
        { titlecolor: 'red', title: '114231', value: '12491', color: 'bg-red-100 text-blue-800' },
        { titlecolor: 'red', title: '10000',  value: '20000', color: 'bg-red-500 text-red-800' }
      ],
      stations: [
        { name: 'SLG-1', id: 'SLG-1' },
        { name: 'SLG-2', id: 'SLG-2' }
      ]
    },
    packing: { unplannedText: 'All Packing processes are scheduled.', smallCards: [{ titlecolor: 'red', title: '114232', value: '12491', color: 'bg-blue-100 text-blue-800' }], stations: [{ name: 'Packing Station 1', id: 'PK-1' }] }
  };

  updateYear();

  // Initialize Unit filter options from resultData
  (function initUnitFilter() {
    const $unitSelect = $('#filter-unit');
    if (!$unitSelect.length || !Array.isArray(resultData)) return;
    const units = [...new Set(resultData.map(r => r.unit_id).filter(Boolean))];
    units.forEach(u => {
      $unitSelect.append(`<option value="${u}">${u}</option>`);
    });
  })();

  // Apply filters on resultData for sewing small cards
  // Also attach a stable __rowIndex so each card is uniquely tied to its backend row
  function getFilteredResultData() {
    if (!Array.isArray(resultData)) return [];

    return resultData
      .map((row, idx) => ({ ...row, __rowIndex: idx }))
      .filter(row => {

      // OCN filter (ccno contains text)
      if (filterState.ocn) {
        const cc = String(row.ccno || '').toLowerCase();
        if (!cc.includes(filterState.ocn.toLowerCase())) return false;
      }

      // Unit filter
      if (filterState.unit) {
        if (String(row.unit_id || '') !== String(filterState.unit)) return false;
      }

      // Date range filter (date_from/date_to assumed YYYY-MM-DD)
      if (filterState.dateFrom || filterState.dateTo) {
        const from = String(row.date_from || '');
        const to   = String(row.date_to   || '');

        // simple string compare is fine for ISO yyyy-mm-dd
        if (filterState.dateFrom && (from < filterState.dateFrom && to < filterState.dateFrom)) {
          return false;
        }
        if (filterState.dateTo && (from > filterState.dateTo && to > filterState.dateTo)) {
          return false;
        }
      }

      return true;
    });
  }

  // Map color names from resultData (e.g. BLUE, PINK, PURPLE) to Tailwind classes
  const cardColorClasses = [
    'bg-blue-100 text-blue-800',    // 1
    'bg-pink-100 text-pink-800',    // 2
    'bg-purple-100 text-purple-800',// 3
    'bg-yellow-100 text-yellow-800',       // 4 (black)
    'bg-yellow-100 text-gray-800',    // 5 (white)
    'bg-amber-100 text-amber-800',  // 6 (khaki)
    'bg-red-100 text-red-800',      // 7
    'bg-green-100 text-green-800'   // 8
  ];

  // Sequence order: 8 4 7 3 6 2 5 1 (1-based indices mapped to 0-based)
  const cardColorSequence = [7, 3, 6, 2, 5, 1, 4, 0];
  let cardColorIndex = 0;

  function getCardColorClasses(rawColorName) {
    const seqPos = cardColorIndex % cardColorSequence.length;
    const colorIdx = cardColorSequence[seqPos];
    cardColorIndex += 1;
    return cardColorClasses[colorIdx] || 'bg-blue-100 text-blue-800';
  }

  function renderSmallCards(processName) {
    $('#small-cards-container').empty();
    let cards = (processData[processName]?.smallCards || []);

    // For sewing, build cards dynamically from resultData
    if (processName === 'sewing' && Array.isArray(resultData) && resultData.length) {
      const filtered = getFilteredResultData();
      cards = filtered.map(row => ({
        title: row.ccno,
        titlecolor: (row.Color || '').trim(),
        value: row.Sel_Qty,
        rowIndex: row.__rowIndex,
        model: row.Model || row.Item || '',
        // Use background/text color based on color name for better visibility
        color: getCardColorClasses(row.Color)
      }));
    }

    cards.forEach(card => {
      $('#small-cards-container').append(`
        <div class="${card.color} rounded-lg p-3 mb-2 cursor-move small-card shadow hover:shadow-md" data-title="${card.title}" data-titlecolor="${card.titlecolor || ''}" data-value="${card.value}" data-color="${card.color}" data-row-index="${card.rowIndex}" data-model="${card.model || ''}">
          <div class="flex justify-between text-xs font-medium">
            <span>${card.title}/${card.titlecolor}</span>
            <span><strong>${parseInt(card.value)}</strong></span>
          </div>
        </div>
      `);
    });

    $('.small-card').draggable({ helper: 'clone', cursor: 'move', revert: 'invalid', zIndex: 1000 });

    // Hover tooltip for unplanned small cards
    $('.small-card').off('mouseenter.unptip mouseleave.unptip');
    $('.small-card').on('mouseenter.unptip', function () {
      const $card = $(this);
      const ccno = $card.data('title');
      const colorName = ($card.data('titlecolor') || '').toString();
      const totalQty = $card.data('value') || '';

      let row = null;
      if (Array.isArray(resultData)) {
        row = resultData.find(r => {
          const ccMatch = String(r.ccno) === String(ccno);
          const colorMatch = String((r.Color || '').trim().toLowerCase()) === String(colorName).trim().toLowerCase();
          return ccMatch && colorMatch;
        }) || null;
      }

      const model = row && (row.Model || row.Item) ? (row.Model || row.Item) : ($card.data('model') || '');

      const $tip = $('#unplanned-card-tooltip');
      if ($tip.length) {
        $('#uc-tip-ccno').text(ccno || '');
        $('#uc-tip-color').text(colorName || '');
        $('#uc-tip-model').text(model || '');
        $('#uc-tip-qty').text(totalQty || '');

        // Match background color with the card's computed background color
        const cardBg = $card.css('background-color');
        if (cardBg) {
          $tip.css('background-color', cardBg);
        }

        $tip.show();
      }
    });

    $('.small-card').on('mouseleave.unptip', function () {
      $('#unplanned-card-tooltip').hide();
    });
  }

  function renderGanttRows(processName) {
    // Console log chart timeline dates in dd-MMM-yyyy format
    const fromDate = startDate.getDate() + '-' + 
                    startDate.toLocaleString('en-US', { month: 'short' }).toLowerCase() + '-' + 
                    startDate.getFullYear();
    const toDate = endDate.getDate() + '-' + 
                  endDate.toLocaleString('en-US', { month: 'short' }).toLowerCase() + '-' + 
                  endDate.getFullYear();
    console.log(`Chart Timeline: ${fromDate} to ${toDate}`);
    
    const $rows = $('#gantt-rows').empty();
    const totalDays = getTotalDaysInRange();
    const fullWidth = totalDays * dayWidth;
    const rowTotalWidth = fullWidth + LEFT_COLUMN_WIDTH;
    // Default stations from static config
    let stations = (processData[processName]?.stations || []);

    // For sewing, prefer dynamic stations from backend groupdetails
    if (processName === 'sewing' && Array.isArray(groupdetails) && groupdetails.length) {
      stations = groupdetails.map(g => ({
        // Use group_name for display and cc_no for id
        name: g.group_name || '',
        id: g.cc_no || g.group_name || g.id || ''
      }));
    }

    stations.forEach(station => {
      $rows.append(`
        <div class="grid border-b hover:bg-gray-50" style="grid-template-columns: ${LEFT_COLUMN_WIDTH}px 1fr; width: ${rowTotalWidth}px;">
            <div class="py-0 pl-4 border-r bg-gray-50 text-sm sticky left-0 z-30" style="position: sticky;">
            <div class="font-bold">${station.name}</div>
            <div class="text-xs text-gray-500">${station.id}</div>
            </div>
            <div class="relative h-[40px] overflow-visible" data-line="${station.id}">
            <div class="task-layer absolute inset-0" style="width:${fullWidth}px;"></div>
            </div>
        </div>
        `);
    });

    // Full year grid lines + weekend shading
    rebuildBackgroundGrid(null);
    refreshGanttBodyLayout();
    // Helper: for a given card (ccno/title) return the allowed station id (cc_no)
    function getAllowedStationForCard(title) {
      if (!Array.isArray(resultData) || !Array.isArray(groupdetails)) return null;
      const row = resultData.find(r => String(r.ccno) === String(title));
      if (!row) return null;
      const g = groupdetails.find(gd => String(gd.cc_no || '') === String(row.ccno || ''));
      if (!g) return null;
      return g.cc_no || g.group_name || g.id || null;
    }

    // Droppable with proper ORANGE task bar and validation per group
    $('.task-layer').droppable({
      accept: '.small-card',
      tolerance: 'pointer',
      over: function (event, ui) {
        // Only enforce mapping for sewing process
        if (processName !== 'sewing') return;
        const $layer = $(this);
        const stationId = $layer.closest('[data-line]').data('line');
        const title = ui.draggable.data('title');
        const valiue = ui.draggable.data('value');
        console.log(valiue);
        const allowedStation = getAllowedStationForCard(title);
        if (!allowedStation || String(stationId) !== String(allowedStation)) {
          ui.helper.css('cursor', 'not-allowed');
        } else {
          ui.helper.css('cursor', 'move');
        }
      },
      out: function (event, ui) {
        ui.helper.css('cursor', 'move');
      },
      drop: function (event, ui) {
        const $layer = $(this);
        const stationId = $layer.closest('[data-line]').data('line');
        const title = ui.draggable.data('title');

        // Validate placement for sewing: only allow card on its mapped group
        if (processName === 'sewing') {
          const allowedStation = getAllowedStationForCard(title);
          if (!allowedStation || String(stationId) !== String(allowedStation)) {
            ui.helper.css('cursor', 'not-allowed');
            return; // cancel drop: do not create task bar or remove card
          }
        }

        const titleColor = ui.draggable.data('titlecolor') || '';
        const rowIndex = parseInt(ui.draggable.attr('data-row-index'), 10);

        // default value if card didn't have one
        const value = ui.draggable.data('value') || 24;
        const color = ui.draggable.data('color') || 'bg-blue-100 text-blue-800';
        const model = ui.draggable.data('model') || '';

        const offset = $layer.offset();
        let left = event.clientX - offset.left;
        left = Math.max(0, Math.round(left / dayWidth) * dayWidth);

        // Generate a unique task id for this new bar
        const taskId = `task_${nextTaskId++}`;

        // Calculate taskbar span based on total quantity and per-day plan quantity

        let defaultDays = 14;
        if (processName === 'sewing' && Array.isArray(resultData)) {
          // Prefer the exact backend row by index when available
          let match = (Number.isInteger(rowIndex) && resultData[rowIndex])
            ? resultData[rowIndex]
            : resultData.find(r => {
              const ccMatch = String(r.ccno) === String(title);
              const colorMatch = String((r.Color || '').trim().toLowerCase()) === String(titleColor || '').trim().toLowerCase();
              return ccMatch && colorMatch;
            }) || {};

          if (match) {
            // Calculate based on total quantity and per-day plan quantity
            const totalQty = parseInt(value); //parseInt(match.Pend_Qty || match.Sel_Qty );
            console.log('Total quantity (from Pend_Qty):', totalQty, 'Sel_Qty was:', match.Sel_Qty);
            
            // Calculate per-day plan quantity using the formula: ((480 / Sam) * Operators) * (Eff_Perc / 100)
            let perDayPlanQty = 870; // default fallback
            if (match.Sam && match.Operators && match.Eff_Perc) {
              const sam = parseFloat(match.Sam);
              const operators = parseFloat(match.Operators);
              const effPerc = parseFloat(match.Eff_Perc);
              const perdayqty = parseFloat(match.Perday_Qty);
              
              if (!isNaN(sam) && sam > 0 && !isNaN(operators) && operators > 0 && !isNaN(effPerc) && effPerc > 0) {
                perDayPlanQty = Math.round( perdayqty * (effPerc / 100));
                console.log('Calculated per-day plan qty:', perDayPlanQty, 'from Sam:', sam, 'Operators:', operators, 'Eff%', effPerc);
              }
            }
            
            console.log('Taskbar calculation:', {
              title: title,
              totalQty: totalQty,
              perDayPlanQty: perDayPlanQty,
              match: match
            });
            
            // Always use quantity-based calculation if totalQty is available
            if (totalQty > 0 && perDayPlanQty > 0) {
              // Calculate days needed: total_qty / per_day_plan_qty, rounded up
              defaultDays = Math.max(1, Math.ceil(totalQty / perDayPlanQty));
              console.log('Calculated days:', defaultDays, 'from', totalQty, '/', perDayPlanQty);
            } else {
              // Fallback to date range calculation if quantity calculation not available
              if (match.date_from && match.date_to) {
                const fromDate = new Date(match.date_from);
                const toDate   = new Date(match.date_to);
                const startIdx = Math.max(0, Math.round((fromDate - startDate) / (24 * 60 * 60 * 1000)));
                const endIdx   = Math.max(startIdx, Math.round((toDate - startDate) / (24 * 60 * 60 * 1000)));
                defaultDays = Math.max(1, endIdx - startIdx + 1);
                console.log('Using date range calculation:', defaultDays, 'days');
              }
            }
          }
        }

        // Prevent overlap with existing task bars on the same line.
        // If a bar already exists and this new bar would overlap it,
        // move the new bar so it starts on the next day after the
        // last overlapping bar's end day.
        let proposedStartDay = Math.round(left / dayWidth);
        let proposedSpanDays = defaultDays;
        let proposedEndDay = proposedStartDay + proposedSpanDays - 1;

        let latestBlockingEnd = null;

        $layer.find('.task-bar').each(function () {
          const $existing = $(this);
          const startDayAttr = parseInt($existing.attr('data-start-day'), 10);
          const spanDaysAttr = parseInt($existing.attr('data-span-days'), 10);

          // Fallback to calculating from CSS if attributes are missing
          const existingStartDay = !Number.isNaN(startDayAttr)
            ? startDayAttr
            : Math.round(($existing.position().left || 0) / dayWidth);
          const existingSpanDays = !Number.isNaN(spanDaysAttr)
            ? spanDaysAttr
            : Math.max(1, Math.round((parseFloat($existing.css('width')) || dayWidth) / dayWidth));

          const existingEndDay = existingStartDay + existingSpanDays - 1;

          const overlaps = existingStartDay <= proposedEndDay && existingEndDay >= proposedStartDay;
          if (overlaps) {
            if (latestBlockingEnd === null || existingEndDay > latestBlockingEnd) {
              latestBlockingEnd = existingEndDay;
            }
          }
        });

        if (latestBlockingEnd !== null) {
          proposedStartDay = latestBlockingEnd + 1;
          proposedEndDay = proposedStartDay + proposedSpanDays - 1;

          // Clamp within available planDays range if needed
          if (Array.isArray(planDays) && planDays.length) {
            const maxEndIndex = planDays.length - 1;
            if (proposedEndDay > maxEndIndex) {
              const overflow = proposedEndDay - maxEndIndex;
              proposedStartDay = Math.max(0, proposedStartDay - overflow);
              proposedEndDay = proposedStartDay + proposedSpanDays - 1;
            }
          }

          left = proposedStartDay * dayWidth;
        }

        const $task = $(`
            <div class="task-bar ${color} text-white font-medium text-xs rounded-lg shadow-md border-2 border-white flex items-center justify-start cursor-pointer"
                style="left:${left}px; width:${dayWidth * defaultDays}px; position:absolute; height:32px; box-sizing:border-box;"
                data-task-id="${taskId}" data-station="${stationId}" data-title="${title}" data-titlecolor="${titleColor}" data-value="${value}" data-color="${color}" data-card-color="${color}" data-model="${model}">
                <div class="flex" style="width: 20px; height: 100%; position: absolute; left: 0; top: 0;">
                    <div class="flex gap-0.5 flex-col justify-center items-center" style="width: 10px; height: 100%;">
                        <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                        <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                        <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                    </div>
                    <div class="flex gap-0.5 flex-col justify-center items-center" style="width: 10px; height: 100%;">
                        <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                        <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                        <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                    </div>
                </div>
                <span style="margin-left: 24px;">
                 <i class="fa-solid fa-scissors"></i> ${title}${titleColor ? `-(${titleColor})` : ''} - ${value}
                </span>

            </div>
        `).appendTo($layer);

        initTaskBar($task);
        
        // Apply grey overlay after new task is added
        applyGreyOverlay();

        // Store converted task data with actual placement dates, keyed by task_id and rowIndex
        convertToTask(title, titleColor, value, stationId, left, dayWidth * defaultDays, taskId, Number.isInteger(rowIndex) ? rowIndex : undefined);

        // Remove the original card from small-cards-container
        ui.draggable.remove();
      }
    });
  }

  function initTaskBar($task) {
    // ensure consistent css width numeric value
    $task.css('box-sizing', 'border-box');
    $task.attr('data-start-day', calculateTaskData($task).startDay);
    $task.attr('data-span-days', calculateTaskData($task).spanDays);

    $task.draggable({
      containment: $task.parent(),
      grid: [dayWidth, 0],
      cursor: "move",

      start: () => {
        // Mark as dragging so the click handler knows to ignore the drop click
        $task.data('dragging', true);
        $task.addClass('ring-4 ring-orange-300');
      },
      stop: () => {
        $task.removeClass('ring-4 ring-orange-300');
        let l = Math.round($task.position().left / dayWidth) * dayWidth;

        // Prevent overlap when dragging existing task bars.
        // If the dragged bar would overlap others on the same line,
        // move it so it starts on the next day after the last
        // overlapping bar's end day.
        const $layer = $task.parent();

        let proposedStartDay = Math.round(l / dayWidth);
        let spanDaysForDrag = Math.max(1, Math.round((parseFloat($task.css('width')) || dayWidth) / dayWidth));
        let proposedEndDay = proposedStartDay + spanDaysForDrag - 1;

        let latestBlockingEnd = null;

        $layer.find('.task-bar').each(function () {
          const $existing = $(this);
          if ($existing[0] === $task[0]) return; // skip self

          const startDayAttr = parseInt($existing.attr('data-start-day'), 10);
          const spanDaysAttr = parseInt($existing.attr('data-span-days'), 10);

          const existingStartDay = !Number.isNaN(startDayAttr)
            ? startDayAttr
            : Math.round(($existing.position().left || 0) / dayWidth);
          const existingSpanDays = !Number.isNaN(spanDaysAttr)
            ? spanDaysAttr
            : Math.max(1, Math.round((parseFloat($existing.css('width')) || dayWidth) / dayWidth));

          const existingEndDay = existingStartDay + existingSpanDays - 1;

          const overlaps = existingStartDay <= proposedEndDay && existingEndDay >= proposedStartDay;
          if (overlaps) {
            if (latestBlockingEnd === null || existingEndDay > latestBlockingEnd) {
              latestBlockingEnd = existingEndDay;
            }
          }
        });

        if (latestBlockingEnd !== null) {
          proposedStartDay = latestBlockingEnd + 1;
          proposedEndDay = proposedStartDay + spanDaysForDrag - 1;

          if (Array.isArray(planDays) && planDays.length) {
            const maxEndIndex = planDays.length - 1;
            if (proposedEndDay > maxEndIndex) {
              const overflow = proposedEndDay - maxEndIndex;
              proposedStartDay = Math.max(0, proposedStartDay - overflow);
              proposedEndDay = proposedStartDay + spanDaysForDrag - 1;
            }
          }

          l = proposedStartDay * dayWidth;
        }

        $task.css('left', l + 'px');
        $task.attr('data-start-day', calculateTaskData($task).startDay);
        $task.attr('data-span-days', calculateTaskData($task).spanDays);
        
        // Clear dragging flag after a short delay so normal clicks work afterwards
        setTimeout(() => {
          $task.data('dragging', false);
        }, 50);
        
        // Apply grey overlay after task is repositioned
        applyGreyOverlay();

        // Get task data from element attributes
        const taskTitle = $task.data('title') || '';
        const taskValue = $task.data('value') || '';
        const stationId = $task.data('station') || '';

        // Log updated task data after drag
        const startDay = Math.round(l / dayWidth);
        const spanDays = Math.round(parseFloat($task.css('width')) / dayWidth);
        const endDay = startDay + spanDays - 1;

        // Map drag result back to dates using planDays so the task layer
        // and header share the same working-day axis
        let newDateFromStr = null;
        let newDateToStr = null;
        if (Array.isArray(planDays) && planDays.length) {
          const fromInfo = planDays[startDay];
          const toInfo   = planDays[endDay];
          if (fromInfo && fromInfo.date) {
            newDateFromStr = fromInfo.date;
          }
          if (toInfo && toInfo.date) {
            newDateToStr = toInfo.date;
          }
        }
        // Fallback to calendar-based dates only if planDays mapping is missing
        if (!newDateFromStr || !newDateToStr) {
          const newDateFrom = new Date(startDate);
          newDateFrom.setDate(newDateFrom.getDate() + startDay);
          const newDateTo = new Date(startDate);
          newDateTo.setDate(newDateTo.getDate() + endDay);
          newDateFromStr = newDateFrom.toISOString().split('T')[0];
          newDateToStr = newDateTo.toISOString().split('T')[0];
        }

        // Find matching resultData row to pull missing fields
        // Again, match by both ccno and Color to keep rows distinct per shade
        const taskColorName = $task.data('titlecolor') || '';
        const sourceRow = Array.isArray(resultData)
          ? resultData.find(r => {
              const ccMatch = String(r.ccno) === String(taskTitle);
              const colorMatch = String((r.Color || '')).trim().toLowerCase() === String(taskColorName).trim().toLowerCase();
              return ccMatch && colorMatch;
            }) || {}
          : {};

        // Resolve display group name from groupdetails (same logic as convertToTask)
        let draggedGroupName = stationId;
        if (Array.isArray(groupdetails) && groupdetails.length) {
          const g = groupdetails.find(gd => String(gd.cc_no || '') === String(stationId || ''));
          if (g && g.group_name) {
            draggedGroupName = g.group_name;
          }
        }

        const updatedTask = {
          station_id: stationId,
          start_day_index: startDay,
          span_days: spanDays,
          Color: $task.data('titlecolor') || '',
          Pend_Qty: sourceRow.Pend_Qty || '',
          Sel_Qty: taskValue,
          Tot_days: String(spanDays),
          ccno: taskTitle,
          date_from: newDateFromStr,
          date_to: newDateToStr,
          group_name: draggedGroupName,
          id: sourceRow.id || '',
          unit_id: sourceRow.unit_id || '',
          model: sourceRow.Model || sourceRow.Item || ''
        };

        logAllTaskData('dragged', updatedTask);

        updateContextMenuPosition($task);
      },
      drag: () => {
        updateContextMenuPosition($task);
      }
    });

    // Hover tooltip: show task info on top-right panel
    $task.on('mouseenter', function () {
      const $t = $(this);
      const startDay = parseInt($t.attr('data-start-day'), 10) || 0;
      const spanDays = parseInt($t.attr('data-span-days'), 10) || 1;
      const endDay = startDay + spanDays - 1;

      let fromDateStr = '';
      let toDateStr = '';

      if (Array.isArray(planDays) && planDays.length) {
        const fromInfo = planDays[startDay];
        const toInfo = planDays[endDay];
        fromDateStr = fromInfo && fromInfo.date ? fromInfo.date : '';
        toDateStr = toInfo && toInfo.date ? toInfo.date : '';
      }

      // Fallback if planDays missing
      if (!fromDateStr || !toDateStr) {
        const from = new Date(startDate);
        from.setDate(from.getDate() + startDay);
        const to = new Date(startDate);
        to.setDate(to.getDate() + endDay);
        fromDateStr = from.toISOString().split('T')[0];
        toDateStr = to.toISOString().split('T')[0];
      }

      const ccno = $t.data('title') || '';
      const colorName = $t.data('titlecolor') || '';

      let row = null;
      if (Array.isArray(resultData)) {
        row = resultData.find(r => {
          const ccMatch = String(r.ccno) === String(ccno);
          const colorMatch = String((r.Color || '')).trim().toLowerCase() === String(colorName).trim().toLowerCase();
          return ccMatch && colorMatch;
        }) || null;
      }

      const ocn = row && row.ccno ? row.ccno : ccno;
      const item = row && (row.Model || row.Item) ? (row.Model || row.Item) : ($t.data('model') || '');
      const buyer = row && row.Buyer ? row.Buyer : '';
      const lineName = row && row.Line ? row.Line : '';
      const color = row && row.Color ? row.Color : colorName;
      const plannedQty = row && (row.Pend_Qty || row.Sel_Qty || row.Total_Qty) ? (row.Pend_Qty || row.Sel_Qty || row.Total_Qty) : ($t.data('value') || '');

      const $tip = $('#gantt-task-tooltip');
      if ($tip.length) {
        $('#gt-tip-ocn').text(ocn);
        $('#gt-tip-item').text(item);
        $('#gt-tip-start').text(fromDateStr ? fromDateStr.split('-').reverse().join('-') : '');
        $('#gt-tip-buyer').text(buyer);
        $('#gt-tip-duration').text(spanDays);
        $('#gt-tip-line').text(lineName);
        $('#gt-tip-color').text(color);
        $('#gt-tip-end').text(toDateStr ? toDateStr.split('-').reverse().join('-') : '');
        $('#gt-tip-qty').text(plannedQty);
        $tip.show();
      }
    });

    $task.on('mouseleave', function () {
      $('#gantt-task-tooltip').hide();
    });

    $task.on('contextmenu', function(e) {
      e.preventDefault();

      const $t = $(this);
      const existingMenu = $('.task-context-menu');

      if (existingMenu.length > 0) {
        existingMenu.remove();
        return;
      }

      const taskOffset = $t.offset();
      const leftPosition = taskOffset.left - 205;
      const topPosition = taskOffset.top;

      $('.task-context-menu').remove();

      const taskTitle = $t.data('title');
      const taskTitleColor = $t.data('titlecolor') || '';
      const taskValue = $t.data('value');
      const stationId = $t.data('station');

      const batchNo = $t.data('batch');
      const isSplitBatch = batchNo !== undefined && batchNo !== null && batchNo !== '';

      const batchSection = isSplitBatch ? `
                    <div class="mt-3 text-xs text-gray-500 font-medium">
                        Batch ${batchNo} /
                    </div>
                    <div class="text-sm text-gray-700 mb-1">
                        Batch Quantity: <span class="font-normal text-gray-800">-</span>
                    </div>
      ` : '';

      const totalsSection = isSplitBatch
        ? `
                    <div class="text-sm text-gray-700">
                        Total Order Quantity: <span class="font-normal text-gray-800">-</span>
                    </div>
                    <div class="text-sm text-gray-700">
                        Latest Start: <span class="font-normal text-gray-800">-</span>
                    </div>
        `
        : `
                    <div class="text-sm font-medium text-gray-700">
                        Total Order Quantity: <span class="font-normal text-gray-800">${taskValue}</span>
                    </div>
        `;

      const displayTitle = taskTitleColor
        ? `${taskTitle}-${taskTitleColor}`
        : `${taskTitle}`;

      const $contextMenu = $(`
                <div class="task-context-menu absolute bg-white rounded-lg shadow-lg p-4 w-[220px] border border-gray-200" 
                     style="left: ${leftPosition}px; top: ${topPosition}px; z-index: 9999;">
                    <!-- Title -->
                    <div class="text-gray-900 font-semibold text-sm">
                        ${displayTitle}
                    </div>
                    
                    <!-- Subtitle -->
                    <div class="text-gray-500 text-xs mb-3">
                        Station ${stationId}
                    </div>
                    
                    ${batchSection}

                    <!-- Quantity / Totals -->
                    ${totalsSection}
                    
                    <!-- Divider -->
                    <div class="border-t border-gray-300 my-4"></div>
                    
                    <!-- Split Process -->
                    <div class="flex items-center gap-2 py-1 cursor-pointer hover:bg-gray-50 rounded-md px-1 split-process-btn">
                        <i class="fa-solid fa-bars text-gray-700 text-sm"></i>
                        <span class="text-gray-700 text-sm">Split Process...</span>
                    </div>
                    
                    <!-- Return to Unplanned -->
                    <div class="flex items-center gap-2 py-1 cursor-pointer hover:bg-gray-50 rounded-md px-1 mt-1 return-to-unplanned-btn">
                        <i class="fa-solid fa-rotate-left text-gray-700 text-sm"></i>
                        <span class="text-gray-700 text-sm">Return to Unplanned</span>
                    </div>
                </div>
            `).appendTo('body');

      $('.split-process-btn').on('click', function(ev) {
        ev.preventDefault();
        ev.stopPropagation();
        openSplitModal($t);
        $('.task-context-menu').remove();
      });

      // Return task from Gantt back to Unplanned small cards
      $contextMenu.find('.return-to-unplanned-btn').on('click', function(ev) {
        ev.preventDefault();
        ev.stopPropagation();

        const taskTitle = $t.data('title');
        const taskTitleColor = $t.data('titlecolor') || '';
        const taskValue = $t.data('value');
        // Prefer explicit data-card-color so it isn't affected by jQuery's .data() caching
        const taskColor = $t.attr('data-card-color') || $t.data('color') || 'bg-blue-100 text-blue-800';

        // Recreate the small card in the Unplanned container
        const $card = $(`
          <div class="${taskColor} rounded-lg p-3 mb-2 cursor-move small-card shadow hover:shadow-md" data-title="${taskTitle}" data-titlecolor="${taskTitleColor}" data-value="${taskValue}" data-color="${taskColor}">
            <div class="flex justify-between text-xs font-medium">
              <span>${taskTitle}/${taskTitleColor}</span>
              <span>Qty: <strong>${taskValue}</strong></span>
            </div>
          </div>
        `);

        $('#small-cards-container').append($card);

        // Make the new small card draggable again
        $card.draggable({ helper: 'clone', cursor: 'move', revert: 'invalid', zIndex: 1000 });

        const stationId = $t.data('station');

        // Remove the task bar from the Gantt chart
        $t.remove();

        // Apply grey overlay after task is removed
        applyGreyOverlay();

        // Remove any metrics rows for this title (shared across stations)
        $(`.metrics-row[data-title="${taskTitle}"]`).remove();

        // Close the context menu
        $('.task-context-menu').remove();
      });

      $(document).on('click', function closeContextMenu() {
        $('.task-context-menu').remove();
        $(document).off('click', closeContextMenu);
      });
    });

  }

  // Keep context menu positioned next to the task while it is dragged
  function updateContextMenuPosition($task) {
    const $contextMenu = $('.task-context-menu');
    if ($contextMenu.length === 0) return;

    const taskOffset = $task.offset();
    const leftPosition = taskOffset.left - 205;
    const topPosition = taskOffset.top;

    $contextMenu.css({
      left: leftPosition + 'px',
      top: topPosition + 'px'
    });
  }

  function showMetricsLoading($task) {
    // Remove any previous loader
    $('.metrics-loading').remove();

    const taskOffset = $task.offset();
    if (!taskOffset) return;

    const $loader = $('<div class="metrics-loading"></div>');
    $loader.css({
      position: 'absolute',
      width: '14px',
      height: '14px',
      borderRadius: '9999px',
      border: '2px solid #3b82f6',
      borderTopColor: 'transparent',
      animation: 'spin 0.8s linear infinite',
      zIndex: 50,
      top: taskOffset.top + 8,
      left: taskOffset.left - 20
    });

    $('body').append($loader);
  }

  function hideMetricsLoading() {
    $('.metrics-loading').remove();
  }

  // Toggle metrics rows: if exist -> remove, else -> create
  function toggleMetricsRows(stationId, title, value, $task = null) {
    // If the day headers row is hidden (e.g., after zoom-out), do not show metrics rows
    const dayRowVisible = $('#day-headers').closest('.grid').is(':visible');
    if (!dayRowVisible) {
      return;
    }

    // We maintain a single shared metrics block per title, even if that
    // title has been split across multiple groups/stations.
    const existing = $(`.metrics-row[data-title="${title}"]`);
    if (existing.length > 0) {
      // If already visible, simply remove them (no need to call API)
      existing.remove();
      hideMetricsLoading();
      return;
    }

    // If the same title appears on multiple rows (split across groups),
    // always choose the bottom-most bar as the canonical one, regardless
    // of which bar was clicked. Metrics will then be inserted under that
    // row while still considering all bars.
    const $allTitleBars = $(`.task-bar[data-title="${title}"]`);
    if ($allTitleBars.length) {
      let $lastBar = $allTitleBars.first();
      let maxRowIndex = -1;
      $allTitleBars.each(function() {
        const $bar = $(this);
        const rowIndex = $bar.closest('.grid').index();
        if (rowIndex > maxRowIndex) {
          maxRowIndex = rowIndex;
          $lastBar = $bar;
        }
      });

      stationId = $lastBar.data('station') || stationId;
      $task = $lastBar;
    }

    // Show loader next to the canonical task bar while we fetch PO+FC data
    if ($task && $task.length) {
      showMetricsLoading($task);
    }

    // Get model from the task bar if available
    let model = '';
    const $taskBar = $(`.task-bar[data-title="${title}"][data-station="${stationId}"]`).first();
    if ($taskBar.length) {
      model = $taskBar.data('model') || '';
    }

    $.ajax({
      url: '/getpofcdata',
      type: 'GET',
      dataType: 'json',
      data: { ccno: title, modelid: model },
      success: function(response) {
        // Optionally keep a global cache if needed elsewhere
        window.pofcdata = response && Array.isArray(response.data) ? response.data : [];
        console.log('toggleMetricsRows: fetched PO/FC data before showing metrics', window.pofcdata);

        hideMetricsLoading();
        // Only after PO+FC has been fetched, create and show the metrics rows
        createMetricsRows(stationId, title, value, $task);
      },
      error: function(err) {
        console.error('toggleMetricsRows: error fetching /getpofcdata', err);
        hideMetricsLoading();
      }
    });
  }

  // Create metric rows aligned to all bars for this title (even if split
  // across multiple stations). Metrics rows are inserted under the
  // bottom-most station row for the title.
  function createMetricsRows(stationId, title, value, $task = null) {

    const $rows = $('#gantt-rows');
    const totalDays = getTotalDaysInRange();
    const fullWidth = totalDays * dayWidth;
    const rowTotalWidth = fullWidth + LEFT_COLUMN_WIDTH;

    // Find the station row - prefer the row of the canonical $task if provided.
    // Otherwise, look for the last grid row that has a bar for this title.
    let $stationRow;
    if ($task && $task.length) {
      $stationRow = $task.closest('.grid');
    } else {
      const $allTitleBars = $(`.task-bar[data-title="${title}"]`);

      if ($allTitleBars.length) {
        let $lastBar = $allTitleBars.first();
        let maxRowIndex = -1;
        $allTitleBars.each(function() {
          const $bar = $(this);
          const rowIndex = $bar.closest('.grid').index();
          if (rowIndex > maxRowIndex) {
            maxRowIndex = rowIndex;
            $lastBar = $bar;
          }
        });
        $stationRow = $lastBar.closest('.grid');
        stationId = $lastBar.data('station') || stationId;
      } else {
        $stationRow = $(`div[data-line="${stationId}"]`).closest('.grid');
      }
    }

    // If already exists, remove first (we will recreate) – keyed only by title
    $(`.metrics-row[data-title="${title}"]`).remove();

    // Find dynamic metric values for this ccno/title from resultData
    let fgOiVal = '1,250';
    let effVal = '92%';
    let planQtyVal = value; // fallback to task value if we cannot compute
    if (Array.isArray(resultData)) {
      const row = resultData.find(r => String(r.ccno) === String(title));
      if (row) {
        if (row.FG_OI !== undefined && row.FG_OI !== null && row.FG_OI !== '') {
          fgOiVal = String(row.FG_OI);
        }
        if (row.Eff_Perc !== undefined && row.Eff_Perc !== null && row.Eff_Perc !== '') {
          effVal = `${row.Eff_Perc}`;
        }
        // Compute Plan Qty = ((480 / Sam) * Operators) * efficiency%
        const sam = parseFloat(row.Sam);
        const operators = parseFloat(row.Operators);
        const effPerc = parseFloat(row.Eff_Perc);
        const perdayqty = parseFloat(row.Perday_Qty);

        if (!isNaN(sam) && sam > 0 && !isNaN(operators) && operators > 0 && !isNaN(effPerc) && effPerc > 0) {
          const planQty = Math.round( perdayqty * (effPerc / 100));
          planQtyVal = Math.round(planQty).toString();
        }
      }
    }
    const fgOiPlusPlan = (parseInt(fgOiVal) || 0) + (parseInt(planQtyVal) || 0);

    const metrics = [
      { name: 'FG OI', value: fgOiVal, color: 'bg-yellow-100 text-yellow-800' },
      { name: 'Plan Qty', value: planQtyVal, color: 'bg-purple-100 text-purple-800' },
      { name: 'Efficiency (%)', value: effVal, color: 'bg-green-100 text-green-800' },
      { name: 'PO + FC ', value: '', color: 'bg-blue-100 text-blue-800' },
      { name: 'FC', value: '', color: 'bg-orange-100 text-orange-800' },
      { name: 'PO', value: '', color: 'bg-red-100 text-red-800' }
    ];

    metrics.forEach((metric) => {
      let metricsCells = '';
      // Find all task bars with this title across all stations, so splits
      // in different groups are treated as a single logical range.
      const $taskBars = $(`.task-bar[data-title="${title}"]`);

      // For FG OI we will build a running total across days using constant daily Plan Qty.
      // Let baseFgOi = fgOiVal; then for each distinct task-bar color:
      //   Day0 FG_OI(color) = baseFgOi + PlanQty
      //   Day i>0 FG_OI(color) = previous FG_OI(color) + Plan Qty
      const baseFgOi = parseInt(fgOiVal, 10) || 0;
      const dailyPlan = parseInt(planQtyVal, 10) || 0;
      const fgOiByColor = {}; // key: task bar color key, value: running FG_OI for that color

      // Precompute PO+FC by day index for this title using window.pofcdata
      const poFcByDayIndex = {};
      const poByDayIndex = {};
      const fcByDayIndex = {};
      if ((metric.name === 'PO + FC ' || metric.name === 'PO' || metric.name === 'FC') && Array.isArray(window.pofcdata)) {
        // Titles can be like '305836-(GREEN)' while API ccno is '305836'.
        // Use only the ccno part before any '-' when matching.
        const ccStrLocal = String(title).split('-')[0].trim();
        window.pofcdata.forEach(function(row) {
          if (!row) return;

          const ccField = row.CC || row.cc || row.ccno || null;
          if (String(ccField || '') !== ccStrLocal) return;

          const rawDate = row.WDate || row.Wdate || row.wdate || row.Delivery_Date || row.delivery_date || null;
          if (!rawDate) return;

          let dateOnly = null;
          if (typeof rawDate === 'string') {
            dateOnly = rawDate.split(' ')[0];
          } else {
            try {
              const d = new Date(rawDate);
              if (!isNaN(d)) {
                dateOnly = d.toISOString().split('T')[0];
              }
            } catch (e) {
              dateOnly = null;
            }
          }

          if (!dateOnly) return;
          const idx = dateIndexMap[dateOnly];
          if (idx == null) return;

          const qtyVal = row.Qty ?? row.qty ?? null;
          const poQtyVal = row.PO_Qty ?? row.po_qty ?? row.POQty ?? null;
          const fcQtyVal = row.Fc_Qty ?? row.FC_Qty ?? row.fc_qty ?? null;

          function accumulate(map, value) {
            if (value == null || value === '' || isNaN(value)) return;
            const num = Number(value);
            if (map[idx] == null) {
              map[idx] = num;
            } else {
              map[idx] += num;
            }
          }

          accumulate(poFcByDayIndex, qtyVal);
          accumulate(poByDayIndex, fcQtyVal);
          accumulate(fcByDayIndex, poQtyVal);
        });
      }

      for (let i = 0; i < totalDays; i++) {
        const date = new Date(startDate);
        date.setDate(date.getDate() + i);

        const isWeekend = date.getDay() === 0 || date.getDay() === 6;

        // Check if this day is covered by ANY bar for this station
        let isInRange = false;
        let barColorKey = null;
        $taskBars.each(function() {
          const $bar = $(this);
          const left = parseInt($bar.css('left')) || 0;
          const width = parseInt($bar.css('width')) || (dayWidth * 14);
          const startDay = Math.floor(left / dayWidth);
          const endDay = Math.floor((left + width) / dayWidth);
          if (i >= startDay && i < endDay) {
            isInRange = true;
            // Use titlecolor or color data attributes as the key for color-wise FG OI
            barColorKey = $bar.data('titlecolor') || $bar.data('color') || $bar.data('colorid') || 'default';
            return false; // break
          }
        });

        let cellContent = '';
        if (isInRange) {
          if (metric.name === 'Efficiency (%)') {
            cellContent = `
              <div class="flex items-center justify-center h-full">
                <span class="px-1 py-1 rounded text-xs font-medium bg-white border border-blue-500 outline-none has-tooltip" contenteditable="true">${metric.value}</span>
              </div>
            `;
          } else if (metric.name === 'FG OI') {
            let displayVal = '';

            if (barColorKey) {
              if (fgOiByColor[barColorKey] == null) {
                // First day for this color: start from baseFgOi + PlanQty
                const fgOiPlusPlan = baseFgOi + dailyPlan;
                fgOiByColor[barColorKey] = fgOiPlusPlan;
              } else {
                // Subsequent days for this color: accumulate by Plan Qty
                fgOiByColor[barColorKey] += dailyPlan;
              }

              displayVal = fgOiByColor[barColorKey];
            }
            cellContent = `
              <div class="flex items-center justify-center h-full">
                <span class="px-1 py-1 rounded text-xs font-medium">${displayVal}</span>
              </div>
            `;

          } else if (metric.name === 'PO + FC ') {
            const val = poFcByDayIndex[i];
            const display = val != null ? val : '';
            cellContent = `
              <div class="flex items-center justify-center h-full">
                <span class="px-1 py-1 rounded text-xs font-medium">${display}</span>
              </div>
            `;
          } else if (metric.name === 'PO') {
            const val = poByDayIndex[i];
            const display = val != null ? val : '';
            cellContent = `
              <div class="flex items-center justify-center h-full">
                <span class="px-1 py-1 rounded text-xs font-medium">${display}</span>
              </div>
            `;
          } else if (metric.name === 'FC') {
            const val = fcByDayIndex[i];
            const display = val != null ? val : '';
            cellContent = `
              <div class="flex items-center justify-center h-full">
                <span class="px-1 py-1 rounded text-xs font-medium">${display}</span>
              </div>
            `;
          } else {
            cellContent = `
              <div class="flex items-center justify-center h-full">
                <span class="px-1 py-1 rounded text-xs font-medium">${metric.value}</span>
              </div>
            `;
          }
        }

        metricsCells += `
          <div class="border-r ${isInRange ? metric.color : ''} relative metrics-cell" 
            data-day-index="${i}" data-metric-name="${metric.name}" style="width:${dayWidth}px; height:30px;">
            ${cellContent}
          </div>
        `;
      }

      const $metricsRow = $(`
        <div class="grid border-b metrics-row" data-station="${stationId}" data-title="${title}" style="grid-template-columns: ${LEFT_COLUMN_WIDTH}px 1fr; width: ${rowTotalWidth}px;">
          <div class="py-1 pl-4 border-r ${metric.color} text-xs sticky left-0 z-30" style="position: sticky;">
            <div class="font-medium">${metric.name}</div>
          </div>
          <div class="relative h-[30px] flex">
            <div class="flex" style="width: ${fullWidth}px;">
              ${metricsCells}
            </div>
          </div>
        </div>
      `);

      // Insert after the station row
      $stationRow.after($metricsRow);
    });
  }

  // Update existing metrics rows when tasks move / added / removed
  function updateMetricsRowsPosition(stationId, title, value) {
    const totalDays = getTotalDaysInRange();
    const fullWidth = totalDays * dayWidth;
    const rowTotalWidth = fullWidth + LEFT_COLUMN_WIDTH;

    // Check if metrics rows exist for this station and title
    const existingMetrics = $(`.metrics-row[data-station="${stationId}"][data-title="${title}"]`);

    if (existingMetrics.length > 0) {
      // Find all task bars for this station
      const $taskBars = $(`.task-bar[data-station="${stationId}"]`);

      // Recompute dynamic metric values for this ccno/title
      let fgOiVal = '1,250';
      let effVal = '92%';
      let planQtyVal = value;
      if (Array.isArray(resultData)) {
        const row = resultData.find(r => String(r.ccno) === String(title));
        if (row) {
          if (row.FG_OI !== undefined && row.FG_OI !== null && row.FG_OI !== '') {
            fgOiVal = String(row.FG_OI);
          }
          if (row.Eff_Perc !== undefined && row.Eff_Perc !== null && row.Eff_Perc !== '') {
            effVal = `${row.Eff_Perc}`;
          }
          // Compute Plan Qty = ((480 / Sam) * Operators) * efficiency%
          const sam = parseFloat(row.Sam);
          const operators = parseFloat(row.Operators);
          const effPerc = parseFloat(row.Eff_Perc);
          const perdayqty = parseFloat(row.Perday_Qty);

          
          if (!isNaN(sam) && sam > 0 && !isNaN(operators) && operators > 0 && !isNaN(effPerc) && effPerc > 0) {
            const planQty = Math.round( perdayqty * (effPerc / 100));
            planQtyVal = Math.round(planQty).toString();
          }
        }
      }

      const metrics = [
        { name: 'FG OI', value: fgOiVal, color: 'bg-yellow-100 text-yellow-800' },
        { name: 'Plan Qty', value: planQtyVal, color: 'bg-purple-100 text-purple-800' },
        { name: 'Efficiency (%)', value: effVal, color: 'bg-green-100 text-green-800' },
        { name: 'PO + FC ', value: '', color: 'bg-blue-100 text-blue-800' },
        { name: 'FC', value: '', color: 'bg-orange-100 text-orange-800' },
        { name: 'PO', value: '', color: 'bg-red-100 text-red-800' }
      ];

      existingMetrics.each(function(index) {
        const $metricsRow = $(this);
        const metric = metrics[index];

        // ensure title is available for later per-day calculations
        $metricsRow.attr('data-title', title || '');
        $metricsRow.css({
          width: rowTotalWidth + 'px',
          gridTemplateColumns: `${LEFT_COLUMN_WIDTH}px 1fr`
        });
        const $flexContainer = $metricsRow.find('.flex');
        $flexContainer.css('width', fullWidth + 'px');

        let metricsCells = '';
        for (let i = 0; i < totalDays; i++) {
          const date = new Date(startDate);
          date.setDate(date.getDate() + i);

          const isWeekend = date.getDay() === 0 || date.getDay() === 6;

          // Check if this day is covered by ANY bar for this station
          let isInRange = false;
          $taskBars.each(function() {
            const left = parseInt($(this).css('left')) || 0;
            const width = parseInt($(this).css('width')) || (dayWidth * 14);
            const startDay = Math.floor(left / dayWidth);
            const endDay = Math.floor((left + width) / dayWidth);
            if (i >= startDay && i < endDay) {
              isInRange = true;
              return false; // break
            }
          });

          let cellContent = '';
          if (isInRange) {
            if (metric.name === 'Efficiency (%)') {
              cellContent = `
                <div class="flex items-center justify-center h-full">
                  <span class="px-1 py-1 rounded text-xs font-medium bg-white border border-blue-500 outline-none has-tooltip" contenteditable="true">${metric.value}</span>
                </div>
              `;
            } else {
              cellContent = `
                <div class="flex items-center justify-center h-full">
                  <span class="px-1 py-1 rounded text-xs font-medium">${metric.value}</span>
                </div>
              `;
            }
          }

          metricsCells += `
            <div class="border-r ${isInRange ? metric.color : ''} relative metrics-cell" 
              data-day-index="${i}" data-metric-name="${metric.name}" style="width:${dayWidth}px; height:30px;">
              ${cellContent}
            </div>
          `;
        }

        // Update the metrics row content
        $flexContainer.html(metricsCells);
      });
    }
  }

  // Remember original efficiency before user edits, so we can compute how much was reduced.
  $(document).on('focus', '.metrics-row [contenteditable="true"]', function() {
    const $span = $(this);
    const rawEff = ($span.text() || '').toString().replace('%', '').trim();
    const effParsed = parseFloat(rawEff);
    if (!isNaN(effParsed)) {
      $span.data('prev-eff', effParsed);
    } else {
      $span.data('prev-eff', null);
    }
  });

  // When efficiency is edited for a specific day in metrics, recalculate that day's Plan Qty
  // using the same formula: ((480 / Sam) * Operators) * efficiency%, and then recompute
  // the FG OI row as a running total by day:
  //   Day0 FG_OI stays as its base value (or base FG_OI + Day0 Plan Qty),
  //   Day i>0 FG_OI = previous day's FG_OI + that day's Plan Qty.
  $(document).on('input', '.metrics-row [contenteditable="true"]', function() {

    const $span = $(this);
    const $metricsRow = $span.closest('.metrics-row');
    const metricHeader = $metricsRow.find('.font-medium').first().text().trim();

    if (metricHeader !== 'Efficiency (%)') {
      return;
    }

    const rawEff = ($span.text() || '').toString().replace('%', '').trim();
    const effParsed = parseFloat(rawEff);

    if (isNaN(effParsed)) {
      return;
    }

    // Clamp efficiency between 0 and 100 and show inline tooltip if out of range
    let effVal = effParsed;
    const minEff = 0;
    const maxEff = 100;
    const clampedEff = Math.min(maxEff, Math.max(minEff, effParsed));

    if (clampedEff !== effParsed) {
      effVal = clampedEff;
      $span.text(clampedEff.toString());
      $span
        .addClass('has-tooltip error-tip show-tip')
        .attr('data-tooltip', 'Efficiency must be between 0 and 100');

      setTimeout(function() {
        $span.removeClass('error-tip show-tip');
      }, 2000);
    } else {
      $span.removeClass('error-tip show-tip').removeAttr('data-tooltip');
    }

    const $cell = $span.closest('.metrics-cell');
    const dayIndex = parseInt($cell.data('day-index'), 10);

    if (isNaN(dayIndex)) {
      return;
    }

    const stationId = $metricsRow.data('station');
    const title = $metricsRow.data('title');

    if (!title) {
      return;
    }

    if (!Array.isArray(resultData)) {
      return;
    }

    const row = resultData.find(r => String(r.ccno) === String(title));
    if (!row) {
      return;
    }

    const sam = parseFloat(row.Sam);
    const operators = parseFloat(row.Operators);

    if (isNaN(sam) || sam <= 0 || isNaN(operators) || operators <= 0) {
      return;
    }

    const planCapacityPer100 = (480 / sam) * operators;
    const planQty = planCapacityPer100 * (effVal / 100);
    const planQtyRounded = Math.round(planQty);

    // Find the matching Plan Qty metrics row for this station and title
    const $planRow = $(`.metrics-row[data-station="${stationId}"][data-title="${title}"]`).filter(function() {
      const label = $(this).find('.font-medium').first().text().trim();
      return label === 'Plan Qty';
    }).first();

    if (!$planRow.length) {
      return;
    }

    const $planCellSpan = $planRow
      .find(`.metrics-cell[data-day-index="${dayIndex}"] span`)
      .first();

    if ($planCellSpan.length) {
      $planCellSpan.text(planQtyRounded);
    }

    // Recalculate FG OI row using the same per-color logic as default rendering:
    // For each distinct task-bar color on this station/title:
    //   First in-range day for that color: FG_OI(color) = baseFgOi + Plan Qty[day]
    //   Subsequent in-range days for that color: FG_OI(color) += Plan Qty[day]
    const baseFgOi = parseInt(row.FG_OI, 10) || 0;

    const $fgRow = $(`.metrics-row[data-station="${stationId}"][data-title="${title}"]`).filter(function() {
      const label = $(this).find('.font-medium').first().text().trim();
      return label === 'FG OI';
    }).first();

    if ($fgRow.length) {
      // All task bars for this station and ccno/title
      const $taskBars = $(`.task-bar[data-station="${stationId}"][data-title="${title}"]`);

      // Running FG OI per color key
      const fgOiByColor = {};

      $fgRow.find('.metrics-cell').each(function() {
        const idx = parseInt($(this).data('day-index'), 10);
        if (isNaN(idx)) return;

        const $fgCellSpan = $(this).find('span').first();
        if (!$fgCellSpan.length) return;

        const $planSpan = $planRow
          .find(`.metrics-cell[data-day-index="${idx}"] span`)
          .first();
        const planText = ($planSpan.text() || '').trim();
        const planVal = parseInt(planText, 10);

        // If this day has no plan qty (out of bar range), leave FG OI as-is and don't affect running totals
        if (!planText || isNaN(planVal)) {
          return;
        }

        // Determine which task bar (and color) covers this day for this station/title
        let barColorKey = null;
        $taskBars.each(function() {
          const $bar = $(this);
          const left = parseInt($bar.css('left')) || 0;
          const width = parseInt($bar.css('width')) || (dayWidth * 14);
          const startDay = Math.floor(left / dayWidth);
          const endDay = Math.floor((left + width) / dayWidth);

          if (idx >= startDay && idx < endDay) {
            barColorKey = $bar.data('titlecolor') || $bar.data('color') || $bar.data('colorid') || 'default';
            return false; // break
          }
        });

        if (!barColorKey) {
          return;
        }

        // Initialize or update this color's running FG OI
        if (fgOiByColor[barColorKey] == null) {
          // First in-range day for this color: start from baseFgOi + this day's PlanQty
          fgOiByColor[barColorKey] = baseFgOi + planVal;
        } else {
          fgOiByColor[barColorKey] += planVal;
        }

        $fgCellSpan.text(fgOiByColor[barColorKey]);
      });
    }

    // Do not change task bar span/width on efficiency edit; only metrics are updated.
    // Calling updateTaskBarWidth here was causing the bar to collapse or jump on the
    // timeline when efficiencies changed.
  });

  // Function to calculate total plan quantity from metrics rows for a specific station and title
  function calculateTotalPlanQuantity(stationId, title) {
    const $planRow = $(`.metrics-row[data-station="${stationId}"][data-title="${title}"]`).filter(function() {
      const label = $(this).find('.font-medium').first().text().trim();
      return label === 'Plan Qty';
    }).first();

    if (!$planRow.length) {
      return 0;
    }

    let totalPlanQty = 0;
    $planRow.find('.metrics-cell').each(function() {
      const $span = $(this).find('span').first();
      const planQtyText = ($span.text() || '').trim();
      const planQty = parseInt(planQtyText, 10);
      if (!isNaN(planQty) && planQty > 0) {
        totalPlanQty += planQty;
      }
    });

    return totalPlanQty;
  }

  // Function to dynamically adjust metrics cells based on task bar span
  function adjustMetricsCells(stationId, title, newSpanDays) {
    // Find all metrics rows for this station and title
    const $metricsRows = $(`.metrics-row[data-station="${stationId}"][data-title="${title}"]`);
    
    if (!$metricsRows.length) {
      return;
    }

    $metricsRows.each(function() {
      const $row = $(this);
      const $flexContainer = $row.find('.flex');
      const metricHeader = $row.find('.font-medium').first().text().trim();
      
      // Get current cells
      const $currentCells = $flexContainer.find('.metrics-cell');
      const currentCellCount = $currentCells.length;
      
      console.log('Adjusting metrics cells:', {
        stationId: stationId,
        title: title,
        metricHeader: metricHeader,
        currentCellCount: currentCellCount,
        newSpanDays: newSpanDays
      });
      
      if (newSpanDays > currentCellCount) {
        // Add new cells
        const cellsToAdd = newSpanDays - currentCellCount;
        for (let i = currentCellCount; i < newSpanDays; i++) {
          let cellContent = '';
          
          if (metricHeader === 'Efficiency (%)') {
            cellContent = `
              <div class="flex items-center justify-center h-full">
                <span class="px-1 py-1 rounded text-xs font-medium bg-white border border-blue-500 outline-none has-tooltip" contenteditable="true">70</span>
              </div>
            `;
          } else if (metricHeader === 'Plan Qty') {
            cellContent = `
              <div class="flex items-center justify-center h-full">
                <span class="px-1 py-1 rounded text-xs font-medium">870</span>
              </div>
            `;
          } else if (metricHeader === 'FG OI') {
            cellContent = `
              <div class="flex items-center justify-center h-full">
                <span class="px-1 py-1 rounded text-xs font-medium">0</span>
              </div>
            `;
          }
          
          const newCell = $(`
            <div class="border-r relative metrics-cell" 
              data-day-index="${i}" data-metric-name="${metricHeader}" style="width:${dayWidth}px; height:30px;">
              ${cellContent}
            </div>
          `);
          
          $flexContainer.append(newCell);
        }
        
        console.log(`Added ${cellsToAdd} new cells to ${metricHeader}`);
        
      } else if (newSpanDays < currentCellCount) {
        // Remove excess cells
        const cellsToRemove = currentCellCount - newSpanDays;
        $flexContainer.find('.metrics-cell').slice(newSpanDays).remove();
        
        console.log(`Removed ${cellsToRemove} excess cells from ${metricHeader}`);
      }
      
      // Update the flex container width
      const newWidth = newSpanDays * dayWidth;
      $flexContainer.css('width', newWidth + 'px');
      
      // Update the row width
      const rowTotalWidth = newWidth + LEFT_COLUMN_WIDTH;
      $row.css({
        width: rowTotalWidth + 'px',
        gridTemplateColumns: `${LEFT_COLUMN_WIDTH}px 1fr`
      });
    });
  }

  // Function to update task bar width based on calculated total plan quantity
  function updateTaskBarWidth(stationId, title, totalPlanQty) {
    // Find all task bars for this station and title
    const $taskBars = $(`.task-bar[data-station="${stationId}"][data-title="${title}"]`);
    
    if (!$taskBars.length) {
      return;
    }

    // Get the original data to calculate per-day plan quantity
    if (!Array.isArray(resultData)) {
      return;
    }

    const row = resultData.find(r => String(r.ccno || '') === String(title || ''));
    if (!row) {
      return;
    }

    // Calculate per-day plan quantity using current efficiency values
    let perDayPlanQty = 870; // default fallback
    if (row.Sam && row.Operators) {
      const sam = parseFloat(row.Sam);
      const operators = parseFloat(row.Operators);
      
      if (!isNaN(sam) && sam > 0 && !isNaN(operators) && operators > 0) {
        // Get current average efficiency from the metrics rows
        const $effRow = $(`.metrics-row[data-station="${stationId}"][data-title="${title}"]`).filter(function() {
          const label = $(this).find('.font-medium').first().text().trim();
          return label === 'Efficiency (%)';
        }).first();

        if ($effRow.length) {
          let totalEfficiency = 0;
          let efficiencyDays = 0;
          
          $effRow.find('.metrics-cell').each(function() {
            const $span = $(this).find('span').first();
            const effText = ($span.text() || '').toString().replace('%', '').trim();
            const effValue = parseFloat(effText);
            if (!isNaN(effValue) && effValue > 0) {
              totalEfficiency += effValue;
              efficiencyDays++;
            }
          });

          if (efficiencyDays > 0) {
            const avgEfficiency = totalEfficiency / efficiencyDays;
            perDayPlanQty = Math.round(((480 / sam) * operators) * (avgEfficiency / 100));
          }
        }
      }
    }

    // Calculate new span days based on total plan quantity and per-day plan quantity
    let newSpanDays = 14; // default fallback
    if (totalPlanQty > 0 && perDayPlanQty > 0) {
      newSpanDays = Math.max(1, Math.ceil(totalPlanQty / perDayPlanQty));
    }

    // Update each task bar's width
    $taskBars.each(function() {
      const $task = $(this);
      const currentStartDay = parseInt($task.attr('data-start-day'), 10) || 0;
      
      // Update the width
      const newWidth = newSpanDays * dayWidth;
      $task.css('width', newWidth + 'px');
      
      // Update the span days attribute
      $task.attr('data-span-days', newSpanDays);
      
      // Keep the original displayed quantity - don't change it
      // The quantity shown on the task bar should remain the same (e.g., 8435)
      const $span = $task.find('span').first();
      const currentText = $span.text();
      const titleText = currentText.split(' - ')[0];
      
      // Use the original value from the task bar data, not the calculated total
      const originalValue = parseInt($task.data('value'), 10) || totalPlanQty;
      $span.html(`<i class="fa-solid fa-scissors"></i> ${titleText} - ${originalValue}`);
      
      console.log('Updated task bar (keeping original quantity):', {
        stationId: stationId,
        title: title,
        originalValue: originalValue,
        calculatedTotal: totalPlanQty,
        perDayPlanQty: perDayPlanQty,
        newSpanDays: newSpanDays,
        newWidth: newWidth
      });
    });

    // Adjust metrics cells to match the new span days
    adjustMetricsCells(stationId, title, newSpanDays);
  }

  // Keyboard navigation for Efficiency (%) cells: Tab / Shift+Tab moves between efficiency inputs
  $(document).on('keydown', '.metrics-row [contenteditable="true"]', function(e) {

    if (e.key !== 'Tab') {
      return;
    }

    const $span = $(this);
    const $metricsRow = $span.closest('.metrics-row');
    const metricHeader = $metricsRow.find('.font-medium').first().text().trim();

    // Only override Tab behavior for Efficiency (%) row
    if (metricHeader !== 'Efficiency (%)') {
      return;
    }

    e.preventDefault();

    // Collect all efficiency cells in DOM order
    const $efficiencySpans = $('.metrics-row').filter(function() {
      const label = $(this).find('.font-medium').first().text().trim();
      return label === 'Efficiency (%)';
    }).find('[contenteditable="true"]');

    const currentIndex = $efficiencySpans.index(this);
    if (currentIndex === -1) {
      return;
    }

    const step = e.shiftKey ? -1 : 1;
    const nextIndex = currentIndex + step;

    if (nextIndex < 0 || nextIndex >= $efficiencySpans.length) {
      return; // no wrap-around; ignore at boundaries
    }

    const nextSpan = $efficiencySpans.get(nextIndex);
    if (!nextSpan) {
      return;
    }

    // Move focus to the next efficiency cell and select all content
    $(nextSpan).focus();
    try {
      const range = document.createRange();
      const sel = window.getSelection();
      range.selectNodeContents(nextSpan);
      sel.removeAllRanges();
      sel.addRange(range);
    } catch (err) {
      // Fallback: browser default focus is enough
    }
  });

  // Global click handler for task bars to toggle metrics rows.
  // Bound once at document level so it doesn't get reattached on each initTaskBar.
  $(document).on('click', '.task-bar', function (e) {
    const $task = $(this);

    // Ignore clicks triggered at the end of a drag operation
    if ($task.data('dragging')) return;

    const stationId = $task.data('station');
    const taskTitle = $task.data('title');
    const taskValue = $task.data('value');

    toggleMetricsRows(stationId, taskTitle, taskValue, $task);
  });

  // Load and render persisted tasks from backend temporary table
  function rendertask() {
    // Build helper map from group_name -> station id (cc_no) using groupdetails
    const groupNameToStationId = {};
    if (Array.isArray(groupdetails)) {
      groupdetails.forEach(g => {
        if (!g || !g.group_name) return;
        const sid = g.cc_no || g.group_name || g.id || '';
        if (sid) {
          groupNameToStationId[String(g.group_name)] = String(sid);
        }
      });
    }

    $.ajax({
      url: '/gantChartDetails',
      type: 'GET',
      dataType: 'json',
      success: function (res) {
        const rows = res && Array.isArray(res.data) ? res.data : [];
        if (!rows.length) return;

        rows.forEach(function (row) {
          if (!row) return;

          const ccno = row.ccno || row.CC || row.cc || null;
          const colorName = row.color || row.Color || '';
          const groupName = row.group_name || '';
          const qty = row.selection_qty || row.Sel_Qty || 0;
          const totalDays = parseInt(row.total_days, 10) || null;
          const fromStr = row.date_from || null;
          const toStr = row.date_to || null;

          if (!ccno || !groupName || !fromStr || !toStr) {
            return;
          }

          // Map group_name -> station id used in data-line
          const stationId = groupNameToStationId[String(groupName)] || groupName;
          const $layer = $(`div[data-line="${stationId}"]`).find('.task-layer').first();
          if (!$layer.length) {
            return;
          }

          // Position task using planDays axis
          const startIdx = dateIndexMap[fromStr] != null ? dateIndexMap[fromStr] : null;
          const endIdx = dateIndexMap[toStr] != null ? dateIndexMap[toStr] : null;
          if (startIdx == null || endIdx == null) {
            return;
          }

          let spanDays = Math.max(1, (endIdx - startIdx + 1));
          if (totalDays && totalDays > 0) {
            spanDays = totalDays;
          }

          const left = startIdx * dayWidth;
          const width = spanDays * dayWidth;

          const title = String(ccno);
          const titleColor = String(colorName || '');
          const value = parseInt(qty, 10) || 0;
          const colorClass = 'bg-orange-500 text-white';
          const taskId = `persisted_${row.id || title + '_' + stationId}`;

          // Avoid duplicating the same persisted bar if rendertask() is called again
          if ($(`.task-bar[data-task-id="${taskId}"]`).length) {
            return;
          }

          const $task = $(`
            <div class="task-bar ${colorClass} font-medium text-xs rounded-lg shadow-md border-2 border-white flex items-center justify-start cursor-pointer"
                 style="left:${left}px; width:${width}px; position:absolute; height:32px; box-sizing:border-box;"
                 data-task-id="${taskId}"
                 data-station="${stationId}"
                 data-title="${title}"
                 data-titlecolor="${titleColor}"
                 data-value="${value}"
                 data-color="${colorClass}"
                 data-card-color="${colorClass}">
              <div class="flex" style="width: 20px; height: 100%; position: absolute; left: 0; top: 0;">
                <div class="flex gap-0.5 flex-col justify-center items-center" style="width: 10px; height: 100%;">
                  <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                  <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                  <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                </div>
                <div class="flex gap-0.5 flex-col justify-center items-center" style="width: 10px; height: 100%;">
                  <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                  <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                  <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
                </div>
              </div>
              <span style="margin-left: 24px;">
                <i class="fa-solid fa-scissors"></i> ${title}${titleColor ? `-(${titleColor})` : ''} - ${value}
              </span>
            </div>
          `).appendTo($layer);

          if (typeof initTaskBar === 'function') {
            initTaskBar($task);
          }
        });

        // Re-apply grey overlay once all persisted tasks are placed
        applyGreyOverlay();
      },
      error: function (err) {
        console.error('Error loading gantChartDetails:', err);
      }
    });
  }

  // Switch process button functionality
  function switchProcess(name) {
    currentProcess = name;
    $('.process-btn').removeClass('bg-gray-200 text-gray-800 rounded').addClass('text-gray-600');
    $(`.process-btn[data-process="${name}"]`).addClass('bg-gray-200 text-gray-800 rounded').removeClass('text-gray-600');
    $('#unplanned-text').text(processData[name]?.unplannedText || '');
    renderSmallCards(name);
    renderGanttRows(name);
  }

  // Apply zoom: expand/compress weeks & rescale existing tasks
  function applyZoom(newIndex) {
    if (newIndex < 0 || newIndex >= zoomLevels.length) return;
    currentZoomIndex = newIndex;
    updateDayWidth(zoomLevels[newIndex], 'zoom');
  }

  // initialise default
  switchProcess('sewing');
  // After rows are built, render any persisted task bars from backend
  if (typeof rendertask === 'function') {
    rendertask();
  }

  // UI bindings
  $('.process-btn').on('click', function() { switchProcess($(this).data('process')); });
  $('#prev-year').on('click', () => { currentYear--; updateYear(currentYear); renderGanttRows(currentProcess); });
  $('#next-year').on('click', () => { currentYear++; updateYear(currentYear); renderGanttRows(currentProcess); });

  // Zoom buttons
  $('#zoom-in').on('click', function() {
    applyZoom(currentZoomIndex + 1);
    // Show day header row and metrics rows when zooming in
    $('#day-headers').closest('.grid').show();
   
  });
  $('#zoom-out').on('click', function() {
    applyZoom(currentZoomIndex - 1);
    // Hide day header row and metrics rows when zooming out
    $('#day-headers').closest('.grid').hide();
    $('.metrics-row').hide();
  });

  bindWeekResizeHandles();

  // sync scrolling of header and body
  $('#header-scroll, #gantt-body').on('scroll', function() {
    $('#header-scroll').scrollLeft(this.scrollLeft);
    $('#gantt-body').scrollLeft(this.scrollLeft);
  });

  // Modal close functionality (split)
  $('#cancel-split').on('click', function() {
    $('#split-modal').hide();
    selectedTask = null;
  });

  // Close modal when clicking outside
  $('#split-modal').on('click', function(e) {
    if (e.target === this) {
      $('#split-modal').hide();
    }
  });

  // Add Batch functionality
  let batchCount = 1;

  $('#add-batch-btn').on('click', function() {
    batchCount++;

    const newBatchRow = $(`
                <div class="grid grid-cols-2 items-center mb-3 px-1 batch-row" data-batch="${batchCount}">
                    <span class="text-gray-700 text-sm">Batch ${batchCount}</span>
                    <div class="relative w-full">
                        <input type="number" value="0" class="border rounded-md px-3 pr-8 py-2 text-sm w-full focus:ring-1 focus:ring-blue-400 focus:border-blue-400 batch-input" />
                        <button class="absolute bg-red-100 rounded right-2 top-1/2 -translate-y-1/2 text-red-500 hover:text-red-700 text-sm remove-batch-btn">
                            <i class="fa-solid fa-minus"></i>
                        </button>
                    </div>
                </div>
    `);

    $('#split-remainder').parent().before(newBatchRow);

    $('.batch-input').off('input').on('input', updateRemainder);

    $('.remove-batch-btn').off('click').on('click', function() {
      $(this).closest('.batch-row').remove();
      updateRemainder();
    });

    updateRemainder();
  });

  

  // initialise first batch input handler
  $('.batch-input').on('input', updateRemainder);

  // Confirm Split functionality - use event delegation to avoid binding issues
  $(document).on('click', '#confirm-split', function(e) {
    e.preventDefault();

    if (!selectedTask) {
      console.warn('No selected task for split');
      $('#split-modal').hide();
      return;
    }

    const splitTasksCreated = [];

    const originalTotal = parseInt($('#split-original-total').text(), 10) || 0;
    let batchTotal = 0;
    const batchData = [];

    console.log('Original total days:', originalTotal);

    // Collect all batch values with their batch numbers
    $('.batch-row').each(function() {
      const $row = $(this);
      const batchNo = parseInt($row.data('batch'), 10);
      const value = parseInt($row.find('.batch-input').val(), 10) || 0;

      if (value > 0 && !isNaN(batchNo)) {
        batchTotal += value;
        batchData.push({ batchNo, value });
      }
    });

    // Validate that batches sum to original total
    if (batchTotal !== originalTotal) {
      alert(`Batch values (${batchTotal}) must equal the original total (${originalTotal})`);
      return;
    }

    // Get original task properties (use the clicked bar as reference)
    const $originalTask = selectedTask;
    const originalTitle = $originalTask.data('title') || '';
    const originalTitleColor = $originalTask.data('titlecolor') || '';
    const originalValue = $originalTask.data('value') || '';
    const originalColor = $originalTask.data('color') || '';
    const originalStation = $originalTask.data('station') || '';

    // Calculate splitGroupName early so it can be used for layer validation
    let splitGroupName = originalStation;
    if (Array.isArray(groupdetails) && groupdetails.length) {
      const g = groupdetails.find(gd => String(gd.cc_no || '') === String(originalStation || ''));
      if (g && g.group_name) {
        splitGroupName = g.group_name;
      }
    }

    // Find all existing batch bars for this cc+color+station and compute earliest left
    const selector = `.task-bar[data-title="${originalTitle}"][data-station="${originalStation}"][data-titlecolor="${originalTitleColor}"]`;
    const $allBatches = $(selector);

    let earliestLeft = null;
    $allBatches.each(function() {
      const left = parseInt($(this).css('left')) || 0;
      if (earliestLeft === null || left < earliestLeft) {
        earliestLeft = left;
      }
    });

    if (earliestLeft === null) {
      earliestLeft = parseInt($originalTask.css('left')) || 0;
    }

    console.log('Original task properties for split (multi-batch):', {
      earliestLeft,
      originalTitle,
      originalTitleColor,
      originalStation,
      originalColor
    });

    // Remove ALL existing batch bars for this cc+color+station
    $allBatches.remove();

    // Helper: find next free left position on this station that does not overlap any other bar
    function findNextFreeLeft(startLeft, widthPx) {
      let left = startLeft;
      const $otherBars = $(`.task-bar[data-station="${originalStation}"]`);

      let adjusted = true;
      while (adjusted) {
        adjusted = false;
        const right = left + widthPx;
        $otherBars.each(function() {
          const $b = $(this);
          const bLeft = parseInt($b.css('left')) || 0;
          const bWidth = parseInt($b.css('width')) || dayWidth;
          const bRight = bLeft + bWidth;

          // If ranges overlap, move left to just after this bar and re-check
          if (!(bRight <= left || bLeft >= right)) {
            left = bRight;
            adjusted = true;
            return false; // break .each
          }
        });
      }
      return left;
    }

    let addedTasks = 0;
    let currentLeft = earliestLeft;

    // Sort batchData by batch number so bars follow Batch 1, 2, 3, ...
    batchData.sort((a, b) => a.batchNo - b.batchNo);

    batchData.forEach(batchInfo => {
      const spanDays = batchInfo.value;
      const batchWidth = spanDays * dayWidth;

      // Move this batch to next free slot so it doesn't overlap any other bar
      currentLeft = findNextFreeLeft(currentLeft, batchWidth);

      const batchNumber = batchInfo.batchNo;

      console.log(`Creating batch ${batchNumber}: ${spanDays} days, width: ${batchWidth}px, left: ${currentLeft}px`);

      const $batchTask = $(`
        <div class="task-bar ${originalColor} text-white font-medium text-xs rounded-lg shadow-md border-2 border-white flex items-center justify-start cursor-pointer"
             style="left:${currentLeft}px; width:${batchWidth}px; position:absolute; height:32px; box-sizing:border-box;"
             data-station="${originalStation}" data-title="${originalTitle}" data-titlecolor="${originalTitleColor}" data-value="${originalValue}" data-color="${originalColor}" data-card-color="${originalColor}" data-batch="${batchNumber}">
          <div class="flex" style="width: 20px; height: 100%; position: absolute; left: 0; top: 0;">
            <div class="flex gap-0.5 flex-col justify-center items-center" style="width: 10px; height: 100%;">
              <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
              <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
              <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
            </div>
            <div class="flex gap-0.5 flex-col justify-center items-center" style="width: 10px; height: 100%;">
              <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
              <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
              <div class="w-1 h-1 bg-gray-200 rounded-full" style="opacity: 0.8"></div>
            </div>
          </div>
          <span style="margin-left: 24px;">
           <i class="fa-solid fa-scissors"></i> ${originalTitle}${originalTitleColor ? `-(${originalTitleColor})` : ''}B${batchNumber}
          </span>
        </div>
      `);

      // Add the batch task to the same layer as the original task
      let $targetLayer = $originalTask.closest('.task-layer');
      console.log('Split: original task layer found:', $targetLayer.length, 'for original task:', $originalTask);
      
      // Debug: check what station this layer belongs to
      if ($targetLayer.length) {
        const $stationRow = $targetLayer.closest('.grid');
        const stationDataLine = $stationRow.find('div[data-line]').data('line');
        const $stationLabel = $stationRow.find('.font-bold');
        const stationLabelText = $stationLabel.text().trim();
        console.log('Split: target layer station ID:', stationDataLine, 'station label:', stationLabelText);
        
        // Additional validation: ensure we're in the correct group by checking the station label
        if (stationLabelText !== splitGroupName && stationLabelText.indexOf(splitGroupName) === -1) {
          console.log('Split: station label mismatch, searching for correct group layer');
          $targetLayer = $(); // Reset to empty to trigger fallback
        }
      }

      if ($targetLayer.length === 0) {
        console.log('Split: original task layer not found or validation failed, searching for correct group layer');
        // Find the correct layer by matching both station ID and group name
        $targetLayer = $(`.grid`).filter(function() {
          const $grid = $(this);
          const stationDataLine = $grid.find('div[data-line]').data('line');
          const $stationLabel = $grid.find('.font-bold');
          const stationLabelText = $stationLabel.text().trim();
          return stationDataLine == originalStation && (stationLabelText === splitGroupName || stationLabelText.indexOf(splitGroupName) !== -1);
        }).find('.task-layer').first();
        console.log('Split: group-specific layer found:', $targetLayer.length);
      }

      if ($targetLayer.length === 0) {
        console.log('Split: group-specific layer not found, falling back to station-based search');
        $targetLayer = $(`.task-layer`).filter(function() {
          return $(this).find(`.task-bar[data-station="${originalStation}"]`).length > 0;
        }).first();
        console.log('Split: fallback layer found:', $targetLayer.length);
      }

      if ($targetLayer.length === 0) {
        $targetLayer = $(`div[data-line="${originalStation}"]`).find('.task-layer');
        console.log('Split: data-line fallback layer found:', $targetLayer.length);
      }

      if ($targetLayer.length === 0) {
        $targetLayer = $('.task-layer').first();
        console.warn('Could not find specific task layer, using first available');
      }

      $targetLayer.append($batchTask);
      console.log(`Added batch task ${batchNumber} to layer for station ${originalStation}`);
      addedTasks++;

      if (typeof initTaskBar === 'function') {
        initTaskBar($batchTask);
      } else {
        console.warn('initTaskBar function not found');
      }

      // Calculate and log split task data
      const startDay = Math.round(currentLeft / dayWidth);
      const endDay = startDay + spanDays - 1;

      const taskDateFrom = new Date(startDate);
      taskDateFrom.setDate(taskDateFrom.getDate() + startDay);
      const taskDateTo = new Date(startDate);
      taskDateTo.setDate(taskDateTo.getDate() + endDay);

      const sourceRow = Array.isArray(resultData) ? resultData.find(r => String(r.ccno) === String(originalTitle)) : {};

      const splitTaskData = {
        Color: originalTitleColor || (sourceRow.Color || ''),
        Pend_Qty: sourceRow.Pend_Qty || '',
        Sel_Qty: originalValue,
        Tot_days: String(spanDays),
        ccno: originalTitle,
        date_from: taskDateFrom.toISOString().split('T')[0],
        date_to: taskDateTo.toISOString().split('T')[0],
        group_name: splitGroupName,
        id: sourceRow.id || '',
        unit_id: sourceRow.unit_id || '',
        batch_number: batchNumber
      };

      convertedTasks.push(splitTaskData);
      console.log('Split task created:', splitTaskData);

      splitTasksCreated.push(splitTaskData);

      currentLeft = currentLeft + batchWidth;
    });

    console.log('Split tasks created:', splitTasksCreated);
    console.log(`Successfully added ${addedTasks} split tasks`);
    logAllTaskData('split');

    $('#split-modal').hide();
    selectedTask = null;

    alert(`Task successfully split into ${addedTasks} batches!`);
  });

  // Unplanned filter dropdown toggle
  $('#unplanned-filter-btn').on('click', function(e) {
    e.stopPropagation();
    $('#unplanned-filter-panel').toggleClass('hidden');
  });

  // Close filter panel when clicking outside
  $(document).on('click', function(e) {
    const $panel = $('#unplanned-filter-panel');
    const $btn = $('#unplanned-filter-btn');
    if ($panel.hasClass('hidden')) return;
    if ($panel.is(e.target) || $panel.has(e.target).length) return;
    if ($btn.is(e.target) || $btn.has(e.target).length) return;
    $panel.addClass('hidden');
  });

  // --- Filter event bindings ---
  $('#filter-ocn').on('input', function() {
    filterState.ocn = $(this).val().trim();
    renderSmallCards(currentProcess);
  });

  $('#filter-unit').on('change', function() {
    filterState.unit = $(this).val();
    renderSmallCards(currentProcess);
  });

  $('#filter-date-from').on('change', function() {
    filterState.dateFrom = $(this).val();
    renderSmallCards(currentProcess);
  });

  $('#filter-date-to').on('change', function() {
    filterState.dateTo = $(this).val();
    renderSmallCards(currentProcess);
  });
  //split card context menu
  $(document).on("contextmenu", ".small-card", function (e) {
      e.preventDefault(); // stop browser menu

      let card = $(this);

      // store selected card globally
      window.selectedCard = card;

      // show your context menu
      $("#cardContextMenu")
          .css({ top: e.pageY, left: e.pageX })
          .show();
  });

  $(document).on("click", function () {
      $("#cardContextMenu").hide();
  });

  $("#btnSplit").on("click", function () {
      $("#cardContextMenu").hide();

      let card = window.selectedCard;
      if (!card) return;

      window.originalValue = parseInt(card.data("value")); // store original
      $("#splitTitle").text(card.data("title"));

      $("#splitVal1").val(parseInt(card.data("value"))/2);
      $("#splitVal2").val(parseInt(card.data("value"))/2);

      $("#splitPopup").show();
  });


  $("#closeSplit").on("click", function () {
      $("#splitPopup").hide();
  });
  $("#submitSplit").on("click", function () {
      let card = window.selectedCard;
      if (!card) return;

      let value1 = parseInt($("#splitVal1").val());
      let value2 = parseInt($("#splitVal2").val());

      if (!value1 || !value2) {
          alert("Enter valid split values");
          return;
      }

      let title = card.data("title");
      let titlecolor = card.data("titlecolor");
      let color = card.data("color");
      let rowIndex = card.data("row-index");

      // REMOVE ORIGINAL CARD
      card.remove();

      // FUNCTION: Create card UI
      function createSmallCard(value) {
          $("#small-cards-container").append(`
              <div class="${color} rounded-lg p-3 mb-2 cursor-move small-card shadow hover:shadow-md" 
                  data-title="${title}" 
                  data-titlecolor="${titlecolor}" 
                  data-value="${value}" 
                  data-color="${color}" 
                  data-row-index="${rowIndex}">
                  
                  <div class="flex justify-between text-xs font-medium">
                      <span>${title}/${titlecolor}</span>
                      <span><strong>${value}</strong></span>
                  </div>
              </div>
          `);
      }

      // ADD NEW SPLIT CARDS
      createSmallCard(value1);
      createSmallCard(value2);

      // RE-INIT DRAGGABLE
      $('.small-card').draggable({
          revert: "invalid",
          helper: "clone",
          start: function () {
              $(this).css("opacity", 0.5);
          },
          stop: function () {
              $(this).css("opacity", 1);
          }
      });

      $("#splitPopup").hide();
  });

  $("#splitVal1").on("input", function () {
      let val1 = parseInt($(this).val()) || 0;
      let remaining = window.originalValue - val1;

      if (remaining < 0) remaining = 0;

      $("#splitVal2").val(remaining);
  });

  

});
</script>

<script>
    const resultData = @json($result);
    console.log('resultData from PHP:', resultData);
    const groupdetails = @json($groupdetail);
    console.log('groupdetails :', groupdetails);
</script>

</body>
</html>