<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css"/>

    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>

<body class="bg-gray-100">

<nav class="w-full bg-blue-800 text-white px-8 py-2 flex items-center justify-between">
    
    <!-- Logo + Title -->
    <div class="flex items-center gap-2 text-xl font-semibold">
        <i class="fa-solid fa-industry text-2xl"></i>
        <span>Planning portal for - WOVEN</span>
    </div>
    



    <!-- Dynamic Nav Items -->
    <ul id="navItems" class="flex justify-center items-center gap-6 text-sm font-medium" style="margin-right:400px;">
    <!-- items inserted by jQuery -->
    </ul>


    <!-- Right-side actions -->
    <div class="flex items-center gap-2">
        <a href="/dashboard" title="Dashboard"
           class="p-2 rounded-md hover:bg-gray-200 transition-colors group text-white">
            <i class="fa fa-home group-hover:text-blue-900 transition-colors" aria-hidden="true"></i>
        </a>

        <!-- Dropdown -->
        <select id="plantSelect" class="bg-white text-black px-4 py-2 rounded-md cursor-pointer hidden">
            <option value="GUP">GUP</option>
            <option value="GUT">GUT</option>
            <option value="GUTNEW">GUT (New)</option>
        </select>
    </div>

</nav>

<script>
    // Portal type mapping
    function getPortalType(dropdownValue) {
        const portalMapping = {
            'GUP': 'gup',
            'GUT': 'gut', 
            'GUTNEW': 'gut_new'
        };
        return portalMapping[dropdownValue] || 'gut_new';
    }

    // Store portal type globally for access by other pages
    function updatePortalType(dropdownValue) {
        const portalType = getPortalType(dropdownValue);
        window.portalType = portalType;
        localStorage.setItem('portalType', portalType);
        console.log('Active portal type:', portalType);
        return portalType;
    }

    // Menu configurations with FONT AWESOME icons
    const menus = {
        GUP: [
            { name: "Dashboard", icon: "fa-solid fa-table-columns" },
            { name: "Orders", icon: "fa-solid fa-cart-shopping" },
            { name: "Capacity", icon: "fa-solid fa-industry" },
        ],
        GUT: [
            { name: "Order Management", icon: "fa-solid fa-cart-shopping" },
            { name: "Demand", icon: "fa-solid fa-chart-line" },
            { name: "Material Planning", icon: "fa-solid fa-boxes-stacked" },
            { name: "Production Planning", icon: "fa-solid fa-industry" },
        ],
        GUTNEW: [
            { name: "Gantt Chart", icon: "fa-regular fa-rectangle-list",path: "/gutgantt" },
            { name: "Orders", icon: "fa-solid fa-cart-shopping",path: "/gutplan" },
            { name: "Capacity", icon: "fa-solid fa-industry",path: "/capacityline" },
			{ name: "Order details", icon: "fa-solid fa-boxes-stacked",path: "/orderdetails" },
			//{name: "TrackRM", icon:"fa-solid fa-box",path: "/trackrm"}
        ]
    };

    // Page switching will be handled by main page; call it if available

    function loadMenu(type){
        $("#navItems").empty();

        menus[type].forEach(item => {

            // CHECK IF ITEM IS "Demand"
            if(item.name === "Demand"){
                $("#navItems").append(`
                    <li class="relative demand-menu">
                        <div id="demandToggle" class="cursor-pointer hover:bg-blue-600 px-3 py-1 rounded transition-all flex items-center gap-2">
                            <i class="${item.icon} text-lg"></i>
                            <span>${item.name}</span>
                            <i class="fa-solid fa-chevron-down text-xs"></i>
                        </div>

                        <!-- DROPDOWN -->
                        <ul id="demandDropdown"
                             class="absolute left-1/2 -translate-x-1/2 top-full w-max bg-white text-black rounded-lg shadow-lg hidden z-50">
                            <a href="/demandtrend" class="block px-4 py-2 hover:bg-gray-100 cursor-pointer">Demand Trend Analysis</a>
                             <a href="/demandsizewise" class="block px-4 py-2 hover:bg-gray-100 cursor-pointer">Size-wise Demand</a>
                             <a href="/demandpostatus" class="block px-4 py-2 hover:bg-gray-100 cursor-pointer">PO Status</a>
                        </ul>
                    </li>
                `);
            }
            // CHECK IF ITEM IS "Material Planning"
            else if (item.name === "Material Planning") {
                $("#navItems").append(`
                    <li class="relative material-planning-menu">
                        <div id="materialPlanningToggle" class="cursor-pointer hover:bg-blue-600 px-3 py-1 rounded transition-all flex items-center gap-2">
                            <i class="${item.icon} text-lg"></i>
                            <span>${item.name}</span>
                            <i class="fa-solid fa-chevron-down text-xs"></i>
                        </div>

                        <!-- DROPDOWN -->
                        <ul id="materialPlanningDropdown"
                             class="absolute left-1/2 -translate-x-1/2 top-full w-max bg-white text-black rounded-lg shadow-lg hidden z-50">
                            <a href="/materialprojectionplanning" class="block px-4 py-2 hover:bg-gray-100 cursor-pointer">Projection Planning</a>
                            <a href="/materialfrcplanning" class="block px-4 py-2 hover:bg-gray-100 cursor-pointer">FRC Planning</a>
                        </ul>
                    </li>
                `);
            }
            // CHECK IF ITEM IS "Production Planning"
            else if (item.name === "Production Planning") {
                $("#navItems").append(`
                    <li class="relative production-planning-menu">
                        <div id="productionPlanningToggle" class="cursor-pointer hover:bg-blue-600 px-3 py-1 rounded transition-all flex items-center gap-2">
                            <i class="${item.icon} text-lg"></i>
                            <span>${item.name}</span>
                            <i class="fa-solid fa-chevron-down text-xs"></i>
                        </div>

                        <!-- DROPDOWN -->
                        <ul id="productionPlanningDropdown"
                             class="absolute left-1/2 -translate-x-1/2 top-full w-max bg-white text-black rounded-lg shadow-lg hidden z-50">
                            <a href="/ccplan" class="block px-4 py-2 hover:bg-gray-100 cursor-pointer">CC Plan</a>
                            <a href="/capacityallocation" class="block px-4 py-2 hover:bg-gray-100 cursor-pointer">Capacity Allocation</a>
                            <a href="/cutorderdetails" class="block px-4 py-2 hover:bg-gray-100 cursor-pointer">Cut Order Details</a>
                            <a href="/lineplan" class="block px-4 py-2 hover:bg-gray-100 cursor-pointer">Line Plan</a>
                        </ul>
                    </li>
                `);
            }

            else {
                const isActive = (window.location.pathname === item.path) ? 'bg-blue-600' : '';
                const linkContent = item.path ? `<a href="${item.path}" class="flex items-center gap-2 w-full">` : '';
                const linkClose = item.path ? '</a>' : '';
                $("#navItems").append(`
                    <li class="cursor-pointer hover:bg-blue-600 px-3 py-1 rounded transition-all ${isActive}">
                        ${linkContent}
                        <i class="${item.icon} text-lg"></i>
                        <span>${item.name}</span>
                        ${linkClose}
                    </li>
                `);
            }

        });

        if (typeof window.showPage === 'function') { window.showPage(type); }
    }


    // Initialize
    const initialPlant = "GUTNEW"; // Always default to GUTNEW
    localStorage.setItem('plantSelect', initialPlant); // Store GUTNEW as the default
    updatePortalType(initialPlant); // Set initial portal type
    loadMenu(initialPlant);
    $("#plantSelect").val(initialPlant); // Set the dropdown to the initial plant

    $("#plantSelect").on("change", function(){
        const val = $(this).val();
        localStorage.setItem('plantSelect', val); // Store the selected plant
        updatePortalType(val); // Update portal type
        loadMenu(val);
        if (typeof window.showPage === 'function') { window.showPage(val); }
    });


    $(document).on("click", "#demandToggle", function(e){
        e.stopPropagation();
        $("#demandDropdown").toggleClass("hidden");
    });

    // Event handler for Material Planning dropdown
    $(document).on("click", "#materialPlanningToggle", function(e){
        e.stopPropagation();
        $("#materialPlanningDropdown").toggleClass("hidden");
    });

    // Event handler for Production Planning dropdown
    $(document).on("click", "#productionPlanningToggle", function(e){
        e.stopPropagation();
        $("#productionPlanningDropdown").toggleClass("hidden");
    });

    // close when clicking outside
    $(document).on("click", function(e){
        if (!$(e.target).closest('#demandToggle').length && !$(e.target).closest('#demandDropdown').length) {
            $("#demandDropdown").addClass("hidden");
        }

        // Close Material Planning dropdown if clicked outside
        if (!$(e.target).closest('#materialPlanningToggle').length && !$(e.target).closest('#materialPlanningDropdown').length) {
            $("#materialPlanningDropdown").addClass("hidden");
        }

        // Close Production Planning dropdown if clicked outside
        if (!$(e.target).closest('#productionPlanningToggle').length && !$(e.target).closest('#productionPlanningDropdown').length) {
            $("#productionPlanningDropdown").addClass("hidden");
        }
    });


</script>

<!-- Content sections will be included and managed in Gutplan_mainpage -->

</body>
</html>
