<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Track RM</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

  <style>
    .breadcrumb a { color: #6b7280; }
    .breadcrumb span { color: #9ca3af; }

    .rm-segment-track {
      background-color: #f3f4f6; /* light gray */
    }

    .rm-segment-active {
      background-color: #ffffff;
      color: #2563eb; /* Tailwind blue-600 */
    }

    .rm-progress-wrap {
      position: relative;
      cursor: pointer;
    }

    .rm-tooltip {
      position: absolute;
      top: -2.25rem;
      right: 0;
      background: #ffffff;
      border-radius: 0.375rem;
      border: 1px solid #e5e7eb;
      box-shadow: 0 10px 15px -3px rgba(0,0,0,0.1);
      padding: 0.35rem 0.5rem;
      font-size: 0.7rem;
      color: #111827;
      white-space: nowrap;
      display: none;
      z-index: 20;
    }

    .rm-progress-wrap:hover .rm-tooltip {
      display: block;
    }

    select:disabled {
      background-color: #f3f4f6;
      cursor: not-allowed;
    }
  </style>
</head>

<body class="bg-[#f5f7fb] ">
 
       @include('LifeAtGainup.Planning.GUTplanning.Gutplan_nav')
 <div class="bodycontainer px-4 py-6">
  <!-- Breadcrumb -->
  <div class="breadcrumb text-sm mb-4 flex items-center gap-2">
      <a href="gutplan">Order Management</a> >
      <a href="projectionplanning">Projection Planning</a> >
      <span>Track RM</span>
  </div>

  <!-- Page Title -->
  <h1 class="text-2xl font-semibold text-gray-800">Track RM</h1>
  <p class="text-sm text-gray-500 mb-6">Filter to view raw material tracking details.</p>

  <!-- Filters -->
  <div class="grid grid-cols-5 gap-4 bg-white p-5 rounded-xl shadow-sm">

      <div>
        <label class="text-xs font-medium text-gray-500">CC</label>
        <select class="w-full mt-1 border rounded-lg p-2 text-sm" id="cc-dropdown">
          <option value="">-select CC-</option>
          <option>UNIQLO-Pants</option>
        </select>
      </div>

      <div>
        <label class="text-xs font-medium text-gray-500">Color</label>
        <select class="w-full mt-1 border rounded-lg p-2 text-sm" id="color-dropdown" disabled>
          <option value="">-select Color-</option>
          <option>Navy</option>
        </select>
      </div>

      <div>
        <label class="text-xs font-medium text-gray-500">Buyer</label>
        <select class="w-full mt-1 border rounded-lg p-2 text-sm" id="buyer-dropdown" disabled>
          <option value="">-select Buyer-</option>
          <option>Uniqlo</option>
        </select>
      </div>

      <div>
        <label class="text-xs font-medium text-gray-500">Season</label>
        <select class="w-full mt-1 border rounded-lg p-2 text-sm" id="season-dropdown" disabled>
          <option value="">-select Season-</option>
          <option>AW-25</option>
        </select>
      </div>

      <div>
        <label class="text-xs font-medium text-gray-500">PRJ #</label>
        <select class="w-full mt-1 border rounded-lg p-2 text-sm" id="prj-dropdown" disabled>
          <option value="">-select PRJ #-</option>
          <option>PRJ-UNIQLO-Pants-NA...</option>
        </select>
      </div>

  </div>

  <!-- Message shown when no data is populated -->
  <div id="no-data-message" class="text-center py-12 text-gray-500">
    <p class="text-lg">Select a PRJ # to view material requirements</p>
  </div>

    <div id="summary_card" class="card bg-white p-5 rounded-xl shadow-sm mt-6" style="display: none;">
        <!-- Summary Cards -->
        <div class="grid grid-cols-3 gap-4 ">

            <div class="bg-gray-100 p-6 rounded-xl shadow-sm text-center">
                <p class="text-gray-500 text-sm">PRJ Req. Qty</p>
                <h2 class="text-3xl font-bold mt-2">17,712</h2>
            </div>

            <div class="bg-blue-50 p-6 rounded-xl shadow-sm text-center border border-blue-200">
                <p class="text-gray-700 text-sm">PO Placed Equivalent</p>
                <h2 class="text-3xl font-bold mt-2 text-blue-700">11,969</h2>
            </div>

            <div class="bg-green-50 p-6 rounded-xl shadow-sm text-center border border-green-200">
                <p class="text-gray-700 text-sm">GRN Qty</p>
                <h2 class="text-3xl font-bold mt-2 text-green-700">3,992</h2>
            </div>

        </div>

        <!-- Table -->
        <div class=" mt-6 p-6 overflow-auto">

            <table class="w-full text-sm">
            <thead class="bg-blue-100">
                <tr class="text-gray-500 border-b">
                    <th class="p-2 text-left">Status</th>
                    <th class="p-2">2XS</th>
                    <th class="p-2">XS</th>
                    <th class="p-2">S</th>
                    <th class="p-2">M</th>
                    <th class="p-2">L</th>
                    <th class="p-2">XL</th>
                    <th class="p-2">2XL</th>
                    <th class="p-2">3XL</th>
                    <th class="p-2">4XL</th>
                    <th class="p-2">5XL</th>
                    <th class="p-2">Total</th>
                </tr>
            </thead>

            {{-- Projection Materials --}}
            <tbody class="rm-table rm-table-projection">

                <tr class="border-b">
                <td class="p-2 font-medium">FRC Req. Qty</td>
                <td class="p-2">1,948</td><td>1,645</td><td>1,493</td><td>1,492</td><td>1,777</td><td>1,872</td>
                <td>1,872</td><td>1,871</td><td>1,870</td><td>1,872</td>
                <td class="font-semibold">17,712</td>
                </tr>

                <tr class="border-b">
                <td class="p-2 font-medium">PO Placed Equivalent</td>
                <td class="p-2">8,918</td><td>8,918</td><td>8,918</td><td>8,918</td><td>8,918</td><td>8,918</td>
                <td>8,918</td><td>8,918</td><td>8,918</td><td>8,918</td>
                <td class="font-semibold">89,180</td>
                </tr>

                <tr class="border-b">
                <td class="p-2 font-medium">GRN Qty</td>
                <td class="p-2">5,522</td><td>5,522</td><td>5,522</td><td>5,522</td><td>5,522</td><td>5,522</td>
                <td>5,522</td><td>5,522</td><td>5,522</td><td>5,522</td>
                <td class="font-semibold">55,222</td>
                </tr>

                <tr class="text-red-500 font-semibold">
                <td class="p-2">To be in-housed</td>
                <td class="p-2">-3,574</td><td>-3,877</td><td>-4,029</td><td>-4,030</td><td>-3,745</td>
                <td>-3,650</td><td>-3,650</td><td>-3,651</td><td>-3,652</td><td>-3,650</td>
                <td>-37,510</td>
                </tr>

            </tbody>
            </table>

        </div>
    </div>
  <!-- Projection Materials Table -->
  <div id="projection_materials" class="bg-white rounded-xl shadow-sm mt-6 p-6" style="display: none;">

    <div class="mb-4">
      <div class="flex rm-segment-track rounded-xl p-1 border border-gray-200">
        <button
          class="rm-tab rm-segment-active flex-1 text-center py-2 px-4 rounded-lg text-sm font-semibold shadow"
          data-tab="projection"
        >
          Projection Materials
        </button>
        <button
          class="rm-tab flex-1 text-center py-2 px-4 rounded-lg text-sm text-gray-500 hover:text-blue-600 transition"
          data-tab="sewing"
        >
          FRC Sewing Materials
        </button>
        <button
          class="rm-tab flex-1 text-center py-2 px-4 rounded-lg text-sm text-gray-500 hover:text-blue-600 transition"
          data-tab="packing"
        >
          FRC Packing Materials
        </button>
      </div>
    </div>

    <table class="w-full text-sm border">
      <thead class="bg-gray-100 text-gray-600">
        <tr>
          <th class="p-2 text-left">Item Code</th>
          <th class="p-2 text-left">Component</th>
          <th class="p-2 text-left">Size</th>
          <th class="p-2 text-left">Supplier</th>
          <th class="p-2">Lead Time (Days)</th>
          <th class="p-2">CK Date</th>
          <th class="p-2">CK Week</th>
          <th class="p-2">Req. Qty</th>
          <th class="p-2">UOM</th>
          <th class="p-2 text-left">Procurement Status</th>
          <th class="p-2">Commitment Date</th>
          <th class="p-2">Merchandiser</th>
        </tr>
      </thead>

      <tbody>

        <tr class="border-b">
          <td class="p-2">PKG-PB-016</td>
          <td class="p-2">Polybag</td>
          <td class="p-2">N/A</td>
          <td class="p-2">PackRight</td>
          <td class="p-2 text-center">15</td>
          <td class="p-2">Aug 04, 2025</td>
          <td class="p-2">W32</td>
          <td class="p-2 text-center">17,712</td>
          <td class="p-2">pcs</td>

          <td class="p-2">
              <div class="rm-progress-wrap w-full">
                  <div class="w-full h-3 rounded-full bg-gray-200 flex overflow-hidden">
                      <div class="bg-blue-500" style="width: 60%"></div>
                      <div class="bg-yellow-400" style="width: 20%"></div>
                      <div class="bg-gray-200 flex-1"></div>
                  </div>
                  <div class="rm-tooltip">
                      <div class="flex items-center gap-1 mb-0.5">
                          <span class="w-2 h-2 rounded-full bg-yellow-400 inline-block"></span>
                          <span>PO: 13,565 (76.6%)</span>
                      </div>
                      <div class="flex items-center gap-1">
                          <span class="w-2 h-2 rounded-full bg-blue-500 inline-block"></span>
                          <span>GRN: 11,998 (63.2%)</span>
                      </div>
                  </div>
              </div>
          </td>

          <td class="p-2 text-center">Dec 12, 2025</td>
          <td class="p-2">Mallory</td>
        </tr>

        <tr class="border-b bg-yellow-50">
          <td class="p-2">PKG-CB-017</td>
          <td class="p-2">Carton Box</td>
          <td class="p-2">N/A</td>
          <td class="p-2">BoxFactory</td>
          <td class="p-2 text-center">10</td>
          <td class="p-2">Aug 04, 2025</td>
          <td class="p-2">W32</td>
          <td class="p-2 text-center">17,712</td>
          <td class="p-2">pcs</td>

          <td class="p-2">
              <div class="rm-progress-wrap w-full">
                  <div class="w-full h-3 rounded-full bg-gray-200 flex overflow-hidden">
                      <div class="bg-blue-500" style="width: 60%"></div>
                      <div class="bg-yellow-400" style="width: 20%"></div>
                      <div class="bg-gray-200 flex-1"></div>
                  </div>
                  <div class="rm-tooltip">
                      <div class="flex items-center gap-1 mb-0.5">
                          <span class="w-2 h-2 rounded-full bg-yellow-400 inline-block"></span>
                          <span>PO: 13,565 (76.6%)</span>
                      </div>
                      <div class="flex items-center gap-1">
                          <span class="w-2 h-2 rounded-full bg-blue-500 inline-block"></span>
                          <span>GRN: 11,998 (63.2%)</span>
                      </div>
                  </div>
              </div>
          </td>

          <td class="p-2 text-center">Dec 11, 2025</td>
          <td class="p-2">Mallory</td>
        </tr>

      </tbody>

      {{-- FRC Sewing Materials --}}
      <tbody class="rm-table rm-table-sewing hidden">

        <tr class="border-b bg-blue-50">
          <td class="p-2">FAB-PK-011</td>
          <td class="p-2">Pocketing Fabric</td>
          <td class="p-2">2XS</td>
          <td class="p-2">Local Weavers</td>
          <td class="p-2 text-center">20</td>
          <td class="p-2">Aug 04, 2025</td>
          <td class="p-2">W32</td>
          <td class="p-2 text-center">2,922</td>
          <td class="p-2">meters</td>
          <td class="p-2">
              <div class="rm-progress-wrap w-full">
                  <div class="w-full h-3 rounded-full bg-gray-200 flex overflow-hidden">
                      <div class="bg-blue-500" style="width: 65%"></div>
                      <div class="bg-yellow-400" style="width: 15%"></div>
                      <div class="bg-gray-200 flex-1"></div>
                  </div>
                  <div class="rm-tooltip">
                      <div class="flex items-center gap-1 mb-0.5">
                          <span class="w-2 h-2 rounded-full bg-yellow-400 inline-block"></span>
                          <span>PO: 2,240 (76.6%)</span>
                      </div>
                      <div class="flex items-center gap-1">
                          <span class="w-2 h-2 rounded-full bg-blue-500 inline-block"></span>
                          <span>GRN: 1,846 (63.2%)</span>
                      </div>
                  </div>
              </div>
          </td>
          <td class="p-2 text-center">Dec 14, 2025</td>
          <td class="p-2">Heidi</td>
        </tr>

        <tr class="border-b">
          <td class="p-2">FAB-PK-011</td>
          <td class="p-2">Pocketing Fabric</td>
          <td class="p-2">XS</td>
          <td class="p-2">Local Weavers</td>
          <td class="p-2 text-center">20</td>
          <td class="p-2">Aug 04, 2025</td>
          <td class="p-2">W32</td>
          <td class="p-2 text-center">2,467.5</td>
          <td class="p-2">meters</td>
          <td class="p-2">
              <div class="rm-progress-wrap w-full">
                  <div class="w-full h-3 rounded-full bg-gray-200 flex overflow-hidden">
                      <div class="bg-blue-500" style="width: 60%"></div>
                      <div class="bg-yellow-400" style="width: 20%"></div>
                      <div class="bg-gray-200 flex-1"></div>
                  </div>
                  <div class="rm-tooltip">
                      <div class="flex items-center gap-1 mb-0.5">
                          <span class="w-2 h-2 rounded-full bg-yellow-400 inline-block"></span>
                          <span>PO: 1,880 (76.6%)</span>
                      </div>
                      <div class="flex items-center gap-1">
                          <span class="w-2 h-2 rounded-full bg-blue-500 inline-block"></span>
                          <span>GRN: 1,560 (63.2%)</span>
                      </div>
                  </div>
              </div>
          </td>
          <td class="p-2 text-center">Dec 14, 2025</td>
          <td class="p-2">Heidi</td>
        </tr>

        <tr class="border-b">
          <td class="p-2">FAB-PK-011</td>
          <td class="p-2">Pocketing Fabric</td>
          <td class="p-2">S</td>
          <td class="p-2">Local Weavers</td>
          <td class="p-2 text-center">20</td>
          <td class="p-2">Aug 04, 2025</td>
          <td class="p-2">W32</td>
          <td class="p-2 text-center">2,239.5</td>
          <td class="p-2">meters</td>
          <td class="p-2">
              <div class="rm-progress-wrap w-full">
                  <div class="w-full h-3 rounded-full bg-gray-200 flex overflow-hidden">
                      <div class="bg-blue-500" style="width: 55%"></div>
                      <div class="bg-yellow-400" style="width: 25%"></div>
                      <div class="bg-gray-200 flex-1"></div>
                  </div>
                  <div class="rm-tooltip">
                      <div class="flex items-center gap-1 mb-0.5">
                          <span class="w-2 h-2 rounded-full bg-yellow-400 inline-block"></span>
                          <span>PO: 1,720 (76.6%)</span>
                      </div>
                      <div class="flex items-center gap-1">
                          <span class="w-2 h-2 rounded-full bg-blue-500 inline-block"></span>
                          <span>GRN: 1,410 (63.2%)</span>
                      </div>
                  </div>
              </div>
          </td>
          <td class="p-2 text-center">Dec 14, 2025</td>
          <td class="p-2">Heidi</td>
        </tr>

      </tbody>

      {{-- FRC Packing Materials --}}
      <tbody class="rm-table rm-table-packing hidden">

        <tr class="border-b bg-yellow-50">
          <td class="p-2">FAB-TW-010</td>
          <td class="p-2">Main Fabric (Twill)</td>
          <td class="p-2">N/A</td>
          <td class="p-2">Premium Fabrics</td>
          <td class="p-2 text-center">75</td>
          <td class="p-2">Aug 04, 2025</td>
          <td class="p-2">W32</td>
          <td class="p-2 text-center">26,568</td>
          <td class="p-2">meters</td>
          <td class="p-2">
              <div class="rm-progress-wrap w-full">
                  <div class="w-full h-3 rounded-full bg-gray-200 flex overflow-hidden">
                      <div class="bg-blue-500" style="width: 70%"></div>
                      <div class="bg-yellow-400" style="width: 15%"></div>
                      <div class="bg-gray-200 flex-1"></div>
                  </div>
                  <div class="rm-tooltip">
                      <div class="flex items-center gap-1 mb-0.5">
                          <span class="w-2 h-2 rounded-full bg-yellow-400 inline-block"></span>
                          <span>PO: 20,336 (76.6%)</span>
                      </div>
                      <div class="flex items-center gap-1">
                          <span class="w-2 h-2 rounded-full bg-blue-500 inline-block"></span>
                          <span>GRN: 16,790 (63.2%)</span>
                      </div>
                  </div>
              </div>
          </td>
          <td class="p-2 text-center">Dec 24, 2025</td>
          <td class="p-2">Grace</td>
        </tr>

        <tr class="border-b">
          <td class="p-2">ZIP-YK-012</td>
          <td class="p-2">Zipper</td>
          <td class="p-2">N/A</td>
          <td class="p-2">YKK</td>
          <td class="p-2 text-center">50</td>
          <td class="p-2">Aug 04, 2025</td>
          <td class="p-2">W32</td>
          <td class="p-2 text-center">17,712</td>
          <td class="p-2">pcs</td>
          <td class="p-2">
              <div class="rm-progress-wrap w-full">
                  <div class="w-full h-3 rounded-full bg-gray-200 flex overflow-hidden">
                      <div class="bg-blue-500" style="width: 60%"></div>
                      <div class="bg-yellow-400" style="width: 20%"></div>
                      <div class="bg-gray-200 flex-1"></div>
                  </div>
                  <div class="rm-tooltip">
                      <div class="flex items-center gap-1 mb-0.5">
                          <span class="w-2 h-2 rounded-full bg-yellow-400 inline-block"></span>
                          <span>PO: 13,565 (76.6%)</span>
                      </div>
                      <div class="flex items-center gap-1">
                          <span class="w-2 h-2 rounded-full bg-blue-500 inline-block"></span>
                          <span>GRN: 11,998 (63.2%)</span>
                      </div>
                  </div>
              </div>
          </td>
          <td class="p-2 text-center">Dec 19, 2025</td>
          <td class="p-2">Ivan</td>
        </tr>

        <tr class="border-b">
          <td class="p-2">BTN-WD-013</td>
          <td class="p-2">Button</td>
          <td class="p-2">N/A</td>
          <td class="p-2">Button World</td>
          <td class="p-2 text-center">50</td>
          <td class="p-2">Aug 04, 2025</td>
          <td class="p-2">W32</td>
          <td class="p-2 text-center">17,712</td>
          <td class="p-2">pcs</td>
          <td class="p-2">
              <div class="rm-progress-wrap w-full">
                  <div class="w-full h-3 rounded-full bg-gray-200 flex overflow-hidden">
                      <div class="bg-blue-500" style="width: 55%"></div>
                      <div class="bg-yellow-400" style="width: 25%"></div>
                      <div class="bg-gray-200 flex-1"></div>
                  </div>
                  <div class="rm-tooltip">
                      <div class="flex items-center gap-1 mb-0.5">
                          <span class="w-2 h-2 rounded-full bg-yellow-400 inline-block"></span>
                          <span>PO: 13,565 (76.6%)</span>
                      </div>
                      <div class="flex items-center gap-1">
                          <span class="w-2 h-2 rounded-full bg-blue-500 inline-block"></span>
                          <span>GRN: 11,998 (63.2%)</span>
                      </div>
                  </div>
              </div>
          </td>
          <td class="p-2 text-center">Dec 19, 2025</td>
          <td class="p-2">Ivan</td>
        </tr>

      </tbody>

    </table>

  </div>

    <!-- po popup -->
    <div id="poModal" class="fixed inset-0 bg-black/40 flex items-center justify-center z-50 hidden">

    <!-- Modal Box -->
    <div class="bg-white w-[750px] rounded-2xl shadow-xl p-6 relative">

        <!-- Close Button -->
        <button id="closeModal" class="absolute top-4 right-4 text-gray-500 hover:text-gray-700">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
            d="M6 18L18 6M6 6l12 12" />
        </svg>
        </button>

        <!-- Title -->
        <h2 class="text-xl font-semibold text-gray-800">PO Details for: Polybag</h2>

        <!-- Subtitle -->
        <p class="text-sm text-gray-500 mt-1">
        Breakdown of purchase orders raised for FRC-UNIQLO-Pants-NA-UN-AW-25-02.
        </p>

        <!-- Table Container -->
        <div class="mt-5 border rounded-lg overflow-hidden">

        <table class="w-full text-sm">
            <thead>
            <tr class="bg-blue-50 text-gray-700 font-medium border-b">
                <th class="py-3 px-4 text-left">PO #</th>
                <th class="py-3 px-4 text-center">PO Qty</th>
                <th class="py-3 px-4 text-center">Planned In-house</th>
                <th class="py-3 px-4 text-center">Actual GRN Date</th>
            </tr>
            </thead>

            <tbody>

            <tr class="border-b text-gray-700">
                <td class="py-3 px-4">PO-PKG-PB-016-01</td>
                <td class="py-3 px-4 text-center">5,597</td>
                <td class="py-3 px-4 text-center">Nov 29, 2025</td>
                <td class="py-3 px-4 text-center">Dec 01, 2025</td>
            </tr>

            <tr class="text-gray-700">
                <td class="py-3 px-4">PO-PKG-PB-016-02</td>
                <td class="py-3 px-4 text-center">3,731</td>
                <td class="py-3 px-4 text-center">Dec 04, 2025</td>
                <td class="py-3 px-4 text-center text-gray-400">Pending</td>
            </tr>

            </tbody>
        </table>

        </div>

    </div>
    </div>


  <script>
    $(function () {
      $(document).on('click', '.rm-tab', function () {
        const tab = $(this).data('tab');

        // Switch active tab styles
        $('.rm-tab')
          .removeClass('rm-segment-active bg-white text-blue-600 font-semibold shadow')
          .addClass('text-gray-500');

        $(this)
          .addClass('rm-segment-active bg-white text-blue-600 font-semibold shadow')
          .removeClass('text-gray-500');

        // Switch table bodies
        $('.rm-table').addClass('hidden');
        $('.rm-table-' + tab).removeClass('hidden');
      });

      // Open PO modal when progress bar is clicked
      $(document).on('click', '.rm-progress-wrap', function () {
        $('#poModal').removeClass('hidden');
      });

      // Close PO modal
      $('#closeModal').on('click', function () {
        $('#poModal').addClass('hidden');
      });

      // Close modal when clicking outside
      $('#poModal').on('click', function (e) {
        if (e.target === this) {
          $('#poModal').addClass('hidden');
        }
      });
    });
  </script>
    <script>
    $(document).ready(function() {
      // Enable color dropdown when CC is selected
      $('#cc-dropdown').on('change', function() {
        if ($(this).val() !== '') {
          $('#color-dropdown').prop('disabled', false);
        } else {
          $('#color-dropdown').prop('disabled', true).val('');
          $('#buyer-dropdown').prop('disabled', true).val('');
          $('#season-dropdown').prop('disabled', true).val('');
          $('#prj-dropdown').prop('disabled', true).val('');
        }
      });

      // Enable buyer dropdown when Color is selected
      $('#color-dropdown').on('change', function() {
        if ($(this).val() !== '') {
          $('#buyer-dropdown').prop('disabled', false);
        } else {
          $('#buyer-dropdown').prop('disabled', true).val('');
          $('#season-dropdown').prop('disabled', true).val('');
          $('#prj-dropdown').prop('disabled', true).val('');
        }
      });

      // Enable season dropdown when Buyer is selected
      $('#buyer-dropdown').on('change', function() {
        if ($(this).val() !== '') {
          $('#season-dropdown').prop('disabled', false);
        } else {
          $('#season-dropdown').prop('disabled', true).val('');
          $('#prj-dropdown').prop('disabled', true).val('');
        }
      });

      // Enable PRJ dropdown when Season is selected
      $('#season-dropdown').on('change', function() {
        if ($(this).val() !== '') {
          $('#prj-dropdown').prop('disabled', false);
          $('#summary_card, #projection_materials').show();
          $('#no-data-message').hide();
        } else {
          $('#prj-dropdown').prop('disabled', true).val('');
          $('#summary_card, #projection_materials').hide();
          $('#no-data-message').show();
        }
      });
    });
  </script>
 </div>
</body>
</html>
