<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>POLICY ENTRY</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/2.11.6/umd/popper.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.6.0/js/bootstrap.min.js"></script>


    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }

        .sticky-header {
            position: sticky;
            top: 0;
            z-index: 1;
            background-color: #405189;
            color: #fff;
        }
    </style>


</head>

<body>
    @section('tittle') {{"POLICY ENTRY"}}@endsection

    <div id="layout-wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="live-preview">
                                        <form method="POST" action="{{ route('policy_ent_save') }}" enctype="multipart/form-data" class="has-validated" id="validate">
                                            @csrf
                                            <div class="row">
                                                <!-- POLICY NO -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">POLICY NO</label>
                                                        <input type="text" name="policyNum" id="policyNum" value="<?php echo $policy_No; ?>" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- DATE -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">DATE</label>
                                                        <input type="text" id="date" name="date" value="{{date('d-m-Y')}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- EFF-FROM -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">EFF-FROM<span class="login-danger">*</span></label>
                                                        <input type="date" id="eff" name="eff" onchange="datechange(this.value)" class="form-control" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="row">
                                                <!-- POLICY NAME -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label">POLICY NAME<span class="login-danger">*</span></label>
                                                        <div class="input-group">
                                                            <input type="text" class="form-control dull" id="policyNameHidden" name="policyNameHidden" style="pointer-events: none;" required>
                                                            <div class="input-group-append">
                                                                <span class="input-group-text">
                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-hand-index-fill" viewBox="0 0 16 16" data-toggle="modal" data-target="#policyTableModal">
                                                                        <path d="M8.5 4.466V1.75a1.75 1.75 0 1 0-3.5 0v5.34l-1.2.24a1.5 1.5 0 0 0-1.196 1.636l.345 3.106a2.5 2.5 0 0 0 .405 1.11l1.433 2.15A1.5 1.5 0 0 0 6.035 16h6.385a1.5 1.5 0 0 0 1.302-.756l1.395-2.441a3.5 3.5 0 0 0 .444-1.389l.271-2.715a2 2 0 0 0-1.99-2.199h-.581a5.114 5.114 0 0 0-.195-.248c-.191-.229-.51-.568-.88-.716-.364-.146-.846-.132-1.158-.108l-.132.012a1.26 1.26 0 0 0-.56-.642 2.632 2.632 0 0 0-.738-.288c-.31-.062-.739-.058-1.05-.046l-.048.002z" />
                                                                    </svg>
                                                                </span>
                                                            </div>
                                                        </div>
                                                        <input type="hidden" class="form-control" id="policyName" name="policyName" required>
                                                    </div>
                                                </div>
                                                <!-- POLICY TYPE -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label">POLICY TYPE<span class="login-danger"></span></label>
                                                        <input type="text" id="policytype" class="form-control dull details1" readonly required>
                                                        <input type="hidden" class="form-control policytype" id="policytype1" name="policytype1" readonly>
                                                    </div>
                                                </div>
                                                <!-- DEPARTMENT -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label">DEPARTMENT<span class="login-danger"></span></label>
                                                        <input type="text" id="department" class="form-control dull details2" readonly>
                                                        <input type="hidden" class="form-control details2" id="department1" name="department1" readonly>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- REMARK -->
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="validationTextarea" class="form-label">REMARK<span class="login-danger">*</span></label>
                                                        <textarea class="form-control" name="comment" id="comment" rows="3" required></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- ATTACHMENT -->
                                            <div class="row">
                                                <div class="form-group row form-row-spacing">
                                                    <div class="col-md-4">
                                                        <label class="form-label">Policy Document-1<span class="login-danger">*</span></label>
                                                        <input class="form-control" type="file" id="formFile1" name="formFile1" required>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label for="formFile" class="form-label">Policy Document-2 </label>
                                                        <input class="form-control" type="file" id="formFile2" name="formFile2">
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label for="formFile" class="form-label">Policy Document-3 </label>
                                                        <input class="form-control" type="file" id="formFile3" name="formFile3">
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <!--  SUBMIT BUTTON -->
                                            <div class="d-flex justify-content-around mt-3">
                                                <button type="submit" id="saveButton" class="btn btn-primary" name="submit">SAVE</button>
                                                <button type="button" id="clearButton" class="btn btn-warning" onclick="window.location.reload()">CLEAR</button>
                                                <button type="button" id="reportButton" class="btn btn-info" onclick="window.location.href = '/policy_ent_rep'">Report</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- -----POPUP TABLE ---- -->
    <!-- Modal -->
    <div class="modal fade" id="policyTableModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">SELECT A POLICY*</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" style="max-height: 300px; overflow-y: auto; padding: 0px;">
                    <table id="app_table" class="table table-bordered table-condensed table-hover table-striped">
                        <thead class="sticky-header">
                            <tr>
                                <th></th>
                                <th>SNO</th>
                                <th>Policy Name</th>
                                <th> Policy Type</th>
                                <th>Department </th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Data will be added here via AJAX -->
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">OK</button>
                </div>
            </div>
        </div>
    </div>




    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>


    <!-- //POPUP TABLE -->
    <script>
        // Function to open the modal
        function openPolicyTableModal() {
            console.log('Modal function called');
            $('#policyTableModal').modal('show');
        }
    </script>

    <!-- //GETING POLCIY NAME -->
    <script>
        document.getElementById('policyName').addEventListener('change', function() {
            var selectedOption = this.options[this.selectedIndex];
            var selectedID = selectedOption.value;
            var selectedName = selectedOption.textContent;

        });
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- ---AJAX METHOD ---- -->
    <script>
        function datechange(t_name) {
            var selected_name = t_name;

            $.ajax({
                url: "{{ route('policy_ent') }}",
                type: "GET",
                data: {
                    eff: selected_name,
                },
                dataType: 'json',
                success: function(details) {
                    console.log(details);

                    var table = $('#app_table').find('tbody');
                    table.empty();

                    for (let i = 0; i < details.length; i++) {
                        var policy_name = details[i].policy_name;
                        var Type_policy = details[i].Type_policy;
                        var Department = details[i].Department;

                        var newRow = $('<tr>');
                        newRow.append('<td><input type="radio" name="policy_radio" value="' + i + '"></td>');
                        newRow.append('<td>' + (i + 1) + '</td>');
                        newRow.append('<td>' + policy_name + '</td>');
                        newRow.append('<td>' + Type_policy + '</td>');
                        newRow.append('<td>' + Department + '</td>');

                        table.append(newRow);
                    }

                    // Add a click event handler for the radio buttons
                    $('input[type=radio][name=policy_radio]').click(function() {
                        var selectedIndex = $(this).val();
                        var selectedRowData = details[selectedIndex];
                        console.log(selectedRowData);
                        // Populate the input boxes with selected data
                        $('#policyNameHidden').val(selectedRowData.policy_name);
                        $('#policyName').val(selectedRowData.policy_id);
                        $('#policytype').val(selectedRowData.Type_policy);
                        $('#policytype1').val(selectedRowData.Type_id);
                        $('#department').val(selectedRowData.Department);
                        $('#department1').val(selectedRowData.dept_id);
                    });
                }
            });
        }
    </script>



    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($message = Session::get('alert'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>