<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link rel="stylesheet" href="{{ asset('frontend/css/bootstrap.min.css')}}">
    <link rel="icon" href="L@g_logo.png" type="png">
    <style>
        * {
            cursor: url('{{ asset('frontend/pongal/icon_sugarcane.png') }}') 16 16, progress !important;
        }

        body {
            margin: 0;
            font-family: Arial, sans-serif;
            overflow: hidden;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            flex-direction: column;
            position: relative;
        }

        .video-background {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            overflow: hidden;
        }

        .video-background video {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .login-container {
            position: fixed;
            top: 45%;
            right: 5%;
            transform: translateY(-50%);
            width: 300px !important;
            height: 70% !important;
            background-color: rgba(255, 255, 255, 0.9);
            padding: 20px;
            box-shadow: -2px 2px 10px rgba(0, 0, 0, 0.2);
            border-radius: 8px;
            z-index: 2;
            display: none;
            /* Hide the form initially */
        }

        .login-form {
            display: flex;
            flex-direction: column;
        }

        .login-form h2 {
            margin-bottom: 20px;
            text-align: center;
            font-family: 'Courier New', Courier, monospace;
            font-weight: 800;
        }

        .login-form label {
            font-size: 14px;
            margin-bottom: 5px;
        }

        .login-form input {
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        .login-form button {
            padding: 10px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }

        .login-form button:hover {
            background-color: #0056b3;
        }

        .forgot-password {
            margin-top: 10px;
            text-align: center;
        }

        .forgot-password-link {
            color: #007bff;
            text-decoration: none;
        }

        .forgot-password-link:hover {
            text-decoration: underline;
        }

        .pongal-image {
            position: absolute;
            top: 25%;
            right: 30%;
            z-index: 1;
            height: 30%;
        }

        .link {
            margin-top: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .link img {
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .login-container {
                right: 50%;
                transform: translateX(50%) translateY(-50%);
                width: 80%;
            }

            .pongal-image {
                position: absolute;
                top: 20%;
                left: 10%;
                right: 10%;
                z-index: 1;
                height: 20%;
            }

            .video-background video {
                object-fit: cover;
            }

            .link {
                margin-top: 20px;
                display: flex;
                justify-content: space-between;
                align-items: center;
            }

            .link img {
                width: 40px;
                margin-bottom: 15px;
            }
        }

        @media (max-width: 480px) {
            .login-container {
                width: 90%;
            }

            .pongal-image {
                top: 15%;
                left: 5%;
                right: 5%;
                height: 15%;
            }

            .login-form input,
            .login-form button {
                font-size: 14px;
            }

            .forgot-password-link {
                font-size: 12px;
            }
        }
    </style>

    <style>
        #pongal-spinner {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 9999;
        }

        .spinner {
            position: relative;
            width: 100px;
            height: 100px;
            animation: spin 2s infinite linear;
        }

        .spinner-img {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 60px;
            /* Adjust the size of the image */
            height: 60px;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .spinner_bg {
            background: rgba(255, 255, 255, 0.8);
            height: 100%;
            width: 100%;
            text-align: center;
            align-items: center;
            display: flex;
            justify-content: center;
            z-index: 9998;
        }
    </style>

<style>

</style>

</head>

<body id="body">
    <div class="video-background">
        <video autoplay loop muted playsinline id="bgVideo">
            <source src="{{ asset('frontend/pongal/pongal_bg_video1_cow.mp4') }}" type="video/mp4">
            Your browser does not support the video tag.
        </video>
    </div>
    <div id="wish_text" style="display: none;">
        <img src="{{ asset('frontend/pongal/pongal_text_tamil.png') }}" alt="Pongal Wish" class="pongal-image">
    </div>
    <div class="login-container" id="loginForm">
        <form action="/dashboard" method="POST" id="form" class="login-form">
            @csrf
            @if(\Session::has('message'))
            <div id="message" class="alert alert-info">
                {{\Session::get('message')}}
            </div>
            <script>
                setTimeout(function() {
                    var successAlert = document.getElementById('message');
                    if (successAlert) {
                        successAlert.remove();
                    }
                }, 15000);
            </script>
            @endif
            @if(session('alert'))
            <style>
                .custom-light-red-alert {
                    background-color: #ffcccc;
                    border-color: #ff9999;
                    color: #0b0b10;
                }
            </style>
            <div id="alert" class="alert custom-light-red-alert d-flex align-items-center" role="alert">
                <svg class="bi flex-shrink-0 me-2" role="img" aria-label="Danger:" style="width: 40px; height: 40px;">
                    <use xlink:href="#exclamation-triangle-fill" />
                </svg>
                <div class="mr-3"></div>
                {{ session('alert') }}
            </div>
            <script>
                setTimeout(function() {
                    var successAlert = document.getElementById('alert');
                    if (successAlert) {
                        successAlert.remove();
                    }
                }, 15000);
            </script>
            @endif
            <h2>
                <img src="{{ asset('frontend/pongal/pongal_left.png') }}" class="mr-2" height="15%" width="15%" alt="Pongal Wish">
                LOGIN
                <img src="{{ asset('frontend/pongal/pongal_right.png') }}" class="ml-2" height="15%" width="15%" alt="Pongal Wish">
            </h2>
            <label for="username">Username</label>
            <input type="text" id="UserName" name="UserName" placeholder="Username" maxlength="10" required>
            @if ($errors->has('UserName'))
            <span class="text-danger">{{ $errors->first('UserName') }}</span>
            @endif
            <label for="password">Password</label>
            <input type="password" id="PassWord" name="PassWord" placeholder="Password" required>
            @if ($errors->has('PassWord'))
            <span class="text-danger">{{ $errors->first('PassWord') }}</span>
            @endif
            <button type="submit">Login</button>
            <div class="forgot-password">
                <a href="forgot" class="forgot-password-link">Forgot Password?</a>
            </div>
            <div class="link d-flex justify-content-between">
                <a href="https://www.gainup.in/" class="mb-5" title="Visit Gainup Website">
                    <img src="L@g_logo.png" alt="" srcset="" width="40">
                </a>
                <br>
                <a href="http://supplier.gainup.in:8084/login" target="_blank" class="mb-5 highlight-link" title="Supplier Portal" download="LatG_App.apk">
                    <img src="SUPPLIER.png" alt="Life@Gainup App" width="40">
                </a>
                <br>
                <a href="griev_entry">
                    <img src="Grievence_img.jfif" alt="" srcset="" class="mb-5 highlight-link" width="60" title="Grievance Entry">
                </a>
            </div>
        </form>
    </div>

    <div class="spinner_bg" id="spinner_bg" style="display: none;"></div>
    <div id="pongal-spinner" style="display:none;">
        <div class="spinner">
            <img src="{{ asset('frontend/pongal/icon_pot_spin.png') }}" alt="Pongal Wish" class="spinner-img">
        </div>
    </div>

    <script>
        const spinner_bg = document.getElementById('spinner_bg');
        const spinner = document.getElementById('pongal-spinner');
        document.addEventListener('DOMContentLoaded', () => {
            spinner.style.display = 'none';
            spinner_bg.style.display = 'none';
        });

        let form = document.getElementById('form');
        form.addEventListener('submit', () => {
            spinner.style.display = 'block';
            spinner_bg.style.display = 'block';
        });
    </script>

    <script>
        const video = document.getElementById('bgVideo');
        const loginForm = document.getElementById('loginForm');
        const text = document.getElementById('wish_text');

        // Wait for the video to load enough to play through without buffering
        video.addEventListener('canplaythrough', () => {
            loginForm.style.display = 'block'; // Show the form
            text.style.display = 'block'; // Show the form
        });
    </script>
</body>

</html>