<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Cutting Output Dashboard</title>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.tailwindcss.com"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
  <!-- Font Awesome CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
<script>
    tailwind.config = {
        theme: {
            extend: {
                colors: {
                    'ui-bg': '#f5f7f9',
                    'ui-primary': '#2563eb',
                    'ui-secondary': '#94a3b8',
                    'kpi-blue': '#1e40af',
                    'kpi-bg': '#f1f5f9',
                    'bar-main': '#2962ff',
                    'bar-sub': '#6495ed',
                    'primary': '#1d4ed8',
                    'primary-foreground': '#ffffff',
                    'card-bg': 'rgba(255, 255, 255, 0.1)',
                },
                fontFamily: {
                    sans: ['Inter', 'sans-serif'],
                },
            }
        }
    }
</script>

<style>
    body {
        background-color: #f8fafc;
    }
    html, body {
        overflow-x: hidden;
        width: 100%;
    }
    .table-header-cell {
        padding-left: 8px;
        padding-right: 8px;
        padding-top: 12px;
        padding-bottom: 12px;
        text-align: left;
        font-size: 0.65rem;
        font-weight: 500;
        color: #64748b;
        text-transform: uppercase;
        letter-spacing: 0.05em;
    }
    .table-data-cell {
        padding-left: 8px;
        padding-right: 8px;
        padding-top: 8px;
        padding-bottom: 8px;
        font-size: 0.7rem;
        white-space: nowrap;
    }
    .kpi-card-border-blue { border-top: 4px solid #3b82f6; }
    .kpi-card-border-red { border-top: 4px solid #ef4444; }
    .kpi-card-border-yellow { border-top: 4px solid #f59e0b; }
    .kpi-card-border-teal { border-top: 4px solid #14b8a6; }
    .kpi-card-border-purple { border-top: 4px solid #8b5cf6; }
    .styled-select {
        appearance: none;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' fill='%23ffffff'%3E%3Cpath fill-rule='evenodd' d='M5.23 7.21a.75.75 0 011.06.02L10 10.99l3.71-3.76a.75.75 0 111.08 1.04l-4.25 4.5a.75.75 0 01-1.08 0l-4.25-4.5a.75.75 0 01.02-1.06z' clip-rule='evenodd' /%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-position: right 0.75rem center;
        background-size: 1em;
        padding-right: 2.5rem;
    }
    .date-picker input {
        background: rgba(248, 250, 252, 0.1);
        color: white;
    }
    .date-picker input::placeholder {
        color: rgba(248, 250, 252, 0.7);
    }
    .spinner {
        display: inline-block;
        width: 1.5rem;
        height: 1.5rem;
        border: 3px solid rgba(255, 255, 255, 0.3);
        border-top-color: #fff;
        border-radius: 50%;
        animation: spin 1s ease-in-out infinite;
    }
    @keyframes spin {
        to { transform: rotate(360deg); }
    }
    /* Compact DataTables length control */
    .dataTables_wrapper .dataTables_length label { font-size: 12px; color:#6b7280; }
    .dataTables_wrapper .dataTables_length select { font-size: 12px; padding: 2px 6px; height: 26px; line-height: 22px; border:1px solid #e5e7eb; border-radius:6px; width:auto; min-width:56px; }
    /* Compact DataTables search control */
    .dataTables_wrapper .dataTables_filter input { font-size: 12px; padding: 2px 6px; height: 26px; line-height: 22px; border:1px solid #D3D3D3; border-radius:6px; width:120px; background-color: #ffffff; }
    /* Compact DataTables info and pagination */
    .dataTables_wrapper .dataTables_info { font-size: 12px; color:#6b7280; }
    .dataTables_wrapper .dataTables_paginate { font-size: 12px; }
    .dataTables_wrapper .dataTables_paginate .paginate_button { padding: 2px 6px; margin: 0 1px; font-size: 12px; }
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0.5em 1em;
        margin: 0 2px;
        border: 1px solid #e2e8f0;
        border-radius: 4px;
        color: #64748b;
        background-color: #fff;
    }
    .dataTables_wrapper .dataTables_paginate .paginate_button.current,
    .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
        background-color: #5e5f5fe1;
        color: #fff;
        border-color: #5e5f5fe1;
    }
    .dataTables_wrapper .dataTables_paginate .paginate_button.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
    .dataTables_wrapper .dataTables_filter input {
        border: 1px solid #e2e8f0;
        border-radius: 4px;
        padding: 0.5em;
        margin-left: 0.5em;
    }
    .dataTables_wrapper .dataTables_length select {
        border: 1px solid #e2e8f0;
        border-radius: 4px;
        padding: 0.5em;
    }
    /* Hide scrollbar indicator but allow vertical scrolling */
    .scroll-ghost { scrollbar-width: none; -ms-overflow-style: none; }
    .scroll-ghost::-webkit-scrollbar { width: 0; height: 0; }
    /* Keep header and body columns aligned in scrollable popper tables */
    .popper-table-2 { width: auto; border-collapse: collapse; }
    .popper-table-2 thead, .popper-table-2 tbody { display: block; }
    .popper-table-2 tbody { max-height: 100px; overflow-y: auto; }
    .popper-table-2 th, .popper-table-2 td { width: 100%; box-sizing: border-box; }
    .popper-table-2 th:nth-child(1), .popper-table-2 td:nth-child(1) { padding-right: 12px; }
    .popper-table-2 th:nth-child(2), .popper-table-2 td:nth-child(2) { text-align: right; }
    .fit-popper { width: max-content; max-width: 90vw; }
    .highlight {
        background-color: #48c4f5bb;
        color: #1e3a8a;
        font-weight: bold;
    }
	.tab-option.active { color: #1e40af; font-weight: 600; border-bottom: 2px solid #1e40af; }
    .kpi-card.active { box-shadow: 0 0 0 2px #1e40af inset, 0 0 12px rgba(30,64,175,0.35); border-color:#1e40af; }
	    /* Cutting table: keep inside card and scroll horizontally on zoom */
		#cuttingTableContainer { overflow-x: auto; width: 100%; }
		#cuttingTable { width: max-content; min-width: 1200px; } /* adjust as needed */

		/* Prevent wrap that misaligns header/body */
		#cuttingTable thead th,
		#cuttingTable tbody td { white-space: nowrap; }

		/* If DataTables wraps the table, keep wrapper scrollable too */
		#cuttingCardTableWrap .dataTables_wrapper { overflow-x: auto; }
</style>
</head>
<body  class="bg-gray-50 text-gray-800">

        @php
        $empl_no= Session::get('empl_id');
        $empl_name = Session::get('emp_name');
        @endphp
   
   
   @include('LifeAtGainup.production.header')

    <!-- Breadcrumb -->
    <div class="px-6 py-3 text-sm text-gray-600">
        <a id="productionBreadcrumb" href="/production_gar_dashboard" class="text-blue-700 hover:underline">Production Dashboard</a> 
        <span> &gt; </span>
        <span class="text-gray-800 font-medium">Cutting Output</span>
    </div>

<div class="px-6 py-2">
    <div class="grid grid-cols-10 gap-2 mb-8">
        <div class="bg-white p-4 rounded-lg shadow-md kpi-card kpi-card-border-blue active col-span-2" data-type="cuttingOutput">
            <div class="flex items-center mb-1 gap-2">
                <div class="text-xs font-medium text-gray-500 mb-1">Cutting Output</div>
                <div class="flex bg-gray-50 rounded-md border border-gray-200 px-2 py-1 gap-3">
                    <span class="tab-option text-[0.8rem] text-gray-500 cursor-pointer hover:text-kpi-blue hover:font-semibold transition active" data-type="pieces">Pieces</span>
                    <span class="tab-option text-[0.8rem] text-gray-500 cursor-pointer hover:text-kpi-blue hover:font-semibold transition" data-type="lay">Lay</span>
                    <span class="tab-option text-[0.8rem] text-gray-500 cursor-pointer hover:text-kpi-blue hover:font-semibold transition" data-type="fabric">Kgs</span>
                </div>
            </div>    
            <div class="flex justify-between items-end">
                <div class="space-y-0.5">
                    <div data-role="value" class="text-3xl font-bold text-kpi-blue">0</div>
                    <div data-role="change" class="text-[0.6rem] leading-none text-gray-500">
                        <span class="text-red-500 font-semibold">0%</span> 
                        <span class="text-gray-500">vs yesterday</span>
                    </div>
                    <div data-role="target" class="text-[0.6rem] text-gray-400">Target: 0</div>
                </div>
                <div class="w-1/3 h-10 bg-kpi-bg rounded-md p-1">
                    <canvas data-role="mini-chart"></canvas>
                </div>
            </div>
        </div>

        <div class="bg-white p-4 rounded-lg shadow-md kpi-card kpi-card-border-blue col-span-2" data-type="balancecuttingOutput">
            <div class="flex items-center mb-1 gap-2">
                <div class="text-xs font-medium text-gray-500 mb-1">Bal To Cut</div>
            </div>    
            <div class="flex justify-between items-end">
                <div class="space-y-0.5">
                    <div data-role="value" class="text-3xl font-bold text-kpi-blue">0</div>
                    <div data-role="change" class="text-[0.6rem] leading-none text-gray-500">
                        <span class="text-red-500 font-semibold">0%</span> 
                        <span class="text-gray-500">vs yesterday</span>
                    </div>
                    <div data-role="target" class="text-[0.6rem] text-gray-400">Target: 0</div>
                </div>
                <div class="w-1/3 h-10 bg-kpi-bg rounded-md p-1">
                    <canvas data-role="mini-chart"></canvas>
                </div>
            </div>
        </div>

        <div class="bg-white p-4 rounded-lg shadow-md kpi-card kpi-card-border-blue col-span-2" data-type="cutpanelOutput">
            <div class="flex items-center mb-1 gap-2">
                <div class="text-xs font-medium text-gray-500 mb-1">Cut Panel</div>
                <div class="flex bg-gray-50 rounded-md border border-gray-200 px-2 py-1 gap-3">
                    <span class="tab-option text-[0.8rem] text-gray-500 cursor-pointer hover:text-kpi-blue hover:font-semibold transition active" data-type="checked">Checked</span>
                    <span class="tab-option text-[0.8rem] text-gray-500 cursor-pointer hover:text-kpi-blue hover:font-semibold transition" data-type="rej">Rej</span>
                    <span class="tab-option text-[0.8rem] text-gray-500 cursor-pointer hover:text-kpi-blue hover:font-semibold transition" data-type="rejperc">Rej%</span>
                </div>
            </div>    
            <div class="flex justify-between items-end">
                <div class="space-y-0.5">
                    <div data-role="value" class="text-3xl font-bold text-kpi-blue">0</div>
                    <div data-role="change" class="text-[0.6rem] leading-none text-gray-500">
                        <span class="text-red-500 font-semibold">0%</span> 
                        <span class="text-gray-500">vs yesterday</span>
                    </div>
                    <div data-role="target" class="text-[0.6rem] text-gray-400">Target: 0</div>
                </div>
                <div class="w-1/3 h-10 bg-kpi-bg rounded-md p-1">
                    <canvas data-role="mini-chart"></canvas>
                </div>
            </div>
        </div>

        <div class="bg-white p-3 rounded-lg shadow-md  kpi-card cursor-pointer col-span-1" data-type="fabricUtilization" style="pointer-events: auto; transition: none; box-shadow: none !important; background-color: #ddd8d8ff !important;">
            <div class="text-xs font-medium text-gray-500 mb-1">Fabric Utilization</div>
            <div class="flex justify-between items-end">
                <div class="space-y-0.5">
                    <div class="text-3xl font-bold text-kpi-blue">86%</div>
                    <div class="text-[0.6rem] leading-none text-gray-500">
                        <span class="text-green-500 font-semibold">2%</span> 
                        <span class="text-gray-500">vs last week</span>
                    </div>
                    <div class="text-[0.6rem] text-gray-400">Target: 90%</div>
                </div>
                <div class="w-1/3 h-8 bg-kpi-bg rounded-md p-1">
                    <canvas id="kpi-chart-2"></canvas>
                </div>
            </div>
        </div>
        <div class="bg-white p-3 rounded-lg shadow-md  kpi-card cursor-pointer col-span-1" data-type="firstTimeRight" style="pointer-events: auto; transition: none; box-shadow: none !important; background-color: #ddd8d8ff !important;">
            <div class="text-xs font-medium text-gray-500 mb-1">First Time Right</div>
            <div class="flex justify-between items-end">
                <div class="space-y-0.5">
                    <div class="text-3xl font-bold text-kpi-blue">97%</div>
                    <div class="text-[0.6rem] leading-none text-gray-500">
                        <span class="text-green-500 font-semibold">0.5%</span> 
                        <span class="text-gray-500">vs last week</span>
                    </div>
                    <div class="text-[0.6rem] text-gray-400">Target: 95%</div>
                </div>
                <div class="w-1/3 h-8 bg-kpi-bg rounded-md p-1">
                    <canvas id="kpi-chart-3"></canvas>
                </div>
            </div>
        </div>
        <div class="bg-white p-3 rounded-lg shadow-md  kpi-card cursor-pointer col-span-1" data-type="markerEfficiency" style="pointer-events: auto; transition: none; box-shadow: none !important; background-color: #ddd8d8ff !important;">
            <div class="text-xs font-medium text-gray-500 mb-1">Marker Efficiency</div>
            <div class="flex justify-between items-end">
                <div class="space-y-0.5">
                    <div class="text-3xl font-bold text-kpi-blue">88%</div>
                    <div class="text-[0.6rem] leading-none text-gray-500">
                        <span class="text-red-500 font-semibold">3%</span> 
                        <span class="text-gray-500">vs last week</span>
                    </div>
                    <div class="text-[0.6rem] text-gray-400">Target: 90%</div>
                </div>
                <div class="w-1/3 h-8 bg-kpi-bg rounded-md p-1">
                    <canvas id="kpi-chart-4"></canvas>
                </div>
            </div>
        </div>
        <div class="bg-white p-3 rounded-lg shadow-md  kpi-card cursor-pointer col-span-1" data-type="machineDowntime" style="pointer-events: auto; transition: none; box-shadow: none !important; background-color: #ddd8d8ff !important;">
            <div class="text-xs font-medium text-gray-500 mb-1">Machine Downtime</div>
            <div class="flex justify-between items-end">
                <div class="space-y-0.5">
                    <div class="text-3xl font-bold text-kpi-blue">124 mins</div>
                    <div class="text-[0.6rem] leading-none text-gray-500">
                        <span class="text-red-500 font-semibold">5%</span> 
                        <span class="text-gray-500">vs yesterday</span>
                    </div>
                    <div class="text-[0.6rem] text-gray-400">Target: 90 mins</div>
                </div>
                <div class="w-1/3 h-8 bg-kpi-bg rounded-md p-1">
                    <canvas id="kpi-chart-5"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-3 gap-2 mb-14 h-[20rem]">
        <div class="bg-white p-4 rounded-lg shadow-md flex flex-col">
            <div class="flex flex-row items-center gap-2">
               
                <div class="text-sm font-semibold text-gray-700 mb-3 bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Overall Trend</div>
                 <div class="text-xs text-gray-500 mb-3 ">Time-series trend for the selected KPI</div>
            </div>
           
            <div class="flex-grow">
                <canvas id="overall-trend-chart"></canvas>
            </div>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-md flex flex-col">
            <div class="text-sm font-semibold text-gray-700 mb-3 bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient" id="unitChartTitle">Machine-wise Total Pieces</div>
            <div class=" mb-3">
                <span id="unitBreadcrumbPieces">All Units</span>
            </div>
            <div class="flex justify-end text-xs font-medium mb-4 space-x-2 hidden">
                <button class="text-bar-main border-b-2 border-bar-main pb-0.5">All Units</button>
                <button class="text-gray-500 hover:text-bar-main">Unit 1</button>
                <button class="text-gray-500 hover:text-bar-main">Unit 2</button>
            </div>
            <div class="flex-grow">
                <canvas id="unit-pieces-chart"></canvas>
            </div>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-md">
            <div class="flex justify-between items-center mb-4">
                <div class="text-sm font-semibold text-gray-700 mb-3 bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Attribute Drilldown</div>
                <select id="attributeModeSelect" class="hidden text-xs border border-gray-300 rounded-md py-1 px-2 focus:ring-ui-primary focus:border-ui-primary">
                <option>Daily KPI</option>
                <option>Cumulative Progress</option>
                </select>
            </div>
            <div class="space-y-4">
                <div class="">
                    <span id="buyerBreadcrumb">All Buyer</span>
                </div>
                <div class="h-80">
                    <canvas id="attribute-drilldown-chart"></canvas>
                </div>
            </div>
        </div>
    </div>
	<div class="py-4">
		<div class="bg-white p-4 rounded-lg shadow-md mt-20" id="cuttingCardTableWrap">
			<div class="flex justify-between items-center mb-4">
				<div>
					<h2 class="text-sm font-semibold text-gray-700 bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Cutting Details</h2>
					<div class="hidden text-xs text-gray-500 mt-1">A detailed log of each cutting lay operation.</div>
				</div>
			</div>
			<div class=" relative" id="cuttingTableContainer">
				<table class="min-w-full divide-y divide-gray-200" id="cuttingTable">
					<thead>
						<tr>
							<th class="table-header-cell min-w-[50px]">Date</th>
							<th class="table-header-cell min-w-[40px]">Lay ID</th>
							<th class="table-header-cell min-w-[90px]">Unit / Shift / Machine</th>
							<th class="table-header-cell min-w-[50px]">Buyer</th>
							<th class="table-header-cell min-w-[90px]">OCN / Style / Color</th>
							<th class="table-header-cell min-w-[40px]">Rolls Used</th>
							<th class="table-header-cell min-w-[40px]">GSM</th>
							<th class="table-header-cell min-w-[60px]">Fabric Wt. (kg)</th>
							<th class="table-header-cell min-w-[40px]">End Bit</th>
                        
							<th class="table-header-cell min-w-[60px]">Cutting Time (min)</th>
                        
							<th class="table-header-cell min-w-[60px]">Cutting Output</th>
							<th class="table-header-cell min-w-[40px]">Ack. pend</th>
							<th class="table-header-cell min-w-[60px]">SM Received</th>
							<th class="table-header-cell min-w-[40px]">Line Qty</th>
						</tr>
					</thead>
					<tbody class="bg-white divide-y divide-gray-100 text-gray-700 text-xs"></tbody>
				</table>
				</table>
				<!-- Popper for Roll details -->
				<div id="rollPopper" class="hidden absolute z-50 bg-white shadow-xl rounded-lg border border-gray-200  p-4 text-sm fit-popper">
					<div class="font-semibold text-gray-800 mb-2">Roll Details</div>
					<table class="min-w-full ">
						<thead>
						   <tr class="text-gray-500 text-xs">
								<th class="text-left py-1 w-[60px]">Roll No.</th>
								<th class="text-left py-1 w-[60px]">R_Points</th>
								<th class="text-left py-1 w-[60px]">Supplier</th>
								<th class="text-left py-1 w-[60px]">Shade</th>
								<th class="text-left py-1 w-[60px]">Relax (hrs)</th>
							</tr>
						</thead>
						<tbody id="popRollBody"  class="scroll-ghost">
                        
						</tbody>
					</table>
				</div>
				<!-- Popper for Cut Output Breakdown -->
				<div id="cutPopper" class="hidden absolute z-50 bg-white shadow-xl rounded-lg border border-gray-200 p-4 text-sm fit-popper">
					<div class="font-semibold text-gray-800 mb-2">Cut Output Breakdown</div>
					<table class="min-w-full">
						<thead>
							<tr class="text-gray-500 text-xs">
								<th class="text-left py-1">Size</th>
								<th class="text-left py-1">Qty</th>
								<th class="text-left py-1">FPY%</th>
							</tr>
						</thead>
						<tbody id="cutBreakdownBody" class="scroll-ghost">
							<!-- rows injected on click -->
						</tbody>
					</table>
				</div>
				<!-- Popper for Ack Pending Breakdown -->
				<div id="ackPopper" class="hidden absolute z-50 bg-white shadow-xl rounded-lg border border-gray-200 p-4 text-sm fit-popper">
					<div class="font-semibold text-gray-800 mb-2">Ack. Pending Breakdown</div>
					<table class="min-w-full popper-table-2">
						<thead>
							<tr class="text-gray-500 text-xs">
								<th class="text-left py-1">Size</th>
								<th class="text-left py-1">Qty</th>
							</tr>
						</thead>
						<tbody id="ackBreakdownBody" class="scroll-ghost">
							<!-- rows injected on click -->
						</tbody>
					</table>
				</div>
				<!-- Popper for Issued to SM Breakdown -->
				<div id="issdPopper" class="hidden absolute z-50 bg-white shadow-xl rounded-lg border border-gray-200 p-4 text-sm fit-popper">
					<div class="font-semibold text-gray-800 mb-2">Issued to SM Breakdown</div>
					<table class="min-w-full popper-table-2">
						<thead>
							<tr class="text-gray-500 text-xs">
								<th class="text-left py-1">Size</th>
								<th class="text-left py-1">Qty</th>
							</tr>
						</thead>
						<tbody id="issdBreakdownBody" class="scroll-ghost">
							<!-- rows injected on click -->
						</tbody>
					</table>
				</div>
				<!-- Popper for Line Issue Breakdown -->
				<div id="linePopper" class="hidden absolute z-50 bg-white shadow-xl rounded-lg border border-gray-200 p-4 text-sm fit-popper">
					<div class="font-semibold text-gray-800 mb-2">Line Issue Breakdown</div>
					<table class="min-w-full popper-table-2">
						<thead>
							<tr class="text-gray-500 text-xs">
								<th class="text-left py-1">Size</th>
								<th class="text-left py-1">Qty</th>
							</tr>
						</thead>
						<tbody id="lineBreakdownBody" class="scroll-ghost">
							<!-- rows injected on click -->
						</tbody>
					</table>
				</div>
			</div>
			<div class="hidden flex justify-between items-center mt-4 text-xs text-gray-500">
				<div>Showing 1 to 10 of 50 entries</div>
				<div class="flex items-center space-x-2">
					<button class="px-3 py-1 border border-gray-300 rounded-md hover:bg-gray-100 disabled:opacity-50" disabled>Previous</button>
					<span class="font-semibold text-gray-700 px-2">Page 1 of 5</span>
					<button class="px-3 py-1 border border-gray-300 rounded-md hover:bg-gray-100">Next</button>
				</div>
			</div>
		</div>

		<!-- Balance Cutting Table Card (hidden by default) -->
        <div class="bg-white p-4 rounded-lg shadow-md mt-20 hidden" id="balanceCardTableWrap">
            <div class="flex justify-between items-center mb-4">
                <div>
                    <h2 class="text-sm font-semibold text-gray-700 bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Balance Cutting Details</h2>
                </div>
            </div>
            <div class="relative">
                <table class="min-w-full divide-y divide-gray-200" id="balanceTable">
                    <thead>
                        <tr>
                            <th class="table-header-cell">Unit</th>
                            <th class="table-header-cell">Buyer</th>
                            <th class="table-header-cell">OCN</th>
                            <th class="table-header-cell">Item</th>
                            <th class="table-header-cell">Color</th>
                            <th class="table-header-cell">Order Qty</th>
                            <th class="table-header-cell">BOM Qty</th>
                            <th class="table-header-cell">Cut Qty</th>
                            <th class="table-header-cell">Bal To Cut</th>
                            <th class="table-header-cell">Pend %</th>
                            <th class="table-header-cell">Cutting</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-100 text-gray-700 text-xs"></tbody>
                </table>
            </div>
        </div>

        <!-- Cut Panel Table Card (hidden by default) -->
        <div class="bg-white p-4 rounded-lg shadow-md mt-20 hidden" id="cutpanelCardTableWrap">
            <div class="flex justify-between items-center mb-4">
                <div>
                    <h2 class="text-sm font-semibold text-gray-700 bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Cut Panel Details</h2>
                </div>
            </div>
            <div class="relative">
                <table class="min-w-full divide-y divide-gray-200" id="cutpanelTable">
                    <thead>
                        <tr>
                            <th class="table-header-cell">Unit</th>
                            <th class="table-header-cell">Buyer</th>
                            <th class="table-header-cell">OCN</th>
                            <th class="table-header-cell">Item</th>
                            <th class="table-header-cell">Color</th>
                            <th class="table-header-cell">OK Qty</th>
                            <th class="table-header-cell">Rej Qty</th>
                            <th class="table-header-cell">Rej Wt</th>
                            <th class="table-header-cell">Rej %</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-100 text-gray-700 text-xs"></tbody>
                </table>
            </div>
        </div>
	</div>
</div>    

<script>

    // Icons now use Font Awesome; no initialization required
    let unitChart, trendChart, attributeChart;
    let unitLevel = "units";
    let unitPath = [];
    let buyerLevel = "buyers";
    let buyerPath = [];
    let selectedRangeLabel = 'Last Week';
	let selectedfromdate = null;
	let selectedenddate = null;
    let apiData = {};
    let apiUnits = {};
    let apiBalance = {};
    let apiCutPanel = {};
    let cuttingOutput = {};
    let balanceOutput = {};
    let cutPanelOutput = {};
    let globalDates = [];
    let globalBuyerLabels = [];
    let dataTable;
    let activeCell = null; // Track the currently highlighted cell
	let kpiCharts = {};
    let kpiActiveTab = {};
    let activeDataset = 'cutting';
    let balanceUnitFilter = null;
    let balanceBuyerFilter = null;
    let balanceTotal = 0; // API-provided total for balance cutting output
    let cutPanelUnitFilter = null;
    let cutPanelBuyerFilter = null;
    
    function processApiData() {
        cuttingOutput = {
            units: { labels: [], values: [], machines: {} },
            buyers: { labels: [], values: [], ocns: {} },
            trend: [],
            logs: []
        };
        balanceOutput = { units: { labels: [], values: [], buyers: {} }, buyers: { labels: [], values: [], units: {} }, logs: [] };
        cutPanelOutput = { units: { labels: [], values: [], buyers: {} }, buyers: { labels: [], values: [], units: {} }, logs: [] };
        if (!apiUnits || typeof apiUnits !== 'object' || Object.keys(apiUnits).length === 0) {
            console.warn("Invalid or empty units; proceeding to process balance data if available");
            globalDates = [];
            globalBuyerLabels = [];
            // Do not return; allow balance data to be processed below
        }
        let allLogs = [];
        Object.values(apiUnits).forEach(unit => {
            if (unit && unit.machines && typeof unit.machines === 'object') {
                Object.values(unit.machines).forEach(machine => {
                    if (machine && Array.isArray(machine.data)) {
                        allLogs.push(...machine.data);
                    }
                });
            }
        });
        globalDates = [...new Set(allLogs.map(l => l.Edate).filter(Boolean))].sort();
        let buyersMap = allLogs.reduce((acc, log) => {
            if (!log || !log.Buyer || !log.Order_No) return acc;
            if (!acc[log.Buyer]) acc[log.Buyer] = { sum: 0, ocns: {}, logs: [] };
            acc[log.Buyer].sum += parseInt(log.Cut_Qty || 0);
            acc[log.Buyer].logs.push(log);
            if (!acc[log.Buyer].ocns[log.Order_No]) acc[log.Buyer].ocns[log.Order_No] = { sum: 0, logs: [], units: {}, trend: [] };
            acc[log.Buyer].ocns[log.Order_No].sum += parseInt(log.Cut_Qty || 0);
            acc[log.Buyer].ocns[log.Order_No].logs.push(log);
            return acc;
        }, {});
        globalBuyerLabels = Object.keys(buyersMap).sort();
        cuttingOutput.buyers = {
            labels: globalBuyerLabels,
            values: globalBuyerLabels.map(b => buyersMap[b]?.sum || 0),
            ocns: globalBuyerLabels.reduce((acc, b) => {
                let ocnMap = buyersMap[b]?.ocns || {};
                acc[b] = {
                    labels: Object.keys(ocnMap),
                    values: Object.values(ocnMap).map(o => o.sum || 0),
                    logs: buyersMap[b]?.logs || []
                };
                Object.keys(ocnMap).forEach(ocn => {
                    let ocnLogs = ocnMap[ocn].logs || [];
                    let ocnUnitSums = {};
                    cuttingOutput.units.labels.forEach(u => ocnUnitSums[u] = 0);
                    ocnLogs.forEach(log => {
                        if (log.Unit) ocnUnitSums[log.Unit] += parseInt(log.Cut_Qty || 0);
                    });
                    acc[b][ocn] = {
                        logs: ocnLogs,
                        units: cuttingOutput.units.labels.map(u => ocnUnitSums[u] || 0),
                        trend: globalDates.map(d => ocnLogs.filter(l => l.Edate === d).reduce((s, l) => s + parseInt(l.Cut_Qty || 0), 0))
                    };
                });
                return acc;
            }, {})
        };
        cuttingOutput.trend = globalDates.map(d => allLogs.filter(l => l.Edate === d).reduce((s, l) => s + parseInt(l.Cut_Qty || 0), 0));
        cuttingOutput.logs = allLogs;
        Object.keys(apiUnits).forEach(unitName => {
            const unit = apiUnits[unitName];
            if (!unit || !unit.Cut_Qty_Sum || !unit.machines) return;
            cuttingOutput.units.labels.push(unitName);
            cuttingOutput.units.values.push(unit.Cut_Qty_Sum);
            cuttingOutput.units.machines[unitName] = { labels: [], values: [], buyers: [], trend: [], logs: [], machineData: {} };
            let unitLogs = [];
            Object.keys(unit.machines).forEach(machineName => {
                const machine = unit.machines[machineName];
                if (!machine || !machine.data || !Array.isArray(machine.data)) return;
                cuttingOutput.units.machines[unitName].labels.push(machineName);
                cuttingOutput.units.machines[unitName].values.push(machine.Cut_Qty_Sum || 0);
                cuttingOutput.units.machines[unitName].machineData[machineName] = { logs: machine.data };
                unitLogs.push(...machine.data);
            });
            let unitBuyersMap = unitLogs.reduce((acc, log) => {
                if (!log || !log.Buyer) return acc;
                if (!acc[log.Buyer]) acc[log.Buyer] = { sum: 0 };
                acc[log.Buyer].sum += parseInt(log.Cut_Qty || 0);
                return acc;
            }, {});
            cuttingOutput.units.machines[unitName].buyers = globalBuyerLabels.map(b => unitBuyersMap[b]?.sum || 0);
            cuttingOutput.units.machines[unitName].trend = globalDates.map(d => unitLogs.filter(l => l.Edate === d).reduce((s, l) => s + parseInt(l.Cut_Qty || 0), 0));
            cuttingOutput.units.machines[unitName].logs = unitLogs;
            Object.keys(unit.machines).forEach(machineName => {
                let machineLogs = unit.machines[machineName]?.data || [];
                let machineBuyersMap = machineLogs.reduce((acc, log) => {
                    if (!log || !log.Buyer) return acc;
                    if (!acc[log.Buyer]) acc[log.Buyer] = { sum: 0 };
                    acc[log.Buyer].sum += parseInt(log.Cut_Qty || 0);
                    return acc;
                }, {});
                cuttingOutput.units.machines[unitName].machineData[machineName].buyers = globalBuyerLabels.map(b => machineBuyersMap[b]?.sum || 0);
                cuttingOutput.units.machines[unitName].machineData[machineName].trend = globalDates.map(d => machineLogs.filter(l => l.Edate === d).reduce((s, l) => s + parseInt(l.Cut_Qty || 0), 0));
            });
        });
        // Balance dataset
        if (apiBalance && typeof apiBalance === 'object' && Object.keys(apiBalance).length) {
            const balUnits = apiBalance;
            let buyerTotals = {};
            Object.keys(balUnits).forEach(unitName => {
                const unit = balUnits[unitName];
                balanceOutput.units.labels.push(unitName);
                // compute unit sum: prefer Balance_Qty_Sum, fallback to sum of buyers or rows' Bal_To_Cut
                let unitSum = parseInt(unit.Balance_Qty_Sum || 0) || 0;
                let unitBuyerSums = {};
                let rowsForUnit = 0;
                if (unit.buyers && typeof unit.buyers === 'object') {
                    Object.keys(unit.buyers).forEach(buyer => {
                        const b = unit.buyers[buyer];
                        const sum = parseInt(b.Balance_Qty_Sum || 0) || 0;
                        unitBuyerSums[buyer] = (unitBuyerSums[buyer] || 0) + sum;
                        buyerTotals[buyer] = (buyerTotals[buyer] || 0) + sum;
                        const rows = Array.isArray(b.data) ? b.data : [];
                        if (rows.length && sum === 0) {
                            // derive sum from rows
                            const derived = rows.reduce((s, r) => s + (parseInt(r.Bal_To_Cut || 0) || 0), 0);
                            unitBuyerSums[buyer] += derived;
                            buyerTotals[buyer] += derived;
                            unitSum += derived;
                        }
                        rows.forEach(r => {
                            balanceOutput.logs.push({
                                Buyer: r.Buyer || buyer,
                                OCN: r.OCN || '',
                                Item: r.Item || '',
                                Color: r.Color || '',
                                Order_Qty: r.Order_Qty || 0,
                                Bom_Qty: r.Bom_Qty || 0,
                                Cut_Qty: r.Cut_Qty || 0,
                                Bal_To_Cut: r.Bal_To_Cut || 0,
                                Unit: r.Unit || unitName,
                                Pend_Perc: r.Pend_Perc || 0
                            });
                        });
                        rowsForUnit += rows.length;
                    });
                }
                if (unitSum === 0 && rowsForUnit === 0 && Object.keys(unitBuyerSums).length) {
                    // if only buyer sums exist, sum them
                    unitSum = Object.values(unitBuyerSums).reduce((s, v) => s + (v || 0), 0);
                }
                balanceOutput.units.values.push(unitSum);
                // Build unit-level buyer sums
                balanceOutput.units.buyers[unitName] = unitBuyerSums;
            });
            const buyerLabels = Object.keys(buyerTotals).sort();
            balanceOutput.buyers.labels = buyerLabels;
            // If buyerTotals are zero but we have logs, derive from logs
            let values = buyerLabels.map(b => buyerTotals[b] || 0);
            if (values.every(v => v === 0) && balanceOutput.logs.length) {
                const derivedMap = {};
                balanceOutput.logs.forEach(r => { derivedMap[r.Buyer] = (derivedMap[r.Buyer] || 0) + (parseInt(r.Bal_To_Cut || 0) || 0); });
                values = buyerLabels.map(b => derivedMap[b] || 0);
            }
            balanceOutput.buyers.values = values;
            // units per buyer reverse map
            buyerLabels.forEach(buyer => {
                balanceOutput.buyers.units[buyer] = balanceOutput.units.labels.map(u => (balanceOutput.units.buyers[u]?.[buyer] || 0));
            });
        }
        // Cut Panel dataset
        if (apiCutPanel && typeof apiCutPanel === 'object' && Object.keys(apiCutPanel).length) {
            const cpUnits = apiCutPanel; // structure: Unit -> Buyer -> [rows]
            const buyerTotals = {};
            Object.keys(cpUnits).forEach(unitName => {
                const buyersObj = cpUnits[unitName] || {};
                // ensure unit exists in labels once
                cutPanelOutput.units.labels.push(unitName);
                let unitSum = 0;
                let unitBuyerSums = {};
                Object.keys(buyersObj).forEach(buyer => {
                    const rows = Array.isArray(buyersObj[buyer]) ? buyersObj[buyer] : [];
                    const okSum = rows.reduce((s, r) => s + (parseInt(String(r.Ok_Qty || r.OK_Qty || '0').replace(/,/g, '')) || 0), 0);
                    unitBuyerSums[buyer] = (unitBuyerSums[buyer] || 0) + okSum;
                    buyerTotals[buyer] = (buyerTotals[buyer] || 0) + okSum;
                    unitSum += okSum;
                    rows.forEach(r => {
                        cutPanelOutput.logs.push({
                            Unit: r.Unit || unitName,
                            Buyer: r.Buyer || buyer,
                            OCN: r.Order_No || '',
                            Item: r.Item || '',
                            Color: r.Color || '',
                            Ok_Qty: r.Ok_Qty || r.OK_Qty || 0,
                            Rej_Qty: r.Rej_Qty || 0,
                            Rej_Wt: r.Rej_Wt || 0,
                            Rej_Perc: r.Rej_Perc || 0
                        });
                    });
                });
                cutPanelOutput.units.values.push(unitSum);
                cutPanelOutput.units.buyers[unitName] = unitBuyerSums;
            });
            const buyerLabels = Object.keys(buyerTotals).sort();
            cutPanelOutput.buyers.labels = buyerLabels;
            cutPanelOutput.buyers.values = buyerLabels.map(b => buyerTotals[b] || 0);
            // build reverse map: buyer -> units array matching units.labels order
            buyerLabels.forEach(buyer => {
                cutPanelOutput.buyers.units[buyer] = cutPanelOutput.units.labels.map(u => (cutPanelOutput.units.buyers[u]?.[buyer] || 0));
            });
        }
    }
    function fetchData(unit_code = null, fromDate = "", toDate = "") {
        $("#loadSpinner").show();
        $.ajax({
            url: '/cuttingreport',
            method: 'GET',
            data: { unit_code: unit_code, fromdate: fromDate, enddate: toDate,empid: "{{ Session('empl_id') }}"  },
            success: function(response) {
                $("#loadSpinner").hide();
                if (response && response.success) {
                    apiData = response;
                    apiUnits = response.units || {};
                    apiBalance = response.balance_cut_unit || {};
                    apiCutPanel = response.cutpaneldetails_buyerwise || {};
                    balanceTotal = parseInt(String(response.Total_Balance_Qty_Sum ?? response.total_balance_qty_sum ?? 0).replace(/,/g, '')) || 0;
                    processApiData();
                    updateAllCharts();
                    updateTable(cuttingOutput.logs);
                    // Apply deep link filter (unit/buyer/ocn) if present in URL
                    try { applyDeepLinkFilterIfAny(); } catch (e) { console.warn('Filter apply failed', e); }
					updateAllKpis();
                    // Ensure balance KPI is populated on initial load even if its card is not active yet
                    const balanceCardInit = document.querySelector('.kpi-card[data-type="balancecuttingOutput"]');
                    if (balanceCardInit) updateKPIForCard(balanceCardInit);
                    // Ensure cut panel KPI is populated on initial load even if its card is not active yet
                    const cutPanelCardInit = document.querySelector('.kpi-card[data-type="cutpanelOutput"]');
                    if (cutPanelCardInit) updateKPIForCard(cutPanelCardInit);
                    updateUnitBreadcrumb();
                    updateBuyerBreadcrumb();
                } else {
                    console.warn("Invalid API response, resetting data");
                    apiData = {}; apiUnits = {}; apiBalance = {}; apiCutPanel = {}; balanceTotal = 0;
                    processApiData();
                    updateAllCharts();
                    updateTable([]);
					updateAllKpis();
                    const balanceCardInit = document.querySelector('.kpi-card[data-type="balancecuttingOutput"]');
                    if (balanceCardInit) updateKPIForCard(balanceCardInit);
                    const cutPanelCardInit = document.querySelector('.kpi-card[data-type="cutpanelOutput"]');
                    if (cutPanelCardInit) updateKPIForCard(cutPanelCardInit);
                    updateUnitBreadcrumb();
                    updateBuyerBreadcrumb();
                }
            },
            error: function() {
                $("#loadSpinner").hide();
                console.error("Error fetching data");
                apiData = {}; apiUnits = {}; apiBalance = {}; balanceTotal = 0;
                processApiData();
                updateAllCharts();
                updateTable([]);
				updateAllKpis();
                const balanceCardInit = document.querySelector('.kpi-card[data-type="balancecuttingOutput"]');
                if (balanceCardInit) updateKPIForCard(balanceCardInit);
                const cutPanelCardInit = document.querySelector('.kpi-card[data-type="cutpanelOutput"]');
                if (cutPanelCardInit) updateKPIForCard(cutPanelCardInit);
                updateUnitBreadcrumb();
                updateBuyerBreadcrumb();
            }
        });
    }
    function updateAllCharts() {
        if (activeDataset === 'balance') {
            // Base charts
            let uLabels = balanceOutput.units.labels.slice();
            let uValues = balanceOutput.units.values.slice();
            let aLabels = balanceOutput.buyers.labels.slice();
            let aValues = balanceOutput.buyers.values.slice();
            let uBg = uLabels.map(() => '#000080');
            let aBg = aLabels.map(() => '#000080');
            // If filtered by unit, show buyer breakdown for that unit
            if (balanceUnitFilter) {
                const buyersMap = balanceOutput.units.buyers[balanceUnitFilter] || {};
                aLabels = Object.keys(buyersMap);
                aValues = aLabels.map(b => buyersMap[b] || 0);
                uBg = uLabels.map(l => l === balanceUnitFilter ? '#1e3a8a' : '#d1d5db');
                // Reset buyer bars to blue for the filtered buyer list
                aBg = aLabels.map(() => '#000080');
            }
            // If filtered by buyer, show unit breakdown for that buyer
            if (balanceBuyerFilter) {
                const perUnits = balanceOutput.buyers.units[balanceBuyerFilter] || [];
                uValues = perUnits;
                aBg = aLabels.map(l => l === balanceBuyerFilter ? '#1e3a8a' : '#d1d5db');
            }
            unitChart.data.labels = uLabels;
            unitChart.data.datasets[0].data = uValues;
            unitChart.data.datasets[0].backgroundColor = uBg;
            unitChart.update();
            attributeChart.data.labels = aLabels;
            attributeChart.data.datasets[0].data = aValues;
            attributeChart.data.datasets[0].backgroundColor = aBg;
            attributeChart.update();
        } else if (activeDataset === 'cutpanel') {
            // Base charts for Cut Panel (Ok Qty sums)
            let uLabels = cutPanelOutput.units.labels.slice();
            let uValues = cutPanelOutput.units.values.slice();
            let aLabels = cutPanelOutput.buyers.labels.slice();
            let aValues = cutPanelOutput.buyers.values.slice();
            let uBg = uLabels.map(() => '#000080');
            let aBg = aLabels.map(() => '#000080');
            if (cutPanelUnitFilter) {
                const buyersMap = cutPanelOutput.units.buyers[cutPanelUnitFilter] || {};
                aLabels = Object.keys(buyersMap);
                aValues = aLabels.map(b => buyersMap[b] || 0);
                uBg = uLabels.map(l => l === cutPanelUnitFilter ? '#1e3a8a' : '#d1d5db');
                aBg = aLabels.map(() => '#000080');
            }
            if (cutPanelBuyerFilter) {
                const perUnits = cutPanelOutput.buyers.units[cutPanelBuyerFilter] || [];
                uValues = perUnits;
                aBg = aLabels.map(l => l === cutPanelBuyerFilter ? '#1e3a8a' : '#d1d5db');
            }
            unitChart.data.labels = uLabels;
            unitChart.data.datasets[0].data = uValues;
            unitChart.data.datasets[0].backgroundColor = uBg;
            unitChart.update();
            attributeChart.data.labels = aLabels;
            attributeChart.data.datasets[0].data = aValues;
            attributeChart.data.datasets[0].backgroundColor = aBg;
            attributeChart.update();
        } else {
            trendChart.data.labels = globalDates;
            trendChart.data.datasets[0].data = cuttingOutput.trend;
            trendChart.update();
            unitChart.data.labels = cuttingOutput.units.labels;
            unitChart.data.datasets[0].data = cuttingOutput.units.values;
            // Reset unit bars to default navy when returning to top-level cutting
            unitChart.data.datasets[0].backgroundColor = unitChart.data.labels.map(() => '#000080');
            unitChart.update();
            attributeChart.data.labels = cuttingOutput.buyers.labels;
            attributeChart.data.datasets[0].data = cuttingOutput.buyers.values;
            // Reset attribute bars to default navy when returning to top-level cutting
            attributeChart.data.datasets[0].backgroundColor = attributeChart.data.labels.map(() => '#000080');
            attributeChart.update();
        }
    }

    // Deep link: apply buyer/ocn/unit filters from URL to charts and table
    function applyDeepLinkFilterIfAny() {
        const params = new URLSearchParams(window.location.search);
        const buyer = (params.get('buyer') || '').trim();
        const ocn = (params.get('ocn') || '').trim();
        const unit = (params.get('unit') || '').trim();
        if (!buyer && !ocn && !unit) return;

        // Configure buyer drilldown
        if (buyer && ocn) {
            buyerLevel = 'ocn';
            buyerPath = [buyer, ocn];
            updateBuyerChart('ocn', buyer, ocn);
        } else if (buyer) {
            buyerLevel = 'ocns';
            buyerPath = [buyer];
            updateBuyerChart('ocns', buyer);
        }

        // Configure unit context: drill to machines level for specified unit
        if (unit) {
            unitLevel = 'machines';
            unitPath = [unit];
            updateUnitChart('machines', unit);
        }

        // Sync visuals and breadcrumbs (may set unfiltered machine values)
        syncChartsAndUpdateAll();

        // If unit is specified, recompute machine totals filtered by buyer/ocn and update the chart
        if (unit) {
            const unitData = cuttingOutput.units.machines[unit] || {};
            const labels = (unitData.labels || []).slice();
            const machineData = unitData.machineData || {};
            const sums = labels.reduce((acc, m) => { acc[m] = 0; return acc; }, {});
            labels.forEach(m => {
                const logs = (machineData[m]?.logs || []).filter(l => {
                    if (buyer && String(l.Buyer || '').trim() !== buyer) return false;
                    const lOcn = String(l.Order_No || l.OCN || '').trim();
                    if (ocn && lOcn !== ocn) return false;
                    return true;
                });
                sums[m] = logs.reduce((s, l) => s + (parseInt(l.Cut_Qty || 0)), 0);
            });
            unitChart.data.labels = labels;
            unitChart.data.datasets[0].data = labels.map(m => sums[m] || 0);
            unitChart.data.datasets[0].backgroundColor = labels.map(() => '#000080');
            unitChart.update();
        }
        updateUnitBreadcrumb();
        updateBuyerBreadcrumb();

        // Filter Cutting Details table rows
        const filtered = (cuttingOutput.logs || []).filter(l => {
            if (buyer && String(l.Buyer || '').trim() !== buyer) return false;
            const lOcn = String(l.Order_No || l.OCN || '').trim();
            if (ocn && lOcn !== ocn) return false;
            if (unit && String(l.Unit || '').trim() !== unit) return false;
            return true;
        });
        if (filtered.length) updateTable(filtered);
    }
    function updateKPIForCard(cardEl, type) {
        const $card = $(cardEl);
        const cardType = $card.data('type');
        let value = 0;
        if (cardType === 'balancecuttingOutput') {
            // Dynamically compute total from balance table (Bal_To_Cut column) over filtered rows
            try {
                if ($.fn.dataTable.isDataTable('#balanceTable') && dataTable) {
                    const rows = dataTable.rows({ filter: 'applied' }).data().toArray();
                    value = rows.reduce((sum, r) => {
                        const raw = (r[8] ?? '0').toString().replace(/,/g, '').trim();
                        const num = parseFloat(raw) || 0;
                        return sum + num;
                    }, 0);
                } else {
                    // Fallback: compute from balance logs with current filters
                    let logs = balanceOutput.logs || [];
                    if (balanceUnitFilter) logs = logs.filter(x => (x.Unit || '') === balanceUnitFilter);
                    if (balanceBuyerFilter) logs = logs.filter(x => (x.Buyer || '') === balanceBuyerFilter);
                    value = logs.reduce((s, x) => s + (parseFloat(String(x.Bal_To_Cut || '0').replace(/,/g, '')) || 0), 0);
                }
            } catch (e) {
                value = 0;
            }
            $card.find('[data-role="value"]').text(Number(value).toLocaleString());
            return;
        } else if (cardType === 'cutpanelOutput') {
            // Determine metric: 'checked' | 'rej' | 'rejperc'
            const domActive = $card.find('.tab-option.active').data('type');
            const remembered = kpiActiveTab['cutpanelOutput'];
            const metric = (type || domActive || remembered || 'checked');
            let sumOk = 0, sumRej = 0;
            try {
                if ($.fn.dataTable.isDataTable('#cutpanelTable') && dataTable) {
                    const rows = dataTable.rows({ filter: 'applied' }).data().toArray();
                    rows.forEach(r => {
                        const okRaw = (r[5] ?? '0').toString().replace(/,/g, '').trim();
                        const rejRaw = (r[6] ?? '0').toString().replace(/,/g, '').trim();
                        const okNum = parseFloat(okRaw) || 0;
                        const rejNum = parseFloat(rejRaw) || 0;
                        sumOk += okNum; sumRej += rejNum;
                    });
                } else {
                    let logs = cutPanelOutput.logs || [];
                    if (cutPanelUnitFilter) logs = logs.filter(x => (x.Unit || '') === cutPanelUnitFilter);
                    if (cutPanelBuyerFilter) logs = logs.filter(x => (x.Buyer || '') === cutPanelBuyerFilter);
                    logs.forEach(x => {
                        const okNum = parseFloat(String(x.Ok_Qty || x.OK_Qty || '0').replace(/,/g, '')) || 0;
                        const rejNum = parseFloat(String(x.Rej_Qty || '0').replace(/,/g, '')) || 0;
                        sumOk += okNum; sumRej += rejNum;
                    });
                }
            } catch (e) { sumOk = 0; sumRej = 0; }
            if (metric === 'checked') {
                value = sumOk + sumRej;
                $card.find('[data-role="value"]').text(Number(value).toLocaleString());
            } else if (metric === 'rej') {
                value = sumRej;
                $card.find('[data-role="value"]').text(Number(value).toLocaleString());
            } else {
                // rejperc
                const perc = sumOk > 0 ? (sumRej / sumOk) * 100 : 0;
                $card.find('[data-role="value"]').text(`${perc.toFixed(2)}%`);
            }
            return;
        }
        // Cutting KPI card uses rows from cutting table
        let logs = [];
        if (dataTable && $('#cuttingTable').length && $.fn.dataTable.isDataTable('#cuttingTable')) {
            logs = dataTable.rows({ filter: 'applied' }).data().toArray().map(row => ({
                Cut_Qty: row[10].match(/>\s*([\d,]+)\s*</)?.[1].replace(/,/g, '') || '0',
                Lay_ID: row[1],
                Fabric_Wt: row[7].replace(/,/g, '') || '0'
            }));
        }
        if (type === 'pieces') {
            value = logs.reduce((sum, row) => sum + parseInt(row.Cut_Qty || 0), 0);
        } else if (type === 'lay') {
            value = new Set(logs.map(row => row.Lay_ID)).size;
        } else if (type === 'fabric') {
            value = logs.reduce((sum, row) => sum + parseFloat(row.Fabric_Wt || 0), 0);
        }
        $card.find('[data-role="value"]').text(value.toLocaleString());
        $card.find('[data-role="change"]').html(`<span class="${kpiData[type].change.startsWith('-') ? 'text-red-500' : 'text-green-500'} font-semibold">${kpiData[type].change}</span> <span class="text-gray-500">vs yesterday</span>`);
        $card.find('[data-role="target"]').text(`Target: ${kpiData[type].target}`);
        const chart = kpiCharts[cardType];
        if (chart) {
            chart.data.datasets[0].data = kpiData[type].chart;
            chart.update();
        }
    }

    function updateAllKpis() {
        if (activeDataset === 'balance') {
            // Update ONLY balance KPI
            const balanceCard = document.querySelector('.kpi-card[data-type="balancecuttingOutput"]');
            if (balanceCard) updateKPIForCard(balanceCard);
            return;
        } else if (activeDataset === 'cutpanel') {
            const cutPanelCard = document.querySelector('.kpi-card[data-type="cutpanelOutput"]');
            if (cutPanelCard) {
                const domActive = $(cutPanelCard).find('.tab-option.active').data('type');
                const remembered = kpiActiveTab['cutpanelOutput'];
                const metric = domActive || remembered || 'checked';
                updateKPIForCard(cutPanelCard, metric);
            }
            return;
        }
        // Update ONLY cutting KPI
        const cuttingCard = document.querySelector('.kpi-card[data-type="cuttingOutput"]');
        if (cuttingCard) {
            const domActive = $(cuttingCard).find('.tab-option.active').data('type');
            const remembered = kpiActiveTab['cuttingOutput'];
            const metric = domActive || remembered || 'pieces';
            updateKPIForCard(cuttingCard, metric);
        }
    }
    
    function updateUnitChart(level, unit, selectedMachine = null) {
        let labels, values;
        if (level === "units" && activeDataset === 'cutting') {
            labels = cuttingOutput.units.labels;
            values = cuttingOutput.units.values;
        } else if ((level === "machines" || level === "machine") && activeDataset === 'cutting') {
            labels = cuttingOutput.units.machines[unit]?.labels || [];
            values = cuttingOutput.units.machines[unit]?.values || [];
        } else if (activeDataset === 'balance') {
            labels = balanceOutput.units.labels;
            values = balanceOutput.units.values;
        } else if (activeDataset === 'cutpanel') {
            labels = cutPanelOutput.units.labels;
            values = cutPanelOutput.units.values;
        }
        unitChart.data.labels = labels;
        unitChart.data.datasets[0].data = values;
        if (selectedMachine && level === "machine") {
            unitChart.data.datasets[0].backgroundColor = labels.map(l => l === selectedMachine ? '#1e3a8a' : '#d1d5db');
        } else {
            unitChart.data.datasets[0].backgroundColor = labels.map(() => '#000080');
        }
        unitChart.update();
    }
    function updateBuyerChart(level, buyer, selectedOCN = null) {
        let labels, values;
        if (level === "buyers" && activeDataset === 'cutting') {
            labels = cuttingOutput.buyers.labels;
            values = cuttingOutput.buyers.values;
        } else if ((level === "ocns" || level === "ocn") && activeDataset === 'cutting') {
            labels = cuttingOutput.buyers.ocns[buyer]?.labels || [];
            values = cuttingOutput.buyers.ocns[buyer]?.values || [];
        } else if (activeDataset === 'balance') {
            labels = balanceOutput.buyers.labels;
            values = balanceOutput.buyers.values;
        } else if (activeDataset === 'cutpanel') {
            labels = cutPanelOutput.buyers.labels;
            values = cutPanelOutput.buyers.values;
        }
        attributeChart.data.labels = labels;
        attributeChart.data.datasets[0].data = values;
        // Always use navy blue for all bars at All Buyers stage and when drilling back
        if (level === "buyers" || level === "ocns" || activeDataset === 'balance') {
            attributeChart.data.datasets[0].backgroundColor = labels.map(() => '#000080');
        } else if (selectedOCN && level === "ocn") {
            attributeChart.data.datasets[0].backgroundColor = labels.map(l => l === selectedOCN ? '#1e3a8a' : '#000080');
        } else {
            attributeChart.data.datasets[0].backgroundColor = labels.map(() => '#000080');
        }
        attributeChart.update();
    }
    function applyBalanceFiltersAndUpdate() {
        // Charts
        updateAllCharts();
        // Table logs filtering
        let logs = balanceOutput.logs || [];
        if (balanceUnitFilter) {
            logs = logs.filter(r => (r.Unit || '') === balanceUnitFilter);
        }
        if (balanceBuyerFilter) {
            logs = logs.filter(r => (r.Buyer || '') === balanceBuyerFilter);
        }
        updateBalanceTable(logs);
        updateAllKpis();
        updateUnitBreadcrumb();
        updateBuyerBreadcrumb();
    }
    function applyCutPanelFiltersAndUpdate() {
        // Charts
        updateAllCharts();
        // Table logs filtering
        let logs = cutPanelOutput.logs || [];
        if (cutPanelUnitFilter) {
            logs = logs.filter(r => (r.Unit || '') === cutPanelUnitFilter);
        }
        if (cutPanelBuyerFilter) {
            logs = logs.filter(r => (r.Buyer || '') === cutPanelBuyerFilter);
        }
        updateCutPanelTable(logs);
        updateAllKpis();
        updateUnitBreadcrumb();
        updateBuyerBreadcrumb();
    }
    function updateUnitBreadcrumb() {
        let breadcrumbHtml = '<span id="allUnits" class="cursor-pointer hover:underline">All Units</span>';
        if (activeDataset === 'balance') {
            if (balanceUnitFilter) {
                breadcrumbHtml += ` > <span id="unitName" class="cursor-pointer hover:underline " data-unit="${balanceUnitFilter}">${balanceUnitFilter}</span>`;
            }
        } else if (activeDataset === 'cutpanel') {
            if (cutPanelUnitFilter) {
                breadcrumbHtml += ` > <span id=\"unitName\" class=\"cursor-pointer hover:underline \" data-unit=\"${cutPanelUnitFilter}\">${cutPanelUnitFilter}</span>`;
            }
        } else {
            if (unitLevel === "machines" && unitPath.length > 0) {
                breadcrumbHtml += ` > <span id="unitName" class="cursor-pointer hover:underline " data-unit="${unitPath[0]}">${unitPath[0]}</span>`;
            } else if (unitLevel === "machine" && unitPath.length > 1) {
                breadcrumbHtml += ` > <span id="unitName" class="cursor-pointer hover:underline " data-unit="${unitPath[0]}">${unitPath[0]}</span>`;
                breadcrumbHtml += ` > <span id="machineName" class="cursor-pointer hover:underline " data-unit="${unitPath[0]}" data-machine="${unitPath[1]}">${unitPath[1]}</span>`;
            }
        }
        $("#unitBreadcrumbPieces").html(breadcrumbHtml);
    }
    function updateBuyerBreadcrumb() {
        let breadcrumbHtml = '<span id="allBuyers" class="cursor-pointer hover:underline ">All Buyer</span>';
        if (activeDataset === 'balance') {
            if (balanceBuyerFilter) {
                breadcrumbHtml += ` > <span id="buyerName" class="cursor-pointer hover:underline " data-buyer="${balanceBuyerFilter}">${balanceBuyerFilter}</span>`;
            }
        } else if (activeDataset === 'cutpanel') {
            if (cutPanelBuyerFilter) {
                breadcrumbHtml += ` > <span id=\"buyerName\" class=\"cursor-pointer hover:underline \" data-buyer=\"${cutPanelBuyerFilter}\">${cutPanelBuyerFilter}</span>`;
            }
        } else {
            if (buyerLevel === "ocns" && buyerPath.length > 0) {
                breadcrumbHtml += ` > <span id="buyerName" class="cursor-pointer hover:underline " data-buyer="${buyerPath[0]}">${buyerPath[0]}</span>`;
            } else if (buyerLevel === "ocn" && buyerPath.length > 1) {
                breadcrumbHtml += ` > <span id="buyerName" class="cursor-pointer hover:underline " data-buyer="${buyerPath[0]}">${buyerPath[0]}</span>`;
                breadcrumbHtml += ` > <span id="ocnName" class="cursor-pointer hover:underline " data-buyer="${buyerPath[0]}" data-ocn="${buyerPath[1]}">${buyerPath[1]}</span>`;
            }
        }
        $("#buyerBreadcrumb").html(breadcrumbHtml);
    }
    function resetBothChartsToTop() {
        if (activeDataset === 'balance') {
            // Clear balance filters and refresh everything
            balanceUnitFilter = null;
            balanceBuyerFilter = null;
            updateAllCharts();
            updateBalanceTable(balanceOutput.logs);
            updateAllKpis();
            updateUnitBreadcrumb();
            updateBuyerBreadcrumb();
            return;
        } else if (activeDataset === 'cutpanel') {
            cutPanelUnitFilter = null;
            cutPanelBuyerFilter = null;
            updateAllCharts();
            updateCutPanelTable(cutPanelOutput.logs);
            updateAllKpis();
            updateUnitBreadcrumb();
            updateBuyerBreadcrumb();
            return;
        }
        unitLevel = "units";
        unitPath = [];
        updateUnitChart("units");
        // Reset attribute chart to show all buyers
        buyerLevel = "buyers";
        buyerPath = [];
        updateBuyerChart("buyers");
        attributeChart.data.labels = cuttingOutput.buyers.labels;
        attributeChart.data.datasets[0].data = cuttingOutput.buyers.values;
        attributeChart.data.datasets[0].backgroundColor = attributeChart.data.labels.map(() => '#000080');
        attributeChart.update();
        trendChart.data.datasets[0].data = cuttingOutput.trend;
        trendChart.update();
        updateTable(cuttingOutput.logs);
        updateAllKpis();
        updateUnitBreadcrumb();
        updateBuyerBreadcrumb();
    }
    function syncChartsAndUpdateAll() {
        const filterUnit = unitPath[0];
        const filterMachine = unitPath[1];
        const filterBuyer = buyerPath[0];
        const filterOCN = buyerPath[1];
        if (unitLevel === "units") {
            unitChart.data.labels = cuttingOutput.units.labels;
            unitChart.data.datasets[0].data = cuttingOutput.units.values;
            unitChart.data.datasets[0].backgroundColor = unitChart.data.labels.map(() => '#000080');
        } else if (unitLevel === "machines") {
            const unitData = cuttingOutput.units.machines[filterUnit];
            if (unitData) {
                unitChart.data.labels = unitData.labels;
                unitChart.data.datasets[0].data = unitData.values;
                unitChart.data.datasets[0].backgroundColor = unitChart.data.labels.map(() => '#000080');
            }
        } else if (unitLevel === "machine") {
            const unitData = cuttingOutput.units.machines[filterUnit];
            if (unitData) {
                unitChart.data.labels = unitData.labels;
                unitChart.data.datasets[0].data = unitData.values;
                unitChart.data.datasets[0].backgroundColor = unitData.labels.map(l => l === filterMachine ? '#1e3a8a' : '#d1d5db');
            }
        }
        unitChart.update();
        if (buyerLevel === "buyers") {
            attributeChart.data.labels = cuttingOutput.buyers.labels;
            attributeChart.data.datasets[0].data = cuttingOutput.buyers.values;
            attributeChart.data.datasets[0].backgroundColor = attributeChart.data.labels.map(() => '#000080');
        } else if (buyerLevel === "ocns") {
            const buyerData = cuttingOutput.buyers.ocns[filterBuyer];
            if (buyerData) {
                attributeChart.data.labels = buyerData.labels;
                attributeChart.data.datasets[0].data = buyerData.values;
                attributeChart.data.datasets[0].backgroundColor = attributeChart.data.labels.map(() => '#000080');
            }
        } else if (buyerLevel === "ocn") {
            const buyerData = cuttingOutput.buyers.ocns[filterBuyer];
            //clickcolorchange
            if (buyerData) {
                attributeChart.data.labels = buyerData.labels;
                attributeChart.data.datasets[0].data = buyerData.values;
                attributeChart.data.datasets[0].backgroundColor = buyerData.labels.map(l => l === filterOCN ? '#1e3a8a' : '#000080');
            }
        }
        attributeChart.update();
        let currentLogs = cuttingOutput.logs;
        let trendData = cuttingOutput.trend;
        if (unitLevel === "machine" && filterUnit && filterMachine) {
            currentLogs = cuttingOutput.units.machines[filterUnit]?.machineData[filterMachine]?.logs || [];
            trendData = cuttingOutput.units.machines[filterUnit]?.machineData[filterMachine]?.trend || [];
        } else if (buyerLevel === "ocn" && filterBuyer && filterOCN) {
            currentLogs = cuttingOutput.buyers.ocns[filterBuyer]?.[filterOCN]?.logs || [];
            trendData = cuttingOutput.buyers.ocns[filterBuyer]?.[filterOCN]?.trend || [];
        }
        trendChart.data.datasets[0].data = trendData;
        trendChart.update();
        if (activeDataset === 'balance') {
            updateBalanceTable(balanceOutput.logs);
        } else if (activeDataset === 'cutpanel') {
            updateCutPanelTable(cutPanelOutput.logs);
        } else {
            updateTable(currentLogs);
        }
		updateAllKpis();
        updateUnitBreadcrumb();
        updateBuyerBreadcrumb();
    }

    function updateTable(logs) {
        if (dataTable) {
            dataTable.clear().destroy();
            $("#cuttingTable tbody").empty();
        }
        const totalCuttingOutput = logs.reduce((sum, row) => sum + parseInt(row.Cut_Qty || 0), 0);
        
        const tableData = logs.map((row, idx) => {
            const formattedDate = row.Edate ? moment(row.Edate).format('DD-MM-YY') : '-';
            return [
                formattedDate,
                row.Lay_ID || '-',
                `${row.Unit || '-'} / ${row.Machine_type || '-'}`,
                row.Buyer || '-',
                `${row.Order_No ? row.Order_No.slice(-4) : ' '} / ${row.Garment || '-'} / ${row.Color || '-'}`,
                `<span class="rolls-used-cell font-bold text-bar-main cursor-pointer"
                    data-roll-no="${row.Roll_No || ''}"
                    data-rpoints="${row.R_Points || row.Rpoints || ''}"
                    data-supplier="${row.Supplier || ''}"
                    data-shade="${row.Shade || ''}"
                    data-layid="${row.Master_Id ?? ''}"
                    data-relax="${row.Relax_hrs || row.Relax || ''}">
                    ${row.Rolls_Used || '-'}
                </span>`,
                row.Gsm || '-',
                row.Fabric_Wt || '-',
                row.End_Bit || '-',
                row.Cut_Time || '-',
                `<span class="cut-qty-cell font-bold text-bar-main cursor-pointer"
                    data-layid="${row.Master_Id ?? ''}">
                    ${row.Cut_Qty || '-'}
                </span>`,
                `<span class="ack-pcs-cell font-bold text-bar-main cursor-pointer"
                   data-layid="${row.Master_Id ?? ''}">
                    ${row.Ack_Pcs || '-'}
                </span>`,
                `<span class="issd-cell font-bold text-bar-main cursor-pointer"
                    data-layid="${row.Master_Id ?? ''}"
                    data-breakdown='${(row.Issd_Breakdown || row.Issued_Breakdown || []).length ? JSON.stringify(row.Issd_Breakdown || row.Issued_Breakdown) : ''}'>
                    ${row.Issd || '-'}
                </span>`,
                `<span class="line-qty-cell font-bold text-bar-main cursor-pointer"
                    data-layid="${row.Master_Id ?? ''}"
                    data-breakdown='${(row.Line_Breakdown || row.Line_Size_Breakdown || []).length ? JSON.stringify(row.Line_Breakdown || row.Line_Size_Breakdown) : ''}'>
                    ${row.Line_Qty || '-'}
                </span>`
            ];
        });
        dataTable = $("#cuttingTable").DataTable({
            data: tableData,
            columns: [
                { title: "Date" },
                { title: "Lay ID" },
                { title: "Unit / Shift / Machine" },
                { title: "Buyer" },
                { title: "OCN / Style / Color" },
                { title: "Rolls Used" },
                { title: "GSM" },
                { title: "Fabric Wt. (kg)" },
                { title: "End Bit" },
                { title: "Cutting Time (min)" },
                { title: "Cutting Output" },
                { title: "Ack. pend" },
                { title: "SM Received" },
                { title: "Line Qty" }
            ],
            language: {
                lengthMenu: 'Show _MENU_ rows',
                search: 'Search:'
            },
            pageLength: 10,
            lengthMenu: [10, 25, 50, 100],
            searching: true,
            ordering: true,
            destroy: true,
            drawCallback: function() {
                bindPopperEvents();
				updateAllKpis();
            }
        });
        dataTable.on('length.dt', function(e, settings, len) {
            const container = document.getElementById('cuttingTableContainer');
            const thead = document.querySelector('#cuttingTable thead');
            if (!container || !thead) return;
            if (len > 10) {
                container.style.maxHeight = '520px';
                container.style.overflowY = 'auto';
                thead.style.position = 'sticky';
                thead.style.top = '0';
                thead.style.zIndex = '10';
                thead.style.background = '#ffffff';
            } else {
                container.style.maxHeight = '';
                container.style.overflowY = '';
                thead.style.position = '';
                thead.style.top = '';
                thead.style.zIndex = '';
                thead.style.background = '';
            }
        });
        function hideAllPoppers() {
            $('#rollPopper,#cutPopper,#ackPopper,#issdPopper,#linePopper').addClass('hidden');
            if (activeCell) {
                $(activeCell).removeClass('highlight');
                activeCell = null;
            }
        }
        function bindPopperEvents() {
            $("#cuttingTable tbody .rolls-used-cell").off('click').on('click', function(e) {
                e.stopPropagation();
                const popper = document.getElementById('rollPopper');
                const $cell = $(this);
                const layID = $cell.data('layid');
                const isHidden = popper.classList.contains('hidden');
                if (isHidden) {
                    hideAllPoppers();
                    activeCell = this;
                    $(this).addClass('highlight');
                    const rect = this.getBoundingClientRect();
                    const containerRect = document.querySelector('#cuttingTableContainer').getBoundingClientRect();
                    popper.style.top = `${rect.top - containerRect.top - 130}px`;
                    popper.style.left = `${rect.left - containerRect.left + 20}px`;
                    popper.classList.remove('hidden');
                    $('#popRollBody').html('<tr><td colspan="5" class="py-1 text-gray-500">Loading...</td></tr>');
                    $.ajax({
                        url: '/sizerollbreakup',
                        type: 'GET',
                        data: { layid: layID },
                        success: function(res) {
                            if (res.success && res.data.length) {
                                const rows = res.data.map(item => `
                                    <tr class="text-gray-800">
                                        <td class="py-1 pr-4">${item.RollNo || '-'}</td>
                                        <td class="py-1 pr-4">${item.R_POints || item.R_POints || '-'}</td>
                                        <td class="py-1 pr-4">${item.Supplier || '-'}</td>
                                        <td class="py-1 pr-4">${item.Shade || '-'}</td>
                                        <td class="py-1">${item.Relax_hrs || item.Relax || '-'}</td>
                                    </tr>
                                `).join('');
                                $('#popRollBody').html(rows);
                            } else {
                                $('#popRollBody').html('<tr><td colspan="5" class="py-1 text-gray-500">No roll details available</td></tr>');
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error('Error fetching roll details:', error);
                            $('#popRollBody').html('<tr><td colspan="5" class="py-1 text-red-500">Error loading data</td></tr>');
                        }
                    });
                } else {
                    hideAllPoppers();
                }
            });
            $(document).off('click.rollpop').on('click.rollpop', function() {
                hideAllPoppers();
            });
            $("#cuttingTable tbody .cut-qty-cell").off('click').on('click', function(e) {
                e.stopPropagation();
                const popper = document.getElementById('cutPopper');
                const $cell = $(this);
                const layID = $cell.data('layid');
                const isHidden = popper.classList.contains('hidden');
                if (isHidden) {
                    hideAllPoppers();
                    activeCell = this;
                    $(this).addClass('highlight');
                    const rect = this.getBoundingClientRect();
                    const containerRect = document.querySelector('#cuttingTableContainer').getBoundingClientRect();
                    popper.style.top = `${rect.top - containerRect.top - 150}px`;
                    popper.style.left = `${rect.left - containerRect.left  + 30}px`;
                    popper.classList.remove('hidden');
                    $('#cutBreakdownBody').html('<tr><td colspan="3" class="py-1 text-gray-500">Loading...</td></tr>');
                    $.ajax({
                        url: '/sizr-breakup-cutting',
                        type: 'GET',
                        data: { layid: layID },
                        success: function(res) {
                            if (res.success && res.data.length) {
                                const rows = res.data.map(it => `
                                    <tr class="text-gray-800">
                                        <td class="py-1 pr-4">${it.Size || '-'}</td>
                                        <td class="py-1 pr-4">${it.Qty ?? '-'}</td>
                                        <td class="py-1">${it.FPY ?? '-'}</td>
                                    </tr>
                                `).join('');
                                $('#cutBreakdownBody').html(rows);
                            } else {
                                $('#cutBreakdownBody').html('<tr><td colspan="3" class="py-1 text-gray-500">No breakdown available</td></tr>');
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error('Error fetching size breakup:', error);
                            $('#cutBreakdownBody').html('<tr><td colspan="3" class="py-1 text-red-500">Error loading data</td></tr>');
                        }
                    });
                } else {
                    hideAllPoppers();
                }
            });
            $(document).off('click.cutpop').on('click.cutpop', function() {
                hideAllPoppers();
            });
            $("#cuttingTable tbody .ack-pcs-cell").off('click').on('click', function(e) {
                e.stopPropagation();
                const popper = document.getElementById('ackPopper');
                const $cell = $(this);
                const layID = $cell.data('layid');
                const isHidden = popper.classList.contains('hidden');
                if (isHidden) {
                    hideAllPoppers();
                    activeCell = this;
                    $(this).addClass('highlight');
                    const rect = this.getBoundingClientRect();
                    const containerRect = document.querySelector('#cuttingTableContainer').getBoundingClientRect();
                    popper.style.top = `${rect.top - containerRect.top - 130}px`;
                    popper.style.left = `${rect.left - containerRect.left + 40}px`;
                    popper.classList.remove('hidden');
                    $('#ackBreakdownBody').html('<tr><td colspan="2" class="text-gray-500 py-1">Loading...</td></tr>');
                    $.ajax({
                        url: '/get-ack-breakdown',
                        method: 'GET',
                        data: { layid: layID, arg: 1 },
                        success: function(response) {
                            let items = response.data || [];
                            const tbodyHtml = items.length
                                ? items.map(it => `
                                    <tr class="text-gray-800">
                                        <td class="py-1 pr-4">${it.Size || '-'}</td>
                                        <td class="py-1">${it.Qty ?? '-'}</td>
                                    </tr>
                                `).join('')
                                : '<tr><td class="py-1 text-gray-500" colspan="2">No breakdown available</td></tr>';
                            $('#ackBreakdownBody').html(tbodyHtml);
                        },
                        error: function(xhr) {
                            console.error(xhr);
                            $('#ackBreakdownBody').html('<tr><td colspan="2" class="text-red-500 py-1">Error loading data</td></tr>');
                        }
                    });
                } else {
                    hideAllPoppers();
                }
            });
            $(document).off('click.ackpop').on('click.ackpop', function() {
                hideAllPoppers();
            });
            $("#cuttingTable tbody .issd-cell").off('click').on('click', function(e) {
                e.stopPropagation();
                const popper = document.getElementById('issdPopper');
                const $cell = $(this);
                const layID = $cell.data('layid');
                const isHidden = popper.classList.contains('hidden');
                if (isHidden) {
                    hideAllPoppers();
                    activeCell = this;
                    $(this).addClass('highlight');
                    const rect = this.getBoundingClientRect();
                    const containerRect = document.querySelector('#cuttingTableContainer').getBoundingClientRect();
                    popper.style.top = `${rect.top - containerRect.top - 150}px`;
                    popper.style.left = `${rect.left - containerRect.left - 180}px`;
                    popper.classList.remove('hidden');
                    $('#issdBreakdownBody').html('<tr><td colspan="2" class="text-gray-500 py-1">Loading...</td></tr>');
                    $.ajax({
                        url: '/get-ack-breakdown',
                        method: 'GET',
                        data: { layid: layID, arg: 2 },
                        success: function(response) {
                            let items = response.data || [];
                            const tbodyHtml = items.length
                                ? items.map(it => `
                                    <tr class="text-gray-800">
                                        <td class="py-1 pr-4">${it.Size || '-'}</td>
                                        <td class="py-1">${it.Qty ?? '-'}</td>
                                    </tr>
                                `).join('')
                                : '<tr><td class="py-1 text-gray-500" colspan="2">No breakdown available</td></tr>';
                            $('#issdBreakdownBody').html(tbodyHtml);
                        },
                        error: function() {
                            $('#issdBreakdownBody').html('<tr><td colspan="2" class="text-red-500 py-1">Error loading data</td></tr>');
                        }
                    });
                } else {
                    hideAllPoppers();
                }
            });
            $(document).off('click.issdpop').on('click.issdpop', function() {
                hideAllPoppers();
            });
            $("#cuttingTable tbody .line-qty-cell").off('click').on('click', function(e) {
                e.stopPropagation();
                const popper = document.getElementById('linePopper');
                const $cell = $(this);
                const layID = $cell.data('layid');
                const isHidden = popper.classList.contains('hidden');
                if (isHidden) {
                    hideAllPoppers();
                    activeCell = this;
                    $(this).addClass('highlight');
                    const rect = this.getBoundingClientRect();
                    const containerRect = document.querySelector('#cuttingTableContainer').getBoundingClientRect();
                    popper.style.top = `${rect.top - containerRect.top - 150}px`;
                    popper.style.left = `${rect.left - containerRect.left - 180}px`;
                    popper.classList.remove('hidden');
                    $('#lineBreakdownBody').html('<tr><td colspan="2" class="text-gray-500 py-1">Loading...</td></tr>');
                    $.ajax({
                        url: '/get-ack-breakdown',
                        method: 'GET',
                        data: { layid: layID, arg: 3 },
                        success: function(response) {
                            let items = response.data || [];
                            const tbodyHtml = items.length
                                ? items.map(it => `
                                    <tr class="text-gray-800">
                                        <td class="py-1 pr-4">${it.Size || '-'}</td>
                                        <td class="py-1">${it.Qty ?? '-'}</td>
                                    </tr>
                                `).join('')
                                : '<tr><td class="py-1 text-gray-500" colspan="2">No breakdown available</td></tr>';
                            $('#lineBreakdownBody').html(tbodyHtml);
                        },
                        error: function() {
                            $('#lineBreakdownBody').html('<tr><td colspan="2" class="text-red-500 py-1">Error loading data</td></tr>');
                        }
                    });
                } else {
                    hideAllPoppers();
                }
            });
            $(document).off('click.linepop').on('click.linepop', function() {
                hideAllPoppers();
            });
        }
    }

    function updateBalanceTable(logs) {
        if (dataTable) {
            dataTable.clear().destroy();
        }
        const tableData = logs.map(row => {
            const cutQtyNum = parseFloat(String(row.Cut_Qty ?? '0').toString().replace(/,/g, '').trim()) || 0;
            const typeStr = cutQtyNum > 0 ? 'Running' : 'Not yet started';
            return [
                row.Unit || '-',
                row.Buyer || '-',
                row.OCN || '-',
                row.Item || '-',
                row.Color || '-',
                row.Order_Qty || '-',
                row.Bom_Qty || '-',
                row.Cut_Qty || '-',
                row.Bal_To_Cut || '-',
                row.Pend_Perc || '-',
                typeStr
            ];
        });
        dataTable = $("#balanceTable").DataTable({
            data: tableData,
            columns: [
                { title: "Unit" },
                { title: "Buyer" },
                { title: "OCN" },
                { title: "Item" },
                { title: "Color" },
                { title: "Order Qty" },
                { title: "BOM Qty" },
                { title: "Cut Qty" },
                { title: "Bal To Cut" },
                { title: "Pend %" },
                { title: "Type" }
            ],
            language: { lengthMenu: 'Show _MENU_ rows', search: 'Search:' },
            pageLength: 10,
            lengthMenu: [10,25,50,100],
            searching: true,
            ordering: true,
            destroy: true,
            drawCallback: function() { updateAllKpis(); }
        });
        // toggle containers
        $('#cuttingCardTableWrap').addClass('hidden');
        $('#cutpanelCardTableWrap').addClass('hidden');
        $('#balanceCardTableWrap').removeClass('hidden');
    }

    function updateCutPanelTable(logs) {
        if (dataTable) {
            dataTable.clear().destroy();
        }
        const tableData = logs.map(row => [
            row.Unit || '-',
            row.Buyer || '-',
            row.OCN || '-',
            row.Item || '-',
            row.Color || '-',
            row.Ok_Qty || '-',
            row.Rej_Qty || '-',
            row.Rej_Wt || '-',
            row.Rej_Perc || '-'
        ]);
        dataTable = $("#cutpanelTable").DataTable({
            data: tableData,
            columns: [
                { title: "Unit" },
                { title: "Buyer" },
                { title: "OCN" },
                { title: "Item" },
                { title: "Color" },
                { title: "OK Qty" },
                { title: "Rej Qty" },
                { title: "Rej Wt" },
                { title: "Rej %" }
            ],
            language: { lengthMenu: 'Show _MENU_ rows', search: 'Search:' },
            pageLength: 10,
            lengthMenu: [10,25,50,100],
            searching: true,
            ordering: true,
            destroy: true,
            drawCallback: function() { updateAllKpis(); }
        });
        // toggle containers
        $('#cuttingCardTableWrap').addClass('hidden');
        $('#balanceCardTableWrap').addClass('hidden');
        $('#cutpanelCardTableWrap').removeClass('hidden');
    }

    function drillOutUnits() {
        unitLevel = "units";
        unitPath = [];
        updateUnitChart("units");
        // Reset attribute chart to show all buyers
        buyerLevel = "buyers";
        buyerPath = [];
        updateBuyerChart("buyers");
        attributeChart.data.labels = cuttingOutput.buyers.labels;
        attributeChart.data.datasets[0].data = cuttingOutput.buyers.values;
        attributeChart.data.datasets[0].backgroundColor = '#000080';
        attributeChart.update();
        trendChart.data.datasets[0].data = cuttingOutput.trend;
        trendChart.update();
        updateTable(cuttingOutput.logs);
		updateAllKpis();
        updateUnitBreadcrumb();
        updateBuyerBreadcrumb();
    }
    function drillBackUnits(unit) {
        unitLevel = "machines";
        unitPath = [unit];
        updateUnitChart("machines", unit);
        // Update attribute chart to show buyers for this unit
        buyerLevel = "buyers";
        buyerPath = [];
        updateBuyerChart("buyers");
        attributeChart.data.labels = cuttingOutput.buyers.labels;
        attributeChart.data.datasets[0].data = cuttingOutput.units.machines[unit]?.buyers || [];
        attributeChart.data.datasets[0].backgroundColor = attributeChart.data.labels.map(() => '#000080');
        attributeChart.update();
        // Update trend chart with unit-specific trend data
        const unitTrend = cuttingOutput.units.machines[unit]?.trend || cuttingOutput.trend;
        trendChart.data.datasets[0].data = unitTrend;
        trendChart.update();
        // Update table with unit-specific logs
        const unitLogs = cuttingOutput.units.machines[unit]?.logs || cuttingOutput.logs;
        updateTable(unitLogs);
		updateAllKpis();
        updateUnitBreadcrumb();
        updateBuyerBreadcrumb();
    }
    function drillBackMachine(unit, machine) {
        unitLevel = "machine";
        unitPath = [unit, machine];
        updateUnitChart("machine", unit, machine);
        // Update attribute chart to show buyers for this machine
        buyerLevel = "buyers";
        buyerPath = [];
        updateBuyerChart("buyers");
        attributeChart.data.labels = cuttingOutput.buyers.labels;
        attributeChart.data.datasets[0].data = cuttingOutput.units.machines[unit]?.machineData[machine]?.buyers || [];
        attributeChart.data.datasets[0].backgroundColor = attributeChart.data.labels.map(() => '#000080');
        attributeChart.update();
        // Update trend chart with machine-specific trend data
        const machineTrend = cuttingOutput.units.machines[unit]?.machineData[machine]?.trend || cuttingOutput.trend;
        trendChart.data.datasets[0].data = machineTrend;
        trendChart.update();
        // Update table with machine-specific logs
        const machineLogs = cuttingOutput.units.machines[unit]?.machineData[machine]?.logs || cuttingOutput.logs;
        updateTable(machineLogs);
		updateAllKpis();
        updateUnitBreadcrumb();
        updateBuyerBreadcrumb();
    }
    function drillOutBuyers() {
        buyerLevel = "buyers";
        buyerPath = [];
        updateBuyerChart("buyers");
        // Reset unit chart to show all units
        unitLevel = "units";
        unitPath = [];
        updateUnitChart("units");
        unitChart.data.labels = cuttingOutput.units.labels;
        unitChart.data.datasets[0].data = cuttingOutput.units.values;
        unitChart.data.datasets[0].backgroundColor = unitChart.data.labels.map(() => '#000080');
        unitChart.update();
        trendChart.data.datasets[0].data = cuttingOutput.trend;
        trendChart.update();
        updateTable(cuttingOutput.logs);
		updateAllKpis();
        updateBuyerBreadcrumb();
        updateUnitBreadcrumb();
    }
    function drillBackBuyers(buyer) {
        buyerLevel = "ocns";
        buyerPath = [buyer];
        updateBuyerChart("ocns", buyer);
        // Preserve current unit drill state and compute unit chart accordingly filtered by buyer
        const currentUnitLevel = unitLevel; // 'units' | 'machines' | 'machine'
        const currentUnit = unitPath[0];
        const currentMachine = unitPath[1];
        let logsForTable = [];

        if (currentUnitLevel === 'machine' && currentUnit && currentMachine) {
            const unitData = cuttingOutput.units.machines[currentUnit] || {};
            const labels = (unitData.labels || []).slice();
            const machineData = unitData.machineData || {};
            const sums = labels.reduce((acc, m) => { acc[m] = 0; return acc; }, {});
            labels.forEach(m => {
                const mlogs = (machineData[m]?.logs || []).filter(l => (l.Buyer || '') === buyer);
                sums[m] = mlogs.reduce((s, l) => s + (parseInt(l.Cut_Qty || 0)), 0);
            });
            unitChart.data.labels = labels;
            unitChart.data.datasets[0].data = labels.map(m => sums[m] || 0);
            unitChart.data.datasets[0].backgroundColor = labels.map(l => l === currentMachine ? '#1e3a8a' : '#d1d5db');
            unitChart.update();
            // Trend and table for the selected machine filtered by buyer
            const filteredMachineLogs = (machineData[currentMachine]?.logs || []).filter(l => (l.Buyer || '') === buyer);
            logsForTable = filteredMachineLogs;
            const trend = globalDates.map(d => filteredMachineLogs.filter(l => l.Edate === d).reduce((s, l) => s + (parseInt(l.Cut_Qty || 0)), 0));
            trendChart.data.datasets[0].data = trend;
            trendChart.update();
        } else if (currentUnitLevel === 'machines' && currentUnit) {
            // Show machine-wise totals for the current unit filtered by buyer
            const unitData = cuttingOutput.units.machines[currentUnit] || {};
            const labels = (unitData.labels || []).slice();
            const machineData = unitData.machineData || {};
            const sums = labels.reduce((acc, m) => { acc[m] = 0; return acc; }, {});
            labels.forEach(m => {
                const mlogs = (machineData[m]?.logs || []).filter(l => (l.Buyer || '') === buyer);
                sums[m] = mlogs.reduce((s, l) => s + (parseInt(l.Cut_Qty || 0)), 0);
            });
            unitChart.data.labels = labels;
            unitChart.data.datasets[0].data = labels.map(m => sums[m] || 0);
            unitChart.data.datasets[0].backgroundColor = labels.map(() => '#000080');
            unitChart.update();
            const unitLogsFiltered = (unitData.logs || []).filter(l => (l.Buyer || '') === buyer);
            logsForTable = unitLogsFiltered;
            const trend = globalDates.map(d => unitLogsFiltered.filter(l => l.Edate === d).reduce((s, l) => s + (parseInt(l.Cut_Qty || 0)), 0));
            trendChart.data.datasets[0].data = trend;
            trendChart.update();
        } else {
            // Default: unit-wise totals filtered by buyer (previous behavior)
            let buyerLogs = cuttingOutput.buyers.ocns[buyer]?.logs || [];
            const unitSums = cuttingOutput.units.labels.reduce((acc, u) => { acc[u] = 0; return acc; }, {});
            buyerLogs.forEach(log => { if (log.Unit) unitSums[log.Unit] += parseInt(log.Cut_Qty || 0); });
            unitChart.data.labels = cuttingOutput.units.labels;
            unitChart.data.datasets[0].data = cuttingOutput.units.labels.map(u => unitSums[u] || 0);
            unitChart.data.datasets[0].backgroundColor = unitChart.data.labels.map(() => '#000080');
            unitChart.update();
            logsForTable = buyerLogs;
            const buyerTrend = globalDates.map(d => buyerLogs.filter(l => l.Edate === d).reduce((s, l) => s + parseInt(l.Cut_Qty || 0), 0));
            trendChart.data.datasets[0].data = buyerTrend;
            trendChart.update();
        }
        updateTable(logsForTable);
        updateAllKpis();
        updateBuyerBreadcrumb();
        updateUnitBreadcrumb();
    }
    function drillBackOCN(buyer, ocn) {
        buyerLevel = "ocn";
        buyerPath = [buyer, ocn];
        updateBuyerChart("ocn", buyer, ocn);
        // Preserve current unit drill state and compute unit chart accordingly filtered by buyer+ocn
        const currentUnitLevel = unitLevel;
        const currentUnit = unitPath[0];
        const currentMachine = unitPath[1];
        let logsForTable = [];
        let ocnLogs = cuttingOutput.buyers.ocns[buyer]?.[ocn]?.logs || [];

        if (currentUnitLevel === 'machine' && currentUnit && currentMachine) {
            const unitData = cuttingOutput.units.machines[currentUnit] || {};
            const labels = (unitData.labels || []).slice();
            const machineData = unitData.machineData || {};
            const sums = labels.reduce((acc, m) => { acc[m] = 0; return acc; }, {});
            labels.forEach(m => {
                const mlogs = (machineData[m]?.logs || []).filter(l => (l.Buyer || '') === buyer && (l.Order_No || '') === ocn);
                sums[m] = mlogs.reduce((s, l) => s + (parseInt(l.Cut_Qty || 0)), 0);
            });
            unitChart.data.labels = labels;
            unitChart.data.datasets[0].data = labels.map(m => sums[m] || 0);
            unitChart.data.datasets[0].backgroundColor = labels.map(l => l === currentMachine ? '#1e3a8a' : '#d1d5db');
            unitChart.update();
            const filteredMachineLogs = (machineData[currentMachine]?.logs || []).filter(l => (l.Buyer || '') === buyer && (l.Order_No || '') === ocn);
            logsForTable = filteredMachineLogs;
            const trend = globalDates.map(d => filteredMachineLogs.filter(l => l.Edate === d).reduce((s, l) => s + (parseInt(l.Cut_Qty || 0)), 0));
            trendChart.data.datasets[0].data = trend;
            trendChart.update();
        } else if (currentUnitLevel === 'machines' && currentUnit) {
            const unitData = cuttingOutput.units.machines[currentUnit] || {};
            const labels = (unitData.labels || []).slice();
            const machineData = unitData.machineData || {};
            const sums = labels.reduce((acc, m) => { acc[m] = 0; return acc; }, {});
            labels.forEach(m => {
                const mlogs = (machineData[m]?.logs || []).filter(l => (l.Buyer || '') === buyer && (l.Order_No || '') === ocn);
                sums[m] = mlogs.reduce((s, l) => s + (parseInt(l.Cut_Qty || 0)), 0);
            });
            unitChart.data.labels = labels;
            unitChart.data.datasets[0].data = labels.map(m => sums[m] || 0);
            unitChart.data.datasets[0].backgroundColor = labels.map(() => '#000080');
            unitChart.update();
            const unitLogsFiltered = (unitData.logs || []).filter(l => (l.Buyer || '') === buyer && (l.Order_No || '') === ocn);
            logsForTable = unitLogsFiltered;
            const trend = globalDates.map(d => unitLogsFiltered.filter(l => l.Edate === d).reduce((s, l) => s + (parseInt(l.Cut_Qty || 0)), 0));
            trendChart.data.datasets[0].data = trend;
            trendChart.update();
        } else {
            // Default: unit-wise totals filtered by buyer and ocn
            const unitSums = cuttingOutput.units.labels.reduce((acc, u) => { acc[u] = 0; return acc; }, {});
            ocnLogs.forEach(log => { if (log.Unit) unitSums[log.Unit] += parseInt(log.Cut_Qty || 0); });
            unitChart.data.labels = cuttingOutput.units.labels;
            unitChart.data.datasets[0].data = cuttingOutput.units.labels.map(u => unitSums[u] || 0);
            unitChart.data.datasets[0].backgroundColor = '#000080';
            unitChart.update();
            logsForTable = ocnLogs;
            const ocnTrend = cuttingOutput.buyers.ocns[buyer]?.[ocn]?.trend || globalDates.map(d => ocnLogs.filter(l => l.Edate === d).reduce((s, l) => s + parseInt(l.Cut_Qty || 0), 0));
            trendChart.data.datasets[0].data = ocnTrend;
            trendChart.update();
        }
        updateTable(logsForTable);
        updateAllKpis();
        updateBuyerBreadcrumb();
        updateUnitBreadcrumb();
    }
    const smallChartOptions = {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: { display: false },
            tooltip: { enabled: false }
        },
        layout: { padding: 0 },
        scales: {
            x: { display: false },
            y: { display: false }
        }
    };
    var kpiData = {
        pieces: { change: "-5%", target: "8,000", chart: [5, 6, 7, 8, 6, 7, 8] },
        lay: { change: "+2%", target: "500", chart: [3, 4, 4, 5, 4, 5, 6] },
        fabric: { change: "-1%", target: "70", chart: [2, 2, 3, 3, 2, 3, 2] }
    };
    function initKpiCards() {
        $('.kpi-card[data-type="cuttingOutput"], .kpi-card[data-type="balancecuttingOutput"], .kpi-card[data-type="cutpanelOutput"]').each(function() {
            const cardType = $(this).data('type');
            if (cardType === 'cutpanelOutput') {
                kpiActiveTab[cardType] = 'checked';
            } else if (cardType === 'cuttingOutput') {
                kpiActiveTab[cardType] = 'pieces';
            }
            const canvas = $(this).find('canvas[data-role="mini-chart"]')[0];
            if (!canvas) return;
            const ctx = canvas.getContext('2d');
            kpiCharts[cardType] = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ["Mon","Tue","Wed","Thu","Fri","Sat","Sun"],
                    datasets: [{
                        data: kpiData.pieces.chart,
                        borderColor: "#3b82f6",
                        backgroundColor: "rgba(59,130,246,0.2)",
                        fill: true,
                        tension: 0.4,
                        borderWidth: 2,
                        pointRadius: 0
                    }]
                },
                options: {
                    responsive: true,
                    plugins: { legend: { display: false }, tooltip: { enabled: false } },
                    scales: { x: { display: false }, y: { display: false } }
                }
            });
        });
    }
    new Chart(document.getElementById('kpi-chart-2'), {
        type: 'line',
        data: {
            labels: ['A', 'B', 'C', 'D', 'E'],
            datasets: [{ data: [90, 85, 88, 86, 86], borderColor: '#ef4444', tension: 0.4, borderWidth: 2, pointRadius: 0, fill: false }]
        },
        options: smallChartOptions
    });
    new Chart(document.getElementById('kpi-chart-3'), {
        type: 'line',
        data: {
            labels: ['A', 'B', 'C', 'D', 'E'],
            datasets: [{ data: [95, 96, 98, 97.5, 97], borderColor: '#f59e0b', tension: 0.4, borderWidth: 2, pointRadius: 0, fill: false }]
        },
        options: smallChartOptions
    });
    new Chart(document.getElementById('kpi-chart-4'), {
        type: 'line',
        data: {
            labels: ['A', 'B', 'C', 'D', 'E'],
            datasets: [{ data: [80, 85, 90, 89, 88], borderColor: '#14b8a6', tension: 0.4, borderWidth: 2, pointRadius: 0, fill: false }]
        },
        options: smallChartOptions
    });
    new Chart(document.getElementById('kpi-chart-5'), {
        type: 'line',
        data: {
            labels: ['A', 'B', 'C', 'D', 'E'],
            datasets: [{ data: [130, 110, 100, 120, 124], borderColor: '#8b5cf6', tension: 0.4, borderWidth: 2, pointRadius: 0, fill: false }]
        },
        options: smallChartOptions
    });

    $(document).ready(function() {


        // Extract fromdate and enddate from URL query parameters
        const urlParams = new URLSearchParams(window.location.search);
        const fromDateParam = urlParams.get('fromdate');
        const endDateParam = urlParams.get('enddate');

        // Initialize date range variables
        let initialStart, initialEnd, initialStartFormatted, initialEndFormatted;
        let initialDisplayStartFormatted, initialDisplayEndFormatted;
        let selectedRangeLabel = 'Last Week'; // Default range

        if (fromDateParam && endDateParam && moment(fromDateParam, 'YYYY-MM-DD', true).isValid() && moment(endDateParam, 'YYYY-MM-DD', true).isValid()) {
            // Use URL parameters if valid
            initialStart = moment(fromDateParam, 'YYYY-MM-DD');
            initialEnd = moment(endDateParam, 'YYYY-MM-DD');
            initialStartFormatted = initialStart.format('YYYY-MM-DD');
            initialEndFormatted = initialEnd.format('YYYY-MM-DD');
			selectedfromdate = initialStartFormatted;
			selectedenddate = initialEndFormatted;
            initialDisplayStartFormatted = initialStart.format('DD-MM-YY');
            initialDisplayEndFormatted = initialEnd.format('DD-MM-YY');

            // Determine the selected range label
            if (initialStart.isSame(initialEnd, 'day')) {
                selectedRangeLabel = 'Today';
            } else if (initialStart.isSame(moment().subtract(6, 'days'), 'day') && initialEnd.isSame(moment(), 'day')) {
                selectedRangeLabel = 'Last Week';
            } else if (initialStart.isSame(moment().startOf('month'), 'day') && initialEnd.isSame(moment().endOf('month'), 'day')) {
                selectedRangeLabel = 'This Month';
            } else {
                selectedRangeLabel = 'Custom Range';
            }
        } else {
            // Fallback to default (Last Week)
            initialStart = moment().subtract(6, 'days');
            initialEnd = moment();
            initialStartFormatted = initialStart.format('YYYY-MM-DD');
            initialEndFormatted = initialEnd.format('YYYY-MM-DD');
			selectedfromdate = initialStartFormatted;
			selectedenddate = initialEndFormatted;
            initialDisplayStartFormatted = initialStart.format('DD-MM-YY');
            initialDisplayEndFormatted = initialEnd.format('DD-MM-YY');
        }

        // KPI card activation (switch dataset); ignore tab clicks
        $(document).on('click', '.kpi-card', function(e) {
            if ($(e.target).closest('.tab-option').length) return; // handled separately
            $('.kpi-card').removeClass('active');
            $(this).addClass('active');
            const cardType = $(this).data('type');
            activeDataset = (cardType === 'balancecuttingOutput') ? 'balance' : (cardType === 'cutpanelOutput' ? 'cutpanel' : 'cutting');
            // toggle table wrappers
            if (activeDataset === 'balance') {
                balanceUnitFilter = null;
                balanceBuyerFilter = null;
                updateAllCharts();
                updateBalanceTable(balanceOutput.logs);
                updateAllKpis();
                $('#unitChartTitle').text('Unit-wise Balance Qty');
                attributeChart.data.datasets[0].label = 'Breakdown by Buyer';
                attributeChart.update();
                // Refresh breadcrumbs for balance dataset
                updateUnitBreadcrumb();
                updateBuyerBreadcrumb();
            } else if (activeDataset === 'cutpanel') {
                cutPanelUnitFilter = null;
                cutPanelBuyerFilter = null;
                updateAllCharts();
                updateCutPanelTable(cutPanelOutput.logs);
                updateAllKpis();
                $('#unitChartTitle').text('Unit-wise OK Qty');
                attributeChart.data.datasets[0].label = 'Breakdown by Buyer';
                attributeChart.update();
                // Refresh breadcrumbs for cut panel dataset
                updateUnitBreadcrumb();
                updateBuyerBreadcrumb();
            } else {
                $('#balanceCardTableWrap').addClass('hidden');
                $('#cutpanelCardTableWrap').addClass('hidden');
                $('#cuttingCardTableWrap').removeClass('hidden');
                balanceUnitFilter = null;
                balanceBuyerFilter = null;
                cutPanelUnitFilter = null;
                cutPanelBuyerFilter = null;
                // Reset drill state for cutting dataset
                unitLevel = 'units';
                unitPath = [];
                buyerLevel = 'buyers';
                buyerPath = [];
                updateAllCharts();
                updateTable(cuttingOutput.logs);
                updateAllKpis();
                $('#unitChartTitle').text('Machine-wise Total Pieces');
                attributeChart.data.datasets[0].label = 'Breakdown by Buyer';
                attributeChart.update();
                // Refresh breadcrumbs for cutting dataset
                updateUnitBreadcrumb();
                updateBuyerBreadcrumb();
            }
        });
        // Tab click handler (cutting KPI only has tabs)
        $(document).on('click', '.kpi-card .tab-option', function() {
            const $card = $(this).closest('.kpi-card');
            $card.find('.tab-option').removeClass('active');
            $(this).addClass('active');
            const cardType = $card.data('type');
            const tab = $(this).data('type');
            kpiActiveTab[cardType] = tab;
            // Refresh this card's KPI value based on selected tab
            updateKPIForCard($card[0], tab);
        });

        // Initialize trend chart
        trendChart = new Chart(document.getElementById('overall-trend-chart'), {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'Trend',
                    data: [],
                    borderColor: '#000080',
                    backgroundColor: 'rgba(0, 0, 128, 0.1)',
                    tension: 0.3,
                    borderWidth: 2,
                    pointRadius: 4,
                    pointBackgroundColor: '#000080',
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { legend: { display: false }, tooltip: { mode: 'index', intersect: false } },
                scales: {
                    x: {
                        grid: { display: false },
                        ticks: {
                            callback: function(value, index, values) {
                                return moment(this.getLabelForValue(value)).format('DD-MM-YY');
                            }
                        }
                    },
                    y: { beginAtZero: true, grid: { color: '#e5e7eb' } }
                }
            }
        });

        // Initialize unit chart
        unitChart = new Chart(document.getElementById('unit-pieces-chart'), {
            type: 'bar',
            data: {
                labels: [],
                datasets: [{
                    label: 'Units',
                    data: [],
                    backgroundColor: '#000080',
                    borderRadius: 4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { legend: { display: false } },
                scales: { x: { grid: { display: false } }, y: { beginAtZero: true, grid: { color: '#e5e7eb' } } },
                onClick: (e, elements) => {
                    if (!elements.length) return;
                    const index = elements[0].index;
                    const label = unitChart.data.labels[index];
                    if (activeDataset === 'balance') {
                        balanceUnitFilter = label;
                        balanceBuyerFilter = null;
                        applyBalanceFiltersAndUpdate();
                        return;
                    } else if (activeDataset === 'cutpanel') {
                        cutPanelUnitFilter = label;
                        cutPanelBuyerFilter = null;
                        applyCutPanelFiltersAndUpdate();
                        return;
                    }
                    if (unitLevel === "units") {
                        drillBackUnits(label);
                    } else if (unitLevel === "machines") {
                        drillBackMachine(unitPath[0], label);
                    } else if (unitLevel === "machine") {
                        drillBackMachine(unitPath[0], label);
                    }
                }
            }
        });

        // Initialize attribute chart
        attributeChart = new Chart(document.getElementById('attribute-drilldown-chart'), {
            type: 'bar',
            data: {
                labels: [],
                datasets: [{
                    label: 'Breakdown by Buyer',
                    data: [],
                    backgroundColor: '#000080',
                    borderRadius: 4,
                    barThickness: 30,
                    borderSkipped: false,
                    borderWidth: 1,
                    borderColor: '#000080'
                }]
            },
            options: {
                indexAxis: 'y',
                responsive: true,
                maintainAspectRatio: false,
                plugins: { legend: { display: false }, tooltip: { enabled: true } },
                scales: {
                    x: { beginAtZero: true, max: undefined, ticks: { callback: value => value.toLocaleString() }, grid: { color: '#e5e7eb' } },
                    y: { grid: { display: false } }
                },
                onClick: (e, elements) => {
                    if (!elements.length) return;
                    const index = elements[0].index;
                    const label = attributeChart.data.labels[index];
                    if (activeDataset === 'balance') {
                        // If a unit is selected, clicking buyer narrows table; else clicking buyer shows per-unit breakdown
                        if (balanceUnitFilter) {
                            balanceBuyerFilter = label;
                        } else {
                            balanceBuyerFilter = label;
                            balanceUnitFilter = null;
                        }
                        applyBalanceFiltersAndUpdate();
                        return;
                    } else if (activeDataset === 'cutpanel') {
                        if (cutPanelUnitFilter) {
                            cutPanelBuyerFilter = label;
                        } else {
                            cutPanelBuyerFilter = label;
                            cutPanelUnitFilter = null;
                        }
                        applyCutPanelFiltersAndUpdate();
                        return;
                    }
                    if (buyerLevel === "buyers") {
                        drillBackBuyers(label);
                    } else if (buyerLevel === "ocns") {
                        drillBackOCN(buyerPath[0], label);
                    } else if (buyerLevel === "ocn") {
                        drillBackOCN(buyerPath[0], label);
                    }
                }
            }
        });

        // Breadcrumb event handlers
        $("#unitBreadcrumbPieces").on("click", "#allUnits", () => {
            resetBothChartsToTop();
        });
        $("#unitBreadcrumbPieces").on("click", "#unitName", function() {
            if (activeDataset === 'balance') {
                balanceUnitFilter = null;
                applyBalanceFiltersAndUpdate();
            } else {
                drillBackUnits($(this).data("unit"));
            }
        });
        $("#unitBreadcrumbPieces").on("click", "#machineName", function() { drillBackMachine($(this).data("unit"), $(this).data("machine")); });
        $("#buyerBreadcrumb").on("click", "#allBuyers", () => {
            resetBothChartsToTop();
        });
        $("#buyerBreadcrumb").on("click", "#buyerName", function() {
            if (activeDataset === 'balance') {
                balanceBuyerFilter = null;
                applyBalanceFiltersAndUpdate();
            } else {
                drillBackBuyers($(this).data("buyer"));
            }
        });
        $("#buyerBreadcrumb").on("click", "#ocnName", function() { drillBackOCN($(this).data("buyer"), $(this).data("ocn")); });

        // Initialize date range picker
        $('#dateRangePicker').daterangepicker({
            opens: 'left',
            startDate: initialStart,
            endDate: initialEnd,
            maxDate: moment(), // Restrict dates beyond today
            ranges: {
                'Today': [moment(), moment()],
                'Last Week': [moment().subtract(6, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')]
            },
            locale: {
                format: 'DD-MM-YY'
            }
        }, function(start, end, label) {
            const startFormatted = start.format('YYYY-MM-DD');
            const endFormatted = end.format('YYYY-MM-DD');
			selectedfromdate = startFormatted;
			selectedenddate = endFormatted;
            const displayStartFormatted = start.format('DD-MM-YY');
            const displayEndFormatted = end.format('DD-MM-YY');
            selectedRangeLabel = label;
            const isSameDay = start.isSame(end, 'day');

            const titleText = `
            Cutting Output for - 
            <span style="color: #000; font-weight: bold; background-color: #FFFF00; padding: 2px 6px; border-radius: 10px;">
                GARMENTS
            </span>
            <span class="ml-4" style="color: #fff; font-weight: 500;">
                ${displayStartFormatted} - ${displayEndFormatted}
            </span>
            `;

            $('.dashboard_title').html(titleText);

            // Update breadcrumb link with selected dates
            const breadcrumbUrl = `/production_gar_dashboard?fromdate=${startFormatted}&enddate=${endFormatted}`;
            $('#productionBreadcrumb').attr('href', breadcrumbUrl);

            $('#dateRangePicker').val(`${displayStartFormatted} - ${displayEndFormatted}`);
            unitLevel = "units";
            unitPath = [];
            buyerLevel = "buyers";
            buyerPath = [];
            fetchData(null, startFormatted, endFormatted);
        });

        // Set initial dashboard title
        $('.dashboard_title').html(`
        Cutting Output for - 
            <span style="color: #000; font-weight: bold; background-color: #FFFF00; padding: 2px 6px; border-radius: 10px;">
            GARMENTS
            </span>
            <span class="ml-4" style="color: #fff; font-weight: 500;">
            ${initialDisplayStartFormatted} - ${initialDisplayEndFormatted}
            </span>
        `);

        // Set initial date picker value
        $('#dateRangePicker').val(`${initialDisplayStartFormatted} - ${initialDisplayEndFormatted}`);
        
        $(`#HistoricalButton`).on('click', function () {
            window.location.href = `/history_dashboard/Cutting?fromdate=${selectedfromdate}&enddate=${selectedenddate}`;
        });

        // Initial data fetch
        // Set initial breadcrumb link with initial dates
        const initialBreadcrumbUrl = `/production_gar_dashboard?fromdate=${initialStartFormatted}&enddate=${initialEndFormatted}`;
        $('#productionBreadcrumb').attr('href', initialBreadcrumbUrl);
        initKpiCards();
        fetchData(null, initialStartFormatted, initialEndFormatted);
    });
</script>
</body>
</html>