<header class="bg-blue-900 text-white flex justify-between items-center px-4 py-2 sticky top-0 z-50">
  <div class="flex items-center space-x-2">
    <a href="/dashboard" class="inline-flex items-center justify-center rounded-lg border border-white/30 p-2 hover:bg-blue-800 transition">
      <i class="fa-solid fa-house text-white text-[20px]"></i>
    </a>
    <h1 class="text-lg font-semibold tracking-tight truncate max-w-xl dashboard_title"> </h1>
  </div>
  <div class="flex items-center space-x-2">
    <div id="loadSpinner" class="spinner hidden"></div>
    <input type="text" placeholder="Select date range" id="dateRangePicker" class="h-8 px-2 rounded-md bg-white/10 text-white border border-white/30 text-sm cursor-pointer hover:bg-white/20 transition-colors">
      <button id="backToHistoryBtn" type="button" class="hidden items-center justify-center h-8 px-3 text-sm font-medium rounded-md bg-white/10 border border-white/30 hover:bg-white/20 transition">
        <i class="fa-solid fa-arrow-left mr-1 text-[16px]"></i>
        Back to history dashboard
      </button>
      <div id="HistoricalButton" class="inline-flex items-center justify-center h-8 px-3 text-sm font-medium rounded-md bg-white/10 border border-white/30 hover:bg-white/20 transition">
        <i class="fa-solid fa-clock-rotate-left mr-1 text-[16px]"></i>
        Historical
      </div>
      <button id="demovideoButton" type="button" class="inline-flex items-center justify-center h-8 px-3 text-sm font-medium rounded-md bg-white/10 border border-white/30 hover:bg-white/20 transition">
        <i class="fa-solid fa-video mr-1 text-[16px]"></i>
        Demo Video
      </button>
      <button id="userLogButton" type="button" class="inline-flex items-center justify-center h-8 w-8 text-sm font-medium rounded-md bg-white/10 border border-white/30 hover:bg-white/20 transition" title="User Activity Log">
        <i class="fa-solid fa-history text-[16px]"></i>
      </button>
    </div>
</header>

<!-- User Log Sliding Popup -->
<div id="userLogPanel" class="fixed bottom-0 right-0 h-screen sm:h-[600px] w-full sm:w-96 bg-white shadow-2xl transform translate-x-full transition-transform duration-300 ease-in-out z-40 flex flex-col rounded-t-3xl sm:rounded-lg overflow-hidden">
  <!-- Panel Header -->
  <div class="flex items-center justify-between px-6 py-5 bg-gradient-to-r from-blue-600 via-blue-700 to-indigo-700 shadow-md">
    <div class="flex items-center space-x-2">
      <i class="fa-solid fa-chart-line text-white text-lg"></i>
      <h2 class="text-lg font-bold text-white">Usage Analysis</h2>
    </div>
    <button id="closeLogPanel" type="button" class="inline-flex items-center justify-center h-8 w-8 rounded-full hover:bg-white/20 transition text-white">
      <i class="fa-solid fa-times text-lg"></i>
    </button>
  </div>

  <!-- Panel Content -->
  <div class="flex-1 overflow-y-auto custom-scrollbar bg-gradient-to-b from-slate-50 to-white">
    <!-- Top Stats -->
    <div class="px-6 py-5 bg-white border-b border-slate-100">
      <h3 class="text-xs font-bold text-slate-600 uppercase tracking-wide mb-4">User Statistics</h3>
      <div class="grid grid-cols-2 gap-4">
        <!-- Today's Users Card -->
        <div class="bg-gradient-to-br from-blue-50 to-blue-100 p-5 rounded-xl border border-blue-200 shadow-sm hover:shadow-md transition">
          <div class="flex items-center justify-between mb-2">
            <p class="text-xs font-semibold text-blue-700">Today's Users</p>
            <i class="fa-solid fa-calendar-day text-blue-500 text-sm"></i>
          </div>
          <p class="text-4xl font-bold text-blue-600" id="todayUsersCount">0</p>
        </div>
        <!-- This Week Card -->
        <div class="bg-gradient-to-br from-indigo-50 to-indigo-100 p-5 rounded-xl border border-indigo-200 shadow-sm hover:shadow-md transition">
          <div class="flex items-center justify-between mb-2">
            <p class="text-xs font-semibold text-indigo-700">This Week</p>
            <i class="fa-solid fa-calendar-week text-indigo-500 text-sm"></i>
          </div>
          <p class="text-4xl font-bold text-indigo-600" id="weeklyUsersCount">0</p>
        </div>
      </div>
    </div>

    <!-- Recent User Activities Grid -->
    <div class="px-6 py-5">
      <div class="flex items-center justify-between mb-4">
        <div class="flex items-center space-x-2">
          <i class="fa-solid fa-users text-slate-600 text-sm"></i>
          <h3 class="text-xs font-bold text-slate-600 uppercase tracking-wide">Recent Users</h3>
        </div>
        <span class="text-xs font-bold bg-blue-100 text-blue-700 px-3 py-1 rounded-full" id="activityCount">0</span>
      </div>
      <div class="bg-white rounded-lg border border-slate-200 overflow-hidden">
        <table class="w-full text-sm">
          <thead>
            <tr class="bg-slate-50 border-b border-slate-200">
              <th class="text-left px-4 py-3 font-bold text-slate-700">User Name</th>
              <th class="text-left px-4 py-3 font-bold text-slate-700">Login Time</th>
            </tr>
          </thead>
          <tbody id="activityTableBody">
            <tr>
              <td colspan="2" class="text-center py-6 text-slate-400">
                <i class="fa-solid fa-spinner animate-spin mr-2"></i>Loading...
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Overlay for log panel -->
<div id="logPanelOverlay" class="fixed inset-0 bg-black/50 hidden z-30 transition-opacity duration-300"></div>
<!-- Tailwind Modal -->
<div id="videoModal" class="fixed inset-0 z-50 hidden" aria-labelledby="videoModalTitle" role="dialog" aria-modal="true">
  <div class="flex min-h-screen items-center justify-center px-4">
    <div id="videoModalOverlay" class="fixed inset-0 bg-black/50"></div>
    <div class="relative w-full max-w-3xl rounded-lg bg-white shadow-xl">
      <div class="flex items-center justify-between border-b px-4 py-3">
        <h5 id="videoModalTitle" class="text-base font-semibold text-gray-800">Demo Video for Production Garments</h5>
        <button type="button" class="rounded p-1 text-gray-500 hover:bg-gray-100 hover:text-gray-700" data-close-video-modal="" aria-label="Close">
          <span class="block text-xl leading-none">&times;</span>
        </button>
      </div>
      <div class="p-4">
        <video id="videoPlayer" class="w-full rounded" controls="">
          <source  src="{{ asset('videos/ProductionDBDemoGarments.mp4') }}"  type="video/mp4">
        </video>
      </div>
    </div>
  </div>
</div>

<script>
  (function() {
  const openBtn = document.getElementById('demovideoButton');
  const modal = document.getElementById('videoModal');
  const overlay = document.getElementById('videoModalOverlay');
  const video = document.getElementById('videoPlayer');
  const closeButtons = document.querySelectorAll('[data-close-video-modal]');

  function openModal() {
  modal.classList.remove('hidden');
  try { video.play(); } catch (e) { /* autoplay may be blocked */ }
  }

  function closeModal() {
  try { video.pause(); video.currentTime = 0; } catch (e) {}
  modal.classList.add('hidden');
  }

  openBtn?.addEventListener('click', function(e) { e.preventDefault(); openModal(); });
  overlay?.addEventListener('click', closeModal);
  closeButtons.forEach(btn => btn.addEventListener('click', closeModal));

  // Close on Escape key
  document.addEventListener('keydown', function(e) {
  if (!modal.classList.contains('hidden') && e.key === 'Escape') {
  closeModal();
  }
  });

  // Back to history dashboard visibility + handler
  const backBtn = document.getElementById('backToHistoryBtn');
  // Show the button only when a back-trigger is set by history drilldown navigation
  (function toggleBackButton() {
  try {
  const HISTORY_URL_KEY = 'history_last_url_v2';
  const BACK_TRIGGER_KEY = 'history_back_trigger_v2';
  const SESSION_ONCE_KEY = 'history_back_once_v2';
  const hasTrigger = localStorage.getItem(BACK_TRIGGER_KEY) === '1';
  const hasUrl = !!localStorage.getItem(HISTORY_URL_KEY);
  const hasOnce = sessionStorage.getItem(SESSION_ONCE_KEY) === '1';
  if (hasTrigger && hasUrl && hasOnce) {
  backBtn?.classList.remove('hidden');
  backBtn?.classList.add('inline-flex');
  } else {
  backBtn?.classList.add('hidden');
  backBtn?.classList.remove('inline-flex');
  }
  } catch (e) { /* no-op */ }
  })();
  backBtn?.addEventListener('click', function() {
  try {
  // Keys must match those used in history_dashboard.blade.php
  const HISTORY_URL_KEY = 'history_last_url_v2';
  const BACK_TRIGGER_KEY = 'history_back_trigger_v2';
  const SESSION_ONCE_KEY = 'history_back_once_v2';
  const url = localStorage.getItem(HISTORY_URL_KEY);
  if (url) {
  localStorage.setItem(BACK_TRIGGER_KEY, '1');
  try { sessionStorage.removeItem(SESSION_ONCE_KEY); } catch (e) {}
  window.location.href = url;
  } else if (document.referrer) {
  // Fallback to browser referrer if available
  localStorage.setItem(BACK_TRIGGER_KEY, '1');
  try { sessionStorage.removeItem(SESSION_ONCE_KEY); } catch (e) {}
  window.location.href = document.referrer;
  }
  } catch (e) {
  // no-op
  }
  });
  })();

  // Historical button: ensure no preselected state is restored on history page
  (function bindHistoricalButton() {
  const histBtn = document.getElementById('HistoricalButton');
  histBtn?.addEventListener('click', function() {
  try {
  // Keys used by history dashboard
  const BACK_TRIGGER_KEY = 'history_back_trigger_v2';
  const SESSION_ONCE_KEY = 'history_back_once_v2';
  const STORAGE_KEY = 'history_dash_selection_v2';
  // Clear any back/restore triggers and previous selection
  localStorage.removeItem(BACK_TRIGGER_KEY);
  sessionStorage.removeItem(SESSION_ONCE_KEY);
  // Optional: clear prior selection so history never restores stale context
  localStorage.removeItem(STORAGE_KEY);
  } catch (e) { /* no-op */ }
  // allow existing navigation (if any) to proceed naturally
  });
  })();

  // ===== USER LOG ANALYTICS FUNCTIONALITY =====
  (function initUserLogAnalytics() {
  // Ensure DOM is ready and elements exist
  if (!document.getElementById('userLogPanel')) return;

  const logPanel = document.getElementById('userLogPanel');
  const logOverlay = document.getElementById('logPanelOverlay');
  const userLogBtn = document.getElementById('userLogButton');
  const closeLogBtn = document.getElementById('closeLogPanel');
  const activityTableBody = document.getElementById('activityTableBody');

  if (!logPanel || !logOverlay || !userLogBtn || !closeLogBtn) {
  console.warn('User analytics: Required elements not found');
  return;
  }

  function fetchUserActivityStats() {
  $.ajax({
  url: '/PortalUsageAnalysisProc',
  type: 'GET',
  data: { portaltype: 10 },
  dataType: 'json',
  success: function(response) {
  try {
  let data = response;
  if (response.success && response.data) {
                data = response.data;
              }

              const todayUsers = parseInt(data.todayUsers) || 0;
              const weekUsers = parseInt(data.weekUsers) || 0;

              document.getElementById('todayUsersCount').textContent = todayUsers;
              document.getElementById('weeklyUsersCount').textContent = weekUsers;

              const recent = Array.isArray(data.result) ? data.result : (Array.isArray(data) ? data : []);
              
              if (recent.length > 0) {
                document.getElementById('activityCount').textContent = recent.length;
                let html = '';
                recent.slice(0, 10).forEach(activity => {
                  const name = activity.employee || activity.user_name || activity.UserName || activity.name || 'Unknown';
                  let time = activity.formatted_time || activity.LastLoginDateTime || activity.created_at || activity.login_time || '';
                  if (time) {
                    try {
                      const d = new Date(time);
                      if (!isNaN(d)) time = d.toLocaleString('en-US', { month: 'short', day: 'numeric', year: 'numeric', hour: '2-digit', minute: '2-digit', hour12: true });
                    } catch (e) {}
                  }
                  html += '<tr style="border-bottom:1px solid #e2e8f0"><td style="padding:8px;font-weight:600;font-size:12px;word-break:break-word;max-width:140px">' + name + '</td><td style="padding:8px;font-size:12px;white-space:nowrap">' + (time || '—') + '</td></tr>';
                });
                activityTableBody.innerHTML = html;
              } else {
                document.getElementById('activityCount').textContent = '0';
                activityTableBody.innerHTML = '<tr><td colspan="2" style="text-align:center;padding:20px;color:#999">No recent activities</td></tr>';
              }
            } catch (e) {
              console.warn('Error processing activity data:', e);
              activityTableBody.innerHTML = '<tr><td colspan="2" style="text-align:center;padding:10px;color:red">Error loading data</td></tr>';
            }
          },
          error: function(xhr, status, error) {
            console.error('API Error:', error);
            document.getElementById('todayUsersCount').textContent = '—';
            document.getElementById('weeklyUsersCount').textContent = '—';
            activityTableBody.innerHTML = '<tr><td colspan="2" style="text-align:center;padding:10px;color:red">Unable to load data</td></tr>';
          }
        });
      }

      function openLogPanel() {
        if (logPanel && logOverlay) {
          logPanel.classList.remove('translate-x-full');
          logOverlay.classList.remove('hidden');
          fetchUserActivityStats();
        }
      }

      function closeLogPanel() {
        if (logPanel && logOverlay) {
          logPanel.classList.add('translate-x-full');
          logOverlay.classList.add('hidden');
        }
      }

      if (userLogBtn) userLogBtn.addEventListener('click', function() {
        if (logPanel && logOverlay) {
          logPanel.classList.remove('translate-x-full');
          logOverlay.classList.remove('hidden');
          fetchUserActivityStats();
        }
      });
      if (closeLogBtn) closeLogBtn.addEventListener('click', function() {
        if (logPanel && logOverlay) {
          logPanel.classList.add('translate-x-full');
          logOverlay.classList.add('hidden');
        }
      });
      if (logOverlay) logOverlay.addEventListener('click', function() {
        if (logPanel && logOverlay) {
          logPanel.classList.add('translate-x-full');
          logOverlay.classList.add('hidden');
        }
      });

      document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape' && logPanel && !logPanel.classList.contains('translate-x-full')) {
          closeLogPanel();
        }
      });
    })();
</script>