<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Historical Data</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
  <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
  <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script>
    tailwind.config = {
        theme: {
            extend: {
                colors: {
                    'background': 'rgb(245, 246, 247)',
                    'foreground': 'rgb(31, 41, 55)',
                    'card': 'rgb(255, 255, 255)',
                    'card-foreground': 'rgb(31, 41, 55)',
                    'primary': 'rgb(15, 61, 126)',
                    'primary-foreground': 'rgb(248, 250, 252)',
                    'primary-100': 'rgb(219, 234, 254)',
                    'primary-50': 'rgb(239, 246, 255)',
                    'primary-25': 'rgb(248, 250, 252)',
                    'secondary': 'rgb(241, 245, 249)',
                    'muted': 'rgb(241, 245, 249)',
                    'muted-foreground': 'rgb(100, 116, 139)',
                    'border': 'rgb(226, 232, 240)',
                    'input': 'rgb(226, 232, 240)',
                    'ring': 'rgb(15, 61, 126)',
                },
                fontFamily: {
                    'body': ['Inter', 'system-ui', 'sans-serif'],
                }
            if (backTrigger) { localStorage.removeItem(BACK_TRIGGER_KEY); }
            }
        }
    }
</script>
<style>
    .date-picker input {
        background: rgba(248, 250, 252, 0.1);
        color: white;
    }
    .date-picker input::placeholder {
        color: rgba(248, 250, 252, 0.7);
    }
    .styled-select {
        background: rgba(248, 250, 252, 0.1);
        color: white;
    }
    .styled-select option {
        color: #1f2937;
        background: white;
    }
    .metrics-dropdown .menu.level2{display:none}
    .metrics-dropdown .menu.level1 .has-sub:hover>.menu.level2{display:block}
    .metrics-trigger{display:flex;align-items:center;gap:.25rem}
    .spinner {
        display: inline-block;
        width: 1.5rem;
        height: 1.5rem;
        border: 3px solid rgba(255, 255, 255, 0.3);
        border-top-color: #fff;
        border-radius: 50%;
        animation: spin 1s ease-in-out infinite;
    }
    @keyframes spin {
        to { transform: rotate(360deg); }
    }
    submenu-item:disabled {
        opacity: 0.5;
        cursor: not-allowed;
        pointer-events: none;
    }
    .highlight {
        background-color: rgb(219, 234, 254) !important;
        font-weight: 600;
    }

	/* Right-align all content inside table body */
	.tablewise tbody td {
	  text-align: right !important;
	}

	/* Left-align first column (Unit/Buyer) in table body */
	.tablewise tbody td:first-child {
	  text-align: left !important;
	}

	/* Right-align all content inside table footer */
	.tablewise tfoot td {
	  text-align: right !important;
	}

	/* Left-align first column in table footer */
	.tablewise tfoot td:first-child {
	  text-align: left !important;
	}

	/* Optional: keep header left-aligned */
	.tablewise thead {
	  text-align: left;
	}

</style>
</head>
<body class="bg-gray-100 font-sans">

        @php
        $empl_no= Session::get('empl_id');
        $empl_name = Session::get('emp_name');
        @endphp

    <nav class="bg-gradient-to-r from-blue-900 via-blue-800 to-blue-900 text-white px-4 py-1.5 shadow-md flex items-center justify-between sticky top-0 z-50 backdrop-blur-md border-b border-blue-700/40">
	  <div class="flex items-center space-x-2">
		<a href="/dashboard"
		  class="inline-flex items-center justify-center rounded-lg border border-white/20 px-2 py-1.5 bg-white/10 hover:bg-white/20 transition-all duration-200">
		  <i class="fa-solid fa-house text-white text-base"></i>
		</a>
		<h1 class="text-base font-semibold leading-tight tracking-wide dashboard_title">
		  Historical Data {{$portal_type}}
		</h1>
	  </div>

	  <div class="flex items-center space-x-2">
		<div id="loadSpinner" class="spinner hidden"></div>

		<!-- Dropdown -->
		<div class="metrics-dropdown relative">
		  <button id="metricsBtn"
			class="metrics-trigger px-3 py-1.5 rounded-md bg-white/10 text-sm border border-white/20 hover:bg-white/20 flex items-center transition-all duration-200"
			data-val="Production:Quantity" data-type="1">
			Quantity <span class="ml-1 text-blue-200 text-xs">▾</span>
		  </button>

		  <!-- Level 1 menu -->
		  <div
			class="menu level1 hidden absolute right-0 mt-1 bg-white text-gray-800 rounded-md shadow-xl border border-gray-200 min-w-[160px] z-[60]">
			<div class="menu-title px-3 py-1.5 border-b text-sm font-semibold bg-gray-50">All Metrics</div>

			<!-- Production -->
			<div class="menu-item has-sub flex items-center justify-between px-3 py-1.5 hover:bg-gray-100 cursor-default text-sm" data-key="Production">
			  <span>Production</span><span class="text-gray-400">›</span>
			  <div class="menu level2 hidden absolute left-full top-8 bg-white rounded-md shadow-xl border border-gray-200 min-w-[150px] z-[70]">
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100" data-val="Production:Quantity" data-type="1">Quantity</button>
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100" data-val="Production:Minutes" data-type="2">Minutes</button>
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100" data-val="Production:Efficiency" data-type="1">Efficiency</button>
			  </div>
			</div>

			<!-- Line Stop -->
			<div class="menu-item has-sub flex items-center justify-between px-3 py-1.5 hover:bg-gray-100 cursor-default text-sm" data-key="Line Stop">
			  <span>Line Stop Mins</span><span class="text-gray-400">›</span>
			  <div class="menu level2 hidden absolute left-full top-10 bg-white rounded-md shadow-xl border border-gray-200 min-w-[150px] z-[70]">
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 line_stop_item" data-val="Line Stop:Minutes" data-type="1">Minutes</button>
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 line_stop_item" data-val="Line Stop:Loss Amount" data-type="2">Loss Amount</button>
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 line_stop_item" disabled>MTBS</button>
			  </div>
			</div>

			<!-- Cutting -->
			<div class="menu-item has-sub flex items-center justify-between px-3 py-1.5 hover:bg-gray-100 cursor-default text-sm" data-key="Cutting">
			  <span>Cutting</span><span class="text-gray-400">›</span>
			  <div class="menu level2 hidden absolute left-full top-12 bg-white rounded-md shadow-xl border border-gray-200 min-w-[150px] z-[70]">
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 cutting_item" data-val="Cutting:Total Cut" data-type="1">Total Cut</button>
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 cutting_item" data-val="Cutting:Fabric Utilization" disabled>Fabric Utilization</button>
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 cutting_item" data-val="Cutting:FTR %" disabled>FTR %</button>
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 cutting_item" data-val="Cutting:Marker Efficiency" disabled>Marker Efficiency</button>
			  </div>
			</div>

			<!-- WIP -->
			<div class="menu-item has-sub flex items-center justify-between px-3 py-1.5 hover:bg-gray-100 cursor-default text-sm" data-key="WIP">
			  <span>WIP</span><span class="text-gray-400">›</span>
			  <div class="menu level2 hidden absolute left-full top-14 bg-white rounded-md shadow-xl border border-gray-200 min-w-[150px] z-[70]">
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 wip_item" data-val="WIP:WIP"  disabled>WIP</button>
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 wip_item" data-val="WIP:WIP Value" disabled>WIP Value</button>
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 wip_item" data-val="WIP:Avg. WIP Age" disabled>Avg. WIP Age</button>
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 wip_item" data-val="WIP:Critical WIP" disabled>Critical WIP</button>
			  </div>
			</div>

			<!-- Labour -->
			<div class="menu-item has-sub flex items-center justify-between px-3 py-1.5 hover:bg-gray-100 cursor-default text-sm" data-key="Labour">
			  <span>Labour</span><span class="text-gray-400">›</span>
			  <div class="menu level2 hidden absolute left-full top-18 bg-white rounded-md shadow-xl border border-gray-200 min-w-[150px] z-[70]">
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 labour_item" data-val="Labour:Strength" disabled>Strength</button>
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 labour_item" data-val="Labour:Absenteeism" disabled>Absenteeism</button>
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 labour_item" data-val="Labour:Attrition" disabled>Attrition</button>
				<button class="submenu-item block w-full text-left px-3 py-1.5 hover:bg-gray-100 labour_item" data-val="Labour:Recruitment" disabled>Recruitment</button>
			  </div>
			</div>
		  </div>
		</div>

		<!-- Date Picker -->
		<div class="date-picker">
		  <input type="text" placeholder="Select date range"
			class="h-8 px-3 rounded-md bg-white/10 text-white border border-white/20 hover:bg-white/20 text-sm cursor-pointer transition-all duration-200 placeholder-blue-200/80 focus:outline-none focus:ring-1 focus:ring-amber-300/50"
			id="dateRangePicker">
		</div>

		<!-- Notification -->
		<button
		  class="inline-flex items-center justify-center rounded-md bg-white/10 text-white border border-white/20 hover:bg-white/20 hover:scale-105 h-8 w-8 transition-all duration-200"
		  id="notificationsBtn">
		  <i class="fa-solid fa-bell text-base text-amber-300"></i>
		</button>
	  </div>
	</nav>

  <div class="px-6 py-3 text-sm text-gray-600 main_breadcrumb">
    <a id="productionBreadcrumb" href="/production_gar_dashboard?fromdate={{$fromdate}}&enddate={{$enddate}}" class="text-blue-700 hover:underline">Production Dashboard</a> 
    <span> &gt; </span>
    <span class="text-gray-500 main_breadcrumb_text portal_type_link"> </span>
    <span> &gt; </span>
    <span class="text-gray-800 font-medium">Historical Data</span>
  </div>
  
  <div class="px-6 grid grid-cols-1 lg:grid-cols-2 gap-6">
    <div class="bg-white px-6 py-2 rounded-lg shadow">
        <div class="flex items-center gap-2">
            <h2 class="text-lg font-semibold bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient ">Unit-wise Performance</h2>
            <p class="text-sm text-gray-500 ">Month-on-month output by production unit.</p>
        </div>    
      <table class="w-full border-collapse text-sm tablewise" >
        <thead>
          <tr class="bg-gray-100">
            <th class="px-2 py-2 text-left">Unit</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="unit" data-month="Apr">Apr</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="unit" data-month="May">May</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="unit" data-month="Jun">Jun</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="unit" data-month="Jul">Jul</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="unit" data-month="Aug">Aug</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="unit" data-month="Sep">Sep</th>
          </tr>
        </thead>
        <tbody>
          <tr><td colspan="7" class="px-4 py-2 text-center">No data available</td></tr>
        </tbody>
      </table>
    </div>
    <div class="bg-white px-6 py-2 rounded-lg shadow">
        <div class="flex items-center gap-2">
            <h2 class="text-lg font-semibold bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Buyer-wise Performance</h2>
            <span id="buyerFilterInfo" class="text-sm font-semibold text-blue-500"></span>
            <p class="text-sm text-gray-500 ">Month-on-month output by buyer.</p>
        </div>    
      <table class="w-full border-collapse text-sm tablewise">
        <thead>
          <tr class="bg-gray-100">
            <th class="px-2 py-2 text-left">Buyer</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="buyer" data-month="Apr">Apr</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="buyer" data-month="May">May</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="buyer" data-month="Jun">Jun</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="buyer" data-month="Jul">Jul</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="buyer" data-month="Aug">Aug</th>
            <th class="px-2 py-2 month-header cursor-pointer" data-type="buyer" data-month="Sep">Sep</th>
          </tr>
        </thead>
        <tbody>
          <tr><td colspan="7" class="px-4 py-2 text-center">No data available</td></tr>
        </tbody>
      </table>
    </div>
  </div>
  <div class="px-6 py-4">
    <div class="bg-white px-6 py-2 rounded-lg shadow">
        <div class="flex items-center gap-2">
            <h2 id="drilldownTitle" class="text-lg font-semibold bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">Daily Performance table</h2>
            <p class="text-sm text-gray-500 ">Showing daily output values. Click a cell to navigate to that day's overview.</p>
        </div>    
      <div class="overflow-x-auto">
        <table id="drilldownTable" class="w-full border-collapse text-sm ">
          <tr><td colspan="100" class="px-4 py-2 text-center">No data available</td></tr>
        </table>
      </div>
    </div>
  </div>
  <div class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden" id="notificationOverlay">
    <div class="fixed right-0 top-0 h-full w-80 bg-white shadow-lg transform translate-x-full transition-transform duration-300" id="notificationPanel">
      <div class="p-6 border-b border-border">
        <div class="flex items-center justify-between">
          <h2 class="text-lg font-semibold">Production Alerts</h2>
          <button class="text-muted-foreground hover:text-foreground" id="closeNotifications">
            <i class="fa-solid fa-xmark h-5 w-5"></i>
          </button>
        </div>
      </div>
      <div class="p-6">
        <p class="text-muted-foreground">No new alerts at this time.</p>
      </div>
    </div>
  </div>
<script>
    let apiData = {};
    let selectedMetric = "Production:Quantity";
    let selectedType = "1";
    // Control whether to restore a previously saved selection from localStorage
    let shouldRestoreSelection = false; // Do not restore on initial load
    let hasInitialLoadCompleted = false; // flip after first data load
    // Active Buyer table filter context (set when unit/month filter is applied on Buyer table)
    let currentBuyerFilterUnit = null; // e.g., 'G-I'
    let currentBuyerFilterMonth = null; // e.g., 'Jul'
    const portal_type = "{{$portal_type}}" || "Production";
    // Persist selection across visits
    const STORAGE_KEY = 'history_dash_selection_v2';
    const BACK_TRIGGER_KEY = 'history_back_trigger_v2';
    const HISTORY_URL_KEY = 'history_last_url_v2';

    function saveSelection(payload = {}) {
    try {
        // Get metric category from the selected metric or payload
        const metricCategory = (payload.metric || selectedMetric || '').split(':')[0] || '';
        
        // Map metric category to portal type
        const metricToPortalType = {
        'Production': 'Production',
        'WIP': 'WIP',
        'Line Stop': 'LineStop',
        'Cutting': 'Cutting',
        'Labour': 'HR'
        };
        
        const portal = metricToPortalType[metricCategory] || portal_type || 'Production';
        
        const sel = {
        portal: portal,
        metric: payload.metric || selectedMetric || '',
        mode: payload.mode || '', // 'cell' | 'month'
        type: payload.type || '', // 'unit' | 'buyer'
        name: payload.name || null,
        month: payload.month || null,
        unitContext: payload.unitContext || null,
        savedAt: Date.now(),
        };
        localStorage.setItem(STORAGE_KEY, JSON.stringify(sel));
        console.log("Selection saved:", sel);
    } catch (e) { 
        console.error("Error saving selection:", e);
    }
    }
    
    function getStoredSelection() {
      try {
        const raw = localStorage.getItem(STORAGE_KEY);
        if (!raw) return null;
        const obj = JSON.parse(raw);
        if (!obj || obj.portal !== (portal_type || '')) return null;
        console.log("Stored selection:", obj);
        return obj;
      } catch { return null; }
    }
    const apiRoutes = {
      'Production:Quantity': '/productionhistoricaldata',
      'Production:Minutes': '/productionhistoricaldata',
      'Production:Efficiency': '/productionhistoricaldata',
      'WIP:WIP': '/wip_historicaldata',
      'WIP:WIP Value': '/wip_value_historicaldata',
      'WIP:Avg. WIP Age': '/avg_wip_age_historicaldata',
      'WIP:Critical WIP': '/critical_wip_historicaldata',
      'Line Stop:Minutes': '/production_minis_historicaldata',
      'Line Stop:Loss Amount': '/production_minis_historicaldata',
      'Line Stop:MTBS': '/mtbs_historicaldata',
      'Cutting:Total Cut': '/production_cutting_historicaldata',
      'Cutting:Fabric Utilization': '/production_cutting_historicaldata',
      'Cutting:FTR %': '/production_cutting_historicaldata',
      'Cutting:Marker Efficiency': '/production_cutting_historicaldata',
      'Labour:Strength': '/strength_historicaldata',
      'Labour:Absenteeism': '/absenteeism_historicaldata',
      'Labour:Attrition': '/attrition_historicaldata',
      'Labour:Recruitment': '/recruitment_historicaldata'
    };
    function fetchData(type = "", fromDate = "", toDate = "", portal_type = "", metric = "Production:Quantity") {
        console.log(portal_type);
      const apiUrl = apiRoutes[metric];
      if (!apiUrl) {
        $("#loadSpinner").hide();
        console.warn(`No API route available for metric: ${metric}`);
        return;
      }
      const isInitialLoad = !hasInitialLoadCompleted;
      const unitTable = $('table').eq(0);
      unitTable.find('thead').html('<tr class="bg-gray-100"><th class="px-2 py-2 text-left">Unit</th></tr>');
      unitTable.find('tbody').html('<tr><td colspan="1" class="px-4 py-2 text-center">No data available</td></tr>');
      unitTable.find('tfoot').remove();
      const buyerTable = $('table').eq(1);
      buyerTable.find('thead').html('<tr class="bg-gray-100"><th class="px-2 py-2 text-left">Buyer</th></tr>');
      buyerTable.find('tbody').html('<tr><td colspan="1" class="px-4 py-2 text-center">No data available</td></tr>');
      buyerTable.find('tfoot').remove();
      $('#buyerFilterInfo').text('');
      // Clear active Buyer filter context on fresh data load
      currentBuyerFilterUnit = null;
      currentBuyerFilterMonth = null;
      $("#drilldownTable").html('<tr><td colspan="100" class="px-4 py-2 text-center">No data available</td></tr>');
      $("#drilldownTitle").text('Daily Performance table');
      $('.drilldown, .month-header').removeClass('highlight');
      $("#loadSpinner").show();
      
      $.ajax({
        url: apiUrl,
        method: 'GET',
        data: { type: type, fromdate: fromDate, enddate: toDate, empid: "{{ Session('empl_id') }}"  },
        success: function(response) {
          $("#loadSpinner").hide();
          if (response && response.success && response.data) {
            apiData = response.data;
            updateTables(apiData, fromDate, toDate, metric);
            
            // Only restore selection on initial load or back navigation
            const backTrigger = localStorage.getItem(BACK_TRIGGER_KEY) === '1';
            const stored = backTrigger ? getStoredSelection() : null;

             // Add this before the restoration check
            console.log("Restoration check:", {
            isInitialLoad,
            backTrigger,
            stored: !!stored,
            hasMonth: stored ? !!stored.month : false,
            storedValue: stored
            });
            
            if (isInitialLoad && backTrigger && stored && stored.month) {
              $('.drilldown, .month-header').removeClass('highlight');
              if (stored.type === 'unit') {
                if (stored.mode === 'cell') {
                  // Recreate buyer filter table for this unit/month
                  updateBuyerTableFilter(stored.month, stored.name);
                  const $cell = $(`.drilldown[data-type="unit"][data-name="${stored.name}"][data-month="${stored.month}"]`).first();
                  if ($cell.length) {
                    $cell.addClass('highlight');
                    updateDrilldownTable('unit', stored.name, stored.month, false, null);
                  }
                } else if (stored.mode === 'month') {
                  const $hdr = $(`.month-header[data-type="unit"][data-month="${stored.month}"]`).first();
                  if ($hdr.length) {
                    $hdr.addClass('highlight');
                    // Also refresh buyer table for the selected month (no unit filter)
                    updateBuyerTableFilter(stored.month, null);
                    updateDrilldownTable('unit', null, stored.month, true, null);
                  }
                }
              } else if (stored.type === 'buyer') {
                if (stored.mode === 'cell') {
                  // If last click was a buyer cell under a unit filter, restore that buyer table filter first
                  if (stored.unitContext) updateBuyerTableFilter(stored.month, stored.unitContext);
                  const $cell = $(`.drilldown[data-type="buyer"][data-name="${stored.name}"][data-month="${stored.month}"]`).first();
                  if ($cell.length) {
                    $cell.addClass('highlight');
                    updateDrilldownTable('buyer', stored.name, stored.month, false, stored.unitContext || null);
                  }
                } else if (stored.mode === 'month') {
                  if (stored.unitContext) updateBuyerTableFilter(stored.month, stored.unitContext);
                  const $hdr = $(`.month-header[data-type="buyer"][data-month="${stored.month}"]`).first();
                  if ($hdr.length) {
                    $hdr.addClass('highlight');
                    updateDrilldownTable('buyer', null, stored.month, true, stored.unitContext || null);
                  }
                }
              }
            }
            
            // After the first successful load, mark as complete
            if (!hasInitialLoadCompleted) {
              hasInitialLoadCompleted = true;
              // Only enable selection restoration for back navigation, not for metric changes
              shouldRestoreSelection = backTrigger;
            }
          } else {
            console.warn("Invalid API response, resetting data");
            apiData = {};
          }
        },
        error: function() {
          $("#loadSpinner").hide();
          console.error("Error fetching data from", apiUrl);
          apiData = {};
        }
      });
    }

function updateTables(data, fromDate, toDate, metric) {
    const start = fromDate ? moment(fromDate, 'YYYY-MM-DD') : moment().subtract(5, 'months').startOf('month');
    const end = toDate ? moment(toDate, 'YYYY-MM-DD') : moment();
    const months = [];
    for (let m = moment(start); m.isSameOrBefore(end); m.add(1, 'month')) {
        months.push(m.format('MMM'));
    }

    // Unit table
    let unitMonthlyTotals = {};
    let unitTotals = {};
    months.forEach(month => unitMonthlyTotals[month] = 0);
    const units = [...new Set(data.map(item => item.units.map(u => u.Unit)).flat())];
    units.forEach(unit => unitTotals[unit] = 0);

    data.forEach(monthData => {
        const month = monthData.Mon_Name.slice(0, 3);
        if (months.includes(month)) {
            monthData.units.forEach(unit => {
                const total = unit.buyers.reduce((sum, b) => sum + b.buyer_total_Audit_Qty, 0);
                unitMonthlyTotals[month] += total;
                unitTotals[unit.Unit] += total;
            });
        }
    });

    let unitTableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-left">Unit</th>`;
    months.forEach(month => {
        unitTableHTML += `<th class="px-2 py-2 month-header cursor-pointer text-right" data-type="unit" data-month="${month}">${month}</th>`;
    });
    unitTableHTML += `<th class="px-2 py-2 text-right">Total</th></tr></thead><tbody>`;
    if (units.length === 0) {
        unitTableHTML += `<tr><td colspan="${months.length + 2}" class="px-4 py-2 text-center">No data available</td></tr>`;
    } else {
        units.forEach(unit => {
            unitTableHTML += `<tr class="border-t"><td class="px-2 py-2">${unit}</td>`;
            months.forEach(month => {
                const monthData = data.find(d => d.Mon_Name.startsWith(month));
                const unitData = monthData?.units.find(u => u.Unit === unit);
                const total = unitData ? unitData.buyers.reduce((sum, b) => sum + b.buyer_total_Audit_Qty, 0) : 0;
                unitTableHTML += `<td class="px-2 py-2 drilldown cursor-pointer text-left" data-type="unit" data-name="${unit}" data-month="${month}">${total.toLocaleString()}</td>`;
            });
            unitTableHTML += `<td class="px-2 py-2 text-right font-semibold">${unitTotals[unit].toLocaleString()}</td>`;
            unitTableHTML += `</tr>`;
        });
    }
    unitTableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-left">Total</td>`;
    months.forEach(month => {
        unitTableHTML += `<td class="px-2 py-2 text-right">${unitMonthlyTotals[month].toLocaleString()}</td>`;
    });
    unitTableHTML += `<td class="px-2 py-2 text-right">${Object.values(unitMonthlyTotals).reduce((sum, val) => sum + val, 0).toLocaleString()}</td>`;
    unitTableHTML += `</tr></tfoot>`;
    $('table').eq(0).html(unitTableHTML);

    // Buyer table
    let buyerMonthlyTotals = {};
    let buyerTotals = {};
    months.forEach(month => buyerMonthlyTotals[month] = 0);
    const buyers = [...new Set(data.map(item => item.units.map(u => u.buyers.map(b => b.Buyer)).flat()).flat())];
    buyers.forEach(buyer => buyerTotals[buyer] = 0);

    data.forEach(monthData => {
        const month = monthData.Mon_Name.slice(0, 3);
        if (months.includes(month)) {
            monthData.units.forEach(unit => {
                unit.buyers.forEach(buyer => {
                    buyerMonthlyTotals[month] += buyer.buyer_total_Audit_Qty;
                    buyerTotals[buyer.Buyer] += buyer.buyer_total_Audit_Qty;
                });
            });
        }
    });

    let buyerTableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-left">Buyer</th>`;
    months.forEach(month => {
        buyerTableHTML += `<th class="px-2 py-2 month-header  text-right cursor-pointer" data-type="buyer" data-month="${month}">${month}</th>`;
    });
    buyerTableHTML += `<th class="px-2 py-2 text-right">Total</th></tr></thead><tbody>`;
    if (buyers.length === 0) {
        buyerTableHTML += `<tr><td colspan="${months.length + 2}" class="px-2 py-2 text-center">No data available</td></tr>`;
    } else {
        buyers.forEach(buyer => {
            let buyername = buyer;
            if (buyername) {
                buyername = `${buyername.slice(0, 6)}`;
            }
            buyerTableHTML += `<tr class="border-t"><td class="px-2 py-2" title="${buyer}">${buyername}</td>`;
            months.forEach(month => {
                const monthData = data.find(d => d.Mon_Name.startsWith(month));
                let total = 0;
                if (monthData) {
                    monthData.units.forEach(unit => {
                        const buyerData = unit.buyers.find(b => b.Buyer === buyer);
                        if (buyerData) total += buyerData.buyer_total_Audit_Qty;
                    });
                }
                buyerTableHTML += `<td class="px-2 py-2 drilldown cursor-pointer text-left" data-type="buyer" data-name="${buyer}" data-month="${month}">${total.toLocaleString()}</td>`;
            });
            buyerTableHTML += `<td class="px-2 py-2 text-right font-semibold">${buyerTotals[buyer].toLocaleString()}</td>`;
            buyerTableHTML += `</tr>`;
        });
    }
    buyerTableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-left">Total</td>`;
    months.forEach(month => {
        buyerTableHTML += `<td class="px-2 py-2 text-right">${buyerMonthlyTotals[month].toLocaleString()}</td>`;
    });
    buyerTableHTML += `<td class="px-2 py-2 text-right">${Object.values(buyerMonthlyTotals).reduce((sum, val) => sum + val, 0).toLocaleString()}</td>`;
    buyerTableHTML += `</tr></tfoot>`;
    $('table').eq(1).html(buyerTableHTML);

    // No initial drilldown selection; keep empty until user clicks
}

function updateBuyerTableFilter(month, unitName = null) {
    const monthData = apiData.find(d => d.Mon_Name.startsWith(month));
    // Get current 6 months from Unit table header to keep consistent columns
    const months = $('table').eq(0).find('thead th.month-header').map(function(){return $(this).data('month');}).get();
    // Aggregate buyer totals for the selected month (optionally by unit)
    let buyerSelectedMonthTotals = {};
    if (monthData) {
        if (unitName) {
            const unitData = monthData.units.find(u => u.Unit === unitName);
            if (unitData) {
                unitData.buyers.forEach(b => {
                    const key = b.Buyer;
                    const val = b.buyer_total_Audit_Qty || 0;
                    buyerSelectedMonthTotals[key] = (buyerSelectedMonthTotals[key] || 0) + val;
                });
            }
        } else {
            monthData.units.forEach(u => {
                u.buyers.forEach(b => {
                    const key = b.Buyer;
                    const val = b.buyer_total_Audit_Qty || 0;
                    buyerSelectedMonthTotals[key] = (buyerSelectedMonthTotals[key] || 0) + val;
                });
            });
        }
    }

    const buyers = Object.keys(buyerSelectedMonthTotals);
    // Header: keep all months
    let buyerTableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-left">Buyer</th>`;
    months.forEach(m => {
        buyerTableHTML += `<th class="px-2 py-2 month-header  text-right cursor-pointer" data-type="buyer" data-month="${m}">${m}</th>`;
    });
    buyerTableHTML += `<th class="px-2 py-2 text-right">Total</th></tr></thead><tbody>`;

    if (buyers.length === 0) {
        buyerTableHTML += `<tr><td colspan="${months.length + 2}" class="px-2 py-2 text-center">No data available</td></tr>`;
    } else {
        buyers.forEach(buyer => {
            let buyername = buyer;
            if (buyername) {
                buyername = `${buyername.slice(0, 6)}`;
            }
            buyerTableHTML += `<tr class="border-t"><td class="px-2 py-2" title="${buyer}">${buyername}</td>`;
            months.forEach(m => {
                if (m === month) {
                    const val = buyerSelectedMonthTotals[buyer] || 0;
                    buyerTableHTML += `<td class="px-2 py-2 drilldown cursor-pointer text-left" data-type="buyer" data-name="${buyer}" data-month="${m}">${val.toLocaleString()}</td>`;
                } else {
                    buyerTableHTML += `<td class="px-2 py-2 text-left">-</td>`;
                }
            });
            const total = buyerSelectedMonthTotals[buyer] || 0;
            buyerTableHTML += `<td class="px-2 py-2 text-right font-semibold">${total.toLocaleString()}</td>`;
            buyerTableHTML += `</tr>`;
        });
    }

    // Footer: '-' for non-selected months; total only for selected month and overall
    const grandTotal = Object.values(buyerSelectedMonthTotals).reduce((sum, v) => sum + v, 0);
    buyerTableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-left">Total</td>`;
    months.forEach(m => {
        if (m === month) {
            buyerTableHTML += `<td class="px-2 py-2 text-right">${grandTotal.toLocaleString()}</td>`;
        } else {
            buyerTableHTML += `<td class="px-2 py-2 text-right">-</td>`;
        }
    });
    buyerTableHTML += `<td class="px-2 py-2 text-right">${grandTotal.toLocaleString()}</td>`;
    buyerTableHTML += `</tr></tfoot>`;
    $('table').eq(1).html(buyerTableHTML);

    // Set info label next to Buyer title
    if (unitName) {
        $('#buyerFilterInfo').text(`| Unit: ${unitName} | Month: ${month} |`);
        currentBuyerFilterUnit = unitName;
        currentBuyerFilterMonth = month;
    } else {
        $('#buyerFilterInfo').text(`| Month: ${month} |`);
        currentBuyerFilterUnit = null;
        currentBuyerFilterMonth = month;
    }
}

function updateDrilldownTable(type, name, month, isMonthHeader = false, unitContext = null) {
    const monthData = apiData.find(d => d.Mon_Name.startsWith(month));
    if (!monthData) {
        $("#drilldownTable").html('<tr><td colspan="100" class="px-4 py-2 text-center">No data available</td></tr>');
        $("#drilldownTitle").text('Daily Performance table');
        return;
    }

    let daysSet = new Set();
    monthData.units.forEach(unit => {
        unit.buyers.forEach(buyer => {
            if (buyer.lines) {
                buyer.lines.forEach(line => {
                    line.data.forEach(item => {
                        const day = moment(item.User_Date).date();
                        daysSet.add(day);
                    });
                });
            } else if (buyer.data) {
                buyer.data.forEach(item => {
                    const day = moment(item.User_Date).date();
                    daysSet.add(day);
                });
            }
        });
    });
    let days = Array.from(daysSet).sort((a, b) => a - b);

    if (isMonthHeader) {
        // Special handling: if Buyer header clicked while a Unit is filtered, show buyers for that unit only
        if (type === 'buyer' && unitContext) {
            const entityType = 'Buyer';
            $("#drilldownTitle").text(`Daily Performance for All ${entityType}s in ${month} (Unit: ${unitContext})`);
            let unitData = monthData.units.find(u => u.Unit === unitContext);
            let entities = unitData ? [...new Set(unitData.buyers.map(b => b.Buyer))] : [];
            let tableData = {};
            let dailyTotals = {};
            let entityTotals = {};
            days.forEach(day => dailyTotals[day] = 0);
            entities.forEach(entity => {
                tableData[entity] = {};
                entityTotals[entity] = 0;
                days.forEach(day => tableData[entity][day] = 0);
            });

            if (unitData) {
                unitData.buyers.forEach(buyer => {
                    if (buyer.lines) {
                        buyer.lines.forEach(line => {
                            line.data.forEach(item => {
                                const day = moment(item.User_Date).date();
                                const qty = parseInt(item.Qty) || 0;
                                const entity = buyer.Buyer;
                                tableData[entity][day] += qty;
                                dailyTotals[day] += qty;
                                entityTotals[entity] += qty;
                            });
                        });
                    } else if (buyer.data) {
                        buyer.data.forEach(item => {
                            const day = moment(item.User_Date).date();
                            const qty = parseInt(item.Qty) || 0;
                            const entity = buyer.Buyer;
                            tableData[entity][day] += qty;
                            dailyTotals[day] += qty;
                            entityTotals[entity] += qty;
                        });
                    }
                });
            }

            let tableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-left">${entityType}</th>`;
            days.forEach(day => { tableHTML += `<th class="px-2 py-2 text-right">${day}</th>`; });
            tableHTML += `<th class="px-2 py-2 text-right">Total</th></tr></thead><tbody>`;
            if (entities.length === 0) {
                tableHTML += `<tr><td colspan="${days.length + 2}" class="px-2 py-2 text-center">No data available</td></tr>`;
            } else {
                entities.forEach(entity => {
                    let entityname = entity;
                    if (entityname) {
                        entityname = `${entityname.slice(0, 6)}`;
                        tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left" title="${entity}">${entityname}</td>`;
                    } else {
                        tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left">${entityname}</td>`;
                    }
                    // Infer year from any sample date in this month
                    let inferredYear = null;
                    if (!inferredYear) {
                        const u0 = monthData.units?.[0];
                        let sampleDate = null;
                        if (u0?.buyers?.[0]?.data?.[0]) sampleDate = u0.buyers[0].data[0].User_Date;
                        else if (u0?.buyers?.[0]?.lines?.[0]?.data?.[0]) sampleDate = u0.buyers[0].lines[0].data[0].User_Date;
                        if (sampleDate) inferredYear = moment(sampleDate).year();
                    }
                    days.forEach(day => {
                        const value = tableData[entity][day] || 0;
                        const clickable = value > 0;
                        const cls = `px-2 py-2 text-right ${clickable ? 'day-cell clickable text-blue-700 hover:underline' : ''}`;
                        tableHTML += `<td class="${cls}" data-day="${day}" data-month="${month}" data-year="${inferredYear || moment().year()}">${value.toLocaleString()}</td>`;
                    });
                    tableHTML += `<td class="px-2 py-2 text-right font-semibold">${entityTotals[entity].toLocaleString()}</td>`;
                    tableHTML += `</tr>`;
                });
            }
            tableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-right">Total</td>`;
            days.forEach(day => { tableHTML += `<td class="px-2 py-2 text-right">${dailyTotals[day].toLocaleString()}</td>`; });
            tableHTML += `<td class="px-2 py-2 text-right">${Object.values(dailyTotals).reduce((sum, val) => sum + val, 0).toLocaleString()}</td>`;
            tableHTML += `</tr></tfoot>`;
            $("#drilldownTable").html(tableHTML);
            return;
        }

        const entityType = type === 'unit' ? 'Unit' : 'Buyer';
        $("#drilldownTitle").text(`Daily Performance for All ${entityType}s in ${month}`);
        let entities = type === 'unit' ? [...new Set(monthData.units.map(u => u.Unit))] : 
                      [...new Set(monthData.units.flatMap(u => u.buyers.map(b => b.Buyer)))];
        let tableData = {};
        let dailyTotals = {};
        let entityTotals = {};
        days.forEach(day => dailyTotals[day] = 0);
        entities.forEach(entity => {
            tableData[entity] = {};
            entityTotals[entity] = 0;
            days.forEach(day => tableData[entity][day] = 0);
        });

        monthData.units.forEach(unit => {
            unit.buyers.forEach(buyer => {
                if (buyer.lines) {
                    buyer.lines.forEach(line => {
                        line.data.forEach(item => {
                            const day = moment(item.User_Date).date();
                            const qty = parseInt(item.Qty) || 0;
                            const entity = type === 'unit' ? unit.Unit : buyer.Buyer;
                            tableData[entity][day] += qty;
                            dailyTotals[day] += qty;
                            entityTotals[entity] += qty;
                        });
                    });
                } else if (buyer.data) {
                    buyer.data.forEach(item => {
                        const day = moment(item.User_Date).date();
                        const qty = parseInt(item.Qty) || 0;
                        const entity = type === 'unit' ? unit.Unit : buyer.Buyer;
                        tableData[entity][day] += qty;
                        dailyTotals[day] += qty;
                        entityTotals[entity] += qty;
                    });
                }
            });
        });

        let tableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-right">${entityType}</th>`;
        days.forEach(day => {
            tableHTML += `<th class="px-2 py-2 text-right">${day}</th>`;
        });
        tableHTML += `<th class="px-2 py-2 text-right">Total</th></tr></thead><tbody>`;
        if (entities.length === 0) {
            tableHTML += `<tr><td colspan="${days.length + 2}" class="px-2 py-2 text-center">No data available</td></tr>`;
        } else {
            entities.forEach(entity => {
                let entityname = entity;
                if (entityname && type === 'buyer') {
                    entityname = `${entityname.slice(0, 6)}`;
                    tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left" title="${entity}">${entityname}</td>`;
                } else {
                    tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left">${entityname}</td>`;
                }
                // Infer year for this month
                let inferredYear = null;
                if (!inferredYear) {
                    const u0 = monthData.units?.[0];
                    let sampleDate = null;
                    if (u0?.buyers?.[0]?.data?.[0]) sampleDate = u0.buyers[0].data[0].User_Date;
                    else if (u0?.buyers?.[0]?.lines?.[0]?.data?.[0]) sampleDate = u0.buyers[0].lines[0].data[0].User_Date;
                    if (sampleDate) inferredYear = moment(sampleDate).year();
                }
                days.forEach(day => {
                    const value = tableData[entity][day] || 0;
                    const clickable = value > 0;
                    const cls = `px-2 py-2 text-right ${clickable ? 'day-cell clickable text-blue-700 hover:underline' : ''}`;
                    tableHTML += `<td class="${cls}" data-day="${day}" data-month="${month}" data-year="${inferredYear || moment().year()}">${value.toLocaleString()}</td>`;
                });
                tableHTML += `<td class="px-2 py-2 text-right font-semibold">${entityTotals[entity].toLocaleString()}</td>`;
                tableHTML += `</tr>`;
            });
        }
        tableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-right">Total</td>`;
        days.forEach(day => {
            tableHTML += `<td class="px-2 py-2 text-right">${dailyTotals[day].toLocaleString()}</td>`;
        });
        tableHTML += `<td class="px-2 py-2 text-right">${Object.values(dailyTotals).reduce((sum, val) => sum + val, 0).toLocaleString()}</td>`;
        tableHTML += `</tr></tfoot>`;
        $("#drilldownTable").html(tableHTML);
    } else {
        const entityType = type === 'unit' ? 'Unit' : 'Buyer';
        const isCuttingMetric = selectedMetric.startsWith('Cutting');
        const titlePrefix = type === 'unit' ? (isCuttingMetric ? 'Buyer-wise' : 'Line-wise') : (isCuttingMetric ? 'Order-wise' : 'OCN-wise');
        $("#drilldownTitle").text(`${titlePrefix} Daily Performance for ${entityType} ${name} in ${month}`);

        if (type === 'unit') {
            const isCuttingMetric = selectedMetric.startsWith('Cutting');
            let entitiesSet = new Set();
            let tableData = {};
            let dailyTotals = {};
            let entityTotals = {};
            days.forEach(day => dailyTotals[day] = 0);
            const unitData = monthData.units.find(u => u.Unit === name);
            
            if (unitData) {
                unitData.buyers.forEach(buyer => {
                    if (isCuttingMetric && buyer.data) {
                        // Material type-wise data for Cutting metrics
                        buyer.data.forEach(item => {
                            const materialType = item.Machine_type || 'Unknown'; // Adjust field name as per your API
                            entitiesSet.add(materialType);
                            const day = moment(item.User_Date).date();
                            const qty = parseInt(item.Qty) || 0;
                            if (!tableData[materialType]) tableData[materialType] = {};
                            if (!tableData[materialType][day]) tableData[materialType][day] = 0;
                            if (!entityTotals[materialType]) entityTotals[materialType] = 0;
                            tableData[materialType][day] += qty;
                            dailyTotals[day] += qty;
                            entityTotals[materialType] += qty;
                        });
                    } else if (buyer.lines) {
                        // Line-wise data for non-Cutting metrics
                        buyer.lines.forEach(line => {
                            const lineNo = line.Line_No;
                            entitiesSet.add(lineNo);
                            line.data.forEach(item => {
                                const day = moment(item.User_Date).date();
                                const qty = parseInt(item.Qty) || 0;
                                if (!tableData[lineNo]) tableData[lineNo] = {};
                                if (!tableData[lineNo][day]) tableData[lineNo][day] = 0;
                                if (!entityTotals[lineNo]) entityTotals[lineNo] = 0;
                                tableData[lineNo][day] += qty;
                                dailyTotals[day] += qty;
                                entityTotals[lineNo] += qty;
                            });
                        });
                    } else if (buyer.data) {
                        // Fallback for buyer data without lines (non-Cutting metrics)
                        const buyerName = buyer.Buyer;
                        entitiesSet.add(buyerName);
                        buyer.data.forEach(item => {
                            const day = moment(item.User_Date).date();
                            const qty = parseInt(item.Qty) || 0;
                            if (!tableData[buyerName]) tableData[buyerName] = {};
                            if (!tableData[buyerName][day]) tableData[buyerName][day] = 0;
                            if (!entityTotals[buyerName]) entityTotals[buyerName] = 0;
                            tableData[buyerName][day] += qty;
                            dailyTotals[day] += qty;
                            entityTotals[buyerName] += qty;
                        });
                    }
                });
            }

            let entities = Array.from(entitiesSet).sort((a, b) => a.localeCompare(b, undefined, { numeric: true }));
            let tableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-left">${isCuttingMetric ? 'Machine Type' : 'Line'}</th>`;
            days.forEach(day => {
                tableHTML += `<th class="px-2 py-2 text-right">${day}</th>`;
            });
            tableHTML += `<th class="px-2 py-2 text-right">Total</th></tr></thead><tbody>`;
            if (entities.length === 0) {
                tableHTML += `<tr><td colspan="${days.length + 2}" class="px-2 py-2 text-center">No data available</td></tr>`;
            } else {
                entities.forEach(entity => {
                    let entityName = entity;
                    if (isCuttingMetric) {
                        entityName = `${entityName.slice(0, 6)}`;
                        tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left" title="${entity}">${entityName}</td>`;
                    } else {
                        tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left">${entityName}</td>`;
                    }
                    days.forEach(day => {
                        const value = tableData[entity]?.[day] || 0;
                        const clickable = value > 0;
                        const cls = `px-2 py-2 text-right ${clickable ? 'day-cell clickable text-blue-700 hover:underline' : ''}`;
                        tableHTML += `<td class="${cls}" data-day="${day}" data-month="${month}" data-year="${moment().year()}">${value.toLocaleString()}</td>`;
                    });
                    tableHTML += `<td class="px-2 py-2 text-right font-semibold">${entityTotals[entity].toLocaleString()}</td>`;
                    tableHTML += `</tr>`;
                });
            }
            tableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-right">Total</td>`;
            days.forEach(day => {
                tableHTML += `<td class="px-2 py-2 text-right">${dailyTotals[day].toLocaleString()}</td>`;
            });
            tableHTML += `<td class="px-2 py-2 text-right">${Object.values(dailyTotals).reduce((sum, val) => sum + val, 0).toLocaleString()}</td>`;
            tableHTML += `</tr></tfoot>`;
            $("#drilldownTable").html(tableHTML);
        } 
		  else {
            let ocnsSet = new Set();
            let tableData = {};
            let dailyTotals = {};
            let ocnTotals = {};
            days.forEach(day => dailyTotals[day] = 0);
            monthData.units.forEach(unit => {
                if (unitContext && unit.Unit !== unitContext) return; // restrict to selected unit when provided
                const buyerData = unit.buyers.find(b => b.Buyer === name);
                if (buyerData) {
                    if (buyerData.lines) {
                        buyerData.lines.forEach(line => {
                            line.data.forEach(item => {
                                const ocn = item.Order_No || 'Unknown';
                                ocnsSet.add(ocn);
                                const day = moment(item.User_Date).date();
                                const qty = parseInt(item.Qty) || 0;
                                if (!tableData[ocn]) tableData[ocn] = {};
                                if (!tableData[ocn][day]) tableData[ocn][day] = 0;
                                if (!ocnTotals[ocn]) ocnTotals[ocn] = 0;
                                tableData[ocn][day] += qty;
                                dailyTotals[day] += qty;
                                ocnTotals[ocn] += qty;
                            });
                        });
                    } else if (buyerData.data) {
                        buyerData.data.forEach(item => {
                            const ocn = item.Order_No || 'Unknown';
                            ocnsSet.add(ocn);
                            const day = moment(item.User_Date).date();
                            const qty = parseInt(item.Qty) || 0;
                            if (!tableData[ocn]) tableData[ocn] = {};
                            if (!tableData[ocn][day]) tableData[ocn][day] = 0;
                            if (!ocnTotals[ocn]) ocnTotals[ocn] = 0;
                            tableData[ocn][day] += qty;
                            dailyTotals[day] += qty;
                            ocnTotals[ocn] += qty;
                        });
                    }
                }
            });

            let ocns = Array.from(ocnsSet).sort((a, b) => a.localeCompare(b, undefined, { numeric: true }));
            let tableHTML = `<thead><tr class="bg-gray-100"><th class="px-2 py-2 text-left">${isCuttingMetric ? 'Order' : 'OCN'}</th>`;
            days.forEach(day => {
                tableHTML += `<th class="px-2 py-2 text-right">${day}</th>`;
            });
            tableHTML += `<th class="px-2 py-2 text-right">Total</th></tr></thead><tbody>`;
            if (ocns.length === 0) {
                tableHTML += `<tr><td colspan="${days.length + 2}" class="px-2 py-2 text-center">No data available</td></tr>`;
            } else {
                ocns.forEach(ocn => {
                    tableHTML += `<tr class="border-t"><td class="px-2 py-2 text-left">${ocn.slice(-4)}</td>`;
                    // Infer year for this month
                    let inferredYear = null;
                    if (!inferredYear) {
                        const u0 = monthData.units?.[0];
                        let sampleDate = null;
                        if (u0?.buyers?.[0]?.data?.[0]) sampleDate = u0.buyers[0].data[0].User_Date;
                        else if (u0?.buyers?.[0]?.lines?.[0]?.data?.[0]) sampleDate = u0.buyers[0].lines[0].data[0].User_Date;
                        if (sampleDate) inferredYear = moment(sampleDate).year();
                    }
                    days.forEach(day => {
                        const value = tableData[ocn]?.[day] || 0;
                        const clickable = value > 0;
                        const cls = `px-2 py-2 text-right ${clickable ? 'day-cell clickable text-blue-700 hover:underline' : ''}`;
                        // carry buyer name (from 'name') and optional unitContext if available globally
                        const buyerName = name || '';
                        const unitCtx = (typeof currentBuyerFilterUnit !== 'undefined' && currentBuyerFilterUnit) ? currentBuyerFilterUnit : '';
                        tableHTML += `<td class="${cls}" data-day="${day}" data-month="${month}" data-year="${inferredYear || moment().year()}" data-buyer="${buyerName}" data-ocn="${ocn}" data-unit="${unitCtx}">${value.toLocaleString()}</td>`;
                    });
                    tableHTML += `<td class="px-2 py-2 text-right font-semibold">${ocnTotals[ocn].toLocaleString()}</td>`;
                    tableHTML += `</tr>`;
                });
            }
            tableHTML += `</tbody><tfoot><tr class="bg-gray-200 font-semibold"><td class="px-2 py-2 text-left">Total</td>`;
            days.forEach(day => {
                tableHTML += `<td class="px-2 py-2 text-right">${dailyTotals[day].toLocaleString()}</td>`;
            });
            tableHTML += `<td class="px-2 py-2 text-right">${Object.values(dailyTotals).reduce((sum, val) => sum + val, 0).toLocaleString()}</td>`;
            tableHTML += `</tr></tfoot>`;
            $("#drilldownTable").html(tableHTML);
        }
    }
}

$(document).ready(function() {
   

    const $menuL1 = $(".metrics-dropdown .menu.level1");
    const $btn = $("#metricsBtn");
    $btn.on('click', function(e) {
        e.stopPropagation();
        $menuL1.toggleClass('hidden');
    });
    $(document).on('click', function() {
        $menuL1.addClass('hidden');
    });
    $menuL1.on('click', function(e) {
        e.stopPropagation();
    });
    // Map metric categories to portal types
    const metricToPortalType = {
        'Production': 'Production',
        'WIP': 'WIP',
        'Line Stop': 'LineStop',
        'Cutting': 'Cutting',
        'Labour': 'HR'
    };

    $('.submenu-item').on('click', function(e) {
        e.stopPropagation();
        const val = $(this).data('val');
        const type = $(this).data('type') || '';
        $btn.contents().filter(function() { return this.nodeType === 3; }).first().replaceWith(val.split(':')[1] + ' ');
        $btn.data('val', val).data('type', type);
        $menuL1.addClass('hidden');
        selectedMetric = val;
        selectedType = type;
        const metricCat = (selectedMetric || '').split(':')[0] || '';
        
        // Update portal type based on selected metric category
        const newPortalType = metricToPortalType[metricCat] || 'Production';
        // Get current URL and update the path to include the portal type
        const currentUrl = new URL(window.location.href);
        const pathSegments = currentUrl.pathname.split('/').filter(segment => segment);
        
        // If we already have a portal type in the path, replace it, otherwise add it
        if (pathSegments.length > 0 && pathSegments[0] === 'history_dashboard') {
            pathSegments[1] = encodeURIComponent(metricCat); // Use the actual category name in the path
        } else {
            pathSegments.unshift('history_dashboard', encodeURIComponent(metricCat));
        }
        
        // Reconstruct the URL with the new path
        const newPath = '/' + pathSegments.join('/');
        currentUrl.pathname = newPath;
        
        // Update the URL without page reload
        window.history.pushState({}, '', currentUrl);
        // Save to history URL key
        localStorage.setItem(HISTORY_URL_KEY, currentUrl.toString());
        // Get the query params from current URL for breadcrumb links
        const urlParams = new URLSearchParams(window.location.search);
        const fromdate = urlParams.get('fromdate') || '';
        const enddate  = urlParams.get('enddate') || '';
        if (metricCat === 'Production') {
            // Simplified breadcrumb: Production Dashboard > Historical Data
            $('.main_breadcrumb').html(
              `<a id="productionBreadcrumb" href="/production_gar_dashboard?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-700 hover:underline">Production Dashboard</a>
               <span> &gt; </span>
               <span class="text-gray-800 font-medium">Historical Data</span>`
            );
        } else {
            // Restore original breadcrumb structure so specific handlers can populate portal_type_link
            $('.main_breadcrumb').html(
              `<a id="productionBreadcrumb" href="/production_gar_dashboard?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-700 hover:underline">Production Dashboard</a>
               <span> &gt; </span>
               <span class="text-gray-500 main_breadcrumb_text portal_type_link"> </span>
               <span> &gt; </span>
               <span class="text-gray-800 font-medium">Historical Data</span>`
            );
        }
        const [displayStart, displayEnd] = $('#dateRangePicker').val().split(' - ');
        const startFormatted = displayStart ? moment(displayStart, 'DD-MM-YY').format('YYYY-MM-DD') : '';
        const endFormatted = displayEnd ? moment(displayEnd, 'DD-MM-YY').format('YYYY-MM-DD') : '';
        const [metricCategory, metricName] = selectedMetric.split(':');
        const titleText = `History for Garments Overview : ${displayStart} - ${displayEnd} | ${metricCategory} : ${metricName}`;
        $('.dashboard_title').text(titleText);
        $('.drilldown, .month-header').removeClass('highlight');
        fetchData(selectedType, startFormatted, endFormatted, portal_type, selectedMetric);
    });

    $(document).on('click', '.drilldown', function() {
        const type = $(this).data('type');
        const name = $(this).data('name');
        const month = $(this).data('month');
        $('.drilldown, .month-header').removeClass('highlight');
        $(this).addClass('highlight');
        // If clicking a Buyer cell while a Unit is filtered, pass the unit context to drilldown
        const unitCtx = (type === 'buyer' && currentBuyerFilterUnit) ? currentBuyerFilterUnit : null;
        updateDrilldownTable(type, name, month, false, unitCtx);
        if (type === 'unit') {
            updateBuyerTableFilter(month, name);
        }
    });
    $(document).on('click', '.month-header', function() {
        const type = $(this).data('type');
        const month = $(this).data('month');
        $('.drilldown, .month-header').removeClass('highlight');
        $(this).addClass('highlight');
        // If clicking Buyer header while a Unit is filtered, show Buyer-wise drilldown for that Unit
        const isBuyerHeader = type === 'buyer';
        const unitCtx = (isBuyerHeader && currentBuyerFilterUnit) ? currentBuyerFilterUnit : null;
        updateDrilldownTable(type, null, month, true, unitCtx);
        if (type === 'unit') {
            updateBuyerTableFilter(month, null);
        }
    });
    // Helper: resolve base dashboard URL dynamically, prioritizing selected metric category
    function resolveDashboardBase() {
        // Prefer the currently selected metric category (e.g., 'Production', 'Line Stop', 'Cutting', 'WIP', 'Labour')
        const btnVal = ($('#metricsBtn').data('val') || '').toString();
        const metricCat = (btnVal || selectedMetric || '').split(':')[0] || '';
        const map = {
            'Production': '/production_gar_dashboard',
            'Line Stop': '/linestop_analysis',
            'Cutting': '/cutting_output',
            'WIP': '/wip',
            'Labour': '/directlabour'
        };
        if (metricCat && map[metricCat]) return map[metricCat];
        // Fallback to breadcrumb link target if present
        const href = $('#productionBreadcrumb').attr('href') || $('.portal_type_link a').attr('href') || '';
        if (href) return href.split('?')[0];
        // Final fallback to portal_type map
        return map[portal_type] || '/production_gar_dashboard';
    }
    // Navigate when clicking a day cell in the drilldown table
    $(document).on('click', '#drilldownTable td.day-cell', function() {
        const day = $(this).data('day');
        const mon = $(this).data('month');
        const year = $(this).data('year');
        if (!day || !mon || !year) return;
        const date = moment(`${day}-${mon}-${year}`, 'D-MMM-YYYY').format('YYYY-MM-DD');
        if (!date || date === 'Invalid date') return;
        // Persist the current selection context ONLY for back navigation
        const $selCell = $('.drilldown.highlight').first();
        const $selMonth = $('.month-header.highlight').first();
        if ($selCell.length) {
          const selType = $selCell.data('type');
          const selName = $selCell.data('name');
          const selMonth = $selCell.data('month');
          const unitCtx = (selType === 'buyer' && currentBuyerFilterUnit) ? currentBuyerFilterUnit : null;
          saveSelection({ mode: 'cell', type: selType, name: selName, month: selMonth, unitContext: unitCtx });
        } else if ($selMonth.length) {
          const selType = $selMonth.data('type');
          const selMonth = $selMonth.data('month');
          const unitCtx = (selType === 'buyer' && currentBuyerFilterUnit) ? currentBuyerFilterUnit : null;
          saveSelection({ mode: 'month', type: selType, month: selMonth, unitContext: unitCtx });
        }
        // mark that the next history visit should restore
        localStorage.setItem(BACK_TRIGGER_KEY, '1');
        // one-time dashboard back button visibility flag (session-scoped)
        try { sessionStorage.setItem('history_back_once_v2', '1'); } catch (e) {}
        // Record this page URL for the back button
        try { localStorage.setItem(HISTORY_URL_KEY, window.location.pathname + window.location.search); } catch (e) {}
        // Redirect to appropriate dashboard based on mapping
        const base = resolveDashboardBase();
        // If Cutting dashboard, include buyer/ocn/unit context when available (Order-wise grid)
        let extra = '';
        if (base === '/cutting_output') {
          const $td = $(this);
          const buyerParam = encodeURIComponent($td.data('buyer') || '');
          const ocnParam = encodeURIComponent($td.data('ocn') || '');
          const unitParam = encodeURIComponent($td.data('unit') || '');
          const parts = [];
          if (buyerParam) parts.push(`buyer=${buyerParam}`);
          if (ocnParam) parts.push(`ocn=${ocnParam}`);
          if (unitParam) parts.push(`unit=${unitParam}`);
          if (parts.length) extra = '&' + parts.join('&');
        } else if (base === '/linestop_analysis') {
          // For Line Stop dashboard, pass unit (if available).
          // Prefer currently selected unit cell; else, if buyer table is filtered by unit, use that.
          const $td = $(this);
          const $selCell = $('.drilldown.highlight').first();
          let unitVal = '';
          if ($selCell.length && $selCell.data('type') === 'unit') {
            unitVal = $selCell.data('name') || '';
          } else if (typeof currentBuyerFilterUnit !== 'undefined' && currentBuyerFilterUnit) {
            unitVal = currentBuyerFilterUnit || '';
          }
          const parts = [];
          if (unitVal) parts.push(`unit=${encodeURIComponent(unitVal)}`);
          // In future, if day-cell carries reason/ocn for line stop, include them similarly:
          const reasonParam = $td.data('reason') ? encodeURIComponent($td.data('reason')) : '';
          const ocnParamLS = $td.data('ocn') ? encodeURIComponent($td.data('ocn')) : '';
          if (reasonParam) parts.push(`reason=${reasonParam}`);
          if (ocnParamLS) parts.push(`ocn=${ocnParamLS}`);
          if (parts.length) extra = '&' + parts.join('&');
        } else if (base === '/wip') {
          // For WIP dashboard, pass unit or buyer context based on selected cell
          const $selCell = $('.drilldown.highlight').first();
          const parts = [];
          if ($selCell.length) {
            const type = $selCell.data('type');
            const name = $selCell.data('name') || '';
            if (type === 'unit' && name) {
              parts.push(`unit=${encodeURIComponent(name)}`);
            } else if (type === 'buyer' && name) {
              parts.push(`buyer=${encodeURIComponent(name)}`);
              // if buyer table is filtered by a unit, include it too
              if (typeof currentBuyerFilterUnit !== 'undefined' && currentBuyerFilterUnit) {
                parts.push(`unit=${encodeURIComponent(currentBuyerFilterUnit)}`);
              }
            }
          }
          if (parts.length) extra = '&' + parts.join('&');
        }
        window.location.href = `${base}?fromdate=${date}&enddate=${date}${extra}`;
    });
    $('#dateRangePicker').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(5, 'months').startOf('month'),
        endDate: moment(),
        maxDate: moment(),
        ranges: {
            'Last 6 Months': [moment().subtract(5, 'months').startOf('month'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')]
        },
        locale: {
            format: 'DD-MM-YY',
            separator: ' - '
        },
        isInvalidDate: function(date) {
            return date.isAfter(moment(), 'day');
        }
    }, function(start, end, label) {
        const displayStartFormatted = start.format('DD-MM-YY');
        const displayEndFormatted = end.format('DD-MM-YY');
        const [metricCategory, metricName] = selectedMetric.split(':');
        const titleText = `History for Garments Overview : ${displayStartFormatted} - ${displayEndFormatted} | ${metricCategory} : ${metricName}`;
        $('.dashboard_title').text(titleText);
        $('#dateRangePicker').val(`${displayStartFormatted} - ${displayEndFormatted}`);
        const startFormatted = start.format('YYYY-MM-DD');
        const endFormatted = end.format('YYYY-MM-DD');
        $('.drilldown, .month-header').removeClass('highlight');
        fetchData(selectedType, startFormatted, endFormatted, portal_type, selectedMetric);
    });

    // Define mapping of portal types to their first available metric
    const portalMetricMap = {
        'Production': 'Production:Quantity',
        'Line Stop': 'Line Stop:Minutes',
        'Cutting': 'Cutting:Total Cut',
        'WIP': 'WIP:WIP',
        'Labour': 'Labour:Strength'
    };

    // Get the portal type (default to 'Production' if not set)
    const portalType = portal_type || 'Production';

    // Set the initial metric based on portal type
    selectedMetric = portalMetricMap[portalType] || 'Production:Quantity';
    selectedType = $(`.submenu-item[data-val="${selectedMetric}"]`).data('type') || '1';

    // Update dropdown button
    $btn.contents().filter(function() { return this.nodeType === 3; }).first().replaceWith(selectedMetric.split(':')[1] + ' ');
    $btn.data('val', selectedMetric).data('type', selectedType);

    const initialStart = moment().subtract(5, 'months').startOf('month');
    const initialEnd = moment();
    const initialStartFormatted = initialStart.format('YYYY-MM-DD');
    const initialEndFormatted = initialEnd.format('YYYY-MM-DD');
    const initialDisplayStartFormatted = initialStart.format('DD-MM-YY');
    const initialDisplayEndFormatted = initialEnd.format('DD-MM-YY');
    const [metricCategory, metricName] = selectedMetric.split(':');
    $('.dashboard_title').text(`History for Garments Overview : ${initialDisplayStartFormatted} - ${initialDisplayEndFormatted} | ${metricCategory} : ${metricName}`);
    $('#dateRangePicker').val(`${initialDisplayStartFormatted} - ${initialDisplayEndFormatted}`);
    selectedMetric = $btn.data('val') || 'Production:Quantity';
    selectedType = $btn.data('type') || '1';
    // Set initial breadcrumb based on selected metric category
    (function(){
      const cat = (selectedMetric || '').split(':')[0] || '';
      const urlParams = new URLSearchParams(window.location.search);
      const fromdate = urlParams.get('fromdate') || '';
      const enddate  = urlParams.get('enddate') || '';
      if (cat === 'Production') {
        $('.main_breadcrumb').html(
          `<a id="productionBreadcrumb" href="/production_gar_dashboard?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-700 hover:underline">Production Dashboard</a>
           <span> &gt; </span>
           <span class="text-gray-800 font-medium">Historical Data</span>`
        );
      } else {
        $('.main_breadcrumb').html(
          `<a id="productionBreadcrumb" href="/production_gar_dashboard?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-700 hover:underline">Production Dashboard</a>
           <span> &gt; </span>
           <span class="text-gray-500 main_breadcrumb_text portal_type_link"> </span>
           <span> &gt; </span>
           <span class="text-gray-800 font-medium">Historical Data</span>`
        );
      }
    })();
    // Record this page URL for the back button
    try { localStorage.setItem(HISTORY_URL_KEY, window.location.pathname + window.location.search); } catch (e) {}
    fetchData(selectedType, initialStartFormatted, initialEndFormatted, portalType, selectedMetric);

    // If returning from a dashboard via back navigation, restore the last-used metric
    (function() {
      try {
        const backTrigger = localStorage.getItem(BACK_TRIGGER_KEY) === '1';
        if (!backTrigger) return;
        if (typeof getStoredSelection !== 'function') return;
        const storedSel = getStoredSelection();
        if (!storedSel || !storedSel.metric) return;

        const restoredMetric = storedSel.metric;
        const $metricItem = $('.submenu-item[data-val="' + restoredMetric + '"]');
        if ($metricItem.length === 0) return; // metric no longer available

        const restoredType = $metricItem.data('type') || '1';
        selectedMetric = restoredMetric;
        selectedType = restoredType;

        // Update dropdown button label and data attributes
        $btn.contents().filter(function() { return this.nodeType === 3; }).first().replaceWith(restoredMetric.split(':')[1] + ' ');
        $btn.data('val', restoredMetric).data('type', restoredType);

        // Recompute title with restored metric using current visible date range
        const currentRange = $('#dateRangePicker').val() || (initialDisplayStartFormatted + ' - ' + initialDisplayEndFormatted);
        const parts = currentRange.split(' - ');
        const dispStart = parts[0] || initialDisplayStartFormatted;
        const dispEnd = parts[1] || initialDisplayEndFormatted;
        const metricParts = restoredMetric.split(':');
        const cat = metricParts[0] || '';
        const name = metricParts[1] || '';
        $('.dashboard_title').text('History for Garments Overview : ' + dispStart + ' - ' + dispEnd + ' | ' + cat + ' : ' + name);

        // Re-run data load with restored metric and same date range
        const startParsed = moment(dispStart, 'DD-MM-YY').isValid() ? moment(dispStart, 'DD-MM-YY') : initialStart;
        const endParsed = moment(dispEnd, 'DD-MM-YY').isValid() ? moment(dispEnd, 'DD-MM-YY') : initialEnd;
        const startF = startParsed.format('YYYY-MM-DD');
        const endF = endParsed.format('YYYY-MM-DD');
        fetchData(selectedType, startF, endF, portalType, selectedMetric);
      } catch (e) {
        // fail silently; normal initial metric logic already ran
      }
    })();

    $('#notificationsBtn').click(function() {
        $('#notificationOverlay').removeClass('hidden');
        setTimeout(() => {
        $('#notificationPanel').removeClass('translate-x-full');
        }, 10);
    });
    $(document).on('click', '#notificationOverlay, #closeNotifications', function(e) {
        if ($(e.target).is('#notificationOverlay') || $(e.target).closest('#closeNotifications').length) {
        $('#notificationPanel').addClass('translate-x-full');
        setTimeout(() => {
            $('#notificationOverlay').addClass('hidden');
        }, 300);
        }
    });

    // Get the query params from current URL
    const urlParams = new URLSearchParams(window.location.search);
    const fromdate = urlParams.get('fromdate') || '';
    const enddate  = urlParams.get('enddate') || '';

    
    // Line Stop Dashboard
    $('.line_stop_item').on('click', function() {
        $('.main_breadcrumb_text').html(
            `<a href="/linestop_analysis?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
                Line Stop Dashboard
            </a>`
        );
    });

    // WIP Dashboard
    $('.wip_item').on('click', function() {
        $('.main_breadcrumb_text').html(
            `<a href="/wip?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
                WIP Dashboard
            </a>`
        );
    });

    // Cutting Dashboard
    $('.cutting_item').on('click', function() {
        $('.main_breadcrumb_text').html(
            `<a href="/cutting_output?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
                Cutting Dashboard
            </a>`
        );
    });

    // Labour Dashboard
    $('.labour_item').on('click', function() {
        $('.main_breadcrumb_text').html(
            `<a href="/direct_labour?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
                Labour Dashboard
            </a>`
        );
    });

    if (portal_type === 'Line Stop') {
        $('.portal_type_link').html(
            `<a href="/linestop_analysis?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
                Line Stop Dashboard
            </a>`
        );
    } else if (portal_type === 'WIP') {
        $('.portal_type_link').html(
            `<a href="/wip?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
                WIP Dashboard
            </a>`
        );
    } else if (portal_type === 'Cutting') {
        $('.portal_type_link').html(
            `<a href="/cutting_output?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
                Cutting Dashboard
            </a>`
        );
    } else if (portal_type === 'Labour') {
        $('.portal_type_link').html(
            `<a href="/directlabour?fromdate=${fromdate}&enddate=${enddate}" class="text-blue-600 hover:underline">
                Labour Dashboard
            </a>`
        );
    } else {
        
    }
    
});

</script>
</body>
</html>