<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Supermarket Stock — Dashboard</title>

    <!-- Tailwind CDN -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- jQuery -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>

    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.3.0/dist/chart.umd.min.js"></script>
    <!-- Font Awesome CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

      <!-- DataTables (for table pagination/search) -->
      <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" />
      <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

      <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
      <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
      <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
      <script>
        tailwind.config = {
        theme: {
        extend: {
        colors: {
        'background': 'rgb(245, 246, 247)',
        'foreground': 'rgb(31, 41, 55)',
        'card': 'rgb(255, 255, 255)',
        'card-foreground': 'rgb(31, 41, 55)',
        'primary': 'rgb(15, 61, 126)',
        'primary-foreground': 'rgb(248, 250, 252)',
        'primary-100': 'rgb(219, 234, 254)',
        'primary-50': 'rgb(239, 246, 255)',
        'primary-25': 'rgb(248, 250, 252)',
        'secondary': 'rgb(241, 245, 249)',
        'muted': 'rgb(241, 245, 249)',
        'muted-foreground': 'rgb(100, 116, 139)',
        'border': 'rgb(226, 232, 240)',
        'input': 'rgb(226, 232, 240)',
        'ring': 'rgb(15, 61, 126)',
        },
        fontFamily: {
        'body': ['Inter', 'system-ui', 'sans-serif'],
        }
        }
        }
        }
      </script>

      <style>
        :root{
        --navy:#143f6b;
        --card-border: rgba(20,63,107,0.06);
        --muted: #6b7280;
        --accent: #0f62a8;
        --accent-dark: #08325b;
        }
        body { font-family: Inter, ui-sans-serif, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial; background:#f3f4f6; color:#0f172a; }
        .card { background: #fff; border-radius: 10px; border:1px solid var(--card-border); box-shadow: 0 2px 8px rgba(15,59,102,0.03); }
        .kpi-value { font-weight: 700; font-size: 1.4rem; color:#0b2540; }
        .small-p { font-size: .78rem; color:var(--muted); }
        canvas.spark { width: 120px; height: 36px; }
        canvas.hbar { height: 280px; }
        .tiny-spark { width: 110px; height: 30px; display:inline-block; }
        .dataTables_wrapper .dataTables_filter input { border:1px solid #e6e6e6; padding:.5rem .6rem; border-radius:6px; }
        /* Compact DataTables length control */
        .dataTables_wrapper .dataTables_length label { font-size: 12px; color:#6b7280; }
        .dataTables_wrapper .dataTables_length select { font-size: 12px; padding: 2px 6px; height: 26px; line-height: 22px; border:1px solid #e5e7eb; border-radius:6px; width:auto; min-width:56px; }
        /* Compact DataTables search control */
        .dataTables_wrapper .dataTables_filter input { font-size: 12px; padding: 2px 6px; height: 26px; line-height: 22px; border:1px solid #D3D3D3; border-radius:6px; width:120px; background-color: #ffffff; }
        /* Compact DataTables info and pagination */
        .dataTables_wrapper .dataTables_info { font-size: 12px; color:#6b7280; }
        .dataTables_wrapper .dataTables_paginate { font-size: 12px; }
        .dataTables_wrapper .dataTables_paginate .paginate_button { padding: 2px 6px; margin: 0 1px; font-size: 12px; }
        /* Compact vertical padding for stock table rows */
        #stockTable tbody tr > th,
        #stockTable tbody tr > td { padding-top: 4px; padding-bottom: 4px; }
        .progress-track { background: #eef2f7; height:8px; border-radius:999px; display:block; overflow:hidden; }
        .progress-fill { height:8px; border-radius:999px; }
        .trend-mini { width:80px; height:30px; display:inline-block; }
        .low-stock { background: rgba(254, 242, 242, 0.7); }
        .icon-btn { background: #f8fafc; border:1px solid #eef2f7; padding:6px; border-radius:6px; }
        .date-picker input {
        background: rgba(248, 250, 252, 0.1);
        color: white;
        }
        .date-picker input::placeholder {
        color: rgba(248, 250, 252, 0.7);
        }
        .spinner {
        display: inline-block;
        width: 1.5rem;
        height: 1.5rem;
        border: 3px solid rgba(255, 255, 255, 0.3);
        border-top-color: #fff;
        border-radius: 50%;
        animation: spin 1s ease-in-out infinite;
        }
        @keyframes spin {
        to { transform: rotate(360deg); }
        }
        .inactive-card { background-color: #ddd8d8ff; filter: grayscale(50%); }
        #dateRangePicker { display: none; }
      </style>
    </head>
  <body>

    @php
    $empl_no= Session::get('empl_id');
    $empl_name = Session::get('emp_name');
    @endphp

    @include('LifeAtGainup.production.header')

    <div class="px-6 py-3 text-sm text-gray-600">
      <a id="productionBreadcrumb" href="/production_gar_dashboard" class="text-blue-700 hover:underline">Production Dashboard</a>
      <span> &gt; </span>
      <span class="text-gray-800 font-medium">Supermarket Stock Analysis</span>
    </div>

    <main class="mx-auto px-6 pb-3 space-y-6">

      <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
        <div class="card p-4 flex flex-col justify-between cursor-pointer hover:shadow-md" id="kpi1">
          <div class="flex flex-col-2">
            <div>
              <div class="text-xs text-[var(--muted)]">SM Availability</div>
              <div class="kpi-value" id="sm-avail">94.7%</div>
              <div class="text-xs text-green-600 mt-1" id="sm-trend">▲ 5.3% vs yesterday</div>
            </div>
            <div class="w-full mt-3">
              <canvas id="k1" class="spark"></canvas>
            </div>
          </div>
          <div class="text-xs text-[var(--muted)] mt-2">Target: 95%</div>
        </div>

        <div class="card p-4 flex flex-col justify-between cursor-pointer hover:shadow-md" id="kpi2">
          <div class="flex flex-col-2">
            <div>
              <div class="text-xs text-[var(--muted)]">Full Kit Availability</div>
              <div class="kpi-value" id="kit-avail">88.9%</div>
              <div class="text-xs text-red-600 mt-1" id="kit-trend">▼ 1.3% vs yesterday</div>
            </div>
            <div class="w-full mt-3">
              <canvas id="k2" class="spark"></canvas>
            </div>
          </div>
          <div class="text-xs text-[var(--muted)] mt-2">Target: 98%</div>
        </div>

        <div class="card p-4 flex flex-col justify-between cursor-pointer hover:shadow-md" id="kpi3">
          <div class="flex flex-col-2">
            <div>
              <div class="text-xs text-[var(--muted)]">Total Stock Quantity</div>
              <div class="kpi-value" id="stock-qty">4,640</div>
              <div class="text-xs text-red-600 mt-1" id="stock-trend">▼ 8.2% vs yesterday</div>
            </div>
            <div class="w-full mt-3">
              <canvas id="k3" class="spark"></canvas>
            </div>
          </div>
          <div class="text-xs text-[var(--muted)] mt-2">Target: 2,500</div>
        </div>

        <div class="inactive-card card px-3 py-2 flex flex-col justify-between cursor-pointer hover:shadow-md" id="kpi4">
          <div class="flex flex-col-2">
            <div>
              <div class="text-xs text-[var(--muted)]">Stock Coverage Days</div>
              <div class="kpi-value" id="coverage-days">6 days</div>
              <div class="text-xs text-green-600 mt-1" id="coverage-trend">▲ 1.5% vs yesterday</div>
            </div>
            <div class="w-full mt-3">
              <canvas id="k4" class="spark"></canvas>
            </div>
          </div>
          <div class="text-xs text-[var(--muted)] mt-2">Target: 5 days</div>
        </div>

        <div class="card p-4 flex flex-col justify-between cursor-pointer hover:shadow-md" id="kpi5">
          <div class="flex flex-col-2">
            <div>
              <div class="text-xs text-[var(--muted)]">Total Input Today</div>
              <div class="kpi-value" id="input-today">787</div>
              <div class="text-xs text-green-600 mt-1" id="input-trend">▲ 0.6% vs yesterday</div>
            </div>
            <div class="w-full mt-3">
              <canvas id="k5" class="spark"></canvas>
            </div>
          </div>
          <div class="text-xs text-[var(--muted)] mt-2">Target: 500</div>
        </div>
      </div>

      <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="card p-4 lg:col-span-2">
          <div class="flex flex-col">
            <div class="flex flex-row items-center gap-2 mb-2">
              <div class="text-lg font-bold bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient">
                Overall Trend Chart
              </div>
              <div class="text-xs text-[var(--muted)]">Daily stock levels with 7-day moving average</div>
            </div>
          </div>
          <div class="mt-4">
            <div class="h-80">
              <canvas id="overallTrend"></canvas>
            </div>
          </div>
        </div>

        <div class="card p-4">
          <div class="text-sm font-bold bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient ">Right Summary</div>
          <div id="buyerCrumb" class="text-xs text-[var(--muted)] mt-2">ALL Buyer</div>
          <div class="mt-6">
            <div class="h-64">
              <canvas id="buyerBars" class="hbar cursor-pointer"></canvas>
            </div>
          </div>
        </div>
      </div>

      <div class="card p-4">
        <div class="flex items-center justify-between">
          <div class="flex flex-row items-center gap-2">
            <div class="text-lg font-bold bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent animate-gradient ">Supermarket Stock Details</div>
            <div class="text-xs text-[var(--muted)]">Live inventory of components and materials ready for production.</div>
          </div>
          <div class="flex items-center gap-2">
            <button class="icon-btn" title="Alerts">
              <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-slate-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 9v2m0 4h.01M7 12a5 5 0 1110 0v6H7v-6z"/>
              </svg>
            </button>
            <button class="icon-btn" title="Export">
              <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-slate-600" viewBox="0 0 20 20" fill="currentColor">
                <path d="M3 3a1 1 0 000 2h14a1 1 0 100-2H3zM3 7a1 1 0 000 2h8a1 1 0 100-2H3zM3 11a1 1 0 000 2h6a1 1 0 100-2H3z"/>
              </svg>
            </button>
          </div>
        </div>

        <div class="mt-4 overflow-x-auto" id="stockTableContainer">
          <table id="stockTable" class="w-full text-sm" style="width: calc(100% - 10px);">
            <thead class="text-xs text-[var(--muted)] border-b">
              <tr class="text-left">
                <th class="py-3 px-3">OCN / Style / Color</th>
                <th class="py-3 px-3">Size</th>
                <th class="py-3 px-3">Stock (pcs)</th>
                <th class="py-3 px-3">Days of Stock</th>
                <th class="py-3 px-3">SM Received</th>

                <th class="py-3 px-3">SM Rcv % VS Order</th>
                <th class="py-3 px-3">Input Trend</th>
                <th class="py-3 px-3">Issued</th>
                <th class="py-3 px-3">Issued % VS Order</th>
                <th class="py-3 px-3">Issued Trend</th>
              </tr>
            </thead>
            <tbody id="stockBody" class="text-slate-800 text-xs"></tbody>
          </table>
        </div>
      </div>

    </main>

    <script>

      // Icons now use Font Awesome; no initialization required

      // Global variables
      let selectedRangeLabel = "Last Week";
      let apiData = [];
      let tableData = [];
      let buyerDrillPath = ['root'];
      let BUYER_DRILL = {};
      let currentKpi = null;
      let sparkCharts = {};
      let ocnMap = {};
      let stockTable = null;
      let overallChart = null;
      let selectedFilter = null; // { key, label } used to highlight/filter at terminal level
      // Base KPI card values computed from full dataset; remain fixed when switching KPI cards
      let baseKpiValues = null; // { sm, kit, stock, coverage, input }
      // Currently selected date range (YYYY-MM-DD)
      let currentStartDate = '';
      let currentEndDate = '';
      // Read from current page URL (preferred for deep links)
      function getParam(name){ try{ return new URL(window.location.href).searchParams.get(name) || ''; }catch(e){ return ''; } }
      const urlFromDate = getParam('fromdate');
      const urlEndDate = getParam('enddate');

      // Chart defaults
      Chart.defaults.font.family = "'Inter', sans-serif";
      Chart.defaults.font.size = 11;
      Chart.defaults.color = "#4b5563";

      // KPI sparkline function
      // KPI sparkline function
      function createSpark(id, data, color, fill = true) {
      const ctx = document.getElementById(id)?.getContext('2d');
      if (!ctx) return null;
      if (sparkCharts[id]) {
      sparkCharts[id].destroy();
      }
      const gradient = ctx.createLinearGradient(0, 0, 0, ctx.canvas.height);
      gradient.addColorStop(0, color + '20'); // Lighter shade at the top
      gradient.addColorStop(1, color + '00'); // Transparent at the bottom

      const chart = new Chart(ctx, {
      type: 'line',
      data: {
      labels: data.map((_, i) => i),
      datasets: [{
      data,
      borderColor: color,
      backgroundColor: fill ? gradient : 'transparent',
      fill: fill,
      tension: 0.4,
      borderWidth: 1.7,
      pointRadius: 0
      }]
      },
      options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: { legend: { display: false } },
      scales: { x: { display: false }, y: { display: false } }
      }
      });
      sparkCharts[id] = chart;
      return chart;
      }
      // Build drill data from apiData
      function buildDrillData(filteredData) {
      let drill = {};
      let buyers = {};
      ocnMap = {};

      if (!filteredData || !Array.isArray(filteredData) || filteredData.length === 0) {
      drill['root'] = {
      title: 'ALL Buyer',
      labels: [],
      data: [],
      kpiData: { sm: 0, kit: 0, stock: 0, coverage: 0, input: 0 },
      overallTrend: [0, 0, 0, 0, 0, 0, 0],
      tableData: []
      };
      return drill;
      }

      filteredData.forEach(unit => {
      if (!unit.buyers || !Array.isArray(unit.buyers)) return;
      unit.buyers.forEach(buyer => {
      if (!buyer.Buyer || !buyer.data || !Array.isArray(buyer.data)) return;
      if (!buyers[buyer.Buyer]) {
      buyers[buyer.Buyer] = {
      ocns: {},
      items: [],
      totalStock: 0,
      totalInput: 0,
      totalIssued: 0,
      sumInputPct: 0,
      sumIssuedPct: 0,
      sumDays: 0,
      count: 0
      };
      }
      let b = buyers[buyer.Buyer];
      buyer.data.forEach(item => {
      const ocnLastFour = item.Order_No ? item.Order_No.slice(-4) : " ";
      const buyername = item.Buyer ? item.Buyer.replace(/[^a-zA-Z]/g, '').slice(0, 6) : " ";
      const itemname = item.Item ? item.Item.replace(/[^a-zA-Z]/g, '').slice(0, 5) : " ";
      const colorname = item.Color ? item.Color.replace(/[^a-zA-Z]/g, '').slice(0, 5) : " ";
      const stock = parseInt(item.Stock) || 0;
      const input = parseInt(item.SM_Rcvd) || 0;
      const issued = parseInt(item.Iss_Qty) || 0;
      const ackwait = parseInt(item.Ack_Waiting) || 0;
      const inputPct = parseFloat(item.Sm_Rcvd_Perc) || 0;
      const issuedPct = parseFloat(item.Iss_Perc) || 0;
      const days = input > 0 ? Math.round(stock / input) : 0;
      b.totalStock += stock;
      b.totalInput += input;
      b.totalIssued += issued;
      b.sumInputPct += inputPct;
      b.sumIssuedPct += issuedPct;
      b.sumDays += days;
      b.count++;
      const row = {
      ocn: `${buyername}${ocnLastFour}/${itemname}/${colorname}`,
      desc: `${item.Item || 'Unknown'} / ${item.Color || 'Unknown'}`,
      itemOnly: item.Item || 'Unknown',
      colorOnly: item.Color || 'Unknown',
      itemId: item.Itemid || item.ItemId || '',
      colorId: item.Colorid || item.ColorId || '',
      sizeId: item.SIzeid || item.SizeId || item.Sizeid || '',
      size: item.Size || 'N/A',
      stock,
      days,
      input,
      ackwait,
      inputPct,
      inputTrend: [inputPct-4, inputPct-2, inputPct, inputPct+2, inputPct-1],
      issued,
      issuedPct,
      issuedTrend: [issuedPct-3, issuedPct-1, issuedPct, issuedPct+1, issuedPct],
      lowStock: stock === 0,
      buyer: buyer.Buyer,
      fullOcn: item.Order_No
      };
      b.items.push(row);
      if (!b.ocns[item.Order_No]) {
      b.ocns[item.Order_No] = {
      items: [],
      totalStock: 0,
      totalInput: 0,
      totalIssued: 0,
      sumInputPct: 0,
      sumIssuedPct: 0,
      sumDays: 0,
      count: 0
      };
      }
      let o = b.ocns[item.Order_No];
      o.items.push(row);
      o.totalStock += stock;
      o.totalInput += input;
      o.totalIssued += issued;
      o.sumInputPct += inputPct;
      o.sumIssuedPct += issuedPct;
      o.sumDays += days;
      o.count++;
      });
      });
      });

      let root = {
      title: 'ALL Buyer',
      labels: [],
      data: [],
      kpiData: {},
      overallTrend: [],
      tableData: []
      };
      let allTotalStock = 0, allTotalInput = 0, allTotalIssued = 0, allSumInputPct = 0, allSumIssuedPct = 0, allSumDays = 0, allCount = 0;
      Object.keys(buyers).forEach(bName => {
      let b = buyers[bName];
      root.labels.push(bName);
      // Use total stock for buyer bar values
      root.data.push(b.totalStock);
      allTotalStock += b.totalStock;
      allTotalInput += b.totalInput;
      allTotalIssued += b.totalIssued;
      allSumInputPct += b.sumInputPct;
      allSumIssuedPct += b.sumIssuedPct;
      allSumDays += b.sumDays;
      allCount += b.count;
      root.tableData.push(...b.items);
      });
      root.kpiData = {
      sm: allCount ? (allSumInputPct / allCount).toFixed(1) : 0,
      kit: allCount ? (allSumIssuedPct / allCount).toFixed(1) : 0,
      stock: allTotalStock,
      coverage: allCount ? Math.round(allSumDays / allCount) : 0,
      input: allTotalInput
      };
      root.overallTrend = allCount ? [root.kpiData.sm - 5, root.kpiData.sm - 2, root.kpiData.sm, root.kpiData.sm + 2, root.kpiData.sm - 1, root.kpiData.sm + 1, root.kpiData.sm] : [0, 0, 0, 0, 0, 0, 0];
      drill['root'] = root;

      Object.keys(buyers).forEach(bName => {
      let b = buyers[bName];
      let node = {
      title: `ALL Buyer > ${bName}`,
      labels: [],
      data: [],
      kpiData: {
      sm: b.count ? (b.sumInputPct / b.count).toFixed(1) : 0,
      kit: b.count ? (b.sumIssuedPct / b.count).toFixed(1) : 0,
      stock: b.totalStock,
      coverage: b.count ? Math.round(b.sumDays / b.count) : 0,
      input: b.totalInput
      },
      overallTrend: [],
      tableData: b.items
      };
      Object.keys(b.ocns).forEach(ocnName => {
      let o = b.ocns[ocnName];
      const shortOcn = ocnName.slice(-4);
      node.labels.push(shortOcn);
      // Use OCN-level total stock for bar values
      node.data.push(o.totalStock);
      ocnMap[shortOcn] = ocnName;
      });
      node.overallTrend = b.count ? [node.kpiData.sm - 5, node.kpiData.sm - 2, node.kpiData.sm, node.kpiData.sm + 2, node.kpiData.sm - 1, node.kpiData.sm + 1, node.kpiData.sm] : [0, 0, 0, 0, 0, 0, 0];
      drill[bName] = node;
      });

      Object.keys(buyers).forEach(bName => {
      let b = buyers[bName];
      Object.keys(b.ocns).forEach(ocnName => {
      let o = b.ocns[ocnName];
      const shortOcn = ocnName.slice(-4);
      // Aggregate deepest level by Item only (exclude Color)
      const byItem = {};
      o.items.forEach(it => {
      const key = it.itemOnly || 'Unknown';
      if (!byItem[key]) byItem[key] = 0;
      byItem[key] += it.stock || 0;
      });

      let subnode = {
      title: `ALL Buyer > ${bName} > ${shortOcn}`,
      labels: Object.keys(byItem),
      // Use summed stock per Item
      data: Object.keys(byItem).map(k => byItem[k]),
      kpiData: {
      sm: o.count ? (o.sumInputPct / o.count).toFixed(1) : 0,
      kit: o.count ? (o.sumIssuedPct / o.count).toFixed(1) : 0,
      stock: o.totalStock,
      coverage: o.count ? Math.round(o.sumDays / o.count) : 0,
      input: o.totalInput
      },
      overallTrend: [],
      tableData: o.items
      };
      subnode.overallTrend = o.count ? [subnode.kpiData.sm - 5, subnode.kpiData.sm - 2, subnode.kpiData.sm, subnode.kpiData.sm + 2, subnode.kpiData.sm - 1, subnode.kpiData.sm + 1, subnode.kpiData.sm] : [0, 0, 0, 0, 0, 0, 0];
      drill[ocnName] = subnode;

      // Create item-level children nodes for color-wise drilldown
      Object.keys(byItem).forEach(itemName => {
      const byColor = {};
      o.items.filter(it => (it.itemOnly || 'Unknown') === itemName).forEach(it => {
      const c = it.colorOnly || 'Unknown';
      if (!byColor[c]) byColor[c] = 0;
      byColor[c] += it.stock || 0;
      });
      const itemKey = `${ocnName}||${itemName}`;
      let itemNode = {
      title: `ALL Buyer > ${bName} > ${shortOcn} > ${itemName}`,
      labels: Object.keys(byColor),
      data: Object.keys(byColor).map(k => byColor[k]),
      kpiData: {
      sm: subnode.kpiData.sm,
      kit: subnode.kpiData.kit,
      stock: Object.values(byColor).reduce((s,v)=>s+v,0),
      coverage: subnode.kpiData.coverage,
      input: subnode.kpiData.input
      },
      overallTrend: subnode.overallTrend,
      tableData: o.items.filter(it => (it.itemOnly || 'Unknown') === itemName)
      };
      drill[itemKey] = itemNode;
      });
      });
      });

      return drill;
      }

      // Fetch data from API
      function fetchData(type = "Last Week", fromDate = "", toDate = "") {
      $("#loadSpinner").show();
      $.ajax({
      url: '/smstockdetail',
      method: 'GET',
      data: {
      type: type,
      fromdate: fromDate,
      enddate: toDate,
      empid: "{{ Session('empl_id') }}"
      },
      success: function(response) {
      $("#loadSpinner").hide();
      if (response && response.success && response.units && Array.isArray(response.units)) {
      apiData = response.units;
      } else {
      apiData = [];
      }
      BUYER_DRILL = buildDrillData(apiData);
      buyerDrillPath = ['root'];
      setBuyerCrumb();
      // Capture base KPI values from full dataset (root) and render cards once
      const rootNode = BUYER_DRILL['root'];
      if (rootNode && rootNode.kpiData) {
      baseKpiValues = {
      sm: parseFloat(rootNode.kpiData.sm) || 0,
      kit: parseFloat(rootNode.kpiData.kit) || 0,
      stock: parseInt(rootNode.kpiData.stock) || 0,
      coverage: parseInt(rootNode.kpiData.coverage) || 0,
      input: parseInt(rootNode.kpiData.input) || 0
      };
      $('#sm-avail').text(`${baseKpiValues.sm}%`);
      $('#kit-avail').text(`${baseKpiValues.kit}%`);
      $('#stock-qty').text(baseKpiValues.stock.toLocaleString());
      $('#coverage-days').text(`${baseKpiValues.coverage} days`);
      $('#input-today').text(baseKpiValues.input.toLocaleString());
      }
      updateBuyerDrill('root');

      // Process and display trend data
      if (response.trend && response.trend.length > 0 && overallChart) {
      const dateMap = {};

      // Group by date and sum stock quantities
      response.trend.forEach(item => {
      const date = item.Edate;
      const stockQty = parseFloat(item.Stock_Qty) || 0;
      dateMap[date] = (dateMap[date] || 0) + stockQty;
      });

      // Sort dates chronologically
      const sortedData = Object.entries(dateMap)
      .map(([date, totalStock]) => ({
      date,
      totalStock
      }))
      .sort((a, b) => new Date(a.date) - new Date(b.date));

      // Update the chart
      overallChart.data.labels = sortedData.map(item => {
      const d = new Date(item.date);
      return d.toLocaleDateString('en-US', { month: 'short', day: 'numeric' });
      });
      overallChart.data.datasets[0].data = sortedData.map(item => item.totalStock);
      overallChart.update();
      }

      },
      error: function() {
      $("#loadSpinner").hide();
      apiData = [];
      BUYER_DRILL = buildDrillData([]);
      buyerDrillPath = ['root'];
      setBuyerCrumb();
      updateBuyerDrill('root');
      }
      });
      }

      // Initialize overall trend chart
      const overallCtx = document.getElementById('overallTrend').getContext('2d');
      const grad = overallCtx.createLinearGradient(0, 0, 0, 240);
      grad.addColorStop(0, 'rgba(15, 61, 126, 0.12)');
      grad.addColorStop(1, 'rgba(15, 61, 126, 0.02)');

      overallChart = new Chart(overallCtx, {
      type: 'line',
      data: {
      labels: [],
      datasets: [{
      label: 'Stock Quantity',
      data: [],
      borderColor: 'rgb(15, 61, 126)',
      backgroundColor: grad,
      tension: 0.3,
      fill: true,
      pointBackgroundColor: 'rgb(15, 61, 126)',
      pointBorderColor: '#fff',
      pointHoverBackgroundColor: '#fff',
      pointHoverBorderColor: 'rgb(15, 61, 126)',
      borderWidth: 2
      }]
      },
      options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
      legend: {
      display: false,
      },
      tooltip: {
      mode: 'index',
      intersect: false,
      }
      },
      scales: {
      x: {
      grid: { display: false },
      title: { display: true, text: 'Date' }
      },
      y: {
      beginAtZero: true,
      title: { display: true, text: 'Stock Quantity (pcs)' }
      }
      }
      }
      });

      // Buyer bar chart
      // Plugin to enforce a minimum visible bar length (pixels) for both vertical and horizontal bars
      const MIN_BAR_PX = 10;
      const minBarPlugin = {
      id: 'minBarPlugin',
      afterDatasetsDraw(chart, args, pluginOptions) {
      const { ctx } = chart;
      const isHorizontal = chart.options.indexAxis === 'y';
      chart.data.datasets.forEach((ds, dsIndex) => {
      const meta = chart.getDatasetMeta(dsIndex);
      if (!meta || meta.type !== 'bar') return;
      meta.data.forEach((bar) => {
      if (!bar) return;
      const props = bar.getProps(['x','y','base','width','height','options'], true);
      if (isHorizontal) {
      const actualW = Math.abs(props.base - props.x);
      if (actualW > 0 && actualW < MIN_BAR_PX) {
                const drawX = props.x < props.base ? props.base - MIN_BAR_PX : props.base;
                ctx.save();
                ctx.fillStyle = props.options.backgroundColor || '#08325b';
                ctx.fillRect(drawX, props.y - props.height / 2, MIN_BAR_PX, props.height);
                ctx.restore();
              }
            } else {
              const actualH = Math.abs(props.base - props.y);
              if (actualH > 0 && actualH < MIN_BAR_PX) {
                const isPositive = props.y < props.base;
                const drawY = isPositive ? props.base - MIN_BAR_PX : props.base;
                ctx.save();
                ctx.fillStyle = props.options.backgroundColor || '#08325b';
                ctx.fillRect(props.x - props.width / 2, drawY, props.width, MIN_BAR_PX);
                ctx.restore();
              }
            }
          });
        });
      }
    };
    const buyerCtx = document.getElementById('buyerBars').getContext('2d');
    const buyerChart = new Chart(buyerCtx, {
      type: 'bar',
      data: {
        labels: [],
        datasets: [{
          data: [],
          backgroundColor: '#08325b',
          borderRadius: 4,
          barThickness: 10,          // ✅ 50% thinner
          minBarLength: 10
        }]
      },
      plugins: [minBarPlugin],
      options: {
        indexAxis: 'y',
        responsive: true,
        maintainAspectRatio: false, // ✅ Allows height expansion
        elements: { bar: { minBarLength: 10, barThickness: 8 } }, // update here also
        plugins: { legend: { display: false }},
        scales: {
          x: {
            display: true,
            grid: { color: '#e5e7eb' },
            border: { color: '#e5e7eb' },
            title: { display: true, text: 'Stock (pcs)', color: '#334155', font: { weight: 600 } },
            ticks: {
              color: '#64748b',
              callback: function(value) {
                return value.toLocaleString();
              }
            }
          },
          y: {
            ticks: { color: '#374151', font: { weight: 600 }},
            title: { display: true, text: 'Buyer', color: '#334155', font: { weight: 600 }},
            categoryPercentage: 0.6,
            barPercentage: 0.7
          }
        }
      }
    });

    // Update buyer drill
    function updateBuyerDrill(key) {
      const node = BUYER_DRILL[key];
      if (!node) {
        buyerChart.data.labels = [];
        buyerChart.data.datasets[0].data = [];
        // Update axis titles based on drill level
    const level = buyerDrillPath.length; // 1: root, 2: buyer, 3: ocn, 4: item
    let yAxisTitle = 'Buyer';
    if (level === 2) yAxisTitle = 'OCN';
    else if (level === 3) yAxisTitle = 'Item';
    else if (level >= 4) yAxisTitle = 'Color';
    buyerChart.options.scales.x.title.text = 'Stock (pcs)';
    buyerChart.options.scales.y.title.text = yAxisTitle;
    buyerChart.update();
        tableData = [];
        if (stockTable) {
          stockTable.clear().rows.add([]).draw();
        }
        $('#sm-avail').text('0%');
        $('#kit-avail').text('0%');
        $('#stock-qty').text('0');
        $('#coverage-days').text('0 days');
        $('#input-today').text('0');
        $('#sm-trend').text('—').removeClass('text-green-600 text-red-600');
        $('#kit-trend').text('—').removeClass('text-green-600 text-red-600');
        $('#stock-trend').text('—').removeClass('text-green-600 text-red-600');
        $('#coverage-trend').text('—').removeClass('text-green-600 text-red-600');
        $('#input-trend').text('—').removeClass('text-green-600 text-red-600');
        overallChart.data.datasets[0].data = [0, 0, 0, 0, 0, 0, 0];
        overallChart.update();
        return;
      }

      // Sort bars by value descending so higher quantities appear on top
      const pairs = (node.labels || []).map((label, idx) => ({ label: label, value: (node.data || [])[idx] || 0 }));
      pairs.sort((a, b) => b.value - a.value);
      const sortedLabels = pairs.map(p => p.label);
      const sortedData = pairs.map(p => p.value);
      buyerChart.data.labels = sortedLabels;
      buyerChart.data.datasets[0].data = sortedData;

      // Highlight selected bar for this key (used at color/item terminal drill)
      const highlightLabel = (selectedFilter && selectedFilter.key === key) ? selectedFilter.label : null;
      const navy = '#08325b';
      const pale = '#cbd5e1';
      buyerChart.data.datasets[0].backgroundColor = sortedLabels.map(l => {
      if (!highlightLabel) return navy; // no selection => all navy
      return (l === highlightLabel) ? pale : navy; // selected pale, others navy
      });
      // Update axis titles based on current drill depth
      (function(){
      const level = buyerDrillPath.length; // 1: root, 2: buyer, 3: ocn, 4+: item/colors
      let yAxisTitle = 'Buyer';
      if (level === 2) yAxisTitle = 'OCN';
      else if (level === 3) yAxisTitle = 'Item';
      else if (level >= 4) yAxisTitle = 'Color';
      buyerChart.options.scales.x.title.text = 'Stock (pcs)';
      buyerChart.options.scales.y.title.text = yAxisTitle;
      })();
      buyerChart.update();

      // Recalculate KPIs if a selection is active at this level
      let tableScope = node.tableData || [];
      if (highlightLabel) {
      if (key.includes('||')) {
      tableScope = tableScope.filter(r => (r.colorOnly || 'Unknown') === highlightLabel);
      } else if (key.includes('OCN')) {
      tableScope = tableScope.filter(r => (r.itemOnly || 'Unknown') === highlightLabel);
      } else if (ocnMap[highlightLabel]) {
      const full = ocnMap[highlightLabel];
      tableScope = tableScope.filter(r => (r.fullOcn || '') === full);
      }
      }

      // KPI cards should always reflect base (full-dataset) values, regardless of drill or KPI selection
      if (baseKpiValues) {
      const smCard = baseKpiValues.sm;
      const kitCard = baseKpiValues.kit;
      const stockCard = baseKpiValues.stock;
      const coverageCard = baseKpiValues.coverage;
      const inputCard = baseKpiValues.input;

      $('#sm-avail').text(`${smCard}%`);
      $('#kit-avail').text(`${kitCard}%`);
      $('#stock-qty').text(stockCard.toLocaleString());
      $('#coverage-days').text(`${coverageCard} days`);
      $('#input-today').text(inputCard.toLocaleString());

      $('#sm-trend').text(smCard >= 90 ? '▲ 5.3% vs yesterday' : smCard > 0 ? '▼ 1.2% vs yesterday' : '—')
      .toggleClass('text-green-600', smCard >= 90).toggleClass('text-red-600', smCard < 90 && smCard > 0);
      $('#kit-trend').text(kitCard >= 85 ? '▲ 2.1% vs yesterday' : kitCard > 0 ? '▼ 1.3% vs yesterday' : '—')
      .toggleClass('text-green-600', kitCard >= 85).toggleClass('text-red-600', kitCard < 85 && kitCard > 0);
      $('#stock-trend').text(stockCard >= 4500 ? '▲ 3.5% vs yesterday' : stockCard > 0 ? '▼ 8.2% vs yesterday' : '—')
      .toggleClass('text-green-600', stockCard >= 4500).toggleClass('text-red-600', stockCard < 4500 && stockCard > 0);
      $('#coverage-trend').text(coverageCard >= 5 ? '▲ 1.5% vs yesterday' : coverageCard > 0 ? '▼ 0.5% vs yesterday' : '—')
      .toggleClass('text-green-600', coverageCard >= 5).toggleClass('text-red-600', coverageCard < 5 && coverageCard > 0);
      $('#input-trend').text(inputCard >= 500 ? '▲ 0.6% vs yesterday' : inputCard > 0 ? '▼ 0.4% vs yesterday' : '—')
      .toggleClass('text-green-600', inputCard >= 500).toggleClass('text-red-600', inputCard < 500 && inputCard > 0);
      }

      // Context KPIs (for sparks and trend) still reflect current drill scope
      const sum = (arr, f) => arr.reduce((s, x) => s + (f(x) || 0), 0);
      const count = tableScope.length || 0;
      const smCtx = count ? (sum(tableScope, x => parseFloat(x.inputPct)) / count).toFixed(1) : (parseFloat(node.kpiData.sm) || 0);
      const kitCtx = count ? (sum(tableScope, x => parseFloat(x.issuedPct)) / count).toFixed(1) : (parseFloat(node.kpiData.kit) || 0);
      const stockCtx = count ? sum(tableScope, x => parseInt(x.stock)) : (parseInt(node.kpiData.stock) || 0);
      const coverageCtx = count ? Math.round(sum(tableScope, x => parseInt(x.days)) / count) : (parseInt(node.kpiData.coverage) || 0);
      const inputCtx = count ? sum(tableScope, x => parseInt(x.issued)) : (parseInt(node.kpiData.issued) || 0);

      createSpark('k1', [smCtx-2, smCtx-1, smCtx, smCtx+1, smCtx], smCtx >= 90 ? '#10b981' : '#ef4444');
      createSpark('k2', [kitCtx-2, kitCtx-1, kitCtx, kitCtx+1, kitCtx], kitCtx >= 85 ? '#10b981' : '#ef4444');
      createSpark('k3', [stockCtx-100, stockCtx-50, stockCtx, stockCtx+50, stockCtx], stockCtx >= 4500 ? '#10b981' : '#ef4444');
      createSpark('k4', [coverageCtx-1, coverageCtx-0.5, coverageCtx, coverageCtx+0.5, coverageCtx], coverageCtx >= 5 ? '#10b981' : '#ef4444');
      createSpark('k5', [inputCtx-10, inputCtx-5, inputCtx, inputCtx+5, inputCtx], inputCtx >= 700 ? '#10b981' : '#ef4444');

      const trendBase = parseFloat(smCtx) || 0;
      const derivedTrend = [trendBase-5, trendBase-2, trendBase, trendBase+2, trendBase-1, trendBase+1, trendBase];
      overallChart.data.datasets[0].data = (count ? derivedTrend : (node.overallTrend || [0, 0, 0, 0, 0, 0, 0]));
      overallChart.update();

      tableData = tableScope;
      if (stockTable) {
      stockTable.clear().rows.add(tableData).draw();
      }
      }

      function drillToBuyer(name) {
      if (buyerDrillPath.length < 4 && BUYER_DRILL[name]) {
      buyerDrillPath.push(name);
      setBuyerCrumb();
      updateBuyerDrill(name);
      }
      }

      // Set breadcrumb
      function setBuyerCrumb() {
      const names = buyerDrillPath.map(k => {
      if (k === 'root') return 'ALL Buyer';
      if (ocnMap[k]) return k.slice(-4);
      if (k.includes('||')) return k.split('||')[1];
      return k;
      });
      // If a color is selected at the terminal level, append it to breadcrumb
      const currentKey = buyerDrillPath[buyerDrillPath.length - 1];
      if (selectedFilter && selectedFilter.key === currentKey && selectedFilter.label) {
      names.push(selectedFilter.label);
      }
      const html = names.map((n, idx) => `<span class="drill-link ${idx}"
        < names.length - 1 ? 'text-blue-600 cursor-pointer' : ''}" data-idx="${idx}">${n}</span>`).join(' <span class="text-slate-400">›</span> ');
      $('#buyerCrumb').html(html);
      }

      // Update dashboard based on KPI selection
      function updateDashboard(kpiKey) {
      currentKpi = kpiKey;
      let filteredData = apiData.map(unit => ({
      Unit: unit.Unit || 'Unknown',
      buyers: unit.buyers?.map(buyer => ({
      Buyer: buyer.Buyer || 'Unknown',
      data: buyer.data?.filter(item => {
      const inputPct = parseFloat(item.Sm_Rcvd_Perc) || 0;
      const issuedPct = parseFloat(item.Iss_Perc) || 0;
      const stock = parseInt(item.Stock) || 0;
      const input = parseInt(item.SM_Rcvd) || 0;
      const issued = parseInt(item.Iss_Qty) || 0;
      const days = input > 0 ? stock / input : 0;
      if (kpiKey === 'sm') return inputPct > 0;
      if (kpiKey === 'kit') return issuedPct > 0;
      if (kpiKey === 'stock') return stock > 0;
      if (kpiKey === 'coverage') return days > 0;
      if (kpiKey === 'input') return input > 0;
      return true;
      }) || []
      })).filter(buyer => buyer.data.length > 0) || []
      })).filter(unit => unit.buyers.length > 0);
      BUYER_DRILL = buildDrillData(filteredData);
      buyerDrillPath = ['root'];
      setBuyerCrumb();
      updateBuyerDrill('root');
      }

      // Function to get URL parameters
      function getUrlParameter(name) {
      name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
      const regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
      const results = regex.exec(location.search);
      return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
      }

      // Parse and apply dates from URL on page load
      function applyDatesFromUrl() {
      const fromDateParam = getUrlParameter('fromdate');
      const endDateParam = getUrlParameter('enddate');

      if (fromDateParam && endDateParam) {
      const initialRouteStart = moment(fromDateParam, 'YYYY-MM-DD');
      const initialRouteEnd = moment(endDateParam, 'YYYY-MM-DD');
      selectedfromdate = initialRouteStart.format('YYYY-MM-DD');
      selectedenddate = initialRouteEnd.format('YYYY-MM-DD');
      // Set initial breadcrumb link with initial dates
      const initialBreadcrumbUrl = `/production_gar_dashboard?fromdate=${initialRouteStart.format('YYYY-MM-DD')}&enddate=${initialRouteEnd.format('YYYY-MM-DD')}`;
      $('#productionBreadcrumb').attr('href', initialBreadcrumbUrl);
      }
      $(`#HistoricalButton`).on('click', function () {
      window.location.href = `/history_dashboard/smstock?fromdate=${selectedfromdate}&enddate=${selectedenddate}`;
      });
      }

      // Initialize
      $(document).ready(function(){
      applyDatesFromUrl();
      // Initialize DataTable
      stockTable = $('#stockTable').DataTable({
      data: [],
      language: {
      lengthMenu: 'Show _MENU_ rows',
      search: 'Search:'
      },
      columns: [
      {
      data: 'ocn',
      render: function(data, type, row) {
      return `<div class="font-medium" title="${row.desc}">${data}</div>`;
      },
      className: 'py-3 px-3 align-top'
      },
      { data: 'size', className: 'py-3 px-3 align-top' },
      { data: 'stock', className: 'py-3 px-3 align-top font-medium' },
      { data: 'days', className: 'py-3 px-3 align-top' },
      { data: 'input', className: 'py-3 px-3 align-top' },
      {
      data: 'inputPct',
      render: function(data) {
      const pct = Math.max(0, Math.min(parseFloat(data) || 0, 100));
      return `<div class="flex items-center gap-2">
        <div class="progress-track w-36 inline-block mr-1">
          <span class="progress-fill" style="width:${pct}%; background:#08325b; display:block;"></span>
        </div>
        <span class="text-xs text-slate-600 font-medium">${pct}%</span>
      </div>`;
      },
      className: 'py-3 px-3 align-top'
      },
      {
      data: null,
      render: function(data, type, row, meta) {
      return `<canvas class="trend-mini" id="inputTrend_${meta.row}"></canvas>`;
      },
      className: 'py-3 px-3 align-top',
      orderable: false
      },
      { data: 'issued', className: 'py-3 px-3 align-top font-medium' },
      {
      data: 'issuedPct',
      render: function(data) {
      const pct = Math.max(0, Math.min(parseFloat(data) || 0, 100));
      return `<div class="flex items-center gap-2">
        <div class="progress-track w-36 inline-block mr-1">
          <span class="progress-fill" style="width:${pct}%; background:#08325b; display:block;"></span>
        </div>
        <span class="text-xs text-slate-600 font-medium">${pct}%</span>
      </div>`;
      },
      className: 'py-3 px-3 align-top'
      },
      {
      data: null,
      render: function(data, type, row, meta) {
      const params = new URLSearchParams({
      order_no: row.fullOcn || '',
      itemid: row.itemId || '',
      colorid: row.colorId || '',
      sizeid: row.sizeId || '',
      buyer: row.buyer || '',
      item: row.itemOnly || '',
      color: row.colorOnly || ''
      }).toString();
      const fromForLink = urlFromDate || currentStartDate;
      const endForLink = urlEndDate || currentEndDate;
      const href = `/issued?${params}&fromdate=${fromForLink}&enddate=${endForLink}`;
      return `<a href="${href}" title="View issued trend">
        <canvas class="trend-mini" id="issuedTrend_${meta.row}"></canvas>
      </a>`;
      },
      className: 'py-3 px-3 align-top',
      orderable: false
      }
      ],
      rowCallback: function(row, data) {
      if (data.lowStock) {
      $(row).addClass('low-stock');
      }
      },
      drawCallback: function() {
      const api = this.api();
      api.rows({page: 'current'}).every(function(rowIdx) {
      const rowData = this.data();
      setTimeout(() => {
      createSpark(`inputTrend_${rowIdx}`, rowData.inputTrend, '#ef4444');
      createSpark(`issuedTrend_${rowIdx}`, rowData.issuedTrend, '#10b981');
      }, 50);
      });
      },
      pageLength: 10,
      lengthMenu: [10, 25, 50, 100],
      searching: true,
      ordering: true,
      info: true,
      paging: true
      });

      // Make stock table header sticky when page length > 10
      stockTable.on('length.dt', function(e, settings, len) {
      const container = document.getElementById('stockTableContainer');
      const thead = document.querySelector('#stockTable thead');
      if (!container || !thead) return;
      if (len > 10) {
      container.style.maxHeight = '520px';
      container.style.overflowY = 'auto';
      thead.style.position = 'sticky';
      thead.style.top = '0';
      thead.style.zIndex = '10';
      thead.style.background = '#ffffff';
      } else {
      container.style.maxHeight = '';
      container.style.overflowY = '';
      thead.style.position = '';
      thead.style.top = '';
      thead.style.zIndex = '';
      thead.style.background = '';
      }
      });

      $('#kpi1').on('click', () => updateDashboard('sm'));
      $('#kpi2').on('click', () => updateDashboard('kit'));
      $('#kpi3').on('click', () => updateDashboard('stock'));
      $('#kpi4').on('click', () => updateDashboard('coverage'));
      $('#kpi5').on('click', () => updateDashboard('input'));

      $('#buyerBars').on('click', function(evt) {
      const points = buyerChart.getElementsAtEventForMode(evt, 'nearest', { intersect: true }, false);
      if (points.length > 0 && typeof points[0].index === 'number' && buyerChart.data.labels[points[0].index]) {
      const labelClicked = buyerChart.data.labels[points[0].index];
      let name = labelClicked;
      const currentKey = buyerDrillPath[buyerDrillPath.length - 1];

      if (currentKey.includes('||')) {
      // Terminal (color-wise) level: toggle selection and recalc
      if (selectedFilter && selectedFilter.key === currentKey && selectedFilter.label === labelClicked) {
      selectedFilter = null;
      } else {
      selectedFilter = { key: currentKey, label: labelClicked };
      }
      updateBuyerDrill(currentKey);
      setBuyerCrumb();
      return;
      }

      if (ocnMap[name]) name = ocnMap[name];
      if (BUYER_DRILL[currentKey] && currentKey.includes('OCN')) {
      const compositeKey = `${currentKey}||${name}`;
      if (BUYER_DRILL[compositeKey]) name = compositeKey;
      }
      selectedFilter = null; // clear when drilling deeper
      drillToBuyer(name);
      }
      });

      $('#buyerCrumb').on('click', '.drill-link', function(){
      const idx = parseInt($(this).data('idx'));
      if (idx === buyerDrillPath.length - 1) return;
      buyerDrillPath = buyerDrillPath.slice(0, idx + 1);
      setBuyerCrumb();
      const key = buyerDrillPath[buyerDrillPath.length - 1];
      updateBuyerDrill(key);
      });

      setBuyerCrumb();

      $('#dateRangePicker').daterangepicker({
      opens: 'left',
      startDate: moment().subtract(6, 'days'),
      endDate: moment(),
      maxDate: moment(), // Restrict dates beyond today
      ranges: {
      'Today': [moment(), moment()],
      'Last Week': [moment().subtract(6, 'days'), moment()], // Changed from This Week
      'This Month': [moment().startOf('month'), moment().endOf('month')]
      },
      locale: {
      format: 'DD-MM-YY'
      }
      }, function(start, end, label) {
      const startFormatted = start.format('YYYY-MM-DD');
      const endFormatted = end.format('YYYY-MM-DD');
      const displayStartFormatted = start.format('DD-MM-YY');
      const displayEndFormatted = end.format('DD-MM-YY');
      selectedRangeLabel = label;
      const isSameDay = start.isSame(end, 'day');

      // update global date range
      currentStartDate = startFormatted;
      currentEndDate = endFormatted;

      const titleText = `
      Supermarket Stock Analysis for -
      <span style="color: #000; font-weight: bold; background-color: #FFFF00; padding: 2px 6px; border-radius: 10px;">
        GARMENTS
      </span>
      <span class="ml-4" style="color: #fff; font-weight: 500;">
        ${startFormatted} - ${endFormatted}
      </span>
      `;

      $('.dashboard_title').html(titleText); // Use .html() instead of .text()

      $('#dateRangePicker').val(`${displayStartFormatted} - ${displayEndFormatted}`);
      buyerDrillPath = ['root'];
      currentKpi = null;
      // Update breadcrumb link with selected dates
      const breadcrumbUrl = `/production_gar_dashboard?fromdate=${startFormatted}&enddate=${endFormatted}`;
      $('#productionBreadcrumb').attr('href', breadcrumbUrl);
      fetchData(selectedRangeLabel, startFormatted, endFormatted);
      });


      const initialStart = moment();
      const initialEnd = moment();
      const initialStartFormatted = initialStart.format('YYYY-MM-DD');
      const initialEndFormatted = initialEnd.format('YYYY-MM-DD');
      const initialDisplayStartFormatted = initialStart.format('DD-MM-YY');
      const initialDisplayEndFormatted = initialEnd.format('DD-MM-YY');
      const isSameDay = initialStart.isSame(initialEnd, 'day');

      // set initial global date range
      currentStartDate = initialStartFormatted;
      currentEndDate = initialEndFormatted;

      $('.dashboard_title').html(`
      Supermarket Stock Analysis for
      <span style="color: #000; font-weight: bold; background-color: #FFFF00; padding: 2px 6px; border-radius: 10px;">
        GARMENTS
      </span>
      <span class="ml-4" style="color: #fff; font-weight: 500;">
        ${initialDisplayStartFormatted} - ${initialDisplayEndFormatted}
      </span>
      `);

      $('#dateRangePicker').val(initialStartFormatted);
      // Set initial breadcrumb link; prefer URL params if present
      const breadFrom = urlFromDate || initialStartFormatted;
      const breadEnd = urlEndDate || initialEndFormatted;
      $('#productionBreadcrumb').attr('href', `/production_gar_dashboard?fromdate=${breadFrom}&enddate=${breadEnd}`);
      fetchData('Today', initialStartFormatted, initialEndFormatted);

      $(`#HistoricalButton`).on('click', function () {
      window.location.href = '/history_dashboard/smstock';
      });

      $('#HistoricalButton').hide();

      });
    </script>
  </body>
</html>