<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Email Update</title>
    <link rel="icon" href="gplogofinal.png" type="png">

    <style>
        .a:hover {
            color: #fff;
        }
    </style>

    <script>
        window.onload = function() {
            var inputElement = document.getElementById('new_email');
            inputElement.focus();
        };
    </script>

    <!-- Custom fonts for this template-->
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
    <!-- Custom styles for this template-->
    <link rel="stylesheet" href="{{ asset('frontend/css/sb-admin-2.min.css')}}">


</head>

<body class="body_1">
    @php
    $head_det = \App\Models\orgs::where('user_id_number', Session::get('user_data'))->get();
    $empl_tno = Session::get('user_data');
    @endphp

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-6  col-lg-12 col-md-9">

                <div id="card" class=" card o-hidden border-0 shadow-lg my-5">
                    <div class="card-body p-0">
                        <div class="row">
                            <?php $emp_idd = Session('empl_id');
                            $Profile_rights = Session('Profile_rights'); ?>
                            <div class="col-lg-12">
                                <div class="p-5">
                                    <div class="text-center">
                                        <h1 class="h4 text-white mb-5">Change Your Email?</h1>
                                    </div>

                                    <!-- VERIFY OTP -->
                                    <form method="POST" action="{{ route('verify_otp') }}">
                                        @csrf
                                        <div class="form-group">
                                            <input type="hidden" name="empl_tno" value="{{ $empl_tno }}">
                                            <input type="text" name="otp" id="new_email" class="form-control mb-5 text-white form-control user input_verify" placeholder="Enter Otp" pattern="[0-9]{4}" title="Please enter a 4-digit value" required style="background:none; border:none; border-bottom:1px solid red; outline:none; " onfocus="this.style.background='none';" onblur="this.style.background='none';">
                                        </div>
                                        <div class="d-flex justify-content-around">
                                            <button type="submit" id="verify_btn" class="btn  d-flex justify-content-center btn-primary btn-user w-50 mb-3 ">Verify OTP</button>
                                        </div>
                                    </form>
                                    @if(session('invalid'))

                                    <!-- RESEND OTP -->
                                    <form action="{{ route('resend_otp') }}" method="post">
                                        @csrf
                                        <div class="">
                                            <button type="submit" class="btn  btn-primary btn-user w-100 mb-2">Resend OTP</button>
                                        </div>
                                    </form>
                                </div>

                                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                    <strong>Invalid</strong> Otp.
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                        <div id="error-message" style="color: red;"></div>
                                    </button>
                                    @endif
                                </div>
                                <div class="text-center">
                                    <a href="profile" class="a">Don't want to change. Go profile</a>
                                </div>
                                <div class="text-center">
                                    <a class="small a" href="dashboard">Go Home.</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>



    <script>
        // Hide the otp-send form after otp is sent
        document.getElementById('otp-send').style.display = 'none';
    </script>

    <script>
        // Hide the Verify OTP button when the condition is met
        document.querySelector('.verify').style.display = 'none';
    </script>

    <script>
        const emailInput = document.getElementById('new_email');
        const errorMessage = document.getElementById('error-message');
        emailInput.addEventListener('input', function() {
            if (!emailInput.validity.valid) {
                errorMessage.textContent = 'Please enter a valid 4-digit value.';
            } else {
                errorMessage.textContent = '';
            }
        });
    </script>


</body>

</html>