<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">


    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Profile</title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="gplogofinal.png" type="png">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <!-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css"> -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.1.6/dist/sweetalert2.min.css">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">


    <!-- for icon -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css" rel="stylesheet">


    <style type="text/css">
        .navbar {
            background: #13265C;
        }

        .nav-link:hover {
            color: #9ffb00 !important;
        }

        .dropdown-menu.left {
            left: auto;
            right: 0;
        }

        .active {

            border-radius: 10px;
            color: #fff;
            font-weight: 500;
            border: 2px solid white;

        }

        body {
            /* padding-top: 50px;  */
            color: #1a202c;
            text-align: left;
            background-color: #e2e8f0;
        }

        .main-body {
            padding: 15px;
        }

        .card {
            box-shadow: 0 1px 3px 0 rgba(0, 0, 0, .1), 0 1px 2px 0 rgba(0, 0, 0, .06);
        }

        .card {
            position: relative;
            display: flex;
            flex-direction: column;
            min-width: 0;
            word-wrap: break-word;
            background-color: #fff;
            background-clip: border-box;
            border: 0 solid rgba(0, 0, 0, .125);
            border-radius: .25rem;
        }

        .card-body {
            flex: 1 1 auto;
            min-height: 1px;
            padding: 1rem;
        }

        .gutters-sm {
            margin-right: -8px;
            margin-left: -8px;
        }

        .gutters-sm>.col,
        .gutters-sm>[class*=col-] {
            padding-right: 8px;
            padding-left: 8px;
        }

        .mb-3,
        .my-3 {
            margin-bottom: 1rem !important;
        }

        .bg-gray-300 {
            background-color: #e2e8f0;
        }

        .h-100 {
            height: 100% !important;
        }

        .shadow-none {
            box-shadow: none !important;
        }

        .rounded {
            border-radius: 50%;
            border: 2px solid #ccc;
            cursor: pointer;

        }

        .profile-img {
            text-align: center;
        }

        .profile-img .file {
            position: relative;
            overflow: hidden;
            margin-top: -25%;
            width: 51%;
            border: none;
            border-radius: 0;
            font-size: 15px;
            background: #212529b8;
        }

        .profile-img .file input {
            position: absolute;
            opacity: 0;
            right: 0;
            top: 0;
        }
    </style>
    <style>
        /* Styling for the alert container */
        .alert-container {
            display: none;
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            padding: 20px;
            background-color: #f1f1f1;
            border-radius: 5px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            z-index: 9999;
        }

        /* Styling for the alert text */
        .alert-text {
            font-size: 16px;
            color: #333;
            margin: 0;
        }

        /* Styling for the close button */
        .close-btn {
            position: absolute;
            top: 5px;
            right: 5px;
            font-size: 18px;
            cursor: pointer;
        }

        #approve_btn {
            display: none;
        }

        /* Styles for the image popup */
        .image-popup {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.7);
            z-index: 9999;
        }

        .image-popup img {
            max-width: 80%;
            max-height: 80%;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .close-btn {
            color: #fff;
            font-size: 30px;
            position: absolute;
            top: 20px;
            right: 30px;
            cursor: pointer;
        }
    </style>
    <style>
        .heading {
            border-bottom: 1px solid #000;
            /* Replace #000 with your desired underline color */
            display: inline-block;
            padding-bottom: 3px;
            /* Adjust the thickness of the underline by changing this value */
        }
    </style>
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->

</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->
    @extends('LifeAtGainup.Navbar.Other_Nav')
    @section('content')

    <div class="container-fulid" id="wrapper">
        <div class="main-body">
            <div class="row gutters-sm">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex flex-column align-items-center text-center">
                                <div class="profile-img">
                                    <?php $emp_idd = Session('empl_id');
                                    $Profile_rights = Session('Profile_rights'); ?>

                                    @if(request()->has('emplno'))
                                    <img src="{{ asset('frontend/emplphotos/'.request('emplno').'.jpeg')}}" alt="Admin" class="rounded" width="130" height="130" onclick="showImageModal()" data-toggle="modal" data-target="#imageModal">
                                    @else
                                    <img src="{{ asset('frontend/emplphotos/'.$emp_idd.'.jpeg')}}" alt="Admin" class="rounded" width="130" height="130" onclick="showImageModal()" data-toggle="modal" data-target="#imageModal">
                                    @endif
                                </div>
                                <p class="btn-sm text-danger">Note : Only JPEG/JPG format & below 40KB.</p>
                                @if ($message = Session::get('success'))
                                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                    {{$message}}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">

                                        <span aria-hidden="true">&times;</span>
                                        <div id="error-message" style="color: red;"></div>
                                    </button>
                                </div>
                                @endif
                                <div class="  mb-1">
                                    <!-- The Modal -->
                                    <div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="imageModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="imageModalLabel">Profile</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <!-- Display the image in the modal -->
                                                    <img src="{{ asset('frontend/emplphotos/'.$emp_idd.'.jpeg')}}" alt="Admin" class="img-fluid">
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Button to display the selected image in a popup -->

                                    <!-- Image popup container -->
                                    <div id="imagePopup" class="image-popup">
                                        <span class="close-btn" onclick="closeImagePopup()">&times;</span>
                                        <img id="selectedImage" src="#" alt="Selected Image">
                                    </div>

                                    <form action="{{ route('Profile_Img_Update') }}" method="post" enctype="multipart/form-data" onsubmit="return validateForm()">
                                        @csrf
                                        <input type="hidden" name="employee_id" value="{{ $emp_idd }}">
                                        <input type="hidden" name="employee_name" value="{{$employeeDetails['name']}}">
                                        <input type="hidden" name="employee_dept" value="{{$employeeDetails['department']}}">
                                        <input type="hidden" name="employee_tno" value="{{$employeeDetails['tockenNo']}}">
                                        <input type="file" name="profile_image" accept=".jpeg ,.jpg" id="profile-image" class="btn-sm btn-outline-primary w-50">

                                        <button class="btn btn-sm btn-outline-primary" type="submit" id="updateButton">Update</button>
                                        <span class="btn btn-sm btn-outline-primary ml-1" data-toggle="tooltip" data-placement="bottom" title="Profile View" onclick="showImagePopup()">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-emoji-heart-eyes-fill pb-1" viewBox="0 0 16 16">
                                                <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0zM4.756 4.566c.763-1.424 4.02-.12.952 3.434-4.496-1.596-2.35-4.298-.952-3.434zm6.559 5.448a.5.5 0 0 1 .548.736A4.498 4.498 0 0 1 7.965 13a4.498 4.498 0 0 1-3.898-2.25.5.5 0 0 1 .548-.736h.005l.017.005.067.015.252.055c.215.046.515.108.857.169.693.124 1.522.242 2.152.242.63 0 1.46-.118 2.152-.242a26.58 26.58 0 0 0 1.109-.224l.067-.015.017-.004.005-.002zm-.07-5.448c1.397-.864 3.543 1.838-.953 3.434-3.067-3.554.19-4.858.952-3.434z" />
                                            </svg>
                                        </span>
                                        <br>
                                        <span id="error-msg" style="color: red;"></span>
                                    </form>
                                    <!-- Alert box -->
                                    <div class="alert alert-warning alert-dismissible fade show" role="alert" style="display: none;">
                                        <strong>Your profile</strong> is waiting for Approval.
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>

                                </div>

                                <div>
                                    <h5>{{$employeeDetails['name']}}</h5>
                                    <p class="text-muted font-size-sm">{{$employeeDetails['tockenNo']}}</p>
                                    <p class="text-secondary">{{$employeeDetails['designation']}}</p>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="card mt-3">
                        <ul class="list-group list-group-flush">
                            <h6 class="d-flex align-items-center mb-2 pb-3 mt-3 ml-3 mr-2 heading "><span class="material-icons text-info mr-2">PERSONAL</span>DETAILS</h6>
                            <li class="list-group-item  d-flex justify-content-between align-items-center flex-wrap">
                                <h6 class="mb-0">MARRIED</h6>
                                <span class="text-secondary">{{$employeeDetails['marriedStatus']}}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                <h6 class="mb-0">BLOOD</h6>
                                <span class="text-secondary">{{$employeeDetails['bloodGroup']}}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                <h6 class="mb-0">CELL NO</h6>
                                <span class="text-secondary">{{$employeeDetails['cellNumber']}}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                <h6 class="mb-0 pb-2">PHONE NO</h6>
                                <span class="text-secondary">{{$employeeDetails['phoneNumber']}}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                <h6 class="mb-0 pb-3">E-MAIL</h6>
                                <div class="">
                                    <div class="input-group">
                                        <input type="text" class="mb-2 text-secondary" id="inlineFormInputGroup" value="{{$employeeDetails['emailid']}}" readonly style="outline:none; border:none;  ">
                                        <div class="input-group-append">
                                            <a type="button" class="btn btn-primary ml-3" href="update_email">+</a>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="card mb-3">
                        <div class="card-body ">
                            <div class="row d-flex">
                                <div class="col-md-3">
                                    <h6 class="mb-0">COMPANY NAME</h6>
                                </div>
                                <div class="col-md-5 text-secondary">
                                    {{$employeeDetails['companyName']}}
                                </div>
                                <div class="col-md-2 mt-1 text-secondary" class="">
                                </div>
                                <div class="col-md-2 text-secondary">
                                    @php
                                    $numRequests = Session::get('num_requests');
                                    @endphp
                                    <a href="/profileApp" id="approve_btn" type="button" class="btn btn-primary">
                                        Approve
                                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                            {{ $numRequests }}
                                        </span>
                                    </a>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0">FATHER/HUSBAND</h6>
                                </div>
                                <div class="col-sm-9 text-secondary">
                                    {{$employeeDetails['fatherName']}}
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0">QUALIFICATION</h6>
                                </div>
                                <div class="col-sm-9 text-secondary">
                                    {{$employeeDetails['qualification']}}
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0">SEX</h6>
                                </div>
                                <div class="col-sm-9 text-secondary">
                                    {{$employeeDetails['sex']}}
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0">DATE OF BIRTH</h6>
                                </div>
                                <div class="col-sm-9 text-secondary">
                                    {{$employeeDetails['dob']}}
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-4">DATE OF JOIN</h6>
                                </div>
                                <div class="col-sm-3 text-secondary">
                                    {{$employeeDetails['doj']}}
                                </div>
                                <div class="col-sm-3">
                                    <h6 class="mb-4">REPORTED TO</h6>
                                </div>
                                <div class="col-sm-3 text-secondary">
                                    {{$employeeDetails['rep_empl']}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row gutters-sm">
                        <div class="col-sm-6 mb-3">
                            <div class="card h-100">
                                <div class="card-body">
                                    <h6 class="d-flex align-items-center mb-2 pb-3  ml-2 heading "><span class="material-icons text-info mr-2">BANK</span>DETAILS</h6>
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                            <h6 class="mb-0">BANK NAME</h6>
                                            <span class="text-secondary">{{$employeeDetails['bankName']}}</span>
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                            <h6 class="mb-0">ACCOUNT NUMBER</h6>
                                            <span class="text-secondary">{{$employeeDetails['accountNo']}}</span>
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                            <h6 class="mb-0">IFSC</h6>
                                            <span class="text-secondary">{{$employeeDetails['bank_ifsc']}}</span>
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                            <h6 class="mb-0">PF NUMBER</h6>
                                            <span class="text-secondary">{{$employeeDetails['pfNumber']}}</span>
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                            <h6 class="mb-0">DATE OF PF</h6>
                                            <span class="text-secondary">{{$employeeDetails['dateofpf']}}</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 mb-3">
                            <div class="card h-100">
                                <div class="card-body">
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                            <h6 class="mb-0">DEPARTMENT NAME</h6>
                                            <span class="text-secondary">{{$employeeDetails['department']}}</span>
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                            <h6 class="mb-0">WEEK OFF</h6>
                                            <span class="text-secondary">{{$employeeDetails['weekoff']}}</span>
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                            <h6 class="mb-0">STATUS</h6>
                                            <span class="text-secondary">{{$employeeDetails['status']}}</span>
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                            <h6 class="mb-0">ADDRESS</h6>
                                            <span class="text-secondary mt-2">{{$employeeDetails['address']}}
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- profile rights -->
    <script>
        let Profile_rights = @json($Profile_rights);
        if (Profile_rights === 'Y') {
            const approveBtn = document.getElementById("approve_btn");
            approveBtn.style.display = "block";
        }
    </script>

    <!-- JavaScript to handle button click -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // When the update button is clicked
            $("form").submit(function(event) {
                event.preventDefault(); // Prevent form submission

                // Check if a file is selected
                if ($("#profile-image").val() !== "") {
                    // Show the alert box
                    $(".alert").fadeIn().alert();

                    // Hide the alert after 5 seconds (5000 milliseconds)
                    setTimeout(function() {
                        $(".alert").fadeOut();

                        // Now, submit the form after the delay (e.g., 3 seconds)
                        setTimeout(function() {
                            $("form").off("submit").submit(); // Manually trigger form submission
                        }, 300); // Delay of 0.3 seconds before form submission
                    }, 1000); // Alert display duration of 1 seconds
                }
            });
        });
    </script>

    <script>
        function validateForm() {
            var profileImage = document.getElementById('profile-image').files[0];

            // Check if a file is selected
            if (!profileImage) {
                document.getElementById('error-msg').innerText = 'Please select a JPEG image.';
                return false;
            }

            // Check the file extension
            var allowedExtensions = /(\.jpeg|\.jpg)$/i;

            if (!allowedExtensions.exec(profileImage.name)) {
                document.getElementById('error-msg').innerText = 'Only JPEG/JPG images are allowed.';
                return false;
            }


            // Check the file size
            var maxSizeKB = 40;
            var maxSizeBytes = maxSizeKB * 1024;
            if (profileImage.size > maxSizeBytes) {
                document.getElementById('error-msg').innerText = 'Image size should be less than ' + maxSizeKB + 'KB.';
                return false;
            }

            // If everything is valid, clear the error message
            document.getElementById('error-msg').innerText = '';

            return true;
        }
    </script>

    <script>
        function showImagePopup() {
            var fileInput = document.getElementById('profile-image');
            var imagePopup = document.getElementById('imagePopup');
            var selectedImage = document.getElementById('selectedImage');

            if (fileInput.files && fileInput.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    selectedImage.src = e.target.result;
                };

                reader.readAsDataURL(fileInput.files[0]);
                imagePopup.style.display = 'block';
            }
        }

        function closeImagePopup() {
            var imagePopup = document.getElementById('imagePopup');
            imagePopup.style.display = 'none';
        }
    </script>


    @endsection
</body>

</html>