<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">

    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Profile Approve</title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="gplogofinal.png" type="png">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.1.6/dist/sweetalert2.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Times New Roman', Times, serif;
        }

        body {
            background: rgb(103, 103, 105);
            background: linear-gradient(90deg, rgba(103, 103, 105, 0.8661589635854342) 48%, rgba(112, 112, 113, 1) 100%, rgba(120, 120, 120, 0.8577556022408963) 100%);
        }

        .card {
            position: relative;
            height: 100px;
            width: 230px;
            background: #fff;
            border-radius: 20px;
            box-shadow: 0 35px 80px rgba(0, 0, 0, 0.15);
            transition: 0.5s;
        }

        .card:hover {
            height: 200px;
        }

        .imgBx {
            position: absolute;
            left: 50%;
            top: -50px;
            transform: translate(-50%);
            width: 90px;
            height: 90px;
            background: #fff;
            margin-bottom: 200px !important;
            border-radius: 20px;
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.35);
            overflow: hidden;
            transition: 0.5s;
        }

        .imgBx img {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .card:hover .imgBx {
            width: 80px;
            height: 80px;
        }

        .card .content {
            position: absolute;
            width: 100%;
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: flex-end;
            overflow: hidden;
        }

        .card .content .details {
            padding: 40px;
            text-align: center;
            width: 100%;
            transition: 0.5s;
            transform: translateY(150px);
        }

        .card:hover .content .details {
            transform: translateY(0px);
        }

        .card .content .details h5 {
            font-size: 1em;
            font-weight: 600;
            color: #555;
            line-height: 1.1em;
            margin-top: -100%;
        }

        .card .content .details h5 span {
            font-size: 0.84em;
            font-weight: 500;
            opacity: 0.5;
        }

        .card .content .details .data {
            display: flex;
            justify-content: space-between;
            margin: 20px 0px;
        }

        .card .content .details .data h3 {
            font-size: 1em;
            color: #555;
            line-height: 1.2em;
            font-weight: 600;
        }

        .card .content .details .data h3 span {
            font-size: 1em;
            font-weight: 500;
            opacity: 0.5;
        }

        .card .content .details .actionBtn {
            display: flex;
            justify-content: space-around;
        }

        .card .content .details .actionBtn button {
            padding: 5px 22px;
            border-radius: 5px;
            border: none;
            outline: none;
            font-size: 0.8em;
            font-weight: 400;
            background: #ff5f95;
            color: #fff;
            cursor: pointer;
        }

        .card .content .details .actionBtn button:nth-child(2) {
            border: 1px solid #999;
            color: #999;
            background: #fff;
            margin-left: 10px;

        }

        .content1 {
            display: flex;
            margin-top: 10%;
            justify-content: center;
            align-items: center;
            font-size: 2.5em;
            color: #0e3742;
            text-transform: uppercase;
            letter-spacing: 15px;
            -webkit-box-refelect: below 1px linear-gradient(transparent, #0004);
            line-height: 0.70em;
            outline: none;
            animation: animate 5s linear infinite;
        }

        @keyframes animate {

            0%,
            18%,
            20%,
            50.1%,
            60%,
            65.1%,
            80%,
            90.1%,
            92% {
                color: #0e3742;
                text-shadow: none;
            }

            18.1%,
            20.1%,
            30%,
            50%,
            60.1%,
            65%,
            80.1%,
            90%,
            92.1%,
            100% {
                color: #fff;
                text-shadow: 0 0 10px #03bcf4,
                    0 0 20px #03bcf4,
                    0 0 40px #03bcf4,
                    0 0 80px #03bcf4,
                    0 0 160px #03bcf4;
            }
        }
    </style>
</head>

<body>


    <nav class="navbar navbar-expand-lg navbar-light bg-dark">
        <a class="navbar-brand text-white" href="#">Profile Approve Page</a>
        <button class="navbar-toggler order-2" type="button" data-toggle="collapse" data-target="#navbarNavAltMarkup" aria-controls="navbarNavAltMarkup" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse order-3 order-lg-1 mr-5" id="navbarNavAltMarkup">
            <div class="navbar-nav ml-auto">
                <a class="nav-item nav-link active text-white mr-5" href="dashboard">HOME <span class="sr-only">(current)</span></a>
                <a class="nav-item nav-link text-white" href="profile">PROFILE</a>

            </div>
        </div>
    </nav>

    <div class="container-lg">
        @if (empty($tempImageDataArray))
        <div class="row">
            <div class="col-md-12">
                @if ($message = Session::get('success'))
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    {{$message}}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">

                        <span aria-hidden="true">&times;</span>
                        <div id="error-message" style="color: red;"></div>
                    </button>
                </div>
                @endif
                <h1 class="content1" contenteditable="true">No more profiles to</h1>
                <span class="content1" contenteditable="true">approve.</span>
            </div>
        </div>
        @else
        <div class="container">
            <div class="row">
                @foreach ($tempImageDataArray as $tempImageData)
                <div class="col-md-3 mt-5">
                    <div class="card mt-2">
                        <div class="imgBx">
                            <!-- Display the temporary profile image here -->
                            <img src="{{ asset('tempProfile/'. $tempImageData['tempImagePath']) }}" alt="Temporary Profile Image" id="img">
                        </div>
                        <div class="content">
                            <div class="details">
                                <br>
                                <h5>{{ $tempImageData['employee_name'] }} <br> <br>
                                    <span>{{ $tempImageData['employee_tno'] }}</span>
                                    <br> <span>{{ $tempImageData['employee_dept'] }}</span>
                                </h5>

                                <form action="{{ route('Approve_Profile') }}" method="post">
                                    @csrf
                                    <input type="hidden" name="employee_id" value="{{ $tempImageData['employee_id'] }}">
                                    <input type="hidden" name="image_path" value="{{ $tempImageData['tempImagePath'] }}">
                                    <div class="actionBtn">
                                        <button type="submit" class="" name="action" value="approve">Approve</button>
                                        <button type="submit" class="" name="action" value="reject">Reject</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif
    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

</body>

</html>